/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.goio.jna;

import java.awt.Button;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.JApplet;
import org.concord.sensor.goio.jna.GoIOLibrary;
import org.concord.sensor.goio.jna.GoIOSensor;

public class LowLevelTestApplet
extends JApplet {
    private static final long serialVersionUID = 1L;

    public void start() {
        super.start();
        Button readButton = new Button("Read");
        readButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LowLevelTestApplet.this.readData();
            }
        });
        this.add(readButton);
    }

    public void readData() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        LowLevelTestApplet.this.doRead();
                        return null;
                    }
                });
            }
        });
    }

    private void doRead() {
        boolean sweet = false;
        GoIOLibrary goio = new GoIOLibrary();
        System.out.println("start main");
        if (!goio.initLibrary()) {
            System.out.println("goIOInterface.initLibrary() failed --bye");
            return;
        }
        if (goio.init() != 0) {
            System.out.println("goIOInterface.init() failed --bye");
            return;
        }
        GoIOSensor sensor = goio.getFirstSensor();
        System.out.println("Found goio: " + sensor);
        sensor.open();
        sweet = goio.sensorSetMeasurementPeriod(sensor, 0.04, 2000);
        System.out.println("sensorSetMeasurementPeriod: " + sweet);
        goio.sensorStartCollectingData(sensor);
        System.out.println("sensorStartCollectingData: " + sweet);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            System.out.println("Bad sleep");
        }
        int MAX_NUM_MEASUREMENTS = 100;
        int[] ret = goio.sensorReadRawMeasuements(sensor, MAX_NUM_MEASUREMENTS);
        System.out.println("sensorReadRawMeasuements: number of bytes read: " + ret.length);
        int i = 0;
        for (i = 0; i < ret.length; ++i) {
            System.out.println("> " + i + " " + ret[i]);
        }
        goio.uninit();
        System.out.println("end  main");
    }
}

