/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.goio.jna;

import com.sun.jna.FunctionMapper;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import org.concord.sensor.goio.jna.GoIOJNALibrary;
import org.concord.sensor.goio.jna.GoIOSensor;

public class GoIOLibrary {
    static int[] GO_DEVICES = new int[]{3, 2, 4, 7};
    protected GoIOJNALibrary goIOLibrary;

    public boolean initLibrary() {
        NativeHelper.removeTemporaryFiles();
        File nativeLibFile = GoIOLibrary.getNativeLibraryFromJar();
        String nativeLibPath = nativeLibFile.getAbsolutePath();
        FunctionMapper functMapper = new FunctionMapper(){

            public String getFunctionName(NativeLibrary library, Method method) {
                return method.getName();
            }
        };
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("function-mapper", functMapper);
        options.put("structure-alignment", 1);
        this.goIOLibrary = (GoIOJNALibrary)Native.loadLibrary((String)nativeLibPath, GoIOJNALibrary.class, options);
        NativeHelper.deleteNativeLibrary(nativeLibFile);
        return this.goIOLibrary != null;
    }

    public int uninit() {
        int ret = this.goIOLibrary.GoIO_Uninit();
        this.goIOLibrary = null;
        return ret;
    }

    public int init() {
        return this.goIOLibrary.GoIO_Init();
    }

    public boolean isGoDeviceAttached() {
        for (int i = 0; i < GO_DEVICES.length; ++i) {
            int number = this.goIOLibrary.GoIO_UpdateListOfAvailableDevices(2295, GO_DEVICES[i]);
            if (number <= 0) continue;
            return true;
        }
        return false;
    }

    public GoIOSensor getSensor(int productId, int index) {
        int number = this.goIOLibrary.GoIO_UpdateListOfAvailableDevices(2295, productId);
        if (number <= index) {
            return null;
        }
        GoIOSensor sensor = new GoIOSensor(this.goIOLibrary);
        sensor.init(productId, index);
        return sensor;
    }

    public GoIOSensor getFirstSensor() {
        for (int i = 0; i < GO_DEVICES.length; ++i) {
            GoIOSensor sensor = this.getSensor(GO_DEVICES[i], 0);
            if (sensor == null) continue;
            return sensor;
        }
        return null;
    }

    public boolean sensorSetMeasurementPeriod(GoIOSensor sensor, double desiredPeriod, int timeoutMs) {
        int ret = this.goIOLibrary.GoIO_Sensor_SetMeasurementPeriod(sensor.hDevice, desiredPeriod, timeoutMs);
        return 0 == ret;
    }

    public boolean sensorSendCmd(GoIOSensor sensor, byte cmd, byte[] pParams, int nParamBytes, Pointer pRespBuf, int[] pnRespBytes, int timeoutMs) {
        int ret = this.goIOLibrary.GoIO_Sensor_SendCmdAndGetResponse(sensor.hDevice, cmd, pParams, nParamBytes, pRespBuf, pnRespBytes, timeoutMs);
        return ret == 0;
    }

    public boolean sensorStartCollectingData(GoIOSensor sensor) {
        boolean ret = false;
        byte[] pParams = null;
        Pointer pRespBuf = null;
        int[] pnRespBytes = null;
        ret = this.sensorSendCmd(sensor, (byte)24, pParams, 0, pRespBuf, pnRespBytes, 2000);
        return ret;
    }

    public int[] sensorReadRawMeasuements(GoIOSensor sensor, int maxCount) {
        int[] pMeasurementsBuf = new int[maxCount];
        int ngot = this.goIOLibrary.GoIO_Sensor_ReadRawMeasurements(sensor.hDevice, pMeasurementsBuf, maxCount);
        int[] retbuf = new int[ngot];
        System.arraycopy(pMeasurementsBuf, 0, retbuf, 0, ngot);
        return retbuf;
    }

    protected boolean getDeviceName(char[] deviceName, int nameLength, int[] pVendorId, int[] pProductId) {
        boolean bFoundDevice = true;
        deviceName[0] = '\u0000';
        int VDV_ID = 2295;
        int numSkips = this.updateDeviceListEntry(VDV_ID, 3);
        int numJonahs = this.updateDeviceListEntry(VDV_ID, 2);
        int numCyclopses = this.updateDeviceListEntry(VDV_ID, 4);
        int numMiniGCs = this.updateDeviceListEntry(VDV_ID, 7);
        if (numSkips > 0) {
            pVendorId[0] = 2295;
            pProductId[0] = 3;
        } else if (numJonahs > 0) {
            pVendorId[0] = 2295;
            pProductId[0] = 2;
        } else if (numCyclopses > 0) {
            pVendorId[0] = 2295;
            pProductId[0] = 4;
        } else if (numMiniGCs > 0) {
            pVendorId[0] = 2295;
            pProductId[0] = 7;
        } else {
            bFoundDevice = false;
        }
        if (bFoundDevice) {
            this.goIOLibrary.GoIO_GetNthAvailableDeviceName(deviceName, nameLength, pVendorId[0], pProductId[0], 0);
        }
        return bFoundDevice;
    }

    protected Pointer sensorOpen(char[] pDeviceName, int vendorId, int productId) {
        return this.goIOLibrary.GoIO_Sensor_Open(pDeviceName, vendorId, productId, 0);
    }

    protected int updateDeviceListEntry(int vendor, int device_id) {
        return this.goIOLibrary.GoIO_UpdateListOfAvailableDevices(vendor, device_id);
    }

    private static File getNativeLibraryFromJar() {
        String libname = GoIOLibrary.getNativeLibraryName();
        String resourceName = GoIOLibrary.getNativeLibraryResourcePath() + "/" + libname;
        URL url = GoIOLibrary.class.getResource(resourceName);
        if (url == null) {
            throw new UnsatisfiedLinkError("GoIO (" + resourceName + ") not found in resource path");
        }
        File lib = null;
        InputStream is = Native.class.getResourceAsStream(resourceName);
        if (is == null) {
            throw new Error("Can't obtain jnidispatch InputStream");
        }
        FileOutputStream fos = null;
        try {
            int count;
            lib = File.createTempFile("jna", null);
            fos = new FileOutputStream(lib);
            byte[] buf = new byte[1024];
            while ((count = is.read(buf, 0, buf.length)) > 0) {
                fos.write(buf, 0, count);
            }
        }
        catch (IOException e) {
            throw new Error("Failed to create temporary file for jnidispatch library: " + e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
        return lib;
    }

    private static String getNativeLibraryName() {
        if (Platform.isWindows()) {
            return "GoIO_DLL.dll";
        }
        if (Platform.isMac()) {
            return "libGoIOUniversal.dylib";
        }
        return null;
    }

    private static String getNativeLibraryResourcePath() {
        String osPrefix;
        String arch = System.getProperty("os.arch").toLowerCase();
        if (Platform.isWindows()) {
            osPrefix = "win32_" + arch;
        } else if (Platform.isMac()) {
            osPrefix = "darwin";
        } else if (Platform.isLinux()) {
            if ("x86".equals(arch)) {
                arch = "i386";
            } else if ("x86_64".equals(arch)) {
                arch = "amd64";
            }
            osPrefix = "linux_" + arch;
        } else if (Platform.isSolaris()) {
            osPrefix = "sunos_" + arch;
        } else {
            osPrefix = System.getProperty("os.name").toLowerCase();
            int space = osPrefix.indexOf(" ");
            if (space != -1) {
                osPrefix = osPrefix.substring(0, space);
            }
            osPrefix = osPrefix + "-" + arch;
        }
        return "/org/concord/sensor/goio/jna/" + osPrefix;
    }

    private static class NativeHelper {
        private NativeHelper() {
        }

        private static void deleteNativeLibrary(File file) {
            if (file.delete()) {
                return;
            }
            NativeHelper.markTemporaryFile(file);
        }

        private static void markTemporaryFile(File file) {
            try {
                File marker = new File(file.getParentFile(), file.getName() + ".x");
                marker.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private static void removeTemporaryFiles() {
            try {
                File dir = File.createTempFile("jna", ".x").getParentFile();
                FilenameFilter filter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".x") && name.indexOf("jna") != -1;
                    }
                };
                File[] files = dir.listFiles(filter);
                for (int i = 0; files != null && i < files.length; ++i) {
                    File marker = files[i];
                    String name = marker.getName();
                    name = name.substring(0, name.length() - 2);
                    File target = new File(marker.getParentFile(), name);
                    if (target.exists() && !target.delete()) continue;
                    marker.delete();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

