/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.goio.jna;

import com.sun.jna.Pointer;
import org.concord.sensor.goio.jna.GoIOJNALibrary;

public class GoIOSensor {
    private static final int LOCK_TIMEOUT_MS = 1000;
    GoIOJNALibrary goIOLibrary;
    char[] deviceName = new char[255];
    int productId;
    Pointer hDevice;
    private int openedSensorId;
    public static final int ANALOG_CHANNEL_5V = 0;
    public static final int ANALOG_CHANNEL_10V = 1;

    public GoIOSensor(GoIOJNALibrary goIOLibrary) {
        this.goIOLibrary = goIOLibrary;
    }

    public void init(int productId, int index) {
        this.productId = productId;
        if (this.goIOLibrary.GoIO_GetNthAvailableDeviceName(this.deviceName, 255, 2295, productId, index) != 0) {
            throw new RuntimeException("error getting device name");
        }
    }

    public void open() {
        this.hDevice = this.goIOLibrary.GoIO_Sensor_Open(this.deviceName, 2295, this.productId, 0);
        if (this.hDevice == null) {
            throw new RuntimeException("error opening device");
        }
        this.unlock();
        this.openedSensorId = this.getAttachedSensorId();
    }

    public void close() {
        this.lock();
        this.goIOLibrary.GoIO_Sensor_Close(this.hDevice);
    }

    private void lock() {
        int ret = this.goIOLibrary.GoIO_Sensor_Lock(this.hDevice, 1000);
        if (ret != 0) {
            throw new RuntimeException("unable to lock device");
        }
    }

    private void unlock() {
        int ret = this.goIOLibrary.GoIO_Sensor_Unlock(this.hDevice);
        if (ret != 0) {
            throw new RuntimeException("unable to unlock device");
        }
    }

    public void clearIO() {
        this.lock();
        int ret = this.goIOLibrary.GoIO_Sensor_ClearIO(this.hDevice);
        this.unlock();
        if (ret != 0) {
            throw new RuntimeException("error clearing IO");
        }
    }

    public void startMeasurements() {
        this.lock();
        int ret = this.goIOLibrary.GoIO_Sensor_SendCmdAndGetResponse(this.hDevice, (byte)24, null, 0, null, null, 2000);
        this.unlock();
        if (ret != 0) {
            throw new RuntimeException("error starting measurments");
        }
    }

    public void stopMeasurements() {
        this.lock();
        int ret = this.goIOLibrary.GoIO_Sensor_SendCmdAndGetResponse(this.hDevice, (byte)25, null, 0, null, null, 2000);
        this.unlock();
        if (ret != 0) {
            throw new RuntimeException("error stopping measurments");
        }
    }

    public int readRawMeasurements(int[] rawBuffer) {
        int safeCount = rawBuffer.length / 6 * 6;
        this.lock();
        int ret = this.goIOLibrary.GoIO_Sensor_ReadRawMeasurements(this.hDevice, rawBuffer, safeCount);
        this.unlock();
        return ret;
    }

    public double convertToVoltage(int rawData) {
        return this.goIOLibrary.GoIO_Sensor_ConvertToVoltage(this.hDevice, rawData);
    }

    public double calibrateData(double voltage) {
        return this.goIOLibrary.GoIO_Sensor_CalibrateData(this.hDevice, voltage);
    }

    public void setMeasurementPeriod(double desiredPeriod) {
        this.lock();
        int ret = this.goIOLibrary.GoIO_Sensor_SetMeasurementPeriod(this.hDevice, desiredPeriod, 2000);
        this.unlock();
        if (ret != 0) {
            throw new RuntimeException("error setting measurement period");
        }
    }

    public int getAttachedSensorId() {
        byte[] sensorId = new byte[1];
        this.lock();
        int ret = this.goIOLibrary.GoIO_Sensor_DDSMem_GetSensorNumber(this.hDevice, sensorId, 1, 2000);
        this.unlock();
        if (ret != 0) {
            throw new RuntimeException("error getting sensor id");
        }
        return sensorId[0] & 0xFF;
    }

    public double getMeasurementPeriod() {
        this.lock();
        double ret = this.goIOLibrary.GoIO_Sensor_GetMeasurementPeriod(this.hDevice, 2000);
        this.unlock();
        if (ret == 1000000.0) {
            throw new RuntimeException("error getting measurement period");
        }
        return ret;
    }

    public byte getDDSCheckSum() {
        this.lock();
        byte[] pChecksum = new byte[1];
        int ret = this.goIOLibrary.GoIO_Sensor_DDSMem_GetChecksum(this.hDevice, pChecksum);
        this.unlock();
        if (ret != 0) {
            throw new RuntimeException("Can't get DDS checksum");
        }
        return pChecksum[0];
    }

    public void setAnalogInputChannel(int channel) {
        byte channelConst = 2;
        if (channel == 0) {
            channelConst = 2;
        } else if (channel == 1) {
            channelConst = 1;
        }
        this.lock();
        this.goIOLibrary.GoIO_Sensor_SendCmdAndGetResponse(this.hDevice, (byte)41, new byte[]{channelConst}, 1, null, null, 2000);
        this.unlock();
    }

    public String getDeviceLabel() {
        switch (this.productId) {
            case 3: {
                return "GoLink";
            }
            case 2: {
                return "GoTemp";
            }
            case 4: {
                return "GoMotion";
            }
            case 7: {
                return "MiniGasChromatograph";
            }
        }
        return "Unknown GoIO Device";
    }

    public boolean isGoMotion() {
        return this.productId == 4;
    }

    public boolean isGoTemp() {
        return this.productId == 2;
    }

    public boolean isGoLink() {
        return this.productId == 3;
    }

    public boolean isMiniGasChromatograph() {
        return this.productId == 7;
    }
}

