/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.device.impl;

import org.concord.sensor.impl.TickListener;
import org.concord.sensor.impl.Ticker;

public class JavaTicker
extends Thread
implements Ticker {
    int millis;
    boolean ticking = false;
    boolean started = false;
    TickListener tickListener;

    public synchronized void startTicking(int millis, TickListener listener) {
        this.millis = millis;
        this.ticking = true;
        if (this.started) {
            this.notify();
        } else {
            this.started = true;
            this.start();
        }
        if (listener == null) {
            throw new RuntimeException("Started ticker with null listener");
        }
        if (this.tickListener != null) {
            throw new RuntimeException("Inconsitant ticker state");
        }
        this.tickListener = listener;
    }

    public synchronized void stopTicking(TickListener listener) {
        this.ticking = false;
        if (listener != this.tickListener && this.tickListener != null) {
            this.tickListener.tickStopped();
        }
        this.tickListener = null;
    }

    public synchronized boolean isTicking() {
        return this.ticking;
    }

    public synchronized void setTickListener(TickListener tListener) {
        if (tListener != null && this.tickListener != null) {
            throw new RuntimeException("Inconsitant ticker state");
        }
        this.tickListener = tListener;
    }

    public synchronized TickListener getTickListener() {
        return this.tickListener;
    }

    public Ticker createNew() {
        return new JavaTicker();
    }

    public int currentTimeMillis() {
        return (int)(System.currentTimeMillis() % Integer.MAX_VALUE);
    }

    public int getMillis() {
        return this.millis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            JavaTicker javaTicker = this;
            synchronized (javaTicker) {
                if (!this.ticking) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.tickListener != null) {
                    this.tickListener.tick();
                } else {
                    System.err.println("ticking a null listener");
                }
                try {
                    this.wait(this.millis);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

