/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.labquest.jna;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import org.concord.sensor.labquest.jna.GSensorDDSMem;
import org.concord.sensor.labquest.jna.LabQuest;
import org.concord.sensor.labquest.jna.LabQuestCommandException;
import org.concord.sensor.labquest.jna.LabQuestException;
import org.concord.sensor.labquest.jna.LabQuestStatus;
import org.concord.sensor.labquest.jna.NGIOLibrary;
import org.concord.sensor.labquest.jna.NGIOSourceCmds;

public class LabQuestImpl
implements LabQuest {
    private NGIOLibrary ngio;
    private Pointer hDevice;
    private int deviceType;

    LabQuestImpl(NGIOLibrary ngio) {
        this.ngio = ngio;
    }

    public void open(String deviceName, Pointer hLibrary) throws LabQuestException {
        this.hDevice = this.ngio.device_Open(hLibrary, deviceName, (byte)0);
        if (this.hDevice == null) {
            throw new LabQuestException();
        }
        IntByReference pDeviceType = new IntByReference();
        int ret = this.ngio.getDeviceTypeFromDeviceName(deviceName, pDeviceType);
        if (ret != 0) {
            this.handleError();
        }
        this.deviceType = pDeviceType.getValue();
    }

    public void close() throws LabQuestException {
        System.err.println("LabQuest: closing");
        int ret = this.ngio.device_Close(this.hDevice);
        System.err.println("LabQuest: called close");
        if (ret != 0) {
            this.handleError();
        }
        System.err.println("LabQuest: claimed to close");
    }

    public boolean isRemoteCollectionActive() throws LabQuestException {
        if (this.deviceType == 12) {
            return false;
        }
        ByteByReference remoteCollectionActive = new ByteByReference();
        int ret = this.ngio.device_IsRemoteCollectionActive(this.hDevice, remoteCollectionActive, 2000);
        if (ret != 0) {
            this.handleError();
        }
        return remoteCollectionActive.getValue() != 0;
    }

    public void acquireExclusiveOwnership() throws LabQuestException {
        if (this.deviceType == 12) {
            return;
        }
        int ret = this.ngio.device_AcquireExclusiveOwnership(this.hDevice, 12000);
        if (ret != 0) {
            this.handleError();
        }
    }

    public LabQuestStatus getStatus() throws LabQuestException {
        LabQuestStatus status = new LabQuestStatus();
        this.sendCmdAndGetResponse((byte)16, null, status);
        return status;
    }

    public String getSensorName(byte channel) throws LabQuestException {
        int sensorId = this.getSensorId(channel);
        System.out.println("found sensor: " + sensorId);
        if (sensorId >= 20) {
            this.ddsMemReadRecord(channel, false);
            GSensorDDSMem sensorDDSMem = this.ddsMemGetRecord(channel);
            String name = Native.toString((byte[])sensorDDSMem.SensorLongName);
            return name;
        }
        return "";
    }

    public int getSensorId(byte channel) throws LabQuestException {
        NGIOSourceCmds.NGIOGetSensorIdParams sensorIdParams = new NGIOSourceCmds.NGIOGetSensorIdParams();
        NGIOSourceCmds.NGIOGetSensorIdCmdResponsePayload sensorIdCmdResponsePayload = new NGIOSourceCmds.NGIOGetSensorIdCmdResponsePayload();
        sensorIdParams.channel = channel;
        this.sendCmdAndGetResponse((byte)40, sensorIdParams, sensorIdCmdResponsePayload);
        byte[] sensorId = sensorIdCmdResponsePayload.sensorId;
        return LabQuestImpl.intFromBytes(sensorId);
    }

    public void ddsMemReadRecord(byte channel, boolean strict) throws LabQuestException {
        byte strictByte = strict ? (byte)1 : 0;
        int ret = this.ngio.device_DDSMem_ReadRecord(this.hDevice, channel, strictByte, 2000);
        if (ret != 0) {
            this.handleError();
        }
    }

    public GSensorDDSMem ddsMemGetRecord(byte channel) throws LabQuestException {
        GSensorDDSMem sensorDDSMem = new GSensorDDSMem();
        int ret = this.ngio.device_DDSMem_GetRecord(this.hDevice, (byte)1, sensorDDSMem);
        if (ret != 0) {
            this.handleError();
        }
        return sensorDDSMem;
    }

    public byte ddsMemCalculateChecksum(byte channel) {
        ByteByReference pChecksum = new ByteByReference();
        int ret = this.ngio.device_DDSMem_CalculateChecksum(this.hDevice, channel, pChecksum);
        if (ret != 0) {
            return 0;
        }
        return pChecksum.getValue();
    }

    public void setMeasurementPeriod(byte channel, double desiredPeriod) throws LabQuestException {
        int ret = this.ngio.device_SetMeasurementPeriod(this.hDevice, channel, desiredPeriod, 2000);
        if (ret != 0) {
            this.handleError();
        }
    }

    public void setSensorChannelEnableMask(int mask) throws LabQuestException {
        NGIOSourceCmds.NGIOSetSensorChannelEnableMaskParams channelEnableMaskParams = new NGIOSourceCmds.NGIOSetSensorChannelEnableMaskParams();
        LabQuestImpl.bytesFromInt(mask, channelEnableMaskParams.enableSensorChannels);
        this.sendCmdAndGetResponse((byte)44, channelEnableMaskParams, null);
    }

    public void clearIO(byte channel) throws LabQuestException {
        int ret = this.ngio.device_ClearIO(this.hDevice, channel);
        if (ret != 0) {
            this.handleError();
        }
    }

    public void startMeasurements() throws LabQuestException {
        this.sendCmdAndGetResponse((byte)24, null, null);
    }

    public void stopMeasurements() throws LabQuestException {
        this.sendCmdAndGetResponse((byte)25, null, null);
    }

    public int getNumberOfMeasurementsAvailable(byte channel) throws LabQuestException {
        int ret = this.ngio.device_GetNumMeasurementsAvailable(this.hDevice, channel);
        if (ret < 0) {
            this.handleError();
        }
        return ret;
    }

    public int readRawMeasurementsAnalog(byte channel, int[] pMeasurementsBuf, int maxCount) throws LabQuestException {
        int numMeasurements = this.ngio.device_ReadRawMeasurements(this.hDevice, channel, pMeasurementsBuf, null, maxCount);
        if (numMeasurements < 0) {
            this.handleError();
        }
        return numMeasurements;
    }

    public int readRawMeasurementsMotion(byte channel, int[] pMeasurementsBuf, long[] timestampBuf, int maxCount) throws LabQuestException {
        int numMeasurements = this.ngio.device_ReadRawMeasurements(this.hDevice, channel, pMeasurementsBuf, timestampBuf, maxCount);
        if (numMeasurements < 0) {
            this.handleError();
        }
        return numMeasurements;
    }

    public float convertToVoltage(byte channel, int rawMeasurement, int probeType) {
        return this.ngio.device_ConvertToVoltage(this.hDevice, channel, rawMeasurement, probeType);
    }

    public void setAnalogInput(byte channel, byte analogInput) throws LabQuestException {
        NGIOSourceCmds.NGIOSetAnalogInputParams setAnalogInputParams = new NGIOSourceCmds.NGIOSetAnalogInputParams();
        setAnalogInputParams.channel = channel;
        setAnalogInputParams.analogInput = analogInput;
        this.sendCmdAndGetResponse((byte)33, setAnalogInputParams, null);
    }

    public void setSamplingMode(byte channel, byte samplingMode) throws LabQuestException {
        NGIOSourceCmds.NGIOSetSamplingModeParams setSamplingModeParams = new NGIOSourceCmds.NGIOSetSamplingModeParams();
        setSamplingModeParams.channel = channel;
        setSamplingModeParams.samplingMode = samplingMode;
        this.sendCmdAndGetResponse((byte)41, setSamplingModeParams, null);
    }

    public float calibrateData2(byte channel, int rawValue) {
        return this.ngio.device_CalibrateData2(this.hDevice, channel, rawValue);
    }

    public void printAttachedSensors() throws LabQuestException {
        for (byte i = 1; i < 7; i = (byte)(i + 1)) {
            int sensorId = this.getSensorId(i);
            System.out.println("found sensor: " + sensorId);
            if (sensorId < 20) continue;
            this.ddsMemReadRecord(i, false);
            GSensorDDSMem sensorDDSMem = this.ddsMemGetRecord(i);
            String name = Native.toString((byte[])sensorDDSMem.SensorLongName);
            System.out.println("  name: " + name);
            System.out.println("  operationType: " + sensorDDSMem.OperationType);
        }
    }

    public void sendCmdAndGetResponse(byte cmd, Structure params, Structure response) throws LabQuestCommandException {
        int paramsSize = 0;
        if (params != null) {
            paramsSize = params.size();
        }
        Memory responsePtr = null;
        IntByReference responseSizeReference = new IntByReference();
        if (response == null) {
            responsePtr = new Memory(1L);
            responseSizeReference.setValue(1);
        } else {
            response.write();
            responsePtr = response.getPointer();
            responseSizeReference.setValue(response.size());
        }
        int ret = this.ngio.device_SendCmdAndGetResponse(this.hDevice, cmd, params, paramsSize, (Pointer)responsePtr, responseSizeReference, 2000);
        if (ret != 0) {
            int responseSize = responseSizeReference.getValue();
            if (responseSize == 1) {
                byte status = responsePtr.getByte(0L);
                System.err.println("error sending command: " + status);
                throw new LabQuestCommandException(cmd, status);
            }
            this.handleError();
        }
        if (response != null) {
            response.read();
        }
    }

    private void handleError() throws LabQuestCommandException {
        throw this.exceptionFromResponseStatus((byte)-1);
    }

    private LabQuestCommandException exceptionFromResponseStatus(byte cmd) {
        ByteByReference lastCmd = new ByteByReference();
        ByteByReference lastCmdStatus = new ByteByReference();
        ByteByReference lastCmdWithErrorRespSentOvertheWire = new ByteByReference();
        ByteByReference lastErrorSentOvertheWire = new ByteByReference();
        int ret = this.ngio.device_GetLastCmdResponseStatus(this.hDevice, lastCmd, lastCmdStatus, lastCmdWithErrorRespSentOvertheWire, lastErrorSentOvertheWire);
        if (ret == 0) {
            LabQuestCommandException exception = new LabQuestCommandException(lastCmd.getValue(), lastCmdStatus.getValue(), lastCmdWithErrorRespSentOvertheWire.getValue(), lastErrorSentOvertheWire.getValue());
            System.err.println("error sending command " + exception.getMessage());
            return exception;
        }
        return new LabQuestCommandException(cmd, -1);
    }

    private static int intFromBytes(byte[] buf) {
        return buf[0] | buf[1] << 8 | buf[2] << 16 | buf[3] << 24;
    }

    private static void bytesFromInt(int val, byte[] buf) {
        buf[0] = (byte)(val & 0xFF);
        buf[1] = (byte)((val & 0xFF00) >> 8);
        buf[2] = (byte)((val & 0xFF0000) >> 16);
        buf[3] = (byte)((val & 0xFF000000) >>> 24);
    }
}

