/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.vernier.labpro;

import java.io.IOException;
import org.concord.sensor.impl.Vector;
import org.concord.sensor.labprousb.jna.LabProUSB;
import org.concord.sensor.labprousb.jna.LabProUSBException;
import org.concord.sensor.labprousb.jna.LabProUSBLibrary;
import org.concord.sensor.serial.SensorSerialPort;
import org.concord.sensor.serial.SerialException;

public class SensorSerialPortLabProUSB
implements SensorSerialPort {
    byte[] tmpBuffer = new byte[2048];
    private static LabProUSB lpusb;

    public void close() throws SerialException {
        lpusb.close();
        lpusb = null;
    }

    public void disableReceiveTimeout() {
    }

    public void enableReceiveTimeout(int time) throws SerialException {
    }

    public Vector getAvailablePorts() {
        return null;
    }

    public int getBaudRate() {
        return 0;
    }

    public int getDataBits() {
        return 0;
    }

    public int getParity() {
        return 0;
    }

    public int getStopBits() {
        return 0;
    }

    public boolean isOpen() {
        if (lpusb == null) {
            return false;
        }
        short open = lpusb.isOpen();
        return open == 1;
    }

    public void open(String portName) throws SerialException {
        try {
            LabProUSBLibrary lplib = new LabProUSBLibrary();
            lplib.init();
            lpusb = lplib.openDevice();
        }
        catch (LabProUSBException e) {
            e.printStackTrace();
            throw new SerialException("Unable to open device");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SerialException("Unable to initialize native library");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new SerialException("Unable to initialize native library (interrupted)");
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            throw new SerialException("Can't load labprousb library", (Throwable)e);
        }
    }

    public int readBytes(byte[] buf, int off, int len, long timeout) throws SerialException {
        int size = 0;
        long startTime = System.currentTimeMillis();
        while (size != -1 && size < len && System.currentTimeMillis() - startTime < timeout) {
            int availableBytes = lpusb.getAvailableBytes();
            if (availableBytes > 0) {
                int numRead = lpusb.readBytes(availableBytes, this.tmpBuffer);
                if (numRead < 0) {
                    System.err.println();
                    System.err.println("error in readBytes: " + numRead);
                    return numRead;
                }
                System.arraycopy(this.tmpBuffer, 0, buf, size + off, numRead);
                size += numRead;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return size;
    }

    public void setFlowControlMode(int flowcontrol) throws SerialException {
    }

    public void setSerialPortParams(int baud, int data, int stop, int parity) throws SerialException {
    }

    public void write(int value) throws SerialException {
        this.tmpBuffer[0] = (byte)value;
        this.write(this.tmpBuffer, 0, 1);
    }

    public void write(byte[] buffer) throws SerialException {
        this.write(buffer, 0, buffer.length);
    }

    public void write(byte[] buffer, int start, int length) throws SerialException {
        short numWritten;
        byte[] bufToWrite = buffer;
        if (start != 0) {
            System.arraycopy(buffer, start, this.tmpBuffer, 0, length);
            bufToWrite = this.tmpBuffer;
        }
        if ((numWritten = lpusb.writeBytes((short)length, bufToWrite)) < length) {
            throw new SerialException("Didn't write all bytes. Wrote: " + numWritten + " out of: " + length);
        }
    }

    public boolean isOpenFast() {
        return true;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (lpusb != null) {
                    System.err.println("Closing LabProUSB.  Its open state is: " + lpusb.isOpen());
                    lpusb.close();
                }
            }
        });
    }
}

