/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.applet;

import java.applet.Applet;
import java.awt.EventQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JApplet;
import netscape.javascript.JSObject;
import org.concord.sensor.ExperimentConfig;
import org.concord.sensor.SensorConfig;
import org.concord.sensor.SensorRequest;
import org.concord.sensor.applet.JavascriptDataBridge;
import org.concord.sensor.applet.SensorAppletAPI;
import org.concord.sensor.applet.SensorUtil;
import org.concord.sensor.applet.exception.ConfigureDeviceException;
import org.concord.sensor.applet.exception.SensorAppletException;
import org.concord.sensor.impl.SensorRequestImpl;
import org.concord.sensor.impl.SensorUtilJava;
import org.json.JSONWriter;

public class SensorApplet
extends JApplet
implements SensorAppletAPI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SensorApplet.class.getName());
    private JavascriptDataBridge jsBridge;
    private HashMap<String, SensorUtil> sensorUtils = new HashMap();
    private boolean notifiedJavascript;
    private ExperimentConfig latestExperimentConfig = null;
    private SensorConfig[] latestSensorConfig = null;

    public void start() {
        if (this.notifiedJavascript) {
            return;
        }
        this.notifiedJavascript = true;
        String codeToEval = this.getParameter("evalOnInit");
        if (codeToEval == null || codeToEval.length() == 0) {
            return;
        }
        JSObject window = JSObject.getWindow((Applet)this);
        System.out.println("SensorApplet running evalOnInit code");
        window.eval(codeToEval);
    }

    public void destroy() {
        for (Map.Entry<String, SensorUtil> entry : this.sensorUtils.entrySet()) {
            SensorUtil util = entry.getValue();
            util.destroy();
        }
        this.jsBridge.destroy();
        this.sensorUtils.clear();
        super.destroy();
    }

    private SensorUtil findOrCreateUtil(String deviceType) {
        SensorUtil util = this.sensorUtils.get(deviceType);
        if (util == null) {
            logger.info("Creating new util...");
            util = new SensorUtil(this, deviceType);
            this.sensorUtils.put(deviceType, util);
        }
        return util;
    }

    public void initSensorInterface(final String listenerPath, final String deviceType, final SensorRequest[] sensors) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        try {
                            logger.info("Setting things up: " + listenerPath + ", " + deviceType + ", " + sensors);
                            SensorApplet.this.jsBridge = new JavascriptDataBridge(listenerPath, SensorApplet.this);
                            SensorUtil util = SensorApplet.this.findOrCreateUtil(deviceType);
                            util.initSensorInterface(sensors, SensorApplet.this.jsBridge);
                        }
                        catch (Throwable t) {
                            System.err.println("Caught unexpected runtime exception...");
                            t.printStackTrace();
                            SensorApplet.this.jsBridge.initSensorInterfaceComplete(false);
                        }
                        return null;
                    }
                });
            }
        });
    }

    public void isInterfaceConnected(final String deviceType, final String callbackIndex) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Boolean b = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        SensorUtil util = SensorApplet.this.findOrCreateUtil(deviceType);
                        if (util.isDeviceAttached()) {
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }
                });
                SensorApplet.this.jsBridge.handleCallback(callbackIndex, new String[]{b.toString()});
            }
        });
    }

    public String getCachedDeviceConfiguration() {
        return JavascriptDataBridge.toJSON(this.latestExperimentConfig).toString();
    }

    public void getDeviceConfiguration(final String deviceType, final String callbackIndex) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ExperimentConfig c = AccessController.doPrivileged(new PrivilegedAction<ExperimentConfig>(){

                    @Override
                    public ExperimentConfig run() {
                        SensorUtil util = SensorApplet.this.findOrCreateUtil(deviceType);
                        try {
                            return util.getDeviceConfig();
                        }
                        catch (ConfigureDeviceException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                });
                SensorApplet.this.latestExperimentConfig = c;
                SensorApplet.this.jsBridge.handleCallback(callbackIndex, null);
            }
        });
    }

    public String getCachedAttachedSensors() {
        try {
            JSONWriter json = JavascriptDataBridge.toJSON(this.latestSensorConfig);
            return json.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "[]";
        }
    }

    public void getAttachedSensors(final String deviceType, final String callbackIndex) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SensorConfig[] c = AccessController.doPrivileged(new PrivilegedAction<SensorConfig[]>(){

                    @Override
                    public SensorConfig[] run() {
                        SensorUtil util = SensorApplet.this.findOrCreateUtil(deviceType);
                        try {
                            ExperimentConfig config = util.getDeviceConfig();
                            if (config != null) {
                                return config.getSensorConfigs();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                });
                SensorApplet.access$402(SensorApplet.this, c);
                SensorApplet.this.jsBridge.handleCallback(callbackIndex, null);
            }
        });
    }

    public void getAttachedSensorsValues(final String deviceType, final String callbackIndex) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                float[] values = SensorApplet.this.getSensorsValues(deviceType, true);
                String args = SensorApplet.this.jsBridge.asArgs(values);
                SensorApplet.this.jsBridge.handleCallback(callbackIndex, new String[]{args});
            }
        });
    }

    public void getConfiguredSensorsValues(final String deviceType, final String callbackIndex) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                float[] values = SensorApplet.this.getConfiguredSensorsValues(deviceType);
                String args = SensorApplet.this.jsBridge.asArgs(values);
                SensorApplet.this.jsBridge.handleCallback(callbackIndex, new String[]{args});
            }
        });
    }

    private float[] getConfiguredSensorsValues(String deviceType) {
        SensorUtil util = this.findOrCreateUtil(deviceType);
        if (util.isActualConfigValid()) {
            return this.getSensorsValues(deviceType, false);
        }
        this.jsBridge.notifySensorUnplugged();
        util.reconfigureNextTime();
        return null;
    }

    private float[] getSensorsValues(final String deviceType, final boolean allSensors) {
        float[] out = AccessController.doPrivileged(new PrivilegedAction<float[]>(){

            @Override
            public float[] run() {
                SensorUtil util = SensorApplet.this.findOrCreateUtil(deviceType);
                try {
                    return util.readSingleValue(SensorApplet.this.jsBridge, allSensors);
                }
                catch (SensorAppletException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        return out;
    }

    public void stopCollecting() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        for (Map.Entry entry : SensorApplet.this.sensorUtils.entrySet()) {
                            try {
                                SensorUtil util = (SensorUtil)entry.getValue();
                                if (!util.isRunning()) continue;
                                util.stopDevice();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        return Boolean.TRUE;
                    }
                });
            }
        });
    }

    public void startCollecting() {
        this.stopCollecting();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        for (Map.Entry entry : SensorApplet.this.sensorUtils.entrySet()) {
                            SensorUtil util = (SensorUtil)entry.getValue();
                            if (!util.isCollectable()) continue;
                            try {
                                util.startDevice(SensorApplet.this.jsBridge);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        return Boolean.TRUE;
                    }
                });
            }
        });
    }

    public SensorRequestImpl getSensorRequest(String sensorType) {
        return SensorUtil.getSensorRequest(sensorType);
    }

    public String getTypeConstantName(int type) {
        return SensorUtilJava.getTypeConstantName((int)type).toLowerCase();
    }

    static /* synthetic */ SensorConfig[] access$402(SensorApplet x0, SensorConfig[] x1) {
        x0.latestSensorConfig = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        READY,
        RUNNING,
        STOPPED,
        UNKNOWN;

    }
}

