/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.applet;

import java.applet.Applet;
import java.awt.EventQueue;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.concord.sensor.DeviceConfig;
import org.concord.sensor.ExperimentConfig;
import org.concord.sensor.ExperimentRequest;
import org.concord.sensor.SensorConfig;
import org.concord.sensor.SensorRequest;
import org.concord.sensor.applet.JavascriptDataBridge;
import org.concord.sensor.applet.exception.ConfigureDeviceException;
import org.concord.sensor.applet.exception.CreateDeviceException;
import org.concord.sensor.applet.exception.SensorAppletException;
import org.concord.sensor.device.SensorDevice;
import org.concord.sensor.device.impl.DeviceConfigImpl;
import org.concord.sensor.device.impl.JavaDeviceFactory;
import org.concord.sensor.device.impl.SensorConfigImpl;
import org.concord.sensor.impl.ExperimentRequestImpl;
import org.concord.sensor.impl.Range;
import org.concord.sensor.impl.SensorRequestImpl;
import org.concord.sensor.impl.SensorUtilJava;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SensorUtil {
    private static final Logger logger = Logger.getLogger(SensorUtil.class.getName());
    private static final int MAX_READ_ERRORS = 7;
    private Applet applet;
    private JavaDeviceFactory deviceFactory;
    private SensorDevice device;
    private ExperimentConfig actualConfig;
    private boolean deviceIsRunning = false;
    private boolean deviceIsAttached = false;
    private boolean deviceIsCollectable = false;
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> collectionTask;
    private String deviceType;
    private String executorThreadName;
    private SensorRequest[] sensors;
    private SensorRequest[] configuredSensors;
    private int numErrors = 0;
    private ExperimentConfig reportedConfig;
    private long reportedConfigLoadedAt = 0L;
    private boolean reconfigureNextTime = false;

    public SensorUtil(Applet applet, String deviceType) {
        this.applet = applet;
        this.deviceType = deviceType;
        this.deviceFactory = new JavaDeviceFactory();
        this.executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> task = this.executor.schedule(new Runnable(){

            public void run() {
                SensorUtil.this.executorThreadName = Thread.currentThread().getName();
            }
        }, 0L, TimeUnit.MILLISECONDS);
        try {
            task.get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initSensorInterface(final SensorRequest[] sensors, final JavascriptDataBridge jsBridge) {
        System.out.println("initSensorInterface called with sensors: " + (sensors == null ? "null" : Integer.valueOf(sensors.length)));
        this.executor.schedule(new Runnable(){

            public void run() {
                boolean success = false;
                try {
                    SensorUtil.this.setupDevice(sensors);
                    if (SensorUtil.this.isActualConfigValid()) {
                        success = true;
                    } else {
                        SensorUtil.this.reconfigureNextTime();
                        success = false;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    success = false;
                }
                jsBridge.initSensorInterfaceComplete(success);
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    public boolean isRunning() {
        return this.deviceIsRunning;
    }

    public void stopDeviceError(JavascriptDataBridge jsBridge) {
        this.stopDevice();
        try {
            if (this.isDeviceAttached()) {
                ExperimentConfig config = this.getDeviceConfig();
                if (config == null) {
                    jsBridge.notifyDeviceUnplugged();
                    return;
                }
                if (config.getSensorConfigs() == null || config.getSensorConfigs().length != this.sensors.length) {
                    jsBridge.notifySensorUnplugged();
                    return;
                }
                System.out.println("Somehow we didn't detect a connection error!");
                this.configureDevice(this.sensors, true);
            } else {
                jsBridge.notifyDeviceUnplugged();
            }
        }
        catch (ConfigureDeviceException e) {
            jsBridge.notifyDeviceUnplugged();
        }
    }

    public void stopDevice() {
        if (this.device != null && this.deviceIsRunning) {
            if (this.collectionTask != null && !this.collectionTask.isDone()) {
                this.collectionTask.cancel(false);
            }
            this.collectionTask = null;
            Runnable r = new Runnable(){

                public void run() {
                    logger.fine("Stopping device: " + Thread.currentThread().getName());
                    SensorUtil.this.deviceIsRunning = false;
                    SensorUtil.this.device.stop(true);
                }
            };
            if (!this.executeAndWait(r)) {
                System.err.println("Stopping had errors! Closing and re-opening.");
                this.tearDownDevice();
            }
        }
    }

    private void reopenDevice(boolean skipExecutor) {
        Runnable r = new Runnable(){

            public void run() {
                SensorUtil.this.device.close();
                SensorUtil.this.device.open(SensorUtil.this.getOpenString(SensorUtil.this.getDeviceId(SensorUtil.this.deviceType)));
            }
        };
        if (skipExecutor) {
            r.run();
        } else {
            this.executeAndWait(r);
        }
    }

    public void startDevice(final JavascriptDataBridge jsBridge) throws CreateDeviceException, ConfigureDeviceException {
        if (this.deviceIsRunning) {
            System.err.println("statDevice called while a device is running");
            return;
        }
        if (this.collectionTask != null) {
            System.err.println("startDevice called while a collectionTask is still around");
            return;
        }
        if (this.device == null) {
            this.createDevice();
        }
        if (this.isDeviceAttached()) {
            this.configureDevice(this.sensors, true);
            if (!this.actualConfig.isValid()) {
                System.err.println("actualConfig is not valid just before starting device");
                return;
            }
            final float[] data = new float[1024];
            final Runnable r = new Runnable(){

                public void run() {
                    try {
                        int numSamples = SensorUtil.this.device.read(data, 0, SensorUtil.this.sensors.length, null);
                        if (numSamples > 0) {
                            float[] dataCopy = new float[numSamples * SensorUtil.this.sensors.length];
                            System.arraycopy(data, 0, dataCopy, 0, numSamples * SensorUtil.this.sensors.length);
                            jsBridge.handleData(numSamples, SensorUtil.this.sensors.length, dataCopy);
                            SensorUtil.this.numErrors = 0;
                        } else {
                            SensorUtil.this.numErrors++;
                        }
                    }
                    catch (Exception e) {
                        SensorUtil.this.numErrors++;
                        logger.log(Level.SEVERE, "Error reading data from device!", e);
                    }
                    if (SensorUtil.this.numErrors >= 7) {
                        SensorUtil.this.numErrors = 0;
                        logger.severe("Too many collection errors! Stopping device.");
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                SensorUtil.this.stopDeviceError(jsBridge);
                            }
                        });
                    }
                }
            };
            this.numErrors = 0;
            long interval = (long)Math.floor(this.actualConfig.getDataReadPeriod() * 1000.0f);
            if (interval <= 0L) {
                interval = 100L;
            }
            final long adjustedInterval = interval;
            Runnable start = new Runnable(){

                public void run() {
                    SensorUtil.this.deviceIsRunning = SensorUtil.this.device.start();
                    if (SensorUtil.this.deviceIsRunning) {
                        System.out.println("started device");
                        SensorUtil.this.collectionTask = SensorUtil.this.executor.scheduleAtFixedRate(r, 10L, adjustedInterval, TimeUnit.MILLISECONDS);
                    } else {
                        System.err.println("error starting the device");
                    }
                }
            };
            this.execute(start, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] readSingleValue(JavascriptDataBridge jsBridge, boolean allAttachedSensors) throws SensorAppletException {
        if (this.deviceIsRunning) {
            return null;
        }
        if (this.device == null) {
            this.setupDevice(null);
        }
        if (allAttachedSensors) {
            this.configureDevice(null, false);
        } else {
            this.configureDevice(this.sensors, false);
        }
        int numSensorsTmp = 1;
        float minPeriodTmp = Float.MAX_VALUE;
        if (allAttachedSensors || this.sensors == null) {
            ExperimentConfig config = this.getDeviceConfig();
            if (config == null) {
                return null;
            }
            SensorConfig[] configs = config.getSensorConfigs();
            numSensorsTmp = configs.length;
            if (configs == null || numSensorsTmp < 1) {
                return null;
            }
            minPeriodTmp = config.getPeriod();
            if ((double)minPeriodTmp < 0.001) {
                minPeriodTmp = 0.1f;
            }
        } else {
            numSensorsTmp = this.sensors.length;
            minPeriodTmp = this.getMinPeriod(this.sensors);
        }
        final int numSensors = numSensorsTmp;
        final float minPeriod = minPeriodTmp;
        Runnable start = new Runnable(){

            public void run() {
                SensorUtil.this.deviceIsRunning = SensorUtil.this.device.start();
                System.out.println("started device");
            }
        };
        this.execute(start, 0);
        final float[] buffer = new float[1024];
        final float[] data = new float[numSensorsTmp];
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void run() {
                int numCollected = 0;
                while (SensorUtil.this.numErrors < 7 && numCollected < 1) {
                    try {
                        int numSamples = SensorUtil.this.device.read(buffer, 0, numSensors, null);
                        if (numSamples > 0) {
                            float[] fArray = data;
                            // MONITORENTER : data
                            System.arraycopy(buffer, 0, data, 0, numSensors);
                            // MONITOREXIT : fArray
                            ++numCollected;
                            SensorUtil.this.numErrors = 0;
                            continue;
                        }
                        SensorUtil.this.numErrors++;
                        Thread.sleep((int)(1000.0f * minPeriod));
                    }
                    catch (Exception e) {
                        SensorUtil.this.numErrors++;
                        logger.log(Level.SEVERE, "Error reading data from device!", e);
                    }
                }
                if (SensorUtil.this.numErrors < 7) return;
                logger.severe("Too many collection errors while getting single value! Stopping device.");
            }
        };
        try {
            this.numErrors = 0;
            this.executeAndWait(r, 10);
            float[] fArray = data;
            synchronized (data) {
                numSensorsTmp = 0;
                // ** MonitorExit[var11_13] (shouldn't be in output)
                fArray = data;
                return fArray;
            }
        }
        finally {
            if (this.numErrors >= 5) {
                this.stopDeviceError(jsBridge);
            } else {
                this.stopDevice();
            }
        }
    }

    public void setupDevice(SensorRequest[] sensors) throws CreateDeviceException, ConfigureDeviceException {
        this.sensors = sensors;
        if (this.device == null) {
            this.createDevice();
        }
        if (!this.isDeviceAttached()) {
            throw new CreateDeviceException("Device is not attached");
        }
        this.configureDevice(sensors, true);
    }

    public ExperimentConfig getDeviceConfig() throws ConfigureDeviceException {
        this.reportedConfig = null;
        if (this.device != null && (this.reportedConfig == null || System.currentTimeMillis() - this.reportedConfigLoadedAt > 1000L)) {
            Runnable r = new Runnable(){

                public void run() {
                    logger.fine("Getting device config: " + Thread.currentThread().getName());
                    SensorUtil.this.reportedConfig = SensorUtil.this.device.getCurrentConfig();
                    SensorUtil.this.reportedConfigLoadedAt = System.currentTimeMillis();
                }
            };
            this.executeAndWaitConfigure(r);
        }
        return this.reportedConfig;
    }

    public boolean isDeviceAttached() {
        Runnable r = new Runnable(){

            public void run() {
                if (SensorUtil.this.device != null) {
                    logger.fine("Checking attached: " + Thread.currentThread().getName());
                    SensorUtil.this.deviceIsAttached = SensorUtil.this.device.isAttached();
                    if (!SensorUtil.this.deviceIsAttached) {
                        try {
                            SensorUtil.this.reopenDevice(true);
                            SensorUtil.this.deviceIsAttached = SensorUtil.this.device.isAttached();
                        }
                        catch (Exception e) {
                            SensorUtil.this.deviceIsAttached = false;
                        }
                    }
                } else {
                    logger.info("Device was null. Trying to open...");
                    try {
                        SensorUtil.this.createDevice();
                        SensorUtil.this.deviceIsAttached = SensorUtil.this.isDeviceAttached();
                    }
                    catch (SensorAppletException e) {
                        SensorUtil.this.deviceIsAttached = false;
                    }
                }
            }
        };
        this.executeAndWait(r);
        return this.deviceIsAttached;
    }

    public boolean isCollectable() {
        logger.fine("Checking for sensor interface: " + this.deviceType);
        if (this.sensors != null && this.sensors.length > 0 && this.deviceIsCollectable) {
            return this.deviceIsCollectable;
        }
        try {
            if (this.device == null) {
                this.createDevice();
            }
            if (this.isDeviceAttached()) {
                logger.fine("Device reported as attached.");
                ExperimentConfig config = this.getDeviceConfig();
                if (config != null) {
                    System.err.println("Interface is connected. Here's the config: ");
                    SensorUtilJava.printExperimentConfig((ExperimentConfig)config);
                    this.deviceIsCollectable = true;
                    return this.deviceIsCollectable;
                }
                logger.fine("No config!");
            } else {
                logger.fine("device says not attached");
            }
        }
        catch (SensorAppletException e) {
            e.printStackTrace();
        }
        this.deviceIsCollectable = false;
        return this.deviceIsCollectable;
    }

    public void tearDownDevice() {
        this.stopDevice();
        if (this.device == null) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                logger.fine("Closing device: " + Thread.currentThread().getName());
                if (SensorUtil.this.device != null) {
                    SensorUtil.this.deviceFactory.destroyDevice(SensorUtil.this.device);
                    SensorUtil.this.device = null;
                    SensorUtil.this.deviceIsRunning = false;
                    logger.fine("Device shut down");
                }
            }
        };
        this.executeAndWait(r);
    }

    public void destroy() {
        this.tearDownDevice();
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            System.err.println("Shutdown completed. All tasks terminated: " + this.executor.isTerminated());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.executor = null;
        this.executorThreadName = null;
        this.applet = null;
        this.deviceFactory = null;
    }

    private void createDevice() throws CreateDeviceException {
        Runnable r = new Runnable(){

            public void run() {
                logger.fine("Creating device: " + Thread.currentThread().getName());
                int deviceId = SensorUtil.this.getDeviceId(SensorUtil.this.deviceType);
                SensorUtil.this.device = SensorUtil.this.deviceFactory.createDevice((DeviceConfig)new DeviceConfigImpl(deviceId, SensorUtil.this.getOpenString(deviceId)));
            }
        };
        this.executeAndWaitCreate(r);
    }

    private void configureDevice(final SensorRequest[] sensors, boolean force) throws ConfigureDeviceException {
        if (!force && this.configuredSensors == sensors) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                logger.fine("Configuring device: " + Thread.currentThread().getName());
                ExperimentRequestImpl request = new ExperimentRequestImpl();
                if (!SensorUtil.this.configureExperimentRequest(request, sensors)) {
                    System.out.println("Couldn't configure experiment request!");
                    return;
                }
                SensorUtil.this.actualConfig = SensorUtil.this.device.configure((ExperimentRequest)request);
                System.out.println("Config to be used:");
                if (SensorUtil.this.actualConfig == null) {
                    System.out.println("IS ALSO NULL <-- BAD!");
                    SensorUtil.this.deviceIsCollectable = false;
                } else {
                    SensorUtilJava.printExperimentConfig((ExperimentConfig)SensorUtil.this.actualConfig);
                    SensorUtil.access$2002(SensorUtil.this, sensors);
                    SensorUtil.this.deviceIsCollectable = true;
                }
            }
        };
        this.executeAndWaitConfigure(r);
    }

    private boolean configureExperimentRequest(ExperimentRequestImpl experiment, SensorRequest[] sensors) {
        if (!(sensors != null && sensors.length != 0 || (sensors = this.getSensorsFromCurrentConfig()) != null && sensors.length != 0)) {
            return false;
        }
        float minPeriod = this.getMinPeriod(sensors);
        System.out.println("Configured min period: " + minPeriod);
        experiment.setPeriod(minPeriod);
        experiment.setNumberOfSamples(-1);
        experiment.setSensorRequests(sensors);
        return true;
    }

    private float getMinPeriod(SensorRequest[] sensors) {
        float minPeriod = Float.MAX_VALUE;
        for (SensorRequest sensor : sensors) {
            float period = this.getPeriod(sensor);
            if (!(period < minPeriod)) continue;
            minPeriod = period;
        }
        return minPeriod;
    }

    private SensorRequest[] getSensorsFromCurrentConfig() {
        ExperimentConfig deviceConfig = this.device.getCurrentConfig();
        if (deviceConfig == null || deviceConfig.getSensorConfigs() == null) {
            return null;
        }
        SensorConfig[] configs = deviceConfig.getSensorConfigs();
        SensorRequest[] reqs = new SensorRequest[configs.length];
        for (int i = 0; i < configs.length; ++i) {
            SensorConfigImpl config = (SensorConfigImpl)configs[i];
            SensorRequestImpl sensorReq = new SensorRequestImpl();
            Range r = config.getValueRange();
            if (r == null) {
                r = new Range(-10000.0f, 10000.0f);
            }
            SensorUtil.configureSensorRequest(sensorReq, 1, r.minimum, r.maximum, config.getPort(), config.getStepSize(), config.getType());
            reqs[i] = sensorReq;
        }
        return reqs;
    }

    private float getPeriod(SensorRequest sensor) {
        switch (sensor.getType()) {
            case 18: 
            case 19: {
                return 1.0f;
            }
            case 5: 
            case 13: {
                return 0.05f;
            }
        }
        return 0.1f;
    }

    private int getDeviceId(String id) {
        logger.fine("Requested device of: " + id);
        if (id.equals("golink") || id.equals("goio")) {
            return 13;
        }
        if (id.equals("labquest")) {
            return 12;
        }
        if (id.equals("manual")) {
            try {
                return Integer.parseInt(this.applet.getParameter("deviceId"));
            }
            catch (NumberFormatException e) {
                logger.severe("Invalid 'deviceId' param: " + this.applet.getParameter("deviceId"));
            }
        }
        return 0;
    }

    private String getOpenString(int deviceId) {
        switch (deviceId) {
            case 12: 
            case 13: {
                return null;
            }
        }
        return this.applet.getParameter("openString");
    }

    public static SensorRequestImpl getSensorRequest(String type) {
        type = type.toLowerCase();
        SensorRequestImpl sensor = new SensorRequestImpl();
        if (type.equals("light")) {
            SensorUtil.configureSensorRequest(sensor, 0, 0.0f, 4000.0f, 0, 0.1f, 2);
        } else if (type.equals("position") || type.equals("distance")) {
            SensorUtil.configureSensorRequest(sensor, -2, 0.0f, 4.0f, 0, 0.1f, 13);
        } else if (type.equals("co2") || type.equals("carbon dioxide")) {
            SensorUtil.configureSensorRequest(sensor, 1, 0.0f, 5000.0f, 0, 20.0f, 18);
        } else if (type.equals("force")) {
            SensorUtil.configureSensorRequest(sensor, -2, -4.0f, 4.0f, 0, 0.1f, 5);
        } else if (type.equals("force 5n")) {
            SensorUtil.configureSensorRequest(sensor, -2, -4.0f, 4.0f, 0, 0.01f, 5);
        } else if (type.equals("force 50n")) {
            SensorUtil.configureSensorRequest(sensor, -1, -40.0f, 40.0f, 0, 0.1f, 5);
        } else if (type.equals("o2") || type.equals("oxygen")) {
            SensorUtil.configureSensorRequest(sensor, -2, 0.0f, 100.0f, 0, 0.01f, 19);
        } else if (type.equals("ph")) {
            SensorUtil.configureSensorRequest(sensor, -1, 0.0f, 14.0f, 0, 0.1f, 20);
        } else if (!type.equals("manual")) {
            SensorUtil.configureSensorRequest(sensor, -1, 0.0f, 40.0f, 0, 0.1f, 0);
        }
        return sensor;
    }

    private static void configureSensorRequest(SensorRequestImpl sensor, int precision, float min, float max, int port, float step, int type) {
        sensor.setDisplayPrecision(precision);
        sensor.setRequiredMin(min);
        sensor.setRequiredMax(max);
        sensor.setPort(port);
        sensor.setStepSize(step);
        sensor.setType(type);
    }

    private ScheduledFuture<?> execute(Runnable r, int delay) {
        if (Thread.currentThread().getName().equals(this.executorThreadName)) {
            r.run();
            return null;
        }
        return this.executor.schedule(r, (long)delay, TimeUnit.MILLISECONDS);
    }

    private void executeAndWaitCreate(Runnable r) throws CreateDeviceException {
        try {
            ScheduledFuture<?> task = this.execute(r, 0);
            if (task != null) {
                task.get();
            }
        }
        catch (InterruptedException e) {
            throw new CreateDeviceException("Exception creating device", e);
        }
        catch (ExecutionException e) {
            throw new CreateDeviceException("Exception creating device", e.getCause());
        }
        catch (IllegalMonitorStateException e) {
            throw new CreateDeviceException("Exception creating device", e);
        }
    }

    private void executeAndWaitConfigure(Runnable r) throws ConfigureDeviceException {
        try {
            ScheduledFuture<?> task = this.execute(r, 0);
            if (task != null) {
                task.get();
            }
        }
        catch (InterruptedException e) {
            throw new ConfigureDeviceException("Exception configuring device", e);
        }
        catch (ExecutionException e) {
            throw new ConfigureDeviceException("Exception configuring device", e.getCause());
        }
        catch (IllegalMonitorStateException e) {
            throw new ConfigureDeviceException("Exception configuring device", e);
        }
    }

    private boolean executeAndWait(Runnable r) {
        return this.executeAndWait(r, 0);
    }

    private boolean executeAndWait(Runnable r, int delayMs) {
        try {
            ScheduledFuture<?> task = this.execute(r, delayMs);
            if (task != null) {
                task.get();
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isActualConfigValid() {
        if (this.reconfigureNextTime) {
            this.reconfigureNextTime = false;
            try {
                this.configureDevice(this.sensors, true);
            }
            catch (ConfigureDeviceException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.actualConfig == null) {
            return false;
        }
        if (this.sensors == null) {
            return true;
        }
        if (this.actualConfig.isValid()) {
            return true;
        }
        System.err.println("actualConfig is not valid (the attached sensors don't include the requested sensors)");
        SensorConfig[] actuals = this.actualConfig.getSensorConfigs();
        if (actuals == null) {
            System.err.println("  there are no attached sensors");
            return false;
        }
        if (this.sensors == null) {
            System.err.println("  there are no requested sensors");
            return false;
        }
        int[] actualTypes = new int[actuals.length];
        for (int i = 0; i < actuals.length; ++i) {
            int aType;
            actualTypes[i] = aType = actuals[i].getType();
        }
        int[] reqTypes = new int[this.sensors.length];
        for (int i = 0; i < this.sensors.length; ++i) {
            int rType;
            reqTypes[i] = rType = this.sensors[i].getType();
        }
        System.err.println("  requested Sensors: " + Arrays.toString(reqTypes));
        System.err.println("  attached  Sensors:  " + Arrays.toString(actualTypes));
        return false;
    }

    public void reconfigureNextTime() {
        this.reconfigureNextTime = true;
    }

    static /* synthetic */ SensorRequest[] access$2002(SensorUtil x0, SensorRequest[] x1) {
        x0.configuredSensors = x1;
        return x1;
    }
}

