/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.device.impl;

import org.concord.sensor.device.DeviceReader;
import org.concord.sensor.device.impl.AbstractSensorDevice;
import org.concord.sensor.device.impl.StreamingBuffer;
import org.concord.sensor.serial.SerialException;

public abstract class AbstractStreamingSensorDevice
extends AbstractSensorDevice {
    private StreamingBuffer streamingBuffer;
    int readSize = this.getStreamBufferSize();

    public AbstractStreamingSensorDevice() {
        this.streamingBuffer = new StreamingBuffer();
        this.streamingBuffer.buf = new byte[this.readSize + 100];
        this.streamingBuffer.processedBytes = 0;
        this.streamingBuffer.totalBytes = 0;
    }

    public boolean start() {
        this.error = 0;
        this.streamingBuffer.clear();
        return true;
    }

    public int read(float[] values, int offset, int nextSampleOffset, DeviceReader reader) {
        int ret = -1;
        try {
            ret = this.port.readBytes(this.streamingBuffer.buf, this.streamingBuffer.totalBytes, this.readSize - this.streamingBuffer.totalBytes, 1L);
            if (ret < 0) {
                this.log("SerPort r error: " + ret + " (dataRead)");
                this.portError(0);
                return ret;
            }
        }
        catch (SerialException e) {
            this.log("SerPort r exp: " + e.getMessage() + " (dataRead)");
            this.portError(e.getPortError());
            return -1;
        }
        this.streamingBuffer.totalBytes += ret;
        int numSamples = this.streamRead(values, offset, nextSampleOffset, reader, this.streamingBuffer);
        if (numSamples < 0) {
            this.closePort();
            return -1;
        }
        this.streamingBuffer.shift();
        return numSamples;
    }

    protected abstract int streamRead(float[] var1, int var2, int var3, DeviceReader var4, StreamingBuffer var5);

    protected abstract int getStreamBufferSize();
}

