/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.device.impl;

import java.util.Hashtable;
import java.util.logging.Logger;
import org.concord.sensor.DeviceConfig;
import org.concord.sensor.device.DeviceFactory;
import org.concord.sensor.device.DeviceIdAware;
import org.concord.sensor.device.DeviceService;
import org.concord.sensor.device.DeviceServiceAware;
import org.concord.sensor.device.SensorDevice;
import org.concord.sensor.device.UserMessageHandler;
import org.concord.sensor.device.impl.DeviceID;
import org.concord.sensor.device.impl.JavaDeviceService;
import org.concord.sensor.device.impl.JavaTicker;
import org.concord.sensor.impl.Ticker;

public class JavaDeviceFactory
extends JavaDeviceService
implements DeviceFactory,
DeviceID,
DeviceService {
    private static final Logger logger = Logger.getLogger(JavaDeviceFactory.class.getCanonicalName());
    Ticker ticker = null;
    Hashtable<String, SensorDevice> deviceTable = new Hashtable();
    Hashtable<SensorDevice, String> configTable = new Hashtable();

    public JavaDeviceFactory() {
        this.ticker = new JavaTicker();
    }

    public SensorDevice createDevice(DeviceConfig config) {
        int id = config.getDeviceId();
        String configStr = config.getConfigString();
        String deviceConfigId = "" + id + ":" + configStr;
        SensorDevice existingDevice = this.deviceTable.get(deviceConfigId);
        if (existingDevice != null) {
            return existingDevice;
        }
        String className = null;
        SensorDevice device = null;
        switch (id) {
            case 0: 
            case 1: {
                className = "org.concord.sensor.pseudo.PseudoSensorDevice";
                break;
            }
            case 14: {
                className = "org.concord.sensor.nativelib.NativeVernierSensorDevice";
                break;
            }
            case 11: {
                className = "org.concord.sensor.vernier.labpro.LabProSensorDevice";
                break;
            }
            case 12: {
                className = "org.concord.sensor.vernier.labquest.LabQuestSensorDevice";
                break;
            }
            case 10: 
            case 13: {
                className = "org.concord.sensor.vernier.goio.GoIOSensorDevice";
                break;
            }
            case 20: {
                className = "org.concord.sensor.nativelib.NativeTISensorDevice";
                break;
            }
            case 30: 
            case 40: 
            case 41: 
            case 42: {
                className = "org.concord.sensor.dataharvest.DataHarvestSensorDevice";
                break;
            }
            case 60: {
                className = "org.concord.sensor.pasco.SW500SensorDevice";
                break;
            }
            case 61: {
                className = "org.concord.sensor.pasco.AirLinkSensorDevice";
                break;
            }
            case 62: {
                className = "org.concord.sensor.pasco.PascoUsbSensorDevice";
                break;
            }
            case 45: 
            case 50: 
            case 55: 
            case 80: {
                device = null;
                break;
            }
            case 70: {
                className = "org.concord.sensor.cc.CCInterface0";
                break;
            }
            case 71: {
                className = "org.concord.sensor.cc.CCInterface1";
                break;
            }
            case 72: {
                className = "org.concord.sensor.cc.CCInterface2";
            }
        }
        if (className == null) {
            System.err.println("Unknown Sensor Interface type: " + id);
            return null;
        }
        try {
            System.out.println("Loading sensor device: " + className);
            Class<?> sensDeviceClass = this.getClass().getClassLoader().loadClass(className);
            device = (SensorDevice)sensDeviceClass.newInstance();
            if (device instanceof DeviceIdAware) {
                ((DeviceIdAware)((Object)device)).setDeviceId(id);
            }
            if (device instanceof DeviceServiceAware) {
                ((DeviceServiceAware)((Object)device)).setDeviceService(this);
            }
            device.open(config.getConfigString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.deviceTable.put(deviceConfigId, device);
        this.configTable.put(device, deviceConfigId);
        return device;
    }

    public void destroyDevice(SensorDevice device) {
        device.close();
        String configStr = this.configTable.get(device);
        this.deviceTable.remove(configStr);
        this.configTable.remove(device);
    }

    public void log(String message) {
        logger.info(message);
    }

    public UserMessageHandler getMessageHandler() {
        return null;
    }
}

