/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.device.impl;

import org.concord.sensor.device.DeviceService;
import org.concord.sensor.serial.SensorSerialPort;

public abstract class JavaDeviceService
implements DeviceService {
    public int getOSType() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return 3;
        }
        if (osName.startsWith("Linux")) {
            return 1;
        }
        if (osName.startsWith("Mac OS X")) {
            return 2;
        }
        return 0;
    }

    public SensorSerialPort getSerialPort(String name, SensorSerialPort oldPort) {
        String portClassName = null;
        if ("ftdi".equals(name)) {
            portClassName = "org.concord.sensor.dataharvest.SensorSerialPortFTDI";
        } else if ("os".equals(name)) {
            portClassName = "org.concord.sensor.serial.SensorSerialPortRXTX";
        } else if ("labprousb".equals(name)) {
            portClassName = "org.concord.sensor.vernier.labpro.SensorSerialPortLabProUSB";
        }
        try {
            Class<?> portClass = this.getClass().getClassLoader().loadClass(portClassName);
            if (!portClass.isInstance(oldPort)) {
                return (SensorSerialPort)portClass.newInstance();
            }
            return oldPort;
        }
        catch (Exception e) {
            System.err.println("Can't load serial port driver class: " + portClassName);
            return null;
        }
    }

    public void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public float intBitsToFloat(int valueInt) {
        return Float.intBitsToFloat(valueInt);
    }

    public boolean isValidFloat(float val) {
        return !Float.isNaN(val);
    }
}

