/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.labquest.jna;

import org.concord.sensor.labquest.jna.LabQuestException;

public class LabQuestCommandException
extends LabQuestException {
    private byte lastCmd;
    private byte lastCmdStatus;
    private byte lastCmdWithErrorRespSentOvertheWire;
    private byte lastErrorSentOvertheWire;

    public LabQuestCommandException(byte cmd, byte status) {
        this.lastCmd = cmd;
        this.lastCmdStatus = status;
    }

    public LabQuestCommandException(byte lastCmd, byte lastCmdStatus, byte lastCmdWithErrorRespSentOvertheWire, byte lastErrorSentOvertheWire) {
        this.lastCmd = lastCmd;
        this.lastCmdStatus = lastCmdStatus;
        this.lastCmdWithErrorRespSentOvertheWire = lastCmdWithErrorRespSentOvertheWire;
        this.lastErrorSentOvertheWire = lastErrorSentOvertheWire;
    }

    public String getMessage() {
        return String.format("lastCmd: %#04x lastCmdStatus: %s(%#04x) lastCmdWithErrorRespSentOvertheWire: %#04x lastErrorSentOvertheWire: %s(%#04x)", this.lastCmd, LabQuestCommandException.getStatusString(this.lastCmdStatus), this.lastCmdStatus, this.lastCmdWithErrorRespSentOvertheWire, LabQuestCommandException.getStatusString(this.lastErrorSentOvertheWire), this.lastErrorSentOvertheWire);
    }

    public boolean isCommunicationError() {
        return this.lastCmdStatus == 65;
    }

    public static String getStatusString(byte status) {
        switch (status) {
            case 0: {
                return "success";
            }
            case 48: {
                return "not ready for new command";
            }
            case 49: {
                return "command not supported";
            }
            case 50: {
                return "internal error 1";
            }
            case 51: {
                return "internal error 2";
            }
            case 52: {
                return "cannot change period while collecting";
            }
            case 53: {
                return "cannot read NV memory bulk while collecting";
            }
            case 54: {
                return "invalid parameter";
            }
            case 55: {
                return "cannot write flash while collecting";
            }
            case 56: {
                return "cannot write flash while host fifo busy";
            }
            case 57: {
                return "operation blocked while collecting";
            }
            case 58: {
                return "calculator cannot measure with no batteries";
            }
            case 59: {
                return "operation not supported in current mode";
            }
            case 60: {
                return "audio control failure";
            }
            case 61: {
                return "audio stream failure";
            }
            case 62: {
                return "cannot reallocate frame buffers";
            }
            case 65: {
                return "communication error";
            }
            case 72: {
                return "interal error 3";
            }
            case 73: {
                return "internal error 4";
            }
        }
        return "unknown error status";
    }
}

