/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.labquest.jna;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleThreadDelegator<T>
extends Thread {
    private Throwable throwable;
    private Object taskReturn;
    private Class<? extends Throwable> exceptionWrapper;
    private Object instance;
    private Method method;
    private Object[] args;
    private Method terminateMethod;
    private boolean quiting = false;

    public T instanciate(T instance, Class<T> interface_, Class<? extends Throwable> throwableWrapper, Method terminateMethod) {
        this.instance = instance;
        this.exceptionWrapper = throwableWrapper;
        this.terminateMethod = terminateMethod;
        InvocationHandler invocationHandler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return SingleThreadDelegator.this.invokeMethod(method, args);
            }
        };
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{interface_}, invocationHandler);
    }

    public synchronized Object invokeMethod(Method method, Object[] args) throws Throwable {
        if (!this.isAlive()) {
            throw new IllegalStateException("The thread has exited so no more methods can be called");
        }
        if (this.method != null) {
            throw new IllegalStateException("this is bad if the stored method is null");
        }
        this.method = method;
        this.args = args;
        this.taskReturn = null;
        this.notify();
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.throwable != null) {
            Throwable wrapper = this.exceptionWrapper.newInstance();
            wrapper.initCause(this.throwable);
            this.throwable = null;
            throw wrapper;
        }
        return this.taskReturn;
    }

    @Override
    public synchronized void run() {
        while (!this.isInterrupted() && !this.quiting) {
            if (this.method == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    break;
                }
            }
            if (this.quiting) break;
            try {
                try {
                    this.taskReturn = this.method.invoke(this.instance, this.args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable t) {
                this.throwable = t;
            }
            if (this.method.equals(this.terminateMethod)) {
                this.method = null;
                this.quiting = true;
                this.notify();
                return;
            }
            this.method = null;
            this.notify();
        }
        if (!this.quiting) {
            System.err.println("Runner Thread got interrupted");
        }
    }

    public synchronized void quit() {
        this.quiting = true;
        this.notify();
    }
}

