/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.vernier.labpro;

import java.util.StringTokenizer;
import org.concord.sensor.ExperimentConfig;
import org.concord.sensor.ExperimentRequest;
import org.concord.sensor.SensorConfig;
import org.concord.sensor.device.DeviceReader;
import org.concord.sensor.device.DeviceService;
import org.concord.sensor.device.impl.AbstractStreamingSensorDevice;
import org.concord.sensor.device.impl.SerialPortParams;
import org.concord.sensor.device.impl.StreamingBuffer;
import org.concord.sensor.impl.ExperimentConfigImpl;
import org.concord.sensor.impl.Vector;
import org.concord.sensor.serial.SensorSerialPort;
import org.concord.sensor.serial.SerialException;
import org.concord.sensor.vernier.VernierSensor;
import org.concord.sensor.vernier.VernierSensorDevice;
import org.concord.sensor.vernier.labpro.LabProProtocol;

public class LabProSensorDevice
extends AbstractStreamingSensorDevice
implements VernierSensorDevice {
    static final SerialPortParams serialPortParams = new SerialPortParams(0, 38400, 8, 1, 0);
    public static final int[] CHANNELS = new int[]{1, 2, 3, 4, 11, 12};
    public static final String ERR_DEVICE_NOT_ATTACHED = "LabPro is not attached";
    protected final byte[] buf = new byte[1024];
    protected LabProProtocol protocol;
    protected String currentErrorMessage;
    float[] dataValues = new float[16];
    private SensorSerialPort usbSerialPort;
    private SensorSerialPort osSerialPort;

    public LabProSensorDevice() {
        this.deviceLabel = "LP";
        this.protocol = new LabProProtocol(this);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                System.err.println("Closing LabProSensorDevice.");
                LabProSensorDevice.this.close();
            }
        });
    }

    public void close() {
        try {
            if (this.port != null && this.port.isOpen() && this.protocol != null) {
                this.protocol.reset();
            }
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        super.close();
    }

    protected SerialPortParams getSerialPortParams() {
        return serialPortParams;
    }

    protected boolean initializeOpenPort(String portName) {
        try {
            this.protocol.wakeUp();
            this.protocol.reset();
        }
        catch (SerialException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected boolean isAttachedInternal(String portLabel) {
        try {
            if (this.port == null || !this.port.isOpen()) {
                return false;
            }
            this.protocol.wakeUp();
            this.protocol.requestSystemStatus();
            float[] values = new float[18];
            int count = this.readValues(values);
            if (count != 17) {
                if (count >= 0) {
                    this.log("wrong number of values returned for system status ret: " + count);
                }
                return false;
            }
            if (LabProSensorDevice.round(values[3]) != 8888) {
                this.log("system status has wrong constent vlaue: " + values[3]);
                return false;
            }
        }
        catch (SerialException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static final int round(float value) {
        if (value >= 0.0f) {
            return (int)(value + 0.5f);
        }
        return (int)(value - 0.5f);
    }

    public ExperimentConfig configure(ExperimentRequest request) {
        return this.autoIdConfigure(request);
    }

    public ExperimentConfig getCurrentConfig() {
        ExperimentConfigImpl expConfig = new ExperimentConfigImpl();
        expConfig.setDeviceName("LabPro");
        Vector sensorConfigVect = new Vector();
        try {
            this.protocol.wakeUp();
            this.protocol.portPowerControl(-2);
            float[] channelStatus = new float[3];
            for (int i = 0; i < CHANNELS.length; ++i) {
                int channelNumber = CHANNELS[i];
                this.protocol.requestChannelStatus(channelNumber, 0);
                int count = this.readValues(channelStatus);
                if (count < 3) {
                    this.log("error reading channel status from device chan: " + channelNumber);
                    continue;
                }
                int sensorId = LabProSensorDevice.round(channelStatus[0]);
                this.log("chan: " + channelNumber + " sens id: " + sensorId);
                if (sensorId <= 0) continue;
                int channelType = 0;
                if (channelNumber > 10) {
                    channelType = 1;
                }
                VernierSensor sensorConfig = new VernierSensor(this, this.devService, channelNumber, channelType);
                sensorConfig.setupSensor(sensorId, null);
                sensorConfigVect.add((Object)sensorConfig);
            }
        }
        catch (SerialException e) {
            this.currentErrorMessage = ERR_DEVICE_NOT_ATTACHED;
            System.err.println(e.toString());
            return null;
        }
        int numSensors = sensorConfigVect.size();
        if (numSensors == 0) {
            expConfig.setSensorConfigs(null);
        } else {
            Object[] sensorConfigArr = new SensorConfig[sensorConfigVect.size()];
            Vector.copyArray((Object[])sensorConfigVect.items, (int)0, (Object[])sensorConfigArr, (int)0, (int)sensorConfigVect.size());
            expConfig.setSensorConfigs((SensorConfig[])sensorConfigArr);
        }
        expConfig.setExactPeriod(true);
        return expConfig;
    }

    public String getErrorMessage(int error) {
        return this.currentErrorMessage;
    }

    protected int streamRead(float[] values, int offset, int nextSampleOffset, DeviceReader reader, StreamingBuffer streamingBuffer) {
        SensorConfig[] sensors = this.currentConfig.getSensorConfigs();
        try {
            int count;
            int numSamples = 0;
            while ((count = this.readValues(this.dataValues, streamingBuffer)) > 0) {
                for (int i = 0; i < count && i < sensors.length; ++i) {
                    float value;
                    values[offset + nextSampleOffset * numSamples + i] = value = ((VernierSensor)sensors[i]).doPostCalibration(this.dataValues[i]);
                }
                ++numSamples;
            }
            return numSamples;
        }
        catch (SerialException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean start() {
        try {
            SensorConfig[] sensorConfigs;
            this.protocol.wakeUp();
            this.protocol.reset();
            for (SensorConfig sensor : sensorConfigs = this.currentConfig.getSensorConfigs()) {
                int channelNumber = sensor.getPort();
                if (sensor.getType() == 23 || sensor.getType() == 22) {
                    this.protocol.channelSetup(channelNumber, 14);
                    continue;
                }
                if (sensor.getType() == 25 || sensor.getType() == 24) {
                    this.protocol.channelSetup(channelNumber, 2);
                    continue;
                }
                this.protocol.channelSetup(channelNumber, 1);
            }
            this.protocol.portPowerControl(-2);
            this.protocol.dataCollectionSetup(this.currentConfig.getPeriod(), -1, 0);
            return super.start();
        }
        catch (SerialException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void stop(boolean wasRunning) {
        try {
            if (!this.port.isOpen()) {
                return;
            }
            this.protocol.wakeUp();
            this.protocol.reset();
            if (this.port.isOpenFast()) {
                this.port.close();
            }
        }
        catch (SerialException e) {
            e.printStackTrace();
        }
    }

    protected int readValues(float[] values, StreamingBuffer sb) throws SerialException {
        int count;
        int off;
        if (sb.totalBytes - sb.processedBytes < 2) {
            return 0;
        }
        byte currentByte = sb.buf[sb.processedBytes];
        if (currentByte != 123) {
            this.log("First byte isn't { instead it is: " + (char)currentByte);
            off = sb.processedBytes + 1;
            while (off < sb.totalBytes && currentByte != 123) {
                currentByte = sb.buf[off++];
            }
            if (currentByte != 123) {
                sb.processedBytes = off;
                return 0;
            }
            sb.processedBytes = off - 1;
        }
        off = sb.processedBytes + 1;
        while (off < sb.totalBytes && currentByte != 10) {
            currentByte = sb.buf[off++];
        }
        if (currentByte != 10) {
            return 0;
        }
        String result = new String(sb.buf, sb.processedBytes, off - sb.processedBytes);
        StringTokenizer toks = new StringTokenizer(result, "{},\r\n");
        for (count = 0; toks.hasMoreTokens() && count < values.length; ++count) {
            String numberStr = toks.nextToken();
            try {
                float number;
                values[count] = number = Float.parseFloat(numberStr);
                continue;
            }
            catch (NumberFormatException e) {
                System.err.println("error parsing: " + numberStr);
                e.printStackTrace();
            }
        }
        sb.processedBytes = off;
        return count;
    }

    protected int readValues(float[] values) throws SerialException {
        int ret = 0;
        int off = 0;
        int numBytes = 0;
        int attempts = 0;
        while (attempts < 5) {
            ret = this.port.readBytes(this.buf, off, this.buf.length - off, 100L);
            if (ret < 0) {
                this.log("error reading values err: " + ret);
                return -1;
            }
            if (ret == 0) {
                this.log("Didn't get any bytes from device attempt: " + attempts);
                ++attempts;
                continue;
            }
            if (this.buf[(numBytes += ret) - 1] == 10) break;
            off += ret;
            ++attempts;
        }
        if (numBytes < 1) {
            this.log("error reading values: no data returned " + attempts + " attempts");
            return -1;
        }
        if (this.buf[numBytes - 1] != 10) {
            String lastByteStr = "";
            if (ret > 0) {
                lastByteStr = " lastB: " + (char)this.buf[ret - 1];
            }
            this.log("error reading values ret: " + ret + lastByteStr);
            return -1;
        }
        String result = new String(this.buf, 0, numBytes);
        this.log("read: \"" + result + "\"");
        int startingIndex = result.lastIndexOf("{");
        if (startingIndex == -1) {
            this.log("readValues got invalid return: " + result);
            return -1;
        }
        result = result.substring(startingIndex);
        int count = 0;
        StringTokenizer toks = new StringTokenizer(result, "{},");
        while (toks.hasMoreTokens() && count < values.length) {
            float number;
            String numberStr = toks.nextToken();
            if ((numberStr = numberStr.trim()).length() == 0) continue;
            values[count] = number = Float.parseFloat(numberStr);
            ++count;
        }
        return count;
    }

    protected int getStreamBufferSize() {
        return 1024;
    }

    SensorSerialPort getPort() {
        return this.port;
    }

    DeviceService getDeviceService() {
        return this.devService;
    }

    protected SensorConfig createSensorConfig(int type, int requestPort) {
        VernierSensor config = new VernierSensor(this, this.devService, requestPort + 1, 0);
        config.setType(type);
        return config;
    }

    protected SensorSerialPort getSensorSerialPort() {
        if ("usb".equals(this.portName)) {
            return this.devService.getSerialPort("labprousb", this.port);
        }
        return super.getSensorSerialPort();
    }

    protected boolean openAutoPort() {
        if (this.usbSerialPort == null) {
            this.usbSerialPort = this.devService.getSerialPort("labprousb", this.usbSerialPort);
        }
        try {
            this.usbSerialPort.open(null);
            if (this.port != this.usbSerialPort && this.port != null) {
                this.port.close();
            }
            this.port = this.usbSerialPort;
            this.portName = "usb";
            return true;
        }
        catch (SerialException e) {
            System.err.println("Can't open LabPro USB");
            System.err.println("  " + e.toString());
            if (this.osSerialPort == null) {
                this.osSerialPort = this.devService.getSerialPort("os", this.osSerialPort);
            }
            if (this.port != this.osSerialPort && this.port != null) {
                try {
                    this.port.close();
                    this.port = this.osSerialPort;
                }
                catch (SerialException e2) {
                    e2.printStackTrace();
                }
            }
            return super.openAutoPort();
        }
    }

    public void log(String message) {
        super.log(message);
    }

    protected boolean hasNonAutoIdSensors() {
        return true;
    }

    public boolean canDetectSensors() {
        return true;
    }

    public String getVendorName() {
        return "Vernier";
    }

    public String getDeviceName() {
        return "LabPro";
    }
}

