/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.applet;

import java.applet.Applet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import org.concord.sensor.ExperimentConfig;
import org.concord.sensor.SensorConfig;
import org.json.JSONStringer;
import org.json.JSONWriter;

public class JavascriptDataBridge {
    private JSObject window;
    private String handlerPath;
    private ScheduledExecutorService jsBridgeExecutor;

    public JavascriptDataBridge(String javascriptObjectPath, Applet applet) {
        this.window = JSObject.getWindow((Applet)applet);
        this.handlerPath = javascriptObjectPath;
        this.jsBridgeExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    public void notifyDeviceUnplugged() {
        this.jsBridgeExecutor.schedule(new Runnable(){

            public void run() {
                System.err.println("Notifying device was unplugged.");
                JavascriptDataBridge.this.window.eval(JavascriptDataBridge.this.handlerPath + ".deviceUnplugged()");
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    public void notifySensorUnplugged() {
        this.jsBridgeExecutor.schedule(new Runnable(){

            public void run() {
                System.err.println("Notifying sensor was unplugged.");
                JavascriptDataBridge.this.window.eval(JavascriptDataBridge.this.handlerPath + ".sensorUnplugged()");
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    public void initSensorInterfaceComplete(boolean booleanValue) {
        this.handleCallback("\"initSensorInterfaceComplete\"", new String[]{Boolean.toString(booleanValue)});
    }

    public void handleData(final int numSamples, final int numSensors, final float[] data) {
        this.jsBridgeExecutor.schedule(new Runnable(){

            public void run() {
                String evalString = JavascriptDataBridge.this.getJsEventCall(numSamples, numSensors, data);
                try {
                    JavascriptDataBridge.this.window.eval(evalString);
                }
                catch (JSException e) {
                    System.err.println("Javascript error: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    private String getJsEventCall(int numSamples, int numSensors, float[] data) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.handlerPath);
        buf.append(".dataReceived(");
        buf.append(1000);
        buf.append(", " + numSamples);
        buf.append(", " + this.arrayAsString(data, numSamples, numSensors));
        buf.append(");");
        return buf.toString();
    }

    private String arrayAsString(float[] arr, int numSamples, int numSensors) {
        if (arr == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int last = numSamples * numSensors;
        for (int i = 0; i < last; ++i) {
            buf.append(arr[i]);
            if (i == last - 1) continue;
            buf.append(",");
        }
        buf.append("]");
        return buf.toString();
    }

    public void destroy() {
        this.jsBridgeExecutor.shutdownNow();
    }

    public String asArgs(float[] arr) {
        return this.arrayAsString(arr, arr.length, 1);
    }

    public void handleCallback(final String idx, final String[] args) {
        this.jsBridgeExecutor.schedule(new Runnable(){

            public void run() {
                StringBuffer buf = new StringBuffer();
                buf.append(JavascriptDataBridge.this.handlerPath);
                buf.append(".handleCallback(");
                buf.append(idx);
                if (args != null && args.length > 0) {
                    buf.append(", [");
                    for (int i = 0; i < args.length; ++i) {
                        buf.append(args[i]);
                        if (i == args.length - 1) continue;
                        buf.append(",");
                    }
                    buf.append("]");
                }
                buf.append(");");
                try {
                    JavascriptDataBridge.this.window.eval(buf.toString());
                }
                catch (JSException e) {
                    System.err.println("Javascript error: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    public static JSONWriter toJSON(ExperimentConfig config) {
        JSONStringer writer = new JSONStringer();
        writer.object();
        writer.key("valid").value(config.isValid());
        writer.key("invalidReason").value(config.getInvalidReason());
        writer.key("period").value(config.getPeriod());
        writer.key("exactPeriod").value(config.getExactPeriod());
        writer.key("dataReadPeriod").value(config.getDataReadPeriod());
        writer.key("deviceName").value(config.getDeviceName());
        writer.key("sensorConfigs").array();
        for (SensorConfig cfg : config.getSensorConfigs()) {
            JavascriptDataBridge.toJSON(cfg, writer);
        }
        writer.endArray();
        writer.endObject();
        return writer;
    }

    public static JSONWriter toJSON(SensorConfig config) {
        JSONStringer writer = new JSONStringer();
        JavascriptDataBridge.toJSON(config, writer);
        return writer;
    }

    public static JSONWriter toJSON(SensorConfig config, JSONWriter writer) {
        writer.object();
        writer.key("confirmed").value(config.isConfirmed());
        writer.key("type").value(config.getType());
        writer.key("stepSize").value(config.getStepSize());
        writer.key("port").value(config.getPort());
        writer.key("portName").value(config.getPortName());
        writer.key("name").value(config.getName());
        writer.key("unit").value(config.getUnit());
        writer.endObject();
        return writer;
    }

    public static JSONWriter toJSON(SensorConfig[] configs) {
        JSONStringer writer = new JSONStringer();
        writer.array();
        for (SensorConfig cfg : configs) {
            JavascriptDataBridge.toJSON(cfg, writer);
        }
        writer.endArray();
        return writer;
    }
}

