/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.serial;

import org.concord.sensor.device.DeviceService;

public class ByteBufferStream {
    byte[] inBuf;
    int offset;
    int endOffset;
    boolean lowNibble = false;
    DeviceService devService;

    public static final int readUShort(byte[] inBuf, int offset) {
        int value = (inBuf[offset] & 0xFF) << 8 | inBuf[offset + 1] & 0xFF;
        return value;
    }

    public static final short readShort(byte[] inBuf, int offset) {
        int value = inBuf[offset] << 8 | inBuf[offset + 1] & 0xFF;
        return (short)value;
    }

    public static final long readULong(byte[] inBuf, int offset) {
        long value = ((long)inBuf[offset++] & 0xFFL) << 24 | (long)((inBuf[offset++] & 0xFF) << 16) | (long)((inBuf[offset++] & 0xFF) << 8) | (long)(inBuf[offset] & 0xFF);
        return value;
    }

    public static final void writeULong(long value, byte[] buf, int offset) {
        buf[offset] = (byte)((value & 0xFFFFFFFFFF000000L) >> 24);
        buf[offset + 1] = (byte)((value & 0xFF0000L) >> 16);
        buf[offset + 2] = (byte)((value & 0xFF00L) >> 8);
        buf[offset + 3] = (byte)(value & 0xFFL);
    }

    public static final void writeUShort(int value, byte[] buf, int offset) {
        buf[offset] = (byte)((value & 0xFF00) >> 8);
        buf[offset + 1] = (byte)(value & 0xFF);
    }

    public static final void writeUByte(int value, byte[] buf, int offset) {
        buf[offset] = (byte)(value & 0xFF);
    }

    public ByteBufferStream(byte[] buffer, int offset, int length, DeviceService devService) {
        this.inBuf = buffer;
        this.offset = offset;
        this.endOffset = offset + length;
        this.devService = devService;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public float readFloat() {
        if (this.lowNibble) {
            throw new RuntimeException("unread low nibble");
        }
        int valueInt = (0xFF & this.inBuf[this.offset]) << 24 | (0xFF & this.inBuf[this.offset + 1]) << 16 | (0xFF & this.inBuf[this.offset + 2]) << 8 | 0xFF & this.inBuf[this.offset + 3];
        float value = this.devService.intBitsToFloat(valueInt);
        this.offset += 4;
        return value;
    }

    public int readUShort() {
        if (this.lowNibble) {
            throw new RuntimeException("unread low nibble");
        }
        int value = ByteBufferStream.readUShort(this.inBuf, this.offset);
        this.offset += 2;
        return value;
    }

    public int readUByte() {
        if (this.lowNibble) {
            throw new RuntimeException("unread low nibble");
        }
        int value = this.inBuf[this.offset] & 0xFF;
        ++this.offset;
        return value;
    }

    public int readUNibble() {
        int value;
        if (this.lowNibble) {
            value = this.inBuf[this.offset] & 0xF;
            ++this.offset;
            this.lowNibble = false;
        } else {
            value = (this.inBuf[this.offset] & 0xF0) >> 4;
            this.lowNibble = true;
        }
        return value;
    }

    public String readCRTermString() {
        byte currChar;
        if (this.lowNibble) {
            throw new RuntimeException("unread low nibble");
        }
        String returnStr = "";
        while (this.offset < this.endOffset && (currChar = this.inBuf[this.offset++]) != 13) {
            returnStr = returnStr + (char)currChar;
        }
        return returnStr;
    }

    public void writeULong(long value) {
        ByteBufferStream.writeULong(value, this.inBuf, this.offset);
        this.offset += 4;
    }

    public void writeUShort(int value) {
        ByteBufferStream.writeUShort(value, this.inBuf, this.offset);
        this.offset += 2;
    }

    public void writeUByte(int value) {
        ByteBufferStream.writeUByte(value, this.inBuf, this.offset);
        ++this.offset;
    }

    public static String printBytesHex(int numBytes, byte[] buf) {
        String result = "";
        for (int i = 0; i < numBytes; ++i) {
            result = result + Integer.toString(buf[i] & 0xFF, 16) + " ";
        }
        return result;
    }

    public static String printBytesChar(int numBytes, byte[] buf) {
        String result = "";
        for (int i = 0; i < numBytes; ++i) {
            int charInt = buf[i] & 0xFF;
            result = charInt > 32 && charInt < 128 ? result + (char)buf[i] + "  " : result + "   ";
        }
        return result;
    }
}

