(function() {
/**
 * almond 0.2.5 Copyright (c) 2011-2012, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/jrburke/almond for details
 */
//Going sloppy to avoid 'use strict' string cost, but strict practices should
//be followed.
/*jslint sloppy: true */
/*global setTimeout: false */

var requirejs, require, define;
(function (undef) {
    var main, req, makeMap, handlers,
        defined = {},
        waiting = {},
        config = {},
        defining = {},
        hasOwn = Object.prototype.hasOwnProperty,
        aps = [].slice;

    function hasProp(obj, prop) {
        return hasOwn.call(obj, prop);
    }

    /**
     * Given a relative module name, like ./something, normalize it to
     * a real name that can be mapped to a path.
     * @param {String} name the relative name
     * @param {String} baseName a real name that the name arg is relative
     * to.
     * @returns {String} normalized name
     */
    function normalize(name, baseName) {
        var nameParts, nameSegment, mapValue, foundMap,
            foundI, foundStarMap, starI, i, j, part,
            baseParts = baseName && baseName.split("/"),
            map = config.map,
            starMap = (map && map['*']) || {};

        //Adjust any relative paths.
        if (name && name.charAt(0) === ".") {
            //If have a base name, try to normalize against it,
            //otherwise, assume it is a top-level require that will
            //be relative to baseUrl in the end.
            if (baseName) {
                //Convert baseName to array, and lop off the last part,
                //so that . matches that "directory" and not name of the baseName's
                //module. For instance, baseName of "one/two/three", maps to
                //"one/two/three.js", but we want the directory, "one/two" for
                //this normalization.
                baseParts = baseParts.slice(0, baseParts.length - 1);

                name = baseParts.concat(name.split("/"));

                //start trimDots
                for (i = 0; i < name.length; i += 1) {
                    part = name[i];
                    if (part === ".") {
                        name.splice(i, 1);
                        i -= 1;
                    } else if (part === "..") {
                        if (i === 1 && (name[2] === '..' || name[0] === '..')) {
                            //End of the line. Keep at least one non-dot
                            //path segment at the front so it can be mapped
                            //correctly to disk. Otherwise, there is likely
                            //no path mapping for a path starting with '..'.
                            //This can still fail, but catches the most reasonable
                            //uses of ..
                            break;
                        } else if (i > 0) {
                            name.splice(i - 1, 2);
                            i -= 2;
                        }
                    }
                }
                //end trimDots

                name = name.join("/");
            } else if (name.indexOf('./') === 0) {
                // No baseName, so this is ID is resolved relative
                // to baseUrl, pull off the leading dot.
                name = name.substring(2);
            }
        }

        //Apply map config if available.
        if ((baseParts || starMap) && map) {
            nameParts = name.split('/');

            for (i = nameParts.length; i > 0; i -= 1) {
                nameSegment = nameParts.slice(0, i).join("/");

                if (baseParts) {
                    //Find the longest baseName segment match in the config.
                    //So, do joins on the biggest to smallest lengths of baseParts.
                    for (j = baseParts.length; j > 0; j -= 1) {
                        mapValue = map[baseParts.slice(0, j).join('/')];

                        //baseName segment has  config, find if it has one for
                        //this name.
                        if (mapValue) {
                            mapValue = mapValue[nameSegment];
                            if (mapValue) {
                                //Match, update name to the new value.
                                foundMap = mapValue;
                                foundI = i;
                                break;
                            }
                        }
                    }
                }

                if (foundMap) {
                    break;
                }

                //Check for a star map match, but just hold on to it,
                //if there is a shorter segment match later in a matching
                //config, then favor over this star map.
                if (!foundStarMap && starMap && starMap[nameSegment]) {
                    foundStarMap = starMap[nameSegment];
                    starI = i;
                }
            }

            if (!foundMap && foundStarMap) {
                foundMap = foundStarMap;
                foundI = starI;
            }

            if (foundMap) {
                nameParts.splice(0, foundI, foundMap);
                name = nameParts.join('/');
            }
        }

        return name;
    }

    function makeRequire(relName, forceSync) {
        return function () {
            //A version of a require function that passes a moduleName
            //value for items that may need to
            //look up paths relative to the moduleName
            return req.apply(undef, aps.call(arguments, 0).concat([relName, forceSync]));
        };
    }

    function makeNormalize(relName) {
        return function (name) {
            return normalize(name, relName);
        };
    }

    function makeLoad(depName) {
        return function (value) {
            defined[depName] = value;
        };
    }

    function callDep(name) {
        if (hasProp(waiting, name)) {
            var args = waiting[name];
            delete waiting[name];
            defining[name] = true;
            main.apply(undef, args);
        }

        if (!hasProp(defined, name) && !hasProp(defining, name)) {
            throw new Error('No ' + name);
        }
        return defined[name];
    }

    //Turns a plugin!resource to [plugin, resource]
    //with the plugin being undefined if the name
    //did not have a plugin prefix.
    function splitPrefix(name) {
        var prefix,
            index = name ? name.indexOf('!') : -1;
        if (index > -1) {
            prefix = name.substring(0, index);
            name = name.substring(index + 1, name.length);
        }
        return [prefix, name];
    }

    /**
     * Makes a name map, normalizing the name, and using a plugin
     * for normalization if necessary. Grabs a ref to plugin
     * too, as an optimization.
     */
    makeMap = function (name, relName) {
        var plugin,
            parts = splitPrefix(name),
            prefix = parts[0];

        name = parts[1];

        if (prefix) {
            prefix = normalize(prefix, relName);
            plugin = callDep(prefix);
        }

        //Normalize according
        if (prefix) {
            if (plugin && plugin.normalize) {
                name = plugin.normalize(name, makeNormalize(relName));
            } else {
                name = normalize(name, relName);
            }
        } else {
            name = normalize(name, relName);
            parts = splitPrefix(name);
            prefix = parts[0];
            name = parts[1];
            if (prefix) {
                plugin = callDep(prefix);
            }
        }

        //Using ridiculous property names for space reasons
        return {
            f: prefix ? prefix + '!' + name : name, //fullName
            n: name,
            pr: prefix,
            p: plugin
        };
    };

    function makeConfig(name) {
        return function () {
            return (config && config.config && config.config[name]) || {};
        };
    }

    handlers = {
        require: function (name) {
            return makeRequire(name);
        },
        exports: function (name) {
            var e = defined[name];
            if (typeof e !== 'undefined') {
                return e;
            } else {
                return (defined[name] = {});
            }
        },
        module: function (name) {
            return {
                id: name,
                uri: '',
                exports: defined[name],
                config: makeConfig(name)
            };
        }
    };

    main = function (name, deps, callback, relName) {
        var cjsModule, depName, ret, map, i,
            args = [],
            usingExports;

        //Use name if no relName
        relName = relName || name;

        //Call the callback to define the module, if necessary.
        if (typeof callback === 'function') {

            //Pull out the defined dependencies and pass the ordered
            //values to the callback.
            //Default to [require, exports, module] if no deps
            deps = !deps.length && callback.length ? ['require', 'exports', 'module'] : deps;
            for (i = 0; i < deps.length; i += 1) {
                map = makeMap(deps[i], relName);
                depName = map.f;

                //Fast path CommonJS standard dependencies.
                if (depName === "require") {
                    args[i] = handlers.require(name);
                } else if (depName === "exports") {
                    //CommonJS module spec 1.1
                    args[i] = handlers.exports(name);
                    usingExports = true;
                } else if (depName === "module") {
                    //CommonJS module spec 1.1
                    cjsModule = args[i] = handlers.module(name);
                } else if (hasProp(defined, depName) ||
                           hasProp(waiting, depName) ||
                           hasProp(defining, depName)) {
                    args[i] = callDep(depName);
                } else if (map.p) {
                    map.p.load(map.n, makeRequire(relName, true), makeLoad(depName), {});
                    args[i] = defined[depName];
                } else {
                    throw new Error(name + ' missing ' + depName);
                }
            }

            ret = callback.apply(defined[name], args);

            if (name) {
                //If setting exports via "module" is in play,
                //favor that over return value and exports. After that,
                //favor a non-undefined return value over exports use.
                if (cjsModule && cjsModule.exports !== undef &&
                        cjsModule.exports !== defined[name]) {
                    defined[name] = cjsModule.exports;
                } else if (ret !== undef || !usingExports) {
                    //Use the return value from the function.
                    defined[name] = ret;
                }
            }
        } else if (name) {
            //May just be an object definition for the module. Only
            //worry about defining if have a module name.
            defined[name] = callback;
        }
    };

    requirejs = require = req = function (deps, callback, relName, forceSync, alt) {
        if (typeof deps === "string") {
            if (handlers[deps]) {
                //callback in this case is really relName
                return handlers[deps](callback);
            }
            //Just return the module wanted. In this scenario, the
            //deps arg is the module name, and second arg (if passed)
            //is just the relName.
            //Normalize module name, if it contains . or ..
            return callDep(makeMap(deps, callback).f);
        } else if (!deps.splice) {
            //deps is a config object, not an array.
            config = deps;
            if (callback.splice) {
                //callback is an array, which means it is a dependency list.
                //Adjust args if there are dependencies
                deps = callback;
                callback = relName;
                relName = null;
            } else {
                deps = undef;
            }
        }

        //Support require(['a'])
        callback = callback || function () {};

        //If relName is a function, it is an errback handler,
        //so remove it.
        if (typeof relName === 'function') {
            relName = forceSync;
            forceSync = alt;
        }

        //Simulate async callback;
        if (forceSync) {
            main(undef, deps, callback, relName);
        } else {
            //Using a non-zero value because of concern for what old browsers
            //do, and latest browsers "upgrade" to 4 if lower value is used:
            //http://www.whatwg.org/specs/web-apps/current-work/multipage/timers.html#dom-windowtimers-settimeout:
            //If want a value immediately, use require('id') instead -- something
            //that works in almond on the global level, but not guaranteed and
            //unlikely to work in other AMD implementations.
            setTimeout(function () {
                main(undef, deps, callback, relName);
            }, 4);
        }

        return req;
    };

    /**
     * Just drops the config on the floor, but returns req in case
     * the config return value is used.
     */
    req.config = function (cfg) {
        config = cfg;
        if (config.deps) {
            req(config.deps, config.callback);
        }
        return req;
    };

    define = function (name, deps, callback) {

        //This module may not have dependencies
        if (!deps.splice) {
            //deps is not an array, so probably means
            //an object literal or factory function for
            //the value. Adjust args.
            callback = deps;
            deps = [];
        }

        if (!hasProp(defined, name) && !hasProp(waiting, name)) {
            waiting[name] = [name, deps, callback];
        }
    };

    define.amd = {
        jQuery: true
    };
}());

define("../../vendor/almond/almond", function(){});

// this file is generated during build process by: ./script/generate-js-version.rb
define('lab.version',['require'],function (require) {
  return {
    "repo": {
      "branch": "1.15.1",
      "commit": {
        "sha":           "6cba5c44bff259232acf736609be043573f068be",
        "short_sha":     "6cba5c44",
        "url":           "https://github.com/concord-consortium/lab/commit/6cba5c44",
        "author":        "pjanik",
        "email":         "janikpiotrek@gmail.com",
        "date":          "2017-12-11 18:44:11 +0000",
        "short_message": "Fix DNA Dialog styles",
        "message":       "Fix DNA Dialog styles\n\n[#151683925]"
      },
      "last_tag":        "1.15.1",
      "dirty": false
    }
  };
});

define('lab.config',[],function () {
  return {
    "sharing": true,
    "logging": false,
    "tracing": false,
    // Set homeForSharing to the host where shared Interactives are found
    // if you don't want to share the ones on the actual server.
    // Example if you host the Interactives on a static S3 site and want the
    // sharing links to point to the same Interactives at http://lab.concord.org
    "homeForSharing": "",
    "homeEmbeddablePath": "/embeddable.html",
    // Root URL of Lab distribution, used to get Lab resources (e.g. DNA images).
    "rootUrl": "lab",
    // Models root URL, appended to all model paths. Leave it empty if model paths are relative
    // to page that contains Lab interactive.
    "modelsRootUrl": "",
    // Set codap to true if Lab is running inside of CODAP
    "codap": false,
    // dataGamesProxyPrefix was the old way of configuring CODAP
    "dataGamesProxyPrefix": "",
    "utmCampaign": null,
    // You can set versioned home to function that accepts major version of Lab and returns
    // URL of embeddable page that uses particular version of Lab, e.g.:
    // Lab.config.versionedHome = function (version) {
    //    return "http://some.domain.com/lab/embeddable-" + version + ".html";
    // }
    // When Lab receives 'getLearnerUrl' messaga via iframe phone, it will respond providing
    // return value of this function.
    "versionedHome": null
  };
});

// seedrandom.js version 2.2.
// Author: David Bau
// Date: 2013 Jun 15
//
// Defines a method Math.seedrandom() that, when called, substitutes
// an explicitly seeded RC4-based algorithm for Math.random().  Also
// supports automatic seeding from local or network sources of entropy.
//
// http://davidbau.com/encode/seedrandom.js
// http://davidbau.com/encode/seedrandom-min.js
//
// Usage:
//
//   <script src=http://davidbau.com/encode/seedrandom-min.js></script>
//
//   Math.seedrandom('yay.');  Sets Math.random to a function that is
//                             initialized using the given explicit seed.
//
//   Math.seedrandom();        Sets Math.random to a function that is
//                             seeded using the current time, dom state,
//                             and other accumulated local entropy.
//                             The generated seed string is returned.
//
//   Math.seedrandom('yowza.', true);
//                             Seeds using the given explicit seed mixed
//                             together with accumulated entropy.
//
//   <script src="https://jsonlib.appspot.com/urandom?callback=Math.seedrandom">
//   </script>                 Seeds using urandom bits from a server.
//
// More advanced examples:
//
//   Math.seedrandom("hello.");           // Use "hello." as the seed.
//   document.write(Math.random());       // Always 0.9282578795792454
//   document.write(Math.random());       // Always 0.3752569768646784
//   var rng1 = Math.random;              // Remember the current prng.
//
//   var autoseed = Math.seedrandom();    // New prng with an automatic seed.
//   document.write(Math.random());       // Pretty much unpredictable x.
//
//   Math.random = rng1;                  // Continue "hello." prng sequence.
//   document.write(Math.random());       // Always 0.7316977468919549
//
//   Math.seedrandom(autoseed);           // Restart at the previous seed.
//   document.write(Math.random());       // Repeat the 'unpredictable' x.
//
//   function reseed(event, count) {      // Define a custom entropy collector.
//     var t = [];
//     function w(e) {
//       t.push([e.pageX, e.pageY, +new Date]);
//       if (t.length < count) { return; }
//       document.removeEventListener(event, w);
//       Math.seedrandom(t, true);        // Mix in any previous entropy.
//     }
//     document.addEventListener(event, w);
//   }
//   reseed('mousemove', 100);            // Reseed after 100 mouse moves.
//
// Version notes:
//
// The random number sequence is the same as version 1.0 for string seeds.
// Version 2.0 changed the sequence for non-string seeds.
// Version 2.1 speeds seeding and uses window.crypto to autoseed if present.
// Version 2.2 alters non-crypto autoseeding to sweep up entropy from plugins.
//
// The standard ARC4 key scheduler cycles short keys, which means that
// seedrandom('ab') is equivalent to seedrandom('abab') and 'ababab'.
// Therefore it is a good idea to add a terminator to avoid trivial
// equivalences on short string seeds, e.g., Math.seedrandom(str + '\0').
// Starting with version 2.0, a terminator is added automatically for
// non-string seeds, so seeding with the number 111 is the same as seeding
// with '111\0'.
//
// When seedrandom() is called with zero args, it uses a seed
// drawn from the browser crypto object if present.  If there is no
// crypto support, seedrandom() uses the current time, the native rng,
// and a walk of several DOM objects to collect a few bits of entropy.
//
// Each time the one- or two-argument forms of seedrandom are called,
// entropy from the passed seed is accumulated in a pool to help generate
// future seeds for the zero- and two-argument forms of seedrandom.
//
// On speed - This javascript implementation of Math.random() is about
// 3-10x slower than the built-in Math.random() because it is not native
// code, but that is typically fast enough.  Some details (timings on
// Chrome 25 on a 2010 vintage macbook):
//
// seeded Math.random()          - avg less than 0.0002 milliseconds per call
// seedrandom('explicit.')       - avg less than 0.2 milliseconds per call
// seedrandom('explicit.', true) - avg less than 0.2 milliseconds per call
// seedrandom() with crypto      - avg less than 0.2 milliseconds per call
//
// Autoseeding without crypto is somewhat slower, about 20-30 milliseconds on
// a 2012 windows 7 1.5ghz i5 laptop, as seen on Firefox 19, IE 10, and Opera.
// Seeded rng calls themselves are fast across these browsers, with slowest
// numbers on Opera at about 0.0005 ms per seeded Math.random().
//
// LICENSE (BSD):
//
// Copyright 2013 David Bau, all rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   1. Redistributions of source code must retain the above copyright
//      notice, this list of conditions and the following disclaimer.
//
//   2. Redistributions in binary form must reproduce the above copyright
//      notice, this list of conditions and the following disclaimer in the
//      documentation and/or other materials provided with the distribution.
//
//   3. Neither the name of this module nor the names of its contributors may
//      be used to endorse or promote products derived from this software
//      without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
/**
 * All code is in an anonymous closure to keep the global namespace clean.
 */
(function (
    global, pool, math, width, chunks, digits) {

//
// The following constants are related to IEEE 754 limits.
//
var startdenom = math.pow(width, chunks),
    significance = math.pow(2, digits),
    overflow = significance * 2,
    mask = width - 1;

//
// seedrandom()
// This is the seedrandom function described above.
//
math['seedrandom'] = function(seed, use_entropy) {
  var key = [];

  // Flatten the seed string or build one from local entropy if needed.
  var shortseed = mixkey(flatten(
    use_entropy ? [seed, tostring(pool)] :
    0 in arguments ? seed : autoseed(), 3), key);

  // Use the seed to initialize an ARC4 generator.
  var arc4 = new ARC4(key);

  // Mix the randomness into accumulated entropy.
  mixkey(tostring(arc4.S), pool);

  // Override Math.random

  // This function returns a random double in [0, 1) that contains
  // randomness in every bit of the mantissa of the IEEE 754 value.

  math['random'] = function() {         // Closure to return a random double:
    var n = arc4.g(chunks),             // Start with a numerator n < 2 ^ 48
        d = startdenom,                 //   and denominator d = 2 ^ 48.
        x = 0;                          //   and no 'extra last byte'.
    while (n < significance) {          // Fill up all significant digits by
      n = (n + x) * width;              //   shifting numerator and
      d *= width;                       //   denominator and generating a
      x = arc4.g(1);                    //   new least-significant-byte.
    }
    while (n >= overflow) {             // To avoid rounding up, before adding
      n /= 2;                           //   last byte, shift everything
      d /= 2;                           //   right using integer math until
      x >>>= 1;                         //   we have exactly the desired bits.
    }
    return (n + x) / d;                 // Form the number within [0, 1).
  };

  // Return the seed that was used
  return shortseed;
};

//
// ARC4
//
// An ARC4 implementation.  The constructor takes a key in the form of
// an array of at most (width) integers that should be 0 <= x < (width).
//
// The g(count) method returns a pseudorandom integer that concatenates
// the next (count) outputs from ARC4.  Its return value is a number x
// that is in the range 0 <= x < (width ^ count).
//
/** @constructor */
function ARC4(key) {
  var t, keylen = key.length,
      me = this, i = 0, j = me.i = me.j = 0, s = me.S = [];

  // The empty key [] is treated as [0].
  if (!keylen) { key = [keylen++]; }

  // Set up S using the standard key scheduling algorithm.
  while (i < width) {
    s[i] = i++;
  }
  for (i = 0; i < width; i++) {
    s[i] = s[j = mask & (j + key[i % keylen] + (t = s[i]))];
    s[j] = t;
  }

  // The "g" method returns the next (count) outputs as one number.
  (me.g = function(count) {
    // Using instance members instead of closure state nearly doubles speed.
    var t, r = 0,
        i = me.i, j = me.j, s = me.S;
    while (count--) {
      t = s[i = mask & (i + 1)];
      r = r * width + s[mask & ((s[i] = s[j = mask & (j + t)]) + (s[j] = t))];
    }
    me.i = i; me.j = j;
    return r;
    // For robust unpredictability discard an initial batch of values.
    // See http://www.rsa.com/rsalabs/node.asp?id=2009
  })(width);
}

//
// flatten()
// Converts an object tree to nested arrays of strings.
//
function flatten(obj, depth) {
  var result = [], typ = (typeof obj)[0], prop;
  if (depth && typ == 'o') {
    for (prop in obj) {
      try { result.push(flatten(obj[prop], depth - 1)); } catch (e) {}
    }
  }
  return (result.length ? result : typ == 's' ? obj : obj + '\0');
}

//
// mixkey()
// Mixes a string seed into a key that is an array of integers, and
// returns a shortened string seed that is equivalent to the result key.
//
function mixkey(seed, key) {
  var stringseed = seed + '', smear, j = 0;
  while (j < stringseed.length) {
    key[mask & j] =
      mask & ((smear ^= key[mask & j] * 19) + stringseed.charCodeAt(j++));
  }
  return tostring(key);
}

//
// autoseed()
// Returns an object for autoseeding, using window.crypto if available.
//
/** @param {Uint8Array=} seed */
function autoseed(seed) {
  try {
    global.crypto.getRandomValues(seed = new Uint8Array(width));
    return tostring(seed);
  } catch (e) {
    return [+new Date, global, global.navigator.plugins,
            global.screen, tostring(pool)];
  }
}

//
// tostring()
// Converts an array of charcodes to a string
//
function tostring(a) {
  return String.fromCharCode.apply(0, a);
}

//
// When seedrandom.js is loaded, we immediately mix a few bits
// from the built-in RNG into the entropy pool.  Because we do
// not want to intefere with determinstic PRNG state later,
// seedrandom will not call math.random on its own again after
// initialization.
//
mixkey(math.random(), pool);

// End anonymous scope, and pass initial values.
})(
  this,   // global window object
  [],     // pool: entropy pool starts empty
  Math,   // math: package containing random, pow, and seedrandom
  256,    // width: each RC4 output is 0 <= x < 256
  6,      // chunks: at least six RC4 outputs for each double
  52      // digits: there are 52 significant digits in a double
);

define("seedrandom", function(){});

/*global window Uint8Array Uint8ClampedArray Int8Array Uint16Array Int16Array Uint32Array Int32Array Float32Array Float64Array */
/*jshint newcap: false */

// Module can be used both in Node.js environment and in Web browser
// using RequireJS. R.JS Optimizer will strip out this if statement.


define('arrays',['require','exports','module'],function (require, exports, module) {
  var arrays = {};

  arrays.version = '0.0.1';

  arrays.webgl = (typeof window !== 'undefined') && !!window.WebGLRenderingContext;

  arrays.typed = (function() {
    try {
      new Float64Array(0);
      return true;
    } catch(e) {
      return false;
    }
  }());

  // http://www.khronos.org/registry/typedarray/specs/latest/#TYPEDARRAYS
  // regular
  // Uint8Array
  // Uint8ClampedArray
  // Uint16Array
  // Uint32Array
  // Int8Array
  // Int16Array
  // Int32Array
  // Float32Array
  // Float64Array

  arrays.create = function(size, fill, array_type) {
    if (!array_type) {
      if (arrays.webgl || arrays.typed) {
        array_type = "Float32Array";
      } else {
        array_type = "regular";
      }
    }
    if (fill === undefined) {
      fill = 0;
    }
    var a, i;
    if (array_type === "regular") {
      a = new Array(size);
    } else {
      switch(array_type) {
        case "Float64Array":
          a = new Float64Array(size);
          break;
        case "Float32Array":
          a = new Float32Array(size);
          break;
        case "Int32Array":
          a = new Int32Array(size);
          break;
        case "Int16Array":
          a = new Int16Array(size);
          break;
        case "Int8Array":
          a = new Int8Array(size);
          break;
        case "Uint32Array":
          a = new Uint32Array(size);
          break;
        case "Uint16Array":
          a = new Uint16Array(size);
          break;
        case "Uint8Array":
          a = new Uint8Array(size);
          break;
        case "Uint8ClampedArray":
          a = new Uint8ClampedArray(size);
          break;
        default:
          throw new Error("arrays: couldn't understand array type \"" + array_type + "\".");
      }
    }
    arrays.fill(a, fill);
    return a;
  };

  arrays.fill = function(array, value) {
    var i = -1, size = array.length;
    while(++i < size) {
      array[i] = value;
    }
  };

  arrays.constructor_function = function(source) {
    if (source.buffer &&
        source.buffer.__proto__ &&
        source.buffer.__proto__.constructor &&
        Object.prototype.toString.call(source) === "[object Array]") {
      return source.__proto__.constructor;
    }

    switch(source.constructor) {
      case Array:             return Array;
      case Float32Array:      return Float32Array;
      case Uint8Array:        return Uint8Array;
      case Float64Array:      return Float64Array;
      case Int32Array:        return Int32Array;
      case Int16Array:        return Int16Array;
      case Int8Array:         return Int8Array;
      case Uint32Array:       return Uint32Array;
      case Uint16Array:       return Uint16Array;
      case Uint8ClampedArray: return Uint8ClampedArray;
      default:
        throw new Error(
            "arrays.constructor_function: must be an Array or Typed Array: " + "  source: " + source);
            // ", source.constructor: " + source.constructor +
            // ", source.buffer: " + source.buffer +
            // ", source.buffer.slice: " + source.buffer.slice +
            // ", source.buffer.__proto__: " + source.buffer.__proto__ +
            // ", source.buffer.__proto__.constructor: " + source.buffer.__proto__.constructor
      }
  };

  arrays.copy = function(source, dest, num) {
    var len = num !== undefined ? num : source.length,
        i = -1;
    while(++i < len) { dest[i] = source[i]; }
    if (arrays.constructor_function(dest) === Array) dest.length = len;
    return dest;
  };

  arrays.clone = function(source) {
    var i, len = source.length, clone, constructor;
    constructor = arrays.constructor_function(source);
    if (constructor === Array) {
      clone = new constructor(len);
      for (i = 0; i < len; i++) { clone[i] = source[i]; }
      return clone;
    }
    if (source.buffer.slice) {
      clone = new constructor(source.buffer.slice(0));
      return clone;
    }
    clone = new constructor(len);
    for (i = 0; i < len; i++) { clone[i] = source[i]; }
    return clone;
  };

  /** @return true if x is between a and b. */
  // float a, float b, float x
  arrays.between = function(a, b, x) {
    return x < Math.max(a, b) && x > Math.min(a, b);
  };

  // float[] array
  arrays.max = function(array) {
    return Math.max.apply( Math, array );
  };

  // float[] array
  arrays.min = function(array) {
    return Math.min.apply( Math, array );
  };

  // FloatxxArray[] array
  arrays.maxTypedArray = function(array) {
    var test, i,
    max = Number.MIN_VALUE,
    length = array.length;
    for(i = 0; i < length; i++) {
      test = array[i];
      max = test > max ? test : max;
    }
    return max;
  };

  // FloatxxArray[] array
  arrays.minTypedArray = function(array) {
    var test, i,
    min = Number.MAX_VALUE,
    length = array.length;
    for(i = 0; i < length; i++) {
      test = array[i];
      min = test < min ? test : min;
    }
    return min;
  };

  // float[] array
  arrays.maxAnyArray = function(array) {
    try {
      return Math.max.apply( Math, array );
    }
    catch (e) {
      if (e instanceof TypeError) {
        var test, i,
        max = Number.MIN_VALUE,
        length = array.length;
        for(i = 0; i < length; i++) {
          test = array[i];
          max = test > max ? test : max;
        }
        return max;
      }
    }
  };

  // float[] array
  arrays.minAnyArray = function(array) {
    try {
      return Math.min.apply( Math, array );
    }
    catch (e) {
      if (e instanceof TypeError) {
        var test, i,
        min = Number.MAX_VALUE,
        length = array.length;
        for(i = 0; i < length; i++) {
          test = array[i];
          min = test < min ? test : min;
        }
        return min;
      }
    }
  };

  arrays.average = function(array) {
    var i, acc = 0,
    length = array.length;
    for (i = 0; i < length; i++) {
      acc += array[i];
    }
    return acc / length;
  };

  /**
    Create a new array of the same type as 'array' and of length 'newLength', and copies as many
    elements from 'array' to the new array as is possible.

    If 'newLength' is less than 'array.length', and 'array' is  a typed array, we still allocate a
    new, shorter array in order to allow GC to work.

    The returned array should always take the place of the passed-in 'array' in client code, and this
    method should not be counted on to always return a copy. If 'array' is non-typed, we manipulate
    its length instead of copying it. But if 'array' is typed, we cannot increase its size in-place,
    therefore must pas a *new* object reference back to client code.
  */
  arrays.extend = function(array, newLength) {
    var extendedArray,
        Constructor,
        i;

    Constructor = arrays.constructor_function(array);

    if (Constructor === Array) {
      i = array.length;
      array.length = newLength;
      // replicate behavior of typed-arrays by filling with 0
      for(;i < newLength; i++) { array[i] = 0; }
      return array;
    }

    extendedArray = new Constructor(newLength);

    // prevent 'set' method from erroring when array.length > newLength, by using the (no-copy) method
    // 'subarray' to get an array view that is clamped to length = min(array.length, newLength)
    extendedArray.set(array.subarray(0, newLength));

    return extendedArray;
  };

  arrays.remove = function(array, idx) {
    var constructor = arrays.constructor_function(array),
        rest;

    if (constructor !== Array) {
      throw new Error("arrays.remove for typed arrays not implemented yet.");
    }

    rest = array.slice(idx + 1);
    array.length = idx;
    Array.prototype.push.apply(array, rest);

    return array;
  };

  arrays.isArray = function (object) {
    if (object === undefined || object === null) {
      return false;
    }
    switch(Object.prototype.toString.call(object)) {
      case "[object Array]":
      case "[object Float32Array]":
      case "[object Float64Array]":
      case "[object Uint8Array]":
      case "[object Uint16Array]":
      case "[object Uint32Array]":
      case "[object Uint8ClampedArray]":
      case "[object Int8Array]":
      case "[object Int16Array]":
      case "[object Int32Array]":
        return true;
      default:
        return false;
    }
  };

  // publish everything to exports
  for (var key in arrays) {
    if (arrays.hasOwnProperty(key)) exports[key] = arrays[key];
  }
});

/**
 * @preserve FastClick: polyfill to remove click delays on browsers with touch UIs.
 *
 * @version 0.6.11
 * @codingstandard ftlabs-jsv2
 * @copyright The Financial Times Limited [All Rights Reserved]
 * @license MIT License (see LICENSE.txt)
 */

/*jslint browser:true, node:true*/
/*global define, Event, Node*/


/**
 * Instantiate fast-clicking listeners on the specificed layer.
 *
 * @constructor
 * @param {Element} layer The layer to listen on
 */
function FastClick(layer) {
	'use strict';
	var oldOnClick, self = this;


	/**
	 * Whether a click is currently being tracked.
	 *
	 * @type boolean
	 */
	this.trackingClick = false;


	/**
	 * Timestamp for when when click tracking started.
	 *
	 * @type number
	 */
	this.trackingClickStart = 0;


	/**
	 * The element being tracked for a click.
	 *
	 * @type EventTarget
	 */
	this.targetElement = null;


	/**
	 * X-coordinate of touch start event.
	 *
	 * @type number
	 */
	this.touchStartX = 0;


	/**
	 * Y-coordinate of touch start event.
	 *
	 * @type number
	 */
	this.touchStartY = 0;


	/**
	 * ID of the last touch, retrieved from Touch.identifier.
	 *
	 * @type number
	 */
	this.lastTouchIdentifier = 0;


	/**
	 * Touchmove boundary, beyond which a click will be cancelled.
	 *
	 * @type number
	 */
	this.touchBoundary = 10;


	/**
	 * The FastClick layer.
	 *
	 * @type Element
	 */
	this.layer = layer;

	if (!layer || !layer.nodeType) {
		throw new TypeError('Layer must be a document node');
	}

	/** @type function() */
	this.onClick = function() { return FastClick.prototype.onClick.apply(self, arguments); };

	/** @type function() */
	this.onMouse = function() { return FastClick.prototype.onMouse.apply(self, arguments); };

	/** @type function() */
	this.onTouchStart = function() { return FastClick.prototype.onTouchStart.apply(self, arguments); };

	/** @type function() */
	this.onTouchMove = function() { return FastClick.prototype.onTouchMove.apply(self, arguments); };

	/** @type function() */
	this.onTouchEnd = function() { return FastClick.prototype.onTouchEnd.apply(self, arguments); };

	/** @type function() */
	this.onTouchCancel = function() { return FastClick.prototype.onTouchCancel.apply(self, arguments); };

	if (FastClick.notNeeded(layer)) {
		return;
	}

	// Set up event handlers as required
	if (this.deviceIsAndroid) {
		layer.addEventListener('mouseover', this.onMouse, true);
		layer.addEventListener('mousedown', this.onMouse, true);
		layer.addEventListener('mouseup', this.onMouse, true);
	}

	layer.addEventListener('click', this.onClick, true);
	layer.addEventListener('touchstart', this.onTouchStart, false);
	layer.addEventListener('touchmove', this.onTouchMove, false);
	layer.addEventListener('touchend', this.onTouchEnd, false);
	layer.addEventListener('touchcancel', this.onTouchCancel, false);

	// Hack is required for browsers that don't support Event#stopImmediatePropagation (e.g. Android 2)
	// which is how FastClick normally stops click events bubbling to callbacks registered on the FastClick
	// layer when they are cancelled.
	if (!Event.prototype.stopImmediatePropagation) {
		layer.removeEventListener = function(type, callback, capture) {
			var rmv = Node.prototype.removeEventListener;
			if (type === 'click') {
				rmv.call(layer, type, callback.hijacked || callback, capture);
			} else {
				rmv.call(layer, type, callback, capture);
			}
		};

		layer.addEventListener = function(type, callback, capture) {
			var adv = Node.prototype.addEventListener;
			if (type === 'click') {
				adv.call(layer, type, callback.hijacked || (callback.hijacked = function(event) {
					if (!event.propagationStopped) {
						callback(event);
					}
				}), capture);
			} else {
				adv.call(layer, type, callback, capture);
			}
		};
	}

	// If a handler is already declared in the element's onclick attribute, it will be fired before
	// FastClick's onClick handler. Fix this by pulling out the user-defined handler function and
	// adding it as listener.
	if (typeof layer.onclick === 'function') {

		// Android browser on at least 3.2 requires a new reference to the function in layer.onclick
		// - the old one won't work if passed to addEventListener directly.
		oldOnClick = layer.onclick;
		layer.addEventListener('click', function(event) {
			oldOnClick(event);
		}, false);
		layer.onclick = null;
	}
}


/**
 * Android requires exceptions.
 *
 * @type boolean
 */
FastClick.prototype.deviceIsAndroid = navigator.userAgent.indexOf('Android') > 0;


/**
 * iOS requires exceptions.
 *
 * @type boolean
 */
FastClick.prototype.deviceIsIOS = /iP(ad|hone|od)/.test(navigator.userAgent);


/**
 * iOS 4 requires an exception for select elements.
 *
 * @type boolean
 */
FastClick.prototype.deviceIsIOS4 = FastClick.prototype.deviceIsIOS && (/OS 4_\d(_\d)?/).test(navigator.userAgent);


/**
 * iOS 6.0(+?) requires the target element to be manually derived
 *
 * @type boolean
 */
FastClick.prototype.deviceIsIOSWithBadTarget = FastClick.prototype.deviceIsIOS && (/OS ([6-9]|\d{2})_\d/).test(navigator.userAgent);


/**
 * Determine whether a given element requires a native click.
 *
 * @param {EventTarget|Element} target Target DOM element
 * @returns {boolean} Returns true if the element needs a native click
 */
FastClick.prototype.needsClick = function(target) {
	'use strict';
	switch (target.nodeName.toLowerCase()) {

	// Don't send a synthetic click to disabled inputs (issue #62)
	case 'button':
	case 'select':
	case 'textarea':
		if (target.disabled) {
			return true;
		}

		break;
	case 'input':

		// File inputs need real clicks on iOS 6 due to a browser bug (issue #68)
		if ((this.deviceIsIOS && target.type === 'file') || target.disabled) {
			return true;
		}

		break;
	case 'label':
	case 'video':
		return true;
	}

	return (/\bneedsclick\b/).test(target.className);
};


/**
 * Determine whether a given element requires a call to focus to simulate click into element.
 *
 * @param {EventTarget|Element} target Target DOM element
 * @returns {boolean} Returns true if the element requires a call to focus to simulate native click.
 */
FastClick.prototype.needsFocus = function(target) {
	'use strict';
	switch (target.nodeName.toLowerCase()) {
	case 'textarea':
		return true;
	case 'select':
		return !this.deviceIsAndroid;
	case 'input':
		switch (target.type) {
		case 'button':
		case 'checkbox':
		case 'file':
		case 'image':
		case 'radio':
		case 'submit':
			return false;
		}

		// No point in attempting to focus disabled inputs
		return !target.disabled && !target.readOnly;
	default:
		return (/\bneedsfocus\b/).test(target.className);
	}
};


/**
 * Send a click event to the specified element.
 *
 * @param {EventTarget|Element} targetElement
 * @param {Event} event
 */
FastClick.prototype.sendClick = function(targetElement, event) {
	'use strict';
	var clickEvent, touch;

	// On some Android devices activeElement needs to be blurred otherwise the synthetic click will have no effect (#24)
	if (document.activeElement && document.activeElement !== targetElement) {
		document.activeElement.blur();
	}

	touch = event.changedTouches[0];

	// Synthesise a click event, with an extra attribute so it can be tracked
	clickEvent = document.createEvent('MouseEvents');
	clickEvent.initMouseEvent(this.determineEventType(targetElement), true, true, window, 1, touch.screenX, touch.screenY, touch.clientX, touch.clientY, false, false, false, false, 0, null);
	clickEvent.forwardedTouchEvent = true;
	targetElement.dispatchEvent(clickEvent);
};

FastClick.prototype.determineEventType = function(targetElement) {
	'use strict;'

	//Issue #159: Android Chrome Select Box does not open with a synthetic click event
	if (this.deviceIsAndroid && targetElement.tagName.toLowerCase() === 'select') {
		return 'mousedown';
	}

	return 'click';
}


/**
 * @param {EventTarget|Element} targetElement
 */
FastClick.prototype.focus = function(targetElement) {
	'use strict';
	var length;

	// Issue #160: on iOS 7, some input elements (e.g. date datetime) throw a vague TypeError on setSelectionRange. These elements don't have an integer value for the selectionStart and selectionEnd properties, but unfortunately that can't be used for detection because accessing the properties also throws a TypeError. Just check the type instead. Filed as Apple bug #15122724.
	if (this.deviceIsIOS && targetElement.setSelectionRange && targetElement.type.indexOf('date') !== 0 && targetElement.type !== 'time') {
		length = targetElement.value.length;
		targetElement.setSelectionRange(length, length);
	} else {
		targetElement.focus();
	}
};


/**
 * Check whether the given target element is a child of a scrollable layer and if so, set a flag on it.
 *
 * @param {EventTarget|Element} targetElement
 */
FastClick.prototype.updateScrollParent = function(targetElement) {
	'use strict';
	var scrollParent, parentElement;

	scrollParent = targetElement.fastClickScrollParent;

	// Attempt to discover whether the target element is contained within a scrollable layer. Re-check if the
	// target element was moved to another parent.
	if (!scrollParent || !scrollParent.contains(targetElement)) {
		parentElement = targetElement;
		do {
			if (parentElement.scrollHeight > parentElement.offsetHeight) {
				scrollParent = parentElement;
				targetElement.fastClickScrollParent = parentElement;
				break;
			}

			parentElement = parentElement.parentElement;
		} while (parentElement);
	}

	// Always update the scroll top tracker if possible.
	if (scrollParent) {
		scrollParent.fastClickLastScrollTop = scrollParent.scrollTop;
	}
};


/**
 * @param {EventTarget} targetElement
 * @returns {Element|EventTarget}
 */
FastClick.prototype.getTargetElementFromEventTarget = function(eventTarget) {
	'use strict';

	// On some older browsers (notably Safari on iOS 4.1 - see issue #56) the event target may be a text node.
	if (eventTarget.nodeType === Node.TEXT_NODE) {
		return eventTarget.parentNode;
	}

	return eventTarget;
};


/**
 * On touch start, record the position and scroll offset.
 *
 * @param {Event} event
 * @returns {boolean}
 */
FastClick.prototype.onTouchStart = function(event) {
	'use strict';
	var targetElement, touch, selection;

	// Ignore multiple touches, otherwise pinch-to-zoom is prevented if both fingers are on the FastClick element (issue #111).
	if (event.targetTouches.length > 1) {
		return true;
	}

	targetElement = this.getTargetElementFromEventTarget(event.target);
	touch = event.targetTouches[0];

	if (this.deviceIsIOS) {

		// Only trusted events will deselect text on iOS (issue #49)
		selection = window.getSelection();
		if (selection.rangeCount && !selection.isCollapsed) {
			return true;
		}

		if (!this.deviceIsIOS4) {

			// Weird things happen on iOS when an alert or confirm dialog is opened from a click event callback (issue #23):
			// when the user next taps anywhere else on the page, new touchstart and touchend events are dispatched
			// with the same identifier as the touch event that previously triggered the click that triggered the alert.
			// Sadly, there is an issue on iOS 4 that causes some normal touch events to have the same identifier as an
			// immediately preceeding touch event (issue #52), so this fix is unavailable on that platform.
			if (touch.identifier === this.lastTouchIdentifier) {
				event.preventDefault();
				return false;
			}

			this.lastTouchIdentifier = touch.identifier;

			// If the target element is a child of a scrollable layer (using -webkit-overflow-scrolling: touch) and:
			// 1) the user does a fling scroll on the scrollable layer
			// 2) the user stops the fling scroll with another tap
			// then the event.target of the last 'touchend' event will be the element that was under the user's finger
			// when the fling scroll was started, causing FastClick to send a click event to that layer - unless a check
			// is made to ensure that a parent layer was not scrolled before sending a synthetic click (issue #42).
			this.updateScrollParent(targetElement);
		}
	}

	this.trackingClick = true;
	this.trackingClickStart = event.timeStamp;
	this.targetElement = targetElement;

	this.touchStartX = touch.pageX;
	this.touchStartY = touch.pageY;

	// Prevent phantom clicks on fast double-tap (issue #36)
	if ((event.timeStamp - this.lastClickTime) < 200) {
		event.preventDefault();
	}

	return true;
};


/**
 * Based on a touchmove event object, check whether the touch has moved past a boundary since it started.
 *
 * @param {Event} event
 * @returns {boolean}
 */
FastClick.prototype.touchHasMoved = function(event) {
	'use strict';
	var touch = event.changedTouches[0], boundary = this.touchBoundary;

	if (Math.abs(touch.pageX - this.touchStartX) > boundary || Math.abs(touch.pageY - this.touchStartY) > boundary) {
		return true;
	}

	return false;
};


/**
 * Update the last position.
 *
 * @param {Event} event
 * @returns {boolean}
 */
FastClick.prototype.onTouchMove = function(event) {
	'use strict';
	if (!this.trackingClick) {
		return true;
	}

	// If the touch has moved, cancel the click tracking
	if (this.targetElement !== this.getTargetElementFromEventTarget(event.target) || this.touchHasMoved(event)) {
		this.trackingClick = false;
		this.targetElement = null;
	}

	return true;
};


/**
 * Attempt to find the labelled control for the given label element.
 *
 * @param {EventTarget|HTMLLabelElement} labelElement
 * @returns {Element|null}
 */
FastClick.prototype.findControl = function(labelElement) {
	'use strict';

	// Fast path for newer browsers supporting the HTML5 control attribute
	if (labelElement.control !== undefined) {
		return labelElement.control;
	}

	// All browsers under test that support touch events also support the HTML5 htmlFor attribute
	if (labelElement.htmlFor) {
		return document.getElementById(labelElement.htmlFor);
	}

	// If no for attribute exists, attempt to retrieve the first labellable descendant element
	// the list of which is defined here: http://www.w3.org/TR/html5/forms.html#category-label
	return labelElement.querySelector('button, input:not([type=hidden]), keygen, meter, output, progress, select, textarea');
};


/**
 * On touch end, determine whether to send a click event at once.
 *
 * @param {Event} event
 * @returns {boolean}
 */
FastClick.prototype.onTouchEnd = function(event) {
	'use strict';
	var forElement, trackingClickStart, targetTagName, scrollParent, touch, targetElement = this.targetElement;

	if (!this.trackingClick) {
		return true;
	}

	// Prevent phantom clicks on fast double-tap (issue #36)
	if ((event.timeStamp - this.lastClickTime) < 200) {
		this.cancelNextClick = true;
		return true;
	}

	// Reset to prevent wrong click cancel on input (issue #156).
	this.cancelNextClick = false;

	this.lastClickTime = event.timeStamp;

	trackingClickStart = this.trackingClickStart;
	this.trackingClick = false;
	this.trackingClickStart = 0;

	// On some iOS devices, the targetElement supplied with the event is invalid if the layer
	// is performing a transition or scroll, and has to be re-detected manually. Note that
	// for this to function correctly, it must be called *after* the event target is checked!
	// See issue #57; also filed as rdar://13048589 .
	if (this.deviceIsIOSWithBadTarget) {
		touch = event.changedTouches[0];

		// In certain cases arguments of elementFromPoint can be negative, so prevent setting targetElement to null
		targetElement = document.elementFromPoint(touch.pageX - window.pageXOffset, touch.pageY - window.pageYOffset) || targetElement;
		targetElement.fastClickScrollParent = this.targetElement.fastClickScrollParent;
	}

	targetTagName = targetElement.tagName.toLowerCase();
	if (targetTagName === 'label') {
		forElement = this.findControl(targetElement);
		if (forElement) {
			this.focus(targetElement);
			if (this.deviceIsAndroid) {
				return false;
			}

			targetElement = forElement;
		}
	} else if (this.needsFocus(targetElement)) {

		// Case 1: If the touch started a while ago (best guess is 100ms based on tests for issue #36) then focus will be triggered anyway. Return early and unset the target element reference so that the subsequent click will be allowed through.
		// Case 2: Without this exception for input elements tapped when the document is contained in an iframe, then any inputted text won't be visible even though the value attribute is updated as the user types (issue #37).
		if ((event.timeStamp - trackingClickStart) > 100 || (this.deviceIsIOS && window.top !== window && targetTagName === 'input')) {
			this.targetElement = null;
			return false;
		}

		this.focus(targetElement);

		// Select elements need the event to go through on iOS 4, otherwise the selector menu won't open.
		if (!this.deviceIsIOS4 || targetTagName !== 'select') {
			this.targetElement = null;
			event.preventDefault();
		}

		return false;
	}

	if (this.deviceIsIOS && !this.deviceIsIOS4) {

		// Don't send a synthetic click event if the target element is contained within a parent layer that was scrolled
		// and this tap is being used to stop the scrolling (usually initiated by a fling - issue #42).
		scrollParent = targetElement.fastClickScrollParent;
		if (scrollParent && scrollParent.fastClickLastScrollTop !== scrollParent.scrollTop) {
			return true;
		}
	}

	// Prevent the actual click from going though - unless the target node is marked as requiring
	// real clicks or if it is in the whitelist in which case only non-programmatic clicks are permitted.
	if (!this.needsClick(targetElement)) {
		event.preventDefault();
		this.sendClick(targetElement, event);
	}

	return false;
};


/**
 * On touch cancel, stop tracking the click.
 *
 * @returns {void}
 */
FastClick.prototype.onTouchCancel = function() {
	'use strict';
	this.trackingClick = false;
	this.targetElement = null;
};


/**
 * Determine mouse events which should be permitted.
 *
 * @param {Event} event
 * @returns {boolean}
 */
FastClick.prototype.onMouse = function(event) {
	'use strict';

	// If a target element was never set (because a touch event was never fired) allow the event
	if (!this.targetElement) {
		return true;
	}

	if (event.forwardedTouchEvent) {
		return true;
	}

	// Programmatically generated events targeting a specific element should be permitted
	if (!event.cancelable) {
		return true;
	}

	// Derive and check the target element to see whether the mouse event needs to be permitted;
	// unless explicitly enabled, prevent non-touch click events from triggering actions,
	// to prevent ghost/doubleclicks.
	if (!this.needsClick(this.targetElement) || this.cancelNextClick) {

		// Prevent any user-added listeners declared on FastClick element from being fired.
		if (event.stopImmediatePropagation) {
			event.stopImmediatePropagation();
		} else {

			// Part of the hack for browsers that don't support Event#stopImmediatePropagation (e.g. Android 2)
			event.propagationStopped = true;
		}

		// Cancel the event
		event.stopPropagation();
		event.preventDefault();

		return false;
	}

	// If the mouse event is permitted, return true for the action to go through.
	return true;
};


/**
 * On actual clicks, determine whether this is a touch-generated click, a click action occurring
 * naturally after a delay after a touch (which needs to be cancelled to avoid duplication), or
 * an actual click which should be permitted.
 *
 * @param {Event} event
 * @returns {boolean}
 */
FastClick.prototype.onClick = function(event) {
	'use strict';
	var permitted;

	// It's possible for another FastClick-like library delivered with third-party code to fire a click event before FastClick does (issue #44). In that case, set the click-tracking flag back to false and return early. This will cause onTouchEnd to return early.
	if (this.trackingClick) {
		this.targetElement = null;
		this.trackingClick = false;
		return true;
	}

	// Very odd behaviour on iOS (issue #18): if a submit element is present inside a form and the user hits enter in the iOS simulator or clicks the Go button on the pop-up OS keyboard the a kind of 'fake' click event will be triggered with the submit-type input element as the target.
	if (event.target.type === 'submit' && event.detail === 0) {
		return true;
	}

	permitted = this.onMouse(event);

	// Only unset targetElement if the click is not permitted. This will ensure that the check for !targetElement in onMouse fails and the browser's click doesn't go through.
	if (!permitted) {
		this.targetElement = null;
	}

	// If clicks are permitted, return true for the action to go through.
	return permitted;
};


/**
 * Remove all FastClick's event listeners.
 *
 * @returns {void}
 */
FastClick.prototype.destroy = function() {
	'use strict';
	var layer = this.layer;

	if (this.deviceIsAndroid) {
		layer.removeEventListener('mouseover', this.onMouse, true);
		layer.removeEventListener('mousedown', this.onMouse, true);
		layer.removeEventListener('mouseup', this.onMouse, true);
	}

	layer.removeEventListener('click', this.onClick, true);
	layer.removeEventListener('touchstart', this.onTouchStart, false);
	layer.removeEventListener('touchmove', this.onTouchMove, false);
	layer.removeEventListener('touchend', this.onTouchEnd, false);
	layer.removeEventListener('touchcancel', this.onTouchCancel, false);
};


/**
 * Check whether FastClick is needed.
 *
 * @param {Element} layer The layer to listen on
 */
FastClick.notNeeded = function(layer) {
	'use strict';
	var metaViewport;

	// Devices that don't support touch don't need FastClick
	if (typeof window.ontouchstart === 'undefined') {
		return true;
	}

	if ((/Chrome\/[0-9]+/).test(navigator.userAgent)) {

		// Chrome on Android with user-scalable="no" doesn't need FastClick (issue #89)
		if (FastClick.prototype.deviceIsAndroid) {
			metaViewport = document.querySelector('meta[name=viewport]');
			if (metaViewport && metaViewport.content.indexOf('user-scalable=no') !== -1) {
				return true;
			}

		// Chrome desktop doesn't need FastClick (issue #15)
		} else {
			return true;
		}
	}

	// IE10 with -ms-touch-action: none, which disables double-tap-to-zoom (issue #97)
	if (layer.style.msTouchAction === 'none') {
		return true;
	}

	return false;
};


/**
 * Factory method for creating a FastClick object
 *
 * @param {Element} layer The layer to listen on
 */
FastClick.attach = function(layer) {
	'use strict';
	return new FastClick(layer);
};


if (typeof define !== 'undefined' && define.amd) {

	// AMD. Register as an anonymous module.
	define('fastclick',[],function() {
		'use strict';
		return FastClick;
	});
} else if (typeof module !== 'undefined' && module.exports) {
	module.exports = FastClick.attach;
	module.exports.FastClick = FastClick;
} else {
	window.FastClick = FastClick;
}
;
//     Underscore.js 1.4.2
//     http://underscorejs.org
//     (c) 2009-2012 Jeremy Ashkenas, DocumentCloud Inc.
//     Underscore may be freely distributed under the MIT license.

(function() {

  // Baseline setup
  // --------------

  // Establish the root object, `window` in the browser, or `global` on the server.
  var root = this;

  // Save the previous value of the `_` variable.
  var previousUnderscore = root._;

  // Establish the object that gets returned to break out of a loop iteration.
  var breaker = {};

  // Save bytes in the minified (but not gzipped) version:
  var ArrayProto = Array.prototype, ObjProto = Object.prototype, FuncProto = Function.prototype;

  // Create quick reference variables for speed access to core prototypes.
  var push             = ArrayProto.push,
      slice            = ArrayProto.slice,
      concat           = ArrayProto.concat,
      unshift          = ArrayProto.unshift,
      toString         = ObjProto.toString,
      hasOwnProperty   = ObjProto.hasOwnProperty;

  // All **ECMAScript 5** native function implementations that we hope to use
  // are declared here.
  var
    nativeForEach      = ArrayProto.forEach,
    nativeMap          = ArrayProto.map,
    nativeReduce       = ArrayProto.reduce,
    nativeReduceRight  = ArrayProto.reduceRight,
    nativeFilter       = ArrayProto.filter,
    nativeEvery        = ArrayProto.every,
    nativeSome         = ArrayProto.some,
    nativeIndexOf      = ArrayProto.indexOf,
    nativeLastIndexOf  = ArrayProto.lastIndexOf,
    nativeIsArray      = Array.isArray,
    nativeKeys         = Object.keys,
    nativeBind         = FuncProto.bind;

  // Create a safe reference to the Underscore object for use below.
  var _ = function(obj) {
    if (obj instanceof _) return obj;
    if (!(this instanceof _)) return new _(obj);
    this._wrapped = obj;
  };

  // Export the Underscore object for **Node.js**, with
  // backwards-compatibility for the old `require()` API. If we're in
  // the browser, add `_` as a global object via a string identifier,
  // for Closure Compiler "advanced" mode.
  if (typeof exports !== 'undefined') {
    if (typeof module !== 'undefined' && module.exports) {
      exports = module.exports = _;
    }
    exports._ = _;
  } else {
    root['_'] = _;
  }

  // Current version.
  _.VERSION = '1.4.2';

  // Collection Functions
  // --------------------

  // The cornerstone, an `each` implementation, aka `forEach`.
  // Handles objects with the built-in `forEach`, arrays, and raw objects.
  // Delegates to **ECMAScript 5**'s native `forEach` if available.
  var each = _.each = _.forEach = function(obj, iterator, context) {
    if (obj == null) return;
    if (nativeForEach && obj.forEach === nativeForEach) {
      obj.forEach(iterator, context);
    } else if (obj.length === +obj.length) {
      for (var i = 0, l = obj.length; i < l; i++) {
        if (iterator.call(context, obj[i], i, obj) === breaker) return;
      }
    } else {
      for (var key in obj) {
        if (_.has(obj, key)) {
          if (iterator.call(context, obj[key], key, obj) === breaker) return;
        }
      }
    }
  };

  // Return the results of applying the iterator to each element.
  // Delegates to **ECMAScript 5**'s native `map` if available.
  _.map = _.collect = function(obj, iterator, context) {
    var results = [];
    if (obj == null) return results;
    if (nativeMap && obj.map === nativeMap) return obj.map(iterator, context);
    each(obj, function(value, index, list) {
      results[results.length] = iterator.call(context, value, index, list);
    });
    return results;
  };

  // **Reduce** builds up a single result from a list of values, aka `inject`,
  // or `foldl`. Delegates to **ECMAScript 5**'s native `reduce` if available.
  _.reduce = _.foldl = _.inject = function(obj, iterator, memo, context) {
    var initial = arguments.length > 2;
    if (obj == null) obj = [];
    if (nativeReduce && obj.reduce === nativeReduce) {
      if (context) iterator = _.bind(iterator, context);
      return initial ? obj.reduce(iterator, memo) : obj.reduce(iterator);
    }
    each(obj, function(value, index, list) {
      if (!initial) {
        memo = value;
        initial = true;
      } else {
        memo = iterator.call(context, memo, value, index, list);
      }
    });
    if (!initial) throw new TypeError('Reduce of empty array with no initial value');
    return memo;
  };

  // The right-associative version of reduce, also known as `foldr`.
  // Delegates to **ECMAScript 5**'s native `reduceRight` if available.
  _.reduceRight = _.foldr = function(obj, iterator, memo, context) {
    var initial = arguments.length > 2;
    if (obj == null) obj = [];
    if (nativeReduceRight && obj.reduceRight === nativeReduceRight) {
      if (context) iterator = _.bind(iterator, context);
      return arguments.length > 2 ? obj.reduceRight(iterator, memo) : obj.reduceRight(iterator);
    }
    var length = obj.length;
    if (length !== +length) {
      var keys = _.keys(obj);
      length = keys.length;
    }
    each(obj, function(value, index, list) {
      index = keys ? keys[--length] : --length;
      if (!initial) {
        memo = obj[index];
        initial = true;
      } else {
        memo = iterator.call(context, memo, obj[index], index, list);
      }
    });
    if (!initial) throw new TypeError('Reduce of empty array with no initial value');
    return memo;
  };

  // Return the first value which passes a truth test. Aliased as `detect`.
  _.find = _.detect = function(obj, iterator, context) {
    var result;
    any(obj, function(value, index, list) {
      if (iterator.call(context, value, index, list)) {
        result = value;
        return true;
      }
    });
    return result;
  };

  // Return all the elements that pass a truth test.
  // Delegates to **ECMAScript 5**'s native `filter` if available.
  // Aliased as `select`.
  _.filter = _.select = function(obj, iterator, context) {
    var results = [];
    if (obj == null) return results;
    if (nativeFilter && obj.filter === nativeFilter) return obj.filter(iterator, context);
    each(obj, function(value, index, list) {
      if (iterator.call(context, value, index, list)) results[results.length] = value;
    });
    return results;
  };

  // Return all the elements for which a truth test fails.
  _.reject = function(obj, iterator, context) {
    return _.filter(obj, function(value, index, list) {
      return !iterator.call(context, value, index, list);
    }, context);
  };

  // Determine whether all of the elements match a truth test.
  // Delegates to **ECMAScript 5**'s native `every` if available.
  // Aliased as `all`.
  _.every = _.all = function(obj, iterator, context) {
    iterator || (iterator = _.identity);
    var result = true;
    if (obj == null) return result;
    if (nativeEvery && obj.every === nativeEvery) return obj.every(iterator, context);
    each(obj, function(value, index, list) {
      if (!(result = result && iterator.call(context, value, index, list))) return breaker;
    });
    return !!result;
  };

  // Determine if at least one element in the object matches a truth test.
  // Delegates to **ECMAScript 5**'s native `some` if available.
  // Aliased as `any`.
  var any = _.some = _.any = function(obj, iterator, context) {
    iterator || (iterator = _.identity);
    var result = false;
    if (obj == null) return result;
    if (nativeSome && obj.some === nativeSome) return obj.some(iterator, context);
    each(obj, function(value, index, list) {
      if (result || (result = iterator.call(context, value, index, list))) return breaker;
    });
    return !!result;
  };

  // Determine if the array or object contains a given value (using `===`).
  // Aliased as `include`.
  _.contains = _.include = function(obj, target) {
    if (obj == null) return false;
    if (nativeIndexOf && obj.indexOf === nativeIndexOf) return obj.indexOf(target) != -1;
    return any(obj, function(value) {
      return value === target;
    });
  };

  // Invoke a method (with arguments) on every item in a collection.
  _.invoke = function(obj, method) {
    var args = slice.call(arguments, 2);
    return _.map(obj, function(value) {
      return (_.isFunction(method) ? method : value[method]).apply(value, args);
    });
  };

  // Convenience version of a common use case of `map`: fetching a property.
  _.pluck = function(obj, key) {
    return _.map(obj, function(value){ return value[key]; });
  };

  // Convenience version of a common use case of `filter`: selecting only objects
  // with specific `key:value` pairs.
  _.where = function(obj, attrs) {
    if (_.isEmpty(attrs)) return [];
    return _.filter(obj, function(value) {
      for (var key in attrs) {
        if (attrs[key] !== value[key]) return false;
      }
      return true;
    });
  };

  // Return the maximum element or (element-based computation).
  // Can't optimize arrays of integers longer than 65,535 elements.
  // See: https://bugs.webkit.org/show_bug.cgi?id=80797
  _.max = function(obj, iterator, context) {
    if (!iterator && _.isArray(obj) && obj[0] === +obj[0] && obj.length < 65535) {
      return Math.max.apply(Math, obj);
    }
    if (!iterator && _.isEmpty(obj)) return -Infinity;
    var result = {computed : -Infinity};
    each(obj, function(value, index, list) {
      var computed = iterator ? iterator.call(context, value, index, list) : value;
      computed >= result.computed && (result = {value : value, computed : computed});
    });
    return result.value;
  };

  // Return the minimum element (or element-based computation).
  _.min = function(obj, iterator, context) {
    if (!iterator && _.isArray(obj) && obj[0] === +obj[0] && obj.length < 65535) {
      return Math.min.apply(Math, obj);
    }
    if (!iterator && _.isEmpty(obj)) return Infinity;
    var result = {computed : Infinity};
    each(obj, function(value, index, list) {
      var computed = iterator ? iterator.call(context, value, index, list) : value;
      computed < result.computed && (result = {value : value, computed : computed});
    });
    return result.value;
  };

  // Shuffle an array.
  _.shuffle = function(obj) {
    var rand;
    var index = 0;
    var shuffled = [];
    each(obj, function(value) {
      rand = _.random(index++);
      shuffled[index - 1] = shuffled[rand];
      shuffled[rand] = value;
    });
    return shuffled;
  };

  // An internal function to generate lookup iterators.
  var lookupIterator = function(value) {
    return _.isFunction(value) ? value : function(obj){ return obj[value]; };
  };

  // Sort the object's values by a criterion produced by an iterator.
  _.sortBy = function(obj, value, context) {
    var iterator = lookupIterator(value);
    return _.pluck(_.map(obj, function(value, index, list) {
      return {
        value : value,
        index : index,
        criteria : iterator.call(context, value, index, list)
      };
    }).sort(function(left, right) {
      var a = left.criteria;
      var b = right.criteria;
      if (a !== b) {
        if (a > b || a === void 0) return 1;
        if (a < b || b === void 0) return -1;
      }
      return left.index < right.index ? -1 : 1;
    }), 'value');
  };

  // An internal function used for aggregate "group by" operations.
  var group = function(obj, value, context, behavior) {
    var result = {};
    var iterator = lookupIterator(value);
    each(obj, function(value, index) {
      var key = iterator.call(context, value, index, obj);
      behavior(result, key, value);
    });
    return result;
  };

  // Groups the object's values by a criterion. Pass either a string attribute
  // to group by, or a function that returns the criterion.
  _.groupBy = function(obj, value, context) {
    return group(obj, value, context, function(result, key, value) {
      (_.has(result, key) ? result[key] : (result[key] = [])).push(value);
    });
  };

  // Counts instances of an object that group by a certain criterion. Pass
  // either a string attribute to count by, or a function that returns the
  // criterion.
  _.countBy = function(obj, value, context) {
    return group(obj, value, context, function(result, key, value) {
      if (!_.has(result, key)) result[key] = 0;
      result[key]++;
    });
  };

  // Use a comparator function to figure out the smallest index at which
  // an object should be inserted so as to maintain order. Uses binary search.
  _.sortedIndex = function(array, obj, iterator, context) {
    iterator = iterator == null ? _.identity : lookupIterator(iterator);
    var value = iterator.call(context, obj);
    var low = 0, high = array.length;
    while (low < high) {
      var mid = (low + high) >>> 1;
      iterator.call(context, array[mid]) < value ? low = mid + 1 : high = mid;
    }
    return low;
  };

  // Safely convert anything iterable into a real, live array.
  _.toArray = function(obj) {
    if (!obj) return [];
    if (obj.length === +obj.length) return slice.call(obj);
    return _.values(obj);
  };

  // Return the number of elements in an object.
  _.size = function(obj) {
    if (obj == null) return 0;
    return (obj.length === +obj.length) ? obj.length : _.keys(obj).length;
  };

  // Array Functions
  // ---------------

  // Get the first element of an array. Passing **n** will return the first N
  // values in the array. Aliased as `head` and `take`. The **guard** check
  // allows it to work with `_.map`.
  _.first = _.head = _.take = function(array, n, guard) {
    if (array == null) return void 0;
    return (n != null) && !guard ? slice.call(array, 0, n) : array[0];
  };

  // Returns everything but the last entry of the array. Especially useful on
  // the arguments object. Passing **n** will return all the values in
  // the array, excluding the last N. The **guard** check allows it to work with
  // `_.map`.
  _.initial = function(array, n, guard) {
    return slice.call(array, 0, array.length - ((n == null) || guard ? 1 : n));
  };

  // Get the last element of an array. Passing **n** will return the last N
  // values in the array. The **guard** check allows it to work with `_.map`.
  _.last = function(array, n, guard) {
    if (array == null) return void 0;
    if ((n != null) && !guard) {
      return slice.call(array, Math.max(array.length - n, 0));
    } else {
      return array[array.length - 1];
    }
  };

  // Returns everything but the first entry of the array. Aliased as `tail` and `drop`.
  // Especially useful on the arguments object. Passing an **n** will return
  // the rest N values in the array. The **guard**
  // check allows it to work with `_.map`.
  _.rest = _.tail = _.drop = function(array, n, guard) {
    return slice.call(array, (n == null) || guard ? 1 : n);
  };

  // Trim out all falsy values from an array.
  _.compact = function(array) {
    return _.filter(array, function(value){ return !!value; });
  };

  // Internal implementation of a recursive `flatten` function.
  var flatten = function(input, shallow, output) {
    each(input, function(value) {
      if (_.isArray(value)) {
        shallow ? push.apply(output, value) : flatten(value, shallow, output);
      } else {
        output.push(value);
      }
    });
    return output;
  };

  // Return a completely flattened version of an array.
  _.flatten = function(array, shallow) {
    return flatten(array, shallow, []);
  };

  // Return a version of the array that does not contain the specified value(s).
  _.without = function(array) {
    return _.difference(array, slice.call(arguments, 1));
  };

  // Produce a duplicate-free version of the array. If the array has already
  // been sorted, you have the option of using a faster algorithm.
  // Aliased as `unique`.
  _.uniq = _.unique = function(array, isSorted, iterator, context) {
    if (_.isFunction(isSorted)) {
      context = iterator;
      iterator = isSorted;
      isSorted = false;
    }
    var initial = iterator ? _.map(array, iterator, context) : array;
    var results = [];
    var seen = [];
    each(initial, function(value, index) {
      if (isSorted ? (!index || seen[seen.length - 1] !== value) : !_.contains(seen, value)) {
        seen.push(value);
        results.push(array[index]);
      }
    });
    return results;
  };

  // Produce an array that contains the union: each distinct element from all of
  // the passed-in arrays.
  _.union = function() {
    return _.uniq(concat.apply(ArrayProto, arguments));
  };

  // Produce an array that contains every item shared between all the
  // passed-in arrays.
  _.intersection = function(array) {
    var rest = slice.call(arguments, 1);
    return _.filter(_.uniq(array), function(item) {
      return _.every(rest, function(other) {
        return _.indexOf(other, item) >= 0;
      });
    });
  };

  // Take the difference between one array and a number of other arrays.
  // Only the elements present in just the first array will remain.
  _.difference = function(array) {
    var rest = concat.apply(ArrayProto, slice.call(arguments, 1));
    return _.filter(array, function(value){ return !_.contains(rest, value); });
  };

  // Zip together multiple lists into a single array -- elements that share
  // an index go together.
  _.zip = function() {
    var args = slice.call(arguments);
    var length = _.max(_.pluck(args, 'length'));
    var results = new Array(length);
    for (var i = 0; i < length; i++) {
      results[i] = _.pluck(args, "" + i);
    }
    return results;
  };

  // Converts lists into objects. Pass either a single array of `[key, value]`
  // pairs, or two parallel arrays of the same length -- one of keys, and one of
  // the corresponding values.
  _.object = function(list, values) {
    if (list == null) return {};
    var result = {};
    for (var i = 0, l = list.length; i < l; i++) {
      if (values) {
        result[list[i]] = values[i];
      } else {
        result[list[i][0]] = list[i][1];
      }
    }
    return result;
  };

  // If the browser doesn't supply us with indexOf (I'm looking at you, **MSIE**),
  // we need this function. Return the position of the first occurrence of an
  // item in an array, or -1 if the item is not included in the array.
  // Delegates to **ECMAScript 5**'s native `indexOf` if available.
  // If the array is large and already in sort order, pass `true`
  // for **isSorted** to use binary search.
  _.indexOf = function(array, item, isSorted) {
    if (array == null) return -1;
    var i = 0, l = array.length;
    if (isSorted) {
      if (typeof isSorted == 'number') {
        i = (isSorted < 0 ? Math.max(0, l + isSorted) : isSorted);
      } else {
        i = _.sortedIndex(array, item);
        return array[i] === item ? i : -1;
      }
    }
    if (nativeIndexOf && array.indexOf === nativeIndexOf) return array.indexOf(item, isSorted);
    for (; i < l; i++) if (array[i] === item) return i;
    return -1;
  };

  // Delegates to **ECMAScript 5**'s native `lastIndexOf` if available.
  _.lastIndexOf = function(array, item, from) {
    if (array == null) return -1;
    var hasIndex = from != null;
    if (nativeLastIndexOf && array.lastIndexOf === nativeLastIndexOf) {
      return hasIndex ? array.lastIndexOf(item, from) : array.lastIndexOf(item);
    }
    var i = (hasIndex ? from : array.length);
    while (i--) if (array[i] === item) return i;
    return -1;
  };

  // Generate an integer Array containing an arithmetic progression. A port of
  // the native Python `range()` function. See
  // [the Python documentation](http://docs.python.org/library/functions.html#range).
  _.range = function(start, stop, step) {
    if (arguments.length <= 1) {
      stop = start || 0;
      start = 0;
    }
    step = arguments[2] || 1;

    var len = Math.max(Math.ceil((stop - start) / step), 0);
    var idx = 0;
    var range = new Array(len);

    while(idx < len) {
      range[idx++] = start;
      start += step;
    }

    return range;
  };

  // Function (ahem) Functions
  // ------------------

  // Reusable constructor function for prototype setting.
  var ctor = function(){};

  // Create a function bound to a given object (assigning `this`, and arguments,
  // optionally). Binding with arguments is also known as `curry`.
  // Delegates to **ECMAScript 5**'s native `Function.bind` if available.
  // We check for `func.bind` first, to fail fast when `func` is undefined.
  _.bind = function bind(func, context) {
    var bound, args;
    if (func.bind === nativeBind && nativeBind) return nativeBind.apply(func, slice.call(arguments, 1));
    if (!_.isFunction(func)) throw new TypeError;
    args = slice.call(arguments, 2);
    return bound = function() {
      if (!(this instanceof bound)) return func.apply(context, args.concat(slice.call(arguments)));
      ctor.prototype = func.prototype;
      var self = new ctor;
      var result = func.apply(self, args.concat(slice.call(arguments)));
      if (Object(result) === result) return result;
      return self;
    };
  };

  // Bind all of an object's methods to that object. Useful for ensuring that
  // all callbacks defined on an object belong to it.
  _.bindAll = function(obj) {
    var funcs = slice.call(arguments, 1);
    if (funcs.length == 0) funcs = _.functions(obj);
    each(funcs, function(f) { obj[f] = _.bind(obj[f], obj); });
    return obj;
  };

  // Memoize an expensive function by storing its results.
  _.memoize = function(func, hasher) {
    var memo = {};
    hasher || (hasher = _.identity);
    return function() {
      var key = hasher.apply(this, arguments);
      return _.has(memo, key) ? memo[key] : (memo[key] = func.apply(this, arguments));
    };
  };

  // Delays a function for the given number of milliseconds, and then calls
  // it with the arguments supplied.
  _.delay = function(func, wait) {
    var args = slice.call(arguments, 2);
    return setTimeout(function(){ return func.apply(null, args); }, wait);
  };

  // Defers a function, scheduling it to run after the current call stack has
  // cleared.
  _.defer = function(func) {
    return _.delay.apply(_, [func, 1].concat(slice.call(arguments, 1)));
  };

  // Returns a function, that, when invoked, will only be triggered at most once
  // during a given window of time.
  _.throttle = function(func, wait) {
    var context, args, timeout, result;
    var previous = 0;
    var later = function() {
      previous = new Date;
      timeout = null;
      result = func.apply(context, args);
    };
    return function() {
      var now = new Date;
      var remaining = wait - (now - previous);
      context = this;
      args = arguments;
      if (remaining <= 0) {
        clearTimeout(timeout);
        previous = now;
        result = func.apply(context, args);
      } else if (!timeout) {
        timeout = setTimeout(later, remaining);
      }
      return result;
    };
  };

  // Returns a function, that, as long as it continues to be invoked, will not
  // be triggered. The function will be called after it stops being called for
  // N milliseconds. If `immediate` is passed, trigger the function on the
  // leading edge, instead of the trailing.
  _.debounce = function(func, wait, immediate) {
    var timeout, result;
    return function() {
      var context = this, args = arguments;
      var later = function() {
        timeout = null;
        if (!immediate) result = func.apply(context, args);
      };
      var callNow = immediate && !timeout;
      clearTimeout(timeout);
      timeout = setTimeout(later, wait);
      if (callNow) result = func.apply(context, args);
      return result;
    };
  };

  // Returns a function that will be executed at most one time, no matter how
  // often you call it. Useful for lazy initialization.
  _.once = function(func) {
    var ran = false, memo;
    return function() {
      if (ran) return memo;
      ran = true;
      memo = func.apply(this, arguments);
      func = null;
      return memo;
    };
  };

  // Returns the first function passed as an argument to the second,
  // allowing you to adjust arguments, run code before and after, and
  // conditionally execute the original function.
  _.wrap = function(func, wrapper) {
    return function() {
      var args = [func];
      push.apply(args, arguments);
      return wrapper.apply(this, args);
    };
  };

  // Returns a function that is the composition of a list of functions, each
  // consuming the return value of the function that follows.
  _.compose = function() {
    var funcs = arguments;
    return function() {
      var args = arguments;
      for (var i = funcs.length - 1; i >= 0; i--) {
        args = [funcs[i].apply(this, args)];
      }
      return args[0];
    };
  };

  // Returns a function that will only be executed after being called N times.
  _.after = function(times, func) {
    if (times <= 0) return func();
    return function() {
      if (--times < 1) {
        return func.apply(this, arguments);
      }
    };
  };

  // Object Functions
  // ----------------

  // Retrieve the names of an object's properties.
  // Delegates to **ECMAScript 5**'s native `Object.keys`
  _.keys = nativeKeys || function(obj) {
    if (obj !== Object(obj)) throw new TypeError('Invalid object');
    var keys = [];
    for (var key in obj) if (_.has(obj, key)) keys[keys.length] = key;
    return keys;
  };

  // Retrieve the values of an object's properties.
  _.values = function(obj) {
    var values = [];
    for (var key in obj) if (_.has(obj, key)) values.push(obj[key]);
    return values;
  };

  // Convert an object into a list of `[key, value]` pairs.
  _.pairs = function(obj) {
    var pairs = [];
    for (var key in obj) if (_.has(obj, key)) pairs.push([key, obj[key]]);
    return pairs;
  };

  // Invert the keys and values of an object. The values must be serializable.
  _.invert = function(obj) {
    var result = {};
    for (var key in obj) if (_.has(obj, key)) result[obj[key]] = key;
    return result;
  };

  // Return a sorted list of the function names available on the object.
  // Aliased as `methods`
  _.functions = _.methods = function(obj) {
    var names = [];
    for (var key in obj) {
      if (_.isFunction(obj[key])) names.push(key);
    }
    return names.sort();
  };

  // Extend a given object with all the properties in passed-in object(s).
  _.extend = function(obj) {
    each(slice.call(arguments, 1), function(source) {
      for (var prop in source) {
        obj[prop] = source[prop];
      }
    });
    return obj;
  };

  // Return a copy of the object only containing the whitelisted properties.
  _.pick = function(obj) {
    var copy = {};
    var keys = concat.apply(ArrayProto, slice.call(arguments, 1));
    each(keys, function(key) {
      if (key in obj) copy[key] = obj[key];
    });
    return copy;
  };

   // Return a copy of the object without the blacklisted properties.
  _.omit = function(obj) {
    var copy = {};
    var keys = concat.apply(ArrayProto, slice.call(arguments, 1));
    for (var key in obj) {
      if (!_.contains(keys, key)) copy[key] = obj[key];
    }
    return copy;
  };

  // Fill in a given object with default properties.
  _.defaults = function(obj) {
    each(slice.call(arguments, 1), function(source) {
      for (var prop in source) {
        if (obj[prop] == null) obj[prop] = source[prop];
      }
    });
    return obj;
  };

  // Create a (shallow-cloned) duplicate of an object.
  _.clone = function(obj) {
    if (!_.isObject(obj)) return obj;
    return _.isArray(obj) ? obj.slice() : _.extend({}, obj);
  };

  // Invokes interceptor with the obj, and then returns obj.
  // The primary purpose of this method is to "tap into" a method chain, in
  // order to perform operations on intermediate results within the chain.
  _.tap = function(obj, interceptor) {
    interceptor(obj);
    return obj;
  };

  // Internal recursive comparison function for `isEqual`.
  var eq = function(a, b, aStack, bStack) {
    // Identical objects are equal. `0 === -0`, but they aren't identical.
    // See the Harmony `egal` proposal: http://wiki.ecmascript.org/doku.php?id=harmony:egal.
    if (a === b) return a !== 0 || 1 / a == 1 / b;
    // A strict comparison is necessary because `null == undefined`.
    if (a == null || b == null) return a === b;
    // Unwrap any wrapped objects.
    if (a instanceof _) a = a._wrapped;
    if (b instanceof _) b = b._wrapped;
    // Compare `[[Class]]` names.
    var className = toString.call(a);
    if (className != toString.call(b)) return false;
    switch (className) {
      // Strings, numbers, dates, and booleans are compared by value.
      case '[object String]':
        // Primitives and their corresponding object wrappers are equivalent; thus, `"5"` is
        // equivalent to `new String("5")`.
        return a == String(b);
      case '[object Number]':
        // `NaN`s are equivalent, but non-reflexive. An `egal` comparison is performed for
        // other numeric values.
        return a != +a ? b != +b : (a == 0 ? 1 / a == 1 / b : a == +b);
      case '[object Date]':
      case '[object Boolean]':
        // Coerce dates and booleans to numeric primitive values. Dates are compared by their
        // millisecond representations. Note that invalid dates with millisecond representations
        // of `NaN` are not equivalent.
        return +a == +b;
      // RegExps are compared by their source patterns and flags.
      case '[object RegExp]':
        return a.source == b.source &&
               a.global == b.global &&
               a.multiline == b.multiline &&
               a.ignoreCase == b.ignoreCase;
    }
    if (typeof a != 'object' || typeof b != 'object') return false;
    // Assume equality for cyclic structures. The algorithm for detecting cyclic
    // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.
    var length = aStack.length;
    while (length--) {
      // Linear search. Performance is inversely proportional to the number of
      // unique nested structures.
      if (aStack[length] == a) return bStack[length] == b;
    }
    // Add the first object to the stack of traversed objects.
    aStack.push(a);
    bStack.push(b);
    var size = 0, result = true;
    // Recursively compare objects and arrays.
    if (className == '[object Array]') {
      // Compare array lengths to determine if a deep comparison is necessary.
      size = a.length;
      result = size == b.length;
      if (result) {
        // Deep compare the contents, ignoring non-numeric properties.
        while (size--) {
          if (!(result = eq(a[size], b[size], aStack, bStack))) break;
        }
      }
    } else {
      // Objects with different constructors are not equivalent, but `Object`s
      // from different frames are.
      var aCtor = a.constructor, bCtor = b.constructor;
      if (aCtor !== bCtor && !(_.isFunction(aCtor) && (aCtor instanceof aCtor) &&
                               _.isFunction(bCtor) && (bCtor instanceof bCtor))) {
        return false;
      }
      // Deep compare objects.
      for (var key in a) {
        if (_.has(a, key)) {
          // Count the expected number of properties.
          size++;
          // Deep compare each member.
          if (!(result = _.has(b, key) && eq(a[key], b[key], aStack, bStack))) break;
        }
      }
      // Ensure that both objects contain the same number of properties.
      if (result) {
        for (key in b) {
          if (_.has(b, key) && !(size--)) break;
        }
        result = !size;
      }
    }
    // Remove the first object from the stack of traversed objects.
    aStack.pop();
    bStack.pop();
    return result;
  };

  // Perform a deep comparison to check if two objects are equal.
  _.isEqual = function(a, b) {
    return eq(a, b, [], []);
  };

  // Is a given array, string, or object empty?
  // An "empty" object has no enumerable own-properties.
  _.isEmpty = function(obj) {
    if (obj == null) return true;
    if (_.isArray(obj) || _.isString(obj)) return obj.length === 0;
    for (var key in obj) if (_.has(obj, key)) return false;
    return true;
  };

  // Is a given value a DOM element?
  _.isElement = function(obj) {
    return !!(obj && obj.nodeType === 1);
  };

  // Is a given value an array?
  // Delegates to ECMA5's native Array.isArray
  _.isArray = nativeIsArray || function(obj) {
    return toString.call(obj) == '[object Array]';
  };

  // Is a given variable an object?
  _.isObject = function(obj) {
    return obj === Object(obj);
  };

  // Add some isType methods: isArguments, isFunction, isString, isNumber, isDate, isRegExp.
  each(['Arguments', 'Function', 'String', 'Number', 'Date', 'RegExp'], function(name) {
    _['is' + name] = function(obj) {
      return toString.call(obj) == '[object ' + name + ']';
    };
  });

  // Define a fallback version of the method in browsers (ahem, IE), where
  // there isn't any inspectable "Arguments" type.
  if (!_.isArguments(arguments)) {
    _.isArguments = function(obj) {
      return !!(obj && _.has(obj, 'callee'));
    };
  }

  // Optimize `isFunction` if appropriate.
  if (typeof (/./) !== 'function') {
    _.isFunction = function(obj) {
      return typeof obj === 'function';
    };
  }

  // Is a given object a finite number?
  _.isFinite = function(obj) {
    return isFinite( obj ) && !isNaN( parseFloat(obj) );
  };

  // Is the given value `NaN`? (NaN is the only number which does not equal itself).
  _.isNaN = function(obj) {
    return _.isNumber(obj) && obj != +obj;
  };

  // Is a given value a boolean?
  _.isBoolean = function(obj) {
    return obj === true || obj === false || toString.call(obj) == '[object Boolean]';
  };

  // Is a given value equal to null?
  _.isNull = function(obj) {
    return obj === null;
  };

  // Is a given variable undefined?
  _.isUndefined = function(obj) {
    return obj === void 0;
  };

  // Shortcut function for checking if an object has a given property directly
  // on itself (in other words, not on a prototype).
  _.has = function(obj, key) {
    return hasOwnProperty.call(obj, key);
  };

  // Utility Functions
  // -----------------

  // Run Underscore.js in *noConflict* mode, returning the `_` variable to its
  // previous owner. Returns a reference to the Underscore object.
  _.noConflict = function() {
    root._ = previousUnderscore;
    return this;
  };

  // Keep the identity function around for default iterators.
  _.identity = function(value) {
    return value;
  };

  // Run a function **n** times.
  _.times = function(n, iterator, context) {
    for (var i = 0; i < n; i++) iterator.call(context, i);
  };

  // Return a random integer between min and max (inclusive).
  _.random = function(min, max) {
    if (max == null) {
      max = min;
      min = 0;
    }
    return min + (0 | Math.random() * (max - min + 1));
  };

  // List of HTML entities for escaping.
  var entityMap = {
    escape: {
      '&': '&amp;',
      '<': '&lt;',
      '>': '&gt;',
      '"': '&quot;',
      "'": '&#x27;',
      '/': '&#x2F;'
    }
  };
  entityMap.unescape = _.invert(entityMap.escape);

  // Regexes containing the keys and values listed immediately above.
  var entityRegexes = {
    escape:   new RegExp('[' + _.keys(entityMap.escape).join('') + ']', 'g'),
    unescape: new RegExp('(' + _.keys(entityMap.unescape).join('|') + ')', 'g')
  };

  // Functions for escaping and unescaping strings to/from HTML interpolation.
  _.each(['escape', 'unescape'], function(method) {
    _[method] = function(string) {
      if (string == null) return '';
      return ('' + string).replace(entityRegexes[method], function(match) {
        return entityMap[method][match];
      });
    };
  });

  // If the value of the named property is a function then invoke it;
  // otherwise, return it.
  _.result = function(object, property) {
    if (object == null) return null;
    var value = object[property];
    return _.isFunction(value) ? value.call(object) : value;
  };

  // Add your own custom functions to the Underscore object.
  _.mixin = function(obj) {
    each(_.functions(obj), function(name){
      var func = _[name] = obj[name];
      _.prototype[name] = function() {
        var args = [this._wrapped];
        push.apply(args, arguments);
        return result.call(this, func.apply(_, args));
      };
    });
  };

  // Generate a unique integer id (unique within the entire client session).
  // Useful for temporary DOM ids.
  var idCounter = 0;
  _.uniqueId = function(prefix) {
    var id = idCounter++;
    return prefix ? prefix + id : id;
  };

  // By default, Underscore uses ERB-style template delimiters, change the
  // following template settings to use alternative delimiters.
  _.templateSettings = {
    evaluate    : /<%([\s\S]+?)%>/g,
    interpolate : /<%=([\s\S]+?)%>/g,
    escape      : /<%-([\s\S]+?)%>/g
  };

  // When customizing `templateSettings`, if you don't want to define an
  // interpolation, evaluation or escaping regex, we need one that is
  // guaranteed not to match.
  var noMatch = /(.)^/;

  // Certain characters need to be escaped so that they can be put into a
  // string literal.
  var escapes = {
    "'":      "'",
    '\\':     '\\',
    '\r':     'r',
    '\n':     'n',
    '\t':     't',
    '\u2028': 'u2028',
    '\u2029': 'u2029'
  };

  var escaper = /\\|'|\r|\n|\t|\u2028|\u2029/g;

  // JavaScript micro-templating, similar to John Resig's implementation.
  // Underscore templating handles arbitrary delimiters, preserves whitespace,
  // and correctly escapes quotes within interpolated code.
  _.template = function(text, data, settings) {
    settings = _.defaults({}, settings, _.templateSettings);

    // Combine delimiters into one regular expression via alternation.
    var matcher = new RegExp([
      (settings.escape || noMatch).source,
      (settings.interpolate || noMatch).source,
      (settings.evaluate || noMatch).source
    ].join('|') + '|$', 'g');

    // Compile the template source, escaping string literals appropriately.
    var index = 0;
    var source = "__p+='";
    text.replace(matcher, function(match, escape, interpolate, evaluate, offset) {
      source += text.slice(index, offset)
        .replace(escaper, function(match) { return '\\' + escapes[match]; });
      source +=
        escape ? "'+\n((__t=(" + escape + "))==null?'':_.escape(__t))+\n'" :
        interpolate ? "'+\n((__t=(" + interpolate + "))==null?'':__t)+\n'" :
        evaluate ? "';\n" + evaluate + "\n__p+='" : '';
      index = offset + match.length;
    });
    source += "';\n";

    // If a variable is not specified, place data values in local scope.
    if (!settings.variable) source = 'with(obj||{}){\n' + source + '}\n';

    source = "var __t,__p='',__j=Array.prototype.join," +
      "print=function(){__p+=__j.call(arguments,'');};\n" +
      source + "return __p;\n";

    try {
      var render = new Function(settings.variable || 'obj', '_', source);
    } catch (e) {
      e.source = source;
      throw e;
    }

    if (data) return render(data, _);
    var template = function(data) {
      return render.call(this, data, _);
    };

    // Provide the compiled function source as a convenience for precompilation.
    template.source = 'function(' + (settings.variable || 'obj') + '){\n' + source + '}';

    return template;
  };

  // Add a "chain" function, which will delegate to the wrapper.
  _.chain = function(obj) {
    return _(obj).chain();
  };

  // OOP
  // ---------------
  // If Underscore is called as a function, it returns a wrapped object that
  // can be used OO-style. This wrapper holds altered versions of all the
  // underscore functions. Wrapped objects may be chained.

  // Helper function to continue chaining intermediate results.
  var result = function(obj) {
    return this._chain ? _(obj).chain() : obj;
  };

  // Add all of the Underscore functions to the wrapper object.
  _.mixin(_);

  // Add all mutator Array functions to the wrapper.
  each(['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'], function(name) {
    var method = ArrayProto[name];
    _.prototype[name] = function() {
      var obj = this._wrapped;
      method.apply(obj, arguments);
      if ((name == 'shift' || name == 'splice') && obj.length === 0) delete obj[0];
      return result.call(this, obj);
    };
  });

  // Add all accessor Array functions to the wrapper.
  each(['concat', 'join', 'slice'], function(name) {
    var method = ArrayProto[name];
    _.prototype[name] = function() {
      return result.call(this, method.apply(this._wrapped, arguments));
    };
  });

  _.extend(_.prototype, {

    // Start chaining a wrapped Underscore object.
    chain: function() {
      this._chain = true;
      return this;
    },

    // Extracts the result from a wrapped and chained object.
    value: function() {
      return this._wrapped;
    }

  });

}).call(this);

define("underscore", (function (global) {
    return function () {
        var ret, fn;
        return ret || global._;
    };
}(this)));

/*global define: false console: true */

define('common/console',['require','lab.config'],function (require) {
  // Dependencies.
  var labConfig = require('lab.config'),

      // Object to be returned.
      publicAPI,
      cons,
      emptyFunction = function () {};

  // Prevent a console.log from blowing things up if we are on a browser that
  // does not support it ... like IE9.
  if (typeof console === 'undefined') {
    console = {};
    if (window) window.console = console;
  }

  // Assign shortcut.
  cons = console;
  // Make sure that every method is defined.
  if (cons.log === undefined)
    cons.log = emptyFunction;
  if (cons.info === undefined)
    cons.info = emptyFunction;
  if (cons.warn === undefined)
    cons.warn = emptyFunction;
  if (cons.error === undefined)
    cons.error = emptyFunction;
  if (cons.time === undefined)
    cons.time = emptyFunction;
  if (cons.timeEnd === undefined)
    cons.timeEnd = emptyFunction;

  // Make sure that every method has access to an 'apply' method
  // This is a hack for IE9 and IE10 when using the built-in developer tools.
  // See: http://stackoverflow.com/questions/5472938/does-ie9-support-console-log-and-is-it-a-real-function
  if (cons.log.apply === undefined)
    cons.log = Function.prototype.bind.call(console.log, console);
  if (cons.info.apply === undefined)
    cons.info = Function.prototype.bind.call(console.info, console);
  if (cons.warn.apply === undefined)
    cons.warn = Function.prototype.bind.call(console.warn, console);
  if (cons.error.apply === undefined)
    cons.error = Function.prototype.bind.call(console.error, console);
  if (cons.time.apply === undefined)
    cons.time = Function.prototype.bind.call(console.time, console);
  if (cons.timeEnd.apply === undefined)
    cons.timeEnd = Function.prototype.bind.call(console.timeEnd, console);

  publicAPI = {
    log: function () {
      if (labConfig.logging)
        cons.log.apply(cons, arguments);
    },
    info: function () {
      if (labConfig.logging)
        cons.info.apply(cons, arguments);
    },
    warn: function () {
      if (labConfig.logging)
        cons.warn.apply(cons, arguments);
    },
    error: function () {
      if (labConfig.logging)
        cons.error.apply(cons, arguments);
    },
    time: function () {
      if (labConfig.tracing)
        cons.time.apply(cons, arguments);
    },
    timeEnd: function () {
      if (labConfig.tracing)
        cons.timeEnd.apply(cons, arguments);
    }
  };

  return publicAPI;
});

/*global define: false alert: false */

/**
  Tiny module providing global way to show errors to user.

  It's better to use module, as in the future, we may want to replace basic
  alert with more sophisticated solution (for example jQuery UI dialog).
*/
define('common/alert',['require','common/console'],function (require) {
  // Dependencies.
  var console = require('common/console'),

      // Try to use global alert. If it's not available, use console.error (node.js).
      alertFunc = typeof alert !== 'undefined' ? alert : console.error;

  return function alert(msg) {
    alertFunc(msg);
  };
});

/*global define: false, $: false */

// For now, only defaultValue, readOnly and immutable
// meta-properties are supported.
define('common/validator',['require','arrays'],function(require) {

  var arrays = require('arrays');

  // Create a new object, that prototypically inherits from the Error constructor.
  // It provides a direct information which property of the input caused an error.
  function ValidationError(prop, message) {
    this.prop = prop;
    this.message = message;
  }
  ValidationError.prototype = new Error();
  ValidationError.prototype.constructor = ValidationError;

  function isObject(prop) {
    // Note that typeof null is also equal to "object", so we have to check it.
    return prop !== null && typeof prop === "object";
  }

  function checkConflicts(input, propName, conflictingProps) {
    var i, len;
    for (i = 0, len = conflictingProps.length; i < len; i++) {
      if (input.hasOwnProperty(conflictingProps[i])) {
        throw new ValidationError(propName, "Properties set contains conflicting properties: " +
          conflictingProps[i] + " and " + propName);
      }
    }
  }

  function validateSingleProperty(propertyMetadata, prop, value, ignoreImmutable) {
    if (propertyMetadata.readOnly) {
      throw new ValidationError(prop, "Properties set tries to overwrite read-only property " + prop);
    }
    if (!ignoreImmutable && propertyMetadata.immutable) {
      throw new ValidationError(prop, "Properties set tries to overwrite immutable property " + prop);
    }
    // Use custom validate function defined in metadata if provided.
    return propertyMetadata.validate ? propertyMetadata.validate(value) : value;
  }

  return {

    // Basic validation.
    // Check if provided 'input' hash doesn't try to overwrite properties
    // which are marked as read-only or immutable. Don't take into account
    // 'defaultValue' as the 'input' hash is allowed to be incomplete.
    // It should be used *only* for update of an object.
    // While creating new object, use validateCompleteness() instead!
    validate: function (metadata, input, ignoreImmutable) {
      var result = {},
          prop, propMetadata;

      if (arguments.length < 2) {
        throw new Error("Incorrect usage. Provide metadata and hash which should be validated.");
      }

      for (prop in input) {
        if (input.hasOwnProperty(prop)) {
          // Try to get meta-data for this property.
          propMetadata = metadata[prop];
          // Continue only if the property is listed in meta-data.
          if (typeof propMetadata !== "undefined") {
            input[prop] = validateSingleProperty(propMetadata, prop, input[prop], ignoreImmutable);
            if (propMetadata.conflictsWith) {
              checkConflicts(input, prop, propMetadata.conflictsWith);
            }
            result[prop] = input[prop];
          }
        }
      }
      return result;
    },

    validateSingleProperty: validateSingleProperty,

    propertyIsWritable: function(propertyMetadata) {
      // Note that immutable properties are writable, they just have to be
      return ! propertyMetadata.readOnly;
    },

    propertyChangeInvalidates: function(propertyMetadata) {
      // Default to true for safety.
      if (typeof propertyMetadata.propertyChangeInvalidates === "undefined") {
        return true;
      }
      return !!propertyMetadata.propertyChangeInvalidates;
    },

    // Complete validation.
    // Assume that provided 'input' hash is used for creation of new
    // object. Start with checking if all required values are provided,
    // and using default values if they are provided.
    // Later perform basic validation.
    validateCompleteness: function (metadata, input, opts) {
      var result = {},
          includeOnlySerializedProperties = opts && opts.includeOnlySerializedProperties,
          prop, propMetadata, defVal;

      if (arguments.length < 2) {
        throw new Error("Incorrect usage. Provide metadata and hash which should be validated.");
      }

      for (prop in metadata) {
        if (metadata.hasOwnProperty(prop)) {
          propMetadata = metadata[prop];
          // require explicit check for serialize === false, because the default value is true.
          if (includeOnlySerializedProperties && propMetadata.serialize === false) {
            continue;
          }

          defVal = propMetadata.defaultValue;

          if (typeof input[prop] === "undefined") {
            // Value is not declared in the input data.
            if (propMetadata.required === true) {
              throw new ValidationError(prop, "Properties set is missing required property " + prop);
            } else if (arrays.isArray(defVal)) {
              // Copy an array defined as a default value.
              // Do not use instance defined in metadata.
              result[prop] = arrays.copy(defVal, []);
            } else if (isObject(defVal)) {
              // Copy an object defined as a default value. Do not use instance defined in metadata.
              result[prop] = $.extend(true, {}, defVal);
            } else if (typeof defVal !== "undefined") {
              // If it's basic type, just set value.
              result[prop] = defVal;
            }
          } else if (!arrays.isArray(input[prop]) && isObject(input[prop]) && isObject(defVal)) {
            // Note that typeof [] is also "object" - that is the reason of the isArray() check.
            result[prop] = $.extend(true, {}, defVal, input[prop]);
          } else if (arrays.isArray(input[prop])) {
            // Deep copy of an array.
            result[prop] = $.extend(true, [], input[prop]);
          } else {
            // Basic type like number, so '=' is enough.
            result[prop] = input[prop];
          }
        }
      }

      // Perform standard check like for hash meant to update object.
      // However, ignore immutable check, as these properties are supposed
      // to create a new object.
      return this.validate(metadata, result, true);
    },

    // Expose ValidationError. It can be useful for the custom validation routines.
    ValidationError: ValidationError
  };
});

// i18next, v1.7.3
// Copyright (c)2014 Jan Mühlemann (jamuhl).
// Distributed under MIT license
// http://i18next.com
(function (root, factory) {
    if (typeof exports === 'object') {

        module.exports = factory();

    } else if (typeof define === 'function' && define.amd) {

        define('i18next',[], factory);

    } 
}(this, function () {

    // add indexOf to non ECMA-262 standard compliant browsers
    if (!Array.prototype.indexOf) {
        Array.prototype.indexOf = function (searchElement /*, fromIndex */ ) {
            "use strict";
            if (this == null) {
                throw new TypeError();
            }
            var t = Object(this);
            var len = t.length >>> 0;
            if (len === 0) {
                return -1;
            }
            var n = 0;
            if (arguments.length > 0) {
                n = Number(arguments[1]);
                if (n != n) { // shortcut for verifying if it's NaN
                    n = 0;
                } else if (n != 0 && n != Infinity && n != -Infinity) {
                    n = (n > 0 || -1) * Math.floor(Math.abs(n));
                }
            }
            if (n >= len) {
                return -1;
            }
            var k = n >= 0 ? n : Math.max(len - Math.abs(n), 0);
            for (; k < len; k++) {
                if (k in t && t[k] === searchElement) {
                    return k;
                }
            }
            return -1;
        }
    }
    
    // add lastIndexOf to non ECMA-262 standard compliant browsers
    if (!Array.prototype.lastIndexOf) {
        Array.prototype.lastIndexOf = function(searchElement /*, fromIndex*/) {
            "use strict";
            if (this == null) {
                throw new TypeError();
            }
            var t = Object(this);
            var len = t.length >>> 0;
            if (len === 0) {
                return -1;
            }
            var n = len;
            if (arguments.length > 1) {
                n = Number(arguments[1]);
                if (n != n) {
                    n = 0;
                } else if (n != 0 && n != (1 / 0) && n != -(1 / 0)) {
                    n = (n > 0 || -1) * Math.floor(Math.abs(n));
                }
            }
            var k = n >= 0 ? Math.min(n, len - 1) : len - Math.abs(n);
            for (; k >= 0; k--) {
                if (k in t && t[k] === searchElement) {
                    return k;
                }
            }
            return -1;
        };
    }
    
    // Add string trim for IE8.
    if (typeof String.prototype.trim !== 'function') {
        String.prototype.trim = function() {
            return this.replace(/^\s+|\s+$/g, ''); 
        }
    }

    var $ = undefined
        , i18n = {}
        , resStore = {}
        , currentLng
        , replacementCounter = 0
        , languages = []
        , initialized = false;

    // defaults
    var o = {
        lng: undefined,
        load: 'all',
        preload: [],
        lowerCaseLng: false,
        returnObjectTrees: false,
        fallbackLng: ['dev'],
        fallbackNS: [],
        detectLngQS: 'setLng',
        ns: 'translation',
        fallbackOnNull: true,
        fallbackOnEmpty: false,
        fallbackToDefaultNS: false,
        nsseparator: ':',
        keyseparator: '.',
        selectorAttr: 'data-i18n',
        debug: false,
        
        resGetPath: 'locales/__lng__/__ns__.json',
        resPostPath: 'locales/add/__lng__/__ns__',
    
        getAsync: true,
        postAsync: true,
    
        resStore: undefined,
        useLocalStorage: false,
        localStorageExpirationTime: 7*24*60*60*1000,
    
        dynamicLoad: false,
        sendMissing: false,
        sendMissingTo: 'fallback', // current | all
        sendType: 'POST',
    
        interpolationPrefix: '__',
        interpolationSuffix: '__',
        reusePrefix: '$t(',
        reuseSuffix: ')',
        pluralSuffix: '_plural',
        pluralNotFound: ['plural_not_found', Math.random()].join(''),
        contextNotFound: ['context_not_found', Math.random()].join(''),
        escapeInterpolation: false,
    
        setJqueryExt: true,
        defaultValueFromContent: true,
        useDataAttrOptions: false,
        cookieExpirationTime: undefined,
        useCookie: true,
        cookieName: 'i18next',
        cookieDomain: undefined,
    
        objectTreeKeyHandler: undefined,
        postProcess: undefined,
        parseMissingKey: undefined,
    
        shortcutFunction: 'sprintf' // or: defaultValue
    };
    function _extend(target, source) {
        if (!source || typeof source === 'function') {
            return target;
        }
    
        for (var attr in source) { target[attr] = source[attr]; }
        return target;
    }
    
    function _each(object, callback, args) {
        var name, i = 0,
            length = object.length,
            isObj = length === undefined || Object.prototype.toString.apply(object) !== '[object Array]' || typeof object === "function";
    
        if (args) {
            if (isObj) {
                for (name in object) {
                    if (callback.apply(object[name], args) === false) {
                        break;
                    }
                }
            } else {
                for ( ; i < length; ) {
                    if (callback.apply(object[i++], args) === false) {
                        break;
                    }
                }
            }
    
        // A special, fast, case for the most common use of each
        } else {
            if (isObj) {
                for (name in object) {
                    if (callback.call(object[name], name, object[name]) === false) {
                        break;
                    }
                }
            } else {
                for ( ; i < length; ) {
                    if (callback.call(object[i], i, object[i++]) === false) {
                        break;
                    }
                }
            }
        }
    
        return object;
    }
    
    var _entityMap = {
        "&": "&amp;",
        "<": "&lt;",
        ">": "&gt;",
        '"': '&quot;',
        "'": '&#39;',
        "/": '&#x2F;'
    };
    
    function _escape(data) {
        if (typeof data === 'string') {
            return data.replace(/[&<>"'\/]/g, function (s) {
                return _entityMap[s];
            });
        }else{
            return data;
        }
    }
    
    function _ajax(options) {
    
        // v0.5.0 of https://github.com/goloroden/http.js
        var getXhr = function (callback) {
            // Use the native XHR object if the browser supports it.
            if (window.XMLHttpRequest) {
                return callback(null, new XMLHttpRequest());
            } else if (window.ActiveXObject) {
                // In Internet Explorer check for ActiveX versions of the XHR object.
                try {
                    return callback(null, new ActiveXObject("Msxml2.XMLHTTP"));
                } catch (e) {
                    return callback(null, new ActiveXObject("Microsoft.XMLHTTP"));
                }
            }
    
            // If no XHR support was found, throw an error.
            return callback(new Error());
        };
    
        var encodeUsingUrlEncoding = function (data) {
            if(typeof data === 'string') {
                return data;
            }
    
            var result = [];
            for(var dataItem in data) {
                if(data.hasOwnProperty(dataItem)) {
                    result.push(encodeURIComponent(dataItem) + '=' + encodeURIComponent(data[dataItem]));
                }
            }
    
            return result.join('&');
        };
    
        var utf8 = function (text) {
            text = text.replace(/\r\n/g, '\n');
            var result = '';
    
            for(var i = 0; i < text.length; i++) {
                var c = text.charCodeAt(i);
    
                if(c < 128) {
                        result += String.fromCharCode(c);
                } else if((c > 127) && (c < 2048)) {
                        result += String.fromCharCode((c >> 6) | 192);
                        result += String.fromCharCode((c & 63) | 128);
                } else {
                        result += String.fromCharCode((c >> 12) | 224);
                        result += String.fromCharCode(((c >> 6) & 63) | 128);
                        result += String.fromCharCode((c & 63) | 128);
                }
            }
    
            return result;
        };
    
        var base64 = function (text) {
            var keyStr = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';
    
            text = utf8(text);
            var result = '',
                    chr1, chr2, chr3,
                    enc1, enc2, enc3, enc4,
                    i = 0;
    
            do {
                chr1 = text.charCodeAt(i++);
                chr2 = text.charCodeAt(i++);
                chr3 = text.charCodeAt(i++);
    
                enc1 = chr1 >> 2;
                enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
                enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
                enc4 = chr3 & 63;
    
                if(isNaN(chr2)) {
                    enc3 = enc4 = 64;
                } else if(isNaN(chr3)) {
                    enc4 = 64;
                }
    
                result +=
                    keyStr.charAt(enc1) +
                    keyStr.charAt(enc2) +
                    keyStr.charAt(enc3) +
                    keyStr.charAt(enc4);
                chr1 = chr2 = chr3 = '';
                enc1 = enc2 = enc3 = enc4 = '';
            } while(i < text.length);
    
            return result;
        };
    
        var mergeHeaders = function () {
            // Use the first header object as base.
            var result = arguments[0];
    
            // Iterate through the remaining header objects and add them.
            for(var i = 1; i < arguments.length; i++) {
                var currentHeaders = arguments[i];
                for(var header in currentHeaders) {
                    if(currentHeaders.hasOwnProperty(header)) {
                        result[header] = currentHeaders[header];
                    }
                }
            }
    
            // Return the merged headers.
            return result;
        };
    
        var ajax = function (method, url, options, callback) {
            // Adjust parameters.
            if(typeof options === 'function') {
                callback = options;
                options = {};
            }
    
            // Set default parameter values.
            options.cache = options.cache || false;
            options.data = options.data || {};
            options.headers = options.headers || {};
            options.jsonp = options.jsonp || false;
            options.async = options.async === undefined ? true : options.async;
    
            // Merge the various header objects.
            var headers = mergeHeaders({
                'accept': '*/*',
                'content-type': 'application/x-www-form-urlencoded;charset=UTF-8'
            }, ajax.headers, options.headers);
    
            // Encode the data according to the content-type.
            var payload;
            if (headers['content-type'] === 'application/json') {
                payload = JSON.stringify(options.data);
            } else {
                payload = encodeUsingUrlEncoding(options.data);
            }
    
            // Specially prepare GET requests: Setup the query string, handle caching and make a JSONP call
            // if neccessary.
            if(method === 'GET') {
                // Setup the query string.
                var queryString = [];
                if(payload) {
                    queryString.push(payload);
                    payload = null;
                }
    
                // Handle caching.
                if(!options.cache) {
                    queryString.push('_=' + (new Date()).getTime());
                }
    
                // If neccessary prepare the query string for a JSONP call.
                if(options.jsonp) {
                    queryString.push('callback=' + options.jsonp);
                    queryString.push('jsonp=' + options.jsonp);
                }
    
                // Merge the query string and attach it to the url.
                queryString = queryString.join('&');
                if (queryString.length > 1) {
                    if (url.indexOf('?') > -1) {
                        url += '&' + queryString;
                    } else {
                        url += '?' + queryString;
                    }
                }
    
                // Make a JSONP call if neccessary.
                if(options.jsonp) {
                    var head = document.getElementsByTagName('head')[0];
                    var script = document.createElement('script');
                    script.type = 'text/javascript';
                    script.src = url;
                    head.appendChild(script);
                    return;
                }
            }
    
            // Since we got here, it is no JSONP request, so make a normal XHR request.
            getXhr(function (err, xhr) {
                if(err) return callback(err);
    
                // Open the request.
                xhr.open(method, url, options.async);
    
                // Set the request headers.
                for(var header in headers) {
                    if(headers.hasOwnProperty(header)) {
                        xhr.setRequestHeader(header, headers[header]);
                    }
                }
    
                // Handle the request events.
                xhr.onreadystatechange = function () {
                    if(xhr.readyState === 4) {
                        var data = xhr.responseText || '';
    
                        // If no callback is given, return.
                        if(!callback) {
                            return;
                        }
    
                        // Return an object that provides access to the data as text and JSON.
                        callback(xhr.status, {
                            text: function () {
                                return data;
                            },
    
                            json: function () {
                                return JSON.parse(data);
                            }
                        });
                    }
                };
    
                // Actually send the XHR request.
                xhr.send(payload);
            });
        };
    
        // Define the external interface.
        var http = {
            authBasic: function (username, password) {
                ajax.headers['Authorization'] = 'Basic ' + base64(username + ':' + password);
            },
    
            connect: function (url, options, callback) {
                return ajax('CONNECT', url, options, callback);
            },
    
            del: function (url, options, callback) {
                return ajax('DELETE', url, options, callback);
            },
    
            get: function (url, options, callback) {
                return ajax('GET', url, options, callback);
            },
    
            head: function (url, options, callback) {
                return ajax('HEAD', url, options, callback);
            },
    
            headers: function (headers) {
                ajax.headers = headers || {};
            },
    
            isAllowed: function (url, verb, callback) {
                this.options(url, function (status, data) {
                    callback(data.text().indexOf(verb) !== -1);
                });
            },
    
            options: function (url, options, callback) {
                return ajax('OPTIONS', url, options, callback);
            },
    
            patch: function (url, options, callback) {
                return ajax('PATCH', url, options, callback);
            },
    
            post: function (url, options, callback) {
                return ajax('POST', url, options, callback);
            },
    
            put: function (url, options, callback) {
                return ajax('PUT', url, options, callback);
            },
    
            trace: function (url, options, callback) {
                return ajax('TRACE', url, options, callback);
            }
        };
    
    
        var methode = options.type ? options.type.toLowerCase() : 'get';
    
        http[methode](options.url, options, function (status, data) {
            if (status === 200) {
                options.success(data.json(), status, null);
            } else {
                options.error(data.text(), status, null);
            }
        });
    }
    
    var _cookie = {
        create: function(name,value,minutes,domain) {
            var expires;
            if (minutes) {
                var date = new Date();
                date.setTime(date.getTime()+(minutes*60*1000));
                expires = "; expires="+date.toGMTString();
            }
            else expires = "";
            domain = (domain)? "domain="+domain+";" : "";
            document.cookie = name+"="+value+expires+";"+domain+"path=/";
        },
    
        read: function(name) {
            var nameEQ = name + "=";
            var ca = document.cookie.split(';');
            for(var i=0;i < ca.length;i++) {
                var c = ca[i];
                while (c.charAt(0)==' ') c = c.substring(1,c.length);
                if (c.indexOf(nameEQ) === 0) return c.substring(nameEQ.length,c.length);
            }
            return null;
        },
    
        remove: function(name) {
            this.create(name,"",-1);
        }
    };
    
    var cookie_noop = {
        create: function(name,value,minutes,domain) {},
        read: function(name) { return null; },
        remove: function(name) {}
    };
    
    
    
    // move dependent functions to a container so that
    // they can be overriden easier in no jquery environment (node.js)
    var f = {
        extend: $ ? $.extend : _extend,
        each: $ ? $.each : _each,
        ajax: $ ? $.ajax : (typeof document !== 'undefined' ? _ajax : function() {}),
        cookie: typeof document !== 'undefined' ? _cookie : cookie_noop,
        detectLanguage: detectLanguage,
        escape: _escape,
        log: function(str) {
            if (o.debug && typeof console !== "undefined") console.log(str);
        },
        toLanguages: function(lng) {
            var languages = [];
            if (typeof lng === 'string' && lng.indexOf('-') > -1) {
                var parts = lng.split('-');
    
                lng = o.lowerCaseLng ?
                    parts[0].toLowerCase() +  '-' + parts[1].toLowerCase() :
                    parts[0].toLowerCase() +  '-' + parts[1].toUpperCase();
    
                if (o.load !== 'unspecific') languages.push(lng);
                if (o.load !== 'current') languages.push(parts[0]);
            } else {
                languages.push(lng);
            }
    
            for (var i = 0; i < o.fallbackLng.length; i++) {
                if (languages.indexOf(o.fallbackLng[i]) === -1 && o.fallbackLng[i]) languages.push(o.fallbackLng[i]);
            }
    
            return languages;
        },
        regexEscape: function(str) {
            return str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&");
        }
    };
    function init(options, cb) {
        
        if (typeof options === 'function') {
            cb = options;
            options = {};
        }
        options = options || {};
        
        // override defaults with passed in options
        f.extend(o, options);
        delete o.fixLng; /* passed in each time */
    
        // create namespace object if namespace is passed in as string
        if (typeof o.ns == 'string') {
            o.ns = { namespaces: [o.ns], defaultNs: o.ns};
        }
    
        // fallback namespaces
        if (typeof o.fallbackNS == 'string') {
            o.fallbackNS = [o.fallbackNS];
        }
    
        // fallback languages
        if (typeof o.fallbackLng == 'string' || typeof o.fallbackLng == 'boolean') {
            o.fallbackLng = [o.fallbackLng];
        }
    
        // escape prefix/suffix
        o.interpolationPrefixEscaped = f.regexEscape(o.interpolationPrefix);
        o.interpolationSuffixEscaped = f.regexEscape(o.interpolationSuffix);
    
        if (!o.lng) o.lng = f.detectLanguage(); 
        if (o.lng) {
            // set cookie with lng set (as detectLanguage will set cookie on need)
            if (o.useCookie) f.cookie.create(o.cookieName, o.lng, o.cookieExpirationTime, o.cookieDomain);
        } else {
            o.lng =  o.fallbackLng[0];
            if (o.useCookie) f.cookie.remove(o.cookieName);
        }
    
        languages = f.toLanguages(o.lng);
        currentLng = languages[0];
        f.log('currentLng set to: ' + currentLng);
    
        var lngTranslate = translate;
        if (options.fixLng) {
            lngTranslate = function(key, options) {
                options = options || {};
                options.lng = options.lng || lngTranslate.lng;
                return translate(key, options);
            };
            lngTranslate.lng = currentLng;
        }
    
        pluralExtensions.setCurrentLng(currentLng);
    
        // add JQuery extensions
        if ($ && o.setJqueryExt) addJqueryFunct();
    
        // jQuery deferred
        var deferred;
        if ($ && $.Deferred) {
            deferred = $.Deferred();
        }
    
        // return immidiatly if res are passed in
        if (o.resStore) {
            resStore = o.resStore;
            initialized = true;
            if (cb) cb(lngTranslate);
            if (deferred) deferred.resolve(lngTranslate);
            if (deferred) return deferred.promise();
            return;
        }
    
        // languages to load
        var lngsToLoad = f.toLanguages(o.lng);
        if (typeof o.preload === 'string') o.preload = [o.preload];
        for (var i = 0, l = o.preload.length; i < l; i++) {
            var pres = f.toLanguages(o.preload[i]);
            for (var y = 0, len = pres.length; y < len; y++) {
                if (lngsToLoad.indexOf(pres[y]) < 0) {
                    lngsToLoad.push(pres[y]);
                }
            }
        }
    
        // else load them
        i18n.sync.load(lngsToLoad, o, function(err, store) {
            resStore = store;
            initialized = true;
    
            if (cb) cb(lngTranslate);
            if (deferred) deferred.resolve(lngTranslate);
        });
    
        if (deferred) return deferred.promise();
    }
    function preload(lngs, cb) {
        if (typeof lngs === 'string') lngs = [lngs];
        for (var i = 0, l = lngs.length; i < l; i++) {
            if (o.preload.indexOf(lngs[i]) < 0) {
                o.preload.push(lngs[i]);
            }
        }
        return init(cb);
    }
    
    function addResourceBundle(lng, ns, resources) {
        if (typeof ns !== 'string') {
            resources = ns;
            ns = o.ns.defaultNs;
        } else if (o.ns.namespaces.indexOf(ns) < 0) {
            o.ns.namespaces.push(ns);
        }
    
        resStore[lng] = resStore[lng] || {};
        resStore[lng][ns] = resStore[lng][ns] || {};
    
        f.extend(resStore[lng][ns], resources);
    }
    
    function removeResourceBundle(lng, ns) {
        if (typeof ns !== 'string') {
            ns = o.ns.defaultNs;
        }
    
        resStore[lng] = resStore[lng] || {};
        resStore[lng][ns] = {};
    }
    
    function setDefaultNamespace(ns) {
        o.ns.defaultNs = ns;
    }
    
    function loadNamespace(namespace, cb) {
        loadNamespaces([namespace], cb);
    }
    
    function loadNamespaces(namespaces, cb) {
        var opts = {
            dynamicLoad: o.dynamicLoad,
            resGetPath: o.resGetPath,
            getAsync: o.getAsync,
            customLoad: o.customLoad,
            ns: { namespaces: namespaces, defaultNs: ''} /* new namespaces to load */
        };
    
        // languages to load
        var lngsToLoad = f.toLanguages(o.lng);
        if (typeof o.preload === 'string') o.preload = [o.preload];
        for (var i = 0, l = o.preload.length; i < l; i++) {
            var pres = f.toLanguages(o.preload[i]);
            for (var y = 0, len = pres.length; y < len; y++) {
                if (lngsToLoad.indexOf(pres[y]) < 0) {
                    lngsToLoad.push(pres[y]);
                }
            }
        }
    
        // check if we have to load
        var lngNeedLoad = [];
        for (var a = 0, lenA = lngsToLoad.length; a < lenA; a++) {
            var needLoad = false;
            var resSet = resStore[lngsToLoad[a]];
            if (resSet) {
                for (var b = 0, lenB = namespaces.length; b < lenB; b++) {
                    if (!resSet[namespaces[b]]) needLoad = true;
                }
            } else {
                needLoad = true;
            }
    
            if (needLoad) lngNeedLoad.push(lngsToLoad[a]);
        }
    
        if (lngNeedLoad.length) {
            i18n.sync._fetch(lngNeedLoad, opts, function(err, store) {
                var todo = namespaces.length * lngNeedLoad.length;
    
                // load each file individual
                f.each(namespaces, function(nsIndex, nsValue) {
    
                    // append namespace to namespace array
                    if (o.ns.namespaces.indexOf(nsValue) < 0) {
                        o.ns.namespaces.push(nsValue);
                    }
    
                    f.each(lngNeedLoad, function(lngIndex, lngValue) {
                        resStore[lngValue] = resStore[lngValue] || {};
                        resStore[lngValue][nsValue] = store[lngValue][nsValue];
    
                        todo--; // wait for all done befor callback
                        if (todo === 0 && cb) {
                            if (o.useLocalStorage) i18n.sync._storeLocal(resStore);
                            cb();
                        }
                    });
                });
            });
        } else {
            if (cb) cb();
        }
    }
    
    function setLng(lng, options, cb) {
        if (typeof options === 'function') {
            cb = options;
            options = {};
        } else if (!options) {
            options = {};
        }
    
        options.lng = lng;
        return init(options, cb);
    }
    
    function lng() {
        return currentLng;
    }
    function addJqueryFunct() {
        // $.t shortcut
        $.t = $.t || translate;
    
        function parse(ele, key, options) {
            if (key.length === 0) return;
    
            var attr = 'text';
    
            if (key.indexOf('[') === 0) {
                var parts = key.split(']');
                key = parts[1];
                attr = parts[0].substr(1, parts[0].length-1);
            }
    
            if (key.indexOf(';') === key.length-1) {
                key = key.substr(0, key.length-2);
            }
    
            var optionsToUse;
            if (attr === 'html') {
                optionsToUse = o.defaultValueFromContent ? $.extend({ defaultValue: ele.html() }, options) : options;
                ele.html($.t(key, optionsToUse));
            } else if (attr === 'text') {
                optionsToUse = o.defaultValueFromContent ? $.extend({ defaultValue: ele.text() }, options) : options;
                ele.text($.t(key, optionsToUse));
            } else if (attr === 'prepend') {
                optionsToUse = o.defaultValueFromContent ? $.extend({ defaultValue: ele.html() }, options) : options;
                ele.prepend($.t(key, optionsToUse));
            } else if (attr === 'append') {
                optionsToUse = o.defaultValueFromContent ? $.extend({ defaultValue: ele.html() }, options) : options;
                ele.append($.t(key, optionsToUse));
            } else if (attr.indexOf("data-") === 0) {
                var dataAttr = attr.substr(("data-").length);
                optionsToUse = o.defaultValueFromContent ? $.extend({ defaultValue: ele.data(dataAttr) }, options) : options;
                var translated = $.t(key, optionsToUse);
                //we change into the data cache
                ele.data(dataAttr, translated);
                //we change into the dom
                ele.attr(attr, translated);
            } else {
                optionsToUse = o.defaultValueFromContent ? $.extend({ defaultValue: ele.attr(attr) }, options) : options;
                ele.attr(attr, $.t(key, optionsToUse));
            }
        }
    
        function localize(ele, options) {
            var key = ele.attr(o.selectorAttr);
            if (!key && typeof key !== 'undefined' && key !== false) key = ele.text() || ele.val();
            if (!key) return;
    
            var target = ele
              , targetSelector = ele.data("i18n-target");
            if (targetSelector) {
                target = ele.find(targetSelector) || ele;
            }
    
            if (!options && o.useDataAttrOptions === true) {
                options = ele.data("i18n-options");
            }
            options = options || {};
    
            if (key.indexOf(';') >= 0) {
                var keys = key.split(';');
    
                $.each(keys, function(m, k) {
                    if (k !== '') parse(target, k, options);
                });
    
            } else {
                parse(target, key, options);
            }
    
            if (o.useDataAttrOptions === true) ele.data("i18n-options", options);
        }
    
        // fn
        $.fn.i18n = function (options) {
            return this.each(function() {
                // localize element itself
                localize($(this), options);
    
                // localize childs
                var elements =  $(this).find('[' + o.selectorAttr + ']');
                elements.each(function() { 
                    localize($(this), options);
                });
            });
        };
    }
    function applyReplacement(str, replacementHash, nestedKey, options) {
        if (!str) return str;
    
        options = options || replacementHash; // first call uses replacement hash combined with options
        if (str.indexOf(options.interpolationPrefix || o.interpolationPrefix) < 0) return str;
    
        var prefix = options.interpolationPrefix ? f.regexEscape(options.interpolationPrefix) : o.interpolationPrefixEscaped
          , suffix = options.interpolationSuffix ? f.regexEscape(options.interpolationSuffix) : o.interpolationSuffixEscaped
          , unEscapingSuffix = 'HTML'+suffix;
    
        f.each(replacementHash, function(key, value) {
            var nextKey = nestedKey ? nestedKey + o.keyseparator + key : key;
            if (typeof value === 'object' && value !== null) {
                str = applyReplacement(str, value, nextKey, options);
            } else {
                if (options.escapeInterpolation || o.escapeInterpolation) {
                    str = str.replace(new RegExp([prefix, nextKey, unEscapingSuffix].join(''), 'g'), value);
                    str = str.replace(new RegExp([prefix, nextKey, suffix].join(''), 'g'), f.escape(value));
                } else {
                    str = str.replace(new RegExp([prefix, nextKey, suffix].join(''), 'g'), value);
                }
                // str = options.escapeInterpolation;
            }
        });
        return str;
    }
    
    // append it to functions
    f.applyReplacement = applyReplacement;
    
    function applyReuse(translated, options) {
        var comma = ',';
        var options_open = '{';
        var options_close = '}';
    
        var opts = f.extend({}, options);
        delete opts.postProcess;
    
        while (translated.indexOf(o.reusePrefix) != -1) {
            replacementCounter++;
            if (replacementCounter > o.maxRecursion) { break; } // safety net for too much recursion
            var index_of_opening = translated.lastIndexOf(o.reusePrefix);
            var index_of_end_of_closing = translated.indexOf(o.reuseSuffix, index_of_opening) + o.reuseSuffix.length;
            var token = translated.substring(index_of_opening, index_of_end_of_closing);
            var token_without_symbols = token.replace(o.reusePrefix, '').replace(o.reuseSuffix, '');
    
    
            if (token_without_symbols.indexOf(comma) != -1) {
                var index_of_token_end_of_closing = token_without_symbols.indexOf(comma);
                if (token_without_symbols.indexOf(options_open, index_of_token_end_of_closing) != -1 && token_without_symbols.indexOf(options_close, index_of_token_end_of_closing) != -1) {
                    var index_of_opts_opening = token_without_symbols.indexOf(options_open, index_of_token_end_of_closing);
                    var index_of_opts_end_of_closing = token_without_symbols.indexOf(options_close, index_of_opts_opening) + options_close.length;
                    try {
                        opts = f.extend(opts, JSON.parse(token_without_symbols.substring(index_of_opts_opening, index_of_opts_end_of_closing)));
                        token_without_symbols = token_without_symbols.substring(0, index_of_token_end_of_closing);
                    } catch (e) {
                    }
                }
            }
    
            var translated_token = _translate(token_without_symbols, opts);
            translated = translated.replace(token, translated_token);
        }
        return translated;
    }
    
    function hasContext(options) {
        return (options.context && (typeof options.context == 'string' || typeof options.context == 'number'));
    }
    
    function needsPlural(options) {
        return (options.count !== undefined && typeof options.count != 'string' && options.count !== 1);
    }
    
    function exists(key, options) {
        options = options || {};
    
        var notFound = _getDefaultValue(key, options)
            , found = _find(key, options);
    
        return found !== undefined || found === notFound;
    }
    
    function translate(key, options) {
        options = options || {};
    
        if (!initialized) {
            f.log('i18next not finished initialization. you might have called t function before loading resources finished.')
            return options.defaultValue || '';
        };
        replacementCounter = 0;
        return _translate.apply(null, arguments);
    }
    
    function _getDefaultValue(key, options) {
        return (options.defaultValue !== undefined) ? options.defaultValue : key;
    }
    
    function _injectSprintfProcessor() {
    
        var values = [];
    
        // mh: build array from second argument onwards
        for (var i = 1; i < arguments.length; i++) {
            values.push(arguments[i]);
        }
    
        return {
            postProcess: 'sprintf',
            sprintf:     values
        };
    }
    
    function _translate(potentialKeys, options) {
        if (options && typeof options !== 'object') {
            if (o.shortcutFunction === 'sprintf') {
                // mh: gettext like sprintf syntax found, automatically create sprintf processor
                options = _injectSprintfProcessor.apply(null, arguments);
            } else if (o.shortcutFunction === 'defaultValue') {
                options = {
                    defaultValue: options
                }
            }
        } else {
            options = options || {};
        }
    
        if (potentialKeys === undefined || potentialKeys === null) return '';
    
        if (typeof potentialKeys == 'string') {
            potentialKeys = [potentialKeys];
        }
    
        var key = potentialKeys[0];
    
        if (potentialKeys.length > 1) {
            for (var i = 0; i < potentialKeys.length; i++) {
                key = potentialKeys[i];
                if (exists(key, options)) {
                    break;
                }
            }
        }
    
        var notFound = _getDefaultValue(key, options)
            , found = _find(key, options)
            , lngs = options.lng ? f.toLanguages(options.lng) : languages
            , ns = options.ns || o.ns.defaultNs
            , parts;
    
        // split ns and key
        if (key.indexOf(o.nsseparator) > -1) {
            parts = key.split(o.nsseparator);
            ns = parts[0];
            key = parts[1];
        }
    
        if (found === undefined && o.sendMissing) {
            if (options.lng) {
                sync.postMissing(lngs[0], ns, key, notFound, lngs);
            } else {
                sync.postMissing(o.lng, ns, key, notFound, lngs);
            }
        }
    
        var postProcessor = options.postProcess || o.postProcess;
        if (found !== undefined && postProcessor) {
            if (postProcessors[postProcessor]) {
                found = postProcessors[postProcessor](found, key, options);
            }
        }
    
        // process notFound if function exists
        var splitNotFound = notFound;
        if (notFound.indexOf(o.nsseparator) > -1) {
            parts = notFound.split(o.nsseparator);
            splitNotFound = parts[1];
        }
        if (splitNotFound === key && o.parseMissingKey) {
            notFound = o.parseMissingKey(notFound);
        }
    
        if (found === undefined) {
            notFound = applyReplacement(notFound, options);
            notFound = applyReuse(notFound, options);
    
            if (postProcessor && postProcessors[postProcessor]) {
                var val = _getDefaultValue(key, options);
                found = postProcessors[postProcessor](val, key, options);
            }
        }
    
        return (found !== undefined) ? found : notFound;
    }
    
    function _find(key, options) {
        options = options || {};
    
        var optionWithoutCount, translated
            , notFound = _getDefaultValue(key, options)
            , lngs = languages;
    
        if (!resStore) { return notFound; } // no resStore to translate from
    
        // CI mode
        if (lngs[0].toLowerCase() === 'cimode') return notFound;
    
        // passed in lng
        if (options.lng) {
            lngs = f.toLanguages(options.lng);
    
            if (!resStore[lngs[0]]) {
                var oldAsync = o.getAsync;
                o.getAsync = false;
    
                i18n.sync.load(lngs, o, function(err, store) {
                    f.extend(resStore, store);
                    o.getAsync = oldAsync;
                });
            }
        }
    
        var ns = options.ns || o.ns.defaultNs;
        if (key.indexOf(o.nsseparator) > -1) {
            var parts = key.split(o.nsseparator);
            ns = parts[0];
            key = parts[1];
        }
    
        if (hasContext(options)) {
            optionWithoutCount = f.extend({}, options);
            delete optionWithoutCount.context;
            optionWithoutCount.defaultValue = o.contextNotFound;
    
            var contextKey = ns + o.nsseparator + key + '_' + options.context;
    
            translated = translate(contextKey, optionWithoutCount);
            if (translated != o.contextNotFound) {
                return applyReplacement(translated, { context: options.context }); // apply replacement for context only
            } // else continue translation with original/nonContext key
        }
    
        if (needsPlural(options)) {
            optionWithoutCount = f.extend({}, options);
            delete optionWithoutCount.count;
            optionWithoutCount.defaultValue = o.pluralNotFound;
    
            var pluralKey = ns + o.nsseparator + key + o.pluralSuffix;
            var pluralExtension = pluralExtensions.get(lngs[0], options.count);
            if (pluralExtension >= 0) {
                pluralKey = pluralKey + '_' + pluralExtension;
            } else if (pluralExtension === 1) {
                pluralKey = ns + o.nsseparator + key; // singular
            }
    
            translated = translate(pluralKey, optionWithoutCount);
            if (translated != o.pluralNotFound) {
                return applyReplacement(translated, {
                    count: options.count,
                    interpolationPrefix: options.interpolationPrefix,
                    interpolationSuffix: options.interpolationSuffix
                }); // apply replacement for count only
            } // else continue translation with original/singular key
        }
    
        var found;
        var keys = key.split(o.keyseparator);
        for (var i = 0, len = lngs.length; i < len; i++ ) {
            if (found !== undefined) break;
    
            var l = lngs[i];
    
            var x = 0;
            var value = resStore[l] && resStore[l][ns];
            while (keys[x]) {
                value = value && value[keys[x]];
                x++;
            }
            if (value !== undefined) {
                var valueType = Object.prototype.toString.apply(value);
                if (typeof value === 'string') {
                    value = applyReplacement(value, options);
                    value = applyReuse(value, options);
                } else if (valueType === '[object Array]' && !o.returnObjectTrees && !options.returnObjectTrees) {
                    value = value.join('\n');
                    value = applyReplacement(value, options);
                    value = applyReuse(value, options);
                } else if (value === null && o.fallbackOnNull === true) {
                    value = undefined;
                } else if (value !== null) {
                    if (!o.returnObjectTrees && !options.returnObjectTrees) {
                        if (o.objectTreeKeyHandler && typeof o.objectTreeKeyHandler == 'function') {
                            value = o.objectTreeKeyHandler(key, value, l, ns, options);
                        } else {
                            value = 'key \'' + ns + ':' + key + ' (' + l + ')\' ' +
                                'returned an object instead of string.';
                            f.log(value);
                        }
                    } else if (valueType !== '[object Number]' && valueType !== '[object Function]' && valueType !== '[object RegExp]') {
                        var copy = (valueType === '[object Array]') ? [] : {}; // apply child translation on a copy
                        f.each(value, function(m) {
                            copy[m] = _translate(ns + o.nsseparator + key + o.keyseparator + m, options);
                        });
                        value = copy;
                    }
                }
    
                if (typeof value === 'string' && value.trim() === '' && o.fallbackOnEmpty === true)
                    value = undefined;
    
                found = value;
            }
        }
    
        if (found === undefined && !options.isFallbackLookup && (o.fallbackToDefaultNS === true || (o.fallbackNS && o.fallbackNS.length > 0))) {
            // set flag for fallback lookup - avoid recursion
            options.isFallbackLookup = true;
    
            if (o.fallbackNS.length) {
    
                for (var y = 0, lenY = o.fallbackNS.length; y < lenY; y++) {
                    found = _find(o.fallbackNS[y] + o.nsseparator + key, options);
    
                    if (found) {
                        /* compare value without namespace */
                        var foundValue = found.indexOf(o.nsseparator) > -1 ? found.split(o.nsseparator)[1] : found
                          , notFoundValue = notFound.indexOf(o.nsseparator) > -1 ? notFound.split(o.nsseparator)[1] : notFound;
    
                        if (foundValue !== notFoundValue) break;
                    }
                }
            } else {
                found = _find(key, options); // fallback to default NS
            }
        }
    
        return found;
    }
    function detectLanguage() {
        var detectedLng;
    
        // get from qs
        var qsParm = [];
        if (typeof window !== 'undefined') {
            (function() {
                var query = window.location.search.substring(1);
                var parms = query.split('&');
                for (var i=0; i<parms.length; i++) {
                    var pos = parms[i].indexOf('=');
                    if (pos > 0) {
                        var key = parms[i].substring(0,pos);
                        var val = parms[i].substring(pos+1);
                        qsParm[key] = val;
                    }
                }
            })();
            if (qsParm[o.detectLngQS]) {
                detectedLng = qsParm[o.detectLngQS];
            }
        }
    
        // get from cookie
        if (!detectedLng && typeof document !== 'undefined' && o.useCookie ) {
            var c = f.cookie.read(o.cookieName);
            if (c) detectedLng = c;
        }
    
        // get from navigator
        if (!detectedLng && typeof navigator !== 'undefined') {
            detectedLng =  (navigator.language) ? navigator.language : navigator.userLanguage;
        }
        
        return detectedLng;
    }
    var sync = {
    
        load: function(lngs, options, cb) {
            if (options.useLocalStorage) {
                sync._loadLocal(lngs, options, function(err, store) {
                    var missingLngs = [];
                    for (var i = 0, len = lngs.length; i < len; i++) {
                        if (!store[lngs[i]]) missingLngs.push(lngs[i]);
                    }
    
                    if (missingLngs.length > 0) {
                        sync._fetch(missingLngs, options, function(err, fetched) {
                            f.extend(store, fetched);
                            sync._storeLocal(fetched);
    
                            cb(null, store);
                        });
                    } else {
                        cb(null, store);
                    }
                });
            } else {
                sync._fetch(lngs, options, function(err, store){
                    cb(null, store);
                });
            }
        },
    
        _loadLocal: function(lngs, options, cb) {
            var store = {}
              , nowMS = new Date().getTime();
    
            if(window.localStorage) {
    
                var todo = lngs.length;
    
                f.each(lngs, function(key, lng) {
                    var local = window.localStorage.getItem('res_' + lng);
    
                    if (local) {
                        local = JSON.parse(local);
    
                        if (local.i18nStamp && local.i18nStamp + options.localStorageExpirationTime > nowMS) {
                            store[lng] = local;
                        }
                    }
    
                    todo--; // wait for all done befor callback
                    if (todo === 0) cb(null, store);
                });
            }
        },
    
        _storeLocal: function(store) {
            if(window.localStorage) {
                for (var m in store) {
                    store[m].i18nStamp = new Date().getTime();
                    window.localStorage.setItem('res_' + m, JSON.stringify(store[m]));
                }
            }
            return;
        },
    
        _fetch: function(lngs, options, cb) {
            var ns = options.ns
              , store = {};
            
            if (!options.dynamicLoad) {
                var todo = ns.namespaces.length * lngs.length
                  , errors;
    
                // load each file individual
                f.each(ns.namespaces, function(nsIndex, nsValue) {
                    f.each(lngs, function(lngIndex, lngValue) {
                        
                        // Call this once our translation has returned.
                        var loadComplete = function(err, data) {
                            if (err) {
                                errors = errors || [];
                                errors.push(err);
                            }
                            store[lngValue] = store[lngValue] || {};
                            store[lngValue][nsValue] = data;
    
                            todo--; // wait for all done befor callback
                            if (todo === 0) cb(errors, store);
                        };
                        
                        if(typeof options.customLoad == 'function'){
                            // Use the specified custom callback.
                            options.customLoad(lngValue, nsValue, options, loadComplete);
                        } else {
                            //~ // Use our inbuilt sync.
                            sync._fetchOne(lngValue, nsValue, options, loadComplete);
                        }
                    });
                });
            } else {
                // Call this once our translation has returned.
                var loadComplete = function(err, data) {
                    cb(null, data);
                };
    
                if(typeof options.customLoad == 'function'){
                    // Use the specified custom callback.
                    options.customLoad(lngs, ns.namespaces, options, loadComplete);
                } else {
                    var url = applyReplacement(options.resGetPath, { lng: lngs.join('+'), ns: ns.namespaces.join('+') });
                    // load all needed stuff once
                    f.ajax({
                        url: url,
                        success: function(data, status, xhr) {
                            f.log('loaded: ' + url);
                            loadComplete(null, data);
                        },
                        error : function(xhr, status, error) {
                            f.log('failed loading: ' + url);
                            loadComplete('failed loading resource.json error: ' + error);
                        },
                        dataType: "json",
                        async : options.getAsync
                    });
                }    
            }
        },
    
        _fetchOne: function(lng, ns, options, done) {
            var url = applyReplacement(options.resGetPath, { lng: lng, ns: ns });
            f.ajax({
                url: url,
                success: function(data, status, xhr) {
                    f.log('loaded: ' + url);
                    done(null, data);
                },
                error : function(xhr, status, error) {
                    if ((status && status == 200) || (xhr && xhr.status && xhr.status == 200)) {
                        // file loaded but invalid json, stop waste time !
                        f.log('There is a typo in: ' + url);
                    } else if ((status && status == 404) || (xhr && xhr.status && xhr.status == 404)) {
                        f.log('Does not exist: ' + url);
                    } else {
                        var theStatus = status ? status : ((xhr && xhr.status) ? xhr.status : null);
                        f.log(theStatus + ' when loading ' + url);
                    }
                    
                    done(error, {});
                },
                dataType: "json",
                async : options.getAsync
            });
        },
    
        postMissing: function(lng, ns, key, defaultValue, lngs) {
            var payload = {};
            payload[key] = defaultValue;
    
            var urls = [];
    
            if (o.sendMissingTo === 'fallback' && o.fallbackLng[0] !== false) {
                for (var i = 0; i < o.fallbackLng.length; i++) {
                    urls.push({lng: o.fallbackLng[i], url: applyReplacement(o.resPostPath, { lng: o.fallbackLng[i], ns: ns })});
                }
            } else if (o.sendMissingTo === 'current' || (o.sendMissingTo === 'fallback' && o.fallbackLng[0] === false) ) {
                urls.push({lng: lng, url: applyReplacement(o.resPostPath, { lng: lng, ns: ns })});
            } else if (o.sendMissingTo === 'all') {
                for (var i = 0, l = lngs.length; i < l; i++) {
                    urls.push({lng: lngs[i], url: applyReplacement(o.resPostPath, { lng: lngs[i], ns: ns })});
                }
            }
    
            for (var y = 0, len = urls.length; y < len; y++) {
                var item = urls[y];
                f.ajax({
                    url: item.url,
                    type: o.sendType,
                    data: payload,
                    success: function(data, status, xhr) {
                        f.log('posted missing key \'' + key + '\' to: ' + item.url);
    
                        // add key to resStore
                        var keys = key.split('.');
                        var x = 0;
                        var value = resStore[item.lng][ns];
                        while (keys[x]) {
                            if (x === keys.length - 1) {
                                value = value[keys[x]] = defaultValue;
                            } else {
                                value = value[keys[x]] = value[keys[x]] || {};
                            }
                            x++;
                        }
                    },
                    error : function(xhr, status, error) {
                        f.log('failed posting missing key \'' + key + '\' to: ' + item.url);
                    },
                    dataType: "json",
                    async : o.postAsync
                });
            }
        }
    };
    // definition http://translate.sourceforge.net/wiki/l10n/pluralforms
    var pluralExtensions = {
    
        rules: {
            "ach": {
                "name": "Acholi", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n > 1); }
            }, 
            "af": {
                "name": "Afrikaans", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "ak": {
                "name": "Akan", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n > 1); }
            }, 
            "am": {
                "name": "Amharic", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n > 1); }
            }, 
            "an": {
                "name": "Aragonese", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "ar": {
                "name": "Arabic", 
                "numbers": [
                    0, 
                    1, 
                    2, 
                    3, 
                    11, 
                    100
                ], 
                "plurals": function(n) { return Number(n===0 ? 0 : n==1 ? 1 : n==2 ? 2 : n%100>=3 && n%100<=10 ? 3 : n%100>=11 ? 4 : 5); }
            }, 
            "arn": {
                "name": "Mapudungun", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n > 1); }
            }, 
            "ast": {
                "name": "Asturian", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "ay": {
                "name": "Aymar\u00e1", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "az": {
                "name": "Azerbaijani", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "be": {
                "name": "Belarusian", 
                "numbers": [
                    1, 
                    2, 
                    5
                ], 
                "plurals": function(n) { return Number(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2); }
            }, 
            "bg": {
                "name": "Bulgarian", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "bn": {
                "name": "Bengali", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "bo": {
                "name": "Tibetan", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "br": {
                "name": "Breton", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n > 1); }
            }, 
            "bs": {
                "name": "Bosnian", 
                "numbers": [
                    1, 
                    2, 
                    5
                ], 
                "plurals": function(n) { return Number(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2); }
            }, 
            "ca": {
                "name": "Catalan", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "cgg": {
                "name": "Chiga", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "cs": {
                "name": "Czech", 
                "numbers": [
                    1, 
                    2, 
                    5
                ], 
                "plurals": function(n) { return Number((n==1) ? 0 : (n>=2 && n<=4) ? 1 : 2); }
            }, 
            "csb": {
                "name": "Kashubian", 
                "numbers": [
                    1, 
                    2, 
                    5
                ], 
                "plurals": function(n) { return Number(n==1 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2); }
            }, 
            "cy": {
                "name": "Welsh", 
                "numbers": [
                    1, 
                    2, 
                    3, 
                    8
                ], 
                "plurals": function(n) { return Number((n==1) ? 0 : (n==2) ? 1 : (n != 8 && n != 11) ? 2 : 3); }
            }, 
            "da": {
                "name": "Danish", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "de": {
                "name": "German", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "dz": {
                "name": "Dzongkha", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "el": {
                "name": "Greek", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "en": {
                "name": "English", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "eo": {
                "name": "Esperanto", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "es": {
                "name": "Spanish", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "es_ar": {
                "name": "Argentinean Spanish", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "et": {
                "name": "Estonian", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "eu": {
                "name": "Basque", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "fa": {
                "name": "Persian", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "fi": {
                "name": "Finnish", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "fil": {
                "name": "Filipino", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n > 1); }
            }, 
            "fo": {
                "name": "Faroese", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "fr": {
                "name": "French", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n > 1); }
            }, 
            "fur": {
                "name": "Friulian", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "fy": {
                "name": "Frisian", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "ga": {
                "name": "Irish", 
                "numbers": [
                    1, 
                    2,
                    3,
                    7, 
                    11
                ], 
                "plurals": function(n) { return Number(n==1 ? 0 : n==2 ? 1 : n<7 ? 2 : n<11 ? 3 : 4) ;}
            }, 
            "gd": {
                "name": "Scottish Gaelic", 
                "numbers": [
                    1, 
                    2, 
                    3,
                    20
                ], 
                "plurals": function(n) { return Number((n==1 || n==11) ? 0 : (n==2 || n==12) ? 1 : (n > 2 && n < 20) ? 2 : 3); }
            }, 
            "gl": {
                "name": "Galician", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "gu": {
                "name": "Gujarati", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "gun": {
                "name": "Gun", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n > 1); }
            }, 
            "ha": {
                "name": "Hausa", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "he": {
                "name": "Hebrew", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "hi": {
                "name": "Hindi", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "hr": {
                "name": "Croatian", 
                "numbers": [
                    1, 
                    2,
                    5
                ], 
                "plurals": function(n) { return Number(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2); }
            }, 
            "hu": {
                "name": "Hungarian", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "hy": {
                "name": "Armenian", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "ia": {
                "name": "Interlingua", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "id": {
                "name": "Indonesian", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "is": {
                "name": "Icelandic", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n%10!=1 || n%100==11); }
            }, 
            "it": {
                "name": "Italian", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "ja": {
                "name": "Japanese", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "jbo": {
                "name": "Lojban", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "jv": {
                "name": "Javanese", 
                "numbers": [
                    0, 
                    1
                ], 
                "plurals": function(n) { return Number(n !== 0); }
            }, 
            "ka": {
                "name": "Georgian", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "kk": {
                "name": "Kazakh", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "km": {
                "name": "Khmer", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "kn": {
                "name": "Kannada", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "ko": {
                "name": "Korean", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "ku": {
                "name": "Kurdish", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "kw": {
                "name": "Cornish", 
                "numbers": [
                    1, 
                    2, 
                    3,
                    4
                ], 
                "plurals": function(n) { return Number((n==1) ? 0 : (n==2) ? 1 : (n == 3) ? 2 : 3); }
            }, 
            "ky": {
                "name": "Kyrgyz", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "lb": {
                "name": "Letzeburgesch", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "ln": {
                "name": "Lingala", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n > 1); }
            }, 
            "lo": {
                "name": "Lao", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "lt": {
                "name": "Lithuanian", 
                "numbers": [
                    1, 
                    2,
                    10
                ], 
                "plurals": function(n) { return Number(n%10==1 && n%100!=11 ? 0 : n%10>=2 && (n%100<10 || n%100>=20) ? 1 : 2); }
            }, 
            "lv": {
                "name": "Latvian", 
                "numbers": [
                    1, 
                    2, 
                    0
                ], 
                "plurals": function(n) { return Number(n%10==1 && n%100!=11 ? 0 : n !== 0 ? 1 : 2); }
            }, 
            "mai": {
                "name": "Maithili", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "mfe": {
                "name": "Mauritian Creole", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n > 1); }
            }, 
            "mg": {
                "name": "Malagasy", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n > 1); }
            }, 
            "mi": {
                "name": "Maori", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n > 1); }
            }, 
            "mk": {
                "name": "Macedonian", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n==1 || n%10==1 ? 0 : 1); }
            }, 
            "ml": {
                "name": "Malayalam", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "mn": {
                "name": "Mongolian", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "mnk": {
                "name": "Mandinka", 
                "numbers": [
                    0, 
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(0 ? 0 : n==1 ? 1 : 2); }
            }, 
            "mr": {
                "name": "Marathi", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "ms": {
                "name": "Malay", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "mt": {
                "name": "Maltese", 
                "numbers": [
                    1, 
                    2, 
                    11, 
                    20
                ], 
                "plurals": function(n) { return Number(n==1 ? 0 : n===0 || ( n%100>1 && n%100<11) ? 1 : (n%100>10 && n%100<20 ) ? 2 : 3); }
            }, 
            "nah": {
                "name": "Nahuatl", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "nap": {
                "name": "Neapolitan", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "nb": {
                "name": "Norwegian Bokmal", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "ne": {
                "name": "Nepali", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "nl": {
                "name": "Dutch", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "nn": {
                "name": "Norwegian Nynorsk", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "no": {
                "name": "Norwegian", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "nso": {
                "name": "Northern Sotho", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "oc": {
                "name": "Occitan", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n > 1); }
            }, 
            "or": {
                "name": "Oriya", 
                "numbers": [
                    2, 
                    1
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "pa": {
                "name": "Punjabi", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "pap": {
                "name": "Papiamento", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "pl": {
                "name": "Polish", 
                "numbers": [
                    1, 
                    2,
                    5
                ], 
                "plurals": function(n) { return Number(n==1 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2); }
            }, 
            "pms": {
                "name": "Piemontese", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "ps": {
                "name": "Pashto", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "pt": {
                "name": "Portuguese", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "pt_br": {
                "name": "Brazilian Portuguese", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "rm": {
                "name": "Romansh", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "ro": {
                "name": "Romanian", 
                "numbers": [
                    1, 
                    2,
                    20
                ], 
                "plurals": function(n) { return Number(n==1 ? 0 : (n===0 || (n%100 > 0 && n%100 < 20)) ? 1 : 2); }
            }, 
            "ru": {
                "name": "Russian", 
                "numbers": [
                    1, 
                    2, 
                    5
                ], 
                "plurals": function(n) { return Number(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2); }
            }, 
            "sah": {
                "name": "Yakut", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "sco": {
                "name": "Scots", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "se": {
                "name": "Northern Sami", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "si": {
                "name": "Sinhala", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "sk": {
                "name": "Slovak", 
                "numbers": [
                    1, 
                    2, 
                    5
                ], 
                "plurals": function(n) { return Number((n==1) ? 0 : (n>=2 && n<=4) ? 1 : 2); }
            }, 
            "sl": {
                "name": "Slovenian", 
                "numbers": [
                    5, 
                    1, 
                    2, 
                    3
                ], 
                "plurals": function(n) { return Number(n%100==1 ? 1 : n%100==2 ? 2 : n%100==3 || n%100==4 ? 3 : 0); }
            }, 
            "so": {
                "name": "Somali", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "son": {
                "name": "Songhay", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "sq": {
                "name": "Albanian", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "sr": {
                "name": "Serbian", 
                "numbers": [
                    1, 
                    2,
                    5
                ], 
                "plurals": function(n) { return Number(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2); }
            }, 
            "su": {
                "name": "Sundanese", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "sv": {
                "name": "Swedish", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "sw": {
                "name": "Swahili", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "ta": {
                "name": "Tamil", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "te": {
                "name": "Telugu", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "tg": {
                "name": "Tajik", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n > 1); }
            }, 
            "th": {
                "name": "Thai", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "ti": {
                "name": "Tigrinya", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n > 1); }
            }, 
            "tk": {
                "name": "Turkmen", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "tr": {
                "name": "Turkish", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n > 1); }
            }, 
            "tt": {
                "name": "Tatar", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "ug": {
                "name": "Uyghur", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "uk": {
                "name": "Ukrainian", 
                "numbers": [
                    1, 
                    2,
                    5
                ], 
                "plurals": function(n) { return Number(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2); }
            }, 
            "ur": {
                "name": "Urdu", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "uz": {
                "name": "Uzbek", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n > 1); }
            }, 
            "vi": {
                "name": "Vietnamese", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "wa": {
                "name": "Walloon", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n > 1); }
            }, 
            "wo": {
                "name": "Wolof", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }, 
            "yo": {
                "name": "Yoruba", 
                "numbers": [
                    1, 
                    2
                ], 
                "plurals": function(n) { return Number(n != 1); }
            }, 
            "zh": {
                "name": "Chinese", 
                "numbers": [
                    1
                ], 
                "plurals": function(n) { return 0; }
            }
        },
    
        // for demonstration only sl and ar is added but you can add your own pluralExtensions
        addRule: function(lng, obj) {
            pluralExtensions.rules[lng] = obj;    
        },
    
        setCurrentLng: function(lng) {
            if (!pluralExtensions.currentRule || pluralExtensions.currentRule.lng !== lng) {
                var parts = lng.split('-');
    
                pluralExtensions.currentRule = {
                    lng: lng,
                    rule: pluralExtensions.rules[parts[0]]
                };
            }
        },
    
        get: function(lng, count) {
            var parts = lng.split('-');
    
            function getResult(l, c) {
                var ext;
                if (pluralExtensions.currentRule && pluralExtensions.currentRule.lng === lng) {
                    ext = pluralExtensions.currentRule.rule; 
                } else {
                    ext = pluralExtensions.rules[l];
                }
                if (ext) {
                    var i = ext.plurals(c);
                    var number = ext.numbers[i];
                    if (ext.numbers.length === 2 && ext.numbers[0] === 1) {
                        if (number === 2) { 
                            number = -1; // regular plural
                        } else if (number === 1) {
                            number = 1; // singular
                        }
                    }//console.log(count + '-' + number);
                    return number;
                } else {
                    return c === 1 ? '1' : '-1';
                }
            }
                        
            return getResult(parts[0], count);
        }
    
    };
    var postProcessors = {};
    var addPostProcessor = function(name, fc) {
        postProcessors[name] = fc;
    };
    // sprintf support
    var sprintf = (function() {
        function get_type(variable) {
            return Object.prototype.toString.call(variable).slice(8, -1).toLowerCase();
        }
        function str_repeat(input, multiplier) {
            for (var output = []; multiplier > 0; output[--multiplier] = input) {/* do nothing */}
            return output.join('');
        }
    
        var str_format = function() {
            if (!str_format.cache.hasOwnProperty(arguments[0])) {
                str_format.cache[arguments[0]] = str_format.parse(arguments[0]);
            }
            return str_format.format.call(null, str_format.cache[arguments[0]], arguments);
        };
    
        str_format.format = function(parse_tree, argv) {
            var cursor = 1, tree_length = parse_tree.length, node_type = '', arg, output = [], i, k, match, pad, pad_character, pad_length;
            for (i = 0; i < tree_length; i++) {
                node_type = get_type(parse_tree[i]);
                if (node_type === 'string') {
                    output.push(parse_tree[i]);
                }
                else if (node_type === 'array') {
                    match = parse_tree[i]; // convenience purposes only
                    if (match[2]) { // keyword argument
                        arg = argv[cursor];
                        for (k = 0; k < match[2].length; k++) {
                            if (!arg.hasOwnProperty(match[2][k])) {
                                throw(sprintf('[sprintf] property "%s" does not exist', match[2][k]));
                            }
                            arg = arg[match[2][k]];
                        }
                    }
                    else if (match[1]) { // positional argument (explicit)
                        arg = argv[match[1]];
                    }
                    else { // positional argument (implicit)
                        arg = argv[cursor++];
                    }
    
                    if (/[^s]/.test(match[8]) && (get_type(arg) != 'number')) {
                        throw(sprintf('[sprintf] expecting number but found %s', get_type(arg)));
                    }
                    switch (match[8]) {
                        case 'b': arg = arg.toString(2); break;
                        case 'c': arg = String.fromCharCode(arg); break;
                        case 'd': arg = parseInt(arg, 10); break;
                        case 'e': arg = match[7] ? arg.toExponential(match[7]) : arg.toExponential(); break;
                        case 'f': arg = match[7] ? parseFloat(arg).toFixed(match[7]) : parseFloat(arg); break;
                        case 'o': arg = arg.toString(8); break;
                        case 's': arg = ((arg = String(arg)) && match[7] ? arg.substring(0, match[7]) : arg); break;
                        case 'u': arg = Math.abs(arg); break;
                        case 'x': arg = arg.toString(16); break;
                        case 'X': arg = arg.toString(16).toUpperCase(); break;
                    }
                    arg = (/[def]/.test(match[8]) && match[3] && arg >= 0 ? '+'+ arg : arg);
                    pad_character = match[4] ? match[4] == '0' ? '0' : match[4].charAt(1) : ' ';
                    pad_length = match[6] - String(arg).length;
                    pad = match[6] ? str_repeat(pad_character, pad_length) : '';
                    output.push(match[5] ? arg + pad : pad + arg);
                }
            }
            return output.join('');
        };
    
        str_format.cache = {};
    
        str_format.parse = function(fmt) {
            var _fmt = fmt, match = [], parse_tree = [], arg_names = 0;
            while (_fmt) {
                if ((match = /^[^\x25]+/.exec(_fmt)) !== null) {
                    parse_tree.push(match[0]);
                }
                else if ((match = /^\x25{2}/.exec(_fmt)) !== null) {
                    parse_tree.push('%');
                }
                else if ((match = /^\x25(?:([1-9]\d*)\$|\(([^\)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-fosuxX])/.exec(_fmt)) !== null) {
                    if (match[2]) {
                        arg_names |= 1;
                        var field_list = [], replacement_field = match[2], field_match = [];
                        if ((field_match = /^([a-z_][a-z_\d]*)/i.exec(replacement_field)) !== null) {
                            field_list.push(field_match[1]);
                            while ((replacement_field = replacement_field.substring(field_match[0].length)) !== '') {
                                if ((field_match = /^\.([a-z_][a-z_\d]*)/i.exec(replacement_field)) !== null) {
                                    field_list.push(field_match[1]);
                                }
                                else if ((field_match = /^\[(\d+)\]/.exec(replacement_field)) !== null) {
                                    field_list.push(field_match[1]);
                                }
                                else {
                                    throw('[sprintf] huh?');
                                }
                            }
                        }
                        else {
                            throw('[sprintf] huh?');
                        }
                        match[2] = field_list;
                    }
                    else {
                        arg_names |= 2;
                    }
                    if (arg_names === 3) {
                        throw('[sprintf] mixing positional and named placeholders is not (yet) supported');
                    }
                    parse_tree.push(match);
                }
                else {
                    throw('[sprintf] huh?');
                }
                _fmt = _fmt.substring(match[0].length);
            }
            return parse_tree;
        };
    
        return str_format;
    })();
    
    var vsprintf = function(fmt, argv) {
        argv.unshift(fmt);
        return sprintf.apply(null, argv);
    };
    
    addPostProcessor("sprintf", function(val, key, opts) {
        if (!opts.sprintf) return val;
    
        if (Object.prototype.toString.apply(opts.sprintf) === '[object Array]') {
            return vsprintf(val, opts.sprintf);
        } else if (typeof opts.sprintf === 'object') {
            return sprintf(val, opts.sprintf);
        }
    
        return val;
    });
    // public api interface
    i18n.init = init;
    i18n.setLng = setLng;
    i18n.preload = preload;
    i18n.addResourceBundle = addResourceBundle;
    i18n.removeResourceBundle = removeResourceBundle;
    i18n.loadNamespace = loadNamespace;
    i18n.loadNamespaces = loadNamespaces;
    i18n.setDefaultNamespace = setDefaultNamespace;
    i18n.t = translate;
    i18n.translate = translate;
    i18n.exists = exists;
    i18n.detectLanguage = f.detectLanguage;
    i18n.pluralExtensions = pluralExtensions;
    i18n.sync = sync;
    i18n.functions = f;
    i18n.lng = lng;
    i18n.addPostProcessor = addPostProcessor;
    i18n.options = o;
        
    return i18n; 

}));
!function(e){"object"==typeof exports?module.exports=e():"function"==typeof define&&define.amd?define('lab-grapher',e):"undefined"!=typeof window?window.LabGrapher=e():"undefined"!=typeof global?global.LabGrapher=e():"undefined"!=typeof self&&(self.LabGrapher=e())}(function(){var define,module,exports;return (function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);throw new Error("Cannot find module '"+o+"'")}var f=n[o]={exports:{}};t[o][0].call(f.exports,function(e){var n=t[o][1][e];return s(n?n:e)},f,f.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){
module.exports.numberWidth = function(elem, cx, cy, fontSizeInPixels, numberStr) {
  var testSVG,
      testText,
      bbox,
      width,
      height,
      node;

  testSVG = elem.append("svg")
    .attr("width",  cx)
    .attr("height", cy)
    .attr("class", "graph");

  testText = testSVG.append('g')
    .append("text")
      .attr("class", "axis")
      .attr("x", -fontSizeInPixels/4 + "px")
      .attr("dy", ".35em")
      .attr("text-anchor", "end")
      .text(numberStr);

  node = testText.node();

  // This code is sometimes called by tests that use d3's jsdom-based mock SVG DOm, which
  // doesn't implement getBBox.
  if (node.getBBox) {
    bbox = testText.node().getBBox();
    width = bbox.width;
    height = bbox.height;
  } else {
    width = 0;
    height = 0;
  }

  testSVG.remove();
  return [width, height];
};

module.exports.axisProcessDrag = function(dragstart, currentdrag, domain) {
  var originExtent, maxDragIn,
      newdomain = domain,
      origin = 0,
      axis1 = domain[0],
      axis2 = domain[1],
      extent = axis2 - axis1;
  if (currentdrag !== 0) {
    if  ((axis1 >= 0) && (axis2 > axis1)) {                 // example: (20, 10, [0, 40]) => [0, 80]
      origin = axis1;
      originExtent = dragstart-origin;
      maxDragIn = originExtent * 0.4 + origin;
      if (currentdrag > maxDragIn) {
        change = originExtent / (currentdrag-origin);
        extent = axis2 - origin;
        newdomain = [axis1, axis1 + (extent * change)];
      }
    } else if ((axis1 < 0) && (axis2 > 0)) {                // example: (20, 10, [-40, 40])       => [-80, 80]
      origin = 0;                                           //          (-0.4, -0.2, [-1.0, 0.4]) => [-1.0, 0.4]
      originExtent = dragstart-origin;
      maxDragIn = originExtent * 0.4 + origin;
      if ((dragstart >= 0 && currentdrag > maxDragIn) || (dragstart  < 0  && currentdrag < maxDragIn)) {
        change = originExtent / (currentdrag-origin);
        newdomain = [axis1 * change, axis2 * change];
      }
    } else if ((axis1 < 0) && (axis2 < 0)) {                // example: (-60, -50, [-80, -40]) => [-120, -40]
      origin = axis2;
      originExtent = dragstart-origin;
      maxDragIn = originExtent * 0.4 + origin;
      if (currentdrag < maxDragIn) {
        change = originExtent / (currentdrag-origin);
        extent = axis1 - origin;
        newdomain = [axis2 + (extent * change), axis2];
      }
    }
  }
  newdomain[0] = +newdomain[0].toPrecision(5);
  newdomain[1] = +newdomain[1].toPrecision(5);
  return newdomain;
};

},{}],2:[function(require,module,exports){
var axis = require('./axis');
var i18n = require('./i18n');

module.exports = function Graph(idOrElement, options, message) {
  var api = {},   // Public API object to be returned.

      // D3 selection of the containing DOM element the graph is placed in
      elem,

      // Regular representation of containing DOM element the graph is placed in
      node,

      // JQuerified version of DOM element
      $node,

      // Size of containing DOM element
      cx, cy,

      // Calculated padding between edges of DOM container and interior plot area of graph.
      padding,

      // Object containing width and height in pixels of interior plot area of graph
      size,

      // D3 objects representing SVG elements/containers in graph
      svg,
      vis,
      plot,
      viewbox,
      title,
      xlabel,
      ylabel,
      selectedRulerX,
      selectedRulerY,

      // Strings used as tooltips when labels are visible but are truncated because
      // they are too big to be rendered into the space the graph allocates
      titleTooltip,

      // Instantiated D3 scale functions
      // currently either d3.scale.linear, d3.scale.log, or d3.scale.pow
      xScale,
      yScale,

      // The approximate number of gridlines in the plot, passed to d3.scale.ticks() function
      xTickCount,
      yTickCount,

      // Instantiated D3 line function: d3.svg.line()
      line,

      // numeric format functions wrapping the d3.format() functions
      fx,
      fy,

      // Instantiated D3 numeric format functions: d3.format()
      fx_d3,
      fy_d3,

      // Function for stroke styling of major and minor grid lines
      gridStroke = function(d) { return d ? "#ccc" : "#666"; },

      // Functions for translation of grid lines and associated numeric labels
      tx = function(d) { return "translate(" + xScale(d) + ",0)"; },
      ty = function(d) { return "translate(0," + yScale(d) + ")"; },

      // Div created and placed with z-index above all other graph layers that holds
      // graph action/mode buttons.
      buttonLayer,
      legendLayer,
      legendButton,
      selectionButton,
      drawButton,

      // div created above everything but the button layer for holding annotations
      annotationLayer,

      // Div created and placed with z-index under all other graph layers
      background,

      // Div created and placed with z-index under title.
      // It isn't styled by default, but it can be done by custom theme.
      titleBackground,

      // Optional string which can be displayed in background of interior plot area of graph.
      notification,

      // Optonal set of annotations that can be added dynamically to call out features of a graph
      annotations = [],

      // An array of strings holding 0 or more lines for the title of the graph
      titles = [],

      // D3 selection containing canvas
      graphCanvas,

      // HTML5 Canvas object containing just plotted lines
      gcanvas,
      gctx,
      canvasFillStyle = "rgba(255,255,255, 0.0)",

      // The style of the cursor when hovering over a sample.point marker.
      // The cursor changes depending on the operations that can be performed.
      markerCursorStyle,

      // Metrics calculated to support layout of titles, axes as
      // well as text and numeric labels for axes.
      fontSizeInPixels,
      halfFontSizeInPixels,
      quarterFontSizeInPixels,
      titleFontSizeInPixels,
      axisFontSizeInPixels,
      xlabelFontSizeInPixels,
      ylabelFontSizeInPixels,

      // Array objects containing width and height of X and Y axis labels
      xlabelMetrics,
      ylabelMetrics,

      // Width of widest numeric labels on X and Y axes
      xAxisNumberWidth,
      yAxisNumberWidth,

      // Height of numeric labels on X and Y axes
      xAxisNumberHeight,
      yAxisNumberHeight,

      // Padding necessary for X and Y axis labels to leave enough room for numeric labels
      xAxisVerticalPadding,
      yAxisHorizontalPadding,

      // Padding necessary between right side of interior plot and edge of graph so
      // make room for numeric lanel on right edge of X axis.
      xAxisLabelHorizontalPadding,

      // Baselines calculated for positioning of X and Y axis labels.
      xAxisLabelBaseline,
      yAxisLabelBaseline,

      // Thickness of draggable areas for rescaling axes, these surround numeric labels
      xAxisDraggableHeight,
      yAxisDraggableWidth,

      // D3 SVG rects used to implement axis dragging
      xAxisDraggable,
      yAxisDraggable,

      // Strings used as tooltips when numeric axis draggables are visible but responsive
      // layout system has removed the axis labels because of small size of graph.
      xAxisDraggableTooltip,
      yAxisDraggableTooltip,

      // Used to calculate styles for markers appearing on samples/points (normally circles)
      markerRadius,
      markerStrokeWidth,

      // Stroke width used for lines in graph
      lineWidth,

      // Used to categorize size of graphs in responsive layout mode where
      // certain graph chrome is removed when graph is rendered smaller.
      sizeType = {
        category: "medium",
        value: 3,
        icon: 120,
        tiny: 240,
        small: 480,
        medium: 960,
        large: 1920
      },

      // Padding of a title when it's placed on the left side.
      titleLeftPadding = "10px",

      // State variables indicating whether an axis drag operation is in place.
      // NaN values are used to indicate operation not in progress and
      // checked like this: if (!isNaN(downx)) { resacle operation in progress }
      //
      // When drag/rescale operation is occuring values contain plot
      // coordinates of start of drag (0 is a valid value).
      downx = NaN,
      downy = NaN,

      // State variable indicating whether a data point is being dragged.
      // When data point drag operation is occuring value contain two element
      // array wiith plot coordinates of drag position.
      draggedPoint = null,

      // When a data point is selected contains two element array wiith plot coordinates
      // of selected data point.
      selected = null,

      // An array of data points in the plot which are near the cursor.
      // Normally used to temporarily display data point markers when cursor
      // is nearby when markAllDataPoints is disabled.
      selectable = [],

      // An array containing two-element arrays consisting of X and Y values for samples/points
      points = [],

      // Consumers of points that have been added by user clicks
      pointListeners = [],

      // An array containing 1 or more points arrays to be plotted. Data is not indexed here
      // and sorted when "sortPoints" option is enabled.
      pointArray,

      // Keeps the same set of points like pointArray, but data is not sorted, but provides
      // indexing instead.
      pointArrayIndexed,

      // Current extent of points plotted by graph.
      pointsXMin,
      pointsXMax,
      pointsYMin,
      pointsYMax,

      // Index into points array for current sample/point.
      // Normally references data point last added.
      // Current sample can refer to earlier points. This is
      // represented in the view by using a desaturated styling for
      // plotted data after te currentSample.
      currentSample,

      // When graphing data samples as opposed to [x, y] data pairs contains
      // the fixed time interval between subsequent samples.
      sampleInterval,

      // Normally data sent to graph as samples starts at an X value of 0
      // A different starting x value can be set
      dataSampleStart,

      // The default options for a graph
      default_options = {
        // Enables the button layer with: AutoScale...
        showButtons: true,
        // "icons" or "text".
        buttonsStyle: "icons",
        // "vertical" (overlaps with the plotting area) or "horizontal" (right below the title).
        buttonsLayout: "vertical",

        // Whether or not to show the graph's legend
        legendVisible: false,

        // Responsive Layout provides progressive removal of
        // graph elements when size gets smaller
        responsiveLayout: false,

        // Font sizes for graphs are normally specified using ems.
        // When fontScaleRelativeToParent to true the font-size of the
        // containing element is set based on the size of the containing
        // element. hs means whn the containing element is smaller the
        // font-size of the labels in the graph will be smaller.
        fontScaleRelativeToParent: true,
        hideAxisValues: false,

        enableAutoScaleButton: true,
        enableAxisScaling: true,
        enableZooming: true,

        enableSelectionButton: false,
        clearSelectionOnLeavingSelectMode: false,

        enableDrawButton: false,
        enableLegendButton: true,

        titlePosition: "center", // or "left"

        drawIndex: 0,

        //
        // dataType can be either 'points or 'samples'
        //
        dataType: 'points',
        //
        // dataType: 'points'
        //
        // Arrays of two-element arrays of x, y data pairs, this is the internal
        // format the graphers uses to represent data.
        dataPoints:      [],
        //
        // dataType: 'samples'
        //
        // An array of samples (or an array or arrays of samples)
        dataSamples:     [],
        // The constant time interval between sample values
        sampleInterval:  1,
        // Normally data sent to graph as samples starts at an X value of 0
        // A different starting x value can be set
        dataSampleStart: 0,

        // If true then all points added to graph will be sorted by X coordinate.
        sortPoints:      true,

        // title can be a string or an array of strings, if an
        // array of strings each element is on a separate line.
        title:          "graph",

        // The labels for the axes, these are separate from the numeric labels.
        xlabel:         "x-axis",
        ylabel:         "y-axis",

        // Initial extent of the X and Y axes.
        xmax:            10,
        xmin:            0,
        ymax:            10,
        ymin:            0,

        // Auto-scaling of X axis when at least one point exceeds current domain.
        autoScaleX:       true,
        autoScaleY:       true,
        autoScalePadding: 0.3,

        // Approximate values for how many gridlines should appear on the axes.
        xTickCount:      10,
        yTickCount:      10,

        // The formatter strings used to convert numbers into strings.
        // see: https://github.com/mbostock/d3/wiki/Formatting#wiki-d3_format
        xFormatter:      ".3s",
        yFormatter:      ".3s",

        // Scale type: options are:
        //   linear: https://github.com/mbostock/d3/wiki/Quantitative-Scales#wiki-linear
        //   log:    https://github.com/mbostock/d3/wiki/Quantitative-Scales#wiki-log
        //   pow:    https://github.com/mbostock/d3/wiki/Quantitative-Scales#wiki-pow
        xscale:         'linear',
        yscale:         'linear',

        // Used when scale type is set to "pow"
        xscaleExponent:  0.5,
        yscaleExponent:  0.5,

        // How many samples/points over which a graph shift should take place
        // when the data being plotted gets close to the edge of the X axis.
        axisShift:       10,

        // selectablePoints: false,

        // true if data points should be marked ... currently marked with a circle.
        markAllDataPoints:   false,

        // only show circles when hovering near them with the mouse or
        // tapping near then on a tablet
        markNearbyDataPoints: false,

        // number of circles to show on each side of the central point
        extraCirclesVisibleOnHover: 2,

        // true to show dashed horizontal and vertical rulers when a circle is selected
        showRulersOnSelection: false,

        // width of the line used for plotting
        lineWidth:      2.0,

        // Enable values of data points to be changed by selecting and dragging.
        dataChange:      false,

        // Enables adding of data to a graph by option/alt clicking in the graph.
        addData:         false,

        // Set value to a string and it will be rendered in background of graph.
        notification:    false,

        // Render lines between samples/points
        lines:           true,

        // Render vertical bars extending up to samples/points
        bars:            false,

        // Callback, called after autoscale button is clicked
        onAutoscale:     null,

        // Callack, called after X or Y axis is changed (due to any reason, e.g. manual or auto-scaling)
        onXDomainChange: null,
        onYDomainChange: null,

        // The R, G, and B values to be used to plot samples in each data channel. This default can
        // be overridden at construction time, but the caller must provide colors for each channel.
        // If there are n channels and m < n provided colors, the last n - m channels will be drawn
        // using the last color in the list
        dataColors: [
          "#a00000",     // channel 0   (red)
          "#2ca000",     // channel 1   (green-yellow)
          "#2c00a0"      // channels 2+ (blue-purple)
        ],

        // An array of strings to be paired with the data colors to build a legend
        legendLabels: []
      },

      // brush selection variables
      selection_region = {
        xmin: null,
        xmax: null,
        ymin: null,
        ymax: null
      },
      has_selection = false,
      selection_visible = false,
      selection_enabled = true,
      selection_listener,
      draw_enabled = false,
      brush_element,
      brush_control;


  // ------------------------------------------------------------
  //
  // Initialization
  //
  // ------------------------------------------------------------

  function initialize(idOrElement, opts, mesg) {
    if (opts || !options) {
      options = setupOptions(opts);
    }
    if (options.lang) {
      // Set language only if it's explicitly defined, don't use any default value.
      // Language can be also set by client library using global object:
      // LabGrapher.i18n.lang = 'es'
      // Default option could overwrite that.
      i18n.lang = options.lang;
    }

    initializeLayout(idOrElement, mesg);

    options.xrange = options.xmax - options.xmin;
    options.yrange = options.ymax - options.ymin;

    if (Object.prototype.toString.call(options.title) === "[object Array]") {
      titles = options.title;
    } else {
      titles = [options.title];
    }
    titles.reverse();

    // use local variables for both access speed and for responsive over-riding
    sampleInterval = options.sampleInterval;
    dataSampleStart = options.dataSampleStart;
    lineWidth = options.lineWidth;

    size = {
      "width":  120,
      "height": 120
    };

    setupScales();

    fx_d3 = d3.format(options.xFormatter);
    fy_d3 = d3.format(options.yFormatter);

    // Wrappers around certain d3 formatters to prevent problems like this:
    //   scale = d3.scale.linear().domain([-.7164, .7164])
    //   scale.ticks(10).map(d3.format('.3r'))
    //   => ["-0.600", "-0.400", "-0.200", "-0.0000000000000000888", "0.200", "0.400", "0.600"]

    fx = function(num) {
      var domain = xScale.domain(),
          onePercent = Math.abs((domain[1] - domain[0])*0.01);
      if (Math.abs(0+num) < onePercent) {
        num = 0;
      }
      return fx_d3(num);
    };

    fy = function(num) {
      var domain = yScale.domain(),
          onePercent = Math.abs((domain[1] - domain[0])*0.01);
      if (Math.abs(0+num) < onePercent) {
        num = 0;
      }
      return fy_d3(num);
    };

    xTickCount = options.xTickCount;
    yTickCount = options.yTickCount;

    pointsXMin = pointsYMin = Infinity;
    pointsXMax = pointsYMax = -Infinity;
    pointArray = [];
    switch(options.dataType) {
      case "fake":
      points = fakeDataPoints();
      pointArray = [points];
      break;

      case 'points':
      resetDataPoints(options.dataPoints);
      break;

      case 'samples':
      resetDataSamples(options.dataSamples, sampleInterval, dataSampleStart);
      break;
    }

    selectable = [];
    selected = null;

    setCurrentSample(points.length);
  }

  function initializeLayout(idOrElement, mesg) {
    if (idOrElement) {
      // d3.select works both for element ID (e.g. "#grapher")
      // and for DOM element.
      elem = d3.select(idOrElement);
      node = elem.node();
      $node = $(node);
      // cx = $node.width();
      // cy = $node.height();
      cx = elem.property("clientWidth");
      cy = elem.property("clientHeight");
    }

    if (mesg) {
      message = mesg;
    }

    if (svg !== undefined) {
      svg.remove();
      svg = undefined;
    }

    if (background !== undefined) {
      background.remove();
      background = undefined;
    }

    if (graphCanvas !== undefined) {
      graphCanvas.remove();
      graphCanvas = undefined;
    }

    if (options.dataChange) {
      markerCursorStyle = "ns-resize";
    } else {
      markerCursorStyle = "crosshair";
    }

    scale();

    // drag axis logic
    downx = NaN;
    downy = NaN;
    draggedPoint = null;
  }

  function scale(w, h) {
    if (!w && !h) {
      cx = Math.max(elem.property("clientWidth"), 60);
      cy = Math.max(elem.property("clientHeight"),60);
    } else {
      cx = w;
      node.style.width =  cx +"px";
      if (!h) {
        node.style.height = "100%";
        h = elem.property("clientHeight");
        cy = h;
        node.style.height = cy +"px";
      } else {
        cy = h;
        node.style.height = cy +"px";
      }
    }
    calculateSizeType();
  }

  function calculateLayout() {
    scale();

    fontSizeInPixels = parseFloat($node.css("font-size"));

    if (!options.fontScaleRelativeToParent) {
      $node.css("font-size", 0.5 + sizeType.value/6 + 'em');
    }

    fontSizeInPixels = parseFloat($node.css("font-size"));

    halfFontSizeInPixels = fontSizeInPixels/2;
    quarterFontSizeInPixels = fontSizeInPixels/4;

    if (svg === undefined) {
      titleFontSizeInPixels =  fontSizeInPixels;
      axisFontSizeInPixels =   fontSizeInPixels;
      xlabelFontSizeInPixels = fontSizeInPixels;
      ylabelFontSizeInPixels = fontSizeInPixels;
    } else {
      titleFontSizeInPixels =  parseFloat($("svg.graph text.title").css("font-size"));
      axisFontSizeInPixels =   parseFloat($("svg.graph text.axis").css("font-size"));
      xlabelFontSizeInPixels = parseFloat($("svg.graph text.xlabel").css("font-size"));
      ylabelFontSizeInPixels = parseFloat($("svg.graph text.ylabel").css("font-size"));
    }
    updateAxesAndSize();

    updateScales();

    line = d3.svg.line()
        .x(function(d, i) { return xScale(points[i][0]); })
        .y(function(d, i) { return yScale(points[i][1]); });
  }

  function setupOptions(options) {
    if (options) {
      for(var p in default_options) {
        if (options[p] === undefined) {
          options[p] = default_options[p];
        }
      }
    } else {
      options = default_options;
    }
    if (options.axisShift < 1) options.axisShift = 1;
    return options;
  }

  function getTopPadding() {
    var topPadding = fontSizeInPixels;
    if (options.title) {
      topPadding = titleFontSizeInPixels * 1.8;
    }
    if (options.buttonsLayout === "horizontal") {
      // Leave some space for buttons.
      topPadding += fontSizeInPixels * 1.3;
    }
    return topPadding;
  }

  function updateAxesAndSize() {
    xlabelMetrics = [fontSizeInPixels, fontSizeInPixels];
    ylabelMetrics = [fontSizeInPixels*2, fontSizeInPixels];
    if (xScale !== undefined) {
      // Find the widest X and Y axis labels, as those metrics are going to be used to calculate padding.
      xScale.ticks(xTickCount).forEach(function (tickVal) {
        var metrics = axis.numberWidth(elem, cx, cy, axisFontSizeInPixels, fx(tickVal));
        if (metrics[0] > xlabelMetrics[0]) { // metrics[0] - width, metrics[1] - height
          xlabelMetrics = metrics;
        }
      });
      yScale.ticks(yTickCount).forEach(function (tickVal) {
        var metrics = axis.numberWidth(elem, cx, cy, axisFontSizeInPixels, fy(tickVal));
        if (metrics[0] > ylabelMetrics[0]) { // metrics[0] - width, metrics[1] - height
          ylabelMetrics = metrics;
        }
      });
    }

    xAxisNumberWidth  = xlabelMetrics[0];
    xAxisNumberHeight = xlabelMetrics[1];

    xAxisLabelHorizontalPadding = xAxisNumberWidth * 0.6;
    xAxisDraggableHeight = xAxisNumberHeight * 1.1;
    xAxisVerticalPadding = xAxisDraggableHeight + xAxisNumberHeight*1.3;
    xAxisLabelBaseline = xAxisVerticalPadding-xAxisNumberHeight/3;

    yAxisNumberWidth  = ylabelMetrics[0];
    yAxisNumberHeight = ylabelMetrics[1];

    yAxisDraggableWidth    = yAxisNumberWidth + xAxisNumberHeight/4;
    yAxisHorizontalPadding = yAxisDraggableWidth + yAxisNumberHeight;
    yAxisLabelBaseline     = -(yAxisDraggableWidth+yAxisNumberHeight/4);
    if (options.hideAxisValues) {
      xAxisLabelBaseline = xAxisLabelBaseline - xAxisNumberHeight*1.3;
      yAxisLabelBaseline = -ylabelFontSizeInPixels/4;
    }

    switch(sizeType.value) {
      case 0:         // icon
      padding = {
        "top":    halfFontSizeInPixels,
        "right":  halfFontSizeInPixels,
        "bottom": xlabelFontSizeInPixels*1.25,
        "left":   ylabelFontSizeInPixels*1.25
      };
      break;

      case 1:         // tiny
      padding = {
        "top":    getTopPadding(),
        "right":  halfFontSizeInPixels,
        "bottom": xlabelFontSizeInPixels*1.25,
        "left":   ylabelFontSizeInPixels*1.25
      };
      break;

      case 2:         // small
      padding = {
        "top":    getTopPadding(),
        "right":  xAxisLabelHorizontalPadding,
        "bottom": options.hideAxisValues ? xlabelFontSizeInPixels*1.25 : axisFontSizeInPixels*1.25,
        "left": options.hideAxisValues ? ylabelFontSizeInPixels*1.25 : yAxisNumberWidth*1.25
      };
      xTickCount = Math.max(6, options.xTickCount/2);
      yTickCount = Math.max(6, options.yTickCount/2);
      break;

      case 3:         // medium
      padding = {
        "top":    getTopPadding(),
        "right":  xAxisLabelHorizontalPadding,
        "bottom": options.hideAxisValues ? xlabelFontSizeInPixels*1.25 : (options.xlabel ? xAxisVerticalPadding : axisFontSizeInPixels*1.25),
        "left": options.hideAxisValues ? ylabelFontSizeInPixels*1.25 : (options.ylabel ? yAxisHorizontalPadding : yAxisNumberWidth)
      };
      break;

      default:         // large
      padding = {
        "top":    getTopPadding(),
        "right":  xAxisLabelHorizontalPadding,
        "bottom": options.hideAxisValues ? xlabelFontSizeInPixels*1.25 : (options.xlabel ? xAxisVerticalPadding : axisFontSizeInPixels*1.25),
        "left": options.hideAxisValues ? ylabelFontSizeInPixels*1.25 : (options.ylabel ? yAxisHorizontalPadding : yAxisNumberWidth)
      };
      break;
    }

    if (sizeType.value > 2 ) {
      padding.top += (titles.length-1) * sizeType.value/3 * sizeType.value/3 * fontSizeInPixels;
    } else {
      titles = [titles[0]];
    }

    size.width  = Math.max(cx - padding.left - padding.right, 60);
    size.height = Math.max(cy - padding.top  - padding.bottom, 60);
  }

  function calculateSizeType() {
    if (options.responsiveLayout) {
      if (cx <= sizeType.icon) {
        sizeType.category = 'icon';
        sizeType.value = 0;
      } else if (cx <= sizeType.tiny) {
        sizeType.category = 'tiny';
        sizeType.value = 1;
      } else if (cx <= sizeType.small) {
        sizeType.category = 'small';
        sizeType.value = 2;
      } else if (cx <= sizeType.medium) {
        sizeType.category = 'medium';
        sizeType.value = 3;
      } else {
        sizeType.category = 'large';
        sizeType.value = 4;
      }
    } else {
      sizeType.category = 'large';
      sizeType.value = 4;
    }
  }

  // Setup xScale, yScale, making sure that options.xmax/xmin/ymax/ymin always reflect changes to
  // the relevant domains.
  function setupScales() {
    function domainObservingScale(scale, callback) {
      var domain = scale.domain;
      var nice = scale.nice;
      scale.domain = function() {
        var result = domain.apply(scale, arguments);
        if (arguments.length) {
          callback();
        }
        return result;
      };
      scale.nice = function() {
        var result = nice.apply(scale, arguments);
        callback();
        return result;
      };
      return scale;
    }

    xScale = domainObservingScale(d3.scale[options.xscale](), function() {
      options.xmin = xScale.domain()[0];
      options.xmax = xScale.domain()[1];
      if (options.onXDomainChange) {
        options.onXDomainChange.call(null, options.xmin, options.xmax);
      }
    });
    yScale = domainObservingScale(d3.scale[options.yscale](), function() {
      options.ymin = yScale.domain()[0];
      options.ymax = yScale.domain()[1];
      if (options.onYDomainChange) {
        options.onYDomainChange.call(null, options.ymin, options.ymax);
      }
    });
    updateScales();
  }

  function updateScales() {
    updateXScale();
    updateYScale();
  }

  // Update the x-scale.
  function updateXScale() {
    xScale.domain([options.xmin, options.xmax])
          .range([0, size.width]);
  }

  // Update the y-scale.
  function updateYScale() {
    yScale.domain([options.ymin, options.ymax])
          .range([size.height, 0]);
  }

  function fakeDataPoints() {
    var yrange2 = options.yrange / 2,
        yrange4 = yrange2 / 2,
        pnts;

    options.datacount = size.width/30;
    options.xtic = options.xrange / options.datacount;
    options.ytic = options.yrange / options.datacount;

    pnts = d3.range(options.datacount).map(function(i) {
      return [i * options.xtic + options.xmin, options.ymin + yrange4 + Math.random() * yrange2 ];
    });
    return pnts;
  }

  function setCurrentSample(samplePoint) {
    if (typeof samplePoint === "number") {
      currentSample = samplePoint;
    } else if (samplePoint === "last") {
      currentSample = 0;
      pointArray.forEach(function (arr) {
        if (arr.length > currentSample) {
          currentSample = arr.length ;
        }
      });
    }
    if (typeof currentSample !== "number") {
      currentSample = points.length-1;
    }
    return currentSample;
  }

  // converts data samples into an array of points
  function indexedData(samples, interval, start) {
    var i = 0,
        pnts = [];
    interval = interval || 1;
    start = start || 0;
    for (i = 0; i < samples.length;  i++) {
      pnts.push([i * interval + start, samples[i]]);
    }
    return pnts;
  }

  //
  // Update notification message
  //
  function notify(mesg) {
    message = mesg;
    if (mesg) {
      notification.text(mesg);
    } else {
      notification.text('');
    }
  }


  function createButtonLayer() {
    buttonLayer = elem.append("div");

    buttonLayer
      .attr("class", "button-layer")
      .style("z-index", 3);

    if (options.enableLegendButton && options.legendLabels.length > 0) {
      legendButton = buttonLayer.append('a');
      legendButton.attr({
            "class": "graph-button legend",
            "title": i18n.t("tooltips.legend")
          })
          .on("click", function() {
            toggleLegend();
          });
      if (options.buttonsStyle === "icons") {
        legendButton.append("i").attr("class", "icon-list-ul");
      } else {
        legendButton.text(i18n.t("labels.legend"));
      }
    }

    if (options.enableAutoScaleButton) {
      var autoscaleButton = buttonLayer.append('a');
      autoscaleButton.attr({
            "class": "graph-button autoscale",
            "title": i18n.t("tooltips.autoscale")
          })
          .on("click", function() {
            autoscale(true);
            redraw();
          });
      if (options.buttonsStyle === "icons") {
        autoscaleButton.append("i").attr("class", "icon-picture");
      } else {
        autoscaleButton.text(i18n.t("labels.autoscale"));
      }
    }

    if (options.enableSelectionButton) {
      selectionButton = buttonLayer.append('a');
      selectionButton.attr({
            "class": "graph-button selection",
            "title": i18n.t("tooltips.selection")
          })
          .on("click", function() {
            toggleSelection();
          });
      if (options.buttonsStyle === "icons") {
        selectionButton.append("i").attr("class", "icon-cut");
      } else {
        selectionButton.text(i18n.t("labels.selection"));
      }
    }

    if (options.enableDrawButton) {
      drawButton = buttonLayer.append('a');
      drawButton.attr({
            "class": "graph-button draw",
            "title": i18n.t("tooltips.draw")
          })
          .on("click", function() {
            toggleDraw();
          });
      if (options.buttonsStyle === "icons") {
        drawButton.append("i").attr("class", "icon-pencil");
      } else {
        drawButton.text(i18n.t("labels.draw"));
      }
    }

    resizeButtonLayer();
  }

  function resizeButtonLayer() {
    if (options.buttonsLayout === "vertical") {
      buttonLayer.style({
        "top":   padding.top + halfFontSizeInPixels * 0.5 + "px",
        "right": padding.right + halfFontSizeInPixels * 0.5 + "px"
      });
      buttonLayer.classed("horizontal", false);
    } else if (options.buttonsLayout === "horizontal") {
      buttonLayer.style({
        "top":  padding.top - fontSizeInPixels * 1.8 + "px",
        "width": (padding.left + size.width) + "px"
      });
      buttonLayer.classed("horizontal", true);
    }
  }
  function createLegendLayer() {
    var color = "black", item;
    legendLayer = elem.append("ul");

    legendLayer
      .attr("class", "legend-layer")
      .style("z-index", 3);

    for (var i = 0; i < options.legendLabels.length; i++) {
      if (options.dataColors.length > i) {
        color = options.dataColors[i];
      }
      item = legendLayer.append("li");
      item.append("div")
        .attr("class", "legend-colorsquare")
        .style("background-color", color);
      item.append("label")
        .text(options.legendLabels[i]);
    }
  }

  function createAnnotationLayer() {
    annotationLayer = elem.append("div");

    annotationLayer
      .attr("class", "annotation-layer")
      .style("z-index", 3);

    resizeAnnotationLayer();
  }

  function resizeAnnotationLayer() {
    annotationLayer
      .style({
        "width": size.width + "px",
        "height": size.height + "px",
        "top": padding.top + "px",
        "left": padding.left + "px"
      });
  }

  // ------------------------------------------------------------
  //
  // Rendering
  //
  // ------------------------------------------------------------

  //
  // Render a new graph by creating the SVG and Canvas elements
  //
  function renderNewGraph() {
    svg = elem.append("svg")
        .attr("width",  cx)
        .attr("height", cy)
        .attr("class", "graph")
        .style('z-index', 2);
        // .attr("tabindex", tabindex || 0);

    vis = svg.append("g")
        .attr("transform", "translate(" + padding.left + "," + padding.top + ")");

    plot = vis.append("rect")
      .attr("class", "plot")
      .attr("width", size.width)
      .attr("height", size.height)
      .attr("pointer-events", "all")
      .attr("fill", "rgba(255,255,255,0)")
      .on("mousemove", plotMousemove)
      .on("mousedown", plotDrag)
      .on("touchstart", plotDrag);

    plot.call(zoomBehavior());

    background = elem.append("div")
      .attr("class", "background")
      .style({
        "width": size.width + "px",
        "height": size.height + "px",
        "top": padding.top + "px",
        "left": padding.left + "px",
        "z-index": 0
      });

    createGraphCanvas();

    viewbox = vis.append("svg")
      .attr("class", "viewbox")
      .attr("top", 0)
      .attr("left", 0)
      .attr("width", size.width)
      .attr("height", size.height)
      .attr("viewBox", "0 0 "+size.width+" "+size.height);

    selectedRulerX = viewbox.append("line")
      .attr("stroke", gridStroke)
      .attr("stroke-dasharray", "2,2")
      .attr("y1", 0)
      .attr("y2", size.height)
      .attr("x1", function() { return selected === null ? 0 : selected[0]; } )
      .attr("x2", function() { return selected === null ? 0 : selected[0]; } )
      .attr("class", "ruler hidden");

    selectedRulerY = viewbox.append("line")
      .attr("stroke", gridStroke)
      .attr("stroke-dasharray", "2,2")
      .attr("x1", 0)
      .attr("x2", size.width)
      .attr("y1", function() { return selected === null ? 0 : selected[1]; } )
      .attr("y2", function() { return selected === null ? 0 : selected[1]; } )
      .attr("class", "ruler hidden");

    yAxisDraggable = svg.append("rect")
      .attr("class", "axis axis-y" + (options.enableAxisScaling ? " axis-draggable" : ""))
      .attr("x", padding.left-yAxisDraggableWidth)
      .attr("y", padding.top)
      .attr("rx", yAxisNumberHeight/6)
      .attr("width", yAxisDraggableWidth)
      .attr("height", size.height)
      .attr("pointer-events", "all")
      .on("mousedown", yAxisDrag)
      .on("touchstart", yAxisDrag);

    yAxisDraggableTooltip = yAxisDraggable.append("title");

    xAxisDraggable = svg.append("rect")
      .attr("class", "axis axis-x" + (options.enableAxisScaling ? " axis-draggable" : ""))
      .attr("x", padding.left)
      .attr("y", size.height+padding.top)
      .attr("rx", yAxisNumberHeight/6)
      .attr("width", size.width)
      .attr("height", xAxisDraggableHeight)
      .attr("pointer-events", "all")
      .on("mousedown", xAxisDrag)
      .on("touchstart", xAxisDrag);

    xAxisDraggableTooltip = xAxisDraggable.append("title");

    if (sizeType.value <= 2 && options.ylabel) {
      xAxisDraggableTooltip.text(options.xlabel);
    }

    if (sizeType.catefory && options.ylabel) {
      yAxisDraggableTooltip.text(options.ylabel);
    }

    adjustAxisDraggableFill();

    brush_element = viewbox.append("g")
          .attr("class", "brush");

    // Add the x-axis label
    if (sizeType.value > 2) {
      xlabel = vis.append("text")
          .attr("class", "axis")
          .attr("class", "xlabel")
          .text(options.xlabel)
          .attr("x", size.width/2)
          .attr("y", size.height)
          .attr("dy", xAxisLabelBaseline + "px")
          .style("text-anchor","middle");
    }

    // add y-axis label
    if (sizeType.value > 2) {
      ylabel = vis.append("g").append("text")
          .attr("class", "axis")
          .attr("class", "ylabel")
          .text( options.ylabel)
          .style("text-anchor","middle")
          .attr("transform","translate(" + yAxisLabelBaseline + " " + size.height/2+") rotate(-90)");
      if (sizeType.category === "small") {
        yAxisDraggable.append("title")
          .text(options.ylabel);
      }
    }

    // add Chart Title
    if (options.title && sizeType.value > 0) {
      titleBackground = svg.append("rect")
        .attr("class", "title-background")
        .attr("x", 0)
        .attr("y", 0)
        .attr("width", size.width + padding.left)
        // Leave some space for the last tick mark number.
        .attr("height", padding.top - halfFontSizeInPixels * 0.8);

      title = svg.selectAll("text")
        .data(titles, function(d) { return d; });
      title.enter().append("text")
        .attr("class", "title")
        .text(function(d) { return d; })
        .attr("x", options.titlePosition === "center" ?
          function() { return padding.left + size.width/2 - Math.min(size.width, getComputedTextLength(this))/2; } : titleLeftPadding)
        .attr("y", titleFontSizeInPixels * 1.1)
        .attr("dy", function(d, i) { return -i * titleFontSizeInPixels + "px"; });
      titleTooltip = title.append("title")
        .text("");
    } else if (options.title) {
      titleTooltip = plot.append("title")
        .text(options.title);
    }

    d3.select(node)
        .on("mousemove.drag", mousemove)
        .on("touchmove.drag", mousemove)
        .on("mouseup.drag",   mouseup)
        .on("touchend.drag",  mouseup);

    notification = vis.append("text")
        .attr("class", "graph-notification")
        .text(message)
        .attr("x", size.width/2)
        .attr("y", size.height/2)
        .style("text-anchor","middle");

    updateMarkers();
    updateRulers();
  }

  //
  // Repaint an existing graph by rescaling/updating the SVG and Canvas elements
  //
  function repaintExistingGraph() {
    vis
      .attr("width",  cx)
      .attr("height", cy)
      .attr("transform", "translate(" + padding.left + "," + padding.top + ")");

    plot
      .attr("width", size.width)
      .attr("height", size.height);

    background
      .style({
        "width":   size.width + "px",
        "height":  size.height + "px",
        "top":     padding.top + "px",
        "left":    padding.left + "px",
        "z-index": 0
      });

    viewbox
        .attr("top", 0)
        .attr("left", 0)
        .attr("width", size.width)
        .attr("height", size.height)
        .attr("viewBox", "0 0 "+size.width+" "+size.height);

    yAxisDraggable
        .attr("x", padding.left-yAxisDraggableWidth)
        .attr("y", padding.top-yAxisNumberHeight/2)
        .attr("width", yAxisDraggableWidth)
        .attr("height", size.height+yAxisNumberHeight);

    xAxisDraggable
        .attr("x", padding.left)
        .attr("y", size.height+padding.top)
        .attr("width", size.width)
        .attr("height", xAxisDraggableHeight);

    adjustAxisDraggableFill();

    if (options.title && sizeType.value > 0) {
      titleBackground
        .attr("x", 0)
        .attr("y", 0)
        .attr("width", size.width + padding.left)
        // Leave some space for the last tick mark number.
        .attr("height", titleFontSizeInPixels * 1.8 - halfFontSizeInPixels * 0.8);

      title
          .attr("x", options.titlePosition === "center" ?
                     function() { return padding.left + size.width/2 - Math.min(size.width, getComputedTextLength(this))/2; } : titleLeftPadding)
          .attr("y", titleFontSizeInPixels * 1.1)
          .attr("dy", function(d, i) { return -i * titleFontSizeInPixels + "px"; });
      titleTooltip
          .text("");
    } else if (options.title) {
      titleTooltip
          .text(options.title);
    }

    if (options.xlabel && sizeType.value > 2) {
      xlabel
          .attr("x", size.width/2)
          .attr("y", size.height)
          .attr("dy", xAxisLabelBaseline + "px");
      xAxisDraggableTooltip
          .text("");
    } else {
      xAxisDraggableTooltip
          .text(options.xlabel);
    }

    if (options.ylabel && sizeType.value > 2) {
      var baseline = yAxisLabelBaseline;
      ylabel
        .attr("transform","translate(" + baseline + " " + size.height/2+") rotate(-90)");
      yAxisDraggableTooltip
        .text("");
    } else {
      yAxisDraggableTooltip
        .text(options.ylabel);
    }

    notification
      .attr("x", size.width/2)
      .attr("y", size.height/2);

    vis.selectAll("g.x").remove();
    vis.selectAll("g.y").remove();

    if (has_selection && selection_visible) {
      updateBrushElement();
    }

    updateMarkers();
    updateRulers();
    resizeCanvas();
    resizeButtonLayer();
  }

  function getComputedTextLength(el) {
    if (el.getComputedTextLength) {
      return el.getComputedTextLength();
    } else {
      return 100;
    }
  }

  function adjustAxisDraggableFill() {
    if (sizeType.value <= 1) {
      xAxisDraggable
        .style({
          "fill":       "rgba(196, 196, 196, 0.2)"
        });
      yAxisDraggable
        .style({
          "fill":       "rgba(196, 196, 196, 0.2)"
        });
    } else {
      xAxisDraggable
        .style({
          "fill":       null
        });
      yAxisDraggable
        .style({
          "fill":       null
        });
    }
  }

  function zoomBehavior() {
    if (options.enableZooming) {
      return d3.behavior.zoom().x(xScale).y(yScale).on("zoom", redraw)
    } else {
      // noop
      return function () {};
    }
  }

  //
  // Redraw the plot and axes when plot is translated or axes are re-scaled
  //
  function redraw() {
    updateAxesAndSize();
    repaintExistingGraph();
    // Regenerate x-ticks
    var gx = vis.selectAll("g.x")
        .data(xScale.ticks(xTickCount), String)
        .attr("transform", tx);

    var gxe = gx.enter().insert("g", "a")
        .attr("class", "x")
        .attr("transform", tx);

    gxe.append("line")
        .attr("stroke", gridStroke)
        .attr("y1", 0)
        .attr("y2", size.height);

    if (sizeType.value > 1 && !options.hideAxisValues) {
      gxe.append("text")
          .attr("class", "axis")
          .attr("y", size.height)
          .attr("dy", axisFontSizeInPixels + "px")
          .attr("text-anchor", "middle")
          .text(fx)
          .on("mouseover", function() { d3.select(this).style("font-weight", "bold");})
          .on("mouseout",  function() { d3.select(this).style("font-weight", "normal");});
    }

    gx.exit().remove();

    // Regenerate y-ticks
    var gy = vis.selectAll("g.y")
        .data(yScale.ticks(yTickCount), String)
        .attr("transform", ty);

    var gye = gy.enter().insert("g", "a")
        .attr("class", "y")
        .attr("transform", ty)
        .attr("background-fill", "#FFEEB6");

    gye.append("line")
        .attr("stroke", gridStroke)
        .attr("x1", 0)
        .attr("x2", size.width);

    if (sizeType.value > 1) {
      if (options.yscale === "log") {
        var gye_length = gye[0].length;
        if (gye_length > 100) {
          gye = gye.filter(function(d) { return !!d.toString().match(/(\.[0]*|^)[1]/);});
        } else if (gye_length > 50) {
          gye = gye.filter(function(d) { return !!d.toString().match(/(\.[0]*|^)[12]/);});
        } else {
          gye = gye.filter(function(d) {
            return !!d.toString().match(/(\.[0]*|^)[125]/);});
        }
      }

      if(!options.hideAxisValues){
        gye.append("text")
          .attr("class", "axis")
          .attr("x", -axisFontSizeInPixels/4 + "px")
          .attr("dy", ".35em")
          .attr("text-anchor", "end")
          .style("cursor", "ns-resize")
          .text(fy)
          .on("mouseover", function() { d3.select(this).style("font-weight", "bold");})
          .on("mouseout",  function() { d3.select(this).style("font-weight", "normal");});
      }
    }

    gy.exit().remove();

    // For now, only annotations are of annotation.type === 'line' are supported
    // so only generate attribute hash for lines and assume that we can directly
    // append svg nodes of annotation.type

    function annotationAttributes(d) {
      switch(d.type) {
      case "line":
        return {
          stroke: d.data.hasOwnProperty("stroke") ? d.data.stroke : "#f00",
          x1: d.data.hasOwnProperty('x1') ? xScale(d.data.x1) : 0,
          x2: d.data.hasOwnProperty('x2') ? xScale(d.data.x2) : size.width,
          y1: d.data.hasOwnProperty('y1') ? yScale(d.data.y1) : 0,
          y2: d.data.hasOwnProperty('y2') ? yScale(d.data.y2) : size.height
        };
      case "bar":
        return {
          stroke: d.data.hasOwnProperty("stroke") ? d.data.stroke : "#f00",
          fill:   d.data.hasOwnProperty("stroke") ? d.data.stroke : "#f00",
          x:      d.data.hasOwnProperty('x1') ? xScale(d.data.x1) : 0,
          y:      d.data.hasOwnProperty('y2') ? yScale(d.data.y2) : 0,
          width:  d.data.hasOwnProperty('x2') ? xScale(d.data.x2)-xScale(d.data.x1) : size.width,
          height: d.data.hasOwnProperty('y1') ? yScale(d.data.y1)-yScale(d.data.y2) : size.height,
          "fill-opacity": 0.5
        };
      }

      return {};
    }

    var annotationTypes = {
      line: "line",
      bar:  "rect"
    };

    var annotationsSelection = vis.selectAll("g.annotation")
      .data(annotations);

    // create annotation objects if necessary
    annotationsSelection.enter()
      .append("g")
      .attr("class", "annotation")
      .each(function(d,i){
        d3.select(this).append(annotationTypes[d.type]);
      });

    // update annotation attributes to reflect current graph state
    annotationsSelection.each(function(d,i){
      d3.select(this.childNodes[0]).attr(annotationAttributes(d))
        .call(zoomBehavior());
    });

    annotationsSelection.exit().remove();
    plot.call(zoomBehavior());
    update();
  }

  // ------------------------------------------------------------
  //
  // Rendering: Updating samples/data points in the plot
  //
  // ------------------------------------------------------------


  //
  // Update plotted data, optionally pass in new samplePoint
  //
  function update(samplePoint) {
    setCurrentSample(samplePoint);
    updateCanvasFromPoints(currentSample);
    updateMarkers();
    if (d3.event && d3.event.keyCode) {
      d3.event.preventDefault();
      d3.event.stopPropagation();
    }
  }

  // samplePoint is optional argument
  function updateOrRescale(samplePoint) {
    setCurrentSample(samplePoint);

    if (autoscale()) {
      redraw();
    } else {
      update(currentSample);
    }
  }

  function circleClasses(d) {
    var cs = [];
    if (d === selected) {
      cs.push("selected");
    }
    if (cs.length === 0) {
      return null;
    } else {
      return cs.join(" ");
    }
  }

  function updateMarkerRadius() {
    var d = xScale.domain(),
        r = xScale.range();
    markerRadius = (r[1] - r[0]) / ((d[1] - d[0]));
    markerRadius = Math.min(Math.max(markerRadius, 4), 8);
    markerStrokeWidth = markerRadius/3;
  }

  function updateMarkers() {
    var marker,
        markedPoints = null;
    if (options.markAllDataPoints && sizeType.value > 1) {
      markedPoints = [];
      markedPoints = markedPoints.concat.apply(markedPoints, pointArray);
    } else if (options.markNearbyDataPoints && sizeType.value > 1) {
      markedPoints = selectable.slice(0);
      if (selected !== null && markedPoints.indexOf(selected) === -1) {
        markedPoints.push(selected);
      }
    }
    if (markedPoints !== null) {
      updateMarkerRadius();
      marker = vis.select("svg").selectAll("circle").data(markedPoints);
      marker.enter().append("circle")
          .attr("class", circleClasses)
          .attr("cx",    function(d) { return xScale(d[0]); })
          .attr("cy",    function(d) { return yScale(d[1]); })
          .attr("r", markerRadius)
          .style("stroke-width", markerStrokeWidth)
          .style("cursor", markerCursorStyle)
          .on("mousedown.drag",  dataPointDrag)
          .on("touchstart.drag", dataPointDrag)
          .append("title")
          .text(function(d) { return "( " + fx(d[0]) + ", " + fy(d[1]) + " )"; });

      marker
          .attr("class", circleClasses)
          .attr("cx",    function(d) { return xScale(d[0]); })
          .attr("cy",    function(d) { return yScale(d[1]); })
          .select("title")
          .text(function(d) { return "( " + fx(d[0]) + ", " + fy(d[1]) + " )"; });

      marker.exit().remove();
    }

    updateRulers();
  }

  function updateRulers() {
    if (options.showRulersOnSelection && selected !== null) {
      selectedRulerX
        .attr("y1", 0)
        .attr("y2", size.height)
        .attr("x1", function() { return selected === null ? 0 : xScale(selected[0]); } )
        .attr("x2", function() { return selected === null ? 0 : xScale(selected[0]); } )
        .attr("class", function() { return "ruler" + (selected === null ? " hidden" : ""); } );

      selectedRulerY
        .attr("x1", 0)
        .attr("x2", size.width)
        .attr("y1", function() { return selected === null ? 0 : yScale(selected[1]); } )
        .attr("y2", function() { return selected === null ? 0 : yScale(selected[1]); } )
        .attr("class", function() { return "ruler" + (selected === null ? " hidden" : ""); } );
    } else {
      selectedRulerX.attr("class", "ruler hidden");
      selectedRulerY.attr("class", "ruler hidden");
    }
  }


  // ------------------------------------------------------------
  //
  // UI Interaction: Plot dragging and translation; Axis re-scaling
  //
  // ------------------------------------------------------------

  function plotMousemove() {
    if (options.markNearbyDataPoints) {
      var mousePoint = d3.mouse(vis.node()),
          translatedMousePointX = xScale.invert(Math.max(0, Math.min(size.width, mousePoint[0]))),
          p,
          idx, pMin, pMax,
          i;
      // highlight the central point, and also points to the left and right
      // TODO Handle multiple data sets/lines
      selectable = [];
      for (i = 0; i < pointArray.length; i++) {
        points = pointArray[i];
        p = findClosestPointByX(translatedMousePointX, i);
        if (p !== null) {
          idx = points.indexOf(p);
          pMin = idx - (options.extraCirclesVisibleOnHover);
          pMax = idx + (options.extraCirclesVisibleOnHover + 1);
          if (pMin < 0) { pMin = 0; }
          if (pMax > points.length - 1) { pMax = points.length; }
          selectable = selectable.concat(points.slice(pMin, pMax));
        }
      }
      update();
    }
  }

  function findClosestPointByX(x, line) {
    if (typeof(line) === "undefined" || line === null) { line = 0; }
    // binary search through points.
    // This assumes points is sorted ascending by x value, which for realTime graphs is true.
    points = pointArray[line];
    if (points.length === 0) { return null; }
    var min = 0,
        max = points.length - 1,
        mid, p1, p2, p3;
    while (min < max) {
      mid = Math.floor((min + max)/2.0);
      if (points[mid][0] < x) {
        min = mid + 1;
      } else {
        max = mid;
      }
    }

    // figure out which point is actually closest.
    // we have to compare 3 points, to account for floating point rounding errors.
    // if the mouse moves off the left edge of the graph, p1 may not exist.
    // if the mouse moves off the right edge of the graph, p3 may not exist.
    p1 = points[mid - 1];
    p2 = points[mid];
    p3 = points[mid + 1];
    if (typeof(p1) !== "undefined" && Math.abs(p1[0] - x) <= Math.abs(p2[0] - x)) {
      return p1;
    } else if (typeof(p3) === "undefined" || Math.abs(p2[0] - x) <= Math.abs(p3[0] - x)) {
      return p2;
    } else {
      return p3;
    }
  }

  function plotDrag() {
    var p;
    if (draw_enabled) {
      d3.event.preventDefault();
      p = d3.mouse(vis.node());
      addPointAtMouse(p);
      downx = p[0];
      downy = p[0];
      draggedPoint = false;
    } else if(options.enableAxisScaling) {
      d3.event.preventDefault();
      d3.select('body').style("cursor", "move");
      if (d3.event.altKey) {
        plot.style("cursor", "nesw-resize");
        if (d3.event.shiftKey && options.addData) {
          addPointAtMouse();
        } else {
          p = d3.mouse(vis.node());
          downx = xScale.invert(p[0]);
          downy = yScale.invert(p[1]);
          draggedPoint = false;
          d3.event.stopPropagation();
        }
        // d3.event.stopPropagation();
      }
    }
  }

  function notifyPointListeners(action, point) {
    pointListeners.forEach(function(callback) {
      callback.call(null,{action: action, point: point});
    });
  }

  function isPointInsideGraph(p) {
    var graphx = xScale.invert(p[0]),
        graphy = yScale.invert(p[1]),
        xAxisStart = xScale.domain()[0],
        xAxisEnd =   xScale.domain()[1],
        yAxisStart = yScale.domain()[0],
        yAxisEnd =   yScale.domain()[1];

    return graphx >= xAxisStart && graphx <= xAxisEnd && graphy >= yAxisStart && graphy <= yAxisEnd;
  }

  function addPointAtMouse(p) {
    if (!p) {
      p = d3.mouse(vis.node());
    }

    var newpoint = [],
        newpointIdx,
        pointsIndexed = pointArrayIndexed[options.drawIndex];
    points = pointArray[options.drawIndex];
    newpoint[0] = xScale.invert(Math.max(0, Math.min(size.width,  p[0])));
    newpoint[1] = yScale.invert(Math.max(0, Math.min(size.height, p[1])));
    points.push(newpoint);
    pointsIndexed.push(newpoint);
    notifyPointListeners("added", newpoint);
    processPointsArray(points);
    selected = newpoint;

    // update currentSample
    newpointIdx = points.indexOf(newpoint);
    if (currentSample == points.length-2 || currentSample >= newpointIdx) {
      // currentSample was pointing to the last point, so keep it at the last point
      currentSample++;
    }

    points = pointArray[0];
    update();
  }

  function isBetween(a,b,p) {
    return a < p && p <= b;
  }

  function isBetweenReversed(a,b,p) {
    return a <= p && p < b;
  }

  function clearPointsBetween(x1, x2) {
    var a = x1,
        b = x2,
        needsUpdate = false,
        between = isBetween,
        i, p, removed, pointsIndexed, newPoints;

    // Check to make sure a is always smaller than b
    if (x1 > x2) {
      a = x2;
      b = x1;
      between = isBetweenReversed;
    }

    pointsIndexed = pointArrayIndexed[options.drawIndex];

    // for (i = points.length-1; i >= 0; i--) {
    for (i = 0; i < pointsIndexed.length; i++) {
      p = pointsIndexed[i];
      if (p && between(a, b, p[0])) {
        // null the point
        removed = pointsIndexed[i].slice();
        pointsIndexed[i][0] = null;
        pointsIndexed[i][1] = null;
        notifyPointListeners("removed", removed);
        needsUpdate = true;
      }
    }
    if (needsUpdate) {
      newPoints = copyNonNull(pointsIndexed);
      processPointsArray(newPoints);
      pointArray[options.drawIndex] = newPoints;
      points = pointArray[0];
      update();
    }
  }

  function falseFunction() {
    return false;
  }

  function xAxisDrag() {
    if(options.enableAxisScaling) {
      node.focus();
      document.onselectstart = falseFunction;
      d3.event.preventDefault();
      var p = d3.mouse(vis.node());
      downx = xScale.invert(p[0]);
    }
  }

  function yAxisDrag() {
    if(options.enableAxisScaling) {
      node.focus();
      d3.event.preventDefault();
      document.onselectstart = falseFunction;
      var p = d3.mouse(vis.node());
      downy = yScale.invert(p[1]);
    }
  }

  function dataPointDrag(d) {
    node.focus();
    d3.event.preventDefault();
    document.onselectstart = falseFunction;
    if (selected === d) {
      selected = draggedPoint = null;
    } else {
      selected = draggedPoint = d;
    }
    update();
  }

  function mousemove() {
    var p = d3.mouse(vis.node()),
        points,
        index,
        px,
        x,
        nextPoint,
        prevPoint,
        minusHalf,
        plusHalf;

    // t = d3.event.changedTouches;

    document.onselectstart = function() { return true; };
    d3.event.preventDefault();
    if (draggedPoint) {
      if (options.dataChange) {
        draggedPoint[1] = yScale.invert(Math.max(0, Math.min(size.height, p[1])));
      } else {
        pointArray.forEach(function (arr) {
          var i = arr.indexOf(draggedPoint);
          if (i !== -1) {
            points = arr;
            index = i;
          }
        });

        if (index && index < (points.length-1)) {
          px = xScale.invert(p[0]);
          x = draggedPoint[0];
          nextPoint = points[index+1];
          prevPoint = points[index-1];
          minusHalf = x - (x - prevPoint[0])/2;
          plusHalf =  x + (nextPoint[0] - x)/2;
          if (px < minusHalf) {
            draggedPoint = prevPoint;
            selected = draggedPoint;
          } else if (px > plusHalf) {
            draggedPoint = nextPoint;
            selected = draggedPoint;
          }
        }
      }
      update();
    }

    if (draw_enabled && !isNaN(downx) && !isNaN(downy)) {
      if (isPointInsideGraph(p)) {
        clearPointsBetween(xScale.invert(Math.max(0, Math.min(size.width,  downx))), xScale.invert(Math.max(0, Math.min(size.width,  p[0]))));
        addPointAtMouse(p);
        downx = p[0];
        downy = p[0];
      } else {
        mouseup();
      }
      d3.event.stopPropagation();
    } else {
      if (!isNaN(downx)) {
        d3.select('body').style("cursor", "col-resize");
        plot.style("cursor", "col-resize");
        xScale.domain(axis.axisProcessDrag(downx, xScale.invert(p[0]), xScale.domain()));
        updateMarkerRadius();
        redraw();
        d3.event.stopPropagation();
      }

      if (!isNaN(downy)) {
        d3.select('body').style("cursor", "row-resize");
        plot.style("cursor", "row-resize");
        yScale.domain(axis.axisProcessDrag(downy, yScale.invert(p[1]), yScale.domain()));
        redraw();
        d3.event.stopPropagation();
      }
    }
  }

  function mouseup() {
    d3.select('body').style("cursor", "auto");
    plot.style("cursor", "auto");
    document.onselectstart = function() { return true; };
    if (!isNaN(downx)) {
      redraw();
      downx = NaN;
    }
    if (!isNaN(downy)) {
      redraw();
      downy = NaN;
    }
    draggedPoint = null;
  }

  //------------------------------------------------------
  //
  // Autoscale
  //
  // ------------------------------------------------------------

  /**
    If there are more than 1 data points, scale axes. Default behavior is to expand domain only when
    corresponding "autoScaleX" and "autoScaleY" options are set to true.

    However if you pass <true> as an argument, it will enforce scaling of axes so the fit data.
  */
  function autoscale(fit) {
    var maxPointsLen = -Infinity;
    var domainXChanged;
    var domainYChanged;
    var ret;

    pointArray.forEach(function (arr) {
      if (arr.length > maxPointsLen) maxPointsLen = arr.length;
    });

    if (maxPointsLen > 1) {
      if (options.autoScaleX || fit) {
        var xPadding = fit ? 0.05 : options.autoScalePadding;
        domainXChanged = scaleAxis("x", pointsXMin, pointsXMax, xPadding, fit);
      }
      if (options.autoScaleY || fit) {
        var yPadding = fit ? 0.05 : options.autoScalePadding;
        domainYChanged = scaleAxis("y", pointsYMin, pointsYMax, yPadding, fit);
      }
      ret = domainXChanged || domainYChanged;
    } else {
      ret = undefined;
    }

    // Only call callback if there's what we think of as an "autoscale was clicked" event, which
    // specifically means the case that fit == true
    if (fit && options.onAutoscale) {
      options.onAutoscale.call(null);
    }

    return ret;
  }

  function scaleAxis(axis, minVal, maxVal, padding, fit) {
    if (minVal === maxVal) {
      // Simply skip scaling when min === max.
      return false;
    }
    // axis argument is expected to be "x" or "y".
    var scale = axis === "x" ? xScale : yScale;
    var dMin = scale.domain()[0];
    var dMax = scale.domain()[1];
    var domainChanged = false;
    // Like Math.pow but returns a value with the same sign as x: pow(-1, 0.5) -> -1
    var pow = function(x, exponent) {
      return x < 0 ? -Math.pow(-x, exponent) : Math.pow(x, exponent);
    };
    // Convert min, max to a linear scale, and set 'transform' to the function that
    // converts the new min, max to the relevant scale.
    var transform;
    switch (options[axis + "scale"]) {
      case 'linear':
        transform = function(x) { return x; };
        break;
      case 'log':
        minVal = Math.log(minVal) / Math.log(10);
        maxVal = Math.log(maxVal) / Math.log(10);
        transform = function(x) { return Math.pow(10, x); };
        break;
      case 'pow':
        var scaleExponent = options[axis + "scaleExponent"];
        minVal = pow(minVal, scaleExponent);
        maxVal = pow(maxVal, scaleExponent);
        transform = function(x) { return pow(x, 1 / scaleExponent); };
        break;
    }

    var pad = (maxVal - minVal) * padding;
    if (maxVal > dMax || fit) {
      dMax = maxVal + pad;
      domainChanged = true;
    }
    if (minVal < dMin || fit) {
      dMin = minVal - pad;
      domainChanged = true;
    }
    if (domainChanged) {
      scale.domain([transform(dMin), transform(dMax)]).nice();
    }
    return domainChanged;
  }

  // ------------------------------------------------------------
  //
  // Brush Selection
  //
  // ------------------------------------------------------------

  function toggleSelection() {
    drawEnabled(false);
    if (!selectionVisible()) {
      // The graph model defaults to visible=false and enabled=true.
      // Reset these so that this first click turns on selection correctly.
      selectionEnabled(false);
      selectionVisible(true);
    }
    if (!!selectionEnabled()) {
      if (options.clearSelectionOnLeavingSelectMode || selectionDomain() === []) {
        selectionDomain(null);
      }
      selectionEnabled(false);
    } else {
      if (selectionDomain() == null) {
        selectionDomain([]);
      }
      selectionEnabled(true);
    }
  }

  /**
    Set or get the selection domain (i.e., the range of x values that are selected).

    Valid domain specifiers:
      null     no current selection (selection is turned off)
      []       a current selection exists but is empty (has_selection is true)
      [x1, x2] the region between x1 and x2 is selected. Any data points between
               x1 and x2 (inclusive) would be considered to be selected.

    Default value is null.
  */
  function selectionDomain(a) {

    if (!arguments.length) {
      if (!has_selection) {
        return null;
      }
      if (selection_region.xmax === Infinity && selection_region.xmin === Infinity ) {
        return [];
      }
      return [selection_region.xmin, selection_region.xmax];
    }

    // setter

    if (a === null) {
      has_selection = false;
    }
    else if (a.length === 0) {
      has_selection = true;
      selection_region.xmin = Infinity;
      selection_region.xmax = Infinity;
    }
    else {
      has_selection = true;
      selection_region.xmin = a[0];
      selection_region.xmax = a[1];
    }

    updateBrushElement();

    if (selection_listener) {
      selection_listener(selectionDomain());
    }
    return api;
  }

  /**
    Get whether the graph currently has a selection region. Default value is false.

    If true, it would be valid to filter the data points to return a subset within the selection
    region, although this region may be empty!

    If false the graph is not considered to have a selection region.

    Note that even if has_selection is true, the selection region may not be currently shown,
    and if shown, it may be empty.
  */
  function hasSelection() {
    return has_selection;
  }

  /**
    Set or get the visibility of the selection region. Default value is false.

    Has no effect if the graph does not currently have a selection region
    (selection_domain is null).

    If the selection_enabled property is true, the user will also be able to interact
    with the selection region.
  */
  function selectionVisible(val) {
    if (!arguments.length) {
      return selection_visible;
    }

    // setter
    val = !!val;
    if (selection_visible !== val) {
      selection_visible = val;
      updateBrushElement();
    }
    return api;
  }

  /**
    Set or get whether user manipulation of the selection region should be enabled
    when a selection region exists and is visible. Default value is true.

    Setting the value to true has no effect unless the graph has a selection region
    (selection_domain is non-null) and the region is visible (selection_visible is true).
    However, the selection_enabled setting is honored whenever those properties are
    subsequently updated.

    Setting the value to false does not affect the visibility of the selection region,
    and does not affect the ability to change the region by calling selectionDomain().

    Note that graph panning and zooming are disabled while selection manipulation is enabled.
  */
  function selectionEnabled(val) {
    if (!arguments.length) {
      return selection_enabled;
    }

    // setter
    val = !!val;
    if (selection_enabled !== val) {
      selection_enabled = val;

      if (selectionButton) {
        if (val) {
          selectionButton.classed("active", true);
        } else {
          selectionButton.classed("active", false);
        }
      }

      updateBrushElement();
    }
    return api;
  }

  /**
    Set or get the listener to be called when the selection_domain changes.

    Both programatic and interactive updates of the selection region result in
    notification of the listener.

    The listener is called with the new selection_domain value in the first argument.
  */
  function selectionListener(cb) {
    if (!arguments.length) {
      return selection_listener;
    }
    // setter
    selection_listener = cb;
    return api;
  }

  function brushListener() {
    var extent;
    if (selection_enabled) {
      // Note there is a brush.empty() method, but it still reports true after the
      // brush extent has been programatically updated.
      extent = brush_control.extent();
      selectionDomain( extent[0] !== extent[1] ? extent : [] );
    }
  }

  function updateBrushElement() {
    if (has_selection && selection_visible) {
      brush_control = brush_control || d3.svg.brush()
        .x(xScale)
        .extent([selection_region.xmin || 0, selection_region.xmax || 0])
        .on("brush", brushListener);

      brush_element
        .call(brush_control.extent([selection_region.xmin || 0, selection_region.xmax || 0]))
        .style('display', 'inline')
        .style('pointer-events', selection_enabled ? 'all' : 'none')
        .selectAll("rect")
          .attr("height", size.height);

    } else {
      brush_element.style('display', 'none');
    }
  }

  // ------------------------------------------------------------
  //
  // Drawing
  //
  // ------------------------------------------------------------

  function toggleDraw() {
    if (has_selection && selection_visible) {
      toggleSelection();
    }
    drawEnabled(!draw_enabled);
  }

  function drawEnabled(val) {
    if (!arguments.length) {
      return draw_enabled;
    }

    // setter
    val = !!val;
    if (draw_enabled !== val) {
      draw_enabled = val;

      if (drawButton) {
        if (val) {
          drawButton.classed("active", true);
        } else {
          drawButton.classed("active", false);
        }
      }
    }
    return api;
  }

  // ------------------------------------------------------------
  //
  // Legend
  //
  // ------------------------------------------------------------

  function toggleLegend() {
    options.legendVisible = !options.legendVisible;
    updateLegendVisibility();
  }

  function updateLegendVisibility() {
    if (legendButton) {
      if (!!options.legendVisible) {
        legendButton.classed("active", true);
      } else {
        legendButton.classed("active", false);
      }
    }
    if (legendLayer) {
      if (!!options.legendVisible) {
        legendLayer.classed("legend-invisible", false);
        // Reposition while we're at it
        legendLayer
          .style({
            "top":     padding.top + halfFontSizeInPixels + "px",
            "right":   padding.right + halfFontSizeInPixels +
                       (options.showButtons && options.buttonsLayout === "vertical" ? buttonLayer.property('clientWidth') : 0) + "px"
          });
      } else {
        legendLayer.classed("legend-invisible", true);
      }
    }
    return api;
  }

  // ------------------------------------------------------------
  //
  // Canvas-based plotting
  //
  // ------------------------------------------------------------

  function createGraphCanvas() {
    graphCanvas = elem.append("canvas");
    gcanvas = graphCanvas.node();
    resizeCanvas();
  }

  function resizeCanvas() {
    graphCanvas
      .attr("class", "overlay")
      .style({
        "position": "absolute",
        "width":    size.width + "px",
        "height":   size.height + "px",
        "top":      padding.top + "px",
        "left":     padding.left + "px",
        "z-index": 1
      });
    gcanvas = graphCanvas.node();
    gcanvas.width = size.width;
    gcanvas.height = size.height;
    gcanvas.top = padding.top;
    gcanvas.left = padding.left;
    setupCanvasContext();
    updateCanvasFromPoints(currentSample);
  }

  function clearCanvas() {
    if (gcanvas.getContext) {
      gcanvas.width = gcanvas.width;
      gctx.lineWidth = lineWidth;
      gctx.fillStyle = canvasFillStyle;
      gctx.fillRect(0, 0, gcanvas.width, gcanvas.height);
      gctx.strokeStyle = "rgba(255,65,0, 1.0)";
      gctx.globalAlpha = 1;
    }
  }

  function setupCanvasContext() {
    if (gcanvas.getContext) {
      gctx = gcanvas.getContext( '2d' );
      gctx.globalCompositeOperation = "source-over";
      gctx.lineWidth = lineWidth;
      gctx.fillStyle = canvasFillStyle;
      gctx.fillRect(0, 0, gcanvas.width, gcanvas.height);
      gctx.strokeStyle = "rgba(255,65,0, 1.0)";
      gctx.globalAlpha = 1;
    }
  }

  //
  // Update Canvas plotted data from [x, y] data points
  //
  function updateCanvasFromPoints(samplePoint) {
    var i, j, len,
        dx,
        px, py,
        index,
        yOrigin = yScale(0.00001),
        lines = options.lines,
        bars = options.bars,
        pointsLength,
        numberOfLines = pointArray.length,
        xAxisStart,
        xAxisEnd,
        pointStop,
        start;

    // hack for lack of canvas support in jsdom tests
    if (typeof gcanvas.getContext === "undefined" ) { return; }

    setCurrentSample(samplePoint);
    clearCanvas();
    gctx.fillRect(0, 0, gcanvas.width, gcanvas.height);
    gctx.lineWidth = lineWidth;
    xAxisStart = xScale.domain()[0];
    xAxisEnd =   xScale.domain()[1];
    start = Math.max(0, xAxisStart);
    if (lines) {
      for (i = 0; i < numberOfLines; i++) {
        points = pointArray[i];
        pointsLength = points.length;
        if (pointsLength === 0) {
          continue;
        } else if (pointsLength === 1) {
          // Draw just single point.
          setFillColor(i);
          gctx.fillRect(xScale(points[0][0]), yScale(points[0][1]), lineWidth, lineWidth);
          continue;
        }
        index = 0;
        // find first point >= xAxisStart
        for (j = 0; j < pointsLength; j++) {
          if (points[j][0] != null && points[j][1] != null && points[j][0] >= xAxisStart) { break; }
          index++;
        }
        if (index >= pointsLength) { continue; }
        if (index > 0) { index--; }
        px = xScale(points[index][0]);
        py = yScale(points[index][1]);
        setStrokeColor(i);
        gctx.beginPath();
        gctx.moveTo(px, py);
        dx = points[index][0];
        index++;
        // plot all ... or until one point past xAxisEnd
        // or until we reach currentSample
        for (len = Math.min(samplePoint, pointsLength); index < len; index++) {
          if (points[index][0] == null || points[index][1] == null) { continue; }
          dx = points[index][0];
          px = xScale(dx);
          py = yScale(points[index][1]);
          gctx.lineTo(px, py);
          if (dx >= xAxisEnd) { break; }
        }
        gctx.stroke();
        // now plot in a desaturated style all the rest of the points
        // ... or until one point past xAxisEnd
        if (index < pointsLength && dx < xAxisEnd) {
          setStrokeColor(i, true);
          gctx.lineWidth = lineWidth/2;
          for (;index < pointsLength; index++) {
            if (points[index][0] == null || points[index][1] == null) { continue; }
            dx = points[index][0];
            px = xScale(dx);
            py = yScale(points[index][1]);
            gctx.lineTo(px, py);
            if (dx >= xAxisEnd) { break; }
          }
          gctx.stroke();
          gctx.lineWidth = lineWidth;
        }
      }
    } else if (bars) {
      for (i = 0; i < numberOfLines; i++) {
        points = pointArray[i];
        pointsLength = points.length;
        setStrokeColor(i);
        pointStop = samplePoint - 1;
        for (index=start; index < pointStop; index++) {
          if (points[index][0] == null || points[index][1] == null) { continue; }
          px = xScale(points[index][0]);
          py = yScale(points[index][1]);
          if (py === 0) {
            continue;
          }
          gctx.beginPath();
          gctx.moveTo(px, yOrigin);
          gctx.lineTo(px, py);
          gctx.stroke();
        }
        pointStop = points.length-1;
        if (index < pointStop) {
          setStrokeColor(i, true);
          for (;index < pointStop; index++) {
            if (points[index][0] == null || points[index][1] == null) { continue; }
            px = xScale(points[index][0]);
            py = yScale(points[index][1]);
            gctx.beginPath();
            gctx.moveTo(px, yOrigin);
            gctx.lineTo(px, py);
            gctx.stroke();
          }
        }
      }
    } else {
      for (i = 0; i < numberOfLines; i++) {
        points = pointArray[i];
        pointsLength = points.length;
        index = 0;
        // find first point >= xAxisStart
        for (j = 0; j < pointsLength; j++) {
          if (points[j][0] != null && points[j][1] != null && points[j][0] >= xAxisStart) { break; }
          index++;
        }
        if (index > 0) { --index; }
        if (index >= pointsLength) { continue; }
        setFillColor(i);
        // plot all ... or until one point past xAxisEnd
        // or until we reach currentSample
        for (len = Math.min(samplePoint, pointsLength); index < len; index++) {
          if (points[index][0] == null || points[index][1] == null) { continue; }
          dx = points[index][0];
          px = xScale(dx);
          py = yScale(points[index][1]);
          gctx.fillRect(px, py, lineWidth, lineWidth);
          if (dx >= xAxisEnd) { break; }
        }
        // now plot in a desaturated style all the rest of the points
        // ... or until one point past xAxisEnd
        if (index < pointsLength && dx < xAxisEnd) {
          setFillColor(i, true);
          for (;index < pointsLength; index++) {
            if (points[index][0] == null || points[index][1] == null) { continue; }
            dx = points[index][0];
            px = xScale(dx);
            py = yScale(points[index][1]);
            gctx.fillRect(px, py, lineWidth, lineWidth);
            if (dx >= xAxisEnd) { break; }
          }
        }
      }
    }
  }

  function setStrokeColor(i, afterSamplePoint) {
    gctx.strokeStyle = getDataColor(i);
    gctx.globalAlpha = afterSamplePoint ? 0.5 : 1.0;
  }

  function setFillColor(i, afterSamplePoint) {
    gctx.fillStyle   = getDataColor(i);
    gctx.globalAlpha = afterSamplePoint ? 0.4 : 1.0;
  }

  function getDataColor(i) {
    var colorIndex = Math.min(i, options.dataColors.length - 1);
    return colorIndex < 0 ? "black" : options.dataColors[colorIndex];
  }

  // ------------------------------------------------------------
  //
  // Adding samples/data points
  //
  // ------------------------------------------------------------

  // Add an array of points then update the graph.
  function addPoints(datapoints) {
    addDataPoints(datapoints);
    setCurrentSample("last");
    updateOrRescale();
  }

  function replacePoints(datapoints, index) {
    setDataPoints(datapoints, index);
    setCurrentSample("last");
    updateOrRescale();
  }

  // Add an array of samples then update the graph.
  function addSamples(datasamples) {
    addDataSamples(datasamples);
    setCurrentSample("last");
    updateOrRescale();
  }


  // Add a point [x, y] by processing sample (Y value) synthesizing
  // X value from sampleInterval and number of points
  function addSample(sample) {
    var index = points.length,
        xvalue = (index * sampleInterval) + dataSampleStart,
        point = [ xvalue, sample ];
    points.push(point);
    setCurrentSample("last");
    updateOrRescale();
  }

  // Add a point [x, y] to points array
  function addPoint(pnt) {
    points.push(pnt);
    setCurrentSample("last");
    updateOrRescale();
  }

  function comparePoints(a, b) {
    if (a[0] < b[0])
       return -1;
    if (a[0] > b[0])
       return 1;
    return 0;
  }

  function checkPointsOrder(points, newPointIdx) {
    if (!options.sortPoints || points.length < 2) return;
    if (newPointIdx == null) {
      points.sort(comparePoints);
      return;
    }
    // This function assumes that 'points' array was sorted and one new point was added.
    // Sort points only when it's really necessary.
    var newPoint = points[newPointIdx];
    var prevPoint = points[newPointIdx - 1];
    var nextPoint = points[newPointIdx + 1];
    if ((prevPoint && prevPoint[0] > newPoint[0]) ||
        (nextPoint && newPoint[0] > nextPoint[0])) {
      points.sort(comparePoints);
    }
  }

  function updatePointsExtent(newPoint) {
    if (newPoint[0] < pointsXMin) pointsXMin = newPoint[0];
    if (newPoint[1] < pointsYMin) pointsYMin = newPoint[1];
    if (newPoint[0] > pointsXMax) pointsXMax = newPoint[0];
    if (newPoint[1] > pointsYMax) pointsYMax = newPoint[1];
  }

  // Add an array (or arrays) of points.
  function addDataPoints(datapoints) {
    var point;
    var points;
    var pointsIndexed;
    for (var i = 0, len = datapoints.length; i < len; i++) {
      if (datapoints[i] == null) continue;
      points = pointArray[i];
      pointsIndexed = pointArrayIndexed[i];
      if (points == null || pointsIndexed == null) {
        // Create a new data series dynamically in case of need.
        points = pointArray[i] = [];
        pointsIndexed = pointArrayIndexed[i] = [];
      }
      point = datapoints[i];
      points.push(point);
      pointsIndexed.push(point);
      updatePointsExtent(point);
      checkPointsOrder(points, points.length - 1);
    }
  }

  function setDataPoints(datapoints, index) {
    var oldPoint;
    var newPoint;
    var points;
    var pointsIndexed;
    var pointModified = false;
    for (var i = 0, len = datapoints.length; i < len; i++) {
      if (datapoints[i] == null) continue;
      points = pointArray[i];
      pointsIndexed = pointArrayIndexed[i];
      if (points == null || pointsIndexed == null) {
        // Create a new data series dynamically in case of need.
        points = pointArray[i] = [];
        pointsIndexed = pointArrayIndexed[i] = [];
      }
      oldPoint = pointsIndexed[index];
      newPoint = datapoints[i];
      if (oldPoint == null) {
        // Create new point.
        points.push(newPoint);
        pointsIndexed[index] = newPoint;
        checkPointsOrder(points, points.length - 1);
        updatePointsExtent(newPoint);
      } else {
        // Update coordinates manually. We can't simply say:
        // pointsInexed[index] = newPoint;
        // as then we would have to find old point in unindexed points array and replace it too.
        // Here we use the fact that both points and indexed points arrays keep references to the
        // same objects.
        oldPoint[0] = newPoint[0];
        oldPoint[1] = newPoint[1];
        checkPointsOrder(points);
        pointModified = true;
      }
    }
    if (pointModified) {
      // Recalculate points extent as old point could contain min/max values.
      pointsXMin = pointsYMin = Infinity;
      pointsXMax = pointsYMax = -Infinity;
      pointArray.forEach(function (points) {
        points.forEach(updatePointsExtent);
      });
    }
  }

  // Add an array of points by processing an array of samples (Y values)
  // synthesizing the X value from sampleInterval interval and number of points.
  function addDataSamples(datasamples) {
    var start,
        i;
    if (Object.prototype.toString.call(datasamples[0]) === "[object Array]") {
      for (i = 0; i < datasamples.length; i++) {
        if (!pointArray[i]) { pointArray.push([]); }
        points = pointArray[i];
        start = points.length * sampleInterval + dataSampleStart;
        points.push.apply(points, indexedData(datasamples[i], sampleInterval, start));
        pointArray[i] = points;
        points.forEach(updatePointsExtent);
      }
      points = pointArray[0];
    } else {
      var point;
      for (i = 0; i < datasamples.length; i++) {
        if (!pointArray[i]) { pointArray.push([]); }
        start = pointArray[i].length * sampleInterval + dataSampleStart;
        point = [start, datasamples[i]];
        pointArray[i].push(point);
        updatePointsExtent(point);
      }
    }
  }

  function copyNonNull(array) {
    var ret = [];
    array.forEach(function(element) {
      if (element == null || element[0] == null || element[1] == null) return;
      ret.push(element);
    });
    return ret;
  }

  function copyNonNullKeepIndexing(array) {
    var ret = [];
    array.forEach(function(element, idx) {
      if (element == null || element[0] == null || element[1] == null) return;
      ret[idx] = element;
    });
    return ret;
  }

  // Each points array should be processed:
  // - points extent need to be updated,
  // - points may be sorted if "sortPoints" option is enabled.
  function processPointsArray(array) {
    // Update point extent and check if the points array is sorted by X coordinates.
    function checkPoint(point, idx, array) {
      updatePointsExtent(point);
      if (sorted && idx > 0 && point[0] < array[idx - 1][0]) {
        sorted = false;
      }
    }
    // If options.sortPoints is disabled, we won't executed check in the if statement above.
    var sorted = options.sortPoints;
    array.forEach(checkPoint);
    if (!sorted && options.sortPoints) {
      array.sort(comparePoints);
    }
  }

  function resetDataPoints(datapoints) {

    pointsXMin = pointsYMin =  Infinity;
    pointsXMax = pointsYMax = -Infinity;
    pointArray = [];
    pointArrayIndexed = [];
    if (!datapoints || datapoints.length === 0) {
      pointArray = [[]];
      pointArrayIndexed = [[]];
    } else if (Object.prototype.toString.call(datapoints[0]) === "[object Array]") {
      for (var i = 0; i < datapoints.length; i++) {
        pointArray.push(copyNonNull(datapoints[i]));
        pointArrayIndexed.push(copyNonNullKeepIndexing(datapoints[i]));
        processPointsArray(pointArray[i]);
      }
    } else {
      pointArray = [copyNonNull(points)];
      pointArrayIndexed = [copyNonNullKeepIndexing(points)];
      processPointsArray(pointArray[0]);
    }
    points = pointArray[0];

    autoscale();
    setCurrentSample("last");
  }

  function resetDataSamples(datasamples, interval, start) {
    pointsXMin = pointsYMin = Infinity;
    pointsXMax = pointsYMax = -Infinity;
    pointArray = [];
    if (Object.prototype.toString.call(datasamples[0]) === "[object Array]") {
      for (var i = 0; i < datasamples.length; i++) {
        pointArray.push(indexedData(datasamples[i], interval, start));
        pointArray[pointArray.length-1].forEach(updatePointsExtent);
      }
      points = pointArray[0];
    } else {
      points = indexedData(datasamples, interval, start);
      pointArray = [points];
      points.forEach(updatePointsExtent);
    }
    sampleInterval = interval;
    dataSampleStart = start;
  }


  function resetSamples(datasamples) {
    resetDataSamples(datasamples, sampleInterval, dataSampleStart);
  }

  function deletePoint(pointIndex, arrayIndex) {
    if (!arrayIndex) { arrayIndex = 0; }
    var pointsIndexed = pointArrayIndexed[arrayIndex],
        origPts = points.slice(),
        deleted, newPoints;
    if (pointsIndexed.length) {
      deleted = pointsIndexed[pointIndex].slice();
      pointsIndexed[pointIndex][0] = null;
      pointsIndexed[pointIndex][1] = null;
      pointArrayIndexed[arrayIndex] = pointsIndexed;
      newPoints = copyNonNull(pointsIndexed);
      processPointsArray(newPoints);
      pointArray[arrayIndex] = newPoints;
      if (currentSample >= points.length) {
        currentSample = points.length-1;
      }
    }
    points = pointArray[0];
  }

  // ------------------------------------------------------------
  //
  // Keyboard Handling
  //
  // ------------------------------------------------------------

  function registerKeyboardHandler() {
    svg.node().addEventListener("keydown", function (evt) {
      if (!selected) return false;
      if (evt.type === "keydown") {
        switch (evt.keyCode) {
          case 8:   // backspace
          case 46:  // delete
          if (options.dataChange) {
            var i = points.indexOf(selected);
            deletePoint(i);
            selected = points.length ? points[i > 0 ? i - 1 : 0] : null;
            update();
          }
          evt.preventDefault();
          evt.stopPropagation();
          break;
        }
        evt.preventDefault();
      }
    });
  }

  // ------------------------------------------------------------
  //
  // Graph attribute updaters
  //
  // ------------------------------------------------------------

  // update the title
  function updateTitle() {
    if (options.title && title) {
      title.text(options.title);
    }
    renderGraph();
  }

  // update the x-axis label
  function updateXlabel() {
    if (options.xlabel && xlabel) {
      xlabel.text(options.xlabel);
    }
    renderGraph();
  }

  // update the y-axis label
  function updateYlabel() {
    if (options.ylabel && ylabel) {
      ylabel.text(options.ylabel);
    } else {
      ylabel.style("display", "none");
    }
    renderGraph();
  }

  // ------------------------------------------------------------
  //
  // Main API functions ...
  //
  // ------------------------------------------------------------

  function renderGraph() {
    calculateLayout();
    if (svg === undefined) {
      renderNewGraph();
    } else {
      repaintExistingGraph();
    }
    if (options.showButtons) {
      if (!buttonLayer) createButtonLayer();
    }
    if (options.legendLabels.length > 0) {
      if (!legendLayer) {
        createLegendLayer();
      }
      updateLegendVisibility();
    }
    redraw();
  }

  function reset(idOrElement, options, message) {
    if (arguments.length) {
      initialize(idOrElement, options, message);
    } else {
      initialize();
    }

    // fully reset the buttons, in case which ones are enabled has changed
    if (buttonLayer) {
      buttonLayer.remove();
      buttonLayer = null;
    }

    renderGraph();
    // and then render again using actual size of SVG text elements are
    renderGraph();
    redraw();
    registerKeyboardHandler();
    return api;
  }

  function resize(w, h) {
    scale(w, h);
    initializeLayout();
    renderGraph();
    redraw();
    return api;
  }

  //
  // Public API to instantiated Graph
  //
  api = {
    update:               update,
    repaint:              renderGraph,
    reset:                reset,
    redraw:               redraw,
    resize:               resize,
    notify:               notify,

    // selection brush api
    selectionDomain:      selectionDomain,
    selectionVisible:     selectionVisible,
    selectionListener:    selectionListener,
    selectionEnabled:     selectionEnabled,
    hasSelection:         hasSelection,

    /**
      Read only getter for the d3 selection referencing the DOM elements containing the d3
      brush used to implement selection region manipulation.
    */
    brushElement: function() {
      return brush_element;
    },

    /**
      Read-only getter for the d3 brush control (d3.svg.brush() function) used to implement
      selection region manipulation.
    */
    brushControl: function() {
      return brush_control;
    },

    /**
      Read-only getter for the internal listener to the d3 'brush' event.
    */
    brushListener: function() {
      return brushListener;
    },

    /**
      Allow consumption of points added/removed to graph through clicking
      */
    addPointListener: function(callback) {
      pointListeners.push(callback);
    },

    clearPointListeners: function() {
      pointListeners.length = 0;
    },

    // specific update functions ???
    scale:                scale,
    updateOrRescale:      updateOrRescale,

    xDomain: function(_) {
      if (!arguments.length) return [options.xmin, options.xmax];
      options.xmin = _[0];
      options.xmax = _[1];
      if (updateXScale) {
        updateXScale();
        redraw();
      }
      return api;
    },

    yDomain: function(_) {
      if (!arguments.length) return [options.ymin, options.ymax];
      options.ymin = _[0];
      options.ymax = _[1];
      if (updateYScale) {
        updateYScale();
        redraw();
      }
      return api;
    },

    xmin: function(_) {
      if (!arguments.length) return options.xmin;
      options.xmin = _;
      options.xrange = options.xmax - options.xmin;
      if (updateXScale) {
        updateXScale();
        redraw();
      }
      return api;
    },

    xmax: function(_) {
      if (!arguments.length) return options.xmax;
      options.xmax = _;
      options.xrange = options.xmax - options.xmin;
      if (updateXScale) {
        updateXScale();
        redraw();
      }
      return api;
    },

    ymin: function(_) {
      if (!arguments.length) return options.ymin;
      options.ymin = _;
      options.yrange = options.ymax - options.ymin;
      if (updateYScale) {
        updateYScale();
        redraw();
      }
      return api;
    },

    ymax: function(_) {
      if (!arguments.length) return options.ymax;
      options.ymax = _;
      options.yrange = options.ymax - options.ymin;
      if (updateYScale) {
        updateYScale();
        redraw();
      }
      return api;
    },

    xLabel: function(_) {
      if (!arguments.length) return options.xlabel;
      options.xlabel = _;
      updateXlabel();
      return api;
    },

    yLabel: function(_) {
      if (!arguments.length) return options.ylabel;
      options.ylabel = _;
      updateYlabel();
      return api;
    },

    title: function(_) {
      if (!arguments.length) return options.title;
      options.title = _;
      updateTitle();
      return api;
    },

    width: function(_) {
      if (!arguments.length) return size.width;
      size.width = _;
      return api;
    },

    height: function(_) {
      if (!arguments.length) return size.height;
      size.height = _;
      return api;
    },

    elem: function(_) {
      if (!arguments.length) return elem;
      elem = d3.select(_);
      initialize(elem);
      return api;
    },

    numberOfPoints: function() {
      if (points) {
        return points.length;
      } else {
        return false;
      }
    },

    addAnnotation: function(annotation) {
      annotations.push(annotation);
      redraw();
    },

    resetAnnotations: function() {
      annotations.length = 0;
      redraw();
    },

    // Programmatically the same actions as clicking the autoscale button. Note that we sometimes
    // use autoscale internally with its 'fit' argument set to false.
    autoscale: function() {
      autoscale(true);
    },

    // Point data consist of an array (or arrays) of [x,y] arrays.
    addPoints:     addPoints,
    replacePoints: replacePoints,
    addPoint:      addPoint,
    resetPoints:   resetDataPoints,
    deletePoint:   function(i, idx) {
      deletePoint(i, idx);
      update();
    },

    // Sample data consists of an array (or an array or arrays) of samples.
    // The interval between samples is assumed to have already been set
    // by specifying options.sampleInterval when creating the graph.
    addSamples:    addSamples,
    addSample:     addSample,
    resetSamples:  resetSamples

  };

  // Initialization.
  initialize(idOrElement, options, message);

  if (node) {
    renderGraph();
    // Render again using actual size of SVG text elements.
    renderGraph();
  }

  return api;
};

},{"./axis":1,"./i18n":3}],3:[function(require,module,exports){
var DEFAULT_LANG = 'en-US';

module.exports.translations = require('../locales/translations.json');

module.exports.lang = DEFAULT_LANG;
module.exports.fallback = DEFAULT_LANG;

module.exports.t = function(key) {
  var lang = module.exports.lang;
  return getTranslation(lang, key) ||
         getTranslation(lang.split("-")[0], key) ||
         getTranslation(lang.split("_")[0], key) ||
         getTranslation(module.exports.fallback, key) ||
         key;
};

function getTranslation(lang, key) {
  var translations = module.exports.translations;
  var keys = key.split(".");
  var t = translations[lang];
  var i = 0;
  var k = keys[i];
  while (k && typeof t === "object") {
    t = t[k];
    k = keys[++i];
  }
  return t;
}

},{"../locales/translations.json":4}],4:[function(require,module,exports){
module.exports={
  "en-US": {
    "labels": {
      "autoscale": "Zoom",
      "draw": "Draw",
      "selection": "Select",
      "legend": "Key"
    },
    "tooltips": {
      "autoscale": "Show all data (autoscale)",
      "draw": "Draw new data points",
      "selection": "Select data for export",
      "legend": "Show/hide the legend"
    }
  },
   "it": {
    "labels": {
      "autoscale": "Zoom",
      "draw": "Disegnare",
      "selection": "Selezionare",
      "legend": "Chiave"
    },
    "tooltips": {
      "autoscale": "Mostra tutti i dati (autoscala)",
      "draw": "Disegnare nuovi punti dati",
      "selection": "Seleziona i dati per l'esportazione",
      "legend": "Mostra / nascondi la leggenda"
    }
  },
  "es": {
    "labels": {
      "autoscale": "Zoom",
      "draw": "Graficar",
      "selection": "Elegir",
      "legend": "Leyenda"
    },
    "tooltips": {
      "autoscale": "Mostrar todos los datos (autoescala)",
      "draw": "Graficar nuevos puntos",
      "selection": "Seleccionar datos para exportar",
      "legend": "Mostrar/Ocultar la leyenda"
    }
  },
  "pl": {
    "labels": {
      "autoscale": "Przybliż",
      "draw": "Rysuj",
      "selection": "Zaznacz",
      "legend": "Legenda"
    },
    "tooltips": {
      "autoscale": "Pokaż cały wykres (autoskalowanie)",
      "draw": "Rysuj nowe punkty",
      "selection": "Zaznacz dane do wyeksportowania",
      "legend": "Pokaż/ukryj legendę"
    }
  },
  "ru": {
    "labels": {
      "autoscale": "Масштабировать",
      "draw": "Рисовать",
      "selection": "Выбрать",
      "legend": "Ключ"
    },
    "tooltips": {
      "autoscale": "Показать все данные (автоматическое масштабированиe)",
      "draw": "Показать новые данные",
      "selection": "Выбрать данные для экспорта",
      "legend": "Показать/скрыть описание"
    }
  }
}

},{}],5:[function(require,module,exports){
// Graph constructor.
module.exports = require('./lib/graph');
// Setup access to i18n settings. To use language different from 'en-US', just set:
//   LabGrapher.i18n.lang = "some-language-code";
// before calling Graph constructor.
module.exports.i18n = require('./lib/i18n');

},{"./lib/graph":2,"./lib/i18n":3}]},{},[5])
(5)
});
;
/**
 * @license RequireJS text 2.0.2 Copyright (c) 2010-2012, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/requirejs/text for details
 */
/*jslint regexp: true */
/*global require: false, XMLHttpRequest: false, ActiveXObject: false,
  define: false, window: false, process: false, Packages: false,
  java: false, location: false */

define('text',['module'], function (module) {
    'use strict';

    var text, fs,
        progIds = ['Msxml2.XMLHTTP', 'Microsoft.XMLHTTP', 'Msxml2.XMLHTTP.4.0'],
        xmlRegExp = /^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im,
        bodyRegExp = /<body[^>]*>\s*([\s\S]+)\s*<\/body>/im,
        hasLocation = typeof location !== 'undefined' && location.href,
        defaultProtocol = hasLocation && location.protocol && location.protocol.replace(/\:/, ''),
        defaultHostName = hasLocation && location.hostname,
        defaultPort = hasLocation && (location.port || undefined),
        buildMap = [],
        masterConfig = (module.config && module.config()) || {};

    text = {
        version: '2.0.2',

        strip: function (content) {
            //Strips <?xml ...?> declarations so that external SVG and XML
            //documents can be added to a document without worry. Also, if the string
            //is an HTML document, only the part inside the body tag is returned.
            if (content) {
                content = content.replace(xmlRegExp, "");
                var matches = content.match(bodyRegExp);
                if (matches) {
                    content = matches[1];
                }
            } else {
                content = "";
            }
            return content;
        },

        jsEscape: function (content) {
            return content.replace(/(['\\])/g, '\\$1')
                .replace(/[\f]/g, "\\f")
                .replace(/[\b]/g, "\\b")
                .replace(/[\n]/g, "\\n")
                .replace(/[\t]/g, "\\t")
                .replace(/[\r]/g, "\\r")
                .replace(/[\u2028]/g, "\\u2028")
                .replace(/[\u2029]/g, "\\u2029");
        },

        createXhr: masterConfig.createXhr || function () {
            //Would love to dump the ActiveX crap in here. Need IE 6 to die first.
            var xhr, i, progId;
            if (typeof XMLHttpRequest !== "undefined") {
                return new XMLHttpRequest();
            } else if (typeof ActiveXObject !== "undefined") {
                for (i = 0; i < 3; i += 1) {
                    progId = progIds[i];
                    try {
                        xhr = new ActiveXObject(progId);
                    } catch (e) {}

                    if (xhr) {
                        progIds = [progId];  // so faster next time
                        break;
                    }
                }
            }

            return xhr;
        },

        /**
         * Parses a resource name into its component parts. Resource names
         * look like: module/name.ext!strip, where the !strip part is
         * optional.
         * @param {String} name the resource name
         * @returns {Object} with properties "moduleName", "ext" and "strip"
         * where strip is a boolean.
         */
        parseName: function (name) {
            var strip = false, index = name.indexOf("."),
                modName = name.substring(0, index),
                ext = name.substring(index + 1, name.length);

            index = ext.indexOf("!");
            if (index !== -1) {
                //Pull off the strip arg.
                strip = ext.substring(index + 1, ext.length);
                strip = strip === "strip";
                ext = ext.substring(0, index);
            }

            return {
                moduleName: modName,
                ext: ext,
                strip: strip
            };
        },

        xdRegExp: /^((\w+)\:)?\/\/([^\/\\]+)/,

        /**
         * Is an URL on another domain. Only works for browser use, returns
         * false in non-browser environments. Only used to know if an
         * optimized .js version of a text resource should be loaded
         * instead.
         * @param {String} url
         * @returns Boolean
         */
        useXhr: function (url, protocol, hostname, port) {
            var uProtocol, uHostName, uPort,
                match = text.xdRegExp.exec(url);
            if (!match) {
                return true;
            }
            uProtocol = match[2];
            uHostName = match[3];

            uHostName = uHostName.split(':');
            uPort = uHostName[1];
            uHostName = uHostName[0];

            return (!uProtocol || uProtocol === protocol) &&
                   (!uHostName || uHostName.toLowerCase() === hostname.toLowerCase()) &&
                   ((!uPort && !uHostName) || uPort === port);
        },

        finishLoad: function (name, strip, content, onLoad) {
            content = strip ? text.strip(content) : content;
            if (masterConfig.isBuild) {
                buildMap[name] = content;
            }
            onLoad(content);
        },

        load: function (name, req, onLoad, config) {
            //Name has format: some.module.filext!strip
            //The strip part is optional.
            //if strip is present, then that means only get the string contents
            //inside a body tag in an HTML string. For XML/SVG content it means
            //removing the <?xml ...?> declarations so the content can be inserted
            //into the current doc without problems.

            // Do not bother with the work if a build and text will
            // not be inlined.
            if (config.isBuild && !config.inlineText) {
                onLoad();
                return;
            }

            masterConfig.isBuild = config.isBuild;

            var parsed = text.parseName(name),
                nonStripName = parsed.moduleName + '.' + parsed.ext,
                url = req.toUrl(nonStripName),
                useXhr = (masterConfig.useXhr) ||
                         text.useXhr;

            //Load the text. Use XHR if possible and in a browser.
            if (!hasLocation || useXhr(url, defaultProtocol, defaultHostName, defaultPort)) {
                text.get(url, function (content) {
                    text.finishLoad(name, parsed.strip, content, onLoad);
                }, function (err) {
                    if (onLoad.error) {
                        onLoad.error(err);
                    }
                });
            } else {
                //Need to fetch the resource across domains. Assume
                //the resource has been optimized into a JS module. Fetch
                //by the module name + extension, but do not include the
                //!strip part to avoid file system issues.
                req([nonStripName], function (content) {
                    text.finishLoad(parsed.moduleName + '.' + parsed.ext,
                                    parsed.strip, content, onLoad);
                });
            }
        },

        write: function (pluginName, moduleName, write, config) {
            if (buildMap.hasOwnProperty(moduleName)) {
                var content = text.jsEscape(buildMap[moduleName]);
                write.asModule(pluginName + "!" + moduleName,
                               "define(function () { return '" +
                                   content +
                               "';});\n");
            }
        },

        writeFile: function (pluginName, moduleName, req, write, config) {
            var parsed = text.parseName(moduleName),
                nonStripName = parsed.moduleName + '.' + parsed.ext,
                //Use a '.js' file name so that it indicates it is a
                //script that can be loaded across domains.
                fileName = req.toUrl(parsed.moduleName + '.' +
                                     parsed.ext) + '.js';

            //Leverage own load() method to load plugin value, but only
            //write out values that do not have the strip argument,
            //to avoid any potential issues with ! in file names.
            text.load(nonStripName, req, function (value) {
                //Use own write() method to construct full module value.
                //But need to create shell that translates writeFile's
                //write() to the right interface.
                var textWrite = function (contents) {
                    return write(fileName, contents);
                };
                textWrite.asModule = function (moduleName, contents) {
                    return write.asModule(moduleName, fileName, contents);
                };

                text.write(pluginName, nonStripName, textWrite, config);
            }, config);
        }
    };

    if (typeof process !== "undefined" &&
             process.versions &&
             !!process.versions.node) {
        //Using special require.nodeRequire, something added by r.js.
        fs = require.nodeRequire('fs');

        text.get = function (url, callback) {
            var file = fs.readFileSync(url, 'utf8');
            //Remove BOM (Byte Mark Order) from utf8 files if it is there.
            if (file.indexOf('\uFEFF') === 0) {
                file = file.substring(1);
            }
            callback(file);
        };
    } else if (typeof Packages !== 'undefined' && typeof java !== 'undefined') {
        //Why Java, why is this so awkward?
        text.get = function (url, callback) {
            var stringBuffer, line,
                encoding = "utf-8",
                file = new java.io.File(url),
                lineSeparator = java.lang.System.getProperty("line.separator"),
                input = new java.io.BufferedReader(new java.io.InputStreamReader(new java.io.FileInputStream(file), encoding)),
                content = '';
            try {
                stringBuffer = new java.lang.StringBuffer();
                line = input.readLine();

                // Byte Order Mark (BOM) - The Unicode Standard, version 3.0, page 324
                // http://www.unicode.org/faq/utf_bom.html

                // Note that when we use utf-8, the BOM should appear as "EF BB BF", but it doesn't due to this bug in the JDK:
                // http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=4508058
                if (line && line.length() && line.charAt(0) === 0xfeff) {
                    // Eat the BOM, since we've already found the encoding on this file,
                    // and we plan to concatenating this buffer with others; the BOM should
                    // only appear at the top of a file.
                    line = line.substring(1);
                }

                stringBuffer.append(line);

                while ((line = input.readLine()) !== null) {
                    stringBuffer.append(lineSeparator);
                    stringBuffer.append(line);
                }
                //Make sure we return a JavaScript string and not a Java string.
                content = String(stringBuffer.toString()); //String
            } finally {
                input.close();
            }
            callback(content);
        };
    } else if (text.createXhr()) {
        text.get = function (url, callback, errback) {
            var xhr = text.createXhr();
            xhr.open('GET', url, true);

            //Allow overrides specified in config
            if (masterConfig.onXhr) {
                masterConfig.onXhr(xhr, url);
            }

            xhr.onreadystatechange = function (evt) {
                var status, err;
                //Do not explicitly handle errors, those should be
                //visible via console output in the browser.
                if (xhr.readyState === 4) {
                    status = xhr.status;
                    if (status > 399 && status < 600) {
                        //An http 4xx or 5xx error. Signal an error.
                        err = new Error(url + ' HTTP status: ' + status);
                        err.xhr = xhr;
                        errback(err);
                    } else {
                        callback(xhr.responseText);
                    }
                }
            };
            xhr.send(null);
        };
    }

    return text;
});


define('text!locales/translations.json',[],function () { return '{\n  "en-US": {\n    "translation": {\n      "banner": {\n        "about": "About",\n        "about_tooltip": "Instructions",\n        "share": "Share",\n        "share_tooltip": "Share using e-mail, IM or embed in website",\n        "lang_tooltip": "Select language",\n        "reload_tooltip": "Reload interactive",\n        "help_tooltip": "Show help tips",\n        "credits_tooltip": "Learn more about The Concord Consortium",\n        "fullscreen_tooltip": "Toggle full-screen",\n        "video_play_pause_tooltip": "Start / pause the simulation",\n        "video_reset_tooltip": "Reset the simulation",\n        "video_step_back_tooltip": "Step back",\n        "video_step_forward_tooltip": "Step forward",\n        "text_start": "Start",\n        "text_start_tooltip": "Start the simulation or data collection",\n        "text_stop": "Stop",\n        "text_stop_tooltip": "Stop the simulation or data collection",\n        "text_reset": "Reset",\n        "text_reset_tooltip": "Reset the simulation or data collection",\n        "text_new_run": "New Run",\n        "text_new_run_tooltip": "Set up a new experiment run",\n        "text_analyze_data": "Analyze Data",\n        "text_analyze_data_tooltip": "Send data from the experiment to CODAP"\n      },\n      "dialog": {\n        "close_tooltip": "Close"\n      },\n      "about_dialog": {\n        "title": "About: __interactive_title__"\n      },\n      "share_dialog": {\n        "title": "Share: __interactive_title__",\n        "link": "link",\n        "paste_email_im": "Paste this __link__ in email or IM.",\n        "paste_html": "Paste HTML to embed in website or blog.",\n        "select_size": "Select Size:",\n        "size_larger": "__val__% larger",\n        "size_actual": "actual",\n        "size_smaller": "__val__% smaller"\n      },\n      "credits_dialog": {\n        "title": "Credits: __interactive_title__",\n        "credits_text": "This interactive was created by the __CC_link__ using our __Next_Gen_MW_link__ software, with funding by a grant from __Google_link__.",\n        "shareable_ver": "shareable version",\n        "find_shareable": "Find a __shareable_ver_link__ of this interactive along with dozens of other open-source interactives for science, math and engineering at __concord_org_link__."\n      },\n      "copyright": {\n        "copyright": "Copyright",\n        "all_rights_reserved": "All rights reserved.",\n        "license": "The software is licensed under the __MIT_link__ license. Please see __license_link__ for other software and associated licensing included in this product.",\n        "attribution": "Please provide attribution to the Concord Consortium and the URL __concord_org_link__."\n      },\n      "md2d": {\n        "heatbath_icon_tooltip": "Heatbath active",\n        "ke_icon_tooltip": "Kinetic energy gradient",\n        "invalid_object_position_alert": "You can\'t drop the object there.",\n        "aminoacid_menu": {\n          "hydrophobic": "Hydrophobic",\n          "hydrophilic": "Hydrophilic",\n          "glycine": "Glycine",\n          "alanine": "Alanine",\n          "valine": "Valine",\n          "leucine": "Leucine",\n          "isoleucine": "Isoleucine",\n          "phenylalanine": "Phenylalanine",\n          "proline": "Proline",\n          "tryptophan": "Tryptophan",\n          "methionine": "Methionine",\n          "cysteine": "Cysteine",\n          "tyrosine": "Tyrosine",\n          "asparagine": "Asparagine",\n          "glutamine": "Glutamine",\n          "serine": "Serine",\n          "threonine": "Threonine",\n          "asparticacid": "Aspartic acid",\n          "glutamicacid": "Glutamic acid",\n          "lysine": "Lysine",\n          "arginine": "Arginine",\n          "histidine": "Histidine"\n        },\n        "mutations_menu": {\n          "substitution_mutation": "Substitution mutation",\n          "insertion_mutation": "Insertion mutation",\n          "deletion_mutation": "Deletion mutation",\n          "insert": "Insert"\n        }\n      },\n      "sensor": {\n        "select_sensor": "Select Sensor",\n        "select_sensor_type": "Select type of sensor...",\n        "reading": "Reading:",\n        "zero": "Zero",\n        "zeroing": "Zeroing...",\n        "loading_sensor": "Loading sensor...",\n        "choose_sensor_title": "Select a sensor:",\n        "connect": "Connect",\n        "address_labquest2": "address of LabQuest2",\n        "messages": {\n          "ready": "Ready to collect.",\n          "ready_nocontrol": "Please stop the __controlling_client__ data collector to collect data here.",\n          "ready_nocontrol_noname": "Please stop the other active data collector to collect data here.",\n          "no_sensors": "No sensors found.",\n          "no_devices": "No devices plugged in.",\n          "not_connected": "Not connected.",\n          "connecting": "Connecting...",\n          "connection_in_progress": "Connecting to your sensors. If a message comes up about sensorconnector.concord.org, please accept it.",\n          "connection_failed": "Connection failed. __retry_link__",\n          "connection_failed_retry_link_text": "Try again",\n          "connection_failed_alert": "The Concord Consortium Sensor Connector is not installed or is not running. Please __click_here_link__ for instructions on using the Sensor Connector.",\n          "connection_failed_labquest2_alert": "Could not connect to the LabQuest2. Please make sure the address is correct and that the LabQuest2 can be reached from this computer",\n          "tare_labquest2_alert": "The LabQuest2 needs to be collecting live data in order to zero. Either set up a new run on the LabQuest2, or click the meter icon in the upper left.",\n          "click_here": "click here",\n          "connected": "Connected.",\n          "connected_start_labquest2": "Connected. Press start on your LabQuest2 to begin.",\n          "connected_start_sensorconnector": "Please stop the __controlling_client__ data collector to collect data here.",\n          "connected_start_sensorconnector_noname": "Please stop the other active data collector to collect data here.",\n          "starting_data_collection": "Starting data collection...",\n          "error_starting_data_collection": "Error starting data collection.",\n          "error_starting_data_collection_alert": "Could not start data collection. Make sure that (remote starting) is enabled",\n          "collecting_data": "Collecting data.",\n          "collecting_data_stop_labquest2": "Collecting data. Press stop on your LabQuest2 to end.",\n          "collecting_data_stop_sensorconnector": "Collecting data.",\n          "no_data": "No data is available.",\n          "no_data_alert": "The Sensor Connector does not appear to be reporting data for the plugged-in device",\n          "no_data_labquest2_alert": "The LabQuest does not appear to be reporting data for the plugged-in device",\n          "canceling_data_collection": "Canceling data collection...",\n          "error_canceling_data_collection": "Error canceling data collection.",\n          "error_canceling_data_collection_alert": "Could not cancel data collection. Make sure that (remote starting) is enabled",\n          "stopping_data_collection": "Stopping data collection...",\n          "error_stopping_data_collection": "Error stopping data collection.",\n          "error_stopping_data_collection_alert": "Could not stop data collection. Make sure that (remote starting) is enabled",\n          "data_collection_stopped": "Data collection stopped.",\n          "data_collection_complete": "Data collection complete.",\n          "disconnected": "Disconnected.",\n          "java_applet_error": "It appears that Java applets cannot run in your browser. If you are able to fix this, reload the page to use the sensor",\n          "java_applet_not_loading": "The sensor applet appears not to be loading. If you are able to fix this, reload the page to use the sensor",\n          "unexpected_error": "There was an unexpected error when connecting to the sensor.",\n          "sensor_not_attached": "The __sensor_name__ does not appear to be attached. Try re-attaching it, and then click \\"$t(sensor.messages.try_again)\\".",\n          "sensor_or_device_unplugged": "The __sensor_or_device_name__ was unplugged. Try plugging it back in, and then click \\"$t(sensor.messages.try_again)\\".",\n          "try_again": "Try Again",\n          "cancel": "Cancel"\n        },\n        "measurements": {\n          "sensor_reading": "Sensor Reading",\n          "time": "Time",\n          "distance": "Distance",\n          "acceleration": "Acceleration",\n          "altitude": "Altitude",\n          "angle": "Angle",\n          "CO2": "CO₂",\n          "CO2_concentration": "CO₂ Concentration",\n          "charge": "Charge",\n          "conductivity": "Conductivity",\n          "current": "Current",\n          "dissolved_oxygen": "DO",\n          "flow_rate": "Flow Rate",\n          "fluorescence_405_nm": "Fluorescence 405 nm",\n          "fluorescence_500_nm": "Fluorescence 500 nm",\n          "force": "Force",\n          "intensity": "Intensity",\n          "light_level": "Light Level",\n          "light_intensity": "Light Intensity",\n          "magnetic_field": "Magnetic Field",\n          "position": "Position",\n          "potential": "Potential",\n          "pressure": "Pressure",\n          "signal": "Signal",\n          "sound_level": "Sound Level",\n          "speed": "Speed",\n          "temperature": "Temperature",\n          "transmittance": "Transmittance",\n          "turbidity": "Turbidity",\n          "UV_intensity": "UV Intensity",\n          "velocity": "Velocity",\n          "volume": "Volume",\n          "pH": "pH",\n          "acidity": "Acidity",\n          "O2_concentration": "O₂ Concentration"\n        },\n        "names": {\n          "sensor": "sensor",\n          "no_sensor": "(no sensor)",\n          "light": "Light",\n          "motion": "Motion",\n          "accelerometer": "Accelerometer",\n          "dissolved_oxygen": "Dissolved Oxygen",\n          "pressure": "Pressure",\n          "charge_sensor": "Charge Sensor",\n          "voltage": "Voltage",\n          "pH": "pH",\n          "CO2_gas": "CO₂ Gas",\n          "colorimeter": "Colorimeter",\n          "conductivity": "Conductivity",\n          "current": "Current",\n          "temperature": "Temperature",\n          "force": "Force",\n          "anemometer": "Anemometer",\n          "hand_dynamometer": "Hand Dynamometer",\n          "heart_rate": "Heart Rate",\n          "magnetic_field": "Magnetic Field",\n          "rotary_motion": "Rotary Motion",\n          "linear_position_sensor": "Linear Position Sensor",\n          "sound_level": "Sound Level",\n          "spectrophotometer": "Spectrophotometer",\n          "spirometer": "Spirometer",\n          "turbidity": "Turbidity",\n          "UV_sensor": "UV Sensor",\n          "drop_counter": "Drop Counter",\n          "altitude": "Altitude",\n          "goMotion": "GoMotion",\n          "goTemp": "GoIO Temperature Sensor",\n          "goLinkTemperature": "GoIO Temperature Sensor",\n          "goLinkLight": "GoIO Light Sensor",\n          "goLinkForce": "GoIO Force Sensor",\n          "goLinkPH": "GoIO pH Sensor",\n          "goLinkCO2": "GoIO CO₂ sensor",\n          "goLinkO2": "GoIO O₂ sensor",\n          "labQuestMotion": "LabQuest Motion Sensor",\n          "labQuestTemperature": "LabQuest Temperature Sensor",\n          "labQuestLight": "LabQuest Light Sensor",\n          "labQuestForce": "LabQuest Force Sensor",\n          "labQuestPH": "LabQuest pH Sensor",\n          "labQuestCO2": "LabQuest CO₂ sensor",\n          "labQuestO2": "LabQuest O₂ sensor"\n        }\n      }\n    }\n  },\n  \n  "el": {\n    "translation": {\n      "banner": {\n        "about": "Πληροφορίες",\n        "about_tooltip": "Οδηγίες",\n        "share": "Κοινοποίηση",\n        "share_tooltip": "Κοινοποίηση με e-mail, μήνυμα ή ενσωμάτωση σε ιστότοπο",\n        "lang_tooltip": "Επιλογή γλώσσας",\n        "reload_tooltip": "Επαναφόρτωση διαδραστικού",\n        "help_tooltip": "Εμφάνιση συμβουλών",\n        "credits_tooltip": "Μάθε περισσότερα για το Concord Consortium",\n        "fullscreen_tooltip": "Εναλλαγή πλήρους οθόνης",\n        "video_play_pause_tooltip": "Έναρξη / παύση της προσομοίωσης",\n        "video_reset_tooltip": "Επαναφορά της προσομοίωσης",\n        "video_step_back_tooltip": "Βήμα πίσω",\n        "video_step_forward_tooltip": "Βήμα εμπρός",\n        "text_start": "Εκτέλεση",\n        "text_start_tooltip": "Έναρξη της προσομοίωσης ή συλλογή δεδομένων",\n        "text_stop": "Σταμάτημα",\n        "text_stop_tooltip": "Σταμάτημα της προσομοίωσης ή συλλογή δεδομένων",\n        "text_reset": "Επαναφορά",\n        "text_reset_tooltip": "Επαναφορά της προσομοίωσης ή συλλογή δεδομένων",\n        "text_new_run": "Νέα εκτέλεση",\n        "text_new_run_tooltip": "Ρύθμιση μιας νέας εκτέλεσης πειράματος",\n        "text_analyze_data": "Ανάλυση δεδομένων",\n        "text_analyze_data_tooltip": "Αποστολή δεδομένων από το πείραμα στο CODAP"\n      },\n      "dialog": {\n        "close_tooltip": "Κλείσιμο"\n      },\n      "about_dialog": {\n        "title": "Πληροφορίες: __interactive_title__"\n      },\n      "share_dialog": {\n        "title": "Κοινοποίηση: __interactive_title__",\n        "link": "συνδέσμου",\n        "paste_email_im": "Επικόλληση αυτού του __link__ σε email ή μήνυμα.",\n        "paste_html": "Επικόλληση HTML για ενσωμάτωση σε ιστότοπο ή ιστολόγιο.",\n        "select_size": "Επιλογή μεγέθους:",\n        "size_larger": "__val__% μεγαλύτερο",\n        "size_actual": "πραγματικό",\n        "size_smaller": "__val__% μικρότερο"\n      },\n      "credits_dialog": {\n        "title": "Παράγοντες: __interactive_title__",\n        "credits_text": "Αυτό το διαδραστικό δημιουργήθηκε από __CC_link__ χρησιμοποιώντας το λογισμικό __Next_Gen_MW_link__, με χρηματοδότηση μέσω μιας δωρεάς από __Google_link__.",\n        "shareable_ver": "κοινοποιήσιμη έκδοση",\n        "find_shareable": "Εύρεση μιας __shareable_ver_link__ αυτού του διαδραστικού μαζί με δεκάδες άλλων διαδραστικών ανοικτού κώδικα για επιστήμη, μαθηματικά και μηχανική στο __concord_σrg_link__."\n      },\n      "copyright": {\n        "copyright": "Πνευματικά δικαιώματα",\n        "all_rights_reserved": "Όλα τα δικαιώματα κατοχυρωμένα.",\n        "license": "Το λογισμικό είναι αδειοδοτημένο κάτω από άδεια __MIT_link__.",\n        "attribution": "Παρακαλώ αναφέρετε το Concord Consortium και το URL __concord_org_link__."\n      },\n      "md2d": {\n        "heatbath_icon_tooltip": "Λουτρό θερμότητας ενεργό",\n        "ke_icon_tooltip": "Κλίση κινητικής ενέργειας",\n        "invalid_object_position_alert": "Δεν μπορείτε να ρίξετε το αντικείμενο εκεί.",\n        "aminoacid_menu": {\n          "hydrophobic": "Υδρόφοβο",\n          "hydrophilic": "Υδρόφιλο",\n          "glycine": "Γλυκίνη",\n          "alanine": "Αλανίνη",\n          "valine": "Βαλίνη",\n          "leucine": "Λευκίνη",\n          "isoleucine": "Ισολευκίνη",\n          "phenylalanine": "Φαινυλαλανίνη",\n          "proline": "Προλίνη",\n          "tryptophan": "Τρυπτοφάνη",\n          "methionine": "Μεθειονίνη",\n          "cysteine": "Κυστεΐνη",\n          "tyrosine": "Τυροσίνη",\n          "asparagine": "Ασπαραγίνη",\n          "glutamine": "Γλουταμίνη",\n          "serine": "Σερίνη",\n          "threonine": "Θρεονίνη",\n          "asparticacid": "Ασπαρτικό οξύ",\n          "glutamicacid": "Γλουταμινικό οξύ",\n          "lysine": "Λυσίνη",\n          "arginine": "Αργινίνη",\n          "histidine": "Ιστιδίνη"\n        },\n        "mutations_menu": {\n          "substitution_mutation": "Μετάλλαξη αντικατάστασης",\n          "insertion_mutation": "Μετάλλαξη προσθήκης",\n          "deletion_mutation": "Μετάλλαξη αφαίρεσης",\n          "insert": "Εισαγωγή"\n        }\n      },\n      "sensor": {\n        "select_sensor": "Επιλογή αισθητήρα",\n        "select_sensor_type": "Επιλογή τύπου αισθητήρα...",\n        "reading": "Ανάγνωση:",\n        "zero": "Μηδέν",\n        "zeroing": "Μηδενισμός...",\n        "loading_sensor": "Φόρτωμα αισθητήρα...",\n        "choose_sensor_title": "Επιλογή αισθητήρα:",\n        "connect": "Σύνδεση",\n        "address_labquest2": "διεύθυνση του LabQuest2",\n        "messages": {\n          "ready": "Έτοιμο για συλλογή.",\n          "ready_nocontrol": "Παρακαλώ σταματήστε το συλλέκτη δεδομένων __controlling_client__ για να συλλέξετε δεδομένα εδώ.",\n          "ready_nocontrol_noname": "Παρακαλώ σταματήστε τον άλλο ενεργό συλλέκτη δεδομένων για να συλλέξετε δεδομένα εδώ.",\n          "no_sensors": "Δε βρέθηκαν αισθητήρες.",\n          "no_devices": "Δεν υπάρχουν συνδεδεμένες συσκευές.",\n          "not_connected": "Μη συνδεδεμένο.",\n          "connecting": "Σύνδεση...",\n          "connection_in_progress": "Γίνετε σύνδεση στους αισθητήρες σας. Αν εμφανιστεί ένα μήνυμα για το sensorconnector.concord.org, παρακαλώ αποδεχτείτε το.",\n          "connection_failed": "Η σύνδεση απέτυχε. __retry_link__",\n          "connection_failed_retry_link_text": "Προσπαθήστε ξανά",\n          "connection_failed_alert": "Το Concord Consortium Sensor Connector δεν είναι εγκατεστημένο ή δεν εκτελείται. Παρακαλώ __click_here_link__ για οδηγίες χρήσης του Sensor Connector.",\n          "connection_failed_labquest2_alert": "Δεν ήταν δυνατό να γίνει σύνδεση στο LabQuest2. Παρακαλώ σιγουρευτείτε πως η διεύθυνση είναι σωστή και πως το LabQuest2 μπορεί να προσπελαστεί από αυτόν τον υπολογιστή",\n          "tare_labquest2_alert": "Το LabQuest2 χρειάζεται να συλλέγει ζωντανά δεδομένα για να μηδενιστεί. Είτε ρυθμίστε μια νέα εκτέλεση στο LabQuest2, ή κάντε κλικ στο εικονίδιο μετρητή πάνω αριστερά.",\n          "click_here": "πατήστε εδώ",\n          "connected": "Συνδεδεμένο.",\n          "connected_start_labquest2": "Συνδεδεμένο. Πατήστε έναρξη στο LabQuest2 για έναρξη.",\n          "connected_start_sensorconnector": "Παρακαλώ σταματήστε το συλλέκτη δεδομένων __controlling_client__ για να συλλέξετε δεδομένα εδώ.",\n          "connected_start_sensorconnector_noname": "Παρακαλώ σταματήστε τον άλλο ενεργό συλλέκτη δεδομένων για να συλλέξετε δεδομένα εδώ.",\n          "starting_data_collection": "Έναρξη συλλογής δεδομένων...",\n          "error_starting_data_collection": "Σφάλμα έναρξης συλλογής δεδομένων.",\n          "error_starting_data_collection_alert": "Δεν ήταν δυνατή η έναρξη συλλογής δεδομένων. Σιγουρευτείτε πως η (απομακρυσμένη έναρξη) είναι ενεργοποιημένη",\n          "collecting_data": "Συλλογή δεδομένων.",\n          "collecting_data_stop_labquest2": "Συλλογή δεδομένων. Πατήστε σταμάτημα στο LabQuest2 για τερματισμό.",\n          "collecting_data_stop_sensorconnector": "Συλλογή δεδομένων.",\n          "no_data": "Δεν υπάρχουν διαθέσιμα δεδομένα.",\n          "no_data_alert": "Το Sensor Connector δε φαίνεται να αναφέρει δεδομένα για τη συνδεδεμένη συσκευή",\n          "no_data_labquest2_alert": "Το LabQuest δε φαίνεται να αναφέρει δεδομένα για τη συνδεδεμένη συσκευή",\n          "canceling_data_collection": "Ακύρωση συλλογής δεδομένων...",\n          "error_canceling_data_collection": "Σφάλμα ακύρωσης συλλογής δεδομένων.",\n          "error_canceling_data_collection_alert": "Δεν ήταν δυνατή η ακύρωση συλλογής δεδομένων. Σιγουρευτείτε πως η (απομακρυσμένη εκκίνηση) είναι ενεργοποιημένη",\n          "stopping_data_collection": "Τερματισμός συλλογής δεδομένων...",\n          "error_stopping_data_collection": "Σφάλμα τερματισμού συλλογής δεδομένων.",\n          "error_stopping_data_collection_alert": "Δεν ήταν δυνατός ο τερματισμός συλλογής δεδομένων. Σιγουτευτείτε πως η (απομακρυσμένη συλλογή δεδομένων) είναι ενεργοποιημένη",\n          "data_collection_stopped": "Η συλλογή δεδομένων τερματίστηκε.",\n          "data_collection_complete": "Η συλλογή δεδομένων ολοκληρώθηκε.",\n          "disconnected": "Αποσυνδεδεμένο.",\n          "java_applet_error": "Φαίνεται πως δεν επιτρέπεται εκτέλεση Java applet στο φυλλομετρητή σας. Αν μπορείτε να το διορθώσετε, επαναφορτώστε τη σελίδα για να χρησιμοποιήσετε τον αισθητήρα",\n          "java_applet_not_loading": "Το applet του αισθητήρα φαίνεται να μη φορτώνεται. Αν μπορείτε να το διορθώσετε, επαναφορτώστε τη σελίδα για να χρησιμοποιήσετε τον αισθητήρα",\n          "unexpected_error": "Υπήρξε ένα μη αναμενόμενο σφάλμα κατά τη σύνδεση στον αισθητήρα.",\n          "sensor_not_attached": "Το __sensor_name__ does δεν φαίνεται να είναι συνδεδεμένο. Δοκιμάστε να το επανασυνδέσετε, και έπειτα πατήστε \\"$t(sensor.messages.try_again)\\".",\n          "sensor_or_device_unplugged": "Το __sensor_or_device_name__ αποσυνδέθηκε. Δοκιμάστε να το επανασυνδέσετε, και έπειτα πατήστε \\"$t(sensor.messages.try_again)\\".",\n          "try_again": "Προσπαθήστε ξανά",\n          "cancel": "Άκυρο"\n        },\n        "measurements": {\n          "sensor_reading": "Μέτρηση αισθητήρα",\n          "time": "Χρόνος",\n          "distance": "Απόσταση",\n          "acceleration": "Επιτάχυνση",\n          "altitude": "Υψόμετρο",\n          "angle": "Γωνία",\n          "CO2": "CO₂",\n          "CO2_concentration": "Συγκέντρωση CO₂",\n          "charge": "Φορτίο",\n          "conductivity": "Αγωγιμότητα",\n          "current": "Ρεύμα",\n          "dissolved_oxygen": "DO (διαλυμένο Οξυγόνο)",\n          "flow_rate": "Ρυθμός ροής",\n          "fluorescence_405_nm": "Φθορισμός 405 nm",\n          "fluorescence_500_nm": "Φθορισμός 500 nm",\n          "force": "Δύναμη",\n          "intensity": "Ένταση",\n          "light_level": "Επίπεδο φωτός",\n          "light_intensity": "Ένταση φωτός",\n          "magnetic_field": "Μαγνητικό πεδίο",\n          "position": "Θέση",\n          "potential": "Δυναμικό",\n          "pressure": "Πίεση",\n          "signal": "Σήμα",\n          "sound_level": "Επίπεδο ήχου",\n          "speed": "Ταχύτητα",\n          "temperature": "Θερμοκρασία",\n          "transmittance": "Μεταδοτικότητα",\n          "turbidity": "Θολότητα",\n          "UV_intensity": "Ένταση UV",\n          "velocity": "Διανυσματική ταχύτητα",\n          "volume": "Volume",\n          "pH": "pH",\n          "acidity": "Οξύτητα",\n          "O2_concentration": "Συγκέντρωση O₂"\n        },\n        "names": {\n          "sensor": "αισθητήρας",\n          "no_sensor": "(χωρίς αισθητήρα)",\n          "light": "Φώς",\n          "motion": "Κίνηση",\n          "accelerometer": "Επιταχυνσιόμετρο",\n          "dissolved_oxygen": "Διαλυμένο Οξυγόνο",\n          "pressure": "Πίεση",\n          "charge_sensor": "Αισθητήρας φορτίου",\n          "voltage": "Τάση",\n          "pH": "pH",\n          "CO2_gas": "Αέριο CO₂",\n          "colorimeter": "Χρωματόμετρο",\n          "conductivity": "Αγωγιμότητα",\n          "current": "Ρεύμα",\n          "temperature": "Θερμοκρασία",\n          "force": "Δύναμη",\n          "anemometer": "Ανεμόμετρο",\n          "hand_dynamometer": "Δυναμόμετρο χειρός",\n          "heart_rate": "Καρδιακός ρυθμός",\n          "magnetic_field": "Μαγνητικό πεδίο",\n          "rotary_motion": "Περιστροφική κίνηση",\n          "linear_position_sensor": "Αισθητήρας γραμικής θέσης",\n          "sound_level": "Επίπεδο ήχου",\n          "spectrophotometer": "Φασματοφωτόμετρο",\n          "spirometer": "Σπιρόμετρο",\n          "turbidity": "Θολότητα",\n          "UV_sensor": "Αισθητήρας UV",\n          "drop_counter": "Μετρητής πτώσης",\n          "altitude": "Υψόμετρο",\n          "goMotion": "GoMotion",\n          "goTemp": "GoIO αισθητήρας θερμοκρασίας",\n          "goLinkTemperature": "GoIO αισθητήρας θερμοκρασίας",\n          "goLinkLight": "GoIO αισθητήρας φωτός",\n          "goLinkForce": "GoIO αισθητήρας δύναμης",\n          "goLinkPH": "GoIO αισθητήρας pH",\n          "goLinkCO2": "GoIO αισθητήρας CO₂",\n          "goLinkO2": "GoIO αισθητήρας O₂",\n          "labQuestMotion": "LabQuest αισθητήρας κίνησης",\n          "labQuestTemperature": "LabQuest αισθητήρας θερμοκρασίας",\n          "labQuestLight": "LabQuest αισθητήρας φωτός",\n          "labQuestForce": "LabQuest αισθητήρας δύναμης",\n          "labQuestPH": "LabQuest αισθητήρας pH",\n          "labQuestCO2": "LabQuest αισθητήρας CO₂",\n          "labQuestO2": "LabQuest αισθητήρας O₂"\n        }\n      }\n    }\n  },\n  \n  "it": {\n    "translation": {\n      "banner": {\n        "about": "Chi siamo",\n        "about_tooltip": "Istruzioni",\n        "share": "Condividere",\n        "share_tooltip": "Condividi tramite e-mail, IM o incorporato nel sito web",\n        "lang_tooltip": "Seleziona la lingua",\n        "reload_tooltip": "Ricarica interattiva",\n        "help_tooltip": "Mostra suggerimenti di aiuto",\n        "credits_tooltip": "Scopri di più su The Concord Consortium",\n        "fullscreen_tooltip": "Passare a schermo intero",\n        "video_play_pause_tooltip": "Avviare / mettere in pausa la simulazione",\n        "video_reset_tooltip": "Ripristina la simulazione",\n        "video_step_back_tooltip": "Fai un passo indietro",\n        "video_step_forward_tooltip": "Passo in avanti",\n        "text_start": "Inizio",\n        "text_start_tooltip": "Avviare la simulazione o la raccolta di dati",\n        "text_stop": "Stop",\n        "text_stop_tooltip": "Interrompere la simulazione o la raccolta dei dati",\n        "text_reset": "Reset",\n        "text_reset_tooltip": "Ripristina la simulazione o la raccolta di dati",\n        "text_new_run": "Nuova corsa",\n        "text_new_run_tooltip": "Imposta un nuovo run di esperimenti",\n        "text_analyze_data": "Analizzare i dati",\n        "text_analyze_data_tooltip": "Invia dati dall\'esperimento a CODAP"\n      },\n      "dialog": {\n        "close_tooltip": "Chiudere"\n      },\n      "about_dialog": {\n        "title": "Di: __interactive_title__"\n      },\n      "share_dialog": {\n        "title": "Condividere: __interactive_title__",\n        "link": "link",\n        "paste_email_im": "Incolla questo __link__ in posta elettronica o IM.",\n        "paste_html": "Incolla HTML per incorporare in sito o blog.",\n        "select_size": "Seleziona la dimensione:",\n        "size_larger": "__val__% più grandi",\n        "size_actual": "effettivo",\n        "size_smaller": "__val__% più piccola"\n      },\n      "credits_dialog": {\n        "title": "Crediti: __interactive_title__",\n        "credits_text": "Questo interattivo è stato creato da __CC_link__ usando il nostru __Next_Gen_MW_link__ software, con finanziamento da una sovvenzione di __Google_link__.",\n        "shareable_ver": "versione condivisibile",\n        "find_shareable": "Trova un __shareable_ver_link__ di questo interattivo insieme a decine di altri interattivi open-source per la scienza, la matematica e l\'ingegneria a __concord_org_link__."\n      },\n      "copyright": {\n        "copyright": "Diritto d\'autore",\n        "all_rights_reserved": "Tutti i diritti riservati.",\n        "license": "Il software è concesso in licenza sotto il __MIT_link__ license.",\n        "attribution": "Fornire l\'attribuzione al Consorzio Concord e all\'URL __concord_org_link__."\n      },\n      "md2d": {\n        "heatbath_icon_tooltip": "Bagno termico attivo",\n        "ke_icon_tooltip": "Gradiente di energia cinetica",\n        "invalid_object_position_alert": "Non puoi posizionare l\'oggetto in quel luogo.",\n        "aminoacid_menu": {\n          "hydrophobic": "Idrofobo",\n          "hydrophilic": "Idrofilo",\n          "glycine": "Glycine",\n          "alanine": "Alanina",\n          "valine": "Valina",\n          "leucine": "Leucina",\n          "isoleucine": "Isoleucine",\n          "phenylalanine": "Fenilalanina",\n          "proline": "Proline",\n          "tryptophan": "Triptofano",\n          "methionine": "Metionina",\n          "cysteine": "Cisteina",\n          "tyrosine": "Tirosina",\n          "asparagine": "Asparagina",\n          "glutamine": "Glutammina",\n          "serine": "Serina",\n          "threonine": "Treonina",\n          "asparticacid": "Acido aspartico",\n          "glutamicacid": "Acido glutammico",\n          "lysine": "Lisina",\n          "arginine": "Arginina",\n          "histidine": "Istidina"\n        },\n        "mutations_menu": {\n          "substitution_mutation": "Mutazione di sostituzione",\n          "insertion_mutation": "Mutazione di inserzione",\n          "deletion_mutation": "Mutazione deletione",\n          "insert": "Inserire"\n        }\n      },\n      "sensor": {\n        "select_sensor": "Selezionare Sensore",\n        "select_sensor_type": "Seleziona il tipo di sensore ...",\n        "reading": "Lettura:",\n        "zero": "Zero",\n        "zeroing": "Azzeramento...",\n        "loading_sensor": "Sensore di carico...",\n        "choose_sensor_title": "Selezionare un sensore:",\n        "connect": "Collegare",\n        "address_labquest2": "Indirizzo di LabQuest2",\n        "messages": {\n          "ready": "Pronta da raccogliere.",\n          "ready_nocontrol": "Si prega di fermare __controlling_client__ raccoglitore di dati per raccogliere i dati qui.",\n          "ready_nocontrol_noname": "Fermati l\'altro collezionista attivo per raccogliere i dati qui.",\n          "no_sensors": "Nessun sensore è stato trovato.",\n          "no_devices": "Nessun dispositivo collegato.",\n          "not_connected": "Non collegata.",\n          "connecting": "Connessione in corso ...",\n          "connection_in_progress": "Collegamento ai sensori. Se viene visualizzato un messaggio sensorconnector.concord.org, si prega di accettarlo.",\n          "connection_failed": "Connessione fallita. __retry_link__",\n          "connection_failed_retry_link_text": "Riprova",\n          "connection_failed_alert": "Il Concord Consortium Sensor Connector non è installato o non è in esecuzione. Per favore __click_here_link__ per istruzioni sull\'utilizzo del connettore del sensore.",\n          "connection_failed_labquest2_alert": "Impossibile connettersi a LabQuest2. Assicurarsi che l\'indirizzo sia corretto e che il LabQuest2 possa essere raggiunto da questo computer",\n          "tare_labquest2_alert": "Il LabQuest2 deve raccogliere i dati dal vivo per zero. Impostare una nuova esecuzione su LabQuest2 oppure fare clic sull\'icona del contatore in alto a sinistra.",\n          "click_here": "clicca qui",\n          "connected": "Collegato.",\n          "connected_start_labquest2": "Collegato. Avviare l\'inizio del tuo LabQuest2 per iniziare.",\n          "connected_start_sensorconnector": "Si prega di fermare __controlling_client__ raccoglitore di dati per raccogliere i dati qui.",\n          "connected_start_sensorconnector_noname": "Ferma l\'altro collezionista attivo per raccogliere i dati qui.",\n          "starting_data_collection": "Inizia la raccolta dati ...",\n          "error_starting_data_collection": "Errore durante la raccolta dati.",\n          "error_starting_data_collection_alert": "Impossibile avviare la raccolta dati. Assicurarsi che sia abilitato (avvio remoto)",\n          "collecting_data": "Raccolta dati.",\n          "collecting_data_stop_labquest2": "Raccolta dati. Arrestare la sosta sul tuo LabQuest2 per terminare.",\n          "collecting_data_stop_sensorconnector": "Raccolta dati.",\n          "no_data": "Nessun dato disponibile.",\n          "no_data_alert": "Il connettore del sensore non sembra riportare i dati per il dispositivo collegato",\n          "no_data_labquest2_alert": "Il LabQuest non sembra riportare i dati per il dispositivo collegato",\n          "canceling_data_collection": "Annullamento della raccolta dati ...",\n          "error_canceling_data_collection": "Errore durante l\'annullamento della raccolta dati.",\n          "error_canceling_data_collection_alert": "Impossibile annullare la raccolta dei dati. Assicurarsi che sia abilitato (avvio remoto)",\n          "stopping_data_collection": "Arresto della raccolta dati ...",\n          "error_stopping_data_collection": "Errore durante l\'arresto della raccolta dati.",\n          "error_stopping_data_collection_alert": "Impossibile arrestare la raccolta dati. Assicurarsi che sia abilitato (avvio remoto)",\n          "data_collection_stopped": "La raccolta dati è stata interrotta.",\n          "data_collection_complete": "La raccolta dei dati è completa.",\n          "disconnected": "Scollegato.",\n          "java_applet_error": "Sembra che gli applet Java non possano essere eseguiti nel tuo browser. Se è in grado di risolvere questo problema, ricaricare la pagina per utilizzare il sensore",\n          "java_applet_not_loading": "L\'applet del sensore sembra non essere caricato. Se è in grado di risolvere questo problema, ricaricare la pagina per utilizzare il sensore",\n          "unexpected_error": "Si è verificato un errore imprevisto quando si connette al sensore.",\n          "sensor_not_attached": "Il __sensor_name__ non sembra essere allegato. Provare a ricollegarlo, quindi fare clic su \\"$t(sensor.messages.try_again)\\".",\n          "sensor_or_device_unplugged": "Il __sensor_or_device_name__ È stato scollegato. Provare a collegarlo nuovamente e quindi fare clic su \\"$t(sensor.messages.try_again)\\".",\n          "try_again": "Riprova",\n          "cancel": "Annulla"\n        },\n        "measurements": {\n          "sensor_reading": "Lettura del sensore",\n          "time": "Tempo",\n          "distance": "Distanza",\n          "acceleration": "Accelerazione",\n          "altitude": "Altitudine",\n          "angle": "Angolo",\n          "CO2": "CO₂",\n          "CO2_concentration": "CO₂ Concentrazione",\n          "charge": "Carica",\n          "conductivity": "Conducibilità",\n          "current": "Current",\n          "dissolved_oxygen": "FARE",\n          "flow_rate": "Portata",\n          "fluorescence_405_nm": "Fluorescenza 405 nm",\n          "fluorescence_500_nm": "Fluorescenza 500 nm",\n          "force": "Vigore",\n          "intensity": "Intensità",\n          "light_level": "Livello luminoso",\n          "light_intensity": "Intensità luminosa",\n          "magnetic_field": "Campo magnetico",\n          "position": "Posizione",\n          "potential": "Potenziale",\n          "pressure": "Pressure",\n          "signal": "Segnale",\n          "sound_level": "Livello audio",\n          "speed": "Velocità",\n          "temperature": "Temperatura",\n          "transmittance": "Trasmissione",\n          "turbidity": "Torbidità",\n          "UV_intensity": "Intensità UV",\n          "velocity": "Velocità",\n          "volume": "Volume",\n          "pH": "pH",\n          "acidity": "Acidità",\n          "O2_concentration": "O₂ Concentrazione"\n        },\n        "names": {\n          "sensor": "sensore",\n          "no_sensor": "(Nessun sensore)",\n          "light": "Leggero",\n          "motion": "Movimento",\n          "accelerometer": "Accelerometro",\n          "dissolved_oxygen": "Ossigeno dissolto",\n          "pressure": "Pressione",\n          "charge_sensor": "Sensore di carica",\n          "voltage": "Voltaggio",\n          "pH": "pH",\n          "CO2_gas": "CO₂ Gas",\n          "colorimeter": "Colorimetro",\n          "conductivity": "Conducibilità",\n          "current": "Attuale",\n          "temperature": "Temperature",\n          "force": "Vigore",\n          "anemometer": "Anemometro",\n          "hand_dynamometer": "Dynamometer della mano",\n          "heart_rate": "Frequenza cardiaca",\n          "magnetic_field": "Campo magnetico",\n          "rotary_motion": "Moto rotativo",\n          "linear_position_sensor": "Sensore di posizione lineare",\n          "sound_level": "Livello audio",\n          "spectrophotometer": "spettrofotometro",\n          "spirometer": "Spirometro",\n          "turbidity": "torbidità",\n          "UV_sensor": "Sensore UV",\n          "drop_counter": "Contatore di caduta",\n          "altitude": "Altitudine",\n          "goMotion": "GoMotion",\n          "goTemp": "Sensore di temperatura GoIO",\n          "goLinkTemperature": "Sensore di temperatura GoIO",\n          "goLinkLight": "Sensore di luce GoIO",\n          "goLinkForce": "Sensore di forza GoIO",\n          "goLinkPH": "Sensore pH GoIO",\n          "goLinkCO2": "Sensore GoIO CO₂",\n          "goLinkO2": "Sensore GoIO O2",\n          "labQuestMotion": "LabQuest Motion Sensore",\n          "labQuestTemperature": "Sensore di temperatura LabQuest",\n          "labQuestLight": "Sensore di luce LabQuest",\n          "labQuestForce": "Sensore di forza LabQuest",\n          "labQuestPH": "Sensore pH LabQuest",\n          "labQuestCO2": "Sensore COQQuest CO₂",\n          "labQuestO2": "Sensore LabQuest O2"\n        }\n      }\n    }\n  },\n  \n  "pl": {\n    "translation": {\n      "banner": {\n        "about": "O symulacji",\n        "about_tooltip": "Instrukcje",\n        "share": "Udostępnij",\n        "share_tooltip": "Udostępnij tę symulację za pomocą e-mail, komunikatora lub umieść na swojej stronie internetowej",\n        "lang_tooltip": "Zmień język",\n        "reload_tooltip": "Załaduj symulację ponownie",\n        "help_tooltip": "Pokaż pomoc",\n        "credits_tooltip": "Dowiedz się więcej o Concord Consortium",\n        "fullscreen_tooltip": "Tryb pełnoekranowy",\n        "video_play_pause_tooltip": "Uruchom lub zatrzymaj symulację",\n        "video_reset_tooltip": "Zresetuj symulację",\n        "video_step_back_tooltip": "Krok wstecz",\n        "video_step_forward_tooltip": "Krok do przodu",\n        "text_start": "Uruchom",\n        "text_start_tooltip": "Uruchom symulację lub pobieranie danych",\n        "text_stop": "Zatrzymaj",\n        "text_stop_tooltip": "Zatrzymaj symulację lub pobieranie danych",\n        "text_reset": "Zresetuj",\n        "text_reset_tooltip": "Zresetuj symulację lub pobieranie danych"\n      },\n      "dialog": {\n        "close_tooltip": "Zamknij"\n      },\n      "about_dialog": {\n        "title": "O symulacji: __interactive_title__"\n      },\n      "share_dialog": {\n        "title": "Udostępnij: __interactive_title__",\n        "link": "odnośnik",\n        "paste_email_im": "Wklej ten __link__ do wiadomości e-mail lub wyślij za pomocą komunikatora.",\n        "paste_html": "Aby zamieścić symulację na swojej stronie lub blogu, wklej kod HTML znajdujący się poniżej.",\n        "select_size": "Wybierz rozmiar:",\n        "size_larger": "__val__% większy",\n        "size_actual": "aktualny",\n        "size_smaller": "__val__% mniejszy"\n      },\n      "credits_dialog": {\n        "title": "__interactive_title__",\n        "credits_text": "Ta symulacja została stworzona przez __CC_link__ przy użyciu __Next_Gen_MW_link__. Prace zostały sfinansowana przez grant otrzymany od __Google_link__.",\n        "shareable_ver": "Wersję tej symulacji, którą możesz udostępnić",\n        "find_shareable": "__shareable_ver_link__, wraz z setkami innych, darmowych symulacji i ćwiczeń znajdziesz na __concord_org_link__."\n      },\n      "copyright": {\n        "copyright": "Copyright",\n        "all_rights_reserved": "Wszystkie prawa zastrzeżone.",\n        "license": "To oprogramowanie jest rozpowszechniane na zasadach wolnej licencji __MIT_link__. Szczegóły licencji znajdują się w pliku __license_link__.",\n        "attribution": "Proszę umieścić odniesienia do Concord Consortium oraz witryny __concord_org_link__."\n      },\n      "md2d": {\n        "heatbath_icon_tooltip": "Stała temperatura",\n        "ke_icon_tooltip": "Skala energii kinetycznej",\n        "invalid_object_position_alert": "Niepoprawna pozycja obiektu.",\n        "aminoacid_menu": {\n          "hydrophobic": "Hydrofobowe",\n          "hydrophilic": "Hydrofilowe",\n          "glycine": "Glicyna",\n          "alanine": "Alanina",\n          "valine": "Walina",\n          "leucine": "Leucyna",\n          "isoleucine": "Izoleucyna",\n          "phenylalanine": "Fenyloalanina",\n          "proline": "Prolina",\n          "tryptophan": "Tryptofan",\n          "methionine": "Metionina",\n          "cysteine": "Cysteina",\n          "tyrosine": "Tyrozyna",\n          "asparagine": "Asparagina",\n          "glutamine": "Glutamina",\n          "serine": "Seryna",\n          "threonine": "Treonina",\n          "asparticacid": "Kwas asparaginowy",\n          "glutamicacid": "Kwas glutaminowy",\n          "lysine": "Lizyna",\n          "arginine": "Arginina",\n          "histidine": "Histydyna"\n        },\n        "mutations_menu": {\n          "substitution_mutation": "Substytucja",\n          "insertion_mutation": "Insercja",\n          "deletion_mutation": "Delecja",\n          "insert": "Wstaw"\n        }\n      },\n      "sensor": {\n        "select_sensor": "Wybierz sensor",\n        "select_sensor_type": "Wybierz rodzaj sensora...",\n        "reading": "Odczyt:",\n        "zero": "Wyzeruj",\n        "zeroing": "Zerowanie...",\n        "loading_sensor": "Ładowanie sensora...",\n        "choose_sensor_title": "Wybierz sensor:",\n        "connect": "Połącz",\n        "address_labquest2": "adres serwera LabQuest2",\n        "messages": {\n          "ready": "Gotowy do odczytu.",\n          "no_sensors": "Nie znaleziono sensorów.",\n          "no_devices": "Żadne urządzenie nie jest podłączone.",\n          "not_connected": "Brak połączenia.",\n          "connecting": "Łączenie...",\n          "connection_failed": "Połączenie nieudane.",\n          "connection_failed_alert": "Concord Consortium Sensor Connector nie jest zainstalowany lub nie działa. Proszę __click_here_link__ żeby otworzyć instrukcję dotyczącą korzystania z Sensor Connector.",\n          "connection_failed_labquest2_alert": "Nie udało się połączyć z LabQuest2. Upewnij się, że adres jest poprawny i LabQuest2 jest osiągalny z tego komputera.",\n          "tare_labquest2_alert": "LabQuest2 musi pobierać rzeczywiste dane aby się wyzerować. Ustaw nowy eksperyment na LabQuest2 lub kliknij ikonę licznika na górze po lewej stronie.",\n          "click_here": "kliknąć tutaj",\n          "connected": "Połączono.",\n          "connected_start_labquest2": "Połączono. Naciśnij start na LabQuest2 aby rozpocząć.",\n          "starting_data_collection": "Rozpoczynanie pobierania danych...",\n          "error_starting_data_collection": "Błąd podczas rozpoczynania pobierania danych.",\n          "error_starting_data_collection_alert": "Nie udało się rozpocząć pobierania danych. Upewnij się, że (remote starting) jest włączony",\n          "collecting_data": "Pobieranie danych.",\n          "collecting_data_stop_labquest2": "Pobieranie danych. Naciśnij stop na LabQuest2 aby zakończyć.",\n          "no_data": "Brak dostępnych danych.",\n          "no_data_alert": "Sensor Connector nie wydaje się raportować żadnych danych dla podłączonego urządzenia",\n          "no_data_labquest2_alert": "LabQuest nie wydaje się raportować żadnych danych dla podłączonego urządzenia",\n          "canceling_data_collection": "Anulowanie pobierania danych...",\n          "error_canceling_data_collection": "Błąd podczas anulowania pobierania danych.",\n          "error_canceling_data_collection_alert": "Nie udało się anulować pobierania danych. Upewnij się, że (remote starting) jest włączony",\n          "stopping_data_collection": "Zatrzymywanie pobierania danych...",\n          "error_stopping_data_collection": "Błąd podczas zatrzymywania pobierania danych.",\n          "error_stopping_data_collection_alert": "Nie udało się zatrzymać pobierania danych. Upewnij się, że (remote starting) jest włączony",\n          "data_collection_stopped": "Pobieranie danych zatrzymane.",\n          "data_collection_complete": "Pobieranie danych zakończone.",\n          "disconnected": "Rozłączono.",\n          "java_applet_error": "Aplety Java prawodpodobnie nie mogą być uruchomione w twojej przeglądarce. Jeżeli jesteś w stanie to naprawić to potem odśwież stronę, żeby użyć sensora.",\n          "java_applet_not_loading": "Sensor Aplet nie ładuje się. Jeżeli jesteś w stanie to naprawić to potem odśwież stronę, żeby użyć sensora.",\n          "unexpected_error": "Wystąpił nieoczekiwany błąd podczas próby połączenia z sensorem.",\n          "sensor_not_attached": "__sensor_name__ wydaje się być niedpołączony. Spróbuj podłączyć go ponownie i potem kliknij \\"$t(sensor.messages.try_again)\\".",\n          "sensor_or_device_unplugged": "__sensor_or_device_name__ został odłączony. Spróbuj podłączyć go ponownie i potem kliknij \\"$t(sensor.messages.try_again)\\".",\n          "try_again": "Spróbuj ponownie",\n          "cancel": "Anuluj"\n        },\n        "measurements": {\n          "sensor_reading": "Odczyt sensora",\n          "time": "Czas",\n          "distance": "Odległość",\n          "acceleration": "Przyspieszenie",\n          "altitude": "Wysokość",\n          "angle": "Kąt",\n          "CO2": "CO₂",\n          "CO2_concentration": "Stężenie CO₂",\n          "charge": "Ładunek",\n          "conductivity": "Przewodność właściwa",\n          "current": "Natężenie prądu",\n          "dissolved_oxygen": "Stężenie tlenu",\n          "flow_rate": "Strumień objętości",\n          "fluorescence_405_nm": "Fluorescencja 405 nm",\n          "fluorescence_500_nm": "Fluorescencja 500 nm",\n          "force": "Siła",\n          "intensity": "Natężenie",\n          "light_level": "Natężenie światła",\n          "light_intensity": "Intensywność światła",\n          "magnetic_field": "Pole magnetyczne",\n          "position": "Pozycja",\n          "potential": "Potencjał",\n          "pressure": "Ciśnienie",\n          "signal": "Sygnał",\n          "sound_level": "Natężenie dźwięku",\n          "speed": "Szybkość",\n          "temperature": "Temperatura",\n          "transmittance": "Transmitacja",\n          "turbidity": "Mętność",\n          "UV_intensity": "Natężenie UV",\n          "velocity": "Prędkość",\n          "volume": "Objętość",\n          "pH": "pH",\n          "acidity": "Kwasowość",\n          "O2_concentration": "Stężenie O₂"\n        },\n        "names": {\n          "sensor": "czujnik",\n          "no_sensor": "(brak czujnika)",\n          "light": "Światło",\n          "motion": "Ruch",\n          "accelerometer": "Akcelerometr",\n          "dissolved_oxygen": "Stężenie tlenu",\n          "pressure": "Ciśnienie",\n          "charge_sensor": "Czujnik ładunku",\n          "voltage": "Napięcie",\n          "pH": "pH",\n          "CO2_gas": "Czujnik CO₂",\n          "colorimeter": "Kolorymetr",\n          "conductivity": "Przewodność właściwa",\n          "current": "Natężenie prądu",\n          "temperature": "Temperatura",\n          "force": "Siła",\n          "anemometer": "Anemometr",\n          "hand_dynamometer": "Dynamometr",\n          "heart_rate": "Pulsometr",\n          "magnetic_field": "Pole magnetyczne",\n          "rotary_motion": "Ruch obrotowy",\n          "linear_position_sensor": "Czujnik położenia",\n          "sound_level": "Natężenie dźwięku",\n          "spectrophotometer": "Spektrofotometr",\n          "spirometer": "Spirometr",\n          "turbidity": "Mętność",\n          "UV_sensor": "Czujnik UV",\n          "drop_counter": "Licznik kropli",\n          "altitude": "Wysokość",\n          "goMotion": "GoMotion",\n          "goTemp": "GoIO czujnik temperatury",\n          "goLinkTemperature": "GoIO czujnik temperatury",\n          "goLinkLight": "GoIO czujnik światła",\n          "goLinkForce": "GoIO czujnik siły",\n          "goLinkPH": "GoIO czujnik pH",\n          "goLinkCO2": "GoIO czujnik CO₂",\n          "goLinkO2": "GoIO czujnik O₂",\n          "labQuestMotion": "LabQuest czujnik ruchu",\n          "labQuestTemperature": "LabQuest czujnik temperatury",\n          "labQuestLight": "LabQuest czujnik światła",\n          "labQuestForce": "LabQuest czujnik siły",\n          "labQuestPH": "LabQuest czujnik pH",\n          "labQuestCO2": "LabQuest czujnik CO₂",\n          "labQuestO2": "LabQuest czujnik O₂"\n        }\n      }\n    }\n  },\n  \n  "nb-NO": {\n    "translation": {\n      "banner": {\n        "about": "Om simuleringen",\n        "about_tooltip": "Bruksanvisning",\n        "share": "Del",\n        "share_tooltip": "Del med e-post, melding eller innbygging",\n        "lang_tooltip": "Velg språk",\n        "reload_tooltip": "Last simuleringen på nytt",\n        "help_tooltip": "Vis hjelpetekster",\n        "credits_tooltip": "Lær mer om Concord Consortium",\n        "fullscreen_tooltip": "Slå fullskjermvisning av/på",\n        "video_play_pause_tooltip": "Start og stopp simuleringen",\n        "video_reset_tooltip": "Tilbakestill simuleringen",\n        "video_step_back_tooltip": "Gå et steg bakover",\n        "video_step_forward_tooltip": "Gå et steg framover",\n        "text_start": "Start",\n        "text_start_tooltip": "Start simuleringen eller datainnsamlingen",\n        "text_stop": "Stopp",\n        "text_stop_tooltip": "Stopp simuleringen eller datainnsamlingen",\n        "text_reset": "Tilbakestill",\n        "text_reset_tooltip": "Tilbakestill simuleringen eller datainnsamlingen"\n      },\n      "dialog": {\n        "close_tooltip": "Lukk"\n      },\n      "about_dialog": {\n        "title": "Om: __interactive_title__"\n      },\n      "share_dialog": {\n        "title": "-Del: __interactive_title__",\n        "link": "lenke",\n        "paste_email_im": "Lim inn denne __link__ i en e-post eller melding.",\n        "paste_html": "Lim inn HTML for innbygging på et nettsted eller en blogg.",\n        "select_size": "Velg størrelse:",\n        "size_larger": "__val__% større",\n        "size_actual": "faktisk",\n        "size_smaller": "__val__% mindre"\n      },\n      "credits_dialog": {\n        "title": "Informasjon om: __interactive_title__",\n        "credits_text": "Denne simuleringen er laget av __CC_link__ med bruk av __Next_Gen_MW_link__ programvare, finanisert av en bevilgning fra __Google_link__.",\n        "shareable_ver": "simuleringen kan deles",\n        "find_shareable": "Du finner en __shareable_ver_link__ av denne simuleringen, sammen med dusinvis andre open-source simuleringer for vitenskap, matematikk og teknologi på __concord_org_link__."\n      },\n      "copyright": {\n        "copyright": "Copyright",\n        "all_rights_reserved": "Alle rettigheter reservert.",\n        "license": "Denne programvaren er lisensiert under __MIT_link__ lisens.",\n        "attribution": "Vær vennlig å referere til Concord Consortium og URLen __concord_org_link__."\n      },\n      "md2d": {\n        "heatbath_icon_tooltip": "Varmebad er på",\n        "ke_icon_tooltip": "Kinetisk energigradient",\n        "invalid_object_position_alert": "You can\'t drop the object there.",\n        "aminoacid_menu": {\n          "hydrophobic": "Hydrofob",\n          "hydrophilic": "Hydrofil",\n          "glycine": "Glysin",\n          "alanine": "Alanin",\n          "valine": "Valin",\n          "leucine": "Leucin",\n          "isoleucine": "Isoleucin",\n          "phenylalanine": "Fenylalanin",\n          "proline": "Prolin",\n          "tryptophan": "Tryptofan",\n          "methionine": "Metionin",\n          "cysteine": "Cystin",\n          "tyrosine": "Tyrosin",\n          "asparagine": "Aspargin",\n          "glutamine": "Glutamin",\n          "serine": "Serin",\n          "threonine": "Threonin",\n          "asparticacid": "Asparginsyre",\n          "glutamicacid": "Glutaminsyre",\n          "lysine": "Lysin",\n          "arginine": "Arginin",\n          "histidine": "Histidin"\n        },\n        "mutations_menu": {\n          "substitution_mutation": "Substitusjonsmutasjon",\n          "insertion_mutation": "Insersjonsmutasjon",\n          "deletion_mutation": "Delesjonsmutasjon",\n          "insert": "Sett inn"\n        }\n      },\n      "sensor": {\n        "select_sensor": "Velg sensor",\n        "select_sensor_type": "Velg sensortype...",\n        "reading": "Avlesning:",\n        "zero": "Null",\n        "zeroing": "Nullstilling...",\n        "loading_sensor": "Laster sensor...",\n        "choose_sensor_title": "Velg en sensor:",\n        "connect": "Koble til",\n        "address_labquest2": "adressen til LabQuest2",\n        "messages": {\n          "ready": "Klar til innsamling.",\n          "no_sensors": "Finner ingen sensorer.",\n          "no_devices": "Ingen enheter er tilkoblet.",\n          "not_connected": "Ikke tilkoblet.",\n          "connecting": "Kobler til...",\n          "connection_failed": "Tilkobling feilet.",\n          "connection_failed_alert": "Concord Consortium Sensor Connector er ikke installert eller kjører ikke. Vennligst __click_here_link__ for instruksjoner om hvordan du bruker Sensor Connector.",\n          "connection_failed_labquest2_alert": "Kunne ikke koble til LabQuest2. Vennligst sjekk at adressen er riktig, og at LabQuest2 kan nås fra denne datamaskinen",\n          "tare_labquest2_alert": "LabQuest2 må samle inn data i sanntid for å kunne nullstilles. Sett enten opp en ny måling, eller klikk målerikonet oppe til venstre.",\n          "click_here": "klikk her",\n          "connected": "Tilkoblet.",\n          "connected_start_labquest2": "Tilkoblet. Trykk start på LabQuest2 for å begynne.",\n          "starting_data_collection": "Starter datainnsamling...",\n          "error_starting_data_collection": "Feil ved start av datainnsamling.",\n          "error_starting_data_collection_alert": "Kunne ikke starte datainnsamling. Forsikre deg om at (fjernstart) er aktivert.",\n          "collecting_data": "Samler inn data.",\n          "collecting_data_stop_labquest2": "Samler inn data. Trykk stopp på LabQuest2 for å avslutte.",\n          "no_data": "Ingen data er tilgengelig.",\n          "no_data_alert": "Sensorkonnektoren ser ikke ut til å levere data fra den tilkoblede enheten",\n          "no_data_labquest2_alert": "LabQuest ser ikke ut til å rapportere data fra den tilkoblede enheten",\n          "canceling_data_collection": "Avbryter datainnsamling...",\n          "error_canceling_data_collection": "Feil ved avbrytelse av datainnsamling.",\n          "error_canceling_data_collection_alert": "Kunne ikke avbryte datainnsamling. Sjekk at (fjernstart) er aktivert",\n          "stopping_data_collection": "Stopper datainnsamling...",\n          "error_stopping_data_collection": "Feil ved stopp av datainnsamling.",\n          "error_stopping_data_collection_alert": "Kunne ikke stoppe datainnsamling. Sjekk at (fjernstart) er aktivert",\n          "data_collection_stopped": "Datainnsamling stoppet.",\n          "data_collection_complete": "Datainnsamling er fullført.",\n          "disconnected": "Koblet fra.",\n          "java_applet_error": "Det ser ut som javaappleter ikke kan kjøre i nettleseren. Hvis du kan rette på dette, last siden på nytt for å bruke sensoren",\n          "java_applet_not_loading": "Sensorappleten ser ikke ut til å virke. Hvis du kan rette på dette, kan du laste siden på nytt for å bruke sensoren",\n          "unexpected_error": "Det oppsto en uventet feil da sensoren ble tilkoblet.",\n          "sensor_not_attached": " __sensor_name__ ser ikke ut til å være tilkoblet. Prøv å koble til på nytt, og klikk på \\"$t(sensor.messages.try_again)\\".",\n          "sensor_or_device_unplugged": " __sensor_or_device_name__ ble frakoblet. Prøv å koble til på nytt, og klikk på \\"$t(sensor.messages.try_again)\\".",\n          "try_again": "Prøv igjen",\n          "cancel": "Avbryt"\n        },\n        "measurements": {\n          "sensor_reading": "Sensoravlesning",\n          "time": "Tid",\n          "distance": "Avstand",\n          "acceleration": "Akselerasjon",\n          "altitude": "Høyde",\n          "angle": "Vinkel",\n          "CO2": "CO₂",\n          "CO2_concentration": "CO₂-konsentrasjon",\n          "charge": "Ladning",\n          "conductivity": "Ledningsevne",\n          "current": "Strøm",\n          "dissolved_oxygen": "OO",\n          "flow_rate": "Gjennomstrømningsmengde",\n          "fluorescence_405_nm": "Fluorescens 405 nm",\n          "fluorescence_500_nm": "Fluorescens 500 nm",\n          "force": "Kraft",\n          "intensity": "Intensitet",\n          "light_level": "Lysnivå",\n          "light_intensity": "Lysintensitet",\n          "magnetic_field": "Magnetfelt",\n          "position": "Posisjon",\n          "potential": "Potensial",\n          "pressure": "Trykk",\n          "signal": "Signal",\n          "sound_level": "Lydnivå",\n          "speed": "Fart",\n          "temperature": "Temperatur",\n          "transmittance": "Transmittans",\n          "turbidity": "Turbiditet",\n          "UV_intensity": "UV-intensitet",\n          "velocity": "Hastighet",\n          "volume": "Volum",\n          "pH": "pH",\n          "acidity": "Surhet",\n          "O2_concentration": "O₂-konsentrasjon"\n        },\n        "names": {\n          "sensor": "sensor",\n          "no_sensor": "(ingen sensor)",\n          "light": "Lys",\n          "motion": "Bevegelse",\n          "accelerometer": "Akselerometer",\n          "dissolved_oxygen": "Oppløst oksygen",\n          "pressure": "Trykk",\n          "charge_sensor": "Ladningssensor",\n          "voltage": "Spenning",\n          "pH": "pH",\n          "CO2_gas": "CO₂-gass",\n          "colorimeter": "Kolorimeter",\n          "conductivity": "Ledningsevne",\n          "current": "Strøm",\n          "temperature": "Temperatur",\n          "force": "Kraft",\n          "anemometer": "Anemometer",\n          "hand_dynamometer": "Hånddynamometer",\n          "heart_rate": "Hjertefrekvens",\n          "magnetic_field": "Magnetfelt",\n          "rotary_motion": "Rotasjon",\n          "linear_position_sensor": "Sensor for lineær posisjon",\n          "sound_level": "Lydnivå",\n          "spectrophotometer": "Spektrofotometer",\n          "spirometer": "Spirometer",\n          "turbidity": "Turbiditet",\n          "UV_sensor": "UV-sensor",\n          "drop_counter": "Dråpeteller",\n          "altitude": "Høyde",\n          "goMotion": "GoMotion",\n          "goTemp": "GoIO temperatursensor",\n          "goLinkTemperature": "GoIO temperatursensor",\n          "goLinkLight": "GoIO lyssensor",\n          "goLinkForce": "GoIO kraftsensor",\n          "goLinkPH": "GoIO pH-sensor",\n          "goLinkCO2": "GoIO CO₂-sensor",\n          "goLinkO2": "GoIO CO₂-sensor",\n          "labQuestMotion": "LabQuest bevegelsessensor",\n          "labQuestTemperature": "LabQuest temperatursensor",\n          "labQuestLight": "LabQuest lyssensor",\n          "labQuestForce": "LabQuest kraftsensor",\n          "labQuestPH": "LabQuest pH-sensor",\n          "labQuestCO2": "LabQuest CO₂-sensor",\n          "labQuestO2": "LabQuest O₂-sensor"\n        }\n      }\n    }\n  },\n  \n  "nn-NO": {\n    "translation": {\n      "banner": {\n        "about": "Om simuleringa",\n        "about_tooltip": "Brukarrettleiing",\n        "share": "Del",\n        "share_tooltip": "Del med e-post, melding eller innbygging",\n        "lang_tooltip": "Vel språk",\n        "reload_tooltip": "Last simuleringa på nytt",\n        "help_tooltip": "Vis hjelpetekstar",\n        "credits_tooltip": "Lær meir om Concord Consortium",\n        "fullscreen_tooltip": "Slå fullskjermvising av/på",\n        "video_play_pause_tooltip": "Start og stopp simuleringa",\n        "video_reset_tooltip": "Tilbakestill simuleringa",\n        "video_step_back_tooltip": "Gå eit steg bakover",\n        "video_step_forward_tooltip": "Gå eit steg framover",\n        "text_start": "Start",\n        "text_start_tooltip": "Start simuleringa eller datainnsamlinga",\n        "text_stop": "Stopp",\n        "text_stop_tooltip": "Stopp simuleringa eller datainnsamlinga",\n        "text_reset": "Tilbakestill",\n        "text_reset_tooltip": "Tilbakestill simuleringa eller datainnsamlinga"\n      },\n      "dialog": {\n        "close_tooltip": "Lukk"\n      },\n      "about_dialog": {\n        "title": "Om: __interactive_title__"\n      },\n      "share_dialog": {\n        "title": "-Del: __interactive_title__",\n        "link": "lenke",\n        "paste_email_im": "Lim inn denne __link__ i ein e-post eller melding.",\n        "paste_html": "Lim inn HTML for innbygging på ein nettstad eller ein blogg.",\n        "select_size": "Vel storleik:",\n        "size_larger": "__val__% større",\n        "size_actual": "faktisk",\n        "size_smaller": "__val__% mindre"\n      },\n      "credits_dialog": {\n        "title": "Informasjon om: __interactive_title__",\n        "credits_text": "Denne simuleringa er laga av __CC_link__ med bruk av __Next_Gen_MW_link__ programvare, finanisert av ei løyving frå __Google_link__.",\n        "shareable_ver": "simuleringa kan delast",\n        "find_shareable": "Du finn ein __shareable_ver_link__ av denne simuleringa, saman med dusinvis andre open-source simuleringar for vitskap, matematikk og teknologi på __concord_org_link__."\n      },\n      "copyright": {\n        "copyright": "Copyright",\n        "all_rights_reserved": "Alle rettar reservert.",\n        "license": "Denne programvara er lisensiert under __MIT_link__ eller lisens.",\n        "attribution": "Vær venleg å referere til Concord Consortium og URLen __concord_org_link__."\n      },\n      "md2d": {\n        "heatbath_icon_tooltip": "Varmebad er på",\n        "ke_icon_tooltip": "Kinetisk energigradient",\n        "invalid_object_position_alert": "You can\'t drop the object there.",\n        "aminoacid_menu": {\n          "hydrophobic": "Hydrofob",\n          "hydrophilic": "Hydrofil",\n          "glycine": "Glysin",\n          "alanine": "Alanin",\n          "valine": "Valin",\n          "leucine": "Leucin",\n          "isoleucine": "Isoleucin",\n          "phenylalanine": "Fenylalanin",\n          "proline": "Prolin",\n          "tryptophan": "Tryptofan",\n          "methionine": "Metionin",\n          "cysteine": "Cystin",\n          "tyrosine": "Tyrosin",\n          "asparagine": "Aspargin",\n          "glutamine": "Glutamin",\n          "serine": "Serin",\n          "threonine": "Threonin",\n          "asparticacid": "Asparginsyre",\n          "glutamicacid": "Glutaminsyre",\n          "lysine": "Lysin",\n          "arginine": "Arginin",\n          "histidine": "Histidin"\n        },\n        "mutations_menu": {\n          "substitution_mutation": "Substitusjonsmutasjon",\n          "insertion_mutation": "Insersjonsmutasjon",\n          "deletion_mutation": "Delesjonsmutasjon",\n          "insert": "Sett inn"\n        }\n      },\n      "sensor": {\n        "select_sensor": "Vel sensor",\n        "select_sensor_type": "Vel sensortype...",\n        "reading": "Avlesing:",\n        "zero": "Null",\n        "zeroing": "Nullstilling...",\n        "loading_sensor": "Lastar sensor...",\n        "choose_sensor_title": "Vel en sensor:",\n        "connect": "Kople til",\n        "address_labquest2": "adressen til LabQuest2",\n        "messages": {\n          "ready": "Klar til innsamling.",\n          "no_sensors": "Finn ingen sensorer.",\n          "no_devices": "Inga eining er kopla til.",\n          "not_connected": "Ikkje tilkopla.",\n          "connecting": "Kopla til...",\n          "connection_failed": "Tilkopling feila.",\n          "connection_failed_alert": "Concord Consortium Sensor Connector er ikke installert eller kjører ikke. Vær venleg __click_here_link__ for, om naudsynt, å laste ned eit installasjonsprogram for sensortilkoplinga.",\n          "connection_failed_labquest2_alert": "Kunne ikkje kople til LabQuest2. Vær venleg, sjekk at adressen er rett, og at LabQuest2 kan nåast frå denne datamaskina",\n          "tare_labquest2_alert": "LabQuest2 må samle inn data i sann tid for å kunne nullstillast. Sett anten opp en ny måling, eller klikk målårikonet oppe til venstre.",\n          "click_here": "klikk her",\n          "connected": "Tilkopla.",\n          "connected_start_labquest2": "Tilkopla. Trykk start på LabQuest2 for å byrje.",\n          "starting_data_collection": "Startar datainnsamling...",\n          "error_starting_data_collection": "Feil ved start av datainnsamling.",\n          "error_starting_data_collection_alert": "Kunne ikkje starte datainnsamling. Forsikre deg om at (fjernstart) er aktivert.",\n          "collecting_data": "Samlar inn data.",\n          "collecting_data_stop_labquest2": "Samlar inn data. Trykk stopp på LabQuest2 for å avslutte.",\n          "no_data": "Ingen data er tilgengelege.",\n          "no_data_alert": "Sensorkonnektoren ser ikkje ut til å levere data frå den tilkopla eininga",\n          "no_data_labquest2_alert": "LabQuest ser ikkje ut til å rapportere data frå den tilkopla eininga",\n          "canceling_data_collection": "Avbryt datainnsamlinga...",\n          "error_canceling_data_collection": "Feil på avbrytinga av datainnsamlinga.",\n          "error_canceling_data_collection_alert": "Kunne ikkje avbryte datainnsamlinga. Sjekk at (fjernstart) er aktivert",\n          "stopping_data_collection": "Stopper datainnsamlinga...",\n          "error_stopping_data_collection": "Feil ved stopp av datainnsamlinga.",\n          "error_stopping_data_collection_alert": "Kunne ikkje stoppe datainnsamlinga. Sjekk at (fjernstart) er aktivert",\n          "data_collection_stopped": "Datainnsamlinga stoppa.",\n          "data_collection_complete": "Datainnsamlinga er fullført.",\n          "disconnected": "Kopla frå.",\n          "java_applet_error": "Det ser ut som javaappleter ikkje kan køyre i nettlesaren. Hvis du kan rette på dette, last inn sida på nytt for å bruke sensoren",\n          "java_applet_not_loading": "Sensorappleten ser ikkje ut til å virke. Hvis du kan rette på dette, kan du laste inn sida på nytt for å bruke sensoren",\n          "unexpected_error": "Det oppsto ein uventa feil då sensoren vart tilkopla.",\n          "sensor_not_attached": " __sensor_name__ ser ikkje ut til å vere tilkopla. Prøv å kople til på nytt, og klikk på \\"$t(sensor.messages.try_again)\\".",\n          "sensor_or_device_unplugged": " __sensor_or_device_name__ ble frakopla. Prøv å kople til på nytt, og klikk på \\"$t(sensor.messages.try_again)\\".",\n          "try_again": "Prøv igjen",\n          "cancel": "Avbryt"\n        },\n        "measurements": {\n          "sensor_reading": "Sensoravlesing",\n          "time": "Tid",\n          "distance": "Avstand",\n          "acceleration": "Akselerasjon",\n          "altitude": "Høgd",\n          "angle": "Vinkel",\n          "CO2": "CO₂",\n          "CO2_concentration": "CO₂-konsentrasjon",\n          "charge": "Ladning",\n          "conductivity": "Leiingsevne",\n          "current": "Strøm",\n          "dissolved_oxygen": "OO",\n          "flow_rate": "Gjennomstrømmingsmengd",\n          "fluorescence_405_nm": "Fluorescens 405 nm",\n          "fluorescence_500_nm": "Fluorescens 500 nm",\n          "force": "Kraft",\n          "intensity": "Intensitet",\n          "light_level": "Lysnivå",\n          "light_intensity": "Lysintensitet",\n          "magnetic_field": "Magnetfelt",\n          "position": "Posisjon",\n          "potential": "Potensial",\n          "pressure": "Trykk",\n          "signal": "Signal",\n          "sound_level": "Lydnivå",\n          "speed": "Fart",\n          "temperature": "Temperatur",\n          "transmittance": "Transmittans",\n          "turbidity": "Turbiditet",\n          "UV_intensity": "UV-intensitet",\n          "velocity": "Hastigheit",\n          "volume": "Volum",\n          "pH": "pH",\n          "acidity": "Surleik",\n          "O2_concentration": "O₂-konsentrasjon"\n        },\n        "names": {\n          "sensor": "sensor",\n          "no_sensor": "(ingen sensor)",\n          "light": "Lys",\n          "motion": "Rørsle",\n          "accelerometer": "Akselerometer",\n          "dissolved_oxygen": "Løyst oksygen",\n          "pressure": "Trykk",\n          "charge_sensor": "Ladingssensor",\n          "voltage": "Spenning",\n          "pH": "pH",\n          "CO2_gas": "CO₂-gass",\n          "colorimeter": "Kolorimeter",\n          "conductivity": "Leiingsevne",\n          "current": "Strøm",\n          "temperature": "Temperatur",\n          "force": "Kraft",\n          "anemometer": "Anemometer",\n          "hand_dynamometer": "Handdynamometer",\n          "heart_rate": "Hjertefrekvens",\n          "magnetic_field": "Magnetfelt",\n          "rotary_motion": "Rotasjon",\n          "linear_position_sensor": "Sensor for lineær posisjon",\n          "sound_level": "Lydnivå",\n          "spectrophotometer": "Spektrofotometer",\n          "spirometer": "Spirometer",\n          "turbidity": "Turbiditet",\n          "UV_sensor": "UV-sensor",\n          "drop_counter": "Dropeteljar",\n          "altitude": "Høgd",\n          "goMotion": "GoMotion",\n          "goTemp": "GoIO temperatursensor",\n          "goLinkTemperature": "GoIO temperatursensor",\n          "goLinkLight": "GoIO lyssensor",\n          "goLinkForce": "GoIO kraftsensor",\n          "goLinkPH": "GoIO pH-sensor",\n          "goLinkCO2": "GoIO CO₂-sensor",\n          "goLinkO2": "GoIO CO₂-sensor",\n          "labQuestMotion": "LabQuest rørslesensor",\n          "labQuestTemperature": "LabQuest temperatursensor",\n          "labQuestLight": "LabQuest lyssensor",\n          "labQuestForce": "LabQuest kraftsensor",\n          "labQuestPH": "LabQuest pH-sensor",\n          "labQuestCO2": "LabQuest CO₂-sensor",\n          "labQuestO2": "LabQuest O₂-sensor"\n        }\n      }\n    }\n  },\n  \n  "pt-BR": {\n    "translation": {\n      "banner": {\n        "about": "Sobre",\n        "about_tooltip": "Instruções",\n        "share": "Compartilhar",\n        "share_tooltip": "Compartilha por e-mail, mensagem ou inclui em site",\n        "lang_tooltip": "Seleciona a língua",\n        "reload_tooltip": "Recarrega o interativo",\n        "help_tooltip": "Mostra dicas",\n        "credits_tooltip": "Saber mais sobre The Concord Consortium",\n        "fullscreen_tooltip": "Alterna para tela cheia",\n        "video_play_pause_tooltip": "Inicia / pausa a simulação",\n        "video_reset_tooltip": "Reinicia a simulação",\n        "video_step_back_tooltip": "Passo atrás",\n        "video_step_forward_tooltip": "Passo adiante",\n        "text_start": "Iniciar",\n        "text_start_tooltip": "Inicia a simulação ou coleta de dados",\n        "text_stop": "Parar",\n        "text_stop_tooltip": "Para a simulação ou coleta de dados",\n        "text_reset": "Reiniciar",\n        "text_reset_tooltip": "Reinicia a simulação ou coleta de dados",\n        "text_new_run": "Nova corrida",\n        "text_new_run_tooltip": "Prepara nova corrida experimental",\n        "text_analyze_data": "Analisar dados",\n        "text_analyze_data_tooltip": "Envia dados experimentais para CODAP"\n      },\n      "dialog": {\n        "close_tooltip": "Fecha"\n      },\n      "about_dialog": {\n        "title": "Sobre: __interactive_title__"\n      },\n      "share_dialog": {\n        "title": "Compartilhar: __interactive_title__",\n        "link": "link",\n        "paste_email_im": "Cole este __link__ no email ou mensagem.",\n        "paste_html": "Cole o HTML para incluir em site ou blog.",\n        "select_size": "Selecione o tamanho:",\n        "size_larger": "__val__% maior",\n        "size_actual": "real",\n        "size_smaller": "__val__% menor"\n      },\n      "credits_dialog": {\n        "title": "Créditos: __interactive_title__",\n        "credits_text": "Este interativo foi criado pelo __CC_link__ usando nosso __Next_Gen_MW_link__ software, com o apoio financeiro do __Google_link__.",\n        "shareable_ver": "versão compartilhável",\n        "find_shareable": "Encontre uma __shareable_ver_link__ deste interativo e mais dezenas de outros interativos de código aberto para ciência, matemática e engenharia em __concord_org_link__."\n      },\n      "copyright": {\n        "copyright": "Copyright",\n        "all_rights_reserved": "Todos direitos reservados.",\n        "license": "O software é licenciado sob a licença __MIT_link__.",\n        "attribution": "Por favor, forneça a atribuição ao Concord Consortium and a URL __concord_org_link__."\n      },\n      "md2d": {\n        "heatbath_icon_tooltip": "Banho de calor ativo",\n        "ke_icon_tooltip": "Gradiente de energia cinética",\n        "invalid_object_position_alert": "You can\'t drop the object there.",\n        "aminoacid_menu": {\n          "hydrophobic": "Hidrofóbico",\n          "hydrophilic": "Hidrofílico",\n          "glycine": "Glicina",\n          "alanine": "Alanina",\n          "valine": "Valina",\n          "leucine": "Leucina",\n          "isoleucine": "Isoleucina",\n          "phenylalanine": "Phenilalanina",\n          "proline": "Prolina",\n          "tryptophan": "Triptofano",\n          "methionine": "Metionina",\n          "cysteine": "Cisteína",\n          "tyrosine": "Tirosina",\n          "asparagine": "Asparagina",\n          "glutamine": "Glutamina",\n          "serine": "Serina",\n          "threonine": "Treonina",\n          "asparticacid": "Ácido aspártico",\n          "glutamicacid": "Ácido glutâmico",\n          "lysine": "Lisina",\n          "arginine": "Arginina",\n          "histidine": "Histidina"\n        },\n        "mutations_menu": {\n          "substitution_mutation": "Mutação de substituição",\n          "insertion_mutation": "Mutação de inserção",\n          "deletion_mutation": "Mutação de deleção",\n          "insert": "Inserir"\n        }\n      },\n      "sensor": {\n        "select_sensor": "Selecione o sensor",\n        "select_sensor_type": "Selecione o tipo de sensor...",\n        "reading": "Leitura:",\n        "zero": "Zero",\n        "zeroing": "Zerando...",\n        "loading_sensor": "Carregando sensor...",\n        "choose_sensor_title": "Selecione o sensor:",\n        "connect": "Conectar",\n        "address_labquest2": "endereço do LabQuest2",\n        "messages": {\n          "ready": "Pronto para coletar.",\n          "ready_nocontrol": "Por favor pare o coletor de dados __controlling_client__ para coletar dados aqui.",\n          "ready_nocontrol_noname": "Por favor pare o outro coletor de dados ativo para coletar dados aqui.",\n          "no_sensors": "Nenhum sensor encontrado.",\n          "no_devices": "Nenhum dispositivo plugado.",\n          "not_connected": "Não contectado.",\n          "connecting": "Conectando...",\n          "connection_failed": "Conexão falhou.",\n          "connection_in_progress": "Conectando-se a seus sensores. Se uma mensagem surge sobre sensorconnector.concord.org, por favor, aceite -o",\n          "connection_failed_alert": "O Conector de Sensores do Concord Consortium não está instalado ou não está funcionando. Por favor __click_here_link__ obter instruções sobre a utilização do Conector de Sensores.",\n          "connection_failed_labquest2_alert": "Não foi possível conectar ao LabQuest2. Por favor verifique se o endereço está certo e se o LabQuest2 pode ser alcançado deste computador",\n          "tare_labquest2_alert": "O LabQuest2 precisa conectar dados ao vivo para zerar. Inicie uma nova corrida no LabQuest2 ou clique no ícone do medidor no alto à esquerda.",\n          "click_here": "clique aqui",\n          "connected": "Conectado.",\n          "connected_start_labquest2": "Conectado. Aperte iniciar no seu LabQuest2 to começar.",\n          "connected_start_sensorconnector": "Por favor pare o coletor de dados __controlling_client__ para coletar dados aqui.",\n          "connected_start_sensorconnector_noname": "Por favor pare o outro coletor de dados ativo para coletar dados aqui.",\n          "starting_data_collection": "Iniciando coleta de dados...",\n          "error_starting_data_collection": "Erro ao iniciar a coleta de dados.",\n          "error_starting_data_collection_alert": "Não foi possível iniciar a coleta de dados. Verifique se (remote starting) está habilitado",\n          "collecting_data": "Coletando dados.",\n          "collecting_data_stop_labquest2": "Coletando dados. Pressione parar no seu LabQuest2 para encerrar.",\n          "collecting_data_stop_sensorconnector": "Coletando dados.",\n          "no_data": "Não há dados disponíveis.",\n          "no_data_alert": "O Conector de Sensores parece não estar reportando dados ao dispositivo plugado",\n          "no_data_labquest2_alert": "The LabQuest parece não estar reportando dados ao dispositivo plugado",\n          "canceling_data_collection": "Cancelando coleta de dados...",\n          "error_canceling_data_collection": "Erro ao cancelar a coleta de dados.",\n          "error_canceling_data_collection_alert": "Não foi possível cancelar a coleta de dados. Verifique se (remote starting) está habilitado",\n          "stopping_data_collection": "Interrompendo a coleta de dados...",\n          "error_stopping_data_collection": "Erro ao interromper a coleta de dados.",\n          "error_stopping_data_collection_alert": "Não foi possível interromper a coleta de dados. Verifique se (remote starting) está habilitado",\n          "data_collection_stopped": "Coleta de dados interrompida.",\n          "data_collection_complete": "Coleta de dados completa.",\n          "disconnected": "Desconectado.",\n          "java_applet_error": "Parece que applets Java não podem rodar no seu navegador. Se você puder consertar isso, recarregue a página para usar o sensor.",\n          "java_applet_not_loading": "O applet do sensor parece não estar carregando. Se você puder consertar isso, recarregue a página para usar o sensor.",\n          "unexpected_error": "Houve um erro inesperado ao conectar com o sensor.",\n          "sensor_not_attached": "O __sensor_name__ parece não estar conectado. Tente reconectá-lo, e então clique \\"$t(sensor.messages.try_again)\\".",\n          "sensor_or_device_unplugged": "O __sensor_or_device_name__ estava deplugado. Tente reconectá-lo, e então clique \\"$t(sensor.messages.try_again)\\".",\n          "try_again": "Tentar de novo",\n          "cancel": "Cancelar"\n        },\n        "measurements": {\n          "sensor_reading": "Leitura do sensor",\n          "time": "Tempo",\n          "distance": "Distância",\n          "acceleration": "Aceleração",\n          "altitude": "Altitude",\n          "angle": "Ângulo",\n          "CO2": "CO₂",\n          "CO2_concentration": "Concentração de CO₂",\n          "charge": "Carga",\n          "conductivity": "Condutividade",\n          "current": "Corrente",\n          "dissolved_oxygen": "OD",\n          "flow_rate": "Taxa de fluxo",\n          "fluorescence_405_nm": "Fluorescência a 405 nm",\n          "fluorescence_500_nm": "Fluorescência a 500 nm",\n          "force": "Força",\n          "intensity": "Intensidade",\n          "light_level": "Nível de luz",\n          "light_intensity": "Intensidade de luz",\n          "magnetic_field": "Campo magnético",\n          "position": "Posição",\n          "potential": "Potencial",\n          "pressure": "Pressão",\n          "signal": "Sinal",\n          "sound_level": "Nível de som",\n          "speed": "Velocidade",\n          "temperature": "Temperatura",\n          "transmittance": "Transmitância",\n          "turbidity": "Turbidez",\n          "UV_intensity": "Intensidade UV",\n          "velocity": "Velocidade",\n          "volume": "Volume",\n          "pH": "pH",\n          "acidity": "Acidez",\n          "O2_concentration": "Concentração de O₂"\n        },\n        "names": {\n          "sensor": "sensor",\n          "no_sensor": "(sem sensor)",\n          "light": "Luz",\n          "motion": "Movimento",\n          "accelerometer": "Acelerômetro",\n          "dissolved_oxygen": "Oxigênio Dissolvido",\n          "pressure": "Pressão",\n          "charge_sensor": "Sensor de Carga",\n          "voltage": "Voltagem",\n          "pH": "pH",\n          "CO2_gas": "Gas CO₂",\n          "colorimeter": "Colorímetro",\n          "conductivity": "Condutividade",\n          "current": "Corrente",\n          "temperature": "Temperatura",\n          "force": "Força",\n          "anemometer": "Anemômetro",\n          "hand_dynamometer": "Dinamômetro de Mão",\n          "heart_rate": "Frequência Cardíaca",\n          "magnetic_field": "Campo Magnético",\n          "rotary_motion": "Movimento de Rotação",\n          "linear_position_sensor": "Sensor de Posição Linear",\n          "sound_level": "Nível de Som",\n          "spectrophotometer": "Espectrofotômetro",\n          "spirometer": "Espirômetro",\n          "turbidity": "Turbidez",\n          "UV_sensor": "Sensor UV",\n          "drop_counter": "Contador de Gotas",\n          "altitude": "Altitude",\n          "goMotion": "GoMotion",\n          "goTemp": "Sensor de Temperatura GoIO",\n          "goLinkTemperature": "Sensor de Temperatura GoIO",\n          "goLinkLight": "Sensor de Luz GoIO",\n          "goLinkForce": "Sensor de Força GoIO",\n          "goLinkPH": "Sensor de pH GoIO",\n          "goLinkCO2": "Sensor de  CO₂ GoIO",\n          "goLinkO2": "Sensor de  O₂ GoIO",\n          "labQuestMotion": "Sensor de Movimento LabQuest",\n          "labQuestTemperature": "Sensor de Temperatura LabQuest",\n          "labQuestLight": "Sensor de Luz LabQuest",\n          "labQuestForce": "Sensor de Força LabQuest",\n          "labQuestPH": "Sensor de pH LabQuest",\n          "labQuestCO2": "Sensor de CO₂ LabQuest",\n          "labQuestO2": "Sensor de O₂ LabQuest"\n        }\n      }\n    }\n  },\n  \n  "cs-CZ": {\n    "translation": {\n      "banner": {\n        "about": "O simulaci",\n        "about_tooltip": "Pokyny",\n        "share": "Sdílet",\n        "share_tooltip": "Sdílet pomocí e-mailu, IM nebo vložení do webové stránky",\n        "lang_tooltip": "Vybrat jazyk",\n        "reload_tooltip": "Opakovat simulaci",\n        "help_tooltip": "Zobrazit nápovědu",\n        "credits_tooltip": "Dozvědět se více o The Concord Consortium",\n        "fullscreen_tooltip": "Režim celé obrazovky",\n        "video_play_pause_tooltip": "Start / pauza simulace",\n        "video_reset_tooltip": "Obnova simulace",\n        "video_step_back_tooltip": "Krok zpět",\n        "video_step_forward_tooltip": "Krok vpřed",\n        "text_start": "Start",\n        "text_start_tooltip": "Start simulace nebo sběru dat",\n        "text_stop": "Stop",\n        "text_stop_tooltip": "Zastavit simulaci nebo sběr dat",\n        "text_reset": "Obnovit",\n        "text_reset_tooltip": "Obnovit simulaci nebo sběr dat",\n        "text_new_run": "Nový pokus",\n        "text_new_run_tooltip": "Nastavení nového pokusu",\n        "text_analyze_data": "Analyzovat data",\n        "text_analyze_data_tooltip": "Poslat data z experimentu do CODAP"\n      },\n      "dialog": {\n        "close_tooltip": "Zavřít"\n      },\n      "about_dialog": {\n        "title": "O simulaci: __interactive_title__"\n      },\n      "share_dialog": {\n        "title": "Sdílet: __interactive_title__",\n        "link": "odkaz",\n        "paste_email_im": "Vložit __link__ do e-mailu nebo IM.",\n        "paste_html": "HTML kód pro vložení do webové stránky nebo blogu",\n        "select_size": "Vybrat velikost:",\n        "size_larger": "__val__% vetší",\n        "size_actual": "současná",\n        "size_smaller": "__val__% menší"\n      },\n      "credits_dialog": {\n        "title": "Credits: __interactive_title__",\n        "credits_text": "Tato simulace byla vytvořena pomocí __CC_link__ využívající našeho __Next_Gen_MW_link__ softwaru. Práce byla financována z grantu __Google_link__.",\n        "shareable_ver": "Verze pro sdílení",\n        "find_shareable": "__shareable_ver_link__ s dalšími simulacemi z přírodních věd, matematiky a strojírenství je možné najít na __concord_org_link__."\n      },\n      "copyright": {\n        "copyright": "Copyright",\n        "all_rights_reserved": "Všechna práva vyhrazena.",\n        "license": "Software je licencován pod __MIT_link__.",\n        "attribution": "Prosím, zajistěte práva Concord Consortium a URL __concord_org_link__."\n      },\n      "md2d": {\n        "heatbath_icon_tooltip": "Vodní lázeň",\n        "ke_icon_tooltip": "Gradient kinetické energie",\n        "invalid_object_position_alert": "You can\'t drop the object there.",\n        "aminoacid_menu": {\n          "hydrophobic": "Hydrofobní",\n          "hydrophilic": "Hydrofilní",\n          "glycine": "Glycin",\n          "alanine": "Alanin",\n          "valine": "Valin",\n          "leucine": "Leucin",\n          "isoleucine": "Isoleucin",\n          "phenylalanine": "Fenylalanin",\n          "proline": "Prolin",\n          "tryptophan": "Tryptofan",\n          "methionine": "Methionin",\n          "cysteine": "Cystein",\n          "tyrosine": "Tyrosin",\n          "asparagine": "Asparagin",\n          "glutamine": "Glutamin",\n          "serine": "Serin",\n          "threonine": "Threonin",\n          "asparticacid": "Kyselina asparagová",\n          "glutamicacid": "Kyselina glutamová",\n          "lysine": "Lysin",\n          "arginine": "Arginin",\n          "histidine": "Histidin"\n        },\n        "mutations_menu": {\n          "substitution_mutation": "Substituční mutace",\n          "insertion_mutation": "Inzerce",\n          "deletion_mutation": "Delece",\n          "insert": "Vložení"\n        }\n      },\n      "sensor": {\n        "select_sensor": "Vybrat čidlo",\n        "select_sensor_type": "Vybrat druh čidla...",\n        "reading": "Hodnota:",\n        "zero": "Vynulovat",\n        "zeroing": "Nulování...",\n        "loading_sensor": "Nahrávání čidla...",\n        "choose_sensor_title": "Vybrat čidlo:",\n        "connect": "Připojeno",\n        "address_labquest2": "adresa LabQuest2",\n        "messages": {\n          "ready": "Připraven ke sběr dat.",\n          "ready_nocontrol": "Prosím, zastavte __controlling_client__ sběr dat, aby bylo možné sbírat data zde.",\n          "ready_nocontrol_noname": "Prosím, zastavte ostatní sběry dat, aby bylo možné sbírat data zde.",\n          "no_sensors": "Čidlo nenalezeno.",\n          "no_devices": "Není připojeno žádné zařízení.",\n          "not_connected": "Nepřipojeno.",\n          "connecting": "Připojování...",\n          "connection_in_progress": "Připojování čidel. Pokud se objeví zpráva o sensorconnector.concord.org, potvrďte ji, prosím.",\n          "connection_failed": "Připojení selhalo. __retry_link__",\n          "connection_failed_retry_link_text": "Zkusit znovu",\n          "connection_failed_alert": "Concord Consortium Sensor Connector není naistalován nebo spuštěn. Prosím, pro další instrukce k používání Sensor Connector __click_here_link__ .",\n          "connection_failed_labquest2_alert": "Nepodařilo se spojit s LabQuest2. Prosím, ověřte zda je adresa správná a jestli je možné se s LabQuest2 spojit z toho počítače.",\n          "tare_labquest2_alert": "Pro vynulování potřebuje LabQuest2 sbírat aktuální data. Buď nastavte nový pokus v LabQuest2, nebo klepněte na ikonu měření v levém horním rohu.",\n          "click_here": "Klepněte zde",\n          "connected": "Připojeno.",\n          "connected_start_labquest2": "Připojeno. Pro zahájení pokusu klepněte na start v LabQuest2.",\n          "connected_start_sensorconnector": "Prosím, zastavte __controlling_client__ sběr dat, aby bylo možné sbírat data zde.",\n          "starting_data_collection": "Začíná sběr dat...",\n          "error_starting_data_collection": "Chyba při zahájení sběru dat.",\n          "error_starting_data_collection_alert": "Nebylo možné zahájit sběr dat. Ujistěte se, že (remote starting) je povolený.",\n          "collecting_data": "Sbírám data.",\n          "collecting_data_stop_labquest2": "Sbírám data. Klikněte na stop v LabQuest2, aby se sběr ukončil.",\n          "collecting_data_stop_sensorconnector": "Sběr dat.",\n          "no_data": "Data nejsou k dispozici.",\n          "no_data_alert": "Sensor Connector nezaznamenává data ze zapojeného zařízení.",\n          "no_data_labquest2_alert": "LabQuest nezaznamenává data ze zapojeného zařízení.",\n          "canceling_data_collection": "Rušení sběru dat...",\n          "error_canceling_data_collection": "Chyba při rušení sběru dat.",\n          "error_canceling_data_collection_alert": "Není možné zrušit sběr dat. Ujistěte se, že (remote starting) je povolený.",\n          "stopping_data_collection": "Zastavování sběru dat...",\n          "error_stopping_data_collection": "Chyba při zastavování sběru dat.",\n          "error_stopping_data_collection_alert": "Není možné zastavit sběr dat. Ujistěte se, že (remote starting) je povolený.",\n          "data_collection_stopped": "Sběr dat zastaven.",\n          "data_collection_complete": "Sběr dat dokončen.",\n          "disconnected": "Odpojeno.",\n          "java_applet_error": "Java aplety nemohou být spuštěny v prohlížeči. Po opravě znovu načtěte stránku, aby bylo možné použít sezor.",\n          "java_applet_not_loading": "čidlo se nenačítá. Po opravě znovu načtěte stránku, aby bylo možné použít sezor.",\n          "unexpected_error": "Nastala neočekáváná chyba při připojování čidla.",\n          "sensor_not_attached": "__sensor_name__ není připojený. Zkuste ho připojit znovu a poté klikněte na \\"$t(sensor.messages.try_again)\\".",\n          "sensor_or_device_unplugged": " __sensor_or_device_name__ byl odpojen. Zkuste ho připojit znovu a poté klepněte na \\"$t(sensor.messages.try_again)\\".",\n          "try_again": "Zkusit znovu",\n          "cancel": "Zrušit"\n        },\n        "measurements": {\n          "sensor_reading": "Hodnota čidla",\n          "time": "Čas",\n          "distance": "Vzdálenost",\n          "acceleration": "Zrychlení",\n          "altitude": "Výška",\n          "angle": "Úhel",\n          "CO2": "CO2",\n          "CO2_concentration": "Koncentrace CO2",\n          "charge": "Náboj",\n          "conductivity": "Vodivost",\n          "current": "Proud",\n          "dissolved_oxygen": "DO - rozpuštěný kyslík",\n          "flow_rate": "Objemový průtok",\n          "fluorescence_405_nm": "Fluorescence 405 nm",\n          "fluorescence_500_nm": "Fluorescence 500 nm",\n          "force": "Síla",\n          "intensity": "Intenzita",\n          "light_level": "Množství světla",\n          "light_intensity": "Intenzita osvětlení",\n          "magnetic_field": "Magnetické pole",\n          "position": "Pozice",\n          "potential": "Potenciál",\n          "pressure": "Tlak",\n          "signal": "Signál",\n          "sound_level": "Hlasitost",\n          "speed": "Rychlost",\n          "temperature": "Teplota",\n          "transmittance": "Transmitance",\n          "turbidity": "Turbidita (zákal)",\n          "UV_intensity": "Intenzita UV záření",\n          "velocity": "Rychlost",\n          "volume": "Objem",\n          "pH": "pH",\n          "acidity": "Kyselost",\n          "O2_concentration": "Koncentrace O2"\n        },\n        "names": {\n          "sensor": "čidlo",\n          "no_sensor": "(žádné čidlo)",\n          "light": "Světlo",\n          "motion": "Pohyb",\n          "accelerometer": "Akcelerometer (čidlo zrychlení)",\n          "dissolved_oxygen": "Rozpuštěný kyslík",\n          "pressure": "Tlak",\n          "charge_sensor": "Elektroskop (čidlo náboje)",\n          "voltage": "Elektrické napětí",\n          "pH": "pH",\n          "CO2_gas": "CO2",\n          "colorimeter": "Kolorimetr",\n          "conductivity": "Vodivost",\n          "current": "Elektrický proud",\n          "temperature": "Teplota",\n          "force": "Síla",\n          "anemometer": "Anemometr",\n          "hand_dynamometer": "Ruční siloměr",\n          "heart_rate": "Srdeční tep",\n          "magnetic_field": "Magnetické pole",\n          "rotary_motion": "Rotační pohyb",\n          "linear_position_sensor": "Lineární poloha",\n          "sound_level": "Hlasitost",\n          "spectrophotometer": "Spektrofotometr",\n          "spirometer": "Spirometr",\n          "turbidity": "Turbidita (zákal)",\n          "UV_sensor": "Čidlo UV záření",\n          "drop_counter": "Čítač kapek",\n          "altitude": "Výška",\n          "goMotion": "GoMotion",\n          "goTemp": "GoIO teplotní čidlo",\n          "goLinkTemperature": "GoIO teplotní čidlo",\n          "goLinkLight": "GoIO světelné čidlo",\n          "goLinkForce": "GoIO čidlo pro měření síly",\n          "goLinkPH": "GoIO čidlo pH",\n          "goLinkCO2": "GoIO čidlo pro měžení CO2",\n          "goLinkO2": "GoIO čidlo pro měření O2",\n          "labQuestMotion": "LabQuest pohybové čidlo",\n          "labQuestTemperature": "LabQuest teplotní čidlo",\n          "labQuestLight": "LabQuest světelné čidlo",\n          "labQuestForce": "LabQuest čidlo pro měření síly",\n          "labQuestPH": "LabQuest čidlo pH",\n          "labQuestCO2": "LabQuest čidlo pro měření CO2",\n          "labQuestO2": "LabQuest čidlo pro měření O2"\n        }\n      }\n    }\n  },\n  \n  "es": {\n    "translation": {\n      "banner": {\n        "about": "Acerca de",\n        "about_tooltip": "Instrucciones",\n        "share": "Compartir",\n        "share_tooltip": "Compartir a través de e-mail, MI o embeber en sitio web",\n        "lang_tooltip": "Elegir idioma",\n        "reload_tooltip": "Recargar el interactivo",\n        "help_tooltip": "Mostrar ayuda",\n        "credits_tooltip": "Saber más sobre The Concord Consortium",\n        "fullscreen_tooltip": "Cambiar a pantalla completa",\n        "video_play_pause_tooltip": "Iniciar / pausar la simulación",\n        "video_reset_tooltip": "Resetear la simulación",\n        "video_step_back_tooltip": "Un paso atrás",\n        "video_step_forward_tooltip": "Un paso adelante",\n        "text_start": "Iniciar",\n        "text_start_tooltip": "Iniciar la simulación o recolección de datos",\n        "text_stop": "Detener",\n        "text_stop_tooltip": "Detener la simulación o recolección de datos",\n        "text_reset": "Resetear",\n        "text_reset_tooltip": "Resetear la simulación o recolección de datos"\n      },\n      "dialog": {\n        "close_tooltip": "Cerrar"\n      },\n      "about_dialog": {\n        "title": "Acerca de: __interactive_title__"\n      },\n      "share_dialog": {\n        "title": "Compartir: __interactive_title__",\n        "link": "enlace",\n        "paste_email_im": "Pegar este __link__ en email o MI",\n        "paste_html": "Pegar HTML para embeber en sitio web o blog.",\n        "select_size": "Elegir tamaño:",\n        "size_larger": "__val__% más grande",\n        "size_actual": "actual",\n        "size_smaller": "__val__% más pequeño"\n      },\n      "credits_dialog": {\n        "title": "Créditos: __interactive_title__",\n        "credits_text": "Este interactivo fue creado por the __CC_link__ usando nuestro software __Next_Gen_MW_link__, con fondos provenientes de un gran de __Google_link__.",\n        "shareable_ver": "versión para compartir",\n        "find_shareable": "Buscar un __shareable_ver_link__ de este interactivo junto a docenas de otros interactivos de código abierto para ciencias, matemática e ingeniería en __concord_org_link__."\n      },\n      "copyright": {\n        "copyright": "Copyright",\n        "all_rights_reserved": "Todos los derechos reservados.",\n        "license": "Este software está licenciado bajo licencia de __MIT_link__.",\n        "attribution": "Por favor dar atribución a The Concord Consortium y la URL __concord_org_link__."\n      }\n    }\n  },\n  \n  "ru": {\n    "translation": {\n      "banner": {\n        "about": "Об интерактиве",\n        "about_tooltip": "Инструкция",\n        "share": "Опубликовать ссылку",\n        "share_tooltip": "Поделиться данными в e-mail, IM или вставить их на страницу в web-страницу",\n        "lang_tooltip": "Выбрать язык",\n        "reload_tooltip": "Перезагрузить интерактив",\n        "help_tooltip": "Показать подсказку",\n        "credits_tooltip": "Подробнее о Конкорд Консорциуме",\n        "fullscreen_tooltip": "Переключить на полноэкранную версию",\n        "video_play_pause_tooltip": "Старт/пауза симуляции",\n        "video_reset_tooltip": "Перезагрузить симуляцию",\n        "video_step_back_tooltip": "Шаг назад",\n        "video_step_forward_tooltip": "Шаг вперед",\n        "text_start": "Старт",\n        "text_start_tooltip": "Запустить симуляции или сбор данных",\n        "text_stop": "Стоп",\n        "text_stop_tooltip": "Остановить симуляцию или сбор данных ",\n        "text_reset": "Перегрузить",\n        "text_reset_tooltip": " Перегрузить симуляцию или сбор данных",\n        "text_new_run": "Повторный запуск",\n        "text_new_run_tooltip": "Повторить запуск нового эксперимента",\n        "text_analyze_data": "Анализ данных",\n        "text_analyze_data_tooltip": "Послать данные опыта на CODAP"\n      },\n      "dialog": {\n        "close_tooltip": "Закрыть"\n      },\n      "about_dialog": {\n        "title": "Об интерактиве: __interactive_title__"\n      },\n      "share_dialog": {\n        "title": "Поделиться: __interactive_title__",\n        "link": " линк ",\n        "paste_email_im": "Вставить этот __link__ в e-mail или IM.",\n        "paste_html": " Скопировать HTML для вставки в web-site или блог.",\n        "select_size": "Выбрать размер:",\n        "size_larger": "__val__% больше",\n        "size_actual": "actual",\n        "size_smaller": "__val__% меньше"\n      },\n      "credits_dialog": {\n        "title": "Авторство: __interactive_title__",\n        "credits_text": "Данные интерактивные  учебные продукты были созданы __CC_link__ с использованием нашего __Next_Gen_MW_link__ программного продукта, при финансовой поддержке  за счет гранта от __Google_link__.",\n        "shareable_ver": "версия для обмена",\n        "find_shareable": "Найти __shareable_ver_link__ коллекцию интерактивных учебных продуктов наряду с десятками  других открытых программных продуктов по естественным наукам, математике и инжинирингу в материалах __concord_org_link__."\n      },\n      "copyright": {\n        "copyright": "Авторские права",\n        "all_rights_reserved": "Все права защищены.",\n        "license": "Лицензия на данный программный продукт предоставляется в соответствии с __MIT_link__ лицензией.",\n        "attribution": "Просьба при использовании данного продукта ссылаться на Конкорд Консорциум URL __concord_org_link__."\n      },\n      "md2d": {\n        "heatbath_icon_tooltip": "Тепловая баня активна",\n        "ke_icon_tooltip": "Градиент кинетической энергии",\n        "invalid_object_position_alert": "Нельзя сбросить объект здесь.",\n        "aminoacid_menu": {\n          "hydrophobic": "Гидрофобный",\n          "hydrophilic": "Гидрофильный",\n          "glycine": "Глицин",\n          "alanine": "Аланин",\n          "valine": "Валин",\n          "leucine": "Лейцин",\n          "isoleucine": "Изолейцин",\n          "phenylalanine": "Фенилаланин",\n          "proline": "Пролин",\n          "tryptophan": "Триптофан",\n          "methionine": "Метионин",\n          "cysteine": "Цистеин",\n          "tyrosine": "Тирозин",\n          "asparagine": "Аспарагин",\n          "glutamine": "Глутамин",\n          "serine": "Серин",\n          "threonine": "Треонин",\n          "asparticacid": "Аспартат",\n          "glutamicacid": "Глутамат",\n          "lysine": "Лизин",\n          "arginine": "Аргинин",\n          "histidine": "Гистидин"\n        },\n        "mutations_menu": {\n          "substitution_mutation": "Мутация: Замена нуклеотида",\n          "insertion_mutation": "Мутация: Вставка нуклеотида",\n          "deletion_mutation": " Мутация: Удаление нуклеотида ",\n          "insert": "Вставить"\n        }\n      },\n      "sensor": {\n        "select_sensor": "Выбрать датчик",\n        "select_sensor_type": "Выбрать тип датчика…",\n        "reading": "Съем данных:",\n        "zero": "Ноль",\n        "zeroing": "Выбор ноля...",\n        "loading_sensor": "Загрузка датчика...",\n        "choose_sensor_title": "Выбор датчика:",\n        "connect": "Соединить",\n        "address_labquest2": "адрес LabQuest2",\n        "messages": {\n          "ready": "Готов к сбору данных.",\n          "ready_nocontrol": "Пожалуйста остановите __controlling_client__ сборщик данных будет собирать данные здесь.",\n          "ready_nocontrol_noname": "Пожалуйста остановите все остальные активные сборщики данных, чтобы собрать данные здесь.",\n          "no_sensors": "Ни один датчик не найден.",\n          "no_devices": "Ни одно устройство не подключено.",\n          "not_connected": "Нет соединения.",\n          "connecting": "Идет подсоединение...",\n          "connection_in_progress": " Идет подсоединение к вашему датчику. Если придет сообщение от sensorconnector.concord.org, пожалуйста примите его.",\n          "connection_failed": "Подсоединения не произошло. __retry_link__",\n          " Подсоединение_failed_retry_link_text": "Повторить попытку",\n          "подсоединения _failed_внимание": "Программа для подсоединения датчиков Concord Consortium Sensor Connector либо не инсталлирована, либо не подключена. Пожалуйста __click_here_link__ для получения инструкции по использованию программы Sensor Connector.",\n          "connection_failed_labquest2_alert": "Не произошло подсоединение к LabQuest2. Пожалуйста убедитесь, в правильности адреса и в том, что LabQuest2 доступен на данном компьютере",\n          "tare_labquest2_alert": "LabQuest2 должен начать сбор данных, чтобы выставить значение ноля. Запустите новое измерение на LabQuest2 или нажмите на иконку измерительного устройства в левом верхнем углу экрана.",\n          "click_here": "Нажать здесь",\n          "connected": "Подсоединение произошло.",\n          "connected_start_labquest2": " Подсоединение произошло. Чтобы начать работу, нажмите кнопку Старт на вашем LabQuest2.",\n          "connected_start_sensorconnector": "Пожалуйста остановите __controlling_client__ сборщик данных чтобы собрать данные здесь.",\n          "connected_start_sensorconnector_noname": "Пожалуйста остановите  другие сборщики данных чтобы собрать данные здесь.",\n          "starting_data_collection": "Начать сбор данных...",\n          "ошибка_starting_data_collection": "Ошибка при запуске сбора данных.",\n          "error_starting_data_collection_alert": " Не запускается сбор данных. Убедитесь в том, что (удаленный старт) разрешен ",\n          "collecting_data": "Идет сбор данных.",\n          "collecting_data_stop_labquest2": " Идет сбор данных. Чтобы его завершит, нажмите кнопку Стоп на LabQuest2.",\n          "collecting_data_stop_sensorconnector": " Идет сбор данных.",\n          "no_data": "Данные не доступны.",\n          "no_data_alert": "Похоже, что The Sensor Connector не передает данные для подключенных устройств",\n          "no_data_labquest2_alert": " Похоже, что LabQuest не передает данные для подключенных устройств",\n          "canceling_data_collection": "Отмена сбора данных...",\n          "error_canceling_data_collection": "Ошибка при отмене сбора данных.",\n          "error_canceling_data_collection_alert": "Не получается отменить сбор данных. Убедитесь в том, что (удаленный старт) разрешен",\n          "stopping_data_collection": "Происходит остановка сбора данных...",\n          "error_stopping_data_collection": " Ошибка при остановке сбора данных.",\n          "error_stopping_data_collection_alert": "Не удалось остановить сбор данных. Убедитесь в том, что (удаленный старт) разрешен ",\n          "data_collection_stopped": "Сбор данных остановлен.",\n          "data_collection_complete": " Сбор данных завершен.",\n          "disconnected": "Произошло отсоединение.",\n          "java_applet_error": "Похоже на то, что Java апплеты не поддерживаются вашим браузером. Попытайтесь решить эту проблему, а затем перезагрузите страницу для того, чтобы использовать датчики",\n          "java_applet_not_loading": " Похоже на то, что апплеты датчиков не загружаются. Попытайтесь решить эту проблему, а затем перезагрузите страницу для того, чтобы использовать датчики",\n          "unexpected_error": "Произошла непредвиденная ошибка при подсоединении к датчику.",\n          "sensor_not_attached": "Похоже, что __sensor_name__ не прикрепиля. Пожалуйста повторите попытку и затем кликните на \\"$t(sensor.messages.try_again)\\".",\n          "датчик_or_device_не подключен": "The __sensor_or_device_name__ был отключен. Пожалуйста подключите его и затем кликните \\"$t(sensor.messages.try_again)\\".",\n          "try_again": "Повторить попытку",\n          "cancel": "Отменить"\n        },\n        "measurements": {\n          "sensor_reading": "Идет считывание датчика",\n          "time": "Время",\n          "distance": "Расстояние",\n          "acceleration": "Ускорение",\n          "altitude": "Высота над уровнем моря",\n          "angle": "Угол",\n          "CO2": "CO₂",\n          "CO2_concentration": "CO₂ Концентрация",\n          "charge": "Заряд",\n          "conductivity": "Проводимость",\n          "current": "Ток",\n          "dissolved_oxygen": "Растворенный кислород",\n          "flow_rate": "Скорость потока",\n          "fluorescence_405_nm": "Флюоресценция 405 nm",\n          "fluorescence_500_nm": "Флюоресценция 500 nm",\n          "force": "Сила",\n          "intensity": "Интенсивность",\n          "light_level": "Уровень освещенности",\n          "light_intensity": " Интенсивность освещенности ",\n          "magnetic_field": "Магнитное поле",\n          "position": "Расположение",\n          "potential": "Потенциал",\n          "pressure": "Давление",\n          "signal": "Сигнал",\n          "sound_level": "Уровень шума",\n          "speed": "Скорость",\n          "temperature": "Температура",\n          "transmittance": "Пропускание",\n          "turbidity": "Мутность",\n          "UV_intensity": "Интенсивность УФ",\n          "velocity": "Вектор скорости",\n          "volume": "Объем",\n          "pH": "рН",\n          "acidity": "Кислотность",\n          "O2_concentration": " Концентрация O₂"\n        },\n        "names": {\n          "sensor": "датчик",\n          "no_sensor": "(нет датчика)",\n          "light": "Освещенность",\n          "motion": "Перемещение",\n          "accelerometer": "Измеритель ускорения",\n          "dissolved_oxygen": "Растворенный кислород",\n          "pressure": "Давление",\n          "charge_sensor": "Сменить датчик",\n          "voltage": "Напряжение",\n          "pH": "рН",\n          "CO2_gas": "CO₂ газ",\n          "colorimeter": "Колориметр",\n          "conductivity": "Проводимость",\n          "current": "Ток",\n          "temperature": "Температура",\n          "force": "Сила",\n          "anemometer": "Анемометр",\n          "hand_dynamometer": "Ручной динамометр",\n          "heart_rate": "Частота сердечных сокращений",\n          "magnetic_field": "Магнитное поле",\n          "rotary_motion": "Угловое перемещение",\n          "linear_position_sensor": "Датчик прямолинейного перемещения",\n          "sound_level": "Уровень шума",\n          "spectrophotometer": "Спектрофотометр",\n          "spirometer": "Спирометр ",\n          "turbidity": "Мутность",\n          "UV_sensor": "УФ датчик ",\n          "drop_counter": "Счетчик капель",\n          "altitude": "Высота над уривнем моря",\n          "goMotion": "GoMotion",\n          "goTemp": "GoIO температурный датчик",\n          "goLinkTemperature": "GoIO температурный датчик",\n          "goLinkLight": "GoIO оптический датчик ",\n          "goLinkForce": "GoIO датчик силы ",\n          "goLinkPH": "GoIO pH датчик ",\n          "goLinkCO2": "GoIO CO₂ датчик ",\n          "goLinkO2": "GoIO O₂ датчик",\n          "labQuestMotion": "LabQuest датчик перемещения",\n          "labQuestTemperature": "LabQuest температурный датчик ",\n          "labQuestLight": "LabQuest оптический датчик ",\n          "labQuestForce": "LabQuest датчик силы ",\n          "labQuestPH": "LabQuest pH датчик ",\n          "labQuestCO2": "LabQuest CO₂ датчик ",\n          "labQuestO2": "LabQuest O₂ датчик"\n        }\n      }\n    }\n  }\n\n}\n';});

/*global define */

define('common/i18n',['require','i18next','lab-grapher','text!locales/translations.json'],function (require) {
  var i18next       = require('i18next');
  var LabGrapher    = require('lab-grapher');
  var translations  = JSON.parse(require('text!locales/translations.json'));

  return function i18n(language) {
    i18next.init({
      lng: language,
      resStore: translations,
      fallbackLng: 'en-US',
      useCookie: false
    });
    // Grapher has its own i18n support implemented, just set language.
    LabGrapher.i18n.lang = language;
    return i18next;
  };
});

/*global define: false */

define('common/controllers/interactive-metadata',[],function() {

  return {
    /**
      Interactive top-level properties:
    */
    interactive: {
      title: {
        required: true
      },

      publicationStatus: {
        defaultValue: "public"
      },

      labEnvironment: {
        // An indicator of which Lab environment the interactive is compatible with.
        // Possible values:
        // - "production"
        // - "staging"
        // - "development"
        defaultValue: "production"
      },

      // Optional path to metadata containing information about available translations.
      // If present and valid, a new pulldown will be added to interactive UI that lets user
      // change language and locales.
      i18nMetadata: {
        defaultValue: ""
      },

      lang: {
        defaultValue: "en-US"
      },

      theme: {
        // Theme name or array of theme names. Multiple themes can be applied at the same time.
        // Note that theme is just a CSS class added to the interactive container, for example
        // ["foo", "bar"] will add following classes: .lab-theme-foo, .lab-theme-bar
        defaultValue: ""
      },

      showTopBar: {
        // Reload, share, about and language.
        defaultValue: true
      },

      showBottomBar: {
        // CC Logo and full-screen mode.
        defaultValue: true
      },

      credits: {
        // Content of the credits dialog. If it's not specified, the default, translatable text will be used.
        defaultValue: ''
      },

      padding: {
        // Top, bottom and left interactive padding, but NOT right...
        // This option was defined that way long time ago and now it has been exposed to authors.
        // We couldn't support right padding at the moment, as we would break backward compatibility.
        defaultValue: 10
      },

      subtitle: {
        defaultValue: ""
      },

      about: {
        defaultValue: ""
      },

      // optional: used by activity finder (pt: http://bit.ly/IGmyks)
      category: {
        defaultValue: ""
      },

      // optional: used by activity finder (pt: http://bit.ly/IGmyks)
      subCategory: {
        defaultValue: ""
      },

      // optional: used by activity finder (pt: http://bit.ly/IGpo96)
      screenshot: {
        defaultValue: ""
      },

      // optional: holds path of html or cml page this Interactive was imported from
      importedFrom: {},

      aspectRatio: {
        defaultValue: 1.3
      },

      fontScale: {
        defaultValue: 1
      },

      randomSeed: {
        required: false
      },

      helpOnLoad: {
        // If true, the help mode will be automatically shown on interactive load.
        defaultValue: false
      },

      aboutOnLoad: {
        // If true, the About dialog will be automatically shown on interactive load.
        defaultValue: false
      },

      models: {
        // List of model definitions. Its definition is below ('model').
        required: true
      },

      parameters: {
        // List of custom parameters.
        defaultValue: []
      },

      dataSets: {
        // List of data sets.
        defaultValue: []
      },

      propertiesToRetain: {
        // List of properties that should be retained during model reload or reset.
        defaultValue: []
      },

      outputs: {
        // List of outputs.
        defaultValue: []
      },

      filteredOutputs: {
        // List of filtered outputs.
        defaultValue: []
      },

      experiment: {
        required: false
      },

      exports: {
        required: false
      },

      logging: {
        // Note that logging is enabled by default, even if configuration is not provided. Take a look at
        // logging section below to see the default configuration. To disable logging, you need to explicitly
        // provide config with "enabled" property set to false.
        required: false
      },

      components: {
        // List of the interactive components. Their definitions are below ('button', 'checkbox' etc.).
        defaultValue: []
      },

      layout: {
        // Layout definition.
        defaultValue: {}
      },

      template: {
        // Layout template definition.
        defaultValue: "simple"
      },

      helpTips: {
        // List of help tips. See 'helpTip' metadata.
        defaultValue: []
      }
    },

    model: {
      // Definition of a model.
      // Can include either a URL to model definition or model options hash..
      type: {
        required: true
      },
      id: {
        required: true
      },
      url: {
        conflictsWith: ["model"]
      },
      // optional: holds path of html or cml page this Interactive was imported from
      importedFrom: {},
      model: {
        conflictsWith: ["url"]
      },
      // Optional "onLoad" script.
      onLoad: {},
      // Optional hash of options overwriting model options.
      viewOptions: {},
      modelOptions: {},
      // Parameters, outputs and filtered outputs can be also specified per model.
      parameters: {},
      outputs: {},
      filteredOutputs: {}
    },

    parameter: {
      name: {
        required: true
      },
      initialValue: {
        required: true
      },
      // Optional "onChange" script.
      onChange: {},
      // Optional description.
      label: {},
      unitType: {},
      unitName: {},
      unitPluralName: {},
      unitAbbreviation: {}
    },

    output: {
      name: {
        required: true
      },
      value: {
        required: true
      },
      // Optional description.
      label: {},
      unitType: {},
      unitName: {},
      unitPluralName: {},
      unitAbbreviation: {}
    },

    dataSet: {
      name: {
        required: true
      },
      properties: {
        defaultValue: []
      },
      serializableProperties: {
        // You can provide a list of properties that should be serialized, e.g.:
        // ["prop1", "prop2", "time"]
        // or use special values: "all" or "none".
        defaultValue: "all"
      },
      streamDataFromModel: {
        defaultValue: true
      },
      clearOnModelReset: {
        // Note that "model reset" in general includes actions like:
        // - reset
        // - reload
        // - new model load
        defaultValue: true
      },
      initialData: {}
    },

    filteredOutput: {
      name: {
        required: true
      },
      property: {
        required: true
      },
      type: {
        // For now, only "RunningAverage" is supported.
        defaultValue: "RunningAverage"
      },
      period: {
        // Smoothing time period in fs.
        defaultValue: 2500
      },
      // Optional description.
      label: {},
      unitType: {},
      unitName: {},
      unitPluralName: {},
      unitAbbreviation: {}
    },

    exports: {
      selectionComponents: {
        required: false,
        defaultValue: []
      },
      perRun: {
        required: false,
        defaultValue: []
      },
      perTick: {
        required: true
      }
    },

    logging: {
      enabled: {
        // Global logging switch. Model start, stop and reload are be logged by default
        // (and probably some other events in the future). Also, #logAction scripting API function
        // works only if it's set to true.
        defaultValue: true
      },
      properties: {
        // Properties that are logged on start, stop and reload events.
        // "boundToComponents" is a special value for authors' convenience.
        defaultValue: "boundToComponents"
      },
      components: {
        // List of components which should log user interaction.
        // "all" and "none" are special values for authors' convenience.
        defaultValue: "all"
      }
    },

    /**
      Interactive experiment template:
    */
    experiment: {
      timeSeries: {
        required: true
      },
      parameters: {
        required: true,
        defaultValue: []
      },
      destinations: {
        required: true,
        defaultValue: []
      },
      stateButtons: {
        required: true,
        startRun: {
          required: true,
          defaultValue: "start-run"
        },
        stopRun: {
          required: true,
          defaultValue: "stop-run"
        },
        saveRun: {
          required: true,
          defaultValue: "save-run"
        },
        nextRun: {
          required: true,
          defaultValue: "next-run"
        },
        clearAll: {
          required: true,
          defaultValue: "clear-all"
        }
      },
      onReset: {
      },
      savedRuns: {
        defaultValue: []
      }
    },

    experimentTimeSeries: {
      time: {
        defaultValue: "displayTime"
      },
      properties: {
        required: true,
        defaultValue: []
      }
    },

    experimentParameter: {
      inputs: {
        required: true,
        defaultValue: []
      },
      outputs: {
        required: true,
        defaultValue: []
      }
    },

    experimentDestination: {
      type: {
        required: true
      },
      componentIds: {
        required: true,
        defaultValue: []
      },
      properties: {
        required: true,
        defaultValue: []
      }
    },

    experimentSavedRun: {
      timeStamp: {
        required: true
      },
      timeSeries: {
        required: true,
        defaultValue: []
      },
      parameters: {
        required: true,
        defaultValue: []
      }
    },

    /**
      Interactive components:
    */
    playback: {
      id: {
        required: true
      },
      type: {
        required: true
      },
      stepping: {
        defaultValue: true
      }
    },

    text: {
      id: {
        required: true
      },
      type: {
        required: true
      },
      onClick: {
        // Script executed on user click, optional.
      },
      text: {
        // Text content.
        defaultValue: ""
      },
      width: {
        defaultValue: "auto"
      },
      height: {
        defaultValue: "auto"
      },
      tooltip: {
        defaultValue: ""
      },
      helpIcon: {
        defaultValue: false
      }
    },

    image: {
      id: {
        required: true
      },
      type: {
        required: true
      },
      src: {
        // Absolute path should start with http(s)://
        // Relative path is relative to model URL, unless specified
        // by urlRelativeTo.
        defaultValue: ""
      },
      urlRelativeTo: {
        // Specifies the url with which relative urls in src are resolved.
        // Possible values: model, page
        defaultValue: "model"
      },
      width: {
        defaultValue: "auto"
      },
      height: {
        defaultValue: "auto"
      },
      onClick: {
        // Script executed on user click, optional.
      },
      tooltip: {
        defaultValue: ""
      },
      helpIcon: {
        defaultValue: false
      }
    },

    div: {
      id: {
        required: true
      },
      type: {
        required: true
      },
      content: {
        conflictsWith: ["url"]
      },
      url: {
        conflictsWith: ["content"]
      },
      width: {
        defaultValue: "auto"
      },
      height: {
        defaultValue: "auto"
      },
      onClick: {
        // Script executed on user click, optional.
      },
      classes: {
        defaultValue: []
      },
      tooltip: {
        defaultValue: ""
      },
      helpIcon: {
        defaultValue: false
      }
    },

    button: {
      id: {
        required: true
      },
      type: {
        required: true
      },
      action: {
        required: true
      },
      text: {
        defaultValue: ""
      },
      width: {
        defaultValue: ""
      },
      height: {
        defaultValue: ""
      },
      disabled: {
        defaultValue: false
      },
      tooltip: {
        defaultValue: ""
      },
      helpIcon: {
        defaultValue: false
      }
    },

    checkbox: {
      id: {
        required: true
      },
      type: {
        required: true
      },
      text: {
        defaultValue: ""
      },
      textOn: {
        defaultValue: "right"
      },
      width: {
        defaultValue: "auto"
      },
      height: {
        defaultValue: "auto"
      },
      property: {
        conflictsWith: ["initialValue", "action"]
      },
      retainProperty: {
        // If property binding is used (so 'property' is defined), this flag decides whether
        // property should be retained during model reload / reset or not.
        defaultValue: true
      },
      action: {
        // Script executed when checkbox is changed, optional.
        conflictsWith: ["property"]
      },
      initialValue: {
        // Note that 'initialValue' makes sense only for checkboxes without property binding.
        // Do not use checkbox as setter of a given property.
        conflictsWith: ["property"]
      },
      disabled: {
        defaultValue: false
      },
      tooltip: {
        defaultValue: ""
      },
      helpIcon: {
        defaultValue: false
      }
    },

    slider: {
      id: {
        required: true
      },
      type: {
        required: true
      },
      min: {
        required: true
      },
      max: {
        required: true
      },
      steps: {
        required: true
      },
      title: {
        defaultValue: ""
      },
      titlePosition: {
        defaultValue: "top" // valid options: top, bottom, left, right
      },
      fillColor: {},
      fillToValue: {},
      labels: {
        // Label is specified by the following object:
        // {
        //   "value": [number or "left" or "right"],
        //   "label": [label, e.g. "High"]
        // }
        // Note that a label with "value": "left" (or "right") will be displayed to the left (or right) of the slider,
        // instead of underneath.
        defaultValue: []
      },
      width: {
        defaultValue: "auto"
      },
      height: {
        defaultValue: "auto"
      },
      displayValue: {},
      // Use "property" OR "action" + "initialValue".
      property: {
        // If you use property binding, do not mix it with action scripts and initial values.
        conflictsWith: ["initialValue", "action"]
      },
      retainProperty: {
        // If property binding is used (so 'property' is defined), this flag decides whether
        // property should be retained during model reload / reset or not.
        defaultValue: true
      },
      action: {
        conflictsWith: ["property"]
      },
      initialValue: {
        // Do not use slider as a property setter.
        // There are better ways to do it, e.g.:
        // "onLoad" scripts (and set({ }) call inside), "modelOptions", etc.
        conflictsWith: ["property"]
      },
      disabled: {
        defaultValue: false
      },
      tooltip: {
        defaultValue: ""
      },
      helpIcon: {
        defaultValue: false
      }
    },

    pulldown: {
      id: {
        required: true
      },
      type: {
        required: true
      },
      label: {
        defaultValue: ""
      },
      labelOn: {
        // Other option is "left".
        defaultValue: "top"
      },
      options: {
        defaultValue: []
      },
      property: {
        // Pulldown can be also connected to a model property.
        // In such case, options should define "value", not "action".
      },
      retainProperty: {
        // If property binding is used (so 'property' is defined), this flag decides whether
        // property should be retained during model reload / reset or not.
        defaultValue: true
      },
      disabled: {
        defaultValue: false
      },
      tooltip: {
        defaultValue: ""
      },
      helpIcon: {
        defaultValue: false
      }
    },

    pulldownOption: {
      text: {
        defaultValue: ""
      },
      action: {
        // Use it when pulldown is not bound to any model property.
        conflictsWith: ["value"]
      },
      value: {
        // Use it when pulldown is bound to some model property.
        conflictsWith: ["action"]
      },
      selected: {
        // Use it when pulldown is not bound to any model property.
        // When "property" is used for pulldown, it will determine
        // selection.
        conflictsWith: ["value"]
      },
      disabled: {}
    },

    radio: {
      id: {
        required: true
      },
      type: {
        required: true
      },
      style: {
        // "radio" (classic radio button) or "toggle" (looks like group of regular buttons).
        defaultValue: "radio"
      },
      orientation: {
        defaultValue: "vertical"
      },
      label: {
        defaultValue: ""
      },
      labelOn: {
        // Other option is "left".
        defaultValue: "top"
      },
      options: {
        defaultValue: []
      },
      property: {
        // Radio can be also connected to a model property.
        // In such case, options should define "value", not "action".
      },
      retainProperty: {
        // If property binding is used (so 'property' is defined), this flag decides whether
        // property should be retained during model reload / reset or not.
        defaultValue: true
      },
      disabled: {
        defaultValue: false
      },
      tooltip: {
        defaultValue: ""
      },
      helpIcon: {
        defaultValue: false
      }
    },

    radioOption: {
      text: {
        defaultValue: ""
      },
      action: {
        // Use it when radio is not bound to any model property.
        conflictsWith: ["value"]
      },
      value: {
        // Use it when radio is bound to some model property.
        conflictsWith: ["action"]
      },
      selected: {
        // Use it when radio is not bound to any model property.
        // When "property" is used for radio, it will determine
        // selection.
        conflictsWith: ["value"]
      },
      disabled: {}
    },

    numericOutput: {
      id: {
        required: true
      },
      type: {
        required: true
      },
      property: {
        required: true
      },
      label: {
        defaultValue: ""
      },
      units: {
        defaultValue: ""
      },
      orientation: {
        defaultValue: "horizontal"
      },
      width: {
        defaultValue: "auto"
      },
      height: {
        defaultValue: "auto"
      },
      displayValue: {},
      tooltip: {
        defaultValue: ""
      },
      helpIcon: {
        defaultValue: false
      }
    },

    thermometer: {
      id: {
        required: true
      },
      type: {
        required: true
      },
      min: {
        required: true
      },
      max: {
        required: true
      },
      width: {
        // It controls width of the thermometer graphics!
        // It won't affect label, e.g. making it truncated
        // as width is only "2.5em".
        defaultValue: "2.5em"
      },
      height: {
        // Height of the whole thermometer with reading.
        defaultValue: "100%"
      },
      labelIsReading: {
        defaultValue: false
      },
      reading: {
        defaultValue: {
          units: "K",
          offset: 0,
          scale: 1,
          digits: 0
        }
      },
      labels: {
        // Label is specified by the following object:
        // {
        //   "value": [value, e.g. 100],
        //   "label": [label, e.g. "High"]
        // }
        defaultValue: []
      }
    },

    joystick: {
      id: {
        required: true
      },
      type: {
        required: true
      },
      title: {
        defaultValue: ""
      },
      labels: {
        // Labels is specified by the following object:
        // {
        //   n: 'North'
        //   w: 'West'
        //   s: 'South'
        //   e: 'East'
        // }
        defaultValue: {n: 'N', e: 'E', s: 'S', w: 'W'}
      },
      scale: {
        defaultValue: 1
      },
      width: {
        defaultValue: "auto"
      },
      height: {
        defaultValue: "auto"
      },
      displayValue: {
        // Javascript which returns a string which will be displayed below the joystick.
        // The 'value' variable is available with the current value of the joystick,
        // which will be an object: { magnitude: 1, direction: 0 }.
        // ex: "return 'Aiming toward ' + value.direction + ' with speed ' + value.magnitude;"
      },
      // Use "property" OR "action" + "initialValue".
      // The joystick value is an object with 2 properties: magnitude and direction -- { magnitude: 1, direction: 0 }
      // Magnitude is always normalized to 0 to 1, and direction is in radians, 0 to 2*PI.
      property: {
        // If you use property binding, do not mix it with action scripts and initial values.
        conflictsWith: ["initialValue", "action"]
      },
      retainProperty: {
        // If property binding is used (so 'property' is defined), this flag decides whether
        // property should be retained during model reload / reset or not.
        defaultValue: true
      },
      action: {
        conflictsWith: ["property"]
      },
      initialValue: {
        conflictsWith: ["property"]
      },
      disabled: {
        defaultValue: false
      },
      tooltip: {
        defaultValue: ""
      },
      helpIcon: {
        defaultValue: false
      }
    },

    colorIndicator: {
      id: {
        required: true
      },
      type: {
        required: true
      },
      title: {
        defaultValue: ""
      },
      colorValue: {
        // Javascript which returns a valid css color -- #aa9933, rgb(), hsl(), etc.
        // The 'value' variable is available with the current value of the watched property.
        // ex: "return 'hsl('+value+',100%,50%)';"
        required: true
      },
      width: {
        defaultValue: "auto"
      },
      height: {
        defaultValue: "auto"
      },
      property: {
        required: true
      },
      retainProperty: {
        // This flag decides whether
        // property should be retained during model reload / reset or not.
        defaultValue: true
      },
      tooltip: {
        defaultValue: ""
      },
      helpIcon: {
        defaultValue: false
      }
    },

    spectrometer: {
      id: {
        required: true
      },
      type: {
        required: true
      },
      upperBound: {
        // Upper bound of frequency in eV.
        defaultValue: 15
      },
      lowerBound: {
        // Lower bound of frequency in eV.
        defaultValue: 2
      },
      ticks: {
        defaultValue: 10
      },
      clearOnModelLoad: {
        // Should spectrometer clear its output on model reload or when a new model is loaded?
        defaultValue: true
      },
      width: {
        defaultValue: "12em"
      },
      height: {
        defaultValue: "3em"
      },
      border: {
        // CSS border specification is accepted.
        defaultValue: "none"
      },
      tooltip: {
        defaultValue: ""
      },
      helpIcon: {
        defaultValue: false
      }
    },

    table: {
      id: {
        required: true
      },
      type: {
        required: true
      },
      title: {
        defaultValue: null
      },
      dataSet: {
        // Optional. When external data set is referenced, then properties listed in "conflictsWith"
        // array should be defined inside data set definition, not in table definition.
        conflictsWith: ["tableData", "clearOnModelReset", "streamDataFromModel"]
      },
      tableData: {
        conflictsWith: ["dataSet"]
      },
      clearOnModelReset: {
        conflictsWith: ["dataSet"]
      },
      streamDataFromModel: {
        conflictsWith: ["dataSet"]
      },
      addNewRows: {
        defaultValue: true
      },
      visibleRows: {
        defaultValue: 4
      },
      showBlankRow: {
        // If true, a new blank row will be always visible.
        defaultValue: false
      },
      indexColumn: {
        defaultValue: true
      },
      propertyColumns: {
        defaultValue: []
      },
      headerData: {
        defaultValue: []
      },
      width: {
        defaultValue: "auto"
      },
      height: {
        defaultValue: "100%"
      },
      tooltip: {
        defaultValue: ""
      },
      helpIcon: {
        defaultValue: false
      }
    },

    graph: {
      id: {
        required: true
      },
      type: {
        required: true
      },
      dataSet: {
        // Optional. When external data set is referenced, then properties listed in "conflictsWith"
        // array should be defined inside data set definition, not in table definition.
        conflictsWith: ["dataPoints", "clearOnModelReset", "streamDataFromModel"]
      },
      dataPoints: {
        conflictsWith: ["dataSet"]
      },
      clearOnModelReset: {
        conflictsWith: ["dataSet"]
      },
      streamDataFromModel: {
        conflictsWith: ["dataSet"]
      },
      resetAxesOnReset: {
        defaultValue: true
      },
      enableAutoScaleButton: {
        defaultValue: true
      },
      enableAxisScaling: {
        defaultValue: true
      },
      enableZooming: {
        defaultValue: true
      },
      autoScaleX: {
        defaultValue: true
      },
      autoScaleY: {
        defaultValue: true
      },
      enableSelectionButton: {
        defaultValue: false
      },
      clearSelectionOnLeavingSelectMode: {
        defaultValue: false
      },
      enableDrawButton: {
        defaultValue: false
      },
      drawProperty: {
        defaultValue: null
      },
      markAllDataPoints: {
        defaultValue: false
      },
      showRulersOnSelection: {
        defaultValue: false
      },
      fontScaleRelativeToParent: {
        defaultValue: true
      },
      hideAxisValues: {
        defaultValue: false
      },
      properties: {
        defaultValue: []
      },
      xProperty: {
        defaultValue: "displayTime"
      },
      title: {
        defaultValue: "Graph"
      },
      titlePosition: {
        // "center" or "left"
        defaultValue: "center"
      },
      buttonsStyle: {
        // "icons" or "text"
        defaultValue: "icons"
      },
      buttonsLayout: {
        // "vertical" or "horizontal"
        defaultValue: "vertical"
      },
      lineWidth: {
        defaultValue: 2.0
      },
      width: {
        defaultValue: "100%"
      },
      height: {
        defaultValue: "100%"
      },
      xlabel: {
        defaultValue: "auto"
      },
      xmin: {
        defaultValue: 0
      },
      xmax: {
        defaultValue: 20
      },
      ylabel: {
        defaultValue: "auto"
      },
      ymin: {
        defaultValue: 0
      },
      ymax: {
        defaultValue: 10
      },
      xTickCount: {
        defaultValue: 10
      },
      yTickCount: {
        defaultValue: 10
      },
      xscaleExponent: {
        defaultValue: 0.5
      },
      yscaleExponent: {
        defaultValue: 0.5
      },
      xFormatter: {
        defaultValue: ".2r"
      },
      yFormatter: {
        defaultValue: ".2r"
      },
      lines: {
        defaultValue: true
      },
      bars: {
        defaultValue: false
      },
      tooltip: {
        defaultValue: ""
      },
      dataColors: {
        defaultValue: [
          "#a00000",
          "#2ca000",
          "#2c00a0"
        ]
      },
      legendLabels: {
        defaultValue: []
      },
      legendVisible: {
        defaultValue: false
      },
      syncXAxis: {
        defaultValue: false
      },
      syncYAxis: {
        defaultValue: false
      },
      helpIcon: {
        defaultValue: false
      }
    },

    barGraph: {
      id: {
        required: true
      },
      type: {
        required: true
      },
      property: {
        required: true
      },
      secondProperty: {
        // Additional value displayed
        // using small triangle. E.g.
        // can be used to present
        // averaged value.
        conflictsWith: ["averagePeriod"]
      },
      min: {
        // Min value displayed.
        defaultValue: 0
      },
      max: {
        // Max value displayed.
        defaultValue: 10
      },
      title: {
        // Graph title.
        defaultValue: ""
      },
      titleOn: {
        // Title position, accepted values are:
        // "right", "top", "bottom"
        defaultValue: "right"
      },
      labels: {
        // Number of labels displayed on the left side of the graph.
        // This value is *only* a suggestion. The most clean
        // and human-readable values are used.
        // You can also specify value-label pairs, e.g.:
        // [
        //   {
        //     "value": 0,
        //     "label": "low"
        //   },
        //   {
        //     "value": 10,
        //     "label": "high"
        //   }
        // ]
        // Use 0 or null to disable labels completely.
        defaultValue: 5
      },
      units: {
        // Units displayed next to labels. Set it to 'true' to use units
        // automatically retrieved from property description. Set it to any
        // string to use custom unit symbol.
        defaultValue: false
      },
      gridLines: {
        // Number of grid lines displayed on the bar.
        // This value is *only* a suggestion, it's similar to 'ticks'.
        defaultValue: 10
      },
      labelFormat: {
        // Format of labels.
        // See the specification of this format:
        // https://github.com/mbostock/d3/wiki/Formatting#wiki-d3_format
        // or:
        // http://docs.python.org/release/3.1.3/library/string.html#formatspec
        defaultValue: "0.1f"
      },
      averagePeriod: {
        // Setting this property to some numeric value
        // enables displaying of the averaged property.
        // It's a shortcut which can be used instead
        // of a custom filtered output bound
        // to the "secondProperty".
        conflictsWith: ["secondProperty"]
      },
      barWidth: {
        // Widht of the bar graph, WITHOUT
        // labels, title and padding.
        defaultValue: "2em"
      },
      height: {
        // Height of the bar graph container,
        // including small padding.
        defaultValue: "100%"
      },
      barColor: {
        // Color of the main bar.
        defaultValue:  "#e23c34"
      },
      fillColor: {
        // Color of the area behind the bar.
        defaultValue: "#fff"
      },
      tooltip: {
        defaultValue: ""
      },
      helpIcon: {
        defaultValue: false
      }
    },

    helpTip: {
      component: {
        // Single component or array of components (bounding box of components will be used).
        // "" - help tip will be positioned in the center.
        defaultValue: ""
      },
      text: {
        defaultValue: ""
      },
      showcase: {
        // If false, help tip is not displayed when user enters showcase mode by clicking top-left "?" icon.
        // It can be displayed only by "?" icon provided by component.
        defaultValue: true
      }
    }
  };
});

/*global define: false */

define('common/resources-url',['require','lab.config'],function (require) {
  var config = require('lab.config');
  return function (resourcePath) {
    return config.rootUrl + "/resources/" + resourcePath;
  };
});

/*global define, $ */

define('common/controllers/language-select',['require','common/resources-url'],function (require) {
  var resourcesUrl = require('common/resources-url');

  function languageSelect(selector, interactiveController) {
    var metadata = interactiveController.interactive.i18nMetadata;
    if (!metadata) return;

    var metadataDownloaded = $.get(metadata).done(function(results) {
      if (typeof results === 'string') results = JSON.parse(results);
      setupContextMenu(selector, results, interactiveController.interactive.lang,
                       interactiveController);
    });

    var interactiveRendered = new $.Deferred();
    interactiveController.on('interactiveRendered.i18nHelper', function() {
      interactiveRendered.resolve();
    });

    $.when(metadataDownloaded, interactiveRendered).done(function () {
      setupLangIcon(selector, interactiveController.interactive.lang);
    });
  }

  // Private functions used by i18nHelper.

  function code2flag(countryCode) {
    var arr = countryCode.split('-');
    // Handle special cases like "en-US", "en-GB" etc.
    return resourcesUrl('flags/' + arr[arr.length - 1].toLowerCase() + '.png');
  }

  function setupLangIcon(selector, currentLang) {
    var $icon = $(selector);
    $icon.addClass('lang-icon');
    $icon.css('background-image', 'url("' + code2flag(currentLang) + '")');
  }

  function setupContextMenu(selector, i18nMetadata, currentLang, interactiveController) {
    var items = {};
    Object.keys(i18nMetadata).forEach(function (key) {
      if (key === currentLang) return;
      items[key] = {
        name: key,
        className: 'lang-' + key
      };
    });
    if (Object.keys(items).length === 0) return;
    // When 'trigger' is set to 'none' and menu is opened manually using .contextMenu() call,
    // it causes that menu positioning doesn't use mouse pointer coordinates. It's the simplest way
    // to force a menu to always show below the flag.
    $(selector).on('click', function () {
      $(selector).contextMenu(); // ! open manu manually
    });
    $.contextMenu('destroy', selector);
    $.contextMenu({
      selector: selector,
      appendTo: '.lab-responsive-content',
      className: 'lang-menu',
      trigger: 'none', // !
      zIndex: 1000, // avoid conflict with layout containers
      determinePosition: function($menu) {
        // position to the lower left of the trigger element
        // .position() is provided as a jQuery UI utility
        // (...and it won't work on hidden elements)
        $menu.css('display', 'block').position({
            my: "right top",
            at: "right bottom",
            of: this,
            offset: "0 5",
            collision: "fit"
        }).css('display', 'none');
      },
      callback: function(key) {
        interactiveController.requestInteractiveAt(i18nMetadata[key]);
      },
      items: items
    });
    Object.keys(items).forEach(function (key) {
      $('.context-menu-item.lang-' + key).css('background-image', 'url("' + code2flag(key) + '")');
    });
  }

  return languageSelect;
});

define('common/listening-pool',[],function () {

  /**
   * isD3Listner : is a given listener a D3 listener?
   * @param {listener} the listener to check for D3
   */
  var isD3Listner = function(listener) {
    // D3 events don't use "off", they issue another 'on' with same name
    // see: https://github.com/mbostock/d3/wiki/Internals#wiki-dispatch_on
    if (typeof listener.off !== 'function') {
      return true;
    }
    return false;
  };

  /**
   * ListeningPool:  A simple helper to keep track of the events you
   * are listening too.
   *
   * @constructor
   *
   * @param {Namespace} our event namespace. Required for D3 events,
   * handy for JQuery event types.
   */
  function ListeningPool(namespace) {
    this._nameSpace           = namespace;
    this.registeredListeners  = [];

    this._nameSpaced          = function (eventName) {
      return eventName + "." + this._nameSpace;
    };
  }

  /**
   * listen: register a new listener on a speaker.
   *
   * @param {speaker}  object we are listening too.
   * @param {eventName} the event type we are listening for
   * @param {func} callback to invoke when event is fired.
   */
  ListeningPool.prototype.listen = function (speaker, eventName, func) {
    var eventKey = this._nameSpaced(eventName);
    var listeningRecord = {
        speaker: speaker,
        eventName: eventKey
    };
    speaker.on(eventKey, func);
    this.registeredListeners.push(listeningRecord);
  };

  /**
   * remove : remove a listener from the registeredListeners
   * @param {listener} the listener to remove
   */
  ListeningPool.prototype.remove = function(listener) {
    if (isD3Listner(listener)) {
      listener.speaker.on(listener.eventName, null); // How D3 removes listeners...
    }
    else {
      listener.speaker.off(listener.eventName); // How JQuery removes listeners..
    }
  };

  /**
   * removeAll : remove ourself as a listener from all our speakers.
   * (We could simply use JQuery off(/namespace/) if we stick to JQ events)
   */
  ListeningPool.prototype.removeAll = function () {
    while(this.registeredListeners.length > 0) {
      this.remove(this.registeredListeners.pop());
    }
  };

  return ListeningPool;
});

/*global define: false, d3: false */
/**
 * This module provides event dispatch based on d3.dispatch:
 * https://github.com/mbostock/d3/wiki/Internals#wiki-d3_dispatch
 *
 * The main improvement over raw d3.dispatch is that this wrapper provides
 * event batching. You can start batch mode (.startBatch()) and while it is
 * active events won't be dispatched immediately. They will be dispatched
 * at the end of batch mode (.endBatch()) or when you call .flush() method.
 *
 * Note that there is one *significant limitation*: arguments passed during
 * event dispatching will be lost! All events will be merged into single
 * event without any argument. Please keep this in mind while using this module.
 *
 * e.g.
 *   dispatch.on("someEvent", function(arg) { console.log(arg); });
 *   dispatch.someEvent(123);     // console output: 123
 *   dispatch.someEvent("test");  // console output: "test"
 * However...
 *   dispatch.startBatch();
 *   dispatch.someEvent(123);
 *   dispatch.someEvent("test");
 *   dispatch.endBatch();         // console output: undefined (!)
 *
 * Rest of the interface is exactly the same like in d3.dispatch (.on()).
 * Under the hood delegation to d3.dispatch instance is used.
 */
define('common/dispatch-support',[],function() {

  // Converts arguments object to regular array.
  function argsToArray(args) {
    return [].slice.call(args);
  }

  return function DispatchSupport() {
    var api,
        d3dispatch,
        types,

        batchMode = false,
        suppressedEvents = d3.set();

    function init(newTypes) {
      var i, len;

      types = newTypes;

      d3dispatch = d3.dispatch.apply(null, types);

      // Provide wrapper around typical calls like dispatch.someEvent().
      for (i = 0, len = types.length; i < len; i++) {
        api[types[i]] = dispatchEvent(types[i]);
      }
    }

    function dispatchEvent(name) {
      return function () {
        if (!batchMode) {
          d3dispatch[name].apply(d3dispatch, arguments);
        } else {
          suppressedEvents.add(name);
        }
      };
    }

    function delegate(funcName) {
      return function () {
        d3dispatch[funcName].apply(d3dispatch, arguments);
      };
    }

    // Public API.
    api = {
      // Copy d3.dispatch API:

      /**
       * Adds or removes an event listener for the specified type. Please see:
       * https://github.com/mbostock/d3/wiki/Internals#wiki-dispatch_on
       */
      on: delegate("on"),

      // New API specific for Lab DispatchSupport:

      mixInto: function(target) {
        target.on = api.on;
        target.suppressEvents = api.suppressEvents;
      },

      /**
       * Adds new event types. Old event types are still supported, but
       * all previously registered listeners will be removed!
       *
       * e.g. dispatch.addEventTypes("newEvent", "anotherEvent")
       */
      addEventTypes: function () {
        if (arguments.length) {
          init(types.concat(argsToArray(arguments)));
        }
      },

      /**
       * Starts batch mode. Events won't be dispatched immediately after call.
       * They will be merged into single event and dispatched when .flush()
       * or .endBatch() is called.
       */
      startBatch: function () {
        batchMode = true;
      },

      /**
       * Ends batch mode and dispatches suppressed events.
       */
      endBatch: function () {
        batchMode = false;
        api.flush();
      },

      /**
       * Dispatches suppressed events.
       * @return {[type]} [description]
       */
      flush: function () {
        suppressedEvents.forEach(function (eventName) {
          d3dispatch[eventName]();
        });
        // Reset suppressed events.
        suppressedEvents = d3.set();
      },

      /**
       * Allows to execute some action without dispatching any events.
       * @param {function} action
       */
      suppressEvents: function(action) {
        batchMode = true;
        action();
        batchMode = false;
        // Reset suppressed events without dispatching them.
        suppressedEvents = d3.set();
      }
    };

    init(argsToArray(arguments));

    return api;
  };
});

define('common/controllers/data-set',['common/controllers/interactive-metadata','common/validator','common/listening-pool','common/dispatch-support'],function () {
  var metadata        = require('common/controllers/interactive-metadata');
  var validator       = require('common/validator');
  var ListeningPool   = require('common/listening-pool');
  var DispatchSupport = require('common/dispatch-support');
  var dataSetCount    = 0;

  /**
   * DataSet: Manage Collections of data for tables, graphs, others.
   *
   * @constructor
   *
   * @param {object}                 component              The json definition for our dataset.
   * @param {interactivesController} interactivesController InteractivesController instance.
   * @param {boolean}                private                If true, data set will register itself
   *                                                        as 'private' data set in interactives
   *                                                        controller.
   */
  function DataSet(component, interactivesController, private) {
    this.interactivesController = interactivesController;
    this._model                 = interactivesController.getModel();
    this.namespace              = "dataSet" + (++dataSetCount);
    this.component              = validator.validateCompleteness(metadata.dataSet, component);
    this.name                   = this.component.name;
    this.properties             = this.component.properties || [];
    this.streamDataFromModel    = this.component.streamDataFromModel;
    this.clearOnModelReset      = this.component.clearOnModelReset;
    // Set initial data only if there is real data there. Otherwise set null for convenience.
    this.initialData            = this.component.initialData ?
                                  $.extend(true, {}, this.component.initialData) : null;
    this._data                  = {};
    // Keep clear distinction between model properties and other properties (e.g. they can be
    // filled by the user). Data streaming streams only model properties.
    this._modelProperties       = [];
    this._listeningPool         = new ListeningPool(this.namespace);
    this._dispatch              = new DispatchSupport();

    for (var key in DataSet.Events) {
      this._dispatch.addEventTypes(DataSet.Events[key]);
    }
    this._dispatch.mixInto(this);

    // This will initialize _data in a right way (e.g. copy initial data).
    this.resetData();

    // Finally register itself in interactives controller (e.g. it's necessary to ensure that
    // modelLoadedCallback will be called).
    this.interactivesController.addDataSet(this, private);
  }

  DataSet.Events = {
    SAMPLE_ADDED:      "sampleAdded",
    SAMPLE_CHANGED:    "sampleChanged",
    SAMPLE_REMOVED:    "sampleRemoved",

    DATA_TRUNCATED:    "dataTruncated",
    DATA_RESET:        "dataReset",

    SELECTION_CHANGED: "selectionChanged",

    LABELS_CHANGED:    "labelsChanged"
  };

  /******************************************************************
    "Private" methods, not intended for use by outside objects.
  *******************************************************************/

  DataSet.prototype._setupEmptyData = function () {
    var context = this;
    this.properties.forEach(function (prop) {
      context._data[prop] = [];
    });
  };

  /**
    Check that we haven't invalidated future datapoints.
  */
  DataSet.prototype._inNewModelTerritory = function () {
    return (this._model.stepCounter() < this.maxLength(this._modelProperties));
  };

  /**
    register model listeners
  */
  DataSet.prototype._addListeners = function() {
    var listeningPool  = this._listeningPool;
    var model          = this.interactivesController.getModel();
    var context        = this;

    var positionChanged = function() {
      context._trigger(DataSet.Events.SELECTION_CHANGED, model.stepCounter());
    };

    listeningPool.removeAll(); // remove previous listeners.

    if (this.streamDataFromModel) {
      listeningPool.listen(model, 'tick', function () {
        context.appendDataPoint();
        positionChanged();
      });

      listeningPool.listen(model, 'play', function() {
        if (context._inNewModelTerritory()) {
          context.removeModelDataAfterStepPointer();
        }
      });

      listeningPool.listen(model, 'stepBack',    positionChanged);
      listeningPool.listen(model, 'stepForward', positionChanged);
      listeningPool.listen(model, 'seek',        positionChanged);

      listeningPool.listen(model, 'invalidation', function() {
        context.removeModelDataAfterStepPointer();
      });
    }

    listeningPool.listen(model, 'reset', function() {
      if (context.clearOnModelReset) {
        context.resetData();
      }
      if (context.streamDataFromModel) {
        context.appendDataPoint();
      }
    });

    this.properties.forEach(function (prop) {
      context._model.addPropertyDescriptionObserver(prop, function() {
        context._trigger(DataSet.Events.LABELS_CHANGED, context.getLabels());
      });
    });
  };

  /**
    Law of demeter workaround ;)
  */
  DataSet.prototype._getModelProperty = function (propName) {
    return this._model.get(propName);
  };

  /**
    Trigger a custom event for listeners.
    @param {name} event name we are triggering
    @param {data} extra data for the event.
  */
  DataSet.prototype._trigger = function (name, data) {
    this._dispatch[name]({'data': data});
  };

  DataSet.prototype._getPropertyLabel = function(prop) {
    if (!this._model.hasProperty(prop)) return "";
    var description = this._model.getPropertyDescription(prop);
    return description.getLabel() + " (" + description.getUnitAbbreviation() + ")";
  };

  DataSet.prototype._resetProperty = function(prop, values) {
    var newValue = [];
    if (values && values[prop]) {
      newValue = values[prop];
    } else if (this.initialData[prop]) {
      newValue = this.initialData[prop];
    }
    this._data[prop] = newValue.slice(0); // always use a copy
  };


  /******************************************************************
    "Public" methods, should have associated unit tests.
  *******************************************************************/

  DataSet.prototype.getData = function() {
    return this._data;
  };

  DataSet.prototype.maxLength = function(props) {
    var maxLength = -Infinity;
    var context = this;
    props.forEach(function (prop) {
      if (maxLength < context._data[prop].length) maxLength = context._data[prop].length;
    });
    return maxLength;
  };

  DataSet.prototype.minLength = function(props) {
    var minLength = Infinity;
    var context = this;
    props.forEach(function (prop) {
      if (minLength > context._data[prop].length) minLength = context._data[prop].length;
    });
    return minLength;
  };

  /**
   Returns index of a data point if all provided values are matching.
   For example if data set has following properties and values:
   {
     x: [0, 1, 2, 3],
     y: [0, 10, 20, 30]
   }
   then:
   dataset.dataPointIndex({x: 2, y: 20}); // returns: 2
   dataset.dataPointIndex({x: 2});        // returns: 2
   dataset.dataPointIndex({x: 2, y: 99}); // returns: -1 (not found)
   */
  DataSet.prototype.dataPointIndex = function (values) {
    var props = Object.keys(values);
    var valuesLength = this.minLength(props);
    var propsLength = props.length;
    var allValuesMatching;
    var prop;

    for (var index = 0; index < valuesLength; index++) {
      allValuesMatching = true;
      for (var j = 0; j < propsLength; j++) {
        prop = props[j];
        if (this._data[prop][index] !== values[prop]) {
          allValuesMatching = false;
          break;
        }
      }
      if (allValuesMatching) {
        return index;
      }
    }
    return -1;
  };

  /**
    Resets data sat to its initial data. When initial data is not provided, clears data
    set (in such case this function behaves exactly like .clearData()).
  */
  DataSet.prototype.resetData = function () {
    this._setupEmptyData();
    if (this.initialData) {
      $.extend(true, this._data, this.initialData);
    }
    this._trigger(DataSet.Events.DATA_RESET, this._data);
  };

  /**
    Clears completely data set.
   */
  DataSet.prototype.clearData = function () {
    this._setupEmptyData();
    this._trigger(DataSet.Events.DATA_RESET, this._data);
  };

  DataSet.prototype.resetProperties = function (props) {
    var i;
    for (i = 0; i < props.length; i++) {
      this._resetProperty(props[i]);
    }
    this._trigger(DataSet.Events.DATA_RESET, this._data);
  };

  DataSet.prototype.appendDataPoint = function (props, values) {
    if (!props) {
      props = this._modelProperties;
    }
    var dataPoint = {};
    var context = this;
    props.forEach(function (prop) {
      var val = values && values[prop] !== undefined ? values[prop] : context._getModelProperty(prop);
      if (val === undefined) return;
      dataPoint[prop] = val;
      context._data[prop].push(val);
    });

    this._trigger(DataSet.Events.SAMPLE_ADDED, dataPoint);
  };

  DataSet.prototype.removeDataPoint = function (props, index) {
    var context = this;
    props.forEach(function (prop) {
      context._data[prop][index] = null;
    });
    this._trigger(DataSet.Events.SAMPLE_REMOVED, {props: props, index: index});
  };


  /**
    Removes all data that correspond to steps following the current step pointer. This is used when
    a change is made that invalidates the future data.
  */
  DataSet.prototype.removeModelDataAfterStepPointer = function () {
    var newLength = this._model.stepCounter();
    var context = this;

    if (newLength < 0) {
      newLength = 0;
    }

    this._modelProperties.forEach(function (prop) {
      if (context._data[prop].length > newLength) {
        context._data[prop].length = newLength;
      }
    });

    this._trigger(DataSet.Events.DATA_TRUNCATED, this._data);

    // Note that code above also removes point equal to step pointer! It's intentional.
    // Now we append the last point again to be sure that it contains updated values of model
    // properties (as invalidation in most cases is related to change of some model property).
    context.appendDataPoint();
  };

  DataSet.prototype.editDataPoint = function (index, property, newValue) {
    this._data[property][index] = newValue;

    var context = this;
    var dataPoint = {};
    this.properties.forEach(function (prop) {
      dataPoint[prop] = context._data[prop][index];
    });

    this._trigger(DataSet.Events.SAMPLE_CHANGED, {index:     index,
                                                  property:  property,
                                                  value:     newValue,
                                                  dataPoint: dataPoint});
  };

  DataSet.prototype.getPropertyValue = function (index, property) {
    return this._data[property][index];
  };

  /**
    Return properties labels (array).
   */
  DataSet.prototype.getLabels = function() {
    var res = {};
    var context = this;
    this.properties.forEach(function (prop) {
      res[prop] = context._getPropertyLabel(prop);
    });
    return res;
  };

  /**
    Called when the model has loaded. Setup listeners. Clear Data.
  */
  DataSet.prototype.modelLoadedCallback = function() {
    this._model = this.interactivesController.getModel();
    this._addListeners();
    // Keep list of properties that are defined in model. Only these properties will be streamed.
    this._modelProperties = [];
    var context = this;
    this.properties.forEach(function (prop) {
      if (context._model.hasProperty(prop)) {
        context._modelProperties.push(prop);
      }
    });
    if (this.clearOnModelReset) {
      this.resetData();
    }
    if (this.streamDataFromModel) {
      this.appendDataPoint();
    }
  };

  DataSet.prototype.serialize = function () {
    // Start with the initial component definition.
    var result = $.extend(true, {}, this.component);
    // Save current data as initial data.
    result.initialData = this.serializeData();
    return result;
  };

  DataSet.prototype.serializeData = function () {
    if (this.component.serializableProperties === "none") return {};
    var props = this.component.serializableProperties === "all" ?
                this.properties : this.component.serializableProperties;
    var result = {};
    var context = this;
    props.forEach(function (prop) {
      result[prop] = $.extend(true, [], context._data[prop]);
    });
    return result;
  };

  // Handle events which are generated by a different dataset.
  // This will keep this data set in sync with the other one.
  DataSet.prototype.handleExternalEvent = function(evtName, data) {
    switch(evtName) {
      case DataSet.Events.SAMPLE_ADDED:
        this.appendDataPoint(Object.keys(data), data);
        break;
      case DataSet.Events.SAMPLE_CHANGED:
        this.editDataPoint(data['index'], data['property'], data['newValue']);
        break;
      case DataSet.Events.SAMPLE_REMOVED:
        this.removeDataPoint(data['props'], data['index']);
        break;

      case DataSet.Events.DATA_TRUNCATED:
        // TODO
        break;
      case DataSet.Events.DATA_RESET:
        var context = this;
        Object.keys(data).forEach(function(prop) {
          context._resetProperty(prop, data);
        });
        this._trigger(DataSet.Events.DATA_RESET, this._data);
        break;

      case DataSet.Events.SELECTION_CHANGED:
        // TODO
        break;

      case DataSet.Events.LABELS_CHANGED:
        // TODO
        break;
    }
  };

  return DataSet;
});

//     Backbone.js 1.1.0

//     (c) 2010-2011 Jeremy Ashkenas, DocumentCloud Inc.
//     (c) 2011-2013 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Backbone may be freely distributed under the MIT license.
//     For all details and documentation:
//     http://backbonejs.org

(function(){

  // Initial Setup
  // -------------

  // Save a reference to the global object (`window` in the browser, `exports`
  // on the server).
  var root = this;

  // Save the previous value of the `Backbone` variable, so that it can be
  // restored later on, if `noConflict` is used.
  var previousBackbone = root.Backbone;

  // Create local references to array methods we'll want to use later.
  var array = [];
  var push = array.push;
  var slice = array.slice;
  var splice = array.splice;

  // The top-level namespace. All public Backbone classes and modules will
  // be attached to this. Exported for both the browser and the server.
  var Backbone;
  if (typeof exports !== 'undefined') {
    Backbone = exports;
  } else {
    Backbone = root.Backbone = {};
  }

  // Current version of the library. Keep in sync with `package.json`.
  Backbone.VERSION = '1.1.0';

  // Require Underscore, if we're on the server, and it's not already present.
  var _ = root._;
  if (!_ && (typeof require !== 'undefined')) _ = require('underscore');

  // For Backbone's purposes, jQuery, Zepto, Ender, or My Library (kidding) owns
  // the `$` variable.
  Backbone.$ = root.jQuery || root.Zepto || root.ender || root.$;

  // Runs Backbone.js in *noConflict* mode, returning the `Backbone` variable
  // to its previous owner. Returns a reference to this Backbone object.
  Backbone.noConflict = function() {
    root.Backbone = previousBackbone;
    return this;
  };

  // Turn on `emulateHTTP` to support legacy HTTP servers. Setting this option
  // will fake `"PATCH"`, `"PUT"` and `"DELETE"` requests via the `_method` parameter and
  // set a `X-Http-Method-Override` header.
  Backbone.emulateHTTP = false;

  // Turn on `emulateJSON` to support legacy servers that can't deal with direct
  // `application/json` requests ... will encode the body as
  // `application/x-www-form-urlencoded` instead and will send the model in a
  // form param named `model`.
  Backbone.emulateJSON = false;

  // Backbone.Events
  // ---------------

  // A module that can be mixed in to *any object* in order to provide it with
  // custom events. You may bind with `on` or remove with `off` callback
  // functions to an event; `trigger`-ing an event fires all callbacks in
  // succession.
  //
  //     var object = {};
  //     _.extend(object, Backbone.Events);
  //     object.on('expand', function(){ alert('expanded'); });
  //     object.trigger('expand');
  //
  var Events = Backbone.Events = {

    // Bind an event to a `callback` function. Passing `"all"` will bind
    // the callback to all events fired.
    on: function(name, callback, context) {
      if (!eventsApi(this, 'on', name, [callback, context]) || !callback) return this;
      this._events || (this._events = {});
      var events = this._events[name] || (this._events[name] = []);
      events.push({callback: callback, context: context, ctx: context || this});
      return this;
    },

    // Bind an event to only be triggered a single time. After the first time
    // the callback is invoked, it will be removed.
    once: function(name, callback, context) {
      if (!eventsApi(this, 'once', name, [callback, context]) || !callback) return this;
      var self = this;
      var once = _.once(function() {
        self.off(name, once);
        callback.apply(this, arguments);
      });
      once._callback = callback;
      return this.on(name, once, context);
    },

    // Remove one or many callbacks. If `context` is null, removes all
    // callbacks with that function. If `callback` is null, removes all
    // callbacks for the event. If `name` is null, removes all bound
    // callbacks for all events.
    off: function(name, callback, context) {
      var retain, ev, events, names, i, l, j, k;
      if (!this._events || !eventsApi(this, 'off', name, [callback, context])) return this;
      if (!name && !callback && !context) {
        this._events = {};
        return this;
      }
      names = name ? [name] : _.keys(this._events);
      for (i = 0, l = names.length; i < l; i++) {
        name = names[i];
        if (events = this._events[name]) {
          this._events[name] = retain = [];
          if (callback || context) {
            for (j = 0, k = events.length; j < k; j++) {
              ev = events[j];
              if ((callback && callback !== ev.callback && callback !== ev.callback._callback) ||
                  (context && context !== ev.context)) {
                retain.push(ev);
              }
            }
          }
          if (!retain.length) delete this._events[name];
        }
      }

      return this;
    },

    // Trigger one or many events, firing all bound callbacks. Callbacks are
    // passed the same arguments as `trigger` is, apart from the event name
    // (unless you're listening on `"all"`, which will cause your callback to
    // receive the true name of the event as the first argument).
    trigger: function(name) {
      if (!this._events) return this;
      var args = slice.call(arguments, 1);
      if (!eventsApi(this, 'trigger', name, args)) return this;
      var events = this._events[name];
      var allEvents = this._events.all;
      if (events) triggerEvents(events, args);
      if (allEvents) triggerEvents(allEvents, arguments);
      return this;
    },

    // Tell this object to stop listening to either specific events ... or
    // to every object it's currently listening to.
    stopListening: function(obj, name, callback) {
      var listeningTo = this._listeningTo;
      if (!listeningTo) return this;
      var remove = !name && !callback;
      if (!callback && typeof name === 'object') callback = this;
      if (obj) (listeningTo = {})[obj._listenId] = obj;
      for (var id in listeningTo) {
        obj = listeningTo[id];
        obj.off(name, callback, this);
        if (remove || _.isEmpty(obj._events)) delete this._listeningTo[id];
      }
      return this;
    }

  };

  // Regular expression used to split event strings.
  var eventSplitter = /\s+/;

  // Implement fancy features of the Events API such as multiple event
  // names `"change blur"` and jQuery-style event maps `{change: action}`
  // in terms of the existing API.
  var eventsApi = function(obj, action, name, rest) {
    if (!name) return true;

    // Handle event maps.
    if (typeof name === 'object') {
      for (var key in name) {
        obj[action].apply(obj, [key, name[key]].concat(rest));
      }
      return false;
    }

    // Handle space separated event names.
    if (eventSplitter.test(name)) {
      var names = name.split(eventSplitter);
      for (var i = 0, l = names.length; i < l; i++) {
        obj[action].apply(obj, [names[i]].concat(rest));
      }
      return false;
    }

    return true;
  };

  // A difficult-to-believe, but optimized internal dispatch function for
  // triggering events. Tries to keep the usual cases speedy (most internal
  // Backbone events have 3 arguments).
  var triggerEvents = function(events, args) {
    var ev, i = -1, l = events.length, a1 = args[0], a2 = args[1], a3 = args[2];
    switch (args.length) {
      case 0: while (++i < l) (ev = events[i]).callback.call(ev.ctx); return;
      case 1: while (++i < l) (ev = events[i]).callback.call(ev.ctx, a1); return;
      case 2: while (++i < l) (ev = events[i]).callback.call(ev.ctx, a1, a2); return;
      case 3: while (++i < l) (ev = events[i]).callback.call(ev.ctx, a1, a2, a3); return;
      default: while (++i < l) (ev = events[i]).callback.apply(ev.ctx, args);
    }
  };

  var listenMethods = {listenTo: 'on', listenToOnce: 'once'};

  // Inversion-of-control versions of `on` and `once`. Tell *this* object to
  // listen to an event in another object ... keeping track of what it's
  // listening to.
  _.each(listenMethods, function(implementation, method) {
    Events[method] = function(obj, name, callback) {
      var listeningTo = this._listeningTo || (this._listeningTo = {});
      var id = obj._listenId || (obj._listenId = _.uniqueId('l'));
      listeningTo[id] = obj;
      if (!callback && typeof name === 'object') callback = this;
      obj[implementation](name, callback, this);
      return this;
    };
  });

  // Aliases for backwards compatibility.
  Events.bind   = Events.on;
  Events.unbind = Events.off;

  // Allow the `Backbone` object to serve as a global event bus, for folks who
  // want global "pubsub" in a convenient place.
  _.extend(Backbone, Events);

  // Backbone.Model
  // --------------

  // Backbone **Models** are the basic data object in the framework --
  // frequently representing a row in a table in a database on your server.
  // A discrete chunk of data and a bunch of useful, related methods for
  // performing computations and transformations on that data.

  // Create a new model with the specified attributes. A client id (`cid`)
  // is automatically generated and assigned for you.
  var Model = Backbone.Model = function(attributes, options) {
    var attrs = attributes || {};
    options || (options = {});
    this.cid = _.uniqueId('c');
    this.attributes = {};
    if (options.collection) this.collection = options.collection;
    if (options.parse) attrs = this.parse(attrs, options) || {};
    attrs = _.defaults({}, attrs, _.result(this, 'defaults'));
    this.set(attrs, options);
    this.changed = {};
    this.initialize.apply(this, arguments);
  };

  // Attach all inheritable methods to the Model prototype.
  _.extend(Model.prototype, Events, {

    // A hash of attributes whose current and previous value differ.
    changed: null,

    // The value returned during the last failed validation.
    validationError: null,

    // The default name for the JSON `id` attribute is `"id"`. MongoDB and
    // CouchDB users may want to set this to `"_id"`.
    idAttribute: 'id',

    // Initialize is an empty function by default. Override it with your own
    // initialization logic.
    initialize: function(){},

    // Return a copy of the model's `attributes` object.
    toJSON: function(options) {
      return _.clone(this.attributes);
    },

    // Proxy `Backbone.sync` by default -- but override this if you need
    // custom syncing semantics for *this* particular model.
    sync: function() {
      return Backbone.sync.apply(this, arguments);
    },

    // Get the value of an attribute.
    get: function(attr) {
      return this.attributes[attr];
    },

    // Get the HTML-escaped value of an attribute.
    escape: function(attr) {
      return _.escape(this.get(attr));
    },

    // Returns `true` if the attribute contains a value that is not null
    // or undefined.
    has: function(attr) {
      return this.get(attr) != null;
    },

    // Set a hash of model attributes on the object, firing `"change"`. This is
    // the core primitive operation of a model, updating the data and notifying
    // anyone who needs to know about the change in state. The heart of the beast.
    set: function(key, val, options) {
      var attr, attrs, unset, changes, silent, changing, prev, current;
      if (key == null) return this;

      // Handle both `"key", value` and `{key: value}` -style arguments.
      if (typeof key === 'object') {
        attrs = key;
        options = val;
      } else {
        (attrs = {})[key] = val;
      }

      options || (options = {});

      // Run validation.
      if (!this._validate(attrs, options)) return false;

      // Extract attributes and options.
      unset           = options.unset;
      silent          = options.silent;
      changes         = [];
      changing        = this._changing;
      this._changing  = true;

      if (!changing) {
        this._previousAttributes = _.clone(this.attributes);
        this.changed = {};
      }
      current = this.attributes, prev = this._previousAttributes;

      // Check for changes of `id`.
      if (this.idAttribute in attrs) this.id = attrs[this.idAttribute];

      // For each `set` attribute, update or delete the current value.
      for (attr in attrs) {
        val = attrs[attr];
        if (!_.isEqual(current[attr], val)) changes.push(attr);
        if (!_.isEqual(prev[attr], val)) {
          this.changed[attr] = val;
        } else {
          delete this.changed[attr];
        }
        unset ? delete current[attr] : current[attr] = val;
      }

      // Trigger all relevant attribute changes.
      if (!silent) {
        if (changes.length) this._pending = true;
        for (var i = 0, l = changes.length; i < l; i++) {
          this.trigger('change:' + changes[i], this, current[changes[i]], options);
        }
      }

      // You might be wondering why there's a `while` loop here. Changes can
      // be recursively nested within `"change"` events.
      if (changing) return this;
      if (!silent) {
        while (this._pending) {
          this._pending = false;
          this.trigger('change', this, options);
        }
      }
      this._pending = false;
      this._changing = false;
      return this;
    },

    // Remove an attribute from the model, firing `"change"`. `unset` is a noop
    // if the attribute doesn't exist.
    unset: function(attr, options) {
      return this.set(attr, void 0, _.extend({}, options, {unset: true}));
    },

    // Clear all attributes on the model, firing `"change"`.
    clear: function(options) {
      var attrs = {};
      for (var key in this.attributes) attrs[key] = void 0;
      return this.set(attrs, _.extend({}, options, {unset: true}));
    },

    // Determine if the model has changed since the last `"change"` event.
    // If you specify an attribute name, determine if that attribute has changed.
    hasChanged: function(attr) {
      if (attr == null) return !_.isEmpty(this.changed);
      return _.has(this.changed, attr);
    },

    // Return an object containing all the attributes that have changed, or
    // false if there are no changed attributes. Useful for determining what
    // parts of a view need to be updated and/or what attributes need to be
    // persisted to the server. Unset attributes will be set to undefined.
    // You can also pass an attributes object to diff against the model,
    // determining if there *would be* a change.
    changedAttributes: function(diff) {
      if (!diff) return this.hasChanged() ? _.clone(this.changed) : false;
      var val, changed = false;
      var old = this._changing ? this._previousAttributes : this.attributes;
      for (var attr in diff) {
        if (_.isEqual(old[attr], (val = diff[attr]))) continue;
        (changed || (changed = {}))[attr] = val;
      }
      return changed;
    },

    // Get the previous value of an attribute, recorded at the time the last
    // `"change"` event was fired.
    previous: function(attr) {
      if (attr == null || !this._previousAttributes) return null;
      return this._previousAttributes[attr];
    },

    // Get all of the attributes of the model at the time of the previous
    // `"change"` event.
    previousAttributes: function() {
      return _.clone(this._previousAttributes);
    },

    // Fetch the model from the server. If the server's representation of the
    // model differs from its current attributes, they will be overridden,
    // triggering a `"change"` event.
    fetch: function(options) {
      options = options ? _.clone(options) : {};
      if (options.parse === void 0) options.parse = true;
      var model = this;
      var success = options.success;
      options.success = function(resp) {
        if (!model.set(model.parse(resp, options), options)) return false;
        if (success) success(model, resp, options);
        model.trigger('sync', model, resp, options);
      };
      wrapError(this, options);
      return this.sync('read', this, options);
    },

    // Set a hash of model attributes, and sync the model to the server.
    // If the server returns an attributes hash that differs, the model's
    // state will be `set` again.
    save: function(key, val, options) {
      var attrs, method, xhr, attributes = this.attributes;

      // Handle both `"key", value` and `{key: value}` -style arguments.
      if (key == null || typeof key === 'object') {
        attrs = key;
        options = val;
      } else {
        (attrs = {})[key] = val;
      }

      options = _.extend({validate: true}, options);

      // If we're not waiting and attributes exist, save acts as
      // `set(attr).save(null, opts)` with validation. Otherwise, check if
      // the model will be valid when the attributes, if any, are set.
      if (attrs && !options.wait) {
        if (!this.set(attrs, options)) return false;
      } else {
        if (!this._validate(attrs, options)) return false;
      }

      // Set temporary attributes if `{wait: true}`.
      if (attrs && options.wait) {
        this.attributes = _.extend({}, attributes, attrs);
      }

      // After a successful server-side save, the client is (optionally)
      // updated with the server-side state.
      if (options.parse === void 0) options.parse = true;
      var model = this;
      var success = options.success;
      options.success = function(resp) {
        // Ensure attributes are restored during synchronous saves.
        model.attributes = attributes;
        var serverAttrs = model.parse(resp, options);
        if (options.wait) serverAttrs = _.extend(attrs || {}, serverAttrs);
        if (_.isObject(serverAttrs) && !model.set(serverAttrs, options)) {
          return false;
        }
        if (success) success(model, resp, options);
        model.trigger('sync', model, resp, options);
      };
      wrapError(this, options);

      method = this.isNew() ? 'create' : (options.patch ? 'patch' : 'update');
      if (method === 'patch') options.attrs = attrs;
      xhr = this.sync(method, this, options);

      // Restore attributes.
      if (attrs && options.wait) this.attributes = attributes;

      return xhr;
    },

    // Destroy this model on the server if it was already persisted.
    // Optimistically removes the model from its collection, if it has one.
    // If `wait: true` is passed, waits for the server to respond before removal.
    destroy: function(options) {
      options = options ? _.clone(options) : {};
      var model = this;
      var success = options.success;

      var destroy = function() {
        model.trigger('destroy', model, model.collection, options);
      };

      options.success = function(resp) {
        if (options.wait || model.isNew()) destroy();
        if (success) success(model, resp, options);
        if (!model.isNew()) model.trigger('sync', model, resp, options);
      };

      if (this.isNew()) {
        options.success();
        return false;
      }
      wrapError(this, options);

      var xhr = this.sync('delete', this, options);
      if (!options.wait) destroy();
      return xhr;
    },

    // Default URL for the model's representation on the server -- if you're
    // using Backbone's restful methods, override this to change the endpoint
    // that will be called.
    url: function() {
      var base = _.result(this, 'urlRoot') || _.result(this.collection, 'url') || urlError();
      if (this.isNew()) return base;
      return base + (base.charAt(base.length - 1) === '/' ? '' : '/') + encodeURIComponent(this.id);
    },

    // **parse** converts a response into the hash of attributes to be `set` on
    // the model. The default implementation is just to pass the response along.
    parse: function(resp, options) {
      return resp;
    },

    // Create a new model with identical attributes to this one.
    clone: function() {
      return new this.constructor(this.attributes);
    },

    // A model is new if it has never been saved to the server, and lacks an id.
    isNew: function() {
      return this.id == null;
    },

    // Check if the model is currently in a valid state.
    isValid: function(options) {
      return this._validate({}, _.extend(options || {}, { validate: true }));
    },

    // Run validation against the next complete set of model attributes,
    // returning `true` if all is well. Otherwise, fire an `"invalid"` event.
    _validate: function(attrs, options) {
      if (!options.validate || !this.validate) return true;
      attrs = _.extend({}, this.attributes, attrs);
      var error = this.validationError = this.validate(attrs, options) || null;
      if (!error) return true;
      this.trigger('invalid', this, error, _.extend(options, {validationError: error}));
      return false;
    }

  });

  // Underscore methods that we want to implement on the Model.
  var modelMethods = ['keys', 'values', 'pairs', 'invert', 'pick', 'omit'];

  // Mix in each Underscore method as a proxy to `Model#attributes`.
  _.each(modelMethods, function(method) {
    Model.prototype[method] = function() {
      var args = slice.call(arguments);
      args.unshift(this.attributes);
      return _[method].apply(_, args);
    };
  });

  // Backbone.Collection
  // -------------------

  // If models tend to represent a single row of data, a Backbone Collection is
  // more analagous to a table full of data ... or a small slice or page of that
  // table, or a collection of rows that belong together for a particular reason
  // -- all of the messages in this particular folder, all of the documents
  // belonging to this particular author, and so on. Collections maintain
  // indexes of their models, both in order, and for lookup by `id`.

  // Create a new **Collection**, perhaps to contain a specific type of `model`.
  // If a `comparator` is specified, the Collection will maintain
  // its models in sort order, as they're added and removed.
  var Collection = Backbone.Collection = function(models, options) {
    options || (options = {});
    if (options.model) this.model = options.model;
    if (options.comparator !== void 0) this.comparator = options.comparator;
    this._reset();
    this.initialize.apply(this, arguments);
    if (models) this.reset(models, _.extend({silent: true}, options));
  };

  // Default options for `Collection#set`.
  var setOptions = {add: true, remove: true, merge: true};
  var addOptions = {add: true, remove: false};

  // Define the Collection's inheritable methods.
  _.extend(Collection.prototype, Events, {

    // The default model for a collection is just a **Backbone.Model**.
    // This should be overridden in most cases.
    model: Model,

    // Initialize is an empty function by default. Override it with your own
    // initialization logic.
    initialize: function(){},

    // The JSON representation of a Collection is an array of the
    // models' attributes.
    toJSON: function(options) {
      return this.map(function(model){ return model.toJSON(options); });
    },

    // Proxy `Backbone.sync` by default.
    sync: function() {
      return Backbone.sync.apply(this, arguments);
    },

    // Add a model, or list of models to the set.
    add: function(models, options) {
      return this.set(models, _.extend({merge: false}, options, addOptions));
    },

    // Remove a model, or a list of models from the set.
    remove: function(models, options) {
      var singular = !_.isArray(models);
      models = singular ? [models] : _.clone(models);
      options || (options = {});
      var i, l, index, model;
      for (i = 0, l = models.length; i < l; i++) {
        model = models[i] = this.get(models[i]);
        if (!model) continue;
        delete this._byId[model.id];
        delete this._byId[model.cid];
        index = this.indexOf(model);
        this.models.splice(index, 1);
        this.length--;
        if (!options.silent) {
          options.index = index;
          model.trigger('remove', model, this, options);
        }
        this._removeReference(model);
      }
      return singular ? models[0] : models;
    },

    // Update a collection by `set`-ing a new list of models, adding new ones,
    // removing models that are no longer present, and merging models that
    // already exist in the collection, as necessary. Similar to **Model#set**,
    // the core operation for updating the data contained by the collection.
    set: function(models, options) {
      options = _.defaults({}, options, setOptions);
      if (options.parse) models = this.parse(models, options);
      var singular = !_.isArray(models);
      models = singular ? (models ? [models] : []) : _.clone(models);
      var i, l, id, model, attrs, existing, sort;
      var at = options.at;
      var targetModel = this.model;
      var sortable = this.comparator && (at == null) && options.sort !== false;
      var sortAttr = _.isString(this.comparator) ? this.comparator : null;
      var toAdd = [], toRemove = [], modelMap = {};
      var add = options.add, merge = options.merge, remove = options.remove;
      var order = !sortable && add && remove ? [] : false;

      // Turn bare objects into model references, and prevent invalid models
      // from being added.
      for (i = 0, l = models.length; i < l; i++) {
        attrs = models[i];
        if (attrs instanceof Model) {
          id = model = attrs;
        } else {
          id = attrs[targetModel.prototype.idAttribute];
        }

        // If a duplicate is found, prevent it from being added and
        // optionally merge it into the existing model.
        if (existing = this.get(id)) {
          if (remove) modelMap[existing.cid] = true;
          if (merge) {
            attrs = attrs === model ? model.attributes : attrs;
            if (options.parse) attrs = existing.parse(attrs, options);
            existing.set(attrs, options);
            if (sortable && !sort && existing.hasChanged(sortAttr)) sort = true;
          }
          models[i] = existing;

        // If this is a new, valid model, push it to the `toAdd` list.
        } else if (add) {
          model = models[i] = this._prepareModel(attrs, options);
          if (!model) continue;
          toAdd.push(model);

          // Listen to added models' events, and index models for lookup by
          // `id` and by `cid`.
          model.on('all', this._onModelEvent, this);
          this._byId[model.cid] = model;
          if (model.id != null) this._byId[model.id] = model;
        }
        if (order) order.push(existing || model);
      }

      // Remove nonexistent models if appropriate.
      if (remove) {
        for (i = 0, l = this.length; i < l; ++i) {
          if (!modelMap[(model = this.models[i]).cid]) toRemove.push(model);
        }
        if (toRemove.length) this.remove(toRemove, options);
      }

      // See if sorting is needed, update `length` and splice in new models.
      if (toAdd.length || (order && order.length)) {
        if (sortable) sort = true;
        this.length += toAdd.length;
        if (at != null) {
          for (i = 0, l = toAdd.length; i < l; i++) {
            this.models.splice(at + i, 0, toAdd[i]);
          }
        } else {
          if (order) this.models.length = 0;
          var orderedModels = order || toAdd;
          for (i = 0, l = orderedModels.length; i < l; i++) {
            this.models.push(orderedModels[i]);
          }
        }
      }

      // Silently sort the collection if appropriate.
      if (sort) this.sort({silent: true});

      // Unless silenced, it's time to fire all appropriate add/sort events.
      if (!options.silent) {
        for (i = 0, l = toAdd.length; i < l; i++) {
          (model = toAdd[i]).trigger('add', model, this, options);
        }
        if (sort || (order && order.length)) this.trigger('sort', this, options);
      }
      
      // Return the added (or merged) model (or models).
      return singular ? models[0] : models;
    },

    // When you have more items than you want to add or remove individually,
    // you can reset the entire set with a new list of models, without firing
    // any granular `add` or `remove` events. Fires `reset` when finished.
    // Useful for bulk operations and optimizations.
    reset: function(models, options) {
      options || (options = {});
      for (var i = 0, l = this.models.length; i < l; i++) {
        this._removeReference(this.models[i]);
      }
      options.previousModels = this.models;
      this._reset();
      models = this.add(models, _.extend({silent: true}, options));
      if (!options.silent) this.trigger('reset', this, options);
      return models;
    },

    // Add a model to the end of the collection.
    push: function(model, options) {
      return this.add(model, _.extend({at: this.length}, options));
    },

    // Remove a model from the end of the collection.
    pop: function(options) {
      var model = this.at(this.length - 1);
      this.remove(model, options);
      return model;
    },

    // Add a model to the beginning of the collection.
    unshift: function(model, options) {
      return this.add(model, _.extend({at: 0}, options));
    },

    // Remove a model from the beginning of the collection.
    shift: function(options) {
      var model = this.at(0);
      this.remove(model, options);
      return model;
    },

    // Slice out a sub-array of models from the collection.
    slice: function() {
      return slice.apply(this.models, arguments);
    },

    // Get a model from the set by id.
    get: function(obj) {
      if (obj == null) return void 0;
      return this._byId[obj.id] || this._byId[obj.cid] || this._byId[obj];
    },

    // Get the model at the given index.
    at: function(index) {
      return this.models[index];
    },

    // Return models with matching attributes. Useful for simple cases of
    // `filter`.
    where: function(attrs, first) {
      if (_.isEmpty(attrs)) return first ? void 0 : [];
      return this[first ? 'find' : 'filter'](function(model) {
        for (var key in attrs) {
          if (attrs[key] !== model.get(key)) return false;
        }
        return true;
      });
    },

    // Return the first model with matching attributes. Useful for simple cases
    // of `find`.
    findWhere: function(attrs) {
      return this.where(attrs, true);
    },

    // Force the collection to re-sort itself. You don't need to call this under
    // normal circumstances, as the set will maintain sort order as each item
    // is added.
    sort: function(options) {
      if (!this.comparator) throw new Error('Cannot sort a set without a comparator');
      options || (options = {});

      // Run sort based on type of `comparator`.
      if (_.isString(this.comparator) || this.comparator.length === 1) {
        this.models = this.sortBy(this.comparator, this);
      } else {
        this.models.sort(_.bind(this.comparator, this));
      }

      if (!options.silent) this.trigger('sort', this, options);
      return this;
    },

    // Pluck an attribute from each model in the collection.
    pluck: function(attr) {
      return _.invoke(this.models, 'get', attr);
    },

    // Fetch the default set of models for this collection, resetting the
    // collection when they arrive. If `reset: true` is passed, the response
    // data will be passed through the `reset` method instead of `set`.
    fetch: function(options) {
      options = options ? _.clone(options) : {};
      if (options.parse === void 0) options.parse = true;
      var success = options.success;
      var collection = this;
      options.success = function(resp) {
        var method = options.reset ? 'reset' : 'set';
        collection[method](resp, options);
        if (success) success(collection, resp, options);
        collection.trigger('sync', collection, resp, options);
      };
      wrapError(this, options);
      return this.sync('read', this, options);
    },

    // Create a new instance of a model in this collection. Add the model to the
    // collection immediately, unless `wait: true` is passed, in which case we
    // wait for the server to agree.
    create: function(model, options) {
      options = options ? _.clone(options) : {};
      if (!(model = this._prepareModel(model, options))) return false;
      if (!options.wait) this.add(model, options);
      var collection = this;
      var success = options.success;
      options.success = function(model, resp, options) {
        if (options.wait) collection.add(model, options);
        if (success) success(model, resp, options);
      };
      model.save(null, options);
      return model;
    },

    // **parse** converts a response into a list of models to be added to the
    // collection. The default implementation is just to pass it through.
    parse: function(resp, options) {
      return resp;
    },

    // Create a new collection with an identical list of models as this one.
    clone: function() {
      return new this.constructor(this.models);
    },

    // Private method to reset all internal state. Called when the collection
    // is first initialized or reset.
    _reset: function() {
      this.length = 0;
      this.models = [];
      this._byId  = {};
    },

    // Prepare a hash of attributes (or other model) to be added to this
    // collection.
    _prepareModel: function(attrs, options) {
      if (attrs instanceof Model) {
        if (!attrs.collection) attrs.collection = this;
        return attrs;
      }
      options = options ? _.clone(options) : {};
      options.collection = this;
      var model = new this.model(attrs, options);
      if (!model.validationError) return model;
      this.trigger('invalid', this, model.validationError, options);
      return false;
    },

    // Internal method to sever a model's ties to a collection.
    _removeReference: function(model) {
      if (this === model.collection) delete model.collection;
      model.off('all', this._onModelEvent, this);
    },

    // Internal method called every time a model in the set fires an event.
    // Sets need to update their indexes when models change ids. All other
    // events simply proxy through. "add" and "remove" events that originate
    // in other collections are ignored.
    _onModelEvent: function(event, model, collection, options) {
      if ((event === 'add' || event === 'remove') && collection !== this) return;
      if (event === 'destroy') this.remove(model, options);
      if (model && event === 'change:' + model.idAttribute) {
        delete this._byId[model.previous(model.idAttribute)];
        if (model.id != null) this._byId[model.id] = model;
      }
      this.trigger.apply(this, arguments);
    }

  });

  // Underscore methods that we want to implement on the Collection.
  // 90% of the core usefulness of Backbone Collections is actually implemented
  // right here:
  var methods = ['forEach', 'each', 'map', 'collect', 'reduce', 'foldl',
    'inject', 'reduceRight', 'foldr', 'find', 'detect', 'filter', 'select',
    'reject', 'every', 'all', 'some', 'any', 'include', 'contains', 'invoke',
    'max', 'min', 'toArray', 'size', 'first', 'head', 'take', 'initial', 'rest',
    'tail', 'drop', 'last', 'without', 'difference', 'indexOf', 'shuffle',
    'lastIndexOf', 'isEmpty', 'chain'];

  // Mix in each Underscore method as a proxy to `Collection#models`.
  _.each(methods, function(method) {
    Collection.prototype[method] = function() {
      var args = slice.call(arguments);
      args.unshift(this.models);
      return _[method].apply(_, args);
    };
  });

  // Underscore methods that take a property name as an argument.
  var attributeMethods = ['groupBy', 'countBy', 'sortBy'];

  // Use attributes instead of properties.
  _.each(attributeMethods, function(method) {
    Collection.prototype[method] = function(value, context) {
      var iterator = _.isFunction(value) ? value : function(model) {
        return model.get(value);
      };
      return _[method](this.models, iterator, context);
    };
  });

  // Backbone.View
  // -------------

  // Backbone Views are almost more convention than they are actual code. A View
  // is simply a JavaScript object that represents a logical chunk of UI in the
  // DOM. This might be a single item, an entire list, a sidebar or panel, or
  // even the surrounding frame which wraps your whole app. Defining a chunk of
  // UI as a **View** allows you to define your DOM events declaratively, without
  // having to worry about render order ... and makes it easy for the view to
  // react to specific changes in the state of your models.

  // Creating a Backbone.View creates its initial element outside of the DOM,
  // if an existing element is not provided...
  var View = Backbone.View = function(options) {
    this.cid = _.uniqueId('view');
    options || (options = {});
    _.extend(this, _.pick(options, viewOptions));
    this._ensureElement();
    this.initialize.apply(this, arguments);
    this.delegateEvents();
  };

  // Cached regex to split keys for `delegate`.
  var delegateEventSplitter = /^(\S+)\s*(.*)$/;

  // List of view options to be merged as properties.
  var viewOptions = ['model', 'collection', 'el', 'id', 'attributes', 'className', 'tagName', 'events'];

  // Set up all inheritable **Backbone.View** properties and methods.
  _.extend(View.prototype, Events, {

    // The default `tagName` of a View's element is `"div"`.
    tagName: 'div',

    // jQuery delegate for element lookup, scoped to DOM elements within the
    // current view. This should be preferred to global lookups where possible.
    $: function(selector) {
      return this.$el.find(selector);
    },

    // Initialize is an empty function by default. Override it with your own
    // initialization logic.
    initialize: function(){},

    // **render** is the core function that your view should override, in order
    // to populate its element (`this.el`), with the appropriate HTML. The
    // convention is for **render** to always return `this`.
    render: function() {
      return this;
    },

    // Remove this view by taking the element out of the DOM, and removing any
    // applicable Backbone.Events listeners.
    remove: function() {
      this.$el.remove();
      this.stopListening();
      return this;
    },

    // Change the view's element (`this.el` property), including event
    // re-delegation.
    setElement: function(element, delegate) {
      if (this.$el) this.undelegateEvents();
      this.$el = element instanceof Backbone.$ ? element : Backbone.$(element);
      this.el = this.$el[0];
      if (delegate !== false) this.delegateEvents();
      return this;
    },

    // Set callbacks, where `this.events` is a hash of
    //
    // *{"event selector": "callback"}*
    //
    //     {
    //       'mousedown .title':  'edit',
    //       'click .button':     'save',
    //       'click .open':       function(e) { ... }
    //     }
    //
    // pairs. Callbacks will be bound to the view, with `this` set properly.
    // Uses event delegation for efficiency.
    // Omitting the selector binds the event to `this.el`.
    // This only works for delegate-able events: not `focus`, `blur`, and
    // not `change`, `submit`, and `reset` in Internet Explorer.
    delegateEvents: function(events) {
      if (!(events || (events = _.result(this, 'events')))) return this;
      this.undelegateEvents();
      for (var key in events) {
        var method = events[key];
        if (!_.isFunction(method)) method = this[events[key]];
        if (!method) continue;

        var match = key.match(delegateEventSplitter);
        var eventName = match[1], selector = match[2];
        method = _.bind(method, this);
        eventName += '.delegateEvents' + this.cid;
        if (selector === '') {
          this.$el.on(eventName, method);
        } else {
          this.$el.on(eventName, selector, method);
        }
      }
      return this;
    },

    // Clears all callbacks previously bound to the view with `delegateEvents`.
    // You usually don't need to use this, but may wish to if you have multiple
    // Backbone views attached to the same DOM element.
    undelegateEvents: function() {
      this.$el.off('.delegateEvents' + this.cid);
      return this;
    },

    // Ensure that the View has a DOM element to render into.
    // If `this.el` is a string, pass it through `$()`, take the first
    // matching element, and re-assign it to `el`. Otherwise, create
    // an element from the `id`, `className` and `tagName` properties.
    _ensureElement: function() {
      if (!this.el) {
        var attrs = _.extend({}, _.result(this, 'attributes'));
        if (this.id) attrs.id = _.result(this, 'id');
        if (this.className) attrs['class'] = _.result(this, 'className');
        var $el = Backbone.$('<' + _.result(this, 'tagName') + '>').attr(attrs);
        this.setElement($el, false);
      } else {
        this.setElement(_.result(this, 'el'), false);
      }
    }

  });

  // Backbone.sync
  // -------------

  // Override this function to change the manner in which Backbone persists
  // models to the server. You will be passed the type of request, and the
  // model in question. By default, makes a RESTful Ajax request
  // to the model's `url()`. Some possible customizations could be:
  //
  // * Use `setTimeout` to batch rapid-fire updates into a single request.
  // * Send up the models as XML instead of JSON.
  // * Persist models via WebSockets instead of Ajax.
  //
  // Turn on `Backbone.emulateHTTP` in order to send `PUT` and `DELETE` requests
  // as `POST`, with a `_method` parameter containing the true HTTP method,
  // as well as all requests with the body as `application/x-www-form-urlencoded`
  // instead of `application/json` with the model in a param named `model`.
  // Useful when interfacing with server-side languages like **PHP** that make
  // it difficult to read the body of `PUT` requests.
  Backbone.sync = function(method, model, options) {
    var type = methodMap[method];

    // Default options, unless specified.
    _.defaults(options || (options = {}), {
      emulateHTTP: Backbone.emulateHTTP,
      emulateJSON: Backbone.emulateJSON
    });

    // Default JSON-request options.
    var params = {type: type, dataType: 'json'};

    // Ensure that we have a URL.
    if (!options.url) {
      params.url = _.result(model, 'url') || urlError();
    }

    // Ensure that we have the appropriate request data.
    if (options.data == null && model && (method === 'create' || method === 'update' || method === 'patch')) {
      params.contentType = 'application/json';
      params.data = JSON.stringify(options.attrs || model.toJSON(options));
    }

    // For older servers, emulate JSON by encoding the request into an HTML-form.
    if (options.emulateJSON) {
      params.contentType = 'application/x-www-form-urlencoded';
      params.data = params.data ? {model: params.data} : {};
    }

    // For older servers, emulate HTTP by mimicking the HTTP method with `_method`
    // And an `X-HTTP-Method-Override` header.
    if (options.emulateHTTP && (type === 'PUT' || type === 'DELETE' || type === 'PATCH')) {
      params.type = 'POST';
      if (options.emulateJSON) params.data._method = type;
      var beforeSend = options.beforeSend;
      options.beforeSend = function(xhr) {
        xhr.setRequestHeader('X-HTTP-Method-Override', type);
        if (beforeSend) return beforeSend.apply(this, arguments);
      };
    }

    // Don't process data on a non-GET request.
    if (params.type !== 'GET' && !options.emulateJSON) {
      params.processData = false;
    }

    // If we're sending a `PATCH` request, and we're in an old Internet Explorer
    // that still has ActiveX enabled by default, override jQuery to use that
    // for XHR instead. Remove this line when jQuery supports `PATCH` on IE8.
    if (params.type === 'PATCH' && noXhrPatch) {
      params.xhr = function() {
        return new ActiveXObject("Microsoft.XMLHTTP");
      };
    }

    // Make the request, allowing the user to override any Ajax options.
    var xhr = options.xhr = Backbone.ajax(_.extend(params, options));
    model.trigger('request', model, xhr, options);
    return xhr;
  };

  var noXhrPatch = typeof window !== 'undefined' && !!window.ActiveXObject && !(window.XMLHttpRequest && (new XMLHttpRequest).dispatchEvent);

  // Map from CRUD to HTTP for our default `Backbone.sync` implementation.
  var methodMap = {
    'create': 'POST',
    'update': 'PUT',
    'patch':  'PATCH',
    'delete': 'DELETE',
    'read':   'GET'
  };

  // Set the default implementation of `Backbone.ajax` to proxy through to `$`.
  // Override this if you'd like to use a different library.
  Backbone.ajax = function() {
    return Backbone.$.ajax.apply(Backbone.$, arguments);
  };

  // Backbone.Router
  // ---------------

  // Routers map faux-URLs to actions, and fire events when routes are
  // matched. Creating a new one sets its `routes` hash, if not set statically.
  var Router = Backbone.Router = function(options) {
    options || (options = {});
    if (options.routes) this.routes = options.routes;
    this._bindRoutes();
    this.initialize.apply(this, arguments);
  };

  // Cached regular expressions for matching named param parts and splatted
  // parts of route strings.
  var optionalParam = /\((.*?)\)/g;
  var namedParam    = /(\(\?)?:\w+/g;
  var splatParam    = /\*\w+/g;
  var escapeRegExp  = /[\-{}\[\]+?.,\\\^$|#\s]/g;

  // Set up all inheritable **Backbone.Router** properties and methods.
  _.extend(Router.prototype, Events, {

    // Initialize is an empty function by default. Override it with your own
    // initialization logic.
    initialize: function(){},

    // Manually bind a single named route to a callback. For example:
    //
    //     this.route('search/:query/p:num', 'search', function(query, num) {
    //       ...
    //     });
    //
    route: function(route, name, callback) {
      if (!_.isRegExp(route)) route = this._routeToRegExp(route);
      if (_.isFunction(name)) {
        callback = name;
        name = '';
      }
      if (!callback) callback = this[name];
      var router = this;
      Backbone.history.route(route, function(fragment) {
        var args = router._extractParameters(route, fragment);
        callback && callback.apply(router, args);
        router.trigger.apply(router, ['route:' + name].concat(args));
        router.trigger('route', name, args);
        Backbone.history.trigger('route', router, name, args);
      });
      return this;
    },

    // Simple proxy to `Backbone.history` to save a fragment into the history.
    navigate: function(fragment, options) {
      Backbone.history.navigate(fragment, options);
      return this;
    },

    // Bind all defined routes to `Backbone.history`. We have to reverse the
    // order of the routes here to support behavior where the most general
    // routes can be defined at the bottom of the route map.
    _bindRoutes: function() {
      if (!this.routes) return;
      this.routes = _.result(this, 'routes');
      var route, routes = _.keys(this.routes);
      while ((route = routes.pop()) != null) {
        this.route(route, this.routes[route]);
      }
    },

    // Convert a route string into a regular expression, suitable for matching
    // against the current location hash.
    _routeToRegExp: function(route) {
      route = route.replace(escapeRegExp, '\\$&')
                   .replace(optionalParam, '(?:$1)?')
                   .replace(namedParam, function(match, optional) {
                     return optional ? match : '([^\/]+)';
                   })
                   .replace(splatParam, '(.*?)');
      return new RegExp('^' + route + '$');
    },

    // Given a route, and a URL fragment that it matches, return the array of
    // extracted decoded parameters. Empty or unmatched parameters will be
    // treated as `null` to normalize cross-browser behavior.
    _extractParameters: function(route, fragment) {
      var params = route.exec(fragment).slice(1);
      return _.map(params, function(param) {
        return param ? decodeURIComponent(param) : null;
      });
    }

  });

  // Backbone.History
  // ----------------

  // Handles cross-browser history management, based on either
  // [pushState](http://diveintohtml5.info/history.html) and real URLs, or
  // [onhashchange](https://developer.mozilla.org/en-US/docs/DOM/window.onhashchange)
  // and URL fragments. If the browser supports neither (old IE, natch),
  // falls back to polling.
  var History = Backbone.History = function() {
    this.handlers = [];
    _.bindAll(this, 'checkUrl');

    // Ensure that `History` can be used outside of the browser.
    if (typeof window !== 'undefined') {
      this.location = window.location;
      this.history = window.history;
    }
  };

  // Cached regex for stripping a leading hash/slash and trailing space.
  var routeStripper = /^[#\/]|\s+$/g;

  // Cached regex for stripping leading and trailing slashes.
  var rootStripper = /^\/+|\/+$/g;

  // Cached regex for detecting MSIE.
  var isExplorer = /msie [\w.]+/;

  // Cached regex for removing a trailing slash.
  var trailingSlash = /\/$/;

  // Cached regex for stripping urls of hash and query.
  var pathStripper = /[?#].*$/;

  // Has the history handling already been started?
  History.started = false;

  // Set up all inheritable **Backbone.History** properties and methods.
  _.extend(History.prototype, Events, {

    // The default interval to poll for hash changes, if necessary, is
    // twenty times a second.
    interval: 50,

    // Gets the true hash value. Cannot use location.hash directly due to bug
    // in Firefox where location.hash will always be decoded.
    getHash: function(window) {
      var match = (window || this).location.href.match(/#(.*)$/);
      return match ? match[1] : '';
    },

    // Get the cross-browser normalized URL fragment, either from the URL,
    // the hash, or the override.
    getFragment: function(fragment, forcePushState) {
      if (fragment == null) {
        if (this._hasPushState || !this._wantsHashChange || forcePushState) {
          fragment = this.location.pathname;
          var root = this.root.replace(trailingSlash, '');
          if (!fragment.indexOf(root)) fragment = fragment.slice(root.length);
        } else {
          fragment = this.getHash();
        }
      }
      return fragment.replace(routeStripper, '');
    },

    // Start the hash change handling, returning `true` if the current URL matches
    // an existing route, and `false` otherwise.
    start: function(options) {
      if (History.started) throw new Error("Backbone.history has already been started");
      History.started = true;

      // Figure out the initial configuration. Do we need an iframe?
      // Is pushState desired ... is it available?
      this.options          = _.extend({root: '/'}, this.options, options);
      this.root             = this.options.root;
      this._wantsHashChange = this.options.hashChange !== false;
      this._wantsPushState  = !!this.options.pushState;
      this._hasPushState    = !!(this.options.pushState && this.history && this.history.pushState);
      var fragment          = this.getFragment();
      var docMode           = document.documentMode;
      var oldIE             = (isExplorer.exec(navigator.userAgent.toLowerCase()) && (!docMode || docMode <= 7));

      // Normalize root to always include a leading and trailing slash.
      this.root = ('/' + this.root + '/').replace(rootStripper, '/');

      if (oldIE && this._wantsHashChange) {
        this.iframe = Backbone.$('<iframe src="javascript:0" tabindex="-1" />').hide().appendTo('body')[0].contentWindow;
        this.navigate(fragment);
      }

      // Depending on whether we're using pushState or hashes, and whether
      // 'onhashchange' is supported, determine how we check the URL state.
      if (this._hasPushState) {
        Backbone.$(window).on('popstate', this.checkUrl);
      } else if (this._wantsHashChange && ('onhashchange' in window) && !oldIE) {
        Backbone.$(window).on('hashchange', this.checkUrl);
      } else if (this._wantsHashChange) {
        this._checkUrlInterval = setInterval(this.checkUrl, this.interval);
      }

      // Determine if we need to change the base url, for a pushState link
      // opened by a non-pushState browser.
      this.fragment = fragment;
      var loc = this.location;
      var atRoot = loc.pathname.replace(/[^\/]$/, '$&/') === this.root;

      // Transition from hashChange to pushState or vice versa if both are
      // requested.
      if (this._wantsHashChange && this._wantsPushState) {

        // If we've started off with a route from a `pushState`-enabled
        // browser, but we're currently in a browser that doesn't support it...
        if (!this._hasPushState && !atRoot) {
          this.fragment = this.getFragment(null, true);
          this.location.replace(this.root + this.location.search + '#' + this.fragment);
          // Return immediately as browser will do redirect to new url
          return true;

        // Or if we've started out with a hash-based route, but we're currently
        // in a browser where it could be `pushState`-based instead...
        } else if (this._hasPushState && atRoot && loc.hash) {
          this.fragment = this.getHash().replace(routeStripper, '');
          this.history.replaceState({}, document.title, this.root + this.fragment + loc.search);
        }

      }

      if (!this.options.silent) return this.loadUrl();
    },

    // Disable Backbone.history, perhaps temporarily. Not useful in a real app,
    // but possibly useful for unit testing Routers.
    stop: function() {
      Backbone.$(window).off('popstate', this.checkUrl).off('hashchange', this.checkUrl);
      clearInterval(this._checkUrlInterval);
      History.started = false;
    },

    // Add a route to be tested when the fragment changes. Routes added later
    // may override previous routes.
    route: function(route, callback) {
      this.handlers.unshift({route: route, callback: callback});
    },

    // Checks the current URL to see if it has changed, and if it has,
    // calls `loadUrl`, normalizing across the hidden iframe.
    checkUrl: function(e) {
      var current = this.getFragment();
      if (current === this.fragment && this.iframe) {
        current = this.getFragment(this.getHash(this.iframe));
      }
      if (current === this.fragment) return false;
      if (this.iframe) this.navigate(current);
      this.loadUrl();
    },

    // Attempt to load the current URL fragment. If a route succeeds with a
    // match, returns `true`. If no defined routes matches the fragment,
    // returns `false`.
    loadUrl: function(fragment) {
      fragment = this.fragment = this.getFragment(fragment);
      return _.any(this.handlers, function(handler) {
        if (handler.route.test(fragment)) {
          handler.callback(fragment);
          return true;
        }
      });
    },

    // Save a fragment into the hash history, or replace the URL state if the
    // 'replace' option is passed. You are responsible for properly URL-encoding
    // the fragment in advance.
    //
    // The options object can contain `trigger: true` if you wish to have the
    // route callback be fired (not usually desirable), or `replace: true`, if
    // you wish to modify the current URL without adding an entry to the history.
    navigate: function(fragment, options) {
      if (!History.started) return false;
      if (!options || options === true) options = {trigger: !!options};

      var url = this.root + (fragment = this.getFragment(fragment || ''));

      // Strip the fragment of the query and hash for matching.
      fragment = fragment.replace(pathStripper, '');

      if (this.fragment === fragment) return;
      this.fragment = fragment;

      // Don't include a trailing slash on the root.
      if (fragment === '' && url !== '/') url = url.slice(0, -1);

      // If pushState is available, we use it to set the fragment as a real URL.
      if (this._hasPushState) {
        this.history[options.replace ? 'replaceState' : 'pushState']({}, document.title, url);

      // If hash changes haven't been explicitly disabled, update the hash
      // fragment to store history.
      } else if (this._wantsHashChange) {
        this._updateHash(this.location, fragment, options.replace);
        if (this.iframe && (fragment !== this.getFragment(this.getHash(this.iframe)))) {
          // Opening and closing the iframe tricks IE7 and earlier to push a
          // history entry on hash-tag change.  When replace is true, we don't
          // want this.
          if(!options.replace) this.iframe.document.open().close();
          this._updateHash(this.iframe.location, fragment, options.replace);
        }

      // If you've told us that you explicitly don't want fallback hashchange-
      // based history, then `navigate` becomes a page refresh.
      } else {
        return this.location.assign(url);
      }
      if (options.trigger) return this.loadUrl(fragment);
    },

    // Update the hash location, either replacing the current entry, or adding
    // a new one to the browser history.
    _updateHash: function(location, fragment, replace) {
      if (replace) {
        var href = location.href.replace(/(javascript:|#).*$/, '');
        location.replace(href + '#' + fragment);
      } else {
        // Some browsers require that `hash` contains a leading #.
        location.hash = '#' + fragment;
      }
    }

  });

  // Create the default Backbone.history.
  Backbone.history = new History;

  // Helpers
  // -------

  // Helper function to correctly set up the prototype chain, for subclasses.
  // Similar to `goog.inherits`, but uses a hash of prototype properties and
  // class properties to be extended.
  var extend = function(protoProps, staticProps) {
    var parent = this;
    var child;

    // The constructor function for the new subclass is either defined by you
    // (the "constructor" property in your `extend` definition), or defaulted
    // by us to simply call the parent's constructor.
    if (protoProps && _.has(protoProps, 'constructor')) {
      child = protoProps.constructor;
    } else {
      child = function(){ return parent.apply(this, arguments); };
    }

    // Add static properties to the constructor function, if supplied.
    _.extend(child, parent, staticProps);

    // Set the prototype chain to inherit from `parent`, without calling
    // `parent`'s constructor function.
    var Surrogate = function(){ this.constructor = child; };
    Surrogate.prototype = parent.prototype;
    child.prototype = new Surrogate;

    // Add prototype properties (instance properties) to the subclass,
    // if supplied.
    if (protoProps) _.extend(child.prototype, protoProps);

    // Set a convenience property in case the parent's prototype is needed
    // later.
    child.__super__ = parent.prototype;

    return child;
  };

  // Set up inheritance for the model, collection, router, view and history.
  Model.extend = Collection.extend = Router.extend = View.extend = History.extend = extend;

  // Throw an error when a URL is needed, and none is supplied.
  var urlError = function() {
    throw new Error('A "url" property or function must be specified');
  };

  // Wrap an optional error callback with a fallback error event.
  var wrapError = function(model, options) {
    var error = options.error;
    options.error = function(resp) {
      if (error) error(model, resp, options);
      model.trigger('error', model, resp, options);
    };
  };

}).call(this);

define("backbone", ["underscore"], (function (global) {
    return function () {
        var ret, fn;
        return ret || global.Backbone;
    };
}(this)));

/*global define */

define('grapher/bar-graph/bar-graph-model',['require','backbone'],function (require) {
  // Dependencies.
  var Backbone = require('backbone'),

      BarGraphModel = Backbone.Model.extend({
        defaults: {
          // Current value displayed by bar graph.
          value:     0,
          // Second value displayed by bar graph (using small triangle).
          // It can be used to show averaged or previous value.
          // null means that it shouldn't be displayed at all.
          secondValue: null,
          // Min value displayed.
          min: 0,
          // Max value displayed.
          max: 10,

          // Width of the bar graph (bar itself, labels, titles etc. are
          // NOT included).
          barWidth: "2em",

          // Height of the bar graph container (bar itself + small padding).
          height: "20em",

          // Graph title. You can also specify multiline title using array
          // of strings, e.g.:
          // ["Title", "Subtitle"]
          title: "",
          // Accepted values are "right", "top" and "bottom".
          titleOn: "right",
          // Color of the main bar.
          barColor:  "#e23c34",
          // Color of the area behind the bar.
          fillColor: "white",
          // Number of labels displayed on the left side of the graph.
          // This value is *only* a suggestion. The most clean
          // and human-readable values are used.
          // You can also specify value-label pairs, e.g.:
          // [
          //   {
          //     "value": 0,
          //     "label": "low"
          //   },
          //   {
          //     "value": 10,
          //     "label": "high"
          //   }
          // ]
          // Use 0 or null to disable labels completely.
          labels:          10,
          // Units symbol displayed next to labels.
          units: "",
          // Number of grid lines displayed on the bar.
          gridLines:      10,
          // Format of labels.
          // See the specification of this format:
          // https://github.com/mbostock/d3/wiki/Formatting#wiki-d3_format
          // or:
          // http://docs.python.org/release/3.1.3/library/string.html#formatspec
          labelFormat: "0.1f"
        }
      });

  return BarGraphModel;
});

/*global define, $ */

/**
 * Require this module to initialize Lab jQuery plugins.
 */
define('common/jquery-plugins',[],function () {
  /**
   * Allows to measure element when it isn't already added to the page.
   * @param  {Function} fn       Function which will be executed.
   * @param  {string}   selector jQuery selector.
   * @param  {Object}   parent   Element which will be used as a temporal container.
   * @return {*}                 Result of 'fn' execution.
   */
  $.fn.measure = function(fn, selector, parent) {
    var el, selection, result;
    el = $(this).clone(false);
    el.css({
      visibility: 'hidden',
      position: 'absolute'
    });
    el.appendTo(parent);
    if (selector) {
      selection = el.find(selector);
    } else {
      selection = el;
    }
    result = fn.apply(selection);
    el.remove();
    return result;
  };

  /**
   * Truncates text inside given element, so its width doesn't exceed specified
   * value (in pixels). Note that you *can* use this function even on elements
   * like <p> or <h1>, which quite often have width of its parent (not width of
   * their text). This function will create a new <span> element with the same
   * style as original text and use it to measure real width of the text.
   *
   * @param  {number} maxWidth Maximum allowed width of text.
   */
  $.fn.truncate = function (maxWidth) {
    var $el = $(this),
        $span = $('<span>'),
        width,
        newText;

    $span.text($el.text());
    $span.css({
      'font-size': $el.css('font-size'),
      'font-weight': $el.css('font-weight'),
      'white-space': 'nowrap',
      'visibility': 'hidden'
    });
    $span.appendTo($el.parent());

    width = $span.width();

    if (width > maxWidth) {
      newText = $span.text() + "...";
      $span.text(newText);
      while (width > maxWidth && newText.length > 3) {
        newText = $span.text().slice(0, -4) + "...";
        $span.text(newText);
        width = $span.width();
      }

      // Save original text content in title attribute,
      // so tooltip can be displayed.
      $el.attr("title", $el.text());
      // Update original element.
      $el.text(newText);
    }
    // Cleanup!
    $span.remove();
  };

 /**
  * jQuery alterClass plugin
  *
  * Remove element classes with wildcard matching. Optionally add classes:
  *   $( '#foo' ).alterClass( 'foo-* bar-*', 'foobar' )
  *
  * Copyright (c) 2011 Pete Boere (the-echoplex.net)
  * Free under terms of the MIT license: http://www.opensource.org/licenses/mit-license.php
  *
  * source: https://gist.github.com/peteboere/1517285
  */
  $.fn.alterClass = function (removals, additions) {
    var self = this;

    if ( removals.indexOf( '*' ) === -1 ) {
      // Use native jQuery methods if there is no wildcard matching
      self.removeClass( removals );
      return !additions ? self : self.addClass( additions );
    }

    var patt = new RegExp( '\\s' +
        removals.
          replace( /\*/g, '[A-Za-z0-9-_]+' ).
          split( ' ' ).
          join( '\\s|\\s' ) +
        '\\s', 'g' );

    self.each( function ( i, it ) {
      var cn = ' ' + it.className + ' ';
      while ( patt.test( cn ) ) {
        cn = cn.replace( patt, ' ' );
      }
      it.className = $.trim( cn );
    });

    return !additions ? self : self.addClass( additions );
  };

  /**
    * jQuery special event triggered when element is removed from DOM.
    * e.g. $('#element-id').on('destroyed', function () { console.log('destroyed!'); })
    */
  $.event.special.destroyed = {
    remove: function(o) {
      if (o.handler) {
        o.handler()
      }
    }
  };
});

/*global define, d3, $ */

define('grapher/bar-graph/bar-graph-view',['require','common/jquery-plugins','backbone'],function (require) {
  //  Dependencies.
      require('common/jquery-plugins');
  var Backbone  = require('backbone'),

      uid = 0,
      // Returns unique ID used by the bar graph view.
      getUID = function () {
        return uid++;
      },

      // Get real width SVG of element using bounding box.
      getRealWidth = function (d3selection) {
        return d3selection.node().getBBox().width;
      },

      // Bar graph scales itself according to the font size.
      // We assume some CANONICAL_FONT_SIZE. All values which should
      // be scaled, should use returned function.
      CANONICAL_FONT_SIZE = 16,
      getScaleFunc = function (fontSize) {
        var factor = fontSize / CANONICAL_FONT_SIZE;

        return function (val) {
          return val * factor;
        };
      },

      setupValueLabelPairs = function (yAxis, ticks) {
        var values = [],
            labels = {},
            i, len;

        for (i = 0, len = ticks.length; i < len; i++) {
          values[i] = ticks[i].value;
          labels[values[i]] = ticks[i].label;
        }

        yAxis
          .tickValues(values)
          .tickFormat(function (value) {
            return labels[value];
          });
      },

      getFormatFunc = function (formatString, unitsString) {
        var format = d3.format(formatString);
        return function (value) {
          return format(value) + " " + unitsString;
        };
      },

      BarGraphView = Backbone.View.extend({
        // Container is a DIV.
        tagName: "div",

        className: "bar-graph",

        initialize: function () {
          // Unique ID. Required to generate unique
          // gradient names.
          this.uid = getUID();

          this.$topArea = $('<div class="top-area">').appendTo(this.$el);

          // Create some SVG elements, which are constant and doesn't need to
          // be recreated each time during rendering.
          this.vis = d3.select(this.el).append("svg");
          this.defs = this.vis.append("defs");
          this.axisContainer = this.vis.append("g");
          this.fill = this.vis.append("rect");
          this.bar = this.vis.append("rect");
          this.gridContainer = this.vis.append("g");
          this.trianglePos = this.vis.append("g");
          this.traingle = this.trianglePos.append("polygon");
          this.titleContainer = this.vis.append("g");

          this.yScale = d3.scale.linear();
          this.heightScale = d3.scale.linear();
          this.yAxis = d3.svg.axis();

          this.scale = null;
          this.barWidth = null;

          this.$bottomArea = $('<div class="bottom-area">').appendTo(this.$el);

          // Register callbacks!
          this.model.on("change", this.modelChanged, this);
        },

        // Render whole bar graph.
        render: function () {
              // toJSON() returns all attributes of the model.
              // This is equivalent to many calls like:
              // property1 = model.get("property1");
              // property2 = model.get("property2");
              // etc.
          var options            = this.model.toJSON(),
              fontSize           = parseFloat(this.$el.css("font-size")),
              // Scale function.
              scale = this.scale = getScaleFunc(fontSize),
              renderLabels       = options.labels > 0 || options.labels.length > 0,
              // Basic padding (scaled).
              paddingTop         = renderLabels ? scale(8) : scale(3),
              paddingBottom      = renderLabels ? scale(8) : scale(3),

              offset = 0;

          // Set height of the most outer container.
          this.$el.outerHeight(options.height);

          this._setupHorizontalTitle();

          this.svgHeight = this.$el.height() - this.$topArea.height() - this.$bottomArea.height();

          // Setup SVG element.
          this.vis
            .attr({
              // Use some random width. At the end of rendering, it will be
              // updated to a valid value in ems (based on the graph content).
              "width":  600,
              "height": this.svgHeight
            });

          // Setup Y scale.
          this.yScale
            .domain([options.min, options.max])
            .range([this.svgHeight - paddingTop, paddingBottom])
            .clamp(true);

          // Setup scale used to translation of the bar height.
          this.heightScale
            .domain([options.min, options.max])
            .range([0, this.svgHeight - paddingTop - paddingBottom])
            .clamp(true);

          // Render elements from left to right.

          this.axisContainer.selectAll("*").remove();
          if (renderLabels) {
            // Setup Y axis.
            this.yAxis
              .scale(this.yScale)
              .tickValues(null)
              .tickPadding(0)
              .tickSize(0, 0, 0)
              .orient("left");

            if (typeof options.labels === "number") {
              // Just normal tics.
              this.yAxis
                .ticks(options.labels)
                .tickFormat(getFormatFunc(options.labelFormat, options.units));
            } else {
              // Array with value - label pairs.
              setupValueLabelPairs(this.yAxis, options.labels);
            }

            // Create and append Y axis.
            this.axisContainer.call(this.yAxis);

            offset += getRealWidth(this.axisContainer);

            this.axisContainer.attr("transform", "translate(" + offset + ")");

            offset += scale(5);
          }

          // Setup background of the bar.
          this.fill
            .attr({
              "width": options.barWidth,
              "height": this.heightScale(options.max),
              "x": offset,
              "y": this.yScale(options.max),
              "rx": "0.5em",
              "ry": "0.5em",
              "fill": this._getFillGradient(options.fillColor)
            });

          // Setup the main bar.
          this.bar
            .attr({
              "width": options.barWidth,
              "x": offset,
              "rx": "0.5em",
              "ry": "0.5em",
              "fill": this._getBarGradient(options.barColor)
            });

          this.barWidth = getRealWidth(this.fill);

          this.traingle
            .classed("triangle", true)
            .attr({
              "points": "15,-7 15,7 1,0",
              "transform": "translate(" + offset + ") scale(" + scale(1) + ")"
            });

          this._setupGrid(offset);

          offset += this.barWidth;

          offset = this._setupTitle(offset);

          // Convert final width in px into value in ems.
          // That ensures that the SVG will work well with semantic layout.
          this.vis.attr("width", (offset / fontSize) + "em");
          this.$el.css("min-width", (offset / fontSize) + "em");

          // work-around bug on iPad2 where container is not expanding in width
          // when SVG element rendered inside it
          // see: Bar graph rendering issues on iPad
          // https://www.pivotaltracker.com/story/show/47854951
          // This means while we are duplicating the current padding styles set
          // in _grapher.sass changes in desired style must be duplicated here.
          this.$el.css("min-width", (offset / fontSize + 0.8) + "em");

          // Finally, update displayed values.
          this.update();
        },

        // Updates only bar height.
        update: function () {
          var value       = this.model.get("value"),
              secondValue = this.model.get("secondValue");

          this.bar
            .attr("height", this.heightScale(value))
            .attr("y", this.yScale(value));

          if (typeof secondValue !== 'undefined' && secondValue !== null) {
            this.traingle.classed("hidden", false);
            this.trianglePos.attr("transform", "translate(0," + this.yScale(secondValue) + ")");
          } else {
            this.traingle.classed("hidden", true);
          }
        },

        // This function should be called whenever model attribute is changed.
        modelChanged: function () {
          var changedAttributes = this.model.changedAttributes(),
              count = 0,
              valChanged, secValChanged, name;

          // There are two possible cases:
          // - Only "value" or "secondValue" have changed, so update only values
          //   displays.
          // - Other attributes have changed, so redraw whole bar graph.

          // Case 1. Check how many attributes have been changed.
          for (name in changedAttributes) {
            if (changedAttributes.hasOwnProperty(name)) {
              count++;
              if (count > 2) {
                // If 3 or more, redraw whole bar graph.
                this.render();
                return;
              }
            }
          }

          valChanged = typeof changedAttributes.value !== 'undefined';
          secValChanged = typeof changedAttributes.secondValue !== 'undefined';
          // Case 2. 1 or 2 attributes have changed, check if they are "value" and "secondValue".
          if ((count === 1 && (valChanged || secValChanged)) ||
              (count === 2 && (valChanged && secValChanged))) {
            this.update();
          } else {
            this.render();
          }
        },

        _getBarGradient: function (color) {
          var id = "bar-gradient-" + this.uid,
              gradient = this.defs.select("#" + id);

          color = d3.rgb(color);

          if (gradient.empty()) {
            // Create a new gradient.
            gradient = this.defs.append("linearGradient")
              .attr("id", id)
              .attr("x1", "0%")
              .attr("y1", "0%")
              .attr("x2", "0%")
              .attr("y2", "100%");
          } else {
            gradient.selectAll("stop").remove();
          }

          gradient.append("stop")
            .attr("stop-color", color.brighter(2).toString())
            .attr("offset", "0%");
          gradient.append("stop")
            .attr("stop-color", color.toString())
            .attr("offset", "100%");

          return "url(#" + id + ")";
        },

        _getFillGradient: function (color) {
          var id = "fill-gradient-" + this.uid,
              gradient = this.defs.select("#" + id);

          if (gradient.empty()) {
            // Create a new gradient.
            gradient = this.defs.append("linearGradient")
              .attr("id", id)
              .attr("x1", "0%")
              .attr("y1", "0%")
              .attr("x2", "0%")
              .attr("y2", "100%");
          } else {
            gradient.selectAll("stop").remove();
          }

          gradient.append("stop")
            .attr("stop-color", color)
            .attr("offset", "0%");
          gradient.append("stop")
            .attr("stop-color", color)
            .attr("stop-opacity", 0.5)
            .attr("offset", "15%");
          gradient.append("stop")
            .attr("stop-color", color)
            .attr("stop-opacity", 0.4)
            .attr("offset", "100%");

          return "url(#" + id + ")";
        },

        _setupGrid: function (offset) {
          var gridLines = this.yScale.ticks(this.model.get("gridLines")),
              yScale = this.yScale,
              width = this.barWidth;

          // Remove first and last tick, as we don't want to draw it as grid line.
          gridLines.pop(); gridLines.shift();
          this.grid = this.gridContainer.selectAll(".grid-line").data(gridLines, String),

          this.grid.enter().append("path").attr("class", "grid-line");
          this.grid.exit().remove();
          this.grid.attr("d", function (d) {
            return "M " + offset + " " + Math.round(yScale(d)) + " h " + width;
          });

          return offset;
        },

        // Setup vertical title.
        _setupTitle: function (offset) {
              // "title" option is expected to be string
              // or array of strings.
          var title = this.model.get("title"),
              self  = this,
              isArray, lines,
              titleG, gEnter;

          if (title && this.model.get("titleOn") === "right") {
            offset += this.scale(10);

            isArray = $.isArray(title);
            lines = isArray ? title.length : 1;

            titleG = this.titleContainer.selectAll(".title").data(isArray ? title : [title]);

            titleG.exit().remove();

            gEnter = titleG.enter().append("g").attr("class", "title");
            gEnter.append("title");
            gEnter.append("text");

            titleG.each(function (d, i) {
              var g = d3.select(this);
              g.select("title").text(d);
              g.select("text")
                .text(self._processTitle(d))
                .attr("dy", -(lines - i -1) + "em");
            });

            // Transform whole container.
            this.titleContainer.attr("transform",
              "translate(" + offset + ", " + this.svgHeight / 2 + ") rotate(90)");

            // Update offset.
            offset += parseFloat($(titleG.node()).css("font-size")) * lines;
          }

          return offset;
        },

        // Setup horizontal title.
        _setupHorizontalTitle: function () {
              // "title" option is expected to be string
              // or array of strings.
          var title = this.model.get("title"),
              pos = this.model.get("titleOn"),
              $container;

          this.$topArea.empty();
          this.$bottomArea.empty();

          if (!title || title.length === 0 || pos === "right") {
            return;
          }

          title = $.isArray(title) ? title : [title];

          if (pos === "top") {
            $container = this.$topArea;
          } else if (pos === "bottom") {
            $container = this.$bottomArea;
          }

          title.forEach(function (t) {
            $container.append('<p class="title">' + t + '</p>');
          });
        },

        _processTitle: function (title) {
          var $title = $('<span class="title">' + title + '</span>').appendTo(this.$el),
              truncatedText;

          $title.truncate(this.svgHeight);
          truncatedText = $title.text();
          $title.remove();
          return truncatedText;
        }
      });

  return BarGraphView;
});

/*global define */

/**
 * Tiny "mixin" that can be used by an interactive component.
 */
define('common/controllers/help-icon-support',[],function () {

  return function helpIconSupport(component, componentDef, helpSystem) {
    if (componentDef.helpIcon) {
      var $helpIcon = $('<i class="icon-question-sign lab-help-icon lab-component-help-icon"></i>');
      $helpIcon.on('click', function () {
        if (!helpSystem.isActive()) {
          helpSystem.showSingle(componentDef.id);
        }
      });
      $helpIcon.appendTo(component.getViewContainer());
    }
  };
});

/*global $: false, define: false */

// Bar graph controller.
// It provides specific interface used in MD2D environment
// (by interactives-controller and layout module).
define('common/controllers/bar-graph-controller',['require','grapher/bar-graph/bar-graph-model','grapher/bar-graph/bar-graph-view','common/controllers/interactive-metadata','common/controllers/help-icon-support','common/validator'],function (require) {
  var BarGraphModel   = require('grapher/bar-graph/bar-graph-model'),
      BarGraphView    = require('grapher/bar-graph/bar-graph-view'),
      metadata        = require('common/controllers/interactive-metadata'),
      helpIconSupport = require('common/controllers/help-icon-support'),
      validator       = require('common/validator'),

      // Note: We always explicitly copy properties from component spec to bar graph options hash,
      // in order to avoid tighly coupling an externally-exposed API (the component spec) to an
      // internal implementation detail (the bar graph options format).
      barGraphOptionForComponentSpecProperty = {
        // Min value displayed.
        min: 'min',
        // Max value displayed.
        max: 'max',
        // Graph title.
        title: 'title',
        // Title position.
        titleOn: 'titleOn',
        // Color of the main bar.
        barColor:  'barColor',
        // Color of the area behind the bar.
        fillColor: 'fillColor',
        // Number of labels displayed on the left side of the graph.
        // This value is *only* a suggestion. The most clean
        // and human-readable values are used.
        // You can also specify value-label pairs, e.g.:
        // [
        //   {
        //     "value": 0,
        //     "label": "low"
        //   },
        //   {
        //     "value": 10,
        //     "label": "high"
        //   }
        // ]
        // Use 0 or null to disable labels completely.
        labels:      'labels',
        // Number of grid lines displayed on the bar.
        // This value is *only* a suggestion, it's similar to 'ticks'.
        gridLines:  'gridLines',
        // Format of labels.
        // See the specification of this format:
        // https://github.com/mbostock/d3/wiki/Formatting#wiki-d3_format
        // or:
        // http://docs.python.org/release/3.1.3/library/string.html#formatspec
        labelFormat: 'labelFormat',
        // Units displayed next to labels. Set it to 'true' to use units
        // automatically retrieved from property description. Set it to any
        // string to use custom unit symbol.
        units: 'units'
      },

      // Limit options only to these supported.
      filterOptions = function(inputHash) {
        var options = {},
            cName, gName;

        for (cName in barGraphOptionForComponentSpecProperty) {
          if (barGraphOptionForComponentSpecProperty.hasOwnProperty(cName)) {
            gName = barGraphOptionForComponentSpecProperty[cName];
            if (inputHash[cName] !== undefined) {
              options[gName] = inputHash[cName];
            }
          }
        }
        return options;
      };

  return function BarGraphController(component, interactivesController) {
    var // Object with Public API.
        controller,
        model,
        // Model with options and current value.
        barGraphModel,
        // Main view.
        barGraphView,
        // First data channel.
        property,
        // Second data channel.
        secondProperty,

        update = function () {
          barGraphModel.set({value: model.get(property)});
        },

        updateSecondProperty = function () {
          barGraphModel.set({secondValue: model.get(secondProperty)});
        };

    function initialize() {
      model = interactivesController.getModel();

      // Validate component definition, use validated copy of the properties.
      component = validator.validateCompleteness(metadata.barGraph, component);
      barGraphModel = new BarGraphModel(filterOptions(component));
      barGraphView  = new BarGraphView({model: barGraphModel, id: component.id});
      // Each interactive component has to have class "component".
      barGraphView.$el.addClass("component");
      property = component.property;
      secondProperty = component.secondProperty;

      if (component.tooltip) {
        barGraphView.$el.attr("title", component.tooltip);
      }

      helpIconSupport(controller, component, interactivesController.helpSystem);
    }

    controller = {
      // This callback should be triggered when model is loaded.
      modelLoadedCallback: function () {
        var units = "";
        if (model) {
          model.removeObserver(property, update);
          if (secondProperty) {
            model.removeObserver(secondProperty, updateSecondProperty);
          }
        }
        model = interactivesController.getModel();
        // Register properties listeners.
        model.addPropertiesListener([property], update);
        if (typeof component.averagePeriod !== 'undefined' && component.averagePeriod !== null) {
          // This option is for authors convenience. It causes that filtered
          // output is automatically defined (it uses basic property as an
          // input). Author doesn't have to define it manually.
          secondProperty = property + "-bargraph-" + component.id + "-average";
          model.defineFilteredOutput(secondProperty, {}, property, "RunningAverage", component.averagePeriod);
        }
        if (secondProperty) {
          model.addPropertiesListener([secondProperty], updateSecondProperty);
        }
        // Retrieve and set units if they are enabled.
        if (component.units === true) {
          // Units automatically retrieved from property description.
          units = model.getPropertyDescription(property).getUnitAbbreviation();
        } else if (component.units) {
          // Units defined in JSON definition explicitly.
          units = component.units;
        }
        // Apply custom width and height settings.
        // Do it in modelLoadedCallback, as during its execution,
        // the view container is already added to the document and
        // calculations of the size work correctly.
        // Also, pass calculated unit type.
        barGraphModel.set({
          barWidth: component.barWidth,
          height: component.height,
          units: units
        });
        // Initial render...
        barGraphView.render();
        // and update.
        update();
      },

      // Returns view container (div).
      getViewContainer: function () {
        return barGraphView.$el;
      },

      // Method required by layout module.
      resize: function () {
        // Just render bar graph again.
        barGraphView.render();
      },

      // Returns serialized component definition.
      serialize: function () {
        var result = $.extend(true, {}, component);
        // Return updated definition.
        return result;
      }
    };

    initialize();

    // Return Public API object.
    return controller;
  };
});

/*global define, $*/

define('common/controllers/graph-controller',['require','lab-grapher','common/controllers/interactive-metadata','common/validator','common/listening-pool','common/controllers/data-set','common/controllers/help-icon-support'],function (require) {
  var Graph           = require('lab-grapher'),
      metadata        = require('common/controllers/interactive-metadata'),
      validator       = require('common/validator'),
      ListeningPool   = require('common/listening-pool'),
      DataSet         = require('common/controllers/data-set'),
      helpIconSupport = require('common/controllers/help-icon-support'),

      // Note: We always explicitly copy properties from component spec to grapher options hash,
      // in order to avoid tighly coupling an externally-exposed API (the component spec) to an
      // internal implementation detail (the grapher options format).
      grapherOptionForComponentSpecProperty = {
        title: 'title',
        titlePosition: 'titlePosition',
        buttonsStyle: 'buttonsStyle',
        buttonsLayout: 'buttonsLayout',
        enableAutoScaleButton: 'enableAutoScaleButton',
        enableAxisScaling: 'enableAxisScaling',
        enableZooming: 'enableZooming',
        autoScaleX: 'autoScaleX',
        autoScaleY: 'autoScaleY',
        enableSelectionButton: 'enableSelectionButton',
        clearSelectionOnLeavingSelectMode: 'clearSelectionOnLeavingSelectMode',
        enableDrawButton: 'enableDrawButton',
        drawIndex: 'drawIndex',
        dataPoints: 'dataPoints',
        markAllDataPoints: 'markAllDataPoints',
        showRulersOnSelection: 'showRulersOnSelection',
        fontScaleRelativeToParent: 'fontScaleRelativeToParent',
        hideAxisValues: 'hideAxisValues',
        xlabel: 'xlabel',
        xmin: 'xmin',
        xmax: 'xmax',
        ylabel: 'ylabel',
        ymin: 'ymin',
        ymax: 'ymax',
        lineWidth: 'lineWidth',
        xTickCount: 'xTickCount',
        yTickCount: 'yTickCount',
        xscaleExponent: 'xscaleExponent',
        yscaleExponent: 'yscaleExponent',
        xFormatter: 'xFormatter',
        yFormatter: 'yFormatter',
        lines: 'lines',
        bars: 'bars',
        dataColors: 'dataColors',
        legendLabels: 'legendLabels',
        legendVisible: 'legendVisible'
      },

      graphControllerCount = 0,

      // Index of the model property whose description sets the current X/Y label
      // (when labels aren't provided explicitly in graph component description).
      X_LABEL_PROP_IDX = 0,
      Y_LABEL_PROP_IDX = 0;

  return function graphController(component, interactivesController) {
    var // HTML element containing view
        $container,
        grapher,
        controller,
        dataSet,
        scriptingAPI,
        xProperties,
        properties,
        dataPointsArrays = [],
        staticSeries,
        listeningPool,
        ignoreDataSetEvents = false,
        suppressDomainSync = false,
        namespace = "graphController" + (++graphControllerCount);

    function getModel () {
      return interactivesController.getModel();
    }

    // Returns true if label is defined explicitly (it's defined and different from "auto").
    function isLabelExplicit(label) {
      return label != null && label !== "auto";
    }

    function loadDataSet () {
      // Get public data set (if its name is provided) or create own, private data set that will
      // be used only by this graph.
      if (component.dataSet) {
        dataSet = interactivesController.getDataSet(component.dataSet);
      } else {
        // Make sure that properties passed to data set include xProperty!
        var dataSetProperties = component.properties.slice();
        xProperties.forEach(function (xProp) {
          if (dataSetProperties.indexOf(xProp) === -1) {
            dataSetProperties.push(xProp);
          }
        });
        dataSet = new DataSet({
                                properties:          dataSetProperties,
                                name:                component.id + "-autoDataSet",
                                streamDataFromModel: component.streamDataFromModel,
                                clearOnModelReset:   component.clearOnModelReset
                              }, interactivesController, true);
      }
      listeningPool.listen(dataSet, DataSet.Events.DATA_RESET,        _dataResetHandler);
      listeningPool.listen(dataSet, DataSet.Events.SAMPLE_ADDED,      _sampleAddedHandler);
      listeningPool.listen(dataSet, DataSet.Events.SAMPLE_CHANGED,    _sampleChangedHandler);
      listeningPool.listen(dataSet, DataSet.Events.SAMPLE_REMOVED,    _sampleRemovedHandler);
      listeningPool.listen(dataSet, DataSet.Events.SELECTION_CHANGED, _selectionChangeHandler);
      listeningPool.listen(dataSet, DataSet.Events.DATA_TRUNCATED,    _invalidationHandler);
      listeningPool.listen(dataSet, DataSet.Events.LABELS_CHANGED,    _labelsChangedHandler);
    }

    function initialize() {
      scriptingAPI = interactivesController.getScriptingAPI();
      listeningPool = new ListeningPool(namespace);
      // Validate component definition, use validated copy of the properties.
      component = validator.validateCompleteness(metadata.graph, component);
      // The list of properties we are being asked to graph.
      properties = component.properties.slice();
      xProperties = component.xProperty;
      if (!$.isArray(xProperties)) {
        xProperties = [xProperties];
      }
      loadDataSet();
      $container = $('<div>').attr('id', component.id).addClass('graph');
      // Each interactive component has to have class "component".
      $container.addClass("component");
      // Apply custom width and height settings.
      $container.css({
        width: component.width,
        height: component.height
      });
      if (component.tooltip) {
        $container.attr("title", component.tooltip);
      }
      // Support optional add help icon.
      helpIconSupport(controller, component, interactivesController.helpSystem);

      staticSeries = [];

      if (component.drawProperty) {
        component.drawIndex = properties.indexOf(component.drawProperty);
        if (component.drawIndex == -1) {
          component.drawProperty = properties[0];
          component.drawIndex = 0;
        }
      }

      // Initial setup of the data.
      dataSet.resetData();
    }

    /**
      Return an options hash for use by the grapher.
    */
    function getOptions() {
      var options = {},
          cProp,
          gOption;

      // update grapher options from component spec & defaults
      for (cProp in grapherOptionForComponentSpecProperty) {
        if (grapherOptionForComponentSpecProperty.hasOwnProperty(cProp)) {
          gOption = grapherOptionForComponentSpecProperty[cProp];
          options[gOption] = component[cProp];
        }
      }

      // These options are specific for Lab and require some more work that just copying
      // values.
      if (component.syncXAxis) {
        setupAxisSync('x', component.syncXAxis, options);
      }
      if (component.syncYAxis) {
        setupAxisSync('y', component.syncYAxis, options);
      }

      return options;
    }

    function setupAxisSync(axis, syncedGraphs, options) {
      var callbackName = 'on'  + axis.toUpperCase() + 'DomainChange'; // e.g. onXDomainChange
      var setterName   = 'set' + axis.toUpperCase() + 'Domain';       // e.g. setXDomain
      if (typeof(syncedGraphs) === 'string') {
        syncedGraphs = [syncedGraphs];
      }
      options[callbackName] = function(min, max) {
        if (suppressDomainSync) return;
        syncedGraphs.forEach(function(syncedGraphID) {
          var syncedGraph = interactivesController.getComponent(syncedGraphID);
          // Third argument (true) ensures that synchronization will be suppressed in target graph.
          // It prevents us from creating infinite loop when we have two-way synchronization.
          syncedGraph[setterName](min, max, true);
        });
      }
    }

    /**
      Causes the graph to move the "current" pointer to the current model step. This desaturates
      the graph region corresponding to times after the current point.
    */
    function redrawCurrentStepPointer(step) {
      grapher.updateOrRescale(step);
    }
    function _selectionChangeHandler(evt) {
      if (ignoreDataSetEvents) return;
      redrawCurrentStepPointer(evt.data);
    }

    function resetGraph() {
      if (grapher) {
        if (component.resetAxesOnReset) {
          resetGrapher();
        }
      } else {
        initGrapher();
      }
      clearGrapher(dataSet.getData());
      updateLabels();
    }
    function _modelResetHandler() {
      resetGraph();
    }

    /**
      Reset all the datapoints in the graph.
      dataSeriesArry will contain an empty data set, or invitial values
      for all model params.
    */
    function clearGrapher(data) {
      if (!grapher) return;
      // Convert data received from data set to data format expected by grapher (nested arrays).
      var gData = [];
      properties.forEach(function (prop, idx) {
        var gSeries = [];
        var xArr = data[xProp(idx)];
        var propArr = data[prop];
        for (var i = 0, len = Math.min(xArr.length, propArr.length); i < len; i++) {
          gSeries.push([xArr[i], propArr[i]]);
        }
        gData.push(gSeries);
      });

      // Append static data series!
      gData = gData.concat(staticSeries);

      grapher.resetPoints(gData);
      grapher.repaint();
    }

    function _dataResetHandler(extra) {
      if (ignoreDataSetEvents) return;
      clearGrapher(extra.data);
    }
    function _invalidationHandler(extra) {
      if (ignoreDataSetEvents) return;
      clearGrapher(extra.data);
    }
    function _labelsChangedHandler(labels) {
      if (ignoreDataSetEvents) return;
      var labelWasChanged = false;
      if (!isLabelExplicit(component.ylabel)) {
        // Set label provided by dataset only if graph component description doesn't specify ylabel.
        var yProp = properties[Y_LABEL_PROP_IDX];

        // If the change is triggered via listener, the values will be wrapped in the 'data' property...
        var yLabel = labels[yProp] || labels.data[yProp];
        grapher.yLabel(yLabel);
        labelWasChanged = true;
      }
      if (!isLabelExplicit(component.xlabel)) {
        var xProp = xProperties[X_LABEL_PROP_IDX];
        var xLabel = labels[xProp] || labels.data[xProp];
        grapher.xLabel(xLabel);
        labelWasChanged = true;
      }
      if (labelWasChanged) {
        controller.syncAxisRangesToPropertyRanges();
      }
    }

    /**
      Ask the grapher to reset itself, without adding new data.
    */
    function resetGrapher() {
      grapher.reset('#' + component.id, getOptions());
    }

    function isPointValid(point) {
      var x = point[0];
      var y = point[1];
      return x != null && x !== "" && !isNaN(Number(x)) &&
             y != null && y !== "" && !isNaN(Number(y));
    }

    function xProp(idx) {
      return xProperties[idx] || xProperties[0];
    }

    function _sampleAddedHandler(evt) {
      if (!grapher) return;
      if (ignoreDataSetEvents) return;
      // Convert data received from data set to data expected by grapher (nested arrays).
      var valid = true;
      var dataPoint = evt.data;
      var gPoints = [];
      var point;
      properties.forEach(function (prop, idx) {
        point = [dataPoint[xProp(idx)], dataPoint[prop]];
        // Pass only valid points, null will be ignored by grapher.
        gPoints.push(isPointValid(point) ? point : null);
      });
      if (valid) grapher.addPoints(gPoints);
    }

    function _sampleChangedHandler(evt) {
      if (!grapher) return;
      if (ignoreDataSetEvents) return;
      var dataPoint = evt.data.dataPoint;
      var index = evt.data.index;
      var gPoints = [];
      var point;
      properties.forEach(function (prop, idx) {
        point = [dataPoint[xProp(idx)], dataPoint[prop]];
        // Pass only valid points, null will be ignored by grapher.
        gPoints.push(isPointValid(point) ? point : null);
      });
      grapher.replacePoints(gPoints, index);
    }

    function _sampleRemovedHandler(evt) {
      if (!grapher) return;
      if (ignoreDataSetEvents) return;
      var index = evt.data.index,
          props = evt.data.props;
      properties.forEach(function (prop, propIdx) {
        if (props.indexOf(prop) !== -1) {
          grapher.deletePoint(index, propIdx);
        }
      });
    }

    function registerModelListeners() {
      var model = getModel();
      // We reset the graph view after model reset.
      model.on('reset', _modelResetHandler);
    }

    function updateLabels() {
      _labelsChangedHandler(dataSet.getLabels());
    }

    function graphChangedDataPoint(evt) {
      ignoreDataSetEvents = true;
      var yPro = component.drawProperty || properties[0],
          xPro = xProp(properties.indexOf(yPro)),
          data = {};
      data[xPro] = evt.point[0];
      data[yPro] = evt.point[1];
      if (evt.action === "added") {
        dataSet.appendDataPoint([xPro, yPro], data);
      } else if (evt.action === "removed") {
        // Make sure that data has both X and Y values, so the point can be clearly identified.
        // X values don't have to be unique - grapher sometimes adds the same point twice...
        var idx = dataSet.dataPointIndex(data);
        // Remove only Y property value, X property can be shared.
        dataSet.removeDataPoint([yPro], idx);
      }
      ignoreDataSetEvents = false;
    }

    function initGrapher() {
      grapher = new Graph($container[0], getOptions(), undefined, interactivesController.getNextTabIndex());
      grapher.addPointListener(graphChangedDataPoint);
    }

    controller = {
      type: "graph",

      /**
        Called by the interactives controller when the model finishes loading.
      */
      modelLoadedCallback: function() {
        registerModelListeners();
        scriptingAPI = interactivesController.getScriptingAPI();
        resetGraph();
        grapher.repaint();
      },

      getDataSet: function() {
        return dataSet;
      },

      /**
        Used when manually adding points to the graph.
      */
      appendDataPropertiesToComponent: function() {
        dataSet.appendDataPoint();
      },


      /**
        Add non-realtime series to the dataSet.
      */
      addDataSet: function (series) {
        staticSeries.push(series);
      },

      /**
        Remove all non-realtime data series from the dataSets
      */
      clearDataSets: function () {
        staticSeries = [];
      },

      /**
        Modifies the current list of graph options with new values and resets the graph.the
        Note: does not support changes to the 'properties' list.
      */
      setAttributes: function(opts) {
        if (grapher) {
          $.extend(component, opts);
          dataSet.resetData();
          if (opts.dataPoints) {
            dataPointsArrays = opts.dataPoints;
          }
          resetGrapher();
          // We may have set or unset the explicit 'ylabel' / 'xlabel' options; update the graph's
          // labels as appropriate.
          updateLabels();
        }
      },

      /**
        Sets X domain of the graph without clearing the data.
      */
      setXDomain: function(min, max, suppressSync) {
        if (grapher) {
          suppressDomainSync = suppressSync;
          grapher.xDomain([min, max]);
          suppressDomainSync = false;
        }
      },

      /**
        Sets Y domain of the graph without clearing the data.
      */
      setYDomain: function(min, max, suppressSync) {
        if (grapher) {
          suppressDomainSync = suppressSync;
          grapher.yDomain([min, max]);
          suppressDomainSync = false;
        }
      },

      /**
        Adjusts axis ranges to match those of the properties the graph is reading from, without
        clearing data.

        Does nothing to the x-axis if the description of the xProperty has no min or max property.
        For the y-axis properties, finds the (min, max) pair that contains all property ranges,
        ignoring missing values for min or max, as long as at least one property has a min and one
        property has a max.
      */
      syncAxisRangesToPropertyRanges: function() {
        var model = getModel();
        var xDescription = model.getPropertyDescription(xProperties[X_LABEL_PROP_IDX]);
        var yDescriptions = properties.map(function(property) {
          return model.getPropertyDescription(property);
        });
        var ymin;
        var ymax;

        if (xDescription && xDescription.getMin() != null && xDescription.getMax() != null) {
          grapher.xDomain([xDescription.getMin(), xDescription.getMax()]);
        }

        ymin = Infinity;
        ymax = -Infinity;
        yDescriptions.forEach(function(description) {
          if (description) {
            if (description.getMin() < ymin) ymin = description.getMin();
            if (description.getMax() > ymax) ymax = description.getMax();
          }
        });

        if (isFinite(ymin) && isFinite(ymax)) {
          grapher.yDomain([ymin, ymax]);
        }
      },

      /**
        If the x=0 is not visible in the current x axis range, move the x-axis so that x=0 is
        present at the left of the graph, while keeping the current x axis scale and the y axis
        range.
      */
      scrollXAxisToZero: function() {
        var xmin = grapher.xmin();
        var xmax = grapher.xmax();

        if (xmin !== 0) {
          grapher.xDomain([0, xmax - xmin]);
        }
      },

      /**
        Returns the grapher object itself.
      */
      getView: function() {
        return grapher;
      },

      /**
        Returns a jQuery selection containing the div which contains the graph.
      */
      getViewContainer: function() {
        return $container;
      },

      resize: function () {
        // For now only "fit to parent" behavior is supported.
        if (grapher) {
          grapher.resize();
        }
      },

      reset: function () {
        if (grapher) {
          resetGrapher();
        }
      },

      update: function () {
        if (grapher) {
          grapher.update();
        }
      },

      selectionDomain: function() {
        if (grapher) {
          return grapher.selectionDomain.apply(grapher, arguments);
        }
        return null;
      },

      selectionEnabled: function() {
        if (grapher) {
          return grapher.selectionEnabled.apply(grapher, arguments);
        }
        return null;
      },

      addAnnotation: function(props) {
        if (grapher) {
          grapher.addAnnotation(props);
        }
      },

      resetAnnotations: function(){
        if (grapher) {
          grapher.resetAnnotations();
        }
      },

      /**
        Returns serialized component definition.
      */
      serialize: function () {
        // The only thing which needs to be updated is scaling of axes.
        // Note however that the serialized definition should always have
        // 'xmin' set to initial value, as after deserialization we assume
        // that there is no previous data and simulations should start from the beginning.
        var result = $.extend(true, {}, component),
            // Get current domains settings, e.g. after dragging performed by the user.
            // TODO: this should be reflected somehow in the grapher model,
            // not grabbed directly from the view as now. Waiting for refactoring.
            xDomain = grapher.xDomain(),
            yDomain = grapher.yDomain(),
            startX  = component.xmin;

        result.ymin = yDomain[0];
        result.ymax = yDomain[1];
        // Shift graph back to the original origin, but keep scale of the X axis.
        // This is not very clear, but follows the rule of least surprise for the user.
        result.xmin = startX;
        result.xmax = startX + xDomain[1] - xDomain[0];

        return result;
      },

      enableLogging: function (logFunc) {
        // If logging gets more complicated, I think we should move the logic to the grapher itself
        // and here just call something like: grapher.enableLogging(logFunc);
        $container.off('.logging');
        $container.on('click.logging', '.graph-button.legend', function () {
          logFunc('GraphKeyBtnClicked');
        });
        $container.on('click.logging', '.graph-button.autoscale', function () {
          logFunc('GraphZoomBtnClicked');
        });
      }
    };

    initialize();
    return controller;

  };
});

!function(e){"object"==typeof exports?module.exports=e():"function"==typeof define&&define.amd?define('iframe-phone',e):"undefined"!=typeof window?window.iframePhone=e():"undefined"!=typeof global?global.iframePhone=e():"undefined"!=typeof self&&(self.iframePhone=e())}(function(){var define,module,exports;return (function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);throw new Error("Cannot find module '"+o+"'")}var f=n[o]={exports:{}};t[o][0].call(f.exports,function(e){var n=t[o][1][e];return s(n?n:e)},f,f.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){
var structuredClone = require('./structured-clone');
var HELLO_INTERVAL_LENGTH = 200;
var HELLO_TIMEOUT_LENGTH = 60000;

function IFrameEndpoint() {
  var listeners = {};
  var isInitialized = false;
  var connected = false;
  var postMessageQueue = [];
  var helloInterval;

  function postToParent(message) {
    // See http://dev.opera.com/articles/view/window-postmessage-messagechannel/#crossdoc
    //     https://github.com/Modernizr/Modernizr/issues/388
    //     http://jsfiddle.net/ryanseddon/uZTgD/2/
    if (structuredClone.supported()) {
      window.parent.postMessage(message, '*');
    } else {
      window.parent.postMessage(JSON.stringify(message), '*');
    }
  }

  function post(type, content) {
    var message;
    // Message object can be constructed from 'type' and 'content' arguments or it can be passed
    // as the first argument.
    if (arguments.length === 1 && typeof type === 'object' && typeof type.type === 'string') {
      message = type;
    } else {
      message = {
        type: type,
        content: content
      };
    }
    if (connected) {
      postToParent(message);
    } else {
      postMessageQueue.push(message);
    }
  }

  function postHello() {
    postToParent({
      type: 'hello'
    });
  }

  function addListener(type, fn) {
    listeners[type] = fn;
  }

  function removeAllListeners() {
    listeners = {};
  }

  function getListenerNames() {
    return Object.keys(listeners);
  }

  function messageListener(message) {
    // Anyone can send us a message. Only pay attention to messages from parent.
    if (message.source !== window.parent) return;
    var messageData = message.data;
    if (typeof messageData === 'string') messageData = JSON.parse(messageData);

    if (!connected && messageData.type === 'hello') {
      connected = true;
      stopPostingHello();
      while (postMessageQueue.length > 0) {
        post(postMessageQueue.shift());
      }
    }

    if (connected && listeners[messageData.type]) {
      listeners[messageData.type](messageData.content);
    }
  }

  function disconnect() {
    connected = false;
    stopPostingHello();
    window.removeEventListener('message', messsageListener);
  }

  /**
    Initialize communication with the parent frame. This should not be called until the app's custom
    listeners are registered (via our 'addListener' public method) because, once we open the
    communication, the parent window may send any messages it may have queued. Messages for which
    we don't have handlers will be silently ignored.
  */
  function initialize() {
    if (isInitialized) {
      return;
    }
    isInitialized = true;
    if (window.parent === window) return;

    // We kick off communication with the parent window by sending a "hello" message. Then we wait
    // for a handshake (another "hello" message) from the parent window.
    startPostingHello();
    window.addEventListener('message', messageListener, false);
  }

  function startPostingHello() {
    if (helloInterval) {
      stopPostingHello();
    }
    helloInterval = window.setInterval(postHello, HELLO_INTERVAL_LENGTH);
    window.setTimeout(stopPostingHello, HELLO_TIMEOUT_LENGTH);
    // Post the first msg immediately.
    postHello();
  }

  function stopPostingHello() {
    window.clearInterval(helloInterval);
    helloInterval = null;
  }

  // Public API.
  return {
    initialize: initialize,
    getListenerNames: getListenerNames,
    addListener: addListener,
    removeAllListeners: removeAllListeners,
    disconnect: disconnect,
    post: post
  };
}

var instance = null;

// IFrameEndpoint is a singleton, as iframe can't have multiple parents anyway.
module.exports = function getIFrameEndpoint() {
  if (!instance) {
    instance = new IFrameEndpoint();
  }
  return instance;
};

},{"./structured-clone":4}],2:[function(require,module,exports){
var ParentEndpoint = require('./parent-endpoint');
var getIFrameEndpoint = require('./iframe-endpoint');

// Not a real UUID as there's an RFC for that (needed for proper distributed computing).
// But in this fairly parochial situation, we just need to be fairly sure to avoid repeats.
function getPseudoUUID() {
  var chars = 'abcdefghijklmnopqrstuvwxyz0123456789';
  var len = chars.length;
  var ret = [];

  for (var i = 0; i < 10; i++) {
    ret.push(chars[Math.floor(Math.random() * len)]);
  }
  return ret.join('');
}

module.exports = function IframePhoneRpcEndpoint(handler, namespace, targetWindow, targetOrigin, phone) {
  var pendingCallbacks = Object.create({});

  // if it's a non-null object, rather than a function, 'handler' is really an options object
  if (handler && typeof handler === 'object') {
    namespace = handler.namespace;
    targetWindow = handler.targetWindow;
    targetOrigin = handler.targetOrigin;
    phone = handler.phone;
    handler = handler.handler;
  }

  if (!phone) {
    if (targetWindow === window.parent) {
      phone = getIFrameEndpoint();
      phone.initialize();
    } else {
      phone = new ParentEndpoint(targetWindow, targetOrigin);
    }
  }

  phone.addListener(namespace, function (message) {
    var callbackObj;

    if (message.messageType === 'call' && typeof this.handler === 'function') {
      this.handler.call(undefined, message.value, function (returnValue) {
        phone.post(namespace, {
          messageType: 'returnValue',
          uuid: message.uuid,
          value: returnValue
        });
      });
    } else if (message.messageType === 'returnValue') {
      callbackObj = pendingCallbacks[message.uuid];

      if (callbackObj) {
        window.clearTimeout(callbackObj.timeout);
        if (callbackObj.callback) {
          callbackObj.callback.call(undefined, message.value);
        }
        pendingCallbacks[message.uuid] = null;
      }
    }
  }.bind(this));

  function call(message, callback) {
    var uuid = getPseudoUUID();

    pendingCallbacks[uuid] = {
      callback: callback,
      timeout: window.setTimeout(function () {
        if (callback) {
          callback(undefined, new Error("IframePhone timed out waiting for reply"));
        }
      }, 2000)
    };

    phone.post(namespace, {
      messageType: 'call',
      uuid: uuid,
      value: message
    });
  }

  function disconnect() {
    phone.disconnect();
  }

  this.handler = handler;
  this.call = call.bind(this);
  this.disconnect = disconnect.bind(this);
};

},{"./iframe-endpoint":1,"./parent-endpoint":3}],3:[function(require,module,exports){
var structuredClone = require('./structured-clone');

/**
  Call as:
    new ParentEndpoint(targetWindow, targetOrigin, afterConnectedCallback)
      targetWindow is a WindowProxy object. (Messages will be sent to it)

      targetOrigin is the origin of the targetWindow. (Messages will be restricted to this origin)

      afterConnectedCallback is an optional callback function to be called when the connection is
        established.

  OR (less secure):
    new ParentEndpoint(targetIframe, afterConnectedCallback)

      targetIframe is a DOM object (HTMLIframeElement); messages will be sent to its contentWindow.

      afterConnectedCallback is an optional callback function

    In this latter case, targetOrigin will be inferred from the value of the src attribute of the
    provided DOM object at the time of the constructor invocation. This is less secure because the
    iframe might have been navigated to an unexpected domain before constructor invocation.

  Note that it is important to specify the expected origin of the iframe's content to safeguard
  against sending messages to an unexpected domain. This might happen if our iframe is navigated to
  a third-party URL unexpectedly. Furthermore, having a reference to Window object (as in the first
  form of the constructor) does not protect against sending a message to the wrong domain. The
  window object is actualy a WindowProxy which transparently proxies the Window object of the
  underlying iframe, so that when the iframe is navigated, the "same" WindowProxy now references a
  completely differeent Window object, possibly controlled by a hostile domain.

  See http://www.esdiscuss.org/topic/a-dom-use-case-that-can-t-be-emulated-with-direct-proxies for
  more about this weird behavior of WindowProxies (the type returned by <iframe>.contentWindow).
*/

module.exports = function ParentEndpoint(targetWindowOrIframeEl, targetOrigin, afterConnectedCallback) {
  var postMessageQueue = [];
  var connected = false;
  var handlers = {};
  var targetWindowIsIframeElement;

  function getIframeOrigin(iframe) {
    return iframe.src.match(/(.*?\/\/.*?)\//)[1];
  }

  function post(type, content) {
    var message;
    // Message object can be constructed from 'type' and 'content' arguments or it can be passed
    // as the first argument.
    if (arguments.length === 1 && typeof type === 'object' && typeof type.type === 'string') {
      message = type;
    } else {
      message = {
        type: type,
        content: content
      };
    }
    if (connected) {
      var tWindow = getTargetWindow();
      // if we are laready connected ... send the message
      // See http://dev.opera.com/articles/view/window-postmessage-messagechannel/#crossdoc
      //     https://github.com/Modernizr/Modernizr/issues/388
      //     http://jsfiddle.net/ryanseddon/uZTgD/2/
      if (structuredClone.supported()) {
        tWindow.postMessage(message, targetOrigin);
      } else {
        tWindow.postMessage(JSON.stringify(message), targetOrigin);
      }
    } else {
      // else queue up the messages to send after connection complete.
      postMessageQueue.push(message);
    }
  }

  function addListener(messageName, func) {
    handlers[messageName] = func;
  }

  function removeListener(messageName) {
    handlers[messageName] = null;
  }

  // Note that this function can't be used when IFrame element hasn't been added to DOM yet
  // (.contentWindow would be null). At the moment risk is purely theoretical, as the parent endpoint
  // only listens for an incoming 'hello' message and the first time we call this function
  // is in #receiveMessage handler (so iframe had to be initialized before, as it could send 'hello').
  // It would become important when we decide to refactor the way how communication is initialized.
  function getTargetWindow() {
    if (targetWindowIsIframeElement) {
      var tWindow = targetWindowOrIframeEl.contentWindow;
      if (!tWindow) {
        throw "IFrame element needs to be added to DOM before communication " +
              "can be started (.contentWindow is not available)";
      }
      return tWindow;
    }
    return targetWindowOrIframeEl;
  }

  function receiveMessage(message) {
    var messageData;
    if (message.source === getTargetWindow() && (targetOrigin === '*' || message.origin === targetOrigin)) {
      messageData = message.data;
      if (typeof messageData === 'string') {
        messageData = JSON.parse(messageData);
      }
      if (handlers[messageData.type]) {
        handlers[messageData.type](messageData.content);
      } else {
        console.log("cant handle type: " + messageData.type);
      }
    }
  }

  function disconnect() {
    connected = false;
    window.removeEventListener('message', receiveMessage);
  }

  // handle the case that targetWindowOrIframeEl is actually an <iframe> rather than a Window(Proxy) object
  // Note that if it *is* a WindowProxy, this probe will throw a SecurityException, but in that case
  // we also don't need to do anything
  try {
    targetWindowIsIframeElement = targetWindowOrIframeEl.constructor === HTMLIFrameElement;
  } catch (e) {
    targetWindowIsIframeElement = false;
  }

  if (targetWindowIsIframeElement) {
    // Infer the origin ONLY if the user did not supply an explicit origin, i.e., if the second
    // argument is empty or is actually a callback (meaning it is supposed to be the
    // afterConnectionCallback)
    if (!targetOrigin || targetOrigin.constructor === Function) {
      afterConnectedCallback = targetOrigin;
      targetOrigin = getIframeOrigin(targetWindowOrIframeEl);
    }
  }

  // Handle pages served through file:// protocol. Behaviour varies in different browsers. Safari sets origin
  // to 'file://' and everything works fine, but Chrome and Safari set message.origin to null.
  // Also, https://developer.mozilla.org/en-US/docs/Web/API/Window/postMessage says:
  //  > Lastly, posting a message to a page at a file: URL currently requires that the targetOrigin argument be "*".
  //  > file:// cannot be used as a security restriction; this restriction may be modified in the future.
  // So, using '*' seems like the only possible solution.
  if (targetOrigin === 'file://') {
    targetOrigin = '*';
  }

  // when we receive 'hello':
  addListener('hello', function () {
    connected = true;

    // send hello response
    post({
      type: 'hello',
      // `origin` property isn't used by IframeEndpoint anymore (>= 1.2.0), but it's being sent to be
      // backward compatible with old IframeEndpoint versions (< v1.2.0).
      origin: window.location.href.match(/(.*?\/\/.*?)\//)[1]
    });

    // give the user a chance to do things now that we are connected
    // note that is will happen before any queued messages
    if (afterConnectedCallback && typeof afterConnectedCallback === "function") {
      afterConnectedCallback();
    }

    // Now send any messages that have been queued up ...
    while (postMessageQueue.length > 0) {
      post(postMessageQueue.shift());
    }
  });

  window.addEventListener('message', receiveMessage, false);

  // Public API.
  return {
    post: post,
    addListener: addListener,
    removeListener: removeListener,
    disconnect: disconnect,
    getTargetWindow: getTargetWindow,
    targetOrigin: targetOrigin
  };
};

},{"./structured-clone":4}],4:[function(require,module,exports){
var featureSupported = false;

(function () {
  var result = 0;

  if (!!window.postMessage) {
    try {
      // Safari 5.1 will sometimes throw an exception and sometimes won't, lolwut?
      // When it doesn't we capture the message event and check the
      // internal [[Class]] property of the message being passed through.
      // Safari will pass through DOM nodes as Null iOS safari on the other hand
      // passes it through as DOMWindow, gotcha.
      window.onmessage = function (e) {
        var type = Object.prototype.toString.call(e.data);
        result = (type.indexOf("Null") != -1 || type.indexOf("DOMWindow") != -1) ? 1 : 0;
        featureSupported = {
          'structuredClones': result
        };
      };
      // Spec states you can't transmit DOM nodes and it will throw an error
      // postMessage implimentations that support cloned data will throw.
      window.postMessage(document.createElement("a"), "*");
    } catch (e) {
      // BBOS6 throws but doesn't pass through the correct exception
      // so check error message
      result = (e.DATA_CLONE_ERR || e.message == "Cannot post cyclic structures.") ? 1 : 0;
      featureSupported = {
        'structuredClones': result
      };
    }
  }
}());

exports.supported = function supported() {
  return featureSupported && featureSupported.structuredClones > 0;
};

},{}],5:[function(require,module,exports){
module.exports = {
  /**
   * Allows to communicate with an iframe.
   */
  ParentEndpoint:  require('./lib/parent-endpoint'),
  /**
   * Allows to communicate with a parent page.
   * IFrameEndpoint is a singleton, as iframe can't have multiple parents anyway.
   */
  getIFrameEndpoint: require('./lib/iframe-endpoint'),
  structuredClone: require('./lib/structured-clone'),

  // TODO: May be misnamed
  IframePhoneRpcEndpoint: require('./lib/iframe-phone-rpc-endpoint')

};

},{"./lib/iframe-endpoint":1,"./lib/iframe-phone-rpc-endpoint":2,"./lib/parent-endpoint":3,"./lib/structured-clone":4}]},{},[5])
(5)
});
;
/*jshint eqnull: true */
/*global define */

define('import-export/dg-exporter',['require','lab.config','iframe-phone'],function(require) {

  var config  = require('lab.config');
  var iframePhone = require('iframe-phone');

  /*
    Private method. Listener for messages sent from CODAP via the iframePhone RPC endpoint.

    Currently, the only message from CODAP that we listen for is the 'codap-present' message
    indicating that we are embedded in an iframePhone-capable CODAP instance. When this message is
    received, `this.codapDidConnect` (a method to be added by client code) is invoked, if present.

    message:   message sent by iframePhone
    callback:  callback passed by iframePhone; must be called to acknowledge receipt of message
  */
  function codapCallbackHandler(message, callback) {
    var wasConnected;
    if (message && message.message === 'codap-present') {
      wasConnected = this.isCodapPresent;

      this.isCodapPresent = true;

      // Some simple (but very limited) zero-configuration event listening:
      if ( ! wasConnected  && typeof this.codapDidConnect === 'function' ) {
        this.codapDidConnect();
      }
    }
    callback();
  }

  var dgExporter = {

    gameName: 'Next Gen MW',

    parentTableLabels: {
      singleCase: "run",
      pluralCase: "runs",
      singleCaseWithArticle: "a run",
      setOfCases: "set",
      setOfCasesWithArticle: "a set"
    },

    childTableLabels: {
      singleCase: "measurement",
      pluralCase: "measurements",
      singleCaseWithArticle: "a measurement",
      setOfCases: "time series",
      setOfCasesWithArticle: "a time series"
    },

    singleTableLabels: {
      singleCase: "measurement",
      pluralCase: "measurements",
      singleCaseWithArticle: "a measurement",
      setOfCases: "set",
      setOfCasesWithArticle: "a set"
    },

    perRunColumnLabelCount: 0,
    perRunColumnLabelPositions: {},

    isCodapPresent: false,

    init: function() {
      if (this.codapPhone) return; // nothing to initialize
      this.codapPhone = new iframePhone.IframePhoneRpcEndpoint(
        codapCallbackHandler.bind(this),
        "codap-game",
        window.parent
      );
    },

    canCallDGDirect: function() {
      if (config.codap || config.dataGamesProxyPrefix) {
        try {
          if (window.parent.DG.doCommand) {
            return true;
          }
        } catch (e) {
          // could be a security exception if window.parent is not same-origin, or a ReferenceError
          // if the game controller isn't defined; in either case, fall through.
        }
      }
      return false;
    },

    isEmbeddedInCODAP: function() {
      return this.isCodapPresent || this.canCallDGDirect();
    },

    canExportData: function() {
      return this.isEmbeddedInCODAP();
    },

    doCommand: function(name, args, callback) {
      var cmd = {
        action: name,
        args: args
      };

      // Ensure the "direct" path follows an async execution pattern, because the iframePhone path
      // is unavoidably async. APIs that call back synchronously sometimes, async other times
      // release Zalgo: http://blog.izs.me/post/59142742143/designing-apis-for-asynchrony

      if (this.canCallDGDirect()) {
        setTimeout(function() {
          var result = window.parent.DG.doCommand(cmd);
          if (callback) {
            setTimeout(function() {
                callback(result);
            }, 1);
          }
        }, 1);
      } else if (this.isCodapPresent) {
        this.codapPhone.call(cmd, callback);
      }
    },

    /**
      Exports the summary data about a run as 1 CODAP table and exports timeseries data, if any, as
      a second, linked table.

      perRunLabels: list of column labels for the "left" table which contains a summary of the run
        (this can contain parameters that define the run, as well as )

      perRunData: list containing 1 row of data to be added to the left table

      timeSeriesLabels (optional): List of column labels for the "right" table which contains a
        set of time points that will be linked to the single row which is added to the "left", run-
        summary table

        If no timeSeriesLabels are provided, the linked "time series" table will not be created.

      timeSeriesData (optional): A list of lists, each of which contains 1 row of data to be added
      to the right table.

      This method automatically adds, as the first column of the run-summary table, a column
      labeled "Number of Time Points", which contains the number of time points in the timeseries
      that is associated with the run.

      Note: Call this method once per run, or row of data to be added to the left table.
      This method "does the right thing" if per-run column labels are added, removed, and/or
      reordered between calls to the method. However, currently, it does not handle the removal
      of time series labels (except from the end of the list) and it does not handle reordering of
      time series labels.
    */
    exportData: function(perRunLabels, perRunData, timeSeriesLabels, timeSeriesData) {
      timeSeriesLabels = timeSeriesLabels || [];

      var label,
          value,
          position,
          perRunColumnLabels = [],
          perRunColumnValues = [],
          timeSeriesColumnLabels = [],
          shouldExportTimeSeries,
          parentTableName,
          childTableName,
          i;

      // Extract metadata in the forms needed for export, ie values need to be an array of values,
      // labels need to be an array of {name: label} objects.
      // Furthermore note that during a DG session, the value for a given label needs to be in the
      // same position in the array every time the DG collection is 'created' (or reopened as the
      // case may be.)

      for (i = 0; i < perRunData.length; i++) {
        label = perRunLabels[i];
        value = perRunData[i];

        if ( this.perRunColumnLabelPositions[label] == null ) {
          this.perRunColumnLabelPositions[label] = this.perRunColumnLabelCount++;
        }
        position = this.perRunColumnLabelPositions[label];

        if (i === 0) {
          perRunColumnLabels[position] = { name: label, formula: "caseIndex" , type:"nominal"};
          perRunColumnValues[position] = null;
        } else {
          perRunColumnLabels[position] = { name: label };
          perRunColumnValues[position] = value;
        }
      }

      // Extract list of data column labels into form needed for export (needs to be an array of
      // name: label objects)
      for (i = 0; i < timeSeriesLabels.length; i++) {
        timeSeriesColumnLabels.push({ name: timeSeriesLabels[i] });
      }

      shouldExportTimeSeries = timeSeriesLabels.length > 0;

      // Export.

      if (shouldExportTimeSeries) {
        parentTableName = this.parentTableLabels.pluralCase;
        childTableName = this.childTableLabels.pluralCase;
      } else {
        parentTableName = this.singleTableLabels.pluralCase;
      }

      var collections = [{
        name: parentTableName,
        attrs: perRunColumnLabels,
        childAttrName: 'runs',
        labels: shouldExportTimeSeries ? this.parentTableLabels : this.singleTableLabels,
        collapseChildren: true
      }];

      if (shouldExportTimeSeries) {
        collections.push({
          name: childTableName,
          attrs: timeSeriesColumnLabels,
          labels: this.childTableLabels
        });
      }

      // Step 1. Tell DG we're a "game".
      this.doCommand('initGame', {
        name: this.gameName,
        collections: collections
      });

      // Step 4. Open a row in the parent table. This will contain the individual time series
      // readings as children.
      this.doCommand('openCase', {
        collection: parentTableName,
        values: perRunColumnValues
      }, function(parentCase) {

        // Step 5. Create rows in the child table for each data point. Using 'createCases' we can
        // do this inline, so we don't need to call openCase, closeCase for each row.
        if (shouldExportTimeSeries) {
          this.doCommand('createCases', {
            collection: childTableName,
            values: timeSeriesData,
            parent: parentCase.caseID
          });
        }

        // Step 6. Close the case.
        this.doCommand('closeCase', {
          collection: parentTableName,
          caseID: parentCase.caseID
        });
      }.bind(this));
    },

    /**
      Call this to cause DataGames to open the 'case table" containing the all the data exported by
      exportData() so far.
    */
    openTable: function() {
      this.doCommand('createComponent', {
        type: 'DG.TableView',
        log: false
      });
    },

    /**
      Call any time to log an event to DataGames
    */
    logAction: function(logString) {
      this.doCommand('logAction', {
        formatStr: logString
      });
    }
  };

  return dgExporter;
});

/*global define, $ */

define('common/controllers/basic-dialog',[],function () {

  var defOptions = {
    autoOpen: false,
    dialogClass: "interactive-dialog",
    width: "80%"
  };

  // E.g. "interactive-dialog" -> "InteractiveDialog".
  function titleizeClass(className) {
    return className.split('-').map(function(s) { return s[0].toUpperCase() + s.slice(1); }).join('');
  }

  /**
   * Simple wrapper around the jQuery UI Dialog,
   * which provides useful defaults and simple interface.
   *
   * @constructor
   * @param {Object} options jQuery UI Dialog options.
   */
  function BasicDialog(options, i18n) {
    /**
     * Basic dialog elements.
     * @type {jQuery}
     */
    var title = options.title || '';
    var id = options.id || '';

    this.$element = $('<div id="'+id+'" title="'+title+'">');
    // Create jQuery UI Dialog.
    options = $.extend({closeText: i18n.t("dialog.close_tooltip")}, defOptions, options)
    this.$element.dialog(options);
    this._eventNamePrefix = titleizeClass(options.dialogClass);
  }

  /**
   * Opens the dialog.
   */
  BasicDialog.prototype.open = function() {
    // Limit height of the content to 50% window height.
    this.$content.css("max-height", ($(window).height() * 0.5) + "px");
    this.$element.dialog("open");
  };

  /**
   * Closes the dialog.
   */
  BasicDialog.prototype.close = function() {
    this.$element.dialog("close");
  };

  /**
   * Sets jQuery UI Dialog option.
   *
   * @param {string} key
   * @param {Object} value
   */
  BasicDialog.prototype.set = function(key, value) {
    this.$element.dialog("option", key, value);
  };

  /**
   * Sets content of the dialog.
   *
   * @param {jQuery|DOM|string} content Any value that can be accepted by the jQuery.append.
   */
  BasicDialog.prototype.setContent = function (content) {
    // Wrap `content` in <div> so we can support raw HTML passed as a string.
    this.$content = $('<div>').append(content);
    this.$element.empty();
    // Not very pretty, but probably the simplest and most reliable way to
    // disable autofocus in jQuery UI dialogs. See:
    // http://jqueryui.com/upgrade-guide/1.10/#added-ability-to-specify-which-element-to-focus-on-open
    this.$element.append('<input type="hidden" autofocus="autofocus" />');
    this.$element.append(this.$content);
  };

  /**
   * Enables logging.
   *
   * @param {function} logFunc function that accepts action name and data
   */
  BasicDialog.prototype.enableLogging = function (logFunc) {
    var openTime = null;
    var eventNamePrefix = this._eventNamePrefix;
    this.$element.off('.logging');
    this.$element.on('dialogopen.logging', function () {
      logFunc(eventNamePrefix + 'Opened');
      openTime = Date.now();
    });
    this.$element.on('dialogclose.logging', function () {
      logFunc(eventNamePrefix + 'Closed', {wasOpenFor: (Date.now() - openTime) / 1000});
    });
  };

  return BasicDialog;
});

/*global define*/
/*jslint boss: true*/

define('common/controllers/export-controller',['require','import-export/dg-exporter','common/controllers/basic-dialog','common/dispatch-support','underscore'],function (require) {

  var dgExporter = require('import-export/dg-exporter');
  var BasicDialog = require('common/controllers/basic-dialog');
  var DispatchSupport = require('common/dispatch-support');
  var _ = require('underscore');

  function modalAlert(title, message, buttons, i18n) {
    var dialog = new BasicDialog({
      width: "60%",
      modal: true,
      id: 'exporter-modal-alert',
      title: title,
      buttons: buttons
    }, i18n);

    dialog.setContent(message);
    dialog.open();
  }

  // Handles CODAP data export. Also, defines a few new log events which are sent to parent when export is possible.
  // In such case it's using generic logAction method, but in practice LogController will talk to CODAP too.
  function ExportController(interactivesController) {
    var dispatch = new DispatchSupport(),
        spec,
        perRun,
        perTick,
        selectionComponents,
        perTickValues,
        controller,
        model,

        // used to compare initial parameters to parameters at export
        initialPerRunData,

        // Are we waiting for timeseries data, or just sending "parent level" data to one table?
        shouldExportTimeSeries = false,

        // Is the exporter set up and ready to allow the model to export data? The difference
        // between this and canExportData is that canExportData merely exposes the fact that we
        // are embedded in CODAP or some other target for our exported data. However
        // modelCanExportData indicates that the export controller has been initialized and is
        // attached to the current model.
        modelCanExportData = false,

        // Has exportData been called for this model since the last load or reset event?
        isUnexportedDataPresent = false,

        // Whether user needs to confirm (ok/cancel) if discarding data. Set by "don't ask again"
        // checkbox when discarding data the first time`
        askAboutDataDiscard = true,

        isInitialized = false;

    function getDataPoint() {
      var ret = [], i, len;

      for (i = 0, len = perTick.length; i < len; i++) {
        ret.push(model.get(perTick[i]));
      }
      return ret;
    }

    function resetData() {
      perTickValues = [getDataPoint()];
    }

    function appendDataPoint() {
      perTickValues.push(getDataPoint());
      // indicate that latest data hasn't been exported
      isUnexportedDataPresent = true;
    }

    function removeDataAfterStepPointer() {
      // Account for initial data, which corresponds to stepCounter == 0
      perTickValues.length = model.stepCounter() + 1;
    }

    function logAction(action, state) {
      var data;
      if (state) {
        // Convert list of labels and values into plain JS object.
        data = {};
        for (var i = 0; i < state.labels.length; i++) {
          data[state.labels[i]] = state.values[i];
        }
      }
      interactivesController.logAction(action, data);
    }

    function shouldHandleDataDiscard() {
      // If there's no unexported data, or we're not in the DG environment, never mind.
      return ExportController.canExportData() &&
        askAboutDataDiscard &&
        shouldExportTimeSeries &&
        isUnexportedDataPresent;
    }

    // Called when a model is about to be reset or reloaded, there is unexported data, and the user
    // has not asked to ignore data discard
    function handleDataDiscard(resetRequest) {

      // Yuck (UI in the controller layer), but here we go.
      modalAlert(
        "Discard data?",
        "<p>Pressing New Run without pressing Analyze Data will discard the current data. " +
        "Set up a new run without saving the data first?</p>" +
          "<input type='checkbox' id='dont-ask' name='dont-ask'></input>"+
          "<label for='dont-ask'>Don't show this message again</label>" , [
          {
            id: 'button-cancel',
            text: "Go back",
            click: function() {
              askAboutDataDiscard = ! $('#dont-ask').is(':checked');
              $(this).remove();
              resetRequest.cancel();
            }
          },
          {
            id: 'button-reset',
            text: "Discard the data",
            click: function() {
              logAction('DiscardedData', getCurrentPerRunData());
              askAboutDataDiscard = ! $('#dont-ask').is(':checked');
              $(this).remove();
              resetRequest.proceed();
            }
          }
        ],
        interactivesController.i18n
      );
    }

    // Called when exporting data; detects changes to per-run parameters since the model's initial
    // 'play' event and returns in a changelist form ready to be exported to the DG log.
    function getChangedParameterValues() {
      if (!initialPerRunData) {
        return false;
      }

      var currentPerRunData = getCurrentPerRunData();
      var changesList = { values: [], labels: [] };
      var anyChanged = false;

      currentPerRunData.values.forEach(function(currentValue, i) {
        var initialValue = initialPerRunData.values[i];
        var parameter = currentPerRunData.labels[i];
        var changed = initialValue !== currentValue;

        changesList.labels.push(parameter + ' changed?');
        changesList.values.push(changed);
        anyChanged = anyChanged || changed;

        changesList.labels.push(parameter + ' (start of run)');
        changesList.values.push(initialValue);

        changesList.labels.push(parameter + ' (sent to CODAP)');
        changesList.values.push(currentValue);
      });

      return anyChanged ? changesList : false;
    }

    function registerModelListeners() {
      // Namespace listeners to '.exportController' so we can eventually remove them all at once
      model.on('tick.exportController', appendDataPoint);
      model.on('reset.exportController', resetData);
      model.on('play.exportController', function() {
        removeDataAfterStepPointer();
        // Save the per-run parameters we see now -- we'll log if a user changes any parameters
        // before exporting the data
        if (!initialPerRunData) {
          initialPerRunData = getCurrentPerRunData();
        }
      });
      model.on('invalidation.exportController', removeDataAfterStepPointer);
    }

    function willResetModelHandler(modelToBeReset, resetRequest) {

      if (modelToBeReset !== model || !shouldHandleDataDiscard()) {
        // false lets interactives controller know it should not wait for a response from us
        return false;
      }

      // There's unexported data and we're supposed to ask the user about it.

      // put up the message and aynchronously wait for a response indicating whether or not to
      // continue with the reset.
      handleDataDiscard(resetRequest);

      // Let interactives controller know it should await our response
      return true;
    }

    function registerInteractiveListeners() {
      interactivesController.on('modelLoaded.exportController', function(cause) {
        handleModelInitialization('modelLoaded', cause);
      });

      interactivesController.on('modelReset.exportController', function(cause) {
        handleModelInitialization('modelReset', cause);
      });
      // Currently there is no need to namespace these particular listeners, because interactive
      // controller uses a *special* on() method that doesn't just delegate to d3.dispatch; in fact
      // it doesn't understand namespacing!
      interactivesController.on('willResetModel', willResetModelHandler);
    }

    function handleModelInitialization(eventName, cause) {

      function handleModelLoaded() {
        model = interactivesController.getModel();

        function propertyExists(p) {
          // (Don't write 'model.properties.hasOwnProperty' because we should eventually *remove*
          // hasOwnProperty and other Object.prototype methods from model.properties' prototype
          // chain -- as it stands there appears to be a model property called 'hasOwnPropety'.)
          return Object.prototype.hasOwnProperty.call(model.properties, p);
        }

        perRun  = (spec.perRun || []).filter(propertyExists);
        if (spec.perTick == null || spec.perTick.length === 0) {
          shouldExportTimeSeries = false;
          perTick = [];
        } else {
          shouldExportTimeSeries = true;
          perTick = ['displayTime'].concat(spec.perTick.filter(propertyExists));
        }

        resetData();
        registerModelListeners();

        if (cause === 'new-run') {
          logAction("SetUpNewRun");
        }

        initialPerRunData = null;
        isUnexportedDataPresent = false;
        if (controller.canExportData()) {
          modelCanExportData = true;
          dispatch.modelCanExportData();
        }
      }

      modelCanExportData = false;

      // Don't accumulate data or logs until we know we know there is somewhere to send the data.
      // (Note that CODAP, if present, will announce itself before the model can be started by the
      // user, so there should not be data loss.)
      if (controller.canExportData()) {
        handleModelLoaded();
      } else {
        controller.on('canExportData.export-controller', handleModelLoaded);
      }
    }

    function getCurrentPerRunData() {
      var state = {};

      state.labels = [];
      state.values = [];

      for (var i = 0; i < perRun.length; i++) {
        state.labels[i] = getLabelForProperty(perRun[i]);
        state.values[i] = model.get(perRun[i]);
      }
      return state;
    }

    function getLabelForProperty(property) {
      var desc  = model.getPropertyDescription(property),
          label = desc && desc.getLabel(),
          units = desc && desc.getUnitAbbreviation(),
          ret   = "";

      if (label && label.length > 0) {
        ret += label;
      } else {
        ret += property;
      }

      if (units && units.length > 0) {
        ret += " (";
        ret += units;
        ret += ")";
      }
      return ret;
    }

    controller = {

      // This just indicates the presence or absence of a technical means to export data (i.e.,
      // whether or not there is CODAP or some other data sink is present and listening for data)
      canExportData: function() {
        return ExportController.canExportData();
      },

      modelCanExportData: function() {
        return modelCanExportData;
      },

      // This indicates whether the default UI should allow data export. (This is advisory; custom
      // scripts can choose to call exportData() while ignoring this value)
      // Currently,
      //   * if the interactive's exports spec omits timeseries data, data can always be exported
      //   * if the interactive's exports spec includes timeseries data, the model must have been
      //     run, and it must now be stopped.
      dataAreAvailableForExport: function() {
        return ! shouldExportTimeSeries || (model.properties.hasPlayed && model.isStopped() && isUnexportedDataPresent);
      },

      isUnexportedDataPresent: function() {
        return isUnexportedDataPresent;
      },

      init: function(_spec) {
        spec = _spec;
        selectionComponents = (spec.selectionComponents || []).slice();

        isInitialized = true;
      },

      selectedData: function() {
        var i, component, domain, min = Infinity, max = -Infinity, outputData = [];

        if ( ! isInitialized ) {
          throw new Error("ExportController: selectData() was called before controller was initialized.");
        }

        for (i = 0; i < selectionComponents.length; i++) {
          component = interactivesController.getComponent(selectionComponents[i]);
          if (component && component.selectionDomain) {
            domain = component.selectionDomain();
            if (domain !== null && domain.length === 2) {
              if (min > domain[0]) {
                min = domain[0];
              }
              if (max < domain[1]) {
                max = domain[1];
              }
            }
          }
        }

        if (min < Infinity || max > -Infinity) {
          // filter the data to only that data which fails within this domain
          outputData = perTickValues.filter(function(point) {
            return point[0] > min && point[0] < max;
          });
        } else {
          outputData = perTickValues;
        }
        return outputData;
      },

      exportData: function() {
        var perRunPropertyLabels = [],
            perRunPropertyValues = [],
            perTickLabels = [],
            changedParameters,
            i;

        if ( ! isInitialized ) {
          throw new Error("ExportController: exportData() was called before controller was initialized.");
        }

        logAction("ExportedModel", getCurrentPerRunData());

        changedParameters = getChangedParameterValues();

        // Create a separate log event for the act of having changed parameters
        if (changedParameters) {
          logAction("ParameterChangeBetweenStartAndExport", changedParameters);
        }

        perRunPropertyLabels[0] = "Row";
        perRunPropertyValues[0] = null;

        for (i = 0; i < perRun.length; i++) {
          perRunPropertyLabels[i+1] = getLabelForProperty(perRun[i]);
          perRunPropertyValues[i+1] = model.get(perRun[i]);
        }

        for (i = 0; i < perTick.length; i++) {
          perTickLabels[i] = getLabelForProperty(perTick[i]);
        }

        dgExporter.exportData(perRunPropertyLabels, perRunPropertyValues, perTickLabels, this.selectedData());
        dgExporter.openTable();

        // all data was just exported
        isUnexportedDataPresent = false;
      }
    };

    // Setup

    dgExporter.init();

    // Issue an 'canExportData' event when canExportData() flips from false to true.
    // Issue 'modelCanExportData' when modelCanExportData() flips
    dispatch.mixInto(controller);
    dispatch.addEventTypes('canExportData', 'modelCanExportData');

    // Make sure we emit event if canExportData becomes true. Assume codap connects only once.
    dgExporter.codapDidConnect = function() {
      if ( ExportController.canExportData() ) {
        dispatch.canExportData();
      }
    };

    registerInteractiveListeners();

    return controller;
  }

  // "Class method" (want to be able to call this before instantiating)
  ExportController.canExportData = function() {
    return dgExporter.canExportData();
  };

  return ExportController;
});
/*global define*/
/*jslint boss: true*/

define('common/controllers/log-controller',['require','iframe-phone','import-export/dg-exporter'],function (require) {
  var iframePhone = require('iframe-phone');
  var dgExporter = require('import-export/dg-exporter');

  // Handles logging of events to LARA or CODAP.
  function LogController(args) {
    var config = args.config;
    this.enabled = config.enabled;
    // Use either provided list of properties bound to components (widgets) or list specified explicitly in config.
    this._properties = config.properties === 'boundToComponents' ? args.boundProperties : config.properties;
    this._interactivesController = args.interactivesController;
    this._model = null;
    
    // Two possible parents that listen to our logs - LARA or CODAP.
    this._phone = iframePhone.getIFrameEndpoint();
    // IFrameEndpoint is a singleton and probably has been already initialized by ParentMessageAPI,
    // but do it again just in case (so we don't depend on ParentMessageAPI).
    this._phone.initialize();
    dgExporter.init();
    
    this._interactivesController.on('modelLoaded.logController', this._modelLoadedHandler.bind(this));
    this._interactivesController.on('interactiveWillReload.logController', this._interactiveWillReloadHandler.bind(this));

    this._setupComponents(args.componentByID, config.components);
    this._enableLoggingIn(args.additionalComponents);
  }

  LogController.prototype.logAction = function (action, data) {
    if (!this.enabled) return;

    if (dgExporter.isEmbeddedInCODAP()) {
      this._logToCODAP(action, data);
    } else {
      this._genericLog(action, data);
    }
  };

  LogController.prototype._genericLog = function (action, data) {
    this._phone.post('log', {action: action, data: data});
  };

  LogController.prototype._logToCODAP = function (action, data) {
    var logString = action;
    if (data) {
      logString += ': ' + JSON.stringify(data);
    }
    dgExporter.logAction(logString);
  };

  LogController.prototype._setupComponents = function (componentByID, enabledComponents) {
    if (enabledComponents === 'none' || enabledComponents === []) return;
    if (enabledComponents === 'all') {
      enabledComponents = Object.keys(componentByID);
    }
    var componentsList = [];
    enabledComponents.forEach(function (compID) {
      componentsList.push(componentByID[compID]);
    });
    this._enableLoggingIn(componentsList);
  };

  LogController.prototype._enableLoggingIn = function (componentsList) {
    var logFunction = this.logAction.bind(this);
    componentsList.forEach(function (comp) {
      // Enable logging and provide function that component can use to log its own events.
      if (comp && comp.enableLogging) {
        comp.enableLogging(logFunction);
      }
    });
  };

  LogController.prototype._interactiveWillReloadHandler = function () {
    // We can log ReloadedInteractive before it actually happens, it's just simpler.
    this.logAction('ReloadedInteractive', this._getProperties());
  };

  LogController.prototype._modelLoadedHandler = function (cause) {
    this._model = this._interactivesController.getModel();

    this._model.on('log.logController', function (action, data) {
      // Models can log custom events too using dispatch. Just pass them to the parent.
      this.logAction(action, data);
    }.bind(this));

    this._model.on('play.logController', function () {
      this.logAction('StartedModel', this._getProperties());
    }.bind(this));

    this._model.on('stop.logController', function () {
      this.logAction('StoppedModel', this._getProperties());
    }.bind(this));

    this._model.on('willReset.logController', function() {
      // We can log ReloadedModel before it actually happens, it's just simpler.
      // Note that when user cancels reload (e.g. inside CODAP), this even is not emitted.
      this.logAction('ReloadedModel', this._getProperties());
    }.bind(this));
  };


  LogController.prototype._getProperties = function () {
    var model = this._model;
    var propData = {};
    function getLabelForProperty(property) {
      var desc = model.getPropertyDescription(property);
      var label = desc && desc.getLabel();
      var units = desc && desc.getUnitAbbreviation();
      var ret   = "";
      if (label && label.length > 0) {
        ret += label;
      } else {
        ret += property;
      }
      if (units && units.length > 0) {
        ret += " (" + units + ")";
      }
      return ret;
    }

    this._properties.forEach(function (prop) {
      propData[getLabelForProperty(prop)] = model.get(prop)
    });
    return propData;
  };

  return LogController;
});

/*global d3, $, define */
/*jshint loopfunc: true */

define('common/controllers/scripting-api',['require','common/alert'],function (require) {

  var alert = require('common/alert');
  var namespaceCount = 0;

  // This object is the outer context in which each script function is executed. This prevents at
  // least inadvertent reliance by the script on unintentinally exposed globals. Note that this
  // object is shared by the all instances of functions created in Scripting API context
  // (see makeFunctionInScriptContext).
  var shadowedGlobals = {};

  function errorForKey(key) {
    return function() {
      throw new ReferenceError(key + " is not defined");
    };
  }

  // Make shadowedGlobals contain keys for all globals (properties of 'window').
  // Also make set and get of any such property throw a ReferenceError exactly like
  // reading or writing an undeclared variable in strict mode.
  function setShadowedGlobals() {
    var keys = Object.getOwnPropertyNames(window),
        key,
        i,
        len,
        err;

    for (i = 0, len = keys.length; i < len; i++) {
      key = keys[i];
      if (!shadowedGlobals.hasOwnProperty(key)) {
        err = errorForKey(key);

        Object.defineProperty(shadowedGlobals, key, {
          set: err,
          get: err
        });
      }
    }
  }

  //
  // Define the scripting API used by 'action' scripts on interactive elements.
  //
  // The properties of the object below will be exposed to the interactive's
  // 'action' scripts as if they were local vars. All other names (including
  // all globals, but exluding Javascript builtins) will be unavailable in the
  // script context; and scripts are run in strict mode so they don't
  // accidentally expose or read globals.
  //
  return function ScriptingAPI (interactivesController, model) {

    // Note. Normally, scripting API methods should not create event listeners to be added to the
    // interactivesController, because doing so from an onLoad script results in adding a new event
    // listener per model load or reload. The interactivesController has no mechanism for
    // associating listeners with a particular model and removing them after load; that semantics is
    // handled by adding listeners directly to a model.

    // Ensure that we don't overwrite model.reset observers.
    // MUST. FIX. EVENT. OBSERVING. to get rid of this ridiculous unique id requirement!
    function onModelReset(callback) {
      model.on('reset.common-scripting-api-' + (namespaceCount++), callback);
    }

    var controller = {

      api: (function() {

        function isInteger(n) {
          // Exploits the facts that (1) NaN !== NaN, and (2) parseInt(Infinity, 10) is NaN
          return typeof n === "number" && (parseFloat(n) === parseInt(n, 10));
        }

        function isArray(obj) {
          return typeof obj === 'object' && obj.slice === Array.prototype.slice;
        }

        /** return a number randomly chosen between 0..max */
        function randomFloat(max) {
          if (max) {
            return Math.random() * max;
          } else {
            return Math.random();
          }
        }

        /** return an integer randomly chosen from the set of integers 0..n-1 */
        function randomInteger(n) {
          return Math.floor(Math.random() * n);
        }

        function swapElementsOfArray(array, i, j) {
          var tmp = array[i];
          array[i] = array[j];
          array[j] = tmp;
        }

        /** Return an array of n randomly chosen members of the set of integers 0..N-1 */
        function choose(n, N) {
          var values = [],
              i;

          for (i = 0; i < N; i++) { values[i] = i; }

          for (i = 0; i < n; i++) {
            swapElementsOfArray(values, i, i + randomInteger(N-i));
          }
          values.length = n;

          return values;
        }

        /* Send a tracking event to Google Analytics */
        function trackEvent(category, action, label) {
          var googleAnalytics;

          if (typeof _gaq === 'undefined'){
            // console.error("Google Analytics not defined, Can not send trackEvent");
            return;
          }
          googleAnalytics = _gaq;
          if (!category) {
            category = "Interactive";
          }
          // console.log("Sending a track page event Google Analytics (category:action:label):");
          // console.log("(" + category + ":"  + action + ":" + label + ")");
          googleAnalytics.push(['_trackEvent', category, action, label]);
        }

        return {
          isInteger: isInteger,
          isArray: isArray,
          randomInteger: randomInteger,
          randomFloat: randomFloat,
          swapElementsOfArray: swapElementsOfArray,
          choose: choose,

          deg2rad: Math.PI/180,
          rad2deg: 180/Math.PI,

          trackEvent: trackEvent,

          format: d3.format,

          get: function get() {
            return model.get.apply(model, arguments);
          },

          set: function set() {
            return model.set.apply(model, arguments);
          },

          freeze: function freeze() {
            return model.freeze.apply(model, arguments);
          },

          unfreeze: function unfreeze() {
            return model.unfreeze.apply(model, arguments);
          },

          /**
           * Logs custom event specified by author. Note that logging needs to be enabled in interactive JSON!
           * It means "logging": {"enabled": true} needs to be specified.
           * Log message will be sent to parent window, so parent window needs to handle it.
           * Currently, only LARA does it and sends logs to CC Log Manager App.
           *
           * @param {string} actionName
           * @param {object} data Hash of key-values that should be logged.
           */
          logAction: function logAction(actionName, data) {
            interactivesController.logAction(actionName, data);
          },

          // optional 'parameters' list of values to pass into the loaded model
          //
          // TODO remove optional parameter list when interactives have parameters that
          //      exist beyond model loading
          loadModel: function loadModel(modelId, parameters) {
            model.stop();
            interactivesController.loadModel(modelId, null, parameters);
          },

          getLoadedModelId: function getLoadedModel() {
            return interactivesController.getLoadedModelId();
          },

          /**
            Observe property `propertyName` on the model, and perform `action` when it changes.
            Pass property value to action.
          */
          onPropertyChange: function onPropertyChange(propertyName, action) {
            model.addPropertiesListener([propertyName], function() {
              action( model.get(propertyName) );
            });
          },

          /**
           * Performs a user-defined script at any given time.
           *
           * callAt(t, ...) guarantees that script will be executed, but not necessarily
           * at exactly chosen time (as this can be impossible due to simulation settings).
           * User scripts cannot interrupt the model "tick", the most inner integration loop.
           * e.g. callAt(23, ...) in MD2D model context will be executed at time 50,
           * if timeStepsPerTick = 50 and timeStep = 1.
           *
           * callAt action will occur when the model reaches the specified time and the simulation
           * is running at the moment. Note that just stepping forward and backward in time won't
           * trigger action again, but if you step back and start the simulation, then it will.
           *
           * @param  {number} time     Time defined in model native time unit (e.g. fs for MD2D).
           * @param  {function} action Function containing user-defined script.
           */
          callAt: function callAt(time, action) {
            function checkTime() {
              if (model.properties.time >= time) {
                action();
                stopChecking();
              }
            }

            function startChecking() {
              // addObserver(key, callback) is idempotent
              model.addObserver('time', checkTime);
            }

            function stopChecking() {
              model.removeObserver('time', checkTime);
            }

            function onStartHandler() {
              // This callback handles situation in which user moved back in time using tick
              // history and clicked play again. Setup checking again. Note that startChecking()
              // is idempotent so we can call it many times.
              if (model.properties.time < time) {
                startChecking();
              }
            }

            onModelReset(startChecking);
            this.onStart(onStartHandler);
            startChecking();
          },

          /**
           * Performs a user-defined script repeatedly, with a fixed time delay
           * between each call.
           *
           * callEvery(t, ...) guarantees that script will be executed *correct number of times*,
           * but not necessarily at exactly chosen intervals (as this can be impossible due to
           * simulation settings). User scripts cannot interrupt the model "tick", the most
           * inner integration loop.
           * e.g. callEvery(23, ...) in MD2D model context will be executed *twice* at time 50,
           * if timeStepsPerTick = 50 and timeStep = 1.
           *
           * callEvery action for time N * interval (for any integer N >= 1) will only be called
           * when the model time exceeds N * interval time. Note that just stepping forward and
           * backward in time won't trigger action again, but if you step back and start the
           * simulation, then it will.
           *
           * @param {number}   interval Interval on how often to execute the script,
           *                            defined in model native time unit (e.g. fs for MD2D).
           * @param {function} action   Function containing user-defined script.
           */
          callEvery: function callEvery(interval, action) {
            var lastCall = 0;

            function checkTime() {
              while (model.properties.time - lastCall >= interval) {
                action();
                lastCall += interval;
              }
            }

            function resetState() {
              lastCall = 0;
            }

            function onStartHandler() {
              // This callback handles situation in which user moved back in time using tick
              // history and clicked play again.
              while (lastCall > model.properties.time) {
                lastCall -= interval;
              }
            }

            model.addObserver('time', checkTime);
            onModelReset(resetState);
            this.onStart(onStartHandler);
          },

          /**
           * Sets a custom click handler for objects of a given type.
           * Basic type which is always supported is "background". It is empty
           * area of a model. Various models can support different clickable
           * types. Please see the model documentation to check what
           * other object types are supported.
           *
           * Behind the scenes this functions uses class selector. So you can
           * also inspect SVG image and check what is class of interesting
           * object and try to use it.
           *
           * MD2D specific notes:
           * Supported types: "background", "atom", "obstacle", "image", "textBox".
           * TODO: move it to MD2D related docs in the future.
           *
           * @param {string}   type    Name of the type of clickable objects.
           * @param {Function} handler Custom click handler. It will be called
           *                           when object is clicked with (x, y, d, i) arguments:
           *                             x - x coordinate in model units,
           *                             y - y coordinate in model units,
           *                             d - data associated with a given object (can be undefined!),
           *                             i - ID of clicked object (usually its value makes sense if d is defined).
           */
          onClick: function onClick(type, handler) {
            // Append '.' to make API simpler.
            // So authors can just specify onClick("atom", ...) instead of class selectors.
            interactivesController.modelController.modelContainer.setClickHandler("." + type, handler);
          },

          /**
           * Sets a custom drag handler for objects of a given type.
           * Drag handler will be executed after position of an object is updated due to user
           * dragging action, so custom handler can affect it (e.g. limit to only one axis), e.g:
           *
           *   onDrag("atom", function (x, y, i, d) {
           *     setAtomProperties(i, {y: 2});
           *   });
           *
           * MD2D specific notes:
           * only "atom" type is supported.
           *
           * @param {string}   type    Name of the type of draggable objects.
           * @param {Function} handler Custom drag handler. It will be called
           *                           when object is dragged with (x, y, d, i) arguments:
           *                             x - x coordinate in model units,
           *                             y - y coordinate in model units,
           *                             d - data associated with a given object (can be undefined!),
           *                             i - ID of an object (usually its value makes sense if d is defined).
           */
          onDrag: function onDrag(type, handler) {
            interactivesController.modelController.modelContainer.setDragHandler(type, handler);
          },

          /**
           * Sets custom select handler. It enables select action and lets author provide custom handler
           * which is executed when select action is finished. The area of selection is passed to handler
           * as arguments. It is defined by rectangle - its lower left corner coordinates, width and height.
           *
           * @param {Function} handler Custom select handler. It will be called
           *                           when select action is finished with (x, y, w, h) arguments:
           *                             x - x coordinate of lower left selection corner (in model units),
           *                             y - y coordinate of lower left selection corner (in model units),
           *                             width  - width of selection rectangle (in model units),
           *                             height - height of selection rectangle (in model units).
           */
          onSelect: function onSelect(handler) {
            interactivesController.modelController.modelContainer.setSelectHandler(handler);
          },

          setComponentDisabled: function setComponentDisabled(compID, v) {
            interactivesController.getComponent(compID).setDisabled(v);
          },

          /**
            Clears data set completely.
           */
          clearDataSet: function clearDataSet(name) {
            interactivesController.getDataSet(name).clearData();
          },

          /**
            Resets data sat to its initial data. When initial data is not provided, clears data
            set (in such case this function behaves exactly like .clearDataSet()).
           */
          resetDataSet: function resetDataSet(name) {
            interactivesController.getDataSet(name).resetData();
          },

          resetDataSetProperties: function resetDataSetProperties(name, props) {
            interactivesController.getDataSet(name).resetProperties(props);
          },

          /**
            Used when manually adding points to a graph or a table.
            Normally the graph or table property streamDataFromModel should be false
            when using this function.
          */
          appendDataPropertiesToComponent: function appendDataPropertiesToComponent(compID) {
            var comp = interactivesController.getComponent(compID);
            if (comp !== undefined) {
              comp.appendDataPropertiesToComponent();
            }
          },

          /**
            Change attributes of an existing component.

            WARNING: the current implementation of this function is very limited. Despite its
                     generic name, it only lets you change graph's attributes or button's label.
          */
          setComponentAttributes: function setComponentAttributes(componentID, opts) {
            var comp = interactivesController.getComponent(componentID);

            if (!comp) {
              throw new Error("Component " + componentID + " not found.");
            }
            if (typeof(comp.setAttributes) !== "function") {
              throw new Error("Component " + componentID + " does not support dynamic attributes change.");
            }
            comp.setAttributes(opts);
          },

          /**
            Set the ranges of graph component to match the ranges of the properties it is graphing.
          */
          syncAxisRangesToPropertyRanges: function syncAxisRangesToPropertyRanges(componentID) {
            var component = interactivesController.getComponent(componentID);

            if (!component) {
              throw new Error("Component " + componentID + " not found.");
            }
            if (!component.syncAxisRangesToPropertyRanges) {
              throw new Error("Component " + componentID + " does not support syncAxisRangesToPropertyRanges.");
            }

            component.syncAxisRangesToPropertyRanges();
          },

          scrollXAxisToZero: function scrollXAxisToZero(componentID) {
            var component = interactivesController.getComponent(componentID);

            if (!component) {
              throw new Error("Component " + componentID + " not found.");
            }
            if (!component.scrollXAxisToZero) {
              throw new Error("Component " + componentID + " does not support scrollXAxisToZero.");
            }

            component.scrollXAxisToZero();
          },

          resetGraphSelection: function resetGraphSelectionDomain(componentID) {
            var component = interactivesController.getComponent(componentID);

            if (!component) {
              throw new Error("Component " + componentID + " not found.");
            }
            if (!component.selectionDomain) {
              throw new Error("Component " + componentID + " does not support selectionDomain.");
            }
            if (!component.selectionEnabled) {
              throw new Error("Component " + componentID + " does not support selectionEnabled.");
            }

            component.selectionDomain(null);
            component.selectionEnabled(false);
          },

          addAnnotation: function addAnnotation(componentID, annotation) {
            var component = interactivesController.getComponent(componentID);

            if (!component) {
              throw new Error("Component " + componentID + " not found.");
            }
            if (!component.addAnnotation) {
              throw new Error("Component " + componentID + " does not support addAnnotation.");
            }

            component.addAnnotation(annotation);
          },

          resetAnnotations: function resetAnnotations(componentID) {
            var component = interactivesController.getComponent(componentID);

            if (!component) {
              throw new Error("Component " + componentID + " not found.");
            }
            if (!component.resetAnnotations) {
              throw new Error("Component " + componentID + " does not support resetAnnotations.");
            }

            component.resetAnnotations();
          },

          start: function start() {
            model.start();
            trackEvent('Interactive', "Start", "Starting interactive: " + interactivesController.get('title') );
          },

          onStart: function onStart(handler) {
            model.on("play.custom-script" + (namespaceCount++), handler);
          },

          stop: function stop() {
            model.stop();
          },

          onStop: function onStop(handler) {
            model.on("stop.custom-script", handler);
          },

          /**
           * Reload the model. The interactives controller will emit a 'willResetModel'.
           * The willResetModel observers can ask to wait for asynchronous confirmation before
           * the model is actually reloaded.
           * @param  {object} options hash of options, supported properties:
           *                         * propertiesToRetain - a list of properties to save before
           *                           the model reload and restore after reload.
           *                         * cause - cause of the reload action, it can be e.g. "reload"
           *                           or "new-run". It will be passed to "modelLoaded" event handlers.
           */
          reloadModel: function reloadModel(options) {
            interactivesController.reloadModel(options);
          },

          /**
           * Reload the interactive. The interactives controller will emit a 'willResetModel',
           * as obviously the interactive reload causes the model to be restored to its initial
           * state too. The willResetModel observers can ask to wait for asynchronous confirmation
           * before the interactive and model is actually reloaded.
           */
          reloadInteractive: function reloadInteractive() {
            interactivesController.reloadInteractive();
          },

          stepForward: function stepForward() {
            model.stepForward();
            if (!model.isNewStep()) {
              interactivesController.updateModelView();
            }
          },

          stepBack: function stepBack() {
            model.stepBack();
            interactivesController.updateModelView();
          },

          tick: function tick() {
            model.tick();
          },

          isStopped: function isStopped() {
            return model.isStopped();
          },

          getTime: function getTime() {
            return model.get('time');
          },

          /**
           * Returns number of frames per second.
           * @return {number} frames per second.
           */
          getFPS: function getFPS() {
            return model.getFPS();
          },

          /**
           * Returns "simulation progress rate".
           * It indicates how much of simulation time is calculated for
           * one second of real time.
           * @return {number} simulation progress rate.
           */
          getSimulationProgressRate: function getSimulationProgressRate() {
            return model.getSimulationProgressRate();
          },

          startPerformanceTuning: function startPerformanceTuning() {
            model.performanceOptimizer.enable();
          },

          repaint: function repaint() {
            interactivesController.repaintModelView();
          },

          canExportData: function canExportData() {
            var exportController = interactivesController.exportController;
            return exportController && exportController.canExportData() || false;
          },

          isUnexportedDataPresent: function isUnexportedDataPresent() {
            var exportController = interactivesController.exportController;
            return exportController && exportController.isUnexportedDataPresent() || false;
          },

          dataAreAvailableForExport: function dataAreAvailableForExport() {
            var exportController = interactivesController.exportController;
            return exportController && exportController.dataAreAvailableForExport() || false;
          },

          exportData: function exportData() {
            var exportController = interactivesController.exportController;
            if (!exportController || !exportController.canExportData()) {
              throw new Error("No exports have been specified.");
            }
            exportController.exportData();
          },

          getCardinalDirection: function getCardinalDirection(angle, inverse) {
            var direction = ["", ""];
            if (angle > Math.PI/8 && angle < Math.PI*7/8)
              direction[0] = inverse ? "S" : "N";
            else if (angle > Math.PI*9/8 && angle < Math.PI*15/8)
              direction[0] = inverse ? "N" : "S";
            if (angle < Math.PI*3/8 || angle > Math.PI*13/8) {
              direction[1] = inverse ? "W" : "E";
            } else if (angle > Math.PI*5/8 && angle < Math.PI*11/8) {
              direction[1] = inverse ? "E" : "W";
            }
            return direction.join("");
          },

          getCompassDirection: function getCompassDirection(angle, inverse) {
            angle = (angle + Math.PI*3/2) % (2*Math.PI);
            var deg = 360 - angle * 180 / Math.PI;
            return inverse ? (180 + deg) % 360 : deg;
          },

          Math: Math,
          Infinity: Infinity,
          isFinite: isFinite,
          NaN: NaN,
          isNaN: isNaN,

          // Prevent sandbox from overwriting window.undefined (this can still happen in browsers
          // that haven't implemented immutable undefined--mainly IE9, Safari 5)
          undefined: void 0,

          // Rudimentary debugging functionality. Use Lab alert helper function.
          alert: alert,

          // safe versions of setTimeout and setInterval
          setTimeout: function setTimeout(handler) {

            // Ensure that we don't leak "window" to handler function.
            if ( ! handler || handler.constructor !== Function ) {
              throw new TypeError("Must pass a Function instance to Lab's setTimeout.");
            }

            var args = Array.prototype.slice.apply(arguments);
            // By the spec, setTimeout explicitly sets the thisValue of the handler to global object
            // http://www.whatwg.org/specs/web-apps/current-work/multipage/webappapis.html#timers
            // (work through the "timer initialization steps" algorithm)
            // Ensure that the thisValue is undefined/null:
            args[0] = handler.bind(undefined);
            return window.setTimeout.apply(window, args);
          },

          setInterval: function setInterval(handler) {
            if ( ! handler || handler.constructor !== Function ) {
              throw new TypeError("Must pass a Function instance to Lab's setInterval.");
            }

            var args = Array.prototype.slice.apply(arguments);
            args[0] = handler.bind(undefined);
            return window.setInterval.apply(window, args);
          },

          clearTimeout:  window.clearTimeout,

          clearInterval: window.clearInterval,

          console: window.console !== null ? window.console : {
            log: function() {},
            error: function() {},
            warn: function() {},
            dir: function() {}
          }
        };
      }()),

      /**
       * Current model.
       */
      get model() {
        return model;
      },

      /**
       * InteractivesController instance.
       */
      get intController() {
        return interactivesController;
      },

      /**
       * Bind a new model to Scripting API.
       */
      bindModel: function (newModel) {
        model = newModel;
      },

      /**
        Freeze Scripting API
        Make the scripting API immutable once defined
      */
      freeze: function () {
        Object.freeze(this.api);
      },

      /**
        Extend Scripting API
      */
      extend: function (ModelScriptingAPI) {
        $.extend(this.api, new ModelScriptingAPI(this));
      },

      /**
        Allow console users to try script actions
      */
      exposeScriptingAPI: function () {
        window.script = this.api;
        window.script.run = function(source, args) {
          var prop,
              argNames = [],
              argVals = [];

          for (prop in args) {
            if (args.hasOwnProperty(prop)) {
              argNames.push(prop);
              argVals.push(args[prop]);
            }
          }
          return controller.makeFunctionInScriptContext.apply(null, argNames.concat(source)).apply(null, argVals);
        };
      },

      /**
        Given a script string, return a function that executes that script in a
        context containing *only* the bindings to names we supply.

        This isn't intended for XSS protection (in particular it relies on strict
        mode.) Rather, it's so script authors don't get too clever and start relying
        on accidentally exposed functionality, before we've made decisions about
        what scripting API and semantics we want to support.
      */
      makeFunctionInScriptContext: function () {
            // First n-1 arguments to this function are the names of the arguments to the script.
        var argumentsToScript = Array.prototype.slice.call(arguments, 0, arguments.length - 1),

            // Last argument is the function body of the script, as a string or array of strings.
            scriptSource = arguments[arguments.length - 1],

            scriptFunctionMakerSource,
            scriptFunctionMaker,
            scriptFunction;

        if (typeof scriptSource !== 'string') scriptSource = scriptSource.join('      \n');

        scriptFunctionMakerSource =
          "with (shadowedGlobals) {\n" +
          "  with (scriptingAPI) {\n" +
          "    return function(" + argumentsToScript.join(',') +  ") {\n" +
          "      'use " + "strict';\n" +
          "      " + scriptSource + "\n" +
          "    };\n" +
          "  }\n" +
          "}";

        try {
          scriptFunctionMaker = new Function('shadowedGlobals', 'scriptingAPI', scriptFunctionMakerSource);
          scriptFunction = scriptFunctionMaker(shadowedGlobals, controller.api);
        } catch (e) {
          alert("Error compiling script: \"" + e.toString() + "\"\nScript:\n\n" + scriptSource);
          return function() {
            throw new Error("Cannot run a script that could not be compiled");
          };
        }

        // This function runs the script with all globals shadowed:
        return function() {
          setShadowedGlobals();
          try {
            // invoke the script, passing only enough arguments for the whitelisted names
            return scriptFunction.apply(null, Array.prototype.slice.call(arguments));
          } catch (e) {
            alert("Error running script: \"" + e.toString() + "\"\nScript:\n\n" + scriptSource);
          }
        };
      }
    };

    return controller;
  };
});

/*global define: false */
/**
 * Inherit the prototype methods from one constructor into another.
 *
 * Usage:
 * function ParentClass(a, b) { }
 * ParentClass.prototype.foo = function(a) { }
 *
 * function ChildClass(a, b, c) {
 *   goog.base(this, a, b);
 * }
 *
 * inherit(ChildClass, ParentClass);
 *
 * var child = new ChildClass('a', 'b', 'see');
 * child.foo(); // works
 *
 * In addition, a superclass' implementation of a method can be invoked
 * as follows:
 *
 * ChildClass.prototype.foo = function(a) {
 *   ChildClass.superClass.foo.call(this, a);
 *   // other code
 * };
 *
 * @param {Function} Child Child class.
 * @param {Function} Parent Parent class.
 */
define('common/inherit',[],function() {
  return function inherit(Child, Parent) {
    function F() {}
    F.prototype = Parent.prototype;
    Child.prototype = new F();
    Child.superClass = Parent.prototype;
    Child.prototype.constructor = Child;
  };
});

/*global define */

/**
 * Custom handling of enabled/disabled state for Lab's HTML elements.
 */
define('common/views/view-state',[],function () {

  return {
    disableView: function($element) {
      if (!$element.hasClass("lab-disabled")) {
        $element.addClass("lab-disabled");
        $element.append('<div class="lab-disabled-overlay"/>');
      }
    },

    enableView: function($element) {
      $element.removeClass("lab-disabled");
      $element.find(".lab-disabled-overlay").remove();
    }
  };
});

/*global define */

/**
 * Tiny "mixin" that can be used by an interactive component. It's temporal workaround before we
 * refactor all interactive components to inherit from one common base class that should provide
 * such basic functionality. Mixins are inconvenient in this case, as they force us to modify
 * implementation of every single component (require and use mixin).
 */
define('common/controllers/disablable',['common/views/view-state'],function () {

  var viewState = require('common/views/view-state');
  var enableView = viewState.enableView;
  var disableView = viewState.disableView;

  return function disablable(component, componentDef) {
    // Extend Public API of a component.
    component.setDisabled = function(v) {
      var $element = this.getViewContainer();
      if (v) {
        disableView($element);
        this.isDisabled = true;
      } else {
        enableView($element);
        this.isDisabled = false;
      }
    };

    // Components are effectively enabled until we take specific action to disable them, so:
    component.isDisabled = false;

    // Set initial value if componentDef is provided.
    if (componentDef) {
      component.setDisabled(componentDef.disabled);
    }
  };
});

/*global define, $ */

define('common/controllers/interactive-component',['require','common/controllers/interactive-metadata','common/validator','common/controllers/disablable','common/controllers/help-icon-support'],function (require) {

  var metadata        = require('common/controllers/interactive-metadata'),
      validator       = require('common/validator'),
      disablable      = require('common/controllers/disablable'),
      helpIconSupport = require('common/controllers/help-icon-support');

  /**
   * Basic class for all interactive components.
   *
   * @constructor
   * @param {string} type Component type, should match definition in interactive metadata.
   * @param {Object} component Component JSON definition.
   * @param {ScriptingAPI} scriptingAPI
   * @param {InteractivesController} interactivesController
   */
  function InteractiveComponent(type, component, interactivesController) {
    this._interactivesController = interactivesController;
    this._scriptingAPI = this._interactivesController.getScriptingAPI();
    this._model = this._interactivesController.getModel();

    /**
     * Validated component definition.
     * @type {Object}
     */
    this.component = validator.validateCompleteness(metadata[type], component);
    /**
     * The most outer element. Subclasses should append content to this element.
     * @type {jQuery}
     */
    this.$element = $('<div>').attr("id", component.id).addClass("component");

    // Optionally setup dimensions of the most outer component.
    // Only when metadata and component JSON specifies width and height
    // properties.
    if (this.component.width) {
      this.$element.css("width", this.component.width);
    }
    if (this.component.height) {
      this.$element.css("height", this.component.height);
    }

    if (this.component.disabled) {
      this.setDisabled(this.component.disabled);
    }

    this._optionallyAddOnClickHandlers();

    // optionally add new css classes
    if (this.component.classes && this.component.classes.length) {
      this.$element.addClass(this.component.classes.join(" "));
    }

    // optionally add tooltip
    if (this.component.tooltip) {
      this.$element.attr("title", this.component.tooltip);
    }

    // optionally add help icon
    helpIconSupport(this, this.component, this._interactivesController.helpSystem);
  }

  /**
   * Called when the Interactive Controller reloads the model ... creating a new model and scriptingAPI
   */
  InteractiveComponent.prototype._modelLoadedCallback = function () {
    this._scriptingAPI = this._interactivesController.getScriptingAPI();
    this._model = this._interactivesController.getModel();
    this._optionallyAddOnClickHandlers();
  };

  InteractiveComponent.prototype._updateClickHandler = function (script) {
    // Create a new handler function from action or onClick in string form
    if (typeof script !== "function") {
      this._actionClickFunction = this._scriptingAPI.makeFunctionInScriptContext(script);
    } else {
      this._actionClickFunction = script;
    }
    var that = this;
    this._onClick(this._nameSpace, function() {
      that._actionClickFunction();
    });
    // Also add a special class indicating that this text node is a clickable.
    this.$element.addClass("clickable");
  };

  InteractiveComponent.prototype._optionallyAddOnClickHandlers = function () {
    // Optionally add onClick or action handlers defined with strings in
    // onClick or action property of component.
    if (this.component.onClick !== undefined) {
      this._updateClickHandler(this.component.onClick);
    }
    if (this.component.action !== undefined) {
      this._updateClickHandler(this.component.action);
    }
  };

  InteractiveComponent.prototype.setAction = function (newAction) {
    // If we are passed a string or array of strings as the new action
    // save them in the action property of the component.
    if (typeof script !== "function") {
      this.component.action = newAction;
    }
    this._updateClickHandler(newAction);
  };

  InteractiveComponent.prototype.setOnClick = function (newOnClick) {
    if (this.component.onClick !== undefined) {
      this.component.onClick = newOnClick;
      this._updateClickHandler(this.component.onClick);
    }
  };

  InteractiveComponent.prototype.enableLogging = function (logFunc) {
    var comp = this.component;
    if (comp.onClick === undefined && comp.action === undefined) return; // nothing to log
    var eventName = comp.type[0].toUpperCase() + comp.type.slice(1) + "Clicked";
    var data = {id: comp.id};
    this._onClick(this._nameSpace + "logging", function () {
      data.label = comp.label || comp.text || comp.title;
      logFunc(eventName, data);
    });
  };

  /**
   * @return {jQuery} The most outer element.
   */
  InteractiveComponent.prototype.getViewContainer = function() {
    return this.$element;
  };

  /**
   * @return {Object} Serialized component definition.
   */
  InteractiveComponent.prototype.serialize = function() {
    return this.component;
  };

  InteractiveComponent.prototype._onClick = function(namespace, handler) {
    this.$element.off("click." + namespace);
    this.$element.on("click." + namespace, this._clickTargetSelector || null, handler);
  };

  // It will add .setDisabled() method to the prototype.
  disablable(InteractiveComponent.prototype);

  return InteractiveComponent;
});

/*global define, $ */

define('common/controllers/button-controller',['common/inherit','common/controllers/interactive-component'],function () {
  var inherit              = require('common/inherit'),
      InteractiveComponent = require('common/controllers/interactive-component'),

      buttonControllerCount = 0;

  function ButtonController(component, interactivesController) {
    this._actionClickFunction = function () { };
    this._nameSpace = "button" + (++buttonControllerCount);
    this._clickTargetSelector = 'button';
    // Call super constructor.
    InteractiveComponent.call(this, "button", component, interactivesController);
    this.$element.addClass("interactive-button");
    this.button = $('<button>')
        .html(component.text)
        .appendTo(this.$element);
    this.setAttributes = function(attrs) {
      // only support text changes right now
      if (attrs.text && typeof(attrs.text) !== "undefined") {
        this.component.text = attrs.text;
        this.button.html(attrs.text);
      }
    };
  }

  inherit(ButtonController, InteractiveComponent);

  ButtonController.prototype.modelLoadedCallback = function () {
    ButtonController.superClass._modelLoadedCallback.call(this);
  };

  return ButtonController;
});

/*global define, $ */

define('common/controllers/checkbox-controller',['common/controllers/interactive-metadata','common/controllers/disablable','common/controllers/help-icon-support','common/validator'],function () {

  var metadata        = require('common/controllers/interactive-metadata'),
      disablable      = require('common/controllers/disablable'),
      helpIconSupport = require('common/controllers/help-icon-support'),
      validator       = require('common/validator');

  return function CheckboxController(component, interactivesController) {
    var propertyName,
        actionScript,
        initialValue,
        $checkbox,
        $fakeCheckable,
        $label,
        $element,
        controller,
        model,
        scriptingAPI;

    // Updates checkbox using model property. Used in modelLoadedCallback.
    // Make sure that this function is only called when:
    // a) model is loaded,
    // b) checkbox is bound to some property.
    function updateCheckbox () {
      setCheckbox(model.get(propertyName));
    }

    function updateCheckboxDisabledState() {
      var description = model.getPropertyDescription(propertyName);
      controller.setDisabled(description.getFrozen());
    }

    function setCheckbox(value) {
      if (value) {
        $checkbox.prop('checked', true);
        $fakeCheckable.addClass('checked');
      } else {
        $checkbox.prop('checked', false);
        $fakeCheckable.removeClass('checked');
      }
    }

    function getCheckboxState() {
      return $checkbox.prop('checked');
    }

    function customClickEvent (e) {
      e.preventDefault();

      if ($checkbox.prop('checked')) {
        setCheckbox(false);
      } else {
        setCheckbox(true);
      }
      // Trigger change event!
      $checkbox.trigger('change');
    }

    model = interactivesController.getModel();
    scriptingAPI = interactivesController.getScriptingAPI();

    // Validate component definition, use validated copy of the properties.
    component = validator.validateCompleteness(metadata.checkbox, component);
    propertyName  = component.property;
    actionScript = component.action;
    initialValue  = component.initialValue;

    $label = $('<label>').append('<span>' + component.text + '</span>');
    $label.attr('for', component.id);
    $checkbox = $('<input type="checkbox">').attr('id', component.id);

    if (interactivesController) {
      $checkbox.attr('tabindex', interactivesController.getNextTabIndex());
    }

    $fakeCheckable = $('<div class="fakeCheckable">');
    // Hide native input, use fake checkable.
    $checkbox.css("display", "none");

    // default is to have label on right of checkbox
    if (component.textOn === "left") {
      $element = $('<div>').append($label).append($checkbox).append($fakeCheckable.addClass("right"));
    } else {
      $element = $('<div>').append($checkbox).append($fakeCheckable).append($label);
    }

    // Append class to the most outer container.
    $element.addClass("interactive-checkbox");
    // Each interactive component has to have class "component".
    $element.addClass("component");

    // Ensure that custom div (used for styling) is clickable.
    $fakeCheckable.on('click', customClickEvent);
    // Label also requires custom event handler to ensure that click updates
    // fake clickable element too.
    $label.on('click', customClickEvent);

    // Custom dimensions.
    $element.css({
      width: component.width,
      height: component.height
    });

    // Process onClick script if it is defined.
    if (actionScript) {
      // Create a function which assumes we pass it a parameter called 'value'.
      actionScript = scriptingAPI.makeFunctionInScriptContext('value', actionScript);
    }

    // Register handler for change event.
    $checkbox.on('change', function () {
      var value = false,
          propObj;
      // $(this) will contain a reference to the checkbox.
      if ($(this).is(':checked')) {
        value = true;
      }
      // Change property value if checkbox is connected
      // with model's property.
      if (propertyName !== undefined) {
        propObj = {};
        propObj[propertyName] = value;
        model.set(propObj);
      }
      // Finally, if checkbox has onClick script attached,
      // call it in script context with checkbox status passed.
      if (actionScript !== undefined) {
        actionScript(value);
      }
    });

    if (component.tooltip) {
      $element.attr("title", component.tooltip);
    }

    // Set initial value if provided.
    if (initialValue !== undefined) {
      setCheckbox(initialValue);
    }

    // Public API
    controller = {
      // This callback should be trigger when model is loaded.
      modelLoadedCallback: function () {
        if (model && propertyName !== undefined) {
          model.removeObserver(propertyName, updateCheckbox);
          model.removePropertyDescriptionObserver(propertyName, updateCheckboxDisabledState);
        }
        model = interactivesController.getModel();
        scriptingAPI = interactivesController.getScriptingAPI();

        // Connect checkbox with model's property if its name is defined.
        if (propertyName !== undefined) {
          // Register listener for 'propertyName'.
          model.addPropertiesListener([propertyName], updateCheckbox);
          model.addPropertyDescriptionObserver(propertyName, updateCheckboxDisabledState);
          // Perform initial checkbox setup.
          updateCheckbox();
        }
      },

      enableLogging: function (logFunc) {
        $checkbox.off('change.logging');
        $checkbox.on('change.logging', function () {
          var data = {id: component.id, label: component.text, value: $(this).is(':checked')};
          if (propertyName) data.property = propertyName;
          logFunc('CheckboxChanged', data);
        });
      },

      // Returns view container. Label tag, as it contains checkbox anyway.
      getViewContainer: function () {
        return $element;
      },

      // Returns serialized component definition.
      serialize: function () {
        var result = $.extend(true, {}, component);

        if (propertyName === undefined) {
          // No property binding. Just action script.
          // Update "initialValue" to represent current
          // value of the slider.
          result.initialValue = $checkbox.is(':checked') ? true : false;
        }

        return result;
      }
    };

    disablable(controller, component);
    helpIconSupport(controller, component, interactivesController.helpSystem);

    // Return Public API object.
    return controller;
  };
});

// Released under MIT license
// Copyright (c) 2009-2010 Dominic Baggott
// Copyright (c) 2009-2010 Ash Berlin
// Copyright (c) 2011 Christoph Dorn <christoph@christophdorn.com> (http://www.christophdorn.com)

/*jshint browser:true, devel:true */

(function( expose ) {

/**
 *  class Markdown
 *
 *  Markdown processing in Javascript done right. We have very particular views
 *  on what constitutes 'right' which include:
 *
 *  - produces well-formed HTML (this means that em and strong nesting is
 *    important)
 *
 *  - has an intermediate representation to allow processing of parsed data (We
 *    in fact have two, both as [JsonML]: a markdown tree and an HTML tree).
 *
 *  - is easily extensible to add new dialects without having to rewrite the
 *    entire parsing mechanics
 *
 *  - has a good test suite
 *
 *  This implementation fulfills all of these (except that the test suite could
 *  do with expanding to automatically run all the fixtures from other Markdown
 *  implementations.)
 *
 *  ##### Intermediate Representation
 *
 *  *TODO* Talk about this :) Its JsonML, but document the node names we use.
 *
 *  [JsonML]: http://jsonml.org/ "JSON Markup Language"
 **/
var Markdown = expose.Markdown = function(dialect) {
  switch (typeof dialect) {
    case "undefined":
      this.dialect = Markdown.dialects.Gruber;
      break;
    case "object":
      this.dialect = dialect;
      break;
    default:
      if ( dialect in Markdown.dialects ) {
        this.dialect = Markdown.dialects[dialect];
      }
      else {
        throw new Error("Unknown Markdown dialect '" + String(dialect) + "'");
      }
      break;
  }
  this.em_state = [];
  this.strong_state = [];
  this.debug_indent = "";
};

/**
 *  parse( markdown, [dialect] ) -> JsonML
 *  - markdown (String): markdown string to parse
 *  - dialect (String | Dialect): the dialect to use, defaults to gruber
 *
 *  Parse `markdown` and return a markdown document as a Markdown.JsonML tree.
 **/
expose.parse = function( source, dialect ) {
  // dialect will default if undefined
  var md = new Markdown( dialect );
  return md.toTree( source );
};

/**
 *  toHTML( markdown, [dialect]  ) -> String
 *  toHTML( md_tree ) -> String
 *  - markdown (String): markdown string to parse
 *  - md_tree (Markdown.JsonML): parsed markdown tree
 *
 *  Take markdown (either as a string or as a JsonML tree) and run it through
 *  [[toHTMLTree]] then turn it into a well-formated HTML fragment.
 **/
expose.toHTML = function toHTML( source , dialect , options ) {
  var input = expose.toHTMLTree( source , dialect , options );

  return expose.renderJsonML( input );
};

/**
 *  toHTMLTree( markdown, [dialect] ) -> JsonML
 *  toHTMLTree( md_tree ) -> JsonML
 *  - markdown (String): markdown string to parse
 *  - dialect (String | Dialect): the dialect to use, defaults to gruber
 *  - md_tree (Markdown.JsonML): parsed markdown tree
 *
 *  Turn markdown into HTML, represented as a JsonML tree. If a string is given
 *  to this function, it is first parsed into a markdown tree by calling
 *  [[parse]].
 **/
expose.toHTMLTree = function toHTMLTree( input, dialect , options ) {
  // convert string input to an MD tree
  if ( typeof input ==="string" ) input = this.parse( input, dialect );

  // Now convert the MD tree to an HTML tree

  // remove references from the tree
  var attrs = extract_attr( input ),
      refs = {};

  if ( attrs && attrs.references ) {
    refs = attrs.references;
  }

  var html = convert_tree_to_html( input, refs , options );
  merge_text_nodes( html );
  return html;
};

// For Spidermonkey based engines
function mk_block_toSource() {
  return "Markdown.mk_block( " +
          uneval(this.toString()) +
          ", " +
          uneval(this.trailing) +
          ", " +
          uneval(this.lineNumber) +
          " )";
}

// node
function mk_block_inspect() {
  var util = require("util");
  return "Markdown.mk_block( " +
          util.inspect(this.toString()) +
          ", " +
          util.inspect(this.trailing) +
          ", " +
          util.inspect(this.lineNumber) +
          " )";

}

var mk_block = Markdown.mk_block = function(block, trail, line) {
  // Be helpful for default case in tests.
  if ( arguments.length == 1 ) trail = "\n\n";

  var s = new String(block);
  s.trailing = trail;
  // To make it clear its not just a string
  s.inspect = mk_block_inspect;
  s.toSource = mk_block_toSource;

  if ( line != undefined )
    s.lineNumber = line;

  return s;
};

function count_lines( str ) {
  var n = 0, i = -1;
  while ( ( i = str.indexOf("\n", i + 1) ) !== -1 ) n++;
  return n;
}

// Internal - split source into rough blocks
Markdown.prototype.split_blocks = function splitBlocks( input, startLine ) {
  input = input.replace(/(\r\n|\n|\r)/g, "\n");
  // [\s\S] matches _anything_ (newline or space)
  // [^] is equivalent but doesn't work in IEs.
  var re = /([\s\S]+?)($|\n#|\n(?:\s*\n|$)+)/g,
      blocks = [],
      m;

  var line_no = 1;

  if ( ( m = /^(\s*\n)/.exec(input) ) != null ) {
    // skip (but count) leading blank lines
    line_no += count_lines( m[0] );
    re.lastIndex = m[0].length;
  }

  while ( ( m = re.exec(input) ) !== null ) {
    if (m[2] == "\n#") {
      m[2] = "\n";
      re.lastIndex--;
    }
    blocks.push( mk_block( m[1], m[2], line_no ) );
    line_no += count_lines( m[0] );
  }

  return blocks;
};

/**
 *  Markdown#processBlock( block, next ) -> undefined | [ JsonML, ... ]
 *  - block (String): the block to process
 *  - next (Array): the following blocks
 *
 * Process `block` and return an array of JsonML nodes representing `block`.
 *
 * It does this by asking each block level function in the dialect to process
 * the block until one can. Succesful handling is indicated by returning an
 * array (with zero or more JsonML nodes), failure by a false value.
 *
 * Blocks handlers are responsible for calling [[Markdown#processInline]]
 * themselves as appropriate.
 *
 * If the blocks were split incorrectly or adjacent blocks need collapsing you
 * can adjust `next` in place using shift/splice etc.
 *
 * If any of this default behaviour is not right for the dialect, you can
 * define a `__call__` method on the dialect that will get invoked to handle
 * the block processing.
 */
Markdown.prototype.processBlock = function processBlock( block, next ) {
  var cbs = this.dialect.block,
      ord = cbs.__order__;

  if ( "__call__" in cbs ) {
    return cbs.__call__.call(this, block, next);
  }

  for ( var i = 0; i < ord.length; i++ ) {
    //D:this.debug( "Testing", ord[i] );
    var res = cbs[ ord[i] ].call( this, block, next );
    if ( res ) {
      //D:this.debug("  matched");
      if ( !isArray(res) || ( res.length > 0 && !( isArray(res[0]) ) ) )
        this.debug(ord[i], "didn't return a proper array");
      //D:this.debug( "" );
      return res;
    }
  }

  // Uhoh! no match! Should we throw an error?
  return [];
};

Markdown.prototype.processInline = function processInline( block ) {
  return this.dialect.inline.__call__.call( this, String( block ) );
};

/**
 *  Markdown#toTree( source ) -> JsonML
 *  - source (String): markdown source to parse
 *
 *  Parse `source` into a JsonML tree representing the markdown document.
 **/
// custom_tree means set this.tree to `custom_tree` and restore old value on return
Markdown.prototype.toTree = function toTree( source, custom_root ) {
  var blocks = source instanceof Array ? source : this.split_blocks( source );

  // Make tree a member variable so its easier to mess with in extensions
  var old_tree = this.tree;
  try {
    this.tree = custom_root || this.tree || [ "markdown" ];

    blocks:
    while ( blocks.length ) {
      var b = this.processBlock( blocks.shift(), blocks );

      // Reference blocks and the like won't return any content
      if ( !b.length ) continue blocks;

      this.tree.push.apply( this.tree, b );
    }
    return this.tree;
  }
  finally {
    if ( custom_root ) {
      this.tree = old_tree;
    }
  }
};

// Noop by default
Markdown.prototype.debug = function () {
  var args = Array.prototype.slice.call( arguments);
  args.unshift(this.debug_indent);
  if ( typeof print !== "undefined" )
      print.apply( print, args );
  if ( typeof console !== "undefined" && typeof console.log !== "undefined" )
      console.log.apply( null, args );
}

Markdown.prototype.loop_re_over_block = function( re, block, cb ) {
  // Dont use /g regexps with this
  var m,
      b = block.valueOf();

  while ( b.length && (m = re.exec(b) ) != null ) {
    b = b.substr( m[0].length );
    cb.call(this, m);
  }
  return b;
};

/**
 * Markdown.dialects
 *
 * Namespace of built-in dialects.
 **/
Markdown.dialects = {};

/**
 * Markdown.dialects.Gruber
 *
 * The default dialect that follows the rules set out by John Gruber's
 * markdown.pl as closely as possible. Well actually we follow the behaviour of
 * that script which in some places is not exactly what the syntax web page
 * says.
 **/
Markdown.dialects.Gruber = {
  block: {
    atxHeader: function atxHeader( block, next ) {
      var m = block.match( /^(#{1,6})\s*(.*?)\s*#*\s*(?:\n|$)/ );

      if ( !m ) return undefined;

      var header = [ "header", { level: m[ 1 ].length } ];
      Array.prototype.push.apply(header, this.processInline(m[ 2 ]));

      if ( m[0].length < block.length )
        next.unshift( mk_block( block.substr( m[0].length ), block.trailing, block.lineNumber + 2 ) );

      return [ header ];
    },

    setextHeader: function setextHeader( block, next ) {
      var m = block.match( /^(.*)\n([-=])\2\2+(?:\n|$)/ );

      if ( !m ) return undefined;

      var level = ( m[ 2 ] === "=" ) ? 1 : 2;
      var header = [ "header", { level : level }, m[ 1 ] ];

      if ( m[0].length < block.length )
        next.unshift( mk_block( block.substr( m[0].length ), block.trailing, block.lineNumber + 2 ) );

      return [ header ];
    },

    code: function code( block, next ) {
      // |    Foo
      // |bar
      // should be a code block followed by a paragraph. Fun
      //
      // There might also be adjacent code block to merge.

      var ret = [],
          re = /^(?: {0,3}\t| {4})(.*)\n?/,
          lines;

      // 4 spaces + content
      if ( !block.match( re ) ) return undefined;

      block_search:
      do {
        // Now pull out the rest of the lines
        var b = this.loop_re_over_block(
                  re, block.valueOf(), function( m ) { ret.push( m[1] ); } );

        if ( b.length ) {
          // Case alluded to in first comment. push it back on as a new block
          next.unshift( mk_block(b, block.trailing) );
          break block_search;
        }
        else if ( next.length ) {
          // Check the next block - it might be code too
          if ( !next[0].match( re ) ) break block_search;

          // Pull how how many blanks lines follow - minus two to account for .join
          ret.push ( block.trailing.replace(/[^\n]/g, "").substring(2) );

          block = next.shift();
        }
        else {
          break block_search;
        }
      } while ( true );

      return [ [ "code_block", ret.join("\n") ] ];
    },

    horizRule: function horizRule( block, next ) {
      // this needs to find any hr in the block to handle abutting blocks
      var m = block.match( /^(?:([\s\S]*?)\n)?[ \t]*([-_*])(?:[ \t]*\2){2,}[ \t]*(?:\n([\s\S]*))?$/ );

      if ( !m ) {
        return undefined;
      }

      var jsonml = [ [ "hr" ] ];

      // if there's a leading abutting block, process it
      if ( m[ 1 ] ) {
        jsonml.unshift.apply( jsonml, this.processBlock( m[ 1 ], [] ) );
      }

      // if there's a trailing abutting block, stick it into next
      if ( m[ 3 ] ) {
        next.unshift( mk_block( m[ 3 ] ) );
      }

      return jsonml;
    },

    // There are two types of lists. Tight and loose. Tight lists have no whitespace
    // between the items (and result in text just in the <li>) and loose lists,
    // which have an empty line between list items, resulting in (one or more)
    // paragraphs inside the <li>.
    //
    // There are all sorts weird edge cases about the original markdown.pl's
    // handling of lists:
    //
    // * Nested lists are supposed to be indented by four chars per level. But
    //   if they aren't, you can get a nested list by indenting by less than
    //   four so long as the indent doesn't match an indent of an existing list
    //   item in the 'nest stack'.
    //
    // * The type of the list (bullet or number) is controlled just by the
    //    first item at the indent. Subsequent changes are ignored unless they
    //    are for nested lists
    //
    lists: (function( ) {
      // Use a closure to hide a few variables.
      var any_list = "[*+-]|\\d+\\.",
          bullet_list = /[*+-]/,
          number_list = /\d+\./,
          // Capture leading indent as it matters for determining nested lists.
          is_list_re = new RegExp( "^( {0,3})(" + any_list + ")[ \t]+" ),
          indent_re = "(?: {0,3}\\t| {4})";

      // TODO: Cache this regexp for certain depths.
      // Create a regexp suitable for matching an li for a given stack depth
      function regex_for_depth( depth ) {

        return new RegExp(
          // m[1] = indent, m[2] = list_type
          "(?:^(" + indent_re + "{0," + depth + "} {0,3})(" + any_list + ")\\s+)|" +
          // m[3] = cont
          "(^" + indent_re + "{0," + (depth-1) + "}[ ]{0,4})"
        );
      }
      function expand_tab( input ) {
        return input.replace( / {0,3}\t/g, "    " );
      }

      // Add inline content `inline` to `li`. inline comes from processInline
      // so is an array of content
      function add(li, loose, inline, nl) {
        if ( loose ) {
          li.push( [ "para" ].concat(inline) );
          return;
        }
        // Hmmm, should this be any block level element or just paras?
        var add_to = li[li.length -1] instanceof Array && li[li.length - 1][0] == "para"
                   ? li[li.length -1]
                   : li;

        // If there is already some content in this list, add the new line in
        if ( nl && li.length > 1 ) inline.unshift(nl);

        for ( var i = 0; i < inline.length; i++ ) {
          var what = inline[i],
              is_str = typeof what == "string";
          if ( is_str && add_to.length > 1 && typeof add_to[add_to.length-1] == "string" ) {
            add_to[ add_to.length-1 ] += what;
          }
          else {
            add_to.push( what );
          }
        }
      }

      // contained means have an indent greater than the current one. On
      // *every* line in the block
      function get_contained_blocks( depth, blocks ) {

        var re = new RegExp( "^(" + indent_re + "{" + depth + "}.*?\\n?)*$" ),
            replace = new RegExp("^" + indent_re + "{" + depth + "}", "gm"),
            ret = [];

        while ( blocks.length > 0 ) {
          if ( re.exec( blocks[0] ) ) {
            var b = blocks.shift(),
                // Now remove that indent
                x = b.replace( replace, "");

            ret.push( mk_block( x, b.trailing, b.lineNumber ) );
          }
          else {
            break;
          }
        }
        return ret;
      }

      // passed to stack.forEach to turn list items up the stack into paras
      function paragraphify(s, i, stack) {
        var list = s.list;
        var last_li = list[list.length-1];

        if ( last_li[1] instanceof Array && last_li[1][0] == "para" ) {
          return;
        }
        if ( i + 1 == stack.length ) {
          // Last stack frame
          // Keep the same array, but replace the contents
          last_li.push( ["para"].concat( last_li.splice(1, last_li.length - 1) ) );
        }
        else {
          var sublist = last_li.pop();
          last_li.push( ["para"].concat( last_li.splice(1, last_li.length - 1) ), sublist );
        }
      }

      // The matcher function
      return function( block, next ) {
        var m = block.match( is_list_re );
        if ( !m ) return undefined;

        function make_list( m ) {
          var list = bullet_list.exec( m[2] )
                   ? ["bulletlist"]
                   : ["numberlist"];

          stack.push( { list: list, indent: m[1] } );
          return list;
        }


        var stack = [], // Stack of lists for nesting.
            list = make_list( m ),
            last_li,
            loose = false,
            ret = [ stack[0].list ],
            i;

        // Loop to search over block looking for inner block elements and loose lists
        loose_search:
        while ( true ) {
          // Split into lines preserving new lines at end of line
          var lines = block.split( /(?=\n)/ );

          // We have to grab all lines for a li and call processInline on them
          // once as there are some inline things that can span lines.
          var li_accumulate = "";

          // Loop over the lines in this block looking for tight lists.
          tight_search:
          for ( var line_no = 0; line_no < lines.length; line_no++ ) {
            var nl = "",
                l = lines[line_no].replace(/^\n/, function(n) { nl = n; return ""; });

            // TODO: really should cache this
            var line_re = regex_for_depth( stack.length );

            m = l.match( line_re );
            //print( "line:", uneval(l), "\nline match:", uneval(m) );

            // We have a list item
            if ( m[1] !== undefined ) {
              // Process the previous list item, if any
              if ( li_accumulate.length ) {
                add( last_li, loose, this.processInline( li_accumulate ), nl );
                // Loose mode will have been dealt with. Reset it
                loose = false;
                li_accumulate = "";
              }

              m[1] = expand_tab( m[1] );
              var wanted_depth = Math.floor(m[1].length/4)+1;
              //print( "want:", wanted_depth, "stack:", stack.length);
              if ( wanted_depth > stack.length ) {
                // Deep enough for a nested list outright
                //print ( "new nested list" );
                list = make_list( m );
                last_li.push( list );
                last_li = list[1] = [ "listitem" ];
              }
              else {
                // We aren't deep enough to be strictly a new level. This is
                // where Md.pl goes nuts. If the indent matches a level in the
                // stack, put it there, else put it one deeper then the
                // wanted_depth deserves.
                var found = false;
                for ( i = 0; i < stack.length; i++ ) {
                  if ( stack[ i ].indent != m[1] ) continue;
                  list = stack[ i ].list;
                  stack.splice( i+1, stack.length - (i+1) );
                  found = true;
                  break;
                }

                if (!found) {
                  //print("not found. l:", uneval(l));
                  wanted_depth++;
                  if ( wanted_depth <= stack.length ) {
                    stack.splice(wanted_depth, stack.length - wanted_depth);
                    //print("Desired depth now", wanted_depth, "stack:", stack.length);
                    list = stack[wanted_depth-1].list;
                    //print("list:", uneval(list) );
                  }
                  else {
                    //print ("made new stack for messy indent");
                    list = make_list(m);
                    last_li.push(list);
                  }
                }

                //print( uneval(list), "last", list === stack[stack.length-1].list );
                last_li = [ "listitem" ];
                list.push(last_li);
              } // end depth of shenegains
              nl = "";
            }

            // Add content
            if ( l.length > m[0].length ) {
              li_accumulate += nl + l.substr( m[0].length );
            }
          } // tight_search

          if ( li_accumulate.length ) {
            add( last_li, loose, this.processInline( li_accumulate ), nl );
            // Loose mode will have been dealt with. Reset it
            loose = false;
            li_accumulate = "";
          }

          // Look at the next block - we might have a loose list. Or an extra
          // paragraph for the current li
          var contained = get_contained_blocks( stack.length, next );

          // Deal with code blocks or properly nested lists
          if ( contained.length > 0 ) {
            // Make sure all listitems up the stack are paragraphs
            forEach( stack, paragraphify, this);

            last_li.push.apply( last_li, this.toTree( contained, [] ) );
          }

          var next_block = next[0] && next[0].valueOf() || "";

          if ( next_block.match(is_list_re) || next_block.match( /^ / ) ) {
            block = next.shift();

            // Check for an HR following a list: features/lists/hr_abutting
            var hr = this.dialect.block.horizRule( block, next );

            if ( hr ) {
              ret.push.apply(ret, hr);
              break;
            }

            // Make sure all listitems up the stack are paragraphs
            forEach( stack, paragraphify, this);

            loose = true;
            continue loose_search;
          }
          break;
        } // loose_search

        return ret;
      };
    })(),

    blockquote: function blockquote( block, next ) {
      if ( !block.match( /^>/m ) )
        return undefined;

      var jsonml = [];

      // separate out the leading abutting block, if any. I.e. in this case:
      //
      //  a
      //  > b
      //
      if ( block[ 0 ] != ">" ) {
        var lines = block.split( /\n/ ),
            prev = [],
            line_no = block.lineNumber;

        // keep shifting lines until you find a crotchet
        while ( lines.length && lines[ 0 ][ 0 ] != ">" ) {
            prev.push( lines.shift() );
            line_no++;
        }

        var abutting = mk_block( prev.join( "\n" ), "\n", block.lineNumber );
        jsonml.push.apply( jsonml, this.processBlock( abutting, [] ) );
        // reassemble new block of just block quotes!
        block = mk_block( lines.join( "\n" ), block.trailing, line_no );
      }


      // if the next block is also a blockquote merge it in
      while ( next.length && next[ 0 ][ 0 ] == ">" ) {
        var b = next.shift();
        block = mk_block( block + block.trailing + b, b.trailing, block.lineNumber );
      }

      // Strip off the leading "> " and re-process as a block.
      var input = block.replace( /^> ?/gm, "" ),
          old_tree = this.tree,
          processedBlock = this.toTree( input, [ "blockquote" ] ),
          attr = extract_attr( processedBlock );

      // If any link references were found get rid of them
      if ( attr && attr.references ) {
        delete attr.references;
        // And then remove the attribute object if it's empty
        if ( isEmpty( attr ) ) {
          processedBlock.splice( 1, 1 );
        }
      }

      jsonml.push( processedBlock );
      return jsonml;
    },

    referenceDefn: function referenceDefn( block, next) {
      var re = /^\s*\[(.*?)\]:\s*(\S+)(?:\s+(?:(['"])(.*?)\3|\((.*?)\)))?\n?/;
      // interesting matches are [ , ref_id, url, , title, title ]

      if ( !block.match(re) )
        return undefined;

      // make an attribute node if it doesn't exist
      if ( !extract_attr( this.tree ) ) {
        this.tree.splice( 1, 0, {} );
      }

      var attrs = extract_attr( this.tree );

      // make a references hash if it doesn't exist
      if ( attrs.references === undefined ) {
        attrs.references = {};
      }

      var b = this.loop_re_over_block(re, block, function( m ) {

        if ( m[2] && m[2][0] == "<" && m[2][m[2].length-1] == ">" )
          m[2] = m[2].substring( 1, m[2].length - 1 );

        var ref = attrs.references[ m[1].toLowerCase() ] = {
          href: m[2]
        };

        if ( m[4] !== undefined )
          ref.title = m[4];
        else if ( m[5] !== undefined )
          ref.title = m[5];

      } );

      if ( b.length )
        next.unshift( mk_block( b, block.trailing ) );

      return [];
    },

    para: function para( block, next ) {
      // everything's a para!
      return [ ["para"].concat( this.processInline( block ) ) ];
    }
  }
};

Markdown.dialects.Gruber.inline = {

    __oneElement__: function oneElement( text, patterns_or_re, previous_nodes ) {
      var m,
          res,
          lastIndex = 0;

      patterns_or_re = patterns_or_re || this.dialect.inline.__patterns__;
      var re = new RegExp( "([\\s\\S]*?)(" + (patterns_or_re.source || patterns_or_re) + ")" );

      m = re.exec( text );
      if (!m) {
        // Just boring text
        return [ text.length, text ];
      }
      else if ( m[1] ) {
        // Some un-interesting text matched. Return that first
        return [ m[1].length, m[1] ];
      }

      var res;
      if ( m[2] in this.dialect.inline ) {
        res = this.dialect.inline[ m[2] ].call(
                  this,
                  text.substr( m.index ), m, previous_nodes || [] );
      }
      // Default for now to make dev easier. just slurp special and output it.
      res = res || [ m[2].length, m[2] ];
      return res;
    },

    __call__: function inline( text, patterns ) {

      var out = [],
          res;

      function add(x) {
        //D:self.debug("  adding output", uneval(x));
        if ( typeof x == "string" && typeof out[out.length-1] == "string" )
          out[ out.length-1 ] += x;
        else
          out.push(x);
      }

      while ( text.length > 0 ) {
        res = this.dialect.inline.__oneElement__.call(this, text, patterns, out );
        text = text.substr( res.shift() );
        forEach(res, add )
      }

      return out;
    },

    // These characters are intersting elsewhere, so have rules for them so that
    // chunks of plain text blocks don't include them
    "]": function () {},
    "}": function () {},

    __escape__ : /^\\[\\`\*_{}\[\]()#\+.!\-]/,

    "\\": function escaped( text ) {
      // [ length of input processed, node/children to add... ]
      // Only esacape: \ ` * _ { } [ ] ( ) # * + - . !
      if ( this.dialect.inline.__escape__.exec( text ) )
        return [ 2, text.charAt( 1 ) ];
      else
        // Not an esacpe
        return [ 1, "\\" ];
    },

    "![": function image( text ) {

      // Unlike images, alt text is plain text only. no other elements are
      // allowed in there

      // ![Alt text](/path/to/img.jpg "Optional title")
      //      1          2            3       4         <--- captures
      var m = text.match( /^!\[(.*?)\][ \t]*\([ \t]*([^")]*?)(?:[ \t]+(["'])(.*?)\3)?[ \t]*\)/ );

      if ( m ) {
        if ( m[2] && m[2][0] == "<" && m[2][m[2].length-1] == ">" )
          m[2] = m[2].substring( 1, m[2].length - 1 );

        m[2] = this.dialect.inline.__call__.call( this, m[2], /\\/ )[0];

        var attrs = { alt: m[1], href: m[2] || "" };
        if ( m[4] !== undefined)
          attrs.title = m[4];

        return [ m[0].length, [ "img", attrs ] ];
      }

      // ![Alt text][id]
      m = text.match( /^!\[(.*?)\][ \t]*\[(.*?)\]/ );

      if ( m ) {
        // We can't check if the reference is known here as it likely wont be
        // found till after. Check it in md tree->hmtl tree conversion
        return [ m[0].length, [ "img_ref", { alt: m[1], ref: m[2].toLowerCase(), original: m[0] } ] ];
      }

      // Just consume the '!['
      return [ 2, "![" ];
    },

    "[": function link( text ) {

      var orig = String(text);
      // Inline content is possible inside `link text`
      var res = Markdown.DialectHelpers.inline_until_char.call( this, text.substr(1), "]" );

      // No closing ']' found. Just consume the [
      if ( !res ) return [ 1, "[" ];

      var consumed = 1 + res[ 0 ],
          children = res[ 1 ],
          link,
          attrs;

      // At this point the first [...] has been parsed. See what follows to find
      // out which kind of link we are (reference or direct url)
      text = text.substr( consumed );

      // [link text](/path/to/img.jpg "Optional title")
      //                 1            2       3         <--- captures
      // This will capture up to the last paren in the block. We then pull
      // back based on if there a matching ones in the url
      //    ([here](/url/(test))
      // The parens have to be balanced
      var m = text.match( /^\s*\([ \t]*([^"']*)(?:[ \t]+(["'])(.*?)\2)?[ \t]*\)/ );
      if ( m ) {
        var url = m[1];
        consumed += m[0].length;

        if ( url && url[0] == "<" && url[url.length-1] == ">" )
          url = url.substring( 1, url.length - 1 );

        // If there is a title we don't have to worry about parens in the url
        if ( !m[3] ) {
          var open_parens = 1; // One open that isn't in the capture
          for ( var len = 0; len < url.length; len++ ) {
            switch ( url[len] ) {
            case "(":
              open_parens++;
              break;
            case ")":
              if ( --open_parens == 0) {
                consumed -= url.length - len;
                url = url.substring(0, len);
              }
              break;
            }
          }
        }

        // Process escapes only
        url = this.dialect.inline.__call__.call( this, url, /\\/ )[0];

        attrs = { href: url || "" };
        if ( m[3] !== undefined)
          attrs.title = m[3];

        link = [ "link", attrs ].concat( children );
        return [ consumed, link ];
      }

      // [Alt text][id]
      // [Alt text] [id]
      m = text.match( /^\s*\[(.*?)\]/ );

      if ( m ) {

        consumed += m[ 0 ].length;

        // [links][] uses links as its reference
        attrs = { ref: ( m[ 1 ] || String(children) ).toLowerCase(),  original: orig.substr( 0, consumed ) };

        link = [ "link_ref", attrs ].concat( children );

        // We can't check if the reference is known here as it likely wont be
        // found till after. Check it in md tree->hmtl tree conversion.
        // Store the original so that conversion can revert if the ref isn't found.
        return [ consumed, link ];
      }

      // [id]
      // Only if id is plain (no formatting.)
      if ( children.length == 1 && typeof children[0] == "string" ) {

        attrs = { ref: children[0].toLowerCase(),  original: orig.substr( 0, consumed ) };
        link = [ "link_ref", attrs, children[0] ];
        return [ consumed, link ];
      }

      // Just consume the "["
      return [ 1, "[" ];
    },


    "<": function autoLink( text ) {
      var m;

      if ( ( m = text.match( /^<(?:((https?|ftp|mailto):[^>]+)|(.*?@.*?\.[a-zA-Z]+))>/ ) ) != null ) {
        if ( m[3] ) {
          return [ m[0].length, [ "link", { href: "mailto:" + m[3] }, m[3] ] ];

        }
        else if ( m[2] == "mailto" ) {
          return [ m[0].length, [ "link", { href: m[1] }, m[1].substr("mailto:".length ) ] ];
        }
        else
          return [ m[0].length, [ "link", { href: m[1] }, m[1] ] ];
      }

      return [ 1, "<" ];
    },

    "`": function inlineCode( text ) {
      // Inline code block. as many backticks as you like to start it
      // Always skip over the opening ticks.
      var m = text.match( /(`+)(([\s\S]*?)\1)/ );

      if ( m && m[2] )
        return [ m[1].length + m[2].length, [ "inlinecode", m[3] ] ];
      else {
        // TODO: No matching end code found - warn!
        return [ 1, "`" ];
      }
    },

    "  \n": function lineBreak( text ) {
      return [ 3, [ "linebreak" ] ];
    }

};

// Meta Helper/generator method for em and strong handling
function strong_em( tag, md ) {

  var state_slot = tag + "_state",
      other_slot = tag == "strong" ? "em_state" : "strong_state";

  function CloseTag(len) {
    this.len_after = len;
    this.name = "close_" + md;
  }

  return function ( text, orig_match ) {

    if ( this[state_slot][0] == md ) {
      // Most recent em is of this type
      //D:this.debug("closing", md);
      this[state_slot].shift();

      // "Consume" everything to go back to the recrusion in the else-block below
      return[ text.length, new CloseTag(text.length-md.length) ];
    }
    else {
      // Store a clone of the em/strong states
      var other = this[other_slot].slice(),
          state = this[state_slot].slice();

      this[state_slot].unshift(md);

      //D:this.debug_indent += "  ";

      // Recurse
      var res = this.processInline( text.substr( md.length ) );
      //D:this.debug_indent = this.debug_indent.substr(2);

      var last = res[res.length - 1];

      //D:this.debug("processInline from", tag + ": ", uneval( res ) );

      var check = this[state_slot].shift();
      if ( last instanceof CloseTag ) {
        res.pop();
        // We matched! Huzzah.
        var consumed = text.length - last.len_after;
        return [ consumed, [ tag ].concat(res) ];
      }
      else {
        // Restore the state of the other kind. We might have mistakenly closed it.
        this[other_slot] = other;
        this[state_slot] = state;

        // We can't reuse the processed result as it could have wrong parsing contexts in it.
        return [ md.length, md ];
      }
    }
  }; // End returned function
}

Markdown.dialects.Gruber.inline["**"] = strong_em("strong", "**");
Markdown.dialects.Gruber.inline["__"] = strong_em("strong", "__");
Markdown.dialects.Gruber.inline["*"]  = strong_em("em", "*");
Markdown.dialects.Gruber.inline["_"]  = strong_em("em", "_");


// Build default order from insertion order.
Markdown.buildBlockOrder = function(d) {
  var ord = [];
  for ( var i in d ) {
    if ( i == "__order__" || i == "__call__" ) continue;
    ord.push( i );
  }
  d.__order__ = ord;
};

// Build patterns for inline matcher
Markdown.buildInlinePatterns = function(d) {
  var patterns = [];

  for ( var i in d ) {
    // __foo__ is reserved and not a pattern
    if ( i.match( /^__.*__$/) ) continue;
    var l = i.replace( /([\\.*+?|()\[\]{}])/g, "\\$1" )
             .replace( /\n/, "\\n" );
    patterns.push( i.length == 1 ? l : "(?:" + l + ")" );
  }

  patterns = patterns.join("|");
  d.__patterns__ = patterns;
  //print("patterns:", uneval( patterns ) );

  var fn = d.__call__;
  d.__call__ = function(text, pattern) {
    if ( pattern != undefined ) {
      return fn.call(this, text, pattern);
    }
    else
    {
      return fn.call(this, text, patterns);
    }
  };
};

Markdown.DialectHelpers = {};
Markdown.DialectHelpers.inline_until_char = function( text, want ) {
  var consumed = 0,
      nodes = [];

  while ( true ) {
    if ( text.charAt( consumed ) == want ) {
      // Found the character we were looking for
      consumed++;
      return [ consumed, nodes ];
    }

    if ( consumed >= text.length ) {
      // No closing char found. Abort.
      return null;
    }

    var res = this.dialect.inline.__oneElement__.call(this, text.substr( consumed ) );
    consumed += res[ 0 ];
    // Add any returned nodes.
    nodes.push.apply( nodes, res.slice( 1 ) );
  }
}

// Helper function to make sub-classing a dialect easier
Markdown.subclassDialect = function( d ) {
  function Block() {}
  Block.prototype = d.block;
  function Inline() {}
  Inline.prototype = d.inline;

  return { block: new Block(), inline: new Inline() };
};

Markdown.buildBlockOrder ( Markdown.dialects.Gruber.block );
Markdown.buildInlinePatterns( Markdown.dialects.Gruber.inline );

Markdown.dialects.Maruku = Markdown.subclassDialect( Markdown.dialects.Gruber );

Markdown.dialects.Maruku.processMetaHash = function processMetaHash( meta_string ) {
  var meta = split_meta_hash( meta_string ),
      attr = {};

  for ( var i = 0; i < meta.length; ++i ) {
    // id: #foo
    if ( /^#/.test( meta[ i ] ) ) {
      attr.id = meta[ i ].substring( 1 );
    }
    // class: .foo
    else if ( /^\./.test( meta[ i ] ) ) {
      // if class already exists, append the new one
      if ( attr["class"] ) {
        attr["class"] = attr["class"] + meta[ i ].replace( /./, " " );
      }
      else {
        attr["class"] = meta[ i ].substring( 1 );
      }
    }
    // attribute: foo=bar
    else if ( /\=/.test( meta[ i ] ) ) {
      var s = meta[ i ].split( /\=/ );
      attr[ s[ 0 ] ] = s[ 1 ];
    }
  }

  return attr;
}

function split_meta_hash( meta_string ) {
  var meta = meta_string.split( "" ),
      parts = [ "" ],
      in_quotes = false;

  while ( meta.length ) {
    var letter = meta.shift();
    switch ( letter ) {
      case " " :
        // if we're in a quoted section, keep it
        if ( in_quotes ) {
          parts[ parts.length - 1 ] += letter;
        }
        // otherwise make a new part
        else {
          parts.push( "" );
        }
        break;
      case "'" :
      case '"' :
        // reverse the quotes and move straight on
        in_quotes = !in_quotes;
        break;
      case "\\" :
        // shift off the next letter to be used straight away.
        // it was escaped so we'll keep it whatever it is
        letter = meta.shift();
      default :
        parts[ parts.length - 1 ] += letter;
        break;
    }
  }

  return parts;
}

Markdown.dialects.Maruku.block.document_meta = function document_meta( block, next ) {
  // we're only interested in the first block
  if ( block.lineNumber > 1 ) return undefined;

  // document_meta blocks consist of one or more lines of `Key: Value\n`
  if ( ! block.match( /^(?:\w+:.*\n)*\w+:.*$/ ) ) return undefined;

  // make an attribute node if it doesn't exist
  if ( !extract_attr( this.tree ) ) {
    this.tree.splice( 1, 0, {} );
  }

  var pairs = block.split( /\n/ );
  for ( p in pairs ) {
    var m = pairs[ p ].match( /(\w+):\s*(.*)$/ ),
        key = m[ 1 ].toLowerCase(),
        value = m[ 2 ];

    this.tree[ 1 ][ key ] = value;
  }

  // document_meta produces no content!
  return [];
};

Markdown.dialects.Maruku.block.block_meta = function block_meta( block, next ) {
  // check if the last line of the block is an meta hash
  var m = block.match( /(^|\n) {0,3}\{:\s*((?:\\\}|[^\}])*)\s*\}$/ );
  if ( !m ) return undefined;

  // process the meta hash
  var attr = this.dialect.processMetaHash( m[ 2 ] );

  var hash;

  // if we matched ^ then we need to apply meta to the previous block
  if ( m[ 1 ] === "" ) {
    var node = this.tree[ this.tree.length - 1 ];
    hash = extract_attr( node );

    // if the node is a string (rather than JsonML), bail
    if ( typeof node === "string" ) return undefined;

    // create the attribute hash if it doesn't exist
    if ( !hash ) {
      hash = {};
      node.splice( 1, 0, hash );
    }

    // add the attributes in
    for ( a in attr ) {
      hash[ a ] = attr[ a ];
    }

    // return nothing so the meta hash is removed
    return [];
  }

  // pull the meta hash off the block and process what's left
  var b = block.replace( /\n.*$/, "" ),
      result = this.processBlock( b, [] );

  // get or make the attributes hash
  hash = extract_attr( result[ 0 ] );
  if ( !hash ) {
    hash = {};
    result[ 0 ].splice( 1, 0, hash );
  }

  // attach the attributes to the block
  for ( a in attr ) {
    hash[ a ] = attr[ a ];
  }

  return result;
};

Markdown.dialects.Maruku.block.definition_list = function definition_list( block, next ) {
  // one or more terms followed by one or more definitions, in a single block
  var tight = /^((?:[^\s:].*\n)+):\s+([\s\S]+)$/,
      list = [ "dl" ],
      i, m;

  // see if we're dealing with a tight or loose block
  if ( ( m = block.match( tight ) ) ) {
    // pull subsequent tight DL blocks out of `next`
    var blocks = [ block ];
    while ( next.length && tight.exec( next[ 0 ] ) ) {
      blocks.push( next.shift() );
    }

    for ( var b = 0; b < blocks.length; ++b ) {
      var m = blocks[ b ].match( tight ),
          terms = m[ 1 ].replace( /\n$/, "" ).split( /\n/ ),
          defns = m[ 2 ].split( /\n:\s+/ );

      // print( uneval( m ) );

      for ( i = 0; i < terms.length; ++i ) {
        list.push( [ "dt", terms[ i ] ] );
      }

      for ( i = 0; i < defns.length; ++i ) {
        // run inline processing over the definition
        list.push( [ "dd" ].concat( this.processInline( defns[ i ].replace( /(\n)\s+/, "$1" ) ) ) );
      }
    }
  }
  else {
    return undefined;
  }

  return [ list ];
};

// splits on unescaped instances of @ch. If @ch is not a character the result
// can be unpredictable

Markdown.dialects.Maruku.block.table = function table (block, next) {

    var _split_on_unescaped = function(s, ch) {
        ch = ch || '\\s';
        if (ch.match(/^[\\|\[\]{}?*.+^$]$/)) { ch = '\\' + ch; }
        var res = [ ],
            r = new RegExp('^((?:\\\\.|[^\\\\' + ch + '])*)' + ch + '(.*)'),
            m;
        while(m = s.match(r)) {
            res.push(m[1]);
            s = m[2];
        }
        res.push(s);
        return res;
    }

    var leading_pipe = /^ {0,3}\|(.+)\n {0,3}\|\s*([\-:]+[\-| :]*)\n((?:\s*\|.*(?:\n|$))*)(?=\n|$)/,
        // find at least an unescaped pipe in each line
        no_leading_pipe = /^ {0,3}(\S(?:\\.|[^\\|])*\|.*)\n {0,3}([\-:]+\s*\|[\-| :]*)\n((?:(?:\\.|[^\\|])*\|.*(?:\n|$))*)(?=\n|$)/,
        i, m;
    if (m = block.match(leading_pipe)) {
        // remove leading pipes in contents
        // (header and horizontal rule already have the leading pipe left out)
        m[3] = m[3].replace(/^\s*\|/gm, '');
    } else if (! ( m = block.match(no_leading_pipe))) {
        return undefined;
    }

    var table = [ "table", [ "thead", [ "tr" ] ], [ "tbody" ] ];

    // remove trailing pipes, then split on pipes
    // (no escaped pipes are allowed in horizontal rule)
    m[2] = m[2].replace(/\|\s*$/, '').split('|');

    // process alignment
    var html_attrs = [ ];
    forEach (m[2], function (s) {
        if (s.match(/^\s*-+:\s*$/))       html_attrs.push({align: "right"});
        else if (s.match(/^\s*:-+\s*$/))  html_attrs.push({align: "left"});
        else if (s.match(/^\s*:-+:\s*$/)) html_attrs.push({align: "center"});
        else                              html_attrs.push({});
    });

    // now for the header, avoid escaped pipes
    m[1] = _split_on_unescaped(m[1].replace(/\|\s*$/, ''), '|');
    for (i = 0; i < m[1].length; i++) {
        table[1][1].push(['th', html_attrs[i] || {}].concat(
            this.processInline(m[1][i].trim())));
    }

    // now for body contents
    forEach (m[3].replace(/\|\s*$/mg, '').split('\n'), function (row) {
        var html_row = ['tr'];
        row = _split_on_unescaped(row, '|');
        for (i = 0; i < row.length; i++) {
            html_row.push(['td', html_attrs[i] || {}].concat(this.processInline(row[i].trim())));
        }
        table[2].push(html_row);
    }, this);

    return [table];
}

Markdown.dialects.Maruku.inline[ "{:" ] = function inline_meta( text, matches, out ) {
  if ( !out.length ) {
    return [ 2, "{:" ];
  }

  // get the preceeding element
  var before = out[ out.length - 1 ];

  if ( typeof before === "string" ) {
    return [ 2, "{:" ];
  }

  // match a meta hash
  var m = text.match( /^\{:\s*((?:\\\}|[^\}])*)\s*\}/ );

  // no match, false alarm
  if ( !m ) {
    return [ 2, "{:" ];
  }

  // attach the attributes to the preceeding element
  var meta = this.dialect.processMetaHash( m[ 1 ] ),
      attr = extract_attr( before );

  if ( !attr ) {
    attr = {};
    before.splice( 1, 0, attr );
  }

  for ( var k in meta ) {
    attr[ k ] = meta[ k ];
  }

  // cut out the string and replace it with nothing
  return [ m[ 0 ].length, "" ];
};

Markdown.dialects.Maruku.inline.__escape__ = /^\\[\\`\*_{}\[\]()#\+.!\-|:]/;

Markdown.buildBlockOrder ( Markdown.dialects.Maruku.block );
Markdown.buildInlinePatterns( Markdown.dialects.Maruku.inline );

var isArray = Array.isArray || function(obj) {
  return Object.prototype.toString.call(obj) == "[object Array]";
};

var forEach;
// Don't mess with Array.prototype. Its not friendly
if ( Array.prototype.forEach ) {
  forEach = function( arr, cb, thisp ) {
    return arr.forEach( cb, thisp );
  };
}
else {
  forEach = function(arr, cb, thisp) {
    for (var i = 0; i < arr.length; i++) {
      cb.call(thisp || arr, arr[i], i, arr);
    }
  }
}

var isEmpty = function( obj ) {
  for ( var key in obj ) {
    if ( hasOwnProperty.call( obj, key ) ) {
      return false;
    }
  }

  return true;
}

function extract_attr( jsonml ) {
  return isArray(jsonml)
      && jsonml.length > 1
      && typeof jsonml[ 1 ] === "object"
      && !( isArray(jsonml[ 1 ]) )
      ? jsonml[ 1 ]
      : undefined;
}



/**
 *  renderJsonML( jsonml[, options] ) -> String
 *  - jsonml (Array): JsonML array to render to XML
 *  - options (Object): options
 *
 *  Converts the given JsonML into well-formed XML.
 *
 *  The options currently understood are:
 *
 *  - root (Boolean): wether or not the root node should be included in the
 *    output, or just its children. The default `false` is to not include the
 *    root itself.
 */
expose.renderJsonML = function( jsonml, options ) {
  options = options || {};
  // include the root element in the rendered output?
  options.root = options.root || false;

  var content = [];

  if ( options.root ) {
    content.push( render_tree( jsonml ) );
  }
  else {
    jsonml.shift(); // get rid of the tag
    if ( jsonml.length && typeof jsonml[ 0 ] === "object" && !( jsonml[ 0 ] instanceof Array ) ) {
      jsonml.shift(); // get rid of the attributes
    }

    while ( jsonml.length ) {
      content.push( render_tree( jsonml.shift() ) );
    }
  }

  return content.join( "\n\n" );
};

function escapeHTML( text ) {
  return text.replace( /&/g, "&amp;" )
             .replace( /</g, "&lt;" )
             .replace( />/g, "&gt;" )
             .replace( /"/g, "&quot;" )
             .replace( /'/g, "&#39;" );
}

function render_tree( jsonml ) {
  // basic case
  if ( typeof jsonml === "string" ) {
    return escapeHTML( jsonml );
  }

  var tag = jsonml.shift(),
      attributes = {},
      content = [];

  if ( jsonml.length && typeof jsonml[ 0 ] === "object" && !( jsonml[ 0 ] instanceof Array ) ) {
    attributes = jsonml.shift();
  }

  while ( jsonml.length ) {
    content.push( render_tree( jsonml.shift() ) );
  }

  var tag_attrs = "";
  for ( var a in attributes ) {
    tag_attrs += " " + a + '="' + escapeHTML( attributes[ a ] ) + '"';
  }

  // be careful about adding whitespace here for inline elements
  if ( tag == "img" || tag == "br" || tag == "hr" ) {
    return "<"+ tag + tag_attrs + "/>";
  }
  else {
    return "<"+ tag + tag_attrs + ">" + content.join( "" ) + "</" + tag + ">";
  }
}

function convert_tree_to_html( tree, references, options ) {
  var i;
  options = options || {};

  // shallow clone
  var jsonml = tree.slice( 0 );

  if ( typeof options.preprocessTreeNode === "function" ) {
      jsonml = options.preprocessTreeNode(jsonml, references);
  }

  // Clone attributes if they exist
  var attrs = extract_attr( jsonml );
  if ( attrs ) {
    jsonml[ 1 ] = {};
    for ( i in attrs ) {
      jsonml[ 1 ][ i ] = attrs[ i ];
    }
    attrs = jsonml[ 1 ];
  }

  // basic case
  if ( typeof jsonml === "string" ) {
    return jsonml;
  }

  // convert this node
  switch ( jsonml[ 0 ] ) {
    case "header":
      jsonml[ 0 ] = "h" + jsonml[ 1 ].level;
      delete jsonml[ 1 ].level;
      break;
    case "bulletlist":
      jsonml[ 0 ] = "ul";
      break;
    case "numberlist":
      jsonml[ 0 ] = "ol";
      break;
    case "listitem":
      jsonml[ 0 ] = "li";
      break;
    case "para":
      jsonml[ 0 ] = "p";
      break;
    case "markdown":
      jsonml[ 0 ] = "html";
      if ( attrs ) delete attrs.references;
      break;
    case "code_block":
      jsonml[ 0 ] = "pre";
      i = attrs ? 2 : 1;
      var code = [ "code" ];
      code.push.apply( code, jsonml.splice( i, jsonml.length - i ) );
      jsonml[ i ] = code;
      break;
    case "inlinecode":
      jsonml[ 0 ] = "code";
      break;
    case "img":
      jsonml[ 1 ].src = jsonml[ 1 ].href;
      delete jsonml[ 1 ].href;
      break;
    case "linebreak":
      jsonml[ 0 ] = "br";
    break;
    case "link":
      jsonml[ 0 ] = "a";
      break;
    case "link_ref":
      jsonml[ 0 ] = "a";

      // grab this ref and clean up the attribute node
      var ref = references[ attrs.ref ];

      // if the reference exists, make the link
      if ( ref ) {
        delete attrs.ref;

        // add in the href and title, if present
        attrs.href = ref.href;
        if ( ref.title ) {
          attrs.title = ref.title;
        }

        // get rid of the unneeded original text
        delete attrs.original;
      }
      // the reference doesn't exist, so revert to plain text
      else {
        return attrs.original;
      }
      break;
    case "img_ref":
      jsonml[ 0 ] = "img";

      // grab this ref and clean up the attribute node
      var ref = references[ attrs.ref ];

      // if the reference exists, make the link
      if ( ref ) {
        delete attrs.ref;

        // add in the href and title, if present
        attrs.src = ref.href;
        if ( ref.title ) {
          attrs.title = ref.title;
        }

        // get rid of the unneeded original text
        delete attrs.original;
      }
      // the reference doesn't exist, so revert to plain text
      else {
        return attrs.original;
      }
      break;
  }

  // convert all the children
  i = 1;

  // deal with the attribute node, if it exists
  if ( attrs ) {
    // if there are keys, skip over it
    for ( var key in jsonml[ 1 ] ) {
        i = 2;
        break;
    }
    // if there aren't, remove it
    if ( i === 1 ) {
      jsonml.splice( i, 1 );
    }
  }

  for ( ; i < jsonml.length; ++i ) {
    jsonml[ i ] = convert_tree_to_html( jsonml[ i ], references, options );
  }

  return jsonml;
}


// merges adjacent text nodes into a single node
function merge_text_nodes( jsonml ) {
  // skip the tag name and attribute hash
  var i = extract_attr( jsonml ) ? 2 : 1;

  while ( i < jsonml.length ) {
    // if it's a string check the next item too
    if ( typeof jsonml[ i ] === "string" ) {
      if ( i + 1 < jsonml.length && typeof jsonml[ i + 1 ] === "string" ) {
        // merge the second string into the first and remove it
        jsonml[ i ] += jsonml.splice( i + 1, 1 )[ 0 ];
      }
      else {
        ++i;
      }
    }
    // if it's not a string recurse
    else {
      merge_text_nodes( jsonml[ i ] );
      ++i;
    }
  }
}

} )( (function() {
  if ( typeof exports === "undefined" ) {
    window.markdown = {};
    return window.markdown;
  }
  else {
    return exports;
  }
} )() );

define("markdown", (function (global) {
    return function () {
        var ret, fn;
        return ret || global.markdown;
    };
}(this)));

/*global define: true, $ */

/**
 * Converts markdown to HTML. Passed argument can be a string or array of strings.
 */
define('common/markdown-to-html',['require','markdown'],function (require) {
  var markdown = require('markdown'),
      NEW_WINDOW = 'class="opens-in-new-window" target="blank"';

  return function markdownToHTML(text) {
    var content = "", html;
    if (!$.isArray(text)) text = [text];
    text.forEach(function (line) {
      content += line + "\n";
    });
    html = '<div class="markdown-typography">' + markdown.toHTML(content) + '</div>';
    return html.replace(/<a(.*?)>/g, "<a$1 " + NEW_WINDOW + ">");
  };
});

/*global define */

define('common/controllers/text-controller',['require','common/markdown-to-html','common/inherit','common/controllers/interactive-component'],function (require) {

  var markdownToHTML       = require('common/markdown-to-html'),
      inherit              = require('common/inherit'),
      InteractiveComponent = require('common/controllers/interactive-component');

  /**
   * Text controller.
   * It supports markdown (syntax: http://daringfireball.net/projects/markdown/syntax).
   *
   * @constructor
   * @extends InteractiveComponent
   * @param {Object} component Component JSON definition.
   * @param {ScriptingAPI} scriptingAPI
   * @param {InteracitveController} interacitveController
   */
  function TextController(component, interactivesController) {
    // Call super constructor.
    InteractiveComponent.call(this, "text", component, interactivesController);
    // Setup custom class.
    this.$element.addClass("interactive-text");
    // Use markdown to parse the 'text' content.
    this.$element.append(markdownToHTML(this.component.text));
  }
  inherit(TextController, InteractiveComponent);

  TextController.prototype.modelLoadedCallback = function () {
    TextController.superClass._modelLoadedCallback.call(this);
  };

  return TextController;
});

/*global define, $ */

define('common/controllers/image-controller',['require','lab.config','common/inherit','common/controllers/interactive-component'],function (require) {

  var labConfig            = require('lab.config'),
      inherit              = require('common/inherit'),
      InteractiveComponent = require('common/controllers/interactive-component'),

      externalUrl  = /^https?:\/\//i;

  /**
   * Image controller.
   *
   * @constructor
   * @extends InteractiveComponent
   * @param {Object} component Component JSON definition.
   * @param {ScriptingAPI} scriptingAPI
   * @param {InteractiveController} controller
   */
  function ImageController(component, controller) {
    // Call super constructor.
    InteractiveComponent.call(this, "image", component, controller);

    /** @private */
    this._controller = controller;
    /** @private */
    this._$img = $("<img>");
    /** @private */
    this._externalUrl = externalUrl.test(this.component.src);

    if (this._externalUrl) {
      // If URL is external, we can setup it just once.
      this._$img.attr("src", this.component.src);
    }

    // When a dimension is different from "auto",
    // ensure that image fits its parent container.
    if (this.component.width !== "auto") {
      this._$img.css("width", "100%");
    }
    if (this.component.height !== "auto") {
      this._$img.css("height", "100%");
    }
    this._$img.appendTo(this.$element);
  }
  inherit(ImageController, InteractiveComponent);

  /**
   * Implements optional callback supported by Interactive Controller.
   */
  ImageController.prototype.modelLoadedCallback = function() {
    var src, modelUrl, urlRelativeTo;
    // It's necessary to update path only if its relative (as it's relative to
    // model file).
    if (!this._externalUrl) {
      src = this.component.src;
      // Relative path should be relative to the model definition file, to
      // follow pattern used for images inside model container.
      // TODO: not sure if it makes sense for the Interactive images. When web
      // application is ready, probably it will be changed anyway.
      urlRelativeTo = this.component.urlRelativeTo;

      switch(urlRelativeTo) {
        case 'page':
          modelUrl = '';
          break;
        case 'model':
        default:
          modelUrl = this._controller.modelController.modelUrl || '';
          break;
      }

      // Remove <model-name>.json from url.
      modelUrl = modelUrl.slice(0, modelUrl.lastIndexOf("/") + 1);
      src = labConfig.modelsRootUrl + modelUrl + src;
      this._$img.attr("src", src);
    }
  };

  return ImageController;
});

/*global define, $ */
/*jshint loopfunc: true */

define('common/controllers/radio-controller',['common/controllers/interactive-metadata','common/validator','common/controllers/disablable','common/controllers/help-icon-support'],function () {

  var metadata        = require('common/controllers/interactive-metadata'),
      validator       = require('common/validator'),
      disablable      = require('common/controllers/disablable'),
      helpIconSupport = require('common/controllers/help-icon-support');

  return function RadioController(component, interactivesController) {
        // Public API.
    var controller,
        // DOM elements.
        $div,
        // Options definitions from component JSON definition.
        options,
        // List of jQuery objects wrapping <input type="radio"> elements.
        $inputs = [],
        // List of jQuery objects wrapping option <div>.
        $options = [],
        model,
        scriptingAPI;

    // Updates radio using model property. Used in modelLoadedCallback.
    // Make sure that this function is only called when:
    // a) model is loaded,
    // b) radio is bound to some property.
    function updateRadio() {
      if (component.property !== undefined) {
        var value = model.get(component.property);
        for (var i = 0, len = options.length; i < len; i++) {
          if (options[i].value === value) {
            $inputs[i].attr("checked", true);
            $options[i].addClass('checked');
          } else {
            $inputs[i].removeAttr("checked");
            $options[i].removeClass('checked');
          }
        }
      }
    }

    function updateRadioDisabledState() {
      var description = model.getPropertyDescription(component.property);
      controller.setDisabled(description.getFrozen());
    }


    function customClickEvent (e) {
      var $span = $(this),
          $input = $span.find('input'),
          i, len;

      e.preventDefault();

      if ($input.attr("disabled") !== undefined) {
        // Do nothing when option is disabled.
        return;
      }

      for (i = 0, len = $inputs.length; i < len; i++) {
        $inputs[i].removeAttr('checked');
        $options[i].removeClass('checked');
      }

      $input.attr('checked', 'checked');
      $span.addClass('checked');

      // Trigger change event!
      $input.trigger('change');
    }

    function initialize() {
      var $input, $span, $label, $optionsContainer,
          option, i, len;

      model = interactivesController.getModel();
      scriptingAPI = interactivesController.getScriptingAPI();

      // Validate component definition, use validated copy of the properties.
      component = validator.validateCompleteness(metadata.radio, component);
      // Validate radio options too.
      options = component.options;
      for (i = 0, len = options.length; i < len; i++) {
        options[i] = validator.validateCompleteness(metadata.radioOption, options[i]);
      }

      // Create HTML elements.
      $div = $('<div>').attr('id', component.id);
      $div.addClass("interactive-radio");
      // Each interactive component has to have class "component".
      $div.addClass("component");
      // Add class defining component orientation - "horizontal" or "vertical".
      $div.addClass(component.orientation);
      // "radio" or "toggle".
      $div.addClass(component.style);

      if (component.label) {
        $label = $("<span>").html(component.label);
        $label.addClass("label");
        $label.addClass(component.labelOn === "top" ? "on-top" : "on-left");
        $div.append($label);
      }

      $optionsContainer = $("<span>").addClass("options").appendTo($div);

      // Create options (<input type="radio">)
      for (i = 0, len = options.length; i < len; i++) {
        option = options[i];
        $input = $('<input>')
          .attr('type', "radio")
          .attr('name', component.id)
          .attr('tabindex', interactivesController.getNextTabIndex())
          .attr('id', component.id + '-' + i);
        $inputs.push($input);

        $span = $('<span>')
          .addClass('option')
          .append($input);
        $options.push($span);
        $optionsContainer.append($span);

        if (component.style === 'radio') {
          $('<div class="fakeCheckable">').appendTo($span);
        }

        $('<label>')
          .attr("for", component.id + '-' + i)
          .html(option.text)
          .appendTo($span);

        if (option.disabled) {
          $input.attr("disabled", option.disabled);
          $span.addClass('lab-disabled');
        }
        if (option.selected) {
          $input.attr("checked", option.selected);
          $span.addClass("checked");
        }

        $span.on('touchstart click', customClickEvent);

        $input.change((function(option) {
          return function() {
            if (option.action){
              scriptingAPI.makeFunctionInScriptContext(option.action)();
            } else if (option.value !== undefined) {
              model.set(component.property, option.value);
            }
          };
        })(option));
      }

      if (component.tooltip) {
        $div.attr("title", component.tooltip);
      }

      disablable(controller, component);
      helpIconSupport(controller, component, interactivesController.helpSystem);
    }

    // Public API.
    controller = {
      modelLoadedCallback: function () {
        if (model && component.property !== undefined) {
          model.removeObserver(component.property, updateRadio);
          model.removePropertyDescriptionObserver(component.property, updateRadioDisabledState);
        }
        model = interactivesController.getModel();
        scriptingAPI = interactivesController.getScriptingAPI();
        // Connect radio with model's property if its name is defined.
        if (component.property !== undefined) {
          // Register listener for property.
          model.addPropertiesListener([component.property], updateRadio);
          model.addPropertyDescriptionObserver(component.property, updateRadioDisabledState);
        }
        // Perform initial radio setup.
        updateRadio();
      },

      enableLogging: function (logFunc) {
        $inputs.forEach(function ($input, idx) {
          var optionSpec = options[idx];
          $input.off('.logging');
          $input.on('change.logging', function () {
            var data = {id: component.id, selected: optionSpec.text};
            if (component.label) data.label = component.label;
            if (component.property) {
              data.property = component.property;
              data.value = optionSpec.value;
            }
            logFunc('RadioChanged', data);
          });
        });
      },

      // Returns view container.
      getViewContainer: function () {
        return $div;
      },

      // Returns serialized component definition.
      serialize: function () {
        var i, len;
        if (component.property === undefined) {
          // When property binding is not defined, we need to keep track
          // which option is currently selected.
          for (i = 0, len = options.length; i < len; i++) {
            if ($inputs[i].attr("checked")) {
              options[i].selected = true;
            } else {
              delete options[i].selected;
            }
          }
        }
        // Note that 'options' array above is a reference to component.options array.
        // Every thing is updated, return a copy.
        return $.extend(true, {}, component);
      }
    };

    initialize();

    // Return Public API object.
    return controller;
  };
});

/*global define, $*/

define('common/controllers/slider-controller',['common/controllers/interactive-metadata','common/validator','common/controllers/disablable','common/controllers/help-icon-support'],function () {

  var metadata        = require('common/controllers/interactive-metadata'),
      validator       = require('common/validator'),
      disablable      = require('common/controllers/disablable'),
      helpIconSupport = require('common/controllers/help-icon-support');

  return function SliderController(component, interactivesController) {
    var min, max, steps, propertyName,
        actionFunc, initialValue,
        title, labels, displayValue, displayFunc,
        i, label,
        fillColor, fillToValue, fillToPct, defaultBackgroundColor = null,
        // View elements.
        $elem,
        $title,
        $label,
        $slider,
        $sliderHandle,
        $container,
        model,
        scriptingAPI,
        // Public API object.
        controller,

        // Updates slider using model property. Used in modelLoadedCallback.
        // Make sure that this function is only called when:
        // a) model is loaded,
        // b) slider is bound to some property.
        updateSlider = function () {
          var value = interactivesController.getModel().get(propertyName);
          $slider.slider('value', value);
          redoSliderFill(value);
          if (displayValue) {
            $sliderHandle.text(displayFunc(value));
          }
        },
        updateSliderDisabledState = function () {
          var description = model.getPropertyDescription(propertyName);
          controller.setDisabled(description.getFrozen());
        };

    function bindTargets() {
      $slider.off('.componentAction');
      // Bind action or/and property, process other options.
      if (component.action) {
        // The 'action' property is a source of a function which assumes we pass it a parameter
        // called 'value'.
        actionFunc = scriptingAPI.makeFunctionInScriptContext('value', component.action);
        $slider.on('slide.componentAction', function(event, ui) {
          actionFunc(ui.value);
          if (displayValue) {
            $sliderHandle.text(displayFunc(ui.value));
          }
        });
      }

      if (propertyName) {
        $slider.on('slide.componentAction', function(event, ui) {
          // Just ignore slide events that occur before the model is loaded.
          var obj = {};
          obj[propertyName] = ui.value;
          if (model) model.set(obj);
          if (displayValue) {
            $sliderHandle.text(displayFunc(ui.value));
          }
        });
      }

      if (displayValue) {
        displayFunc = scriptingAPI.makeFunctionInScriptContext('value', displayValue);
      }
    }

    function redoSliderFill(value) {
      // linear-gradient isn't supported on IE 9, but IE 9 doesn't seem to support multi-stop gradients anyway.
      // It falls back to the same behavior as not having the fill color defined.
      if (fillColor) {
        var valuePct = Math.round(100 * (value - min) / (max - min)),
            gradientStr = '',
            webkitGradientStr = '',
            stops = [];

        if (defaultBackgroundColor === null) {
          $container.css('background', '');
          defaultBackgroundColor = $container.css('background-color');
        }

        // Figure out our gradient string
        if (value === fillToValue) {
          // remove the gradient entirely when we're on top of the value we're filling to
          $container.css('background', '');
        } else {
          // min stop
          gradientStr += defaultBackgroundColor + ' 0%, ';
          webkitGradientStr += 'color-stop(0%,' + defaultBackgroundColor + '), ';

          // next the value and fillToValue stops
          if (fillToValue <= value) {
            stops.push(fillToPct);
            stops.push(valuePct);
          } else {
            stops.push(valuePct);
            stops.push(fillToPct);
          }

          // we're the default color to the left of the first stop, and the fillColor to the right
          gradientStr += defaultBackgroundColor + ' ' + stops[0] + '%, ';
          webkitGradientStr += 'color-stop(' + stops[0] + '%,' + defaultBackgroundColor + '), ';

          gradientStr += fillColor + ' ' + stops[0] + '%, ';
          webkitGradientStr += 'color-stop(' + stops[0] + '%,' + fillColor + '), ';

          // All the way up to the next stop, then we revert back to the default color
          gradientStr += fillColor + ' ' + stops[1] + '%, ';
          webkitGradientStr += 'color-stop(' + stops[1] + '%,' + fillColor + '), ';

          gradientStr += defaultBackgroundColor + ' ' + stops[1] + '%, ';
          webkitGradientStr += 'color-stop(' + stops[1] + '%,' + defaultBackgroundColor + '), ';

          // And then we're the default color up to the max
          gradientStr += defaultBackgroundColor + ' 100%';
          webkitGradientStr += 'color-stop(100%,' + defaultBackgroundColor + ')';

          $container.css('background', '-webkit-gradient(linear, left top, right top, ' + webkitGradientStr + ')');
          $container.css('background', '-webkit-linear-gradient(left, ' + gradientStr + ')');
          $container.css('background', '-moz-linear-gradient(left, ' + gradientStr + ')');
          $container.css('background', '-o-linear-gradient(left, ' + gradientStr + ')');
          $container.css('background', 'linear-gradient(to right, ' + gradientStr + ')');
        }
      }
    }

    function initialize() {
      //
      // Initialize.
      //
      scriptingAPI = interactivesController.getScriptingAPI();
      model = interactivesController.getModel();
      // Validate component definition, use validated copy of the properties.
      component = validator.validateCompleteness(metadata.slider, component);
      min = component.min;
      max = component.max;
      steps = component.steps;
      propertyName = component.property;
      initialValue = component.initialValue;
      title = component.title;
      labels = component.labels;
      displayValue = component.displayValue;
      fillColor = component.fillColor;
      fillToValue = component.fillToValue;

      model = interactivesController.getModel();

      // Setup view.
      if (min === undefined) min = 0;
      if (max === undefined) max = 10;
      if (steps === undefined) steps = 10;
      if (fillToValue === undefined) fillToValue = min;

      fillToPct = Math.round(100 * (fillToValue - min) / (max - min));

      $title = $('<div class="title ' + component.titlePosition + '">' + title + '</div>');
      // we pick up the SVG slider component CSS if we use the generic class name 'slider'
      $container = $('<div class="container">');
      $slider = $('<div class="html-slider">').attr('id', component.id);
      $slider.appendTo($container);

      $slider.slider({
        min: min,
        max: max,
        step: (max - min) / steps
      });

      if (fillColor) {
        $slider.addClass('has-fill');
        $slider.on('slide', function(evt, ui) {
          redoSliderFill(ui.value);
        });
      }

      $sliderHandle = $slider.find(".ui-slider-handle");

      $sliderHandle.attr('tabindex', interactivesController.getNextTabIndex());

      $elem = $('<div class="interactive-slider">');
      if (component.titlePosition === "right" || component.titlePosition === "bottom") {
        $elem.append($container)
             .append($title);
      } else {
        $elem.append($title)
             .append($container);
      }

      if (component.titlePosition === "left" || component.titlePosition === "right") {
        $container.css({ display: 'inline-block' });
      }

      // Each interactive component has to have class "component".
      $elem.addClass("component");

      // Apply custom width and height settings.
      // Also not that we set dimensions of the most outer container, not slider.
      // Slider itself will always follow dimensions of container DIV.
      // We have to do it that way to ensure that labels refer correct dimensions.
      $elem.css({
        "width": component.width,
        "height": component.height
      });
      if (component.width === "auto") {
        // Ensure that min width is 12em, when width is set to "auto".
        // Prevent from situation when all sliders with short labels have
        // different widths, what looks distracting.
        $elem.css("min-width", "12em");
      }

      var leftLabelWidth = null;
      var rightLabelWidth = null;
      var getLabelWidth = function(labelSelector) {
        // This is quite tricky - we need to calculate label width only when we add the whole
        // slider element to the interactive container. It ensures that styles are applied correctly
        // and font sizes are final.
        return $elem.measure(function() {
          // Use font size of the container, not label itself!
          // Note that this refers to the label (take a look at $.measure function).
          return (this.width() / parseFloat(this.parent().css('font-size')));
        }, labelSelector, interactivesController.interactiveContainer);
      };
      for (i = 0; i < labels.length; i++) {
        label = labels[i];
        $label = $('<p class="label">' + label.label + '</p>');
        $container.append($label);
        if (label.value === 'right') {
          // Special kind of label which is on the right side of the slider.
          $label.addClass('side right');
          rightLabelWidth = getLabelWidth('.label.side.right');
          $label.css({
            'left': '100%',
            'margin-left': '0.6em'
          });
        } else if (label.value === 'left') {
          // Special kind of label which is on the left side of the slider.
          $label.addClass('side left');
          leftLabelWidth = getLabelWidth('.label.side.left');
          $label.css({
            'left': (-leftLabelWidth) + 'em',
            'margin-left': '-0.8em'
          });
        } else {
          $label.css('left', (label.value - min) / (max - min) * 100 + '%');
        }
      }
      // Theoretically we should also include left margins (0.6em + 0.8em),
      // but slider always has small padding to handle regular labels,
      // so it's not necessary in practice.
      if (leftLabelWidth) $elem.css('margin-left', leftLabelWidth + 'em');
      if (rightLabelWidth) $elem.css('margin-right', rightLabelWidth + 'em');

      bindTargets();

      if (component.tooltip) {
        $elem.attr("title", component.tooltip);
      }

      disablable(controller, component);
      helpIconSupport(controller, component, interactivesController.helpSystem);

      // Prevent keyboard control of slider from stepping the model backwards and forwards
      $sliderHandle.on('keydown.slider-handle', function(event) {
          event.stopPropagation();
      });

      // Call resize function to support complex resizing when height is different from "auto".
      controller.resize();

      // Finally set the initial value if it's provided.
      if (initialValue !== undefined && initialValue !== null) {
        $slider.slider('value', initialValue);
        redoSliderFill(initialValue);
        if (displayValue) {
          $sliderHandle.text(displayFunc(initialValue));
        }
      }
    }

    // Public API.
    controller = {
      // This callback should be triggered when model is loaded.
      modelLoadedCallback: function () {
        if (model && propertyName) {
          model.removeObserver(propertyName, updateSlider);
          model.removePropertyDescriptionObserver(propertyName, updateSliderDisabledState);
        }
        scriptingAPI = interactivesController.getScriptingAPI();
        model = interactivesController.getModel();
        if (propertyName) {
          model.addPropertiesListener([propertyName], updateSlider);
          model.addPropertyDescriptionObserver(propertyName, updateSliderDisabledState);
        }

        bindTargets();

        if (propertyName) {
          updateSlider();
        }
      },

      // Returns view container (div).
      getViewContainer: function () {
        return $elem;
      },

      resize: function () {
        var remainingHeight,
            emSize = parseFloat($sliderHandle.css("font-size"));
        if (component.height !== "auto") {
          // Height calculation is more complex when height is different from
          // "auto". Calculate dynamically available height for slider itself.
          // Note that component.height refers to the height of the *whole*
          // component!
          remainingHeight = $elem.height();
          if (component.titlePosition === "top" || component.titlePosition === "bottom") {
            remainingHeight -= $title.outerHeight(true);
          }
          if ($label !== undefined) {
            remainingHeight -= $label.outerHeight(true);
          }
          $container.css("height", remainingHeight);
          $slider.css("top", 0.5 * remainingHeight);
          // Handle also requires dynamic styling.
          $sliderHandle.css("height", remainingHeight + emSize * 0.4);
          $sliderHandle.css("top", -0.5 * remainingHeight - emSize * 0.4);
        }

        if (component.titlePosition === "left" || component.titlePosition === "right") {
          $container.css({ width: $elem.width() - $title.outerWidth(true) - 0.5*emSize });
        }
      },

      enableLogging: function (logFunc) {
        var data = {id: component.id, label: component.label};
        if (propertyName) {
          data.property = propertyName;
        }
        var startTime;
        $slider.off('.logging');
        $slider.on('slidestart.logging', function (event, ui) {
          startTime = Date.now();
          data.startVal = data.minVal = data.maxVal = ui.value;
        });
        $slider.on('slide.logging', function (event, ui) {
          data.minVal = Math.min(data.minVal, ui.value);
          data.maxVal = Math.max(data.maxVal, ui.value);
        });
        $slider.on('slidestop.logging', function (event, ui) {
          data.endVal = ui.value;
          data.time = (Date.now() - startTime) / 1000;
          logFunc('SliderChanged', data);
        });
      },

      // Returns serialized component definition.
      serialize: function () {
        var result = $.extend(true, {}, component);

        if (!propertyName) {
          // No property binding. Just action script.
          // Update "initialValue" to represent current
          // value of the slider.
          result.initialValue = $slider.slider('value');
        }

        return result;
      }
    };

    initialize();

    // Return Public API object.
    return controller;
  };
});

define('common/views/select-box-view',[],function() {

  return function SelectBoxView(opts) {
    var id       = opts.id,
        options  = opts.options,
        label    = opts.label,
        labelOn  = opts.labelOn,
        onChange = opts.onChange,
        ignoreChangeEvent,
        $select,
        $wrapper;

    function changeHandler() {
      var index;

      if (ignoreChangeEvent) {
        // Ignore change event caused by the pulldown menu update. It prevents from infinite loop of
        // pulldown - property updates.
        ignoreChangeEvent = false;
        return;
      }
      index = $(this).prop('selectedIndex');
      onChange(options[index], index);
    }

    return {

      update: function(selection) {
        // Set flag indicating that change event should be ignored by our own change listener. It
        // prevents from infinite loop like: pulldown update => property update => pulldown update =>
        // ... It's necessary as selectOption() call below will trigger change event of original
        // select. It's used by selectBoxIt to update its view.
        ignoreChangeEvent = true;
        // Retrieve all of the SelectBoxIt methods and call selectOption(). Note that we have to call
        // .toString() as numeric values are interpreted as option index by selectBoxIt. See:
        // http://gregfranko.com/jquery.selectBoxIt.js/#Methods
        // Also note that we have to call trim, as otherwise selectBoxIt won't recognize passed
        // string as an option if there are unnecessary whitespace characters.
        $select.data("selectBox-selectBoxIt").selectOption(selection.toString().trim());
      },

      render: function(parent) {
        var $options = [],
            $option, $label, ulEms, arrowEms, textMaxWidth, boxWidth;

        $select = $('<select>');

        options.forEach(function(option) {
          $option = $('<option>').html(option.text);
          $options.push($option);
          if (option.disabled) {
            $option.prop("disabled", option.disabled);
          }
          if (option.selected) {
            $option.prop("selected", option.selected);
          }
          // allow pulldowns to have falsy values, such as 0.
          if (option.value !== undefined) {
            $option.prop("value", option.value);
          }
          $select.append($option);
        });

        $select.change(changeHandler);

        // First append label to wrapper, then <select>
        $wrapper = $('<div>').attr('id', id);
        if (label) {
          $label = $("<span>").text(label);
          $label.addClass("label");
          $label.addClass(labelOn === "top" ? "on-top" : "on-left");
          $wrapper.append($label);
        }
        $wrapper.append($select);

        // Must call selectBoxIt after appending to wrapper
        $select.selectBoxIt();
        this.$element = $select;

        $wrapper.find(".selectboxit").css("width", "auto");

        // SelectBoxIt assumes that all select boxes are always going to have a width
        // set in CSS (default 220px). This doesn't work for us, as we don't know how
        // wide the content is going to be. Instead we have to measure the needed width
        // of the internal ul list, and use that to define the width of the select box.
        //
        // This issue has been raised in SelectBoxIt:
        // https://github.com/gfranko/jquery.selectBoxIt.js/issues/129
        //
        // However, this is still problematic because we haven't added the element to
        // the page yet. This $().measure function allows us to embed the element hidden
        // on the page first to allow us to check the required width.

        // ems for a given pixel size
        function pxToEm(input) {
          var emSize = parseFloat(parent.css("font-size"));
          return input / emSize;
        }

        function width() {
          return this.width();
        }

        ulEms    = pxToEm($wrapper.measure(width, "ul", parent));
        arrowEms = pxToEm($wrapper.measure(width, ".selectboxit-arrow-container", parent));

        textMaxWidth = ulEms+"em";
        boxWidth  = (ulEms + arrowEms + 0.3)+"em";

        $wrapper.find(".selectboxit").css("width", boxWidth);
        $wrapper.find(".selectboxit-text").css("max-width", textMaxWidth);

        // set hidden select box dimensions too, for mobile devices
        $wrapper.find(".selectboxit-container select").css({
          width: boxWidth,
          height: "100%"
        });

        return $wrapper;
      },

      get $element() {
        return $wrapper;
      },

      refresh: function() {
        // grab the SelectBoxIt instance and call into it
        $select.data('selectBox-selectBoxIt').refresh();
      },

      destroy: function() {
        $select.data('selectBox-selectBoxIt').destroy();
        $wrapper.remove();
      }
    };
  };
});

/*global require, define, $ */

define('common/controllers/pulldown-controller',['common/controllers/interactive-metadata','common/validator','common/controllers/disablable','common/controllers/help-icon-support','common/views/select-box-view','common/jquery-plugins'],function () {

  var metadata        = require('common/controllers/interactive-metadata'),
      validator       = require('common/validator'),
      disablable      = require('common/controllers/disablable'),
      helpIconSupport = require('common/controllers/help-icon-support'),
      SelectBoxView   = require('common/views/select-box-view');

      require('common/jquery-plugins');

  return function PulldownController(component, interactivesController) {
        // Public API.
    var controller,
        model,
        scriptingAPI,
        // Logging function, can be injected by #enableLogging call.
        logAction,
        // Options definitions from component JSON definition.
        options,
        view,
        $element;

    function updatePulldown() {
      if (component.property !== undefined) {
        view.update(model.get(component.property));
      }
    }

    function updatePulldownDisabledState() {
      var description = model.getPropertyDescription(component.property);
      controller.setDisabled(description.getFrozen());
    }

    function logChange(optionSpec) {
      if (!logAction) return; // logging is not enabled
      var data = {id: component.id, selected: optionSpec.text};
      if (component.label) data.label = component.label;
      if (component.property) {
        data.property = component.property;
        data.value = optionSpec.value;
      }
      logAction('PulldownChanged', data);
    }

    function initialize() {
      var parent = interactivesController.interactiveContainer,
          i, len;

      model = interactivesController.getModel();
      scriptingAPI = interactivesController.getScriptingAPI();

      // Validate component definition, use validated copy of the properties.
      component = validator.validateCompleteness(metadata.pulldown, component);
      // Validate pulldown options too.
      options = component.options;
      for (i = 0, len = options.length; i < len; i++) {
        options[i] = validator.validateCompleteness(metadata.pulldownOption, options[i]);
      }

      view = new SelectBoxView({
        id: component.id,
        options: options,
        label: component.label,
        labelOn: component.labelOn,
        onChange: function(option) {
          if (option.action) {
            scriptingAPI.makeFunctionInScriptContext(option.action)();
          } else if (option.value !== undefined) {
            scriptingAPI.api.set(component.property, option.value);
          }
          logChange(option);
        }
      });

      $element = view.render(parent);

      $element
        .addClass("interactive-pulldown")
        .addClass("component");

      if (component.tooltip) {
        $element.attr("title", component.tooltip);
      }

      disablable(controller, component);
      helpIconSupport(controller, component, interactivesController.helpSystem);
    }

    // Public API.
    controller = {
      modelLoadedCallback: function () {
        scriptingAPI = interactivesController.getScriptingAPI();
        if (component.property !== undefined) {
          if (model) {
            model.removeObserver(component.property, updatePulldown);
            model.removePropertyDescriptionObserver(component.property, updatePulldownDisabledState);
          }
          model = interactivesController.getModel();
          // Register listener for property.
          model.addObserver(component.property, updatePulldown);
          model.addPropertyDescriptionObserver(component.property, updatePulldownDisabledState);
          // Perform initial pulldown setup.
        } else {
          model = interactivesController.getModel();
        }
        updatePulldown();
      },

      enableLogging: function (logFunc) {
        logAction = logFunc;
      },

      // Returns view container.
      getViewContainer: function () {
        return $element;
      },

      // Returns serialized component definition.
      serialize: function () {
        var i, len, $options;
        if (component.property === undefined) {
          // When property binding is not defined, we need to keep track
          // which option is currently selected.
          $options = $element.find('option');
          for (i = 0, len = options.length; i < len; i++) {
            if ($($options[i]).prop("selected")) {
              options[i].selected = true;
            } else {
              delete options[i].selected;
            }
          }
        }
        // Note that 'options' array above is a reference to component.options array.
        // Every thing is updated, return a copy.
        return $.extend(true, {}, component);
      }
    };

    initialize();

    // Return Public API object.
    return controller;
  };
});

/*global define, $*/

define('common/controllers/joystick-controller',['common/controllers/interactive-metadata','common/validator','common/controllers/disablable','common/controllers/help-icon-support'],function () {

  var metadata        = require('common/controllers/interactive-metadata'),
      validator       = require('common/validator'),
      disablable      = require('common/controllers/disablable'),
      helpIconSupport = require('common/controllers/help-icon-support');

  return function JoystickController(component, interactivesController) {
    var propertyName, actionFunc, initialValue,
        title, labels, displayValue, displayFunc,
        // View elements.
        $elem,
        $container,
        $title,
        $labelN,$labelS,$labelE,$labelW,
        $joystickBase,
        $joystickHandle,
        $valueText,
        model,
        scriptingAPI,
        // Public API object.
        controller,
        valueChanged,
        hasBeenSetUp = false,
        base = {}, joystick = {},

        // Updates joystick using model property. Used in modelLoadedCallback.
        // Make sure that this function is only called when:
        // a) model is loaded,
        // b) joystick is bound to some property.
        updateJoystick = function (firstTime) {
          var value = interactivesController.getModel().get(propertyName);
          if (firstTime) { // FIXME This disables any changes coming from outside of our component...
            moveJoystickTo(value);
          }
          if (displayValue) {
            $valueText.text(displayFunc(value));
          }
        },
        updateJoystickDisabledState = function () {
          var description = model.getPropertyDescription(propertyName);
          controller.setDisabled(description.getFrozen());
        };

    function bindTargets() {
      // Bind action or/and property, process other options.
      if (component.action) {
        // The 'action' property is a source of a function which assumes we pass it a parameter
        // called 'value'.
        actionFunc = scriptingAPI.makeFunctionInScriptContext('value', component.action);
        valueChanged = function(value) {
          actionFunc(value);
          if (displayValue) {
            $valueText.text(displayFunc(value));
          }
        };
      }

      if (propertyName) {
        valueChanged = function(value) {
          if (model) model.properties[propertyName] = value;
          if (displayValue) {
            $valueText.text(displayFunc(value));
          }
        };
      }

      if (displayValue) {
        displayFunc = scriptingAPI.makeFunctionInScriptContext('value', displayValue);
      }
    }

    function setup() {
      $joystickHandle.draggable({
          revert: false,    // set to true to have joystick slide back to center
          create: function() {
            init();
          },
          drag: function (event, ui) {
            var loc = limitXY(ui.position.left+joystick.halfWidth, ui.position.top+joystick.halfHeight);
            if (loc) {
              ui.position.left = loc.x-joystick.halfWidth;
              ui.position.top = loc.y-joystick.halfHeight;
            }

            // Normalize x/y to range from -1 to 1
            var rel_left = (ui.position.left - joystick.startLeft)/(base.radius - joystick.halfWidth);
            var rel_top = (joystick.startTop - ui.position.top)/(base.radius - joystick.halfHeight);
            joystickMoved(rel_left, rel_top);
          },
          stop: function () {
            //$('#coords').html("&nbsp;");
          }
      });
    }

    function init() {
      if (hasBeenSetUp) return;
      hasBeenSetUp = true;

      base.width = $joystickBase[0].offsetWidth;
      base.height = $joystickBase[0].offsetHeight;
      base.top = $joystickBase[0].offsetTop;
      base.left = $joystickBase[0].offsetLeft;
      base.center = [base.width / 2, base.height / 2];
      base.radius = base.width / 2;

      joystick.startLeft = parseInt($joystickHandle.css("left"));
      joystick.startTop = parseInt($joystickHandle.css("top"));

      $joystickHandle.data("startLeft", joystick.startLeft);
      $joystickHandle.data("startTop", joystick.startTop);

      joystick.halfWidth = $joystickHandle[0].offsetWidth/2;
      joystick.halfHeight = $joystickHandle[0].offsetHeight/2;
    }

    function limitXY(x, y) {
      var dist = distance([x, y], base.center);
      if (dist <= base.radius - joystick.halfWidth) {
        return null;
      } else {
        x = x - base.center[0];
        y = y - base.center[1];
        var radians = Math.atan2(y, x);
        return {
          x: Math.cos(radians) * (base.radius-joystick.halfWidth) + base.center[0],
          y: Math.sin(radians) * (base.radius-joystick.halfWidth) + base.center[1]
        };
      }
    }

    function distance(dot1, dot2) {
      var x1 = dot1[0],
          y1 = dot1[1],
          x2 = dot2[0],
          y2 = dot2[1];
      return Math.sqrt(Math.pow(x1 - x2, 2) + Math.pow(y1 - y2, 2));
    }

    function joystickMoved(x, y) {
      var magnitude = Math.sqrt(x*x + y*y) * component.scale,
          direction = (Math.atan2(y, x) + 2*Math.PI) % (2*Math.PI),
          data = {magnitude: magnitude, direction: direction};

      // Send the new value
      if (valueChanged) valueChanged(data);
    }

    function moveJoystickTo(value) {
      // Set the joystick in the right position
      var mag = (base.radius - joystick.halfWidth) * value.magnitude / component.scale, // Normalized to -radius to radius
          dx = mag * Math.cos(value.direction),
          dy = mag * Math.sin(value.direction),
          startLeft = base.center[0] - joystick.halfWidth + dx,
          startTop = base.center[1] - joystick.halfWidth - dy; // invert the y direction

      $joystickHandle.css({top: startTop, left: startLeft});
    }

    function initialize() {
      //
      // Initialize.
      //
      scriptingAPI = interactivesController.getScriptingAPI();
      model = interactivesController.getModel();
      // Validate component definition, use validated copy of the properties.
      component = validator.validateCompleteness(metadata.joystick, component);
      propertyName = component.property;
      initialValue = component.initialValue;
      title = component.title;
      labels = component.labels;
      displayValue = component.displayValue;

      model = interactivesController.getModel();

      if (propertyName === undefined && initialValue === undefined) initialValue = { magnitude: 0, direction: 0 };

      // Setup view.
      // <div id="interactive-joystick">
      //   <p class="title">Wind</p>
      //   <div id="joystick-base">
      //       <div id="joystick-handle"></div>
      //   </div>
      //   <span id="label n">N</span>
      //   <span id="label e">E</span>
      //   <span id="label s">S</span>
      //   <span id="label w">W</span>
      //   <div id="joystick-value">0 MPH</div>
      // </div>
      $container = $('<div class="container">');
      $title = $('<div class="title">' + title + '</div>');

      $joystickBase = $('<div class="base">').attr('id', component.id);
      $joystickHandle = $('<div class="handle">');
      $joystickHandle.appendTo($joystickBase);

      $labelN = $('<div class="label n">' + labels.n + '</div>');
      $labelS = $('<div class="label s">' + labels.s + '</div>');
      $labelW = $('<div class="label w">' + labels.w + '</div>');
      $labelE = $('<div class="label e">' + labels.e + '</div>');

      $container.append($labelN)
                .append($labelW)
                .append($joystickBase)
                .append($labelE)
                .append($labelS);

      $elem = $('<div class="interactive-joystick">')
                .append($title)
                .append($container);

      // Each interactive component has to have class "component".
      $elem.addClass("component");

      $valueText = $('<div class="value"></div>');
      $elem.append($valueText);

      if (component.tooltip) {
        $elem.attr("title", component.tooltip);
      }

      disablable(controller, component);
      helpIconSupport(controller, component, interactivesController.helpSystem);

      // Apply custom width and height settings.
      // Also not that we set dimensions of the most outer container, not slider.
      // Slider itself will always follow dimensions of container DIV.
      // We have to do it that way to ensure that labels refer correct dimensions.
      $elem.css({
        "width": component.width,
        "height": component.height
      });
      // Call resize function to support complex resizing when height is different from "auto".
      controller.resize(true);

      // Finally set the initial value if it's provided.
      if (initialValue !== undefined && initialValue !== null) {
        moveJoystickTo(initialValue);
        if (displayValue) {
          $valueText.text(displayFunc(initialValue));
        }
      }
    }

    // Public API.
    controller = {
      // This callback should be triggered when model is loaded.
      modelLoadedCallback: function () {
        if (model && propertyName) {
          model.removeObserver(propertyName, updateJoystick);
          model.removePropertyDescriptionObserver(propertyName, updateJoystickDisabledState);
        }
        scriptingAPI = interactivesController.getScriptingAPI();
        model = interactivesController.getModel();
        if (propertyName) {
          model.addPropertiesListener([propertyName], updateJoystick);
          model.addPropertyDescriptionObserver(propertyName, updateJoystickDisabledState);
        }

        bindTargets();

        setup();

        if (propertyName) {
          updateJoystick(true);
        }
      },

      // Returns view container (div).
      getViewContainer: function () {
        return $elem;
      },

      resize: function (fromSetup) {
        if (fromSetup) return;
        var width = $elem[0].clientWidth,
            height = $elem[0].clientHeight,
            emSize = parseFloat($elem.css('font-size')),
            baseHeight = height - 4.2*emSize, // subtract for title, value text, N-label, S-label and 0.1em padding on both top and bottom\
            labelsWidth = $labelE.outerWidth(true) + $labelW.outerWidth(true),
            baseWidth = width - labelsWidth,
            labelsOverflow = 0;

        if (baseWidth < 2*emSize) {
          labelsOverflow = Math.abs(2*emSize - baseWidth);
          baseWidth = 2*emSize;
        }

        var baseSize = baseWidth < baseHeight ? baseWidth : baseHeight,
            handleSize = baseSize * 0.3,
            containerHeight = baseSize + 2.2*emSize,
            centerX;

        if (labelsOverflow > 0) {
          var adjPct = (labelsWidth - labelsOverflow - 0.1*emSize) / labelsWidth;
          centerX = $labelW.outerWidth(true) * adjPct + 0.1*emSize + baseSize/2;
        } else {
          centerX = $labelW.outerWidth(true) + 0.1*emSize + baseSize/2;
        }

        $container.css({ width: width, height: containerHeight });

        $labelE.css({ left: centerX + baseSize/2 + 0.1*emSize });
        $labelW.css({ left: centerX - baseSize/2 - 0.1*emSize - $labelW[0].clientWidth });
        $labelN.css({ left: centerX - $labelN.outerWidth(true)/2 });
        $labelS.css({ left: centerX - $labelS.outerWidth(true)/2 });

        $joystickBase.css({ height: baseSize, width: baseSize, left: centerX - baseSize/2, top: 1.1*emSize, borderRadius: baseSize });
        $joystickHandle.css({ height: handleSize, width: handleSize, borderRadius: baseSize, left: baseSize/2 - handleSize/2, top: baseSize/2 - handleSize/2 });

        // update joystick cached info
        hasBeenSetUp = false;
        init();

        // update the actual joystick position to match the current value
        var value = interactivesController.getModel().get(propertyName);
        moveJoystickTo(value);
      },

      // Returns serialized component definition.
      serialize: function () {
        var result = $.extend(true, {}, component);

        if (!propertyName) {
          // No property binding. Just action script.
          // Update "initialValue" to represent current
          // value of the slider.
          result.initialValue = {magnitude: 0, direction: 0};
        }

        return result;
      }
    };

    initialize();

    // Return Public API object.
    return controller;
  };
});

/*global define, $*/

define('common/controllers/color-indicator-controller',['common/controllers/interactive-metadata','common/validator','common/controllers/help-icon-support'],function () {

  var metadata        = require('common/controllers/interactive-metadata'),
      validator       = require('common/validator'),
      helpIconSupport = require('common/controllers/help-icon-support');

  return function ColorIndicatorController(component, interactivesController) {
    var propertyName, initialValue,
        title, colorFunc,
        // View elements.
        $elem,
        $title,
        $swatch,
        model,
        scriptingAPI,
        // Public API object.
        controller,

        // Updates joystick using model property. Used in modelLoadedCallback.
        // Make sure that this function is only called when:
        // a) model is loaded,
        // b) joystick is bound to some property.
        updateColorIndicator = function () {
          var value = interactivesController.getModel().get(propertyName);

          // Set the new color
          var color = colorFunc(value); // "hsl("+value+",100%,50%)";
          $swatch.css("background-color", color);
        };

    function initialize() {
      //
      // Initialize.
      //
      scriptingAPI = interactivesController.getScriptingAPI();
      model = interactivesController.getModel();
      // Validate component definition, use validated copy of the properties.
      component = validator.validateCompleteness(metadata.colorIndicator, component);
      propertyName = component.property;
      initialValue = component.initialValue;
      title = component.title;

      colorFunc = scriptingAPI.makeFunctionInScriptContext('value', component.colorValue);

      model = interactivesController.getModel();

      $title = $('<div class="title">' + title + '</div>');
      $swatch = $('<div class="swatch"></div>');

      $elem = $('<div class="interactive-color-indicator">')
                .append($title)
                .append($swatch);

      // Each interactive component has to have class "component".
      $elem.addClass("component");

      if (component.tooltip) {
        $elem.attr("title", component.tooltip);
      }

      helpIconSupport(controller, component, interactivesController.helpSystem);

      // Apply custom width and height settings.
      // Also not that we set dimensions of the most outer container, not slider.
      // Slider itself will always follow dimensions of container DIV.
      // We have to do it that way to ensure that labels refer correct dimensions.
      $elem.css({
        "width": component.width,
        "height": component.height
      });
      // Call resize function to support complex resizing when height is different from "auto".
      controller.resize();
    }

    // Public API.
    controller = {
      // This callback should be triggered when model is loaded.
      modelLoadedCallback: function () {
        if (model && propertyName) {
          model.removeObserver(propertyName, updateColorIndicator);
        }
        scriptingAPI = interactivesController.getScriptingAPI();
        model = interactivesController.getModel();
        if (propertyName) {
          model.addPropertiesListener([propertyName], updateColorIndicator);
        }

        if (propertyName) {
          updateColorIndicator();
        }
      },

      // Returns view container (div).
      getViewContainer: function () {
        return $elem;
      },

      resize: function () {
      },

      // Returns serialized component definition.
      serialize: function () {
        return $.extend(true, {}, component);
      }
    };

    initialize();

    // Return Public API object.
    return controller;
  };
});

/*global define */

// Simple wrapper for cloning and restoring hash of arrays.
// Such structure is widely used in md2d engine for keeping
// state of various objects (like atoms and obstacles).
// Use it in the following way:
// var obj = saveRestoreWrapper(hashOfArrays)
// var state = obj.clone();
// (...)
// obj.restore(state);

define('common/models/engines/clone-restore-wrapper',['require','arrays'],function (require) {
  // Dependencies.
  var arrays = require('arrays');

  return function CloneRestoreWrapper(hashOfArrays, options) {
    options = options || {};

    // Public API.
    var ret = {
      // Clone hash of arrays
      clone: function() {
        var copy = {},
            prop;

        for (prop in hashOfArrays) {
          if (hashOfArrays.hasOwnProperty(prop)) {
            copy[prop] = arrays.clone(hashOfArrays[prop]);
          }
        }

        return copy;
      }
    };

    // Restore internal arrays using saved state. 2 paths, depending on options.padArraysWithZeroes
    if (options.padArraysWithZeroes) {
      ret.restore = function(state) {
        var prop, target, i, j;

        for (prop in hashOfArrays) {
          if (hashOfArrays.hasOwnProperty(prop)) {
            target = hashOfArrays[prop];
            arrays.copy(state[prop], target);
            for (i = state[prop].length, j = target.length; i < j; i++) {
              target[i] = 0;
            }
          }
        }
      };
    } else {
      ret.restore = function(state) {
        var prop;

        for (prop in hashOfArrays) {
          if (hashOfArrays.hasOwnProperty(prop)) {
            arrays.copy(state[prop], hashOfArrays[prop]);
          }
        }
      };
    }

    return ret;
  };

});

/*global define: true */
/** Provides a few simple helper functions for converting related unit types.

    This sub-module doesn't do unit conversion between compound unit types (e.g., knowing that kg*m/s^2 = N)
    only simple scaling between units measuring the same type of quantity.
*/

// Prefer the "per" formulation to the "in" formulation.
//
// If KILOGRAMS_PER_AMU is 1.660540e-27 we know the math is:
// "1 amu * 1.660540e-27 kg/amu = 1.660540e-27 kg"
// (Whereas the "in" forumulation might be slighty more error prone:
// given 1 amu and 6.022e-26 kg in an amu, how do you get kg again?)

// These you might have to look up...

// Module can be used both in Node.js environment and in Web browser
// using RequireJS. RequireJS Optimizer will strip out this if statement.


define('models/md2d/models/engine/constants/units',['require','exports','module'],function (require, exports, module) {

  var KILOGRAMS_PER_DALTON  = 1.660540e-27,
      COULOMBS_PER_ELEMENTARY_CHARGE = 1.602177e-19,

      // 1 eV = 1 e * 1 V = (COULOMBS_PER_ELEMENTARY_CHARGE) C * 1 J/C
      JOULES_PER_EV = COULOMBS_PER_ELEMENTARY_CHARGE,

      // though these are equally important!
      SECONDS_PER_FEMTOSECOND = 1e-15,
      METERS_PER_NANOMETER    = 1e-9,
      ANGSTROMS_PER_NANOMETER = 10,
      GRAMS_PER_KILOGRAM      = 1000,

      types = {
        TIME: "time",
        LENGTH: "length",
        MASS: "mass",
        ENERGY: "energy",
        ENTROPY: "entropy",
        CHARGE: "charge",
        INVERSE_QUANTITY: "inverse quantity",

        FARADS_PER_METER: "farads per meter",
        METERS_PER_FARAD: "meters per farad",

        FORCE: "force",
        VELOCITY: "velocity",

        // unused as of yet
        AREA: "area",
        PRESSURE: "pressure"
      },

    unit,
    ratio,
    convert;

  /**
    In each of these units, the reference type we actually use has value 1, and conversion
    ratios for the others are listed.
  */
  exports.unit = unit = {

    FEMTOSECOND: { name: "femtosecond", value: 1,                       type: types.TIME },
    SECOND:      { name: "second",      value: SECONDS_PER_FEMTOSECOND, type: types.TIME },

    NANOMETER:   { name: "nanometer", value: 1,                           type: types.LENGTH },
    ANGSTROM:    { name: "Angstrom",  value: 1 * ANGSTROMS_PER_NANOMETER, type: types.LENGTH },
    METER:       { name: "meter",     value: 1 * METERS_PER_NANOMETER,    type: types.LENGTH },

    DALTON:   { name: "Dalton",   value: 1,                                             type: types.MASS },
    GRAM:     { name: "gram",     value: 1 * KILOGRAMS_PER_DALTON * GRAMS_PER_KILOGRAM, type: types.MASS },
    KILOGRAM: { name: "kilogram", value: 1 * KILOGRAMS_PER_DALTON,                      type: types.MASS },

    MW_ENERGY_UNIT: {
      name: "MW Energy Unit (Dalton * nm^2 / fs^2)",
      value: 1,
      type: types.ENERGY
    },

    JOULE: {
      name: "Joule",
      value: KILOGRAMS_PER_DALTON *
             METERS_PER_NANOMETER * METERS_PER_NANOMETER *
             (1/SECONDS_PER_FEMTOSECOND) * (1/SECONDS_PER_FEMTOSECOND),
      type: types.ENERGY
    },

    EV: {
      name: "electron volt",
      value: KILOGRAMS_PER_DALTON *
              METERS_PER_NANOMETER * METERS_PER_NANOMETER *
              (1/SECONDS_PER_FEMTOSECOND) * (1/SECONDS_PER_FEMTOSECOND) *
              (1/JOULES_PER_EV),
      type: types.ENERGY
    },

    EV_PER_KELVIN:     { name: "electron volts per Kelvin", value: 1,                 type: types.ENTROPY },
    JOULES_PER_KELVIN: { name: "Joules per Kelvin",         value: 1 * JOULES_PER_EV, type: types.ENTROPY },

    ELEMENTARY_CHARGE: { name: "elementary charge", value: 1,                             type: types.CHARGE },
    COULOMB:           { name: "Coulomb",           value: COULOMBS_PER_ELEMENTARY_CHARGE, type: types.CHARGE },

    INVERSE_MOLE: { name: "inverse moles", value: 1, type: types.INVERSE_QUANTITY },

    FARADS_PER_METER: { name: "Farads per meter", value: 1, type: types.FARADS_PER_METER },

    METERS_PER_FARAD: { name: "meters per Farad", value: 1, type: types.METERS_PER_FARAD },

    MW_FORCE_UNIT: {
      name: "MW force units (Dalton * nm / fs^2)",
      value: 1,
      type: types.FORCE
    },

    NEWTON: {
      name: "Newton",
      value: 1 * KILOGRAMS_PER_DALTON * METERS_PER_NANOMETER * (1/SECONDS_PER_FEMTOSECOND) * (1/SECONDS_PER_FEMTOSECOND),
      type: types.FORCE
    },

    EV_PER_NM: {
      name: "electron volts per nanometer",
      value: 1 * KILOGRAMS_PER_DALTON * METERS_PER_NANOMETER * METERS_PER_NANOMETER *
             (1/SECONDS_PER_FEMTOSECOND) * (1/SECONDS_PER_FEMTOSECOND) *
             (1/JOULES_PER_EV),
      type: types.FORCE
    },

    MW_VELOCITY_UNIT: {
      name: "MW velocity units (nm / fs)",
      value: 1,
      type: types.VELOCITY
    },

    METERS_PER_SECOND: {
      name: "meters per second",
      value: 1 * METERS_PER_NANOMETER * (1 / SECONDS_PER_FEMTOSECOND),
      type: types.VELOCITY
    }

  };


  /** Provide ratios for conversion of one unit to an equivalent unit type.

     Usage: ratio(units.GRAM, { per: units.KILOGRAM }) === 1000
            ratio(units.GRAM, { as: units.KILOGRAM }) === 0.001
  */
  exports.ratio = ratio = function(from, to) {
    var checkCompatibility = function(fromUnit, toUnit) {
      if (fromUnit.type !== toUnit.type) {
        throw new Error("Attempt to convert incompatible type '" + fromUnit.name + "'' to '" + toUnit.name + "'");
      }
    };

    if (to.per) {
      checkCompatibility(from, to.per);
      return from.value / to.per.value;
    } else if (to.as) {
      checkCompatibility(from, to.as);
      return to.as.value / from.value;
    } else {
      throw new Error("units.ratio() received arguments it couldn't understand.");
    }
  };

  /** Scale 'val' to a different unit of the same type.

    Usage: convert(1, { from: unit.KILOGRAM, to: unit.GRAM }) === 1000
  */
  exports.convert = convert = function(val, fromTo) {
    var from = fromTo && fromTo.from,
        to   = fromTo && fromTo.to;

    if (!from) {
      throw new Error("units.convert() did not receive a \"from\" argument");
    }
    if (!to) {
      throw new Error("units.convert() did not receive a \"to\" argument");
    }

    return val * ratio(to, { per: from });
  };
});

/*global define: true */
/*jslint loopfunc: true */

/** A list of physical constants. To access any given constant, require() this module
    and call the 'as' method of the desired constant to get the constant in the desired unit.

    This module also provides a few helper functions for unit conversion.

    Usage:
      var constants = require('./constants'),

          ATOMIC_MASS_IN_GRAMS = constants.ATOMIC_MASS.as(constants.unit.GRAM),

          GRAMS_PER_KILOGRAM = constants.ratio(constants.unit.GRAM, { per: constants.unit.KILOGRAM }),

          // this works for illustration purposes, although the preferred method would be to pass
          // constants.unit.KILOGRAM to the 'as' method:

          ATOMIC_MASS_IN_KILOGRAMS = constants.convert(ATOMIC_MASS_IN_GRAMS, {
            from: constants.unit.GRAM,
            to:   constants.unit.KILOGRAM
          });
*/

// Module can be used both in Node.js environment and in Web browser
// using RequireJS. RequireJS Optimizer will strip out this if statement.


define('models/md2d/models/engine/constants/index',['require','exports','module','./units'],function (require, exports, module) {

  var units = require('./units'),
      unit  = units.unit,
      ratio = units.ratio,
      convert = units.convert,

      constants = {

        ELEMENTARY_CHARGE: {
          value: 1,
          unit: unit.ELEMENTARY_CHARGE
        },

        ATOMIC_MASS: {
          value: 1,
          unit: unit.DALTON
        },

        BOLTZMANN_CONSTANT: {
          value: 1.380658e-23,
          unit: unit.JOULES_PER_KELVIN
        },

        AVAGADRO_CONSTANT: {
          // N_A is numerically equal to Dalton per gram
          value: ratio( unit.DALTON, { per: unit.GRAM }),
          unit: unit.INVERSE_MOLE
        },

        PERMITTIVITY_OF_FREE_SPACE: {
          value: 8.854187e-12,
          unit: unit.FARADS_PER_METER
        }
      },

      constantName, constant;


  // Derived units
  constants.COULOMB_CONSTANT = {
    value: 1 / (4 * Math.PI * constants.PERMITTIVITY_OF_FREE_SPACE.value),
    unit: unit.METERS_PER_FARAD
  };

  // Exports

  exports.unit = unit;
  exports.ratio = ratio;
  exports.convert = convert;

  // Require explicitness about units by publishing constants as a set of objects with only an 'as' property,
  // which will return the constant in the specified unit.

  for (constantName in constants) {
    if (constants.hasOwnProperty(constantName)) {
      constant = constants[constantName];

      exports[constantName] = (function(constant) {
        return {
          as: function(toUnit) {
            return units.convert(constant.value, { from: constant.unit, to: toUnit });
          }
        };
      }(constant));
    }
  }
});

/*global define: false*/
define('models/md2d/models/engine/utils',['require','arrays'],function(require) {

  var arrays = require('arrays');

  /**
    Extend all arrays in arrayContainer to `newLength`. Here, arrayContainer is expected to be `atoms`
    `elements`, `radialBonds`, etc. arrayContainer might be an array or an object.
    TODO: this is just interim solution, in the future only objects will be expected.
  */
  return {
    extendArrays: function(arrayContainer, newLength) {
      var i, len;
      if (Array.isArray(arrayContainer)) {
        // Array of arrays.
        for (i = 0, len = arrayContainer.length; i < len; i++) {
          if (arrays.isArray(arrayContainer[i]))
            arrayContainer[i] = arrays.extend(arrayContainer[i], newLength);
        }
      } else {
        // Object with arrays defined as properties.
        for (i in arrayContainer) {
          if(arrayContainer.hasOwnProperty(i)) {
            if (arrays.isArray(arrayContainer[i]))
              arrayContainer[i] = arrays.extend(arrayContainer[i], newLength);
          }
        }
      }
    }
  };
});

/*global define: true */

// Tiny module which contains definition of preferred
// array types used across whole Lab project.
// It checks whether typed arrays are available and type of browser
// (as typed arrays are slower in Safari).

define('common/array-types',['require','arrays'],function (require) {
  // Dependencies.
  var arrays = require('arrays'),

      // Check for Safari. Typed arrays are faster almost everywhere ... except Safari.
      notSafari = (function() {
        // Node.js?
        if (typeof navigator === 'undefined')
          return true;
        // Safari?
        var safarimatch  = / AppleWebKit\/([0123456789.+]+) \(KHTML, like Gecko\) Version\/([0123456789.]+) (Safari)\/([0123456789.]+)/,
            match = navigator.userAgent.match(safarimatch);
        return !match || !match[3];
      }()),

      useTyped = arrays.typed && notSafari;

  // Return all available types of arrays.
  // If you need to use new type, declare it here.
  return {
    floatType:  useTyped ? 'Float64Array' : 'regular',
    int32Type:  useTyped ? 'Int32Array'   : 'regular',
    int16Type:  useTyped ? 'Int16Array'   : 'regular',
    int8Type:   useTyped ? 'Int8Array'    : 'regular',
    uint16Type: useTyped ? 'Uint16Array'  : 'regular',
    uint8Type:  useTyped ? 'Uint8Array'   : 'regular'
  };

});

/*global define: false */

define('models/md2d/models/metadata',[],function() {

  return {
    mainProperties: {
      type: {
        defaultValue: "md2d",
        immutable: true
      },
      isBeingEdited: {
        defaultValue: false,
        serialize: false
      },
      imagePath: {
        defaultValue: "",
        immutable: true
      },
      minX: {
        serialize: false
      },
      maxX: {
        serialize: false
      },
      minY: {
        serialize: false
      },
      maxY: {
        serialize: false
      },
      width: {
        defaultValue: 10,
        unitType: "length",
        immutable: true
      },
      height: {
        defaultValue: 10,
        unitType: "length",
        immutable: true
      },
      unitsScheme: {
        defaultValue: "md2d"
      },
      lennardJonesForces: {
        defaultValue: true,
        storeInTickHistory: true
      },
      coulombForces: {
        defaultValue: true,
        storeInTickHistory: true
      },
      temperatureControl: {
        defaultValue: false,
        storeInTickHistory: true
      },
      targetTemperature: {
        defaultValue: 300,
        unitType: "temperature",
        storeInTickHistory: true
      },
      modelSampleRate: {
        defaultValue: "default"
      },
      gravitationalField: {
        defaultValue: false,
        unitType: "acceleration",
        storeInTickHistory: true
      },
      timeStep: {
        defaultValue: 1,
        unitType: "time",
        storeInTickHistory: true
      },
      dielectricConstant: {
        defaultValue: 1
      },
      realisticDielectricEffect: {
        defaultValue: true
      },
      solventForceFactor: {
        defaultValue: 1.25
      },
      solventForceType: {
        //  0 - vacuum.
        //  1 - water.
        // -1 - oil.
        defaultValue: 0
      },
      // Additional force applied to amino acids that depends on distance from the center of mass. It affects
      // only AAs which are pulled into the center of mass (to stabilize shape of the protein).
      // 'additionalSolventForceMult'      - maximum multiplier applied to solvent force when AA is in the center of mass.
      // 'additionalSolventForceThreshold' - maximum distance from the center of mass which triggers this increase of the force.
      // The additional force is described by the linear function of the AA distance from the center of mass
      // that passes through two points:
      // (0, additionalSolventForceMult) and (additionalSolventForceThreshold, 1).
      additionalSolventForceMult: {
        defaultValue: 4
      },
      additionalSolventForceThreshold: {
        defaultValue: 10,
        unitType: "length"
      },
      polarAAEpsilon: {
        defaultValue: -2
      },
      viscosity: {
        defaultValue: 1,
        storeInTickHistory: true
      },
      timeStepsPerTick: {
        defaultValue: 50,
        storeInTickHistory: true
      },
      DNAState: {
        defaultValue: "dna"
      },
      DNA: {
        defaultValue: "",
        validate: function (value) {
          if (/[agtc]/.test(value)) {
            value = value.toUpperCase();
          }
          if (/[^AGTC]/.test(value)) {
            throw new Error("DNA code on sense strand can be defined using only A, G, T or C characters.");
          }
          return value;
        }
      },
      DNAMutations: {
        defaultValue: true
      },
      useQuantumDynamics: {
        defaultValue: false
      },
      useChemicalReactions: {
        defaultValue: false
      },
      useDuration: {
        defaultValue: 'codap',
        storeInTickHistory: false,
        validate: function(value) {
          if (value === true || value === false || value === 'codap') {
            return value;
          }
          throw new Error("Invalid 'useDuration' value: " + value);
        }
      },
      requestedDuration: {
        defaultValue: null,
        storeInTickHistory: false
      },
      skipPECheckOnAddAtom: {
        defaultValue: false
      }
    },

    viewOptions: {
      viewPortWidth: {
        unitType: "length",
        immutable: true
      },
      viewPortHeight: {
        unitType: "length",
        immutable: true
      },
      viewPortZoom: {
        defaultValue: 1
      },
      viewPortX: {
        unitType: "length"
      },
      viewPortY: {
        unitType: "length"
      },
      viewPortDrag: {
        // Supported values:
        // - true  -> dragging is enabled.
        // - "x"   -> dragging is limited only to X axis.
        // - "y"   -> dragging is limited only yo Y axis.
        // - false -> dragging is disabled.
        defaultValue: false
      },
      backgroundColor: {
        defaultValue: "#eeeeee"
      },
      showClock: {
        defaultValue: true,
        storeInTickHistory: true
      },
      markColor: {
        defaultValue: "#f8b500"
      },
      atomRadiusScale: {
        defaultValue: 1
      },
      keShading: {
        defaultValue: false,
        storeInTickHistory: true
      },
      keShadingMinEnergy: {
        // Kinetic energy of an atom which is lower boundary for KE shading (white shading).
        defaultValue: 0,
        storeInTickHistory: true
      },
      keShadingMaxEnergy: {
        // Kinetic energy of an atom which is upper boundary for KE shading (red shading).
        defaultValue: 0.2,
        storeInTickHistory: true
      },
      chargeShading: {
        defaultValue: false,
        storeInTickHistory: true
      },
      chargeShadingStyle: {
        // "biology" (+ blue, - red) or "chemistry" (+ red, - blue).
        defaultValue: "biology",
        storeInTickHistory: true
      },
      aminoAcidColorScheme: {
        defaultValue: "hydrophobicity"
      },
      aminoAcidLabels: {
        defaultValue: true,
      },
      useThreeLetterCode: {
        // Amino acid labels type - single letter (false) or three letters (true).
        defaultValue: true
      },
      showChargeSymbols: {
        defaultValue: true
      },
      showVDWLines: {
        defaultValue: false,
        storeInTickHistory: true
      },
      VDWLinesCutoff: {
        defaultValue: "medium"
      },
      showVelocityVectors: {
        defaultValue: false,
        storeInTickHistory: true
      },
      showForceVectors: {
        defaultValue: false,
        storeInTickHistory: true
      },
      showElectricField: {
        defaultValue: false,
        storeInTickHistory: true
      },
      electricFieldDensity: {
        defaultValue: 18, // it means 18 arrows per row
        storeInTickHistory: true
      },
      electricFieldColor: {
        // "auto" means color contrasting to background, black or white.
        // However any custom color can be specified.
        defaultValue: "auto"
      },
      showAtomTrace: {
        storeInTickHistory: true,
        defaultValue: false
      },
      atomTraceId: {
        storeInTickHistory: true,
        defaultValue: 0
      },
      images: {
        defaultValue: []
      },
      imageMapping: {
        defaultValue: {}
      },
      textBoxes: {
        defaultValue: []
      },
      xlabel: {
        defaultValue: false
      },
      ylabel: {
        defaultValue: false
      },
      xunits: {
        defaultValue: false
      },
      yunits: {
        defaultValue: false
      },
      controlButtons: {
        defaultValue: "play"
      },
      controlButtonStyle: {
        defaultValue: "video",
        propertyChangeInvalidates: false,
        // expectation is that this will be set by the interactive
        serialize: false
      },
      gridLines: {
        defaultValue: false
      },
      atomNumbers: {
        defaultValue: false
      },
      enableAtomTooltips: {
        defaultValue: false
      },
      enableKeyboardHandlers: {
        defaultValue: true
      },
      atomTraceColor: {
        defaultValue: "#6913c5"
      },
      velocityVectors: {
        defaultValue: {
          color: "#000",
          width: 0.01,
          length: 2
        }
      },
      forceVectors: {
        defaultValue: {
          color: "#169C30",
          width: 0.01,
          length: 2
        }
      },
      forceVectorsDirectionOnly: {
        defaultValue: false
      },
      onAtomDrag: {
        // Atom dragging can either start translation or rotation of the molecule.
        // Behavior which is not default can be activated if user holds Alt / Opt key while dragging.
        // Available options: 'translate', 'rotate'.
        defaultValue: 'translate'
      }
    },

    atom: {
      // Required properties:
      x: {
        required: true,
        unitType: "length"
      },
      y: {
        required: true,
        unitType: "length"
      },
      // Optional properties:
      element: {
        defaultValue: 0
      },
      vx: {
        defaultValue: 0,
        unitType: "velocity"
      },
      vy: {
        defaultValue: 0,
        unitType: "velocity"
      },
      ax: {
        defaultValue: 0,
        unitType: "acceleration",
        serialize: false
      },
      ay: {
        defaultValue: 0,
        unitType: "acceleration",
        serialize: false
      },
      charge: {
        defaultValue: 0,
        unitType: "charge"
      },
      friction: {
        defaultValue: 0,
        unitType: "dampingCoefficient"
      },
      radical: {
        defaultValue: 0
      },
      visible: {
        // Note that it also accepts fractional values, e.g. 0.5 (=> atom will be semi-transparent).
        defaultValue: 1
      },
      pinned: {
        defaultValue: 0
      },
      marked: {
        defaultValue: 0
      },
      draggable: {
        defaultValue: 0
      },
      draggableWhenStopped: {
        defaultValue: 1
      },
      // Read-only values, can be set only by engine:
      radius: {
        readOnly: true,
        unitType: "length",
        serialize: false
      },
      px: {
        readOnly: true,
        unitType: "momentum",
        serialize: false
      },
      py: {
        readOnly: true,
        unitType: "momentum",
        serialize: false
      },
      speed: {
        readOnly: true,
        unitType: "velocity",
        serialize: false
      },
      mass: {
        // Mass is defined per element, but this is a convenience shortcut for
        // quick access to mass of the given atom.
        readOnly: true,
        unitType: "mass",
        serialize: false
      },
      excitation: {
        // [Quantum Dynamics plugin]
      },
      sharedElectrons: {
        // [Chemical Reactions plugin]
      }
    },

    element: {
      mass: {
        defaultValue: 120,
        unitType: "mass"
      },
      sigma: {
        defaultValue: 0.3,
        unitType: "length"
      },
      epsilon: {
        defaultValue: -0.1,
        unitType: "energy"
      },
      radius: {
        unitType: "length",
        readOnly: true,
        serialize: false
      },
      color: {
        defaultValue: -855310
      }
    },

    pairwiseLJProperties: {
      element1: {
        defaultValue: 0
      },
      element2: {
        defaultValue: 0
      },
      sigma: {
        unitType: "length"
      },
      epsilon: {
        unitType: "energy"
      }
    },

    obstacle: {
      // Required properties:
      width: {
        unitType: "length",
        required: true
      },
      height: {
        unitType: "length",
        required: true
      },
      // Optional properties:
      x: {
        defaultValue: 0,
        unitType: "length"
      },
      y: {
        defaultValue: 0,
        unitType: "length"
      },
      mass: {
        defaultValue: Infinity,
        unitType: "mass"
      },
      vx: {
        defaultValue: 0,
        unitType: "velocity"
      },
      vy: {
        defaultValue: 0,
        unitType: "velocity"
      },
      // Externally applied horizontal acceleration
      externalAx: {
        defaultValue: 0,
        unitType: "acceleration"
      },
      // Externally applied vertical acceleration
      externalAy: {
        defaultValue: 0,
        unitType: "acceleration"
      },
      // Whether to render arrows for the externally applied acceleration externalAx and externalAy
      displayExternalAcceleration: {
        defaultValue: true
      },
      // Damping coefficient per mass unit (= acceleration / velocity = 1 / time)
      friction: {
        defaultValue: 0,
        unitType: "inverseTime"
      },
      // Pressure probe, west side.
      westProbe: {
        defaultValue: false
      },
      // Final value of pressure in Bars.
      westProbeValue: {
        unitType: "pressure",
        readOnly: true,
        serialize: false
      },
      // Pressure probe, north side.
      northProbe: {
        defaultValue: false
      },
      // Final value of pressure in Bars.
      northProbeValue: {
        unitType: "pressure",
        readOnly: true,
        serialize: false
      },
      // Pressure probe, east side.
      eastProbe: {
        defaultValue: false
      },
      // Final value of pressure in Bars.
      eastProbeValue: {
        unitType: "pressure",
        readOnly: true,
        serialize: false
      },
      // Pressure probe, south side.
      southProbe: {
        defaultValue: false
      },
      // Final value of pressure in Bars.
      southProbeValue: {
        unitType: "pressure",
        readOnly: true,
        serialize: false
      },
      // View options.
      color:{
        defaultValue: "rgb(128,128,128)"
      },
      visible: {
        defaultValue: true
      }
    },

    shape: {
      // Required properties:
      type: {
        defaultValue: "rectangle",
        required: true
      },
      width: {
        unitType: "length",
        required: true
      },
      height: {
        unitType: "length",
        required: true
      },
      // Optional properties:
      x: {
        defaultValue: 0,
        unitType: "length"
      },
      y: {
        defaultValue: 0,
        unitType: "length"
      },
      fence: {
        defaultValue: 0,
      },
      // View options.
      color: {
        defaultValue: "transparent"
      },
      lineColor: {
        defaultValue: "black"
      },
      lineDashes: {
        defaultValue: "none"
      },
      lineWeight: {
        defaultValue: 1
      },
      layer: {
        defaultValue: 1
      },
      layerPosition: {
        defaultValue: 1
      },
      visible: {
        defaultValue: 1
      }
    },

    line: {
      // Required properties:
      x1: {
        defaultValue: 0,
        required: true,
        unitType: "length"
      },
      y1: {
        defaultValue: 0,
        required: true,
        unitType: "length"
      },
      x2: {
        defaultValue: 0,
        required: true,
        unitType: "length"
      },
      y2: {
        defaultValue: 0,
        required: true,
        unitType: "length"
      },
      // Optional properties:
      beginStyle: {
        defaultValue: "none",
      },
      endStyle: {
        defaultValue: "none",
      },
      fence: {
        defaultValue: 0,
      },
      // View options.
      lineColor: {
        defaultValue: "black"
      },
      lineDashes: {
        defaultValue: "none"
      },
      lineWeight: {
        defaultValue: 1
      },
      layer: {
        defaultValue: 1
      },
      layerPosition: {
        defaultValue: 1
      },
      visible: {
        defaultValue: 1
      }
    },

    radialBond: {
      atom1: {
        defaultValue: 0
      },
      atom2: {
        defaultValue: 0
      },
      length: {
        unitType: "length",
        required: true
      },
      strength: {
        unitType: "stiffness",
        required: true
      },
      type: {
        defaultValue: 101
      }
    },

    angularBond: {
      atom1: {
        defaultValue: 0
      },
      atom2: {
        defaultValue: 0
      },
      atom3: {
        defaultValue: 0
      },
      strength: {
        unitType: "rotationalStiffness",
        required: true
      },
      angle: {
        unitType: "angle",
        required: true
      }
    },

    restraint: {
      atomIndex: {
        required: true
      },
      k: {
        defaultValue: 2000,
        unitType: "stiffness"
      },
      x0: {
        defaultValue: 0,
        unitType: "length"
      },
      y0: {
        defaultValue: 0,
        unitType: "length"
      }
    },

    electricField: {
      intensity: {
        defaultValue: 0.004
      },
      orientation: {
        defaultValue: "E"
      },
      shapeIdx: {
        // Optional, electric field boundaries can be limited to a shape. When 'null' is used,
        // the electric field will be applied to the whole model area.
        defaultValue: null
      }
    },

    textBox: {
      text: {
        defaultValue: ""
      },
      x: {
        defaultValue: 0,
        unitType: "length"
      },
      y: {
        defaultValue: 0,
        unitType: "length"
      },
      anchor: {
        defaultValue: "lower-left"
      },
      layer: {
        defaultValue: 1
      },
      width: {},
      height: {},
      frame: {},
      color: {},
      calloutPoint: {},
      backgroundColor: {
        defaultValue: "white"
      },
      strokeWidthEms: {
        defaultValue: 0.03
      },
      strokeOpacity: {
        defaultValue: 1.0
      },
      strokeColor: {
        defaultValue: "#000000"
      },
      rotate: {
        defaultValue: 0
      },
      fontSize: {
        defaultValue: 0.12 // defined in nm!
      },
      hostType: {},
      hostIndex: {},
      textAlign: {}
    },

    chemicalReactions: {
      updateInterval: {
        defaultValue: 10
      },
      createAngularBonds: {
        // When this option is set to true, the algorithm will add angular bonds between triplet
        // of atoms. Angle calculation is based on the energy minimization and valence electrons
        // count.
        defaultValue: true
      },
      noLoops: {
        // If this option is enabled, the algorithm will ensure that no molecule will form a loop.
        // Note that it can have impact on performance and in many cases won't be possible due to
        // valence electrons configuration anyway.
        defaultValue: false
      },
      valenceElectrons: {
        defaultValue: [1, 1, 7, 7]
      },
      bondEnergy: {
        defaultValue: {
          // This configuration means that default bond chemical energy is 6eV, however single bonds
          // between the same elements (like bond between 1 and 1) have a bit smaller chemical
          // energy equal to 4eV. You can freely modify this configuration. Note that you should
          // define "default" key if you don't specify all possible configurations.
          // Single bond is defined by "-" symbol, e.g. 0-1 is a single bond between element 0 and 1.
          // Double bond is defined by "=" symbol, e.g. 1=2 is a double bond between element 1 and 2.
          // Triple bond is defined by "#" symbol, e.g. 2#3 is a triple bond between element 2 and 3.
          "default": 6,
          "0-0": 4,
          "1-1": 4,
          "2-2": 4,
          "3-3": 4
        }
      },
      activationEnergy: {
        defaultValue: {
          // This configuration means that default activation energy is equal to 0.2eV.
          // If you need custom parameters for various combinations, you can add e.g.:
          // "1+2-2": 0.5,
          // "2+1-1": 5
          // what means that when element 1 collides with two bonded elements 2, activation
          // energy that causes bonds exchange is 0.5 eV. Similarly, when element 2 collides with
          // two bonded elements 1, activation energy that causes bonds exchange is 5 eV.
          // Note that format is important! Single element is first, then "+" sign, then pair
          // description.
          "default": 0.2

        }
      },
      bondProbability: {
        defaultValue: {
          // This configuration means that when two colliding atoms have 3 unpaired electrons
          // (e.g. their valence electron count is equal to 5), there is 80% chances that
          // single bond will be formed between them, 15% that double and 5% that triple.
          // If you need custom probability for a specific elements configuration, you can add e.g:
          // "1-2": [0.6, 0.3, 0.1]
          // what has analogical meaning, but these values are limited only to elements 1 and 2.
          "default": [0.8, 0.15, 0.05]
        },
        validate: function (value) {
          Object.keys(value).forEach(function (key) {
            var p = value[key];
            if (Math.abs(p[0] + p[1] + p[2] - 1) > 1e-3) {
              throw new Error("Bond type probability values should sum to one.");
            }
          });
          return value;
        }
      }
    },

    image: {
      imageUri: {
        required: true
      },
      imageX: {
        defaultValue: 0,
        required: true
      },
      imageY: {
        defaultValue: 0,
        required: true
      },
      imageHostType: {
        defaultValue: ""
      },
      imageHostIndex: {
        defaultValue: 0
      },
      imageLayer: {
        defaultValue: 1
      },
      imageLayerPosition: {
        defaultValue: 1
      },
      visible: {
        defaultValue: true
      },
      rotation: {
        defaultValue: 0
      },
      scale: {
        defaultValue: 1,
      },
      opacity: {
        defaultValue: 1
      }
    },

    quantumDynamics: {
      elementEnergyLevels: {
        defaultValue: []
      },
      photons: {
        defaultValue: {}
      },
      radiationlessEmissionProbability: {
        defaultValue: 1
      },
      lightSource: {
        defaultValue: {
          on: false,
          monochromatic: true,
          frequency: 1,
          radiationPeriod: 1000,
          numberOfBeams: 10,
          angleOfIncidence: 0
        }
      }
    },

    photon: {
      x: {
        serialize: true
      },
      y: {
        serialize: true
      },
      vx: {
        defaultValue: 0,
        serialize: true
      },
      vy: {
        defaultValue: 0,
        serialize: true
      },
      angularFrequency: {
        serialize: true
      }
    }
  };
});

/*global define */

/**
  This plugin adds quantum dynamics functionality to the MD2D engine.

  Datatable changes`
    atoms:
      excitation: an int representing the current level of excitation of an atom, from
        floor (0) to an arbitrary level. In this model each atom is assumed to have one
        single electron that can be excited to any of a finite number of levels. The
        actual energy of each level is defined by the atom's element

  New serialized properties:

    elementEnergyLevels: A 2-dimensional array defining energy levels for each element

*/


define('models/md2d/models/engine/plugins/quantum-dynamics',['require','common/models/engines/clone-restore-wrapper','common/dispatch-support','../constants/index','../utils','arrays','common/array-types','models/md2d/models/metadata','common/validator'],function(require) {

  // static variables
  var CloneRestoreWrapper = require('common/models/engines/clone-restore-wrapper'),
      DispatchSupport     = require('common/dispatch-support'),
      constants           = require('../constants/index'),
      utils               = require('../utils'),
      arrays              = require('arrays'),
      arrayTypes          = require('common/array-types'),
      metadata            = require('models/md2d/models/metadata'),
      validator           = require('common/validator'),

      // in reality, 6.626E-34 m^2kg/s. Classic MW uses 0.2 in its units (eV * fs)
      PLANCK_CONSTANT = constants.convert(0.2, { from: constants.unit.EV, to: constants.unit.MW_ENERGY_UNIT }),

      // MW uses a "tolerance band" to decide if a photon's energy matches an energy level gap.
      // Reference: https://github.com/concord-consortium/mw/blob/d3f621ba87825888737257a6cb9ac9e4e4f63f77/src/org/concord/mw2d/models/PhotonicExcitor.java#L28
      ENERGY_GAP_TOLERANCE = constants.convert(0.05, { from: constants.unit.EV, to: constants.unit.MW_ENERGY_UNIT }),

      // Speed of light.
      // in reality, about 300 nm/fs! Classic uses 0.2 in its units (0.1Å/fs), which is 0.002 nm/fs:
      C = 0.002,
      TWO_PI = 2 * Math.PI,

      // expected value of lifetime of excited energy state, in fs
      LIFETIME = 200,
      EMISSION_PROBABILITY_PER_FS = 1/LIFETIME,

      INFRARED = 2.5,
      ULTRAVIOLET = 14.5,

      // dispatch events from handlePhotonAtomCollision
      PHOTON_ABSORBED = 1,
      PHOTON_EMITTED = 2;

  function QuantumDynamics(engine, _properties) {

    var properties           = validator.validateCompleteness(metadata.quantumDynamics, _properties),

        api,
        dispatch             = new DispatchSupport("photonAbsorbed"),

        elementEnergyLevels  = properties.elementEnergyLevels,
        pRadiationless       = properties.radiationlessEmissionProbability,
        pStimulatedEmission  = 0,

        lightSource          = properties.lightSource,

        dimensions           = engine.getDimensions(),

        excitationTime       = [],

        modelTime,

        atoms,
        elements,
        photons,

        nextPhotonId = 0,

        getRandomFrequency = function() {
          return INFRARED + ((ULTRAVIOLET - INFRARED) * Math.random());
        },

        updateAtomsTable = function() {
          var length = atoms.x.length;

          atoms.excitation = arrays.create(length, 0, arrayTypes.int8Type);
        },

        createPhotonsTable = function(serializedPhotons) {
          var length = 0;

          if (serializedPhotons.x) {
            length = Math.ceil(serializedPhotons.x.length / 10) * 10;
          }

          photons =  {
            id    : arrays.create(length, 0, arrayTypes.uint16Type),
            x     : arrays.create(length, 0, arrayTypes.floatType),
            y     : arrays.create(length, 0, arrayTypes.floatType),
            vx    : arrays.create(length, 0, arrayTypes.floatType),
            vy    : arrays.create(length, 0, arrayTypes.floatType),
            angularFrequency : arrays.create(length, 0, arrayTypes.floatType)
          };
        },

        currentlyOperatedPairs = [],  // all pairs being currently operated on

        atom1Idx, atom2Idx,           // current pair of atoms during thermal excitation

        u1, u2,                       // temporary velocity-calculation variables
        w1, w2,
        dxFraction, dyFraction,

        numPhotons = 0,

        copyPhotonData = function(serializedPhotons) {
          if (!serializedPhotons || !serializedPhotons.x) {
            return;
          }
          ['x', 'y', 'vx', 'vy', 'angularFrequency'].forEach(function(key) {
            arrays.copy(serializedPhotons[key], photons[key]);
          });

          for (var i = 0; i < photons.x.length; i++) {
            if (photons.vx[i] || photons.vy[i]) {
              numPhotons++;
              photons.id[i] = nextPhotonId++;
            }
          }
        },

        // Iterate over all photon-atom pairs, and allow them to interact if "touching".
        //
        // If a photons and atom are close enough, one of the following may happen:
        //   - the photon is absorbed, exciting the atom's electron to a higher energy level
        //   - (NOT YET IMPLEMENTED) the photon is absorbed, ionizing the atoms' electron
        //   - (NOT YET IMPLEMENTED) the photon triggers stimulated emission of a second photon
        //   - (NOT YET IMPLEMENTED) the photon is scattered
        //   - or no interaction occurs (the photon and atom are unmodified)
        //
        handlePhotonAtomCollisions = function() {
          var numAtoms = engine.getNumberOfAtoms(),
              i, len,
              x, y,
              atomIndex,
              r, rsq,
              dx, dy,
              collisionResult;

          for (i = 0, len = photons.x.length; i < len; i++) {
            if (!photons.vx[i] && !photons.vy[i]) {
              continue;
            }

            x = photons.x[i];
            y = photons.y[i];

            // TODO. Consider using the cell list to narrow down the list of atoms to those in the
            // same cell as the photon.
            for (atomIndex = 0; atomIndex < numAtoms; atomIndex++) {
              dx = atoms.x[atomIndex] - x;
              dy = atoms.y[atomIndex] - y;
              r = atoms.radius[atomIndex];
              // TODO. Cache rsq values?
              rsq = r*r;

              if (dx*dx + dy*dy < rsq) {
                collisionResult = handlePhotonAtomCollision(i, atomIndex);
                if (collisionResult === PHOTON_ABSORBED) {
                  // Break from iteration over atoms, and move on to the next photon.
                  break;
                }
                // TODO. Handle stimulated emission by remembering a list of photons to create
                // after the loop over photons completes.
              }
            }
          }
        },

        handlePhotonAtomCollision = function(photonIndex, atomIndex) {
          if (Math.random() < pStimulatedEmission) {
            // TODO. Stimulated emission.
            return PHOTON_EMITTED;
          } else {
            var preciseEnergy = tryToAbsorbPhoton(photonIndex, atomIndex);
            if (preciseEnergy !== false && preciseEnergy > 0) {
              removePhoton(photonIndex);
              // For some reason Classic MW doesn't show initial frequency of the photon on the spectrometer.
              // It's updated first using "preciseEnergy". Do the same to be consistent.
              var newFreq = preciseEnergy / PLANCK_CONSTANT;
              dispatch.photonAbsorbed(newFreq);
              return PHOTON_ABSORBED;
            }
          }
          // TODO. Scatter photon (or not) depending on the model's "scatter probability".
        },

        // If the photon can be absorbed by exciting the atom's electron to a higher energy level,
        // then remove the photon, excite the electron, and return the precise energy. Otherwise, return false.
        tryToAbsorbPhoton = function(photonIndex, atomIndex) {
          if (!elementEnergyLevels) return;

          var energyLevels     = elementEnergyLevels[atoms.element[atomIndex]],
              energyLevelIndex = atoms.excitation[atomIndex],
              electronEnergy   = energyLevels[energyLevelIndex],
              photonEnergy     = photons.angularFrequency[photonIndex] * PLANCK_CONSTANT,
              i,
              nLevels;

          for (i = energyLevelIndex + 1, nLevels = energyLevels.length; i < nLevels; i++) {
            if (Math.abs(energyLevels[i] - electronEnergy - photonEnergy) < ENERGY_GAP_TOLERANCE) {
              atoms.excitation[atomIndex] = i;
              excitationTime[atomIndex] = modelTime;
              return energyLevels[i] - electronEnergy;
            }
          }
          return false;
        },

        // If a pair of atoms are close enough, QD interactions may occur.
        //
        // This is called at the end of every integration loop.
        thermallyExciteAndDeexciteAtoms = function(neighborList) {
          var N     = engine.getNumberOfAtoms(),
              nlist = neighborList.getList(),
              currentlyClosePairs = [],
              a1, a2,
              i, len,
              el1, el2,
              energyLevels1, energyLevels2,
              xi, yi, xij, yij, ijsq,
              avrSigma, avrSigmaSq,
              atomWasExcited, atomWasDeexcited;

          if (!elementEnergyLevels) return;

          // get all proximal pairs of atoms, using neighborList
          for (a1 = 0; a1 < N; a1++) {

            xi = atoms.x[a1];
            yi = atoms.y[a1];

            for (i = neighborList.getStartIdxFor(a1), len = neighborList.getEndIdxFor(a1); i < len; i++) {
              a2 = nlist[i];

              el1 = atoms.element[a1];
              el2 = atoms.element[a2];
              energyLevels1 = elementEnergyLevels[el1];
              energyLevels2 = elementEnergyLevels[el2];

              // if neither atom is of an element with energy levels, skip
              if (!energyLevels1.length && !energyLevels2.length) {
                continue;
              }

              // if we aren't close (within the avrSigma of two atoms), skip
              xij = xi - atoms.x[a2];
              yij = yi - atoms.y[a2];
              ijsq = xij * xij + yij * yij;
              avrSigma = 0.55 * (elements.sigma[el1] + elements.sigma[el2]);
              avrSigmaSq = avrSigma * avrSigma;

              if (ijsq >= avrSigmaSq) {
                continue;
              }

              currentlyClosePairs[a1] = a2;   // add this pair to our temporary list of close pairs

              if (currentlyOperatedPairs[a1] === a2) {
                // we have already operated on this pair, and the atoms have not yet
                // left each other's neighborhoods, so we skip so as not to operate
                // on them twice in one collision
                continue;
              }

              // first try to see if we can excite atoms
              atomWasExcited = tryToThermallyExciteAtoms(a1, a2);

              // if we didn't excite, see if this pair wants to de-excite
              if (!atomWasExcited) {
                atomWasDeexcited = tryToThermallyDeexciteAtoms(a1, a2);
              }

              if (atomWasExcited || atomWasDeexcited) {
                // add pair to our operation list
                currentlyOperatedPairs[a1] = a2;
                currentlyOperatedPairs[a2] = a1;
              }
            }
          }

          // go through list of currently-operated pairs, and if any of them aren't in
          // our temporary list of close pairs, they have left each other so we can
          // strike them from the list
          for (a1 = 0, len = currentlyOperatedPairs.length; a1 < len; a1++) {
            a2 = currentlyOperatedPairs[a1];
            if (!isNaN(a2)) {
              if (!(currentlyClosePairs[a1] === a2 || currentlyClosePairs[a2] === a1)) {
                delete currentlyOperatedPairs[a1];
                delete currentlyOperatedPairs[a2];
              }
            }
          }
        },

        // If a pair of atoms are close enough, and their relative KE is greater than
        // the energy required to reach a new excitation level of a random member of
        // the pair, increase the excitation level of that atom and adjust the velocity
        // of the pair as required.
        tryToThermallyExciteAtoms = function(a1, a2) {
          var atomWasExcited,
              selection;

          atom1Idx = a1;
          atom2Idx = a2;

          // excite a random atom, or pick the excitable one if only one can be excited
          selection = Math.random() < 0.5 ? atom1Idx : atom2Idx;
          atomWasExcited = tryToExciteAtom(selection);
          if (!atomWasExcited) {
            // if we couldn't excite the first, excite the other one
            atomWasExcited = tryToExciteAtom(atom1Idx+atom2Idx-selection);
          }

          return atomWasExcited;
        },

        // Excites an atom to a new energy level if the relative KE of the pair atom1Idx
        // and atom2Idx is high enough, and updates the velocities of atoms as necessary
        tryToExciteAtom = function(i) {
          var energyLevels   =   elementEnergyLevels[atoms.element[i]],
              currentEnergyLevel,
              currentElectronEnergy,
              relativeKE,
              energyRequired, highest,
              nextEnergyLevel, energyAbsorbed,
              j, jj;

          if (!energyLevels) return;

          computeVelocityComponents();

          relativeKE = getRelativeKE();

          currentEnergyLevel = atoms.excitation[i];
          currentElectronEnergy = energyLevels[currentEnergyLevel];

          // get the highest energy level above the current that the relative KE can reach
          for (j = currentEnergyLevel+1, jj = energyLevels.length; j < jj; j++) {
            energyRequired = energyLevels[j] - currentElectronEnergy;
            if (relativeKE < energyRequired) {
              break;
            }
            highest = j;
          }
          if (!highest) {
            // there is no higher energy level we can reach
            return false;
          }

          // assuming that all the energy levels above have the same chance of
          // getting the excited electron, we randomly pick one.
          highest = highest - currentEnergyLevel;
          nextEnergyLevel = Math.ceil(Math.random() * highest) + currentEnergyLevel;

          atoms.excitation[i] = nextEnergyLevel;
          excitationTime[i] = modelTime;
          energyAbsorbed = energyLevels[nextEnergyLevel] - currentElectronEnergy;
          updateVelocities(energyAbsorbed);
          return true;
        },

        computeVelocityComponents = function() {
          var dx = atoms.x[atom2Idx] - atoms.x[atom1Idx],
              dy = atoms.y[atom2Idx] - atoms.y[atom1Idx],
              normalizationFactor = 1 / Math.sqrt(dx*dx + dy*dy);

          dxFraction = dx * normalizationFactor;
          dyFraction = dy * normalizationFactor;

          // Decompose v1 into components u1 (parallel to d) and w1 (orthogonal to d)
          u1 = atoms.vx[atom1Idx] * dxFraction + atoms.vy[atom1Idx] * dyFraction;
          w1 = atoms.vy[atom1Idx] * dxFraction - atoms.vx[atom1Idx] * dyFraction;

          // Decompose v2 similarly
          u2 = atoms.vx[atom2Idx] * dxFraction + atoms.vy[atom2Idx] * dyFraction;
          w2 = atoms.vy[atom2Idx] * dxFraction - atoms.vx[atom2Idx] * dyFraction;
        },

        getRelativeKE = function() {
          var du = u2 - u1,
              m1 = atoms.mass[atom1Idx],
              m2 = atoms.mass[atom2Idx];

          return 0.5 * du * du * m1 * m2 / (m1 + m2);
        },

        updateVelocities = function(energyDelta) {
          var m1 = atoms.mass[atom1Idx],
              m2 = atoms.mass[atom2Idx],
              j  = m1 * u1 * u1 + m2 * u2 * u2 - energyDelta,
              g  = m1 * u1 + m2 * u2,
              v1 = (g - Math.sqrt(m2 / m1 * (j * (m1 + m2) - g * g))) / (m1 + m2),
              v2 = (g + Math.sqrt(m1 / m2 * (j * (m1 + m2) - g * g))) / (m1 + m2);

          atoms.vx[atom1Idx] = v1 * dxFraction - w1 * dyFraction;
          atoms.vy[atom1Idx] = v1 * dyFraction + w1 * dxFraction;
          atoms.vx[atom2Idx] = v2 * dxFraction - w2 * dyFraction;
          atoms.vy[atom2Idx] = v2 * dyFraction + w2 * dxFraction;
        },

        // If one atom has an electron in a higher energy state (and we didn't just excite this
        // pair) the atom may deexcite during a collision. This will either release a photon or will
        // increase the relative KE of the atoms (radiationless transition), with the probabilities
        // of each depending on the model settings.
        tryToThermallyDeexciteAtoms = function(a1, a2) {
          var selection,
              excitation1 = atoms.excitation[a1],
              excitation2 = atoms.excitation[a2];

          atom1Idx = a1;
          atom2Idx = a2;

          if (!excitation1 && !excitation2) {
            return false;
          }

          // excite a random atom, or pick the excitable one if only one can be excited
          if (!excitation1) {
            if (!readyToThermallyDeexcite(atom2Idx)) return false;
            selection = atom2Idx;
          } else if (!excitation2) {
            if (!readyToThermallyDeexcite(atom1Idx)) return false;
            selection = atom1Idx;
          } else {
            selection = Math.random() < 0.5 ? atom1Idx : atom2Idx;
            if (!readyToThermallyDeexcite(selection)) {
              selection = atom1Idx + atom2Idx - selection;
              if (!readyToThermallyDeexcite(selection)) {
                return false;
              }
            }
          }
          deexciteAtom(selection);
          return true;
        },

        readyToThermallyDeexcite = function(i) {
          if (modelTime > excitationTime[i] + LIFETIME) {
            return true;
          }
        },

        deexciteAtom = function(i) {
          var energyLevels   = elementEnergyLevels[atoms.element[i]],
              currentLevel   = atoms.excitation[i],
              newLevel       = Math.floor(Math.random() * currentLevel),
              energyReleased = energyLevels[newLevel] - energyLevels[currentLevel];

          atoms.excitation[i] = newLevel;

          if (Math.random() < pRadiationless) {
            // new energy goes into increasing atom velocities after collision
            computeVelocityComponents();
            updateVelocities(energyReleased);
          } else {
            emitPhotonFromAtom(i, -energyReleased);
          }
        },

        findEmptyPhotonIndex = function() {
          var length = photons.x.length,
              i;

          if (numPhotons + 1 > length) {
            utils.extendArrays(photons, length+10);
            return length;
          }

          for (i = 0; i < length; i++) {
            if (!photons.vx[i] && !photons.vy[i]) {
              return i;
            }
          }
        },

        removePhoton = function(i) {
          numPhotons--;
          photons.x[i] = photons.y[i] = photons.vx[i] = photons.vy[i] = photons.angularFrequency[i] = 0;
        },

        emitPhoton = function(x, y, angle, energy) {
          var cosA  = Math.cos(angle),
              sinA  = Math.sin(angle),
              vx          = C * cosA,
              vy          = C * sinA,
              angularFreq = energy / PLANCK_CONSTANT,
              photonIndex = findEmptyPhotonIndex();

          numPhotons++;
          photons.id[photonIndex] = nextPhotonId++;
          photons.x[photonIndex]  = x;
          photons.y[photonIndex]  = y;
          photons.vx[photonIndex] = vx;
          photons.vy[photonIndex] = vy;
          photons.angularFrequency[photonIndex] = angularFreq;
        },

        emitPhotonFromAtom = function(atomIndex, energy) {
          var angle = Math.random() * TWO_PI - Math.PI,
              cosA  = Math.cos(angle),
              sinA  = Math.sin(angle),
              sigma = elements.sigma[atoms.element[atomIndex]],

              // set photon location just outside atom's sigma
              x = atoms.x[atomIndex] + (sigma * 0.51 * cosA),
              y = atoms.y[atomIndex] + (sigma * 0.51 * sinA);

          emitPhoton(x, y, angle, energy);
        },

        movePhotons = function(dt) {
          var i, ii,
              x, y;

          for (i = 0, ii = photons.x.length; i < ii; i++) {
            if (!photons.vx[i] && !photons.vy[i]) continue;

            x = photons.x[i] += photons.vx[i] * dt;
            y = photons.y[i] += photons.vy[i] * dt;

            if (x < dimensions[0] || x > dimensions[2] || y < dimensions[1] || y > dimensions[3]) {
              removePhoton(i);
            }
          }
        },

        spontaneouslyEmitPhotons = function(dt) {
          if (!elementEnergyLevels) { return; }

          for (var i = 0, N = engine.getNumberOfAtoms(); i < N; i++) {
            tryToSpontaneouslyEmitPhoton(i, dt);
          }
        },

        tryToSpontaneouslyEmitPhoton = function(atomIndex, dt) {

          if (atoms.excitation[atomIndex] === 0) { return; }

          // The probability of an emission in the current timestep is the probability that an
          // exponential random variable T with expected value LIFETIME has value t less than dt.
          // For dt < ~0.1 * LIFETIME, this probability is approximately equal to dt/LIFETIME.

          if (Math.random() > dt * EMISSION_PROBABILITY_PER_FS) { return; }

          // Randomly select an energy level. Reference:
          // https://github.com/concord-consortium/mw/blob/6e2f2d4630323b8e993fcfb531a3e7cb06644fef/src/org/concord/mw2d/models/SpontaneousEmission.java#L48-L70

          var r1 = Math.random(),
              r2 = Math.random(),
              energyLevels,
              excessEnergy,
              i,
              m = atoms.excitation[atomIndex],
              mInverse = 1/m;

          for (i = 0; i < m; i++) {
            if (i*mInverse <= r1 && r1 < (i+1)*mInverse && pRadiationless < r2) {
              energyLevels = elementEnergyLevels[atoms.element[atomIndex]];
              excessEnergy = energyLevels[m] - energyLevels[i];
              atoms.excitation[atomIndex] = i;
              emitPhotonFromAtom(atomIndex, excessEnergy);
              return;
            }
          }
        },

        normalizeAngle = function(t) {
          t = t % TWO_PI;
          if (t < 0 || t > TWO_PI)
            return Math.abs((TWO_PI) - Math.abs(t));
          return t;
        },

        // Temporary implementation with hard-wired parameters.
        emitLightSourcePhotons = function() {
          var x = dimensions[0],
              y = dimensions[1],
              w = dimensions[2] - x,
              h = dimensions[3] - y,

              angle  = normalizeAngle(lightSource.angleOfIncidence),
              nBeams = lightSource.numberOfBeams,
              spacing,
              s, c, length, dx, dy, m, n, i,

              getEnergy = function () {
                return (lightSource.monochromatic ? lightSource.frequency : getRandomFrequency()) * PLANCK_CONSTANT;
              };

          if (angle == 0) {
            spacing = h / (nBeams + 1);
            for (i = 1; i <= nBeams; i++) {
              emitPhoton(x, y + spacing * i, angle, getEnergy());
            }
          } else if (angle.toFixed(4) == (Math.PI/2).toFixed(4)) {
            spacing = w / (nBeams + 1);
            for (i = 1; i <= nBeams; i++) {
              emitPhoton(x + spacing * i, y, angle, getEnergy());
            }
          } else if (angle.toFixed(4) == (Math.PI).toFixed(4)) {
            spacing = h / (nBeams + 1);
            for (i = 1; i <= nBeams; i++) {
              emitPhoton(x + w, y + spacing * i, angle, getEnergy());
            }
          } else if (angle.toFixed(4) == (Math.PI*3/2).toFixed(4)) {
            spacing = w / (nBeams + 1);
            for (i = 1; i <= nBeams; i++) {
              emitPhoton(x + spacing * i, y + h, angle, getEnergy());
            }
          } else {
            // Lifted from AtomicModel.shootPhotons()
            // https://github.com/concord-consortium/mw/blob/d3f621ba87825888737257a6cb9ac9e4e4f63f77/src/org/concord/mw2d/models/AtomicModel.java#L2534
            s = Math.abs(Math.sin(angle));
            c = Math.abs(Math.cos(angle));
            length = s * h < c * w ? h / c : w / s;
            spacing = length / nBeams;
            dx = spacing / s;
            dy = spacing / c;
            m = Math.floor(w / dx);
            n = Math.floor(h / dy);

            // Lifted from AtomicModel.shootAtAngle()
            // https://github.com/concord-consortium/mw/blob/d3f621ba87825888737257a6cb9ac9e4e4f63f77/src/org/concord/mw2d/models/AtomicModel.java#L2471
            if (angle >= 0 && angle < 0.5 * Math.PI) {
              for (i = 1; i <= m; i++)
                emitPhoton(x + dx * i, y, angle, getEnergy());
              for (i = 0; i <= n; i++)
                emitPhoton(x, y + h - dy * i, angle, getEnergy());
            } else if (angle >= Math.PI*3/2) {
              for (i = 1; i <= m; i++)
                emitPhoton(x + dx * i, y + h, angle, getEnergy());
              for (i = 0; i <= n; i++)
                emitPhoton(x, y + dy * i, angle, getEnergy());
            } else if (angle < Math.PI && angle >= 0.5 * Math.PI) {
              for (i = 0; i <= m; i++)
                emitPhoton(x + w - dx * i, y, angle, getEnergy());
              for (i = 1; i <= n; i++)
                emitPhoton(x + w, y + h - dy * i, angle, getEnergy());
            } else if (angle >= Math.PI && angle < Math.PI*3/2) {
              for (i = 0; i <= m; i++)
                emitPhoton(x + w - dx * i, y + h, angle, getEnergy());
              for (i = 1; i <= n; i++)
                emitPhoton(x + w, y + dy * i, angle, getEnergy());
            }
          }
        };


    // Public API.
    api = {
      initialize: function(dataTables) {
        atoms     = dataTables.atoms;
        elements  = dataTables.elements;
        updateAtomsTable();
        createPhotonsTable(properties.photons);
        copyPhotonData(properties.photons);
      },

      performActionWithinIntegrationLoop: function(neighborList, dt, time) {
        modelTime = time;
        movePhotons(dt);
        handlePhotonAtomCollisions();
        thermallyExciteAndDeexciteAtoms(neighborList);
        spontaneouslyEmitPhotons(dt);
        // Temporary hard-wired light source, for demo purposes

        if (lightSource.on && time % lightSource.radiationPeriod < dt) {
          emitLightSourcePhotons();
        }
      },

      turnOnLightSource: function() {
        lightSource.on = true;
      },

      turnOffLightSource: function() {
        lightSource.on = false;
      },

      setLightSourceAngle: function(angle) {
        lightSource.angleOfIncidence = angle;
      },

      setLightSourceFrequency: function(freq) {
        lightSource.frequency = freq;
      },

      setLightSourcePeriod: function(period) {
        lightSource.radiationPeriod = period;
      },

      setLightSourceNumber: function(number) {
        lightSource.numberOfBeams = number;
      },

      getPhotons: function() {
        return photons;
      },

      getNumPhotons: function() {
        return numPhotons;
      },

      // TODO/FIXME: This is a modeler-level method; it's here until the plugin mechanism is
      // extended to allow plugins to define both engine-level and modeler-level parts.
      // Additionally, this can be split into updateViewPhotons which can happen in the
      // modeler's readModelState method, and a simple getViewPhotons accessor used by the view.
      getViewPhotons: (function() {
        var viewPhotons = [],
            viewPhotonsByIndex = [];

        function makeViewPhoton(photons, i) {
          var vx = photons.vx[i],
              vy = photons.vy[i],
              // For convenience, this is in the form required by SVG transform
              angle = -180 * Math.atan2(vy, vx) / Math.PI;

          return {
            id: photons.id[i],
            x:  photons.x[i],
            y:  photons.y[i],
            vx: vx,
            vy: vy,
            angle: angle,
            angularFrequency: photons.angularFrequency[i]
          };
        }

        return function() {
          // avoid using the closure variable 'photons' as this method will be relocated to
          // modeler, and will then have to access photons table via some kind of accessor method
          var photons = this.getPhotons(),
              n = 0,
              i,
              len,
              viewPhoton;

          viewPhotons.length = this.getNumPhotons();
          viewPhotonsByIndex.length = photons.x.length;

          for (i = 0, len = photons.x.length; i < len; i++) {
            if (photons.vx[i] || photons.vy[i]) {
              viewPhoton = viewPhotonsByIndex[i];

              // If we have a viewPhoton for slot i in the photons array, update it instead of
              // allocating a new viewPhoton object; that will tell the view code to update the
              // position of the squiggle instead of generating a new one. Note that we also need to
              // make sure that that slot in the photons array still represents the same photon it
              // did last time we were called.
              if (viewPhoton && viewPhoton.id === photons.id[i]) {
                viewPhoton.x = photons.x[i];
                viewPhoton.y = photons.y[i];
              } else {
                viewPhoton = makeViewPhoton(photons, i);
                viewPhotonsByIndex[i] = viewPhoton;
              }
              viewPhotons[n++] = viewPhoton;
            } else {
              // Release references to the viewPhoton object after we're done with it.
              viewPhotonsByIndex[i] = null;
            }
          }

          return viewPhotons;
        };
      }()),

      getElementEnergyLevels: function() {
        return elementEnergyLevels;
      },

      getRadiationlessEmissionProbability: function() {
        return pRadiationless;
      },

      getLightSource: function() {
        if (!lightSource) return undefined;
        return lightSource;
      },

      getState: function() {
        return [
          new CloneRestoreWrapper(photons, { padArraysWithZeroes: true }),
          {
            clone: function() {
              return {
                numPhotons: numPhotons
              };
            },
            restore: function(state) {
              numPhotons = state.numPhotons;
            }
          }
        ];
      }
    };

    dispatch.mixInto(api);

    return api;
  }

  // Export constants.
  QuantumDynamics.INFRARED = INFRARED;
  QuantumDynamics.ULTRAVIOLET = ULTRAVIOLET;

  return QuantumDynamics;

});

/*global define, $ */

define('common/controllers/spectrometer-controller',['common/inherit','common/controllers/interactive-component','models/md2d/models/engine/plugins/quantum-dynamics'],function () {
  var inherit              = require('common/inherit'),
      InteractiveComponent = require('common/controllers/interactive-component'),

      QuantumDynamics      = require('models/md2d/models/engine/plugins/quantum-dynamics'),
      INFRARED             = QuantumDynamics.INFRARED,
      ULTRAVIOLET          = QuantumDynamics.ULTRAVIOLET,

      // Performance optimization - photon mark is not rendered if there is already another
      // photon mark at the same position. Positions are rounded to the PHOTON_MARKS_PRECISION.
      PHOTON_MARKS_PRECISION = 2,

      // Visible light spectrum image (297px x 1px). Covers area from INFRARED to ULTRAVIOLET.
      // It's based on the Classic MW spectrometer.
      VISIBLE_LIGHT_IMG_DATA = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAASkAAAABCAYAAACCEVhtAAAAmUlEQVQ4T8WUw' +
                               'Q6DIBBEn1Wr+P/fCnjCbGuTLe4GbphMnH0ZhkiIUymlMOo5T0jpXzk/mWQ097zusnpihBXYgP1+i38rL/NP' +
                               'HteZVl72mYBXp3qzjdwJpErZYJLR3PO6y+qJnzskhxEqyQHUTGbNPa/XWT0HDPjQhe81EmnfM3vrWnzeYAm' +
                               'VdoNJRvPbrwFmI+/yY9RP4bnvBfEAd/7c+ytNAAAAAElFTkSuQmCC';

  function SpectrometerController(component, interactivesController) {
    // Call super constructor.
    InteractiveComponent.call(this, 'spectrometer', component, interactivesController);

    this.$element
      .addClass('interactive-spectrometer')
      .css('border', this.component.border);

    this.lowerBound = this.component.lowerBound;
    this.upperBound = this.component.upperBound;

    // Helper objects that prevents spectrometer from drawing multiple photon marks at the same position.
    this._existingPhotonMarks = {};
    
    this.renderBackground();
    this.renderTickMarks();
    this.$photonMarksContainer = $('<div>').appendTo(this.$element);
  }

  inherit(SpectrometerController, InteractiveComponent);

  SpectrometerController.prototype.modelLoadedCallback = function () {
    SpectrometerController.superClass._modelLoadedCallback.call(this);
    this._model.onPhotonAbsorbed(this.onPhotonAbsorbed.bind(this));
    if (this.component.clearOnModelLoad) {
      this.$photonMarksContainer.empty();
    }
  };

  SpectrometerController.prototype.renderBackground = function () {
    var position = (INFRARED - this.lowerBound) / (this.upperBound - this.lowerBound) * 100;
    var width = (ULTRAVIOLET - INFRARED) / (this.upperBound - this.lowerBound) * 100;
    $('<img>')
      .addClass('spectrometer-bg')
      .attr('src', VISIBLE_LIGHT_IMG_DATA)
      .css('left', position + '%')
      .css('width', width + '%')
      .appendTo(this.$element);
  };

  SpectrometerController.prototype.renderTickMarks = function () {
    if (!this.component.ticks || this.component.ticks < 2) return;

    var $tickMarksContainer = $('<div>').appendTo(this.$element);
    var spacing = 100 / this.component.ticks;
    for (var i = 1; i < this.component.ticks; i++) {
      $('<div class="tick-mark">').css('left', (i * spacing) + '%').appendTo($tickMarksContainer);
    }
  };

  SpectrometerController.prototype.onPhotonAbsorbed = function (frequency) {
    if (frequency > this.upperBound || frequency < this.lowerBound) return;

    var position = (frequency - this.lowerBound) / (this.upperBound - this.lowerBound) * 100;
    // Check existing photon marks, so we don't render hundreds of lines in the same place.
    if (!this.photonMarkExists(position)) {
      this.addPhotonMark(position);
    }
  };

  SpectrometerController.prototype.photonMarkExists = function (position) {
    return !!this._existingPhotonMarks[position.toFixed(PHOTON_MARKS_PRECISION)];
  };

  SpectrometerController.prototype.addPhotonMark = function (position) {
    $('<div class="photon-mark">').css('left', position + '%').appendTo(this.$photonMarksContainer);
    this._existingPhotonMarks[position.toFixed(PHOTON_MARKS_PRECISION)] = true;
  };

  return SpectrometerController;
});

define('common/layout/detect-font-change',[],function() {
  // Size of the font we test, it doesn't really matter.
  var FONT_SIZE = 15; // px

  // how long to poll
  var DEFAULTS = {
    weight: 'normal',
    timeout: 3000,
    interval: 250,
    onchange: null
  };

  var fontLoaded = {};
  var loading = {};

  function getBitmap(font) {
    var canvas = document.createElement('canvas');
    var ctx = canvas.getContext('2d');
    var dim = FONT_SIZE * 1.5;

    canvas.width = dim;
    canvas.height = dim;

    ctx.font = font;
    ctx.fillText('A', 0, dim);
    return canvas.toDataURL();
  }

  function stopChecking(font) {
    window.clearInterval(loading[font].pollingInterval);
    delete loading[font];
  }

  function fontChecker(font, startTime, timeout) {
    loading[font].bitmap = getBitmap(font);

    return function() {
      if (getBitmap(font) !== loading[font].bitmap) {
        loading[font].changeCallbacks.forEach(function (cb) {
          cb();
        });
        fontLoaded[font] = true;
        stopChecking(font);
        return;
      }

      if (Date.now() - startTime > timeout) {
        stopChecking(font);
      }
    };
  }

  /**
    Detects changes to how a given font renders in a Canvas context, using the assumption that the
    first such change indicates that the font has loaded and should no longer be checked.
    If you provide multiple fonts (e.g. Lato, 'Open Sans', Arial), onchange handler can be called
    multiple times.

    options:
      font:   a font family name in the format used by the CSS font-family property.
              See https://developer.mozilla.org/en-US/docs/Web/CSS/font-family

      weight: a font weight in the format used by the CSS font-weight property.
              See https://developer.mozilla.org/en/docs/Web/CSS/font-weight

      interval: Length in milliseconds of the interval to use for checking a font for changes.

      timeout: How many milliseconds to wait before indicating an error

      onchange: A function to be called when we detect a change to the way the font renders. This is
                not a promise-style callback that indicates the font is loaded; it is only called
                when we detect a difference in the bitmap created when rendering canvas fillText
                using this font. It will be called if this method returns true and the font-checking
                does not timeout. It is always called asynchronously (i.e, in a later event loop.)

    returns:
      true, if the font has not yet loaded
      false, if the font is already loaded

    semantics:

      for a given font specifier
        if it has been loaded already
          return false
        if it has not loaded
          and we are not already polling for changes to that font:
            add 'onchange' to the list of onchange listeners
            return true
          else:
            begin polling every interval milliseconds, for at most 'timeout' milliseconds
              if it changes during that interval
               call onchange listeners
               cancel polling interval
            return true
  */
  return function detectFontChange(_options) {
    var options = {};

    // option processing
    Object.keys(_options).concat(Object.keys(DEFAULTS)).forEach(function(key) {
      options[key] = _options[key] != null ? _options[key] : DEFAULTS[key];
    });

    var multipleFonts = options.font.split(',');
    if (multipleFonts.length > 1) {
      var result = false;
      multipleFonts.forEach(function(fontName) {
        options.font = fontName.trim();
        if (detectFontChange(options)) {
          // Return true if at least one font is not already loaded.
          result = true;
        }
      });
      return result;
    }

    // Construct compact form that is expected by canvas.
    var font = options.weight + ' ' + FONT_SIZE + 'px ' + options.font;

    if (fontLoaded[font]) {
      // Font already loaded.
      return false;
    }

    if ( ! loading[font] ) {
      loading[font] = {
        bitmap: null,
        pollingInterval: null,
        changeCallbacks: []
      };
    }

    if (options.onchange) {
      loading[font].changeCallbacks.push(options.onchange);
    }

    if ( ! loading[font].pollingInterval ) {
      loading[font].pollingInterval = window.setInterval(
        fontChecker(font, Date.now(), options.timeout),
        options.interval
      );
    }

    return true;
  };

});

define('common/views/numeric-output-view',['common/layout/detect-font-change'],function () {

  var detectFontChange = require('common/layout/detect-font-change');
  var OVERSAMPLE = 2;

  return function NumericOutputView(opts) {

    var id    = opts.id;
    var label = opts.label;
    var units = opts.unit;

    var $numericOutput;
    var $label;
    var $output;
    var $number;
    var $units;

    var lastValue;
    var minContentWidth;

    var $canvas;
    var textWidth = 0;
    var textY;
    var ctx;
    var canvasElementWidth, canvasElementHeight;
    var canvasInternalWidth, canvasInternalHeight;

    var api;

    function resizeCanvas(width) {
      var oversampledFontSize;

      canvasElementWidth = width;
      canvasElementHeight = $number.height();

      $canvas.width(canvasElementWidth);
      $canvas.height(canvasElementHeight);

      // oversample for HiDPI devices (set its internal width, height to 2x those of canvas element)
      canvasInternalWidth = OVERSAMPLE * canvasElementWidth;
      canvasInternalHeight = OVERSAMPLE * canvasElementHeight;

      $canvas.attr('width', canvasInternalWidth);
      $canvas.attr('height', canvasInternalHeight);

      // resizing resets internal canvas properties!
      oversampledFontSize = OVERSAMPLE * parseInt($number.css('font-size'), 10);

      ctx.font = [
        $number.css('font-style'),
        $number.css('font-variant'),
        $number.css('font-weight'),
        oversampledFontSize + 'px/' + $number.css('line-height'),
        $number.css('font-family')
      ].join(' ');

      ctx.fillStyle = $number.css('color');
      ctx.textAlign = 'right';
      ctx.textBaseline = 'middle';

      textY = canvasInternalHeight / 2;
    }

    function repositionCanvas() {
      var position = $output.position();
      $canvas.css({
        left: position.left + parseInt($number.css('padding-left'), 10) + $number.width() - canvasElementWidth,
        top: position.top + parseInt($output.css('padding-top'), 10)
      });
    }

    api = {

      /**
        Update the canvas element to the current value, and conservatively update the width of the
        background <span>.

        Numeric outputs update every tick (usually), so we're using canvas for speed (Drawing text
        to Canvas is faster than drawing to an absolutely positioned html element, and is much
        faster than updating an element in page flow, which invalidates the whole page layout and
        costs several full ms in layout and paint time even on a fast desktop browser.)

        Note that we need $number to be in page flow (position: relative) in order for semantic
        layout to work.

        We must update the size of $number but we to avoid performance hits we do so conservatiely
        -- only do it if the width of the number being displayed is > 5px larger or smaller than the
        width of $number.
      */
      update: function(value) {
        if (value == null) {
          value = '';
        } else {
          value = '' + value;
        }
        lastValue = value;

        var positionChanged = false;

        textWidth = Math.round(ctx.measureText(value).width / OVERSAMPLE);

        if (canvasElementWidth < textWidth) {
          resizeCanvas(2 * textWidth);
          positionChanged = true;
        }

        // Avoid resizing the number <span> each tick.
        if (Math.abs($number.width() - textWidth) > 5 && textWidth > minContentWidth) {
          $number.width(textWidth);
          positionChanged = true;
        }

        if (positionChanged) {
          repositionCanvas();
        }

        ctx.clearRect(0, 0, canvasInternalWidth, canvasInternalHeight);
        ctx.fillText(value, canvasInternalWidth, textY);
      },

      updateLabel: function(value) {
        $label.html(value);
      },

      updateUnits: function(value) {
        $units.html(value);
      },

      hideUnits: function() {
        // avoid growing/shrinking the box unnecessarily
        $units.css('opacity', 0);
      },

      showUnits: function() {
        $units.css('opacity', 1);
      },

      render: function() {
        $canvas = $('<canvas>').css('position', 'absolute');
        ctx = $canvas[0].getContext('2d');

        $numericOutput = $('<div class="numeric-output">');
        $label  = $('<span class="label"></span>');
        $output = $('<span class="output"></span>');
        // $number has to have content just so that its height is reported correctly
        $number = $('<span class="value"> - </span>').css('opacity', 0);
        $units  = $('<span class="units"></span>');

        if (label) { $label.html(label); }
        if (units) { $units.html(units); }

        $numericOutput.attr('id', id)
          .append($label)
          .append($output
            .append($canvas)
            .append($number)
            .append($units)
          );

        return $numericOutput;
      },

      /**
        Call this whenever app resizes. Updates canvas position, size, and font-size.
        Must be called at least once after the view has been added to the DOM!
      */
      resize: function() {
        minContentWidth =
          parseInt($number.css('min-width'), 10) -
          parseInt($number.css('padding-left'), 10) -
          parseInt($number.css('padding-right'), 10);

        resizeCanvas(2 * textWidth);
        api.update(lastValue);
        repositionCanvas();

        detectFontChange({
          font: ctx.font,
          onchange: function() {
            api.resize();
          }
        });
      }
    };

    return api;
  };
});

/*global define, $ */

define('common/controllers/numeric-output-controller',['common/controllers/interactive-metadata','common/validator','common/controllers/help-icon-support','common/views/numeric-output-view'],function () {

  var metadata          = require('common/controllers/interactive-metadata'),
      validator         = require('common/validator'),
      helpIconSupport   = require('common/controllers/help-icon-support'),
      NumericOutputView = require('common/views/numeric-output-view');

  return function NumericOutputController(component, interactivesController) {
    var propertyName,
        label,
        units,
        displayValue,
        view,
        $element,
        propertyDescription,
        controller,
        model,
        scriptingAPI;

    function renderValue() {
      var value = model.properties[propertyName];

      if (displayValue) {
        value = displayValue(value);
      }
      view.update(value);
    }

    //
    // Initialization.
    //
    model = interactivesController.getModel();
    scriptingAPI = interactivesController.getScriptingAPI();

    // Validate component definition, use validated copy of the properties.
    component = validator.validateCompleteness(metadata.numericOutput, component);

    propertyName = component.property;
    units = component.units;
    label = component.label;
    displayValue = component.displayValue;

    view = new NumericOutputView({
      id: component.id,
      units: units,
      label: label
    });

    $element = view.render();

    // Each interactive component has to have class "component".
    $element.addClass("component");

    // Add class defining component orientation - "horizontal" or "vertical".
    $element.addClass(component.orientation);

    // Custom dimensions.
    $element.css({
      width: component.width,
      height: component.height
    });

    if (displayValue) {
      displayValue = scriptingAPI.makeFunctionInScriptContext('value', displayValue);
    }

    if (component.tooltip) {
      $element.attr("title", component.tooltip);
    }

    // Public API.
    controller = {
      // This callback should be trigger when model is loaded.
      modelLoadedCallback: function () {
        if (model) {
          model.removeObserver(propertyName, renderValue);
        }
        model = interactivesController.getModel();
        scriptingAPI = interactivesController.getScriptingAPI();
        if (propertyName) {
          propertyDescription = model.getPropertyDescription(propertyName);
          if (propertyDescription) {
            if (!label) { view.updateLabel(propertyDescription.getLabel()); }
            if (!units) { view.updateUnits(propertyDescription.getUnitAbbreviation()); }
          }
          renderValue();
          model.addObserver(propertyName, renderValue);
        }
      },

      // Returns view container. Label tag, as it contains checkbox anyway.
      getViewContainer: function () {
        return $element;
      },

      resize: function() {
        view.resize();
        renderValue();
      },

      // Returns serialized component definition.
      serialize: function () {
        // Return the initial component definition.
        // Numeric output component doesn't have any state, which can be changed.
        // It's value is defined by underlying model.
        return $.extend(true, {}, component);
      }
    };

    // Support optional help icon.
    helpIconSupport(controller, component, interactivesController.helpSystem);

    // Return Public API object.
    return controller;
  };
});

define('common/views/table-view',[],function() {

  return function TableView(opts, tableController) {
    var api,
        id          = opts.id,
        columns     = opts.columns,
        formatters  = opts.formatters,
        visibleRows = opts.visibleRows,
        blankRow    = opts.showBlankRow,
        title       = opts.title,
        width       = opts.width,
        height      = opts.height,
        tooltip     = opts.tooltip,
        klasses     = opts.klasses || [],
        headerWidths,
        $el,
        $tableWrapper,
        $table,
        $thead,
        $titlerow,
        $tbody,
        $bodyrows,
        tbodyPos,
        tbodyHeight,
        selected = [];

    function renderColumnTitles() {
      var i, $th;
      $titlerow.find('th').remove("th");
      for(i = 0; i < columns.length; i++) {
        $th = $('<th>');
        $th.text(columns[i].name);
        $th.click(columnSort);
        $titlerow.append($th);
      }
    }

    function setFormattedData($td, datum, colIdx) {
      if (typeof datum !== "undefined" && datum !== null) {
        if(typeof datum === "string") {
          $td.text(datum);
        } else if(typeof datum === "number") {
          $td.text(formatters[colIdx](datum));
        }
      } else {
        $td.html("&nbsp;");
      }
    }

    function formatNumericValues() {
      $tbody.find('td').html(function() {
        var $td = $(this);
        var datum = $td.data('datum');
        var colIdx = $td.data('index');
        setFormattedData($td, datum, colIdx);
      });
    }

    function columnSort(e) {
      var $title = $(this),
          ascending = "asc",
          descending = "desc",
          sortOrder;

      // Remove blank row and setup it again after storting to ensure that it's always at the end
      // of the table.
      removeBlankRow();
      sortOrder = ascending;
      if ($title.hasClass(ascending)) {
        $title.removeClass(ascending);
        $title.addClass(descending);
        sortOrder = descending;
      } else if ($title.hasClass(descending)) {
        $title.removeClass(descending);
        $title.addClass(ascending);
        sortOrder = ascending;
      } else {
        $title.addClass(descending);
        sortOrder = descending;
      }
      $title.siblings().removeClass("sorted");
      $bodyrows = $tbody.find("tr");
      $bodyrows.tsort('td:eq('+$title.index()+')',
        {
          sortFunction:function(a, b) {
            var anum = Math.abs(parseFloat(a.s)),
                bnum = Math.abs(parseFloat(b.s));
            if (sortOrder === ascending) {
              return anum === bnum ? 0 : (anum > bnum ? 1 : -1);
            } else {
              return anum === bnum ? 0 : (anum < bnum ? 1 : -1);
            }
          }
        }
      );
      $title.addClass("sorted");
      setupBlankRow();
      e.preventDefault();
    }

    function alignColumnWidths() {
      headerWidths = $thead.find('tr:first th').map(function() {
        return $(this).outerWidth();
      });

      $tbody.find('tr:first td').each(function(i) {
        $(this).outerWidth(headerWidths[i]);
      });
    }

    function getRowByIndex(rowIndex) {
      return $($tbody.find('tr')).filter(function() {
        return $(this).data("index") === rowIndex;
      });
    }

    function getRowIndexFromRow($tr) {
      return $tr.data('index');
    }

    function getRowVisiblity($tr) {
      var p = $tr.position();
      if (!p || !tbodyPos) return 0;
      if (p.top < tbodyPos.top) return -1;
      if (p.top > tbodyHeight) return 1;
      return 0;
    }

    function removeSelection(rowIndex) {
      var i = selected.indexOf(rowIndex);
      if (i !== -1) {
        selected.splice(i, 1);
        return getRowByIndex(rowIndex).removeClass('selected');
      }
    }

    function addSelection(rowIndex) {
      var $tr;
      if (selected.indexOf(rowIndex) === -1) {
        selected.push(rowIndex);
        $tr = getRowByIndex(rowIndex);
        $tr.addClass('selected');
        return $tr;
      }
    }

    function getRowOrderIndices() {
      var i, j, indices = [];
      for (i = 0; i < selected.length; i++) {
        j = selected[i];
        indices.push([j, getRowByIndex(j).index()]);
      }
      return indices.sort(function(a, b) {
        return a[1] - b[1];
      });
    }

    function fillSelection() {
      var i, rowOrderIndices, start, end;
      rowOrderIndices = getRowOrderIndices();
      start = rowOrderIndices[0];
      end = rowOrderIndices[rowOrderIndices.length-1];
      $bodyrows = $tbody.find("tr");
      for (i = start[1]; i <= end[1]; i++) {
        addSelection($($bodyrows[i]).data('index'));
      }
    }

    function clearSelection() {
      var i;
      for (i = 0; i < selected.length; i++) {
        getRowByIndex(selected[i]).removeClass('selected');
      }
      selected = [];
    }

    function appendSingleRow(rowData, index) {
      var i, datum, $tr, $td;
      $tr = $('<tr class="data">');
      $($tr).data('index', index);
      for(i = 0; i < columns.length; i++) {
        $td = $('<td>');
        $($td).data('index', i);
        datum = rowData[i];
        $td.data('datum', datum);
        setFormattedData($td, datum, i);
        $tr.append($td);
      }
      $tbody.append($tr);
      if ($tbody.find("tr").length < 2) {
        alignColumnWidths();
      }
    }

    function removeBlankRow() {
      $tbody.find(".blank").remove();
    }

    function setupBlankRow() {
      // Remove old blank row and add new one.
      removeBlankRow();
      if (!blankRow) return;
      var index = $tbody.find("tr").length;
      var i, $tr, $td;
      $tr = $('<tr class="data blank">');
      $($tr).data('index', index);
      for(i = 0; i < columns.length; i++) {
        $td = $('<td>');
        $($td).data('index', i);
        $td.html("&nbsp;");
        $tr.append($td);
      }
      $tbody.append($tr);
      if ($tbody.find("tr").length < 2) {
        alignColumnWidths();
      }
    }

    function scrollToBottom() {
      // Dummy, big number will cause that we will always scroll maximally to the bottom.
      $tbody.scrollTop(99999999);
    }

    function replaceDataRow(rowData, index) {
      var datum;

      if ($tbody.find('tr').length === 0) {
        api.appendDataRow(rowData, index);
        return;
      }

      var $tr = $($tbody.find('tr')).filter(function() {
            return $(this).data("index") === index;
          }),
          $dataElements = $($tr).find('td'),
          dataElementCount = $dataElements.length,
          $td, i;

      for (i = 0; i < rowData.length; i++) {
        if (i < dataElementCount) {
          $td = $($dataElements[i]);
          datum = rowData[i];
          $td.data('datum', datum);
          setFormattedData($td, datum, i);
        }
      }
    }

    function calculateSizeAndPosition() {
      tbodyPos = $tbody.position();
      tbodyHeight = $tbody.height();
    }

    function commitEditing() {
      var $input = $tbody.find('input');

      $input.each(function() {
        var $td = $(this).parent(),
            rowIndex = $td.parent().data('index'),
            colIndex = $td.data('index'),
            val = $(this).val();

        if (!isNaN(parseFloat(val)) && isFinite(val)) {
          val = parseFloat(val);
        }
        tableController.addDataToCell(rowIndex, colIndex, val);
        $td.empty().html(val);
      });

      alignColumnWidths();
      calculateSizeAndPosition();
    }

    function startEditing(rowIndex, colIndex) {
      var $td = $(getRowByIndex(rowIndex).find('td')[colIndex]),
          $oldInputs = $tbody.find('input'),
          data,
          $input,
          nextColIndex;

      if (!$td || (!columns[colIndex].editable) || ($td.find('input').length)) {
        return;
      }

      if ($oldInputs.length) {
        commitEditing();
      }

      data   = tableController.getDataInCell(rowIndex, colIndex);
      $input = $('<input class="editor-text">').val(data);

      $td.empty().append($input);

      alignColumnWidths();

      $input.bind('keydown', function(e) {
        var code = (e.keyCode ? e.keyCode : e.which);
        if(code === 13) {        // Enter
          commitEditing();
        } else if (code === 9){  // Tab
          commitEditing();
          // find and select next available cell
          nextColIndex = colIndex;
          while (++nextColIndex < columns.length) {
            if (columns[nextColIndex].editable) {
              startEditing(rowIndex, nextColIndex);
              break;
            }
          }
        }
        e.stopPropagation();
      });

      $input.on('blur', commitEditing);

      setTimeout(function(){
        $input.focus();
      }, 0);
    }

    api = {
      render: function() {
        var i, $title;
        $el = $('<div>');
        $table = $('<table>');
        $tbody = $('<tbody>');
        $titlerow = $('<tr class="header">');
        $thead = $('<thead>').append($titlerow);
        $table
          .append($thead)
          .append($tbody);
        renderColumnTitles();
        $tableWrapper = $('<div>')
          .addClass("table-wrapper")
          .append($table);
        $el.attr('id', id);
        if (title) {
          $title = $('<div>')
            .addClass("title")
            .text(title);
          $el.append($title);
        }
        $el.append($tableWrapper);
        for (i = 0; i < klasses.length; i++) {
          $el.addClass(klasses[i]);
        }
        if (tooltip) {
          $el.attr("title", tooltip);
        }
        if (width) {
          $el.css("width", width);
        }
        if (height) {
          $el.css("height", height);
        }
        $tbody.delegate("tr", "click", function(e) {
          var ri = getRowIndexFromRow($(e.currentTarget));
          if (!e.shiftKey && !e.metaKey) {
            clearSelection();
          }
          addSelection(ri);
          if (e.shiftKey) {
            fillSelection();
          }
        });
        $tbody.delegate("td", "click", function(e) {
          var $td      = $(e.currentTarget),
              rowIndex = $td.parent().data('index'),
              colIndex = $td.data('index');

          startEditing(rowIndex, colIndex);
        });
        calculateSizeAndPosition();
        return $el;
      },

      resize: function () {
        var remainingHeight;
        $table.height($tableWrapper.height());
        remainingHeight = $table.height() - ($thead.outerHeight(true));
        $tbody.height(remainingHeight - 6);
        alignColumnWidths();
        calculateSizeAndPosition();
      },

      clear: function () {
        $tbody.find('.data').remove();
      },

      appendDataRow: function (rowData, index) {
        appendSingleRow(rowData, index);
        setupBlankRow();
        scrollToBottom();
      },

      appendDataRows: function (rows, startIndex) {
        var index = startIndex;
        rows.forEach(function (row) {
          appendSingleRow(row, index++);
        });
        setupBlankRow();
        scrollToBottom();
      },

      removeDataRows: function (startIdx) {
        var $tr = $tbody.find('tr').filter(function() {
          var idx = $(this).data("index");
          return idx >= startIdx;
        });
        $tr.remove();
        setupBlankRow();
      },

      replaceDataRow: replaceDataRow,

      removeSelection: removeSelection,
      addSelection: addSelection,
      clearSelection: clearSelection,

      updateTable: function(opts) {
        columns     = opts.columns || columns;
        formatters  = opts.formatters || formatters;
        renderColumnTitles();
        formatNumericValues();
        alignColumnWidths();
        calculateSizeAndPosition();
      }
    };

    return api;
  };
});


/*global define, $*/

define('common/controllers/table-controller',['require','common/controllers/interactive-metadata','common/validator','common/views/table-view','common/listening-pool','common/controllers/data-set','common/controllers/help-icon-support'],function (require) {
  var metadata        = require('common/controllers/interactive-metadata'),
      validator       = require('common/validator'),
      TableView       = require('common/views/table-view'),
      ListeningPool   = require('common/listening-pool'),
      DataSet         = require('common/controllers/data-set'),
      helpIconSupport = require('common/controllers/help-icon-support'),
      tableControllerCount = 0;

  return function TableController(component, interactivesController) {
        // Public API.
    var controller,
        model,
        dataSet,
        listeningPool,
        view,
        $element,
        rowIndex,
        columns,
        formatters,
        headerData,
        properties,
        namespace = "tableController" + (++tableControllerCount);

    function initialize() {
      model = interactivesController.getModel();

      // Validate component definition, use validated copy of the properties.
      component = validator.validateCompleteness(metadata.table, component);

      properties = component.propertyColumns.slice();
      // dataTable has object-based properties, which dataSet doesn't support yet
      for (var i = 0; i < properties.length; i++) {
        if (properties[i].name) {
          properties[i] = properties[i].name;
        }
      }

      listeningPool = new ListeningPool(namespace);
      loadDataSet();

      generateColumnTitlesAndFormatters();
      rowIndex = 0;
      headerData = $.extend(true, [], component.headerData);

      view = new TableView({
        id: component.id,
        title: component.title,
        columns: columns,
        formatters: formatters,
        visibleRows: component.visibleRows,
        showBlankRow: component.showBlankRow,
        width: component.width,
        height: component.height,
        tooltip: component.tooltip,
        klasses: [ "interactive-table", "component" ]
      }, controller);

      $element = view.render();

      helpIconSupport(controller, component, interactivesController.helpSystem);

      // This will load serialized data (passed as "initialData") into the data set if available.
      // Otherwise data set will be just cleared. It will also call dataResetHandler(), so view
      // will be immediately updated.
      dataSet.resetData();
    }

    function loadDataSet () {
      // Get public data set (if its name is provided) or create own, private data set that will
      // be used only by this table.
      dataSet = component.dataSet ? interactivesController.getDataSet(component.dataSet) :
                                    new DataSet({
                                      name: component.id + "-autoDataSet",
                                      properties: properties.slice(),
                                      xProperty: component.xProperty,
                                      initialData: component.tableData,
                                      streamDataFromModel: component.streamDataFromModel,
                                      clearOnModelReset: component.clearOnModelReset
                                    }, interactivesController, true);

      // Register DataSet listeners.
      listeningPool.listen(dataSet, DataSet.Events.SAMPLE_ADDED, sampleAddedHandler);
      listeningPool.listen(dataSet, DataSet.Events.SAMPLE_CHANGED, sampleChangedHandler);
      listeningPool.listen(dataSet, DataSet.Events.DATA_RESET, dataResetHandler);
      listeningPool.listen(dataSet, DataSet.Events.DATA_TRUNCATED, dataTruncatedHandler);
      listeningPool.listen(dataSet, DataSet.Events.SELECTION_CHANGED, selectionChangedHandler);
    }

    function generateColumnTitlesAndFormatters() {
      var i, propertyName, columnDesc, propertyDescription, propertyTitle, unitAbrev;
      var editable, format;

      columns = [];
      formatters = [];

      if (component.indexColumn) {
        columns.push({name: "#", editable: false});
        formatters.push(d3.format("f"));
      }

      for(i = 0; i < component.propertyColumns.length; i++) {
        propertyTitle = null;
        editable = false;
        format = '.3r';

        if (typeof component.propertyColumns[i] === "string") {
          columnDesc = {name: component.propertyColumns[i]};
        } else {
          columnDesc = component.propertyColumns[i];
        }

        if (typeof model !== 'undefined') {
          propertyName = columnDesc.name;
          if (model.properties.hasOwnProperty(propertyName)) {
            propertyDescription = model.getPropertyDescription(propertyName);
            if (propertyDescription) {
              propertyTitle = propertyDescription.getLabel();
              unitAbrev = propertyDescription.getUnitAbbreviation();
              if (unitAbrev) {
                propertyTitle += ' (' + unitAbrev + ')';
              }
            }
          }
        }
        if (!propertyTitle) {
          propertyTitle = columnDesc.name;
          if (columnDesc.units) {
            propertyTitle += ' (' + columnDesc.units + ')';
          }
          editable = columnDesc.hasOwnProperty("editable") ? columnDesc.editable : true;
          format = columnDesc.hasOwnProperty("format") ? columnDesc.format : format;
        }
        columns.push({name: propertyTitle, editable: editable});
        formatters.push(d3.format(format));
      }
    }

    function updateTable() {
      generateColumnTitlesAndFormatters();
      view.updateTable({
        columns: columns,
        formatters: formatters
      });
    }

    function appendPropertyRow() {
      dataSet.appendDataPoint();
    }

    function selectionChangedHandler(evt) {
      var activeRow = evt.data;
      if (component.addNewRows) {
        view.clearSelection();
        view.addSelection(activeRow);
      } else {
        var data = dataSet.getData();
        view.replaceDataRow(nthRow(data, activeRow), 0);
      }
    }

    function data2row(dataPoint, index) {
      var dataRow = [];
      if (component.indexColumn) {
        if (index == null) {
          index = rowIndex;
        }
        dataRow.push(index);
      }
      properties.forEach(function (prop) {
        dataRow.push(dataPoint[prop]);
      });
      return dataRow;
    }

    function nthRow(data, index) {
      var dataRow = [];
      if (component.indexColumn) {
        dataRow.push(index);
      }
      properties.forEach(function (prop) {
        dataRow.push(data[prop][index]);
      });
      return dataRow;
    }

    function isEmpty(row) {
      for (var i = component.indexColumn ? 1 : 0, len = row.length; i < len; i++) {
        if (row[i] != null) return false;
      }
      return true;
    }

    function handleNewDataRow(dataPoint) {
      var dataRow = data2row(dataPoint);
      if (isEmpty(dataRow)) return;
      if (component.addNewRows) {
        view.appendDataRow(dataRow, rowIndex);
        rowIndex++;
      } else {
        view.replaceDataRow(dataRow, 0);
        rowIndex++;
      }
    }

    function sampleAddedHandler(evt) {
      handleNewDataRow(evt.data);
    }

    function sampleChangedHandler(evt) {
      var rowIndex = evt.data.index;
      var dataRow = data2row(evt.data.dataPoint, rowIndex);
      if (component.addNewRows) {
        view.replaceDataRow(dataRow, rowIndex);
      } else {
        view.replaceDataRow(dataRow, 0);
      }
    }

    function dataResetHandler(evt) {
      var data = evt.data;
      var length = dataSet.maxLength(properties);
      var dataRow;

      if (component.addNewRows) {
        var dataRows = [];
        rowIndex = 0;
        for (; rowIndex < length; rowIndex++) {
          dataRows.push(nthRow(data, rowIndex));
        }
        view.clear();
        view.appendDataRows(dataRows, 0);
      } else {
        dataRow = nthRow(data, length - 1);
        view.replaceDataRow(dataRow, 0);
        rowIndex = length;
      }
    }

    function dataTruncatedHandler(evt) {
      var dataLength = dataSet.maxLength(properties);
      rowIndex = dataLength;
      if (component.addNewRows) {
        view.removeDataRows(dataLength);
      } else {
        view.replaceDataRow(nthRow(evt.data, dataLength - 1), 0);
      }
    }

    function registerModelListeners() {
      /** -- Old methods not yet converted to new dataset

      Probably they shouldn't be converted at all. It's data set responsibility.

      model.on('stepBack.'+namespace, redrawCurrentStepPointer);
      model.on('stepForward.'+namespace, redrawCurrentStepPointer);
      model.on('seek.'+namespace, redrawCurrentStepPointer);
      model.on('play.'+namespace, function() {
        if (model.stepCounter() < tableData.length) {
          removeDataAfterStepPointer();
        }
      });
      model.on('invalidation.'+namespace, function() {
        replacePropertyRow();
      });

      **/
    }

    // Public API.
    controller = {
      /**
        Called by the interactives controller when the model finishes loading.
      */
      modelLoadedCallback: function() {
        model = interactivesController.getModel();
        registerModelListeners();
        updateTable();
      },

      resize: function () {
        if (view) view.resize();
      },

      getData: function(propArray) {
        var data = dataSet.getData();
        var result = {};
        propArray.forEach(function (prop) {
          result[prop] = data[prop];
        });
        return result;
      },

      /**
        Used when manually adding a row of property values to the table.
      */
      appendDataPropertiesToComponent: appendPropertyRow,

      addDataToCell: function (row, col, val) {
        // Index column is purely stored by view, it isn't present in DataSet.
        if (component.indexColumn) col--;
        var property = properties[col];

        if (row === rowIndex) {
          // Extend table when new non-empty data is added to "nonexistent" (in data model) row.
          if (val === "") return;
          var values = {};
          values[property] = val;
          dataSet.appendDataPoint(properties, values);
          return;
        }
        dataSet.editDataPoint(row, property, val);
      },

      getDataInCell: function (rowIndex, colIndex) {
        // Index column is purely stored by view, it isn't present in DataSet.
        if (component.indexColumn) colIndex--;
        var property = properties[colIndex];
        return  dataSet.getPropertyValue(rowIndex, property);
      },

      // Returns view container.
      getViewContainer: function () {
        return $element;
      },

      // Returns the view object.
      getView: function() {
        return view;
      },

      // Returns serialized component definition.
      serialize: function () {
        // start with the initial component definition.
        var result = $.extend(true, {}, component);
        // add headerData and tableData
        result.headerData = columns;
        if (!component.dataSet) {
          // Include data directly in component definition only when no external data set is
          // referenced by table. When some external data set is used, it will serialize data.
          result.tableData = dataSet.serializeData();
        }
        return result;
      }
    };

    initialize();

    // Return Public API object.
    return controller;
  };
});

/*global define: false */
define('common/benchmark/browser-detect',[],function () {
  // example userAgent strings:
  // chrome mobile: Mozilla/5.0 (Linux; Android 4.2.2; Galaxy Nexus Build/JDQ39) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/29.0.1547.72 Mobile Safari/537.36

  var windows_platform_token = {
        "Windows NT 6.2": "Windows 8",
        "Windows NT 6.1": "Windows 7",
        "Windows NT 6.0": "Windows Vista",
        "Windows NT 5.2": "Windows Server 2003; Windows XP x64 Edition",
        "Windows NT 5.1": "Windows XP",
        "Windows NT 5.01": "Windows 2000, Service Pack 1 (SP1)",
        "Windows NT 5.0": "Windows 2000",
        "Windows NT 4.0": "Microsoft Windows NT 4.0"
      };

  function os_platform() {
    var match = navigator.userAgent.match(/\(([^)]+)\).*/);
    if (!match) { return "na"; }
    var systemInfo = match[1];
    var systemInfoArray = systemInfo.split("; ");

    if (systemInfoArray[0] === "Macintosh") {
      return systemInfoArray[1];
    } else if (systemInfoArray[0].match(/^Windows/)) {
      var token = navigator.userAgent.match(/\(.*?(Windows NT.+?)[;)]/),
          arch = "";
      if(systemInfo.match(/WOW64/)){
        arch = "64/32";
      } else if(systemInfo.match(/Win64; IA64/)){
        arch = "64";
      } else if(systemInfo.match(/Win64; x64/)){
        arch = "64";
      }
      return windows_platform_token[token[1]] + "/" + arch;
    } else if (systemInfoArray[0].match(/^X11/)) {
      return systemInfoArray.join('/');
    }

    return "na";
  }

  return {
    // Based on: http://detectmobilebrowsers.com/ + ipad|android|playbook|silk as we treat
    // tablets as mobile devices.
    isMobile: (function(a) { return (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|ipad|android|playbook|silk|iris|kindle|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i).test(a)||(/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i).test(a.substr(0,4)); })(navigator.userAgent||navigator.vendor||window.opera),

    what_browser: function what_browser() {
      var chromematch  = / (Chrome)\/(.*?) /,
          ffmatch      = / (Firefox)\/([0123456789ab.]+)/,
          safarimatch  = / AppleWebKit\/([0123456789.+]+) \(KHTML, like Gecko\) Version\/([0123456789.]+) (Safari)\/([0123456789.]+)/,
          iematch      = / (MSIE) ([0123456789.]+);/,
          operamatch   = /^(Opera)\/.+? Version\/([0123456789.]+)$/,
          iphonematch  = /.+?\((iPhone); CPU.+?OS .+?Version\/([0123456789._]+)/,
          ipadmatch    = /.+?\((iPad); CPU.+?OS .+?Version\/([0123456789._]+)/,
          ipodmatch    = /.+?\((iPod); CPU (iPhone.+?) like.+?Version\/([0123456789ab._]+)/,
          androidchromematch = /.+?(Android) ([0123456789.]+).*?; (.+?)\).+? Chrome\/([0123456789.]+)/,
          androidfirefoxmatch = /.+?(Android.+?\)).+? Firefox\/([0123456789.]+)/,
          androidmatch = /.+?(Android) ([0123456789ab.]+).*?; (.+?)\)/,
          match;

      match = navigator.userAgent.match(androidchromematch);
      if (match && match[1]) {
        return {
          browser: "Chrome for Android",
          version: match[4],
          oscpu: match[1] + "/" + match[2] + "/" + match[3]
        };
      }
      match = navigator.userAgent.match(chromematch);
      if (match && match[1]) {
        return {
          browser: match[1],
          version: match[2],
          oscpu: os_platform()
        };
      }
      match = navigator.userAgent.match(ffmatch);
      if (match && match[1]) {
        var buildID = navigator.buildID,
            buildDate = "";
        if (buildID && buildID.length >= 8) {
          buildDate = "(" + buildID.slice(0,4) + "-" + buildID.slice(4,6) + "-" + buildID.slice(6,8) + ")";
        }
        return {
          browser: match[1],
          version: match[2] + ' ' + buildDate,
          oscpu: os_platform()
        };
      }
      match = navigator.userAgent.match(androidfirefoxmatch);
      if (match && match[1]) {
        return {
          browser: "Firefox",
          version: match[2],
          oscpu: match[1]
        };
      }
      match = navigator.userAgent.match(androidmatch);
      if (match && match[1]) {
        return {
          browser: "Android",
          version: match[2],
          oscpu: match[1] + "/" + match[2] + "/" + match[3]
        };
      }
      match = navigator.userAgent.match(safarimatch);
      if (match && match[3]) {
        return {
          browser: match[3],
          version: match[2] + '/' + match[1],
          oscpu: os_platform()
        };
      }
      match = navigator.userAgent.match(iematch);
      if (match && match[1]) {
        var platform_match = navigator.userAgent.match(/\(.*?(Windows.+?); (.+?)[;)].*/);
        return {
          browser: match[1],
          version: match[2],
          oscpu: windows_platform_token[platform_match[1]] + "/" + navigator.cpuClass + "/" + navigator.platform
        };
      }
      match = navigator.userAgent.match(operamatch);
      if (match && match[1]) {
        return {
          browser: match[1],
          version: match[2],
          oscpu: os_platform()
        };
      }
      match = navigator.userAgent.match(iphonematch);
      if (match && match[1]) {
        return {
          browser: "Mobile Safari",
          version: match[2],
          oscpu: match[1] + "/" + "iOS" + "/" + match[2]
        };
      }
      match = navigator.userAgent.match(ipadmatch);
      if (match && match[1]) {
        return {
          browser: "Mobile Safari",
          version: match[2],
          oscpu: match[1] + "/" + "iOS" + "/" + match[2]
        };
      }
      match = navigator.userAgent.match(ipodmatch);
      if (match && match[1]) {
        return {
          browser: "Mobile Safari",
          version: match[3],
          oscpu: match[1] + "/" + "iOS" + "/" + match[2]
        };
      }
      return {
        browser: "",
        version: navigator.appVersion,
        oscpu:   ""
      };
    }
  };
});
/*global Lab, define: false, d3: false */
/*jshint loopfunc: true*/

/*
  ------------------------------------------------------------

  Simple benchmark runner and results generator

    see: https://gist.github.com/1364172

  ------------------------------------------------------------

  Runs benchmarks and generates the results in a table.

  Setup benchmarks to run in an array of objects with two properties:

    name: a title for the table column of results
    numeric: boolean, used to decide what columns should be used to calculate averages
    formatter: (optional) a function that takes a number and returns a formmatted string, example: d3.format("5.1f")
    run: a function that is called to run the benchmark and call back with a value.
         It should accept a single argument, the callback to be called when the
         benchmark completes. It should pass the benchmark value to the callback.

  Start the benchmarks by passing the table element where the results are to
  be placed and an array of benchmarks to run.

  Example:

    var benchmarks_table = document.getElementById("benchmarks-table");

    var benchmarks_to_run = [
      {
        name: "molecules",
        run: function(done) {
          done(mol_number);
        }
      },
      {
        name: "100 Steps (steps/s)",
        run: function(done) {
          modelStop();
          var start = +Date.now();
          var i = -1;
          while (i++ < 100) {
            model.tick();
          }
          elapsed = Date.now() - start;
          done(d3.format("5.1f")(100/elapsed*1000));
        }
      },
    ];

    benchmark.run(benchmarks_table, benchmarks_to_run)

  You can optionally pass two additional arguments to the run method: start_callback, end_callback

    function run(benchmarks_table, benchmarks_to_run, start_callback, end_callback)

  These arguments are used when the last benchmark test is run using the browsers scheduling and re-painting mechanisms.

  For example this test runs a model un the browser and calculates actual frames per second combining the
  model, view, and browser scheduling and repaint operations.

    {
      name: "fps",
      numeric: true,
      formatter: d3.format("5.1f"),
      run: function(done) {
        // warmup
        model.start();
        setTimeout(function() {
          model.stop();
          var start = model.get('time');
          setTimeout(function() {
            // actual fps calculation
            model.start();
            setTimeout(function() {
              model.stop();
              var elapsedModelTime = model.get('time') - start;
              done( elapsedModelTime / (model.get('timeStepsPerTick') * model.get('timeStep')) / 2 );
            }, 2000);
          }, 100);
        }, 1000);
      }
    }

  Here's an example calling the benchmark.run method and passing in start_callback, end_callback functions:

    benchmark.run(document.getElementById("model-benchmark-results"), benchmarksToRun, function() {
      $runBenchmarksButton.attr('disabled', true);
    }, function() {
      $runBenchmarksButton.attr('disabled', false);
    });

  The "Run Benchmarks" button is disabled until the browser finishes running thelast queued test.

  The first five columns in the generated table consist of:

    browser, version, cpu/os, date, and commit

  These columns are followed by a column for each benchmark passed in.

  Subsequent calls to: benchmark.run(benchmarks_table, benchmarks_to_run) will
  add additional rows to the table.

  A special second row is created in the table which displays averages of all tests
  that generate numeric results.

  Here are some css styles for the table:

    table {
      font: 11px/24px Verdana, Arial, Helvetica, sans-serif;
      border-collapse: collapse; }
    th {
      padding: 0 1em;
      text-align: left; }
    td {
      border-top: 1px solid #cccccc;
      padding: 0 1em; }

*/

define('common/benchmark/benchmark',['require','./browser-detect'],function (require) {
  var browser_detect = require('./browser-detect'),
      what_browser = browser_detect.what_browser,

      _isMobile = browser_detect.isMobile,
      _browser = browser_detect.what_browser(),

      average_row;

  function renderToTable(benchmarks_table, benchmarksThatWereRun, results) {
    var i = 0,
        results_row,
        result,
        col_number = 0,
        col_numbers = {},
        title_row,
        title_cells,
        len,
        rows = benchmarks_table.getElementsByTagName("tr");

    benchmarks_table.style.display = "";

    function add_column(title) {
      var title_row = benchmarks_table.getElementsByTagName("tr")[0],
          cell = title_row.appendChild(document.createElement("th"));

      cell.innerHTML = title;
      col_numbers[title] = col_number++;
    }

    function add_row(num_cols) {
      num_cols = num_cols || 0;
      var tr =  benchmarks_table.appendChild(document.createElement("tr")),
          i;

      for (i = 0; i < num_cols; i++) {
        tr.appendChild(document.createElement("td"));
      }
      return tr;
    }

    function add_result(name, content, row) {
      var cell;
      row = row || results_row;
      cell = row.getElementsByTagName("td")[col_numbers[name]];
      if (typeof content === "string" && content.slice(0,1) === "<") {
        cell.innerHTML = content;
      } else {
        cell.textContent = content;
      }
    }

    function update_averages() {
      var i, j,
          b,
          row,
          num_rows = rows.length,
          cell,
          cell_index,
          average_elements = average_row.getElementsByTagName("td"),
          total,
          average,
          genericDecimalFormatter = d3.format("5.1f"),
          genericIntegerFormatter = d3.format("f");

      function isInteger(i) {
        return Math.floor(i) === i;
      }

      for (i = 0; i < benchmarksThatWereRun.length; i++) {
        b = benchmarksThatWereRun[i];
        cell_index = col_numbers[b.name];
        if (b.numeric === false) {
          row = rows[2];
          cell = row.getElementsByTagName("td")[cell_index];
          average_elements[cell_index].innerHTML = cell.innerHTML;
        } else {
          total = 0;
          for (j = 2; j < num_rows; j++) {
            row = rows[j];
            cell = row.getElementsByTagName("td")[cell_index];
            total += (+cell.textContent);
          }
          average = total/(num_rows-2);
          if (b.formatter) {
            average = b.formatter(average);
          } else {
            if (isInteger(average)) {
              average = genericIntegerFormatter(total/(num_rows-2));
            } else {
              average = genericDecimalFormatter(total/(num_rows-2));
            }
          }
          average_elements[cell_index].textContent = average;
        }
      }
    }

    if (rows.length === 0) {
      add_row();
      add_column("browser");
      add_column("version");
      add_column("cpu/os");
      add_column("date");
      add_column("commit");
      add_column("branch");
      for (i = 0; i < benchmarksThatWereRun.length; i++) {
        add_column(benchmarksThatWereRun[i].name);
      }
      average_row = add_row(col_number);
      average_row.className = 'average';
    } else {
      title_row = rows[0];
      title_cells = title_row.getElementsByTagName("th");
      for (i = 0, len = title_cells.length; i < len; i++) {
        col_numbers[title_cells[i].innerHTML] = col_number++;
      }
    }

    results_row = add_row(col_number);
    results_row.className = 'sample';

    for (i = 0; i < 6; i++) {
      result = results[i];
      add_result(result[0], result[1]);
      add_result(result[0], result[1], average_row);
    }

    for(i = 6; i < results.length; i++) {
      result = results[i];
      add_result(result[0], result[1]);
    }
    update_averages();
  }

  function bench(benchmarks_to_run, resultsCallback, start_callback, end_callback) {
    var bencharks_queue = benchmarks_to_run.slice(),
        results = [],
        browser_info = what_browser(),
        formatter = d3.time.format("%Y-%m-%d %H:%M"),
        commit_link;

    results.push([ "browser", browser_info.browser]);
    results.push([ "version", browser_info.version]);
    results.push([ "cpu/os", browser_info.oscpu]);
    results.push([ "date", formatter(new Date())]);

    commit_link = "<a href='"+Lab.version.repo.commit.url+"' class='opens-in-new-window' target='_blank'>"+Lab.version.repo.commit.short_sha+"</a>";
    if (Lab.version.repo.dirty) {
      commit_link += " <i>dirty</i>";
    }
    results.push([ "commit", commit_link]);
    results.push([ "branch", Lab.version.repo.branch]);

    if (start_callback) start_callback();

    runBenchmark(bencharks_queue.shift());

    function runBenchmark(b) {
      b.run(doneCallback);

      function doneCallback(result) {
        if (b.formatter) {
          results.push([ b.name, b.formatter(result) ]);
        } else {
          results.push([ b.name, result ]);
        }

        if (bencharks_queue.length > 0) {
          runBenchmark(bencharks_queue.shift());
        } else {
          if (end_callback) end_callback();
          if (resultsCallback) resultsCallback(results);
        }
      }
    }

    return results;
  }

  function run(benchmarks_to_run, benchmarks_table, resultsCallback, start_callback, end_callback) {
    var results;
    bench(benchmarks_to_run, function(results) {
      renderToTable(benchmarks_table, benchmarks_to_run, results);
      resultsCallback(results);
    }, start_callback, end_callback);
    return results;
  }

  // Return Public API.
  return {
    /**
     * Browser description.
     */
    get browser() {
      return _browser;
    },
    /**
     * Triggers recalculation of browser description and returns the result.
     * Depreciated, use .browser property instead.
     */
    what_browser: function() {
      _browser = what_browser();
      return _browser;
    },
    get isMobile() {
      return _isMobile;
    },
    // run benchmarks, add row to table, update averages row
    run: function(benchmarks_to_run, benchmarks_table, resultsCallback, start_callback, end_callback) {
      run(benchmarks_to_run, benchmarks_table, resultsCallback, start_callback, end_callback);
    },
    // run benchmarks, return results in object
    bench: function(benchmarks_to_run, resultsCallback, start_callback, end_callback) {
      return bench(benchmarks_to_run, resultsCallback, start_callback, end_callback);
    },
    // run benchmarks, add row to table, update averages row
    renderToTable: function(benchmarks_table, benchmarksThatWereRun, results) {
      renderToTable(benchmarks_table, benchmarksThatWereRun, results);
    }
  };
});


define('common/url-helper',['require','lab.version','lab.config'],function (require) {
  var version  = require('lab.version');
  var config   = require('lab.config');

  var addParam = function(string, key, value) {
    if (string.length > 0) {
      return string + "&" + key + "=" + value;
    }
    return "?" + key + "=" + value;
  };

  return {
    getVersionedUrl: function () {
      if (config.versionedHome && version.repo.last_tag) {
        return config.versionedHome(version.repo.last_tag);
      }
      var host     = window.location.host;
      var path     = window.location.pathname;
      var search   = window.location.search;
      var protocol = window.location.protocol;
      search = addParam(search, 'show_data_warning', 'true');
      return protocol + "//" + host + path + search;
    }
  };
});

/*global define:false*/

define('common/controllers/parent-message-api',['require','common/benchmark/benchmark','common/url-helper','iframe-phone'],function(require) {
  var benchmark   = require('common/benchmark/benchmark');
  var urlHelper   = require('common/url-helper');
  var iframePhone = require('iframe-phone');

  // Defines the default postMessage API used to communicate with parent window (i.e., an embedder)
  return function(controller) {
    var model;
    // iframeEndpoint is a singleton (iframe can't have multiple parents).
    var iframeEndpoint = iframePhone.getIFrameEndpoint();

    function sendPropertyValue(propertyName) {
      iframeEndpoint.post('propertyValue', {
        name: propertyName,
        value: model.get(propertyName)
      });
    }

    function sendDataset(datasetName) {
      iframeEndpoint.post('dataset', {
        name: datasetName,
        value: controller.getDataSet(datasetName).serialize()
      });
    }

    // on message 'setFocus' call view.setFocus
    iframeEndpoint.addListener('setFocus', function() {
      var view = controller.modelController.modelContainer;
      if (view && view.setFocus) {
        view.setFocus();
      }
    });

    // on message 'getLearnerUrl' return urlHelper.getVersionedUrl()
    iframeEndpoint.addListener('getLearnerUrl', function() {
      iframeEndpoint.post('setLearnerUrl', urlHelper.getVersionedUrl());
    });

    // on message 'loadInteractive' call controller.loadInteractive
    iframeEndpoint.addListener('loadInteractive', function(content) {
      if (controller && controller.loadInteractive) {
        controller.loadInteractive(content);
      }
    });

    // on message 'loadModel' call controller.loadModel
    iframeEndpoint.addListener('loadModel', function(content) {
      if (controller && controller.loadModel) {
        controller.loadModel(content.modelId, content.modelObject);
      }
    });

    // on message 'getModelState' call and return controller.modelController.state()
    iframeEndpoint.addListener('getModelState', function() {
      if (controller && controller.modelController) {
        iframeEndpoint.post('modelState', controller.modelController.state());
      }
    });

    // on message 'getInteractiveState' call and return controller.serialize() result
    iframeEndpoint.addListener('getInteractiveState', function() {
      if (controller && controller.modelController) {
        iframeEndpoint.post('interactiveState', controller.serialize());
      }
    });

    // on message 'runBenchmarks' call controller.runBenchmarks
    iframeEndpoint.addListener('runBenchmarks', function() {
      var modelController, benchmarks;
      if (controller && controller.modelController) {
        modelController = controller.modelController;
        benchmarks = controller.benchmarks.concat(modelController.benchmarks);
        benchmark.bench(benchmarks, function(results) {
          console.log(results);
          iframeEndpoint.post('returnBenchmarks', {
            results: results,
            benchmarks: benchmarks
          });
        });
      }
    });

    // Listen for events in the model, and notify using message.post
    // uses D3 disaptch on model to trigger events
    // pass in message.properties ([names]) to also send model properties
    // in content object when triggering in parent Frame
    iframeEndpoint.addListener('listenForDispatchEvent', function(content) {
      var eventName    = content.eventName,
          properties   = content.properties,
          values       = {},
          i            = 0,
          propertyName = null;

      model.on(eventName, function() {
        if (properties) {
          for (i = 0 ; i < properties.length; i++) {
            propertyName = properties[i];
            values[propertyName] = model.get(propertyName);
          }
        }
        iframeEndpoint.post(eventName, values);
      });
    });

    var sendDatasetEvents = true;
    // Listen for events in a dataset, and notify using message.post
    // in content object when triggering in parent Frame
    iframeEndpoint.addListener('listenForDatasetEvent', function(content) {
      var eventName    = content.eventName,
          datasetName  = content.datasetName,
          dataset      = controller.getDataSet(datasetName);

      if (!dataset) { return; }
      console.log("registering listener on " + datasetName + ": " + eventName);

      dataset.on(eventName, function(evt) {
        if (sendDatasetEvents) {
          iframeEndpoint.post(datasetName + "-" + eventName, evt);
        }
      });
    });

    iframeEndpoint.addListener('sendDatasetEvent', function(content) {
      var eventName    = content.eventName,
          datasetName  = content.datasetName,
          data         = content.data,
          dataset      = controller.getDataSet(datasetName);

      if (!dataset) { return; }

      sendDatasetEvents = false;
      dataset.handleExternalEvent(eventName, data);
      sendDatasetEvents = true;
    });

    // Remove an existing Listener for events in the model
    iframeEndpoint.addListener('removeListenerForDispatchEvent', function(content) {
      model.on(content, null);
    });

    // on message 'getDataset' datasetName: return a 'dataset' message
    iframeEndpoint.addListener('getDataset', function(content) {
      sendDataset(content);
    });

    // on message 'get' propertyName: return a 'propertyValue' message
    iframeEndpoint.addListener('get', function(content) {
      sendPropertyValue(content);
    });

    // on message 'observe' propertyName: send 'propertyValue' once, and then every time
    // the property changes.
    iframeEndpoint.addListener('observe', function(content) {
      model.addPropertiesListener(content, function() {
        sendPropertyValue(content);
      });
      // Don't forget to send the initial value of the property too:
      sendPropertyValue(content);
    });

    // on message 'set' propertyName: set the relevant property
    iframeEndpoint.addListener('set', function(content) {
      model.set(content.name, content.value);
    });

    iframeEndpoint.addListener('tick', function(content) {
      model.tick(Number(content));
    });

    iframeEndpoint.addListener('play', function() {
      model.start();
    });

    iframeEndpoint.addListener('stop', function() {
      model.stop();
    });

    iframeEndpoint.addListener('reloadModel', function() {
      controller.reloadModel();
    });

    iframeEndpoint.addListener('reloadInteractive', function() {
      controller.reloadInteractive();
    });

    iframeEndpoint.initialize();

    controller.on('modelLoaded.parentMessageAPI', function() {
      iframeEndpoint.post('modelLoaded');
    });

    return {
      // REF FIXME: use scripting API object and avoid binding the model at all (as scripting
      // API is always guaranteed to have a current, valid model object).
      bindModel: function (newModel) {
        model = newModel;
      }
    };
  };
});

/*!
 * mustache.js - Logic-less {{mustache}} templates with JavaScript
 * http://github.com/janl/mustache.js
 */

/*global define: false*/

(function (root, factory) {
  if (typeof exports === "object" && exports) {
    factory(exports); // CommonJS
  } else {
    var mustache = {};
    factory(mustache);
    if (typeof define === "function" && define.amd) {
      define('mustache',mustache); // AMD
    } else {
      root.Mustache = mustache; // <script>
    }
  }
}(this, function (mustache) {

  var whiteRe = /\s*/;
  var spaceRe = /\s+/;
  var nonSpaceRe = /\S/;
  var eqRe = /\s*=/;
  var curlyRe = /\s*\}/;
  var tagRe = /#|\^|\/|>|\{|&|=|!/;

  // Workaround for https://issues.apache.org/jira/browse/COUCHDB-577
  // See https://github.com/janl/mustache.js/issues/189
  var RegExp_test = RegExp.prototype.test;
  function testRegExp(re, string) {
    return RegExp_test.call(re, string);
  }

  function isWhitespace(string) {
    return !testRegExp(nonSpaceRe, string);
  }

  var Object_toString = Object.prototype.toString;
  var isArray = Array.isArray || function (object) {
    return Object_toString.call(object) === '[object Array]';
  };

  function isFunction(object) {
    return typeof object === 'function';
  }

  function escapeRegExp(string) {
    return string.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g, "\\$&");
  }

  var entityMap = {
    "&": "&amp;",
    "<": "&lt;",
    ">": "&gt;",
    '"': '&quot;',
    "'": '&#39;',
    "/": '&#x2F;'
  };

  function escapeHtml(string) {
    return String(string).replace(/[&<>"'\/]/g, function (s) {
      return entityMap[s];
    });
  }

  function Scanner(string) {
    this.string = string;
    this.tail = string;
    this.pos = 0;
  }

  /**
   * Returns `true` if the tail is empty (end of string).
   */
  Scanner.prototype.eos = function () {
    return this.tail === "";
  };

  /**
   * Tries to match the given regular expression at the current position.
   * Returns the matched text if it can match, the empty string otherwise.
   */
  Scanner.prototype.scan = function (re) {
    var match = this.tail.match(re);

    if (match && match.index === 0) {
      var string = match[0];
      this.tail = this.tail.substring(string.length);
      this.pos += string.length;
      return string;
    }

    return "";
  };

  /**
   * Skips all text until the given regular expression can be matched. Returns
   * the skipped string, which is the entire tail if no match can be made.
   */
  Scanner.prototype.scanUntil = function (re) {
    var index = this.tail.search(re), match;

    switch (index) {
    case -1:
      match = this.tail;
      this.tail = "";
      break;
    case 0:
      match = "";
      break;
    default:
      match = this.tail.substring(0, index);
      this.tail = this.tail.substring(index);
    }

    this.pos += match.length;

    return match;
  };

  function Context(view, parent) {
    this.view = view == null ? {} : view;
    this.parent = parent;
    this._cache = { '.': this.view };
  }

  Context.make = function (view) {
    return (view instanceof Context) ? view : new Context(view);
  };

  Context.prototype.push = function (view) {
    return new Context(view, this);
  };

  Context.prototype.lookup = function (name) {
    var value;
    if (name in this._cache) {
      value = this._cache[name];
    } else {
      var context = this;

      while (context) {
        if (name.indexOf('.') > 0) {
          value = context.view;

          var names = name.split('.'), i = 0;
          while (value != null && i < names.length) {
            value = value[names[i++]];
          }
        } else {
          value = context.view[name];
        }

        if (value != null) break;

        context = context.parent;
      }

      this._cache[name] = value;
    }

    if (isFunction(value)) {
      value = value.call(this.view);
    }

    return value;
  };

  function Writer() {
    this.clearCache();
  }

  Writer.prototype.clearCache = function () {
    this._cache = {};
    this._partialCache = {};
  };

  Writer.prototype.compile = function (template, tags) {
    var fn = this._cache[template];

    if (!fn) {
      var tokens = mustache.parse(template, tags);
      fn = this._cache[template] = this.compileTokens(tokens, template);
    }

    return fn;
  };

  Writer.prototype.compilePartial = function (name, template, tags) {
    var fn = this.compile(template, tags);
    this._partialCache[name] = fn;
    return fn;
  };

  Writer.prototype.getPartial = function (name) {
    if (!(name in this._partialCache) && this._loadPartial) {
      this.compilePartial(name, this._loadPartial(name));
    }

    return this._partialCache[name];
  };

  Writer.prototype.compileTokens = function (tokens, template) {
    var self = this;
    return function (view, partials) {
      if (partials) {
        if (isFunction(partials)) {
          self._loadPartial = partials;
        } else {
          for (var name in partials) {
            self.compilePartial(name, partials[name]);
          }
        }
      }

      return renderTokens(tokens, self, Context.make(view), template);
    };
  };

  Writer.prototype.render = function (template, view, partials) {
    return this.compile(template)(view, partials);
  };

  /**
   * Low-level function that renders the given `tokens` using the given `writer`
   * and `context`. The `template` string is only needed for templates that use
   * higher-order sections to extract the portion of the original template that
   * was contained in that section.
   */
  function renderTokens(tokens, writer, context, template) {
    var buffer = '';

    // This function is used to render an artbitrary template
    // in the current context by higher-order functions.
    function subRender(template) {
      return writer.render(template, context);
    }

    var token, tokenValue, value;
    for (var i = 0, len = tokens.length; i < len; ++i) {
      token = tokens[i];
      tokenValue = token[1];

      switch (token[0]) {
      case '#':
        value = context.lookup(tokenValue);

        if (typeof value === 'object' || typeof value === 'string') {
          if (isArray(value)) {
            for (var j = 0, jlen = value.length; j < jlen; ++j) {
              buffer += renderTokens(token[4], writer, context.push(value[j]), template);
            }
          } else if (value) {
            buffer += renderTokens(token[4], writer, context.push(value), template);
          }
        } else if (isFunction(value)) {
          var text = template == null ? null : template.slice(token[3], token[5]);
          value = value.call(context.view, text, subRender);
          if (value != null) buffer += value;
        } else if (value) {
          buffer += renderTokens(token[4], writer, context, template);
        }

        break;
      case '^':
        value = context.lookup(tokenValue);

        // Use JavaScript's definition of falsy. Include empty arrays.
        // See https://github.com/janl/mustache.js/issues/186
        if (!value || (isArray(value) && value.length === 0)) {
          buffer += renderTokens(token[4], writer, context, template);
        }

        break;
      case '>':
        value = writer.getPartial(tokenValue);
        if (isFunction(value)) buffer += value(context);
        break;
      case '&':
        value = context.lookup(tokenValue);
        if (value != null) buffer += value;
        break;
      case 'name':
        value = context.lookup(tokenValue);
        if (value != null) buffer += mustache.escape(value);
        break;
      case 'text':
        buffer += tokenValue;
        break;
      }
    }

    return buffer;
  }

  /**
   * Forms the given array of `tokens` into a nested tree structure where
   * tokens that represent a section have two additional items: 1) an array of
   * all tokens that appear in that section and 2) the index in the original
   * template that represents the end of that section.
   */
  function nestTokens(tokens) {
    var tree = [];
    var collector = tree;
    var sections = [];

    var token;
    for (var i = 0, len = tokens.length; i < len; ++i) {
      token = tokens[i];
      switch (token[0]) {
      case '#':
      case '^':
        sections.push(token);
        collector.push(token);
        collector = token[4] = [];
        break;
      case '/':
        var section = sections.pop();
        section[5] = token[2];
        collector = sections.length > 0 ? sections[sections.length - 1][4] : tree;
        break;
      default:
        collector.push(token);
      }
    }

    return tree;
  }

  /**
   * Combines the values of consecutive text tokens in the given `tokens` array
   * to a single token.
   */
  function squashTokens(tokens) {
    var squashedTokens = [];

    var token, lastToken;
    for (var i = 0, len = tokens.length; i < len; ++i) {
      token = tokens[i];
      if (token) {
        if (token[0] === 'text' && lastToken && lastToken[0] === 'text') {
          lastToken[1] += token[1];
          lastToken[3] = token[3];
        } else {
          lastToken = token;
          squashedTokens.push(token);
        }
      }
    }

    return squashedTokens;
  }

  function escapeTags(tags) {
    return [
      new RegExp(escapeRegExp(tags[0]) + "\\s*"),
      new RegExp("\\s*" + escapeRegExp(tags[1]))
    ];
  }

  /**
   * Breaks up the given `template` string into a tree of token objects. If
   * `tags` is given here it must be an array with two string values: the
   * opening and closing tags used in the template (e.g. ["<%", "%>"]). Of
   * course, the default is to use mustaches (i.e. Mustache.tags).
   */
  function parseTemplate(template, tags) {
    template = template || '';
    tags = tags || mustache.tags;

    if (typeof tags === 'string') tags = tags.split(spaceRe);
    if (tags.length !== 2) throw new Error('Invalid tags: ' + tags.join(', '));

    var tagRes = escapeTags(tags);
    var scanner = new Scanner(template);

    var sections = [];     // Stack to hold section tokens
    var tokens = [];       // Buffer to hold the tokens
    var spaces = [];       // Indices of whitespace tokens on the current line
    var hasTag = false;    // Is there a {{tag}} on the current line?
    var nonSpace = false;  // Is there a non-space char on the current line?

    // Strips all whitespace tokens array for the current line
    // if there was a {{#tag}} on it and otherwise only space.
    function stripSpace() {
      if (hasTag && !nonSpace) {
        while (spaces.length) {
          delete tokens[spaces.pop()];
        }
      } else {
        spaces = [];
      }

      hasTag = false;
      nonSpace = false;
    }

    var start, type, value, chr, token, openSection;
    while (!scanner.eos()) {
      start = scanner.pos;

      // Match any text between tags.
      value = scanner.scanUntil(tagRes[0]);
      if (value) {
        for (var i = 0, len = value.length; i < len; ++i) {
          chr = value.charAt(i);

          if (isWhitespace(chr)) {
            spaces.push(tokens.length);
          } else {
            nonSpace = true;
          }

          tokens.push(['text', chr, start, start + 1]);
          start += 1;

          // Check for whitespace on the current line.
          if (chr == '\n') stripSpace();
        }
      }

      // Match the opening tag.
      if (!scanner.scan(tagRes[0])) break;
      hasTag = true;

      // Get the tag type.
      type = scanner.scan(tagRe) || 'name';
      scanner.scan(whiteRe);

      // Get the tag value.
      if (type === '=') {
        value = scanner.scanUntil(eqRe);
        scanner.scan(eqRe);
        scanner.scanUntil(tagRes[1]);
      } else if (type === '{') {
        value = scanner.scanUntil(new RegExp('\\s*' + escapeRegExp('}' + tags[1])));
        scanner.scan(curlyRe);
        scanner.scanUntil(tagRes[1]);
        type = '&';
      } else {
        value = scanner.scanUntil(tagRes[1]);
      }

      // Match the closing tag.
      if (!scanner.scan(tagRes[1])) throw new Error('Unclosed tag at ' + scanner.pos);

      token = [type, value, start, scanner.pos];
      tokens.push(token);

      if (type === '#' || type === '^') {
        sections.push(token);
      } else if (type === '/') {
        // Check section nesting.
        openSection = sections.pop();
        if (!openSection) {
          throw new Error('Unopened section "' + value + '" at ' + start);
        }
        if (openSection[1] !== value) {
          throw new Error('Unclosed section "' + openSection[1] + '" at ' + start);
        }
      } else if (type === 'name' || type === '{' || type === '&') {
        nonSpace = true;
      } else if (type === '=') {
        // Set the tags for the next time around.
        tags = value.split(spaceRe);
        if (tags.length !== 2) {
          throw new Error('Invalid tags at ' + start + ': ' + tags.join(', '));
        }
        tagRes = escapeTags(tags);
      }
    }

    // Make sure there are no open sections when we're done.
    openSection = sections.pop();
    if (openSection) {
      throw new Error('Unclosed section "' + openSection[1] + '" at ' + scanner.pos);
    }

    return nestTokens(squashTokens(tokens));
  }

  mustache.name = "mustache.js";
  mustache.version = "0.7.3";
  mustache.tags = ["{{", "}}"];

  mustache.Scanner = Scanner;
  mustache.Context = Context;
  mustache.Writer = Writer;

  mustache.parse = parseTemplate;

  // Export the escaping function so that the user may override it.
  // See https://github.com/janl/mustache.js/issues/244
  mustache.escape = escapeHtml;

  // All Mustache.* functions use this writer.
  var defaultWriter = new Writer();

  /**
   * Clears all cached templates and partials in the default writer.
   */
  mustache.clearCache = function () {
    return defaultWriter.clearCache();
  };

  /**
   * Compiles the given `template` to a reusable function using the default
   * writer.
   */
  mustache.compile = function (template, tags) {
    return defaultWriter.compile(template, tags);
  };

  /**
   * Compiles the partial with the given `name` and `template` to a reusable
   * function using the default writer.
   */
  mustache.compilePartial = function (name, template, tags) {
    return defaultWriter.compilePartial(name, template, tags);
  };

  /**
   * Compiles the given array of tokens (the output of a parse) to a reusable
   * function using the default writer.
   */
  mustache.compileTokens = function (tokens, template) {
    return defaultWriter.compileTokens(tokens, template);
  };

  /**
   * Renders the `template` with the given `view` and `partials` using the
   * default writer.
   */
  mustache.render = function (template, view, partials) {
    return defaultWriter.render(template, view, partials);
  };

  // This is here for backwards compatibility with 0.4.x.
  mustache.to_html = function (template, view, partials, send) {
    var result = mustache.render(template, view, partials);

    if (isFunction(send)) {
      send(result);
    } else {
      return result;
    }
  };

}));


define('text!common/controllers/thermometer.tpl',[],function () { return '<div class="interactive-thermometer component" id="{{id}}">\n  <div class="thermometer-main-container">\n    <div class="thermometer">\n      <div class="thermometer-fill"></div>\n    </div>\n    <p class="label">{{labelText}}</p>\n  </div>\n  <div class="labels-container">\n    {{#labels}}\n      <span class="value-label" style="bottom: {{position}}">{{label}}</span>\n    {{/labels}}\n  </div>\n</div>';});

/*global define, $ */

define('common/controllers/thermometer-controller',['require','mustache','text!common/controllers/thermometer.tpl','common/controllers/interactive-metadata','common/validator','common/jquery-plugins'],function (require) {

  var mustache       = require('mustache'),
      thermometerTpl = require('text!common/controllers/thermometer.tpl'),
      metadata       = require('common/controllers/interactive-metadata'),
      validator      = require('common/validator');
      require('common/jquery-plugins');

  /**
    An 'interactive thermometer' object, that wraps a base Thermometer with a label for use
    in Interactives.

    Properties are:

     modelLoadedCallback:  Standard interactive component callback, called as soon as the model is loaded.
     getViewContainer:     DOM element containing the Thermometer div and the label div.
     getView:              Returns base Thermometer object, with no label.
  */
  return function ThermometerController(component, interactivesController) {
    var units,
        digits,
        // Returns scaled value using provided 'scale' and 'offset' component properties.
        scaleFunc,
        // Returns value between 0% and 100% using provided 'min' and 'max' component properties.
        normalize,

        labelIsReading,
        fitWidth,
        $elem,
        $thermometer,
        $thermometerFill,
        $bottomLabel,
        $labelsContainer,

        controller,
        model,

        updateLabel = function (temperature) {
          temperature = scaleFunc(temperature);
          $bottomLabel.text(temperature.toFixed(digits) + " " + units);
        },

        // Updates thermometer using model property. Used in modelLoadedCallback.
        // Make sure that this function is only called when model is loaded.
        updateThermometer = function () {
          var t = model.get('targetTemperature');
          $thermometerFill.css("height", normalize(scaleFunc(t)));
          if (labelIsReading) updateLabel(t);
        };

    //
    // Initialization.
    //
    function initialize() {
      var reading, offset, scale,
          view, labelText, labels,
          longestLabelIdx, maxLength,
          max, min, i, len;

      model = interactivesController.getModel();

      component = validator.validateCompleteness(metadata.thermometer, component);
      reading = component.reading;
      units = reading.units;
      offset = reading.offset;
      scale  = reading.scale;
      digits = reading.digits;
      min = component.min;
      max = component.max;

      scaleFunc = function (val) {
        return scale * val + offset;
      };

      normalize = function (val) {
        return ((val - min) / (max - min) * 100) + "%";
      };

      labelIsReading = component.labelIsReading;
      labelText = labelIsReading ? "" : "Thermometer";

      // Calculate view.
      view = {
        id: component.id,
        labelText: labelIsReading ? "" : "Thermometer"
      };
      // Calculate tick labels positions.
      labels = component.labels;
      maxLength = -Infinity;
      view.labels = [];
      for (i = 0, len = labels.length; i < len; i++) {
        view.labels.push({
          label: labels[i].label,
          position: normalize(scaleFunc(labels[i].value))
        });
        if (labels[i].label.length > maxLength) {
          maxLength = labels[i].label.length;
          longestLabelIdx = i;
        }
      }
      // Render view.
      $elem = $(mustache.render(thermometerTpl, view));
      // Save useful references.
      $thermometer = $elem.find(".thermometer");
      $thermometerFill = $elem.find(".thermometer-fill");
      $bottomLabel = $elem.find(".label");
      $labelsContainer = $elem.find(".labels-container");

      // Calculate size of the "labels container" div.
      // It's used to ensure that wrapping DIV ($elem) has correct width
      // so layout system can work fine. We have to explicitly set its
      // width, as absolutely positioned elements (labels) are excluded
      // from the layout workflow.
      maxLength = $elem.measure(function() {
        // Calculate width of the longest label in ems (!).
        return (this.width() / parseFloat(this.css("font-size"))) + "em";
      }, ".value-label:eq(" + longestLabelIdx + ")", interactivesController.interactiveContainer);
      $labelsContainer.css("width", maxLength);

      // Support custom dimensions. Implementation may seem unclear,
      // but the goal is to provide most obvious behavior for authors.
      // We can simply set height of the most outer container.
      // Thermometer will adjusts itself appropriately.
      $elem.css("height", component.height);
      // Width is more tricky.
      fitWidth = false;
      if (!/%$/.test(component.width)) {
        // When it's ems or px, its enough to set thermometer width.
        $thermometer.css("width", component.width);
      } else {
        // Whet it's defined in %, set width of the most outer container
        // to that value and thermometer should use all available space
        // (100% or 100% - labels width).
        $elem.css("width", component.width);
        fitWidth = true;
      }
    }

    // Public API.
    controller = {
      // No modelLoadeCallback is defined. In case of need:
      modelLoadedCallback: function () {
        if (model) {
          model.removeObserver('targetTemperature', updateThermometer);
        }
        model = interactivesController.getModel();
        // TODO: update to observe actual system temperature once output properties are observable
        model.addPropertiesListener('targetTemperature', updateThermometer);
        updateThermometer();
      },

      // Returns view container.
      getViewContainer: function () {
        return $elem;
      },

      resize: function () {
        var thermometerHeight = $elem.height() - $bottomLabel.height();
        $thermometer.height(thermometerHeight);
        $labelsContainer.height(thermometerHeight);
        if (fitWidth) {
          // When user sets width in %, it means that the most outer container
          // width is equal to this value and thermometer shape should try to
          // use maximum available space.
          $thermometer.width($elem.width() - $labelsContainer.width());
        }
      },

      // Returns serialized component definition.
      serialize: function () {
        // Return the initial component definition.
        // Displayed value is always defined by the model,
        // so it shouldn't be serialized.
        return component;
      }
    };

    initialize();

    // Return Public API object.
    return controller;
  };
});

/*global define, $ */

define('common/controllers/playback-controller',['require','common/inherit','common/layout/detect-font-change','common/controllers/interactive-component','common/views/select-box-view','underscore'],function (require) {

  var inherit              = require('common/inherit'),
      detectFontChange     = require('common/layout/detect-font-change'),
      InteractiveComponent = require('common/controllers/interactive-component'),
      SelectBoxView        = require('common/views/select-box-view'),
      _                    = require('underscore');

  function disable($el) {
    $el.attr('disabled', true).addClass('lab-disabled').css('cursor', 'default');
  }

  function enable($el) {
    $el.attr('disabled', false).removeClass('lab-disabled').css('cursor', 'pointer');
  }

  function enableWhen(condition, $el) {
    if (condition) {
      enable($el);
    } else {
      disable($el);
    }
  }

  function disableWhen(condition, $el) {
    enableWhen(!condition, $el);
  }

  /**
   * Playback controller.
   *
   * @constructor
   * @extends InteractiveComponent
   * @param {Object} component Component JSON definition.
   * @param {interactivesController} interactives controller that created this playback controller
   */
  function PlaybackController(component, interactivesController) {
    // Call super constructor.
    InteractiveComponent.call(this, "playback", component, interactivesController);

    this.$element.addClass("interactive-playback");

    this._modelStopped = true;
    this._modelPlayable = true;
    this._modelHasPlayed = false;
    this._dataAreAvailableForExport = false;
    this._timeDesc = null;
    this._model = null;
    this._scriptingAPI = null;
    this._interactivesController = interactivesController;
    // Font used by time display
    this._fontSpec = "2em " + interactivesController.fontFamily;

    detectFontChange({
      font: interactivesController.fontFamily,
      onchange: this._updateClockVisibility.bind(this)
    });
  }
  inherit(PlaybackController, InteractiveComponent);

  // These method implementations depend on the controlButtonStyle
  var controlButtonMethods = {
    video: {
      createControls: function() {
        var scriptingAPI = this._scriptingAPI;
        var i18n = this._interactivesController.i18n;

        this.$element.empty();
        this.$element.removeClass('text').addClass('video');

        /** @private */
        this._$reset = $('<button class="reset"><i class="icon-step-backward"></i></button>').appendTo(this.$element);
        /** @private */
        this._$playPause = $('<button class="play-pause"><i class="icon-play"></i><i class="icon-pause"></i></button>').appendTo(this.$element);
        /** @private */
        this._$timeDisplay = $('<span class="time-display">').appendTo(this._$playPause);

        // Canvas is much faster that native HTML text, especially on mobile devices. See:
        // https://www.pivotaltracker.com/story/show/58879086
        /** @private */
        this._$timeCanvas = $('<canvas>').appendTo(this._$timeDisplay);
        /** @private */
        this._timeCtx = this._$timeCanvas[0].getContext("2d");

        /** @private */
        this._$stepBackward = $('<button class="step"><i class="icon-backward"></i></button>').insertBefore(this._$playPause);
        /** @private */
        this._$stepForward = $('<button class="step"><i class="icon-forward"></i></button>').insertAfter(this._$playPause);

        this._$reset.after('<div class="spacer reset">');
        this._$stepBackward.after('<div class="spacer step">');
        this._$stepForward.before('<div class="spacer step">');

        // Bind click handlers.
        this._$reset.on("click", scriptingAPI.reloadModel);

        this._$playPause.on("click", function() {
          if (this._modelStopped) {
            if (this._modelPlayable) {
              scriptingAPI.start();
            }
          } else {
            scriptingAPI.stop();
          }
        }.bind(this));

        this._$stepBackward.on("click", scriptingAPI.stepBack);
        this._$stepForward.on("click", scriptingAPI.stepForward);

        this._$playPause.attr("title", i18n.t("banner.video_play_pause_tooltip"));
        this._$reset.attr("title", i18n.t("banner.video_reset_tooltip"));
        this._$stepBackward.attr("title", i18n.t("banner.video_step_back_tooltip"));
        this._$stepForward.attr("title", i18n.t("banner.video_step_forward_tooltip"));
      },

      updateButtonStates: function(stopped, playable) {
        var playing = ! stopped;
        this._$playPause.toggleClass('playing', playing);
        disableWhen(stopped && ! playable, this._$playPause);
      },

      updateControlButtonChoices: function(mode) {
        var $buttons;

        if (!mode) { // mode === "" || mode === null || mode === false
          this.$element.find(".step, .reset, .play-pause").addClass("hidden");
        } else if (mode === "play") {
          this.$element.find(".play-pause").removeClass("hidden");
          this.$element.find(".spacer, .step, .reset").addClass("hidden");
        } else if (mode === "reset") {
          this.$element.find(".reset").removeClass("hidden");
          this.$element.find(".spacer, .play-pause, .step").addClass("hidden");
        } else if (mode === "play_reset") {
          this.$element.find(".spacer, .play-pause, .reset").removeClass("hidden");
          this.$element.find(".step").addClass("hidden");
        } else if (mode === "play_reset_step") {
          this.$element.find(".spacer, .step, .reset, .play-pause").removeClass("hidden");
        }
        $buttons = this.$element.find("button");
        $buttons.removeClass("first");
        $buttons.removeClass("last");
        $buttons = $buttons.not(".hidden");
        $buttons.first().addClass("first");
        $buttons.last().addClass("last");
      },

      setClockVisibility: function(showClock) {
        if (showClock) {
          this._$playPause.addClass("with-clock");
          // Update 'displayTime' description (used for formatting).
          this._timeDesc =  this._model.getPropertyDescription("displayTime");
          // Update clock immediately.
          this._timeChanged();
        } else {
          this._$playPause.removeClass("with-clock");
        }
      },

      setClockValue: function(value) {
        // Canvas is much faster that native HTML text, especially on mobile devices. See:
        // https://www.pivotaltracker.com/story/show/58879086
        this._timeCtx.clearRect(0, 0, this._canvWidth, this._canvHeigth);
        this._timeCtx.fillText(
          this._timeDesc.format(value), this._canvWidth, this._canvHeigth * 0.85);
      }
    },

    text: {
      createControls: function() {
        var scriptingAPI = this._scriptingAPI;
        var i18n = this._interactivesController.i18n;

        this.$element.empty();
        this.$element.removeClass('video').addClass('text');

        this._$start = $('<button class="start">').text(i18n.t("banner.text_start")).appendTo(this.$element);
        this._$stop = $('<button class="stop">').text(i18n.t("banner.text_stop")).appendTo(this.$element);
        this._$reset = $('<button class="reset">').text(i18n.t("banner.text_reset")).appendTo(this.$element);

        // Bind click handlers
        this._$reset.on('click', scriptingAPI.reloadModel);
        this._$start.on('click', scriptingAPI.start);
        this._$stop.on('click', scriptingAPI.stop);

        this._$start.attr("title", i18n.t("banner.text_start_tooltip"));
        this._$stop.attr("title",  i18n.t("banner.text_stop_tooltip"));
        this._$reset.attr("title", i18n.t("banner.text_reset_tooltip"));
      },

      updateButtonStates: function(stopped, playable) {
        disableWhen(stopped, this._$stop);
        enableWhen(playable, this._$start);
      },

      updateControlButtonChoices: function(mode) {
        if (!mode) { // mode === "" || mode === null || mode === false
          this.$element.find(".reset, .start, .stop").addClass("hidden");
        } else if (mode === "play") {
          this.$element.find(".start, .stop").removeClass("hidden");
          this.$element.find(".reset").addClass("hidden");
        } else if (mode === "reset") {
          this.$element.find(".reset").removeClass("hidden");
          this.$element.find(".start, .stop").addClass("hidden");
        } else if (mode === "play_reset") {
          this.$element.find(".start, .stop, .reset").removeClass("hidden");
        } else {
          // no play_reset_step support for text style buttons, yet.
          throw new Error("controlButtons option \"" + mode +
            "\" is not understood or is not compatible with controlButtonStyle \"text\"");
        }
      },

      setClockVisibility: function() {
        // noop
      },

      setClockValue: function() {
        // noop
      }
    },

    codap: {
      createControls: function() {
        var scriptingAPI = this._scriptingAPI;
        var i18n = this._interactivesController.i18n;

        this.$element.removeClass('video').addClass('text wide');
        this.$element.empty();

        this._$start = $('<button class="start">').
          text(i18n.t('banner.text_start')).
          attr("title", i18n.t('banner.text_start_tooltip')).
          appendTo(this.$element);

        this._$stop = $('<button class="stop">').
          text(i18n.t('banner.text_stop')).
          attr('title', i18n.t('banner.text_start_tooltip')).
          appendTo(this.$element);

        this._$analyzeData = $('<button class="analyze-data">').
          text(i18n.t('banner.text_analyze_data')).
          attr('title', i18n.t('banner.text_analyze_data_tooltip')).
          appendTo(this.$element);

        this._$newRun = $('<button class="new-run">').
          text(i18n.t('banner.text_new_run')).
          attr('title', i18n.t('banner.text_new_run_tooltip')).
          appendTo(this.$element);

        // Bind click handlers
        this._$start.on('click', scriptingAPI.start);
        this._$stop.on('click', scriptingAPI.stop);
        this._$analyzeData.on('click', function() {
          scriptingAPI.exportData();
          // Export controller may or may not want us to wait for a new run before re-enabling the
          // analyze data button:
          this._dataAreAvailableForExport = scriptingAPI.dataAreAvailableForExport();
          if ( ! this._dataAreAvailableForExport ) {
            disable($(this));
          }
        });

        this._$newRun.on('click', function() {
          scriptingAPI.reloadModel({ cause: 'new-run' });
        });
      },

      updateButtonStates: function(stopped, playable, hasPlayed, dataAreAvailableForExport) {
        disableWhen(hasPlayed, this._$start);
        disableWhen(stopped, this._$stop);
        enableWhen(hasPlayed && stopped, this._$newRun);
        enableWhen(dataAreAvailableForExport, this._$analyzeData);
      },

      updateControlButtonChoices: function(mode) {
        // mode is one of: null, 'play', 'reset', 'play_reset', 'play_reset_step'
        // only show start/stop buttons in 'play', 'play_reset', 'play_reset_step'
        // only show new-run button if reset button is requested AND play button is requested:
        // (i.e., in play_reset and play_reset_step)

        if (mode && mode.indexOf('play') >= 0) {
          this._$start.show();
          this._$stop.show();
          if (mode.indexOf('reset') >= 0) {
            this._$newRun.show();
          } else {
            this._$newRun.hide();
          }
        } else {
          this._$start.hide();
          this._$stop.hide();
          this._$newRun.hide();
        }
      },

      setClockVisibility: function() {
        // noop
      },

      setClockValue: function() {
        // noop
      }
    }
  };

  PlaybackController.prototype._createControls = function() {
    this._controlButtonMethods.createControls.apply(this, arguments);
    this._updateButtonStates();
    this._fitButtons();
  };

  PlaybackController.prototype._updateButtonStates = function() {
    this._controlButtonMethods.updateButtonStates.call(this,
       this._modelStopped, this._modelPlayable, this._modelHasPlayed, this._dataAreAvailableForExport );
  };

  PlaybackController.prototype._updateControlButtonChoices = function() {
    this._controlButtonMethods.updateControlButtonChoices.apply(this, arguments);
    this._fitButtons();
  };

  PlaybackController.prototype._setClockVisibility = function() {
    this._controlButtonMethods.setClockVisibility.apply(this, arguments);
  };

  PlaybackController.prototype._setClockValue = function() {
    this._controlButtonMethods.setClockValue.apply(this, arguments);
  };

  PlaybackController.prototype._updateCachedSimulationState = function() {
    var modelStopped = this._model.isStopped();
    // Coerce undefined to *true* for models that don't have isPlayable property
    var modelPlayable = this._model.properties.isPlayable === false ? false : true;
    var modelHasPlayed = this._model.properties.hasPlayed;
    var dataAreAvailableForExport = this._scriptingAPI.dataAreAvailableForExport();

    // Update button states only if modelStopped/modelPlayable actually changed. (Since they're
    // model properties, we are called every tick, unfortunately -- the optimization assumption
    // made by PropertySupport is that all model properties are *physics* properties which are
    // almost certain to change every tick, so it doesn't check to see if they really changed.)
    // update-button-states adds and removes classes, which at the very least adds a distracting
    // entry to Dev Tools timeline view every tick.
    if (modelStopped !== this._modelStopped ||
        modelPlayable !== this._modelPlayable ||
        modelHasPlayed !== this._modelHasPlayed ||
        dataAreAvailableForExport !== this._dataAreAvailableForExport) {
      this._modelStopped = modelStopped;
      this._modelPlayable = modelPlayable;
      this._modelHasPlayed = modelHasPlayed;
      this._dataAreAvailableForExport = dataAreAvailableForExport;

      return true;
    }
    return false;
  };

  /**
   * Updates play / pause button.
   * @private
   */
  PlaybackController.prototype._simulationStateChanged = function () {
    if (this._updateCachedSimulationState()) {
      this._updateButtonStates();
    }
  };

  /**
   * Updates time display.
   * @private
   */
  PlaybackController.prototype._timeChanged = function () {
    if (this._model.properties.showClock) {
      this._setClockValue(this._model.properties.displayTime);
    }
  };

  PlaybackController.prototype._useDurationChanged = function() {
    // Reminder. Output properties are notified every tick (due to obsolete assumption that they
    // are necessarily physical properties.)
    // Thus, dirty check before doing anything.

    if (this._useDuration !== this._model.properties.actualUseDuration) {
      this._useDuration = this._model.properties.actualUseDuration;
      this._updateDurationControl();
    }
  };

  PlaybackController.prototype._updateDurationControl = function() {
    var model = this._model;
    var useDuration = this._useDuration;
    var durationOptions = model.properties.durationOptions;
    var actualDuration = model.properties.actualDuration;
    var selectOptions = [];

    if (this.durationControl) {
      this.durationControl.destroy();
      this.durationControl = null;
    }

    if (useDuration && durationOptions.length > 0) {

      durationOptions.forEach(function(duration) {
        // Sneak actualDuration in before 'duration', if that's where it belongs in the sorted list
        // and it was not previously added.
        if (actualDuration < duration &&
            (selectOptions.length === 0 || actualDuration > selectOptions[selectOptions.length-1].value) ) {

          selectOptions.push({
            value: actualDuration,
            text: model.formatTime(actualDuration),
            selected: true
          });
        }

        selectOptions.push({
          value: duration,
          text: model.formatTime(duration),
          selected: duration === actualDuration
        });
      });

      this.durationControl = new SelectBoxView({
        id: 'duration-control',
        options: selectOptions,
        onChange: function(option) {
          // use this._model here, not the possibly-stale closure value 'model'!
          this._model.properties.requestedDuration = option.value;
        }.bind(this)
      });

      this.durationControl.render(this.$element.parent());
      this.durationControl.$element.addClass('duration-control interactive-pulldown component component-spacing');
      this.$element.parent().append(this.durationControl.$element);
    }

    this._fitButtons();
  };

  /**
   * Updates playback controller mode (none, "play", "play_reset" or "play_reset_step").
   * @private
   */
  PlaybackController.prototype._controlButtonChoicesChanged = function () {
    this._updateControlButtonChoices(this._model.properties.controlButtons);
  };

  /**
   * Updates playback controller style (currently, "video" or "text")
   * @private
   */
  PlaybackController.prototype._controlButtonStyleChanged = function () {
    // To handle model types whose metadata don't define controlButtonStyle, default to 'video' here
    var style = this._model.properties.controlButtonStyle || 'video';
    if (this.controlButtonStyle === style) {
      return;
    }
    this.controlButtonStyle = style;
    this.$element.empty();

    if (!controlButtonMethods[style]) {
      throw new Error("Unknown controlButtonStyle \"" + style + "\"");
    }

    this._controlButtonMethods = controlButtonMethods[style];
    this._updateCachedSimulationState();
    this._createControls();
    this._controlButtonChoicesChanged();
  };

  PlaybackController.prototype._updateClockVisibility = function() {
    this._setClockVisibility(this._model.properties.showClock);
  };

  /*
    Adjusts the font-size of the playback buttons so that they fit within the available
    width. The default font-size (set by the interactive's layout engine) is honored by default,
    but if using this size would cause the buttons to overflow our containing element, the
    relative font-size of the button container is adjusted so that they just fit. (The button
    widths are specified in ems.)

    A minimum font-size of 10px is used; when this might cause the buttons to overflow, the buttons
    are srunched together (by use of the 'scrunched-buttons' CSS class).

    This is a relatively "heavy" operation involving DOM manipulation and relayout, so
    it should not be called during a window resize. Instead, call _fitButtonsOnResize, which
    uses a debounced version of this method which delays until the end of the first 200ms
    window that passes without a resize event.
  */
  PlaybackController.prototype._fitButtons = function() {
    // Get the width of the element we need to fit into
    var parentWidth = this.$element.parent().width();
    var MIN_FONT_SIZE = 10; // px
    var relativeFontSize;
    var absoluteFontSize;
    var fontSizeStyle;

    var $durationControl = this.durationControl && this.durationControl.$element;

    // Temporarily undo any positioning that prevents overlap of buttons & duration control
    this.$element.css('left', '');

    // Get the width the buttons would have in the absence of the font-sizing and
    // margin adjustments that may have been previously applied by this method.
    var elementWidth = this.$element.measure(function() {
      // account for the width of the duration dropdown
      if ($durationControl) {
        this.prepend($durationControl.clone());
      }
      this.removeClass('scrunched-buttons');
      return this.width();
    }, null, $('#bottom-bar'));

    this.$element.parent().css('fontSize', '');

    if (elementWidth < parentWidth) {
      this.$element.removeClass('scrunched-buttons');
    } else {
      relativeFontSize = parentWidth / elementWidth;
      absoluteFontSize = parseFloat(this.$element.parent().css('font-size')) * relativeFontSize;
      fontSizeStyle = absoluteFontSize < MIN_FONT_SIZE ? (MIN_FONT_SIZE + 'px') : (relativeFontSize + 'em');
      this.$element.parent().css('fontSize', fontSizeStyle);

      // Remove scrunched-buttons before testing width...
      this.$element.removeClass('scrunched-buttons');

      // and then add it back if needed to make the buttons (more likely to) fit.
      // (The magic 10 is a guesstimate of the allowable slop/margin on the buttons; a
      // more precise value could be derived from button's calculated margin, but that
      // seems like overkill.)
      if (this.$element.width() - 10 >= parentWidth) {
        this.$element.addClass('scrunched-buttons');
      }
    }

    // Finally, make room for the duration control. Need to make sure left margin of leftmost button
    // doesn't bump into it, however.
    if ($durationControl) {
      var $b = this.$element.find('button:visible').first();

      if ($b.length > 0) {
        var right = $b.offset().left - parseFloat($b.css('padding-left')) - parseFloat($b.css('margin-left'));
        var left = $durationControl.offset().left + $durationControl.outerWidth(true);

        if (right < left) {
          this.$element.css('left', left - right + 'px');
        }
      }
    }
  };

  PlaybackController.prototype._fitButtonsOnResize = function() {
    if ( ! this._debouncedFitButtons ) {
      this._debouncedFitButtons = _.debounce(this._fitButtons.bind(this), 200);
    }

    // Prevent visual chaos by "locking" the playback control's fontsize to its current px
    // value while the interactive font-size changes during the resize operation.
    this.$element.parent().css('fontSize', this.$element.parent().css('fontSize'));

    // After 500ms of no resize events, set the playback controls' font-size so they fit
    this._debouncedFitButtons();
  };

  /**
   * Implements optional callback supported by Interactive Controller.
   */
  PlaybackController.prototype.modelLoadedCallback = function () {

    this._model = this._interactivesController.getModel();
    this._scriptingAPI = this._interactivesController.getScriptingAPI().api;

    var simulationStateChanged = this._simulationStateChanged.bind(this);

    // Update play / pause button.
    // Use event namespace to let multiple playbacks work fine with one model.
    this._model.on('play.' + this.component.id, simulationStateChanged);
    this._model.on('stop.' + this.component.id, simulationStateChanged);
    this._model.addObserver('isPlayable', simulationStateChanged);
    this._model.addObserver('showClock', this._updateClockVisibility.bind(this));
    this._model.addObserver('displayTime', this._timeChanged.bind(this));

    // Update which controls/style to display
    this._model.addObserver('actualUseDuration', this._useDurationChanged.bind(this));
    this._model.addObserver('controlButtons', this._controlButtonChoicesChanged.bind(this));
    this._model.addObserver('controlButtonStyle', this._controlButtonStyleChanged.bind(this));

    this._useDuration = null;
    this._useDurationChanged();
    this._controlButtonStyleChanged();
    this._controlButtonChoicesChanged();
    this._simulationStateChanged();
    this._updateClockVisibility();
  };

  /**
   * Implements optional callback supported by Interactive Controller.
     (*Could* be dispatched to controlButtonMethods, but is that really necessary?)
   */
  PlaybackController.prototype.resize = function () {

    this._fitButtonsOnResize();

    if ( !this._$timeCanvas ) {
      return;
    }

    // Oversample canvas, so text will look good on Retina-like displays.
    this._canvWidth = this._$timeCanvas.width() * 2;
    this._canvHeigth = this._$timeCanvas.height() * 2;
    this._$timeCanvas.attr("width", this._canvWidth);
    this._$timeCanvas.attr("height", this._canvHeigth);

    this._timeCtx.font = this._fontSpec;
    this._timeCtx.fillStyle = "#939598";
    this._timeCtx.textAlign = "right";

    this._updateClockVisibility();
  };

  return PlaybackController;
});

/*global define */

define('common/controllers/div-controller',['require','common/inherit','common/controllers/interactive-component','common/alert'],function (require) {

  var inherit              = require('common/inherit'),
      InteractiveComponent = require('common/controllers/interactive-component'),
      alert                = require('common/alert');

  /**
   * Simplest component controller which just inherits from InteractiveComponent, simply
   * creating a div element. Component can have dimensions, css classes and on onClick
   * function.
   * @param {Object} component Component JSON definition.
   * @param {ScriptingAPI} scriptingAPI
   * @param {InteractiveController} controller
   */
  function DivController(component, scriptingAPI, controller) {
    // Call super constructor.
    InteractiveComponent.call(this, "div", component, scriptingAPI, controller);
    var content = component.content;
    var divController = this;
    if (component.url) {
      // make sure the user sets the width and height because otherwise the layout
      // will be broken
      if( component.width === "auto" || component.height === "auto") {
        alert("This interactive has a remote div component.\n"+
              "The width and/or height is not set.\n"+
              "Please set both the width and height.");
      }


      $.ajax(component.url, {
        dataType: "html",
        complete: function (data){
          divController.$element.append(data.responseText);
        }
      });
    } else {
      if (content && content.join) {
        content = content.join("\n");
      }
      this.$element.append(content);
    }
  }
  inherit(DivController, InteractiveComponent);

  return DivController;
});

/*global define, $ */
define('common/controllers/help-system',['require','common/markdown-to-html','common/dispatch-support'],function (require) {

  var markdownToHTML  = require("common/markdown-to-html"),
      DispatchSupport = require("common/dispatch-support"),

      OVERLAY_MY = [
        "center bottom",
        "left center",
        "center top",
        "right center"
      ],

      OVERLAY_AT = [
        "center top-5",
        "right+5 center",
        "center bottom+5",
        "left-5 center"
      ],

      IS_BOUNDING_BOX = "lab-is-bounding-box";

  return function HelpSystem(helpTips, $container) {
    var api,
        dispatch = new DispatchSupport("start", "stop"),
        isActive = false,
        tipIdx = -1,
        $tip,
        $instructions,
        overlays = [];

    function showTip() {
      var def = helpTips[tipIdx],
          $component,
          overlayHeight,
          offset;

      if (!def) return;
      // Make sure that focus is active so keyboard handlers work fine.
      $tip.focus();
      // Update content.
      $tip.html(markdownToHTML(def.text));
      // Position.
      if (def.component) {
        $component = getComponent(def.component);
        overlayHeight = $component.outerHeight() + 10; // + 5+ 5 => take a loot at OVERLAY_AT values.
        offset = parseFloat($tip.css("font-size"));
        $tip.position({
          of: $component,
          collision: "flipfit flipfit",
          within: $container,
          // Arrow's height depends on font-size (as it's defined in ems).
          my: "left-" + (offset * 4) + " top+" + offset,
          at: "right bottom",
          using: function(position, feedback) {
            var eLeft  = feedback.element.left,
                eWidth = feedback.element.width,
                tLeft  = feedback.target.left,
                tWidth = feedback.target.width,
                $arrow, leftOffset;
            $(this).css(position);
            $arrow = $("<div>")
              .addClass("lab-help-arrow")
              .addClass(feedback.vertical)
              .appendTo(this);
            if (tLeft > eLeft) {
              leftOffset = tLeft - eLeft + tWidth / 2;
              leftOffset = Math.max(eWidth * 0.1, Math.min(eWidth * 0.9, leftOffset));
              $arrow.css("left", leftOffset);
            }
          }
        });
        overlays.forEach(function ($overlay, idx) {
          // Set custom height of left and right overlays.
          if (idx === 1 || idx === 3) $overlay.css("height", overlayHeight);
          $overlay.position({
            of: $component,
            collision: "none none",
            my: OVERLAY_MY[idx],
            at: OVERLAY_AT[idx]
          });
        });
        if ($component.data(IS_BOUNDING_BOX)) {
          // Cleanup.
          $component.remove();
        }
      } else {
        $tip.position({
          of: $container,
          collision: "flipfit flipfit",
          within: $container,
          my: "center center",
          at: "center center"
        });
        overlays.forEach(function ($overlay, idx) {
          $overlay.position({
            of: $container,
            collision: "none none",
            // Position all overlays outside the container except from one (avoid alpha channel
            // summing).
            my: idx ? "left top" : "center center",
            at: idx ? "right bottom" : "center center"
          });
        });
      }
    }

    function getComponent(compDef) {
      var $component;
      if (compDef === "model") {
        $component = $("#model-container");
      } else if (typeof compDef === "string") {
        $component = $("#" + compDef).closest(".component");
      } else { // array
        $component = $(compDef.map(function (id) { return "#" + id; }).join(", ")).closest(".component");
        $component = getBoundingBox($component);
      }
      return $component;
    }

    function getBoundingBox($elements) {
      var left = [],
          right = [],
          top = [],
          bottom = [],
          minLeft, maxRight, minTop, maxBottom, $bb;

      $elements.each(function () {
        $el = $(this);
        pos = $el.offset();
        contPos = $container.offset();
        left.push(pos.left - contPos.left);
        right.push(pos.left - contPos.left + $el.width());
        top.push(pos.top - contPos.top);
        bottom.push(pos.top - contPos.top + $el.height());
      });

      minLeft = Math.min.apply(null, left);
      maxRight = Math.max.apply(null, right);
      minTop = Math.min.apply(null, top);
      maxBottom = Math.max.apply(null, bottom);

      $bb = $('<div>')
        .data(IS_BOUNDING_BOX, true) // very important, this element needs to be removed later
        .css({
          position: 'absolute',
          left: minLeft,
          top: minTop,
          width: maxRight - minLeft,
          height: maxBottom - minTop
        })
        .appendTo($container);

      return $bb;
    }

    api = {
      start: function (startIdx, single) {
        if (isActive) {
          api.stop();
          return;
        }
        for (var i = 0; i < 4; i++) {
          overlays.push($('<div class="lab-help-overlay lab-help-next"></div>').appendTo($container));
        }
        $tip = $('<div class="lab-help-tip lab-help-next" tabindex="-1"></div>').appendTo($container);
        if (single) {
          $instructions = $('<div class="lab-help-instructions">' +
                            '<span class="lab-help-next">Click overlay to hide help tip</span>' +
                            '</div>').appendTo($container);
          $container.on("click.lab-help-next", ".lab-help-next", api.stop);
        } else {
          $instructions = $('<div class="lab-help-instructions">' +
                            '<span class="lab-help-prev btn"><</span>' +
                            '<span class="lab-help-next">Click overlay to see next help tip</span>' +
                            '<span class="lab-help-next btn">></span>' +
                            '</div>').appendTo($container);
          $container.on("click.lab-help-next", ".lab-help-next", api.next);
          $container.on("click.lab-help-prev", ".lab-help-prev", api.prev);
          $tip.on('keydown.lab-help', function(event) {
            switch(event.keycode || event.which) {
              case 37: // left-arrow
                api.prev();
                break;
              case 39: // right-arrow
                api.next();
                break;
            }
            event.preventDefault();
            event.stopPropagation();
          });
        }
        isActive = true;
        tipIdx = startIdx != null ? startIdx : 0;
        if (single) {
          showTip();
        } else {
          // .next() implements logic related to showcase mode.
          tipIdx--;
          api.next();
        }
        dispatch.start();
      },

      showSingle: function (componentName) {
        for(var i = 0; i < helpTips.length; i++) {
          var comp = helpTips[i].component;
          // Note that comp can be a string or array.
          if (typeof comp === "string" && comp === componentName || comp.indexOf(componentName) !== -1) {
            api.start(i, true);
            return;
          }
        }
      },

      stop: function () {
        $tip.remove();
        $instructions.remove();
        overlays.forEach(function ($overlay) {
          $overlay.remove();
        });
        overlays.length = 0;
        $container.off("click.lab-help-next", ".lab-help-next");
        $container.off("click.lab-help-prev", ".lab-help-prev");
        isActive = false;
        dispatch.stop();
      },

      next: function () {
        tipIdx++;
        // Skip help tips that have showcase property set to false.
        while(tipIdx < helpTips.length && !helpTips[tipIdx].showcase) {
          tipIdx++;
        }
        if (tipIdx >= helpTips.length) {
          api.stop();
          return;
        }
        showTip();
      },

      prev: function () {
        tipIdx--;
        // Skip help tips that have showcase property set to false.
        while(!tipIdx >= 0 && helpTips[tipIdx].showcase) {
          tipIdx--;
        }
        if (tipIdx < 0) {
          api.stop();
          return;
        }
        showTip();
      },

      isActive: function () {
        return isActive;
      },

      hasShowcase: function () {
        return helpTips.filter(function(h) { return h.showcase }).length > 0;
      },

      enableLogging: function(logFunc) {
        var startTime = null;
        dispatch.on('.logging', null);
        dispatch.on('start.logging', function () {
          logFunc('HelpTipsOpened');
          startTime = Date.now();
        });
        dispatch.on('stop.logging', function () {
          logFunc('HelpTipsClosed', {wasOpenFor: (Date.now() - startTime) / 1000});
        });
      }
    };

    dispatch.mixInto(api);

    return api;
  };
});

/*global define: false, $: false */

/**
 * Lab-compatible tooltips based on jQuery-UI tooltips. The custom styling is used and tooltips
 * scale themselves according to the font-size of parent div.
 *
 * There is also a special algorithm for delaying tooltips. When you hover over element with
 * tooltip, it will be shown after 2 seconds. Then if you move mouse pointer fast to another
 * tooltip-able element, tooltip will be shown much faster. This helps user read all tooltips
 * quickly in case of need.
 *
 * Implementation details:
 *
 * There are a few icky solutions. First of all we have to manually set font-size of tooltip
 * container, based on #responsive content font-size, as we can't append tooltip to this div.
 * What's more, there is no way to set font-size before positioning, so we have to position
 * tooltip again after updating font-size (so its size too).
 *
 * Also algorithm for dynamical tooltips delay requires a lot of customization. jQuery-UI
 * implementation doesn't support behavior we expect. We hide tooltip manually in 'open' callback
 * and set interval which shows it again after calculated amount of milliseconds. Weird, but works
 * quite fine.
 */
define('common/views/tooltip',['require','common/benchmark/benchmark'],function (require) {

  var benchmark = require("common/benchmark/benchmark"),
      lastClose = 0,

      customTooltipsEnabled = (function () {
        // Disable custom tooltips on mobile devices, as e.g. on iPad they cause that
        // user have to tap each component twice as first tap only opens a tooltip.
        if (benchmark.isMobile) return false;
        // Disable tooltips in all Safari version older than 7. They are causing weird issues there.
        // See the related PT story and more precise problem description:
        // https://www.pivotaltracker.com/s/projects/442903/stories/59910282
        var browser = benchmark.browser.browser;
        // parseInt() will convert e.g. "7.0/537.71" just to 7.
        var version = parseInt(benchmark.browser.version, 10);
        if (browser === "Safari" && version < 7) return false;
        // Tooltips are enabled by default.
        return true;
      }());

  function tooltip($parent) {
    if (!customTooltipsEnabled) return;

    var $tooltip = null,
        fadeInID = null,
        fadeOutID = null,
        wasShown = false;

    function position(target) {
      // Update font-size using $parent div font-size.
      // Lab Interactives scaling is based on the font-size of this div.
      var fontSize = $parent.css("font-size"),
          vertOffset = + parseFloat(fontSize) * 0.35,
          // workaround jQueryUI tooltip issue; it removes title attribute on focus event
          $posTarget = $(target).closest("[title], [aria-describedby]");
      $tooltip.css("font-size", fontSize);
      // Font-size of the top container changes also dimensions of various elements
      // that are defined in ems, so calculate correct position for tooltip.
      if (!$tooltip.is(":visible")) {
        // Show invisible tooltip, as positioning can't work with hidden elements.
        $tooltip.show();
      }
      $tooltip.position({
        of: $posTarget,
        collision: "flipfit flipfit",
        within: $parent,
        // Arrow's height depends on font-size (as it's defined in ems).
        my: "center top+" + vertOffset,
        at: "center bottom",
        using: function(position, feedback) {
          $(this).css(position);
          // Add arrow for nicer look & feel.
          $("<div>")
            .addClass("ui-tooltip-arrow")
            .addClass(feedback.vertical)
            .addClass(feedback.horizontal)
            .appendTo(this);
        }
      });
    }

    function clearTooltipState() {
      if ($tooltip) {
        $tooltip.hide();
      }
      clearInterval(fadeInID);
      clearInterval(fadeOutID);
      wasShown = false;
      $tooltip = null;
    }

    $parent.tooltip({
      show: false,
      hide: false,
      open: function (event, ui) {
        var delayVal = 3 * Math.min(500, Date.now() - lastClose);

        // Ensure that only one tooltip is visible and tracked by $tooltip and the fadein/fadeout
        // timeres at one time. (A focus event can cause a tooltip to be opened on the previously
        // hovered element just before a tooltip is opened on the currently hovered element, without
        // a close event in between.)
        if ($tooltip !== null) {
          clearTooltipState();
        }

        $tooltip = ui.tooltip;
        position(event.originalEvent.target);
        // Custom delayed animation. Delay value is based on the last user actions.
        $tooltip.hide();
        fadeInID = setTimeout(function () {
          $tooltip.fadeIn();
          wasShown = true;
        }, delayVal);
        fadeOutID = setTimeout(function () {
          $tooltip.fadeOut();
        }, delayVal + 5000);
      },
      close: function (event, ui) {
        if (!$tooltip || ui.tooltip[0] !== $tooltip[0]) {
          return;
        }

        if (wasShown) {
          lastClose = Date.now();
        }
        clearTooltipState();
      }
    });
  }

  return tooltip;
});

/*global define, unescape, escape */

/**
 * Cookies helper adapted from MDN pages. Original docs:
 * https://developer.mozilla.org/en-US/docs/DOM/document.cookie
 */
define('common/cookies',[],function () {

  return {
    getItem: function (sKey) {
      return unescape(document.cookie.replace(new RegExp("(?:(?:^|.*;)\\s*" + escape(sKey).replace(/[\-\.\+\*]/g, "\\$&") + "\\s*\\=\\s*([^;]*).*$)|^.*$"), "$1")) || null;
    },
    setItem: function (sKey, sValue, vEnd, sPath, sDomain, bSecure) {
      if (!sKey || /^(?:expires|max\-age|path|domain|secure)$/i.test(sKey)) { return false; }
      var sExpires = "";
      if (vEnd) {
        switch (vEnd.constructor) {
          case Number:
            sExpires = vEnd === Infinity ? "; expires=Fri, 31 Dec 9999 23:59:59 GMT" : "; max-age=" + vEnd;
            break;
          case String:
            sExpires = "; expires=" + vEnd;
            break;
          case Date:
            sExpires = "; expires=" + vEnd.toGMTString();
            break;
        }
      }
      document.cookie = escape(sKey) + "=" + escape(sValue) + sExpires + (sDomain ? "; domain=" + sDomain : "") + (sPath ? "; path=" + sPath : "") + (bSecure ? "; secure" : "");
      return true;
    },
    removeItem: function (sKey, sPath) {
      if (!sKey || !this.hasItem(sKey)) { return false; }
      document.cookie = escape(sKey) + "=; expires=Thu, 01 Jan 1970 00:00:00 GMT" + (sPath ? "; path=" + sPath : "");
      return true;
    },
    hasItem: function (sKey) {
      return (new RegExp("(?:^|;\\s*)" + escape(sKey).replace(/[\-\.\+\*]/g, "\\$&") + "\\s*\\=")).test(document.cookie);
    },
    keys: /* optional method: you can safely remove it! */ function () {
      var aKeys = document.cookie.replace(/((?:^|\s*;)[^\=]+)(?=;|$)|^\s*|\s*(?:\=[^;]*)?(?:\1|$)/g, "").split(/\s*(?:\=[^;]*)?;\s*/);
      for (var nIdx = 0; nIdx < aKeys.length; nIdx++) { aKeys[nIdx] = unescape(aKeys[nIdx]); }
      return aKeys;
    }
  };
});

/*!
* screenfull
* v3.0.2 - 2017-03-13
* (c) Sindre Sorhus; MIT License
*/
(function () {
	'use strict';

	var isCommonjs = typeof module !== 'undefined' && module.exports;
	var keyboardAllowed = typeof Element !== 'undefined' && 'ALLOW_KEYBOARD_INPUT' in Element;

	var fn = (function () {
		var val;

		var fnMap = [
			[
				'requestFullscreen',
				'exitFullscreen',
				'fullscreenElement',
				'fullscreenEnabled',
				'fullscreenchange',
				'fullscreenerror'
			],
			// new WebKit
			[
				'webkitRequestFullscreen',
				'webkitExitFullscreen',
				'webkitFullscreenElement',
				'webkitFullscreenEnabled',
				'webkitfullscreenchange',
				'webkitfullscreenerror'

			],
			// old WebKit (Safari 5.1)
			[
				'webkitRequestFullScreen',
				'webkitCancelFullScreen',
				'webkitCurrentFullScreenElement',
				'webkitCancelFullScreen',
				'webkitfullscreenchange',
				'webkitfullscreenerror'

			],
			[
				'mozRequestFullScreen',
				'mozCancelFullScreen',
				'mozFullScreenElement',
				'mozFullScreenEnabled',
				'mozfullscreenchange',
				'mozfullscreenerror'
			],
			[
				'msRequestFullscreen',
				'msExitFullscreen',
				'msFullscreenElement',
				'msFullscreenEnabled',
				'MSFullscreenChange',
				'MSFullscreenError'
			]
		];

		var i = 0;
		var l = fnMap.length;
		var ret = {};

		for (; i < l; i++) {
			val = fnMap[i];
			if (val && val[1] in document) {
				for (i = 0; i < val.length; i++) {
					ret[fnMap[0][i]] = val[i];
				}
				return ret;
			}
		}

		return false;
	})();

	var screenfull = {
		request: function (elem) {
			var request = fn.requestFullscreen;

			elem = elem || document.documentElement;

			// Work around Safari 5.1 bug: reports support for
			// keyboard in fullscreen even though it doesn't.
			// Browser sniffing, since the alternative with
			// setTimeout is even worse.
			if (/5\.1[.\d]* Safari/.test(navigator.userAgent)) {
				elem[request]();
			} else {
				elem[request](keyboardAllowed && Element.ALLOW_KEYBOARD_INPUT);
			}
		},
		exit: function () {
			document[fn.exitFullscreen]();
		},
		toggle: function (elem) {
			if (this.isFullscreen) {
				this.exit();
			} else {
				this.request(elem);
			}
		},
		onchange: function (callback) {
			document.addEventListener(fn.fullscreenchange, callback, false);
		},
		onerror: function (callback) {
			document.addEventListener(fn.fullscreenerror, callback, false);
		},
		raw: fn
	};

	if (!fn) {
		if (isCommonjs) {
			module.exports = false;
		} else {
			window.screenfull = false;
		}

		return;
	}

	Object.defineProperties(screenfull, {
		isFullscreen: {
			get: function () {
				return Boolean(document[fn.fullscreenElement]);
			}
		},
		element: {
			enumerable: true,
			get: function () {
				return document[fn.fullscreenElement];
			}
		},
		enabled: {
			enumerable: true,
			get: function () {
				// Coerce to boolean in case of old WebKit
				return Boolean(document[fn.fullscreenEnabled]);
			}
		}
	});

	if (isCommonjs) {
		module.exports = screenfull;
	} else {
		window.screenfull = screenfull;
	}
})();

define("screenfull", (function (global) {
    return function () {
        var ret, fn;
        return ret || global.screenfull;
    };
}(this)));

/*global define, $ */

define('common/controllers/setup-banner',['lab.config','common/controllers/text-controller','common/controllers/image-controller','common/controllers/div-controller','common/controllers/playback-controller','screenfull'],function () {

  var labConfig          = require('lab.config'),
      TextController     = require('common/controllers/text-controller'),
      ImageController    = require('common/controllers/image-controller'),
      DivController      = require('common/controllers/div-controller'),
      PlaybackController = require('common/controllers/playback-controller'),
      screenfull         = require('screenfull'),

      topBarHeight    = 1.5,
      topBarFontScale = topBarHeight * 0.65,
      topBarVerticalPadding = topBarHeight / 10;

  /**
   * Returns a hash containing:
   *  - components,
   *  - containers,
   *  - layout definition (components location).
   * All these things are used to build the interactive banner.
   *
   * @param {InteractivesController} controller
   * @param {Object} interactive Interactive JSON definition.
   * @param {CreditsDialog} creditsDialog
   * @param {AboutDialog} aboutDialog
   * @param {ShareDialog} shareDialog
   */
  return function setupBanner(controller, interactive, creditsDialog, aboutDialog, shareDialog) {
    var components = {},
        template = [],
        layout = {},
        i18n = controller.i18n,
        body, requestFullscreenMethod;

    function createElementInContainer(element, container) {
      var Controller;

      if (element.type === "text") {
        Controller = TextController;
      } else if (element.type === "image") {
        Controller = ImageController;
      } else if (element.type === "div") {
        Controller = DivController;
      } else if (element.type === "playback") {
        Controller = PlaybackController;
      }

      components[element.id] = new Controller(element, controller);
      template.push(container);
      layout[container.id] = [element.id];
    }

    // Checks if there is a "playback" component in interactive JSON component section.
    function isPlaybackDefinedByAuthor() {
      for (var i = 0; i < interactive.components.length; i++) {
        if (interactive.components[i].type === "playback") return true;
      }
      return false;
    }

    function setupTopBar() {
      template.push({
        "id": "top-bar",
        "top": "0",
        "left": "0",
        "height": topBarHeight + "em",
        "padding-top": topBarVerticalPadding + "em",
        "padding-bottom": topBarVerticalPadding + "em",
        "width": "container.width",
        "aboveOthers": true
      });

      if (interactive.i18nMetadata) {
        createElementInContainer({
          "type": "div",
          "id": "lang-icon",
          "width": "1.8em",
          "height": "1.35em",
          "tooltip": i18n.t("banner.lang_tooltip")
        },
        {
          "id": "banner-lang",
          "top": "0",
          "height": topBarHeight + "em",
          "right": "container.right",
          "padding-top": topBarVerticalPadding + "em",
          "padding-bottom": topBarVerticalPadding + "em",
          "padding-left": "0.75em",
          "padding-right": "0.25em",
          "aboveOthers": true
        });
      }

      createElementInContainer({
        "type": "text",
        "id": "about-link",
        "text": i18n.t("banner.about"),
        "onClick": function () {
          aboutDialog.open();
        },
        "tooltip": i18n.t("banner.about_tooltip")
      },
      {
        "id": "banner-right",
        "fontScale": topBarFontScale,
        "top": "0",
        "height": topBarHeight + "em",
        "padding-top": topBarVerticalPadding + "em",
        "padding-bottom": topBarVerticalPadding + "em",
        "right": interactive.i18nMetadata ? "banner-lang.left" : "interactive.right",
        "padding-left": "1em",
        "padding-right": "0.75em",
        "align": "right",
        "aboveOthers": true
      });

      // Define sharing link only if sharing is enabled.
      // Note that due to layout limitations, banner-middle container
      // has to be defined *after* banner-right container which is used
      // in its specification!
      if (labConfig.sharing) {
        createElementInContainer({
          "type": "text",
          "id": "share-link",
          "text": controller.i18n.t("banner.share"),
          "onClick": function () {
            shareDialog.open();
          },
          "tooltip": i18n.t("banner.share_tooltip")
        },
        {
          "id": "banner-middle",
          "fontScale": topBarFontScale,
          "top": "0",
          "height": topBarHeight + "em",
          "padding-top": topBarVerticalPadding + "em",
          "padding-bottom": topBarVerticalPadding + "em",
          "right": "banner-right.left",
          "padding-right": "1em",
          "align": "right",
          "aboveOthers": true
        });
      }

      createElementInContainer({
        "type": "div",
        "id": "interactive-reload-icon",
        "content": '<i class="icon-repeat"></i>',
        "onClick": function () {
          controller.reloadInteractive();
        },
        "tooltip": i18n.t("banner.reload_tooltip")
      },
      {
        "id": "banner-reload",
        "fontScale": topBarFontScale,
        "top": "0",
        "height": topBarHeight + "em",
        "padding-top": topBarVerticalPadding + "em",
        "padding-bottom": topBarVerticalPadding + "em",
        "left": "0.7em",
        "padding-right": "1em",
        "align": "left",
        "aboveOthers": true
      });

      if (controller.helpSystem && controller.helpSystem.hasShowcase()) {
        createElementInContainer({
          "type": "div",
          "id": "main-help-icon",
          "content": '<i class="icon-question-sign lab-help-icon"></i>',
          "onClick": function () {
            if (!controller.helpSystem.isActive()) {
              controller.helpSystem.start();
            } else {
              controller.helpSystem.stop();
            }
          },
          "tooltip": i18n.t("banner.help_tooltip")
        },
        {
          "id": "banner-help",
          "fontScale": topBarFontScale,
          "top": "0",
          "height": topBarHeight + "em",
          "padding-top": topBarVerticalPadding + "em",
          "padding-bottom": topBarVerticalPadding + "em",
          // "banner-right" can be undefined, so check it.
          "left": "banner-reload.right",
          "padding-right": "1em",
          "align": "left",
          "aboveOthers": true
        });

        // Note that help system has to be initialized before we setup banner!
        controller.helpSystem.on("start.icon", function () {
          var $icon = $("#main-help-icon .lab-help-icon");
          $icon.addClass("icon-remove-sign active");
          $icon.removeClass("icon-question-sign");
        });
        controller.helpSystem.on("stop.icon", function () {
          var $icon = $("#main-help-icon .lab-help-icon");
          $icon.addClass("icon-question-sign");
          $icon.removeClass("icon-remove-sign active");
        });
      }
    }

    function setupBottomBar() {
      template.push({
        "id": "bottom-bar",
        "bottom": "container.height",
        "left": "0",
        "width": "container.width",
        "height": "2.5em",
        "belowOthers": true
      });

      createElementInContainer({
        "type": "div",
        "id": "credits-link",
        "height": "2.5em",
        "width": "8.1em",
        "classes": ["credits"],
        "tooltip": i18n.t("banner.credits_tooltip"),
        "onClick": function () {
          creditsDialog.open();
        }
      },
      {
        "id": "banner-bottom-left",
        "bottom": "container.height",
        "left": "0",
        "padding-left": "0.3em",
        "align": "left",
        "belowOthers": true
      });

      if (screenfull.enabled) {
        // Note: This requires iframe to be embedded with 'allowfullscreen=true'.
        createElementInContainer({
          "type": "div",
          "id": "fullsize-link",
          "height": "2.5em",
          "width": "2.5em",
          "classes": ["fullscreen"],
          "tooltip": i18n.t("banner.fullscreen_tooltip"),
          "onClick": function () {
            if (!screenfull.isFullscreen) {
              screenfull.request(document.body);
              controller.logAction('FullScreenStarted');
            } else {
              screenfull.exit();
            }
          }
        },
        {
          "id": "banner-bottom-right",
          "bottom": "container.height",
          "right": "container.width",
          "align": "left",
          "padding-left": "1em",
          "belowOthers": true
        });
      }

      if (!isPlaybackDefinedByAuthor()) {
        // Define playback component automatically only if it hasn't been done by interactive author.
        createElementInContainer({
          "type": "playback",
          "id": "playback"
        },
        {
          "id": "interactive-playback-container",
          "bottom": "container.height",
          "height": "banner-bottom-left.height",
          "left": "banner-bottom-left.right",
          // note that banner-bottom-right may not be defined
          "right": template.map(function (o) { return o.id; }).indexOf('banner-bottom-right') >= 0 ?
            "banner-bottom-right.left" : "container.right",
          "belowOthers": true
        });
      }
    }

    if (interactive.showTopBar) {
      setupTopBar();
    }

    if (interactive.showBottomBar) {
      setupBottomBar();
    }

    return {
      components: components,
      template: template,
      layout: layout
    };
  };
});

/*global define, $ */
define('common/controllers/about-dialog',['require','common/markdown-to-html','common/inherit','common/controllers/basic-dialog'],function (require) {

  var markdownToHTML = require('common/markdown-to-html'),
      inherit        = require('common/inherit'),
      BasicDialog    = require('common/controllers/basic-dialog');

  /**
   * About Dialog. Inherits from Basic Dialog.
   *
   * @co