/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.vernier;

import org.concord.sensor.SensorRequest;
import org.concord.sensor.device.DeviceService;
import org.concord.sensor.device.impl.SensorConfigImpl;
import org.concord.sensor.impl.LinearCalibration;
import org.concord.sensor.impl.Range;
import org.concord.sensor.impl.SensorCalibration;
import org.concord.sensor.vernier.VernierSensorDevice;

public class VernierSensor
extends SensorConfigImpl {
    public static final int CHANNEL_TYPE_ANALOG = 0;
    public static final int CHANNEL_TYPE_DIGITAL = 1;
    public static final byte kProbeTypeNoProbe = 0;
    public static final byte kProbeTypeTime = 1;
    public static final byte kProbeTypeAnalog5V = 2;
    public static final byte kProbeTypeAnalog10V = 3;
    public static final byte kProbeTypeHeatPulser = 4;
    public static final byte kProbeTypeAnalogOut = 5;
    public static final byte kProbeTypeMD = 6;
    public static final byte kProbeTypePhotoGate = 7;
    public static final byte kProbeTypeDigitalCount = 10;
    public static final byte kProbeTypeRotary = 11;
    public static final byte kProbeTypeDigitalOut = 12;
    public static final byte kProbeTypeLabquestAudio = 13;
    private final VernierSensorDevice device;
    SensorCalibration calibrationEquation;
    private int channelType;
    byte vernierProbeType = (byte)2;
    private SensorCalibration postCalibrationEquation;
    public static final SensorCalibration rawVoltageCalibration = new LinearCalibration(0.0f, 1.0f);
    public static final SensorCalibration rawDataCalibration = new LinearCalibration(0.12345f, 0.0f);
    public static final SensorCalibration temperatureCalibration = new SensorCalibration(){
        public static final float TEMP_K0 = 0.00102119f;
        public static final float TEMP_K1 = 2.22468E-4f;
        public static final float TEMP_K2 = 1.33342E-7f;

        public float calibrate(float voltage) {
            float R = voltage * 15.0f / (5.0f - voltage);
            float lnR = (float)Math.log(1000.0f * R);
            return 1.0f / (0.00102119f + 2.22468E-4f * lnR + 1.33342E-7f * lnR * lnR * lnR) - 273.15f;
        }
    };
    public static final SensorCalibration lightCalibration = new SensorCalibration(){
        public static final float ILLUM_B1 = 4.5E-4f;

        public float calibrate(float voltage) {
            return voltage / 4.5E-4f;
        }
    };
    public static final SensorCalibration relativeHumidityCalibration = new LinearCalibration(-23.8f, 32.9f);
    public static final SensorCalibration studentForceCalibration = new LinearCalibration(9.8f, -9.8f);
    public static final SensorCalibration tiVoltageCalibration = rawVoltageCalibration;
    public static final SensorCalibration differentialVoltageCalibration = new LinearCalibration(6.25f, -2.5f);
    public static final SensorCalibration co2GasCalibration = new LinearCalibration(0.0f, 2000.0f);
    public static final SensorCalibration oxygenGasCalibration = new LinearCalibration(0.0f, 6.769f);

    public VernierSensor(VernierSensorDevice device, DeviceService devService, int channelNumber, int channelType) {
        this.device = device;
        this.setPort(channelNumber);
        this.channelType = channelType;
    }

    public void setCalibration(SensorCalibration calibration) {
        this.calibrationEquation = calibration;
    }

    public SensorCalibration getCalibration() {
        return this.calibrationEquation;
    }

    public void setPostCalibration(SensorCalibration calibration) {
        this.postCalibrationEquation = calibration;
    }

    public SensorCalibration getPostCalibration() {
        return this.postCalibrationEquation;
    }

    public float doPostCalibration(float input) {
        SensorCalibration postCalibration = this.getPostCalibration();
        if (postCalibration != null) {
            return postCalibration.calibrate(input);
        }
        return input;
    }

    public int setupSensor(int sensorId, SensorRequest request) {
        if (this.channelType == 1) {
            if (sensorId == 2 || sensorId == 69) {
                this.setConfirmed(true);
                this.setUnit("m");
                this.setType(13);
                this.vernierProbeType = (byte)6;
                this.setStepSize(0.01f);
            }
        } else if (sensorId >= 20) {
            this.setConfirmed(true);
            Range valueRange = null;
            block0 : switch (sensorId) {
                case 46: {
                    this.setUnit("kPa");
                    this.setType(3);
                    this.setName("Barometer");
                    this.setStepSize(0.01f);
                    valueRange = new Range(81.0f, 106.0f);
                    this.setValueRange(valueRange);
                    break;
                }
                case 24: {
                    this.setUnit("kPa");
                    this.setType(3);
                    this.setName("Biology Gas Pressure");
                    this.setStepSize(0.05f);
                    break;
                }
                case 25: {
                    this.setUnit("N");
                    this.setType(5);
                    this.setName("Dual Range Force 10 N");
                    this.setStepSize(0.01f);
                    valueRange = new Range(-10.0f, 10.0f);
                    this.setValueRange(valueRange);
                    break;
                }
                case 26: {
                    this.setUnit("N");
                    this.setType(5);
                    this.setName("Dual Range Force 50 N");
                    this.setStepSize(0.05f);
                    valueRange = new Range(-50.0f, 50.0f);
                    this.setValueRange(valueRange);
                    break;
                }
                case 34: 
                case 35: 
                case 36: {
                    this.setUnit("lux");
                    this.setType(2);
                    this.setName("Illuminance");
                    this.setStepSize(0.01f);
                    break;
                }
                case 44: 
                case 45: {
                    this.setUnit("mT");
                    this.setType(26);
                    this.setName("Magnetic Field");
                    this.setStepSize(0.0032f);
                    break;
                }
                case 60: {
                    this.setUnit("degC");
                    this.setType(1);
                    this.setName("Temperature");
                    this.setStepSize(0.01f);
                    break;
                }
                case 69: {
                    this.setUnit("m");
                    this.setType(13);
                    this.setName("Position");
                    this.setStepSize(0.01f);
                    break;
                }
                case 47: {
                    this.setUnit("%RH");
                    this.setType(7);
                    this.setName("Relative Humidity");
                    this.setStepSize(0.1f);
                    break;
                }
                case 73: {
                    this.setUnit("degC");
                    this.setType(1);
                    this.setName("IR Temperature Sensor");
                    this.setStepSize(0.01f);
                    break;
                }
                case 20: {
                    this.setUnit("pH");
                    this.setType(20);
                    this.setName("pH");
                    this.setStepSize(0.0077f);
                    break;
                }
                case 52: {
                    this.setUnit("mW/m^2");
                    this.setType(35);
                    this.setName("UVA Intensity");
                    this.setStepSize(5.0f);
                    this.setValueRange(new Range(0.0f, 20000.0f));
                    break;
                }
                case 53: {
                    this.setUnit("mW/m^2");
                    this.setType(36);
                    this.setName("UVB Intensity");
                    this.setStepSize(0.25f);
                    this.setValueRange(new Range(0.0f, 1000.0f));
                    break;
                }
                case 61: {
                    this.setUnit("ppt");
                    this.setType(21);
                    this.setName("Salinity");
                    this.setStepSize(0.02f);
                    break;
                }
                case 75: 
                case 76: {
                    this.setUnit("ppm");
                    this.setType(18);
                    this.setName("CO2");
                    this.setStepSize(4.0f);
                    break;
                }
                case 74: {
                    this.setUnit("dB");
                    this.setType(14);
                    this.setName("Sound Level");
                    this.setStepSize(0.2f);
                    break;
                }
                case 66: {
                    this.setUnit("mm Hg");
                    this.setType(30);
                    this.setName("Cuff Pressure");
                    this.setStepSize(0.11222f);
                    break;
                }
                case 54: {
                    this.setType(33);
                    this.setName("Absorbance");
                    this.setStepSize(0.057f);
                    this.setPostCalibration(new SensorCalibration(){

                        public float calibrate(float input) {
                            return (float)Math.log10(100.0f / input);
                        }
                    });
                    break;
                }
                case 67: {
                    this.setUnit("N");
                    this.setType(34);
                    this.setName("Hand Dynamometer");
                    this.setStepSize(0.35f);
                    break;
                }
                case 90: {
                    this.setUnit("A");
                    this.setType(10);
                    this.setName("High Current Sensor");
                    this.setStepSize(0.005f);
                    this.setValueRange(new Range(-10.0f, 10.0f));
                    break;
                }
                case 37: {
                    this.setUnit("mg/L");
                    this.setType(32);
                    this.setName("Dissolved Oxygen");
                    this.setStepSize(0.00654f);
                    break;
                }
                case 77: {
                    this.setUnit("%");
                    this.setType(19);
                    this.setName("Oxygen Gas");
                    this.setStepSize(0.01f);
                    break;
                }
                case 68: {
                    this.setUnit("L/s");
                    this.setType(27);
                    this.setName("Flow Rate");
                    this.setStepSize(0.01437f);
                    break;
                }
                case 21: 
                case 22: 
                case 23: {
                    this.setUnit("uS/cm");
                    this.setType(31);
                    this.setName("Conductivity");
                    switch (sensorId) {
                        case 21: {
                            this.setStepSize(0.1f);
                            break block0;
                        }
                        case 22: {
                            this.setStepSize(1.0f);
                            break block0;
                        }
                        case 23: {
                            this.setStepSize(10.0f);
                        }
                    }
                    break;
                }
                default: {
                    this.setType(-1);
                    break;
                }
            }
        } else {
            if (sensorId != 0) {
                this.setConfirmed(true);
                this.device.log("  current attached sensor: " + sensorId);
                switch (sensorId) {
                    case 10: {
                        this.setUnit("degC");
                        this.setName("Temperature");
                        this.setType(0);
                        this.setStepSize(0.01f);
                        this.setCalibration(temperatureCalibration);
                        break;
                    }
                    case 1: {
                        this.setUnit("degC");
                        this.setName("Temperature");
                        this.setType(0);
                        this.setStepSize(0.01f);
                        this.setCalibration(temperatureCalibration);
                        break;
                    }
                    case 12: {
                        this.setUnit("lux");
                        this.setName("Illuminance");
                        this.setType(2);
                        this.setStepSize(2.0f);
                        this.setCalibration(lightCalibration);
                        break;
                    }
                    case 2: 
                    case 8: 
                    case 14: {
                        this.setUnit("V");
                        this.setName("Voltage");
                        this.setType(4);
                        this.setStepSize(0.01f);
                        switch (sensorId) {
                            case 2: {
                                this.setCalibration(tiVoltageCalibration);
                                this.vernierProbeType = (byte)3;
                                break;
                            }
                            case 14: {
                                this.setCalibration(rawVoltageCalibration);
                                break;
                            }
                            case 8: {
                                this.setCalibration(differentialVoltageCalibration);
                            }
                        }
                        break;
                    }
                    case 17: {
                        this.setUnit("ppm");
                        this.setName("CO2 Gas");
                        this.setType(18);
                        this.setStepSize(4.0f);
                        this.setCalibration(co2GasCalibration);
                        break;
                    }
                    case 18: {
                        this.setUnit("%");
                        this.setName("Oxygen Gas");
                        this.setType(19);
                        this.setStepSize(0.01f);
                        this.setCalibration(oxygenGasCalibration);
                        break;
                    }
                    case 15: {
                        this.setUnit("mV");
                        this.setName("EKG");
                        this.setType(29);
                        this.setStepSize(0.002f);
                        this.setCalibration(rawVoltageCalibration);
                        break;
                    }
                    case 9: {
                        this.setUnit("A");
                        this.setType(10);
                        this.setStepSize(3.0E-4f);
                        this.setValueRange(new Range(-0.6f, 0.6f));
                        this.setCalibration((SensorCalibration)new LinearCalibration(0.625f, -0.25f));
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 11: {
                        this.device.log("Sensor type is not supported yet: " + sensorId);
                        this.setType(-1);
                        break;
                    }
                    case 13: {
                        this.setUnit("v");
                        this.setName("Heart Rate Signal");
                        this.setType(28);
                        this.setStepSize(0.002f);
                        this.setCalibration(rawVoltageCalibration);
                        break;
                    }
                    default: {
                        this.device.log("Unknown sensor id: " + sensorId);
                        this.setType(-1);
                    }
                }
                return 0;
            }
            this.setConfirmed(false);
            if (request == null) {
                return 0;
            }
            switch (request.getType()) {
                case 7: {
                    this.setUnit("%RH");
                    this.setName("Relative Humidity");
                    this.setType(7);
                    this.setStepSize(0.04f);
                    this.setCalibration(relativeHumidityCalibration);
                    break;
                }
                case 5: {
                    this.setUnit("N");
                    this.setName("Force");
                    this.setType(5);
                    this.setStepSize(0.02f);
                    this.setCalibration(studentForceCalibration);
                }
            }
        }
        return 0;
    }

    public byte getVernierProbeType() {
        return this.vernierProbeType;
    }

    public void setVernierProbeType(byte type) {
        this.vernierProbeType = type;
    }

    public void setType(int type) {
        super.setType(type);
        if (type == 23 || type == 22) {
            this.setVernierProbeType((byte)2);
            this.setCalibration(rawVoltageCalibration);
        } else if (type == 25 || type == 24) {
            this.setVernierProbeType((byte)3);
            this.setCalibration(rawVoltageCalibration);
        }
    }
}

