/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.vernier.goio;

import org.concord.sensor.ExperimentConfig;
import org.concord.sensor.ExperimentRequest;
import org.concord.sensor.SensorConfig;
import org.concord.sensor.device.DeviceReader;
import org.concord.sensor.device.impl.AbstractSensorDevice;
import org.concord.sensor.device.impl.SerialPortParams;
import org.concord.sensor.goio.jna.GoIOLibrary;
import org.concord.sensor.goio.jna.GoIOSensor;
import org.concord.sensor.impl.ExperimentConfigImpl;
import org.concord.sensor.vernier.VernierSensor;
import org.concord.sensor.vernier.VernierSensorDevice;

public class GoIOSensorDevice
extends AbstractSensorDevice
implements VernierSensorDevice {
    GoIOLibrary goio;
    String errorMessage;
    GoIOSensor currentGoDevice;
    int[] rawBuffer = new int[200];

    public GoIOSensorDevice() {
        this.deviceLabel = "GIO";
        this.goio = new GoIOLibrary();
        try {
            this.goio.initLibrary();
        }
        catch (Throwable t) {
            this.errorMessage = "Can't load goio native library";
            this.goio = null;
            t.printStackTrace();
        }
    }

    public void log(String message) {
        super.log(message);
    }

    protected SerialPortParams getSerialPortParams() {
        return null;
    }

    protected boolean initializeOpenPort(String portName) {
        return false;
    }

    public void open(String portParams) {
        if (this.goio == null) {
            return;
        }
        if (this.goio.init() != 0) {
            this.errorMessage = "Can't init go_io, You have another program using the Go device\n";
        }
    }

    protected boolean openPort() {
        return this.goio != null;
    }

    public void close() {
        if (this.goio == null) {
            return;
        }
        if (this.currentGoDevice != null) {
            this.currentGoDevice.close();
            this.currentGoDevice = null;
        }
        this.goio.uninit();
        this.goio = null;
    }

    public boolean canDetectSensors() {
        return true;
    }

    protected boolean hasNonAutoIdSensors() {
        return false;
    }

    public ExperimentConfig configure(ExperimentRequest request) {
        ExperimentConfig experimentConfig = this.autoIdConfigure(request);
        this.currentGoDevice.setMeasurementPeriod((double)experimentConfig.getPeriod());
        ((ExperimentConfigImpl)experimentConfig).setPeriod((float)this.currentGoDevice.getMeasurementPeriod());
        return experimentConfig;
    }

    public ExperimentConfig getCurrentConfig() {
        if (this.currentGoDevice != null) {
            this.currentGoDevice.close();
            this.currentGoDevice = null;
        }
        this.currentGoDevice = this.openGoDevice();
        if (this.currentGoDevice == null) {
            return null;
        }
        ExperimentConfigImpl expConfig = new ExperimentConfigImpl();
        expConfig.setDeviceName(this.currentGoDevice.getDeviceLabel());
        expConfig.setExactPeriod(true);
        expConfig.setPeriod((float)this.currentGoDevice.getMeasurementPeriod());
        expConfig.setDataReadPeriod(expConfig.getPeriod());
        SensorConfig[] sensorConfigs = new SensorConfig[1];
        expConfig.setSensorConfigs(sensorConfigs);
        int channelType = 0;
        if (this.currentGoDevice.isGoMotion()) {
            channelType = 1;
        }
        VernierSensor sensor = new VernierSensor(this, this.devService, 0, channelType);
        sensor.setupSensor(this.currentGoDevice.getAttachedSensorId(), null);
        sensorConfigs[0] = sensor;
        expConfig.setValid(true);
        return expConfig;
    }

    protected GoIOSensor openGoDevice() {
        if (this.goio == null) {
            return null;
        }
        GoIOSensor gSensor = this.goio.getFirstSensor();
        if (gSensor == null) {
            this.errorMessage = "Cannot find an attached Go IO device";
            return null;
        }
        gSensor.open();
        return gSensor;
    }

    public String getErrorMessage(int error) {
        if (this.errorMessage == null) {
            return "Unkown Error";
        }
        return this.errorMessage;
    }

    public String getVendorName() {
        return "Vernier";
    }

    public String getDeviceName() {
        if (this.currentGoDevice != null) {
            return this.currentGoDevice.getDeviceLabel();
        }
        return "GoIO";
    }

    public boolean start() {
        this.currentGoDevice.clearIO();
        SensorConfig[] sensorConfigs = this.currentConfig.getSensorConfigs();
        if (sensorConfigs != null && sensorConfigs.length > 0 && ((VernierSensor)sensorConfigs[0]).getVernierProbeType() == 3) {
            this.currentGoDevice.setAnalogInputChannel(1);
        }
        this.currentGoDevice.startMeasurements();
        return true;
    }

    public void stop(boolean wasRunning) {
        this.currentGoDevice.stopMeasurements();
    }

    public boolean isAttached() {
        if (this.goio == null) {
            return false;
        }
        return this.goio.isGoDeviceAttached();
    }

    protected SensorConfig createSensorConfig(int type, int requestPort) {
        VernierSensor config = new VernierSensor(this, this.devService, 0, 0);
        config.setType(type);
        return config;
    }

    public int read(float[] values, int offset, int nextSampleOffset, DeviceReader reader) {
        int numMeasurements = this.currentGoDevice.readRawMeasurements(this.rawBuffer);
        if (numMeasurements < 0) {
            this.errorMessage = "error reading measurements";
            return -1;
        }
        SensorConfig[] sensors = this.currentConfig.getSensorConfigs();
        VernierSensor sensorConfig = (VernierSensor)sensors[0];
        int type = sensorConfig.getType();
        int sensorIndex = 0;
        for (int i = 0; i < numMeasurements; ++i) {
            float calibratedData = Float.NaN;
            if (type == 22 || type == 24) {
                calibratedData = this.rawBuffer[i];
            } else {
                float voltage = (float)this.currentGoDevice.convertToVoltage(this.rawBuffer[i]);
                calibratedData = sensorConfig.getCalibration() != null ? sensorConfig.getCalibration().calibrate(voltage) : (float)this.currentGoDevice.calibrateData((double)voltage);
                calibratedData = sensorConfig.doPostCalibration(calibratedData);
            }
            values[offset + sensorIndex + i * nextSampleOffset] = calibratedData;
        }
        return numMeasurements;
    }
}

