/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.vernier.labpro;

import org.concord.sensor.serial.SerialException;
import org.concord.sensor.vernier.labpro.LabProSensorDevice;

public class LabProProtocol {
    public static final boolean PRINT_SENDS = true;
    LabProSensorDevice labProDevice;
    private byte[] wakeUpBytes = new byte[]{115, 10};

    public LabProProtocol(LabProSensorDevice device) {
        this.labProDevice = device;
    }

    protected void sendCommand(int command, String params) throws SerialException {
        params = params != null ? "," + params : "";
        String cmdStr = "s{" + command + params + "}\n";
        System.out.print("sending: " + cmdStr);
        byte[] strBytes = cmdStr.getBytes();
        this.labProDevice.getPort().write(strBytes);
    }

    public void requestSystemStatus() throws SerialException {
        this.sendCommand(7, null);
    }

    public void requestChannelStatus(int channel, int reqtype) throws SerialException {
        this.sendCommand(8, "" + channel + ",0");
    }

    public void channelSetup(int channel, int operation) throws SerialException {
        this.sendCommand(1, "" + channel + "," + operation);
    }

    public void channelSetup(int channel, int operation, int postProc, int delta, int equ) throws SerialException {
        this.sendCommand(1, "" + channel + "," + operation + "," + postProc + "," + delta + "," + equ);
    }

    public void dataCollectionSetupPrevious() throws SerialException {
        this.sendCommand(3, "-1");
    }

    public void dataCollectionSetup(float samptime) throws SerialException {
        this.sendCommand(3, "" + samptime);
    }

    public void dataCollectionSetup(float samptime, int numpoints, int trigtype) throws SerialException {
        this.sendCommand(3, "" + samptime + "," + numpoints + "," + trigtype);
    }

    public void portPowerControl(int powerControl) throws SerialException {
        this.sendCommand(102, "" + powerControl);
    }

    public void reset() throws SerialException {
        this.sendCommand(0, null);
    }

    public void wakeUp() throws SerialException {
        System.out.println("s");
        this.labProDevice.getPort().write(this.wakeUpBytes);
        this.labProDevice.getDeviceService().sleep(100);
    }

    public static final class CMD {
        public static final int RESET = 0;
        public static final int CHANNEL_SETUP = 1;
        public static final int DATA_COLLECTION_SETUP = 3;
        public static final int CONVERSION_EQUATION_SETUP = 4;
        public static final int DATA_CONTROL = 5;
        public static final int SYSTEM_SETUP = 6;
        public static final int REQUEST_SYSTEM_STATUS = 7;
        public static final int REQUEST_CHANNEL_STATUS = 8;
        public static final int REQUEST_CHANNEL_DATA = 9;
        public static final int ADVANCED_DATA_REDUCTION = 10;
        public static final int DIGITAL_DATA_CAPTURE = 12;
        public static final int PORT_POWER_CONTROL_COMMAND = 102;
        public static final int BAUD_RATE_SELECTION = 105;
        public static final int MOTION_DETECTOR_UNDERSAMPLE_RATE = 106;
        public static final int OVERSAMPLING_BURST = 107;
        public static final int REQUEST_SETUP_INFORMATION = 115;
        public static final int REQUEST_LONG_SENSOR_NAME = 116;
        public static final int REQUEST_SHORT_SENSOR_NAME = 117;
        public static final int REQUEST_ALTERNATE_CALIBRATION = 119;
        public static final int ARCHIVE_OPERATIONS_COMMAND = 201;
        public static final int ANALOG_OUTPUT_SETUP = 401;
        public static final int SET_LED_COMMAND = 1998;
        public static final int SOUND_COMMAND = 1999;
        public static final int DIRECT_OUTPUT_TO_DIGITALOUT_PORT = 2001;
    }

    public static final class SYS_STATUS {
        public static final int SOFTWARE_ID = 0;
        public static final int ERROR = 1;
        public static final int BATTERY = 2;
        public static final int CONST_8888 = 3;
        public static final int SAMPLE_TIME = 4;
        public static final int TRIGGER_CONDITION = 5;
        public static final int CHANNEL_FUNCTION = 6;
        public static final int CHANNEL_POST = 7;
        public static final int CHANNEL_FILTER = 8;
        public static final int NUM_SAMPLES = 9;
        public static final int RECORD_TIME = 10;
        public static final int TEMPERATURE = 11;
        public static final int PIEZO_FLAG = 12;
        public static final int SYSTEM_STATE = 13;
        public static final int DATASTART = 14;
        public static final int DATAEND = 15;
        public static final int SYSTEM_ID = 16;
    }
}

