/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.vernier.labquest;

import java.io.IOException;
import java.util.ArrayList;
import org.concord.sensor.ExperimentConfig;
import org.concord.sensor.ExperimentRequest;
import org.concord.sensor.SensorConfig;
import org.concord.sensor.device.DeviceReader;
import org.concord.sensor.device.impl.AbstractSensorDevice;
import org.concord.sensor.device.impl.SerialPortParams;
import org.concord.sensor.impl.ExperimentConfigImpl;
import org.concord.sensor.labquest.jna.LabQuest;
import org.concord.sensor.labquest.jna.LabQuestException;
import org.concord.sensor.labquest.jna.LabQuestLibrary;
import org.concord.sensor.vernier.VernierSensor;
import org.concord.sensor.vernier.VernierSensorDevice;

public class LabQuestSensorDevice
extends AbstractSensorDevice
implements VernierSensorDevice {
    private static final double SPEED_OF_SOUND_M_PER_USEC = 3.43E-4;
    private LabQuestLibrary labQuestLibrary;
    private LabQuest labQuest;
    int[] pMeasurementsBuf = new int[1000];
    long[] pTimestampsBuf = new long[1000];
    private float lastMDValue = 0.0f;
    private String errorMessage = null;

    public LabQuestSensorDevice() {
        this.deviceLabel = "LQ";
        try {
            this.labQuestLibrary = LabQuestLibrary.getInstance();
            this.labQuestLibrary.init((Object)this);
        }
        catch (IOException e) {
            this.unableToInitialize(e);
        }
        catch (InterruptedException e) {
            this.unableToInitialize(e);
        }
        catch (LabQuestException e) {
            this.unableToInitialize((Exception)((Object)e));
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (LabQuestSensorDevice.this.labQuest == null) {
                    return;
                }
                System.err.println("Closing LabQuestSensorDevice.");
                LabQuestSensorDevice.this.close();
            }
        });
    }

    private void unableToInitialize(Exception e) {
        this.errorMessage = "Unable to initialize native library";
        this.labQuestLibrary = null;
        e.printStackTrace();
    }

    public void open(String portParams) {
        if (this.labQuestLibrary == null) {
            return;
        }
        try {
            String firstDeviceName = this.labQuestLibrary.getFirstDeviceName();
            if (firstDeviceName == null) {
                return;
            }
            this.labQuest = this.labQuestLibrary.openDevice(firstDeviceName);
            this.labQuest.acquireExclusiveOwnership();
        }
        catch (LabQuestException e) {
            this.closeAfterException(e);
        }
    }

    public void close() {
        if (this.labQuest == null) {
            return;
        }
        try {
            this.labQuest.close();
            System.out.println("LabQuest: Calling uninit");
            this.labQuestLibrary.uninit((Object)this);
            this.labQuestLibrary = null;
            this.labQuest = null;
        }
        catch (LabQuestException e) {
            e.printStackTrace();
            this.labQuest = null;
        }
    }

    protected boolean openPort() {
        return this.labQuest != null;
    }

    public boolean isAttached() {
        block3: {
            if (this.labQuest == null) {
                return false;
            }
            try {
                this.labQuest.getStatus();
            }
            catch (LabQuestException e) {
                if (!e.isCommunicationError()) break block3;
                return false;
            }
        }
        return true;
    }

    public LabQuest getCurrentLabQuest() {
        return this.labQuest;
    }

    public ExperimentConfig getCurrentConfig() {
        ExperimentConfigImpl expConfig = new ExperimentConfigImpl();
        expConfig.setDeviceName("LabQuest");
        ArrayList<VernierSensor> sensorConfigList = new ArrayList<VernierSensor>();
        try {
            for (byte i = 1; i < 7; i = (byte)(i + 1)) {
                String possibleName;
                int sensorId = -1;
                sensorId = this.labQuest.getSensorId(i);
                if (sensorId <= 0) continue;
                int channelType = 0;
                if (i >= 5) {
                    channelType = 1;
                }
                VernierSensor sensorConfig = new VernierSensor(this, this.devService, i, channelType);
                sensorConfig.setupSensor(sensorId, null);
                if (sensorId >= 20 && i <= 4 && (possibleName = this.labQuest.getSensorName(i)).length() > 0) {
                    sensorConfig.setName(possibleName);
                }
                sensorConfigList.add(sensorConfig);
            }
            this.labQuest.printAttachedSensors();
            int numSensors = sensorConfigList.size();
            if (numSensors == 0) {
                expConfig.setSensorConfigs(null);
            } else {
                SensorConfig[] sensorConfigArr = sensorConfigList.toArray(new SensorConfig[sensorConfigList.size()]);
                expConfig.setSensorConfigs(sensorConfigArr);
            }
            expConfig.setExactPeriod(true);
        }
        catch (LabQuestException e) {
            if (expConfig != null) {
                expConfig = null;
            }
            this.closeAfterException(e);
        }
        return expConfig;
    }

    public String getErrorMessage(int error) {
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        return "Unknown LabQuest Error";
    }

    public boolean start() {
        try {
            SensorConfig[] sensors = this.currentConfig.getSensorConfigs();
            float period = this.currentConfig.getPeriod();
            this.labQuest.setMeasurementPeriod((byte)-1, (double)period);
            int mask = 0;
            block6: for (SensorConfig sensorConfig : sensors) {
                int channel = sensorConfig.getPort();
                this.labQuest.clearIO((byte)channel);
                mask |= 1 << channel;
                VernierSensor vSensor = (VernierSensor)sensorConfig;
                switch (vSensor.getVernierProbeType()) {
                    case 6: {
                        this.labQuest.setSamplingMode((byte)channel, (byte)3);
                        continue block6;
                    }
                    case 3: {
                        this.labQuest.setAnalogInput((byte)channel, (byte)4);
                    }
                }
            }
            this.labQuest.setSensorChannelEnableMask(mask);
            this.labQuest.startMeasurements();
            return true;
        }
        catch (LabQuestException e) {
            this.closeAfterException(e);
            return false;
        }
    }

    public int read(float[] values, int offset, int nextSampleOffset, DeviceReader reader) {
        try {
            SensorConfig[] sensors = this.currentConfig.getSensorConfigs();
            int minAvailable = Integer.MAX_VALUE;
            for (int sensorIndex = 0; sensorIndex < sensors.length; ++sensorIndex) {
                VernierSensor sensorConfig = (VernierSensor)sensors[sensorIndex];
                int channel = sensorConfig.getPort();
                int available = this.labQuest.getNumberOfMeasurementsAvailable((byte)channel);
                if (sensorConfig.getVernierProbeType() == 6) {
                    available /= 2;
                }
                if (available >= minAvailable) continue;
                minAvailable = available;
            }
            assert (minAvailable != Integer.MAX_VALUE);
            int numMeasurements = 0;
            for (int sensorIndex = 0; sensorIndex < sensors.length; ++sensorIndex) {
                VernierSensor sensorConfig = (VernierSensor)sensors[sensorIndex];
                int channel = sensorConfig.getPort();
                int type = sensorConfig.getType();
                byte vernierProbeType = sensorConfig.getVernierProbeType();
                if (vernierProbeType == 2 || vernierProbeType == 3) {
                    numMeasurements = this.labQuest.readRawMeasurementsAnalog((byte)channel, this.pMeasurementsBuf, minAvailable);
                    for (int i = 0; i < numMeasurements; ++i) {
                        float calibratedData = Float.NaN;
                        if (type == 22 || type == 24) {
                            calibratedData = this.pMeasurementsBuf[i];
                        } else {
                            if (sensorConfig.getCalibration() != null) {
                                float voltage = this.labQuest.convertToVoltage((byte)channel, this.pMeasurementsBuf[i], (int)vernierProbeType);
                                calibratedData = sensorConfig.getCalibration().calibrate(voltage);
                            } else {
                                calibratedData = this.labQuest.calibrateData2((byte)channel, this.pMeasurementsBuf[i]);
                            }
                            calibratedData = sensorConfig.doPostCalibration(calibratedData);
                        }
                        values[offset + sensorIndex + i * nextSampleOffset] = calibratedData;
                    }
                    continue;
                }
                if (vernierProbeType != 6) continue;
                int numReadings = this.labQuest.readRawMeasurementsMotion((byte)channel, this.pMeasurementsBuf, this.pTimestampsBuf, minAvailable * 2);
                numMeasurements = this.computeDistanceMeasurements(numReadings, values, offset + sensorIndex, nextSampleOffset);
            }
            return numMeasurements;
        }
        catch (LabQuestException e) {
            this.closeAfterException(e);
            return -1;
        }
    }

    private int computeDistanceMeasurements(int numReadings, float[] values, int startIndex, int nextSampleOffset) {
        int numValues = 0;
        long ping = -1L;
        block5: for (int i = 0; i < numReadings; ++i) {
            switch (this.pMeasurementsBuf[i]) {
                case 0: {
                    ping = this.pTimestampsBuf[i];
                    continue block5;
                }
                case 1: {
                    long echo = this.pTimestampsBuf[i];
                    values[startIndex + numValues * nextSampleOffset] = this.lastMDValue = (float)(0.5 * (double)(echo - ping) * 3.43E-4);
                    ++numValues;
                    ping = -1L;
                    continue block5;
                }
                case 2: {
                    values[startIndex + numValues * nextSampleOffset] = this.lastMDValue;
                    ++numValues;
                    ping = -1L;
                }
            }
        }
        return numValues;
    }

    public void stop(boolean wasRunning) {
        try {
            this.labQuest.stopMeasurements();
        }
        catch (LabQuestException e) {
            this.closeAfterException(e);
        }
    }

    public ExperimentConfig configure(ExperimentRequest request) {
        return this.autoIdConfigure(request);
    }

    protected SerialPortParams getSerialPortParams() {
        return null;
    }

    protected boolean initializeOpenPort(String portName) {
        return false;
    }

    public boolean canDetectSensors() {
        return true;
    }

    public void log(String message) {
        super.log(message);
    }

    protected SensorConfig createSensorConfig(int type, int requestPort) {
        VernierSensor config = new VernierSensor(this, this.devService, requestPort + 1, 0);
        config.setType(type);
        return config;
    }

    private void closeAfterException(LabQuestException e) {
        e.printStackTrace();
        if (this.labQuest != null) {
            try {
                this.labQuest.close();
            }
            catch (LabQuestException e1) {
                e1.printStackTrace();
                this.labQuest = null;
            }
        }
    }

    public String getVendorName() {
        return "Vernier";
    }

    public String getDeviceName() {
        return "LabQuest";
    }
}

