/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.device.impl;

import java.util.ArrayList;
import org.concord.sensor.ExperimentConfig;
import org.concord.sensor.ExperimentRequest;
import org.concord.sensor.SensorConfig;
import org.concord.sensor.SensorRequest;
import org.concord.sensor.device.DeviceService;
import org.concord.sensor.device.DeviceServiceAware;
import org.concord.sensor.device.SensorDevice;
import org.concord.sensor.device.impl.SensorConfigImpl;
import org.concord.sensor.device.impl.SerialPortParams;
import org.concord.sensor.impl.ExperimentConfigImpl;
import org.concord.sensor.impl.Range;
import org.concord.sensor.impl.SensorUtilJava;
import org.concord.sensor.impl.Vector;
import org.concord.sensor.serial.SensorSerialPort;
import org.concord.sensor.serial.SerialException;

public abstract class AbstractSensorDevice
implements SensorDevice,
DeviceServiceAware {
    public static final int ERROR_NONE = 0;
    public static final int ERROR_GENERAL = -1;
    public static final int ERROR_PORT = -2;
    public static final int ERROR_DEV_VERSION = -3;
    protected String deviceLabel = "SD";
    protected ExperimentConfigImpl currentConfig = null;
    protected boolean attached = false;
    protected String portName;
    protected SensorSerialPort port = null;
    protected int error = 0;
    protected int portError = 0;
    protected DeviceService devService;

    public static final boolean isRawType(int type) {
        return type == 23 || type == 25 || type == 22 || type == 24;
    }

    public boolean isAttached() {
        if (this.port == null || !this.port.isOpen()) {
            return false;
        }
        return this.isAttachedInternal(this.portName);
    }

    public void setDeviceService(DeviceService provider) {
        this.devService = provider;
    }

    public void open(String openString) {
        this.portName = openString;
        if (!this.openPort()) {
            return;
        }
    }

    public void close() {
        System.err.println("Closing device: " + this.getClass());
        this.closePort();
        this.port = null;
    }

    protected void closePort() {
        if (this.port == null || !this.port.isOpen()) {
            return;
        }
        this.log("closing port: " + this.portName);
        try {
            this.port.close();
        }
        catch (SerialException e) {
            e.printStackTrace();
        }
        this.port = null;
    }

    protected boolean openPort() {
        if (this.port != null && this.port.isOpen()) {
            return true;
        }
        this.error = 0;
        if (this.portName == null || this.portName.trim().length() == 0) {
            this.portName = "bluetooth";
        }
        if ("_auto_".equals(this.portName)) {
            return this.openAutoPort();
        }
        return this.openPortName(this.portName);
    }

    protected boolean openAutoPort() {
        if (this.port == null) {
            this.port = this.getSensorSerialPort();
        }
        Vector availablePorts = this.getAvailablePortNames();
        for (int i = 0; i < availablePorts.size(); ++i) {
            String possiblePort = (String)availablePorts.get(i);
            if (!this.openPortName(possiblePort)) continue;
            this.portName = possiblePort;
            return true;
        }
        return false;
    }

    protected boolean openPortName(String possiblePort) {
        this.log("looking for device on port: " + possiblePort);
        if (!this.attemptToOpenPort(possiblePort)) {
            this.log("could not open port: " + possiblePort);
            this.closePort();
            return false;
        }
        if (!this.isAttachedInternal(possiblePort)) {
            this.log("could not find device on port: " + possiblePort);
            this.closePort();
            return false;
        }
        this.log("found device on port: " + possiblePort);
        return true;
    }

    protected void log(String message) {
        this.devService.log(this.deviceLabel + ": " + message);
    }

    protected SensorSerialPort getSensorSerialPort() {
        return this.devService.getSerialPort("os", this.port);
    }

    protected Vector getAvailablePortNames() {
        return this.port.getAvailablePorts();
    }

    protected boolean isAttachedInternal(String portLabel) {
        return this.attached;
    }

    public boolean attemptToOpenPort(String portName) {
        this.closePort();
        if (this.port == null) {
            this.port = this.getSensorSerialPort();
        }
        if (this.port == null) {
            this.log("Cannot open serial driver");
            return false;
        }
        SerialPortParams serialPortParams = this.getSerialPortParams();
        try {
            if (serialPortParams != null) {
                serialPortParams.setupPort(this.port);
            }
            this.port.open(portName);
            this.log("opened port: " + portName);
        }
        catch (SerialException e) {
            this.portError = e.getPortError();
            this.port = null;
            this.error = -2;
            this.log("Cannot open port " + portName + " err: " + this.portError);
            this.log("  msg: " + e.getMessage());
            return false;
        }
        return this.initializeOpenPort(portName);
    }

    protected void portError(int portError) {
        this.error = -2;
        this.log("ser port err: " + portError);
        this.closePort();
    }

    protected void deviceError(int code, String tag) {
        this.log("dev err: " + code + " (" + tag + ")");
        if (this.port != null) {
            this.error = code;
        }
        this.closePort();
    }

    protected int compareSensorConfigAndRequest(SensorConfig config, SensorRequest request) {
        float score = 100.0f;
        float typeFactor = SensorUtilJava.scoreSensorType(config, request);
        score *= typeFactor;
        float rangeFactor = SensorUtilJava.scoreValueRange(config, request);
        score *= rangeFactor;
        float stepSizeFactor = SensorUtilJava.scoreStepSize(config, request);
        return (int)(score *= stepSizeFactor);
    }

    protected boolean hasExactPeriod() {
        return true;
    }

    protected void autoIdConfigureInternal(ExperimentConfigImpl expConfig, ExperimentRequest request) {
        int i;
        Range periodRange = expConfig.getPeriodRange();
        if (periodRange != null) {
            if (request.getPeriod() > periodRange.maximum) {
                expConfig.setPeriod(periodRange.maximum);
            } else if (request.getPeriod() < periodRange.minimum) {
                expConfig.setPeriod(periodRange.minimum);
            } else {
                expConfig.setPeriod(request.getPeriod());
            }
        } else {
            expConfig.setPeriod(request.getPeriod());
        }
        expConfig.setDataReadPeriod(expConfig.getPeriod());
        expConfig.setExactPeriod(this.hasExactPeriod());
        SensorRequest[] sensorRequests = request.getSensorRequests();
        SensorConfig[] sensorConfigs = expConfig.getSensorConfigs();
        ArrayList<SensorConfig> matchingConfigs = new ArrayList<SensorConfig>();
        expConfig.setValid(true);
        boolean sensorTypesAvailable = true;
        ArrayList<int[]> scores = new ArrayList<int[]>();
        for (i = 0; i < sensorRequests.length; ++i) {
            int[] scoreArray = new int[sensorConfigs.length];
            for (int j = 0; j < sensorConfigs.length; ++j) {
                scoreArray[j] = this.compareSensorConfigAndRequest(sensorConfigs[j], sensorRequests[i]);
            }
            scores.add(scoreArray);
        }
        for (i = 0; i < sensorRequests.length; ++i) {
            int highScore = 0;
            int highScoreIndex = -1;
            int[] scoreArray = (int[])scores.get(i);
            for (int j = 0; j < scoreArray.length; ++j) {
                int score;
                SensorConfig sensorConfig = sensorConfigs[j];
                if (matchingConfigs.contains(sensorConfig) || (score = scoreArray[j]) <= highScore) continue;
                highScoreIndex = j;
                highScore = score;
            }
            if (highScoreIndex == -1) {
                sensorTypesAvailable = false;
                break;
            }
            matchingConfigs.add(sensorConfigs[highScoreIndex]);
        }
        if (!sensorTypesAvailable) {
            expConfig.setValid(false);
            return;
        }
        int numConfigs = matchingConfigs.size();
        SensorConfig[] matchingConfigArray = new SensorConfig[numConfigs];
        for (int i2 = 0; i2 < numConfigs; ++i2) {
            matchingConfigArray[i2] = (SensorConfig)matchingConfigs.get(i2);
        }
        expConfig.setSensorConfigs(matchingConfigArray);
        expConfig.setValid(true);
    }

    protected ExperimentConfig autoIdConfigure(ExperimentRequest request) {
        if (!this.openPort()) {
            return null;
        }
        ExperimentConfigImpl deviceConfig = (ExperimentConfigImpl)this.getCurrentConfig();
        if (deviceConfig == null) {
            return null;
        }
        SensorRequest[] sensorRequests = request.getSensorRequests();
        if (this.supportsRawSensorValues() && sensorRequests != null && sensorRequests.length > 0 && AbstractSensorDevice.isRawType(sensorRequests[0].getType())) {
            SensorConfig rawSensorConfig = this.createSensorConfig(sensorRequests[0].getType(), 0);
            SensorConfig[] sensorConfigs = new SensorConfig[]{rawSensorConfig};
            deviceConfig.setSensorConfigs(sensorConfigs);
            deviceConfig.setValid(true);
        }
        if (deviceConfig.getSensorConfigs() == null) {
            if (this.hasNonAutoIdSensors()) {
                this.nonAutoIdConfigureInteral(deviceConfig, request);
            } else {
                deviceConfig.setValid(false);
            }
        } else if (deviceConfig.getSensorConfigs().length == 0) {
            this.devService.log("warning getCurrentConfig returned 0 length sensorConfigs waba cannot handle that");
            deviceConfig.setValid(false);
        } else {
            this.autoIdConfigureInternal(deviceConfig, request);
        }
        if (deviceConfig.isValid()) {
            this.currentConfig = deviceConfig;
        }
        return deviceConfig;
    }

    protected void nonAutoIdConfigureInteral(ExperimentConfigImpl deviceConfig, ExperimentRequest request) {
        SensorRequest[] sensorRequests = request.getSensorRequests();
        if (sensorRequests == null || sensorRequests.length == 0) {
            deviceConfig.setSensorConfigs(null);
            deviceConfig.setValid(false);
            return;
        }
        SensorConfig[] sensorConfigs = new SensorConfig[sensorRequests.length];
        for (int i = 0; i < sensorRequests.length; ++i) {
            sensorConfigs[i] = this.createSensorConfig(sensorRequests[i].getType(), sensorRequests[i].getPort());
        }
        deviceConfig.setSensorConfigs(sensorConfigs);
        deviceConfig.setValid(true);
        deviceConfig.setPeriod(request.getPeriod());
        deviceConfig.setDataReadPeriod(deviceConfig.getPeriod());
        deviceConfig.setExactPeriod(this.hasExactPeriod());
    }

    protected SensorConfig createSensorConfig(int type, int requestPort) {
        SensorConfigImpl config = new SensorConfigImpl();
        config.setType(type);
        config.setPort(requestPort);
        return config;
    }

    protected boolean hasNonAutoIdSensors() {
        return false;
    }

    protected boolean supportsRawSensorValues() {
        return true;
    }

    protected abstract boolean initializeOpenPort(String var1);

    protected abstract SerialPortParams getSerialPortParams();
}

