/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.device.impl;

import org.concord.sensor.DeviceTime;
import org.concord.sensor.ExperimentConfig;
import org.concord.sensor.LoggingRequest;
import org.concord.sensor.device.SensorLoggedRecord;
import org.concord.sensor.impl.ExperimentConfigImpl;

public abstract class AbstractSensorLoggedRecord
implements SensorLoggedRecord {
    protected String description;
    protected ExperimentConfig loggedConfig;
    protected int numSamples;
    protected DeviceTime startTime;
    protected int startCondition;
    protected int triggerPosition;
    protected int preTriggerSamples;
    protected int triggerChannel;
    protected float triggerValue;
    protected int numSamplesToTake;

    public String getDescription() {
        return this.description;
    }

    public ExperimentConfig getLoggedConfig() {
        return this.loggedConfig;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public DeviceTime getStartTime() {
        return this.startTime;
    }

    public int getStartCondition() {
        return this.startCondition;
    }

    public void configure(ExperimentConfigImpl expConfig, LoggingRequest request) {
        this.startTime = request.getStartTime();
        this.startCondition = request.getStartCondition();
        this.triggerPosition = request.getTriggerPosition();
        this.preTriggerSamples = request.getPreTriggerSamples();
        this.triggerChannel = request.getTriggerChannel();
        this.triggerValue = request.getTriggerValue();
        this.numSamplesToTake = request.getNumberOfSamples();
        if (expConfig == null) {
            expConfig = new ExperimentConfigImpl();
        }
        expConfig.setPeriod(request.getPeriod());
        this.loggedConfig = expConfig;
    }
}

