/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.impl;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.concord.sensor.ExperimentConfig;
import org.concord.sensor.ExperimentRequest;
import org.concord.sensor.SensorConfig;
import org.concord.sensor.SensorRequest;
import org.concord.sensor.device.impl.SensorConfigImpl;
import org.concord.sensor.impl.Range;

public class SensorUtilJava {
    public static String getTypeConstantName(int type) {
        Field[] declaredFields = SensorConfig.class.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            String name;
            Field field = declaredFields[i];
            int mod = field.getModifiers();
            if (!Modifier.isStatic(mod) || !(name = field.getName()).startsWith("QUANTITY_")) continue;
            try {
                int fieldValue = field.getInt(null);
                if (fieldValue != type) continue;
                return name.substring("QUANTITY_".length());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void printExperimentConfig(ExperimentConfig currentConfig) {
        PrintStream out = System.out;
        out.println(SensorUtilJava.experimentConfigToString(currentConfig));
    }

    public static String experimentConfigToString(ExperimentConfig currentConfig) {
        String ret = "ExperimentConfig\n";
        ret = ret + "  deviceName " + currentConfig.getDeviceName() + "\n";
        ret = ret + "  dataReadPeriod " + currentConfig.getDataReadPeriod() + "\n";
        ret = ret + "  exactPeriod " + currentConfig.getExactPeriod() + "\n";
        ret = ret + "  invalid " + currentConfig.isValid() + "\n";
        ret = ret + "  invalidReason " + currentConfig.getInvalidReason() + "\n";
        SensorConfig[] sensors = currentConfig.getSensorConfigs();
        if (sensors == null) {
            ret = ret + "  No SensorConfigs found!\n";
        } else {
            for (int i = 0; i < sensors.length; ++i) {
                SensorConfig sensor = sensors[i];
                ret = ret + "  SensorConfig\n";
                ret = ret + "    name " + sensor.getName() + "\n";
                ret = ret + "    type " + sensor.getType() + "\n";
                ret = ret + "    typeConstant " + SensorUtilJava.getTypeConstantName(sensor.getType()) + "\n";
                ret = ret + "    port " + sensor.getPort() + "\n";
                ret = ret + "    portName " + sensor.getPortName() + "\n";
                ret = ret + "    stepSize " + sensor.getStepSize() + "\n";
                ret = ret + "    confirmed " + sensor.isConfirmed() + "\n";
                String unit = sensor.getUnit();
                ret = ret + "    unit " + (unit == null ? "null" : unit) + "\n";
            }
        }
        return ret;
    }

    public static String experimentRequestToString(ExperimentRequest request) {
        SensorRequest[] sensorRequests;
        String ret = "ExperimentRequest\n";
        ret = ret + "  numberOfSamples: " + request.getNumberOfSamples() + "\n";
        ret = ret + "  period: " + request.getPeriod() + "\n";
        for (SensorRequest sensor : sensorRequests = request.getSensorRequests()) {
            ret = ret + "  sensorRequest:\n";
            ret = ret + "    displayPrecision: " + sensor.getDisplayPrecision() + "\n";
            ret = ret + "    port: " + sensor.getPort() + "\n";
            ret = ret + "    requiredMax: " + sensor.getRequiredMax() + "\n";
            ret = ret + "    requiredMin: " + sensor.getRequiredMin() + "\n";
            ret = ret + "    stepSize: " + sensor.getStepSize() + "\n";
            ret = ret + "    type: " + SensorUtilJava.getTypeConstantName(sensor.getType()) + "\n";
            ret = ret + "    unit: " + sensor.getUnit() + "\n";
            String[] sensorParamKeys = sensor.getSensorParamKeys();
            if (sensorParamKeys == null || sensorParamKeys.length <= 0) continue;
            ret = ret + "    sensorParams:\n";
            for (String key : sensorParamKeys) {
                ret = ret + "      " + key + ": " + sensor.getSensorParam(key) + "\n";
            }
        }
        return ret;
    }

    public static float scoreSensorType(SensorConfig config, SensorRequest request) {
        if (request.getType() == 0) {
            if (config.getType() == 0) {
                return 0.75f;
            }
            if (config.getType() == 1) {
                return 1.0f;
            }
        }
        if (config.getType() == 13 && (request.getType() == 13 || request.getType() == 6)) {
            return 1.0f;
        }
        if (config.getType() != request.getType()) {
            return 0.0f;
        }
        return 1.0f;
    }

    public static float scoreValueRange(SensorConfig config, SensorRequest request) {
        if (config instanceof SensorConfigImpl) {
            Range valueRange = ((SensorConfigImpl)config).getValueRange();
            if (valueRange == null) {
                return 1.0f;
            }
            float reqMin = request.getRequiredMin();
            float reqMax = request.getRequiredMax();
            if (!Float.isNaN(reqMin) && reqMin < valueRange.minimum) {
                return 0.5f;
            }
            if (!Float.isNaN(reqMax) && reqMax > valueRange.maximum) {
                return 0.5f;
            }
            return 1.0f;
        }
        return 1.0f;
    }

    public static float scoreStepSize(SensorConfig config, SensorRequest request) {
        if (request.getType() == 3 || request.getType() == 5) {
            if (Float.isNaN(request.getStepSize())) {
                return 1.0f;
            }
            if (request.getStepSize() <= 0.0f && config.getStepSize() <= 0.0f) {
                return 1.0f;
            }
            if (request.getStepSize() >= config.getStepSize()) {
                return 1.0f;
            }
            return 0.0f;
        }
        return 1.0f;
    }
}

