/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.impl;

public final class Vector {
    public Object[] items;
    private int count;

    public static void copyArray(Object[] srcArray, int srcStart, Object[] dstArray, int dstStart, int length) {
        int srcIndex = srcStart;
        int dstIndex = dstStart;
        for (int i = 0; i < length; ++i) {
            dstArray[dstIndex] = srcArray[srcIndex];
            ++srcIndex;
            ++dstIndex;
        }
    }

    public Vector() {
        this(8);
    }

    public Vector(int size) {
        this.items = new Object[size == 0 ? 1 : size];
    }

    public Vector(Object[] startingWith) {
        if (startingWith != null) {
            this.items = startingWith;
            this.count = startingWith.length;
        } else {
            this.items = new Object[1];
        }
    }

    public void add(Object obj) {
        if (this.count < this.items.length) {
            this.items[this.count++] = obj;
        } else {
            this.insert(this.count, obj);
        }
    }

    public void insert(int index, Object obj) {
        if (index < 0 || index > this.count) {
            index = this.count;
        }
        if (this.count == this.items.length) {
            Object[] newItems = new Object[this.items.length * 12 / 10 + 1];
            Vector.copyArray(this.items, 0, newItems, 0, this.count);
            this.items = newItems;
        }
        if (index != this.count) {
            Vector.copyArray(this.items, index, this.items, index + 1, this.count - index);
        }
        this.items[index] = obj;
        ++this.count;
    }

    public void del(int index) {
        if (index != this.count - 1) {
            Vector.copyArray(this.items, index + 1, this.items, index, this.count - index - 1);
        }
        this.items[this.count - 1] = null;
        --this.count;
    }

    public boolean del(Object obj) {
        int i = this.find(obj);
        if (i >= 0) {
            this.del(i);
            return true;
        }
        return false;
    }

    public Object get(int index) {
        if (index >= this.count) {
            index = this.items.length;
        }
        return this.items[index];
    }

    public void set(int index, Object obj) {
        if (index >= this.count) {
            index = this.items.length;
        }
        this.items[index] = obj;
    }

    public int find(Object obj) {
        return this.find(obj, 0);
    }

    public int find(Object obj, int startIndex) {
        for (int i = startIndex; i < this.count; ++i) {
            if (!this.items[i].equals(obj)) continue;
            return i;
        }
        return -1;
    }

    public int getCount() {
        return this.count;
    }

    public Object[] toObjectArray() {
        if (this.count == 0) {
            return null;
        }
        Object[] objs = this.items[0] instanceof String ? new String[this.count] : new Object[this.count];
        if (this.count > 0) {
            Vector.copyArray(this.items, 0, objs, 0, this.count);
        }
        return objs;
    }

    public void push(Object obj) {
        this.add(obj);
    }

    public Object pop() {
        Object o = null;
        if (this.count > 0) {
            o = this.items[--this.count];
        }
        this.items[this.count] = null;
        return o;
    }

    public Object peek() {
        return this.count > 0 ? this.items[this.count - 1] : null;
    }

    public void clear() {
        for (int i = 0; i < this.count; ++i) {
            this.items[i] = null;
        }
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public int indexOf(Object elem) {
        return this.find(elem, 0);
    }

    public int indexOf(Object elem, int index) {
        return this.find(elem, index);
    }

    public Object elementAt(int index) {
        return this.get(index);
    }

    public void setElementAt(Object obj, int index) {
        this.set(index, obj);
    }

    public void removeElementAt(int index) {
        this.del(index);
    }

    public void insertElementAt(Object obj, int index) {
        this.insert(index, obj);
    }

    public boolean removeElement(Object obj) {
        return this.del(obj);
    }

    public void removeAllElements() {
        this.clear();
    }
}

