/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.pseudo;

import org.concord.sensor.ExperimentConfig;
import org.concord.sensor.ExperimentRequest;
import org.concord.sensor.SensorConfig;
import org.concord.sensor.SensorRequest;
import org.concord.sensor.device.DeviceIdAware;
import org.concord.sensor.device.DeviceReader;
import org.concord.sensor.device.impl.AbstractSensorDevice;
import org.concord.sensor.device.impl.SerialPortParams;
import org.concord.sensor.impl.ExperimentConfigImpl;
import org.concord.sensor.impl.Range;
import org.concord.sensor.pseudo.PseudoSensorConfig;

public class PseudoSensorDevice
extends AbstractSensorDevice
implements DeviceIdAware {
    PseudoSensorConfig[] sensConfigs;
    float time = 0.0f;
    private int deviceId = -1;

    public String getVendorName() {
        return "Simulated";
    }

    public String getDeviceName() {
        if (this.deviceId == -1) {
            return "Simulated Data";
        }
        return "Simulated Data (id:" + this.deviceId + ")";
    }

    public void open(String openString) {
    }

    protected boolean hasVariableTime() {
        return this.deviceId == 1;
    }

    public ExperimentConfig configure(ExperimentRequest request) {
        this.currentConfig = new ExperimentConfigImpl();
        this.currentConfig.setValid(true);
        this.currentConfig.setDeviceName("Psuedo Device");
        if (this.hasVariableTime()) {
            this.currentConfig.setExactPeriod(false);
        } else {
            this.currentConfig.setExactPeriod(true);
        }
        this.currentConfig.setPeriod(0.1f);
        this.currentConfig.setDataReadPeriod(0.1f);
        SensorRequest[] sensRequests = request.getSensorRequests();
        this.sensConfigs = new PseudoSensorConfig[sensRequests.length];
        for (int i = 0; i < sensRequests.length; ++i) {
            PseudoSensorConfig sensConfig;
            this.sensConfigs[i] = sensConfig = new PseudoSensorConfig();
            sensConfig.setPort(sensRequests[i].getPort());
            sensConfig.setStepSize(sensRequests[i].getStepSize());
            sensConfig.setType(sensRequests[i].getType());
            sensConfig.setUnit(sensRequests[i].getUnit());
            float max = sensRequests[i].getRequiredMax();
            float min = sensRequests[i].getRequiredMin();
            sensConfig.setValueRange(new Range(min, max));
            if (!this.devService.isValidFloat(max) || !this.devService.isValidFloat(min)) continue;
            sensConfig.setSinOffset((max + min) / 2.0f);
            sensConfig.setSinMagnitude((max - min) / 2.0f);
        }
        this.currentConfig.setSensorConfigs(this.sensConfigs);
        return this.currentConfig;
    }

    public boolean start() {
        this.time = 0.0f;
        return true;
    }

    public int read(float[] values, int offset, int nextSampleOffset, DeviceReader reader) {
        if (this.hasVariableTime()) {
            values[offset++] = this.time;
        }
        for (int i = 0; i < this.sensConfigs.length; ++i) {
            float sinOffset = this.sensConfigs[i].getSinOffset();
            float sinMagnitude = this.sensConfigs[i].getSinMagnitude();
            values[offset++] = (float)((double)sinOffset + (double)sinMagnitude * Math.sin(this.time));
        }
        this.time = (float)((double)this.time + 0.1);
        return 1;
    }

    public void stop(boolean wasRunning) {
        this.time = 0.0f;
    }

    public String getErrorMessage(int error) {
        return null;
    }

    public boolean isAttached() {
        return true;
    }

    public boolean canDetectSensors() {
        return true;
    }

    public ExperimentConfig getCurrentConfig() {
        if (this.currentConfig != null) {
            return this.currentConfig;
        }
        this.currentConfig = new ExperimentConfigImpl();
        SensorConfig[] sensConfigs = new SensorConfig[1];
        PseudoSensorConfig sensConfig = new PseudoSensorConfig();
        sensConfigs[0] = sensConfig;
        sensConfig.setPort(0);
        sensConfig.setStepSize(0.1f);
        sensConfig.setType(0);
        sensConfig.setUnit("degC");
        this.currentConfig.setSensorConfigs(sensConfigs);
        return this.currentConfig;
    }

    protected SerialPortParams getSerialPortParams() {
        return null;
    }

    protected boolean initializeOpenPort(String portName) {
        return true;
    }

    public void setDeviceId(int id) {
        this.deviceId = id;
    }
}

