/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.serial;

import gnu.io.CommPortIdentifier;
import gnu.io.RXTXCommDriver;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.concord.sensor.impl.Vector;
import org.concord.sensor.serial.SensorSerialPort;
import org.concord.sensor.serial.SerialException;

public class SensorSerialPortRXTX
implements SensorSerialPort {
    RXTXCommDriver commDriver = null;
    SerialPort port = null;
    InputStream inStream = null;
    OutputStream outStream = null;
    private int currentTimeout;
    int baud;
    int dataBits;
    int stopBits;
    int parity;
    int flowcontrol;

    public Vector getAvailablePorts() {
        Vector availablePorts = new Vector();
        if (this.commDriver == null) {
            this.commDriver = new RXTXCommDriver();
            this.commDriver.initialize();
        }
        Enumeration ports = CommPortIdentifier.getPortIdentifiers();
        while (ports.hasMoreElements()) {
            CommPortIdentifier portID = (CommPortIdentifier)ports.nextElement();
            String portName = portID.getName();
            if (System.getProperty("os.name").startsWith("Mac OS X") && !portName.startsWith("/dev/tty")) continue;
            System.out.println("RXTX: found port: " + portName);
            availablePorts.add(portName);
        }
        return availablePorts;
    }

    public void open(String portName) throws SerialException {
        if (this.commDriver == null) {
            this.commDriver = new RXTXCommDriver();
            this.commDriver.initialize();
            Enumeration ports = CommPortIdentifier.getPortIdentifiers();
            while (ports.hasMoreElements()) {
                CommPortIdentifier portID = (CommPortIdentifier)ports.nextElement();
                System.out.println("RXTX: found port: " + portID.getName());
            }
        }
        if (this.port != null) {
            throw new RuntimeException("The port was not closed before being opened");
        }
        System.out.println("RXTX: opening port: " + portName);
        this.port = (SerialPort)this.commDriver.getCommPort(portName, 1);
        if (this.port == null) {
            throw new SerialException("can't open serial port");
        }
        try {
            this.inStream = this.port.getInputStream();
            if (this.inStream == null) {
                throw new SerialException("null inStream");
            }
            this.outStream = this.port.getOutputStream();
            if (this.outStream == null) {
                throw new SerialException("null outStream");
            }
        }
        catch (IOException e) {
            throw new SerialException("can't open streams", e);
        }
        try {
            this.port.setSerialPortParams(this.baud, this.dataBits, this.stopBits, this.parity);
            this.port.setFlowControlMode(this.flowcontrol);
        }
        catch (UnsupportedCommOperationException e) {
            throw new SerialException("UnsupportedCommOperation", e);
        }
    }

    public void close() throws SerialException {
        if (this.port == null) {
            return;
        }
        this.port.close();
        this.port = null;
    }

    public boolean isOpen() {
        return this.port != null;
    }

    public void setSerialPortParams(int b, int d, int s, int p) throws SerialException {
        this.baud = b;
        this.dataBits = d;
        this.stopBits = s;
        this.parity = p;
    }

    public int getBaudRate() {
        return this.port.getBaudRate();
    }

    public int getDataBits() {
        return this.port.getDataBits();
    }

    public int getStopBits() {
        return this.port.getStopBits();
    }

    public int getParity() {
        return this.port.getParity();
    }

    public void setFlowControlMode(int flowcontrol) throws SerialException {
        this.flowcontrol = flowcontrol;
    }

    public void disableReceiveTimeout() {
        this.port.disableReceiveTimeout();
    }

    public void enableReceiveTimeout(int time) throws SerialException {
        this.currentTimeout = time;
        try {
            this.port.enableReceiveTimeout(time);
        }
        catch (UnsupportedCommOperationException e) {
            throw new SerialException("UnsupportedCommOperation");
        }
    }

    public int readBytes(byte[] buf, int off, int len, long timeout) throws SerialException {
        if (!System.getProperty("os.name").startsWith("Windows")) {
            try {
                this.port.enableReceiveTimeout((int)timeout);
                this.port.enableReceiveThreshold(len);
                int numRead = this.inStream.read(buf, off, len);
                this.port.disableReceiveThreshold();
                this.port.enableReceiveTimeout(this.currentTimeout);
                return numRead;
            }
            catch (UnsupportedCommOperationException e) {
                System.err.println("timeout or threshold not available on this platform");
            }
            catch (IOException e) {
                throw new SerialException("threshold read error", e);
            }
        }
        try {
            int size;
            int readSize;
            long startTime = System.currentTimeMillis();
            for (size = 0; size != -1 && size < len && System.currentTimeMillis() - startTime < timeout; size += readSize) {
                readSize = this.inStream.read(buf, size + off, len - size);
                if (readSize >= 0) continue;
                System.err.println();
                System.err.println("error in readBytes: " + readSize);
                return readSize;
            }
            return size;
        }
        catch (IOException e) {
            throw new SerialException("polling read error", e);
        }
    }

    public void write(byte[] buffer) throws SerialException {
        try {
            this.outStream.write(buffer);
            this.outStream.flush();
        }
        catch (IOException e) {
            throw new SerialException("write error", e);
        }
    }

    public void write(byte[] buffer, int start, int length) throws SerialException {
        try {
            this.outStream.write(buffer, start, length);
            this.outStream.flush();
        }
        catch (IOException e) {
            throw new SerialException("write error", e);
        }
    }

    public void write(int value) throws SerialException {
        try {
            this.outStream.write(value);
            this.outStream.flush();
        }
        catch (IOException e) {
            throw new SerialException("write error", e);
        }
    }

    public boolean isOpenFast() {
        return false;
    }
}

