/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.applet;

import java.awt.Button;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import javax.swing.JApplet;
import org.concord.sensor.applet.JavascriptDataBridge;
import org.concord.sensor.applet.SensorUtil;

public class HighLevelTestApplet
extends JApplet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(HighLevelTestApplet.class.getName());

    public void start() {
        super.start();
        Button readButton = new Button("Read");
        readButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HighLevelTestApplet.this.readData();
            }
        });
        this.add(readButton);
    }

    public void readData() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        HighLevelTestApplet.this.doRead();
                        return null;
                    }
                });
            }
        });
    }

    private void doRead() {
        SensorUtil util = new SensorUtil(this, "golink");
        JavascriptDataBridge jsBridge = new JavascriptDataBridge("window", this);
        try {
            float[] data = util.readSingleValue(jsBridge, true);
            logger.info("got data: " + jsBridge.asArgs(data));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

