/*
 * Decompiled with CFR 0.152.
 */
package org.concord.sensor.labquest.jna;

import com.sun.jna.FunctionMapper;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.ShortByReference;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.concord.sensor.labquest.jna.LabQuest;
import org.concord.sensor.labquest.jna.LabQuestException;
import org.concord.sensor.labquest.jna.LabQuestImpl;
import org.concord.sensor.labquest.jna.NGIOLibrary;
import org.concord.sensor.labquest.jna.SingleThreadDelegator;

public class LabQuestLibrary {
    private static LabQuestLibrary instance;
    private NGIOLibrary ngio;
    private Pointer hLibrary;
    private ArrayList<Integer> initializers = new ArrayList();

    public static LabQuestLibrary getInstance() throws IOException, InterruptedException {
        if (instance != null) {
            return instance;
        }
        instance = new LabQuestLibrary();
        return instance;
    }

    private LabQuestLibrary() throws IOException, InterruptedException {
        NativeHelper.removeTemporaryFiles();
        File nativeLibFile = LabQuestLibrary.getNativeLibraryFromJar();
        String nativeLibPath = nativeLibFile.getAbsolutePath();
        FunctionMapper functMapper = new FunctionMapper(){

            public String getFunctionName(NativeLibrary library, Method method) {
                return "NGIO_" + method.getName().substring(0, 1).toUpperCase() + method.getName().substring(1);
            }
        };
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("function-mapper", functMapper);
        options.put("structure-alignment", 1);
        this.ngio = (NGIOLibrary)Native.loadLibrary((String)nativeLibPath, NGIOLibrary.class, options);
        NativeHelper.deleteNativeLibrary(nativeLibFile);
    }

    public void init(Object key) throws InterruptedException, LabQuestException {
        this.initializers.add(key.hashCode());
        if (this.hLibrary != null) {
            return;
        }
        this.hLibrary = this.ngio.init();
        if (this.hLibrary == null) {
            throw new LabQuestException("Cannot initialize native library");
        }
        int lqDebugLevel = Integer.getInteger("labquest.debug.level", -1);
        if (lqDebugLevel != -1) {
            this.ngio.diags_SetDebugTraceThreshold(this.hLibrary, lqDebugLevel);
        }
        Thread.sleep(200L);
    }

    public void uninit(Object key) {
        if (this.hLibrary == null) {
            System.err.println("  hLibrary null");
            return;
        }
        this.initializers.remove((Object)key.hashCode());
        if (this.initializers.size() > 0) {
            return;
        }
        int ret = this.ngio.uninit(this.hLibrary);
        if (ret != 0) {
            System.err.println("  uninit failed");
        }
        this.hLibrary = null;
    }

    public short[] getDLLVersion() throws LabQuestException {
        ShortByReference majorVersion = new ShortByReference();
        ShortByReference minorVersion = new ShortByReference();
        int ret = this.ngio.getDLLVersion(this.hLibrary, majorVersion, minorVersion);
        if (ret != 0) {
            throw new LabQuestException();
        }
        short[] version = new short[]{majorVersion.getValue(), minorVersion.getValue()};
        return version;
    }

    public void searchForDevices() throws LabQuestException {
        IntByReference listSig = new IntByReference();
        int ret = -1;
        ret = this.ngio.searchForDevices(this.hLibrary, 5, 1, null, listSig);
        if (ret != 0) {
            throw new LabQuestException();
        }
        ret = this.ngio.searchForDevices(this.hLibrary, 12, 1, null, listSig);
        if (ret != 0) {
            throw new LabQuestException();
        }
        ret = this.ngio.searchForDevices(this.hLibrary, 14, 1, null, listSig);
        if (ret != 0) {
            throw new LabQuestException();
        }
    }

    public void printListOfDevices() throws LabQuestException {
        this.printDeviceListSnapshot(5, "labquest");
        this.printDeviceListSnapshot(12, "labquest_mini");
        this.printDeviceListSnapshot(14, "labquest_mini");
    }

    private void printDeviceListSnapshot(int deviceType, String deviceTypeName) throws LabQuestException {
        IntByReference numDevices = new IntByReference();
        IntByReference listSig = new IntByReference();
        Pointer openDeviceListSnapshotHandle = this.ngio.openDeviceListSnapshot(this.hLibrary, deviceType, numDevices, listSig);
        if (openDeviceListSnapshotHandle == null) {
            System.err.println("got a null snapshot handle");
            return;
        }
        System.out.println(deviceTypeName + " num devices: " + numDevices.getValue() + " list sig: " + listSig.getValue());
        byte[] devNameBuf = new byte[220];
        IntByReference deviceStatusMask = new IntByReference();
        for (int i = 0; i < numDevices.getValue(); ++i) {
            this.ngio.deviceListSnapshot_GetNthEntry(openDeviceListSnapshotHandle, i, devNameBuf, devNameBuf.length, deviceStatusMask);
            String devName = Native.toString((byte[])devNameBuf);
            System.out.println("  dev name: " + devName);
        }
        this.closeDeviceListSnapshot(openDeviceListSnapshotHandle);
    }

    private void closeDeviceListSnapshot(Pointer deviceListSnapshotHandle) throws LabQuestException {
        int ret = this.ngio.closeDeviceListSnapshot(deviceListSnapshotHandle);
        if (ret != 0) {
            throw new LabQuestException();
        }
    }

    public String getFirstDeviceName() throws LabQuestException {
        this.searchForDevices();
        String ret = this.getFirstDeviceName(5);
        if (ret != null) {
            return ret;
        }
        ret = this.getFirstDeviceName(12);
        if (ret != null) {
            return ret;
        }
        ret = this.getFirstDeviceName(14);
        return ret;
    }

    private String getFirstDeviceName(int deviceType) throws LabQuestException {
        IntByReference listSig = new IntByReference();
        IntByReference numDevices = new IntByReference();
        Pointer openDeviceListSnapshotHandle = this.ngio.openDeviceListSnapshot(this.hLibrary, deviceType, numDevices, listSig);
        int num = numDevices.getValue();
        if (num <= 0) {
            this.closeDeviceListSnapshot(openDeviceListSnapshotHandle);
            return null;
        }
        byte[] devNameBuf = new byte[220];
        IntByReference deviceStatusMask = new IntByReference();
        int ret = this.ngio.deviceListSnapshot_GetNthEntry(openDeviceListSnapshotHandle, 0, devNameBuf, devNameBuf.length, deviceStatusMask);
        if (ret != 0) {
            throw new LabQuestException();
        }
        this.closeDeviceListSnapshot(openDeviceListSnapshotHandle);
        return Native.toString((byte[])devNameBuf);
    }

    public LabQuest openDevice(String deviceName) throws LabQuestException {
        LabQuestImpl labQuest = new LabQuestImpl(this.ngio);
        SingleThreadDelegator<LabQuest> singleThreadDelegator = new SingleThreadDelegator<LabQuest>();
        singleThreadDelegator.setDaemon(true);
        singleThreadDelegator.start();
        Method closeMethod = null;
        try {
            closeMethod = LabQuest.class.getMethod("close", new Class[0]);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        LabQuest labQuest2 = singleThreadDelegator.instanciate(labQuest, LabQuest.class, LabQuestException.class, closeMethod);
        labQuest2.open(deviceName, this.hLibrary);
        return labQuest2;
    }

    static File getNativeLibraryFromJar() throws IOException, InterruptedException {
        if (Platform.isWindows()) {
            return LabQuestLibrary.getNativeLibraryFromJarWindows();
        }
        if (Platform.isMac()) {
            return LabQuestLibrary.getNativeLibraryFromJarMac();
        }
        return null;
    }

    static File getNativeLibraryFromJarWindows() throws IOException, InterruptedException {
        String path = LabQuestLibrary.getNativeLibraryResourcePath();
        File directory = LabQuestLibrary.createTmpDirectory();
        String ngioDll = LabQuestLibrary.getNativeLibraryResourcePath() + "/NGIO_lib.dll";
        if (path.endsWith("amd64")) {
            String wdapi64OS64 = LabQuestLibrary.getNativeLibraryResourcePath() + "/wdapi921.dll";
            LabQuestLibrary.extractResource(wdapi64OS64, directory);
        } else {
            String copyExec = LabQuestLibrary.getNativeLibraryResourcePath() + "/copy_win32_wdapi_dll.exe";
            String wdapiOS32 = LabQuestLibrary.getNativeLibraryResourcePath() + "/wdapi921_WIN32forOS32.dll";
            String wdapiOS64 = LabQuestLibrary.getNativeLibraryResourcePath() + "/wdapi921_WIN32forOS64.dll";
            File copyExecFile = LabQuestLibrary.extractResource(copyExec, directory);
            LabQuestLibrary.extractResource(wdapiOS32, directory);
            LabQuestLibrary.extractResource(wdapiOS64, directory);
            Process exec = Runtime.getRuntime().exec(new String[]{copyExecFile.getCanonicalPath()}, null, copyExecFile.getParentFile());
            exec.waitFor();
        }
        return LabQuestLibrary.extractResource(ngioDll, directory);
    }

    private static File getNativeLibraryFromJarMac() throws IOException {
        String resourceName = LabQuestLibrary.getNativeLibraryResourcePath() + "/libNGIOUniversal3way.dylib";
        File directory = LabQuestLibrary.createTmpDirectory();
        return LabQuestLibrary.extractResource(resourceName, directory);
    }

    static File createTmpDirectory() throws IOException {
        File directory = File.createTempFile("jna", "");
        directory.delete();
        directory.mkdir();
        return directory;
    }

    static File extractResource(String resourceName, File directory) throws Error, FileNotFoundException {
        URL url = LabQuestLibrary.class.getResource(resourceName);
        if (url == null) {
            throw new FileNotFoundException(resourceName + " not found in resource path");
        }
        File resourceFile = null;
        InputStream is = Native.class.getResourceAsStream(resourceName);
        if (is == null) {
            throw new Error("Can't obtain jnidispatch InputStream");
        }
        FileOutputStream fos = null;
        try {
            int count;
            String fileName = resourceName.substring(resourceName.lastIndexOf(47) + 1);
            resourceFile = new File(directory, fileName);
            fos = new FileOutputStream(resourceFile);
            byte[] buf = new byte[1024];
            while ((count = is.read(buf, 0, buf.length)) > 0) {
                fos.write(buf, 0, count);
            }
        }
        catch (IOException e) {
            throw new Error("Failed to create temporary file: " + e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
        return resourceFile;
    }

    private static String getNativeLibraryResourcePath() {
        String osPrefix;
        String arch = System.getProperty("os.arch").toLowerCase();
        if (Platform.isWindows()) {
            osPrefix = "win32_" + arch;
        } else if (Platform.isMac()) {
            osPrefix = "darwin";
        } else if (Platform.isLinux()) {
            if ("x86".equals(arch)) {
                arch = "i386";
            } else if ("x86_64".equals(arch)) {
                arch = "amd64";
            }
            osPrefix = "linux_" + arch;
        } else if (Platform.isSolaris()) {
            osPrefix = "sunos_" + arch;
        } else {
            osPrefix = System.getProperty("os.name").toLowerCase();
            int space = osPrefix.indexOf(" ");
            if (space != -1) {
                osPrefix = osPrefix.substring(0, space);
            }
            osPrefix = osPrefix + "-" + arch;
        }
        return "/org/concord/sensor/labquest/jna/" + osPrefix;
    }

    private static class NativeHelper {
        private NativeHelper() {
        }

        private static void deleteNativeLibrary(File file) {
            if (file.delete()) {
                return;
            }
            NativeHelper.markTemporaryFile(file);
        }

        private static void markTemporaryFile(File file) {
            try {
                File marker = new File(file.getParentFile(), file.getName() + ".x");
                marker.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private static void removeTemporaryFiles() {
            try {
                File dir = File.createTempFile("jna", ".x").getParentFile();
                FilenameFilter filter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".x") && name.indexOf("jna") != -1;
                    }
                };
                File[] files = dir.listFiles(filter);
                for (int i = 0; files != null && i < files.length; ++i) {
                    File marker = files[i];
                    String name = marker.getName();
                    name = name.substring(0, name.length() - 2);
                    File target = new File(marker.getParentFile(), name);
                    if (target.exists() && !target.delete()) continue;
                    marker.delete();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

