// Initialize Canvas
canvas = document.getElementById("canvas");
var stage = new createjs.Stage("canvas");

// Create Canvas elements
//Initialize Base Container Elements
var base_container = new createjs.Container();
var base_rect = new createjs.Shape();
var base_circle = new createjs.Shape();
var inner_circle = new createjs.Shape();

//Initialize Lines Container Elements
var lines_container = new createjs.Container();
var length_line = new createjs.Shape();
var length_line_arrow = new createjs.Shape();
var length_lineDashed = new createjs.Shape();
var angleCurve = new createjs.Shape();

//Initialize Connection Circle Elements
var cc_container = new createjs.Container();
var connection_circle = new createjs.Shape();

//Initialize Circle Container Elements
var circles_container = new createjs.Container();
var down_circle = new createjs.Shape();
var distance_line = new createjs.Shape();
var axisx_dashed_rect = new createjs.Shape();
var axisy_dashed_rect = new createjs.Shape();
var axisTop_dashed_rect = new createjs.Shape();
var dashed_circle = new createjs.Shape();
var dashed_rect = new createjs.Shape();
var helpDashed_rect = new createjs.Shape();
var length_lineCircleDashed = new createjs.Shape();

//Initialize Length D Info Container Elements
var dInfo = new createjs.Container();
var dRightLine = new createjs.Shape();
var dLeftLine = new createjs.Shape();
var degreesLine = new createjs.Shape();

//Math D Info on Canvas
var d_container = new createjs.Container();
var d = new createjs.Text("d", "bold 26px Arial", "blue");
d.textAlign = "center";
//
var d_l_arrow = new createjs.Shape();
var d_r_arrow = new createjs.Shape();
//L∙ημφ
//Circle Shape Explanation
var ex_container = new createjs.Container();
var explainCurve = new createjs.Shape();
explainCurve.graphics.setStrokeDash([10, 11.9]).setStrokeStyle(3).beginStroke("#ff6a00").moveTo(0, 100).bezierCurveTo(100, 90, 90, 0, 10, 0);
//
var explainCurveArrow = new createjs.Shape();
explainCurveArrow.graphics.beginFill("#ff6a00").drawPolyStar(3, 100, 12, 3, 0, 170);
var explainCurveTxt = new createjs.Text("Φορά\nΠεριστροφής", "bold 16px Arial", "#22245d");
explainCurveTxt.textAlign = "center";
explainCurveTxt.x = 10;
explainCurveTxt.y = 30;
//
ex_container.x = 540;
ex_container.y = 320;
ex_container.scaleX = ex_container.scaleY = 0.8;

//Initialize texts on Canvas
// Value
var mek_force = new createjs.Text("F = 0N", "bold 20px Arial", "#663300");
mek_force.textAlign = "center";
mek_force.x = 430;
mek_force.y = 200;
//
var mek_length = new createjs.Text("L", "bold 20px Arial", "blue");
mek_length.textAlign = "center";
mek_length.x = 202;
mek_length.y = 190;
//
var d_info = new createjs.Text("d = L∙ημφ", "bold 20px Arial", "#990000");
d_info.textAlign = "center";
//
var mek_angle = new createjs.Text("φ", "bold 20px Arial", "purple");
mek_angle.textAlign = "center";
mek_angle.x = 285;
mek_angle.y = 190;
//
var length_line_arrow_down = new createjs.Shape();
length_line_arrow_down.graphics.beginFill("blue").drawRect(0, 0, 6, 120);
length_line_arrow_down.graphics.beginFill("blue").drawPolyStar(3, 120, 12, 3, 0, 90);
//
var length_line_arrow_up = new createjs.Shape();
length_line_arrow_up.graphics.beginFill("blue").drawRect(0, 0, 6, 100);
length_line_arrow_up.graphics.beginFill("blue").drawPolyStar(3, 0, 12, 3, 0, -90);
length_line_arrow_up.x = 200;
length_line_arrow_up.y = 75;

length_line_arrow_down.x = 200;
length_line_arrow_down.y = 225;
//
var mek_results = new createjs.Text("Μοχλοβραχίονας \n\n d = 0,00000 m \n----------------\nΡοπή\n\n M = 0,00 N &sdot; m", "bold 18px Arial", "#333");
mek_results.textAlign = "center";
mek_results.x = 450;
mek_results.y = 10;
//AXIS TOP
axisTop_dashed_rect.graphics.setStrokeStyle(1).beginStroke("blue").drawRect(145, 60, 140, 1);
//
stage.addChild(mek_force, mek_length, length_line_arrow_down, length_line_arrow_up, axisTop_dashed_rect); //d_container

//help xLine for keeping the angle.
helpDashed_rect.graphics.setStrokeDash([10, 11.9]).setStrokeStyle(1).beginStroke("#990000").drawRect(100, 160, 300, 1);

//MEK Container
var mek_container = new createjs.Container();

/*-- Show Elements On Canvas --*/
//Final Container
mek_container.shadow = new createjs.Shadow("#333", 2, 5, 10);
mek_container.x = 245;
mek_container.y = 20;
//
mek_container.scaleX = mek_container.scaleY = 0.8;

//Add Childs to Containers
base_container.addChild(base_rect, base_circle, inner_circle);
lines_container.addChild(length_line, length_line_arrow, length_lineDashed);
circles_container.addChild(dashed_circle, axisx_dashed_rect, axisy_dashed_rect, distance_line, down_circle, length_lineCircleDashed);
dInfo.addChild(dRightLine, dLeftLine, degreesLine); //d_info
cc_container.addChild(connection_circle);
//Add Container to Main Stage Container
mek_container.addChild(dInfo, dashed_rect, circles_container, base_container, lines_container, cc_container, angleCurve);
ex_container.addChild(explainCurve, explainCurveArrow, explainCurveTxt);
//add final shape to stage
stage.addChild(mek_container, ex_container);

//Align Separate Containers inside the mek_container
//Base Container
base_container.x = 0;
//Lines Container
lines_container.x = 0;
//Orange Borderded Circle
cc_container.x = 35;
cc_container.y = 305;
//Red Borderded Circle and axisx, axisy dashed
circles_container.x = 0;
circles_container.y = 120;
//Length d information
dInfo.x = 34;
dInfo.y = 50;


//Stage update
stage.update();

/* -- Draw Base Container -- */
//Childs of Base Container
base_rect.graphics.setStrokeStyle(4).beginStroke("#000").beginFill("rgba(130, 162, 160, 0.7").drawRect(-15, -15, 100, 130); //0,0,70,100
//base_rect.scaleX = base_rect.scaleY = 1.3;
//
base_circle.graphics.setStrokeStyle(4).beginStroke("#333").beginFill("#f3f3f3").drawCircle(35, 50, 15);
inner_circle.graphics.beginFill("#333").drawCircle(35, 50, 8);

/* -- Draw Lines Container -- */
//Length Line Init-lineLength(lineHeight, lineRotation)
lineLength(260, 0);
arrowLength(35, 180, 90);
/* -- Draw Lines Connection Circle -- */
//Orange Circle
connection_circle.graphics.setStrokeStyle(3).beginStroke("orange").beginFill("#333").drawCircle(0, 0, 14); //35,305

/* -- Circle Container  -- */
//Red Circle
down_circle.graphics.setStrokeStyle(3).beginStroke("#990000").beginFill("#333").drawCircle(35, 300, 14);
//Distance Line
//lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
lineDistance(35, 200, 35, 300);
//axis x
axisx_dashed_rect.graphics.setStrokeDash([10, 11.9]).setStrokeStyle(1).beginStroke("#999").drawRect(-115, 300, 300, 1);
//axis y
axisy_dashed_rect.graphics.setStrokeDash([10, 11]).setStrokeStyle(1).beginStroke("#999").drawRect(35, 300, 1, 150);
//Dashed Circle
//dashed_circle.graphics.setStrokeDash([10, 11]).beginStroke("#999").beginFill("rgba(0, 0, 0, 0)").drawCircle(35, 300, 118);

/* -- Dashed Main Line -- */
dashed_rect.graphics.setStrokeDash([10, 19.4]).setStrokeStyle(1).beginStroke("#000").drawRect(35, -15, 1, 415);

/* -- Draw length d Info Container -- */
//Left Blue Line
function infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight) {
    dLeftLine.graphics.clear();
    dRightLine.graphics.clear();
    degreesLine.graphics.clear();
    //Left Blue Line
    dLeftLine.graphics.beginFill("blue").drawRect(0, 0, 2, lHeight);
    dLeftLine.x = 0;
    dLeftLine.y = 0;
    dLeftLine.regX = dLeftLine.regY = 0;
    dLeftLine.rotation = dLeftRotate;
    //Right Blue Line
    dRightLine.x = 0;
    dRightLine.y = dRightY;
    dRightLine.graphics.beginFill("blue").drawRect(0, 0, 2, 100);
    dRightLine.regX = dRightLine.regY = 0;
    dRightLine.rotation = dRightRotate;
    //90degrees Blue Line
    degreesLine.x = 0;
    degreesLine.y = dRightY;
    degreesLine.graphics.setStrokeDash([10, 11]).setStrokeStyle(1).beginStroke("blue").drawRect(0, 0, 1, dLineHeight);
    degreesLine.regX = degreesLine.regY = 0;
    degreesLine.rotation = dLineRotate;
    //
}
//Function info D on canvas
function dMathInfo(x, y, lArrowX, dX, dRotate) {
    //
    d_r_arrow.graphics.clear();
    d_l_arrow.graphics.clear();
    //
    d_l_arrow.graphics.beginFill("blue").drawRect(lArrowX, 0, 25, 6);
    d_l_arrow.graphics.beginFill("blue").drawPolyStar(lArrowX + 30, 3, 12, 3, 0, 120);
    //
    d_r_arrow.graphics.beginFill("blue").drawRect(0, 0, 25, 6);
    d_r_arrow.graphics.beginFill("blue").drawPolyStar(0, 3, 12, 3, 0, 180);
    //
    d_container.x = x;
    d_container.y = y;
    //align
    d_r_arrow.x = 0;
    d_r_arrow.y = 8;
    d.x = dX;
    d_l_arrow.x = lArrowX;
    d_l_arrow.y = 8;
    //
    d_container.scaleX = d_container.scaleY = 0.6;
    //

    d_container.regX = d_container.regY = 0;
    d_container.rotation = dRotate;
    d_container.addChild(d_l_arrow, d_r_arrow, d);
    stage.addChild(d_container);
}
/* -- Function Shapes  -- */
//Main Vertical Dahsed Line
function dashedMainLine(stroke1, stroke2, x, y, w, h) {
    dashed_rect.graphics.clear();
    dashed_rect.graphics.setStrokeDash([stroke1, stroke2]).setStrokeStyle(1).beginStroke("#000").drawRect(x, y, w, h);
}
//Function for Length Line
function lineLength(lineHeight, lineRotation) {
    length_line.graphics.clear();
    length_line.graphics.beginFill("#663300").drawRoundRect(0, 0, 8, lineHeight, 2, 2, 2, 2);
    length_line.x = 31;
    length_line.y = 50;
    length_line.rotation = lineRotation;
}
//Function Length Arrow
function arrowLength(x, y, rotation) {
    length_line_arrow.graphics.clear();
    length_line_arrow.graphics.beginFill("#663300").drawPolyStar(x, y, 20, 3, 0, rotation);
}
//Function for Distance Line inside Circles Container
function lineDistance(m1, m2, l1, l2) {
    distance_line.graphics.clear();
    distance_line.graphics.setStrokeStyle(8).beginStroke("#333").moveTo(m1, m2).lineTo(l1, l2);
}

//Function for Length Line Dashed
function lineLengtCiclehDashed(stroke1, stroke2, m1, m2, l1, l2) {
    length_lineCircleDashed.graphics.clear();
    length_lineCircleDashed.graphics.setStrokeDash([stroke1, stroke2]).setStrokeStyle(4).beginStroke("#6881f0").moveTo(m1, m2).lineTo(l1, l2);
}
//Function for Angle Curve Dashed
function angleCurvehDashed(l1, l2, l3, l4) {
    angleCurve.graphics.clear();
    angleCurve.graphics.setStrokeDash([10, 11.9]).setStrokeStyle(3).beginStroke("purple").moveTo(35, 250).quadraticCurveTo(l1, l2, l3, l4);
}

/*-- Move Shapes Functions --*/
//Connection Circle
function moveShapes(angle, length_l) {
    if (angle != 0) {
        stage.addChild(mek_angle);
    }
    /* --------- *********** --------- */
    /* --------- Length 0.1 --------- */
    /* --------- ********* --------- */
    if (length_l == 0.1) {
        dashedMainLine(10, 19.4, 35, -15, 1, 415);
        circles_container.y = 120;
        length_line_arrow_down.y = 225;
        mek_length.y = 190;
        //Initial Shape Positions
        cc_container.x = 35;
        cc_container.y = 305;
        //lineLength(lineHeight, lineRotation)
        lineLength(260, 0);
        /*----Angle 5----*/
        if (angle == 5) {
            mek_angle.x = 285;
            cc_container.x = 79;
            //cc_container.y = 305;
            //lineLength(lineHeight, lineRotation)
            lineLength(260, -10);
            //arrowLength(x,y,rotate)
            arrowLength(57, 180, 200);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(80, 185, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 70, 250);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-10, 470, -10, 370, -100, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(289, 420, 20, 32, -10);
        }
        /*----Angle 6----*/
        else if (angle == 6) {
            mek_angle.x = 290;
            cc_container.x = 96;
            //cc_container.y = 305; //315;
            //lineLength(lineHeight, lineRotation)
            lineLength(260, -14);
            //arrowLength(x,y,rotate)
            arrowLength(67, 180, 192);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(100, 185, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 70, 248);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-14, 465, -14, 370, -105, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(295, 415, 32, 44, -14);
        }
        /*----Angle 7----*/
        else if (angle == 7) {
            mek_angle.x = 295;
            cc_container.x = 107;
            //cc_container.y = 305; //320;
            //lineLength(lineHeight, lineRotation)
            lineLength(260, -16);
            //arrowLength(x,y,rotate)
            arrowLength(72, 180, 192);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(108, 190, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 90, 240);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-16, 460, -16, 370, -110, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(295, 410, 42, 54, -16);
        }
        /*----Angle 8----*/
        else if (angle == 8) {
            mek_angle.x = 300;
            cc_container.x = 126;
            //cc_container.y = 305; //330;
            //lineLength(lineHeight, lineRotation)
            lineLength(260, -20);
            //arrowLength(x,y,rotate)
            arrowLength(84, 180, 190);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(125, 195, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 100, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-20, 460, -20, 370, -112, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(295, 395, 58, 68, -20);
        }
        /*----Angle 9----*/
        else if (angle == 9) {
            mek_angle.x = 305;
            cc_container.x = 136;
            //cc_container.y = 305; //340;
            //lineLength(lineHeight, lineRotation)
            lineLength(280, -22);
            //arrowLength(x,y,rotate)
            arrowLength(88, 180, 188);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(135, 195, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 105, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-22, 460, -22, 370, -115, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(298, 395, 62, 72, -20);
        }
        /*----Angle 10----*/
        else if (angle == 10) {
            mek_angle.x = 308;
            cc_container.x = 142;
            //cc_container.y = 305; //360;
            //lineLength(lineHeight, lineRotation)
            lineLength(265, -23);
            //arrowLength(x,y,rotate)
            arrowLength(92, 180, 185);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(135, 195, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 108, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-23, 450, -23, 370, -115, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(304, 410, 70, 80, -23);
        }
        /*----Angle 11----*/
        else if (angle == 11) {
            mek_angle.x = 310;
            cc_container.x = 148;
            //cc_container.y = 305; //370;
            //lineLength(lineHeight, lineRotation)
            lineLength(270, -24);
            //arrowLength(x,y,rotate)
            arrowLength(94, 180, 188);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(145, 195, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 108, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-24, 440, -24, 370, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(308, 410, 70, 80, -24);
        }
        /*----Angle 12----*/
        else if (angle == 12) {
            mek_angle.x = 312;
            cc_container.x = 152;
            //cc_container.y = 305; //380;
            //lineLength(lineHeight, lineRotation)
            lineLength(270, -25);
            //arrowLength(x,y,rotate)
            arrowLength(97, 180, 185);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(150, 195, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 110, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-25, 435, -25, 370, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 395, 75, 85, -25);
        }
        /*----Angle 13----*/
        else if (angle == 13) {
            mek_angle.x = 312;
            cc_container.x = 159;
            //cc_container.y = 305; //385;
            //lineLength(lineHeight, lineRotation)
            lineLength(270, -26);
            //arrowLength(x,y,rotate)
            arrowLength(100, 180, 184);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(154, 195, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 115, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-26, 430, -26, 370, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 390, 78, 88, -26);
        }
        /*----Angle 14----*/
        else if (angle == 14) {
            mek_angle.x = 312;
            cc_container.x = 164;
            //cc_container.y = 305; //390;
            //lineLength(lineHeight, lineRotation)
            lineLength(280, -27);
            //arrowLength(x,y,rotate)
            arrowLength(102, 180, 184);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(157, 195, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 125, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-27, 420, -27, 370, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(295, 385, 85, 95, -27);
        }
        /*----Angle 15----*/
        else if (angle == 15) {
            mek_angle.x = 312;
            cc_container.x = 170;
            //cc_container.y = 305; //420;
            //lineLength(lineHeight, lineRotation)
            lineLength(280, -28);
            //arrowLength(x,y,rotate)
            arrowLength(105, 180, 183);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(162, 195, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 130, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-28, 420, -28, 370, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(295, 380, 85, 95, -28);
        }
    }
    /* --------- *********** --------- */
    /* --------- Length 0.2 --------- */
    /* --------- ********* --------- */
    if (length_l == 0.2) {
        dashedMainLine(10, 19.4, 35, -15, 1, 415);
        circles_container.y = 140;
        length_line_arrow_down.y = 240;
        mek_length.y = 200;
        //lineLength(lineHeight, lineRotation)
        lineLength(290, 0);
        //Initial Shape Positions
        cc_container.x = 35;
        cc_container.y = 330;
        /*----Angle 5----*/
        if (angle == 5) {
            mek_angle.x = 285;
            cc_container.x = 84;
            //cc_container.y = 305;
            //lineLength(lineHeight, lineRotation)
            lineLength(290, -10);
            //arrowLength(x,y,rotate)
            arrowLength(57, 180, 200);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(82, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 70, 250);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-10, 480, -10, 390, -100, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(289, 430, 20, 32, -10);
        }
        /*----Angle 6----*/
        else if (angle == 6) {
            mek_angle.x = 290;
            cc_container.x = 104;
            //cc_container.y = 305; //315;
            //lineLength(lineHeight, lineRotation)
            lineLength(290, -14);
            //arrowLength(x,y,rotate)
            arrowLength(67, 180, 192);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(100, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 70, 248);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-14, 485, -14, 390, -105, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(290, 415, 38, 50, -14);
        }
        /*----Angle 7----*/
        else if (angle == 7) {
            mek_angle.x = 295;
            cc_container.x = 114;
            //cc_container.y = 305; //320;
            //lineLength(lineHeight, lineRotation)
            lineLength(290, -16);
            //arrowLength(x,y,rotate)
            arrowLength(72, 180, 192);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(110, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 90, 240);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-16, 485, -16, 390, -110, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(295, 420, 43, 55, -16);
        }
        /*----Angle 8----*/
        else if (angle == 8) {
            mek_angle.x = 300;
            cc_container.x = 135;
            //cc_container.y = 305; //330;
            //lineLength(lineHeight, lineRotation)
            lineLength(290, -20);
            //arrowLength(x,y,rotate)
            arrowLength(84, 180, 190);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(135, 195, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 100, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-20, 485, -20, 390, -112, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(295, 410, 63, 71, -20);
        }
        /*----Angle 9----*/
        else if (angle == 9) {
            mek_angle.x = 305;
            cc_container.x = 148;
            //cc_container.y = 305; //340;
            //lineLength(lineHeight, lineRotation)
            lineLength(300, -22);
            //arrowLength(x,y,rotate)
            arrowLength(88, 180, 188);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(148, 195, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 105, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-22, 475, -22, 390, -115, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(295, 400, 68, 78, -20);
        }
        /*----Angle 10----*/
        else if (angle == 10) {
            mek_angle.x = 308;
            cc_container.x = 153;
            //cc_container.y = 305; //360;
            //lineLength(lineHeight, lineRotation)
            lineLength(300, -23);
            //arrowLength(x,y,rotate)
            arrowLength(92, 180, 185);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(145, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 108, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-23, 450, -23, 390, -115, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 415, 75, 85, -23);
        }
        /*----Angle 11----*/
        else if (angle == 11) {
            mek_angle.x = 310;
            cc_container.x = 160;
            //cc_container.y = 305; //370;
            //lineLength(lineHeight, lineRotation)
            lineLength(300, -24);
            //arrowLength(x,y,rotate)
            arrowLength(94, 180, 188);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(150, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 108, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-24, 450, -24, 390, -115, 214); //infoD(-24, 420, -24, 390, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(301, 420, 80, 90, -24);
        }
        /*----Angle 12----*/
        else if (angle == 12) {
            mek_angle.x = 312;
            cc_container.x = 165;
            //cc_container.y = 305; //380;
            //lineLength(lineHeight, lineRotation)
            lineLength(300, -25);
            //arrowLength(x,y,rotate)
            arrowLength(97, 180, 185);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(155, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 110, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-25, 445, -26, 390, -115, 214); //infoD(-25, 420, -25, 390, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(302, 415, 80, 90, -25);
        }
        /*----Angle 13----*/
        else if (angle == 13) {
            mek_angle.x = 312;
            cc_container.x = 171;
            //cc_container.y = 305; //385;
            //lineLength(lineHeight, lineRotation)
            lineLength(300, -26);
            //arrowLength(x,y,rotate)
            arrowLength(100, 180, 184);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(160, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 115, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-26, 445, -26, 390, -115, 214); //infoD(-26, 420, -26, 390, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 410, 85, 95, -26);
        }
        /*----Angle 14----*/
        else if (angle == 14) {
            mek_angle.x = 312;
            cc_container.x = 178;
            //cc_container.y = 305; //390;
            //lineLength(lineHeight, lineRotation)
            lineLength(315, -27);
            //arrowLength(x,y,rotate)
            arrowLength(102, 180, 184);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(167, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 125, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-27, 445, -27, 390, -115, 214); //infoD(-27, 420, -27, 390, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 410, 90, 102, -27);
        }
        /*----Angle 15----*/
        else if (angle == 15) {
            mek_angle.x = 312;
            cc_container.x = 184;
            //cc_container.y = 305; //420;
            //lineLength(lineHeight, lineRotation)
            lineLength(310, -28);
            //arrowLength(x,y,rotate)
            arrowLength(105, 180, 183);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(175, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 130, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-28, 445, -28, 390, -115, 214); //infoD(-28, 420, -28, 390, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(301, 410, 94, 106, -28);

        }
    }
    /* --------- *********** --------- */
    /* --------- Length 0.3 --------- */
    /* --------- ********* --------- */
    if (length_l == 0.3) {
        dashedMainLine(10, 19.5, 35, -15, 1, 490);
        circles_container.y = 160;
        length_line_arrow_down.y = 255;
        mek_length.y = 210;
        //lineLength(lineHeight, lineRotation)
        lineLength(310, 0);
        //Initial Shape Positions
        cc_container.x = 35;
        cc_container.y = 350;
        /*----Angle 5----*/
        if (angle == 5) {
            mek_angle.x = 285;
            cc_container.x = 87;
            //cc_container.y = 305;
            //lineLength(lineHeight, lineRotation)
            lineLength(310, -10);
            //arrowLength(x,y,rotate)
            arrowLength(57, 180, 200);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(83, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 70, 250);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-10, 495, -10, 410, -100, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(289, 440, 20, 32, -10);
        }
        /*----Angle 6----*/
        else if (angle == 6) {
            mek_angle.x = 290;
            cc_container.x = 108;
            //cc_container.y = 305; //315;
            //lineLength(lineHeight, lineRotation)
            lineLength(310, -14);
            //arrowLength(x,y,rotate)
            arrowLength(67, 180, 192);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(102, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 70, 248);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-14, 500, -14, 410, -105, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(289, 420, 38, 50, -14);
        }
        /*----Angle 7----*/
        else if (angle == 7) {
            mek_angle.x = 295;
            cc_container.x = 120;
            //cc_container.y = 305; //320;
            //lineLength(lineHeight, lineRotation)
            lineLength(310, -16);
            //arrowLength(x,y,rotate)
            arrowLength(72, 180, 192);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(115, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 90, 240);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-16, 500, -16, 410, -110, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(294, 430, 46, 58, -16);
        }
        /*----Angle 8----*/
        else if (angle == 8) {
            mek_angle.x = 300;
            cc_container.x = 144;
            //cc_container.y = 305; //330;
            //lineLength(lineHeight, lineRotation)
            lineLength(310, -20);
            //arrowLength(x,y,rotate)
            arrowLength(84, 180, 190);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(145, 195, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 100, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-20, 500, -20, 410, -112, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(294, 420, 66, 78, -20);
        }
        /*----Angle 9----*/
        else if (angle == 9) {
            mek_angle.x = 305;
            cc_container.x = 155;
            //cc_container.y = 305; //340;
            //lineLength(lineHeight, lineRotation)
            lineLength(320, -22);
            //arrowLength(x,y,rotate)
            arrowLength(88, 180, 188);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(152, 195, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 105, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-22, 500, -22, 410, -115, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(295, 420, 74, 84, -20);
        }
        /*----Angle 10----*/
        else if (angle == 10) {
            mek_angle.x = 308;
            cc_container.x = 162;
            //cc_container.y = 305; //360;
            //lineLength(lineHeight, lineRotation)
            lineLength(320, -23);
            //arrowLength(x,y,rotate)
            arrowLength(92, 180, 185);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(155, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 108, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-23, 460, -23, 410, -115, 214); //infoD(-23, 450, -23, 410, -115, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(295, 425, 80, 90, -23);
        }
        /*----Angle 11----*/
        else if (angle == 11) {
            mek_angle.x = 310;
            cc_container.x = 168;
            //cc_container.y = 305; //370;
            //lineLength(lineHeight, lineRotation)
            lineLength(320, -24);
            //arrowLength(x,y,rotate)
            arrowLength(94, 180, 188);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(160, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 108, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-24, 460, -24, 410, -115, 214); //infoD(-24, 450, -24, 410, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 430, 84, 94, -24);
        }
        /*----Angle 12----*/
        else if (angle == 12) {
            mek_angle.x = 312;
            cc_container.x = 174;
            //cc_container.y = 305; //380;
            //lineLength(lineHeight, lineRotation)
            lineLength(320, -25);
            //arrowLength(x,y,rotate)
            arrowLength(97, 180, 185);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(165, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 110, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-25, 455, -25, 410, -115, 214); //infoD(-25, 450, -25, 410, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 430, 88, 98, -25);
        }
        /*----Angle 13----*/
        else if (angle == 13) {
            mek_angle.x = 312;
            cc_container.x = 182;
            //cc_container.y = 305; //385;
            //lineLength(lineHeight, lineRotation)
            lineLength(325, -26);
            //arrowLength(x,y,rotate)
            arrowLength(100, 180, 184);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(170, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 115, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-26, 455, -26, 410, -115, 214); //infoD(-26, 450, -26, 410, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(301, 430, 92, 102, -26);
        }
        /*----Angle 14----*/
        else if (angle == 14) {
            mek_angle.x = 312;
            cc_container.x = 188;
            //cc_container.y = 305; //390;
            //lineLength(lineHeight, lineRotation)
            lineLength(335, -27);
            //arrowLength(x,y,rotate)
            arrowLength(102, 180, 184);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(175, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 125, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-27, 460, -27, 410, -115, 214); //infoD(-27, 450, -27, 410, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(301, 430, 98, 108, -27);
        }
        /*----Angle 15----*/
        else if (angle == 15) {
            mek_angle.x = 312;
            cc_container.x = 195;
            //cc_container.y = 305; //420;
            //lineLength(lineHeight, lineRotation)
            lineLength(335, -28);
            //arrowLength(x,y,rotate)
            arrowLength(105, 180, 183);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(182, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 130, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-28, 450, -28, 410, -115, 214); //infoD(-28, 450, -28, 410, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 420, 100, 110, -28);
        }
    }
    /* --------- *********** --------- */
    /* --------- Length 0.4 --------- */
    /* --------- ********* --------- */
    if (length_l == 0.4) {
        dashedMainLine(10, 19.5, 35, -15, 1, 490);
        circles_container.y = 180;
        length_line_arrow_down.y = 270;
        mek_length.y = 220;
        //lineLength(lineHeight, lineRotation)
        lineLength(330, 0);
        //Initial Shape Positions
        cc_container.x = 35;
        cc_container.y = 370;
        /*----Angle 5----*/
        if (angle == 5) {
            mek_angle.x = 285;
            cc_container.x = 90;
            //cc_container.y = 305;
            //lineLength(lineHeight, lineRotation)
            lineLength(330, -10);
            //arrowLength(x,y,rotate)
            arrowLength(57, 180, 200);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(88, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 70, 250);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-10, 515, -10, 430, -100, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(289, 450, 22, 34, -10);
        }
        /*----Angle 6----*/
        else if (angle == 6) {
            mek_angle.x = 290;
            cc_container.x = 114;
            //cc_container.y = 305; //315;
            //lineLength(lineHeight, lineRotation)
            lineLength(330, -14);
            //arrowLength(x,y,rotate)
            arrowLength(67, 180, 192);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(108, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 70, 248);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-14, 505, -14, 430, -105, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(288, 435, 42, 54, -14);
        }
        /*----Angle 7----*/
        else if (angle == 7) {
            mek_angle.x = 295;
            cc_container.x = 127;
            //cc_container.y = 305; //320;
            //lineLength(lineHeight, lineRotation)
            lineLength(330, -16);
            //arrowLength(x,y,rotate)
            arrowLength(72, 180, 192);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(120, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 90, 240);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-16, 505, -16, 430, -110, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(294, 450, 50, 62, -16);
        }
        /*----Angle 8----*/
        else if (angle == 8) {
            mek_angle.x = 300;
            cc_container.x = 151;
            //cc_container.y = 305; //330;
            //lineLength(lineHeight, lineRotation)
            lineLength(330, -20);
            //arrowLength(x,y,rotate)
            arrowLength(84, 180, 190);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(148, 195, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 100, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-20, 505, -20, 430, -112, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(294, 440, 70, 82, -20);
        }
        /*----Angle 9----*/
        else if (angle == 9) {
            mek_angle.x = 305;
            cc_container.x = 163;
            //cc_container.y = 305; //340;
            //lineLength(lineHeight, lineRotation)
            lineLength(345, -22);
            //arrowLength(x,y,rotate)
            arrowLength(88, 180, 188);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(155, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 105, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-22, 505, -22, 430, -112, 214); //infoD(-22, 470, -22, 430, -115, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(295, 440, 80, 90, -20);
        }
        /*----Angle 10----*/
        else if (angle == 10) {
            mek_angle.x = 308;
            cc_container.x = 171;
            //cc_container.y = 305; //360;
            //lineLength(lineHeight, lineRotation)
            lineLength(345, -23);
            //arrowLength(x,y,rotate)
            arrowLength(92, 180, 185);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(160, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 108, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-23, 480, -23, 430, -112, 214); //infoD(-23, 470, -23, 430, -115, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(295, 440, 85, 95, -23);
        }
        /*----Angle 11----*/
        else if (angle == 11) {
            mek_angle.x = 310;
            cc_container.x = 177;
            //cc_container.y = 305; //370;
            //lineLength(lineHeight, lineRotation)
            lineLength(345, -24);
            //arrowLength(x,y,rotate)
            arrowLength(94, 180, 188);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(165, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 108, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-24, 480, -24, 430, -112, 214); //infoD(-24, 470, -24, 430, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(298, 440, 88, 98, -24);
        }
        /*----Angle 12----*/
        else if (angle == 12) {
            mek_angle.x = 312;
            cc_container.x = 184;
            //cc_container.y = 305; //380;
            //lineLength(lineHeight, lineRotation)
            lineLength(345, -25);
            //arrowLength(x,y,rotate)
            arrowLength(97, 180, 185);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(175, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 110, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-25, 480, -25, 430, -112, 214); //infoD(-25, 470, -25, 430, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(298, 440, 92, 102, -25);
        }
        /*----Angle 13----*/
        else if (angle == 13) {
            mek_angle.x = 312;
            cc_container.x = 192;
            //cc_container.y = 305; //385;
            //lineLength(lineHeight, lineRotation)
            lineLength(345, -26);
            //arrowLength(x,y,rotate)
            arrowLength(100, 180, 184);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(180, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 115, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-26, 480, -26, 430, -114, 214); //infoD(-26, 470, -26, 430, -118, 214);
            dMathInfo(298, 440, 98, 110, -26);
        }
        /*----Angle 14----*/
        else if (angle == 14) {
            cc_container.x = 198;
            //cc_container.y = 305; //390;
            //lineLength(lineHeight, lineRotation)
            lineLength(360, -27);
            //arrowLength(x,y,rotate)
            arrowLength(102, 180, 184);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(185, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 125, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-27, 480, -27, 430, -114, 214); //infoD(-27, 470, -27, 430, -118, 214);
            dMathInfo(298, 440, 104, 114, -27);
        }
        /*----Angle 15----*/
        else if (angle == 15) {
            cc_container.x = 205;
            //cc_container.y = 305; //420;
            //lineLength(lineHeight, lineRotation)
            lineLength(360, -28);
            //arrowLength(x,y,rotate)
            arrowLength(105, 180, 183);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(194, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 130, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-28, 480, -28, 430, -114, 214); //infoD(-28, 470, -28, 430, -118, 214);
            dMathInfo(299, 440, 108, 120, -28);
        }
    }
    /* --------- *********** --------- */
    /* --------- Length 0.5 --------- */
    /* --------- ********* --------- */
    if (length_l == 0.5) {
        dashedMainLine(10, 19.5, 35, -15, 1, 490);
        circles_container.y = 200;
        length_line_arrow_down.y = 290;
        mek_length.y = 225;
        //lineLength(lineHeight, lineRotation)
        lineLength(350, 0);
        //Initial Shape Positions
        cc_container.x = 35;
        cc_container.y = 390;
        /*----Angle 5----*/
        if (angle == 5) {
            mek_angle.x = 285;
            cc_container.x = 94;
            //cc_container.y = 305;
            //lineLength(lineHeight, lineRotation)
            lineLength(350, -10);
            //arrowLength(x,y,rotate)
            arrowLength(57, 180, 200);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(90, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 70, 250);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-10, 540, -10, 450, -100, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(288, 460, 24, 36, -10);
        }
        /*----Angle 6----*/
        else if (angle == 6) {
            mek_angle.x = 290;
            cc_container.x = 119;
            //cc_container.y = 305; //315;
            //lineLength(lineHeight, lineRotation)
            lineLength(350, -14);
            //arrowLength(x,y,rotate)
            arrowLength(67, 180, 192);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(112, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 70, 248);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-14, 540, -14, 450, -105, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(288, 450, 46, 58, -14);
        }
        /*----Angle 7----*/
        else if (angle == 7) {
            mek_angle.x = 295;
            cc_container.x = 132;
            //cc_container.y = 305; //320;
            //lineLength(lineHeight, lineRotation)
            lineLength(350, -16);
            //arrowLength(x,y,rotate)
            arrowLength(72, 180, 192);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(125, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 90, 240);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-16, 540, -16, 450, -110, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(294, 460, 52, 64, -16);
        }
        /*----Angle 8----*/
        else if (angle == 8) {
            mek_angle.x = 300;
            cc_container.x = 159;
            //cc_container.y = 305; //330;
            //lineLength(lineHeight, lineRotation)
            lineLength(350, -20);
            //arrowLength(x,y,rotate)
            arrowLength(84, 180, 190);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(155, 195, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 100, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-20, 540, -20, 450, -112, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(294, 450, 72, 84, -20);
        }
        /*----Angle 9----*/
        else if (angle == 9) {
            mek_angle.x = 305;
            cc_container.x = 172;
            //cc_container.y = 305; //340;
            //lineLength(lineHeight, lineRotation)
            lineLength(365, -22);
            //arrowLength(x,y,rotate)
            arrowLength(88, 180, 188);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(165, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 105, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-22, 535, -22, 450, -115, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(298, 460, 84, 94, -20);
        }
        /*----Angle 10----*/
        else if (angle == 10) {
            mek_angle.x = 308;
            cc_container.x = 179;
            //cc_container.y = 305; //360;
            //lineLength(lineHeight, lineRotation)
            lineLength(365, -23);
            //arrowLength(x,y,rotate)
            arrowLength(92, 180, 185);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(170, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 108, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-23, 530, -23, 450, -115, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(298, 460, 88, 98, -23);
        }
        /*----Angle 11----*/
        else if (angle == 11) {
            mek_angle.x = 310;
            cc_container.x = 186;
            //cc_container.y = 305; //370;
            //lineLength(lineHeight, lineRotation)
            lineLength(365, -24);
            //arrowLength(x,y,rotate)
            arrowLength(94, 180, 188);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(175, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 108, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-24, 525, -24, 450, -115, 214); // infoD(-24, 470, -24, 450, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(298, 460, 94, 104, -24);
        }
        /*----Angle 12----*/
        else if (angle == 12) {
            mek_angle.x = 312;
            cc_container.x = 193;
            //cc_container.y = 305; //380;
            //lineLength(lineHeight, lineRotation)
            lineLength(365, -25);
            //arrowLength(x,y,rotate)
            arrowLength(97, 180, 185);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(185, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 110, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-25, 520, -25, 450, -115, 214); //infoD(-25, 470, -25, 450, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(298, 460, 100, 110, -25);
        }
        /*----Angle 13----*/
        else if (angle == 13) {
            mek_angle.x = 312;
            cc_container.x = 201;
            //cc_container.y = 305; //385;
            //lineLength(lineHeight, lineRotation)
            lineLength(370, -26);
            //arrowLength(x,y,rotate)
            arrowLength(100, 180, 184);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(192, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 115, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-26, 520, -26, 450, -115, 214); // infoD(-26, 470, -26, 450, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 460, 105, 115, -26);
        }
        /*----Angle 14----*/
        else if (angle == 14) {
            mek_angle.x = 312;
            cc_container.x = 208;
            //cc_container.y = 305; //390;
            //lineLength(lineHeight, lineRotation)
            lineLength(380, -27);
            //arrowLength(x,y,rotate)
            arrowLength(102, 180, 184);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(195, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 125, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-27, 515, -27, 450, -115, 214); //infoD(-27, 470, -27, 450, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 460, 110, 120, -27);
        }
        /*----Angle 15----*/
        else if (angle == 15) {
            mek_angle.x = 312;
            cc_container.x = 215;
            //cc_container.y = 305; //420;
            //lineLength(lineHeight, lineRotation)
            lineLength(380, -28);
            //arrowLength(x,y,rotate)
            arrowLength(105, 180, 183);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(202, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 130, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-28, 520, -28, 450, -115, 214); //infoD(-28, 470, -28, 450, -118, 214);
            dMathInfo(300, 460, 115, 138, -28);
        }
    }
    /* --------- *********** --------- */
    /* --------- Length 0.6 --------- */
    /* --------- ********* --------- */
    if (length_l == 0.6) {
        dashedMainLine(10, 19.5, 35, -15, 1, 520);
        circles_container.y = 220;
        length_line_arrow_down.y = 305;
        mek_length.y = 230;
        //lineLength(lineHeight, lineRotation)
        lineLength(370, 0);
        //Initial Shape Positions
        cc_container.x = 35;
        cc_container.y = 410;
        /*----Angle 5----*/
        if (angle == 5) {
            mek_angle.x = 285;
            cc_container.x = 97;
            //cc_container.y = 305;
            //lineLength(lineHeight, lineRotation)
            lineLength(370, -10);
            //arrowLength(x,y,rotate)
            arrowLength(57, 180, 200);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(92, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 70, 250);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-10, 560, -10, 470, -100, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(287, 470, 26, 38, -10);
        }
        /*----Angle 6----*/
        else if (angle == 6) {
            mek_angle.x = 290;
            cc_container.x = 123;
            //cc_container.y = 305; //315;
            //lineLength(lineHeight, lineRotation)
            lineLength(370, -14);
            //arrowLength(x,y,rotate)
            arrowLength(67, 180, 192);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(118, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 70, 248);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-14, 560, -14, 470, -105, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(288, 465, 48, 60, -14);
        }
        /*----Angle 7----*/
        else if (angle == 7) {
            cc_container.x = 137;
            mek_angle.x = 295;
            //cc_container.y = 305; //320;
            //lineLength(lineHeight, lineRotation)
            lineLength(370, -16);
            //arrowLength(x,y,rotate)
            arrowLength(72, 180, 192);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(130, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 90, 240);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-16, 560, -16, 470, -110, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 560, 70, 80, -35);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(290, 470, 58, 70, -16);
        }
        /*----Angle 8----*/
        else if (angle == 8) {
            cc_container.x = 165;
            mek_angle.x = 300;
            //cc_container.y = 305; //330;
            //lineLength(lineHeight, lineRotation)
            lineLength(370, -20);
            //arrowLength(x,y,rotate)
            arrowLength(84, 180, 190);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(160, 195, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 100, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-20, 560, -20, 470, -112, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(295, 470, 78, 90, -20);
        }
        /*----Angle 9----*/
        else if (angle == 9) {
            mek_angle.x = 305;
            cc_container.x = 180;
            //cc_container.y = 305; //340;
            //lineLength(lineHeight, lineRotation)
            lineLength(395, -22);
            //arrowLength(x,y,rotate)
            arrowLength(88, 180, 188);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(170, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 105, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-22, 555, -22, 470, -112, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 480, 88, 100, -20);
        }
        /*----Angle 10----*/
        else if (angle == 10) {
            mek_angle.x = 308;
            cc_container.x = 188;
            //cc_container.y = 305; //360;
            //lineLength(lineHeight, lineRotation)
            lineLength(395, -23);
            //arrowLength(x,y,rotate)
            arrowLength(92, 180, 185);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(180, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 108, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-23, 540, -23, 470, -115, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(295, 470, 94, 104, -23);
        }
        /*----Angle 11----*/
        else if (angle == 11) {
            mek_angle.x = 310;
            cc_container.x = 195;
            //cc_container.y = 305; //370;
            //lineLength(lineHeight, lineRotation)
            lineLength(395, -24);
            //arrowLength(x,y,rotate)
            arrowLength(94, 180, 188);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(185, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 108, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-24, 520, -24, 470, -115, 214); //infoD(-24, 490, -24, 470, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 480, 98, 108, -24);
        }
        /*----Angle 12----*/
        else if (angle == 12) {
            mek_angle.x = 312;
            cc_container.x = 202;
            //cc_container.y = 305; //380;
            //lineLength(lineHeight, lineRotation)
            lineLength(395, -25);
            //arrowLength(x,y,rotate)
            arrowLength(97, 180, 185);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(195, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 110, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-25, 520, -25, 470, -115, 214); //infoD(-25, 490, -25, 470, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(296, 470, 105, 115, -25);
        }
        /*----Angle 13----*/
        else if (angle == 13) {
            mek_angle.x = 312;
            cc_container.x = 210;
            //cc_container.y = 305; //385;
            //lineLength(lineHeight, lineRotation)
            lineLength(395, -26);
            //arrowLength(x,y,rotate)
            arrowLength(100, 180, 184);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(200, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 115, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-26, 520, -26, 470, -115, 214); //infoD(-26, 490, -26, 470, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 470, 108, 118, -26);
        }
        /*----Angle 14----*/
        else if (angle == 14) {
            mek_angle.x = 312;
            cc_container.x = 218;
            //cc_container.y = 305; //390;
            //lineLength(lineHeight, lineRotation)
            lineLength(400, -27);
            //arrowLength(x,y,rotate)
            arrowLength(102, 180, 184);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(210, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 125, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-27, 540, -27, 470, -115, 214); //infoD(-27, 490, -27, 470, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 470, 114, 120, -27);
        }
        /*----Angle 15----*/
        else if (angle == 15) {
            mek_angle.x = 312;
            cc_container.x = 226;
            //cc_container.y = 305; //420;
            //lineLength(lineHeight, lineRotation)
            lineLength(400, -28);
            //arrowLength(x,y,rotate)
            arrowLength(105, 180, 183);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(215, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 130, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-28, 510, -28, 470, -115, 214); //infoD(-28, 490, -28, 470, -118, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(295, 460, 120, 140, -28);
        }
    }
    /* --------- *********** --------- */
    /* --------- Length 0.7 --------- */
    /* --------- ********* --------- */
    if (length_l == 0.7) {
        dashedMainLine(10, 19.5, 35, -15, 1, 520);
        circles_container.y = 240;
        length_line_arrow_down.y = 320;
        mek_length.y = 245;
        //lineLength(lineHeight, lineRotation)
        lineLength(390, 0);
        //Initial Shape Positions
        cc_container.x = 35;
        cc_container.y = 430;
        /*----Angle 5----*/
        if (angle == 5) {
            mek_angle.x = 285;
            cc_container.x = 100;
            //cc_container.y = 305;
            //lineLength(lineHeight, lineRotation)
            lineLength(390, -10);
            //arrowLength(x,y,rotate)
            arrowLength(57, 180, 200);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(94, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 70, 250);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-10, 580, -10, 490, -100, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(285, 480, 30, 42, -10);
        }
        /*----Angle 6----*/
        else if (angle == 6) {
            mek_angle.x = 290;
            cc_container.x = 129;
            //cc_container.y = 305; //315;
            //lineLength(lineHeight, lineRotation)
            lineLength(390, -14);
            //arrowLength(x,y,rotate)
            arrowLength(67, 180, 192);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(120, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 70, 248);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-14, 580, -14, 490, -105, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(288, 480, 50, 62, -14);
        }
        /*----Angle 7----*/
        else if (angle == 7) {
            mek_angle.x = 295;
            cc_container.x = 143;
            //cc_container.y = 305; //320;
            //lineLength(lineHeight, lineRotation)
            lineLength(390, -16);
            //arrowLength(x,y,rotate)
            arrowLength(72, 180, 192);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(135, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 90, 240);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-16, 580, -16, 490, -110, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(291, 490, 62, 74, -16);
        }
        /*----Angle 8----*/
        else if (angle == 8) {
            mek_angle.x = 300;
            cc_container.x = 172;
            //cc_container.y = 305; //330;
            //lineLength(lineHeight, lineRotation)
            lineLength(395, -20);
            //arrowLength(x,y,rotate)
            arrowLength(84, 180, 190);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(168, 195, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 100, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-20, 575, -20, 490, -112, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(296, 490, 82, 94, -20);
        }
        /*----Angle 9----*/
        else if (angle == 9) {
            mek_angle.x = 305;
            cc_container.x = 188;
            //cc_container.y = 305; //340;
            //lineLength(lineHeight, lineRotation)
            lineLength(405, -22);
            //arrowLength(x,y,rotate)
            arrowLength(88, 180, 188);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(178, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 105, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-22, 570, -22, 490, -112, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 490, 90, 102, -20);
        }
        /*----Angle 10----*/
        else if (angle == 10) {
            mek_angle.x = 308;
            cc_container.x = 196;
            //cc_container.y = 305; //360;
            //lineLength(lineHeight, lineRotation)
            lineLength(405, -23);
            //arrowLength(x,y,rotate)
            arrowLength(92, 180, 185);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(188, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 108, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-23, 570, -23, 490, -112, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(295, 480, 98, 108, -23);
        }
        /*----Angle 11----*/
        else if (angle == 11) {
            mek_angle.x = 310;
            cc_container.x = 204;
            //cc_container.y = 305; //370;
            //lineLength(lineHeight, lineRotation)
            lineLength(405, -24);
            //arrowLength(x,y,rotate)
            arrowLength(94, 180, 188);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(195, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 108, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-24, 540, -24, 490, -112, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(295, 480, 102, 112, -24);
        }
        /*----Angle 12----*/
        else if (angle == 12) {
            mek_angle.x = 312;
            cc_container.x = 212;
            //cc_container.y = 305; //380;
            //lineLength(lineHeight, lineRotation)
            lineLength(410, -25);
            //arrowLength(x,y,rotate)
            arrowLength(97, 180, 185);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(200, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 110, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-25, 540, -25, 490, -112, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 490, 110, 120, -25);
        }
        /*----Angle 13----*/
        else if (angle == 13) {
            mek_angle.x = 312;
            cc_container.x = 220;
            //cc_container.y = 305; //385;
            //lineLength(lineHeight, lineRotation)
            lineLength(420, -26);
            //arrowLength(x,y,rotate)
            arrowLength(100, 180, 184);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(210, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 115, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-26, 540, -26, 490, -112, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 490, 114, 124, -26);
        }
        /*----Angle 14----*/
        else if (angle == 14) {
            mek_angle.x = 312;
            cc_container.x = 228;
            //cc_container.y = 305; //390;
            //lineLength(lineHeight, lineRotation)
            lineLength(420, -27);
            //arrowLength(x,y,rotate)
            arrowLength(102, 180, 184);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(215, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 125, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-27, 540, -27, 490, -112, 234);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 490, 120, 128, -27);
        }
        /*----Angle 15----*/
        else if (angle == 15) {
            mek_angle.x = 312;
            cc_container.x = 238;
            //cc_container.y = 305; //420;
            //lineLength(lineHeight, lineRotation)
            lineLength(420, -28);
            //arrowLength(x,y,rotate)
            arrowLength(105, 180, 183);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(225, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 130, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-28, 540, -28, 490, -112, 276);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 490, 128, 150, -28);
        }
    }
    /* --------- *********** --------- */
    /* --------- Length 0.8 --------- */
    /* --------- ********* --------- */
    if (length_l == 0.8) {
        dashedMainLine(10, 19.52, 35, -15, 1, 550);
        circles_container.y = 260;
        length_line_arrow_down.y = 335;
        mek_length.y = 250;
        //lineLength(lineHeight, lineRotation)
        lineLength(420, 0);
        //Initial Shape Positions
        cc_container.x = 35;
        cc_container.y = 450;
        /*----Angle 5----*/
        if (angle == 5) {
            mek_angle.x = 285;
            cc_container.x = 105;
            //cc_container.y = 305;
            //lineLength(lineHeight, lineRotation)
            lineLength(420, -10);
            //arrowLength(x,y,rotate)
            arrowLength(57, 180, 200);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(100, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 70, 250);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-10, 590, -10, 510, -100, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(285, 495, 32, 44, -10);
        }
        /*----Angle 6----*/
        else if (angle == 6) {
            mek_angle.x = 290;
            cc_container.x = 134;
            //cc_container.y = 305; //315;
            //lineLength(lineHeight, lineRotation)
            lineLength(420, -14);
            //arrowLength(x,y,rotate)
            arrowLength(67, 180, 192);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(126, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 70, 248);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-14, 590, -14, 510, -105, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(288, 495, 54, 66, -14);
        }
        /*----Angle 7----*/
        else if (angle == 7) {
            mek_angle.x = 295;
            cc_container.x = 148;
            //cc_container.y = 305; //320;
            //lineLength(lineHeight, lineRotation)
            lineLength(420, -16);
            //arrowLength(x,y,rotate)
            arrowLength(72, 180, 192);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(142, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 90, 240);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-16, 590, -16, 510, -110, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(292, 510, 66, 78, -16);
        }
        /*----Angle 8----*/
        else if (angle == 8) {
            mek_angle.x = 300;
            cc_container.x = 180;
            //cc_container.y = 305; //330;
            //lineLength(lineHeight, lineRotation)
            lineLength(420, -20);
            //arrowLength(x,y,rotate)
            arrowLength(84, 180, 190);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(175, 195, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 100, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-20, 590, -20, 510, -110, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(296, 510, 86, 98, -20);
        }
        /*----Angle 9----*/
        else if (angle == 9) {
            mek_angle.x = 305;
            cc_container.x = 196;
            //cc_container.y = 305; //340;
            //lineLength(lineHeight, lineRotation)
            lineLength(435, -22);
            //arrowLength(x,y,rotate)
            arrowLength(88, 180, 188);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(185, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 105, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-22, 585, -22, 510, -110, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 510, 96, 108, -20);
        }
        /*----Angle 10----*/
        else if (angle == 10) {
            mek_angle.x = 308;
            cc_container.x = 204;
            //cc_container.y = 305; //360;
            //lineLength(lineHeight, lineRotation)
            lineLength(435, -23);
            //arrowLength(x,y,rotate)
            arrowLength(92, 180, 185);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(198, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 108, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-23, 580, -23, 510, -110, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 510, 102, 112, -23);
        }
        /*----Angle 11----*/
        else if (angle == 11) {
            mek_angle.x = 310;
            cc_container.x = 212;
            //cc_container.y = 305; //370;
            //lineLength(lineHeight, lineRotation)
            lineLength(435, -24);
            //arrowLength(x,y,rotate)
            arrowLength(94, 180, 188);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(202, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 108, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-24, 580, -24, 510, -110, 276);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(305, 520, 110, 120, -24);
        }
        /*----Angle 12----*/
        else if (angle == 12) {
            mek_angle.x = 312;
            cc_container.x = 221;
            //cc_container.y = 305; //380;
            //lineLength(lineHeight, lineRotation)
            lineLength(435, -25);
            //arrowLength(x,y,rotate)
            arrowLength(97, 180, 185);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(210, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 110, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-25, 580, -26, 510, -110, 276);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(306, 520, 114, 124, -25);
        }
        /*----Angle 13----*/
        else if (angle == 13) {
            mek_angle.x = 312;
            cc_container.x = 230;
            //cc_container.y = 305; //385;
            //lineLength(lineHeight, lineRotation)
            lineLength(435, -26);
            //arrowLength(x,y,rotate)
            arrowLength(100, 180, 184);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(217, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 115, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-26, 550, -26, 510, -110, 276);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(308, 520, 120, 128, -26);
        }
        /*----Angle 14----*/
        else if (angle == 14) {
            mek_angle.x = 312;
            cc_container.x = 238;
            //cc_container.y = 305; //390;
            //lineLength(lineHeight, lineRotation)
            lineLength(440, -27);
            //arrowLength(x,y,rotate)
            arrowLength(102, 180, 184);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(225, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 125, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-27, 585, -27, 510, -110, 276);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(308, 520, 128, 150, -27);
        }
        /*----Angle 15----*/
        else if (angle == 15) {
            mek_angle.x = 312;
            cc_container.x = 248;
            //cc_container.y = 305; //420;
            //lineLength(lineHeight, lineRotation)
            lineLength(445, -28);
            //arrowLength(x,y,rotate)
            arrowLength(105, 180, 183);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(237, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 130, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-28, 550, -28, 510, -110, 276);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(308, 520, 132, 152, -28);
        }
    }
    /* --------- *********** --------- */
    /* --------- Length 0.9 --------- */
    /* --------- ********* --------- */
    if (length_l == 0.9) {
        dashedMainLine(10, 19.52, 35, -15, 1, 550);
        circles_container.y = 280;
        length_line_arrow_down.y = 350;
        mek_length.y = 255;
        //lineLength(lineHeight, lineRotation)
        lineLength(440, 0);
        //Initial Shape Positions
        cc_container.x = 35;
        cc_container.y = 470;
        /*----Angle 5----*/
        if (angle == 5) {
            mek_angle.x = 285;
            cc_container.x = 108;
            //cc_container.y = 305;
            //lineLength(lineHeight, lineRotation)
            lineLength(440, -10);
            //arrowLength(x,y,rotate)
            arrowLength(57, 180, 200);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(102, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 70, 250);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-10, 600, -10, 530, -100, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(284, 510, 36, 48, -10);
        }
        /*----Angle 6----*/
        else if (angle == 6) {
            mek_angle.x = 290;
            cc_container.x = 138;
            //cc_container.y = 305; //315;
            //lineLength(lineHeight, lineRotation)
            lineLength(440, -14);
            //arrowLength(x,y,rotate)
            arrowLength(67, 180, 192);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(132, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 70, 248);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-14, 600, -14, 530, -105, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(288, 510, 58, 70, -14);
        }
        /*----Angle 7----*/
        else if (angle == 7) {
            mek_angle.x = 295;
            cc_container.x = 153;
            //cc_container.y = 305; //320;
            //lineLength(lineHeight, lineRotation)
            lineLength(440, -16);
            //arrowLength(x,y,rotate)
            arrowLength(72, 180, 192);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(150, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 90, 240);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-16, 600, -16, 530, -110, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(294, 530, 70, 82, -16);
        }
        /*----Angle 8----*/
        else if (angle == 8) {
            mek_angle.x = 300;
            cc_container.x = 188;
            //cc_container.y = 305; //330;
            //lineLength(lineHeight, lineRotation)
            lineLength(440, -20);
            //arrowLength(x,y,rotate)
            arrowLength(84, 180, 190);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(182, 195, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 100, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-20, 600, -20, 530, -112, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(298, 530, 92, 104, -20);
        }
        /*----Angle 9----*/
        else if (angle == 9) {
            mek_angle.x = 305;
            cc_container.x = 204;
            //cc_container.y = 305; //340;
            //lineLength(lineHeight, lineRotation)
            lineLength(455, -22);
            //arrowLength(x,y,rotate)
            arrowLength(88, 180, 188);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(200, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 105, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-22, 595, -22, 530, -115, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 530, 104, 114, -20);
        }
        /*----Angle 10----*/
        else if (angle == 10) {
            mek_angle.x = 308;
            cc_container.x = 210;
            //cc_container.y = 305; //360;
            //lineLength(lineHeight, lineRotation)
            lineLength(455, -23);
            //arrowLength(x,y,rotate)
            arrowLength(92, 180, 185);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(205, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 108, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-23, 580, -23, 530, -115, 276);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 530, 110, 120, -23);
        }
        /*----Angle 11----*/
        else if (angle == 11) {
            mek_angle.x = 310;
            cc_container.x = 222;
            //cc_container.y = 305; //370;
            //lineLength(lineHeight, lineRotation)
            lineLength(455, -24);
            //arrowLength(x,y,rotate)
            arrowLength(94, 180, 188);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(210, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 108, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-24, 580, -24, 530, -115, 276);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(304, 530, 112, 122, -24);
        }
        /*----Angle 12----*/
        else if (angle == 12) {
            mek_angle.x = 312;
            cc_container.x = 230;
            //cc_container.y = 305; //380;
            //lineLength(lineHeight, lineRotation)
            lineLength(455, -25);
            //arrowLength(x,y,rotate)
            arrowLength(97, 180, 185);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(217, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 110, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-25, 580, -25, 530, -115, 276);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(304, 530, 120, 128, -25);
        }
        /*----Angle 13----*/
        else if (angle == 13) {
            mek_angle.x = 312;
            cc_container.x = 239;
            //cc_container.y = 305; //385;
            //lineLength(lineHeight, lineRotation)
            lineLength(455, -26);
            //arrowLength(x,y,rotate)
            arrowLength(100, 180, 184);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(227, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 115, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-26, 580, -26, 530, -115, 276);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(306, 530, 124, 132, -26);
        }
        /*----Angle 14----*/
        else if (angle == 14) {
            mek_angle.x = 312;
            cc_container.x = 248;
            //cc_container.y = 305; //390;
            //lineLength(lineHeight, lineRotation)
            lineLength(480, -27);
            //arrowLength(x,y,rotate)
            arrowLength(102, 180, 184);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(235, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 125, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-27, 580, -27, 530, -115, 276);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(304, 530, 132, 154, -27);
        }
        /*----Angle 15----*/
        else if (angle == 15) {
            mek_angle.x = 312;
            cc_container.x = 258;
            //cc_container.y = 305; //420;
            //lineLength(lineHeight, lineRotation)
            lineLength(480, -28);
            //arrowLength(x,y,rotate)
            arrowLength(105, 180, 183);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(247, 200, 35, 300);
            //Angle Curve
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-28, 580, -28, 530, -115, 276);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(304, 530, 138, 160, -28);
        }
    }
    /* --------- ********* --------- */
    /* --------- Length 1 --------- */
    /* --------- ******* --------- */
    if (length_l == 1) {
        dashedMainLine(10, 19.8, 35, -15, 1, 600);
        circles_container.y = 300;
        length_line_arrow_down.y = 365;
        mek_length.y = 265;
        //lineLength(lineHeight, lineRotation)
        lineLength(450, 0);
        //Initial Shape Positions
        cc_container.x = 35;
        cc_container.y = 490;
        /*----Angle 5----*/
        if (angle == 5) {
            mek_angle.x = 285;
            cc_container.x = 112;
            //cc_container.y = 305;
            //lineLength(lineHeight, lineRotation)
            lineLength(450, -10);
            //arrowLength(x,y,rotate)
            arrowLength(57, 180, 200);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(105, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 70, 250);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-10, 645, -10, 550, -100, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(284, 525, 36, 48, -10);
        }
        /*----Angle 6----*/
        else if (angle == 6) {
            mek_angle.x = 290;
            cc_container.x = 144;
            //cc_container.y = 305; //315;
            //lineLength(lineHeight, lineRotation)
            lineLength(450, -14);
            //arrowLength(x,y,rotate)
            arrowLength(67, 180, 192);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(139, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 70, 248);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-14, 645, -14, 550, -105, 150);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(288, 525, 61, 73, -14);
        }
        /*----Angle 7----*/
        else if (angle == 7) {
            mek_angle.x = 295;
            cc_container.x = 158;
            //cc_container.y = 305; //320;
            //lineLength(lineHeight, lineRotation)
            lineLength(450, -16);
            //arrowLength(x,y,rotate)
            arrowLength(72, 180, 192);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(152, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 90, 240);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-16, 645, -16, 550, -110, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(294, 550, 76, 88, -16);
        }
        /*----Angle 8----*/
        else if (angle == 8) {
            mek_angle.x = 300;
            cc_container.x = 194;
            //cc_container.y = 305; //330;
            //lineLength(lineHeight, lineRotation)
            lineLength(470, -20);
            //arrowLength(x,y,rotate)
            arrowLength(84, 180, 190);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(190, 195, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 100, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-20, 635, -20, 550, -112, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 550, 98, 110, -20);
        }
        /*----Angle 9----*/
        else if (angle == 9) {
            mek_angle.x = 305;
            cc_container.x = 212;
            //cc_container.y = 305; //340;
            //lineLength(lineHeight, lineRotation)
            lineLength(480, -22);
            //arrowLength(x,y,rotate)
            arrowLength(88, 180, 188);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(205, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 105, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-22, 625, -22, 550, -115, 214);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(299, 540, 108, 120, -20);

        }
        /*----Angle 10----*/
        else if (angle == 10) {
            mek_angle.x = 308;
            cc_container.x = 220;
            //cc_container.y = 305; //360;
            //lineLength(lineHeight, lineRotation)
            lineLength(480, -23);
            //arrowLength(x,y,rotate)
            arrowLength(92, 180, 185);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(215, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 108, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-23, 600, -23, 550, -115, 276);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 540, 112, 122, -23);
        }
        /*----Angle 11----*/
        else if (angle == 11) {
            mek_angle.x = 310;
            cc_container.x = 230;
            //cc_container.y = 305; //370;
            //lineLength(lineHeight, lineRotation)
            lineLength(480, -24);
            //arrowLength(x,y,rotate)
            arrowLength(94, 180, 188);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(217, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 108, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-24, 600, -24, 550, -115, 276);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 540, 120, 128, -24);
        }
        /*----Angle 12----*/
        else if (angle == 12) {
            mek_angle.x = 312;
            cc_container.x = 238;
            //cc_container.y = 305; //380;
            //lineLength(lineHeight, lineRotation)
            lineLength(480, -25);
            //arrowLength(x,y,rotate)
            arrowLength(97, 180, 185);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(227, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 110, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-25, 580, -25, 550, -115, 276);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 540, 126, 134, -25);
        }
        /*----Angle 13----*/
        else if (angle == 13) {
            mek_angle.x = 312;
            cc_container.x = 247;
            //cc_container.y = 305; //385;
            //lineLength(lineHeight, lineRotation)
            lineLength(480, -26);
            //arrowLength(x,y,rotate)
            arrowLength(100, 180, 184);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(237, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 115, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-26, 605, -26, 550, -115, 276);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 540, 134, 158, -26);
        }
        /*----Angle 14----*/
        else if (angle == 14) {
            mek_angle.x = 312;
            cc_container.x = 260;
            //cc_container.y = 305; //390;
            //lineLength(lineHeight, lineRotation)
            lineLength(490, -27);
            //arrowLength(x,y,rotate)
            arrowLength(102, 180, 184);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(247, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 125, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-27, 605, -27, 550, -115, 276);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(300, 540, 142, 162, -27);
        }
        /*----Angle 15----*/
        else if (angle == 15) {
            mek_angle.x = 312;
            cc_container.x = 268;
            //cc_container.y = 305; //420;
            //lineLength(lineHeight, lineRotation)
            lineLength(490, -28);
            //arrowLength(x,y,rotate)
            arrowLength(105, 180, 183);
            //lineDistance(moveTo1,moveTo2,lineTo1,lineTo2)
            lineDistance(258, 200, 35, 300);
            //Angle Curve
            angleCurvehDashed(90, 250, 130, 235);
            //infoD(dLeftRotate, lHeight, dRightRotate, dRightY, dLineRotate, dLineHeight)
            infoD(-28, 580, -28, 550, -115, 276);
            //dMathInfo(x, y, lArrowX, dX, dRotate)
            dMathInfo(302, 540, 146, 168, -28);
        }
    }
    stage.update();
    // Stage update
}