// Animate

// Update stage will render next frame
createjs.Ticker.framerate = 30;
createjs.Ticker.addEventListener("tick", tickHandler);

function tickHandler(e) {
	stage.update();
}

// createjs.Ticker.addEventListener("tick", rotate_f1);
// createjs.Ticker.addEventListener("tick", rotate_f2);

// alert (circle_f1.radius);

// circle_f1.graphics.setStrokeStyle(5).beginStroke("green").beginFill("#ffffff50").drawCircle(0, 0, 80);
// stage.addChild(circle_f1);
// stage.update();


// createjs.Ticker.addEventListener("tick", resize_f1);






function f1_changed() {
	calc_ropes();
	//resize_power_f1(f1_power.x, f1_power.y);
}

function f2_changed() {
	calc_ropes();
	//resize_power_f2(f2_power.x, f2_power.y);
}

function r1_changed() {
	calc_ropes();
	r1 = parseFloat( $("#num_distance_r1").val() );
	resize_radius_f1(r1);
}

function r2_changed() {
	calc_ropes();
	r2 = parseFloat( $("#num_distance_r2").val() );
	resize_radius_f2(r2);
}




// Rotate the two circles
function rotate_circles(e) {
	var f1 = $("#num_power_f1").val();
	var f2 = $("#num_power_f2").val();
	var r1 = $("#num_distance_r1").val();
	var r2 = $("#num_distance_r2").val();
	var ropi1 = parseFloat(f1) * parseFloat(r1);
	var ropi2 = parseFloat(f2) * parseFloat(r2);
	var speed = (ropi1 - ropi2) / 400;
	var f1_top = f1_horizline.y + 40;
	var f1_bottom = 500;
	var f2_top = f2_horizline.y + 40;
	var f2_bottom = 500;
	var f1_power_x = f1_power.x;
	var f1_power_y = f1_power.y;
	var f2_power_x = f2_power.x;
	var f2_power_y = f2_power.y;

	if (ropi1 > ropi2 && img_weight_m1.y < f1_bottom && img_weight_m2.y > f2_top) {
		// hide arrow
		img_cw.visible = false;
		img_acw.visible = false;
		img_acw.regX = 140;
		img_acw.regY = 140;
		// img_acw.rotation -= speed;

		// rotate circles
		circle_f1.rotation -= speed;
		circle_f2.rotation -= speed;

		// rotate the two pullers
		f1_pulley.regX = 0;
		f1_pulley.regY = 0;
		f1_pulley.rotation -= speed*4;
		f2_pulley.regX = 0;
		f2_pulley.regY = 0;
		f2_pulley.rotation -= speed*4;

		// move weights
		img_weight_m1.y += speed;
		f1_val.y += speed;
		img_weight_m2.y -= speed;
		f2_val.y -= speed;

		// move m1 and m2
		f1_text.y += speed;
		f1_subtext.y += speed;
		f2_text.y -= speed;
		f2_subtext.y -= speed;

		// adjust vertical ropes
		len_f1 = img_weight_m1.y - f1_power_y;
		len_f2 = img_weight_m2.y - f2_power_y;
		f1_power.graphics.clear().beginFill("#808080").drawRect(0, 0, 6, len_f1);
		f2_power.graphics.clear().beginFill("#808080").drawRect(0, 0, 6, len_f2);
	}
	if (ropi1 < ropi2 && img_weight_m2.y < f1_bottom && img_weight_m1.y > f1_top) {
		// hide arrow
		img_cw.visible = false;
		img_acw.visible = false;
		img_cw.regX = 140;
		img_cw.regY = 140;
		// img_cw.rotation -= speed;

		// rotate circles
		circle_f1.rotation -= speed;
		circle_f2.rotation -= speed;

		// rotate the two pullers
		f1_pulley.regX = 0;
		f1_pulley.regY = 0;
		f1_pulley.rotation -= speed*4;
		f2_pulley.regX = 0;
		f2_pulley.regY = 0;
		f2_pulley.rotation -= speed*4;

		// move weights
		img_weight_m1.y += speed;
		f1_val.y += speed;
		img_weight_m2.y -= speed;
		f2_val.y -= speed;

		// move m1 and m2
		f1_text.y += speed;
		f1_subtext.y += speed;
		f2_text.y -= speed;
		f2_subtext.y -= speed;

		// adjust vertical ropes
		len_f1 = img_weight_m1.y - f1_power_y;
		len_f2 = img_weight_m2.y - f2_power_y;
		f1_power.graphics.clear().beginFill("#808080").drawRect(0, 0, 6, len_f1);
		f2_power.graphics.clear().beginFill("#808080").drawRect(0, 0, 6, len_f2);
	}
	if (ropi1 > ropi2 && (img_weight_m1.y >= f1_bottom || img_weight_m2.y <= f2_top)) {
		// show anti-clockwise arrow (<==)
		img_cw.visible = false;
		img_acw.visible = true;
		img_acw.regX = 140;
		img_acw.regY = 140;
		// img_acw.rotation -= speed;
	}

	if (ropi1 < ropi2 && (img_weight_m2.y >= f2_bottom || img_weight_m1.y <= f1_top)) {
		// show clockwise arrow (==>)
		img_cw.visible = true;
		img_acw.visible = false;
		img_cw.regX = 140;
		img_cw.regY = 140;
		// img_cw.rotation -= speed;
	}

	stage.update();
}

/*
// Rotate F2
function rotate_f2(e) {
	var f1 = $("#num_power_f1").val();
	var f2 = $("#num_power_f2").val();
	var r1 = $("#num_distance_r1").val();
	var r2 = $("#num_distance_r2").val();
	var ropi1 = parseFloat(f1) * parseFloat(r1);
	var ropi2 = parseFloat(f2) * parseFloat(r2);
	var speed = (ropi2 - ropi1) / 400;
	circle_f2.rotation += speed; 
	stage.update();
}



// Stop Rotating F1
function stop_rotate_f1() {
	circle_f1.rotation = 0; 
	stage.update();
}

// Stop Rotating F2
function stop_rotate_f2() {
	circle_f2.rotation = 0; 
	stage.update();
}
*/

// Resize F1
function resize_radius_f1(radius) {

	radius = radius * 2;

	circle_f1.graphics.clear().setStrokeStyle(8).beginStroke("#c8c8c8").beginFill("rgba(0, 0, 0, 0.32)").drawCircle(0, 0, radius + 80);
	circle_f1.graphics.setStrokeStyle(10).beginStroke("#c8c8c8").drawCircle(radius+60, 0, 5);
	circle_f1.graphics.setStrokeStyle(10).beginStroke("#c8c8c8").drawCircle(0, radius+60, 5);
	circle_f1.graphics.setStrokeStyle(10).beginStroke("#c8c8c8").drawCircle(-radius-60, 0, 5);
	circle_f1.graphics.setStrokeStyle(10).beginStroke("#c8c8c8").drawCircle(0, -radius-60, 5);

	circle_f1.x = config.center_x;
	circle_f1.y = config.center_y;
	stage.addChild(circle_f1);
	stage.addChild(circle_f2);	// Need to keep circle f2 on top!
	stage.addChild(img_cw);		// Need to keep clockwise arrow on top!
	stage.addChild(img_acw);	// Need to keep anti-clockwise arrow on top!

	// move the rest of the drawing
	f1_container.y = -42 - radius;
	stage.update();
}



// Resize F2
function resize_radius_f2(radius) {

	radius = radius * 2;

	circle_f2.graphics.clear().setStrokeStyle(12).beginStroke("white").beginFill("rgba(0, 0, 0, 0.32)").drawCircle(0, 0, radius + 80);
	circle_f2.graphics.setStrokeStyle(12).beginStroke("white").drawCircle(radius+40, 0, 6);
	circle_f2.graphics.setStrokeStyle(12).beginStroke("white").drawCircle(0, radius+40, 6);
	circle_f2.graphics.setStrokeStyle(12).beginStroke("white").drawCircle(-radius-40, 0, 6);
	circle_f2.graphics.setStrokeStyle(12).beginStroke("white").drawCircle(0, -radius-40, 6);
	circle_f2.x = config.center_x;
	circle_f2.y = config.center_y;
	stage.addChild(circle_f2);
	stage.addChild(img_cw);		// Need to keep clockwise arrow on top!
	stage.addChild(img_acw);	// Need to keep anti-clockwise arrow on top!

	// move the rest of the drawing
	f2_container.y = -10 - radius;
	stage.update();
}




function resize_power_f1(x, y) {

	var power = parseInt( $("#num_power_f1").val() );
	var len = parseInt(power*1.6) + 170;

	f1_power.graphics.clear().beginFill("#808080").drawRect(0, 0, 6, len);
	// f1_power.graphics.beginFill("#808080").drawPolyStar(2, len, 12, 3, 0, 90);  // arrow
	f1_power.x = x;
	f1_power.y = y;

	// f1_text.y = config.center_y - 130 + len;
	// f1_subtext.y = config.center_y - 110 + len;

	//img_weight_m1.y = config.center_y - 150 + len;
	//f1_val.y = config.center_y - 120 + len;

	stage.update();

}


function resize_power_f2(x, y) {

	var power = parseInt( $("#num_power_f2").val() );
	var len = parseInt(power*1.6) + 170;

	f2_power.graphics.clear().beginFill("#808080").drawRect(0, 0, 6, len);
	// f2_power.graphics.beginFill("#808080").drawPolyStar(2, len, 12, 3, 0, 90);  // arrow
	f2_power.x = x;
	f2_power.y = y;

	// f2_text.y = config.center_y - 150 + len;
	// f2_subtext.y = config.center_y - 130 + len;

	//img_weight_m2.y = config.center_y - 170 + len;
	//f2_val.y = config.center_y - 140 + len;

	stage.update();

}





// Calculate F1 * r = F2 * R
function calc_ropes() {

	// Get Controls Values
	var power_f1 = $("#num_power_f1").val();
	var power_f2 = $("#num_power_f2").val();
	// var g = config.g_earth;
	var distance_r1 = $("#num_distance_r1").val();
	var distance_r2 = $("#num_distance_r2").val();

	var ropi1_val = $("#ropi1_val");
	var ropi2_val = $("#ropi2_val");

	var M1 = parseFloat(power_f1) * parseFloat(g) * parseFloat(distance_r1);
	var M2 = parseFloat(power_f2) * parseFloat(g) * parseFloat(distance_r2);

	// Round result to 2 digits
	// M1.toFixed(2);
	// M2.toFixed(2);
	M1 = Math.round(M1*100)/100;
	M2 = Math.round(M2*100)/100;

	// console.log(g, M1, M2);

	if (M1 == M2) {
		// M1 = M2 (Isorropia)
		ropi1_val.html( format_number_el(M1) + ' N&sdot;cm');
		ropi2_val.html( format_number_el(M2) + ' N&sdot;cm');
		f1_val.text = format_number_el( $("#num_power_f1").val() ) + " Kg";
		f2_val.text = format_number_el( $("#num_power_f2").val() ) + " Kg";

		createjs.Ticker.removeEventListener("tick", rotate_circles);
		
	} else if (M1 > M2) {
		// M1 > M2
		ropi1_val.html( format_number_el(M1) + ' N&sdot;cm');
		ropi2_val.html( format_number_el(M2) + ' N&sdot;cm');
		f1_val.text = format_number_el( $("#num_power_f1").val() ) + " Kg";
		f2_val.text = format_number_el( $("#num_power_f2").val() ) + " Kg";

		createjs.Ticker.addEventListener("tick", rotate_circles);

	} else {
		// M2 < M1
		ropi1_val.html( format_number_el(M1) + ' N&sdot;cm');
		ropi2_val.html( format_number_el(M2) + ' N&sdot;cm');
		f1_val.text = format_number_el( $("#num_power_f1").val() ) + " Kg";
		f2_val.text = format_number_el( $("#num_power_f2").val() ) + " Kg";

		createjs.Ticker.addEventListener("tick", rotate_circles);
	}

	return true;
}




function format_number_el(val) {
	// Get a javascript float number with decimal .
	// Replace decimal . with , and returns a string with the number formated with greek locale
	var num = val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ";"); // convert to string with thousands separator as ;
	num = num.replace(".", ","); // replace decimal separator as ,
	num = num.replace(";", "."); // replace thousands separator as .

	return num;
}

function convert_to_number_el(val) {
	// Get a string formated with greek locale (thousands separator as . and decimal separator as ,)
	// and return a javascript float number with decimal .
	var num = val.replace(".", "");  // remove thousands separator
	num = num.replace(",", ".");     // replace decimal separator with .
	num = parseFloat(num);

	return num;
}