// Create Canvas elements



// Initialize Canvas
var canvas = document.getElementById("canvas");
var context = canvas.getContext('2d');
var stage = new createjs.Stage("canvas");

// Background Image
var image_base = new Image();
image_base.src = 'images/base.png';

var img_base = new createjs.Bitmap(image_base);
img_base.scaleX = img_base.scaleY = 0.77;
img_base.x = config.center_x - 400;
img_base.y = config.center_y - 30;

image_base.onload = function () {
	stage.addChild(img_base);
	stage.setChildIndex(img_base, 0);
	stage.update();
}

// Draw f1 circle
var circle_f1 = new createjs.Shape();
var f1_r = 40;
// circle_f1.graphics.setStrokeStyle(5).beginStroke("green").beginFill("#ffffff50").drawCircle(0, 0, f1_r);
circle_f1.graphics.setStrokeStyle(8).beginStroke("#c8c8c8").beginFill("rgba(0, 0, 0, 0.32)").drawCircle(0, 0, f1_r);
circle_f1.graphics.setStrokeStyle(10).beginStroke("#c8c8c8").drawCircle(-10, 0, 5);
circle_f1.graphics.setStrokeStyle(10).beginStroke("#c8c8c8").drawCircle(0, -10, 5);
circle_f1.graphics.setStrokeStyle(10).beginStroke("#c8c8c8").drawCircle(10, 0, 5);
circle_f1.graphics.setStrokeStyle(10).beginStroke("#c8c8c8").drawCircle(0, 10, 5);
// line at the center of the circle
// circle_f1.graphics.setStrokeStyle(2).beginStroke("green").moveTo(-f1_r,0).lineTo(+f1_r,0).endStroke();
circle_f1.x = config.center_x;
circle_f1.y = config.center_y;
stage.addChild(circle_f1);

// Draw f1 power
var f1_power = new createjs.Shape();
f1_power.graphics.beginFill("#808080").drawRect(0, 0, 6, 220); // default: 0, 0, 6, 40
// f1_power.graphics.beginFill("#808080").drawPolyStar(2, 44, 12, 3, 0, 90);  // arrow
f1_power.x = config.center_x - 332;
f1_power.y = config.center_y - 29;


// Horizontal Rope
var f1_horizline = new createjs.Shape();
f1_horizline.graphics.beginFill("#808080").drawRect(5, -16, 320, 6);
f1_horizline.x = config.center_x - 317;
f1_horizline.y = config.center_y - 25;

// Static pulleys
var f1_pulley = new createjs.Shape();
f1_pulley.graphics.setStrokeStyle(5).beginStroke("#f8e8ce").beginFill("#5d7178").drawCircle(0, 0, 13);
f1_pulley.graphics.setStrokeStyle(2).beginStroke("#f8e8ce").moveTo(-13,0).lineTo(13,0).endStroke();
f1_pulley.x = config.center_x - 317;
f1_pulley.y = config.center_y - 25;

// Weight
/*
var f1_box = new createjs.Shape();
f1_box.graphics.setStrokeStyle(10).beginStroke("#f8e8ce").beginFill("#39454a").drawRoundRectComplex(0, 0, 80, 80, 10, 10, 10, 10);
f1_box.x = config.center_x - 370;
f1_box.y = config.center_y + 200;
*/

var image_weight_m1 = new Image();
image_weight_m1.src = 'images/weight.png';     
var img_weight_m1 = new createjs.Bitmap(image_weight_m1);
img_weight_m1.scaleX = img_weight_m1.scaleY = 0.70;
img_weight_m1.x = config.center_x - 382;
img_weight_m1.y = config.center_y + 125;

image_weight_m1.onload = function () {
	//stage.addChild(img_weight_m1);
	stage.update();
}


// Weight Value
var f1_val = new createjs.Text("0 Kg", "bold 20px Arial", "white");
f1_val.textAlign = "center";
f1_val.x = config.center_x - 330;
f1_val.y = config.center_y + 170;
f1_val.text = $("#num_power_f1").val() + " Kg";
stage.update();

// Weight Label
var f1_text = new createjs.Text("m", "bold 32px Arial", "#4c5e64");
f1_text.x = config.center_x - 260; // 310
f1_text.y = config.center_y + 160;
var f1_subtext = new createjs.Text("1", "bold 20px Arial", "#4c5e64");
f1_subtext.x = config.center_x - 230; // 290
f1_subtext.y = config.center_y + 180;


var f1_container = new createjs.Container();
f1_container.addChild(f1_power);
f1_container.addChild(f1_horizline);
f1_container.addChild(f1_pulley);
f1_container.addChild(f1_text);
f1_container.addChild(f1_subtext);
// f1_container.addChild(f1_box);
f1_container.addChild(img_weight_m1);
f1_container.addChild(f1_val);
stage.addChild(f1_container);







// Draw f2 circle
var circle_f2 = new createjs.Shape();
var f2_r = 68;
circle_f2.graphics.setStrokeStyle(12).beginStroke("white").beginFill("rgba(0, 0, 0, 0.8)").drawCircle(0, 0, f2_r);
circle_f2.graphics.setStrokeStyle(16).beginStroke("white").drawCircle(-58, 0, 8);
circle_f2.graphics.setStrokeStyle(16).beginStroke("white").drawCircle(0, -58, 8);
circle_f2.graphics.setStrokeStyle(16).beginStroke("white").drawCircle(58, 0, 8);
circle_f2.graphics.setStrokeStyle(16).beginStroke("white").drawCircle(0, 58, 8);
circle_f2.x = config.center_x;
circle_f2.y = config.center_y;
circle_f1.rotation += 45; // Rotate for 45 degrees in order the spots to have different position
stage.addChild(circle_f2);

// Draw f2 power
var f2_power = new createjs.Shape();
f2_power.graphics.beginFill("#808080").drawRect(0, 0, 6, 140);
// f2_power.graphics.beginFill("#808080").drawPolyStar(2, 44, 12, 3, 0, 90); // arrow
f2_power.x = config.center_x + 337;
f2_power.y = config.center_y - 55;

// Horizontal Rope
var f2_horizline = new createjs.Shape();
f2_horizline.graphics.beginFill("#808080").drawRect(-218, -16, 320, 6); // #808080
f2_horizline.x = config.center_x + 223;
f2_horizline.y = config.center_y - 55;

// Static pulleys
var f2_pulley = new createjs.Shape();
f2_pulley.graphics.setStrokeStyle(5).beginStroke("#f8e8ce").beginFill("#5d7178").drawCircle(0, 0, 13);
f2_pulley.graphics.setStrokeStyle(2).beginStroke("#f8e8ce").moveTo(-13,0).lineTo(13,0).endStroke();
f2_pulley.x = config.center_x + 328;
f2_pulley.y = config.center_y - 55;
// f2_pulley.rotation += 45; // Rotate for 45 degrees in order the spots to have different position

// Weight
/*
var f2_box = new createjs.Shape();
f2_box.graphics.setStrokeStyle(10).beginStroke("#f8e8ce").beginFill("#39454a").drawRoundRectComplex(0, 0, 80, 80, 10, 10, 10, 10);
f2_box.x = config.center_x + 300;
f2_box.y = config.center_y - 10;
*/

// Load Weight image
var image_weight_m2 = new Image();
image_weight_m2.src = 'images/weight.png';     
var img_weight_m2 = new createjs.Bitmap(image_weight_m2);
img_weight_m2.scaleX = img_weight_m2.scaleY = 0.7;
img_weight_m2.x = config.center_x + 288;
img_weight_m2.y = config.center_y + 75;


image_weight_m2.onload = function () {
        // stage.addChild(img_weight_m2);
        stage.update();
}

// Weight Value
var f2_val = new createjs.Text("0 Kg", "bold 20px Arial", "white");
f2_val.textAlign = "center";
f2_val.x = config.center_x + 340;
f2_val.y = config.center_y + 120;
f2_val.text = $("#num_power_f2").val() + " Kg";

// Weight Label
var f2_text = new createjs.Text("m", "bold 32px Arial", "#fff");
f2_text.x = config.center_x + 220; // 250
f2_text.y = config.center_y + 110;
var f2_subtext = new createjs.Text("2", "bold 20px Arial", "#fff");
f2_subtext.x = config.center_x + 248; // 268
f2_subtext.y = config.center_y + 130;


var f2_container = new createjs.Container();
f2_container.addChild(f2_power);
f2_container.addChild(f2_horizline);
f2_container.addChild(f2_pulley);
f2_container.addChild(f2_text);
f2_container.addChild(f2_subtext);
// f2_container.addChild(f2_box);
f2_container.addChild(img_weight_m2);
f2_container.addChild(f2_val);
stage.addChild(f2_container);


/*
function loadImage() {
  var preload = new createjs.LoadQueue();
  preload.addEventListener("fileload", handleFileComplete);
  preload.loadFile("images/arrow-clockwise.png");
  preload.loadFile("images/arrow-anticlockwise.png");
}


function handleFileComplete(event) {
  document.body.appendChild(event.result);
}
*/

 // Load Arrow images
var image_cw = new Image();
var image_acw = new Image();

image_cw.src = 'images/arrow-clockwise.png';     
image_acw.src = 'images/arrow-anticlockwise.png';     

var img_cw = new createjs.Bitmap(image_cw);
var img_acw = new createjs.Bitmap(image_acw);

/*
// inside 
img_cw.scaleX = img_cw.scaleY = 0.8;
img_cw.x = config.center_x - 0;
img_cw.y = config.center_y - 5;
img_cw.alpha = 0.25;

img_acw.scaleX = img_acw.scaleY = 0.8;
img_acw.x = config.center_x - 0;
img_acw.y = config.center_y - 5;
img_acw.alpha = 0.25;
*/

// outside at the base
img_cw.scaleX = img_cw.scaleY = 0.4;
img_cw.x = config.center_x - 0;
img_cw.y = config.center_y - 5;
img_cw.alpha = 1;

img_acw.scaleX = img_acw.scaleY = 0.4;
img_acw.x = config.center_x - 0;
img_acw.y = config.center_y - 5;
img_acw.alpha = 0.5;

image_cw.onload = function () {
        stage.addChild(img_cw);
        stage.update();
}

image_acw.onload = function () {
        stage.addChild(img_acw);
        stage.update();
}

img_cw.visible = false;
img_acw.visible = false;


/*
var shape_34 = new createjs.Shape();
shape_34.graphics.f().s("#808080").ss(8,1,1).p("AAAN4IAA7v");
shape_34.setTransform(0,32.5);
stage.addChild(shape_34);
*/



// Stage update
stage.update();

