// Initialize Canvas
canvas = document.getElementById("canvas");
var stage = new createjs.Stage("canvas");

//Stage Dimensions
stageWidth = stage.canvas.width;
stageHeight = stage.canvas.height;

/* Start of Main Container */
var main_container = new createjs.Container();
/* End of Main Container */


/* Start of Main Container Elements */

// Diagram Image
/*var shapeDiagram_img = new Image();
shapeDiagram_img.src = 'images/diagram-empty.png';*/

var shapeDiagram = new createjs.Bitmap("images/diagram-empty.png"); //new createjs.Bitmap(shapeDiagram_img);
shapeDiagram.scaleX = shapeDiagram.scaleY = 1;
//Align on Stage
shapeDiagram.x = 10;
shapeDiagram.y = 50;

// wait image to be loaded
/*shapeDiagram_img.onload = function() {
    // add image to the stage
    // stage.addChild(shapeDiagram);

    // add image to the container
    main_container.addChild(shapeDiagram);

    // set z-index
    stage.setChildIndex(shapeDiagram, -1);
    stage.update();

};*/

//Material Title
var materialTile = new createjs.Text("Υλικό: ", "bold 18px Arial", "#fff");
materialTile.textAlign = "center";
//Align Title on Stage
materialTile.x = 300;
materialTile.y = 15;
materialTile.shadow = new createjs.Shadow("#333", 0, 0, 1);
//
var materialTitleBox = new createjs.Shape();
materialTitleBox.graphics.setStrokeStyle(5).beginStroke("#293766").beginFill("#293766").drawRoundRectComplex(0, 0, 390, 30, 10, 10, 10, 10); //drawRect(0, 0, 390, 30);
materialTitleBox.shadow = new createjs.Shadow("#666", 0, 0, 1);
//Set Text
materialTile.text = "Διάγραμμα φορτίων - επιμηκύνσεων";
materialTitleBox.x = 105;
materialTitleBox.y = 10;


//MetalikoDokimio Title
var metalikoDokimio = new createjs.Text("Μεταλλικό Δοκίμιο", "bold 20px Arial", "#293766");
metalikoDokimio.textAlign = "center";
//Align Title on Stage
metalikoDokimio.x = stageWidth - 130;
metalikoDokimio.y = stageHeight - 500;
metalikoDokimio.shadow = new createjs.Shadow("#666", 0, 0, 1);

//Epimikinsi Type
var epimikinsiType = new createjs.Text("ΔL = L - Lo = 0mm", "bold 15px Arial", "#333");
epimikinsiType.textAlign = "center";
//Align Title on Stage
epimikinsiType.x = stageWidth - 130;
epimikinsiType.y = stageHeight - 470;
epimikinsiType.shadow = new createjs.Shadow("#666", 0, 0, 1);

// Material Place Holder
var malakosXalivas = new createjs.Bitmap("images/diagram.png");
malakosXalivas.x = shapeDiagram.x;
malakosXalivas.y = shapeDiagram.y;

var imgContainer = new createjs.Container();
var imagePlaceholder = new createjs.Shape();

//Width and Height
var imagePlaceHolderWidth = 220;
var imagePlaceholderHeight = 365; //360
//Create Placeholder for the Material Image [old fill: "rgba(0, 0, 0, 0.0"]
imagePlaceholder.graphics.setStrokeStyle(5).beginStroke("#293766").beginFill("#e4e4e4").drawRect(0, 0, imagePlaceHolderWidth, imagePlaceholderHeight);

//Add Elements to the Image Container
imgContainer.addChild(imagePlaceholder);

//Align Image Container on Stage depending on the width and Height of The stage
imgContainer.x = stageWidth - 240;
imgContainer.y = stageHeight - 440; //440

//Extra Beauties!!
imgContainer.shadow = new createjs.Shadow("#333", 2, 5, 10);
imgContainer.cursor = "pointer";

//State Title
var materialStateTile = new createjs.Text("", "bold 16px Arial", "#293766");
materialStateTile.textAlign = "center";
//Align Title on Stage
materialStateTile.x = stageWidth - 70;
materialStateTile.y = stageHeight - 270;
materialStateTile.shadow = new createjs.Shadow("#666", 0, 0, 1);

// Elastic Region
var elasticRegionBox = new createjs.Shape();
elasticRegionBox.graphics.setStrokeStyle(5).beginStroke("#62abd1").beginFill("#62abd1").drawRoundRectComplex(0, 0, 145, 35, 6, 6, 6, 6); //drawRect(0, 0, 145, 35);
//elasticRegionBox.graphics.setStrokeStyle(5).beginStroke("#293766").beginFill("#e4e4e4").drawRoundRectComplex(0, 0, 145, 35, 6, 6, 6, 6); //drawRect(0, 0, 145, 35);
elasticRegionBox.shadow = new createjs.Shadow("#666", 0, 0, 1);
//
elasticRegionBox.x = 80;
elasticRegionBox.y = 490;
var elasticRegionImg = new createjs.Bitmap("images/elasticRegion.png");
var elasticRegionTitle = new createjs.Text("Περιοχή ελαστικών\nπαραμορφώσεων", "bold 13px Arial", "#fff"); //62abd1
elasticRegionTitle.textAlign = "center";
//
elasticRegionTitle.x = 150;
elasticRegionTitle.y = 495; //440
elasticRegionTitle.cursor = "pointer";
elasticRegionBox.cursor = "pointer";


// Plastic Region
var plasticRegionBox = new createjs.Shape();
plasticRegionBox.graphics.setStrokeStyle(5).beginStroke("#d16289").beginFill("#d16289").drawRoundRectComplex(0, 0, 145, 35, 6, 6, 6, 6); //drawRect(0, 0, 145, 35);
//plasticRegionBox.graphics.setStrokeStyle(5).beginStroke("#293766").beginFill("#e4e4e4").drawRoundRectComplex(0, 0, 145, 35, 6, 6, 6, 6); //drawRect(0, 0, 145, 35);
plasticRegionBox.shadow = new createjs.Shadow("#666", 0, 0, 1);
//
plasticRegionBox.x = 350;
plasticRegionBox.y = 490;
//
var plasticRegionImg = new createjs.Bitmap("images/plasticRegion.png");
var plasticRegionTitle = new createjs.Text("Περιοχή πλαστικών\nπαραμορφώσεων", "bold 13px Arial", "#fff"); //d16289
plasticRegionTitle.textAlign = "center";
//
plasticRegionTitle.x = 420;
plasticRegionTitle.y = 495; //440
plasticRegionTitle.cursor = "pointer";
plasticRegionBox.cursor = "pointer";

// Dot Pointer: shows the unition of F and Δl axis
var dotPointer = new createjs.Shape();
dotPointer.graphics.setStrokeStyle(4).beginStroke("#990000").beginFill("#f3f3f3").drawCircle(0, 0, 15);
dotPointer.graphics.beginFill("#990000").drawCircle(0, 0, 8);
dotPointer.shadow = new createjs.Shadow("#999", 1, 1, 1);
//
dotPointer.scaleX = dotPointer.scaleY = 0.4; //0.5
dotPointer.alpha = 0;
dotPointer.cursor = "pointer";
// Black Pointers
var blackPointers = new createjs.Container();
var blackPointerA = new createjs.Shape();
var blackPointerE = new createjs.Shape();
var blackPointerD = new createjs.Shape();
var blackPointerM = new createjs.Shape();
var blackPointerTheta = new createjs.Shape();
blackPointerA.graphics.beginFill("#000").drawCircle(0, 0, 6);
blackPointerE.graphics.beginFill("#000").drawCircle(0, 0, 6);
blackPointerD.graphics.beginFill("#000").drawCircle(0, 0, 6);
blackPointerM.graphics.beginFill("#000").drawCircle(0, 0, 6);
blackPointerTheta.graphics.beginFill("#000").drawCircle(0, 0, 6);
//
blackPointerA.x = 92;
blackPointerE.x = 96;
blackPointerD.x = 100;
blackPointerM.x = 395;
blackPointerTheta.x = 487;
blackPointerA.y = 190;
blackPointerE.y = 158;
blackPointerD.y = 128;
blackPointerM.y = 38;
blackPointerTheta.y = 67;
//
blackPointerA.cursor = "pointer";
blackPointerE.cursor = "pointer";
blackPointerD.cursor = "pointer";
blackPointerM.cursor = "pointer";
blackPointerTheta.cursor = "pointer";
//
blackPointers.x = shapeDiagram.x;
blackPointers.y = shapeDiagram.y;
blackPointers.addChild(blackPointerA, blackPointerE, blackPointerD, blackPointerM, blackPointerTheta);

//Dashed Lines for points
var point2000 = new createjs.Bitmap("images/2000-002.png");
var point4000 = new createjs.Bitmap("images/4000-004.png");
var point6000 = new createjs.Bitmap("images/6000-006.png");
var point8000 = new createjs.Bitmap("images/8000-008.png");
var point10000 = new createjs.Bitmap("images/10000-010.png");
var point12000 = new createjs.Bitmap("images/12000-012.png");
var point14000 = new createjs.Bitmap("images/14000-020.png");
var point16000 = new createjs.Bitmap("images/16000-100.png");
var point20000 = new createjs.Bitmap("images/20000-350.png");
var point18000 = new createjs.Bitmap("images/18000-450.png");

// x,y 
point2000.x = point4000.x = point6000.x = point8000.x = point10000.x = point12000.x = point14000.x = point16000.x = point18000.x = point20000.x = shapeDiagram.x;
point2000.y = point4000.y = point6000.y = point8000.y = point10000.y = point12000.y = point14000.y = point16000.y = point18000.y = point20000.y = shapeDiagram.y;
// alpha
point2000.alpha = point14000.alpha = point12000.alpha = point20000.alpha = point18000.alpha = 0;

// Material States
var axikoMikos = new createjs.Bitmap("images/arxikoMikos.png");
var epimikinsi = new createjs.Bitmap("images/epimikinsi.png");
var epimikinsi2 = new createjs.Bitmap("images/epimikinsi2.png");
var laimwsi = new createjs.Bitmap("images/laimwsi.png");
var thrausi = new createjs.Bitmap("images/thrausi.png");
// x,y 
axikoMikos.x = epimikinsi.x = epimikinsi2.x = laimwsi.x = thrausi.x = imgContainer.x + 62;
axikoMikos.y = epimikinsi.y = epimikinsi2.y = laimwsi.y = thrausi.y = imgContainer.y + 15; //5
// alpha
axikoMikos.alpha = epimikinsi.alpha = epimikinsi2.alpha = laimwsi.alpha = thrausi.alpha = 0;

//Tooltip Elements
var tooltipContainer = new createjs.Container();
var tooltipBox = new createjs.Shape();
var tooltipTxt = new createjs.Text("", "bold 14px Arial", "#f3f3f3");
tooltipTxt.textAlign = "center";
tooltipContainer.x = 100;
tooltipContainer.y = 100;
//
tooltipBox.shadow = new createjs.Shadow("#999", 1, 1, 1);
tooltipTxt.shadow = new createjs.Shadow("#666", 0, 0, 1);
//
tooltipContainer.addChild(tooltipBox, tooltipTxt);

/* End of Main Container Elements*/

/* Start of Functions Section */
//showPointers: Function that shows pointer and info about it!
function showPointers(imgName, dotX, dotY, materialName) {
    //Set Text
    materialTile.text = "Διάγραμμα  φορτίων - επιμηκύνσεων"; //materialName;
    // Reset Alpha State
    dotPointer.alpha = 0;
    point2000.alpha = point4000.alpha = point6000.alpha = point8000.alpha = point10000.alpha = point12000.alpha = point14000.alpha = point16000.alpha = point18000.alpha = point20000.alpha = 0;
    axikoMikos.alpha = epimikinsi.alpha = epimikinsi2.alpha = laimwsi.alpha = thrausi.alpha = 0;

    // Get the Material name and show its data
    if (materialName == "Μαλακός Χάλυβας") {
        //shapeDiagram_img.src = 'images/diagram-empty.png';
        dotPointer.alpha = 1;
        if (imgName == "point2000") {
            point2000.alpha = 1;
            epimikinsi.alpha = 1;
            materialStateTile.text = "";
            epimikinsiType.text = "Επιμήκυνση: ΔL = L - Lo = 0,02mm";
            dotPointerAction(dotPointer, "none");
        } else if (imgName == "point4000") {
            point4000.alpha = 1;
            epimikinsi.alpha = 1;
            epimikinsiType.text = "Επιμήκυνση: ΔL = L - Lo = 0,04mm";
            dotPointerAction(dotPointer, "none");
        } else if (imgName == "point6000") {
            point6000.alpha = 1;
            epimikinsi.alpha = 1;
            materialStateTile.text = "";
            epimikinsiType.text = "Επιμήκυνση: ΔL = L - Lo = 0,06mm";
            dotPointerAction(dotPointer, "none");
        } else if (imgName == "point8000") {
            point8000.alpha = 1;
            epimikinsi.alpha = 1;
            materialStateTile.text = "";
            epimikinsiType.text = "Επιμήκυνση: ΔL = L - Lo = 0,08mm";
            dotPointerAction(dotPointer, "none");
        } else if (imgName == "point10000") {
            point10000.alpha = 1;
            epimikinsi.alpha = 1;
            materialStateTile.text = "";
            epimikinsiType.text = "Επιμήκυνση: ΔL = L - Lo = 0,10mm";
            dotPointerAction(dotPointer, "Σημείο Α: Φορτίο αναλογίας (Fα)");
        } else if (imgName == "point12000") {
            point12000.alpha = 1;
            epimikinsi.alpha = 1;
            materialStateTile.text = "";
            epimikinsiType.text = "Επιμήκυνση: ΔL = L - Lo = 0,15mm";
            dotPointerAction(dotPointer, "Σημείο Ε: Φορτίο ελαστικότητας (Fε)");
        } else if (imgName == "point14000") {
            point14000.alpha = 1;
            epimikinsi.alpha = 1;
            materialStateTile.text = "";
            epimikinsiType.text = "Επιμήκυνση: ΔL = L - Lo = 0,20mm";
            dotPointerAction(dotPointer, "Σημείο Δ: Φορτίο διαρροής (Fδ)");
        } else if (imgName == "point16000") {
            point16000.alpha = 1;
            epimikinsi2.alpha = 1;
            materialStateTile.text = "";
            epimikinsiType.text = "Επιμήκυνση: ΔL = L - Lo = 1,00mm";
            dotPointerAction(dotPointer, "none");
        } else if (imgName == "point18000") {
            point18000.alpha = 1;
            thrausi.alpha = 1;
            materialStateTile.text = "Θραύση";
            epimikinsiType.text = "Επιμήκυνση: ΔL = L - Lo = 4,50mm";
            dotPointerAction(dotPointer, "Σημείο Θ: Φορτίο θραύσης (Fθρ)");
        } else if (imgName == "point20000") {
            point20000.alpha = 1;
            laimwsi.alpha = 1;
            materialStateTile.text = "Λαίμωση";
            epimikinsiType.text = "Επιμήκυνση: ΔL = L - Lo = 3,50mm";
            dotPointerAction(dotPointer, "Σημείο Μ: Μέγιστο φορτίο (Fμ)");
        } else if (imgName == "noImage") {
            dotPointer.alpha = 1;
            axikoMikos.alpha = 1;
            epimikinsiType.text = "Επιμήκυνση: ΔL = L - Lo = 0mm";
            dotPointerAction(dotPointer, "none");
        }
    } else {
        materialTile.text = materialName;
        materialStateTile.text = "Κατάσταση:";
        //
        point2000.alpha = point4000.alpha = point6000.alpha = point8000.alpha = point10000.alpha = point12000.alpha = point14000.alpha = point16000.alpha = point18000.alpha = point20000.alpha = 0;
        axikoMikos.alpha = epimikinsi.alpha = epimikinsi2.alpha = laimwsi.alpha = thrausi.alpha = 0;
        dotPointer.alpha = 0;
    }
    // Dot Coordinates & Alpha
    dotPointer.x = dotX;
    dotPointer.y = dotY;
}


/* End of  Functions Section */

/* Start of Mouse Actions */
//Dot Pointer Actions
function dotPointerAction(pointer, txt) {
    pointer.on("click", function() {
        if (txt == "none") {

            main_container.removeChild(tooltipContainer);
        } else {
            tooltipBox.graphics.clear();
            //
            tooltipBox.graphics.setStrokeStyle(5).beginFill("rgba(0, 0, 0, 0.8").drawRect(0, 0, 300, 50);
            //
            tooltipTxt.text = txt;
            //
            tooltipTxt.x = 300 / 2;
            tooltipTxt.y = 20;
            tooltipContainer.x = pointer.x + 10;
            tooltipContainer.y = pointer.y - 10;
            //
            main_container.addChild(tooltipContainer);
            //stage.update();
        }
    });
    pointer.on("mouseout", function() {
        main_container.removeChild(tooltipContainer);
    });

    stage.update();
}

//Image Container Actions
imgContainer.on("click", function() {
    tooltipBox.graphics.clear();
    //
    tooltipBox.graphics.setStrokeStyle(5).beginFill("rgba(0, 0, 0, 0.8").drawRect(0, 0, 400, 110);
    //
    tooltipTxt.text = "Μεταλλικό δοκίμιο:  Μαλακός χάλυβας, 0.4%C,\n\nΑνόπτηση στους  900 °C\n\nΔιαστάσεις: 6mm x 80mm (διάμετρος x μήκος)";
    //Align Texts and Container
    tooltipTxt.x = 400 / 2;
    tooltipTxt.y = 20;
    tooltipContainer.x = imgContainer.x - 250;
    tooltipContainer.y = imgContainer.y + 120;
    //
    main_container.addChild(tooltipContainer);
    stage.update();
});
imgContainer.on("mouseout", function() {
    main_container.removeChild(tooltipContainer);
    stage.update();
});
//TooltipContainer Action in order to close on mobiles
tooltipContainer.on("click", function() {
    main_container.removeChild(tooltipContainer);
    stage.update();
});
//Plastic Region  Actions
var plasticRegionFlag = false;
//function for ON/OFF
function plasticRegion() {
    if (plasticRegionFlag == false) {
        plasticRegionFlag = true;
        main_container.addChild(plasticRegionImg);
    } else if (plasticRegionFlag == true) {
        main_container.removeChild(plasticRegionImg);
        plasticRegionFlag = false;
    }
    plasticRegionImg.x = 10;
    plasticRegionImg.y = 50;
    stage.update();
    return plasticRegionFlag;
}
//
plasticRegionTitle.on("click", function() {
    if (plasticRegionFlag == false) {
        plasticRegionFlag = true;
        main_container.addChild(plasticRegionImg);
    } else if (plasticRegionFlag == true) {
        main_container.removeChild(plasticRegionImg);
        plasticRegionFlag = false;
    }
    plasticRegionImg.x = 10;
    plasticRegionImg.y = 50;
    stage.update();
    return plasticRegionFlag;
});
plasticRegionBox.on("click", function() {
    if (plasticRegionFlag == false) {
        plasticRegionFlag = true;
        main_container.addChild(plasticRegionImg);
    } else if (plasticRegionFlag == true) {
        main_container.removeChild(plasticRegionImg);
        plasticRegionFlag = false;
    }
    plasticRegionImg.x = 10;
    plasticRegionImg.y = 50;
    stage.update();
    return plasticRegionFlag;
});
//Elastic Region Actions
var elasticRegionFlag = false; //function for ON/OFF
function elasticRegion() {
    if (elasticRegionFlag == false) {
        elasticRegionFlag = true;
        main_container.addChild(elasticRegionImg);
    } else if (elasticRegionFlag == true) {
        main_container.removeChild(elasticRegionImg);
        elasticRegionFlag = false;
    }
    elasticRegionImg.x = 10;
    elasticRegionImg.y = 50;
    stage.update();
    return elasticRegionFlag;
}
//
elasticRegionTitle.on("click", function() {
    if (elasticRegionFlag == false) {
        elasticRegionFlag = true;
        main_container.addChild(elasticRegionImg);
    } else if (elasticRegionFlag == true) {
        main_container.removeChild(elasticRegionImg);
        elasticRegionFlag = false;
    }
    elasticRegionImg.x = 10;
    elasticRegionImg.y = 50;
    stage.update();
    return elasticRegionFlag;
});
elasticRegionBox.on("click", function() {
    if (elasticRegionFlag == false) {
        elasticRegionFlag = true;
        main_container.addChild(elasticRegionImg);
    } else if (elasticRegionFlag == true) {
        main_container.removeChild(elasticRegionImg);
        elasticRegionFlag = false;
    }
    elasticRegionImg.x = 10;
    elasticRegionImg.y = 50;
    stage.update();
    return elasticRegionFlag;
});



//Black Pointers
dotPointerAction(blackPointerA, "Σημείο Α: Φορτίο αναλογίας (Fα)");
dotPointerAction(blackPointerE, "Σημείο Ε: Φορτίο ελαστικότητας (Fε)");
dotPointerAction(blackPointerD, "Σημείο Δ: Φορτίο διαρροής (Fδ) ");
dotPointerAction(blackPointerM, "Σημείο Μ: Μέγιστο φορτίο (Fμ)");
dotPointerAction(blackPointerTheta, "Σημείο Θ: Φορτίο θραύσης (Fθρ)");

/* End of Mouse Actions */
//Add Element to the Main Container
main_container.addChild(shapeDiagram, imgContainer, materialTitleBox, materialTile, metalikoDokimio, epimikinsiType, materialStateTile, point2000, point4000, point6000, point8000, point10000, point12000, point14000, point16000, point18000, point20000, axikoMikos, epimikinsi, epimikinsi2, laimwsi, thrausi);
// Put elements on stage
stage.addChild(main_container, blackPointers, dotPointer);
//plasticRegionBox, plasticRegionTitle, elasticRegionBox, elasticRegionTitle

// Update stage
stage.update();