// Animate

// Update stage will render next frame
createjs.Ticker.framerate = 30;
createjs.Ticker.addEventListener("tick", tickHandler);

function tickHandler(e) {
	stage.update();
}


function d1_r1_changed() {
	var d1 = true;

	if ( $("#switch_d1").prop("checked") ) {
		d1 = true;
	} else {
		d1 = false;
	}
	r1 = parseFloat( $("#num_r1").val() );
	calc_ammeter(d1, r1);
	toggle_switch_d1(d1);
	toggle_switch_d2(d1, r1);
}


// Calculate Amper Meter
function calc_ammeter(d1, r1) {

	var i = 0;

	if (d1==true) {
		if (r1 <= 3900) {
			i = 98.76 - ((r1 - 500) * 0.00036);
		} else {
			i = 97.535 - ((r1 - 3900) * 0.013);
		}
	}

	// Display 2 decimal
	i = Math.round(i*100)/100;
	i = i.toFixed(2);

	// display results
	// console.log(i);
	// $("#ammeter").html(i);

	// Display results at Amper meter
	if (i > 0) {
		ammeter_text.text = i + "mA";
	} else {
		ammeter_text.text = "00.00mA";
	}

	return i;
}


// Control Switch D1
function toggle_switch_d1(d1) {

	var status = '';

	if (d1==true) {
		status = 'closed';
	} else {
		status = 'open';
	}

	if (status=='open')	{
		// $("#circuit_status").html('Ανοικτό');
		switch_d1_open.visible = true;
		switch_d1_closed.visible = false;
	} else {
		// $("#circuit_status").html('Κλειστό');
		switch_d1_open.visible = false;
		switch_d1_closed.visible = true;
	}

	stage.update();
		
	return status;
}


// Control Switch D1
function toggle_switch_d2(d1, r1) {

	var status = '';

	if (d1==true && (r1 >= 500 && r1 <=4500)) {
		status = 'closed';
	} else {
		status = 'open';
	}

	// display results
	// console.log(status);
	if (status=='open')	{
		// $("#circuit_status").html('Ανοικτό');
		$("#moter_status span").html('εκτός λειτουργίας');
		$("#moter_status").removeClass("blink_me");
		circuit_closed.visible = false;
		circuit_open.visible = true;
		motor_on.visible = false;
		motor_off.visible = true;
		stop_compressor_animation();
	} else {
		// $("#circuit_status").html('Κλειστό');
		$("#moter_status span").html('σε λειτουργία!');
		$("#moter_status").addClass("blink_me");
		circuit_open.visible = false;
		circuit_closed.visible = true;
		motor_off.visible = false;
		motor_on.visible = true;
		show_compressor_animation();
	}

	stage.update();
		
	return status;
}


function show_compressor_animation() {

	motor_on.x = config.center_x + 324;
	motor_on.y = config.center_y + 142;

	// Move compressor
	createjs.Tween.get(motor_on, {loop:true})
		.to({x:motor_on.x - 2}, 324)
		.to({x:motor_on.x + 2}, 142);


	// Update stage
	stage.update();

	return true;

}


function stop_compressor_animation() {

	createjs.Tween.removeTweens(motor_on);

	motor_on.x = config.center_x + 324;
	motor_on.y = config.center_y + 142;
	
	// Update stage
	stage.update();

	return true;

}



function format_number_el(val) {
	// Get a javascript float number with decimal .
	// Replace decimal . with , and returns a string with the number formated with greek locale
	var num = val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ";"); // convert to string with thousands separator as ;
	num = num.replace(".", ","); // replace decimal separator with ,
	num = num.replace(new RegExp(";", 'g'), "."); // replace thousands separator with .

	return num;
}

function convert_to_number_el(val) {
	// Get a string formated with greek locale (thousands separator as . and decimal separator as ,)
	// and return a javascript float number with decimal .
	var num = val.replace(".", "");  // remove thousands separator
	num = num.replace(",", ".");     // replace decimal separator with .
	num = parseFloat(num);

	return num;
}