// Create Canvas elements



// Initialize Canvas
var canvas = document.getElementById("canvas");
var context = canvas.getContext('2d');
var stage = new createjs.Stage("canvas");


// Open Circuit Image
var image_circuit_open = new Image();
image_circuit_open.src = 'images/relay-circuit-open.png';

var circuit_open = new createjs.Bitmap(image_circuit_open);
circuit_open.scaleX = circuit_open.scaleY = 1;
circuit_open.x = config.center_x - 400;
circuit_open.y = config.center_y - 240;

image_circuit_open.onload = function () {
	stage.addChild(circuit_open);
	stage.setChildIndex(circuit_open, 0);
	stage.update();
}


// Closed Circuit Image
var image_circuit_closed = new Image();
image_circuit_closed.src = 'images/relay-circuit-closed.png';

var circuit_closed = new createjs.Bitmap(image_circuit_closed);
circuit_closed.scaleX = circuit_closed.scaleY = 1;
circuit_closed.x = config.center_x - 400;
circuit_closed.y = config.center_y - 240;

image_circuit_closed.onload = function () {
	stage.addChild(circuit_closed);
	stage.setChildIndex(circuit_closed, 0);
	stage.update();
}


// Engine Inactive Image
var image_motor_off = new Image();
image_motor_off.src = 'images/motor-off.png';

var motor_off = new createjs.Bitmap(image_motor_off);
motor_off.scaleX = motor_off.scaleY = 0.8;
motor_off.x = config.center_x + 324;
motor_off.y = config.center_y + 142;

image_motor_off.onload = function () {
	stage.addChild(motor_off);
	stage.setChildIndex(motor_off, 100);
	stage.update();
}


// Engine Active Image
var image_motor_on = new Image();
image_motor_on.src = 'images/motor-on.png';

var motor_on = new createjs.Bitmap(image_motor_on);
motor_on.scaleX = motor_on.scaleY = 0.8;
motor_on.x = config.center_x + 324;
motor_on.y = config.center_y + 142;

image_motor_on.onload = function () {
	stage.addChild(motor_on);
	stage.setChildIndex(motor_on, 100);
	stage.update();
}


circuit_open.visible = true;
circuit_closed.visible = false;
motor_off.visible = true;
motor_on.visible = false;



// Amper Meter
var ammeter_text = new createjs.Text();
ammeter_text.font = "20px digital-7";
ammeter_text.textAlign = "right";
ammeter_text.text = "00.00mA";

ammeter_text.x = config.center_x + 130;
ammeter_text.y = config.center_y + 40;
stage.addChild(ammeter_text);


// Switch D1 open
var switch_d1_open = new createjs.Shape();
switch_d1_open.graphics.beginFill("#000000").drawRoundRect(0, 0, 16, 4, 0);
switch_d1_open.x = config.center_x - 262;
switch_d1_open.y = config.center_y - 103;
switch_d1_open.rotation = -40;
stage.addChild(switch_d1_open);
switch_d1_open.visible = false;


// Switch D1 closed
var switch_d1_closed = new createjs.Shape();
switch_d1_closed.graphics.beginFill("#ff9c00").drawRoundRect(0, 0, 13, 5, 0);
switch_d1_closed.x = config.center_x - 259;
switch_d1_closed.y = config.center_y - 101;
stage.addChild(switch_d1_closed);
switch_d1_closed.visible = false;


// Switch D1 click area
var switch_d1_area = new createjs.Shape();
switch_d1_area.graphics.beginFill("rgba(255, 255, 255, 0.01)").drawRoundRect(0, 0, 35, 20, 0);
switch_d1_area.x = config.center_x - 270;
switch_d1_area.y = config.center_y - 110;
switch_d1_area.cursor = "pointer"; // show pointer on mouseover
stage.addChild(switch_d1_area);



// Update stage
stage.update();

// Enable Mouseover on stage
stage.enableMouseOver();


