/* 
 * Graphics Framework
 * copyright Dimitrios Al. Aggelis
 */
/* global THREE, Detector */
"use strict";

  //console.log(this.childs[i].checked);
var GF = function () {
    "use strict";
    var debugs=[];
    var edeltay=0;
    var interval = 1 / 1111; ///  1/fps
    var frames = 0;
    var fps = 0;
    var fpst = 0;
    var fpst0 = 0;
    var logw = 1280;
    var logh = 720;
    var mobile = false; // if touch screen mobile=true
    //var wheeldelta=0;
    var colorbutton = "#F0F0F1";
    var colorwin ="#FFFEFA"; 
    var colorbody ="#000000"; 
    var colorcheck = "#FCFFE6";  
    var colortext="#18005C";
    var colortitle="#FF9900";
    var colortitle0="#fff0db";
    var image1;
    var check1;
    var check2;
    var radio1;
    var radio2;
    var iconhome;
    var icontrig;
    var iconinfo;
    var iconwave;
    var clock1;
    var clock2;
    var clock3, clock4, clock5, clock6, clock7;
    var iconrgb;
    var iconhelp, iconabout, iconclose;
    var gsc = 1; //// global scale 
    var gok = false; /// if all ready then start scene manager 
    var vectorth = Math.PI * 0.85;
    var clicks = []; // list of clicked objects in a scene;
    var MOUSEDOWN = -1;
    var MOUSEUP = -2;
    var MOUSEMOVE = -3;
    var TOUCHSTART = -4;
    var TOUCHMOVE = -5;
    var TOUCHEND = -6;
    var KEYDOWN = -7;
    var KEYUP = -8;
    var MOUSEWHEEL = -9;
    // Find the right method, call on correct element
    var MULTISTATE = -16; //// 
    var BUTTONCOMMAND = -17; /// command button with parameter list []
    var PUSHBUTTON = -18;
    var SCROLLBAR = -19;
    var WINDOW = -20,
        LABEL = -21,
        BUTTON = -22,
        VSCROLLBAR = -23,
        HSCROLLBAR = -24;
    var LIST = -25,
        MLIST = -26,
        CHECK = -27,
        RADIO = -28,
        LISTITEM = -29;
    var SCNEXT = -30, ///// commands 
        SCPREVIOUS = -31,
        SCLAST = -32,
        SCFIRST = -33,
        SCANY = -34; //// COMMANDS need parameter a scene num
    var FSON = -38; //fullscreen on
    var FSOFF = -39; //off
    var DRAGMOVE = -40;
    var DRAGCLONE = -41;
    var APP = -42;
    var degtorad = Math.PI / 180.0;
    var pi = Math.PI;
    var twopi = 2 * Math.PI;
    var mousex = 0;
    var mousey = 0;
    var key1 = false; //key 1 pressed
    var mousest = 122; // mousest=  mouse down =1 drag 2 up with drag=2 mst=3(drop)
    //// mst=4 just up 
    var mousemove = false;
    var mousex0 = 0;
    var mousey0 = 0; /// when drag start
    var dragx = 0;
    var dragy = 0; /// x,y of window dragged;
    var overover = undefined;
    var pressedobject = undefined;
    var overobject = undefined; // which instance button downed
    var overobject2 = undefined;// id dragged previous over
    var draggedobject = undefined;
    var clickedobject = undefined;
    //var pressedpush=undefined; /// which pushbutton pressed
    var drop = 1;
    ////////////////////////////////
    var time0 = 0; // initial millis 
    var time1 = 0; // current 
    var time = 0; /// since program startd
    ///var timescale = 1;
    var timedelta = 0;
    ///// canvas, windoww ,winh 
    //// canvas2 and canvas3d logw logh
    var keysDown = {
        mx: 0,
        my: 0
    }; // holds keycode if pressed
    var keycode = -1; ///holds last key cod for test
    var canvas = document.getElementById("canvas");
    var canvas2 = document.getElementById("canvas2");
    var ctx2 = canvas2.getContext("2d");
    var imageresourcecount = 0;
    canvas.width = logw; //window.innerWidth; 
    canvas.height = logh; //window.innerHeight;
    var ctx = canvas.getContext("2d");
    var viewtr = new Transform();
    viewtr.scale(2.0, 2.0);
    var gtr1 = new Transform(); // global tranforms for debug use;
    var gtr2 = new Transform();
    /// --------------  3d globals app start ------------------------
    var pressedelement = 0; /// will receive window mouse up
    var raycaster, renderer, stats;
    var control3d = true; //// no controls cause a form no 3d pressed
    var focused;
    //var ratio; /// put by form3d 
    var container;
    var INTERSECTED = null;
    var canvas3d = getelement("canvas3d");
    canvas3d.width = logw;
    canvas3d.height = logh;
    //------------------------------------------------- 
    /// usefull for vector length
    function todecimal(n, digits) {
        return n.toFixed(digits);
    }

    function toround(n) {
        return Math.round(n);
    }

    function sign(x) {
        if (x > 0) return 1;
        if (x < 0) return -1;
        return 0;
    }

    function toint(x) {
        return parseInt(x);
    }

    function tofloat(str) {
        return parseFloat(str);
    }

    function rgb(r, g, b) {
        return ("rgb(" + r.toString() + "," + g.toString() + "," + b.toString() + ")");
    }

    function rgba(r, g, b, a) {
        return ("rgba(" + r.toString() + "," + g.toString() + "," + b.toString() + "," + a.toString() + ")");
    }

    function concat() {
        var st = "";
        for (var i = 0; i < arguments.length; i++) {
            st += " " + arguments[i];
        }
        return st;
    };
    //// dom elements support
    function getattr(el, str) {
        return el.getAttribute(str);
    }

    function setattr(el, str) {
        el.setAttribute(str);
    }
    /// string for id comma sep childs
    function appendchilds() {
        var el = getelement(arguments[0]);
        for (var i = 1; i < arguments.length; i++) {
            el.appendChild(arguments[i]);
        }
    }

    function setbackimage(el, str) {
        el.style.backgroundImage = "url(" + str + ")";
    }

    function setbackcolor(el, str) {
        el.style.backgroundColor = str;
    }

    function setelementpos(d, x_pos, y_pos) {
        d.style.position = "absolute";
        d.style.left = x_pos + 'px';
        d.style.top = y_pos + 'px';
    }
    /////----------------- global functions 
    function getlastchild() {
        if (clicks.length > 0) return clicks[clicks.length - 1];
        return undefined;
    } /// 
    //
    // 
    function getpreviouschild() {
        if (clicks.length > 1) return clicks[clicks.length - 2];
        return undefined;
    } /// 
    function unpress(aw) {
        if (aw) aw.pressed = 0;
    } /// 
    //
    function obtitle(ob) {
        if (ob === undefined) return "none";
        return ob.title;
    };

    function objectcompare(ob1, ob2) {
        if (!ob1) return false;
        if (!ob2) return false;
        return (ob1 === ob2);
    };
    //////  3 d    g e o m e t r y /////////////////////////////////////////////////
    function arrow() {
        //var dir = new THREE.Vector3(0, 0, 1);
        //normalize the direction vector (convert to vector of length 1)
        //dir.normalize();
        var origin = new THREE.Vector3(0, 0, 0);
        var length = 1;
        return new THREE.Arrow(0, 0, 1, origin, length, 0x336633, 0.08, 0.04, 0.01);
    }

    function sphere(radius, s1, s2, mat) {
        var geometry = new THREE.SphereBufferGeometry(radius, s1, s2);
        return new THREE.Mesh(geometry, mat);
    }

    function box(x1, y1, z1, mat) {
        var geometry = new THREE.BoxGeometry(x1, y1, z1);
        return new THREE.Mesh(geometry, mat);
    }

    function cylinder(segments, mat) {
        var geometry = new THREE.CylinderBufferGeometry(1, 1, 1, segments);
        geometry.translate(0, +0.5, 0);
        return new THREE.Mesh(geometry, mat);
    }

    function line(mat) {
        var geometry = new THREE.Geometry();
        geometry.vertices.push(new THREE.Vector3(0, 0, 0));
        geometry.vertices.push(new THREE.Vector3(1, 0, 0));
        return new THREE.Line(geometry, mat);
    }

    function lineupdate(aline) {
        aline.geometry.verticesNeedUpdate = true;
        if (aline.material.isLineDashedMaterial) {
            aline.computeLineDistances();
            aline.geometry.lineDistancesNeedUpdate = true;
        }
    }
 
    function lineset(aline, x1, y1, z1, x2, y2, z2) {
        aline.geometry.vertices[0].set(x1, y1, z1);
        aline.geometry.vertices[1].set(x2, y2, z2);
        lineupdate(aline)
    }

    function linestart(aline, x1, y1, z1) {
        aline.geometry.vertices[0].set(x1, y1, z1);
        lineupdate(aline)
    }

    function lineend(aline, x1, y1, z1) {
        aline.geometry.vertices[1].set(x1, y1, z1);
        lineupdate(aline)
    }

    function ngon(radius, num, mat) {
        var geometry = new THREE.Geometry();
        for (var i = 0; i <= num; i++) {
            var th = i * 2.0 * Math.PI / num;
            var x = radius * Math.cos(th);
            var y = radius * Math.sin(th);
            geometry.vertices.push(new THREE.Vector3(x, y, 0));
        }
        return new THREE.Line(geometry, mat);
    }

    function helix(radius, num, turns, mat) {
        var geometry = new THREE.Geometry();
        for (var i = 0; i <= num * turns; i++) {
            var th = i * 2.0 * Math.PI / num;
            var x = radius * Math.cos(th);
            var y = radius * Math.sin(th);
            geometry.vertices.push(new THREE.Vector3(x, y, 1 * i / turns / num));
        }
        return new THREE.Line(geometry, mat);
    }

    function concat() {
        var st = "";
        for (var i = 0; i < arguments.length; i++) {
            st += " " + arguments[i];
        }
        return st;
    };
    // Handle keyboard controls
    function setmouse(e, type) {
        var rect = canvas.getBoundingClientRect();
        mousex = e.clientX - rect.left;
        mousey = e.clientY - rect.top;
        var inv = new Transform(viewtr);
        inv.invert();
        //*************    mousex mouse y transformed by view 
        var poi = inv.transformPoint(mousex, mousey);
        mousex = poi[0];
        mousey = poi[1];
        ///***********
        mousemove = false;
        if (type === MOUSEWHEEL) {
            // wheeldelta+=e.deltaY;
            sm.onevent(e, type);
        }
        if (type === MOUSEDOWN) {
            mousest = 1;
            mousex0 = mousex;
            mousey0 = mousey; // for drag  
            sm.onevent(e, MOUSEDOWN);
        }
        if (type === MOUSEUP) {
            if (mousest === 2) {
                mousest = 3;
            } else {
                mousest = 4;
            }
            sm.onevent(e, MOUSEUP);
        }
        if (type === MOUSEMOVE) {
            if (mousest === 1) {
                mousest = 2;
            };
            if (mousest === 2) mousemove = true;
            sm.onevent(e, MOUSEMOVE);
        }
    }; /// set mouse 
    // 
    function setkeys(e, type) {
        if (type === KEYDOWN) {
            sm.onevent(e, KEYDOWN);
        }
        if (type === KEYUP) {
            sm.onevent(e, KEYUP);
        }
        keycode = e.keyCode;
    };

    function initialize() { //// ------------E v e n t   f r o m  O S    -----------------------------
        /// class        
        // Register an event listener to call the resizeCanvas() function 
        // each time the window is resized.
        addEventListener('resize', onresize, false);
        addEventListener("wheel", function (e) {
            setmouse(e, MOUSEWHEEL);
        }, false);
        //window.addEventListener('orientationchange', resizeCanvas,false);
        addEventListener("keydown", function (e) {
            keysDown[e.keyCode] = true;
            setkeys(e, KEYDOWN);
            e.preventDefault();
        }, false);
        addEventListener("keyup", function (e) {
            delete keysDown[e.keyCode];
            setkeys(e, KEYUP);
            e.preventDefault();
            if (keycode === 33) {
                keycode = -1;
                fullscreenon();
            }
            if (keycode === 34) {
                keycode = -1;
                fullscreenoff();
            }
        }, false);
        addEventListener("mousedown", function (e) {
            setmouse(e, MOUSEDOWN);
            e.preventDefault();
        }, true);
        addEventListener("mousemove", function (e) {
            setmouse(e, MOUSEMOVE);
            e.preventDefault();
        }, !false);
        addEventListener("mouseup", function (e) {
            setmouse(e, MOUSEUP);
            e.preventDefault();
        }, !false);
        addEventListener("touchstart", function (e) {
            mobile = true; /// touch down no mouse  
            var touchobj = e.changedTouches[0];
            e.preventDefault();
            setmouse(touchobj, MOUSEDOWN);
        }, false);
        addEventListener("touchmove", function (e) {
            var touchobj = e.changedTouches[0];
            e.preventDefault();
            setmouse(touchobj, MOUSEMOVE);
        }, false);
        addEventListener("touchend", function (e) {
            var touchobj = e.changedTouches[0];
            e.preventDefault();
            setmouse(touchobj, MOUSEUP);
        }, false);
        onresize();
    }

    function resizecanvas() {
       
        canvas.width = window.innerWidth;
        canvas.height = canvas.width * logh / logw;
        var px = 0;
        var py = (window.innerHeight - canvas.height) / 2;
        if (canvas.height > window.innerHeight) {
            canvas.height = window.innerHeight;
            canvas.width = canvas.height * logw / logh;
            py = 0;
            px = (window.innerWidth - canvas.width) / 2;
        }
        setelementpos(canvas, px, py);
        setelementpos(canvas3d, px, py);
        //canvas3d.width = canvas.width;
       // canvas3d.height = canvas.height;
        // var wsc=canvas.width/logw;
        //var ifr=getelement("iframehelp");
        //var icw=ifr.contentWindow.document.body;
        /// ifr.width  =icw.scrollWidth/4;
        //ifr.height =icw.scrollHeight/4;
        // alert  (ifr.width)
        //scaleelement(getelement("help"),gsc,gsc);
    }

    function onresize() {
        //canvas.width =   window.innerWidth;
        //canvas.height =  window.innerHeight;
        resizecanvas();
        sm.onresize();
    }
    //------------------   definition classes
    /// class         ---------------------------- ImageResource     -----------------------------
    function ImageResource(filename) {
        this.filename = filename;
        this.image = new Image();
        this.isready = false;
        this.imw;
        this.imh;
        //this.ratio;
        var other = this;
        this.image.onload = function () {
            other.onloadcall();
        };
        this.image.src = filename;
        imageresourcecount++;
        this.onloadcall = function () {
            this.imw = this.image.naturalWidth;
            this.imh = this.image.naturalHeight;
            //this.ratio=this.imw/this.imh;
            this.isready = true;
            imageresourcecount--;
            //if(this.isready) { window.alert("jsjsjsjsj "+this.isready);} 
        };
        this.draw = function (ctx, x, y) {
            if (this.isready) {
                ctx.drawImage(this.image, x, y);
            }
        };
    } //// end ImageResource definition
    /// class         ---------------------------- Actor    -----------------------------
    function BBox() {
        this.init();
    }
    BBox.prototype.init = function () {
        this.xmin = Number.MAX_VALUE;
        this.ymin = Number.MAX_VALUE;
        this.zmin = Number.MAX_VALUE;
        this.xmax = Number.MIN_VALUE;
        this.ymax = Number.MIN_VALUE;
        this.zmax = Number.MIN_VALUE;
    };
    BBox.prototype.addpoint = function (x, y, z) {
        this.xmin = Math.min(x, this.xmin);
        this.xmax = Math.max(x, this.xmax);
        this.ymin = Math.min(y, this.ymin);
        this.ymax = Math.max(y, this.ymax);
        this.zmin = Math.min(z, this.zmin);
        this.zmax = Math.max(z, this.zmax);
    };

    function Actor(imres, x, y, rot, scx, scy) {
        this.imres = imres;
        this.pivotx = 128;
        this.pivoty = 16;
        this.x = x;
        this.y = y;
        this.rot = rot;
        this.scx = scx;
        this.scy = scy;
        this.v = 0;
        this.v0 = 0;
    }
    Actor.prototype.draw = function (ctx) {
        if (this.imres.isready) {
            ctx.save();
            ctx.translate(this.x, this.y);
            ctx.rotate(this.rot * degtorad);
            ctx.scale(this.scx, this.scy);
            ctx.translate(-this.pivotx, -this.pivoty);
            ctx.drawImage(this.imres.image, 0, 0);
            ctx.restore();
        }
    };

    function Actor2(imres, x, y, rot, scx, scy) {
        Actor.call(this, imres, x, y, rot, scx, scy);
    }
    Actor2.prototype = Object.create(Actor.prototype);
    Actor2.prototype.constructor = Actor2;
    Actor2.prototype.draw = function (ctx) {
        Actor.prototype.draw.call(this, ctx);
    };
    /// class         ---------------------------- F o r m    -----------------------------
    function Form(id, title, x, y, width, height, imageres) {
        // "use strict"
       
        this.cursor = "default";
        this.picktype = 1; /// 1rect 2 ;ellipse contains overrid e else i     //
        this.wheeldelta = 0;
        //// if want clip ellipse clip(1);
        this.cliptype = 0; /// 0 no clip 1 cliprect 2 clip circle; else override clip
        this.composition = "source-over";
        this.visible = true; /// use it in custom draw
        this.drawbackground = true;
        this.drawoutline = false;
        this.corner = 0; //if corner>0 draws roundrect outline
        this.clipped = false; // if clipped  then clips children too;
        this.tr = new Transform();
        this.wtr = new Transform(); // view * tr 
        this.commandlist = []; //   at any not defined go menu // 
        this.command = 0; ///no command 
        this.t = 0; ///time
        this.dt = 0;
        this.timescale = 1;
        this.stopped = true;
        this.pickable = true;
        ////// update in draw;
        this.id = id; /// no command  = 0 
        ///------------------------values--------------------
        this.min = 0;
        this.max = 100;
        this.value = 33; /// case scroll bar
        this.valuename = "";
        this.valueunit = "";
        this.valuedigits = 2; // accuracy;
        this.valuedisplay = false;
        this.valuex = 0;
        this.valuey = 0;
        this.kind = WINDOW;
        this.subkind = 0; /// or radio ///
        ///// if subkind =check then multi and appropriate images
        ////-----------------------
        //// if list ,mlist, check box, radio button
        this.checked = false; //// usefull as child
        this.selecteditem; /// last  checked each time usefull for list and radios
       
        this.state = 0;
        //this.numstates = 0; //// for multistate count childs 
        this.multiselect = false; //false;
        this.rows = 1; /// update columns; rows auto;
        this.cols = 1;
        this.backcolor = colorwin;
        this.textcolor = colortext;
        this.draggable = false;
        this.dropable = false;
        this.dragtype = 0; /////  DRAGMOVE ,DRAFCLONE ;
        this.droptypes = [];
        ////////////////this.sm=0; //////no  scene manager no notify  //// 
        this.pressed = 0;
        this.depressed = 1;
        this.texth = 20; //text height 
        this.textcentered=true; //center left
        this.texthor="";
        this.texver="";
        this.parent = 0;
        if (imageres !== undefined) this.imageres = imageres;
        this.title = title;
        this.x = x; /// local
        this.y = y;
        this.xg = x; /// global by getparentpos;
        this.yg = y; /// 
        this.x0 = x;
        this.y0 = y;
        this.width = width;
        this.height = height;
        this.texts = []; /// 
        this.childs = []; ///
        this.xorig = 0; /// functions xo;yorigin
        this.yorig = 0;
        this.clickx = 0;
        this.clicky = 0; /// for click pos in win (local coords)
        this.setorigin(0, 0);
    } // end window definition 
    Form.prototype.centerhor = function () {
        var nx = 0;
        if (this.parent) nx = (this.parent.width - this.width) / 2;
        else nx = (logw - this.width) / 2;
        this.x = nx;
         
    }
    Form.prototype.centerver = function () {
        var nv = 0;
        if (this.parent) nv = (this.parent.height - this.height) / 2;
        else nv = (logh - this.height) / 2;
        this.y = nv;
    }
    Form.prototype.bottom = function (d) {
        var nv = 0;
        if (this.parent) nv = this.parent.height - this.height - d;
        else nv = logh - this.height - d;
        this.y = nv;
    }
    Form.prototype.right = function (d) {
        var nv = 0;
        if (this.parent) nv = this.parent.width - this.width - d;
        else nv = logw - this.width - d;
        this.x = nv;
    }
    
    
    Form.prototype.setvaluepos = function (ax, ay) {
        this.valuex = ax;
        this.valuey = ay;
    }
    Form.prototype.setvaluedescr = function (aname, aunit, adigits) {
        this.valuename = aname;
        this.valueunit = aunit;
        this.valuedigits = adigits;
    }
    Form.prototype.create = function () {}
    Form.prototype.init = function () {}
    Form.prototype.update = function () {}
    Form.prototype.render = function () {}
    Form.prototype.setbackcolor = function (r, g, b, a) {
        this.backcolor = rgba(r, g, b, 1 || a);
    }
    Form.prototype.drawimage = function (imageres, tw, th, centered) {
        if (!imageres) return;
        if (!imageres.image) return;
        var imw = imageres.imw;
        if (!imw) imw = logw;
        var imh = imageres.imh;
        if (!imh) imh = logh;
        var nw, nh;
        nw = tw;
        nh = tw * imh / imw;
        var px = 0;
        var py = (th - nh) / 2;
        if (nh > th) {
            nh = th;
            nw = th * imw / imh;
            py = 0;
            px = (tw - nw) / 2;
        }
        if (!centered) {
            px = 0;
            py = 0
        };
        ctx.drawImage(imageres.image, this.xg + px, this.yg + py, nw, nh);
    }
    Form.prototype.drawline = function (x1, y1, x2, y2, linestyle) {
        ctx.beginPath();
        if (linestyle) ctx.strokeStyle = linestyle;
        ctx.moveTo(x1 + this.xorig, this.yorig - y1);
        ctx.lineTo(x2 + this.xorig, this.yorig - y2);
        ctx.stroke();
    }
    Form.prototype.drawpolar = function (x, y, r, thrad, linestyle) {
        drawpolar(ctx, x + this.xorig, this.yorig - y, r, -thrad, linestyle);
    }
    Form.prototype.clip = function () {
        ctx.save();
        var v = this.getparentpos();
        ctx.beginPath();
        ctx.lineWidth = "3";
        if (this.cliptype === 1) ctx.rect(v.x, +v.y, this.width, this.height);
        if (this.cliptype === 2) ctx.arc(v.x + this.width / 2, v.y + this.width / 2, this.width / 2, 0, twopi, false);
        ctx.clip();
    }
    Form.prototype.drawvector = function (x1, y1, x2, y2, linestyle) {
        var thrad = Math.atan2(y2 - y1, x2 - x1);
        var r = Math.sqrt((y2 - y1) * (y2 - y1) + (x2 - x1) * (x2 - x1));
        this.drawpolar(x1, y1, r, thrad, linestyle);
        this.drawpolar(x2, y2, 16, thrad + vectorth, linestyle);
        this.drawpolar(x2, y2, 16, thrad - vectorth, linestyle);
    }
    Form.prototype.drawpolarvector = function (x, y, r, thrad, linestyle) {
        this.drawvector(x, y, x + r * Math.cos(thrad), y + r * Math.sin(thrad), linestyle);
    }
    Form.prototype.dptolp = function (ax, ay) {
        /// tr -1 *  viewtr -1
        var inv = new Transform(this.tr);
        inv.invert();
        var sec = new Transform(viewtr);
        sec.invert();
        inv.multiply(sec);
        return inv.transformPoint(ax, ay)
    };
    Form.prototype.lptodp = function (ax, ay) {
        var inv = new Transform(this.wtr);
        inv.invert();
        //inv.multiply(this.tr);
        return inv.transformPoint(ax, ay)
    };
    Form.prototype.setorigin = function (xo, yo) {
        var v = this.getparentpos();
        this.xorig = v.x + xo;
        this.yorig = v.y + yo;
    }
    Form.prototype.drawarc = function (xo, yo, r, st, en, anticlock, linestyle) {
        ctx.beginPath();
        if (linestyle) ctx.strokeStyle = linestyle;
        st = twopi - st;
        en = twopi - en;
        if (st > en) {
            var tmp = st;
            st = en;
            en = tmp;
        }
        ctx.arc(xo + this.xorig, this.yorig - yo, r, st, en, anticlock);
        ctx.stroke();
    }
    Form.prototype.drawarcfilled = function (xo, yo, r, st, en, anticlock, linestyle) {
        ctx.beginPath();
        if (linestyle) ctx.fillStyle = linestyle;
        st = twopi - st;
        en = twopi - en;
        if (st > en) {
            var tmp = st;
            st = en;
            en = tmp;
        }
        ctx.moveTo(xo + this.xorig, this.yorig - yo);
        ctx.arc(xo + this.xorig, this.yorig - yo, r, st, en, anticlock);
        ctx.fill();
    }
    Form.prototype.drawfilltext = function (str, x, y, linestyle) {
        if (linestyle) ctx.fillStyle = linestyle;
        ctx.fillText(str, x + this.xorig, -y + this.yorig);
    }
    Form.prototype.drawcircle = function (xo, yo, r, linestyle) {
        this.drawarc(xo, yo, r, 0, twopi, false, linestyle);
    }
    Form.prototype.drawcirclefilled = function (xo, yo, r, linestyle) {
        this.drawarcfilled(xo, yo, r, 0, twopi, false, linestyle);
    }
    Form.prototype.drawball = function (xo, yo, r, linestyle) {
        var cx = xo + this.xorig;
        var cy = -yo + this.yorig;
        var grd = ctx.createRadialGradient(cx, cy, r / 10, cx, cy, r * 1.5);
        if (!linestyle) grd.addColorStop(0, "white");
        else grd.addColorStop(0, linestyle);
        grd.addColorStop(1, "black");
        // Fill with gradient
        //ctx.save();
        //ctx.beginPath();
        ctx.fillStyle = grd;
        //ctx.arc(xo + this.xorig, this.yorig - yo, r, 0, twopi);
        //ctx.fill();
        this.drawarcfilled(xo, yo, r, 0, twopi, false);
        // ctx.restore();      
    }
    Form.prototype.drawtext = function (text, x, y, fillstyle) {
        ctx.fillStyle = fillstyle;
        ctx.fillText(text, x + this.xorig, this.yorig - y);
    }
    Form.prototype.pause = function (b) {
        this.stopped = false;
        if (b) this.stopped = true;
    };
    Form.prototype.settime = function (atime) {
        this.t = atime;
    };
    Form.prototype.setvalues = function (amin, amax, avalue) {
        this.min = amin;
        this.max = amax;
        this.value = avalue;
        this.setscrollpos(amin, amax, avalue);
    };
    Form.prototype.setscrollpos = function (amin, amax, avalue) {
        this.min = amin;
        this.max = amax;
        this.value = avalue;
        if (this.kind !== SCROLLBAR) return;
        var ishor = false;
        var but = this.childs[1];
        var dis = 100;
        //this.y=(this.value-this.min)*dis/(this.max-this.min);
        if (this.width > this.height) ishor = true;
        if (ishor) {
           // alert (this.de)
            but.y = this.height - this.de-this.de/2;
            dis = this.width- but.width;
            but.x = (this.value - this.min) * dis / (this.max - this.min);
             //but.width = (this.value - this.min) * dis / (this.max - this.min);
              //but.x =0; 
        } else {
            but.x =  this.width - this.de-this.de/2;
            dis = this.height - but.height;
            but.y = (this.value - this.min) * dis / (this.max - this.min);
            //but.height = (this.value - this.min) * dis / (this.max - this.min);
             //but.y = 0; 
        }
    };
    Form.prototype.fixscrollbar = function (sb) {
        if (sb.kind !== SCROLLBAR) return;
        var ishor = false; //is vertical
        var dis = 0;
        var d1=0;
        var d2=0;
         
        if (sb.width > sb.height) ishor = true;
        
        if (ishor) {
           
            dis = (sb.clickx-sb.de/2 )/ (sb.width-sb.de);
            
        } else {
            dis =( sb.clicky -sb.de/2)/ (sb.height-sb.de);
        }
        
        if (dis < 0) dis = 0;
        if (dis > 1) dis = 1;
        sb.value = sb.min + dis * (sb.max - sb.min);
        sb.setvalues(sb.min, sb.max, sb.value);
    };
    Form.prototype.addapp = function (id, title) {
        var sb = new App(id, title);
        sb.kind = APP;
        this.addchild(sb);
        return sb;
    };
    Form.prototype.addform3d = function (id, title, x, y, w, h) {
        var nf = new Form3d(id, title, x, y, w, h);
        nf.kind = "3d";
        this.addchild(nf);
        return nf;
    };
    Form.prototype.addscrollbar = function (id, title, x, y, width, height, imageres) {
        var sb = new Form(id, title, x, y, width, height, imageres);
        sb.de=sb.height/2; // new attr 
        sb.rede=sb.height/8;
        sb.kind = SCROLLBAR;
        sb.valuedraw = true;
        sb.cursor = "pointer";
        sb.drawbackground = false;
         sb.drawoutline = false;
         /// hor
        var sbrect = sb.addform(0, "",sb.de/2,(height -sb.rede)/2, width-sb.de, sb.rede, imageres);
        //var sbrect = sb.addform(0, "", 0, 0  , width, height  , imageres);
        sbrect.pickable = false;
         sbrect.drawoutline = true;
         sbrect.backcolor=rgb(133,133,133);
        this.addchild(sb);
        /////add a test win
        var ishor = false;
        if (sb.width > sb.height) ishor = true; ///
        //var sbwi = sb.width/3;
       // var sbhi = sb.width/3;
        if (ishor) {
            sb.de=sb.height/2;
         //   sbwi = sb.height/3;
         //   sbhi = sb.height/3;// * 0.33;
        }
        if (!ishor) {
            sb.de=sb.width/2;
            sb.rede=sb.width/8;
             sbrect.x = (width -sb.rede)/2;
             sbrect.y = sb.de/2;
             sbrect.width =sb.rede;
            sbrect.height = height-sb.de;
        }
        var but = new Form(id, title, 0, 0, sb.de, sb.de, imageres);
        sb.addchild(but);
        but.corner=sb.de/2;
        //sbrect.corner=sb.de/2;
        but.pickable = false;
        but.draggable = true;
        but.backcolor = colorbutton; //rgb(128, 128, 178);
        sb.backcolor = colorwin; //rgb(200, 200, 200);
        sb.setscrollpos(sb.min, sb.max, sb.value);
        but.drawoutline = true;
         // but.drawbackground = false;
        return sb;
    };
    Form.prototype.addmultistate = function (id, title, x, y, width, height, imageres) {
        var nw = new Multistate(id, title, x, y, width, height, imageres);
        this.addchild(nw);
        nw.backcolor = rgb(255, 255, 255);
        nw.drawbackground=false;
        nw.drawoutline=false;
        nw.cursor = "pointer";
        return nw;
    };
    Form.prototype.addlabel = function (id, title, x, y, width, height, imageres) {
        var nw = new Form(id, title, x, y, width, height, imageres);
        nw.kind = LABEL;
        this.addchild(nw);
        return nw;
    };
    Form.prototype.addform = function (id, title, x, y, width, height, imageres) {
        var nw = new Form(id, title, x, y, width, height, imageres);
        this.addchild(nw);
        nw.backcolor = colorwin;
        return nw;
    };
    Form.prototype.addclosebutton = function (imageres) {
        var nw = this.addbutton(0, "x", this.width - 32, 0, 32, 32, imageres);
        var scope=this;
        nw.onclick = function () {
            scope.visible = false;
        }
        return nw;
    };
    Form.prototype.addbutton = function (id, title, x, y, width, height, imageres) {
        var nw = new Form(id, title, x, y, width, height, imageres);
        nw.kind = BUTTON;
        nw.cursor = "pointer";
        nw.backcolor = colorbutton; // rgb(155, 155, 155);
        nw.drawbackground = true;
        nw.drawoutline = true;
        this.addchild(nw);
        return nw;
    };
    Form.prototype.addbuttoncommand = function (command, plist, id, title, x, y, width, height, imageres) {
        var nw = this.addbutton(id, title, x, y, width, height, imageres);
        nw.kind = BUTTON;
        nw.backcolor = colorbutton; //rgb(155, 155, 155);
        nw.drawbackground = false;
        nw.command = command;
        nw.commandlist = [];
        for (var i = 0; i < plist.length; i++) {
            nw.commandlist.push(plist[i]);
        }
        //this.addchild(nw);
        return nw;
    };
    Form.prototype.addpushbutton = function (id, title, x, y, width, height, imageres) {
        var nw = this.addbutton(id, title, x, y, width, height, imageres);
        nw.kind = PUSHBUTTON;
        //this.addchild(nw);
        return nw;
    };
    ////////   addchild with proper image list mlist check combo
    Form.prototype.addlist = function (id, title, x, y, width, height, imageres) {
        var nw = new Form(id, title, x, y, width, height, imageres);
        nw.kind = LIST;
        nw.multiselect = false;
        this.addchild(nw);
        nw.backcolor = rgb(0, 250, 250);
        return nw;
    };
    Form.prototype.addmlist = function (id, title, x, y, width, height, imageres) {
        var nw = new Form(id, title, x, y, width, height, imageres);
        nw.kind = LIST;
        nw.multiselect = true;
        this.addchild(nw);
        nw.backcolor = rgb(0, 250, 250);
        return nw;
    };
    Form.prototype.addcheck = function (id, title, x, y, width, height, imageres) {
        var nw = new Form(id, title, x, y, width, height, imageres);
        nw.kind = LIST;
        nw.subkind = CHECK;
        nw.multiselect = true;
        this.addchild(nw);
        nw.backcolor = colorcheck;
        nw.drawoutline = true;
        return nw;
    };
    Form.prototype.addradio = function (id, title, x, y, width, height, imageres) {
        var nw = new Form(id, title, x, y, width, height, imageres);
        nw.kind = LIST;
        nw.subkind = RADIO;
        nw.multiselect = false;
        this.addchild(nw);
        nw.backcolor = colorcheck;
        nw.drawoutline = true;
        return nw;
    };
    Form.prototype.addlistitem = function (id, title, x, y, width, height, imageres) {
        var nw = new Form(id, title, x, y, width, height, imageres);
        nw.kind = LISTITEM;
        this.addchild(nw);
        nw.cursor = "pointer";
        //nw.backcolor=rgb(0,0,250);
        //nw.draggable=true;
        //
        return nw;
    };
    ///// pressed list item object so only this check on list 
    Form.prototype.listpressed = function (ob) {
        if (!this.multiselect) {
            for (var i = 0; i < this.childs.length; i++) {
                this.childs[i].checked = (ob === this.childs[i]);
            }
        }
    };
    /// recalc position 
    Form.prototype.setchilds = function (ax, ay, dx, dy,nw,nh) {
        var si;
        for (si = 0; si < this.childs.length; si++) {
            this.childs[si].x = ax + si * dx;
            this.childs[si].y = ay + si * dy;
            if (nw) this.childs[si].width = nw;
            if (nh) this.childs[si].height = nh;
         
        }
    };
     Form.prototype.setchildsarray = function (rows, cols, dx, dy) {
        var c,r;
        var i;
        for (r = 0; r < rows; r++) {
            
            for (c=0;c<cols;c++){
               i=cols*r+c;
               if(i<this.childs.length){
                   this.childs[i].x=c*dx;
                   this.childs[i].y=r*dy;
               }
                
            }
         
        }
    };
    
    Form.prototype.selectitem = function (n) {
        this.selecteditem = undefined;
        if (n < 0 || n > this.childs.length) return;
        this.selecteditem = this.childs[n];
        this.childs[n].checked = true;
         if (this.multiselect) return;/// 
         var i;
         for (i=0;i<this.childs.length;i++){
             this.childs[i].checked= (n===i); 
           
         }
        
    };
    Form.prototype.unselectitem = function (n) {
        this.selecteditem = undefined;
        if (n < 0 || n > this.childs.length) return;
        this.childs[n].checked = false;
    };
    Form.prototype.checklist = function (n) {
        if (n < 0 || n > this.childs.length) return false;
        if (this.kind !== LIST) return false;
        if (!this.multiselect) return this.selecteditem === this.childs[n];
        return this.childs[n].checked;
    };
    Form.prototype.checkeditem = function (n) {
        if (n < 0 || n > this.childs.length) return false;
        if (this.kind !== LIST) return false;
        return this.childs[n].checked;
    };
    Form.prototype.setkind = function (kind) {
        this.kind = kind;
    };
    Form.prototype.setsubkind = function (akind) {
        this.subkind = akind;
    };
    Form.prototype.contains = function (ax, ay) {
        if (!this.pickable) return false;
        var v = this.getparentpos();
        if (ax < v.x) return false;
        if (ay < v.y) return false;
        if (ax > this.width + v.x) return false;
        if (ay > this.height + v.y) return false;
        /////
        //// ok now we have hit win 
        // 
        this.clickx = ax - v.x;
        this.clicky = ay - v.y;
        ///********
        if (this.picktype === 1) return true;
        if (this.picktype === 2) {
            var cx = v.x + this.width / 2;
            var cy = v.y + this.height / 2;
            //return ((cx-ax)*(cx-ax)+(cy-ay)*(cy-ay)<this.width/2*this.width/2);
            return Math.pow(cx - ax, 2) + Math.pow(cy - ay, 2) < Math.pow(this.width / 2, 2);
        }
        return false;
    };
    Form.prototype.addtext = function () {
        var st="";
        for (var i = 0; i < arguments.length; i++) {
            st+=arguments[i]+" ";
            //this.texts.push(arguments[i]);
            ///// this.msg("hello from log"); works !!!!!!!!
        }
         this.texts.push(st);
    };
    Form.prototype.addchild = function () {
        for (var i = 0; i < arguments.length; i++) {
            this.childs.push(arguments[i]);
            arguments[i].parent = this;
        }
    };
    Form.prototype.getparentpos = function () {
        var parx = this.x;
        var pary = this.y;
        var v = this.parent;
        while (v !== 0) {
            parx += v.x;
            pary += v.y;
            v = v.parent;
        }
        /// ok update 
        this.xg = parx;
        this.yg = pary;
        return {
            x: parx,
            y: pary
        };
    };
    Form.prototype.devtolog = function (ax, ay) {
        //  -this.xorig+mousex,this.yorig-mousey	
        return {
            x: ax - this.xorig,
            y: -ay + this.yorig
        };
    };
    Form.prototype.logtodev = function (ax, ay) {
        return {
            x: ax + this.xorig,
            y: -ay + this.yorig
        };
    };
    Form.prototype.checkmouse = function (x, y) {
        ////// fills clicks[] for win
        // maybe for all forms not to overlap
        if (!this.visible) return;
        if (this.contains(x, y)) clicks.push(this);
        for (var i = 0; i < this.childs.length; i++) {
            this.childs[i].checkmouse(x, y);
        }
    };
    Form.prototype.onwheel = function (e) {
        /// do whatever 
    }; //// end onmdt
    Form.prototype.onmousedown = function () {
        /// do whatever 
    }; //// end onmdt
    Form.prototype.onmousemove = function () {
        /// do whatever 
    }; //// end onm mv
    Form.prototype.onmouseup = function () {};
    Form.prototype.onclick = function () {
        /// do whatever 
    };
     Form.prototype.ondrop = function () {
        /// do whatever  droppedobject dropped over  oveobject2
    };
    Form.prototype.onevent = function (e, type) {
        /////  handle childs event first 
        ///// useless until now 
        if (type === MOUSEDOWN) {}
        var i = 0;
        // for (i=this.childs.length-1;i>-1;i--){
        //    this.childs[i].onevent(e,type);
        //}   
        for (i = 0; i < this.childs.length; i++) {
            this.childs[i].onevent(e, type);
        }
        ///// now its time to handle which mousedown
    }; //// end windo onevent
    ////
    Form.prototype.setpos = function () {
       
        var v = this.getparentpos();
        this.xg = v.x + this.pressed;
        this.yg = v.y + this.pressed;
        
    };
    Form.prototype.settime = function () {
        this.dt = timedelta * this.timescale * (!this.stopped);
        this.t += this.dt;
        if (this.t < 0) this.t = 0;
       
    }
    
    
    Form.prototype.setpost = function () {
        this.setpos();
        this.settime();
        this.update();
    };
    Form.prototype.below = function (aform,d) {
        aform.setpos();
        this.x=aform.xg;
        this.y=aform.yg+d+aform.height;
        
    }
    
    Form.prototype.draw = function (ctx) {
        if (!this.visible) return;
        this.setpost(); /// position x y and time
        /// with drawchilds(ctx) no need all stuff 
        ctx.globalCompositeOperation = this.composition;
        if (this.cliptype > 0) this.clip();
        var selcolorink = this.textcolor;
        ctx.lineWidth = "4";
        ctx.strokeStyle = "white";
        if (this.kind === LABEL) {
            
        }
        ctx.fillStyle = this.backcolor;
        ///var drawbackground = true;
        /// if list dont draw background
        if (this.kind === LISTITEM) {
            this.drawbackground = false;
            if (this.parent.subkind === CHECK) {
                this.imageres = check1;
            }
            if (this.parent.subkind === RADIO) {
                this.imageres = radio1;
            }
            ///// if non multistate 
            if (this.parent.multiselect && this.checked) {
                this.drawbackground = true;
                selcolorink = "white";
                ctx.fillStyle = "blue"; ///rgb(123,123,123);
                if (this.parent.subkind === CHECK) {
                    this.imageres = check2;
                }
                if (this.parent.subkind === RADIO) {
                    this.imageres = radio2;
                }
            }
            if (!this.parent.multiselect && this === this.parent.selecteditem) {
                this.drawbackground = true;
                selcolorink = "white";
                ctx.fillStyle = "blue"; ///rgb(123,123,123);
                if (this.parent.subkind === CHECK) {
                    this.imageres = check2;
                }
                if (this.parent.subkind === RADIO) {
                    this.imageres = radio2;
                }
            }
            if (this.parent.subkind === CHECK || this.parent.subkind === RADIO) {
                this.drawbackground = false;
                selcolorink = this.textcolor;
            }
        } /// end is listitem 
        if (this.drawbackground) {
            if (this.corner <= 0) {
              ctx.fillRect(this.xg, this.yg, this.width, this.height);  
            } else {
                drawroundrect(ctx, this.xg, this.yg, this.width, this.height, this.corner, 1);
            }
            
           
        }
        if (this.drawoutline) {
            ctx.strokeStyle = "grey";
            ctx.lineWidth = "1";
            if (this.corner <= 0) {
                ctx.beginPath();
                ctx.rect(this.xg, this.yg, this.width, this.height);
                ctx.stroke();
            } else {
                drawroundrect(ctx, this.xg, this.yg, this.width, this.height, this.corner, 0);
            }
        }
       
        ctx.fillStyle = selcolorink;
       
        ctx.font = this.texth + "px Helvetica";
         ctx.textAlign = "left";
        if (this.textcentered) ctx.textAlign = "center";
        ctx.textBaseline = "middle";
        var ofsx =  this.xg + this.width / 2*this.textcentered;
        var ofsy = this.yg + this.height / 2 ;
        /// to scale image
        var imx, imy;
       
        if (this.kind === LISTITEM) {
            //imx = this.xg + (this.width - this.imageres.imw) / 2;
            //imy = this.yg + (this.height - this.imageres.imh) / 2;
            ctx.textBaseline = "middle";
            ofsx = this.xg + this.height;
            var ofsy = this.yg + this.height / 2;
            ctx.textAlign = "start";
            
        }
        
        ctx.fillText(this.title, ofsx, ofsy);
        ctx.textAlign = "start";
        //ctx.textBaseline = "top";
        //if (this.valuedraw) ctx.fillText(this.valuename + "=" + todecimal(this.value, this.valuedigits) + " " + this.valueunit, this.xg + this.valuex, this.height / 2 + this.yg + this.valuey)
        this.drawtexts(ctx);
        /// draw image
        if (this.imageres) {
            imx = this.xg + (this.width - this.imageres.imw) / 2;
            imy = this.yg + (this.height - this.imageres.imh) / 2;
            if (this.kind === LISTITEM) {
                imx = this.xg + (this.height - this.imageres.imw) / 2;
                imy = this.yg + (this.height - this.imageres.imh) / 2;
                ctx.drawImage(this.imageres.image, imx, imy);
            } else {
                this.drawimage(this.imageres, this.width, this.height, true)
            };
            //his.drawimage()
        }
        ///// draw childs
        this.drawchilds(ctx);
        if (this.valuedraw) ctx.fillText(this.valuename + "=" + todecimal(this.value, this.valuedigits) + " " + this.valueunit, this.xg + this.valuex, this.height / 2 + this.yg + this.valuey)
         
        ctx.globalCompositeOperation = "source-over";
         
        if (this.cliptype > 1) ctx.restore();
    }; /// end draw definition
    // 
    // 
    Form.prototype.drawchilds = function (ctx) {
        for (var i = 0; i < this.childs.length; i++) {
            this.childs[i].draw(ctx);
        }
    }
    Form.prototype.drawtexts = function (ctx) {
        var i = 0;
        // draw texts
        for (i = 0; i < this.texts.length; i++) {
            ctx.fillText(this.texts[i], 8 + this.xg, (i + 1) * this.texth + this.yg);
        }
    }

    function Form3d(id, title, x, y, width, height) {
        Form.call(this, id, title, x, y, width, height);
        this.hitlist = [];
        this.kind = "3d"
        this.scene;
        this.camera;
        this.light;
        this.mouse3d = {
            x: -1,
            y: -1
        };
        // start 3d def
        this.camera = new THREE.PerspectiveCamera(33, window.innerWidth / window.innerHeight, 0.01, 40);
        this.camera.position.set(0, 0, 7);
        this.camera.lookAt(0, 0, 0);
        this.scene = new THREE.Scene();
        this.scene.background = new THREE.Color(0x000000);
        /////scene.fog = new THREE.Fog( 0xa0a0a0, 200, 10000 );
        //var grid = new THREE.GridHelper(10, 10, 0xff00ff, 0xff0000);
        //this.scene.add(grid);
        raycaster = new THREE.Raycaster();
        //var box3 = box(mat);
        //this.scene.add(box3);
        //this.hitlist.push(box3);
        this.p0 = this.scene.rotation.clone(); //this.scene.position.clone();
        this.r0 = this.scene.rotation.clone();
        this.sc0 = this.scene.scale.clone();
        // end 3d def
    }
    Form3d.prototype = Object.create(Form.prototype);
    Form3d.prototype.constructor = Form3d;
    Form3d.prototype.onwheel = function (e) {
        this.wheeldelta = -0.1 * sign(e.deltaY);
        edeltay=e.deltaY;
        //var nsc=this.sc0.x+((mousey-mousey0)/1280*wheel/100);
        //var nsc=this.sc0.x+e.deltaY/1000;
        //var nsc=this.sc0.x+this.wheeldelta ;
        var nsc = this.scene.scale.x + this.wheeldelta;
        if (nsc < 0.1) {
            nsc = 0.1;
            this.wheeldelta =-this.sc0.x +0.1 ;
        }
        this.scene.scale.x = nsc;
        this.scene.scale.y = nsc;
        this.scene.scale.z = nsc;
        
    }; //
    
     Form3d.prototype.setscale = function (nsc) {
        
        this.scene.scale.x = nsc;
        this.scene.scale.y = nsc;
        this.scene.scale.z = nsc;
         this.sc0.copy( this.scene.scale );
    }; //
    
    Form3d.prototype.draw = function (ctx) {
        //Form.prototype.draw.call(this, ctx);  /// any way if must draw childs etc
        //or 
        if (!this.visible) {
            return;
        }
        if (control3d && mousemove && pressedobject === this) {
            // drag view 
            //this.scene.rotation.z = this.r0.z + ((mousex - mousex0) / 314);
            this.scene.rotation.x = this.r0.x + ((mousey - mousey0) / 314);
            //this.scene.position.x = this.p0.x + ((mousex - mousex0) / 150);
            //this.scene.position.y = this.p0.y + ((mousey - mousey0) / 150);
        }
        this.texts = [];
        //this.addtext(this.scene.rotation.y, this.r0.x, mousex - mousex0);
        this.setpost();
        // *** not set mobile resize failure //renderer.setPixelRatio(window.devicePixelRatio);
        this.camera.aspect = this.width / this.height;
        this.camera.updateProjectionMatrix();
        //renderw=this.width;
        //renderh=this.height;
        this.mouse3d.x = ((mousex - this.xg) / this.width) * 2 - 1;
        this.mouse3d.y = -((mousey - this.yg) / this.height) * 2 + 1;
        renderer.setViewport(0, 0, this.width, this.height);
        renderer.setSize(logw, logh);
        renderer.setPixelRatio(window.devicePixelRatio);
         //renderer.setSize(this.width, this.height);//
        animate3d(this.scene, this.camera, this.mouse3d, this.hitlist);
        ctx.drawImage(canvas3d, 0, 0, this.width, this.height  );
        ///old was ..,xg ,yg ,width ,height
        this.drawchilds(ctx);
        this.drawtexts(ctx);
    };

    function App(id, title) {
        Form.call(this, id, title, 0, 0, 1024, 768);
    }
    App.prototype = Object.create(Form.prototype);
    App.prototype.constructor = App;
    App.prototype.create = function () {}
    App.prototype.init = function () {}
    App.prototype.update = function () {}
    App.prototype.render = function () {}

    function Multistate(id, title, x, y, width, height, imageres) {
        Form.call(this, id, title, x, y, width, height, imageres);
        this.kind = MULTISTATE;
    }
    Multistate.prototype = Object.create(Form.prototype);
    Multistate.prototype.constructor = Multistate;
    Multistate.prototype.onclick = function () {
        // if (overobject!==this) return;
        this.state += 1;
        //alert(this.state);
        if (this.state > this.childs.length - 1) this.state = 0;
    };
    Multistate.prototype.draw = function (ctx) {
        var v = this.getparentpos();
        this.xg = v.x + 1 * (this === pressedobject);
        this.yg = v.y + 1 * (this === pressedobject);
        //ctx.fillStyle = this.backcolor;
        //ctx.fillRect(this.xg, this.yg, this.width, this.height);
        ctx.fillStyle = this.textcolor;
        ctx.fillStyle = rgb(0, 0, 0);
        ctx.font = this.texth + "px Helvetica";
        //ctx.textAlign = "center";
        //ctx.textBaseline = "top";
        var str = this.title;
        var imres;
        var img;
        var wi0 = 0;
        var ch = this.childs;
        if (ch) {
            str = ch[this.state].title;
            imres = ch[this.state].imageres;
            if (imres) img = imres.image;
            if (img) wi0 = img.width;
        }
        var ofsx = this.xg + wi0; // + ch[this.state].width / 2 + 40 * (imres);
        var ofsy = this.yg;
        ctx.fillText(str, ofsx, ofsy);
        //ctx.textAlign = "start";
        if (imres) {
            ctx.drawImage(imres.image, this.xg, this.yg);
        }
    };
    Multistate.prototype.addstate = function (id, title, imageres) {
        var nw = new Form(id, title, 1, 1, 32, 32, imageres);
        nw.kind = BUTTON;
         nw.drawbackground=false;
        nw.drawoutline=false;
        nw.pickable = false;
        this.childs.push(nw);
        return nw;
    };
    //------------------------------------------------------------------
    function Clockwin(id, title, x, y, width, height, imageres) {
        Form.call(this, id, "", x, y, 48 * 6, 48, imageres);

        this.stept=0.1;
        this.backcolor = rgb(243, 223, 223);
        this.drawbackground = false;
        this.drawoutline = false;
        //this.draggable=true;
        var d0 = 0;
        this.ms = this.addmultistate(0, "", 0, d0, 48, 48);
        this.ms.addstate(1, "", clock1);
        this.ms.addstate(2, "", clock2);
        this.ms.onclick = function () {
            var par = this.parent;
            Multistate.prototype.onclick.call(this);
            if (this.state === 0) par.stopped = true;
            if (this.state === 1) par.stopped = false;
        };
        var msl=this;
        this.rst = this.addbutton(0, "", 48, d0, 48, 48, clock3);
        this.rst.drawbackground = false;
        this.rst.drawoutline = false;
        this.rst.onclick = function () {
            this.parent.t = 0;
        };
        this.ff1 = this.addbutton(0, "", 2 * 48, d0, 48, 48, clock4);
        this.ff1.drawbackground = false;
        this.ff1.drawoutline = false;
        this.ff1.onmouseup = function () {
            msl.clockstop();
        };
        this.ff1.onmousedown = function () {
            msl.clockstart();
        };
        this.ff2 = this.addbutton(0, "", 3 * 48, d0, 48, 48, clock5);
        this.ff2.drawbackground = false;
         this.ff2.drawoutline = false;
        this.ff2.onmouseup = function () {
            msl.clockstop(this);
            this.parent.timescale = 1;
        };
        this.ff2.onmousedown = function () {
            this.parent.timescale = -1;
            msl.clockstart(this);
        };
        this.ff3 = this.addbutton(0, "", 4 * 48, d0, 48, 48, clock6);
        this.ff3.drawbackground = false;
         this.ff3.drawoutline = false;
        this.ff3.onmouseup = function () {
            this.parent.t += this.parent.stept;
        };
        this.ff3.onmousedown = function () {
            msl.clockstop(this);
        };
        this.ff4 = this.addbutton(0, "", 5 * 48, d0, 48, 48, clock7);
        this.ff4.drawbackground = false;
         this.ff4.drawoutline = false;
        this.ff4.onmouseup = function () {
            this.parent.t -= this.parent.stept;
            if (this.parent.t < 0) this.parent.t = 0.0;
        };
        this.ff4.onmousedown = function () {
            msl.clockstop(this);
        };
    }
    Clockwin.prototype = Object.create(Form.prototype);
    Clockwin.prototype.constructor = Clockwin;
    Clockwin.prototype.draw = function (ctx) {
       // this.drawbackground = true;
        ctx.lineWidth = "1";
        //ctx.lineStyle=rgb(0,0,0);
        var v = this.getparentpos();
        //drawroundrect(ctx, v.x, v.y, this.width, this.height, 4, 0, "black", this.backcolor);
        Form.prototype.draw.call(this, ctx);
        this.value = this.t;
    };
    
       Clockwin.prototype.clockstop=function () {
            this.stopped = true;
            this.ms.state = 0;
        }

         Clockwin.prototype.clockstart=function() {
            this.stopped = false;
            this.ms.state = 1;
        }
    //------------------------------------------------------------------
    var PEMOVETO = 1;
    var PELINETO = 2;
    var PECURVETO = 3;
    var PEBEZIERTO = 4;
    var PEARCTO = 5;
    var PECLOSE = 6;

    function Pathelement(type, p) {
        /// is a command e.g 0 null
        this.type = 0;
        this.points = [];
        if (type) this.type = type; /// move to
        var i = 0;
        if (p) {
            for (i = 0; i < p.length; i++) {
                this.points.push(p[i]);
            }
        }
    }
    /// a path 
    function Path(name) {
        this.name = name; /// usefull for id or tag 
        this.visible = true;
        this.pathelements = [];
        this.type = 0;
        this.usestroke = true;
        this.usefill = false;
        this.uselinedash = false;
        this.uselinecap = false;
        this.linedash = [];
        this.strokestyle = "yellow";
        this.fillstyle = "blue";
        this.linewidth = 1;
        /// type 1 line 2 arrow 3 double arrow 
        // 10 rect 11 round rect ;
        // 5 
        this.points = [0, 0, 0, 0];
    }
    //// eg path.add(PEMOVETO,0,0);
    Path.prototype.add = function () {
        var pe = new Pathelement();
        for (var i = 0; i < arguments.length; i++) {
            if (i === 0) this.type = arguments[i];
            else this.points.push(arguments[i]);
        }
    };
    Path.prototype.circle = function (x, y, r) {};

    function Shape(id, title, x, y, width, height, imageres) {
        Form.call(this, id, title, x, y, width, height, imageres);
        this.paths = [];
        this.backcolor = rgb(243, 223, 223);
        this.draggable = true;
        this.drawbackground = false;
        this.type = 1; //vector
        this.points = [0, 0, 0, 0];
        this.visible = true;
    }
    Shape.prototype = Object.create(Form.prototype);
    Shape.prototype.constructor = Shape;
    Shape.prototype.draw = function (ctx) {
        if (!this.visible) return;
        Form.prototype.draw.call(this, ctx); // to drawchilds
        /// *******************  ///this.setorigin(0,0);   /// set origin at draw function to have functions 
        var po = this.points;
        ctx.lineWidth = "2";
        ctx.lineStyle = rgb(255, 255, 0);
        this.drawvector(po[0], po[1], po[2], po[3], "yellow");
    };
    Shape.prototype.setpoints = function (p) {
        var i = 0;
        for (i = 0; i < p.length; i++) {
            this.points[i] = p[i];
        }
    };
    /// class         ---------------------------- S c e n e     -----------------------------
    function Scene() {
        Form.call(this, "idscene", "title", 0, 0, 1024, 768);
        ////  collection of stuff only with parent===0;
    } // end scene def
    Scene.prototype = Object.create(Form.prototype);
    Scene.prototype.constructor = Scene;
    Scene.prototype.draw = function (ctx) {
        var i = 0;
        for (i = 0; i < this.childs.length; i++) {
            this.childs[i].draw(ctx);
        }
        if (draggedobject) {
            /// todo stop timer             
            if (draggedobject.dropable) draggedobject.draw(ctx);
        }
    };
    Scene.prototype.getclicks = function () {
        var i = 0;
        for (i = 0; i < this.childs.length; i++) {
            this.childs[i].checkmouse(mousex, mousey);
        }
        for (i = 0; i < sm.childs.length; i++) {
            sm.childs[i].checkmouse(mousex, mousey);
        }
    };
    Scene.prototype.onevent = function (e, type) {
        var i = 0;
        var ob = undefined;
        overobject = undefined;
        var v = undefined;
        //draggedobject=undefined;
        clickedobject = undefined;
        clicks = [];
        this.getclicks();
        ob = getlastchild();
        overover = ob;
        overobject2=getpreviouschild();
        if (type === MOUSEWHEEL && overover) {
            overover.onwheel(e);
        }
        if (type === MOUSEDOWN) {
            pressedobject = undefined;
            if (ob !== undefined) {
                control3d = false;
                if (ob.kind === "3d") {
                    ob.p0.copy(ob.scene.position);
                    ob.r0.copy(ob.scene.rotation);
                    ob.sc0.copy(ob.scene.scale);
                    control3d = true;
                }
                if (ob.kind === LISTITEM) {
                   
                    ob.pressed = 1;
                }
                ob.onmousedown();
                if (ob.kind === BUTTON || ob.kind === PUSHBUTTON) ob.pressed = 1; //modify dx for buttons
                if (ob.kind === SCROLLBAR) {
                    ob.fixscrollbar(ob);
                }
                pressedobject = ob; //// ok 
                overobject = ob;
                if (ob.draggable) draggedobject = ob;
                dragx = ob.x;
                dragy = ob.y;
                ////////  if is list toggle  
            } ///// having clicked
        } //////// end mouse down
        if (type === MOUSEMOVE) {
            overobject = ob;
            if (ob) changecursor(ob.cursor);
            else changecursor("default");
            if (pressedobject) {
                pressedobject.onmousemove();
                if (pressedobject.kind === SCROLLBAR) {
                    v = pressedobject.getparentpos();
                    pressedobject.clickx = mousex - v.x;
                    pressedobject.clicky = mousey - v.y;
                    pressedobject.fixscrollbar(pressedobject);
                }
            }
            if (draggedobject !== undefined && mousest === 2) {
                ///// update drag position
                draggedobject.x = dragx + mousex - mousex0;
                draggedobject.y = dragy + mousey - mousey0;
                /// are we over another object ?
                
            }
        } ////end mouse move 
        if (type === MOUSEUP) {
            control3d = false;
            overobject = ob;
            if (pressedobject) {
                pressedobject.onmouseup();
                if (pressedobject.kind === "3d") control3d = true;
            }
            /// console.log(ob.toString()); 
            if (ob === pressedobject) clickedobject = ob;
            if (clickedobject) {
                if (ob.kind === LISTITEM) {
                    ob.checked = !ob.checked;
                    ob.parent.selecteditem = ob; ////in any case 
                    ob.parent.listpressed(ob);
                    ob.pressed = 1;
                }
                clickedobject.onclick(); /////// usefull at least for multistate
                switch (clickedobject.command) {
                case 0:
                    break;
                case SCFIRST:
                    sm.gotoscene(0);
                    break;
                case SCNEXT:
                    sm.gonext();
                    break;
                case SCPREVIOUS:
                    sm.goprevious();
                    break;
                case SCANY:
                    sm.gotoscene(clickedobject.commandlist[0]);
                    break;
                case FSON:
                    fullscreenon();
                    break;
                case FSOFF:
                    fullscreenoff();
                    break;
                } /// end switch
            } /// end clicked 
            /// if mousest=3 dragged dropped 
            //////// handle drop
            if (draggedobject && overobject2){
                overobject2.ondrop();
            };
            
            draggedobject = undefined;
        } /// end mouseup
        //////useless  
        for (i = this.childs.length - 1; i > -1; i--) {
            this.childs[i].onevent(e, type);
        }
        for (i = sm.childs.length - 1; i > -1; i--) {
            sm.childs[i].onevent(e, type);
        }
    };
    Scene.prototype.userevent = function (e, type) {
        ///    override if have special message
        //// do nothing user defines his event 
        //all scene events handled by childs now user
         
        if (type === MOUSEUP) {
            unpress(pressedobject);
            pressedobject = 0;
        }
    };
    /// class         ---------------------------- S c e n e  M a n a g e r    -----------------------------   
    function SceneManager() {
        fpst0 = 0; //Date.now();
        ///var that=this;
        Form.call(this, "idSM", "title", 0, 0, logw, logh);
        //this.addbuttoncommand(SCFIRST, [], 0, " menu", 0, 0, 128, 64, iconhome);
        this.name = "SceneManager";
        this.scenes = []; ////  collection of scenes;
        this.current = 0; //first scene
        this.currentscene = 0; /// noscene
        this.images = [];
        this.dwin;
        
        check1 = this.createimage("images/check1.png");
        check2 = this.createimage("images/check2.png");
        radio1 = this.createimage("images/radio1.png");
        radio2 = this.createimage("images/radio2.png");
        iconhome = this.createimage("images/iconhome.png");
        
        iconinfo = this.createimage("images/iconinfo.png");
    
        clock1 = this.createimage("images/clock1.png");
        clock2 = this.createimage("images/clock2.png");
        clock3 = this.createimage("images/clock3.png");
        clock4 = this.createimage("images/clock4.png");
        clock5 = this.createimage("images/clock5.png");
        clock6 = this.createimage("images/clock6.png");
        clock7 = this.createimage("images/clock7.png");
      
        iconabout = this.createimage("images/aboutbtn.png");
        iconhelp = this.createimage("images/helpbtn.png");
        iconclose = this.createimage("images/closebtn.png");
    } // end scene Manager def
    SceneManager.prototype = Object.create(Form.prototype);
    SceneManager.prototype.constructor = SceneManager;
    SceneManager.prototype.adddebug = function () {
        this.dwin = this.addform(0, "", 0, 0, 256, 512);
        this.dwin.drawbackground = false;
        //this.dwin.textcolor = "grey";
        this.dwin.draggable = true;
        this.dwin.drawoutline = true;
    }
    SceneManager.prototype.setscene = function () {
        this.currentscene = this.scenes[this.current]; //// always have scene
        this.onresize();
    };
    SceneManager.prototype.createscene = function () {
        gok = true;
        var ns = new Scene();
        this.scenes.push(ns);
        this.setscene();
        return ns;
    };
    SceneManager.prototype.addscene = function () {
        var ns = new Scene();
        this.scenes.push(ns);
        //this.childs.push(awin);
        //this.setscene();
        return ns;
    };
    SceneManager.prototype.createimage = function (fn) {
        var ns = new ImageResource(fn);
        this.images.push(ns);
        return ns;
    };
    SceneManager.prototype.scenexists = function (n) {
        var le = this.scenes.length;
        if (le < 1) return false;
        return (n > -1 && n < le);
    };
    SceneManager.prototype.gotoscene = function (n) {
        this.current = 0;
        if (this.scenes.length < 1) {
            alert("NO SCENE NO APP");
            return;
        }
        if (n > -1 && n < this.scenes.length) {
            this.current = n;
        }
        //this.currentscene = this.scenes[this.current]; //// always have scene
        this.setscene();
    };
    SceneManager.prototype.gonext = function () {
        this.current++;
        if (this.current >= this.scenes.length) {
            this.current = 0;
        }
        //this.currentscene = this.scenes[this.current]; //// always have scene
        this.setscene();
    };
    SceneManager.prototype.goprevious = function () {
        this.current--;
        if (this.current < 0) {
            this.current = this.scenes.length - 1;
        }
        this.setscene();
        //this.currentscene = this.scenes[this.current]; //// always have scene
    };
    SceneManager.prototype.draw = function (ctx) {
        frames++;
        fpst = time1; //Date.now();
        if (fpst - fpst0 > 1) {
            fps = frames;
            fpst0 = fpst;
            frames = 0;
            
        }
        // ctx2.fillStyle = rgb(0,0,255);// this.backcolor;
        //ctx2.fillRect(0, 0, canvaswidth, canvasheight);
        ctx.fillStyle = this.backcolor;
        //if (this.drawbackground) ctx.fillRect(0, 0, canvas.width, canvas.height);
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        ctx.save();
        viewtr.reset();
        //gsc=2.5;
        viewtr.translate(0, 0);
        viewtr.scale(gsc, gsc);
        settransform(ctx, viewtr);
        // set canvas transform
        //canvas.style.transform="scale('+gsc+','+gsc+')";
        //setelementpos(canvas,0,0);
        if (this.scenes.length > 0) {
            this.currentscene.draw(ctx);
            // ctx.fillText(info, 0, 4);     
        }
        var i = 0;
        for (i = this.childs.length - 1; i > -1; i--) {
            this.childs[i].draw(ctx);
        }
    /*
        this.dwin.texts = [];
        this.dwin.addtext("fps",fps);
        this.dwin.addtext("mousest",mousest);
         this.dwin.addtext("over",obtitle(overobject));
          this.dwin.addtext("over 2",obtitle(overobject2));
          this.dwin.addtext("pressed",obtitle(pressedobject));
           this.dwin.addtext("dragged",obtitle(draggedobject));
        this.dwin.addtext("mouse x,y",toint(mousex), ",", toint(mousey));
        
        this.dwin.addtext("w pix ratio", window.devicePixelRatio );
        this.dwin.addtext("canvas", canvas.width, canvas.height);
          
        
        this.dwin.addtext("wiw wih ",window.innerWidth,window.innerHeight );
     
        
         this.dwin.addtext("outer ",window.outerWidth,window.outerHeight);
          
        
         this.dwin.addtext("screen",window.screen.width,window.screen.height);
      
        
         this.dwin.addtext("avail",window.screen.availWidth,window.screen.availHeight);
         for(i=0;i<debugs.length;i++){
             this.dwin.addtext(debugs[i]);
         }
         this.dwin.addtext("edeltay",edeltay);
         
        this.dwin.draw(ctx);
        debugs=[];
        */
        ctx.restore();
    };
    SceneManager.prototype.onevent = function (e, type) {
        // hope all info in global vars
        this.currentscene.onevent(e, type);
        /// already all childs notified but if 
        ///************* caution 
        this.currentscene.userevent(e, type);
        //
    };
    SceneManager.prototype.onresize = function () {
        var scx = (canvas.width) / logw;
        var scy = (canvas.height) / logh;
        //var scx = (wiw) / this.width;
        //var scy = (wih) / this.height;
        gsc = Math.min(scx, scy);
        //gsc=gsc/ window.devicePixelRatio;
        /// center form0
        if (!gok)   return; /// no forms 0 to center
        var fo = this.currentscene.childs[0];
        if (fo) {
            fo.x = (canvas.width / gsc - fo.width) / 2;
            fo.y = (canvas.height / gsc - fo.height) / 2;
            //fo.x = (wiw / gsc - fo.width) / 2;
            //fo.y = (wih / gsc - fo.height) / 2;
        }
    };

    function fullscreenon(element) {
        element = document.documentElement;
        //element = window;
        if (element.requestFullscreen) {
            element.requestFullscreen();
        } else if (element.mozRequestFullScreen) {
            element.mozRequestFullScreen();
        } else if (element.webkitRequestFullscreen) {
            element.webkitRequestFullscreen();
        } else if (element.msRequestFullscreen) {
            element.msRequestFullscreen();
        }
         
        onresize();
    }

    function fullscreenoff() {
        if (document.exitFullscreen) {
            document.exitFullscreen();
        } else if (document.mozCancelFullScreen) {
            document.mozCancelFullScreen();
        } else if (document.webkitExitFullscreen) {
            document.webkitExitFullscreen();
        }
        
        onresize();
    }
    ///////////---------drawing functions -------------------------
    function drawroundrect(ctx, x, y, width, height, radius, filled, strokestyle, fillstyle) {
        // filled =0 only line 1 only fill 2 both
        ctx.beginPath();
        if (strokestyle) ctx.strokeStyle = strokestyle;
        if (fillstyle) ctx.fillStyle = fillstyle;
        ctx.moveTo(x, y + radius);
        ctx.lineTo(x, y + height - radius);
        ctx.arcTo(x, y + height, x + radius, y + height, radius);
        ctx.lineTo(x + width - radius, y + height);
        ctx.arcTo(x + width, y + height, x + width, y + height - radius, radius);
        ctx.lineTo(x + width, y + radius);
        ctx.arcTo(x + width, y, x + width - radius, y, radius);
        ctx.lineTo(x + radius, y);
        ctx.arcTo(x, y, x, y + radius, radius);
        if (filled === 0 || filled === 2) ctx.stroke();
        if (filled === 1 || filled === 2) ctx.fill();
    }

    function settransform(ctx, tr) {
        ctx.setTransform(tr.m[0], tr.m[1], tr.m[2], tr.m[3], tr.m[4], tr.m[5]);
    }

    function drawline(ctx, x1, y1, x2, y2, linestyle) {
        ctx.beginPath();
        if (linestyle) ctx.strokeStyle = linestyle;
        ctx.moveTo(x1, y1);
        ctx.lineTo(x2, y2);
        ctx.stroke();
    }

    function drawpolar(ctx, x, y, r, thrad, linestyle) {
        ctx.beginPath();
        if (linestyle) ctx.strokeStyle = linestyle;
        ctx.moveTo(x, y);
        ctx.lineTo(x + r * Math.cos(thrad), y + r * Math.sin(thrad));
        ctx.stroke();
    }

    function drawvector(ctx, x1, y1, x2, y2, linestyle) {
        var thrad = Math.atan2(y2 - y1, x2 - x1);
        //var r=Math.hypot(y2-y1,x2-x1);
        var r = Math.sqrt((y2 - y1) * (y2 - y1) + (x2 - x1) * (x2 - x1));
        drawpolar(ctx, x1, y1, r, thrad, linestyle);
        drawpolar(ctx, x2, y2, 16, thrad + pi * 0.8, linestyle);
        drawpolar(ctx, x2, y2, 44, thrad - pi * 0.8, "yellow");
    }

    function drawvectorpolar(ctx, x, y, r, thrad, linestyle) {
        drawvector(ctx, x, y, x + r * Math.cos(thrad), y + r * Math.sin(thrad), linestyle);
    }

    function drawrect(ctx, x1, y1, w, h, linestyle) {
        ctx.beginPath();
        if (linestyle) ctx.strokeStyle = linestyle;
        ctx.rect(x1, y1, w, h);
        ctx.stroke();
    }

    function drawarc(ctx, xo, yo, r, st, en, anticlock, linestyle) {
        ctx.beginPath();
        if (linestyle) ctx.strokeStyle = linestyle;
        ctx.arc(xo, yo, r, st, en, anticlock);
        ctx.stroke();
    }

    function drawarcfilled(ctx, xo, yo, r, st, en, anticlock, linestyle) {
        ctx.beginPath();
        ctx.moveTo(xo, yo);
        if (linestyle) ctx.fillStyle = linestyle;
        ctx.arc(xo, yo, r, st, en, anticlock);
        ctx.fill();
    }

    function drawcircle(ctx, xo, yo, r, linestyle) {
        drawarc(ctx, xo, yo, r, 0, twopi, false, linestyle);
    }

    function drawcirclefilled(ctx, xo, yo, r, linestyle) {
        drawarcfilled(ctx, xo, yo, r, 0, twopi, false, linestyle);
    }
    ////----------------------------------end drawing functions -------------------
    ///------------------------------------------    app start 
    function Okk() {
        Form3d.call(this, 0, "okk", 0, 0, logw, logh);
        
        
        this.flagds=0;  // nothing pressed 1 start  2 end 
        this.flagdth=0;
        this.shows=false;
        this.showth=false;
        this.showds=false;
        this.showdth=false;
         var scope=this;
        this.scene.background = new THREE.Color(colorwin);
         //this.scene.background=colorwin;
        this.matline;
        this.matlinedash;
        this.matmesh;
        this.matlambert;
        this.ci; // path
        this.sph1;
        this.sphx; //; this.sphy;
        this.box1;
        this.box2;
        this.pln;
        this.linR;
        this.linx;
        this.liny;
        this.linx1; //// for x coord
        this.liny1;
        this.he;
        this.pathplane;
        this.arrow;
        ////   app variables
        this.r1 = 0.04;
        this.F;
        this.FMAX;
        this.R = 1;
        this.R1=1; // radius for path 
        this.th;
         this.th1;
          this.th2;
        this.xi;
        this.yi;
        this.ve;
        this.om;
        this.ak;
        this.fk;
        this.t;
        this.vx;
        this.vy;
        this.ax;
        this.ay;
        this.vv;
        this.vom;
        this.va;
        this.vvx;
        this.vvy;
        this.vax;
        this.vay;
        this.vf;
        this.vfx;
        this.vfy;
        /// flags 
        this.flr;
        this.flx;
        this.fly;
        this.flv;
        this.fla;
        this.flf;
        this.flaatx;
        this.flaaty;
        ////----app   gui --------------------------------------------
        ///// forms
        this.bch1;
        this.bch2; ///// button check  
        this.chr;
        this.chaat;
        this.multiaat;
        this.chom;
        //this.chpath;
        this.chaxis; /// show axis
        //this.chxy;
        this.chv;
        this.cha;
        this.fel;
        this.clock;
        this.cylx; /// cylinders for x y cartesian
        this.cyly;
        this.cylaatx;
        this.cylaaty;
        this.vaat = []; /// 4 arrow x v x a yv y a
        ///------------------  3d create ----------------------------
        this.matlinedash1 = new THREE.LineDashedMaterial({
            color: 0x333333,
            linewidth: 1,
            scale: 1,
            dashSize: 0.03,
            gapSize: 0.01
        });
        this.matlinedash2 = new THREE.LineDashedMaterial({
            color: 0x333333,
            linewidth: 1,
            scale: 1,
            dashSize: 0.03,
            gapSize: 0.01
        });
        this.matline = new THREE.LineBasicMaterial({
            color: 0x333333
        });
        // this.scene.add( new THREE.AmbientLight( 0xffffff ) );
        this.matlambert = new THREE.MeshStandardMaterial({
            color: 0x77ffff,
            metalness: 0.8
        });
        //this.scene.background.set("#D6EBD4");
        setbackcolor(getelement("body"), colorbody);
        this.camera.position.set(0, 0, 7);
        //this.light = new THREE.PointLight( 0xffffff, 3, 100,0 );
        this.light = new THREE.HemisphereLight(0xffffff, 0x444444);
        this.scene.add(this.light);
        this.light = new THREE.PointLight(0xffffff, 1, 0, 1);
        this.light.position.set(0, 0, 7);
        this.scene.add(this.light);
        //this.ci = ngon(1.0, 128, this.matline); /// object ngon
        //ci.material.color.setRGB(0, 255, 0);
        //var geometry = new THREE.RingGeometry( 0.995, 1.005, 128 );
        var geometry = new THREE.TorusBufferGeometry(1, 0.003, 8, 128);
        var material = new THREE.MeshBasicMaterial({
            color: 0x000000
        });
        this.ci = new THREE.Mesh(geometry, material);
        this.scene.add(this.ci);
        //geometry = new THREE.RingGeometry( 1-0.02, 1+0.02, 32,1,Math.PI/2,1.23 );
        geometry = new THREE.TorusBufferGeometry(this.R, 0.111, 4, 128, Math.PI * 2);
         
        material = new THREE.MeshBasicMaterial({
            color: 0x112299,
            side: THREE.DoubleSide
        });
        this.ods = new THREE.Mesh(geometry, material);
        this.ods.visible=false;
        this.scene.add(this.ods);
        
        geometry = new THREE.RingGeometry(0.001, 1 / 2, 35, 1, Math.PI / 2, 1.23);
        material = new THREE.MeshBasicMaterial({
            color: 0xff8800,
            side: THREE.DoubleSide
        });
        this.odth = new THREE.Mesh(geometry, material);
        this.odth.visible=false;
        this.scene.add(this.odth);
        
        this.pathplane  = new THREE.Mesh(new THREE.PlaneGeometry( 2.5, 2.5 ), new THREE.MeshBasicMaterial({
		color: 0x009999,
		depthWrite: false,
		transparent: true,
		opacity: 0.25,
		side: THREE.DoubleSide
	}));
	//mesh.rotation.x = - Math.PI / 2;
	//mesh.receiveShadow = true;
	this.scene.add(this.pathplane );
        
        
        
        //geometry = new THREE.TorusBufferGeometry(this.R * 1.768, 0.002, 4, 4);
        //this.pathplane = new THREE.Mesh(geometry, this.ci.material);
        //this.scene.add(this.pathplane);
       // this.pathplane.rotation.set(0, 0, Math.PI / 4);
        
       
        
        
        
        
        
        this.he = helix(this.r1, 32, 6, this.matline); /// object ngon
        this.scene.add(this.he);
        //this.he.material.color.setRGB(255, 0, 0);
        this.sph1 = sphere(this.r1, 18, 18, this.matlambert);
        //this.sph1.normalizeNormals();
        this.scene.add(this.sph1);
        this.sph1.position.set(1, 0, 0);
        //this.sphx = sphere(this.r1, 12, 12);
        this.sphx = box(2 * this.r1, 2 * this.r1, 2 * this.r1, this.matlambert);
        this.scene.add(this.sphx);
        this.sphx.position.set(1, 0, 0);
        this.linR = line(this.matline);
        this.scene.add(this.linR);
        
        this.linth1= line(this.matline);
        this.scene.add(this.linth1);
        this.linth2= line(this.matline);
        this.scene.add(this.linth2);
        
        this.linx = line(this.matline);
        this.scene.add(this.linx);
        this.liny = line(this.matline);
        this.scene.add(this.liny);
        this.linx1 = line(this.matlinedash1);
        this.scene.add(this.linx1);
        this.liny1 = line(this.matlinedash2);
        this.scene.add(this.liny1);
        this.linx1.computeLineDistances();
        this.liny1.computeLineDistances();
        this.vv = arrow();
        this.scene.add(this.vv);
        this.vom = arrow();
        this.scene.add(this.vom);
        this.va = arrow();
        this.scene.add(this.va);
        this.cylx = cylinder(8);
        this.scene.add(this.cylx);
        this.cyly = cylinder(8);
        
        this.scene.add(this.cyly);
        this.cylx.visible=false;
        this.cyly.visible=false;
        this.cylaatx = cylinder(8);
        this.scene.add(this.cylaatx);
        this.cylaaty = cylinder(8);
        this.scene.add(this.cylaaty);
        //////---------------gui ------------------------------
         //--------title of app -------------
        //var tw = this.addform(0, " Ομαλή κυκλική κίνηση και απλή αρμονική ταλάντωση", 0, logh-48, logw, 48);
        //tw.drawbackground = false;
      //  tw.texth =24;  
       // tw.backcolor=colortitle;
      //  tw.textcolor=colortitle0;
      //  tw.textcentered=false;
        
        
        this.panel=this.addform(0,"",4,4,2*48+8,4*48 );
        this.panel.backcolor = colorcheck;
        this.panel.corner = 6;
        this.panel.drawoutline = true;
         
        
        var aw = 2*48+8;
        this.check = this.addcheck(0, "", 4, 4*48+8, aw, 4 * 48  );
        this.check.corner = 6;
        this.check.drawoutline = true;
        //this.chpath = this.check.addlistitem(0, "τροχιά", 0, 180, aw, 32);
        this.chr = this.check.addlistitem(0, "R", 0, 90, aw, 32);
        this.chv = this.check.addlistitem(0, "υ", 0, 240, aw, 32);
        this.chom = this.check.addlistitem(0, "ω", 0, 150, aw, 32);
        this.cha = this.check.addlistitem(0, "a", 0, 270, aw, 32);
       // this.chxy = this.check.addlistitem(0, "xy", 0, 210, aw, 32);
       // this.chdir = this.check.addlistitem(0, "φορά", 0, 210, aw, 32);
       
         this.panel2=this.addform(0,"",0, 2*48,aw,6.6*48 );
          
        this.panel2.corner = 6;
        this.panel2.drawoutline = true;
         this.panel2.below(this.check,4);
         this.panel2.backcolor = colorcheck;
         
        this.check.setchilds(0, 4, 0, 48,aw,48);
        this.check.backcolor = colorcheck;
         
        
        
        this.check2 = this.addradio(0, "", 4, 2*48, aw, 4 * 48 + 2);
        this.check2.corner = 6;
        this.check2.drawoutline = true;
        this.chcart = this.check2.addlistitem(0, "x,y", 0, 48, aw, 32);
        this.chs = this.check2.addlistitem(0, "s", 0, 0, aw, 32);
        this.chth = this.check2.addlistitem(0, "θ", 0, 0, aw, 32);  
        this.chnopos= this.check2.addlistitem(0, "-", 0, 0, aw, 32);  
        this.check2.setchilds(0, 0, 0, 48,aw,48);
        this.check2.selectitem(3);
        this.check2.right(12);
         this.check3=this.addcheck(0, "", logw-200, 2*48, aw, 1* 48 + 2);
        this.check3.corner = 6;
        this.check3.drawoutline = true;
        this.check3.below(this.check2,1*48+16);
        
        this.chaat = this.check3.addlistitem(0, "ΑΑΤ", 0,  0, aw, 48);
        
        this.fel = this.addscrollbar(0, "",4,logh-250,48, 232);
        this.fel.setvalues(1, -1, 0.1);
        this.fel.setvaluedescr("f", "Hz", 2);
        this.fel.setvaluepos(4, -3.4*48);
        this.fel.childs[1].title="f";
         this.fer = this.addscrollbar(0, "", 4+48,logh-250,48, 232);
        this.fer.setvalues(1.0, 0.5, 0.8);
        this.fer.setvaluedescr("R", "m", 2);
        this.fer.setvaluepos(-44, -2.8*48);
        this.fer.childs[1].title="R";
        this.clock = new Clockwin(0, "clockwin", 4, 0);
        this.clock.setchildsarray(3,2,48,48);
        this.panel.addchild(this.clock);
        var vclock = this.clock;
       // this.chdir.onclick = function () {
     //       vclock.t = 0;
    //    };
        this.clock.setvaluedescr("t", "s", 2);
        this.clock.setvaluepos(4, 3*48);
        this.clock.valuedraw = true;
        //this.clock.centerhor();
       // this.clock.bottom(4);
        
        var oldclockstate;
        this.fel.onmousedown = function () {
            oldclockstate = this.parent.clock.ms.state;
            this.parent.clock.ms.state = 0;
            this.parent.clock.t = 0;
            this.parent.clock.stopped = true;
        };
        this.fel.onmouseup = function () {
            this.parent.clock.ms.state = oldclockstate;
            this.parent.clock.stopped = (oldclockstate === 0);
        };
        this.multiaat = this.addradio(0, "", logw-3*48, 8 * 48 + 2, aw, 96);
        //this.multiaat.addstate(0,"AAT...");
        this.multiaat.addlistitem(0, "AATx", 0, 0, aw, 48);
        this.multiaat.addlistitem(1, "AATy", 0, 48, aw, 48);
        this.multiaat.selectitem(0);
        this.multiaat.backcolor = colorcheck;
        this.multiaat.corner = 6;
        this.multiaat.drawoutline = true;
        this.multiaat.below(this.check3,4);
        
        this.btnds=this.addbutton(0,"Δs",logw-333,logh-48-4,48,48);
        this.btnds.drawoutline=true;
        this.btnds.drawbackground = true;
        this.btnds.setvaluedescr("Δs","πR m",2);
        this.btnds.setvaluepos(0,-48);
        this.btnds.below(this.check2,8); 
        this.btnds.corner = 6;
        this.t1label=this.btnds.addlabel(0,"t",-214,0,206,48);
        this.t1label.backcolor="#D6EBD4";
         this.t1label.drawoutline=true;
         this.t1label.visible=false;
         ///this.tl2=this.tlabel1.addlabel
        this.btndth=this.btnds.addbutton(0,"Δθ",48+8,0,48,48);
        this.btndth.drawoutline=true;
        this.btndth.drawbackground = true;
         this.btndth.setvaluedescr("Δθ","π rad",2);
         this.btndth.setvaluepos(0,-48);
         this.btndth.corner = 6;
         this.t1;///definition
        this.btnds.onmousedown=function(){
            scope.t1=scope.clock.t;
            scope.clock.clockstart();
            scope.flagds=1;
            scope.th1=scope.th;
            scope.showds=true;
            scope.check2.selectitem(3);
        };
        this.btnds.onmouseup=function(){
            scope.clock.clockstop();
            scope.flagds=2;
            
          
        };
        this.btndth.onmousedown=function(){
            scope.clock.clockstart();
            scope.flagdth=1;
            scope.th1=scope.th;
             scope.t1=scope.clock.t;
             scope.showdth=true;
            scope.check2.selectitem(3);
        };
        this.btndth.onmouseup=function(){
            scope.clock.clockstop();
            scope.flagdth=2;
            
         
        };
       
        ////////// ------------------  end gui             
        this.vaat[0] = arrow(); //vxaat
        this.vaat[1] = arrow();
        this.vaat[2] = arrow();
        this.vaat[3] = arrow();
        this.cylx.material.color.set(rgb(66, 222, 66));
        this.cyly.material.color.set(rgb(66, 66, 222));
        this.cylaatx.material.color.set(rgb(66, 222, 66));
        this.cylaaty.material.color.set(rgb(66, 66, 222));
        this.va.setColor(rgb(222, 66, 66));
        this.vaat[2].setColor(rgb(222, 66, 66));
        this.vaat[3].setColor(rgb(222, 66, 66));
        this.scene.add(this.vaat[0]);
        this.scene.add(this.vaat[1]);
        this.scene.add(this.vaat[2]);
        this.scene.add(this.vaat[3]);
        
        //// ------------------ create scenes
        
       // var scenehome=sm.createscene();
        var fh=new Form(0,"",0,0,logw,logh);
        var dd=80;
        var fhc=fh.addform(0,"",0,0,200,5*dd);
        
        fhc.addbuttoncommand(SCANY,[1],0,"OKK & AAT",0,0,140,48);
     
        
        //this.addbuttoncommand(SCANY,[0],0,"",0,0,48,48,iconhome);
        fhc.addbuttoncommand(FSON, [], 0, "Πλήρης Οθόνη", 0, 1* 48, 128, 48);
        fhc.addbuttoncommand(FSOFF, [], 0, "Επαναφορά",   0, 2 * 48, 128, 48);
        
   var bc1=     this.addbuttoncommand(SCANY,[1],0,"",         logw-96-8,0,48,48,iconhelp);
   var bc2=      this.addbuttoncommand(SCANY,[2],0,"",logw-48-4,0,48,48,iconabout);
        bc1.drawoutline=false;
        bc2.drawoutline=false;
         fhc.setchilds(0,0,0,dd,200,50 );
         fhc.centerhor();
         fhc.centerver();
     //   scenehome.addchild(fh);  ///0
        var sceneokk =sm.createscene();//00
        sceneokk.addchild(this); /// 1 okk
       
        var formhelp = new Form(0, "about", 0, 0, logw, logh, sm.createimage("images/help.svg"));
         
        var formabout = new Form(0, "about", 0, 0, logw, logh, sm.createimage("images/about.png"));
        
     bc1=    formhelp.addbuttoncommand(SCANY,[0],0,"",logw-56,0,48,48,iconclose);
      bc1.drawoutline=false;
      bc1=   formabout.addbuttoncommand(SCANY,[0],0,"",logw-56,0,48,48,iconclose);
       bc1.drawoutline=false;  
         
     
        var scenehelp=sm.createscene(); ///1 
        var sceneabout=sm.createscene(); ///2
        scenehelp.addchild(formhelp);
        sceneabout.addchild(formabout);
        
        
        
        ///-----------------------init now
        
        
        
        
        
        this.init();
    }
    Okk.prototype = Object.create(Form3d.prototype);
    Okk.prototype.constructor = Okk;
    Okk.prototype.create = function () {
        /// no need defined in constructor  
    }
    Okk.prototype.updateds = function () {
       
        
        this.scene.remove(this.ods);
        this.ods.geometry.dispose();
        this.ods.material.dispose();
        this.ods = undefined;
        var gon=this.th-this.th1;
        if (iszero(gon)) gon=0.001;
        this.btnds.value=gon/Math.PI;
        if(Math.abs(gon)>Math.PI*2) gon=sign(gon)*(Math.PI*2);
         
        var geometry = new THREE.TorusBufferGeometry(this.R, 0.011, 4, 128,gon );
        var material = new THREE.MeshBasicMaterial({
            color: 0x112299,
            side: THREE.DoubleSide
        });
        this.ods = new THREE.Mesh(geometry, material);
        this.scene.add(this.ods);
        this.ods.rotation.set(0,0,this.th1);
         this.linth1.rotation.set(0,0,this.th1);
           this.linth2.rotation.set(0,0,this.th);
            this.linth1.scale.set(this.R,1,1);
            
           this.linth2.scale.set(this.R,1,1);
           
           
           if(this.flagds===2) this.flagds=3;
    }
    
     Okk.prototype.updateds1 = function () {
        
         
         var gon=this.th-this.th1;
        if (iszero(gon)) gon=0.001;
        var range=Math.abs(gon)%(Math.PI*2)*this.ods.geometry.attributes.position.count/3;
        //this.ods.geometry.setDrawRange(0,this.ods.geometry.attributes.position.count);
         this.ods.geometry.setDrawRange(0,this.fel.value*this.ods.geometry.attributes.position.count);
        this.btnds.value=gon/Math.PI;
        if(Math.abs(gon)>Math.PI*2) gon=sign(gon)*(Math.PI*2);
      
        this.ods.rotation.set(0,0,this.th1);
         this.linth1.rotation.set(0,0,this.th1);
           this.linth2.rotation.set(0,0,this.th);
           if(this.flagds===2) this.flagds=3;
    }
    
    Okk.prototype.updatedth = function () {
        this.scene.remove(this.odth);
        this.odth.geometry.dispose();
        this.odth.material.dispose();
        this.odth = undefined;
        var gon=this.th-this.th1;
        if (iszero(gon)) gon=0.001;
        this.btndth.value=gon/Math.PI;
        if(Math.abs(gon)>Math.PI*2) gon=sign(gon)*(Math.PI*2);
         
        //var geometry = new THREE.RingGeometry(0.001, 1 / 2, 64, 1, this.th1, gon);
         var geometry = new THREE.CylinderGeometry(this.R/3, this.R/3,0.002, 64, 1,false, this.th1, gon);
         
        var material = new THREE.MeshBasicMaterial({
            color: 0xff8800,
            side: THREE.DoubleSide
        });
        this.odth = new THREE.Mesh(geometry, material);
        this.odth.rotation.set(Math.PI/2,Math.PI/2,0);
        this.scene.add(this.odth);
         this.linth1.rotation.set(0,0,this.th1);
         this.linth1.scale.set(this.R,1,1);
           this.linth2.rotation.set(0,0,this.th);
           this.linth2.scale.set(this.R,1,1);
           if(this.flagdth===2) this.flagdth=3;
    }
    /// init sets all initial values 
    Okk.prototype.init = function () {
        this.t = 0;
        this.th = 0;
        this.r1 = 0.04;
        this.setscale(1.45);
    }
    Okk.prototype.update = function () {
         debugs.push(concat("wheeledelta",this.wheeldelta));
        this.F = todecimal(this.fel.value,2);
         this.R = this.fer.value;
       // if (this.chdir.checked) this.F = -1 * this.F;
        this.FMAX = Math.max(this.fel.max,this.fel.min);
        //var dt = clock.getDelta()*(bch1.checked);
        this.t = this.clock.t; //clock.getDelta();
        this.om = 2 * Math.PI * this.F;
        var dt = this.clock.dt;
        this.th = this.om * this.t; // dt;
        //this.th = this.om * this.t;
        //////--------------------------------
         
        if (this.flagds>0){
             
            this.t1label.visible=true;
          this.updateds();
            
         if (this.flagds<3)   this.updateds(); 
            this.ods.visible=true; 
            
             
            if(this.flagds===3&&mousest===1){
                this.t1label.visible=false;
                this.flagds=0;
              this.ods.visible=false;  
               this.showds=false;
            };
    
       }
        
        if (this.flagdth>0){
              this.t1label.visible=true;
            this.updatedth();
           
            this.odth.visible=true;
            
            if(this.flagdth===3&&mousest===1){
               this.t1label.visible=false;
                this.flagdth=0;
              this.odth.visible=false;  
               this.showdth=false;
            };
          
        }
        if (this.flagds>0 || this.flagdth>0){
            
           this.t1label.title="t₁="+todecimal(this.t1,2)+"s, t₂="+todecimal(this.clock.t,2)+"s";  
        }
        // this.btnds.valuedraw=this.showds;
       //  this.btndth.valuedraw=this.showdth;
         this.linth1.visible=this.ods.visible||this.odth.visible;
         this.linth2.visible=this.ods.visible||this.odth.visible;
          
        
        this.ve = this.om * this.R;
        var co = Math.cos(this.th);
        var si = Math.sin(this.th);
        this.xi = this.R * co;
        this.yi = this.R * si;
        this.vx = -this.R * this.om * si;
        this.vy = this.R * this.om * co;
        this.ve = Math.sqrt(Math.pow(this.vx, 2) + Math.pow(this.vy, 2));
        this.ax = -this.R * this.om * this.om * co;
        this.ay = -this.R * this.om * this.om * si;
        this.ak = Math.sqrt(Math.pow(this.ax, 2) + Math.pow(this.ay, 2));
        var mv = this.R / 4 + 2 * this.R / 4 * Math.abs(this.F) / this.FMAX;
        this.vv.setLength(mv, 0.00, 0.025);
        this.vv.position.set(this.xi, this.yi, 0);
        this.vv.setDirection(this.vx, this.vy, 0);
        this.va.setLength(mv, 0.05, 0.025);
        this.va.position.set(this.xi, this.yi, 0);
        this.va.setDirection(this.ax, this.ay, 0);
        this.vom.setLength(mv, 0.05, 0.025);
        this.vom.position.set(0, 0, 0);
        this.vom.setDirection(0, 0, this.F);
        ///aat vx
        this.vaat[0].setLength(mv * si, 0.05, 0.025);
        this.vaat[0].position.set(this.xi, this.R1 + this.R1 / 4 + 0.1, 0);
        this.vaat[0].setDirection(-si, 0, 0);
        this.vaat[1].setLength(mv * co, 0.05, 0.025);
        this.vaat[1].position.set(+this.R1 + this.R1 / 4 + 0.1, this.yi, 0);
        this.vaat[1].setDirection(0, this.vy, 0);
        this.vaat[2].setLength(-mv * co, 0.05, 0.025);
        this.vaat[2].position.set(this.xi, this.R1 + this.R1 / 4 + 0.15, 0);
        this.vaat[2].setDirection(-co, 0, 0);
        this.vaat[3].setLength(mv * si, 0.05, 0.025);
        this.vaat[3].position.set(+this.R1 + this.R1 / 4 + 0.15, this.yi, 0);
        this.vaat[3].setDirection(0, -si, 0);
        this.sph1.position.set(this.xi, this.yi, 0);
        this.linR.rotation.set(0, 0, this.th);
        this.linR.scale.set(this.R,1,1);
        this.ci.scale.set(this.R,this.R,1);
        // box1.rotation.set(0,0,this.th);
        this.linx.position.set(-1.5 * this.R1, 0, 0);
        this.linx.scale.set(3.0 * this.R1, 1, 1);
        this.liny.position.set(0, -1.5 * this.R1, 0);
        this.liny.scale.set(3.0 * this.R1, 1, 1);
        this.liny.rotation.set(0, 0, Math.PI / 2);
        lineset(this.linx1, this.xi, this.yi, 0, 0, this.yi, 0);
        this.linx1.lineDistancesNeedUpdate = true;
        lineset(this.liny1, this.xi, this.yi, 0, this.xi, 0, 0);
        this.sphx.position.set(this.R1 + this.R1 / 4, this.yi, 0);
        //sphy.position.set(xi, R + R / 4, 0);
        this.he.position.set(+this.R1 + this.R1 / 4, this.R1 + this.R1 / 4, 0);
        this.he.scale.set(1, 1, this.R1 / 4 + this.R1 - this.yi);
        this.he.rotation.set(Math.PI / 2, 0, 0);
        this.linR.visible = this.chr.checked;
        var visaatx = this.chaat.checked && this.multiaat.checkeditem(0);
        var visaaty = this.chaat.checked && this.multiaat.checkeditem(1);
        this.multiaat.visible = this.chaat.checked;
        this.he.visible = this.chaat.checked; //this.multiaat.state>0;///.checked;
        this.sphx.visible = this.he.visible; //chaat.checked;
        if (this.multiaat.checkeditem(0)) {
            this.he.position.set(-this.R1 - this.R1 / 4, this.R1 + this.R1 / 4, 0);
            this.he.scale.set(1, 1, this.R1 / 4 + this.R1 + this.xi);
            this.he.rotation.set(0, Math.PI / 2, 0);
            this.sphx.position.set(this.xi, this.R1 + this.R1 / 4, 0);
        }
        this.vom.visible = this.chom.checked && Math.abs(this.F) > 0.001;
        this.vv.visible = this.chv.checked && Math.abs(this.F) > 0.001;
        this.va.visible = this.cha.checked && Math.abs(this.F) > 0.001;
        //this.ci.visible = this.chpath.checked;
        //this.pathplane.visible = this.chpath.checked;
        
       
        
      
        this.vaat[0].visible = visaatx && this.vv.visible;
        this.vaat[1].visible = visaaty && this.vv.visible;
        this.vaat[2].visible = visaatx && this.va.visible;
        this.vaat[3].visible = visaaty && this.va.visible;
        //linestart(this.linx1,-10,-10,0);
        var sclx = this.xi;
        var eps = getepsilon();
        if (iszero(sclx)) sclx = eps;
        var scly = this.yi;
        if (iszero(scly)) scly = eps;
        var ll = 0.004;
        if (this.chcart.checked){
        this.cylx.scale.set(ll, sclx, ll);
        this.cylx.rotation.set(0, 0, -Math.PI / 2);
        //this.cylx.visible = this.chxy.checked;
        //this.cyly.visible = this.chxy.checked;
        this.cyly.scale.set(ll, scly, ll);
        this.cyly.rotation.set(0, 0, 0);
    } 
        this.linx1.visible = this.chcart.checked;  
        this.liny1.visible = this.chcart.checked;  
        this.cylx.visible = this.chcart.checked;
        this.cyly.visible = this.chcart.checked;
        // this.linx.visible = this.chxy.checked||this.chcart.checked||this.chs.checked||this.chth.checked;
          this.linx.visible =  this.chcart.checked||this.chs.checked||this.chth.checked;
        this.liny.visible = this.linx.visible; 
        this.shows=this.chs.checked;
        if (this.shows) {
            
            this.th1=0;
            this.updateds();
        }
        this.showth=this.chth.checked;
         if (this.showth) {
            
            this.th1=0;
            this.updatedth();
        }
         this.ods.visible=this.shows||this.showds;
         this.odth.visible=this.showth||this.showdth;
         
        this.cylaatx.scale.set(ll, sclx, ll);
        this.cylaatx.rotation.set(0, 0, -Math.PI / 2);
        this.cylaatx.position.set(0, this.R1 / 4 + this.R1, 0);
        this.cylaaty.scale.set(ll, scly, ll);
        this.cylaaty.rotation.set(0, 0, 0);
        this.cylaaty.position.set(this.R1 / 4 + this.R1, 0, 0);
        this.cylaatx.visible = this.chcart.checked && visaatx;
        this.cylaaty.visible = this.chcart.checked && visaaty;
    }
    ///----------------------------------------------------------------------------    
    ///--------------------------------init 3d
    function init3d() {
        if (!Detector.webgl) Detector.addGetWebGLMessage();
        ///initmaterials();
        renderer = new THREE.WebGLRenderer({
            canvas: canvas3d,
            antialias: true
        });
        //renderer.setSize(logw, logh);
        //renderer.setSize(canvas3d.width, canvas3d.height);
        
        renderer.shadowMap.enabled = true;
    }

    function animate3d(ascene, acamera, amouse, ahitlist) {
        
        raycaster.setFromCamera(amouse, acamera);
        var intersects = raycaster.intersectObjects(ahitlist);
     
        if (intersects.length > 0) {
           
            if (INTERSECTED !== intersects[0].object) {
                if (INTERSECTED) INTERSECTED.material.emissive.setHex(INTERSECTED.currentHex);
                INTERSECTED = intersects[0].object;
                INTERSECTED.currentHex = INTERSECTED.material.emissive.getHex();
                INTERSECTED.material.emissive.setHex(0x555555);
            }
        } else {
            if (INTERSECTED) INTERSECTED.material.emissive.setHex(INTERSECTED.currentHex);
            INTERSECTED = null;
        }
        renderer.render(ascene, acamera);
        //stats.update();
    }

    function render3d() {}
    var w = window;
    var requestAnimationFrame = w.requestAnimationFrame || w.webkitRequestAnimationFrame || w.msRequestAnimationFrame || w.mozRequestAnimationFrame;
    //////////////----------create sm    -----------------------------
    var sm = new SceneManager();

    function getmanager() {
        return sm;
    }

    function main() {
        time1 = Date.now() / 1000;
        timedelta = (time1 - time0); // * timescale;
        time = time + (timedelta);
        if (timedelta > interval) {
            //time0 = time1;
            time0 = time1 - (timedelta % interval)
            sm.draw(ctx); //////  render();
        }
        // Request to do this again ASAP
        requestAnimationFrame(main);
    };

    function start() {
        time0 = Date.now() / 1000;
        time = 0;
          initialize();
    init3d();
        sm.onresize();
        main();
    }
  
    return {
        start: start,
        getmanager: getmanager,
        renderer: renderer,
        Form: Form,
        Form3d: Form3d,
        Okk: Okk
    };
}; /// end frame work
// notes renderer set pixelratio  renderer.setPixelRatio(window.devicePixelRatio);e