﻿/**
 * 
 */

function initialise(){
    showAppTitle();
	$('body').on('paste input','[contenteditable]',function() {
		clearEnvironment();
		simulationReset();
	});
	simulationReset();
	$("#btnPlay").prop("disabled",true);
	clearEnvironment();
	defineExerciseTypes();
	generatePatterns();
	generateProblemList();
	problemID=0;
	showProblemDescription();
	if(!eventsInitialised){
	    eventsInitialised=true;
        initialiseEvents();
	}
}

function initialiseEvents(){
    $("#btnHelp").on("click touchstart",function(){
        showHelp();
        //window.location.href="#openModalHelp";
    });

    $("#btnNewProblem").on("click touchstart",function(){
        selectRandomProblem();
    });
    
    $("#btnDelete").on("click touchstart",function(){
        deleteAll();
    });
    
    $("#btnPlay").on("click touchstart",function(){
        simulateCode(modeShowResults);
    });
    
    $("#btnPause").on("click touchstart",function(){
        $("#showOptions").show();
        //simulating=false;
        $("#btnPause").hide();
        $("#btnContinue").show();
        $("#btnForward").prop("disabled",false);
        clearInterval(timerLoop);
        //handleContinuationButtons();
    });
    
    $("#btnContinue").on("click touchstart",function(){
        $("#showOptions").hide();
        //simulating=true;
        $("#btnContinue").hide();
        $("#btnForward").prop("disabled",true);
        $("#btnPause").show();
        timerLoop=setInterval(function(){simulationRun(modeShowResults);},simSpeed);
    });
    
    $("#btnStop").on("click touchstart",function(){
        simulationReset();
    });
    
    $("#btnSubmit").on("click touchstart",function(){
        checkSolution();
    });

    $("#btnShowSolution").on("click touchstart",function(){
        showSolution();
    });

    $("#btnHint").on("click touchstart",function(){
        showHint();
    });

    $("#btnForward").on("click touchstart",function(){
        /*simulationAborted=false;*/
        if(!simulationInitialised){
            simulationInitialise();
        }
        simulationRun(modeShowResults);
        if(simulationIndex==codeLength){
            simulationReset();
        }

    });
    
    $("#closeTool").on("click touchstart",function(){
        hideHelp();
    });
    
    //Κουμπιά διαχείρισης εφαρμογής
    $("#slideSpeed").bind("change keyup touchend",function(event,ui) {
        var maxSimSpeed=Number($(this).attr("max"))+1;
        simSpeed=maxSimSpeed-$(this).val();
    });
    
    $("#showVarValues").bind("change keyup touchend",function(event,ui) {
        if($("#showVarValues:checked").val()=="show"){
            showVarValues=true;
        }
        else{
            showVarValues=false;
        }
    });
    
    $("#requestConfirmations").bind("change keyup touchend",function(event,ui) {
        if($("#requestConfirmations:checked").val()=="reqConfirm"){
            requestConfirmationState=requestConfirmation;
        }
        else{
            requestConfirmationState=dontRequestConfirmation;
        }
    });
    
    $("#showFullSimulationPath").bind("change keyup touchend",function(event,ui) {
        if($("#showFullSimulationPath:checked").val()=="showFullSimPath"){
            hideSimulationPath=false;
        }
        else{
            hideSimulationPath=true;
        }
    });
}

function clearEnvironment(){
	clearCodeResults();
	clearHint();
	hideHintTool();
	hideResult();
	//$("#btnPlay").prop("disabled",true);
}

function clearPatterns(){
    patternID=-1;
	for(var i=1;i<5;i++){
		$("#pattern"+i).removeClass("selectedPattern");
		$("#pattern"+i).addClass("patternCode");
	}
}

function clearCodeResults(){
	$("#studentResults").hide();
	$("#solutionOk").hide();
	$("#solutionError").hide();
}

function sizeDIVs(){
	var divBorder=15;
	
	var newTop=document.getElementById("studentCodeDIV").getBoundingClientRect().top;
	var studentCodeLeft=divBorder;
	$("#studentCodeDIV").css({
        left: studentCodeLeft+"px"
    });

	var solutionResultsLeft=studentCodeLeft+document.getElementById("studentCodeDIV").getBoundingClientRect().width+divBorder;
	$("#solutionResultsDIV").css({
        top: newTop+"px",
        left: solutionResultsLeft+"px",
        width: "42px"
    });

    //Μηνύματα
    var messageAreaLeft=solutionResultsLeft+document.getElementById("solutionResultsDIV").getBoundingClientRect().width+divBorder;
    $("#messageArea").css({
        left: messageAreaLeft+"px"
    });
    var messageAreaHeight=document.getElementById("studentResults").getBoundingClientRect().height;
    $("#messageArea").css({
        //height: Math.max(messageAreaHeight,30)+"px"
        height: height+"px"
    });
	
	var height=document.getElementById("studentCodeDIV").getBoundingClientRect().height+divBorder;
	$("#exerciseArea").css({
        height: height+"px"
    });

	//Αποτελέσματα
	var resultsAreaLeft=studentCodeLeft;
	$("#resultsArea").css({
        left: messageAreaLeft+"px"
    });
	//var resultsHeight=document.getElementById("studentResults").getBoundingClientRect().height;
	$("#resultsArea").css({
        //height: Math.max(resultsHeight,30)+"px"
        height: height+"px"
    });
}

function generateProblemList(){
	var menuEntry="<div tabindex='0' class='onclick-menu'>";
	menuEntry+="<ul class='onclick-menu-content'>";
	for(var i=0;i<problemDescr.length;i++){
		menuEntry+="<li><button onclick='showProblem("+i+")'>"+problemDescr[i]+"</button></li>";
	}
	menuEntry+="</ul>";
	menuEntry+="</div>";
	document.getElementById("levels").innerHTML=menuEntry;
}

function showProblem(selected){
    $("#btnPlay").prop("disabled",true);
    $("#btnShowSolution").prop("disabled",true);
    $("#btnForward").prop("disabled",true);
    $("#messageArea").hide();
    $("#resultsArea").hide();
	document.getElementById("studentCodeDIV").style.display="none";
	problemID=selected;
	clearEnvironment();
	clearPatterns();
	showProblemDescription();
}

function generateEntryPlaceholder(entryID,presetValue){
	var content="ˍˍˍ";
	if(presetValue!== undefined)content=presetValue;
	var newEntry="<span class='toChange' id='"+entryID+"' contenteditable='true'>"+content+"</span>";
	return newEntry;
}

function simulateCode(runMode){
    if(simulationInitialise()){
        $("#btnContinue").hide();
        $("#btnForward").prop("disabled",true);
        $("#btnNewProblem").prop("disabled",true);
        $("#btnDelete").prop("disabled",true);
        $("#btnSubmit").prop("disabled",true);
        $("#btnShowSolution").prop("disabled",true);
        $("#btnPlay").hide();
        $("#btnPause").show();
        $("#btnStop").prop("disabled",false);
        $("#btnForward").prop("disabled",false);
        $("#showOptions").hide();

        //έναρξη προσομοίωσης με κλήση timer
        timerLoop=setInterval(function(){simulationRun(runMode);},simSpeed);
    }
}

function simulationInitialise(){
	clearAdditionalErrorMessages();
	var i=0;
	simulationInitialised=true;
	if(document.getElementById("xStart")){
		userValues[i]=trimSpaces(document.getElementById("xStart").innerHTML);
		if(userValues[i]=="")simulationInitialised=false;
	}
	else{
		userValues[i]=xStart;
	}
	i++;
	if(document.getElementById("loopFrom")){
		userValues[i]=trimSpaces(document.getElementById("loopFrom").innerHTML);
		if(userValues[i]=="")simulationInitialised=false;
	}
	else{
		userValues[i]=loopStartFrom;
	}
	i++;
	if(document.getElementById("loopTo")){
		userValues[i]=trimSpaces(document.getElementById("loopTo").innerHTML);
		if(userValues[i]=="")simulationInitialised=false;
	}
	else{
		userValues[i]=loopEndTo;
	}
	i++;
	if(document.getElementById("loopStep")){
		userValues[i]=trimSpaces(document.getElementById("loopStep").innerHTML);
		if(userValues[i]=="")simulationInitialised=false;
	}
	else{
		userValues[i]=loopStepValue;
	}
	i++;
	if(document.getElementById("xConditional")){
		userValues[i]=trimSpaces(document.getElementById("xConditional").innerHTML);
		if(userValues[i]=="")simulationInitialised=false;
	}
	else{
		userValues[i]=xConditional;
	}
	i++;
	if(document.getElementById("iConditional")){
		userValues[i]=trimSpaces(document.getElementById("iConditional").innerHTML);
		if(userValues[i]=="")simulationInitialised=false;
	}
	else{
		userValues[i]=iConditional;
	}
	i++;
	if(document.getElementById("xExpression")){
		userValues[i]=trimSpaces(document.getElementById("xExpression").innerHTML);
		if(userValues[i]=="")simulationInitialised=false;
	}
	else{
		userValues[i]=xExpression;
	}
	i++;
	if(document.getElementById("iExpression")){
		userValues[i]=trimSpaces(document.getElementById("iExpression").innerHTML);
		if(userValues[i]=="")simulationInitialised=false;
	}
	else{
		userValues[i]=iExpression[0];
	}
	i++;
	if(document.getElementById("xStep")){
		userValues[i]=trimSpaces(document.getElementById("xStep").innerHTML);
		if(userValues[i]=="")simulationInitialised=false;
	}
	else{
		userValues[i]=xStep;
	}
	
	loopBegin=parseFloat(userValues[1]);
	loopEnd=parseFloat(userValues[2]);
	/*if(loopBegin>loopEnd){
		loopBegin=parseFloat(userValues[2]);
		loopEnd=parseFloat(userValues[1]);
	}*/
	programOutput="";
	return simulationInitialised;

	/*if((exerciseVariation & twoVariables)==twoVariables){// i και x
		if((exerciseVariation & swapLoopBody)==swapLoopBody){//Πρώτα τροποποίησε
			x=parseFloat(userValues[0]);
			for(var i=loopBegin;i<=loopEnd;i=i+parseFloat(userValues[3])){
				x+=parseFloat(userValues[8]);
				if((exerciseVariation & outputWithConditional)==outputWithConditional){
					if(stringLogicalValue(userValues[4],x)) programOutput+=stringExpressionValue(userValues[6],x)+" ";
				}
				else{
					programOutput+=stringExpressionValue(userValues[6],x)+" ";
				}
			}
		}
		else{//πρώτα ΓΡΑΨΕ
			x=parseFloat(userValues[0]);
			for(var i=loopBegin;i<=loopEnd;i=i+parseFloat(userValues[3])){
				if((exerciseVariation & outputWithConditional)==outputWithConditional){
					if(stringLogicalValue(userValues[4],x)) programOutput+=stringExpressionValue(userValues[6],x)+" ";
				}
				else{
					programOutput+=stringExpressionValue(userValues[6],x)+" ";
				}
				x+=parseFloat(userValues[8]);
			}
		}
	}
	else{//μόνο i
		if((exerciseVariation & swapLoopBody)==swapLoopBody){//Πρώτα τροποποίησε
			//ΔΕ ΜΠΟΡΕΙ ΝΑ ΣΥΜΒΕΙ!!!
		}
		else{//πρώτα ΓΡΑΨΕ
			for(var i=loopBegin;i<=loopEnd;i=i+parseFloat(userValues[3])){
				x=stringExpressionValue(userValues[7],i);
				if((exerciseVariation & outputWithConditional)==outputWithConditional){
					if(stringLogicalValue(userValues[5],i)) programOutput+=stringExpressionValue(userValues[7],i)+" ";
				}
				else{
					programOutput+=x+" ";
				}
			}
		}
		
	}
	if(runMode==modeShowResults){
		document.getElementById("studentResults").innerHTML="Αποτελέσματα εκτέλεσης<br><code>"+programOutput+"</code>";
		$("#studentResults").show(jQueryAnimationRate,function(){
			sizeDIVs();
		});
	}*/
}

function simulationRun(runMode){ //CHECK IT!!
    //Οι επόμενες 2 εντολές τοποθετούνται εδώ και όχι στην simulateCode
    // για να λειτουργεί σωστά και η βηματική εκτέλεση
    $("#resultsArea").show();
    $("#messageArea").hide();
    
    simulationIndex++;
    var jStart=1;
    var nxtSimulationIndex=simulationIndex;
    if(simulationIndex>codeLength){//Μετά την προσομοίωση της τελευταίας εντολής τερμάτισε το μηχανισμό προσομοίωσης
        simulationReset();
        return;
    }
    $(".simulatingCode").removeClass("simulatingCode");
    if(hideSimulationPath){
        jStart=simulationIndex+1;
    }
    //εμφάνιση μονοπατιού προσομοίωσης
    for(var j=jStart;j<=simulationIndex+1;j++){
        $("#cmd"+j).addClass("simulatingCode");
    }

    hideSimulationValues();

    if((exerciseVariation & twoVariables)==twoVariables){// i και x
        if((exerciseVariation & swapLoopBody)==swapLoopBody){//Πρώτα τροποποίησε
            switch (simulationIndex){
                case 0: //Αρχικοποίηση x
                    xSim=parseFloat(userValues[0]);
                    if(showVarValues){
                        $("#xStartVal").html(" x = "+xSim+" ");
                        $("#xStartVal").show(animationRate);
                    }

                    break;
                case 1: //Είσοδος στη Δομή Επανάληψης
                    var iCondVal="ΑΛΗΘΗΣ";
                    var iInitialisationInfo="";
                    if(!iInitialised){
                        iInitialised=true;
                        iSim=loopBegin;
                        iInitialisationInfo="i="+iSim+" , ";
                    }
                    if(iSim>loopEnd && parseFloat(userValues[3])>=0 || iSim<loopEnd && parseFloat(userValues[3])<0){
                        iCondVal="ΨΕΥΔΗΣ";
                        nxtSimulationIndex=4;//Ολοκλήρωση Δομής
                    }
                    if(showVarValues){
                        $("#iCond").html(" "+iInitialisationInfo+iSim+" <= "+loopEnd+" ["+iCondVal+"] ");
                        $("#iCond").show(animationRate);
                    }
                    break;
                case 2: //Υπολογισμός νέας τιμής x
                    xSim+=parseFloat(userValues[8]);
                    if(showVarValues){
                        $("#xVal").html(" x = "+xSim+" ");
                        $("#xVal").show(animationRate);
                    }
                    break;
                case 3: //ΓΡΑΨΕ
                    var debugInfo=" ";
                    if((exerciseVariation & outputWithConditional)==outputWithConditional){
                        outputConditional="ΨΕΥΔΗΣ";
                        var outputDebug="";
                        if(stringLogicalValue(userValues[4],xSim)){
                            outputConditional="ΑΛΗΘΗΣ";
                            outputSim=stringExpressionValue(userValues[6],xSim);
                            programOutput+=outputSim+" ";
                            outputDebug=" , ΟΘΟΝΗ: "+outputSim;
                        }
                        debugInfo+="Συνθήκη = "+outputConditional+outputDebug;
                    }
                    else{
                        outputSim=stringExpressionValue(userValues[6],xSim);
                        programOutput+=outputSim+" ";
                        debugInfo+="ΟΘΟΝΗ: "+outputSim;
                    }
                    if(showVarValues){
                        $("#output").html(debugInfo+" ");
                        $("#output").show(animationRate);
                    }
                    break;
                case 4: //ΤΕΛΟΣ_ΕΠΑΝΑΛΗΨΗΣ
                    iSim+=parseFloat(userValues[3]);
                    if(showVarValues){
                        $("#iVal").html(" i = "+iSim+" ");
                        $("#iVal").show(animationRate);
                    }
                    nxtSimulationIndex=0;
                    break;
            }
        }
        else{//πρώτα ΓΡΑΨΕ
            switch (simulationIndex){
                case 0: //Αρχικοποίηση x
                    xSim=parseFloat(userValues[0]);
                    if(showVarValues){
                        $("#xStartVal").html(" x = "+xSim+" ");
                        $("#xStartVal").show(animationRate);
                    }
                    break;
                case 1: //Είσοδος στη Δομή Επανάληψης
                    var iCondVal="ΑΛΗΘΗΣ";
                    var iInitialisationInfo="";
                    if(!iInitialised){
                        iInitialised=true;
                        iSim=loopBegin;
                        iInitialisationInfo="i = "+iSim+" , ";
                    }
                    if(iSim>loopEnd && parseFloat(userValues[3])>=0 || iSim<loopEnd && parseFloat(userValues[3])<0){
                        iCondVal="ΨΕΥΔΗΣ";
                        nxtSimulationIndex=4;//Ολοκλήρωση Δομής
                    }
                    if(showVarValues){
                        $("#iCond").html(" "+iInitialisationInfo+iSim+" <= "+loopEnd+" ["+iCondVal+"] ");
                        $("#iCond").show(animationRate);
                    }
                    break;
                case 2: //ΓΡΑΨΕ
                    var debugInfo=" ";
                    if((exerciseVariation & outputWithConditional)==outputWithConditional){
                        outputConditional="ΨΕΥΔΗΣ";
                        var outputDebug="";
                        if(stringLogicalValue(userValues[4],xSim)){
                            outputConditional="ΑΛΗΘΗΣ";
                            outputSim=stringExpressionValue(userValues[6],xSim);
                            programOutput+=outputSim+" ";
                            outputDebug=" , ΟΘΟΝΗ: "+outputSim;
                        }
                        debugInfo+="Συνθήκη = "+outputConditional+outputDebug;
                    }
                    else{
                        outputSim=stringExpressionValue(userValues[6],xSim);
                        programOutput+=outputSim+" ";
                        debugInfo+="ΟΘΟΝΗ: "+outputSim;
                    }
                    if(showVarValues){
                        $("#output").html(debugInfo+" ");
                        $("#output").show(animationRate);
                    }
                    break;
                case 3: //Υπολογισμός νέας τιμής x
                    xSim+=parseFloat(userValues[8]);
                    if(showVarValues){
                        $("#xVal").html(" x = "+xSim+" ");
                        $("#xVal").show(animationRate);
                    }
                    break;
                case 4: //ΤΕΛΟΣ_ΕΠΑΝΑΛΗΨΗΣ
                    iSim+=parseFloat(userValues[3]);
                    if(showVarValues){
                        $("#iVal").html(" i = "+iSim+" ");
                        $("#iVal").show(animationRate);
                    }
                    nxtSimulationIndex=0;
                    break;
            }
        }
    }
    else{//μόνο i
        if((exerciseVariation & swapLoopBody)==swapLoopBody){//Πρώτα τροποποίησε
            //ΔΕ ΜΠΟΡΕΙ ΝΑ ΣΥΜΒΕΙ!!!
        }
        else{//πρώτα ΓΡΑΨΕ
            switch (simulationIndex){
                case 0: //Είσοδος στη Δομή Επανάληψης
                    var iCondVal="ΑΛΗΘΗΣ";
                    var iInitialisationInfo="";
                    if(!iInitialised){
                        iInitialised=true;
                        iSim=loopBegin;
                        iInitialisationInfo="i = "+iSim+" , ";
                    }
                    if(iSim>loopEnd && parseFloat(userValues[3])>=0 || iSim<loopEnd && parseFloat(userValues[3])<0){
                        iCondVal="ΨΕΥΔΗΣ";
                        nxtSimulationIndex=2;//Ολοκλήρωση Δομής
                    }
                    if(showVarValues){
                        $("#iCond").html(" "+iInitialisationInfo+iSim+" <= "+loopEnd+" ["+iCondVal+"] ");
                        $("#iCond").show(animationRate);
                    }
                    break;
                case 1: //ΓΡΑΨΕ
                    var debugInfo=" ";
                    if((exerciseVariation & outputWithConditional)==outputWithConditional){
                        outputConditional="ΨΕΥΔΗΣ";
                        var outputDebug="";
                        if(stringLogicalValue(userValues[5],iSim)){
                            outputConditional="ΑΛΗΘΗΣ";
                            outputSim=stringExpressionValue(userValues[7],iSim);
                            programOutput+=outputSim+" ";
                            outputDebug=" , ΟΘΟΝΗ: "+outputSim;
                        }
                        debugInfo+="Συνθήκη = "+outputConditional+outputDebug;
                    }
                    else{
                        outputSim=stringExpressionValue(userValues[7],iSim);
                        programOutput+=outputSim+" ";
                        debugInfo+="ΟΘΟΝΗ: "+outputSim;
                    }
                    if(showVarValues){
                        $("#output").html(debugInfo+" ");
                        $("#output").show(animationRate);
                    }
                    break;
                case 2: //ΤΕΛΟΣ_ΕΠΑΝΑΛΗΨΗΣ
                    iSim+=parseFloat(userValues[3]);
                    if(showVarValues){
                        $("#iVal").html(" i = "+iSim+" ");
                        $("#iVal").show(animationRate);
                    }
                    nxtSimulationIndex=-1;
                    break;
            }            
        }
    }
    simulationIndex=nxtSimulationIndex;
    
    if(runMode==modeShowResults){
        document.getElementById("studentResults").innerHTML="<span id='resultsTitle'>Αποτελέσματα εκτέλεσης</span><br><code>"+programOutput+"</code>";
        $("#studentResults").show();
    }    
    
}

function simulationReset(){
    clearInterval(timerLoop);
    $("#btnNewProblem").prop("disabled",false);
    $("#btnDelete").prop("disabled",false);
    $("#btnSubmit").prop("disabled",false);
    $("#btnShowSolution").prop("disabled",false);
    $(".simulatingCode").removeClass("simulatingCode");
    $("#btnContinue").hide();
    $("#btnForward").prop("disabled",false);
    $("#btnPlay").prop("disabled",false);
    $("#btnPlay").show();
    $("#btnPause").hide();
    $("#btnStop").prop("disabled",true);
    $("#showOptions").show();
    simulationIndex=-1;
    iInitialised=false;
    hideSimulationValues();
    simulationInitialised=false;
}

function hideSimulationValues(){
    if(!showVarValues || simulationIndex!=0){
        $("#xStartVal").html("");
        $("#xStartVal").hide(animationRate);
    }
    if(!showVarValues || simulationIndex<1 || simulationIndex>=codeLength){
        $("#iCond").html("");
        $("#iCond").hide(animationRate);
        
        $("#iVal").html("");
        $("#iVal").hide(animationRate);
    }
    if(!showVarValues || simulationIndex!=outputIndex || simulationIndex==-1){
        $("#output").html("");
        $("#output").hide(animationRate);
    }
    if(!showVarValues || simulationIndex!=generateNewValueIndex || simulationIndex==-1){
        $("#xVal").html("");
        $("#xVal").hide(animationRate);
    }
}

function checkSolution(){
	$("#solutionOk").hide();
	$("#solutionError").hide();
	//userOutputVisible=false;
	$("#studentResults").hide();
	sizeDIVs();
	if(userSolutionOK()){
		if(debug)alert("Εύγε!!!!");
		hideHintTool();
        /*$("#btnPlay").prop("disabled",false);*/

        $("#solutionOk").show(jQueryAnimationRate);
	}
	else{
		$("#solutionError").show(jQueryAnimationRate);

        $("#btnHint").prop("disabled",false);
        $("#btnShowSolution").prop("disabled",false);
        /*$("#btnPlay").prop("disabled",true);*/
		var msg="Την πάτησες...";
		if(debug)alert(msg);
	}
}

function userSolutionOK(){
	var solutionOK=true;
	clearHint();
	//έλεγχος εγκυρότητας και εξαγωγή τιμών χρήστη
	errorLocation=noSyntaxError;
	for(var i=0;i<userEntriesIDs.length;i++){
		if(document.getElementById(userEntriesIDs[i])){
			userValues[i]=trimSpaces(document.getElementById(userEntriesIDs[i]).textContent);
			if(checkEntry(userValues[i],entryTypes[i])){
				if(entryTypes[i]==numericEntry) userValues[i]=parseFloat(userValues[i]);
			}
			else{
				errorLocation+=errorCodes[i];
			}
		}
	}
	solutionOK=(errorLocation==noSyntaxError);
	
	//Αν δεν υπάρχουν συντακτικά λάθη κάνε έλεγχο τιμών και εντοπισμό λογικών λαθών	
	if(solutionOK){
		var error1=false,error2=false,error3=false;
		logicalErrors="";
		switch(patternID){
		case 0:
			error1=xStart!=userValues[0];
			if(error1){
	            logicalErrors+="Η αρχική τιμή της μεταβλητής x πρέπει να είναι <span class='correctValue'>"+xStart+"</span>";
	            if(userValues[0]!="")logicalErrors+=" και όχι <span class='errorValue'>"+userValues[0]+"</span>";
	            logicalErrors+=".<br>";
			}
			error2=loopEndTo!=userValues[2];
			if(error2){
	            logicalErrors+="Η τιμή λήξης της Δομής Επανάληψης πρέπει να είναι <span class='correctValue'>"+loopEndTo+"</span>";
	            if(userValues[2]!="")logicalErrors+=" και όχι <span class='errorValue'>"+userValues[2]+"</span>";
	            logicalErrors+=".<br>";
			}
			error3=xStep!=userValues[8];
			if(error3){
			    logicalErrors+="Η τιμή μεταβολής της μεταβλητής x πρέπει να είναι <span class='correctValue'>"+xStep+"</span>";
	            if(userValues[8]!="")logicalErrors+=" και όχι <span class='errorValue'>"+userValues[8]+"</span>";
	            logicalErrors+=".<br>";
			}
			break;
		case 1:
			if(problemID==5){//countdown
				solutionOK=false; //noSolution=true;
			}
			else{
				error1=loopStartFrom!=userValues[1];
				if(error1){
				    logicalErrors+="Η τιμή έναρξης της Δομής Επανάληψης πρέπει να είναι <span class='correctValue'>"+loopStartFrom+"</span>";
	                if(userValues[1]!="")logicalErrors+=" και όχι <span class='errorValue'>"+userValues[1]+"</span>";
	                logicalErrors+=".<br>";
				}
				error2=loopEndTo!=userValues[2];
				if(error2){
				    logicalErrors+="Η τιμή λήξης της Δομής Επανάληψης πρέπει να είναι <span class='correctValue'>"+loopEndTo+"</span>";
	                if(userValues[2]!="")logicalErrors+=" και όχι <span class='errorValue'>"+userValues[2]+"</span>";
	                logicalErrors+=".<br>";
				}
				error3=trimSpaces(iConditional)!=trimSpaces(userValues[5]);
				if(error3){
				    logicalErrors+="Η τιμή μεταβολής της μεταβλητής x πρέπει να είναι <span class='correctValue'>"+xStep+"</span>";
	                if(userValues[5]!="")logicalErrors+=" και όχι <span class='errorValue'>"+userValues[5]+"</span>";
	                logicalErrors+=".<br>";
				}
			}
			break;
		case 2:
			error1=loopStartFrom!=userValues[1];
			if(error1){
			    logicalErrors+="Η τιμή έναρξης της Δομής Επανάληψης πρέπει να είναι <span class='correctValue'>"+loopStartFrom+"</span>";
	            if(userValues[1]!="")logicalErrors+=" και όχι <span class='errorValue'>"+userValues[1]+"</span>";
	            logicalErrors+=".<br>";
			}
			error2=loopEndTo!=userValues[2];
			if(error2){
			    logicalErrors+="Η τιμή λήξης της Δομής Επανάληψης πρέπει να είναι <span class='correctValue'>"+loopEndTo+"</span>";
	            if(userValues[2]!="")logicalErrors+=" και όχι <span class='errorValue'>"+userValues[2]+"</span>";
	            logicalErrors+=".<br>";
			}
			var iExprOK=false;
			for(var i=0;i<iExpression.length;i++){
				iExprOK=iExprOK || iExpression[i]==userValues[7];
			}
			error3=!iExprOK;
			if(error3){
			    logicalErrors+="Η παράμετρος της εντολής <code>ΓΡΑΨΕ</code> πρέπει να είναι <span class='correctValue'>"+iExpression[0]+"</span>";
	            if(userValues[7]!="")logicalErrors+=" και όχι <span class='errorValue'>"+userValues[7]+"</span>";
	            logicalErrors+=".<br>";
			}
			break;
		case 3:
			error1=loopStartFrom!=userValues[1];
			if(error1){
			    logicalErrors+="Η τιμή έναρξης της Δομής Επανάληψης πρέπει να είναι <span class='correctValue'>"+loopStartFrom+"</span>";
	            if(userValues[1]!="")logicalErrors+=" και όχι <span class='errorValue'>"+userValues[1]+"</span>";
	            logicalErrors+=".<br>";
			}
			error2=loopEndTo!=userValues[2];
			if(error2){
			    logicalErrors+="Η τιμή λήξης της Δομής Επανάληψης πρέπει να είναι <span class='correctValue'>"+loopEndTo+"</span>";
	            if(userValues[2]!="")logicalErrors+=" και όχι <span class='errorValue'>"+userValues[2]+"</span>";
	            logicalErrors+=".<br>";
			}
			error3=loopStepValue!=userValues[3];
			if(error3){
			    logicalErrors+="Το βήμα μεταβολής της Δομής Επανάληψης πρέπει να είναι <span class='correctValue'>"+loopStepValue+"</span>";
	            if(userValues[3]!="")logicalErrors+=" και όχι <span class='errorValue'>"+userValues[3]+"</span>";
	            logicalErrors+=".<br>";
			}
			break;
		}
		solutionOK=!(error1 || error2 || error3);
	}
	return solutionOK;
}

function checkEntry(userEntry,entryType){
	var comparatorPosition=-1;
	var entryOK=true;
	var lessThanAllowed=true;
	var greaterThanAllowed=true;
	var equalAllowed=true;
	var lng=userEntry.length;
	var i=0;
	if(lng==0)entryOK=false;
	if(entryType==conditionalEntry){
		entryOK=!(trimSpaces(userEntry).toLowerCase()!=trimSpaces(iConditional.toLowerCase()) && userEntry!=trimSpaces(xConditional.toLowerCase()));
	}
	else if(entryType==expressionEntry){
		entryOK=!(trimSpaces(userEntry).toLowerCase()!=trimSpaces(iExpression[0].toLowerCase()) && userEntry!=trimSpaces(iExpression[1].toLowerCase()) && userEntry!=trimSpaces(iExpression[2].toLowerCase()) && userEntry!=trimSpaces(xExpression.toLowerCase()));
	}
	else{
		while(entryOK && i<lng){
			currentChar=userEntry.charAt(i);
			if((entryType & numericEntry)!=0){//Έλεγχος αριθμητικών ψηφίων
				if(currentChar>="0" && currentChar<="9" || currentChar=="+" || currentChar=="-"){//αριθμητικά ψηφία και πρόσημα είναι δεκτά
					if((entryType & comparatorEntry)!=0){//Ο συγκριτικός τελεστής πρέπει να ολοκληρώνεται πριν την αριθμητική τιμή
						entryType-=comparatorEntry;
					}
				}
				else if(entryType==numericEntry){//οποιοσδήποτε άλλος χαρακτήρας απορρίπτεται εφόσον αναζητούμε μόνο αριθμό
					entryOK=false;
				}
			}
			if(entryOK && (entryType & comparatorEntry)!=0){//Έλεγχος συγκριτικών τελεστών
				if(i==comparatorPosition+1){//Συγκριτικοί Τελεστές επιτρέπονται μόνο σε διαδοχικές αρχικές θέσεις
					comparatorPosition=i;
					switch(currentChar){
					case "<":
						if(lessThanAllowed){
							userComparator+=currentChar;
							lessThanAllowed=false;
						}
						else{
							entryOK=false;
						}
						break;
					case "=":
						if(equalAllowed){
							userComparatorType=comparatorWithEquality;
							userComparator+=currentChar;
							lessThanAllowed=false;
							greaterThanAllowed=false;
							equalAllowed=false;
						}
						else{
							entryOK=false;
						}
						break;
					case ">":
						if(greaterThanAllowed){
							userComparator+=currentChar;
							lessThanAllowed=false;
							greaterThanAllowed=false;
						}
						else{
							entryOK=false;
						}
						break;//επιτρέπονται σύμβολα συγκριτικών χαρακτήρων της ψευδογλώσσας
					default://οποιοσδήποτε άλλος χαρακτήρας απορρίπτεται
						entryOK=false;
					}
				}
				else{
					entryOK=false;
				}
			}
			i++;
		}
	}
	return entryOK;
}

function trimSpaces(entry){
	var currentChar="",correctedChar="";
	var entryLength=entry.length;
	var trimmed="";
	for(var i=0;i<entryLength;i++){
		currentChar=entry.charAt(i);
		if(currentChar!=" " && currentChar!="ˍ"){
			switch(currentChar){
			case "΅":
				correctedChar="";
				break;
			case "Ά":
			case "ά":
				correctedChar="α";
				break;
			case "Έ":
			case "έ":
				correctedChar="ε";
				break;
			case "Ή":
			case "ή":
				correctedChar="η";
				break;
			case "Ί":
			case "ί":
			case "Ϊ":
			case "ϊ":
			case "ΐ":
				correctedChar="ι";
				break;
			case "Ύ":
			case "ύ":
			case "Ϋ":
			case "ϋ":
			case "ΰ":
				correctedChar="υ";
				break;
			case "Ώ":
			case "ώ":
				correctedChar="ω";
				break;
			case "Ό":
			case "ό":
			case "ο":
				correctedChar="o";//aggliko
				break;
			case "Χ":
			case "χ":
				correctedChar="x";
				break;
			default:
				correctedChar=currentChar.toLowerCase();
			}
			trimmed+=correctedChar;
		}
	}
	return trimmed;
}

function deleteAll(){
	for(var i=0;i<userEntriesIDs.length;i++){
		if(document.getElementById(userEntriesIDs[i])){
			document.getElementById(userEntriesIDs[i]).innerHTML="ˍˍˍ";
		}
	}
    $("#solutionOk").hide(jQueryAnimationRate);
    $("#solutionError").hide(jQueryAnimationRate);
    hideHintTool();
    $("#btnPlay").prop("disabled",true);
    
    $("#studentResults").hide();
	clearHint();
	hideResult();
	sizeDIVs();
}

function showHint(){
	var msg="";
	if(noSolution){
		document.getElementById("studentCodeDIV").style.background="LightCoral";
		document.getElementById("studentCodeDIV").style.color="black";
		for(var i=0;i<userEntriesIDs.length;i++){
			if(document.getElementById(userEntriesIDs[i])){
				document.getElementById(userEntriesIDs[i]).innerHTML="   ";
			}
		}
		msg="Αν και υπάρχει τρόπος να υπολογίσουμε τις τιμές που πρέπει να χρησιμοποιηθούν ώστε το απόσπασμα κώδικα να λειτουργήσει κατά τα αναμενόμενα,";
		msg+=" οι υπολογισμοί αυτοί είναι αρκετά κοπιαστικοί, με αποτέλεσμα αυτή η παραλλαγή να κρίνεται ασύμφορη ως λύση, αφού ο άνθρωπος καταλήγει να κάνει περισσότερη δουλειά από τον υπολογιστή.";
	}
	else{
		var i;
		hintLevel++;
		if(hintLevel>-1){
			for(i=0;i<userEntriesIDs.length;i++){
				if((errorLocation & errorCodes[i])===errorCodes[i]){
					msg+=syntaxError[i]+"<br>";
				}
			}
		}
		if(msg=="")hintLevel++;
		if(hintLevel>0){
		    //simulateCode(modeSupressResults);
			for(i=0;i<additionalErrorMessages.length;i++){
				msg+=additionalErrorMessages[i]+"<br>";
			}
		}
		if(msg=="")hintLevel++;
		if(hintLevel>1){
			if(additionalErrorMessages.length!=0){
				msg+="Διορθώστε τα συντακτικά λάθη του κώδικα για να δείτε πρόσθετες βοηθητικές πληροφορίες.<br>";
			}
		}
		if(msg=="" && hintLevel>-1){
		    //simulateCode(modeShowResults);
		}
		if(msg=="" && hintLevel>0){
			msg+=logicalErrors;
		}
	}
	document.getElementById("hintToShow").innerHTML=msg;
	$("#resultsArea").hide();
	$("#messageArea").show();
}

function clearHint(){
	hintLevel=-1;
	document.getElementById("hintToShow").innerHTML="";
}

function hideHintTool(){
    $("#btnHint").prop("disabled",true);
    $("#messageArea").hide();
}

function hideResult(){
    $("#solutionOk").hide(jQueryAnimationRate);
    $("#solutionError").hide(jQueryAnimationRate);
}

function showSolution(){
    if(requestConfirmationState || confirm("Θέλεις σίγουρα να αποκαλύψεις μία λύση;")){
        if(noSolution){
            showHint();
        }
        else{
            iExpressionSelector=(iExpressionSelector+1) % iExpression.length;//εναλλαγή τιμής
            switch(patternID){
            case 0:
                document.getElementById("xStart").innerHTML=xStart;
                document.getElementById("loopTo").innerHTML=loopEndTo;
                document.getElementById("xStep").innerHTML=xStep;
                break;
            case 1:
                if(problemID==5){//countdown
                    solutionOK=false; //noSolution=true;
                }
                else{
                    document.getElementById("loopFrom").innerHTML=loopStartFrom;
                    document.getElementById("loopTo").innerHTML=loopEndTo;
                    document.getElementById("iConditional").innerHTML=iConditional;
                }
                break;
            case 2:
                document.getElementById("loopFrom").innerHTML=loopStartFrom;
                document.getElementById("loopTo").innerHTML=loopEndTo;
                document.getElementById("iExpression").innerHTML=iExpression[iExpressionSelector];
                break;
            case 3:
                document.getElementById("loopFrom").innerHTML=loopStartFrom;
                document.getElementById("loopTo").innerHTML=loopEndTo;
                document.getElementById("loopStep").innerHTML=loopStepValue;
                break;
            }
            clearEnvironment();
            $("#btnPlay").prop("disabled",false);
        }        
    }
}

function defineExerciseTypes(){
	var exerciseType=1;
	
	twoVariables=exerciseType;
	exerciseType*=2;
	request_xStart=exerciseType;
	exerciseType*=2;
	request_xStep=exerciseType;
	exerciseType*=2;
	swapLoopBody=exerciseType;
	exerciseType*=2;
	loopVarExpression=exerciseType;
	exerciseType*=2;
	loopFrom=exerciseType;
	exerciseType*=2;
	loopTo=exerciseType;
	exerciseType*=2;
	loopStep=exerciseType;
	exerciseType*=2;
	request_loopStep=exerciseType;
	exerciseType*=2;
	outputWithConditional=exerciseType;
	exerciseType*=2;
	request_OutputConditional=exerciseType;
	exerciseType*=2;
	request_OutputExpression=exerciseType;
	exerciseType*=2;
}

function showAppID(){
	window.open("index_DS_II.html","_newtab");
}

function generatePatterns(){
	var html="";
	html+="<code> 1: x <- 0";
	html+="\n 2: <span class='reservedWord'>ΓΙΑ</span> i <span class='reservedWord'>ΑΠΟ</span> 1 <span class='reservedWord'>ΜΕΧΡΙ</span> 10";
	html+="\n 3:   <span class='reservedWord'>ΓΡΑΨΕ</span> x";
	html+="\n 4:   x <- x + 2";
	html+="\n 5: <span class='reservedWord'>ΤΕΛΟΣ_ΕΠΑΝΑΛΗΨΗΣ</span></code>";
	document.getElementById("pattern1").innerHTML=html;
	
	html="<code> 1: <span class='reservedWord'>ΓΙΑ</span> i <span class='reservedWord'>ΑΠΟ</span> 0 <span class='reservedWord'>ΜΕΧΡΙ</span> 18";
	html+="\n 2:   <span class='reservedWord'>ΑΝ</span> i MOD 2 = 0 <span class='reservedWord'>ΤΟΤΕ</span> <span class='reservedWord'>ΓΡΑΨΕ</span> i";
	html+="\n 3: <span class='reservedWord'>ΤΕΛΟΣ_ΕΠΑΝΑΛΗΨΗΣ</span></code>";
	document.getElementById("pattern2").innerHTML=html;

	html="<code> 1: <span class='reservedWord'>ΓΙΑ</span> i <span class='reservedWord'>ΑΠΟ</span> 0 <span class='reservedWord'>ΜΕΧΡΙ</span> 9";
	html+="\n 2:   <span class='reservedWord'>ΓΡΑΨΕ</span> 2*i";
	html+="\n 3: <span class='reservedWord'>ΤΕΛΟΣ_ΕΠΑΝΑΛΗΨΗΣ</span></code>";
	document.getElementById("pattern3").innerHTML=html;

	html="<code> 1: <span class='reservedWord'>ΓΙΑ</span> i <span class='reservedWord'>ΑΠΟ</span> 0 <span class='reservedWord'>ΜΕΧΡΙ</span> 18 <span class='reservedWord'>ΜΕ_ΒΗΜΑ</span> 2";
	html+="\n 2:   <span class='reservedWord'>ΓΡΑΨΕ</span> i";
	html+="\n 3: <span class='reservedWord'>ΤΕΛΟΣ_ΕΠΑΝΑΛΗΨΗΣ</span></code>";
	document.getElementById("pattern4").innerHTML=html;
}

function copyPattern(selector){
	if(patternID==selector) return;
	clearEnvironment();
	clearPatterns();
	$("#pattern"+(selector+1)).removeClass("patternCode");
	$("#pattern"+(selector+1)).addClass("selectedPattern");

	exerciseVariation=0;
	patternID=selector;
	var html="<code><br> ";
	switch (patternID){
	case 0:
		exerciseVariation=twoVariables;
		html+="1:<span class='algoCmd' id='cmd1'> x <- "+generateEntryPlaceholder("xStart",0)+"</span>   <span class='showValues' id='xStartVal'></span>";
		html+="\n 2:<span class='algoCmd' id='cmd2'> <span class='reservedWord'>ΓΙΑ</span> i <span class='reservedWord'>ΑΠΟ</span> 1 <span class='reservedWord'>ΜΕΧΡΙ</span> "+generateEntryPlaceholder("loopTo",10)+"</span>   <span class='showValues' id='iCond'></span>";
		html+="\n 3:<span class='algoCmd' id='cmd3'>   <span class='reservedWord'>ΓΡΑΨΕ</span> x"+"</span>   <span class='showValues' id='output'></span>";
		html+="\n 4:<span class='algoCmd' id='cmd4'>   x <- x + "+generateEntryPlaceholder("xStep",2)+"</span>   <span class='showValues' id='xVal'></span>";
		html+="\n 5:<span class='algoCmd' id='cmd5'> <span class='reservedWord'>ΤΕΛΟΣ_ΕΠΑΝΑΛΗΨΗΣ</span>"+"</span>   <span class='showValues' id='iVal'></span>";
		loopStartFrom=1;
		loopStepValue=1;
		codeLength=5;
		break;
	case 1:
		exerciseVariation=outputWithConditional;
		html+="1:<span class='algoCmd' id='cmd1'> <span class='reservedWord'>ΓΙΑ</span> i <span class='reservedWord'>ΑΠΟ</span> "+generateEntryPlaceholder("loopFrom",0)+" <span class='reservedWord'>ΜΕΧΡΙ</span> "+generateEntryPlaceholder("loopTo",18)+"</span>   <span class='showValues' id='iCond'></span>";
		html+="\n 2:<span class='algoCmd' id='cmd2'>   <span class='reservedWord'>ΑΝ</span> "+generateEntryPlaceholder("iConditional","i MOD 2 = 0")+" <span class='reservedWord'>ΤΟΤΕ</span> <span class='reservedWord'>ΓΡΑΨΕ</span> i"+"</span>   <span class='showValues' id='output'></span>";
		html+="\n 3:<span class='algoCmd' id='cmd3'> <span class='reservedWord'>ΤΕΛΟΣ_ΕΠΑΝΑΛΗΨΗΣ</span>"+"</span>   <span class='showValues' id='iVal'></span>";
		loopStepValue=1;
		iConditional="i MOD 2 = 0";
		iExpression=["i","i","i","i"];
		codeLength=3;
		break;
	case 2:
		html+="1:<span class='algoCmd' id='cmd1'> <span class='reservedWord'>ΓΙΑ</span> i <span class='reservedWord'>ΑΠΟ</span> "+generateEntryPlaceholder("loopFrom",0)+" <span class='reservedWord'>ΜΕΧΡΙ</span> "+generateEntryPlaceholder("loopTo",9)+"</span>   <span class='showValues' id='iCond'></span>";
		html+="\n 2:<span class='algoCmd' id='cmd2'>   <span class='reservedWord'>ΓΡΑΨΕ</span> "+generateEntryPlaceholder("iExpression","2*i")+"</span>   <span class='showValues' id='output'></span>";
		html+="\n 3:<span class='algoCmd' id='cmd3'> <span class='reservedWord'>ΤΕΛΟΣ_ΕΠΑΝΑΛΗΨΗΣ</span>"+"</span>   <span class='showValues' id='iVal'></span>";
		loopStepValue=1;
		codeLength=3;
		break;
	case 3:
		html+="1:<span class='algoCmd' id='cmd1'> <span class='reservedWord'>ΓΙΑ</span> i <span class='reservedWord'>ΑΠΟ</span> "+generateEntryPlaceholder("loopFrom",0)+" <span class='reservedWord'>ΜΕΧΡΙ</span> "+generateEntryPlaceholder("loopTo",18)+" <span class='reservedWord'>ΜΕ_ΒΗΜΑ</span> "+generateEntryPlaceholder("loopStep",2)+"</span>   <span class='showValues' id='iCond'></span>";
		html+="\n 2:<span class='algoCmd' id='cmd2'>   <span class='reservedWord'>ΓΡΑΨΕ</span> i"+"</span>   <span class='showValues' id='output'></span>";
		html+="\n 3:<span class='algoCmd' id='cmd3'> <span class='reservedWord'>ΤΕΛΟΣ_ΕΠΑΝΑΛΗΨΗΣ</span></span>   <span class='showValues' id='iVal'></span>";
		iExpression=["i","i","i","i"];
		codeLength=3;
		break;
	}
	html+="<br> </code>";
	document.getElementById("studentCodeDIV").innerHTML=html;
	document.getElementById("studentCodeDIV").style.display="initial";
	document.getElementById("studentCodeDIV").style.background="PaleGoldenRod";
    simulationReset();
	sizeDIVs();
	determineSolution();
}

function selectRandomProblem(){
	var newID=-1;
	do{
		newID=parseInt(Math.random()*problemDescr.length);
	} while(newID==problemID);
	showProblem(newID);	
}

function showProblemDescription(){
	var descr="";
	var problemPrompt="<font size='4'>Επιλέξτε ένα από αυτά και τροποποιήστε το, ώστε να εμφανίζει ";
	var problemPS="</font><br><font size='3'>Σημειώστε ότι <i>ίσως</i> να μην είναι όλα τα αποσπάσματα κατάλληλα για τη λύση του προβλήματος.</font>";
	clearEnvironment();

	$("#btnSubmit").prop("disabled",true);
    $("#btnDelete").prop("disabled",true);
    $("#btnShowSolution").prop("disabled",true);
    $("#btnForward").prop("disabled",true);
	switch(problemID){
	case 0:
		multitude=parseInt(Math.random()*40)+10;
		descr="τους πρώτους "+multitude+" άρτιους.";
		break;
	case 1:
		multitude=10;
		descr="τους πρώτους 10 περιττούς.";
		break;
	case 2:
		multitude=parseInt(Math.random()*40)+10;
		descr="τα πρώτα "+multitude+" πολλαπλάσια του 3.";
		break;
	case 3:
		regionStart=3*(parseInt(Math.random()*20)+1);
		regionEnd=parseInt(Math.random()*40+10)+regionStart;
		descr="τα πολλαπλάσια του 3 στο διάστημα ["+regionStart+" , "+regionEnd+"].";
		break;
	case 4:
		regionStart=(parseInt(Math.random()*200)+1);
		regionEnd=parseInt(Math.random()*500)+50+regionStart;
		descr="τα πολλαπλάσια του 3 στο διάστημα ["+regionStart+" , "+regionEnd+"].";
		break;
	case 5:
		descr="την αντίστροφη μέτρηση για την εκτόξευση ενός πυραύλου.";
		break;
	}
	if(problemID>-1){
		document.getElementById("exercisePrompt").innerHTML="<h3>"+problemDescr[problemID]+"</h3>"+problemPrompt+descr+problemPS;
		document.getElementById("studentCodeDIV").innerHTML="";
		sizeDIVs();
	}
}

function determineSolution(){
	noSolution=false;
	switch(problemID){
	case 0:
		determineMultitudeSolution();
		break;
	case 1:
		determineOddsSolution();
		break;
	case 2:
		determineThreesSolution();
		break;
	case 3:
		determineThreesASolution();
		break;
	case 4:
		determineThreesBSolution();
		break;
	case 5:
		determineCountdownSolution();
		break;
	}
}

function determineMultitudeSolution(){
	switch(patternID){
	case 0:
		xStart=0;
		loopEndTo=multitude;
		xStep=2;
		break;
	case 1:
		loopStartFrom=0;
		loopEndTo=2*(multitude-1);
		iConditional="i MOD 2 = 0";
		break;
	case 2:
		loopStartFrom=0;
		loopEndTo=multitude-1;
		iExpression=["2*i","i*2","2*i","i*2"];
		break;
	case 3:
		loopStartFrom=0;
		loopEndTo=2*(multitude-1);
		loopStepValue=2;
		break;
	}
}

function determineOddsSolution(){
	switch(patternID){
	case 0:
		xStart=1;
		loopEndTo=multitude;
		xStep=2;
		break;
	case 1:
		loopStartFrom=1;
		loopEndTo=2*multitude-1;
		iConditional="i MOD 2 = 1";
		break;
	case 2:
		loopStartFrom=0;
		loopEndTo=multitude-1;
		iExpression=["2*i+1","i*2+1","2*i+1","i*2+1"];
		break;
	case 3:
		loopStartFrom=1;
		loopEndTo=2*multitude-1;
		loopStepValue=2;
		break;
	}
}

function determineThreesSolution(){
	switch(patternID){
	case 0:
		xStart=0;
		loopEndTo=multitude;
		xStep=3;
		break;
	case 1:
		loopStartFrom=0;
		loopEndTo=3*(multitude-1);
		iConditional="i MOD 3 = 0";
		break;
	case 2:
		loopStartFrom=0;
		loopEndTo=multitude-1;
		iExpression=["3*i","i*3","3*i","i*3"];
		break;
	case 3:
		loopStartFrom=0;
		loopEndTo=3*(multitude-1);
		loopStepValue=3;
		break;
	}
}

function determineThreesASolution(){
	switch(patternID){
	case 0:
		xStart=regionStart;
		loopEndTo=parseInt((regionEnd-regionStart)/3)+1;
		xStep=3;
		break;
	case 1:
		loopStartFrom=regionStart;
		loopEndTo=regionEnd;
		iConditional="i MOD 3 = 0";
		break;
	case 2:
		loopStartFrom=regionStart/3;
		loopEndTo=parseInt(regionEnd/3);
		iExpression=["3*i","i*3","3*i","i*3"];
		break;
	case 3:
		loopStartFrom=regionStart;
		loopEndTo=regionEnd;
		loopStepValue=3;
		break;
	}
}

function determineThreesBSolution(){
	switch(patternID){
	case 0:
		noSolution=true;
		break;
	case 1:
		loopStartFrom=regionStart;
		loopEndTo=regionEnd;
		iConditional="i MOD 3 = 0";
		break;
	case 2:
		noSolution=true;
		break;
	case 3:
		noSolution=true;
		break;
	}
}

function determineCountdownSolution(){
	switch(patternID){
	case 0:
		xStart=10;
		loopEndTo=11;
		xStep=-1;
		break;
	case 1:
		noSolution=true;
		break;
	case 2:
		loopStartFrom=0;
		loopEndTo=10;
		iExpression=["10-i","10-i","10-i","10-i"];
		break;
	case 3:
		loopStartFrom=10;
		loopEndTo=0;
		loopStepValue=-1;
		break;
	}
}

function clearAdditionalErrorMessages(){
	for(var i=additionalErrorMessages.length-1;i>=0;i--){
		additionalErrorMessages.splice(i,1);
	}
}

function hideHelp(){
    $("#openModalHelp").hide();
}

function showHelp(){
    var availableHeight=window.innerHeight-48;
    if(availableHeight>100){
        $("#openModalHelp").show();
        $("#helpContent").css("height","auto");        
        var maxHeight=$("#helpContent").height();
        var heightToUse=availableHeight<maxHeight?availableHeight:maxHeight;
        $("#helpContent").height(heightToUse);
    }
    else{
        alert("Δεν υπάρχει αρκετός διαθέσιμος χώρος για εμφάνιση του παράθυρου βοήθειας. Παρακαλώ μεγαλώστε το παράθυρο και δοκιμάστε ξανά.");
    }
}