/**
 * 
 */

function stringExpressionValue(expression,x){
	expression=trimSpaces(expression.toLowerCase());
	var unexpectedEndOfExpressionErrMsg="Η αλγεβρική παράσταση δεν τερματίζεται σωστά.";
	var unknownElementErrMsg="Μη αναγνωρίσιμο στοιχείο (τελεστής/συνάρτηση/...). Παρακαλώ ελέξτε την παράσταση στη θέση:";
	var emptyExpressionErrMsg="Παρακαλώ δώστε μια αλγεβρική παράσταση.";
	var parenthesisErrMsg="Υπάρχει λάθος στην έκφραση που πληκτρολογήσατε. Παρακαλώ ελέγξτε τις παρενθέσεις.";
	var length=expression.length-1;
	var i=0;
	var subExpression;
	var exprValue=0;
	var limitingSymbols="+-";
	var exponentLimitingSymbols="+-*/dm";
	if(length<0){
		updateErrorArray(emptyExpressionErrMsg);
		return "error";
	}
	while(i<=length){
		switch(expression.charAt(i)){
	    case "(":
	    	i++;
	    	subExpression=getSubexpressionInParentheses();
		    exprValue=stringExpressionValue(subExpression,x);
		    i++;
		    break;
	    case "s"://ημ
	    	if(expression.substring(i,i+4)=="sin("){
	    		i+=4;
	    		subExpression=getSubexpressionInParentheses();
	    		exprValue=Math.sin(stringExpressionValue(subExpression, x));
	    		i++;
	    	}
    		else{
    			updateErrorArray(unknownElementErrMsg+(i+1));
	    		return "error";
	    	}
	    	break;
	    case "c"://συν
		    if(expression.substring(i,i+4)=="cos("){
		        i+=4;
		        subExpression=getSubexpressionInParentheses();
		        exprValue=Math.cos(stringExpressionValue(subExpression, x));
		        i++;
			}  
	    	else{
	    		updateErrorArray(unknownElementErrMsg+(i+1));
	    		return "error";
	    	}
	    	break;
	    case "t"://εφ
		    if(expression.substring(i,i+4)=="tan("){
		        i+=4;
		        subExpression=getSubexpressionInParentheses();
		        exprValue=Math.tan(stringExpressionValue(subExpression, x));
		        i++;
			}  
	    	else{
	    		updateErrorArray(unknownElementErrMsg+(i+1));
	    		return "error";
	    	}
	    	break;
	    case "d"://div
		    if(expression.substring(i,i+3)=="div"){
		        i+=3;
		        subExpression="";
				if(expression.charAt(i)=="("){
					i++;
					subExpression=getSubexpressionInParentheses();
				}
				else{
			        do{
			        	subExpression=subExpression+expression.charAt(i);
				        i++;
				    }while(limitingSymbols.indexOf(expression.charAt(i))==-1 && i<=length);
				}
		    	exprValue=parseInt(exprValue / stringExpressionValue(subExpression,x));
			}  
	    	else{
	    		updateErrorArray(unknownElementErrMsg+(i+1));
	    		return "error";
	    	}
	    	break;
	    case "m"://mod
		    if(expression.substring(i,i+3)=="mod"){
		        i+=3;
		        subExpression="";
				if(expression.charAt(i)=="("){
					i++;
					subExpression=getSubexpressionInParentheses();
				}
				else{
			        do{
			        	subExpression=subExpression+expression.charAt(i);
				        i++;
				    }while(limitingSymbols.indexOf(expression.charAt(i))==-1 && i<=length);
				}
		    	exprValue=exprValue % stringExpressionValue(subExpression,x);
			}  
	    	else{
	    		updateErrorArray(unknownElementErrMsg+(i+1));
	    		return "error";
	    	}
	    	break;
	    case "+":
	    case "-":
	    case "*":
	    case "/":
	    case "^":
	    	var selectedOperator=expression.charAt(i);
	    	var limit=limitingSymbols;
	    	if(selectedOperator=="^"){
	    		limit=exponentLimitingSymbols;
	    	}
			i++;
			if(i>length){
				updateErrorArray(unexpectedEndOfExpressionErrMsg);
				return "error";
			}
			subExpression="";
			while(limit.indexOf(expression.charAt(i))==-1 && i<=length){
				if(expression.charAt(i)=="("){
					i++;
					subExpression=subExpression+"("+getSubexpressionInParentheses();
				}
				else{
					subExpression=subExpression+expression.charAt(i);
					i++;
				}
			}
			if(selectedOperator=="+"){
				exprValue=exprValue+stringExpressionValue(subExpression,x);
			}
			else if(selectedOperator=="-"){
				exprValue=exprValue-stringExpressionValue(subExpression,x);
			}
			else if(selectedOperator=="*"){
				exprValue=exprValue*stringExpressionValue(subExpression,x);
			}
			else if(selectedOperator=="/"){
				exprValue=exprValue/stringExpressionValue(subExpression,x);
			}	
			else if(selectedOperator=="^"){
				exprValue=Math.pow(exprValue,stringExpressionValue(subExpression,x));
			}	
			break;
	    case "x"://Για έκφραση που περιλαμβάνει μεταβλητή με όνομα x
	    case "i"://Για έκφραση που περιλαμβάνει μεταβλητή με όνομα i
	    	exprValue=x;
		    i++;
		    break;
	    case "π":
		    exprValue=Math.PI;
		    i++;
		    break;
	    case "0":
	    case "1":
	    case "2":
	    case "3":
	    case "4":
	    case "5":
	    case "6":
	    case "7":
	    case "8":
	    case "9":
	    case ".":
	    	subExpression="";
			while ((((expression.charAt(i)>="0") && (expression.charAt(i)<="9")) || (expression.charAt(i)==".") || (expression.charAt(i)=="%")) && (i<=length)){
				subExpression=subExpression+expression.charAt(i);
				i++;
			}
			if(subExpression.charAt(subExpression.length-1)=="%"){
				exprValue=parseFloat(subExpression)/100;
			}
			else{
				exprValue=parseFloat(subExpression);
			}
			break;
	    default:
	    	updateErrorArray(unknownElementErrMsg);
	    	return "error";
		}//της switch
	}//της while
	return exprValue;
	
	function getSubexpressionInParentheses(){
		var parenthesisCounter=1;//Η getSubexpressionInParentheses καλείται όταν έχει ήδη εντοπιστεί παρένθεση που ανοίγει
		var subExpr="";
	    while(expression.charAt(i)!=")" || parenthesisCounter!=0){
	    	var currentChar=expression.charAt(i);
	    	if(currentChar=="("){
	    		parenthesisCounter++;
	    	}
	    	else if(currentChar==")"){
	    		parenthesisCounter--;
	    	}
	    	if(parenthesisCounter>0){
		    	subExpr=subExpr+currentChar;
		    	i++;
		    	if(i>length){
		    		updateErrorArray(parenthesisErrMsg);
		    		return "error";
		    	}
	    	}
	    }
	    return subExpr;
	}
}

function stringComparativeValue(expression,x){
	expression=trimSpaces(expression.toLowerCase());
	var unexpectedEndOfExpressionErrMsg="Η λογική συνθήκη δεν περιλαβάνει δεύτερο μέλος.";
	var noComparatorErrMsg="Δε δόθηκε συγκριτικός τελεστής.";
	var multipleComparatorsErrMsg="Μόνο ένας συγκριτικός τελεστής επιτρέπεται.";
	var length=expression.length-1;
	var i=0;
	var selectedComparator="";
	var logicalExpr1="";
	var logicalExpr2="";
	var logicalSubexpression="";
	var logicalValue=false;
	var limitingSymbols="=<>";//Πρώτοι χαρακτήρες συγκριτικών τελεστών
	if(length<0){
		updateErrorArray(emptyExpressionErrMsg);
		return "error";
	}
	while(i<=length){
		switch(expression.charAt(i)){
	    case "=":
	    case ">":
	    case "<":
	    /*case "<>":
	    case ">=":
	    case "<=":*/
	    	if(selectedComparator!=""){//Αν έχει ήδη εντοπιστεί συγκριτικός τελεστής...
	    		updateErrorArray(multipleComparatorsErrMsg);
				return "error";
	    	}
	    	selectedComparator=expression.charAt(i);
    		i++;
	    	if(limitingSymbols.indexOf(expression.charAt(i))>-1){
	    		selectedComparator=selectedComparator+expression.charAt(i);
	    		i++;
	    	}
			if(i>length){
				updateErrorArray(unexpectedEndOfExpressionErrMsg);
				return "error";
			}
			logicalExpr2="";
			while(limitingSymbols.indexOf(expression.charAt(i))==-1 && i<=length){
				logicalExpr2=logicalExpr2+expression.charAt(i);
				i++;
			}
			if(i<=length){
				updateErrorArray(multipleComparatorsErrMsg);
				return "error";
			}
			else if(selectedComparator=="="){
				logicalValue=stringExpressionValue(logicalExpr1,x) == stringExpressionValue(logicalExpr2,x);
			}
			else if(selectedComparator=="<>"){
				logicalValue=stringExpressionValue(logicalExpr1,x) != stringExpressionValue(logicalExpr2,x);
			}
			else if(selectedComparator==">"){
				logicalValue=stringExpressionValue(logicalExpr1,x) > stringExpressionValue(logicalExpr2,x);
			}
			else if(selectedComparator==">="){
				logicalValue=stringExpressionValue(logicalExpr1,x) >= stringExpressionValue(logicalExpr2,x);
			}
			else if(selectedComparator=="<"){
				logicalValue=stringExpressionValue(logicalExpr1,x) < stringExpressionValue(logicalExpr2,x);
			}
			else if(selectedComparator=="<="){
				logicalValue=stringExpressionValue(logicalExpr1,x) <= stringExpressionValue(logicalExpr2,x);
			}	
			break;
	    default:
	        while(limitingSymbols.indexOf(expression.charAt(i))==-1 && i<=length){
	        	logicalExpr1=logicalExpr1+expression.charAt(i);
	        	i++;
	    	}
		}//της switch
	}//της while
	if(selectedComparator!=""){
		return logicalValue;
	}
	else{
		updateErrorArray(noComparatorErrMsg);
		return "error";
	}
}

function stringLogicalValue(expression,x){
	expression=trimSpaces(expression.toLowerCase());
	var unexpectedStartOfExpressionErrMsg="Η λογική συνθήκη δεν ξεκινά σωστά.";
	var unexpectedEndOfExpressionErrMsg="Η λογική συνθήκη δεν τερματίζεται σωστά.";
	var unknownOperatorErrMsg="Άγνωστος λογικός τελεστής.";
	var length=expression.length-1;
	var i=0;
	var logicalExpr="";
	var logicalSubexpression="";
	var logicalValue=false;
	var limitingSymbols="οκη";//Πρώτοι χαρακτήρες λογικών τελεστών κατά σειρά προτεραιότητας
	if(length<0){
		updateErrorArray(emptyExpressionErrMsg);
		return "error";
	}
	while(i<=length){
		switch(expression.charAt(i)){
	    case "ο"://Ελληνικά
	    case "o"://Αγγλικά
	    	//ΠΡΟΣΟΧΗ: Η trimSpaces αλλάζει το "χ" σε "x"
	    	if(expression.substring(i,i+3)=="oxι" || expression.substring(i,i+3)=="oxi"){
	    		i+=3;
	    		if(expression.charAt(i)=="("){
	    			logicalSubexpression=getLogicalSubexpressionInParentheses();
	    		}
	    		else{
	    			logicalSubexpression="";
	    			while(limitingSymbols.indexOf(expression.charAt(i))==-1 && i<=length){
	    				logicalSubexpression=logicalSubexpression+expression.charAt(i);
	    				i++;
	    			}
	    		}
	    		logicalValue=!stringLogicalValue(logicalSubexpression,x);
	    	}
	    	else{
	    		updateErrorArray(unknownOperatorErrMsg);
	    		return "error";
	    	}
	    	break;
	    case "κ"://Ελληνικά
	    case "k"://Αγγλικά
	    	if(i==0){
	    		updateErrorArray(unexpectedStartOfExpressionErrMsg);
	    		return "error";
	    	}
	    	if(expression.substring(i,i+3)=="και" || expression.substring(i,i+3)=="kai"){
	    		i+=3;
	    		if(expression.charAt(i)=="("){
	    			logicalSubexpression=getLogicalSubexpressionInParentheses();
	    		}
	    		else{
	    			logicalSubexpression="";
	    			while(limitingSymbols.substring(1,3).indexOf(expression.charAt(i))==-1 && i<=length){
	    				logicalSubexpression=logicalSubexpression+expression.charAt(i);
	    				i++;
	    			}
	    		}
	    		logicalValue=logicalValue && stringLogicalValue(logicalSubexpression,x);
	    	}
	    	else{
	    		updateErrorArray(unknownOperatorErrMsg);
	    		return "error";
	    	}
	    	break;
	    case "η"://Ελληνικά
	    case "h"://Αγγλικά
	    	if(i==0){
	    		updateErrorArray(unexpectedStartOfExpressionErrMsg);
	    		return "error";
	    	}
    		i++;
    		if(expression.charAt(i)=="("){
    			logicalSubexpression=getLogicalSubexpressionInParentheses();
    		}
    		else{
    			logicalSubexpression="";
    			while(limitingSymbols.substring(2,3).indexOf(expression.charAt(i))==-1 && i<=length){
    				logicalSubexpression=logicalSubexpression+expression.charAt(i);
    				i++;
    			}
    		}
    		logicalValue=logicalValue || stringLogicalValue(logicalSubexpression,x);
			break;
	    default:
	        while(limitingSymbols.indexOf(expression.charAt(i))==-1 && i<=length){
	        	logicalExpr=logicalExpr+expression.charAt(i);
	        	i++;
	        }
	        logicalValue=stringComparativeValue(logicalExpr,x);
		}//της switch
	}//της while
	return logicalValue;

	function getLogicalSubexpressionInParentheses(){
		var parenthesisCounter=1;//Η getSubexpressionInParentheses καλείται όταν έχει ήδη εντοπιστεί παρένθεση που ανοίγει
		var subExpr="";
	    while(expression.charAt(i)!=")" || parenthesisCounter!=0){
	    	var currentChar=expression.charAt(i);
	    	if(currentChar=="("){
	    		parenthesisCounter++;
	    	}
	    	else if(currentChar==")"){
	    		parenthesisCounter--;
	    	}
	    	if(parenthesisCounter>0){
		    	subExpr=subExpr+currentChar;
		    	i++;
		    	if(i>length){
		    		updateErrorArray(parenthesisErrMsg);
		    		return "error";
		    	}
	    	}
	    }
	    return subExpr;
	}
}

function updateErrorArray(errMsg){
	var found=false;
	i=0;
	while(i<additionalErrorMessages.length && additionalErrorMessages[i]!=errMsg){
		i++;
	}
	if(additionalErrorMessages[i]!=errMsg){
		if(debug)alert(errMsg);
		additionalErrorMessages.push(errMsg);
	}
}