/**
 * 
 */
function statement(htmlID,leftBorder,topBorder,left,top,row,col,width,height,page){
	this.htmlID=htmlID;
	this.leftBorder=leftBorder;
	this.topBorder=topBorder;
    this.left=left;
    this.top=top;
    this.width=width;
    this.row=row;
    this.col=col;
    this.height=height;
    this.page=page;
    this.autoUpdate=true;
    this.mHover=false;
    this.grabbed=false;
    this.grabbedSize=1;
    this.opacity=1;
    $("#"+this.htmlID).css("zIndex","0");//Μεταφορά στο φόντο

    this.setRow=function(newRow){
    	if(newRow>-1 && newRow<4){
    		this.row=newRow;
    		this.setTop(this.row*this.height+this.topBorder);
    	}
    };

    this.setCol=function(newCol){
    	if(newCol>-1 && newCol<2){
    		this.col=newCol;
    		this.setLeft(this.col*this.width+this.leftBorder);
    	}
    };

    this.setLeft=function(newLeft){
    	this.left=newLeft;
		if(this.autoUpdate)	this.show();
    };

    this.setTop=function(newTop){
    	this.top=newTop;
		if(this.autoUpdate)	this.show();
    };

    this.move=function(newLeft,newTop){
    	this.autoUpdate=false; 
    	this.setLeft(newLeft);
    	this.autoUpdate=true;
    	this.setTop(newTop);
    };

    this.show=function(){
		var rate=100;
		if (this.grabbed) rate=5;
		$("#"+this.htmlID).animate({left:this.left, top:this.top, width:this.grabbedSize*this.width, height:this.grabbedSize*this.height, opacity:this.opacity},rate);
	};
	
	this.mouseHover=function(mouseX,mouseY){
		var inX=mouseX>this.left && mouseX<=this.left+this.width;
		var inY=mouseY>this.top && mouseY<=this.top+this.height;
		this.mHover=inX && inY;
		return this.mHover;
	};
	
	this.grab=function(){
		this.grabbed=true;
		this.grabbedSize=0.95;
		$("#"+this.htmlID).css("zIndex","999");//Μεταφορά στο προσκήνιο
		this.show();
	};
	
	this.release=function(){
		this.grabbed=false;
		this.grabbedSize=1;
		$("#"+this.htmlID).css("zIndex","0");//Επαναφορά στο φόντο
		this.show();
	};
}