/**
 * 
 */
var mX=0,mY=0;
var tapping=false;

var statements=[];
var divHoveringIndex=-1;
var divSrcIndex=-1;
var divDestinationIndex=-1;
var xOffset=0;
var yOffset=0;
var slotHeight=0;
var statementsTopBorder;

function initialise(){
	$("#number-A").val(varValues[0]);
	$("#number-B").val(varValues[1]);
	$("#number-C").val(varValues[2]);
	simulating=false;
	simulatingBackwards=false;
	visibleCases=0;
	codeLeftBorder=($(document).width())/2+verticalBorder;
	codeTopBorder=$("#buttonArea").outerHeight();
	
	showAppTitle();
	showButtonCaptions();
	showProblem();
	promptTopBorder=codeTopBorder+$("#problemWording").outerHeight()+verticalBorder;
	adjustCode();
	defineConditionalsArray();
	$(".movableDIV").hide();
	
	$("#solutionControls").hide();
	$("#simulateControls").hide();
	$("#algorithmStart").hide();
	$("#algorithmEnd").hide();
	$("#dataInput").hide();
	initialiseEvents();
	showPrompt();
	$(".varLabel").css("text-align","center");
}

function initialiseEvents(){
	//mouse events
	document.addEventListener("mousedown", function(evt){
		handleMouseDown(evt);
	});
	document.addEventListener("mouseup", function(evt){
		mX=evt.pageX;
	 	mY=evt.pageY;
		handleMouseUp(evt);
	});
	document.addEventListener("mousemove", function(evt){
		handleMouseMove(evt);
	});
	
	$(".problemCases").hover(
		function(){
			if(visibleCases==Math.pow(2,noOfCases)-1){
				$("#part"+this.id.substr(4,1)).css({"background-color": "AntiqueWhite"});
			}
		},
		function(){
			if(visibleCases==Math.pow(2,noOfCases)-1){
				$("#part"+this.id.substr(4,1)).css({"background-color": "PaleGoldenRod"});
			}
		}
	);

	//touch events
	$("#showInfo").on("touchend",function(evt){
	    $("#showInfo").trigger("click");
	});
	
	/*document.addEventListener("touchstart",function(evt){
		evt.preventDefault();
		handleMouseMove();
		handleMouseDown();
    }, false);*/
	
	$(".problemCases").on("tap",function(){
		tapping=true;
		if(visibleCases==Math.pow(2,noOfCases)-1){
			for(var i=0;i<statements.length;i++){
				$("#part"+i).css({"background-color": "PaleGoldenRod"});
			}
			$("#part"+this.id.substr(4,1)).css({"background-color": "AntiqueWhite"});
		}
	});
	
	document.addEventListener("touchend",function(evt){
		if(tapping){
			tapping=false;
			return;
		}
		evt.preventDefault();
		var i=0;
 		mX=evt.changedTouches[0].pageX;
 		mY=evt.changedTouches[0].pageY;
 		if(divSrcIndex>-1){//έλεγχος σημείου απόθεσης
 			statements[divSrcIndex].release();
 			divDestinationIndex=-1;
 	 		i=0;
 	 	 	while(i<statements.length && divDestinationIndex==-1){
 	 	 		if (statements[i].mouseHover(mX,mY) && i!=divSrcIndex){
 	 	 			divDestinationIndex=i;
 	 	 		}
 	 	 		else{
 	 	 			i++;
 	 	 		}
 	 	 	}
 	 	 	handleMouseUp(evt);
 	 		$.each($(".tapped"),function(){
 	 			$(this).removeClass("tapped");
 	 		});
 	 	 	divSrcIndex=-1;
 	 	 	divDestinationIndex=-1;
 		}
 		else{//έλεγχος σημείου επαφής για εντοπισμό επιλεγμένου statement
 	 		divSrcIndex=-1;
 	 		for(i=0;i<statements.length;i++){
 	 			$("#case"+statements[i].htmlID.substr(4,1)).css({"background-color": "#d1d1d1"});
	 			$("#part"+statements[i].htmlID.substr(4,1)).css({"background-color": "PaleGoldenRod"});
 	 		}
 	 		i=0;
 	 	 	while(i<statements.length && divSrcIndex==-1){
 	 	 		if (statements[i].mouseHover(mX,mY)){
 	 	 			xOffset=statements[i].left-mX;
 	 	 			yOffset=statements[i].top-mY;
 	 	 			divSrcIndex=i;
 	 	 		}
 	 	 		else{
 	 	 			i++;
 	 	 		}
 	 	 	}
 	 	 	if(divSrcIndex>-1){
 	 	 		$("#"+statements[divSrcIndex].htmlID).addClass("tapped");
 	 	 		$("#case"+statements[divSrcIndex].htmlID.substr(4,1)).css({"background-color": "AntiqueWhite"});
 	 	 	}
 		}
    }, false);
	/*document.addEventListener("touchmove",function(evt){
        evt.preventDefault();
		mX=evt.changedTouches[0].pageX;
		mY=evt.changedTouches[0].pageY;
		handleMouseMove();
    }, false);*/

	// Κουμπιά
    $("#btnPlay").on("click touchstart",function(){
    	simulating=true;
    	$("#btnPlay").hide();
    	$("#btnStop").show();
    	$("#btnPause").prop("disabled",false);
    	$("#btnBackward").prop("disabled",true);
    	$("#btnForward").prop("disabled",true);
    	simulatingBackwards=false;
		resetSimulation();
    	simulateCode(true);
    });
    
    $("#btnStop").on("click touchstart",function(){
    	simulating=false;
    	$("#btnPlay").show();
    	$("#btnStop").hide();
    	simulateCode(false);
    	resetSimulation();
    });
    
    $("#btnPause").on("click touchstart",function(){
    	simulating=false;
    	$("#btnPause").hide();
    	$("#btnContinue").show();
    	clearInterval(timerLoop);
    	handleContinuationButtons();
    });
    
    $("#btnContinue").on("click touchstart",function(){
    	simulating=true;
    	$("#btnContinue").hide();
    	$("#btnPause").show();
    	simulatingBackwards=false;
    	simulateCode(true);
    });
                
    $("#btnForward").on("click touchstart",function(){
    	if(simulationIndex<endIfIndex+1){
    		simulatingBackwards=false;
    		simulateRun();
    	}
    	/*else{
    		resetSimulation();
    	}*/
    });
    
    $("#btnBackward").on("click touchstart",function(){
    	if(simulationIndex>-1){
			var trueStatementIndex=endIfIndex+2;
			if(simulationIndex<=ifIndex || simulationIndex>endIfIndex){
				simulationIndex-=2;
			}
			else{
				if($(".conditionTrue").first().attr("id")){
					var partID=parseInt($(".conditionTrue").first().attr("id").substr(7,1));
					partIndex=0;
					while(statements[partIndex].htmlID!="part"+partID){
						partIndex++;
					}
					trueStatementIndex=ifIndex+2*partIndex;
				}
				if(simulationIndex<=trueStatementIndex){
					simulationIndex+=-3;
				}
				else{
					if(simulationIndex==trueStatementIndex+1){
						simulationIndex+=-2;
					}
					else if(simulationIndex==endIfIndex){
						simulationIndex=trueStatementIndex;
					}
					else{
						simulationIndex=trueStatementIndex-1;
					}
				}
			}
    		simulatingBackwards=true;
    		clearSimulated();
    		simulateRun();
    	}
    });
    
    $("#btnCheckCode").on("click touchstart",function(){
    	checkCode();
    	handleContinuationButtons();
    });

    $("#btnShowSolution").on("click touchstart",function(){
    	showSolution();
    });

    $("#btnInitialiseCode").on("click touchstart",function(){
    	promptID=promptToShowRestOfSolution;
    	showPrompt();
    	resetStatements();
    	simulating=false;
    	simulatingBackwards=false;
    	resetSimulation();
    	handleContinuationButtons();
    });

    $("#btnEnter").on("click touchstart",function(){
		if(simulating)timerLoop=setInterval(function(){simulateRun();},simSpeed);
    });   
    
    $(".problemCases").on("click touchstart",function(){
    	if(parseInt(this.id.substr(4,1))%2==1){
    		$(this).addClass("caseSelectedOdd");
    	}
    	else{
    		$(this).addClass("caseSelectedEven");
    	}
    	var i=parseInt(this.id.substr(4,1));
    	statements[i].move($("#case"+i).position().left,$("#case"+i).position().top);
    	$("#part"+i).show();
    	statements[i].move(codeLeftBorder,i*slotHeight+statementsTopBorder);
    	adjustCode();
    	
    	visibleCases=visibleCases | Math.pow(2,i);
    	advancePrompt();
    });
    
    $("#number-A").on('touchstart',function(){
    	$("#number-A").focus();
    });

    $("#number-B").on('touchstart',function(){
    	$("#number-B").focus();
    });

    $("#number-C").on('touchstart',function(){
    	$("#number-C").focus();
    });
    
    $("#number-A").bind('keyup mouseup',function(){
    	var newValue=parseInt($("#number-A").val());
    	if(newValue>=parseInt($("#number-A").attr("min")) && newValue<=parseInt($("#number-A").attr("max"))){
    		varValues[0]=newValue;
    		checkTriangle();
    	}
    	else{
    		$("#number-A").val(varValues[0]);
    	}
    	resetSimulation();
    	handleContinuationButtons();
    });

    $("#number-B").bind('keyup mouseup',function(){
    	var newValue=parseInt($("#number-B").val());
    	if(newValue>=parseInt($("#number-B").attr("min")) && newValue<=parseInt($("#number-B").attr("max"))){
    		varValues[1]=newValue;
    		checkTriangle();
    	}
    	else{
    		$("#number-B").val(varValues[1]);
    	}
    	resetSimulation();
    	handleContinuationButtons();
    });
    
    $("#number-C").bind('keyup mouseup',function(){
    	var newValue=parseInt($("#number-C").val());
    	if(newValue>=parseInt($("#number-C").attr("min")) && newValue<=parseInt($("#number-C").attr("max"))){
    		varValues[2]=newValue;
    		checkTriangle();
    	}
    	else{
    		$("#number-C").val(varValues[2]);
    	}
    	resetSimulation();
    	handleContinuationButtons();
    });
    
    /*$("#btnHint").on("click touchstart",function(){
		$("#number-A").val(hintValue[selectedSolution][0]);
		$("#number-B").val(hintValue[selectedSolution][1]);
    });*/
}

function handleMouseDown(evt){
	if(visibleCases==Math.pow(2,noOfCases)-1 && !simulating && divHoveringIndex>-1){
		divSrcIndex=parseInt(divHoveringIndex);
		xOffset=statements[divSrcIndex].left-mX;
		yOffset=statements[divSrcIndex].top-mY;
		statements[divSrcIndex].grab();
	}
}

function handleMouseUp(evt){
	if(divSrcIndex>-1){
		statements[divSrcIndex].release();
		if(divDestinationIndex==-1 || divSrcIndex==divDestinationIndex){//επιστροφή στην αρχική θέση
			statements[divSrcIndex].setCol(0);
			statements[divSrcIndex].setRow(parseInt($("#"+statements[divSrcIndex].htmlID).attr("data-index")));
		}
		else{
			statements[divSrcIndex].setCol(0);
			statements[divSrcIndex].setRow(parseInt(divDestinationIndex));
			var statementOnTheMove=statements[divSrcIndex];
			var newRow;
			if(divSrcIndex>divDestinationIndex){
				for(var i=divSrcIndex-1;i>=divDestinationIndex;i--){
					newRow=statements[i].row+1;
					statements[i].setRow(newRow);
					$("#"+statements[i].htmlID).attr("data-index",newRow);
					statements[i+1]=statements[i];
				}
			}
			else if(divSrcIndex<divDestinationIndex){
				for(var i=divSrcIndex+1;i<=divDestinationIndex;i++){
					newRow=statements[i].row-1;
					statements[i].setRow(newRow);
					$("#"+statements[i].htmlID).attr("data-index",newRow);
					statements[i-1]=statements[i];
				}
			}
			$("#"+statementOnTheMove.htmlID).attr("data-index",divDestinationIndex);
			statements[divDestinationIndex]=statementOnTheMove;
			solutionType=userSolution;
			resetSimulation();
			handleContinuationButtons();
			promptID=promptEmpty;
			showPrompt();
		}
		divHoveringIndex=-1;
		divSrcIndex=-1;
		divDestinationIndex=-1;
		zIndexRestore();
		adjustCode();
	}
}

function zIndexRestore(){
    for(var i=0;i<statements.length;i++){
        $("#"+statements[i].htmlID).zIndex(i+1);
    }
    $("#algorithmEnd").zIndex(i+1);
}

function handleMouseMove(evt){
	var i=0;
	var offset=$("#solutionArea").offset();
    mX=evt.pageX;//-offset.left;
    mY=evt.pageY;//-offset.top;
	if(divSrcIndex>-1){//μετατόπιση επιλεγμένου DIV
 		updateMovingDIV(statements[divSrcIndex]);
 		divDestinationIndex=-1;
 		i=0;
 	 	while(i<statements.length && divDestinationIndex==-1){
 	 		if (statements[i].mouseHover(mX,mY) && i!=divSrcIndex){
 	 			divDestinationIndex=i;
 	 		}
 	 		else{
 	 			i++;
 	 		}
 	 	}
 	}
 	else {//έλεγχος θέσης ποντικιού ως προς τα DIVs (hovering)
 		divHoveringIndex=-1;
 		for(i=0;i<statements.length;i++){
			$("#case"+statements[i].htmlID.substr(4,1)).css({"background-color": "transparent"});
 		}
 		i=0;
 	 	while(i<statements.length && divHoveringIndex==-1){
 	 		if (statements[i].mouseHover(mX,mY)){
 	 			xOffset=statements[i].left-mX;
 	 			yOffset=statements[i].top-mY;
 	 			divHoveringIndex=i;
 				if(visibleCases==Math.pow(2,noOfCases)-1){
 					$("#case"+statements[divHoveringIndex].htmlID.substr(4,1)).css({"background-color": "PaleGoldenRod"});
 				}
 	 		}
 	 		else{
 	 			i++;
 	 		}
 	 	}
 	}
	if(debugMode) document.getElementById("debug").innerHTML="mX="+mX+" mY="+mY+" HoverIndex="+divHoveringIndex+" SourceIndex="+divSrcIndex+" DestinationIndex="+divDestinationIndex;
}

function handleMouseOut(){
	divHoveringIndex=-1;
}

function updateMovingDIV(statementOnTheMove){
	statementOnTheMove.move(mX+xOffset,mY+yOffset);
}

function defineConditionalsArray(){
	var page=0,col=0,row=0;
	$.each($(".movableDIV"),function(){
		var height=parseInt($(this).outerHeight());
		slotHeight=Math.max(slotHeight,height);
	});
	var i=0;
	$("#algorithmStart").css({left: codeLeftBorder, top: codeTopBorder});
	$("#promptArea").css({top: promptTopBorder});
	
	statementsTopBorder=parseInt($("#algorithmStart").outerHeight()+$("#algorithmStart").position().top);
	$.each($(".movableDIV"),function(){
		var htmlID=$(this).attr("id");
		var width=$(this).width();
		var left=$(this).position().left+codeLeftBorder;
		var top=i*slotHeight+statementsTopBorder;
		var newStatement=new statement(htmlID,codeLeftBorder,statementsTopBorder,left,top,row,col,width,slotHeight,page);
		statements.push(newStatement);
		row++;
		i++;
	});
	$("#algorithmEnd").css({left: codeLeftBorder, top: statementsTopBorder+noOfCases*slotHeight});
}

function adjustCode(){
	var majorIndex=0;
	var firstStatementVisible=false;
	var html="";
	var condition="";
	var msg="";
	var dataIndex=0;
	var startingClause="";
    html+="<code class='algorithm'><span id='algoStart'><span class='reservedWord'>ΑΛΓΟΡΙΘΜΟΣ</span> Τρίγωνα</span>";
    html+='\n  <span id="eisodos1"><span class="reservedWord">ΓΡΑΨΕ</span> "Δώσε τα μήκη των πλευρών:"</span>';
    html+="\n  <span id='eisodos2'><span class='reservedWord'>ΔΙΑΒΑΣΕ</span> α,β,γ</span></code>";
    $("#algorithmStart").html(html);
    for(var i=0;i<statements.length;i++){
		html="";
		startingClause="<span class='reservedWord'>ΑΝ</span>";
		dataIndex=parseInt($("#"+statements[i].htmlID).attr("data-index"));
		if(firstStatementVisible && dataIndex!=0){
			startingClause="<span class='reservedWord'>ΑΛΛΙΩΣ_ΑΝ</span>";
		}
		majorIndex=statements[i].htmlID.substr(4,1);
		switch(statements[i].htmlID){
		case "part0":
			condition="α <> β <span class='reservedWord'>ΚΑΙ</span> α <> γ <span class='reservedWord'>ΚΑΙ</span> β <> γ";
			msg='"Σκαληνό."';
			break;	
		case "part1":
			condition="α = β <span class='reservedWord'>Ή</span> α = γ <span class='reservedWord'>Ή</span> β = γ";
			msg='"Ισοσκελές."';
			break;
		case "part2":
			condition="α = β <span class='reservedWord'>ΚΑΙ</span> α = γ";
			msg='"Ισόπλευρο."';
			break;
		}
	    html+="<code class='statementCode'><span id='command"+majorIndex+"0'>";
	    //βρες αν υπάρχει statement τοποθετημένο χαμηλότερσ 
	    var lastPlaced=true;
	    for(var ii=i+1;ii<noOfCases;ii++){
	    	if($("#"+statements[ii].htmlID).is(":visible"))lastPlaced=false;
	    }
		if(firstStatementVisible && suppressFinalCondition && lastPlaced){
			html+="  <span class='reservedWord'>ΑΛΛΙΩΣ</span></span>";
		}
		else{
		    html+="  "+startingClause + " "+condition+" <span class='reservedWord'>ΤΟΤΕ</span></span>";
		}
	    if(debugMode)html+="   <b>("+statements[i].htmlID+") dataIndex="+dataIndex+"</b>";
	    html+="\n    <span id='command"+majorIndex+"1'><span class='reservedWord'>ΓΡΑΨΕ</span> "+msg+"</span>";
	    html+="</code>";
	    document.getElementById(statements[i].htmlID).innerHTML=html;

		if($("#"+statements[i].htmlID).is(":visible")){
			firstStatementVisible=true;
		}
    }
    html="<code class='algorithm'>  <span id='endIf'><span class='reservedWord'>ΤΕΛΟΣ_ΑΝ</span></span>";
    html+="\n<span id='algoEnd'><span class='reservedWord'>ΤΕΛΟΣ</span> Τρίγωνα</span>";
    $("#algorithmEnd").html(html);
}

function showProblem(){
	$("#problemWording").css({left: 0, top: codeTopBorder});
	$("#problemWording").html(getProblemWording());
}

function getProblemWording(){
	var html="<p>";
	html+="Με βάση τα μήκη των πλευρών του ένα τρίγωνο εντάσσεται σε μία από τις ακόλουθες κατηγορίες:</p>";	
	html+="<p><span class='problemCases' id='case0'><i>Σκαληνό</i> όταν κάθε πλευρά του έχει μήκος διαφορετικό από τις άλλες δύο.</span>";
	html+="<span class='problemCases' id='case1'> <i>Ισοσκελές</i> όταν μόνο δύο πλευρές έχουν το ίδιο μήκος.</span>";
	html+="<span class='problemCases' id='case2'> <i>Ισόπλευρο</i> όταν όλες οι πλευρές του έχουν το ίδιο μήκος.</span></p>";
	html+="<p>Να δημιουργήσετε αλγόριθμο ο οποίος θα διαβάζει τα μήκη των πλευρών ενός τριγώνου και θα εμφανίζει την κατηγορία στην οποία ανήκει με βάση τα κριτήρια αυτά.</p>";
	html+="<p></p>";
	return html;
}

function showButtonCaptions(){
	if(buttonCaptionsVisible){
        $("#btnCheckCode").html("Υποβολή");
        $("#btnShowSolution").html("Λύση");
        $("#btnInitialiseCode").html("Επαναφορά");
        $("#btnPlay").html("Έναρξη");
        $("#btnStop").html("Τερματισμός");
        $("#btnPause").html("Παύση");
        $("#btnContinue").html("Συνέχεια");
        $("#btnBackward").html("Πίσω");                 
        $("#btnForward").html("Μπροστά");
        /*$("#btnHint").html("Υπόδειξη");*/
 	}
	else{
        $("#btnCheckCode").html("");
        $("#btnShowSolution").html("");
        $("#btnInitialiseCode").html("");
        $("#btnPlay").html("");
        $("#btnStop").html("");
        $("#btnPause").html("");
        $("#btnContinue").html("");
        $("#btnBackward").html("");                 
        $("#btnForward").html("");
        /*$("#btnHint").html("");*/
	}
}

function advancePrompt(){
	switch(promptID){
	case promptToShowCases:
    	if(visibleCases==Math.pow(2,noOfCases)-1){
    		promptID=promptToShowRestOfSolution;
    		$("#algorithmStart").show(animationRate);
    		$("#algorithmEnd").show(animationRate);
    	}
    	else{
    		additionalPrompt=true;
    	}
		showPrompt();
		break;
	case promptToShowRestOfSolution:
		break;
	case promptToSortCases:
		break;
	}
}

function showPrompt(){
	var msg="";
	switch(promptID){
	case promptToShowCases:
		msg="Καλούμαστε να λύσουμε το παραπάνω πρόβλημα, το οποίο έχει "+noOfCases+" περιπτώσεις.<br>Προσπάθησε να εντοπίσεις κάθε μία, κάνοντας click με το ποντίκι σου στην κατάλληλη πρόταση της εκφώνησης.";
		if(additionalPrompt){
			msg+="<br>Βλέπεις αμέσως τον αντίστοιχο κώδικα να συμπληρώνεται.";
		}
		break;
	case promptToShowRestOfSolution:
		msg="Στην πλήρη πλέον δομή της Πολλαπλής Επιλογής προστέθηκαν αυτόματα και οι υπολοιπες εντολές του αλγόριθμου, ώστε αυτός να είναι πλήρης.<br>";
		msg+="Είναι όμως ορθός; Μπορείς να χρησιμοποιήσεις τα χειριστήρια για να ελέγξεις την άποψή σου.<br>";
		msg+="Αν θεωρείς ότι χρειάζεται, μπορείς να αναδιατάξεις τα τμήματα της δομής χρησιμοποιώντας το ποντίκι σου.<br>";
		msg+="Φυσικά μπορείς πάντα να ζητήσεις την αποκάλυψη της λύσης.<br>Μάλλον όμως είναι πιο ενδιαφέρον να δοκιμάσεις τις δυνάμεις σου.";
		$("#solutionControls").show(animationRate);
		break;
	case promptToSortCases:
		if(errorsFound){
			msg="Η εκδοχή που προτείνεις δεν είναι σωστή.<br>";
			msg+="Δοκίμασε να αναδιατάξεις με το ποντίκι σου τις περιπτώσεις της πολλαπλής επιλογής για να εντοπίσεις μια σωστή λύση του προβλήματος.<br>";
			msg+="Ίσως σε βοηθήσει να κατανοήσεις τι πρόβλημα έχει ο κώδικας, αν παρακολουθήσεις την εκτέλεσή του με τα αντίστοιχα χειριστήρια,<br>φροντίζοντας να δώσεις <i>όλους</i> τους κατάλληλους συνδυασμούς των τιμών εισόδου.";
		}
		else{
			if(optimalFound){
				if(solutionType==userSolution){
					msg="Πράγματι βρήκες μία λύση (και μάλιστα με το ελάχιστο δυνατό πλήθος συνθηκών) αλλά δεν είναι η μοναδική.<br>Μπορείς να εντοπίσεις εναλλακτικές; Θα χρειαστεί να αναδιατάξεις τα τμήματα της Δομής Επιλογής.";
				}
				else{
					msg="Αυτή που βλέπεις είναι μια λύση (και μάλιστα με το ελάχιστο δυνατό πλήθος συνθηκών) αλλά δεν είναι η μοναδική.<br>Μπορείς να εντοπίσεις εναλλακτικές; ";	
				}
			}
			else{
				if(solutionType==userSolution){
					msg="Πράγματι βρήκες μία λύση του προβλήματος.<br>Υπάρχουν όμως και παραλλαγές που ελέγχουν λιγότερες συνθήκες.<br>Για να τις εντοπίσεις δοκίμασε να αναδιατάξεις τα μέρη της πολλαπλής επιλογής.";
				}
				else{
					msg="Αυτή που βλέπεις είναι μία λύση του προβλήματος.<br>Υπάρχουν όμως και παραλλαγές που ελέγχουν λιγότερες συνθήκες.<br>Μπορείς να τις εντοπίσεις;";
				}
			}
		}
		break;
	}
    $("#prompt").html(msg);
}

function resetStatements(){
	var i,j,temp;
	//ταξινόμηση
	for(i=1;i<statements.length;i++){
		for(j=statements.length-1;j>=1;j--){
			if(statements[j].htmlID<statements[j-1].htmlID){
				temp=statements[j];
				statements[j]=statements[j-1];
				statements[j-1]=temp;
				$("#"+statements[j].htmlID).attr("data-index",j);
				$("#"+statements[j-1].htmlID).attr("data-index",j-1);
				statements[j].row=j;
				statements[j-1].row=j-1;
			}
		}
	}
	//εμφάνιση
	for(i=0;i<statements.length;i++){
		statements[i].move(codeLeftBorder,i*slotHeight+statementsTopBorder);
	}
	adjustCode();
}

function showSolution(){
	if(confirm("Θέλεις σίγουρα να αποκαλύψεις τη λύση;")){
		var i,j,temp;
		var solutionToShow;
		resetSimulation();
		handleContinuationButtons();
		do{
			solutionToShow=parseInt(Math.random()*solutions.length);
		}while(selectedSolution==solutionToShow);
		selectedSolution=solutionToShow;
		for(j=0;j<noOfCases-1;j++){
			i=0;
			while(statements[i].htmlID!=solutions[selectedSolution][j]){
				i++;
			}
			temp=statements[j];
			statements[j]=statements[i];
			statements[i]=temp;
			$("#"+statements[j].htmlID).attr("data-index",j);
			$("#"+statements[i].htmlID).attr("data-index",i);
			statements[j].row=j;
			statements[i].row=i;
		}
		for(i=0;i<statements.length;i++){
			statements[i].move(codeLeftBorder,i*slotHeight+statementsTopBorder);
		}
		solutionType=officialSolution;
		errorsFound=false;
		adjustCode();
		optimalFound=selectedSolution<optimalLimit;
		promptID=promptToSortCases;
		showPrompt();
	}
	zIndexRestore();
}

function checkCode(){
	var solutionOK;
	var j=-1;
	do{
		j++;
		solutionOK=true;
		for(var i=0;i<noOfCases;i++){
			solutionOK=solutionOK && statements[i].htmlID==solutions[j][i];
		}
	}while(j<solutions.length-1 && !solutionOK);
	if(solutionOK){
		errorsFound=false;
		if(debugMode)alert("Πολύ σωστά!");
		optimalFound=j<optimalLimit;
	}
	else{
		errorsFound=true;
		if(debugMode)alert("Υπάρχουν λάθη...");
	}
	promptID=promptToSortCases;
	showPrompt();
	$("#simulateControls").show(animationRate);
	$("#dataInput").show(animationRate);
}

function simulateCode(simulationSwitch){
	if (simulationSwitch){
		//έναρξη προσομοίωση με κλήση timer
		timerLoop=setInterval(function(){simulateRun();},simSpeed);
	}
	else{
		clearInterval(timerLoop);
		simulatingBackwards=false;
		simulating=false;
    	$("#btnStop").hide();
    	$("#btnPlay").show();
    	$("#btnContinue").hide();
    	$("#btnPause").prop("disabled",true);
    	$("#btnPause").show();
    	handleContinuationButtons();
	}	
}

function simulateRun(){
	var statementIndex;
	simulationIndex++;
	handleContinuationButtons();
	//ΑΛΓΟΡΙΘΜΟΣ
	if(simulationIndex==0 || simulatingBackwards && simulationIndex>=0){
		$("#algoStart").addClass("simulatingCode");
	}
	else if(hideSimulationPath){
		$("#algoStart").removeClass("simulatingCode");
	}
	//ΕΙΣΟΔΟΣ-ΓΡΑΨΕ
	if(simulationIndex==1 || simulatingBackwards && simulationIndex>=1){
		$("#eisodos1").addClass("simulatingCode");
	}
	else if(hideSimulationPath){
		$("#eisodos1").removeClass("simulatingCode");
	}
	//ΕΙΣΟΔΟΣ-ΔΙΑΒΑΣΕ
	if(simulationIndex==2 || simulatingBackwards && simulationIndex>=2){
		$("#eisodos2").addClass("simulatingCode");
	}
	else if(hideSimulationPath){
		$("#eisodos2").removeClass("simulatingCode");
	}
	if(simulationIndex>=ifIndex && simulationIndex<=endIfIndex-1 || simulatingBackwards && simulationIndex>=ifIndex){

		var jj;
		var jjEnd=simulationIndex;
		for(jj=ifIndex;jj<=jjEnd;jj++){
			statementIndex=Math.round(jj/2)-2;
			
			var htmlID=parseInt(statements[statementIndex].htmlID.substr(4,1));
			var command="#command"+htmlID;

			
			if(jj % 2 == 1){//Προσομοίωση συνθήκης
			    $(command+"0").addClass("simulatingCode");
				if(stripSimulateStatement(htmlID)){
					$(command+"0").addClass("conditionTrue");
				}
				else{
					$(command+"0").addClass("conditionFalse");
					jj++;
				}
				if(!simulatingBackwards){
					simulationIndex=jj;
				}
			}
			else{//Προσομοίωση εντολής
				$(command+"1").addClass("simulatingCode");
				jj=simulationIndex;
				if(!simulatingBackwards)simulationIndex=endIfIndex-1;//Σε περίπτωση ΑΛΗΘΟΥΣ συνθήκης προσπέρασε τις επόμενες εντολές μέχρι το ΤΕΛΟΣ_ΑΝ
			}
			
		}
	}
	//ΤΕΛΟΣ_ΑΝ
	if(simulationIndex==endIfIndex || simulatingBackwards && simulationIndex>=endIfIndex){
		$("#endIf").addClass("simulatingCode");
	}
	else if(hideSimulationPath){
		$("#endIf").removeClass("simulatingCode");
	}
	if(simulationIndex==endIfIndex+1 || simulatingBackwards && simulationIndex>=endIfIndex+1){
		$("#algoEnd").addClass("simulatingCode");
	}
	else if(hideSimulationPath){
		$("#algoEnd").removeClass("simulatingCode");
	}
	if(simulationIndex==endIfIndex+2 || simulatingBackwards && simulationIndex>=endIfIndex+2){//Μετά την προσομοίωση του ΤΕΛΟΣ, τερμάτισε το μηχανισμό προσομοίωσης
		simulateCode(false);	
	}
}

function handleContinuationButtons(){
	if(simulationIndex>endIfIndex){
		$("#btnForward").prop("disabled",true);
	}
	else{
		$("#btnForward").prop("disabled",false);
	}
	if(simulationIndex<0){
		$("#btnBackward").prop("disabled",true);
	}
	else{
		$("#btnBackward").prop("disabled",false);
	}
}

function stripSimulateStatement(statementIndex){
	var logicalResult=false;
	var command=document.getElementById("command"+statementIndex+"0").textContent;
	var ifIndex=command.indexOf("ΑΝ");
	var subCommand=command.substr(ifIndex+3,command.length-ifIndex-2);
	var condition=subCommand.substr(0,subCommand.indexOf("ΤΟΤΕ"));
	if(condition==""){//τμήμα ΑΛΛΙΩΣ
		logicalResult=true;
	}
	else{
		logicalResult=stringLogicalValue(condition,varNames,varValues);
	}
	return logicalResult;
}

function clearSimulated(){
	$(".simulatingCode").removeClass("simulatingCode");
	$(".conditionTrue").removeClass("conditionTrue");
	$(".conditionFalse").removeClass("conditionFalse");
}

function resetSimulation(){
	clearSimulated();
	simulationIndex=-1;
}

function checkTriangle(){
	var t=(varValues[0]+varValues[1]+varValues[2])/2;
	var subRoot=(t-varValues[0])*(t-varValues[1])*(t-varValues[2]);
	if(subRoot<=0){
		$("#prompt").html("Οι πλευρές δε σχηματίζουν τρίγωνο!");
	}
	else{
		showPrompt();
	}
}