/**
 * 
 */
var mX=0,mY=0;

var outputMsgs=[];
var canvas;
var cntx;

var tapping=false;

function initialise(){
	simulating=false;
	
	showAppTitle();
	showButtonCaptions();
	showProblem();
	adjustCode();
	placeContents();
	$("#drawArea").hide();
	showSimulationValues(); //καλείται για να αποκρύψει όλα τα span elements
	initialiseGraphics();
	initialiseEvents();
	showPrompt();
	setParameterValue(0,100);
	$(".varLabel").css("text-align","center");
}

function initialiseEvents(){
    
    $("#popupMoreHints").focusout(function(){
        preventMoreHints();
    });
    
    $(".toChange").focus(function(){
        if(simulating){
            $("#"+this.id).blur();
        }
    });
    
    //Χρωματική αντιστοιχία ελεύθερου κειμένου και ψευδογλώσσας
    $(".algoStep").hover(
        function(){
            if(enableRepresentationMatching){
                var index=parseInt(this.id.substr(4,1));
                $("#"+this.id).addClass("matched");
                showMatches(index);
            }
        },
        function(){
            $(".matched").removeClass("matched");
        }
    );
    
    
    $(".algoStep").on("tap",function(){
        $(".matched").removeClass("matched");
        if(enableRepresentationMatching){
            var index=parseInt(this.id.substr(4,1));
            $("#"+this.id).addClass("matched");
            showMatches(index);
        }        
    });
    
    document.addEventListener("touchend",function(evt){
        if(tapping){
            tapping=false;
            $(".matched").removeClass("matched");
            evt.preventDefault();
            return;
        }
    });
    
	$("#clearBreakPoints").on("click touchend",function(){
	    $(".breakPointCmd").removeClass("breakPointCmd");
	});
	
	$("#visualisation").on("mousemove touchend",function(evt){
		var rect = canvas.getBoundingClientRect();
		mX=evt.clientX-rect.left;
	    mY=evt.clientY-rect.top;
		handleMouseMove();
	});
	
	$(".algoCmd").on("click touchend",function(evt){
	    if(evt.target.id.substr(0,7)=="usrEntr") return;
		if($("#"+this.id).hasClass("breakPointCmd")){
			$("#"+this.id).removeClass("breakPointCmd");
		}
		else{
			$("#"+this.id).addClass("breakPointCmd");
		}
	});

	//touch events
	$("#showInfo").on("touchend",function(evt){
	    $("#showInfo").trigger("click");
	});
	
	//Κουμπιά διαχείρισης ορατού τμήματος πίνακα
	$("#btnFirst").on("click touchstart",function(evt){
		evt.preventDefault();
		handleArray(-firstVisibleCell);
	});

	$("#btnPrevious").on("click touchstart",function(evt){
		evt.preventDefault();
		handleArray(-1);
	});

	$("#btnNext").on("click touchstart",function(evt){
		evt.preventDefault();
		handleArray(1);
	});

	$("#btnLast").on("click touchstart",function(evt){
		evt.preventDefault();
		handleArray(outputMsgs.length-1-firstVisibleCell);
	});

	//Κουμπιά διαχείρισης εφαρμογής
    $("#slideSpeed").bind("change keyup touchend",function(event,ui) {
        var maxSimSpeed=Number($(this).attr("max"))+1;
        simSpeed=maxSimSpeed-$(this).val();
    });
	
    $("#showCaptions").bind("change keyup touchend",function(event,ui) {
    	if($("#showCaptions:checked").val()=="show"){
    		buttonCaptionsVisible=true;
    	}
    	else{
    		buttonCaptionsVisible=false;
    	}
    	showButtonCaptions();
    });
    
    
    $("#showVarValues").bind("change keyup touchend",function(event,ui) {
    	if($("#showVarValues:checked").val()=="show"){
    		showVarValues=true;
    	}
    	else{
    		showVarValues=false;
    	}
    });
    
    $("#showComments").bind("change keyup touchend",function(event,ui) {
    	if($("#showComments:checked").val()=="show"){
    		$("#commentArea").slideDown("slow");
    		showComments=true;
    	}
    	else{
    		$("#commentArea").slideUp("slow");
    		showComments=false;
    	}
    });
	
    $("#requestConfirmations").bind("change keyup touchend",function(event,ui) {
    	if($("#requestConfirmations:checked").val()=="reqConfirm"){
    		requestConfirmationState=requestConfirmation;
    	}
    	else{
    		requestConfirmationState=dontRequestConfirmation;
    	}
    });
    
    $("#matchRepresentations").bind("change keyup touchend",function(event,ui) {
        if($("#matchRepresentations:checked").val()=="reqRepresentations"){
            enableRepresentationMatching=true;
        }
        else{
            enableRepresentationMatching=false;
        }
    });
    
    $("#showFullSimulationPath").bind("change keyup touchend",function(event,ui) {
    	if($("#showFullSimulationPath:checked").val()=="showFullSimPath"){
    		hideSimulationPath=false;
    	}
    	else{
    		hideSimulationPath=true;
    	}
    });

    $("#btnPlay").on("click touchstart",function(){
    	$("#showOptions").hide();
    	simulating=true;
    	$("#btnPlay").hide();
    	$("#btnStop").show();
    	$("#btnPause").prop("disabled",false);
    	$("#btnForward").prop("disabled",true);
		//resetSimulation(); //Η εντολή απενεργοποιείται για να είναι δυνατή η αυτόματη εκτέλεση από εκεί που σταμάτησε η βηματική
    	promptID=promptDuringRunning;
    	simulationAborted=false;
    	simulateCode(true);
    });
    
    $("#btnStop").on("click touchstart",function(){
        $("#drawArea").hide(animationRate);
    	simulating=false;
    	simulateCode(false);
    	resetSimulation();
    	$("#btnPlay").show();
    	$("#btnStop").hide();
    	$("#btnPause").show();
    	$("#btnContinue").hide();
    	$("#btnForward").show();
    	if(simulationAborted){
    	    promptID=promptToFillInBlanks;
    	}
    	else{
    	    promptID=promptToRunCode;
    	}
    	showPrompt();
    });
    
    $("#btnPause").on("click touchstart",function(){
    	$("#showOptions").show();
    	simulating=false;
    	$("#btnPause").hide();
    	$("#btnContinue").show();
    	clearInterval(timerLoop);
    	handleContinuationButtons();
    	showPrompt();
    });
    
    $("#btnContinue").on("click touchstart",function(){
    	$("#showOptions").hide();
    	simulating=true;
    	$("#btnContinue").hide();
    	$("#btnForward").prop("disabled",true);
    	$("#btnPause").show();
    	simulateCode(true);
    });
                
    $("#btnForward").on("click touchstart",function(){
        $("#drawArea").show(animationRate);
        simulationAborted=false;
    	if(simulationIndex==-1){
    		resetSimulation();
    	}
    	if(simulationIndex<=parseInt(lastOutput.substr(3,2))){
    		simulateRun();
    	}
    });
    
    $("#btnCheckCode").on("click touchstart",function(){
    	checkCode();
    	handleContinuationButtons();
    });

    $("#btnShowSolution").on("click touchstart",function(){
    	showSolution();
    });

    $("#btnShowHint").on("click touchstart",function(){
        showNextHint();
    });
    
    $("#btnInitialiseCode").on("click touchstart",function(){
    	if(requestConfirmationState || confirm("ΠΡΟΣΟΧΗ! Η εντολή αυτή θα επαναφέρει τις αρχικές καταχωρήσεις και θα διαγράψει όλα τα Σημεία Διακοπής. Είσαι σίγουρος;")){
        	$(".breakPointCmd").removeClass("breakPointCmd");
        	$(".hintedCommand").removeClass("hintedCommand");
            $("#drawArea").hide(animationRate);
        	additionalHintsShown=false;
            selectedHint=-1;
        	simulating=false;
            simulateCode(false);
        	resetSimulation();
        	handleContinuationButtons();
        	showUserEntries();
        	countEntries();
    	}
    });

    $("#btnEnter").on("click touchstart",function(){
		if(simulating)timerLoop=setInterval(function(){simulateRun();},simSpeed);
    });
    
    $("#number-A").on("touchstart",function(){
    	$("#number-A").focus();
    });

    $("#number-A").bind("keyup mouseup",function(){
    	var newValue=parseInt($("#number-A").val());
    	if(newValue>=parseInt($("#number-A").attr("min")) && newValue<=parseInt($("#number-A").attr("max"))){
    		setParameterValue(0,newValue);
    	}
    	else{
    		setParameterValue(0,varValues[0]);
    	}
    	abortSimulation();
    	resetSimulation();
    	handleContinuationButtons();
    });

    $(".cellNavigation").mouseover(function(){
    	if($(this).css("opacity")>0){
      	  $("#"+this.id).fadeTo(0,1);
    	  $("#"+this.id).css({
    		  "background-color" : "#c0c0c0",
    		  "box-shadow" : "1px 1px 2px #000000,2px 2px 4px #505050,3px 3px 6px #a0a0a0"
    	  });
    	}
    });
    
    $(".cellNavigation").mouseout(function(){
    	if($(this).css("opacity")>0){
        	$(this).fadeTo(0,0.5);
        	$(this).css({
        		"background-color" : "#ffffff",
        		"box-shadow" : "1px 1px #ffffff,2px 2px #ffffff,3px 3px #ffffff"
        	});
    	}
    });
}

function setParameterValue(paramIndex,newValue){
	$("#number-"+String.fromCharCode(65+paramIndex)).val(newValue);
	varValues[paramIndex]=newValue;
	if(paramIndex==0){
	    hSimInit=newValue;
	}
}

function handleMouseDown(){
}

function handleMouseUp(){
}

function handleMouseMove(){
	if(debugMode) document.getElementById("debug").innerHTML="mX="+mX+" mY="+mY+" promptID="+promptID+" , "+slctdNo;
}

function handleMouseOut(){
}

function placeContents(){
	codeTopBorder=$("#buttonArea").outerHeight();
	drawTopBorder=codeTopBorder+$("#problemWording").outerHeight()+verticalBorder;
	commentTopBorder=codeTopBorder+$("#algorithmStart").outerHeight()+1.5*verticalBorder;
	
	$("#problemWording").css({left: horizontalBorder, top: codeTopBorder});
    codeLeftBorder=$("#problemWording").outerWidth()+2*horizontalBorder;

	$("#algorithmStart").css({left: codeLeftBorder, top: codeTopBorder});
	$("#commentArea").css({left: codeLeftBorder, top: commentTopBorder, width: $("#algorithmStart").width(), height: 40});
	$("#drawArea").css({top: drawTopBorder});
	//"Πάνω" κουμπιά
	$("#btnFirst").css({left: $("#drawArea").position().left, top: 0});
    $("#btnPrevious").css({left: $("#drawArea").position().left, top: $("#btnFirst").outerHeight()});
    //"Κάτω" κουμπιά
    $("#btnLast").css({left: $("#drawArea").position().left, top: $("#visualisation").position().top+$("#visualisation").outerHeight()-$("#btnLast").outerHeight()});
    $("#btnNext").css({left: $("#drawArea").position().left, top: $("#btnLast").position().top-$("#btnNext").outerHeight()});
    //Επιφάνεια σχεδίασης
    $("#visualisation").css({left: $("#btnLast").position().left+$("#btnLast").outerWidth()+horizontalBorder, top: 0});
    $("#drawArea").height($("#visualisation").height+2*verticalBorder);
    //πΕριοχή ειδοποιήσεων
    promptTopBorder=drawTopBorder+$("#visualisation").outerHeight()+verticalBorder;
    $("#promptArea").css({top: promptTopBorder});
}

function adjustCode(){
	var j=-1;
	var html="<code class='algorithm'>";
    html+='\n<span class="algoCmd" id="cmd0"><span class="reservedWord">ΓΡΑΨΕ</span> "Δώσε tην αρχική οφειλή:"</span>';
    html+="\n<span class='algoCmd' id='cmd1'><span class='reservedWord'>ΔΙΑΒΑΣΕ</span> ο</span>   <span class='showValues' id='hInitVal'></span>";
    j++;
    html+="\n<span class='algoCmd' id='cmd2'>μ <- "+generateEntryPlaceholder("usrEntr"+j,userEntries[j],editableState)+"</span>   <span class='showValues' id='plInitVal'></span>";
    html+="\n<span class='algoCmd' id='cmd3'><span class='reservedWord'>ΑΡΧΗ_ΕΠΑΝΑΛΗΨΗΣ</span></span>";
    j++;
    html+="\n<span class='algoCmd' id='cmd4'>  μ <- "+generateEntryPlaceholder("usrEntr"+j,userEntries[j],editableState)+"</span>   <span class='showValues' id='plAdder'></span>";
    j++;
    html+="\n<span class='algoCmd' id='cmd5'>  o <- o * "+generateEntryPlaceholder("usrEntr"+j,userEntries[j],editableState)+"</span>   <span class='showValues' id='hFactor'></span>";
    j++;
    html+="\n<span class='algoCmd' id='cmd6'>  <span class='reservedWord'>ΓΡΑΨΕ</span> \"Οφειλή μετά την \",μ,\"η δόση:\", "+generateEntryPlaceholder("usrEntr"+j,userEntries[j],editableState)+" ,\"€\"</span>";
    j++;
    html+="\n<span class='algoCmd' id='cmd7'><span class='reservedWord'>ΜΕΧΡΙΣ_ΟΤΟΥ</span> "+generateEntryPlaceholder("usrEntr"+j,userEntries[j],editableState)+"</span>   <span class='showValues' id='repeatCondVal'></span>";
    j++;
    html+="\n<span class='algoCmd' id='cmd8'><span class='reservedWord'>ΓΡΑΨΕ</span> \"Πραγματοποιήθηκαν \" , "+generateEntryPlaceholder("usrEntr"+j,userEntries[j],editableState)+" , \" πληρωμές.\"</span>   <span class='showValues' id='plToPrint'></span>";
    html+="</code>";
	$("#algorithmStart").html(html);

	//Προσθήκη event παρακολούθησης εισόδου χρήστη σε κάθε editable τμήμα
    for(var i=0;i<noOfEntries;i++){
    	if(document.getElementById("usrEntr"+i)){
            document.getElementById("usrEntr"+i).addEventListener("input", function() {
        	    saveUserEntry(this.id);
        	}, false);
    	}
    }    	
}

function showProblem(){
	$("#problemWording").css({left: 0, top: codeTopBorder});
	$("#problemWording").html(getProblemWording());
}

function getProblemWording(){
    var html="Ένα κατάστημα διαφημίζει ένα πρωτότυπο σύστημα πληρωμής των προϊόντων που αγοράζουν οι πελάτες του. Κάθε μήνα τους ζητά να πληρώνουν το <b>"+percentageLoss+"%</b> του ποσού που απομένει ως την πλήρη εξόφληση της οφειλής. ";
    html+="Θέλουμε να υπολογίζουμε το ποσό που απομένει μετά από κάθε πληρωμή, καθώς και το πλήθος των πληρωμών που πραγματοποιήθηκαν μέχρι την πλήρη εξόφληση.";
    html+="<br>Τα βήματα του αλγόριθμου έχουν ως εξής:";
    html+="<p class='algoStep' id='step1'><b>1.</b> Διαβάζουμε το αρχικό ποσό οφειλής <span class='suggestedName'>o</span>.</p>";
    html+="<p class='algoStep' id='step2'><b>2.</b> Αρχικοποιούμε το πλήθος <span class='suggestedName'>μ</span> των δόσεων.</p>";
    html+="<p class='algoStep' id='step3'><b>3.</b> Δημιουργούμε μια δομή επανάληψης για τον υπολογισμό των ζητούμενων.</p>";
    html+="<p class='algoStep' id='step4'><b>4.</b> Αφού κάθε επανάληψη αντιστοιχεί σε μία πληρωμή, ενημερώνουμε το πλήθος των δόσεων.</p>";
    html+="<p class='algoStep' id='step5'><b>5.</b> Υπολογίζουμε τη νέα οφειλή (εφόσον αυτό ζητείται από την εκφώνηση) την εμφανίζουμε.</p>";
    html+="<p class='algoStep' id='step6'><b>6.</b> Καθώς το πλήθος των επαναλήψεων δεν είναι εκ των προτέρων γνωστό (είναι, αντίθετα, ένα από τα ζητούμενα του προβλήματος), κλείνουμε την επανάληψη με την κατάλληλη συνθήκη τερματισμού.</p>";
    html+="<p class='algoStep' id='step7'><b>7.</b> Εμφανίζουμε το πλήθος των δόσεων που χρειάστηκαν για την εξόφληση.</p>";
	html+="Προσπάθησε να συμπληρώσεις τις εντολές που υλοποιούν τον αλγόριθμο αυτό.";
	return html;
}

function showButtonCaptions(){
	if(buttonCaptionsVisible){
        $("#btnCheckCode").html("Υποβολή");
        $("#btnShowSolution").html("Λύση");
        $("#btnShowHint").html("Βοήθεια");
        $("#btnInitialiseCode").html("Επαναφορά");
        $("#btnPlay").html("Έναρξη");
        $("#btnStop").html("Αρχικοποίηση");
        $("#btnPause").html("Παύση");
        $("#btnContinue").html("Συνέχεια");
        $("#btnForward").html("Επόμενο");
        $("#btnOptions").html("Ρυθμίσεις");
        $(".btnMenu").css({"width":"175px"});
        $(".buttonData").width(160);
 	}
	else{
        $("#btnCheckCode").html("");
        $("#btnShowSolution").html("");
        $("#btnShowHint").html("");
        $("#btnInitialiseCode").html("");
        $("#btnPlay").html("");
        $("#btnStop").html("");
        $("#btnPause").html("");
        $("#btnContinue").html("");
        $("#btnForward").html("");
        $("#btnOptions").html("");
        $(".btnMenu").css({"width":"30px"});
        $(".buttonData").width(40);
    }
	placeContents();
}

function showPrompt(){
	var msg="";
	if(selectedHint==-1){//Δείξε βασικά prompts
	    switch(promptID){
	        case promptToFillInBlanks:
	            msg="Προσπάθησε να λύσεις το πρόβλημα, συμπληρώνοντας ορθά τα κενά των εντολών που βλέπεις.";
	            msg+="<br>Αν δυσκολεύεσαι, ίσως σε βοηθήσει η προβολή αντιστοιχίας μεταξύ του <i>Ελεύθερου Κειμένου</i> και της <i>Ψευδογλώσσας</i> μέσω των Ρυθμίσεων.";
	            msg+="<br>Μπορείς να ελέγξεις την άποψή σου με το κουμπί [Υποβολή], ή να ";
	            if($("#btnShowHint").is(":visible")){
	                msg+="πάρεις υποδείξεις για τη λύση με το κουμπί [Βοήθεια].";	                
	            }
	            else{
                    msg+="δεις την ορθή εκδοχή του προγράμματος με το κουμπί [Λύση]";                 
	            }
	            break;
	        case promptToRunCode:
	            msg="Αν θεωρείς τη λύση ολοκληρωμένη, 'τρέξε' το πρόγραμμά σου με το κουμπί [Έναρξη].";
	            msg+=" Επιλέγοντας μία εντολή, μπορείς να προσθέσεις Σημείο Διακοπής (Breakpoint).";
	            msg+="<br>Εναλλακτικά, δοκίμασε τη βηματική εκτέλεση με το κουμπί [Επόμενο].";
	            msg+="<br>Χρησιμοποίησε τις Ρυθμίσεις Προσομοίωσης για να προβάλλεις πρόσθετες πληροφορίες υπό μορφή επεξηγήσεων.";
	            break;
	        case promptDuringRunning:
	            if($("#btnContinue").is(":visible")){
	                msg="Χρησιμοποίησε το κουμπί [Επόμενο] για να εκτελεστεί η επόμενη εντολή.";
	                msg+="<br>Χρησιμοποίησε το κουμπί [Συνέχεια] για να επιστρέψεις στην αυτόματη εκτέλεση.";
	            }
	            else{
	                msg="Χρησιμοποίησε το κουμπί [Παύση] για να διακόψεις την αυτόματη εκτέλεση.";
	            }
	            msg+="<br>Χρησιμοποίησε το κουμπί [Αρχικοποίηση] για να τερματίσεις την αυτόματη εκτέλεση.";
	            break;
	        case promptAtEndOfRun:
	            msg="Χρησιμοποίησε το κουμπί [Αρχικοποίηση] για να διαγράψεις τα αποτελέσματα της εκτέλεσης του προγράμματος.";
	            break;
	        case promptSubmittedSolution:
	            if(errorsFound){
	                msg="Η εκδοχή που προτείνεις δεν είναι σωστή.";
	                msg+="<br>Μελέτησε προσεκτικότερα την εκφώνηση του προβλήματος, προσπαθώντας να βρεις τις αντιστοιχίες των φράσεων του <i>Ελεύθερου Κειμένου</i> με τις εντολές της <i>Ψευδογλώσσας</i>.";
	                msg+="<br>Μπορείς να κάνεις ορατές τις αντιστοιχείς αυτές μέσω των Ρυθμίσεων.";
	            }
	            else{
	                if(solutionType==userSolution){
	                    msg="Πράγματι βρήκες μία λύση του προβλήματος.";
	                }
	                else{
	                    msg="Αυτή που βλέπεις είναι μία λύση του προβλήματος.";
	                }
	                msg+=" Κανείς έμπορος δεν πρόκειται να διεκδικήσει οφειλή μικρότερη του 0.01€, αλλά ακόμη κι αν επιμέναμε να την πληρώσουμε, δε θα μπορούσαμε να δώσουμε το ακριβές ποσό, ούτε εκείνος θα μπορούσε να μας δώσει ρέστα.";
	                msg+="<br>'Τρέξε' τώρα το πρόγραμμά σου για να υπολογίσεις το πλήθος των δόσεων.";
	            }
	            break;
	    }	    
	}
	else{//Δείξε hint-prompts
        var selectedCommand=-1;
	    switch(selectedHint){
	        case 0:
	            selectedCommand=2;
	            msg="ΓΡΑΜΜΗ 3: Πριν την έναρξη της Δομής Επανάληψης δεν έχει εκτελεστεί ΚΑΜΙΑ πληρωμή.";
	            break;
            case 1:
                selectedCommand=4;
                msg="ΓΡΑΜΜΗ 5: Κάθε επανάληψη συνιστά μία <i>ακόμη</i> πληρωμή δόσης.";
                break;
            case 2:
                selectedCommand=5;
                msg="ΓΡΑΜΜΗ 6: Μετά από κάθε πληρωμή η οφειλή μειώνεται κατά "+percentageLoss+"%. Άρα η νέα οφειλή θα είναι ...";
                break;
            case 3:
                selectedCommand=6;
                msg="ΓΡΑΜΜΗ 7: Η οφειλή μετά την τρέχουσα πληρωμή έχει εκχωρηθεί στη μεταβλητή o.";
                break;
            case 4:
                selectedCommand=7;
                msg="ΓΡΑΜΜΗ 8: Όταν εξοφλείται το σύνολο του ποσού, η οφειλή μηδενίζεται.";
                break;
            case 5:
                selectedCommand=8;
                msg="ΓΡΑΜΜΗ 9: Το τελικό πλήθος πληρωμών έχει υπολογιστεί στη μεταβλητή μ.";
                break;
            case hintShown.length:
                msg="Φαίνεται ότι συμπληρώθηκαν όλα τα κενά των εντολών. Δοκίμασε να εκτελέσεις τον αλγόριθμό σου για να ελέγξεις την ορθότητά του.";
                selectedHint=-1;
                break;
	    }
	    $("#cmd"+selectedCommand).addClass("hintedCommand");
	}

    $("#prompt").html(msg);
}

function showNextHint(){
    var hintsCounter=0;
    if(selectedHint==-1){//Έχει ολοκληρωθεί η διαχείριση του προηγουμενου hint
        $(".hintedCommand").removeClass("hintedCommand");
        for(var i=0;i<hintShown.length;i++){//Καταμέτρηση ολοκληρωμένων hints
            var currentEntry=userEntries[i]===undefined?"":trimSpaces(userEntries[i]);
            if(i==4){
                hintShown[i]=currentEntry==trimSpaces(officialEntries[i]) || currentEntry==trimSpaces(correctCondition);
            }
            else{
                if(Array.isArray(officialEntries[i])){
                    var found=false;
                    var j=0;
                    while(j<officialEntries[i].length && !found){
                        found=currentEntry==trimSpaces(officialEntries[i][j]);
                        j++;
                    }
                    hintShown[i]=found;
                }
                else{
                    hintShown[i]=currentEntry==trimSpaces(officialEntries[i]);
                }
            }
            if(hintShown[i]){
                hintsCounter++;
            }
        }
        if(hintsCounter==hintShown.length){//Αν όλες οι καταχωρήσεις είναι ορθές...
            $("#btnShowHint").hide();
            $("#btnShowSolution").show();
            selectedHint=hintShown.length;
            showPrompt();//...εμφάνισε σχετικό μήνυμα
        }
        else{//αλλιώς έλεγξε αν έχει ήδη επιλεγεί επόμενο hint προς προβολή
            if(hintsCounter<hintShown.length-1){//Αν περισσεύουν hints εκτός της συνθήκης τερματισμού
                do{//... διάλεξε ένα στην τύχη
                    selectedHint=parseInt(Math.random()*hintShown.length);
                }while( hintShown[selectedHint] || selectedHint==correctConditionHintIndex );
            }
            else{
                selectedHint=correctConditionHintIndex;
            }
            showPrompt();//δείξε το επιλεγμένο hint
        }
    }
    else{//Δεν έχει ολοκληρωθεί η διαχείριση του προηγουμενου hint
        if(Array.isArray(officialEntries[selectedHint])){
            var variationIndex=parseInt(Math.random()*officialEntries[selectedHint].length);
            userEntries[selectedHint]=officialEntries[selectedHint][variationIndex];
        }
        else{
            userEntries[selectedHint]=officialEntries[selectedHint];
        }
        showUserEntries();
        selectedHint=-1;
    }
}

function showUserEntries(){
    var code;
    for(var i=0;i<noOfEntries;i++){
        code="ˍˍˍ";
        if(userEntries[i]!=null && userEntries[i]!=""){
            code=userEntries[i];
        }
        $("#usrEntr"+i).html(code);
    }
}

function showSolution(){
    var selectedPart="";
	if(requestConfirmationState || confirm("Θέλεις σίγουρα να αποκαλύψεις μία λύση;")){
		for(var i=0;i<noOfEntries;i++){
		    if(i==4){
		        selectedPart=correctCondition;
		    }
		    else{
	            if(Array.isArray(officialEntries[i])){
	                var j=parseInt(Math.random()*officialEntries[i].length);
	                selectedPart=officialEntries[i][j];
	            }
	            else{
	                selectedPart=officialEntries[i];
	            }
		    }
		    $("#usrEntr"+i).html(selectedPart);		    
		}
		solutionType=officialSolution;
		promptID=promptSubmittedSolution;
		showPrompt();
	}
}

function checkCode(){
	var solutionOK=true;
	var j=0;
	var submitted;
	var official;
	while(j<noOfEntries && solutionOK){
		submitted=trimSpaces(document.getElementById("usrEntr"+j).textContent.toLowerCase());
		if(Array.isArray(officialEntries[j])){
		    solutionOK=checkAgainstArray(submitted,j);
		}
		else{
		    official=trimSpaces(officialEntries[j].toLowerCase());
	        if(submitted!=official)solutionOK=false;
		}
		j++;
	}
	if(solutionOK){
		errorsFound=false;
		if(debugMode)alert("Πολύ σωστά!");
	}
	else{
		errorsFound=true;
		if(debugMode)alert("Υπάρχουν λάθη...");
	}
	promptID=promptSubmittedSolution;
	showPrompt();
	enableCodeSimulation();
}

function checkAgainstArray(submitted,j){
    var result=false;
    var official="";
    var i=0;
    while(!result && i<officialEntries[j].length){
        official=trimSpaces(officialEntries[j][i].toLowerCase());
        result=result || (submitted==official);
        i++;
    }
    return result;
}

function enableCodeSimulation(){
	$("#simulateControls").show(animationRate);
	$("#dataInput").show(animationRate);
}

function simulateCode(simulationSwitch){
	if(simulationSwitch){
	    $("#drawArea").show(animationRate);
	    mSimLimit=mSimLimitMin()+parseInt(Math.random()*10);
		//έναρξη προσομοίωσης με κλήση timer
		timerLoop=setInterval(function(){simulateRun();},simSpeed);
	}
	else{
		clearInterval(timerLoop);
		simulating=false;
		$("#btnContinue").hide();
		$("#btnForward").hide();
    	$("#btnPlay").hide();
    	$("#btnPause").prop("disabled",true);
    	$("#btnStop").show();
    	$("#showOptions").show();
	}	
}

function simulateRun(){
	var entryResult;
	var jStart=0;
	simulationIndex++;
	var nxtSimulationIndex=simulationIndex;
	var cmdSimulated="cmd"+simulationIndex;
	if(showComments) showCurrentComment(cmdSimulated);
	if($("#"+cmdSimulated).hasClass("breakPointCmd")){
		$("#btnPause").click();//Παύση σε breakpoint
	}
	handleContinuationButtons();
	
	$(".simulatingCode").removeClass("simulatingCode");
	if(hideSimulationPath){
		jStart=simulationIndex;
	}
	//εμφάνιση μονοπατιού προσομοίωσης
	for(var j=jStart;j<=simulationIndex;j++){
		$("#cmd"+j).addClass("simulatingCode");
	}
	
	//Προσομοίωση αλγόριθμου
	switch(cmdSimulated){
        case eisodos2:
            hSim=hSimInit;
            break;
	    case plInit:
	        entryResult=stringExpressionValue($("#usrEntr0").text(),varNames,varValues,[],[]);
	        if(entryResult=="error"){
	            abortSimulation();
	            return;
	        }
	        else{
	            mSim=entryResult;
	            varValues[1]=mSim;
	        }
	        break;
        case LoopBody1:
            entryResult=stringExpressionValue($("#usrEntr1").text(),varNames,varValues,[],[]);
            if(entryResult=="error"){
                abortSimulation();
                return;
            }
            else{
                mSim=entryResult;
                varValues[1]=mSim;
            }
            break;
	    case LoopBody2:
            entryResult=stringExpressionValue($("#usrEntr2").text(),varNames,varValues,[],[]);
            if(entryResult=="error"){
                abortSimulation();
                return;
            }
            else{
                hSim=hSim*entryResult;
                varValues[0]=hSim;

                //Υπολογισμός κατάλληλου πλήθους δεκαδικών ψηφίων
                var hSimStr=hSim.toFixed(noOfDecimalDigits);
                do{
                    var zeroCounter=0;
                    for(var indx=0;indx<hSimStr.length;indx++){
                        if(hSimStr.substr(indx,1)=="0")zeroCounter++;
                    }
                    if(zeroCounter>=hSimStr.length-2){
                        noOfDecimalDigits++;
                        hSimStr=hSim.toFixed(noOfDecimalDigits);
                    }
                }while(zeroCounter>=hSimStr.length-2);
            }
	        break;
        case LoopBody3:
            entryResult=stringExpressionValue($("#usrEntr3").text(),varNames,varValues,[],[]);
            if(entryResult=="error"){
                abortSimulation();
                return;
            }
            else{
                outputMsgs.push("Οφειλή μετά την "+mSim+"η δόση: "+entryResult.toFixed(noOfDecimalDigits)+"€");
                makeVisible(mSim,forceArrayDraw);
                //drawArray(firstVisibleCell);
            }
            break;
        case LoopEnd:
            entryResult=stringComparativeValue($("#usrEntr4").text(),varNames,varValues,false);
            if(entryResult=="error"){
                abortSimulation();
                return;
            }
            else{
                if(!entryResult){
                    nxtSimulationIndex=parseInt(LoopStart.substr(3,2));
                    var entryToCheck=trimSpaces(userEntries[4]); 
                    if((entryToCheck=="o=0" || entryToCheck=="o=h" ) && mSim>mSimLimit && !additionalHintsShown){//Εμφάνιση υπόδειξης για αποκατάσταση περατότητας
                        updateSimulationInfo();
                        $("#showMoreHints").trigger("click");
                    }
                }
                else{
                    nxtSimulationIndex=parseInt(LoopEnd.substr(3,2));
                    handleArray(0);
                }
            }
            break;
        case lastOutput:
            entryResult=stringExpressionValue($("#usrEntr5").text(),varNames,varValues,[],[]);
            if(entryResult=="error"){
                abortSimulation();
                return;
            }
            else{
                outputMsgs.push("Πραγματοποιήθηκαν "+entryResult+" πληρωμές.");
                makeVisible(mSim,forceArrayDraw);
                //drawArray(firstVisibleCell);
            }
            break;
	}
	showSimulationValues();
	if(simulationIndex>parseInt(lastOutput.substr(3,2))){//Μετά την προσομοίωση της τελευταίας εντολής τερμάτισε το μηχανισμό προσομοίωσης
		simulateCode(false);
		promptID=promptAtEndOfRun;
	}
	simulationIndex=nxtSimulationIndex;
	showPrompt();
}

function showCurrentComment(cmdSimulated){
	var comment="";
	switch(cmdSimulated){
	case eisodos1:
	    comment="Προτρεπτικό μήνυμα για εισαγωγή αρχικού ποσού οφειλής.";
	    break;
	case eisodos2:
		comment="Εισαγωγή αρχικής τιμής της μεταβλητής <span class='suggestedName'>o</span>.";
	    break;
	case plInit:
	    comment="Αρχικοποίηση της μεταβλητής <span class='suggestedName'>μ</span>.";
        break;
	case LoopStart:
		comment="Έναρξη της Δομής Επανάληψης.";
		break;
	case LoopBody1:
		comment="Καταμέτρηση της τρέχουσας πληρωμής.";
		break;
    case LoopBody2:
        comment="Υπολογισμός της νέας οφειλής με βάση το δεδομένο της εκφώνησης";
        break;
    case LoopBody3:
        comment="Εμφάνιση της νέας οφειλής.";
        break;
	case LoopEnd:
		comment="Έλεγχος τέλους επαναλήψεων.";
		break;
	case lastOutput:
		comment="Εμφάνιση του πλήθους πληρωμών που πραγματοποιήθηκαν.";
		break;
	}
	$("#commentArea").html(comment);
}

function makeVisible(cellIndex,forceDrawFlag){
	var arrayNotDrawn=true;
	while(cellTop(cellIndex,firstVisibleCell)>canvas.height-cellSize){
		firstVisibleCell++;
		drawArray(firstVisibleCell);
		arrayNotDrawn=false;
	}
	while(cellTop(cellIndex,firstVisibleCell)<0){
		firstVisibleCell--;
		drawArray(firstVisibleCell);
		arrayNotDrawn=false;
	}
	if(forceDrawFlag && arrayNotDrawn) drawArray(firstVisibleCell);
	handleNavigationButtons();
}

function handleContinuationButtons(){
	if(simulating)return;
	if(simulationIndex>parseInt(lastOutput.substr(3,2))){
		$("#btnForward").prop("disabled",true);
	}
	else{
		$("#btnForward").prop("disabled",false);
	}
}

function clearSimulated(){
	$(".simulatingCode").removeClass("simulatingCode");
	$(".conditionTrue").removeClass("conditionTrue");
	$(".conditionFalse").removeClass("conditionFalse");
	$(".conditionInError").removeClass("conditionInError");
}

function resetSimulation(){
	initialiseArray();
	resetErrorMessages();
	clearSimulated();
	simulationIndex=-1;
	handleContinuationButtons();
	showSimulationValues();
	$("#commentArea").html("");
}

function generateEntryPlaceholder(entryID,presetValue,editableState){
	var content="ˍˍˍ";
	var classToShow=(editableState)?"class='toChange'":"";
	if(presetValue!== undefined)content=presetValue;
	var newEntry="<span "+classToShow+" id='"+entryID+"' contenteditable='true'>"+content+"</span>";
	return newEntry;
}

function initialiseGraphics(){
    canvas=document.getElementById("visualisation");
    cntx=canvas.getContext("2d");
    //Πλάτος καμβά ίσο με το διαθέσιμο πλάτος προβολής
    //cntx.canvas.width=window.innerWidth;
    initialiseArray();
}

function initialiseArray(){
    outputMsgs=[];
	handleArray(0);
}

function drawArray(startingCell){
	cntx.clearRect(0,0,canvas.width,canvas.height);
	var i;
	for(i=0;i<outputMsgs.length;i++){
		drawCell(i,startingCell);
	}
}

function drawCell(i,startingCell){
	var topCoord=cellTop(i,startingCell);
	//Μη σχεδιάζεις κελιά εκτός ορατών ορίων
	if(topCoord<0 || topCoord>canvas.height) return;
	
    var content=outputMsgs[i]+"";
    cntx.font="15px Georgia";
    var contentLeft=horizontalBorder;
    cntx.fillText(content,contentLeft,topCoord+cellSize-(cellSize-20)/2);
}

function cellTop(i,startingCell){
	return (i-startingCell)*cellSize;
}

function handleArray(step){
	firstVisibleCell+=step;
	handleNavigationButtons();
	drawArray(firstVisibleCell);
}

function handleNavigationButtons(){
	if(outputMsgs.length==0){
        $("#btnFirst").fadeTo(0,0);
        $("#btnPrevious").fadeTo(0,0);
        $("#btnNext").fadeTo(0,0);
        $("#btnLast").fadeTo(0,0);
	}
	else if(firstVisibleCell<=0){
		$("#btnNext").fadeTo(0,0.5);
		$("#btnLast").fadeTo(0,0.5);
		$("#btnPrevious").fadeTo(0,0);
		$("#btnFirst").fadeTo(0,0);
    	$("#btnPrevious").css({
    		"background-color" : "#ffffff",
    		"box-shadow" : "1px 1px #ffffff,2px 2px #ffffff,3px 3px #ffffff"
    	});
    	$("#btnFirst").css({
    		"background-color" : "#ffffff",
    		"box-shadow" : "1px 1px #ffffff,2px 2px #ffffff,3px 3px #ffffff"
    	});
		firstVisibleCell=0;
	}
	else if(firstVisibleCell>=Math.max(outputMsgs.length-1,0)){
		$("#btnFirst").fadeTo(0,0.5);
		$("#btnPrevious").fadeTo(0,0.5);
		$("#btnNext").fadeTo(0,0);
    	$("#btnNext").css({
    		"background-color" : "#ffffff",
    		"box-shadow" : "1px 1px #ffffff,2px 2px #ffffff,3px 3px #ffffff"
    	});
		$("#btnLast").fadeTo(0,0);
    	$("#btnLast").css({
    		"background-color" : "#ffffff",
    		"box-shadow" : "1px 1px #ffffff,2px 2px #ffffff,3px 3px #ffffff"
    	});
		firstVisibleCell=Math.max(outputMsgs.length-1,0);
	}
	else{
		$("#btnFirst").fadeTo(0,0.5);
		$("#btnPrevious").fadeTo(0,0.5);
		$("#btnNext").fadeTo(0,0.5);
		$("#btnLast").fadeTo(0,0.5);
	}
}

function showSimulationValues(){
	if(!showVarValues) return;
	
	//τιμή του o
	if(simulationIndex==parseInt(eisodos2.substr(3,2))){
		$("#hInitVal").html(" o="+hSim.toFixed(noOfDecimalDigits)+" ");
		$("#hInitVal").show(animationRate);
	}
	else{
		$("#hInitVal").html("");
		$("#hInitVal").hide(animationRate);
	}
	
	//τιμή του μ
	if(simulationIndex==parseInt(plInit.substr(3,2))){
		$("#plInitVal").html(" μ="+mSim+" ");
		$("#plInitVal").show(animationRate);
	}
	else{
		$("#plInitVal").html("");
		$("#plInitVal").hide(animationRate);
	}
	
    //προσθετικός συντελεστής του μ
    if(simulationIndex>=parseInt(LoopBody1.substr(3,2)) && simulationIndex<=parseInt(LoopEnd.substr(3,2))){
        $("#plAdder").html(" μ="+mSim+" ");
        $("#plAdder").show(animationRate);
    }
    else{
        $("#plAdder").html("");
        $("#plAdder").hide(animationRate);
    }

	//πολλαπλασιαστικός συντελεστής του o
	if(simulationIndex>=parseInt(LoopBody2.substr(3,2)) && simulationIndex<=parseInt(LoopEnd.substr(3,2))){
		$("#hFactor").html(" o="+hSim.toFixed(noOfDecimalDigits)+" ");
		$("#hFactor").show(animationRate);
	}
	else{
		$("#hFactor").html("");
		$("#hFactor").hide(animationRate);
	}
	
	//Συνθήκη ΜΕΧΡΙΣ_ΟΤΟΥ
	if(simulationIndex==parseInt(LoopEnd.substr(3,2))){
		var result=stringComparativeValue($("#usrEntr4").html(),varNames,varValues,false)?"ΑΛΗΘΗΣ":"ΨΕΥΔΗΣ";
		$("#repeatCondVal").html(" "+result+" ");
		$("#repeatCondVal").show(animationRate);
	}
	else{
		$("#repeatCondVal").html("");
		$("#repeatCondVal").hide(animationRate);
	}

	//Εμφάνιση τιμής της μεταβλητής μ
    if(simulationIndex==parseInt(lastOutput.substr(3,2))){
        $("#plToPrint").html(" μ="+mSim+" ");
        $("#plToPrint").show(animationRate);
    }
    else{
        $("#plToPrint").html("");
        $("#plToPrint").hide(animationRate);
    }
}

function saveUserEntry(entryID){
    
	entryIndex=parseInt(entryID.substr("usrEntr".length,2));
	userEntries[entryIndex]=trimSpaces($("#"+entryID).html());
    solutionType=userSolution;
    countEntries();
}

function countEntries(){
    var filledEntries=0;
    for(var i=0;i<userEntries.length;i++){
        if(userEntries[i]!=null && userEntries[i]!="")filledEntries++;
    }
    if(filledEntries==noOfEntries){
        //$("#solutionControls").show(animationRate); //Τα controls είναι ήδη ορατά από εκπαιδευτική άποψη
        promptID=promptToRunCode;
    }
    else{
        promptID=promptToFillInBlanks;
    }
    showPrompt();
}

function abortSimulation(){
    simulationAborted=true;
	$("#btnStop").click();
}

function showMatches(index){
    switch(index){
    case 1:
        for(var i=0;i<2;i++){
            $("#cmd"+i).addClass("matched");
        }
        break;
    case 2:
        $("#cmd2").addClass("matched");
        break;
    case 3:
        $("#cmd3").addClass("matched");
        $("#cmd7").addClass("matched");
        break;
    case 4:
        $("#cmd4").addClass("matched");
        break;
    case 5:
        for(var i=5;i<7;i++){
            $("#cmd"+i).addClass("matched");
        }
        break;
    case 6:
        $("#cmd7").addClass("matched");
        break;
    case 7:
        $("#cmd8").addClass("matched");
        break;
    }    
}

function updateSimulationInfo(){
    document.getElementById("mCurrent").innerHTML=mSim;
    document.getElementById("currentHeight").innerHTML=hSim.toFixed(noOfDecimalDigits)+" €";
}

function preventMoreHints(){
    additionalHintsShown=true;
}