/**
 * 
 */
var additionalErrorMessages=[];
var progressiveExpression=[];

function stringExpressionValue(expression,varNames,varValues,startOfExpression,restOfExpression,resultRounded){
	expression=trimSpaces(expression.toLowerCase());
	var unexpectedEndOfExpressionErrMsg="Η αλγεβρική παράσταση δεν τερματίζεται σωστά.";
	var unknownElementErrMsg="Μη αναγνωρίσιμο στοιχείο (τελεστής/συνάρτηση/...). Παρακαλώ ελέξτε την παράσταση στη θέση:";
	var emptyExpressionErrMsg="Παρακαλώ δώστε μια αλγεβρική παράσταση.";
	var unexpectedIndexErrMsg="Αναφορά σε στοιχείο χωρίς όνομα πίνακα. Παρακαλώ ελέξτε την παράσταση στη θέση:";
	var indexOutOfBoundsErrMsg="Δείκτης εκτός ορίων. Παρακαλώ ελέξτε την παράσταση στη θέση:";
	var arrayWithoutIndexErrMsg="Αναφορά σε πίνακα χωρίς χρήση δείκτη. Παρακαλώ ελέξτε την παράσταση στη θέση:";
	var length=expression.length-1;
	var i=0;
	var subExpression;
	var exprValue=0;
	var limitingSymbols="+-";
	var exponentLimitingSymbols="+-*/dm";
	var partialFirst="";
	var partialLast="";
    var tempResult="";
	if(length<0){
		updateErrorArray(emptyExpressionErrMsg);
		return "error";
	}
	while(i<=length){
		switch(expression.charAt(i)){
	    case "(":
	    	i++;
	    	subExpression=getSubexpressionInParentheses();

	    	
	    	partialFirst=startOfExpression+"(";
	    	partialLast=expression.substr(i,expression.length)+restOfExpression;
            tempResult=stringExpressionValue(subExpression,varNames,varValues,partialFirst,partialLast,resultRounded);
            progressiveExpression.push(partialFirst+tempResult+partialLast);
            exprValue=tempResult;

		    i++;
		    break;
	    case "[":
	    	if(i==0){
	    		var errPos=i+1;
	    		updateErrorArray(unexpectedIndexErrMsg+errPos);
	    		return "error";
	    	}
	    	else{
		    	i++;
		    	subExpression=getSubexpressionInSquareBrackets();

	            partialFirst=startOfExpression+"[";
	            partialLast=expression.substr(i,expression.length)+restOfExpression;
		    	tempResult=stringExpressionValue(subExpression,varNames,varValues,partialFirst,partialLast,resultRounded);
                progressiveExpression.push(partialFirst+tempResult+partialLast);
                exprValue=tempResult;

			    i++;
	    	}
		    break;
        case "α"://Α_Τ ή Α_Μ
            if(expression.substring(i,i+4)=="α_τ("){
                i+=4;
                subExpression=getSubexpressionInParentheses();
                
                partialFirst=startOfExpression+"Α_Τ(";
                partialLast=expression.substr(i,expression.length)+restOfExpression;
                tempResult=stringExpressionValue(subExpression,varNames,varValues,partialFirst,partialLast,resultRounded);
                progressiveExpression.push(partialFirst+tempResult+partialLast);
                exprValue=Math.abs(tempResult);

                i++;//Παρένθεση της Α_Τ που κλείνει
            }
            else if(expression.substring(i,i+4)=="α_μ("){
                i+=4;
                subExpression=getSubexpressionInParentheses();
                
                partialFirst=startOfExpression+"Α_Μ(";
                partialLast=expression.substr(i,expression.length)+restOfExpression;
                tempResult=stringExpressionValue(subExpression,varNames,varValues,partialFirst,partialLast,resultRounded);
                progressiveExpression.push(partialFirst+tempResult+partialLast);
                exprValue=parseInt(tempResult);

                i++;//Παρένθεση του Α_Μ που κλείνει
            }
            break;
        case "τ"://Τ_Ρ
            if(expression.substring(i,i+4)=="τ_ρ("){
                
                i+=4;
                subExpression=getSubexpressionInParentheses();

                partialFirst=startOfExpression+"Τ_Ρ(";
                partialLast=expression.substr(i,expression.length)+restOfExpression;
                tempResult=stringExpressionValue(subExpression,varNames,varValues,partialFirst,partialLast,resultRounded);
                progressiveExpression.push(partialFirst+tempResult+partialLast);
                exprValue=Math.sqrt(tempResult);
                
                i++;//Παρένθεση της Τ_Ρ που κλείνει

                //partialLast=expression.substr(i,expression.length);
            }
            break;
	    case "η"://ΗΜ
	    	if(expression.substring(i,i+3)=="ημ("){
	    		i+=3;
	    		subExpression=getSubexpressionInParentheses();

                partialFirst=startOfExpression+"ΗΜ(";
                partialLast=expression.substr(i,expression.length)+restOfExpression;
                tempResult=stringExpressionValue(subExpression,varNames,varValues,partialFirst,partialLast,resultRounded);
                progressiveExpression.push(partialFirst+tempResult+partialLast);
                exprValue=Math.sin(tempResult);
	    		
	    		i++;//Παρένθεση του ΗΜ που κλείνει
	    	}
    		/*else{
    			updateErrorArray(unknownElementErrMsg+(i+1));
	    		return "error";
	    	}*/
	    	break;
	    case "σ"://ΣΥΝ
		    if(expression.substring(i,i+4)=="συν("){
		        i+=4;
		        subExpression=getSubexpressionInParentheses();

                partialFirst=startOfExpression+"ΣΥΝ(";
                partialLast=expression.substr(i,expression.length)+restOfExpression;
                tempResult=stringExpressionValue(subExpression,varNames,varValues,partialFirst,partialLast,resultRounded);
                progressiveExpression.push(partialFirst+tempResult+partialLast);
                exprValue=Math.cos(tempResult);
		        
		        i++;//Παρένθεση του ΣΥΝ που κλείνει
			}  
	    	/*else{
	    		updateErrorArray(unknownElementErrMsg+(i+1));
	    		return "error";
	    	}*/
	    	break;
        case "ε"://ΕΦ ή Ε-κθετική
            if(expression.substring(i,i+3)=="εφ("){
                i+=3;
                subExpression=getSubexpressionInParentheses();

                partialFirst=startOfExpression+"ΕΦ(";
                partialLast=expression.substr(i,expression.length)+restOfExpression;
                tempResult=stringExpressionValue(subExpression,varNames,varValues,partialFirst,partialLast,resultRounded);
                progressiveExpression.push(partialFirst+tempResult+partialLast);
                exprValue=Math.tan(tempResult);

                i++;//Παρένθεση της ΕΦ που κλείνει
            }  
            else if(expression.substring(i,i+2)=="ε("){
                i+=2;
                subExpression=getSubexpressionInParentheses();

                partialFirst=startOfExpression+"Ε(";
                partialLast=expression.substr(i,expression.length)+restOfExpression;
                tempResult=stringExpressionValue(subExpression,varNames,varValues,partialFirst,partialLast,resultRounded);
                progressiveExpression.push(partialFirst+tempResult+partialLast);
                exprValue=Math.exp(tempResult);
                
                i++;//Παρένθεση της Ε που κλείνει
            }  
            /*else{
                updateErrorArray(unknownElementErrMsg+(i+1));
                return "error";
            }*/
            break;
        case "λ"://ΛΟΓ
            if(expression.substring(i,i+4)=="λoγ("){
                i+=4;
                subExpression=getSubexpressionInParentheses();

                partialFirst=startOfExpression+"ΛΟΓ(";
                partialLast=expression.substr(i,expression.length)+restOfExpression;
                tempResult=stringExpressionValue(subExpression,varNames,varValues,partialFirst,partialLast,resultRounded);
                progressiveExpression.push(partialFirst+tempResult+partialLast);
                exprValue=Math.log(tempResult);

                i++;//Παρένθεση της ΛΟΓ που κλείνει
            }  
            /*else{
                updateErrorArray(unknownElementErrMsg+(i+1));
                return "error";
            }*/
            break;
	    case "t"://true
		    if(expression.substring(i,i+4)=="true"){
		        i+=4;
		        exprValue="1";
			}  
	    	/*else{
	    		updateErrorArray(unknownElementErrMsg+(i+1));
	    		return "error";
	    	}*/
	    	break;
	    case "f"://false
		    if(expression.substring(i,i+5)=="false"){
		        i+=5;
		        exprValue="0";
			}  
	    	/*else{
	    		updateErrorArray(unknownElementErrMsg+(i+1));
	    		return "error";
	    	}*/
	    	break;
	    case "d"://div
		    if(expression.substring(i,i+3)=="div"){
		        i+=3;
		        subExpression="";
                do{
                    subExpression=subExpression+expression.charAt(i);
                    if(expression.charAt(i)=="("){
                        i++;
                        subExpression+=getSubexpressionInParentheses()+")";
                    }
                    i++;
                }while(exponentLimitingSymbols.indexOf(expression.charAt(i))==-1 && i<=length);

                partialFirst=startOfExpression+exprValue+"div";
                partialLast=expression.substr(i,expression.length)+restOfExpression;

                tempResult=stringExpressionValue(subExpression,varNames,varValues,partialFirst,partialLast,resultRounded);
                progressiveExpression.push(partialFirst+tempResult+partialLast);
                exprValue=parseInt(exprValue/tempResult);
		    }
	    	/*else{
	    		updateErrorArray(unknownElementErrMsg+(i+1));
	    		return "error";
	    	}*/
	    	break;
	    case "m"://mod
		    if(expression.substring(i,i+3)=="mod"){
		        i+=3;
		        subExpression="";
                do{
                    subExpression=subExpression+expression.charAt(i);
                    if(expression.charAt(i)=="("){
                        i++;
                        subExpression+=getSubexpressionInParentheses()+")";
                    }
                    i++;
                }while(exponentLimitingSymbols.indexOf(expression.charAt(i))==-1 && i<=length);
                
                partialFirst=startOfExpression+exprValue+"mod";
                partialLast=expression.substr(i,expression.length)+restOfExpression;

                tempResult=stringExpressionValue(subExpression,varNames,varValues,partialFirst,partialLast,resultRounded);
                progressiveExpression.push(partialFirst+tempResult+partialLast);
                exprValue=exprValue % tempResult;
		    }  
	    	/*else{
	    		updateErrorArray(unknownElementErrMsg+(i+1));
	    		return "error";
	    	}*/
	    	break;
	    case "+":
	    case "-":
	    case "*":
	    case "/":
	    case "^":
	    	var selectedOperator=expression.charAt(i);
	    	var limit=exponentLimitingSymbols;
	    	if(selectedOperator=="+" || selectedOperator=="-"){
	    		limit=limitingSymbols;
	    	}
			i++;
			if(i>length){
				updateErrorArray(unexpectedEndOfExpressionErrMsg);
				return "error";
			}
			subExpression="";
			while(limit.indexOf(expression.charAt(i))==-1 && i<=length){
				if(expression.charAt(i)=="("){
					i++;
					subExpression=subExpression+"("+getSubexpressionInParentheses();
				}
				else{
					subExpression=subExpression+expression.charAt(i);
					i++;
				}
			}

            partialFirst=startOfExpression+exprValue+selectedOperator;
            partialLast=expression.substr(i,expression.length)+restOfExpression;

			tempResult=stringExpressionValue(subExpression,varNames,varValues,partialFirst,partialLast,resultRounded);
            progressiveExpression.push(partialFirst+tempResult+partialLast);

			if(selectedOperator=="+"){
			    exprValue=exprValue+tempResult;
			}
			else if(selectedOperator=="-"){
				exprValue=exprValue-tempResult;
			}
			else if(selectedOperator=="*"){
				exprValue=exprValue*tempResult;
			}
			else if(selectedOperator=="/"){
				exprValue=exprValue/tempResult;
			}	
			else if(selectedOperator=="^"){
				exprValue=Math.pow(exprValue,tempResult);
			}	
			break;
	    case "π":
		    exprValue=Math.PI;
		    i++;
		    break;
	    case "0":
	    case "1":
	    case "2":
	    case "3":
	    case "4":
	    case "5":
	    case "6":
	    case "7":
	    case "8":
	    case "9":
	    case ".":
	    	subExpression="";
			while ((((expression.charAt(i)>="0") && (expression.charAt(i)<="9")) || (expression.charAt(i)==".") || (expression.charAt(i)=="%")) && (i<=length)){
				subExpression=subExpression+expression.charAt(i);
				i++;
			}
			if(subExpression.charAt(subExpression.length-1)=="%"){
				exprValue=parseFloat(subExpression)/100;
			}
			else{
				exprValue=parseFloat(subExpression);
			}
			break;
	    default:
	    	var jj=-1;
	        do{
	        	jj++;
	        }while(jj<varNames.length && varNames[jj]!=expression.charAt(i));
	        if(jj==varNames.length){//Αν δε βρέθηκε το όνομα μεταβλητής
	        	updateErrorArray(unknownElementErrMsg+(i+1));
	        	return "error";
	        }
	        else{
	        	if(varValues[jj].length){//Αν η μεταβλητή είναι πίνακας
			    	i++;
			    	if(expression.charAt(i)=="["){//Αν ακολουθεί αγκύλη για 
				    	i++;
			    		subExpression=getSubexpressionInSquareBrackets();
					    var indexValue=stringExpressionValue(subExpression,varNames,varValues,expression.substr(i,expression.length),resultRounded);
					    if(indexValue<varValues[jj].length){
					    	exprValue=varValues[jj][indexValue];
					    }
					    else{
					    	updateErrorArray(indexOutOfBoundsErrMsg+(i+1));
					    	return "error";
					    }
			    	}
			    	else{
			        	updateErrorArray(arrayWithoutIndexErrMsg+(i+1));
			        	return "error";
			    	}
	        	}
	        	else{
	        		exprValue=varValues[jj];
	        	}
	        	i++;
	        }
		}//της switch
	}//της while
	if(resultRounded){
	    return Math.round(100*exprValue)/100;
	}
	else{
	    return exprValue;
	}
	
	function getSubexpressionInParentheses(){
		var parenthesisErrMsg="Υπάρχει λάθος στην έκφραση που πληκτρολογήσατε. Παρακαλώ ελέγξτε τις παρενθέσεις στη θέση:";
		var parenthesisCounter=1;//Η getSubexpressionInParentheses καλείται όταν έχει ήδη εντοπιστεί παρένθεση που ανοίγει
		var subExpr="";
		//while(expression.charAt(i)!=")" && parenthesisCounter!=0){
	    while(parenthesisCounter!=0){
	    	var currentChar=expression.charAt(i);
	    	if(currentChar=="("){
	    		parenthesisCounter++;
	    	}
	    	else if(currentChar==")"){
	    		parenthesisCounter--;
	    	}
	    	if(parenthesisCounter>0){
		    	subExpr=subExpr+currentChar;
		    	i++;
		    	if(i>length){
		    		updateErrorArray(parenthesisErrMsg+(i+1));
		    		return "error";
		    	}
	    	}
	    }
	    return subExpr;
	}

	function getSubexpressionInSquareBrackets(){
		var bracketsErrMsg="Υπάρχει λάθος στην έκφραση που πληκτρολογήσατε. Παρακαλώ ελέγξτε τις αγκύλες στη θέση:";
		var bracketsCounter=1;//Η getSubexpressionInSquareBrackets καλείται όταν έχει ήδη εντοπιστεί αγκύλη που ανοίγει
		var subExpr="";
		//while(expression.charAt(i)!="]" || bracketsCounter!=0){
	    while(bracketsCounter!=0){
	    	var currentChar=expression.charAt(i);
	    	if(currentChar=="["){
	    		bracketsCounter++;
	    	}
	    	else if(currentChar=="]"){
	    		bracketsCounter--;
	    	}
	    	if(bracketsCounter>0){
		    	subExpr=subExpr+currentChar;
		    	i++;
		    	if(i>length){
		    		updateErrorArray(bracketsErrMsg+(i+1));
		    		return "error";
		    	}
	    	}
	    }
	    return subExpr;
	}
}

function stringComparativeValue(expression,varNames,varValues,resultRounded){
	expression=trimSpaces(expression.toLowerCase());
	if(expression=="true"){
	    return true;
	}
    if(expression=="false"){
        return false;
    }
	var unexpectedEndOfExpressionErrMsg="Η λογική συνθήκη δεν περιλαβάνει δεύτερο μέλος.";
	var noComparatorErrMsg="Δε δόθηκε συγκριτικός τελεστής.";
	var multipleComparatorsErrMsg="Μόνο ένας συγκριτικός τελεστής επιτρέπεται.";
	var emptyExpressionErrMsg="Παρακαλώ δώστε μια αλγεβρική παράσταση.";
	//var unknownSymbolErrMsg="Μη αναγνωρίσιμο σύμβολο.";
	var length=expression.length-1;
	var i=0;
	var selectedComparator="";
	var logicalExpr1="";
	var logicalExpr2="";
	//var logicalSubexpression="";
	var logicalValue=false;
	var limitingSymbols="=<>";//Πρώτοι χαρακτήρες συγκριτικών τελεστών
	if(length<0){
		updateErrorArray(emptyExpressionErrMsg);
		return "error";
	}
	while(i<=length){
		switch(expression.charAt(i)){
	    case "=":
	    case ">":
	    case "<":
	    /*case "<>":
	    case ">=":
	    case "<=":*/
	    	if(selectedComparator!=""){//Αν έχει ήδη εντοπιστεί συγκριτικός τελεστής...
	    		updateErrorArray(multipleComparatorsErrMsg);
				return "error";
	    	}
	    	selectedComparator=expression.charAt(i);
    		i++;
	    	if(limitingSymbols.indexOf(expression.charAt(i))>-1){
	    		selectedComparator=selectedComparator+expression.charAt(i);
	    		i++;
	    	}
			if(i>length){
				updateErrorArray(unexpectedEndOfExpressionErrMsg);
				return "error";
			}
			logicalExpr2="";
			while(limitingSymbols.indexOf(expression.charAt(i))==-1 && i<=length){
				logicalExpr2=logicalExpr2+expression.charAt(i);
				i++;
			}
			if(i<=length){
				updateErrorArray(multipleComparatorsErrMsg);
				return "error";
			}
			else if(selectedComparator=="="){
				logicalValue=stringExpressionValue(logicalExpr1,varNames,varValues,"","",resultRounded) == stringExpressionValue(logicalExpr2,varNames,varValues,"","",resultRounded);
			}
			else if(selectedComparator=="<>"){
				logicalValue=stringExpressionValue(logicalExpr1,varNames,varValues,"","",resultRounded) != stringExpressionValue(logicalExpr2,varNames,varValues,"","",resultRounded);
			}
			else if(selectedComparator==">"){
				logicalValue=stringExpressionValue(logicalExpr1,varNames,varValues,"","",resultRounded) > stringExpressionValue(logicalExpr2,varNames,varValues,"","",resultRounded);
			}
			else if(selectedComparator==">="){
				logicalValue=stringExpressionValue(logicalExpr1,varNames,varValues,"","",resultRounded) >= stringExpressionValue(logicalExpr2,varNames,varValues,"","",resultRounded);
			}
			else if(selectedComparator=="<"){
				logicalValue=stringExpressionValue(logicalExpr1,varNames,varValues,"","",resultRounded) < stringExpressionValue(logicalExpr2,varNames,varValues,"","",resultRounded);
			}
			else if(selectedComparator=="<="){
				var c1=stringExpressionValue(logicalExpr1,varNames,varValues,"","",resultRounded);
				var c2=stringExpressionValue(logicalExpr2,varNames,varValues,"","",resultRounded);
				logicalValue=c1 <= c2;
			}	
			break;
	    /*case "t":
	        if(expression.length==4 && expression.substring(i,i+4)=="true"){
	            logicalValue==true;
	        }
	        else{
	            updateErrorArray(unknownSymbolErrMsg);
	            return "error";
	        }
	        break;*/
        /*case "f":
            if(expression.length==5 && expression.substring(i,i+5)=="false"){
                logicalValue==false;
            }
            else{
                updateErrorArray(unknownSymbolErrMsg);
                return "error";
            }
            break;*/
	    default:
	        while(limitingSymbols.indexOf(expression.charAt(i))==-1 && i<=length){
	        	logicalExpr1=logicalExpr1+expression.charAt(i);
	        	i++;
	    	}
		}//της switch
	}//της while
	if(selectedComparator!="" || logicalValue==true || logicalValue==false){
		return logicalValue;
	}
	else{
		updateErrorArray(noComparatorErrMsg);
		return "error";
	}
}

function stringLogicalValue(expression,varNames,varValues,resultRounded){
	expression=trimSpaces(expression.toString().toLowerCase());
	var unexpectedStartOfExpressionErrMsg="Η λογική συνθήκη δεν ξεκινά σωστά.";
	//var unexpectedEndOfExpressionErrMsg="Η λογική συνθήκη δεν τερματίζεται σωστά.";
	var unknownOperatorErrMsg="Άγνωστος λογικός τελεστής.";
	var emptyLogicalExpressionErrMsg="Παρακαλώ γράψτε μια λογική συνθήκη.";
	//var unknownElementErrMsg="Μη αναγνωρίσιμο στοιχείο (τελεστής/συνάρτηση/...). Παρακαλώ ελέξτε την παράσταση στη θέση:";
	var length=expression.length-1;
	var i=0;
	var logicalSubexpression="";
	var logicalValue=false;
	if(length<0){
		updateErrorArray(emptyLogicalExpressionErrMsg);
		return "error";
	}
	while(i<=length){
		switch(expression.charAt(i)){
	    case "ο"://Ελληνικά
	    case "o"://Αγγλικά
	    	//***************************************************
	    	//**  ΠΡΟΣΟΧΗ: Η trimSpaces αλλάζει το "χ" σε "x"  **
	    	//***************************************************
	    	if(expression.substring(i,i+3)=="oxι" || expression.substring(i,i+3)=="oxi"){
	    		i+=3;
	    		if(expression.charAt(i)=="("){
	    		    i++;
	    			logicalSubexpression=getLogicalSubexpressionInParentheses();
	    			i++; //Παρένθεση που κλείνει
	    		}
	    		else{
	    	    	logicalSubexpression=stringLogicalValue(expression.substr(i,expression.length),varNames,varValues,resultRounded);
	        	    i=expression.length;
	    		}
	    		if(logicalSubexpression=="error"){
	    			logicalValue="error";
	    		}
	    		else{
		    		logicalValue=!stringLogicalValue(logicalSubexpression,varNames,varValues,resultRounded);
	    		}
	    	}
	    	else{
	    		updateErrorArray(unknownOperatorErrMsg);
	    		return "error";
	    	}
	    	break;
	    case "κ"://Ελληνικά
	    case "k"://Αγγλικά
	    	if(i==0){
	    		updateErrorArray(unexpectedStartOfExpressionErrMsg+"("+expression+")");
	    		return "error";
	    	}
	    	if(expression.substring(i,i+3)=="και" || expression.substring(i,i+3)=="kai"){
	    		i+=3;
	    		if(expression.charAt(i)=="("){
	    		    i++;
	    			logicalSubexpression=getLogicalSubexpressionInParentheses();
                    i++; //Παρένθεση που κλείνει
	    		}
	    		else{
	    	    	logicalSubexpression=stringLogicalValue(expression.substr(i,expression.length),varNames,varValues,resultRounded);
	        	    i=expression.length;
	    		}
	    		if(logicalSubexpression=="error"){
	    			logicalValue="error";
	    		}
	    		else{
		    		logicalValue=logicalValue && stringLogicalValue(logicalSubexpression,varNames,varValues,resultRounded);
	    		}
	    	}
	    	else{
	    		updateErrorArray(unknownOperatorErrMsg);
	    		return "error";
	    	}
	    	break;
	    case "η"://Ελληνικά
	    case "h"://Αγγλικά
	    	if(i==0){
	    		updateErrorArray(unexpectedStartOfExpressionErrMsg);
	    		return "error";
	    	}
    		i++;
    		if(expression.charAt(i)=="("){
    		    i++;
    			logicalSubexpression=getLogicalSubexpressionInParentheses();
                i++; //Παρένθεση που κλείνει
    		}
    		else{
    	    	logicalSubexpression=stringLogicalValue(expression.substr(i,expression.length),varNames,varValues,resultRounded);
        	    i=expression.length;
    		}
    		if(logicalSubexpression=="error"){
    			logicalValue="error";
    		}
    		else{
        		logicalValue=logicalValue || stringLogicalValue(logicalSubexpression,varNames,varValues,resultRounded);
    		}
			break;
	    default:
	    	var getSubExpr=getLogicalSubExpression(expression,i);
	        logicalValue=getSubExpr.value;
    	    i=getSubExpr.iNew;
		}//της switch
	}//της while
	return logicalValue;

	function getLogicalSubExpression(expression,i){
		var logicalValue;
		var logicalExpr="";
		var limitingSymbols="οκη";//Πρώτοι χαρακτήρες λογικών τελεστών κατά σειρά προτεραιότητας
    	/*if(expression.substring(i,i+6)=="αληθης"){
    		logicalValue=true;
    		i+=6;
    	}
    	else if(expression.substring(i,i+4)=="true"){
    		logicalValue=true;
    		i+=4;
    	}
    	else if(expression.substring(i,i+6)=="ψευδης"){
    		logicalValue=false;
    		i+=6;
		}
    	else if(expression.substring(i,i+5)=="false"){
    		logicalValue=false;
    		i+=5;
		}
    	else{*/
	        while(limitingSymbols.indexOf(expression.charAt(i))==-1 && i<=length){
	        	if(expression.substring(i,i+6)=="αληθησ"){
	        		//logicalValue=true;
	        		logicalExpr+="true";
	        		i+=6;
	        	}
	        	else if(expression.substring(i,i+4)=="true"){
	        		//logicalValue=true;
	        		logicalExpr+="true";
	        		i+=4;
	        	}
	        	else if(expression.substring(i,i+6)=="ψευδησ"){
	        		//logicalValue=false;
	        		logicalExpr+="false";
	        		i+=6;
	    		}
	        	else if(expression.substring(i,i+5)=="false"){
	        		//logicalValue=false;
	        		logicalExpr+="false";
	        		i+=5;
	    		}
	        	else{
		        	logicalExpr=logicalExpr+expression.charAt(i);
		        	i++;
	        	}
	        }
	        logicalValue=stringComparativeValue(logicalExpr,varNames,varValues,resultRounded);
    	//}
    	return{
    		value: logicalValue,
    		iNew: i
    	};
    		
	}
	
	function getLogicalSubexpressionInParentheses(){
	    var parenthesisErrMsg="Υπάρχει λάθος στην έκφραση που πληκτρολογήσατε. Παρακαλώ ελέγξτε τις παρενθέσεις στη θέση:";
	    var parenthesisCounter=1;//Η getLogicalSubexpressionInParentheses καλείται όταν έχει ήδη εντοπιστεί παρένθεση που ανοίγει
		var subExpr="";
		//while(expression.charAt(i)!=")" && parenthesisCounter!=0){
	    while(parenthesisCounter!=0){
	    	var currentChar=expression.charAt(i);
	    	if(currentChar=="("){
	    		parenthesisCounter++;
	    	}
	    	else if(currentChar==")"){
	    		parenthesisCounter--;
	    	}
	    	if(parenthesisCounter>0){
		    	subExpr=subExpr+currentChar;
		    	i++;
		    	if(i>length){
		    		updateErrorArray(parenthesisErrMsg+i);
		    		return "error";
		    	}
	    	}
	    }
	    return subExpr;
	}
}

function updateErrorArray(errMsg){
	//var found=false;
	i=0;
	while(i<additionalErrorMessages.length && additionalErrorMessages[i]!=errMsg){
		i++;
	}
	if(additionalErrorMessages[i]!=errMsg){
		alert(errMsg);
		additionalErrorMessages.push(errMsg);
	}
}

function resetErrorMessages(){
	for(var i=additionalErrorMessages.length-1;i>-1;i--){
		additionalErrorMessages.splice(i,1);
	}
}

function trimSpaces(entry){
	var currentChar="",correctedChar="";
	var entryLength=entry.length;
	var trimmed="";
	for(var i=0;i<entryLength;i++){
		currentChar=entry.charAt(i);
		if(currentChar!=" " && currentChar!="ˍ"){
			switch(currentChar){
			case "΅":
				correctedChar="";
				break;
			case "Ά":
			case "ά":
				correctedChar="α";
				break;
			case "Έ":
			case "έ":
				correctedChar="ε";
				break;
			case "Ή":
			case "ή":
				correctedChar="η";
				break;
			case "Ί":
			case "ί":
			case "Ϊ":
			case "ϊ":
			case "ΐ":
				correctedChar="ι";
				break;
			case "Ύ":
			case "ύ":
			case "Ϋ":
			case "ϋ":
			case "ΰ":
				correctedChar="υ";
				break;
			case "Ώ":
			case "ώ":
				correctedChar="ω";
				break;
			case "Ό":
			case "ό":
			case "ο":
				correctedChar="o";//aggliko
				break;
			case "Χ":
			case "χ":
				correctedChar="x";
				break;
            case "ς":
                correctedChar="σ";
                break;
			default:
				correctedChar=currentChar;
			}
			trimmed+=correctedChar;
		}
	}
	return trimmed;
}

function showProgressiveExpression(targetID){
    var progrExpr="";
    for(var i=0;i<progressiveExpression.length;i++){
        progrExpr+=progressiveExpression[i];
        if(i<progressiveExpression.length-1) progrExpr+="<br>";
    }
    $("#"+targetID).html(progrExpr);
    
}

function getProgressiveExpression(){
    var progrExpr="";
    for(var i=0;i<progressiveExpression.length;i++){
        var nextEntry=""+progressiveExpression[i];
        //προσθήκη κενών διαστημάτων σε +
        nextEntry=replacePart(nextEntry,"+"," + ");

        //προσθήκη κενών διαστημάτων σε -
        nextEntry=replacePart(nextEntry,"-"," - ");

        //προσθήκη κενών διαστημάτων σε *
        nextEntry=replacePart(nextEntry,"*"," * ");

        //προσθήκη κενών διαστημάτων σε /
        nextEntry=replacePart(nextEntry,"/"," / ");

        //προσθήκη κενών διαστημάτων σε div
        nextEntry=replacePart(nextEntry,"div"," DIV ");
        
        //προσθήκη κενών διαστημάτων σε mod
        nextEntry=replacePart(nextEntry,"mod"," MOD ");
        
        //προσθήκη κενών διαστημάτων σε Α_Τ και επαναφορά σε κεφαλαία
        nextEntry=replacePart(nextEntry,"α_τ"," Α_Τ");

        //προσθήκη κενών διαστημάτων σε Τ_Ρ και επαναφορά σε κεφαλαία
        nextEntry=replacePart(nextEntry,"τ_ρ"," Τ_Ρ");

        //προσθήκη κενών διαστημάτων σε Α_Μ και επαναφορά σε κεφαλαία
        nextEntry=replacePart(nextEntry,"α_μ"," Α_Μ");

        //προσθήκη κενών διαστημάτων σε ΗΜ και επαναφορά σε κεφαλαία
        nextEntry=replacePart(nextEntry,"ημ"," ΗΜ");

        //προσθήκη κενών διαστημάτων σε ΣΥΝ και επαναφορά σε κεφαλαία
        nextEntry=replacePart(nextEntry,"συν"," ΣΥΝ");

        //προσθήκη κενών διαστημάτων σε ΕΦ και επαναφορά σε κεφαλαία
        nextEntry=replacePart(nextEntry,"εφ"," ΕΦ");

        //προσθήκη κενών διαστημάτων σε ΛΟΓ και επαναφορά σε κεφαλαία
        nextEntry=replacePart(nextEntry,"λογ"," ΛΟΓ");

        //προσθήκη κενών διαστημάτων σε Ε και επαναφορά σε κεφαλαία
        nextEntry=replacePart(nextEntry,"ε"," Ε");

        if(i>0) progrExpr+="⇔ ";
        progrExpr+=nextEntry;
        if(i<progressiveExpression.length-1) progrExpr+=" ⇔<br>";
    }
    return progrExpr;

    function replacePart(phrase,partToFind,partToReplace){
        var from=0;
        var n=0;
        var offset=partToFind.length;
        while(n>-1){
            n=phrase.indexOf(partToFind,from);
            if(n>-1){
                phrase=phrase.substr(0,n)+partToReplace+phrase.substr(n+offset,phrase.length);
                from=n+partToReplace.length;
            }
        }
        return phrase;
    }
}

function generateFullProgressiveExpression(progrExpr1,comparator,progrExpr2,leftAddendum,rightAddendum){
    var part1="";
    var part2="";
    var expressionSteps=[];
    var n1=progrExpr1.length;
    var n2=progrExpr2.length;
    var n=Math.max(n1,n2);
    for (var i=0;i<n;i++){
        //απομόνωση προοδευτικής τιμής έκφρασης πρώτου μέλους
        if(i<n1){
            part1=progrExpr1[i];
        }
        else{
            part1=progrExpr1[n1-1];
        }
        //απομόνωση προοδευτικής τιμής έκφρασης πρώτου μέλους
        if(i<n2){
            part2=progrExpr2[i];
        }
        else{
            part2=progrExpr2[n2-1];
        }
        expressionSteps.push(leftAddendum+part1+comparator+part2+rightAddendum);
    }
    return expressionSteps;
}