﻿var codeProgram = new CodeSandBox();
var codeProgram = new CodeSandBox();

var $tabConsole;
var $tabVisual;
var $tabsCode;
var $tabsProgram;
var codeGen = null;
var codeGenerators = [];
var prevCommandIt = undefined;
var curCommandRunning = undefined;
var $appTooltip = undefined;
var $tabCurProgram;
var $ddlCommandsHidden;
var $ddlCommandsHiddenIf;

var animSpeed = 1000;

var animPaused = false;
var autoToolitips = true;

var bAnimating = false;

function getRandomInt(max) {
    return Math.floor(Math.random() * Math.floor(max));
}

function isTrue(value) {
    return (value.toLowerCase() == "αληθης") || (value.toLowerCase() == "true");
}

function isFalse(value) {
    return (value.toLowerCase() == "ψευδης") || (value.toLowerCase() == "false");
}

function isNumber(n) {
    return !isNaN(parseFloat(n)) && isFinite(n);
}

jQuery.fn.reverse = function () {
    return this.pushStack(this.get().reverse(), arguments);
};

jQuery.fn.hasScrollBar = function () {
    var e = this.get(0);
    return {
        vertical: e.scrollHeight > e.clientHeight,
        horizontal: e.scrollWidth > e.clientWidth
    };
}

function swap(x, y) {
    var temp = x;
    x = y;
    y = temp;
};

var isString = function (strObj) {
    return (strObj.startsWith("\x22") && strObj.endsWith("\x22"));
};

function showApplicationMessage(strMessage, $target, $parent, strSolution) {
    var $disableTip, $enableTip;
    if ($appTooltip === undefined) {
        $appTooltip = $('<div class="naoTooltip nt-top nt-medium appMessage"><span class="closeTip" title="Κλείσιμο">&times;</span><span class="message"></span></div>')

        $disableTip = $('<span class="disableTip" title="Απενεργοποίηση πληροφοριών εκτέλεσης">&#8943;</span>');
        $enableTip = $('<span class="enableTip" title="Ενεργοποίηση πληροφοριών εκτέλεσης">&#8759;</span>');


        $disableTip.click(function () {
            autoToolitips = false;
            $("#cbAutoTooltips").prop("checked", autoToolitips).checkboxradio("refresh");
            $appTooltip.find(".message:first").html("");
            $appTooltip.hide();
        });
        $enableTip.click(function () {
            autoToolitips = true;
            $("#cbAutoTooltips").prop("checked", autoToolitips).checkboxradio("refresh");
            $appTooltip.find(".message:first").html("");
            $appTooltip.hide();
        });

        $appTooltip.find("span.closeTip").after($disableTip).after($enableTip);
        $appTooltip.find("span.closeTip").click(function () {
            $appTooltip.find(".message:first").html("");
            $appTooltip.hide();
        })
    } else {
        $disableTip = $appTooltip.find("span.disableTip");
        $enableTip = $appTooltip.find("span.enableTip");
    }

    if (autoToolitips) {
        $disableTip.show();
        $enableTip.hide();
    } else {
        $disableTip.hide();
        $enableTip.show();
    }
    $parent.append($appTooltip);
    if (strMessage == "" || strMessage === null || strMessage === undefined) {
        $appTooltip.find(".message:first").html("");
        $appTooltip.hide();
    } else {
        $appTooltip.show();
        $target.attr("data-app-message-displayed", "true");
        if (strSolution != undefined && strSolution != "") {
            $("#popSolutionHeader").html(strMessage);
            strMessage += " <a href='#popupSolution' class='ui-btn ui-mini ui-btn-inline ui-icon-eye ui-btn-icon-notext ui-corner-all solution' data-rel='popup'data-position-to='origin' data-transition='slideup' title='Λύση'>Λύση</a>";
            $("#popSolutionContent").html(strSolution);
        }
        $appTooltip.find(".message:first").html(strMessage);
        if ($target.length > 0) {
            var varOffset = $target.offset();
            var varOffsetParent = $parent.offset();
            var msgHeight = $appTooltip.outerHeight(true);
            var msgTop = varOffset.top - msgHeight;
            var msgLeft = $parent.outerWidth() - $appTooltip.outerWidth(true) - 15;
            // Check if there is no room on top of the line
            if (varOffset.top - varOffsetParent.top < msgHeight) {
                $appTooltip.removeClass("nt-top");
                $appTooltip.addClass("nt-bottom");
                msgTop = varOffset.top + 20;
            } else {
                $appTooltip.removeClass("nt-bottom");
                $appTooltip.addClass("nt-top");
                msgTop = varOffset.top - msgHeight;
            }
            $appTooltip.offset({
                top: msgTop,
                left: msgLeft,
            });
        }
    }

}


function createNewLine() {
    return $('<div class="line"><span class="spanCommand">θέσε</span><span class="spanParameter">0</span></div>');
}


function printText(strText) {
    if (strText === true)
        strText = "αληθης";
    if (strText === false)
        strText = "ψευδης";
    $tabConsole.append("<span class='msg'><pre>" + strText + "</pre></span>");
}

function setValueConstant($targetVariable, value, $animSource, handlerNextCommand) {
    var $content = $targetVariable.find(".content:first");

    if ($.type(value) === "number") {
        $targetVariable.append($content);
        $content.removeClass("fixedContent")
        $content.removeClass("booleanContent")
        $content.removeClass("stringContent")
        $targetVariable.find(".naoTooltip").remove();
        $content.addClass("numberContent")
        $content.html(value);
        $content.addClass("spanHidden");
        $content.css("opacity", "0");
        $content.animate({
            opacity: 1
        }, "slow", function () {
            $(this).removeClass("spanHidden");
            var w = $(this).width();
            var newW = String(value).length * 9;
            if (newW > w)
                $(this).width(newW);

        });

    } else
    if ($.type(value) === "string") {
        $content.removeClass("booleanContent")
        $content.removeClass("numberContent")
        $content.addClass("stringContent")
        if (value == "")
            $content.html('""');
        else
            $content.html('"' + value + '"');
        if ($targetVariable.find(".naoTooltip").length == 0) {
            var $toolTip = $('<div class="naoTooltip nt-right nt-small"></div>');
            $targetVariable.append($toolTip);
            $toolTip.append($content);
            //$variable.naoTooltip();
        }
    } else
    if ($.type(value) === "boolean") {
        // remove string appearence
        if ($targetVariable.find(".naoTooltip").length > 0) {
            $targetVariable.append($content);
            $targetVariable.find(".naoTooltip").remove();
            $content.html("");
        }
        $content.addClass("booleanContent");
        var $check;
        $check = $targetVariable.find("input[type='checkbox']");
        if ($check.length == 0) {
            $content.html("");
            // create checkbox
            $check = $('<input type="checkbox" class="checkbox"/>');
            $content.append($check);
            // create slider for the checkbox
            $check.checkToggler({
                labelOn: 'αληθης',
                labelOff: 'ψευδης'
            });
            $content.removeClass("stringContent")
            $content.removeClass("numberContent")
            $content.addClass("booleanContent")
        }
        $check.prop("checked", value);
        $check.change();
    }

    // call the next command handler
    if (handlerNextCommand !== undefined)
        handlerNextCommand(null);
    else
        bAnimating = false;
}

function animateVariable(pos, $source, $targetVariable, $animSource, callback) {
    var ch, cw, ah, aw, tw, th;
    var $targetContent = $targetVariable.find(".content:first");

    if (pos == 0)
        $targetContent.html("&nbsp;");

    $targetContent.removeClass("fixedContent")
    $targetContent.removeClass("booleanContent")
    $targetContent.removeClass("stringContent")
    $targetContent.removeClass("numberContent")

    var targetOffset = $targetContent.offset();
    th = $targetContent.outerHeight(true);
    tw = $targetContent.outerWidth(true);

    var $clonedContent;

    ah = $animSource.outerHeight(true);
    aw = $animSource.outerWidth(true);

    if ($.type($source) === "string") {
        var sourceOffset = $animSource.offset();
        $clonedContent = $('<span class="content clonedContent" style="position:absolute"></span>');
        $clonedContent.html($source);
        $("body").append($clonedContent)
        ch = $clonedContent.outerHeight(true);
        $clonedContent.offset({
            left: sourceOffset.left + aw,
            top: sourceOffset.top - ch / 2 + ah / 2
        });
    } else {
        var $sourceContent = $source.find(".content:first");
        var sourceOffset = $sourceContent.offset();
        var $clonedContent = $sourceContent.clone();
        $clonedContent.removeClass("spanHidden");
        $clonedContent.removeClass("fixedContent")
        $clonedContent.removeClass("booleanContent")
        $clonedContent.removeClass("stringContent")
        $clonedContent.removeClass("numberContent")

        $clonedContent.addClass("clonedContent");
        // check for boolean value visualization
        var $input = $clonedContent.find("input[type=checkbox]:first");
        if ($input.length > 0) {
            // replace boolean visualization toggle with the
            // word αληθης ή ψευδής
            $clonedContent.removeClass("booleanContent");
            var bValue = $input.prop("checked");
            if (bValue)
                $clonedContent.html("αληθης");
            else
                $clonedContent.html("ψευδης");
        }
        $("body").append($clonedContent)
        ch = $clonedContent.outerHeight(true);
        $clonedContent.offset({
            left: sourceOffset.left,
            top: sourceOffset.top
        });
    }


    $clonedContent.animate({
        top: targetOffset.top + th / 2 - ch / 2,
        left: targetOffset.left - 3 + tw
    }, animSpeed, function () {
        $(this).attr("style", "")
        $(this).addClass("fixedContent");
        $(this).removeClass("clonedContent");
        $targetContent.append($(this));
        callback();
    });
}

function setValue($targetVariable, value, statement, $animSource, handlerNextCommand, expressionEvaled, curProgram, stepRun) {

    function animateNextPiece() {
        var strVar = arrVariables[i].trim();

        strVar = strVar.replace("**", "^");
        strVar = strVar.replace("==", "=");
        strVar = strVar.replace("&&", "και");
        strVar = strVar.replace("||", "ή");
        strVar = strVar.replace("!=", "<>");
        strVar = strVar.replace("!", "οχι");
        strVar = strVar.replace("true", "αληθης");
        strVar = strVar.replace("false", "ψευδης");

        if (strVar == "") {
            if (i < arrVariables.length - 1 && codeGenerators.length > 0) {
                i++;
                animateNextPiece();
            } else
                setValueConstant($targetVariable, value, $animSource, handlerNextCommand);
            return;
        }
        // This is unefficient, propably must leave
        showArrayIndexes();

        var targetX = $targetVariable.offset().top;
        $tabVisual.scrollTop(targetX - parentX);

        if (strVar.match(re) != null) { // Is it an operator ?
            animateVariable(i, strVar, $targetVariable, $animSource, function () {
                //  codeGenerators.length > 0 aka step execution has started
                if (i < arrVariables.length - 1 && codeGenerators.length > 0) {
                    i++;
                    animateNextPiece();
                } else
                    setValueConstant($targetVariable, value, $animSource, handlerNextCommand);
            });
        } else
            try { // Is it a variable?

                var strMet = codeProgram.MetToString(curProgram, strVar);

                var strSelector = 'div[data-met-raw=\'' + strMet + '\']';
                var $sourceVar = $tabVisual.find(strSelector).not(".variableIndex");

                // If $sourceVar not found, terminate animation
                if ($sourceVar.length == 0) {
                    setTimeout(function () {
                        setValueConstant($targetVariable, value, $animSource, handlerNextCommand);
                    }, 100);
                } else {
                    if (!$sourceVar.is($targetVariable)) {
                        animateVariable(i, $sourceVar, $targetVariable, $sourceVar, function () {
                            if (i < arrVariables.length - 1) {
                                i++;
                                animateNextPiece();
                            } else
                                setValueConstant($targetVariable, value, $animSource, handlerNextCommand);
                        });
                    } else {
                        if (i < arrVariables.length - 1 && codeGenerators.length > 0) {
                            i++;
                            animateNextPiece();
                        } else
                            setValueConstant($targetVariable, value, $animSource, handlerNextCommand);
                    }
                }

            } catch (e) {
                // Not a variable, fixed value or array declaration
                if (strVar.charAt(0) == "[" && strVar.charAt(strVar.length - 1) == "]") {
                    // If it is an array, the ret.value holds the i-th position value
                    if ($.type(value) === "boolean") {
                        if (value)
                            strVar = "αληθης";
                        else
                            strVar = "ψευδης";
                    } else
                        strVar = value.toString();
                }

                animateVariable(i, strVar, $targetVariable, $animSource, function () {
                    //  codeGenerators.length > 0 aka step execution has started
                    if (i < arrVariables.length - 1 && codeGenerators.length > 0) {
                        i++;
                        animateNextPiece();
                    } else
                        setValueConstant($targetVariable, value, $animSource, handlerNextCommand);
                });
            }

    }


    function animateNextPieceOld() {
        var strVar = arrVariables[i];
        strVar = strVar.replace("&&", "και");
        strVar = strVar.replace("||", "ή");
        strVar = strVar.replace("!", "οχι");
        strVar = strVar.replace("true", "αληθης");
        strVar = strVar.replace("false", "ψευδης");

        strVar = strVar.replace("==", "=");

        strVar = strVar.replace("%", "mod");

        // This is unefficient, propably must leave
        showArrayIndexes();

        var targetX = $targetVariable.offset().top;
        $tabVisual.scrollTop(targetX - parentX);

        if (strVar.indexOf("this.metavlites") == -1) {
            // not a variable, so it's fixed value or array declaration


            animateVariable(i, strVar, $targetVariable, $animSource, function () {
                //  codeGenerators.length > 0 aka step execution has started
                if (i < arrVariables.length - 1 && codeGenerators.length > 0) {
                    i++;
                    animateNextPiece();
                } else
                    setValueConstant($targetVariable, value, $animSource, handlerNextCommand);
            });
        } else {
            var strSelector = 'div[data-met-raw=\'' + strVar + '\']';
            var $sourceVar = $tabVisual.find(strSelector).not(".variableIndex");

            // If $sourceVar not found, terminate animation
            if ($sourceVar.length == 0) {
                //var $targetContent = $targetVariable.find(".content:first");
                // $targetContent.removeClass("fixedContent");
                // $targetContent.removeClass("booleanContent");
                // $targetContent.removeClass("stringContent");
                // $targetContent.removeClass("numberContent");

                setTimeout(function () {
                    setValueConstant($targetVariable, value, $animSource, handlerNextCommand);
                }, 100);
            } else {
                if (!$sourceVar.is($targetVariable)) {
                    animateVariable(i, $sourceVar, $targetVariable, $sourceVar, function () {
                        if (i < arrVariables.length - 1) {
                            i++;
                            animateNextPiece();
                        } else
                            setValueConstant($targetVariable, value, $animSource, handlerNextCommand);
                    });
                } else {
                    if (i < arrVariables.length - 1 && codeGenerators.length > 0) {
                        i++;
                        animateNextPiece();
                    } else
                        setValueConstant($targetVariable, value, $animSource, handlerNextCommand);
                }
            }
        }

    }

    //var re = /(και|ή|οχι|αληθης|ψευδης|div|mod|\+|-|\*|\/|\(|\)|=|>|<)/g;
    var re = /(div|mod|\*\*|\+|-|\*|\/|\(|\)|&&|\|\||!=|==|>=|<=|>|<|=|!)/g;

    //var arrVariables = codeProgram.extractVariables(statement);
    var arrVariables = expressionEvaled.split(re);

    var i = 0;
    var parentX = $tabVisual.offset().top;

    if (stepRun != null && stepRun == 2) {
        setValueConstant($targetVariable, value, $animSource, handlerNextCommand);
        showArrayIndexes();
    } else
        animateNextPiece();
    //showArrayIndexes();
}

function createVariableVisual(curProgram, strMetRaw, name, ret, $parent, $animSource, handlerNextCommand, stepRun) {
    var strVariable = '<div class="variableContainer naoTooltip-wrap"><span class="label"></span ><span class="content">&nbsp;</span></div >';
    var $variable = $(strVariable);
    $variable.attr("data-met-raw", strMetRaw);
    $variable.attr("data-cur-program", curProgram);
    $variable.find(".label").html(name);
    $parent.append($variable);

    // if there is rightStatement, then its an assignment, else it is
    // a condition expression visualization, so use leftStatement
    if (ret.rightStatement !== undefined)
        setValue($variable, ret.value, ret.rightStatement.evaledStatement, $animSource, handlerNextCommand, ret.rightStatement.expressionEvaled, curProgram, stepRun);
    else
        setValue($variable, ret.value, ret.leftStatement.evaledStatement, $animSource, handlerNextCommand, ret.leftStatement.expressionEvaled, curProgram, stepRun);

    return $variable;
}

function getObjectDigits(obj) {
    var curType = $.type(obj);
    if (curType === "number")
        return String(obj).length;
    else
    if (curType === "string") {
        return obj.length;

    } else
    if (curType === "boolean") {
        return 10;
    }
}

function createArrayVisual(curProgram, strMetRaw, name, ret, $parent, $source, handlerNextCommand, stepRun) {
    var arrValue = ret.value;
    var name = codeProgram.GetMetName(strMetRaw);
    var strArray = '<div class="arrayContainer"><span class="label">Α</span></div>';



    var $array = $(strArray);
    $array.attr("data-met-raw", strMetRaw);
    $array.attr("data-cur-program", curProgram);
    $array.find(".label").html(name);
    // check for hard-code indexes
    var hardIndexes = $source.attr("data-met-raw-index-hard");
    if (hardIndexes !== undefined) {
        $array.attr("data-met-raw-index-hard", hardIndexes);
        //$array.attr("data-met-raw-index", hardIndexes);
    }

    //if (curProgram == "Κεντρικό")
    //    $array.find(".label").html(name);
    //else
    //    $array.find(".label").html(curProgram.replace("Κεντρικό.", "") + "." + name);

    var maxValue = arrValue.reduce(function (a, b) {
        var lenA = getObjectDigits(a);
        var lenB = getObjectDigits(b);
        return (lenA >= lenB) ? a : b;
    });

    var maxW = ($.type(maxValue) === "boolean") ? 60 : String(maxValue).length * 9;

    $parent.append($array);
    for (var i = 1; i < arrValue.length; i++) {
        var strMetRawIndex = strMetRaw + "[" + i + "]";
        var retI = {
            value: arrValue[i],
            leftStatement: ret.leftStatement,
            rightStatement: ret.rightStatement
        };
        var $variable;
        // call the next command handler only for the last array element
        if (i == arrValue.length - 1)
            $variable = createVariableVisual(curProgram, strMetRawIndex, i, retI, $array, $source, handlerNextCommand, stepRun);
        else
            $variable = createVariableVisual(curProgram, strMetRawIndex, i, retI, $array, $source, undefined, stepRun);

        // align array labels to the left
        var w = $variable.find(".label:first").width();
        w = Math.abs(w - 9);
        $variable.css("left", "-" + w + "px")

        $variable.find("span.content:first").width(maxW);
    }

    return $array;
}

function createArrayIndexes(arrVarPieces) {
    // if strRaw exists as a variable, find it
    // and mark it as index of the array
    for (var i = 0; i < arrVarPieces.length; i++) {
        var strRaw = arrVarPieces[i];
        // Do we have array accessors? If so, then it is a variable
        if (strRaw.charAt(0) == "[" && strRaw.charAt(strRaw.length - 1) == "]") {
            // Remove [ ] from start, end
            strRaw = strRaw.slice(1, strRaw.length - 1);
            var strRawArray = "this.metavlites[" + strRaw + "]";
            var type = codeProgram.GetMetRawType(strRawArray)
            if (type === "array") {
                var strArrSelector = 'div[data-met-raw=\'' + strRawArray + '\']';
                var $array = $tabVisual.find(strArrSelector).not(".variableIndex");

                //var curRawIndex = $array.attr("data-met-raw-index");
                // add hard-coded indexes to the array
                var hardIndexes = $array.attr("data-met-raw-index-hard");
                //if (hardIndexes !== undefined) {
                //    $array.attr("data-met-raw-index", hardIndexes);
                //}

                // Check for array index in procceding pieces
                while (i < arrVarPieces.length - 1) {
                    i++;
                    var strRawIndex = arrVarPieces[i];
                    if (strRawIndex.charAt(0) == "[" && strRawIndex.charAt(strRawIndex.length - 1) == "]") {
                        strRawIndex = strRawIndex.slice(1, strRawIndex.length - 1);

                        // if index is at the hard-coded indexes, don't add to the
                        // runtime indexes. just check the next one
                        if (hardIndexes !== undefined && hardIndexes.indexOf(strRawIndex) != -1)
                            continue;

                        var strSelector = 'div[data-met-raw=\'' + strRawIndex + '\']';
                        var $variable = $tabVisual.find(strSelector).not(".variableIndex");
                        if ($variable.length > 0) {
                            var curRawIndex = $array.attr("data-met-raw-index");
                            if (curRawIndex === undefined)
                                $array.attr("data-met-raw-index", strRawIndex);
                            else
                                // Is it already indexed by this index?
                                if (curRawIndex.indexOf(strRawIndex) == -1)
                                    $array.attr("data-met-raw-index", curRawIndex + " " + strRawIndex);

                        }
                    } else
                        break; // no more indexes to check for this array
                }
            }
        }
    }
}

function removeIndex($index, attrRawIndex) {
    if (attrRawIndex !== undefined) {
        //var hardIndexes = $arr.attr("data-met-raw-index-hard");
        var strRawIndex = $index.attr("data-met-raw").split("->")[0];
        // remove index with respect to hard-coded indexes
        //if (hardIndexes !== undefined && hardIndexes.indexOf(strRawIndex) == -1)
        attrRawIndex = attrRawIndex.replace(strRawIndex, "");
        //$arr.attr("data-met-raw-index", attrRawIndex);
    }
    $index.parent(".naoTooltip").remove();
    return attrRawIndex;
}

function sortIndexes(arrRawIndex) {
    var dictSorted = [];

    for (let strRawIndex of arrRawIndex) {
        if (strRawIndex == "")
            continue;
        var indexValue = codeProgram.GetMetRaw(strRawIndex);
        if (indexValue === undefined)
            continue;
        dictSorted.push([strRawIndex, indexValue]);
    }

    dictSorted.sort(function compare(kv1, kv2) {
        // This comparison function has 3 return cases:
        // - Negative number: kv1 should be placed BEFORE kv2
        // - Positive number: kv1 should be placed AFTER kv2
        // - Zero: they are equal, any order is ok between these 2 items
        return kv1[1] - kv2[1]
    })
    return dictSorted;
}

function showArrayIndexes() {
    $tabVisual.find("fieldset > .arrayContainer").not(".variableIndex").each(function () {
        var $arr = $(this);
        var attrRawIndex = $arr.attr("data-met-raw-index");
        var attrNewIndex = attrRawIndex;

        // add hard-coded indexes to indexes string
        var hardIndexes = $arr.attr("data-met-raw-index-hard");
        if (hardIndexes !== undefined)
            if (attrRawIndex === undefined || attrRawIndex === null || attrRawIndex == "")
                attrRawIndex = hardIndexes;
            else
                attrRawIndex += " " + hardIndexes;

        attrRawIndex = $.trim(attrRawIndex);
        var strArrMetRaw = $arr.attr("data-met-raw");
        if (attrRawIndex !== undefined && attrRawIndex !== "") {
            var prevIndexValue = 0;
            var $prevVariableIndex = undefined;
            var arrRawIndex = attrRawIndex.split(" ");
            var arrSortedIndex = sortIndexes(arrRawIndex);
            for (let sortedIndex of arrSortedIndex) {
                var baseLeft;
                var strRawIndex = sortedIndex[0];
                var indexValue = sortedIndex[1];

                if (strRawIndex === undefined || strRawIndex == "" ||
                    indexValue === undefined || indexValue <= 0)
                    continue;

                var strLabel;
                var $toolTip;

                // Check if the source variable for the index exists
                var strSelector = 'div[data-met-raw=\'' + strRawIndex + '\']';
                var $sourceVar = $tabVisual.find(strSelector).not(".variableIndex");
                // If the source variable not exists, remove this index from the array
                if ($sourceVar.length == 0) {
                    attrNewIndex = attrNewIndex.replace(strRawIndex, "");
                    continue;
                }

                strSelector = 'div.variableIndex[data-met-raw=\'' + strRawIndex + '->' + strArrMetRaw + '\']';
                var $index = $tabVisual.find(strSelector);
                // No index found, create a new one
                if ($index.length == 0) {
                    strSelector = 'div[data-met-raw=\'' + strRawIndex + '\']';
                    //$index = $tabVisual.find(strSelector).not(".variableIndex");;
                    $index = $sourceVar.clone();
                    $index.addClass("variableIndex");
                    $index.removeClass("naoTooltip-wrap");
                    $index.attr("data-met-raw", strRawIndex + '->' + strArrMetRaw);
                    $index.css("margin", "1px");
                    // $index.css("opacity", "1.0");
                    var strCurProgram = $index.attr("data-cur-program");
                    var $content = $index.find(".content");
                    $content.removeClass("stringContent");
                    $content.removeClass("numberContent");
                    $content.removeClass("booleanContent");
                    $content.removeClass("fixedContent");
                    //$index = $cloneIndex;
                    strLabel = $index.find(".label:first").text();
                    $index.find(".label:first").html(strLabel + " =");
                    $toolTip = $('<div class="naoTooltip nt-right nt-small variableIndex"></div>');
                    $toolTip.attr("data-cur-program", strCurProgram);
                    $toolTip.append($index);
                    //$index.naoTooltip();
                    $tabVisual.append($toolTip);
                } else {
                    $toolTip = $index.parent(".naoTooltip");
                }

                $index.find(".content").css("opacity", "1.0").html(indexValue);
                var $variable = $arr.children(".variableContainer").not(".variableIndex").eq(indexValue - 1);
                if ($variable.length > 0) {

                    if (indexValue == prevIndexValue) {
                        var prevVariableIndexWidth = ($prevVariableIndex === undefined) ? 0 : $prevVariableIndex.outerWidth(true);
                        baseLeft += prevVariableIndexWidth + 10;
                    } else
                        baseLeft = 0;
                    prevIndexValue = indexValue;
                    $prevVariableIndex = $index;

                    var $content = $variable.find(".content:first");
                    var varOffset = $content.offset();
                    var varPos = $variable.position();
                    $toolTip.offset({
                        top: varOffset.top + 4,
                        left: baseLeft + varOffset.left + $content.outerWidth(true) + 10,
                    });
                } else {
                    // The index is not pointing at an array element,
                    // remove it from DOM
                    attrNewIndex = removeIndex($index, attrNewIndex);
                    prevIndexValue = 0;
                    $prevVariableIndex = undefined;
                }


            }
            // set the the new indexes for the array
            if (attrNewIndex !== undefined && attrNewIndex !== "") {
                attrNewIndex = attrNewIndex.trim();
                $arr.attr("data-met-raw-index", attrNewIndex);
            } else
                $arr.attr("data-met-raw-index", undefined);
        }
    });
}

function setVariableVisual(curProgram, ret, $animSource, handlerNextCommand, stepRun) {
    var strMetRaw;
    var strVarName;
    var strSelector;
    var value = ret.value;
    var name;
    var strSelectorBlock = '[data-cur-program=\'' + curProgram + '\']';
    var strSelectorBlockMain = '[data-cur-program=\'Κεντρικό\']';

    var $visualBlock = $tabVisual.find("fieldset.visualBlock[data-cur-program='" + curProgram + "']");
    if ($visualBlock.length == 0) {
        $visualBlock = $('<fieldset class="visualBlock" data-cur-program=""><legend></legend></fieldset >');
        $visualBlock.attr("data-cur-program", curProgram);
        var arrCallStack = curProgram.split(".").reverse();
        var $ddlCallStack = $('<select class="ddlCallStack" title="Λίστα κλήσεων"></select>');
        for (var i = 0; i < arrCallStack.length; i++) {
            var $optItem = $("<option></option>");
            var strItem = arrCallStack[i];
            $optItem.html(strItem);
            if (i > 0)
                $optItem.attr("disabled", "disabled");
            $ddlCallStack.append($optItem);
        }
        $visualBlock.find("legend:first").append($ddlCallStack);
        $tabVisual.append($visualBlock);
    }

    strMetRaw = ret.leftStatement.evaledStatement;

    // Is this a reference to another variable?
    // Add the @name of the variable on top of the referenced variable
    if (strMetRaw.charAt(0) == "@") {
        var $label = $('<span class="label" style="opacity:0">' + strMetRaw + '</span>');
        var strRef = codeProgram.MetToString(curProgram, strMetRaw);
        strSelector = 'div[data-met-raw=\'' + strRef + '\']';
        var $varRef = $tabVisual.find(strSelector).not(".variableIndex");;
        //$array.attr("data-met-raw", strMetRaw);
        $label.attr("data-cur-program", curProgram);
        $varRef.find(".label:first").after($label);

        $label.animate({
            opacity: 1
        }, "slow", function () {
            var arrVarPieces = codeProgram.parseArrayStatement(ret.leftStatement.sourceStatement);
            createArrayIndexes(arrVarPieces);
            // call the next command handler
            if (handlerNextCommand !== undefined)
                handlerNextCommand(null);
        });


        return;
    }

    // if no rightstatement, then this is a condition expression visualization
    if (ret.rightStatement === undefined) {
        name = ret.leftStatement.expression;
        strMetRaw = ret.leftStatement.sourceStatement;
    } else {
        name = codeProgram.GetMetName(strMetRaw);
    }
    strSelector = 'div[data-met-raw=\'' + strMetRaw + '\']';
    strVarName = strMetRaw;



    // Parse the left side of the statement
    var $varRef;
    // Search for variable first in the current block and then
    // in the main block
    var $variable = $visualBlock.find(strSelector + strSelectorBlock).not(".variableIndex");

    // Search for variable first in the main block
    if ($variable.length == 0)
        $variable = $tabVisual.find(strSelector + strSelectorBlockMain).not(".variableIndex");

    if ($variable.length == 0) {

        var arrVarPieces = codeProgram.parseArrayStatement(ret.leftStatement.sourceStatement);
        createArrayIndexes(arrVarPieces);

        if (ret.rightStatement !== undefined) {
            arrVarPieces = codeProgram.parseArrayStatement(ret.rightStatement.sourceStatement);
            createArrayIndexes(arrVarPieces);
        }


        if ($.type(value) === "array") {
            $varRef = createArrayVisual(curProgram, strVarName, name, ret, $visualBlock, $animSource, handlerNextCommand, stepRun);
        } else
            $variable = createVariableVisual(curProgram, strVarName, name, ret, $visualBlock, $animSource, handlerNextCommand, stepRun);

    } else {
        if ($.type(value) === "array") {
            // remove previous array
            var strSelector = 'div.arrayContainer[data-met-raw=\'' + strMetRaw + '\']';
            var $arr = $tabVisual.find(strSelector).not(".variableIndex");;
            $arr.remove();
            // create the new one
            $varRef = createArrayVisual(curProgram, strVarName, name, ret, $tabVisual, $animSource, handlerNextCommand, stepRun);
        } else {
            // if there is rightStatement, then its an assignment, else it is
            // a condition expression visualization, so use leftStatement
            if (ret.rightStatement !== undefined)
                setValue($variable, ret.value, ret.rightStatement.evaledStatement, $animSource, handlerNextCommand, ret.rightStatement.expressionEvaled, curProgram, stepRun);
            else
                setValue($variable, ret.value, ret.leftStatement.evaledStatement, $animSource, handlerNextCommand, ret.leftStatement.expressionEvaled, curProgram, stepRun);
        }
        //var arrVarPieces = codeProgram.parseArrayStatement(strMetRaw);
        var arrVarPieces = codeProgram.parseArrayStatement(ret.leftStatement.sourceStatement);
        createArrayIndexes(arrVarPieces);

        if (ret.rightStatement !== undefined) {
            arrVarPieces = codeProgram.parseArrayStatement(ret.rightStatement.sourceStatement);
            createArrayIndexes(arrVarPieces);
        }
    }
}

function makeAssignment(curProgram, strParameter, stepRun, $animSource, handlerNextCommand, $command) {
    var ret = codeProgram.MakeAssignment(curProgram, strParameter, $command);

    if (stepRun) {
        if ((stepRun === true || stepRun == 2) && !ret.bExitFunction) {
            setVariableVisual(curProgram, ret, $animSource, handlerNextCommand, stepRun);
            //showArrayIndexes();
        } else {
            var strSelector = 'div[data-met-raw=\'' + ret.leftStatement.evaledStatement + '\']';
            var $sourceVar = $tabVisual.find(strSelector).not(".variableIndex");
            if ($sourceVar.length > 0) {
                setValueConstant($sourceVar, ret.value, $animSource, handlerNextCommand);
            }
        }

    }
    return ret;
}


function setExpressionVisual(curProgram, ret, $animSource, handlerNextCommand, stepRun) {
    var retExpr = {
        value: ret.value,
        leftStatement: ret.statement,
        rightStatement: undefined
    };
    setVariableVisual(curProgram, retExpr, $animSource, handlerNextCommand, stepRun)
}

function checkCondition(curProgram, strParameter, stepRun, $animSource, handlerNextCommand) {
    var ret = codeProgram.CheckCondition(curProgram, strParameter);
    if (stepRun === true || stepRun == 2 || (stepRun.caller != null && stepRun.caller == curProgram)) {
        setExpressionVisual(curProgram, ret, $animSource, handlerNextCommand, stepRun)
        //showArrayIndexes();
    }
    return ret;
}

function getCommandValue($command) {
    var strCommand;
    var $ddlCommands = $command.find(".ddlCommands:first");
    if ($ddlCommands.length == 0) { // no dropdown found, search for classic spanCommand
        var $spanCommand = $command.find(".spanCommand:first");
        strCommand = $spanCommand.text().trim();
        return strCommand;
    } else { // dropdown found, get value
        strCommand = $ddlCommands.val().trim();
        return {
            ddlCommands: $ddlCommands,
            command: strCommand
        };
    }
}

function getParameterValue($spanParameter) {
    var strParameter;
    var $paramInput = $spanParameter.find(".paramInput:first");

    if ($paramInput.length == 0)
        strParameter = $spanParameter.text().trim();
    else
        strParameter = $paramInput.val().trim();

    return strParameter;
}

function parseCommand($command, curProgram, stepRun, handlerNextCommand) {
    var ret = undefined;

    var strCommand = getCommandValue($command);
    if (strCommand.ddlCommands !== undefined) {
        // There is a dropdown for this line
        strCommand = strCommand.command;
    }
    var $spanParameter = $command.find(".spanParameter:first");
    var strParameter = getParameterValue($spanParameter);

    if (strCommand == "Κάλεσε") {
        ret = null;
        if (stepRun === true) {
            var codeGen;
            codeGen = runCodeProcedureGenerator($command, curProgram, stepRun, handlerNextCommand);
            codeGenerators.push(codeGen);

            // call the next command handler
            if (handlerNextCommand !== undefined)
                handlerNextCommand(null);
        } else if (stepRun === 2) {
            ret = runCodeProcedure($command, curProgram, {
                value: 2,
                caller: curProgram
            }, handlerNextCommand);
            if (ret != null && ret.value !== undefined)
                ret = null; // consume exitCode
        } else {
            ret = runCodeProcedure($command, curProgram, stepRun);
            if (ret != null && ret.value !== undefined)
                ret = null; // consume exitCode
        }
        return ret;
    } else
    if (strCommand == "") {
        try {
            ret = makeAssignment(curProgram, strParameter, stepRun, $spanParameter, handlerNextCommand, $command);
            // Check for return from function call
            if (ret.bExitFunction) {
                // we are assigning a value to the function variable.
                // this is an exit with value from function
                var ret1 = null;
                ret1 = ret.value;
                // call the next command handler
                if (handlerNextCommand !== undefined)
                    handlerNextCommand({
                        value: ret1
                    });

                return {
                    value: ret1
                };
            } else
                return null;
        } catch (e) {
            if (e instanceof InvalidNameError) {
                codeProgram.ErrorMessage = e.message;
                throw e;
            }
            // Check if there is a function call
            if (stepRun === true) {
                var codeGen;
                codeGen = runCodeComputeGenerator($command, curProgram, stepRun, handlerNextCommand);
                codeGenerators.push(codeGen);

                // call the next command handler
                if (handlerNextCommand !== undefined)
                    handlerNextCommand(null);

                return null;
            } else if (stepRun === 2) {
                //runCodeCompute($command, curProgram, 2, handlerNextCommand);
                runCodeCompute($command, curProgram, {
                    value: 2,
                    caller: curProgram
                }, handlerNextCommand);
                return null;
            } else {
                runCodeCompute($command, curProgram, stepRun);
                return null;
            }
        }
    } else if (strCommand == "Γράψε") {
        // Check for comma separated expressions
        var arrExpr = strParameter.match(/(".*?"|[^",]+)(?=\s*,|\s*$)/g);
        arrExpr = arrExpr || [];
        for (let curExpr of arrExpr) {
            curExpr = $.trim(curExpr);
            if (curExpr == "")
                continue;
            var ret = codeProgram.GetMet(curProgram, curExpr);
            if (ret.value == null || Number.isNaN(ret.value)){
                codeProgram.ErrorMessage = "Σφάλμα -> " + curExpr;
                console.log("Σφάλμα -> " + curExpr);
                throw codeProgram.ErrorMessage;
            }
            else
                printText(ret.value);

            if (stepRun === true && ret.statement !== undefined && ret.statement !== null) {
                var arrVarPieces = codeProgram.parseArrayStatement(ret.statement.sourceStatement);
                createArrayIndexes(arrVarPieces);
                //showArrayIndexes();
            }
        }
        // Break to new line, after messages
        printText("<br />");

        // select console tab
        selectDataTab(1);

        // call the next command handler
        if (handlerNextCommand !== undefined)
            handlerNextCommand(null);

        return null;
    } else if (strCommand == "Διάβασε") {

        try {
            ret = codeProgram.GetMet(curProgram, strParameter);
            if (ret.value == null || Number.isNaN(ret.value)){
                codeProgram.ErrorMessage = "Σφάλμα -> " + strParameter;
                console.log("Σφάλμα -> " + strParameter);
                //throw this.ErrorMessage;
                return undefined;
            }
        } catch (e) {
            //Do nothing if variable not found
        }

        var value = prompt("Δώστε τιμή για τη μεταβλητή " + strParameter);
        var strAssignment = strParameter + " <- ";
        value = $.trim(value);
        //if (value == null || value == "") {
        //    codeProgram.ErrorMessage = "Πρέπει να δώσετε τιμή!";
        //    throw codeProgram.ErrorMessage;
        //}
        if (isNumber(value)) {
            strAssignment += value;
        } else
        if (value.toLowerCase() == "αληθης") {
            value = "true";
            strAssignment += value;
        } else
        if (value.toLowerCase() == "ψευδης") {
            value = "false";
            strAssignment += value;
        } else {
            strAssignment += '"' + value + '"';
        }

        var ret = makeAssignment(curProgram, strAssignment, stepRun, $spanParameter, handlerNextCommand);
        return null;
    } else {
        // ????????????????????
        var num = codeProgram.GetMet(curProgram, strParameter).value;
        if (stepRun) {} else {}
    }
    return undefined;
}

function runCodeCompute($command, curProgram, stepRun, handlerNextCommand) {
    var exitCode = null;

    var $spanParameter = $command.find(".spanParameter:first");
    var strParameter = getParameterValue($spanParameter);

    var arrParam = strParameter.split("<-");
    if (arrParam.length != 2) {
        this.ErrorMessage = "Σφάλμα -> " + strStatement;
        console.log("Σφάλμα -> " + strStatement);
        throw this.ErrorMessage;
        return undefined;
    }
    var strParameters1 = $.trim(arrParam[0]);
    var strParameters2 = $.trim(arrParam[1]);
    // remove more than one space
    strParameters2 = strParameters2.replace(/\s\s+/g, ' ');
    // remove space before comma
    strParameters2 = strParameters2.replace(/\s\,/g, ',');
    // remove space after comma
    strParameters2 = strParameters2.replace(/\,\s/g, ',');

    var idx = strParameters2.indexOf('(');
    var strProcedure;
    if (idx != -1) {
        strProcedure = strParameters2.slice(0, idx).trim();
        strParameters2 = strParameters2.slice(idx);
    } else {
        codeProgram.ErrorMessage = "Σφάλμα -> " + strParameters2;
        throw codeProgram.ErrorMessage;
    }

    var $divLine = createNewLine();
    var $spanCommand = $divLine.find(".spanCommand:first");
    $spanCommand.html("Κάλεσε");
    $divLine.find(".spanParameter:first").html(strProcedure + strParameters2);

    exitCode = runCodeProcedure($divLine, curProgram, stepRun);

    // make the assignment
    if (exitCode != null && exitCode.value != null) {
        if ($.type(exitCode.value) == "string")
            var statement = strParameters1 + "<-\"" + exitCode.value + "\"";
        else
            var statement = strParameters1 + "<-" + exitCode.value;
        var ret = makeAssignment(curProgram, statement, stepRun, $spanParameter);

        // call handler if there is step-over execution
        if (handlerNextCommand !== undefined)
            handlerNextCommand(ret, $spanParameter);

        exitCode = null; // consume exitCode
    } else {
        exitCode = null; // consume exitCode
        // call handler if there is step-over execution
        if (handlerNextCommand !== undefined)
            handlerNextCommand(null);
    }

    return exitCode;
}

function* runCodeComputeGenerator($command, curProgram, stepRun, handlerNextCommand) {
    var $spanParameter = $command.find(".spanParameter:first");
    var strParameter = getParameterValue($spanParameter);

    var arrParam = strParameter.split("<-");
    if (arrParam.length != 2) {
        this.ErrorMessage = "Σφάλμα -> " + strStatement;
        console.log("Σφάλμα -> " + strStatement);
        throw this.ErrorMessage;
        return undefined;
    }
    var strParameters1 = $.trim(arrParam[0]);
    var strParameters2 = $.trim(arrParam[1]);
    // remove more than one space
    strParameters2 = strParameters2.replace(/\s\s+/g, ' ');
    // remove space before comma
    strParameters2 = strParameters2.replace(/\s\,/g, ',');
    // remove space after comma
    strParameters2 = strParameters2.replace(/\,\s/g, ',');

    var idx = strParameters2.indexOf('(');
    var strProcedure;
    if (idx != -1) {
        strProcedure = strParameters2.slice(0, idx).trim();
        strParameters2 = strParameters2.slice(idx);
    } else {
        codeProgram.ErrorMessage = "Σφάλμα -> " + strParameters2;
        throw codeProgram.ErrorMessage;
    }

    var $divLine = createNewLine();
    var $spanCommand = $divLine.find(".spanCommand:first");
    $spanCommand.html("Κάλεσε");
    $divLine.find(".spanParameter:first").html(strProcedure + strParameters2);

    $spanParameter.append($divLine);
    $divLine.css("display", "none");

    var codeGen;
    codeGen = runCodeProcedureGenerator($divLine, curProgram, stepRun, handlerNextCommand);
    //codeGenerators.push(codeGen);

    var ret = yield* codeGen;

    // Remove procedure variables from visualization
    $tabVisual.find("*[data-cur-program='" + curCommandRunning.curProgram + "']").remove();

    $divLine.remove();

    // make the assignment
    if (ret != null && ret.value != null) {
        if ($.type(ret.value) == "string")
            var statement = strParameters1 + "<-\"" + ret.value + "\"";
        else
            var statement = strParameters1 + "<-" + ret.value;
        makeAssignment(curProgram, statement, stepRun, $spanParameter, handlerNextCommand);
        ret = null; // return value is consumed here, not to be send to the parent generators

        // don't procced to the next command, until the animation finishes
        bAnimating = true;
        yield null;
    } else
        ret = null; // return value is consumed here, not to be send to the parent generators


    return ret;
}

function runCodeFor($command, curProgram, stepRun) {
    var exitCode = null;

    var $block;

    var $spanParameterCounter = $command.find(".line:first .spanParameter").eq(0);
    var spanParameterCounter = getParameterValue($spanParameterCounter);

    var $spanParameterStart = $command.find(".line:first .spanParameter").eq(1);
    var spanParameterStart = getParameterValue($spanParameterStart);

    var $spanParameterEnd = $command.find(".line:first .spanParameter").eq(2);
    var spanParameterEnd = getParameterValue($spanParameterEnd);

    var $spanParameterStep = $command.find(".line:first .spanParameter").eq(3);
    var spanParameterStep = getParameterValue($spanParameterStep);

    // Start for
    var ret = codeProgram.GetMet(curProgram, spanParameterStart);
    var loopStart = ret.value;
    var ret = makeAssignment(curProgram, spanParameterCounter + "<-" + loopStart, stepRun, $spanParameterStart);
    var metCounter = ret.leftStatement.sourceStatement;

    // End for
    ret = codeProgram.GetMet(curProgram, spanParameterEnd);
    var loopEnd = ret.value;

    // Step for
    var step = codeProgram.GetMet(curProgram, spanParameterStep).value;

    $block = $command.find(".block:first");

    var i = loopStart;
    var forLoopContinued = true;

    if (step > 0) {
        forLoopContinued = (i <= loopEnd)
    } else {
        if (step < 0) {
            forLoopContinued = (i >= loopEnd)
        } else {
            if (i > loopEnd)
                forLoopContinued = false;
            else
                forLoopContinued = true;
        }
    }

    while (forLoopContinued) {
        exitCode = runCode($block, curProgram, stepRun);
        if (exitCode === undefined) {
            throw "Σφάλμα for loop";
        } else if (exitCode !== null)
            return exitCode;

        i += step
        codeProgram.SetMetRaw(metCounter, i);
        //if (loopStart < loopEnd)
        //    forLoopContinued = (i <= loopEnd);
        //else
        //    if (loopStart > loopEnd)
        //        forLoopContinued = (loopEnd <= i);
        //    else
        //        forLoopContinued = false;
        if (step > 0) {
            forLoopContinued = (i <= loopEnd)
        } else {
            if (step < 0) {
                forLoopContinued = (i >= loopEnd)
            } else {
                if (i > loopEnd)
                    forLoopContinued = false;
                else
                    forLoopContinued = true;
            }
        }
    }

    return exitCode;
}

function* runCodeForGenerator($command, curProgram, stepRun, handlerNextCommand) {
    var $block, $blockHeader, $blockEnd;

    var $spanParameterCounter = $command.find(".line:first .spanParameter").eq(0);
    var spanParameterCounter = getParameterValue($spanParameterCounter);

    var $spanParameterStart = $command.find(".line:first .spanParameter").eq(1);
    var spanParameterStart = getParameterValue($spanParameterStart);

    var $spanParameterEnd = $command.find(".line:first .spanParameter").eq(2);
    var spanParameterEnd = getParameterValue($spanParameterEnd);

    var $spanParameterStep = $command.find(".line:first .spanParameter").eq(3);
    var spanParameterStep = getParameterValue($spanParameterStep);


    $blockHeader = $command.find("> .blockHeader:first");
    ret = {
        $command: $blockHeader,
        curProgram: curProgram,
        stepRun: stepRun
    };
    ret = yield ret;
    if (ret != null && ret.stepRun != null)
        stepRun = ret.stepRun;

    // Start for
    var ret1 = codeProgram.GetMet(curProgram, spanParameterStart);
    var loopStart = ret1.value;

    if (stepRun == 2)
        ret1 = makeAssignment(curProgram, spanParameterCounter + "<-" + loopStart, stepRun, $spanParameterStart, undefined);
    else {
        ret1 = makeAssignment(curProgram, spanParameterCounter + "<-" + loopStart, stepRun, $spanParameterStart, handlerNextCommand);
        // don't procced to the next command, until the animation finishes
        bAnimating = true;
    }

    // don't procced to the next command, until the animation finishes
    //bAnimating = true;
    //    ret = yield null;
    //    if (ret != null && ret.stepRun != null)
    //        stepRun = ret.stepRun;

    var metName = codeProgram.GetMetName(ret1.leftStatement.sourceStatement);

    // End for
    ret1 = codeProgram.GetMet(curProgram, spanParameterEnd);
    var loopEnd = ret1.value;

    // Step for
    var step = codeProgram.GetMet(curProgram, spanParameterStep).value;


    $block = $command.find(".block:first");
    //$blockHeader = $command.find(".blockHeader:first");
    $blockEnd = $command.find(".blockEnd:last");

    var i = loopStart;
    var forLoopContinued = true;

    if (step > 0) {
        forLoopContinued = (i <= loopEnd)
    } else {
        if (step < 0) {
            forLoopContinued = (i >= loopEnd)
        } else {
            if (i > loopEnd)
                forLoopContinued = false;
            else
                forLoopContinued = true;
        }
    }

    while (forLoopContinued) {

        var codeGen = runCodeGenerator($block, curProgram, stepRun);
        //codeGenerators.push(codeGen);

        var ret = yield* codeGen;

        ret = {
            $command: $blockEnd,
            curProgram: curProgram,
            stepRun: stepRun
        };
        ret = yield ret;
        if (ret != null && ret.stepRun != null)
            stepRun = ret.stepRun;

        i += step
        if (stepRun == 2){
            ret1 = makeAssignment(curProgram, metName + "<-" + i, stepRun, $spanParameterStep, undefined);
//            if (handlerNextCommand != undefined)
//                handlerNextCommand(null);
        }
        else {
            ret1 = makeAssignment(curProgram, metName + "<-" + i, stepRun, $spanParameterStep, handlerNextCommand);
            // don't procced to the next command, until the animation finishes
            bAnimating = true;
            ret = {
                $command: $blockEnd,
                curProgram: curProgram,
                stepRun: stepRun
            };
            ret = yield ret;
            if (ret != null && ret.stepRun != null)
                stepRun = ret.stepRun;
        }


        ret = {
            $command: $blockHeader,
            curProgram: curProgram,
            stepRun: stepRun
        };
        ret = yield ret;
        if (ret != null && ret.stepRun != null)
            stepRun = ret.stepRun;



        if (step > 0) {
            forLoopContinued = (i <= loopEnd)
        } else {
            if (step < 0) {
                forLoopContinued = (i >= loopEnd)
            } else {
                if (i > loopEnd)
                    forLoopContinued = false;
                else
                    forLoopContinued = true;
            }
        }
    }

    ret = {
        $command: $blockEnd,
        curProgram: curProgram,
        stepRun: stepRun
    };
    ret = yield ret;
    if (ret != null && ret.stepRun != null)
        stepRun = ret.stepRun;

}

function runCodeIf($command, curProgram, stepRun) {
    var exitCode = null;

    var $block;

    if ($command.hasClass("blockCommand"))
        $command = $command.find(".line:first");

    var $spanParameter = $command.find(".spanParameter:first");
    var spanParameter = getParameterValue($spanParameter);

    var strCommand = getCommandValue($command);
    if (strCommand.ddlCommands !== undefined) {
        // There is a dropdown for this line
        strCommand = strCommand.command;
    }

    var cond = codeProgram.CheckCondition(curProgram, spanParameter).value;

    if (cond == true) {
        $block = $command.next(".block:first");
        exitCode = runCode($block, curProgram, stepRun);
        if (exitCode === undefined) {
            throw "Σφάλμα Αν";
        }
    } else {
        $command = $command.nextAll(".blockEndIf:first");
        strCommand = getCommandValue($command);
        if (strCommand.ddlCommands !== undefined) {
            // There is a dropdown for this line
            strCommand = strCommand.command;
        }
        if (strCommand == "Αλλιώς") {
            $block = $command.next(".block:first");
            exitCode = runCode($block, curProgram, stepRun);
            if (exitCode === undefined) {
                throw "Σφάλμα Αλλιώς";
            }
        } else if (strCommand == "Αλλιώς_Αν") {
            exitCode = runCodeIf($command, curProgram, stepRun);
            if (exitCode === undefined) {
                throw "Σφάλμα Αλλιώς_Αν";
            }
        }
    }

    return exitCode;
}

function* runCodeIfGenerator($command, curProgram, stepRun, handlerNextCommand) {
    var $block, $blockHeader, $blockEnd;
    var ret;

    if ($command.hasClass("blockCommand")) {
        $blockHeader = $command.find("> .blockHeader:first");
        ret = {
            $command: $blockHeader,
            curProgram: curProgram,
            stepRun: stepRun
        };
        ret = yield ret;
        if (ret != null && ret.stepRun != null)
            stepRun = ret.stepRun;

        $command = $command.find(".line:first");
    } else
        $blockHeader = $command;

    var $spanParameter = $command.find(".spanParameter:first");
    var spanParameter = getParameterValue($spanParameter);

    var strCommand = getCommandValue($command);
    if (strCommand.ddlCommands !== undefined) {
        // There is a dropdown for this line
        strCommand = strCommand.command;
    }


    if (stepRun == 2) {
        ret = checkCondition(curProgram, spanParameter, stepRun, $spanParameter, undefined);
        var cond = ret.value;
    } else {
        ret = checkCondition(curProgram, spanParameter, stepRun, $spanParameter, handlerNextCommand);
        var cond = ret.value;
        // don't procced to the next command, until the animation finishes
        bAnimating = true;
        ret = {
            $command: $blockHeader,
            curProgram: curProgram,
            stepRun: stepRun
        };
        ret = yield ret;
        if (ret != null && ret.stepRun != null)
            stepRun = ret.stepRun;
    }

    if (cond == true) {
        $block = $command.next(".block:first");
        var codeGen = runCodeGenerator($block, curProgram, stepRun);
        ret = yield* codeGen;

        $blockEnd = $command.nextAll(".blockEndIf:last");
        ret = {
            $command: $blockEnd,
            curProgram: curProgram,
            stepRun: stepRun
        };
        ret = yield ret;
        if (ret != null && ret.stepRun != null)
            stepRun = ret.stepRun;
    } else {
        $command = $command.nextAll(".blockEndIf:first");
        strCommand = getCommandValue($command);
        if (strCommand.ddlCommands !== undefined) {
            // There is a dropdown for this line
            strCommand = strCommand.command;
        }
        if (strCommand == "Αλλιώς") {
            ret = {
                $command: $command,
                curProgram: curProgram,
                stepRun: stepRun
            };
            ret = yield ret;
            if (ret != null && ret.stepRun != null)
                stepRun = ret.stepRun;

            $block = $command.next(".block:first");
            var codeGen = runCodeGenerator($block, curProgram, stepRun);
            ret = yield* codeGen;

            $blockEnd = $command.nextAll(".blockEndIf:last");
            ret = {
                $command: $blockEnd,
                curProgram: curProgram,
                stepRun: stepRun
            };
            ret = yield ret;
            if (ret != null && ret.stepRun != null)
                stepRun = ret.stepRun;


        } else if (strCommand == "Αλλιώς_Αν") {
            //if (stepRun === true){
            ret = {
                $command: $command,
                curProgram: curProgram,
                stepRun: stepRun
            };
            ret = yield ret;
            if (ret != null && ret.stepRun != null)
                stepRun = ret.stepRun;
            //}

            var codeGen;
            codeGen = runCodeIfGenerator($command, curProgram, stepRun, handlerNextCommand);
            //codeGenerators.push(codeGen);

            ret = yield* codeGen;



            // call the next command handler
            //            if (handlerNextCommand !== undefined)
            //                handlerNextCommand(null);
        }

    }
}

function runCodeWhile($command, curProgram, stepRun) {
    var exitCode = null;

    var $block;
    var $spanParameter = $command.find(".line:first .spanParameter:first");
    //var spanParameter = $spanParameter.text().trim();
    var spanParameter = getParameterValue($spanParameter);

    var ret = checkCondition(curProgram, spanParameter, stepRun, $spanParameter);
    var cond = ret.value;

    if (cond == true) {
        $block = $command.children(".block").first();
        while (cond == true) {
            exitCode = runCode($block, curProgram, stepRun);

            if (exitCode === undefined) {
                throw "Σφάλμα while";
            } else if (exitCode !== null) {
                return exitCode;
            }
            ret = checkCondition(curProgram, spanParameter, stepRun, $spanParameter);
            cond = ret.value;
        }
    }

    return exitCode;
}

function* runCodeWhileGenerator($command, curProgram, stepRun, handlerNextCommand) {
    var ret;
    var $block, $blockHeader, $blockEnd;
    var $spanParameter = $command.find(".line:first .spanParameter:first");
    //var spanParameter = $spanParameter.text().trim();
    var spanParameter = getParameterValue($spanParameter);

    $blockHeader = $command.find("> .blockHeader:first");
    ret = {
        $command: $blockHeader,
        curProgram: curProgram,
        stepRun: stepRun
    };
    ret = yield ret;
    if (ret != null && ret.stepRun != null)
        stepRun = ret.stepRun;

    //ret = checkCondition(curProgram, spanParameter, stepRun, $spanParameter, handlerNextCommand);
    if (stepRun == 2)
        ret = checkCondition(curProgram, spanParameter, stepRun, $spanParameter, undefined);
    else {
        ret = checkCondition(curProgram, spanParameter, stepRun, $spanParameter, handlerNextCommand);
        // don't procced to the next command, until the animation finishes
        bAnimating = true;
    }
    var cond = ret.value;

    //    // don't procced to the next command, until the animation finishes
    //    bAnimating = true;
    //    yield null;

    if (cond == true) {
        $block = $command.children(".block").first();
        while (cond == true) {

            var codeGen = runCodeGenerator($block, curProgram, stepRun);
            //codeGenerators.push(codeGen);
            ret = yield* codeGen;

            ret = {
                $command: $blockHeader,
                curProgram: curProgram,
                stepRun: stepRun
            };
            ret = yield ret;
            if (ret != null && ret.stepRun != null)
                stepRun = ret.stepRun;

            //ret = checkCondition(curProgram, spanParameter, stepRun, $spanParameter, handlerNextCommand);
            if (stepRun == 2)
                ret = checkCondition(curProgram, spanParameter, stepRun, $spanParameter, undefined);
            else {
                ret = checkCondition(curProgram, spanParameter, stepRun, $spanParameter, handlerNextCommand);
                // don't procced to the next command, until the animation finishes
                bAnimating = true;
            }
            cond = ret.value;

            // don't procced to the next command, until the animation finishes
            //bAnimating = true;
            //yield null;
        }
    }
    $blockEnd = $command.find("> .blockEnd:last");
    ret = {
        $command: $blockEnd,
        curProgram: curProgram,
        stepRun: stepRun
    };
    ret = yield ret;
    if (ret != null && ret.stepRun != null)
        stepRun = ret.stepRun;
}

function removeParametersParenthesis(spanParameter) {
    if (spanParameter.charAt(0) == "(" && spanParameter.charAt(spanParameter.length - 1) == ")") {
        // Remove ( ) from start, end
        spanParameter = spanParameter.slice(1, spanParameter.length - 1);
        return spanParameter;
    } else {
        codeProgram.ErrorMessage = "Οι παράμετροι πρέπει να εσωκλείονται σε παρενθέσεις -> " + spanParameter;
        throw codeProgram.ErrorMessage;
    }
    return undefined;
}

function runCodeProcedure($command, curProgram, stepRun, handlerNextCommand) {
    var exitCode = undefined;
    var $block;
    var tabId;

    var $spanParameter = $command.find(".spanParameter:first");
    var spanParameter = getParameterValue($spanParameter);

    var idx = spanParameter.indexOf('(');
    var strProcedure;
    if (idx != -1) {
        strProcedure = spanParameter.slice(0, idx).trim();
        spanParameter = spanParameter.slice(idx);
    } else {
        codeProgram.ErrorMessage = "Σφάλμα -> " + strParameters2;
        throw codeProgram.ErrorMessage;
    }
    var $li = $tabsCode.find("ul:first>li[name='" + strProcedure + "']")

    var $tabProcedure = $tabsCode.find($li.find("a:first").attr("href"));


    var $procParams = $tabProcedure.find(".blockHeader:first .spanParameter:first");
    //var strProcParams = $tabProcedure.find(".blockHeader:first .spanParameter:first").text().trim();
    var strProcParams = getParameterValue($procParams);
    var newProgram = $tabProcedure.find("code:first").attr("name");
    var strValues = "";

    var strProgram = curProgram + "." + newProgram;

    if (spanParameter != "" && strProcParams != "") {
        // check for start and end parenthesis in the parameters
        spanParameter = removeParametersParenthesis(spanParameter);
        strProcParams = removeParametersParenthesis(strProcParams);

        var arrProcParams = strProcParams.split(",");
        var arrValues = spanParameter.split(",");
        if (arrValues.length != arrProcParams.length) {
            codeProgram.ErrorMessage = "Λάθος αριθμός παραμέτρων -> " + spanParameter;
            throw codeProgram.ErrorMessage;
        }
        // Create procedure parameters variables
        // Parameters passed by value
        for (var i = 0, len = arrValues.length; i < len; i++) {
            var v;
            var strValMet = $.trim(arrValues[i]);
            var strProcParam = $.trim(arrProcParams[i]);
            if (strProcParam.charAt(0) == "@") {
                // Pass by reference
                var retState;
                retState = codeProgram.ParseStatement(curProgram, strValMet);
                //v = retState.sourceStatement;
                v = retState.evaledStatement;
                codeProgram.SetMet(strProgram, strProcParam, v);
            } else {
                v = codeProgram.GetMet(curProgram, strValMet).value;
                var strAssignment = strProcParam + " <- ";
                if (Array.isArray(v)) {
                    v.shift(); // remove first element(the length of the array)
                    strAssignment += "[" + v.toString() + "]";
                } else
                    strAssignment += v;
                var ret = makeAssignment(strProgram, strAssignment, stepRun, $spanParameter);
            }
        }

        exitCode = runCode($tabProcedure.find(".block:first"), strProgram, stepRun);
        if (handlerNextCommand !== undefined)
            handlerNextCommand(null);
    }


    if (exitCode === undefined) {
        throw "Σφάλμα διαδικασίας";
    }

    return exitCode;

}

function* runCodeProcedureGenerator($command, curProgram, stepRun, handlerNextCommand) {
    var ret = null;
    var $block;

    var tabId;
    var $spanParameter = $command.find(".spanParameter:first");
    var spanParameter = getParameterValue($spanParameter);

    var idx = spanParameter.indexOf('(');
    var strProcedure;
    if (idx != -1) {
        strProcedure = spanParameter.slice(0, idx).trim();
        spanParameter = spanParameter.slice(idx);
    } else {
        codeProgram.ErrorMessage = "Σφάλμα -> " + strParameters2;
        throw codeProgram.ErrorMessage;
    }
    var $li = $tabsCode.find("ul:first>li[name='" + strProcedure + "']")

    var $tabProcedure = $tabsCode.find($li.find("a:first").attr("href"));


    // Is this a call from runCodeComputeGenerator ?
    var $animSource = $command.parent("span.spanParameter:first");
    if ($animSource.length == 0)
        $animSource = $spanParameter;

    var $procParams = $tabProcedure.find(".blockHeader:first .spanParameter:first");
    //var strProcParams = $tabProcedure.find(".blockHeader:first .spanParameter:first").text().trim();
    var strProcParams = getParameterValue($procParams);

    var newProgram = $tabProcedure.find("code:first").attr("name");
    var strValues = "";

    var strProgram = curProgram + "." + newProgram;

    if (spanParameter != "" && strProcParams != "") {
        // check for start and end parenthesis in the parameters
        spanParameter = removeParametersParenthesis(spanParameter);
        strProcParams = removeParametersParenthesis(strProcParams);

        var arrProcParams = strProcParams.split(",");
        var arrValues = spanParameter.split(",");
        if (arrValues.length != arrProcParams.length) {
            codeProgram.ErrorMessage = "Λάθος αριμός παραμέτρων -> " + spanParameter;
            throw codeProgram.ErrorMessage;
        }
        // Create procedure parameters variables
        // Parameters passed by value
        for (var i = 0, len = arrValues.length; i < len; i++) {
            var v;
            var retState;
            var strValMet = $.trim(arrValues[i]);
            var strProcParam = $.trim(arrProcParams[i]);
            var handlerLast = undefined;

            // call the nextCommand handler only for the last parameter
            if (i == len - 1)
                handlerLast = handlerNextCommand;

            if (strProcParam.charAt(0) == "@") {
                retState = codeProgram.ParseStatement(curProgram, strValMet);
                //v = retState.sourceStatement;
                v = retState.evaledStatement;
                codeProgram.SetMet(strProgram, strProcParam, v);
            } else {
                v = codeProgram.GetMet(curProgram, strValMet).value;
                var strAssignment = strProcParam + " <- ";
                if (Array.isArray(v)) {
                    v.shift(); // remove first element(the length of the array)
                    strAssignment += "[" + v.toString() + "]";
                } else
                    strAssignment += v;
                if (stepRun == 2)
                    ret = makeAssignment(strProgram, strAssignment, stepRun, $animSource, undefined);
                else {
                    ret = makeAssignment(strProgram, strAssignment, stepRun, $animSource, handlerLast);
                    // don't procced to the next command, until the animation finishes
                    bAnimating = true;
                }
            }


            if (stepRun) {
                // Is this a reference to another variable?
                if (strProcParam.charAt(0) == "@") {
                    ret = {
                        value: v,
                        leftStatement: {
                            evaledStatement: strProcParam,
                            sourceStatement: retState.sourceStatement
                        }
                    }
                    setVariableVisual(strProgram, ret, $animSource, handlerLast, stepRun);
                }

            }
        }
        //if (stepRun)
        //    showArrayIndexes();
    }

    // don't procced to the next command, until the animation finishes
    //bAnimating = true;
    //yield null;



    var codeGen = runCodeGenerator($tabProcedure.find(".block:first"), strProgram, stepRun);
    //codeGenerators.push(codeGen);

    ret = yield* codeGen;

    $blockEnd = $tabProcedure.find(".blockEnd:last");
    var dummy = {
        $command: $blockEnd,
        curProgram: strProgram,
        stepRun: stepRun
    };
    yield dummy;


    return ret;

}

function runCodeDoWhile($command, curProgram, stepRun) {
    var exitCode = null;
    var $block;
    var $spanParameter = $command.find(".blockFooter:first .spanParameter:first");
    //var spanParameter = $spanParameter.text().trim();
    var spanParameter = getParameterValue($spanParameter);

    var ret = checkCondition(curProgram, spanParameter, stepRun, $spanParameter);
    var cond = ret.value; //codeProgram.CheckCondition(curProgram, spanParameter).value;

    $block = $command.children(".block").first();
    do {
        exitCode = runCode($block, curProgram, stepRun);

        if (exitCode === undefined) {
            throw "Σφάλμα do..while";
        } else if (exitCode !== null)
            return exitCode;

        ret = checkCondition(curProgram, spanParameter, stepRun, $spanParameter);
        cond = ret.value; //codeProgram.CheckCondition(curProgram, spanParameter).value;
    } while (cond == false)

    return exitCode;
}

function* runCodeDoWhileGenerator($command, curProgram, stepRun, handlerNextCommand) {
    var ret;
    var $block, $blockHeader, $blockFooter;
    var $spanParameter = $command.find(".blockFooter:first .spanParameter:first");
    //var spanParameter = $spanParameter.text().trim();
    var spanParameter = getParameterValue($spanParameter);

    var cond; // = codeProgram.CheckCondition(curProgram, spanParameter).value;
    $blockFooter = $command.find("> .blockFooter:first");

    $block = $command.children(".block").first();

    $blockHeader = $command.find("> .blockHeader:first");
    ret = {
        $command: $blockHeader,
        curProgram: curProgram,
        stepRun: stepRun
    };
    ret = yield ret;
    if (ret != null && ret.stepRun != null)
        stepRun = ret.stepRun;
    do {
        //        $blockHeader = $command.find("> .blockHeader:first");
        //        ret = {
        //            $command: $blockHeader,
        //            curProgram: curProgram,
        //            stepRun: stepRun
        //        };
        //        ret = yield ret;
        //        if (ret != null && ret.stepRun != null)
        //            stepRun = ret.stepRun;

        var codeGen = runCodeGenerator($block, curProgram, stepRun);
        //codeGenerators.push(codeGen);
        ret = yield* codeGen;

        ret = {
            $command: $blockFooter,
            curProgram: curProgram,
            stepRun: stepRun
        };
        ret = yield ret;
        if (ret != null && ret.stepRun != null)
            stepRun = ret.stepRun;

        if (stepRun == 2)
            ret = checkCondition(curProgram, spanParameter, stepRun, $spanParameter, undefined);
        else {
            ret = checkCondition(curProgram, spanParameter, stepRun, $spanParameter, handlerNextCommand);
            // don't procced to the next command, until the animation finishes
            bAnimating = true;
        }
        cond = ret.value;

        //        // don't procced to the next command, until the animation finishes
        //        bAnimating = true;
        //        ret = {
        //            $command: null,
        //            curProgram: curProgram,
        //            stepRun: stepRun
        //        };
        //        ret = yield null;
        //        if (ret != null && ret.stepRun != null)
        //            stepRun = ret.stepRun;

        ret = {
            $command: $blockHeader,
            curProgram: curProgram,
            stepRun: stepRun
        };
        ret = yield ret;
        if (ret != null && ret.stepRun != null)
            stepRun = ret.stepRun;

    } while (cond == false)
}

function runCodeLine($command, curProgram, stepRun, handlerNextCommand) {
    var exitCode = null;

    if ($command.hasClass("blockCommand")) {
        var $block;
        var strCommand = getCommandValue($command.find(">.line:first"));
        if (strCommand.ddlCommands !== undefined) {
            // There is a dropdown for this line
            strCommand = strCommand.command;
        }

        var $spanParameter = $command.find(">.line:first .spanParameter:first");
        var spanParameter = getParameterValue($spanParameter);

        if (strCommand == "Για") {
            if (stepRun === true || stepRun == 2) {
                var codeGen;
                codeGen = runCodeForGenerator($command, curProgram, stepRun, handlerNextCommand);
                codeGenerators.push(codeGen);

                // call the next command handler
                if (handlerNextCommand !== undefined)
                    handlerNextCommand(null);
            } else
                exitCode = runCodeFor($command, curProgram, stepRun);
        } else
        if (strCommand == "Αν") {
            if (stepRun === true || stepRun == 2) {
                var codeGen;
                codeGen = runCodeIfGenerator($command, curProgram, stepRun, handlerNextCommand);
                codeGenerators.push(codeGen);

                // call the next command handler
                if (handlerNextCommand !== undefined)
                    handlerNextCommand(null);

            } else
                exitCode = runCodeIf($command, curProgram, stepRun);
        } else
        if (strCommand == "Όσο") {
            if (stepRun === true || stepRun == 2) {
                var codeGen;
                codeGen = runCodeWhileGenerator($command, curProgram, stepRun, handlerNextCommand);
                codeGenerators.push(codeGen);

                // call the next command handler
                if (handlerNextCommand !== undefined)
                    handlerNextCommand(null);
            } else
                exitCode = runCodeWhile($command, curProgram, stepRun);
        } else
        if (strCommand == "Αρχή_Επανάληψης") {
            if (stepRun === true || stepRun == 2) {
                var codeGen;
                codeGen = runCodeDoWhileGenerator($command, curProgram, stepRun, handlerNextCommand);
                codeGenerators.push(codeGen);

                // call the next command handler
                if (handlerNextCommand !== undefined)
                    handlerNextCommand(null);
            } else
                exitCode = runCodeDoWhile($command, curProgram, stepRun);
        }
    } else {
        if ($command.hasClass("line")) {
            //Ignore block header, end lines
            if ($command.hasClass("blockHeader") || $command.hasClass("blockEnd") ||
                $command.hasClass("blockFooter")) {

                // call the next command handler
                if (handlerNextCommand !== undefined)
                    handlerNextCommand(null);

                return null;

            }

            exitCode = parseCommand($command, curProgram, stepRun, handlerNextCommand)
            if (exitCode === undefined) {
                throw codeProgram.ErrorMessage;
            } else if (exitCode !== null) {
                // "επίστρεψε" statement, exit commands block immediately
                return exitCode;
            }
        }
    }

    return exitCode;
}

function runCode($commands, curProgram, stepRun) {
    var exitCode = null;

    $commands.children().each(function (idx) {
        var $command = $(this);
        try {
            exitCode = runCodeLine($command, curProgram, stepRun);
            //"επέστρεψε" statement returns something different than null
            if (exitCode !== null) {
                // return false breaks the each iteration, so runCode exits with the
                // proper value
                return false;
            }
        } catch (e) {
            if (e != "")
                alert(e);
            exitCode = undefined;
            // return false breaks the each iteration, so runCode exits with the
            // proper value
            return false;
        }
    });


    return exitCode;
}

function* runCodeGenerator($commands, curProgram, stepRun) {
    var exitCode = null;
    var $children = $commands.children();

    var codeIt = {};
    codeIt[Symbol.iterator] = function () {
        return {
            _first: true,
            _$command: $children.first(),
            next: function () {
                if (this._first == true) {
                    // if there is an animation happening, do not procced the iterator
                    if (bAnimating)
                        return {
                            value: null,
                            done: false
                        };

                    this._first = false;
                    if (this._$command.length > 0) {
                        var ret = {
                            $command: this._$command,
                            curProgram: curProgram,
                            stepRun: stepRun
                        };
                        return {
                            value: ret,
                            done: false
                        };
                    } else
                        return {
                            value: null,
                            done: true
                        };
                } else {
                    // if there is an animation happening, do not procced the iterator
                    if (bAnimating)
                        return {
                            value: null,
                            done: false
                        };

                    this._$command = this._$command.next();
                    if (this._$command.length > 0) {
                        var ret = {
                            $command: this._$command,
                            curProgram: curProgram,
                            stepRun: stepRun
                        };
                        return {
                            value: ret,
                            done: false
                        };
                    } else
                        return {
                            value: null,
                            done: true
                        };
                }
            }
        };
    };

    var ret;
    for (let value of codeIt) {
        //console.log(value);
        // When yield is called, the codeIt[Symbol.iterator].next function
        // gets evaluated and the value is returned to the caller(generator.next)
        ret = yield value;
        if (ret !== null && ret !== undefined) {
            if (ret.stepRun != null)
                stepRun = ret.stepRun;
            // if yield came with a ret.retValue, this means an "επίστρεψε" statement happened
            if (ret.retValue != null)
                break;
        }
    }
    if (ret !== null && ret !== undefined)
        exitCode = ret.retValue;

    return exitCode;
}

function clearCodeGenerators() {
    for (let codeGen of codeGenerators) {
        codeGen.return(null);
    }
    codeGenerators.length = 0; // clear the array
}

function ExecuteStep(commandIt, handlerNextCommand, stepRun) {
    var $command = commandIt.$command;
    var curProgram = commandIt.curProgram;
    //    if (stepRun == null)
    //        stepRun = commandIt.stepRun;
    try {
        var ret = runCodeLine($command, curProgram, stepRun, handlerNextCommand);
    } catch (e) {
        if (e instanceof InvalidNameError) {
            alert(e.message);
        } else
        if (e != "")
            alert(e);
        return undefined;
    }
    return ret;
}

function getNextCommand(retValue, stepRun) {
    var codeGen;
    var commandIt = undefined;
    var $tabMain = $tabCurProgram.find(".tabMain:first");
    var len = codeGenerators.length;
    var ret = null;
    if (len == 0) {
        resetCode();
        // var $code = $("code", $("#tabMain"));

        //Get the code from the active tab
        var $code = $tabMain.find("code:first");

        var strName = $code.attr("name");
        codeGen = runCodeGenerator($code, strName, true);
        codeGenerators.push(codeGen);
    }
    do {
        commandIt = null;
        len = codeGenerators.length;
        codeGen = codeGenerators[len - 1];

        // If retValue is different from null, the codeGen will be
        // notified to close
        try {
            ret = codeGen.next({
                retValue: retValue,
                stepRun: stepRun
            });
        } catch (e) {
            if (e != "")
                alert(e);

            // error happened, return previous command
            return prevCommandIt;
        }
        //ret = codeGen.next(retValue);


        if (ret.done == true) {
            //codeGen.return(retValue);
            codeGen.return(null);
            codeGenerators.pop();
            if (codeGen instanceof runCodeProcedureGenerator) {
                // Remove procedure variables from visualization
                $tabVisual.find("*[data-cur-program='" + curCommandRunning.curProgram + "']").remove();
            }
        } else {
            commandIt = ret.value;
            if (commandIt === null || commandIt === undefined) {
                // no value returned, return previous command
                return prevCommandIt;
            } else {
                $(".line").removeClass("highlightRunLine");
                $(".blockCommand").removeClass("highlightRunLine");
                $(".blockEnd").removeClass("highlightRunLine");
                commandIt.$command.addClass("highlightRunLine");
                var $tab = commandIt.$command.parents("code:first").parent();
                var strTabId = $tab.attr("id");
                var index = $tabsCode.find('a[href="#' + strTabId + '"]').parent().index();
                $tabsCode.tabs("option", "active", index);

                curCommandRunning = commandIt;

                // Check if line has some message for the user
                var $line = commandIt.$command;
                var message = $line.attr("data-app-message");
                var $tabActive = $tabsCode.find(".ui-tabs-panel").eq(index);
                if (message !== undefined & message != "") {
                    var displayed = $line.attr("data-app-message-displayed");
                    if (autoToolitips && displayed != "true") {
                        showApplicationMessage(message, $line, $tabActive);
                    } else
                        showApplicationMessage("", $line, $tabActive); // hide tooltip
                } else
                    showApplicationMessage("", $line, $tabActive); // hide tooltip

                return commandIt;
            }
        }
    } while (codeGenerators.length > 0)
    return commandIt;
}

function exitFromFunction(retValue, stepRun) {
    var len = codeGenerators.length;
    var codeGen = codeGenerators[len - 1];
    var keepSearching = true;

    while (keepSearching) {
        if (codeGen instanceof runCodeComputeGenerator ||
            codeGen instanceof runCodeProcedureGenerator) {

            keepSearching = false;
            // Call codeGen.next with a value to notify the runCodeGenerator that
            // he must close with this value
            codeGen.next({
                retValue: retValue,
                stepRun: stepRun
            });
        } else {
            if (len > 1) {
                codeGen.return(retValue);
                codeGenerators.pop();
                len = codeGenerators.length;
                codeGen = codeGenerators[len - 1];
            } else {
                // retValue not consumed from the other generators,
                // consume it in main generator
                return retValue;
            }
        }
    }
    // retValue consumed, return null
    return null;
}

function selectDataTab(index) {

    $tabsData.tabs("option", "active", index);

    var $disabled = $tabsData.find("li:nth-child(" + (2 - index).toString() + ")");
    $disabled.removeClass("ui-state-active");
    $disabled.removeClass("ui-tabs-active");
    $disabled.find("a:first").removeClass("ui-btn-active");

    var $enabled = $tabsData.find("li:nth-child(" + (index + 1).toString() + ")");
    $enabled.addClass("ui-state-active");
    $enabled.addClass("ui-tabs-active");
    $enabled.find("a:first").addClass("ui-btn-active");
}

$(document).on('pagecreate', function () {
    //$(document).ready(function () {

    Init();

    // Κουμπί πλαισίου διαλόγου
    $("#btnEnter").click(function () {

    });

    $("#btnPlay").click(function () {
        //var $code = $("code", $("#tabMain"));

        //Get the code from the active tab
        var $code = $tabCurProgram.find(".tabMain:first>code").eq(0);
        var strName = $code.attr("name");

        resetCode();
        var dStart, dEnd;
        console.log("Start execution");

        selectDataTab(1);

        dStart = new Date().getTime();
        runCode($code, strName, false);
        dEnd = new Date().getTime();
        console.log("Time lapsed: " + (dEnd - dStart) + " ms");
        //console.log("lines ->" + $("line", svgManager.root()).length);
    });


    $("#btnStop").click(function () {
        resetCode();
    });


    $("#btnPause").click(function () {

        animPaused = !animPaused;

        if (animPaused) {
            $(".clonedContent").pause();
            $(this).text("Συνέχεια").attr("title", "Συνέχιση εκτέλεσης")

        } else {
            $(".clonedContent").resume();
            $(this).text("Παύση").attr("title", "Παύση εκτέλεσης")
        }


    });


    $("#btnForward, #btnJump").click(function () {

        function proceedToNextStep(ret, stepRun) {
            if (ret !== null) {
                ret = exitFromFunction(ret, stepRun);
            }
            showArrayIndexes();
            bAnimating = false;
            prevCommandIt = getNextCommand(ret, stepRun);
        }

        if (bAnimating)
            return true;

        var $self = $(this);
        var id = $self.prop("id");
        // If there is an animation in progress, do nothing

        var curCommandIt = undefined;
        if (prevCommandIt === undefined) {
            prevCommandIt = getNextCommand(null, true);
            if (prevCommandIt === undefined && codeGenerators.length == 0) {
                resetCode();
            }
        } else {
            curCommandIt = prevCommandIt;
        }

        if (curCommandIt !== null && curCommandIt !== undefined) {
            //jQuery.fx.off = false;
            $(".clonedContent").resume();
            animPaused = false;
            $("#btnPause").text("Παύση").attr("title", "Παύση εκτέλεσης")

            // select visualization tab
            selectDataTab(0);

            bAnimating = true;

            if (id == "btnForward") {
                var ret1 = ExecuteStep(curCommandIt, function (ret) {
                    proceedToNextStep(ret, true);
                }, true);
            } else {
                var ret1 = ExecuteStep(curCommandIt, function (ret, $animSource) {
                    if ($animSource != null) {
                        var curProgram = curCommandIt.curProgram;
                        setVariableVisual(curProgram, ret, $animSource, function (ret) {
                            proceedToNextStep(ret, 2);
                        }, 2);
                    } else {
                        proceedToNextStep(ret, 2);
                    }

                }, 2);
            }
            // ExecuteStep returned error?
            if (ret1 === undefined) {
                bAnimating = false;
            }


        } else {
            if (codeGenerators.length == 0)
                resetCode();
        }

    });

    $("#btnBackward").click(function () {

    });

});


function createRandomArray(strSelector) {
    var num = $("#numArrayItems").val();
    if (num <= 0)
        num = 10;
    if (num > 20)
        num = 20;

    $("#numArrayItems").val(num);

    var right = "[";

    $tabsProgram.find(strSelector).each(function () {
        var $divLine = $(this);
        var $spanParameter = $divLine.find(".spanParameter");
        var spanParameter = getParameterValue($spanParameter);
        var arrParameter;
        var left;
        if (spanParameter.indexOf("<-") == -1) {
            left = "A";
        } else {
            arrParameter = spanParameter.split("<-");
            left = arrParameter[0].trim();
            if (left == "")
                left = "A";
        }

        // if right statement(the array) is empty("[" only), create a new array statement
        if (right == "[") {
            for (var i = 0; i < num; i++) {
                var curNum = getRandomInt(100);
                if (i < num - 1)
                    right += curNum.toString() + ", ";
                else
                    right += curNum.toString() + "]";
            }
        }
        var strNewParameter = left + " <- " + right;
        var $input = $spanParameter.find("input");
        $input.val(strNewParameter);
        $input.change();
    });

}


function Init() {

    var $divHeader = $("#divHeader")
    var bodyH = $(document).height();

    $tabConsole = $("#tabConsole");
    $tabVisual = $("#tabVisual");
    $tabsData = $("#DataTabs");
    $tabsProgram = $("#ProgramTabs");

    $tabCurProgram = $("#LeftTab1");
    $tabsCode = $tabCurProgram.find(".tabsCode:first");
    $ddlCommandsHidden = $("#ddlCommandsHidden");
    $ddlCommandsHiddenIf = $("#ddlCommandsHiddenIf");

    $tabsProgram.on("tabsactivate", function (event, ui) {
        var $newPanel = ui.newPanel;

        $tabCurProgram = ui.newPanel;
        $tabsCode = $tabCurProgram.find(".tabsCode:first");
        resetCode();

    });

    // Prevent the change tab event to bubble to the parent tab(ProgramTabs)
    $(".tabsCode").on("tabsactivate", function (event, ui) {
        event.stopPropagation();
    });

    // $tabsCode.tabs("option", "active", 0);
    // $tabsData.tabs("option", "active", 0);

    // control the height of codePanel and tabConsole through css variable
    $(window).resize(function () {
        var strH = $divHeader.height();
        var bodyStyles = document.body.style;
        bodyStyles.setProperty('--header_height', strH + "px");
    });

    setTimeout(function () {
        $(window).resize();
    }, 100);

    $tabsData.on("tabsactivate", function (event, ui) {
        var $newPanel = ui.newPanel;
        // If we switched to visualization, reshow indexes
        if ($newPanel.attr("id") == "tabVisual") {
            showArrayIndexes();
        }
    });

    $("#cbAutoTooltips").prop("checked", autoToolitips).checkboxradio("refresh");;
    //$("#cbAutoTooltips").val(autoToolitips);
    //$("#cbAutoTooltips").change();
    $("#cbAutoTooltips").bind("change", function (event, ui) {
        autoToolitips = $(this).prop("checked");
    });

    $("#slideSpeed").bind("change", function (event, ui) {
        var maxSpeed = Number($(this).attr("max"));
        animSpeed = maxSpeed - $(this).val();
        if (animSpeed < 50)
            animSpeed = 50;
    });

    // create only the info button for the lines(if any)
    //createLineEvents($tabsProgram.find(".line"), true);
    //createLineEvents($tabsProgram.find(".blockEnd"), true);

    createLineEvents($tabsProgram.find("#LeftTab1:first .line"), {
        showAdd: true,
        showDel: true
    });
    createCommandsDropdown($tabsProgram.find("#LeftTab1:first .line"), $ddlCommandsHidden);
    createParameters($tabsProgram.find("#LeftTab1:first .line"));

    createLineEvents($tabsProgram.find("#LeftTab2:first .line"), {
        showAdd: true,
        showDel: true
    });
    createCommandsDropdown($tabsProgram.find("#LeftTab2:first .line"), $ddlCommandsHidden);
    createParameters($tabsProgram.find("#LeftTab2:first .line"));

    createLineEvents($tabsProgram.find("#LeftTab3:first .line"), {
        showAdd: true,
        showDel: true
    });
    createCommandsDropdown($tabsProgram.find("#LeftTab3:first .line"), $ddlCommandsHidden);
    createParameters($tabsProgram.find("#LeftTab3:first .line"));

    createLineEvents($tabsProgram.find("#LeftTab4:first .line"), {
        showAdd: true,
        showDel: true
    });
    createCommandsDropdown($tabsProgram.find("#LeftTab4:first .line"), $ddlCommandsHidden);
    createParameters($tabsProgram.find("#LeftTab4:first .line"));


    //
    //    createLineEvents($tabsProgram.find("#LeftTab4:first .line"),
    //        { showAdd: false, showDel: false });
    //    createCommandsDropdown($tabsProgram.find("#LeftTab4:first .line"));
    //    createParameters($tabsProgram.find("#LeftTab4:first .line"));
    //
    //    createLineEvents($tabsProgram.find("#LeftTab5:first .line"),
    //        { showAdd: false, showDel: false });
    //    createCommandsDropdown($tabsProgram.find("#LeftTab5:first .line"));
    //    createParameters($tabsProgram.find("#LeftTab5:first .line"));


    //createLineEvents($tabsProgram.find("#LeftTab3:first .line"), false);


    //createCommandsDropdown($tabsProgram.find(".line.editableCommand"));

    //createParameters($tabsProgram.find(".line.editableParameter"));

    $("#btnRandomArray").click(function () {
        createRandomArray(".randomArray");
    });
}


function resetCode() {
    $tabConsole.html("");

    codeProgram.Clear();
    clearCodeGenerators();

    var $line = $(".line");
    $(".line, .blockEnd, .blockCommand").removeClass("highlightRunLine");
    $line.removeClass("highlightRunLine");
    $(".blockCommand").removeClass("highlightRunLine");
    prevCommandIt = undefined;
    curCommandRunning = undefined;
    $tabVisual.html("");
    if ($appTooltip !== undefined) {
        $appTooltip.find(".message:first").html("");
        $appTooltip.hide();
    }
    $line.removeAttr("data-app-message-displayed");

    //jQuery.fx.off = true;
    $(".clonedContent").stop(true);
    $(".clonedContent").clearQueue();
    $(".clonedContent").remove();
    animPaused = false;
    bAnimating = false;
    $("#btnPause").text("Παύση").attr("title", "Παύση εκτέλεσης")

    //if (timeoutID != -1)
    //    clearInterval(timeoutID);
    //timeoutID = -1;
    //$poolLine = undefined;
    //ToggleAutoControls(false);

}

function createButtonInfo($divLine, base) {
    var strInfo = $divLine.attr("data-app-message")
    if (strInfo !== undefined && strInfo != "") {
        var $btnInfo = $divLine.find(".btnInfo");
        if ($btnInfo.length == 0) {
            $btnInfo = $('<button class="btnLine btnInfo" title="Πληροφορίες">i</button>');
            $divLine.append($btnInfo);
            base -= 20;
            $btnInfo.css("left", base + "px");
            $btnInfo.click(function () {
                //var $tabMain = $tabCurProgram.find(".tabMain:first");
                var tabIdx = $tabsCode.tabs("option", "active");
                var $tabActive = $tabsCode.find(".ui-tabs-panel").eq(tabIdx);

                showApplicationMessage(strInfo, $divLine, $tabActive);
            });
        }
    }
    return base;
}

function createButtonTask($divLine, base) {
    var strTask = $divLine.attr("data-app-task")
    if (strTask !== undefined && strTask != "") {
        var $btnTask = $divLine.find(".btnTask");
        if ($btnTask.length == 0) {
            $btnTask = $('<button class="btnLine btnTask" title="Εργασία">?</button>');
            $divLine.append($btnTask);
            base -= 20;
            $btnTask.css("left", base + "px");
            $btnTask.click(function () {
                //var $tabMain = $tabCurProgram.find(".tabMain:first");
                var tabIdx = $tabsCode.tabs("option", "active");
                var $tabActive = $tabsCode.find(".ui-tabs-panel").eq(tabIdx);
                var strSolution = $divLine.attr("data-app-solution");

                showApplicationMessage(strTask, $divLine, $tabActive, strSolution);
            });
        }
    }
    return base;
}

function createLineButtons($divLine, options) {
    // get active tab
    var tabIdx = $tabsCode.tabs("option", "active");
    var $tabActive = $tabsCode.find(".ui-tabs-panel").eq(tabIdx);
    var w = $tabActive.width();

    var showInfo = true;
    var showTask = true;
    var showAdd = true;
    var showDel = true;
    if (options != undefined) {
        if (options.showAdd != undefined)
            showAdd = options.showAdd;
        if (options.showDel != undefined)
            showDel = options.showDel;
    }

    $divLine.each(function () {
        var $self = $(this);
        var pos = $self.position();
        var base = w - pos.left;

        if ($tabActive.hasScrollBar().vertical)
            base = base - 20;

        // Button info
        if (showInfo)
            base = createButtonInfo($self, base);

        // Button task
        if (showTask)
            base = createButtonTask($self, base);


        // Button add
        if (showAdd) {
            var $btnAdd = $self.find(".btnAdd");
            if ($btnAdd.length == 0) {
                $btnAdd = $('<button class="btnLine btnAdd" title="Προσθήκη γραμμής">+</button>');
                $self.append($btnAdd);
                base -= 20;
                $btnAdd.css("left", base + "px");
                $btnAdd.click(function () {
                    var $ret = createCommand("Γράψε");
                    if ($self.hasClass("blockHeader"))
                        $self.next(".block:first").prepend($ret);
                    else
                    if ($self.hasClass("blockFooter"))
                        // insert after(outside) the div.blockCommand
                        $self.parent(".blockCommand:first").after($ret);
                    else
                    if ($self.hasClass("blockEnd")) {
                        var $block = $self.next(".block:first");
                        if ($block.length > 0)
                            $block.prepend($ret);
                        else {
                            // insert after(outside) the div.blockCommand
                            $self.parent(".blockCommand:first").after($ret);
                        }
                    } else
                        $self.after($ret);

                    createLineEvents($ret);

                });
            }
        }

        if (showDel) {
            // If its a .blockEnd line, don't add any other buttons
            if ($self.hasClass("blockEnd"))
                return;

            // if it is the first line of the code
            var $parent = $self.first().parent(":first");
            if ($parent.hasClass("program") || $parent.hasClass("procedure") || $parent.hasClass("function"))
                if ($self.first().index() == 0)
                    return;

            // Button delete
            var $btnDel = $self.find(".btnDel");
            if ($btnDel.length == 0) {
                $btnDel = $('<button class="btnLine btnDel" title="Διαγραφή γραμμής">-</button>');
                $self.append($btnDel);
                base -= 20;
                $btnDel.css("left", base + "px");
                $btnDel.click(function () {
                    var $blockCommand = $self.parent(".blockCommand:first");
                    if ($blockCommand.length > 0) {
                        if (confirm("Όλες οι εντολές θα διαγραφούν. Είστε σίγουροι?"))
                            $blockCommand.remove();
                    } else {
                        if (confirm("Η γραμμή θα διαγραφεί. Είστε σίγουροι?"))
                            $self.remove();
                    }
                });
            }
        }

    });



}

function createLineEvents($divLine, options) {

    //if (bInfoOnly === undefined)
    //    bInfoOnly = false;

    $divLine.hover(function () {
            //$(this).addClass("highlightLine");
            var lineOptions = $(this).attr("data-show-options");
            if (lineOptions !== undefined && lineOptions != "") {
                var objOptions = obj = eval('({' + lineOptions + '})');;
                createLineButtons($(this), objOptions);
            } else
                createLineButtons($(this), options);
        },
        function () {
            //$(this).removeClass("highlightLine");

            // remove all line buttons
            $(this).find(".btnLine").remove();
        });

    if (options == undefined)
        createLineCommandParam($divLine);
}


function createCommand(strCommand) {
    var $block, $divLine;
    var $block = $('<div class="blockCommand"></div>');
    var ret;
    var strMarkup;

    switch (strCommand) {
        case "Αλλιώς_Αν":
            strMarkup = '<div class="line blockEnd blockEndIf"><span class="spanCommand spanCommandExtra">Αλλιώς_Αν</span><span class="spanParameter spanParameterExtra">....</span><span class="spanCommandExtra">Τότε</span></div>';
            strMarkup += '<div class="block"></div>';
            $divLine = $(strMarkup);
            ret = $divLine;
            break;
        case "Τέλος_Αν":
            strMarkup = '<div class="block"></div>';
            strMarkup += '<div class="line blockEnd blockEndIf"><span class="spanCommand spanCommandExtra">Τέλος_Αν</span>\n</div>';
            $divLine = $(strMarkup);
            ret = $divLine;
            break;
        case "Αλλιώς":
            strMarkup = '<div class="line blockEnd blockEndIf"><span class="spanCommand spanCommandExtra">Αλλιώς</span>\n</div>';
            strMarkup += '<div class="block"></div>';
            $divLine = $(strMarkup);
            ret = $divLine;
            break;
        case "Για":
            strMarkup = '<div class="line blockHeader"><span class="spanCommand">Για</span>';
            strMarkup += '<span class="spanParameter">....</span>&nbsp;';
            strMarkup += '<span class="spanCommandExtra">Από</span>';
            strMarkup += '<span class="spanParameter">....</span>&nbsp;';
            strMarkup += '<span class="spanCommandExtra">Μέχρι</span>';
            strMarkup += '<span class="spanParameter">....</span>&nbsp;';
            strMarkup += '<span class="spanCommandExtra">Με_Βήμα</span>';
            strMarkup += '<span class="spanParameter">1</span>';
            strMarkup += '</div>';
            strMarkup += '<div class="block">';
            //strMarkup += '<div class="line"><span class="spanCommand">Γράψε</span><span class="spanParameter">....</span></div>';
            strMarkup += '</div>';
            strMarkup += '<div class="line blockEnd">Τέλος_Επανάληψης</div>';
            $divLine = $(strMarkup);
            $block.append($divLine);
            ret = $block;
            break;
        case "Αν":
            strMarkup = '<div class="line blockHeader"><span class="spanCommand">' + strCommand + '</span>';
            strMarkup += '<span class="spanParameter">....</span><span class="spanCommandExtra">Τότε</span>';
            strMarkup += '</div>';
            strMarkup += '<div class="block">';
            //strMarkup += '<div class="line"><span class="spanCommand">Γράψε</span><span class="spanParameter">....</span></div>';
            strMarkup += '</div>';

            strMarkup += '<div class="line blockEnd blockEndIf"><span class="spanCommand spanCommandExtra">Τέλος_Αν</span></div>';
            $divLine = $(strMarkup);
            $block.append($divLine);
            ret = $block;
            break;
        case "Όσο":
            strMarkup = '<div class="line blockHeader"><span class="spanCommand">Όσο</span>';
            strMarkup += '<span class="spanParameter">....</span>&nbsp;';
            strMarkup += '<span class="spanCommandExtra">Επανάλαβε</span>';
            strMarkup += '</div>';
            strMarkup += '<div class="block">';
            //strMarkup += '<div class="line"><span class="spanCommand">Γράψε</span><span class="spanParameter">....</span></div>';
            strMarkup += '</div>';
            strMarkup += '<div class="line blockEnd">Τέλος_Επανάληψης</div>';
            $divLine = $(strMarkup);
            $block.append($divLine);
            ret = $block;
            break;
        case "Αρχή_Επανάληψης":
            strMarkup = '<div class="line blockHeader"><span class="spanCommand">Αρχή_Επανάληψης</span>';
            strMarkup += '</div>';
            strMarkup += '<div class="block">';
            //strMarkup += '<div class="line"><span class="spanCommand">Γράψε</span><span class="spanParameter">....</span></div>';
            strMarkup += '</div>';
            strMarkup += '<div class="line blockFooter"><span class="spanCommandExtra">Μέχρις_Ότου</span><span class="spanParameter">....</span></div>';
            $divLine = $(strMarkup);
            $block.append($divLine);
            ret = $block;
            break;
        case "":
        case "Γράψε":
        case "Κάλεσε":
        case "Διάβασε":
            strMarkup = '<div class="line"><span class="spanCommand">' + strCommand + '</span>\n<span class="spanParameter">....</span></div>';
            $divLine = $(strMarkup);
            ret = $divLine;
            break;
        default:
            strMarkup = '<div class="line"><span class="spanCommand">' + strCommand + '</span><span class="spanParameter">....</span></div>';
            $divLine = $(strMarkup);
            ret = $divLine;
            break;
    }
    return ret;
}

function changeCommand($divLine, strOldCommand, strNewCommand) {
    var ret = true;
    var $spanParameter = $divLine.find(".spanParameter:first");
    var $input = $spanParameter.find("input:first");
    var strParameter;
    if ($input.length > 0)
        strParameter = $input.val();
    else
        strParameter = $spanParameter.text();

    switch (strNewCommand) {
        case "Αλλιώς":
            if (strOldCommand == "Τέλος_Αν"){
                var $ret = createCommand(strOldCommand);
                $divLine.after($ret);
                createLineEvents($ret.eq(1));
                // remove all lines after Τέλος_Αν
                //$ret.eq(1).nextAll(".block, .blockEndIf").remove();
            } else {
                $divLine.find(".spanParameter").remove();               //remove parameter
                $divLine.find(".spanCommandExtra:last").remove();       //remove Τότε
                var $end_if = $divLine.nextAll(".blockEndIf:last"); // find the last Τέλος_Αν
                $divLine.next(".block").after($end_if); // make Τέλος_Αν the end of the block
                $end_if.nextAll(".block, .blockEndIf").remove(); // remove all lines after Τέλος_Αν
            }
            break;
        case "Αλλιώς_Αν":
            if (strOldCommand == "Τέλος_Αν"){
                // create Τέλος_Αν command and add it after the Αλλιώς_Αν
                var $ret = createCommand(strOldCommand);
                $divLine.after($ret);
                createLineEvents($ret.eq(1));
                $divLine.append('<span class="spanParameter spanParameterExtra">....</span>');
                $divLine.append('<span class="spanCommandExtra">Τότε</span>');
                createParameters($divLine);
            } else {
                $divLine.append('<span class="spanParameter spanParameterExtra">....</span>');
                $divLine.append('<span class="spanCommandExtra">Τότε</span>');
                createParameters($divLine);
            }
            break;
        case "Τέλος_Αν":
            $divLine.find(".spanParameter").remove();               //remove parameter
            $divLine.find(".spanCommandExtra:not(:first-child)").remove();       //remove Τότε
            $divLine.nextAll(".block, .blockEndIf").remove();       // remove all lines after Τέλος_Αν
            break;
        default:
            // Is it a block command ?
            var $blockCommand = $divLine.parent(".blockCommand:first");
            if ($blockCommand.length > 0) {
                var ans = confirm("Όλες οι εσωτερικές εντολές θα σβηστούν. Είστε σίγουροι?");
                ret = ans;
                if (ans) {
                    var $ret = createCommand(strNewCommand);
                    $blockCommand.before($ret);
                    if ($ret.hasClass("blockCommand")) {
                        createLineEvents($ret.find(".line"));
                        //                createLineEvents($ret.find(".blockEnd"));
                    } else
                        createLineEvents($ret);

                    $blockCommand.remove();
                }
            } else {
                // Insert new line only if the new is a block command
                var $ret = createCommand(strNewCommand);
                if ($ret.hasClass("blockCommand")) {
                    $divLine.before($ret);
                    createLineEvents($ret.find(".line"));
                    //createLineEvents($ret.find(".blockEnd"));
                    $divLine.remove();
                } else {
                    if (strOldCommand == "") {
                        $spanParameter.css("left", "0px");
                    }
                    if (strNewCommand == "") {
                        var $spanParameterNew = $ret.find(".spanParameter:first");
                        $spanParameterNew.html(strParameter);
                    }
                    $divLine.before($ret);
                    createLineEvents($ret);
                    $divLine.remove();
                }
            }
    }


    return ret;
}

function createCommandsDropdown($divLine, $curDdlCommandsHidden) {
    // Get the dropdown commands for the else, else_if, end_if
    $divLine.each(function (index) {
        var $parent = $(this);

        // create commands dropdown
        var blockEndIf = $parent.hasClass("blockEndIf");
        var $spanParameters = $parent.find(".spanParameter:first");
        var $spanCommand = $parent.find(".spanCommand");
        $spanCommand.removeClass("hidden");

        var strCommand = $spanCommand.text().trim();
        var w = strCommand.length * 8 + 16;

        // if no command specified, switch position with parameters, so they became first in line
        //        if (strCommand == ""){
        //            $spanCommand.insertAfter($spanParameters);
        //        }

        var $ddlCommands = $('<select data-role="none" class="ddlCommands" data-native-menu="false"></select>');
        var strCommandsHidden;
        if (blockEndIf)
            strCommandsHidden = $ddlCommandsHiddenIf.html();
        else
            strCommandsHidden = $curDdlCommandsHidden.html();

        var $options = $(strCommandsHidden);
        $ddlCommands.append($options);
        $spanCommand.html("");
        $spanCommand.addClass("noPadding");
        $spanCommand.append($ddlCommands);
        //$ddlCommands.width(w - 4);
        $ddlCommands.css("width", (strCommand.length + 2) + "ch");
        $ddlCommands.attr("data-command", strCommand);
        var $command = $ddlCommands.find("option[name='" + strCommand + "']");
        $command.attr("selected", "selected");

        $ddlCommands.change(function (e) {
            var strCommandOld = $ddlCommands.attr("data-command");
            //strCommand = $(this).val();         // val() holds the tab-ID, not the name
            var $optSelected = $(this).find("option:selected");
            strCommand = $optSelected.attr("name");

            if (changeCommand($parent, strCommandOld, strCommand)) {
                w = strCommand.length * 8 + 16;
                $(this).width(w);
                $(this).css("width", (strCommand.length + 2) + "ch");
                $(this).attr("data-command", strCommand);

            } else {
                // Undo command change
                var $command = $(this).find("option[name='" + strCommandOld + "']");
                var oldValue = $command.attr("value");
                $(this).val(oldValue);
                $(this).attr("data-command", strCommandOld);
            }

        });
    });
}

function createParameters($divLine) {
    $divLine.each(function (index) {
        var $parent = $(this);
        // create edit boxes for the spanparameters
        var $spanParameters = $parent.find(".spanParameter");
        var $spanCommand = $parent.find(".spanCommand");
        var $spanCommandExtra = $parent.find(".spanCommandExtra");
        var $ddlCommands = $spanCommand.find(".ddlCommands:first");
        var strCommand = ($ddlCommands.length > 0) ? $ddlCommands.val().trim() : $spanCommand.text().trim();
        var strCommandExtra = $spanCommandExtra.text().trim();

        $spanParameters.each(function (index) {
            var $spanParameter = $(this);
            var paramWidth;
            var paramValue = $spanParameter.text().trim();
            paramWidth = paramValue.length * 8 + 8;
            if (paramWidth < 8)
                paramWidth = 8;
            paramValue = encodeURI(paramValue);

            var $paramInput = $('<input  data-role="none" type="text" class="paramInput" value="">');
            paramValue = decodeURI(paramValue);
            $paramInput.val(paramValue);
            //$paramInput.width(paramWidth);
            $paramInput.css("width", (paramValue.length + 2) + "ch");
            $spanParameter.html("");
            $spanParameter.append($paramInput);

            var inputWidth = 0;

            // if strCommand is nothing, then spanParameter must go at the start of the line
            // and this parameter is not at the header of a function or procedure
            if (strCommand == "" && !$parent.hasClass("functionHeader") &&
                !$parent.hasClass("procedureHeader") &&
                strCommandExtra != "Μέχρις_Ότου") {
                inputWidth = $paramInput.outerWidth(false);
                $ddlCommands.width(inputWidth + 10);
                $spanParameter.css("left", -inputWidth - 22 + "px");
                //$spanParameter.position().left = $spanCommand.position().left;
            }

            $paramInput.on("keydown", function () {
                $(this).change();
            });

            $paramInput.on("change", function () {
                paramValue = $(this).val(); // no trim, keep spaces for computation
                paramWidth = paramValue.length * 8 + 8;
                if (paramWidth < 8)
                    paramWidth = 8;
                //$(this).width(paramWidth);
                $(this).css("width", (paramValue.length + 2) + "ch");

                // if strCommand is nothing, then spanParameter must go at the start of the line
                // only if not a function or procedure header
                strCommand = ($ddlCommands.length > 0) ? $ddlCommands.val().trim() : $spanCommand.text().trim();
                strCommandExtra = $spanCommandExtra.text().trim();
                if (strCommand == "" && strCommandExtra != "Μέχρις_Ότου") {
                    var $lineParent = $(this).parents(".line:first");
                    if ($lineParent.hasClass("functionHeader") || $lineParent.hasClass("procedureHeader"))
                        return true;
                    inputWidth = $(this).outerWidth(false);
                    $ddlCommands.width(inputWidth + 10);
                    $spanParameter.css("left", -inputWidth - 22 + "px");
                    //$spanParameter.position().left = $spanCommand.position().left;
                }
            });
        });
    });
}



function createLineCommandParam($divLine) {
    var $leftTabPanel = $divLine.parents(".LeftTabPanel:first");
    $divLine.each(function (index) {
        var $parent = $(this);

        // create commands dropdown
        createCommandsDropdown($parent, $ddlCommandsHidden);

        // create edit boxes for the spanparameters
        createParameters($parent);
    });

}

function removeLineControls($divLine) {
    $divLine.each(function (index) {
        var $parent = $(this);


    });

}
