//debugger;
"use strict";

class ExtendableError extends Error {
    constructor(message) {
        super(message);
        this.name = this.constructor.name;
        if (typeof Error.captureStackTrace === 'function') {
            Error.captureStackTrace(this, this.constructor);
        } else {
            this.stack = (new Error(message)).stack;
        }
    }
}

// now I can extend

class InvalidNameError extends ExtendableError {}



String.prototype.replaceAll = function (str1, str2) {
    //return this.replace(new RegExp(str1.replace(/([\/\,\!\\\^\$\{\}\[\]\(\)\.\*\+\?\|\<\>\-\&])/g, "\\$&"), (ignore ? "gi" : "g")), (typeof (str2) == "string") ? str2.replace(/\$/g, "$$$$") : str2);

    //var strSource = this.replace(/[-\\()\[\]{}^$*+.?|]/g, '\\$&');
    // (?!\s)αληθης(\s?)?

    // (^|\s|\()(οχι)(?=\s|$)

    //var strExpr = '(?!\\+-\\*\\/\\(\\)><=!\\|&\\[\\],\\s)' + str1 + '(?=[+\\-*/()><=!|&\\s,\\[\\]]|$)'
    var strExpr = '(^|\\s|=|\\()(' + str1 + ')(?=\\s|\\)|$)';

    var regex = new RegExp(strExpr, "gi");
    return this.replace(regex, "$1" + str2);
};

function checkName(strMet) {
    var reInvalidChars = /[\+\-\*\/\(\)><=!\|&\[\],\s\"\'\.\?;~\^#%\\΄:{}`]/gi;
    var strInvalidFirstChars = "1234567890";

    // check for @ operator
    var idx = strMet.indexOf('@');
    if (idx > 0) {
        return ["@"];
    }
    if (strMet == "div")
        return ["div"];
    if (strMet == "mod")
        return ["mod"];
    var found = strMet.match(reInvalidChars);

    if (found == null) {
        // Check for invalid start of name (numeric digits)
        var reInvalidFirstChar = /^[0-9]/;
        found = strMet.match(reInvalidFirstChar);
    }
    return found;
}

function CodeSandBox() {
    this.metavlites = {};
    this.ErrorMessage = "";
}



CodeSandBox.prototype.GetMetRawType = function (strMetRaw) {
    try {
        var val = eval(strMetRaw);
        return $.type(val);
    } catch (e) {
        this.ErrorMessage = "GetMetRawType -> Σφάλμα στη μεταβλητή " + strMetRaw;
        throw this.ErrorMessage;
        return undefined;
    }
}


CodeSandBox.prototype.evalStatement = function (strRawStatement) {
    'use strict';
    return eval(strRawStatement);
};



CodeSandBox.prototype.extractVariables = function (strStatement) {
    var strCleaned = strStatement.replace(/this.metavlites/g, "");
    var arrPieces = this.parseArrayStatement(strCleaned);
    var arrVariables = [];
    for (var i = 0; i < arrPieces.length; i++) {
        // If piece is surrounded by [ ] , then it is a variable or an array of values
        var strPiece = arrPieces[i].trim();
        if (strPiece.charAt(0) == "[" && strPiece.charAt(strPiece.length - 1) == "]") {
            try {
                // Is this a variable ?
                var strVar = "this.metavlites" + strPiece;
                var type = this.GetMetRawType(strVar);

                if (type === "undefined") {
                    // It is not a variable, is it an array of values?
                    var arr = JSON.parse(strPiece);
                    // IF we pass the JSON.parse, then strPiece is an
                    // array of values(array declaration)
                    arrVariables.push(strPiece);
                } else {
                    // This is a variable
                    // Is this variable an array or ?
                    if (type === "array") {
                        // check for array accessors
                        while (i < arrPieces.length - 1) {
                            i++;
                            var strAccessorPiece = arrPieces[i];
                            // Is it an array accessor ?
                            if (strAccessorPiece.charAt(0) == "[" && strAccessorPiece.charAt(strAccessorPiece.length - 1) == "]") {
                                strVar += strAccessorPiece;
                            } else {
                                i--; // roll back to check i-th position again
                                break; // no more indexes to check for this array
                            }
                        }
                    }
                    arrVariables.push(strVar);
                }
            } catch (e) {
                throw this.ErrorMessage;
            }
        } else
            arrVariables.push(strPiece);
    }
    return arrVariables;
}

CodeSandBox.prototype.parseArrayStatement = function (strMetRaw) {
    var ret = strMetRaw;
    //ret = ret.replace(/this.metavlites\[/g, "");
    //ret = ret.replace(/'\]/g, "'");

    var level = 0;
    var str = "";
    var arrPieces = [];
    for (var ch of ret) {
        if (ch == "[") {
            if (level == 0 && str != "") {
                arrPieces.push(str);
                str = "";
            }
            level++;
            str += ch;
        } else
        if (ch == "]") {
            str += ch;
            level--;
            if (level == 0 && str != "") {
                arrPieces.push(str);
                str = "";
            }
        } else
            str += ch;
    }
    if (str != "") {
        arrPieces.push(str);
    }
    // Remove [ ] from start, end
    //for (var i = 1; i < arrPieces.length; i++) {
    //    arrPieces[i] = arrPieces[i].slice(1, arrPieces[i].length - 1);
    //}

    return arrPieces;
}

CodeSandBox.prototype.GetMetName = function (strMetRaw) {
    var dot = strMetRaw.lastIndexOf('.');
    var quote = strMetRaw.lastIndexOf('"');
    var name = strMetRaw.slice(dot + 1, quote);
    return name;
};

CodeSandBox.prototype.SetMet = function (strScope, strMet, value) {
    var found = checkName(strMet);
    if (found != null) {
        this.ErrorMessage = "Σφάλμα στο όνομα της μεταβλητής -> " + strMet;
        throw new InvalidNameError(this.ErrorMessage);
    }
    var met = strScope + "." + strMet;
    this.metavlites[met] = (value == null) ? 0 : value;
    return met;
};

CodeSandBox.prototype.SetMetRaw = function (strMetRaw, value) {
    //this.metavlites[met] = (value == null) ? 0 : value;
    try {
        var ret = eval(strMetRaw + "=" + value);
        return ret;
    } catch (e) {
        this.ErrorMessage = "SetMetRaw -> Συντακτικό σφάλμα";
        throw this.ErrorMessage;
        return undefined;
    }
};

CodeSandBox.prototype.GetMetRaw = function (strMetRaw) {
    //return this.metavlites[strMet];
    try {
        var ret = eval(strMetRaw);
        return ret;
    } catch (e) {
        this.ErrorMessage = "GetMetRaw -> Συντακτικό σφάλμα";
        throw this.ErrorMessage;
        return undefined;
    }
};

CodeSandBox.prototype.GetMet = function (strScope, strMet) {
    var newStatement;
    if ($.isNumeric(strMet))
        return {
            value: Number(strMet),
            statement: newStatement
        };;
    var met = strScope + "." + strMet;
    try {
        newStatement = this.ParseStatement(strScope, strMet);
    } catch (e) {
        if (e instanceof InvalidNameError) {
            this.ErrorMessage = e.message;
            throw this.ErrorMessage;
        }
        try {
            newStatement = this.ParseStatement("Κεντρικό", strMet);
        } catch (e) {
            if (e instanceof InvalidNameError) {
                this.ErrorMessage = e.message;
                throw this.ErrorMessage;
            }
            this.ErrorMessage = "Άγνωστη μεταβλητή ->" + strMet;
            throw this.ErrorMessage;
        }
    }
    try {
        var ret = eval(newStatement.evaledStatement);
        return {
            value: ret,
            statement: newStatement
        };
    } catch (e) {
        this.ErrorMessage = "Άγνωστη μεταβλητή ->" + strMet;
        throw this.ErrorMessage;
    }
}

CodeSandBox.prototype.MetToString = function (strScope, strMet) {
    var found = checkName(strMet);
    if (found != null) {
        this.ErrorMessage = "Σφάλμα στο όνομα της μεταβλητής -> " + strMet;
        throw new InvalidNameError(this.ErrorMessage);
    }

    var met = strScope + "." + strMet;


    // Pass by reference check
    if (strMet.charAt(0) == "@") {
        var ret = this.metavlites[met];
        if (ret === undefined) {
            this.ErrorMessage = "Άγνωστη μεταβλητή -> " + strMet;
            throw new InvalidNameError(this.ErrorMessage);
            return undefined;
        }
        return ret;
    }

    if (this.metavlites[met] === undefined) {
        met = "Κεντρικό" + "." + strMet;
        if (this.metavlites[met] === undefined) {
            this.ErrorMessage = "Άγνωστη μεταβλητή -> " + strMet;
            throw this.ErrorMessage;
            return undefined;
        }
    }
    return "this.metavlites[\"" + met + "\"]";
}

CodeSandBox.prototype.Clear = function () {
    for (var met in this.metavlites) {
        //console.log(met);
        delete this.metavlites[met];
    }
    this.metavlites = {};
}


CodeSandBox.prototype.CheckIntegerDivision = function (strStatement) {
    var strNewStatement = strStatement;
    var operators = "+-*/ "; // \x22 is ", \x27 is '

    var pos = strNewStatement.lastIndexOf(" div ")
    if (pos >= 0) {
        var strLeft, strRight;
        strLeft = strNewStatement.slice(0, pos);
        strRight = strNewStatement.slice(pos + 5);

        strLeft = this.CheckIntegerDivision(strLeft);
        // respect the left operator precedence
        for (var i = strLeft.length - 1; i >= 0; i--) {
            var ch = strLeft[i];
            if (ch == "+" || ch == "-")
                break;
        }
        var strLeftLeft = "";
        if (i > 0) {
            strLeftLeft = strLeft.substring(0, i + 1);
        }
        strLeft = strLeft.substring(i + 1);

        var strRightRight = "";
        strRight = this.CheckIntegerDivision(strRight);
        // respect the left operator precedence
        for (var i = 0; i < strRight.length; i++) {
            var ch = strRight[i];
            if (operators.indexOf(ch) >= 0) {
                strRightRight = strRight.substring(i);
                break;
            }
        }
        strRight = strRight.substring(0, i);

        //        strNewStatement = "~~(" + strLeft + " / " + strRight + ")";
        strNewStatement = strLeftLeft + " Math.trunc(" + strLeft + " / " + strRight + ")" + strRightRight;
    }
    return strNewStatement;
}


CodeSandBox.prototype.ParseSegment = function (start, strStatement, handlerCallback) {
    var strSegment = "";
    var strNewSegment = "";
    var len = strStatement.length;
    var inString = false;

    if (start >= len)
        return "";
    for (var i = start; i < strStatement.length; i++) {
        var ch = strStatement[i];

        if (ch == "\x22") // \x22 is "
            inString = !inString;

        if (inString) {
            strSegment += ch;
        } else if (ch == "(") {
            var objSegment = this.ParseSegment(i + 1, strStatement, handlerCallback);
            strNewSegment = objSegment.strSegment;
            i = objSegment.pos;
            strSegment += "(" + strNewSegment + ")";
        } else if (ch == "[") {
            var objSegment = this.ParseSegment(i + 1, strStatement, handlerCallback);
            strNewSegment = objSegment.strSegment;
            i = objSegment.pos;
            strSegment += "[" + strNewSegment + "]";
        }
        //        else if (ch == ")"){
        //            strNewSegment = handlerCallback(strSegment);
        //            return {strSegment: strNewSegment, pos: i};
        //        }
        else if (ch == ")" || ch == "]") {
            if (isString(strSegment) == false)
                strNewSegment = handlerCallback(strSegment);
            else
                strNewSegment = strSegment;
            return {
                strSegment: strNewSegment,
                pos: i
            };
        } else
            strSegment += ch;
    }
    strSegment = handlerCallback(strSegment);
    return strSegment;
}


CodeSandBox.prototype.ParseSegmentLeft = function (strStatement) {
    var sbLevel = 0;
    var pLevel = 0;

    // respect the left operator precedence
    for (var i = strStatement.length - 1; i >= 0; i--) {
        var ch = strStatement[i];
        if ((ch == "+" || ch == "-" || ch == ",") && (sbLevel == 0) && (pLevel == 0))
            break;
        else if (ch == ")")
            pLevel++;
        else if (ch == "(")
            pLevel--;
        else if (ch == "]")
            sbLevel++;
        else if (ch == "[")
            sbLevel--;
    }

    return i + 1;
}


CodeSandBox.prototype.ParseStatementJS = function (strScope, strStatement, start, sqrBracketLevel, parLevel, breakHandler) {
    var operators = "+-*/()><=!|&[],^ "; // \x22 is ", \x27 is '
    var operatorsBreak = "+-*/><=!|&,"; // \x22 is ", \x27 is '
    var strMet = new String("");
    var strVar = new String("");
    var inString = false;
    var strSegment = "";
    var strNewSegment = "";
    var strSegmentEvaled = "";
    var len = strStatement.length;
    var inString = false;

    var newStatementEvaled = "";
    var strVarEvaled = new String("");
    var strExressionEvaled = new String("");


    var str = "";
    var strDivLeft = "";
    var strDivLeftEvaled = "";
    var strDivRight = "";
    var strDivRightEvaled = "";

    if (start >= len)
        return "";


    for (var i = start; i < len; i++) {
        var ch = strStatement[i];

        if (ch == "\x22") // \x22 is "
            inString = !inString;


        if (inString) {
            strMet += ch;
        } else if (operators.indexOf(ch) == -1) {
            strMet += ch;
        } else {
            if (ch == "^")
                ch = "**";
            if (strMet == "") {
                strVar = "";
            } else if (strMet == "div") {
                strVar = "div";
            } else if (strMet == "mod") {
                strVar = "%";
            } else if ($.isNumeric(strMet)) {
                strVar = "Number(\"" + strMet + "\")";
            } else if (isString(strMet)) {
                strVar = strMet;
            } else if (isTrue(strMet)) {
                strVar = "true";
            } else if (isFalse(strMet)) {
                strVar = "false";
            } else {
                strVar = this.MetToString(strScope, strMet);
            }

            if (breakHandler != undefined && breakHandler(ch, strVar, sqrBracketLevel, parLevel)) {
                if (strVar == "div" || strVar == "%") {
                    i -= 4;
                    strMet = "";
                }
                break;
            }
            if (strVar == "div") {
                var posLeft = this.ParseSegmentLeft(strSegment);
                strDivLeft = strSegment.substr(posLeft);
                var strUnchanged = strSegment.substring(0, posLeft);

                posLeft = this.ParseSegmentLeft(strSegmentEvaled);
                strDivLeftEvaled = strSegmentEvaled.substr(posLeft);
                var strUnchangedEvaled = strSegmentEvaled.substring(0, posLeft);

                var objDivRight = this.ParseStatementJS(strScope, strStatement, i, 0, 0, function (_ch, _strVar, sbLevel, pLevel) {
                    if (sbLevel == 0 && pLevel == 0 && (operatorsBreak.indexOf(_ch) > -1 || _strVar == "div" || _strVar == "%"))
                        return true;

                    return false;
                });
                i = objDivRight.pos - 1;
                strDivRight = objDivRight.strSegment;
                strDivRightEvaled = objDivRight.strSegmentEvaled;

                strSegment = strUnchanged + "Math.trunc(" + strDivLeft.trim() + "/" + strDivRight.trim() + ")";
                strSegmentEvaled = strUnchangedEvaled + "Math.trunc(" + strDivLeftEvaled.trim() + "/" + strDivRightEvaled.trim() + ")";
                strExressionEvaled += "div" + objDivRight.strExressionEvaled;
                strVar = "";
                strMet = "";
                continue;
            }
            if (ch == "(") {
                var objSegment = this.ParseStatementJS(strScope, strStatement, i + 1, sqrBracketLevel, parLevel + 1, breakHandler);
                //strNewSegment = objSegment.strSegment;
                i = objSegment.pos;
                strSegment += strVar + "(" + objSegment.strSegment + ")";
                strSegmentEvaled += strVar + "(" + objSegment.strSegmentEvaled + ")";
                strExressionEvaled += strMet  + "(" + objSegment.strExressionEvaled + ")";
            } else if (ch == "[") {
                var objSegment = this.ParseStatementJS(strScope, strStatement, i + 1, sqrBracketLevel + 1, parLevel, breakHandler);
                //strNewSegment = objSegment.strSegment;
                i = objSegment.pos;
                strSegment += strVar + "[" + objSegment.strSegment + "]";
                // Check for array (JSON.parse)
                if (sqrBracketLevel == 0) {
                    try {
                        var arr = JSON.parse("[" + objSegment.strSegmentEvaled + "]");
                        // JSON parsing succeeded, so we have an array
                        strSegmentEvaled += strVar + "[" + objSegment.strSegmentEvaled + "]";
                        strExressionEvaled += strMet  + "[" + objSegment.strSegmentEvaled + "]";
                    } catch (e) {
                        // JSON parsing failed, so it's not an array.
                        // eval() it as a javascript expression
                        strVarEvaled = eval(objSegment.strSegmentEvaled);
                        strSegmentEvaled += strVar + "[" + strVarEvaled + "]";
                        strExressionEvaled += strMet  + "[" + strVarEvaled + "]";
                    }
                } else{
                    strSegmentEvaled += strVar + "[" + objSegment.strSegmentEvaled + "]";
                    strExressionEvaled += strMet  + "(" + objSegment.strExressionEvaled + ")";
                }
            } else if (ch == ")" || ch == "]") {
                strNewSegment = strSegment + strVar;
                strSegmentEvaled = strSegmentEvaled + strVar;
                strExressionEvaled += strMet;
                return {
                    strSegment: strNewSegment,
                    strSegmentEvaled: strSegmentEvaled,
                    strExressionEvaled: strExressionEvaled,
                    pos: i
                };
            } else {
                strSegment += strVar + ch;
                strSegmentEvaled += strVar + ch;
                strExressionEvaled += strMet + ch;
            }

            strMet = "";
            strVar = "";
        }
    }
    strVar = strMet;
    if (strMet != "" && !$.isNumeric(strMet) && !isString(strMet) &&
        strMet != "true" && strMet != "false") {
        strVar = this.MetToString(strScope, strMet);
    }

    if ($.isNumeric(strMet))
        strVar = "Number(\"" + strMet + "\")";

    strSegment += strVar;
    strSegmentEvaled += strVar;
    strExressionEvaled += strMet;
    return {
        strSegment: strSegment,
        strSegmentEvaled: strSegmentEvaled,
        strExressionEvaled: strExressionEvaled,
        pos: i
    };
}

CodeSandBox.prototype.ParseStatement = function (strScope, strStatement) {
    var self = this;
    var strStatementSource = strStatement;

    // if strStatement is not a string(enclosed in ""), then do the replacements,
    // otherwise leave it as is
    if (isString(strStatement)) {
        return {
            sourceStatement: strStatement,
            evaledStatement: strStatement,
            expressionEvaled: strStatement,
            expression: strStatement
        };
    }

    // Before remove spaces, restore correct operators
    strStatement = strStatement.replace(/<>/g, "!=");

    // Αντικατέστησε το = με == μόνο αν ο χαρακτήρας πριν δεν είναι κάποιος
    // από !<>= ( (?<![!,<,>,=]) - negative look-behind) και δεν ακολουθεί
    // κάποιο άλλο = ( (?!=) - negative look-ahead)
    // η javascript δεν υποστηρίζει negative look-behind :-(
    //strStatement = strStatement.replace(/(?<![!,<,>,=])=(?!=)/g, " == ");

    strStatement = strStatement.replace(/=/g, " == ");
    // remove more than one space
    strStatement = strStatement.replace(/\s\s+/g, ' ');

    strStatement = strStatement.replace(/! == /g, " != ");
    strStatement = strStatement.replace(/> == /g, " >= ");
    strStatement = strStatement.replace(/< == /g, " <= ");


    // (^|\s|\()(οχι)(?=\s|$)

    //strStatement = strStatement.replaceAll("mod", "%");

    strStatement = strStatement.replaceAll("και", "&&");
    strStatement = strStatement.replaceAll("ή", "||");
    strStatement = strStatement.replaceAll("οχι", "!");
    strStatement = strStatement.replaceAll("αληθης", "true");
    strStatement = strStatement.replaceAll("ψευδης", "false");

    //strStatement = strStatement.replace(/ /gi, ""); //remove spaces


    //            var newStatement = "";
    //            var arrStatement = strStatement.split('');
    //            var operators = "+-*/()><=!|&[], "; // \x22 is ", \x27 is '
    //            var strMet = new String("");
    //            var strVar = new String("");
    //            var inString = false;
    //
    //            var newStatementEvaled = "";
    //            var strVarEvaled = new String("");
    //
    //
    //            var level = 0;
    //            var str = "";
    //
    //            for (var i = 0, len = strStatement.length; i < len; i++) {
    //                var ch = strStatement[i];
    //
    //                if (inString) {
    //                    strMet += ch;
    //                } else
    //                if (operators.indexOf(ch) == -1) {
    //                    strMet += ch;
    //                } else {
    //
    //                    if (strMet == "") {
    //                        strVar = "";
    //                    } else if (strMet == "div") {
    //                        strVar = "div";
    //                    } else if ($.isNumeric(strMet)) {
    //                        strVar = strMet;
    //                    } else if (isString(strMet)) {
    //                        strVar = strMet;
    //                    } else if (isTrue(strMet)) {
    //                        strVar = "true";
    //                    } else if (isFalse(strMet)) {
    //                        strVar = "false";
    //                    } else {
    //                        strVar = this.MetToString(strScope, strMet);
    //                    }
    //
    //                    if (ch == "[") {
    //                        if (level <= 0) {
    //                            newStatementEvaled += strVar + ch;
    //                            str += ch;
    //                        } else
    //                            str += strVar + ch;
    //                        level++;
    //                    } else
    //                    if (ch == "]") {
    //                        level--;
    //                        str += strVar + ch;
    //                        if (level == 0) {
    //                            // Remove [ ] from start, end
    //                            var strInner = str.slice(1, str.length - 1);
    //                            strInner = this.ParseSegment(0, strInner, function (strStatement) {
    //                                return self.CheckIntegerDivision(strStatement);
    //                            });
    //                            str = "[" + strInner + "]";
    //                            try {
    //                                var arr = JSON.parse(str);
    //                                // JSON parsing succeeded, so we have an array
    //                                // Remove [ ] from start, end
    //                                str = str.slice(1, str.length - 1);
    //                                strVarEvaled = str;
    //                            } catch (e) {
    //                                // JSON parsing failed, so it's not an array.
    //                                // eval() it as a javascript expression
    //                                // Remove [ ] from start, end
    //                                str = str.slice(1, str.length - 1);
    //                                strVarEvaled = eval(str);
    //                            }
    //                            newStatementEvaled += strVarEvaled + ch;
    //                            strVarEvaled = "";
    //                            str = "";
    //                        }
    //                    } else
    //                    if (level > 0)
    //                        str += strVar + ch;
    //                    else
    //                        newStatementEvaled += strVar + ch;
    //
    //                    newStatement += strVar + ch;
    //                    strMet = "";
    //                    strVar = "";
    //                }
    //                if (ch == "\x22") // \x22 is "
    //                    inString = !inString;
    //            }
    //            strVar = strMet;
    //                if (strMet != "" && !$.isNumeric(strMet) && !isString(strMet) &&
    //                    strMet != "true" && strMet != "false") {
    //                    strVar = this.MetToString(strScope, strMet);
    //                }
    //                newStatementEvaled += strVar;
    //                newStatement += strVar;

    var objStatement = this.ParseStatementJS(strScope, strStatement, 0, 0, 0);
    var newStatement = objStatement.strSegment;
    var newStatementEvaled = objStatement.strSegmentEvaled;



    //newStatement = this.CheckIntegerDivision(newStatement);
    //    newStatement = this.ParseSegment(0, newStatement, function (strStatement) {
    //        return self.CheckIntegerDivision(strStatement);
    //    });

    return {
        sourceStatement: newStatement,
        evaledStatement: newStatementEvaled,
        expressionEvaled: objStatement.strExressionEvaled,
        expression: strStatementSource
    };
}

CodeSandBox.prototype.MakeAssignment = function (strScope, strStatement, $command) {
    var ret = null;

    var arrParam = strStatement.split("<-");

    if (arrParam.length != 2) {
        this.ErrorMessage = "Σφάλμα -> " + strStatement;
        console.log("Σφάλμα -> " + strStatement);
        throw this.ErrorMessage;
        return undefined;
    }
    //console.log(arrParam);
    var met;
    var leftStatement, leftParam;
    leftParam = $.trim(arrParam[0]);
    var retLeft;
    try {
        retLeft = this.ParseStatement(strScope, leftParam);
        var ret = eval(retLeft.evaledStatement);
        leftStatement = retLeft.sourceStatement;
        if (ret === undefined){
            this.ErrorMessage = "Σφάλμα -> " + leftParam;
            throw this.ErrorMessage;
        }
    } catch (e) {
        if (ret === undefined){
            console.log(this.ErrorMessage);
            throw new InvalidNameError(this.ErrorMessage);
            //throw this.ErrorMessage;
        }

        if (e instanceof InvalidNameError) {
            this.ErrorMessage = e.message;
            throw this.ErrorMessage;
        }
        met = this.SetMet(strScope, leftParam, 0);
        retLeft = this.ParseStatement(strScope, leftParam);
        leftStatement = retLeft.sourceStatement;
        //leftStatement = met;
    }

    var rightParam = $.trim(arrParam[1]);
    var retRight = this.ParseStatement(strScope, rightParam);
    var rightStatement = retRight.sourceStatement;

    var assingment = leftStatement + "=" + rightStatement;

    try {
        //ret = eval(assingment);
        ret = this.evalStatement(assingment);
        if (ret == undefined || Number.isNaN(ret)) {
            this.ErrorMessage = "Σφάλμα στην ανάθεση τιμής";
            console.log(this.ErrorMessage);
            throw this.ErrorMessage;
            return undefined;
        }
        if (Array.isArray(ret)) {
            // add the array length to 0-index position
            // [0]: the array length,
            // rest: the actual array elements
            var len = ret.length
            ret.unshift(len);
        }
        this.ErrorMessage = "";
        var exitFunction = false;
        if ($command != null){
            var scopeName = this.GetMetName('\"' + strScope + '\"');
            var metName = retLeft.expressionEvaled;
            var $code = $command.parents("code:first");

            if (scopeName == metName && $code.hasClass("function"))
                exitFunction = true;
        }

        return {
            value: ret,
            leftStatement: retLeft,
            rightStatement: retRight,
            bExitFunction: exitFunction
        };
    } catch (error) {
        this.ErrorMessage = "Σφάλμα στην ανάθεση τιμής : " + strStatement;
        console.log(this.ErrorMessage);
        throw this.ErrorMessage;
        return undefined;
    }
}

CodeSandBox.prototype.CheckCondition = function (strScope, strStatement) {
    var ret = true;
    var retState = this.ParseStatement(strScope, strStatement);
    retState.expression = strStatement;
    var newStatement = retState.evaledStatement;
    try {
        ret = eval(newStatement);
        if (ret == undefined) {
            this.ErrorMessage = "Σφάλμα στην έκφραση ελέγχου";
            console.log(this.ErrorMessage);
            throw this.ErrorMessage;
            return undefined;
        }
    } catch (e) {
        this.ErrorMessage = "Συντακτικό σφάλμα";
        throw this.ErrorMessage;
        return undefined;
    }
    this.ErrorMessage = "";
    return {
        value: ret,
        statement: retState
    };
}
