/* --------------------------------------------------
Author: Anastasios Pallas / tcpallas@gmail.com
Version 1.0
Last Update: 2018-12-20
-------------------------------------------------- */

// Fix responsive for canvas overlay objects
// based on the screen resolution

$(document).ready(function(){
	handle_window_resize();
});
 

$(window).on('resize', function(){
	handle_window_resize();
});


function handle_window_resize() {

	var screenwidth = $(window).width();
	
	/*
	if (screenwidth < 1140) {

	} else {

	}
	*/

}




// Theory Button
theory_btn_area.addEventListener("click", function() {
	handleClick_theory_btn();
});

// Application Button
app_btn_area.addEventListener("click", function() {
	handleClick_app_btn();
});

// Investigation Button
inv_btn_area.addEventListener("click", function() {
	handleClick_inv_btn();
});

// Specs Button
specs_btn_area.addEventListener("click", function() {
	handleClick_specs_btn();
});





// Q Prev
q_arrow_prev.addEventListener("click", function() {
	handleClick_q_prev(circuit_array);
});

// Q Next
q_arrow_next.addEventListener("click", function() {
	handleClick_q_next(circuit_array);
});

// Pi Prev
pi_arrow_prev.addEventListener("click", function() {
	handleClick_p_prev(circuit_array);
});

// Pi Next
pi_arrow_next.addEventListener("click", function() {
	handleClick_p_next(circuit_array);
});





// Add Device 
device_add_btn.addEventListener("click", function() {
	handleClick_device_add(circuit_array, p_array);
});






// Remove 1st device
rm_device[0].addEventListener("click", function() {
	handleClick_device_remove(circuit_array, p_array, 0);
});

// Remove 2nd device
rm_device[1].addEventListener("click", function() {
	handleClick_device_remove(circuit_array, p_array, 1);
});

// Remove 3rd device
rm_device[2].addEventListener("click", function() {
	handleClick_device_remove(circuit_array, p_array, 2);
});

// Remove 4th device
rm_device[3].addEventListener("click", function() {
	handleClick_device_remove(circuit_array, p_array, 3);
});





// Change Tabs
circuit_tab1.addEventListener("click", function() {
	handleClick_tab1();
});

circuit_tab2.addEventListener("click", function() {
	handleClick_tab2();
});

circuit_tab3.addEventListener("click", function() {
	handleClick_tab3();
});


// Change Temperatures highlight row
temperatures_table_highlight_area1.addEventListener("click", function() {
	handleClick_temperatures_table_highlight_area1();
});
temperatures_table_highlight_area2.addEventListener("click", function() {
	handleClick_temperatures_table_highlight_area2();
});
temperatures_table_highlight_area3.addEventListener("click", function() {
	handleClick_temperatures_table_highlight_area3();
});
temperatures_table_highlight_area4.addEventListener("click", function() {
	handleClick_temperatures_table_highlight_area4();
});




// Handlers

function handleClick_theory_btn() {
	$("#theory_instruction_modal").modal('show');
	return true;
}

function handleClick_app_btn() {
	$("#application_instruction_modal").modal('show');
	return true;	
}

function handleClick_inv_btn() {
	$("#investigation_instruction_modal").modal('show');
	return true;
}


function handleClick_specs_btn() {
	$("#specs_instruction_modal").modal('show');
	return true;
}



function handleClick_q_next(circuit_array) {

	// Order: 800 > 1000 > 1200 > 1500 Kcal/h

	if (pick_q_value.text == "800 Kcal/h") {
		pick_q_value.text = "1000 Kcal/h";
	} else if (pick_q_value.text == "1000 Kcal/h") {
		pick_q_value.text = "1200 Kcal/h";
	} else if (pick_q_value.text == "1200 Kcal/h") {
		pick_q_value.text = "1500 Kcal/h";
	}
	// also rotate values
	else if (pick_q_value.text == "1500 Kcal/h") {
		pick_q_value.text = "800 Kcal/h";
	}

	return true;

}



function handleClick_q_prev(circuit_array) {

	// Order: 800 < 1000 < 1200 < 1500 Kcal/h

	if (pick_q_value.text == "1000 Kcal/h") {
		pick_q_value.text = "800 Kcal/h";
	} else if (pick_q_value.text == "1200 Kcal/h") {
		pick_q_value.text = "1000 Kcal/h";
	} else if (pick_q_value.text == "1500 Kcal/h") {
		pick_q_value.text = "1200 Kcal/h";
	}

	// also rotate values
	else if (pick_q_value.text == "800 Kcal/h") {
		pick_q_value.text = "1500 Kcal/h";
	}

	return true;

}


function handleClick_p_next(circuit_array) {

	// Order: 50 > 60 > 70 > 80 > 90 > 100 %

	if (pick_p_value.text == "50%") {
		pick_p_value.text = "60%";
	} else if (pick_p_value.text == "60%") {
		pick_p_value.text = "70%";
	} else if (pick_p_value.text == "70%") {
		pick_p_value.text = "80%";
	} else if (pick_p_value.text == "80%") {
		pick_p_value.text = "90%";
	} else if (pick_p_value.text == "90%") {
		pick_p_value.text = "100%";
	}
	// also rotate values
	else if (pick_p_value.text == "100%") {
		pick_p_value.text = "50%";
	}

	return true;

}



function handleClick_p_prev(circuit_array) {

	// Order: 50 < 60 < 70 < 80 < 90 < 100 %

	if (pick_p_value.text == "60%") {
		pick_p_value.text = "50%";
	} else if (pick_p_value.text == "70%") {
		pick_p_value.text = "60%";
	} else if (pick_p_value.text == "80%") {
		pick_p_value.text = "70%";
	} else if (pick_p_value.text == "90%") {
		pick_p_value.text = "80%";
	} else if (pick_p_value.text == "100%") {
		pick_p_value.text = "90%";
	}
	// also rotate values
	else if (pick_p_value.text == "50%") {
		pick_p_value.text = "100%";
	}
	return true;

}



function handleClick_device_add(circuit_array, p_array) {

	// Check which position is empty
	circuit_position = -1;	//  no empty position

	if (circuit_array[0] == "add_circuit") {
		circuit_position = 0;
	} else if (circuit_array[1] == "add_circuit") {
		circuit_position = 1;
	} else if (circuit_array[2] == "add_circuit") {
		circuit_position = 2;
	} else if (circuit_array[3] == "add_circuit") {
		circuit_position = 3;
	} else if (circuit_array[4] == "add_circuit") {
		circuit_position = 4;
	}
	
	if (circuit_position >= 0) {

		// Update circuit array
		if (pick_q_value.text == "800 Kcal/h") {
			circuit_array[circuit_position] = "body_800";
		} else if (pick_q_value.text == "1000 Kcal/h") {
			circuit_array[circuit_position] = "body_1000";
		} else if (pick_q_value.text == "1200 Kcal/h") {
			circuit_array[circuit_position] = "body_1200";
		} else if (pick_q_value.text == "1500 Kcal/h") {
			circuit_array[circuit_position] = "body_1500";
		}


		// Update p_array
		if (pick_p_value.text == "50%") {
			p_array[circuit_position] = 50;
		} else if (pick_p_value.text == "60%") {
			p_array[circuit_position] = 60;
		} else if (pick_p_value.text == "70%") {
			p_array[circuit_position] = 70;
		} else if (pick_p_value.text == "80%") {
			p_array[circuit_position] = 80;
		} else if (pick_p_value.text == "90%") {
			p_array[circuit_position] = 90;
		} else if (pick_p_value.text == "100%") {
			p_array[circuit_position] = 100;
		}


		// Move "Add Circuit" to the next available position
		if (circuit_array[0] == "") {
			circuit_array[0] = "add_circuit";
		} else if (circuit_array[1] == "") {
			circuit_array[1] = "add_circuit";
		} else if (circuit_array[2] == "") {
			circuit_array[2] = "add_circuit";
		} else if (circuit_array[3] == "") {
			circuit_array[3] = "add_circuit";
		} else if (circuit_array[4] == "") {
			circuit_array[4] = "add_circuit";
		}


		// Update Main Circuit
		update_circuit(circuit_array, p_array);

	}

}


function handleClick_device_remove(circuit_array, p_array, position) {

	circuit_array[position] = "";
	p_array[position] = 0;

	// Reorganize Main Circuit
	for (i = 0; i < circuit_array.length-1; i++) { 
    	if (circuit_array[i]=="" && circuit_array[i+1]!="") {
    		circuit_array[i] = circuit_array[i+1];
    		circuit_array[i+1] = "";
			// Update also p_array!!!
			p_array[i] = p_array[i+1];
			p_array[i+1] = 0;
    	}
    }

	// Update Main Circuit
	update_circuit(circuit_array, p_array);
	
	return true;

}






// TABS

function handleClick_tab1() {

	// Update tabs
	circuit_tab1.cursor = "";
	circuit_tab2.cursor = "pointer";
	circuit_tab3.cursor = "pointer";

	circuit_tab1.graphics.clear().beginFill("#667b16").beginStroke("#667b16").setStrokeStyle(3).drawRoundRect(0, 0, 150, 40, 10);
	circuit_tab2.graphics.clear().beginFill("#a4b859").beginStroke("#667b16").setStrokeStyle(3).drawRoundRect(0, 0, 150, 40, 10);
	circuit_tab3.graphics.clear().beginFill("#a4b859").beginStroke("#667b16").setStrokeStyle(3).drawRoundRect(0, 0, 150, 40, 10);

	circuit_tab1_text.color = "#ffffff";
	circuit_tab2_text.color = "#ffffff";
	circuit_tab3_text.color = "#ffffff";

	// Show/Hide Remove Buttons
	for (i = 0; i < circuit_array.length; i++) {
    	if (circuit_array[i]=="" || circuit_array[i]=="add_circuit") {
    		rm_device[i].visible = false;
    	} else {
    		rm_device[i].visible = true;
    	}
	}

	// Hide elements of 2nd tab
	tab2_overlay.visible = false;
	temperatures_circuit.visible = false;
	temperatures_circuit_texts.visible = false;
	temperatures_table.visible = false;
	temperatures_table_values.visible = false;

	
	// Hide elements of 3rd tab
	tab3_overlay.visible = false;
	power_graph.visible = false;
	power_table.visible = false;
	power_table_values.visible = false;


	stage.update();

}

function handleClick_tab2() {

	// Update tabs
	circuit_tab1.cursor = "pointer";
	circuit_tab2.cursor = "";
	circuit_tab3.cursor = "pointer";

	circuit_tab1.graphics.clear().beginFill("#a4b859").beginStroke("#667b16").setStrokeStyle(3).drawRoundRect(0, 0, 150, 40, 10);
	circuit_tab2.graphics.clear().beginFill("#667b16").beginStroke("#667b16").setStrokeStyle(3).drawRoundRect(0, 0, 150, 40, 10);
	circuit_tab3.graphics.clear().beginFill("#a4b859").beginStroke("#667b16").setStrokeStyle(3).drawRoundRect(0, 0, 150, 40, 10);

	circuit_tab1_text.color = "#ffffff";
	circuit_tab2_text.color = "#ffffff";
	circuit_tab3_text.color = "#ffffff";

	// Hide elements of 1st tab
	rm_device[0].visible = false;
	rm_device[1].visible = false;
	rm_device[2].visible = false;
	rm_device[3].visible = false;


	// Hide elements of 3rd tab
	tab3_overlay.visible = false;
	power_graph.visible = false;
	power_table.visible = false;
	power_table_values.visible = false;
	

	// Z-index
	// var tab2_zindex = stage.getNumChildren()-1; // getNumbChildren is deprecated!
	var tab2_zindex = stage.numChildren - 1;
	stage.setChildIndex(tab2_overlay, tab2_zindex);
	stage.setChildIndex(temperatures_circuit, tab2_zindex);
	stage.setChildIndex(temperatures_circuit_texts, tab2_zindex);
	stage.setChildIndex(temperatures_table, tab2_zindex);
	stage.setChildIndex(temperatures_table_values, tab2_zindex);


	// Show 2nd tab elements
	tab2_overlay.visible = true;
	temperatures_circuit.visible = true;
	temperatures_circuit_texts.visible = true;
	temperatures_table.visible = true;
	temperatures_table_values.visible = true;

	stage.update();

}

function handleClick_tab3() {

	// Update tabs
	circuit_tab1.cursor = "pointer";
	circuit_tab2.cursor = "pointer";
	circuit_tab3.cursor = "";

	circuit_tab1.graphics.clear().beginFill("#a4b859").beginStroke("#667b16").setStrokeStyle(3).drawRoundRect(0, 0, 150, 40, 10);
	circuit_tab2.graphics.clear().beginFill("#a4b859").beginStroke("#667b16").setStrokeStyle(3).drawRoundRect(0, 0, 150, 40, 10);
	circuit_tab3.graphics.clear().beginFill("#667b16").beginStroke("#667b16").setStrokeStyle(3).drawRoundRect(0, 0, 150, 40, 10);

	circuit_tab1_text.color = "#ffffff";
	circuit_tab2_text.color = "#ffffff";
	circuit_tab3_text.color = "#ffffff";

	// Hide elements of 1st tab
	rm_device[0].visible = false;
	rm_device[1].visible = false;
	rm_device[2].visible = false;
	rm_device[3].visible = false;


	// Hide elements of 2nd tab
	tab2_overlay.visible = false;
	temperatures_circuit.visible = false;
	temperatures_circuit_texts.visible = false;
	temperatures_table.visible = false;
	temperatures_table_values.visible = false;


	// Z-index
	var tab3_zindex = stage.numChildren - 1;
	stage.setChildIndex(tab3_overlay, tab3_zindex);
	stage.setChildIndex(power_graph, tab3_zindex);
	stage.setChildIndex(power_table, tab3_zindex);
	stage.setChildIndex(power_table_values, tab3_zindex);

	// Show 3rd tab elements
	tab3_overlay.visible = true;
	power_graph.visible = true;
	power_table.visible = true;
	power_table_values.visible = true;
	


	stage.update();
}


function handleClick_temperatures_table_highlight_area1() {

	temperatures_table_highlight_area1.visible = false;
	temperatures_table_highlight_area2.visible = true;
	temperatures_table_highlight_area3.visible = true;
	temperatures_table_highlight_area4.visible = true;

	temperatures_circuit_text1.visible = true;
	temperatures_circuit_text2.visible = false;
	temperatures_circuit_text3.visible = false;
	temperatures_circuit_text4.visible = false;


	temperatures_table_highlight.y = config.center_y + 35;  // 35, 81, 127, 174

	stage.update();
}

function handleClick_temperatures_table_highlight_area2() {

	temperatures_table_highlight_area1.visible = true;
	temperatures_table_highlight_area2.visible = false;
	temperatures_table_highlight_area3.visible = true;
	temperatures_table_highlight_area4.visible = true;

	temperatures_circuit_text1.visible = false;
	temperatures_circuit_text2.visible = true;
	temperatures_circuit_text3.visible = false;
	temperatures_circuit_text4.visible = false;

	temperatures_table_highlight.y = config.center_y + 81;  // 35, 81, 127, 174

	stage.update();
}

function handleClick_temperatures_table_highlight_area3() {

	temperatures_table_highlight_area1.visible = true;
	temperatures_table_highlight_area2.visible = true;
	temperatures_table_highlight_area3.visible = false;
	temperatures_table_highlight_area4.visible = true;

	temperatures_circuit_text1.visible = false;
	temperatures_circuit_text2.visible = false;
	temperatures_circuit_text3.visible = true;
	temperatures_circuit_text4.visible = false;

	temperatures_table_highlight.y = config.center_y + 127;  // 35, 81, 127, 174

	stage.update();
}

function handleClick_temperatures_table_highlight_area4() {

	temperatures_table_highlight_area1.visible = true;
	temperatures_table_highlight_area2.visible = true;
	temperatures_table_highlight_area3.visible = true;
	temperatures_table_highlight_area4.visible = false;

	temperatures_circuit_text1.visible = false;
	temperatures_circuit_text2.visible = false;
	temperatures_circuit_text3.visible = false;
	temperatures_circuit_text4.visible = true;

	temperatures_table_highlight.y = config.center_y + 174;  // 35, 81, 127, 174

	stage.update();
}
