/* --------------------------------------------------
Author: Anastasios Pallas / tcpallas@gmail.com
Version 3.2
Last Update: 2018-11-22
-------------------------------------------------- */


// Update stage will render next frame
createjs.Ticker.framerate = 30;
createjs.Ticker.addEventListener("tick", tickHandler);

function tickHandler(e) {
	stage.update();
}






function update_device_button(circuit_array) {

	device_add.visible = true;
	device_add_btn.visible = true;
	
	// Hide Add button if no more empty positions
	if ( circuit_array.indexOf("add_circuit")==-1 ) {
		device_add.visible = false;
		device_add_btn.visible = false;
	}

	return true;
}



function update_circuit(circuit_array, p_array){

	// Debugging
	// console.log(circuit_array);
	// console.log(p_array);

	stage.setChildIndex(circuit_bg, 20);

	// Put Add a New Circuit if necessary
	for (i = 0; i < circuit_array.length; i++) {
		if (circuit_array[i] == "add_circuit") {
			break;
		}
		if (circuit_array[i] == "") {
			circuit_array[i] = "add_circuit";
			break;
		}
	}
	

	// Position 1
	switch(circuit_array[0]) {
		case "add_circuit":
			device_circuit.visible = false;
			circuit_add.x = config.center_x - 410;
			circuit_add.visible = true;
			circuit_label1.text = "";
			circuit_qlabel1.text = "";
			circuit_plabel1.text = "";
			break;
		case "body_800":
			device_circuit.visible = true;
			circuit_label1.text = "Χώρος #1";
			circuit_qlabel1.text = config.device_body_q1 + " Kcal/h";
			break;
		case "body_1000":
			device_circuit.visible = true;
			circuit_label1.text = "Χώρος #1";
			circuit_qlabel1.text = config.device_body_q2 + " Kcal/h";
			break;
		case "body_1200":
			device_circuit.visible = true;
			circuit_label1.text = "Χώρος #1";
			circuit_qlabel1.text = config.device_body_q3 + " Kcal/h";
			break;
		case "body_1500":
			device_circuit.visible = true;
			circuit_label1.text = "Χώρος #1";
			circuit_qlabel1.text = config.device_body_q4 + " Kcal/h";
			break;
	}

	
	// Position 2
	switch(circuit_array[1]) {
		case "add_circuit":
			device_circuit2.visible = false;
			circuit_add.x = config.center_x - 200;
			circuit_add.visible = true;
			circuit_label2.text = "";
			circuit_qlabel2.text = "";
			circuit_plabel2.text = "";
			break;
		case "body_800":		
			// stage.setChildIndex(device_circuit2, 100);
			device_circuit2.visible = true;
			circuit_label2.text = "Χώρος #2";
			circuit_qlabel2.text = config.device_body_q1 + " Kcal/h";
			break;
		case "body_1000":
			device_circuit2.visible = true;
			circuit_label2.text = "Χώρος #2";
			circuit_qlabel2.text = config.device_body_q2 + " Kcal/h";
			break;
		case "body_1200":
			device_circuit2.visible = true;
			circuit_label2.text = "Χώρος #2";
			circuit_qlabel2.text = config.device_body_q3 + " Kcal/h";
			break;
		case "body_1500":
			device_circuit2.visible = true;
			circuit_label2.text = "Χώρος #2";
			circuit_qlabel2.text = config.device_body_q4 + " Kcal/h";
			break;
		case "":
			device_circuit2.visible = false;
			circuit_label2.text = "";
			circuit_qlabel2.text = "";
			circuit_plabel2.text = "";
			break;
	}

	// Position 3
	switch(circuit_array[2]) {
		case "add_circuit":
			device_circuit3.visible = false;
			circuit_add.x = config.center_x + 10;
			circuit_add.visible = true;
			circuit_label3.text = "";
			circuit_qlabel3.text = "";
			circuit_plabel3.text = "";
			break;
		case "body_800":
			device_circuit3.visible = true;
			circuit_label3.text = "Χώρος #3";
			circuit_qlabel3.text = config.device_body_q1 + " Kcal/h";
			break;
		case "body_1000":
			device_circuit3.visible = true;
			circuit_label3.text = "Χώρος #3";
			circuit_qlabel3.text = config.device_body_q2 + " Kcal/h";
			break;
		case "body_1200":
			device_circuit3.visible = true;
			circuit_label3.text = "Χώρος #3";
			circuit_qlabel3.text = config.device_body_q3 + " Kcal/h";
			break;
		case "body_1500":
			device_circuit3.visible = true;
			circuit_label3.text = "Χώρος #3";
			circuit_qlabel3.text = config.device_body_q4 + " Kcal/h";
			break;
		case "":
			device_circuit3.visible = false;
			circuit_label3.text = "";
			circuit_qlabel3.text = "";
			circuit_plabel3.text = "";
			break;
	}

	// Position 4
	switch(circuit_array[3]) {
		case "add_circuit":
			device_circuit4.visible = false;
			circuit_add.x = config.center_x + 220;
			circuit_add.visible = true;
			circuit_label4.text = "";
			circuit_qlabel4.text = "";
			circuit_plabel4.text = "";
			break;
		case "body_800":
			circuit_add.visible = false;
			device_circuit4.visible = true;
			circuit_label4.text = "Χώρος #4";
			circuit_qlabel4.text = config.device_body_q1 + " Kcal/h";
			break;
		case "body_1000":
			circuit_add.visible = false;
			device_circuit4.visible = true;
			circuit_label4.text = "Χώρος #4";
			circuit_qlabel4.text = config.device_body_q2 + " Kcal/h";
			break;
		case "body_1200":
			circuit_add.visible = false;
			device_circuit4.visible = true;
			circuit_label4.text = "Χώρος #4";
			circuit_qlabel4.text = config.device_body_q3 + " Kcal/h";
			break;
		case "body_1500":
			circuit_add.visible = false;
			device_circuit4.visible = true;
			circuit_label4.text = "Χώρος #4";
			circuit_qlabel4.text = config.device_body_q4 + " Kcal/h";
			break;
		case "":
			device_circuit4.visible = false;
			circuit_label4.text = "";
			circuit_qlabel4.text = "";
			circuit_plabel4.text = "";
			break;
	}


	// Show/Hide Remove Buttons
	for (i = 0; i < circuit_array.length; i++) {	
    	if (circuit_array[i]=="" || circuit_array[i]=="add_circuit") {
    		rm_device[i].visible = false;
    	} else {
    		rm_device[i].visible = true;
    	}
    }



	// Update P labels
	if ( Array.isArray(p_array) ) {
		if (p_array[0] > 0) {
			circuit_plabel1.text = "π = " + p_array[0] + "%";
		} else {
			circuit_plabel1.text = "";
		}
	
		if (p_array[1] > 0) {
			circuit_plabel2.text = "π = " + p_array[1] + "%";
		} else {
			circuit_plabel2.text = "";
		}
	
		if (p_array[2] > 0) {
			circuit_plabel3.text = "π = " + p_array[2] + "%";
		} else {
			circuit_plabel3.text = "";
		}

		if (p_array[3] > 0) {
			circuit_plabel4.text = "π = " + p_array[3] + "%";
		} else {
			circuit_plabel4.text = "";
		}
	}




    // Update Device Buttons
    update_device_button(circuit_array);

    // Update Main Circuit Values
    calc_main_values (circuit_array);

	// Update Temperatures and Power tables
	calc_table_values(circuit_array, p_array);

	// Update stage
	stage.update();

	// Debugging
	// console.log(circuit_array);

	return true;
}




function calc_main_values (circuit_array) {

	var Q = 0;
	var V = 0;

	for (i = 0; i < circuit_array.length; i++) {
		
		switch (circuit_array[i]) {
			case "body_800":
				Q += config.device_body_q1; 
				break;
			case "body_1000":
				Q += config.device_body_q2; 
				break;
			case "body_1200":
				Q += config.device_body_q3; 
				break;
			case "body_1500":
				Q += config.device_body_q4;
				break;
		}

	}

	// V = Q/Δt, Δt = tV-tR = 90 – 70 = 20οC
	V = Q / 20; 

	// Update Circuit Values
	var V_rounded = Math.round(V * 100) / 100; 	// round to 2 decimal
	circuit_values_txt.text = "Q=" + Q + " Kcal/h    V=" + V_rounded + " lt/h";

	return true;

}


function calc_table_values(circuit_array, p_array) {

	var Q = 0;
	var V = 0;
	var q = new Array();
	var v = new Array();
	var tv = new Array();
	var tr = new Array();
	var te = new Array();
	var s = new Array();
	var q60 = new Array();

	// Q
	for (i = 0; i < circuit_array.length; i++) {
		switch (circuit_array[i]) {
			case "body_800":
				Q += config.device_body_q1; 
				break;
			case "body_1000":
				Q += config.device_body_q2; 
				break;
			case "body_1200":
				Q += config.device_body_q3; 
				break;
			case "body_1500":
				Q += config.device_body_q4;
				break;
		}
	}

	// V
	V = Q / 20; // V = Q/Δt, Δt = tV-tR = 90 – 70 = 20οC

	// Q1
	if (circuit_array[0]=="body_800") {
		q[0] = config.device_body_q1;
	} else if (circuit_array[0]=="body_1000") {
		q[0] = config.device_body_q2;
	} else if (circuit_array[0]=="body_1200") {
		q[0] = config.device_body_q3;
	} else if (circuit_array[0]=="body_1500") {
		q[0] = config.device_body_q4;
	}
	// Q2
	if (circuit_array[1]=="body_800") {
		q[1] = config.device_body_q1;
	} else if (circuit_array[1]=="body_1000") {
		q[1] = config.device_body_q2;
	} else if (circuit_array[1]=="body_1200") {
		q[1] = config.device_body_q3;
	} else if (circuit_array[1]=="body_1500") {
		q[1] = config.device_body_q4;
	}
	// Q3
	if (circuit_array[2]=="body_800") {
		q[2] = config.device_body_q1;
	} else if (circuit_array[2]=="body_1000") {
		q[2] = config.device_body_q2;
	} else if (circuit_array[2]=="body_1200") {
		q[2] = config.device_body_q3;
	} else if (circuit_array[2]=="body_1500") {
		q[2] = config.device_body_q4;
	}
	// Q4
	if (circuit_array[3]=="body_800") {
		q[3] = config.device_body_q1;
	} else if (circuit_array[3]=="body_1000") {
		q[3] = config.device_body_q2;
	} else if (circuit_array[3]=="body_1200") {
		q[3] = config.device_body_q3;
	} else if (circuit_array[3]=="body_1500") {
		q[3] = config.device_body_q4;
	}

	// V1, V2, V3, V4
	v[0] = (p_array[0] / 100) * V;
	v[1] = (p_array[1] / 100) * V;
	v[2] = (p_array[2] / 100) * V;
	v[3] = (p_array[3] / 100) * V;

	// Debugging
	// console.log("V: " + V);
	// console.log("v1: " + v[0] + ", v2: " + v[1] + ", v3: " + v[2] + ", v4: " + v[3]);

	
	// Calculate Temperature table values
	if (p_array[0]>0) {
		tv[0] = 90;
		tr[0] = tv[0] - (q[0] / v[0]);
		te[0] = tv[0] - (q[0] / v[0] / 2) - 20;
		s[0] = Math.pow((te[0]/60), 1.33);
	}

	if (p_array[1]>0) {
		tv[1] = tv[0] - (q[0] / V);
		tr[1] = tv[1] - (q[1] / v[1]);
		te[1] = tv[1] - (q[1] / v[1] / 2) - 20;
		s[1] = Math.pow((te[1]/60), 1.33);
	}
	if (p_array[2]>0) {
		tv[2] = tv[1] - (q[1] / V);
		tr[2] = tv[2] - (q[2] / v[2]);
		te[2] = tv[2] - (q[2] / v[2] / 2) - 20;
		s[2] = Math.pow((te[2]/60), 1.33);
	}
	if (p_array[3]>0) {
		tv[3] = tv[2] - (q[2] / V);
		tr[3] = tv[3] - (q[3] / v[3]);
		te[3] = tv[3] - (q[3] / v[3] / 2) - 20;
		s[3] = Math.pow((te[3]/60), 1.33);
	}
	
	// Fix empty values
	for (i = 0; i <= 3; i++) {
		// Tv
		if (tv[i] && tv[i]>0) {
			tv[i] = Math.round(tv[i] * 10) / 10;
			tv[i] = tv[i].toFixed(1);
		} else {
			tv[i] = "-   ";
		}
		// Tr
		if (tr[i] && tr[i]>0) {
			tr[i] = Math.round(tr[i] * 10) / 10;
			tr[i] = tr[i].toFixed(1);
		} else {
			tr[i] = "-   ";
		}
		// Te
		if (te[i] && te[i]>0) {
			te[i] = Math.round(te[i] * 10) / 10;
			te[i] = te[i].toFixed(1);
		} else {
			te[i] = "-   ";
		}
		// S and Q60
		if (s[i] && s[i]>0) {
			s[i] = Math.round(s[i] * 100) / 100;
			s[i] = s[i].toFixed(2);
			// Calculate Q based on rounded K
			q60[i] = q[i] / s[i];
			q60[i] = Math.round(q60[i]);
			q60[i] = q60[i] + " Kcal/h";
		} else {
			s[i] = "-  ";
			q60[i] = "-     KCal/h";
		}
	}

	// Update Temperature table
	temperatures_cell_11.text = tv[0];
	temperatures_cell_21.text = tv[1];
	temperatures_cell_31.text = tv[2];
	temperatures_cell_41.text = tv[3];
	temperatures_cell_12.text = tr[0];
	temperatures_cell_22.text = tr[1];
	temperatures_cell_32.text = tr[2];
	temperatures_cell_42.text = tr[3];
	temperatures_cell_13.text = te[0];
	temperatures_cell_23.text = te[1];
	temperatures_cell_33.text = te[2];
	temperatures_cell_43.text = te[3];

	// Update Power table
	power_cell_11.text = s[0];
	power_cell_21.text = s[1];
	power_cell_31.text = s[2];
	power_cell_41.text = s[3];
	power_cell_12.text = q60[0];
	power_cell_22.text = q60[1];
	power_cell_32.text = q60[2];
	power_cell_42.text = q60[3];


	stage.update();

	return true;
}

