/* --------------------------------------------------
Author: Anastasios Pallas / tcpallas@gmail.com
Version 3.2
Last Update: 2018-11-22
-------------------------------------------------- */

// Initialize Canvas
var canvas = document.getElementById("canvas");
var context = canvas.getContext('2d');
var stage = new createjs.Stage("canvas");

// Theory button
var theory_btn_img = new Image();
theory_btn_img.src = 'images/btn-theory-light.png';

var theory_btn = new createjs.Bitmap(theory_btn_img);
theory_btn.scaleX = theory_btn.scaleY = 1;
theory_btn.x = config.center_x + 285;
theory_btn.y = config.center_y - 330;

theory_btn_img.onload = function () {
	stage.addChild(theory_btn);
	stage.setChildIndex(theory_btn, 0);
	stage.update();
}

// Application button
var app_btn_img = new Image();
app_btn_img.src = 'images/btn-application-light.png';

var app_btn = new createjs.Bitmap(app_btn_img);
app_btn.scaleX = app_btn.scaleY = 1;
app_btn.x = config.center_x + 285;
app_btn.y = config.center_y - 265;

app_btn_img.onload = function () {
	stage.addChild(app_btn);
	stage.setChildIndex(app_btn, 1);
	stage.update();
}


// Investigation button
var inv_btn_img = new Image();
inv_btn_img.src = 'images/btn-investigation-light.png';

var inv_btn = new createjs.Bitmap(inv_btn_img);
inv_btn.scaleX = inv_btn.scaleY = 1;
inv_btn.x = config.center_x + 285;
inv_btn.y = config.center_y - 200;

inv_btn_img.onload = function () {
	stage.addChild(inv_btn);
	stage.setChildIndex(inv_btn, 2);
	stage.update();
}


// Specs button
var specs_btn_img = new Image();
specs_btn_img.src = 'images/btn-specs.png';

var specs_btn = new createjs.Bitmap(specs_btn_img);
specs_btn.scaleX = specs_btn.scaleY = 1;
specs_btn.x = config.center_x - 110;
specs_btn.y = config.center_y - 220;

specs_btn_img.onload = function () {
	stage.addChild(specs_btn);
	stage.setChildIndex(specs_btn, 3);
	stage.update();
}





// Circuit Title
var pick_device_title = new createjs.Text(config.pick_device_title, "16px Arial", "#ce621b");
pick_device_title.textAlign = "left";
pick_device_title.lineHeight = "20";

pick_device_title.x = config.center_x - 110;
pick_device_title.y = config.center_y - 320;
stage.addChild(pick_device_title);




// Pick device background image
var device_bg_img = new Image();
device_bg_img.src = 'images/device-bg.png';

var device_bg = new createjs.Bitmap(device_bg_img);
device_bg.scaleX = device_bg.scaleY = 1;
device_bg.x = config.center_x - 530;
device_bg.y = config.center_y - 325;

device_bg_img.onload = function () {
	stage.addChild(device_bg);
	stage.setChildIndex(device_bg, 4);
	stage.update();
}


// Q Value
var pick_q_value = new createjs.Text("800 Kcal/h", "17px Arial", "#d67726");
pick_q_value.textAlign = "center";

pick_q_value.x = config.center_x - 235;
pick_q_value.y = config.center_y - 165;
stage.addChild(pick_q_value);

// Pi Value
var pick_p_value = new createjs.Text("50%", "17px Arial", "#d67726");
pick_p_value.textAlign = "center";

pick_p_value.x = config.center_x - 415;
pick_p_value.y = config.center_y - 165;
stage.addChild(pick_p_value);



// Pick Device Button
var device_add_img = new Image();
device_add_img.src = 'images/btn-add.png';

var device_add = new createjs.Bitmap(device_add_img);
device_add.scaleX = device_add.scaleY = 1;
device_add.x = config.center_x - 290;
device_add.y = config.center_y - 135;

device_add_img.onload = function () {
	stage.addChild(device_add);
	stage.setChildIndex(device_add, 5);
	stage.update();
}







// MAIN CIRCUIT

// Main Circuit Tab
var circuit_tab1 = new createjs.Shape();
circuit_tab1.graphics.beginFill("#667b16").beginStroke("#667b16").setStrokeStyle(3).drawRoundRect(0, 0, 150, 40, 10);
circuit_tab1.x = config.center_x + 38;
circuit_tab1.y = config.center_y - 120;
circuit_tab1.cursor = "";
stage.addChild(circuit_tab1);
stage.setChildIndex(circuit_tab1, 6);

var circuit_tab1_text = new createjs.Text(config.circuit_tab1_text, "17px Arial", "#ffffff");
circuit_tab1_text.textAlign = "left";

circuit_tab1_text.x = config.center_x + 80;
circuit_tab1_text.y = config.center_y - 112;
stage.addChild(circuit_tab1_text);







// Temperatures Tab
var circuit_tab2 = new createjs.Shape();
circuit_tab2.graphics.beginFill("#a4b859").beginStroke("#667b16").setStrokeStyle(3).drawRoundRect(0, 0, 150, 40, 10);
circuit_tab2.x = config.center_x + 190;
circuit_tab2.y = config.center_y - 120;
circuit_tab2.cursor = "pointer";
stage.addChild(circuit_tab2);
stage.setChildIndex(circuit_tab2, 7);

var tab2_overlay = new createjs.Shape();
tab2_overlay.graphics.beginFill("white").drawRoundRect(0, 0, 1040, 370, 10);
tab2_overlay.x = config.center_x - 520;
tab2_overlay.y = config.center_y - 80;
stage.addChild(tab2_overlay);


var circuit_tab2_text = new createjs.Text(config.circuit_tab2_text, "17px Arial", "#ffffff");
circuit_tab2_text.textAlign = "center";

circuit_tab2_text.x = config.center_x + 260;
circuit_tab2_text.y = config.center_y - 112;
stage.addChild(circuit_tab2_text);







// Power Tab
var circuit_tab3 = new createjs.Shape();
circuit_tab3.graphics.beginFill("#a4b859").beginStroke("#667b16").setStrokeStyle(3).drawRoundRect(0, 0, 150, 40, 10);
circuit_tab3.x = config.center_x + 340;
circuit_tab3.y = config.center_y - 120;
circuit_tab3.cursor = "pointer";
stage.addChild(circuit_tab3);
stage.setChildIndex(circuit_tab3, 8);

var tab3_overlay = new createjs.Shape();
tab3_overlay.graphics.beginFill("white").drawRoundRect(0, 0, 1040, 370, 10);
tab3_overlay.x = config.center_x - 520;
tab3_overlay.y = config.center_y - 80;
stage.addChild(tab3_overlay);


var circuit_tab3_text = new createjs.Text(config.circuit_tab3_text, "17px Arial", "#ffffff");
circuit_tab3_text.textAlign = "center";

circuit_tab3_text.x = config.center_x + 415;
circuit_tab3_text.y = config.center_y - 112;
stage.addChild(circuit_tab3_text);




// Main stage
var circuit_bg = new createjs.Shape();
circuit_bg.graphics.beginFill("#ffffff").beginStroke("#667b16").setStrokeStyle(3).drawRoundRect(0, 0, 1054, 415, 10);
circuit_bg.x = config.center_x - 527;
circuit_bg.y = config.center_y - 90;
stage.addChild(circuit_bg);
stage.setChildIndex(circuit_bg, 9);



// Circuit Values
var circuit_values_bg = new createjs.Shape();
circuit_values_bg.graphics.beginFill("#ffffff").beginStroke("#667b16").setStrokeStyle(3).drawRoundRect(0, 0, 400, 50, 10);
circuit_values_bg.x = config.center_x + 100;
circuit_values_bg.y = config.center_y + 295;
stage.addChild(circuit_values_bg);
stage.setChildIndex(circuit_values_bg, 10);
stage.update();

var circuit_values_txt = new createjs.Text("Q=0 Kcal/h    V=0 lt/h", "17px Arial", "#d67726");
circuit_values_txt.textAlign = "left";

circuit_values_txt.x = config.center_x + 115;
circuit_values_txt.y = config.center_y + 312;
stage.addChild(circuit_values_txt);

var circuit_values2_txt = new createjs.Text("Δt = t   - t   = 20  C", "17px Arial", "#d67726");
circuit_values2_txt.textAlign = "left";

circuit_values2_txt.x = config.center_x + 348;
circuit_values2_txt.y = config.center_y + 312;
stage.addChild(circuit_values2_txt);

// Subscript "v" and "R"
var circuit_values2sub_txt = new createjs.Text("V      R", "12px Arial", "#d67726");
circuit_values2sub_txt.textAlign = "left";

circuit_values2sub_txt.x = config.center_x + 390;
circuit_values2sub_txt.y = config.center_y + 320;
stage.addChild(circuit_values2sub_txt);

// Superscript "o" 
var circuit_values2sub_txt = new createjs.Text("o", "12px Arial", "#d67726");
circuit_values2sub_txt.textAlign = "left";

circuit_values2sub_txt.x = config.center_x + 467;
circuit_values2sub_txt.y = config.center_y + 310;
stage.addChild(circuit_values2sub_txt);






// main circuit background
var circuit_bg_img = new Image();
circuit_bg_img.src = 'images/circuit-bg.png';

var circuit_bg = new createjs.Bitmap(circuit_bg_img);
circuit_bg.scaleX = circuit_bg.scaleY = 1;
circuit_bg.x = config.center_x - 482;
circuit_bg.y = config.center_y + 75;

circuit_bg_img.onload = function () {
	stage.addChild(circuit_bg);
	//stage.setChildIndex(circuit_bg, 11);
	stage.update();
}


// Blank Circuit
var circuit_add_img = new Image();
circuit_add_img.src = 'images/circuit-add.png';

var circuit_add = new createjs.Bitmap(circuit_add_img);
circuit_add.scaleX = circuit_add.scaleY = 1;
circuit_add.x = config.center_x - 410;	// -410, -200, +10, +220
circuit_add.y = config.center_y - 10;

circuit_add_img.onload = function () {
	stage.setChildIndex(circuit_add, 12);
	stage.addChild(circuit_add);
	stage.update();
}


// Thermical bodies for each position
var device_circuit_img = new Image();
device_circuit_img.src = 'images/circuit-body.png';

var device_circuit = new createjs.Bitmap(device_circuit_img);
device_circuit.scaleX = device_circuit.scaleY = 1;
device_circuit.x = config.center_x - 410;
device_circuit.y = config.center_y - 10;

device_circuit_img.onload = function () {
	stage.setChildIndex(device_circuit, 100);
	stage.addChild(device_circuit);
	stage.update();
}

var device_circuit2 = device_circuit.clone();
device_circuit2.x = config.center_x - 200;
stage.setChildIndex(device_circuit2, 100);
stage.addChild(device_circuit2);

var device_circuit3 = device_circuit.clone();
device_circuit3.x = config.center_x + 10;
stage.setChildIndex(device_circuit3, 100);
stage.addChild(device_circuit3);

var device_circuit4 = device_circuit.clone();
device_circuit4.x = config.center_x + 220;
stage.setChildIndex(device_circuit4, 100);
stage.addChild(device_circuit4);

stage.update();




// Circuit Labels based on positions
var circuit_label1 = new createjs.Text();
circuit_label1.text = "";
circuit_label1.font = "17px Arial";
circuit_label1.color = "#667b16";
circuit_label1.textAlign = "center";
circuit_label1.x = config.center_x - 305;
circuit_label1.y = config.center_y - 50;
stage.addChild(circuit_label1);
//stage.setChildIndex(circuit_label1, 17);

var circuit_label2 = new createjs.Text();
circuit_label2.text = "";
circuit_label2.font = "17px Arial";
circuit_label2.color = "#667b16";
circuit_label2.textAlign = "center";
circuit_label2.x = config.center_x - 95;
circuit_label2.y = config.center_y - 50;
stage.addChild(circuit_label2);
//stage.setChildIndex(circuit_label2, 18);

var circuit_label3 = new createjs.Text();
circuit_label3.text = "";
circuit_label3.font = "17px Arial";
circuit_label3.color = "#667b16";
circuit_label3.textAlign = "center";
circuit_label3.x = config.center_x + 115;
circuit_label3.y = config.center_y - 50;
stage.addChild(circuit_label3);
//stage.setChildIndex(circuit_label3, 19);

var circuit_label4 = new createjs.Text();
circuit_label4.text = "";
circuit_label4.font = "17px Arial";
circuit_label4.color = "#667b16";
circuit_label4.textAlign = "center";
circuit_label4.x = config.center_x + 325;
circuit_label4.y = config.center_y - 50;
stage.addChild(circuit_label4);
//stage.setChildIndex(circuit_label4, 20);

stage.update();

// Q Labels based on positions
var circuit_qlabel1 = new createjs.Text();
circuit_qlabel1.text = "";
circuit_qlabel1.font = "17px Arial";
circuit_qlabel1.color = "#ce621b";
circuit_qlabel1.textAlign = "center";
circuit_qlabel1.x = config.center_x - 305;
circuit_qlabel1.y = config.center_y + 5;
stage.addChild(circuit_qlabel1);
stage.setChildIndex(circuit_qlabel1, 21);

var circuit_qlabel2 = new createjs.Text();
circuit_qlabel2.text = "";
circuit_qlabel2.font = "17px Arial";
circuit_qlabel2.color = "#ce621b";
circuit_qlabel2.textAlign = "center";
circuit_qlabel2.x = config.center_x - 95;
circuit_qlabel2.y = config.center_y + 5;
stage.addChild(circuit_qlabel2);
stage.setChildIndex(circuit_qlabel2, 22);

var circuit_qlabel3 = new createjs.Text();
circuit_qlabel3.text = "";
circuit_qlabel3.font = "17px Arial";
circuit_qlabel3.color = "#ce621b";
circuit_qlabel3.textAlign = "center";
circuit_qlabel3.x = config.center_x + 115;
circuit_qlabel3.y = config.center_y + 5;
stage.addChild(circuit_qlabel3);
stage.setChildIndex(circuit_qlabel3, 23);

var circuit_qlabel4 = new createjs.Text();
circuit_qlabel4.text = "";
circuit_qlabel4.font = "17px Arial";
circuit_qlabel4.color = "#ce621b";
circuit_qlabel4.textAlign = "center";
circuit_qlabel4.x = config.center_x + 325;
circuit_qlabel4.y = config.center_y + 5;
stage.addChild(circuit_qlabel4);
stage.setChildIndex(circuit_qlabel4, 24);


// P Labels based on positions
var circuit_plabel1 = new createjs.Text();
circuit_plabel1.text = "";
circuit_plabel1.font = "17px Arial";
circuit_plabel1.color = "#ce621b";
circuit_plabel1.textAlign = "center";
circuit_plabel1.x = config.center_x - 305;
circuit_plabel1.y = config.center_y + 135;
stage.addChild(circuit_plabel1);
stage.setChildIndex(circuit_plabel1, 25);

var circuit_plabel2 = new createjs.Text();
circuit_plabel2.text = "";
circuit_plabel2.font = "17px Arial";
circuit_plabel2.color = "#ce621b";
circuit_plabel2.textAlign = "center";
circuit_plabel2.x = config.center_x - 95;
circuit_plabel2.y = config.center_y + 135;
stage.addChild(circuit_plabel2);
stage.setChildIndex(circuit_plabel2, 26);

var circuit_plabel3 = new createjs.Text();
circuit_plabel3.text = "";
circuit_plabel3.font = "17px Arial";
circuit_plabel3.color = "#ce621b";
circuit_plabel3.textAlign = "center";
circuit_plabel3.x = config.center_x + 115;
circuit_plabel3.y = config.center_y + 135;
stage.addChild(circuit_plabel3);
stage.setChildIndex(circuit_plabel3, 27);

var circuit_plabel4 = new createjs.Text();
circuit_plabel4.text = "";
circuit_plabel4.font = "17px Arial";
circuit_plabel4.color = "#ce621b";
circuit_plabel4.textAlign = "center";
circuit_plabel4.x = config.center_x + 325;
circuit_plabel4.y = config.center_y + 135;
stage.addChild(circuit_plabel4);
stage.setChildIndex(circuit_plabel4, 28);





// 2nd Tab Area - Temperatures

var temperatures_circuit_img = new Image();
temperatures_circuit_img.src = 'images/temperatures-circuit.png';

var temperatures_circuit = new createjs.Bitmap(temperatures_circuit_img);
temperatures_circuit.scaleX = circuit_add.scaleY = 1;
temperatures_circuit.x = config.center_x - 470;
temperatures_circuit.y = config.center_y - 0;

temperatures_circuit_img.onload = function () {
	stage.addChild(temperatures_circuit);
	stage.update();
}

// Temperatures Circuit Texts
var temperatures_circuit_texts = new createjs.Container();

var temperatures_circuit_text1_img = new Image();
temperatures_circuit_text1_img.src = 'images/temperatures-circuit-text1.png';

var temperatures_circuit_text1 = new createjs.Bitmap(temperatures_circuit_text1_img);
temperatures_circuit_text1.scaleX = temperatures_circuit_text1.scaleY = 1;
temperatures_circuit_text1_img.onload = function () {
	temperatures_circuit_texts.addChild(temperatures_circuit_text1);
	stage.update();
}

var temperatures_circuit_text2_img = new Image();
temperatures_circuit_text2_img.src = 'images/temperatures-circuit-text2.png';

var temperatures_circuit_text2 = new createjs.Bitmap(temperatures_circuit_text2_img);
temperatures_circuit_text2.scaleX = temperatures_circuit_text2.scaleY = 1;
temperatures_circuit_text2_img.onload = function () {
	temperatures_circuit_texts.addChild(temperatures_circuit_text2);
	stage.update();
}

var temperatures_circuit_text3_img = new Image();
temperatures_circuit_text3_img.src = 'images/temperatures-circuit-text3.png';

var temperatures_circuit_text3 = new createjs.Bitmap(temperatures_circuit_text3_img);
temperatures_circuit_text3.scaleX = temperatures_circuit_text3.scaleY = 1;
temperatures_circuit_text3_img.onload = function () {
	temperatures_circuit_texts.addChild(temperatures_circuit_text3);
	stage.update();
}

var temperatures_circuit_text4_img = new Image();
temperatures_circuit_text4_img.src = 'images/temperatures-circuit-text4.png';

var temperatures_circuit_text4 = new createjs.Bitmap(temperatures_circuit_text4_img);
temperatures_circuit_text4.scaleX = temperatures_circuit_text4.scaleY = 1;
temperatures_circuit_text4_img.onload = function () {
	temperatures_circuit_texts.addChild(temperatures_circuit_text4);
	stage.update();
}

temperatures_circuit_texts.x = config.center_x - 462;
temperatures_circuit_texts.y = config.center_y - 35;
stage.addChild(temperatures_circuit_texts);


var temperatures_table_img = new Image();
temperatures_table_img.src = 'images/temperatures-table.png';

var temperatures_table = new createjs.Bitmap(temperatures_table_img);
temperatures_table.scaleX = circuit_add.scaleY = 1;
temperatures_table.x = config.center_x - 125;
temperatures_table.y = config.center_y - 20;

temperatures_table_img.onload = function () {
	stage.addChild(temperatures_table);
	stage.update();
}

// Temperatures Table Highlight
var temperatures_table_highlight = new createjs.Shape();
temperatures_table_highlight.graphics.beginFill("rgba(164, 184, 89, 0.3)").drawRoundRect(0, 0, 615, 46, 0);
temperatures_table_highlight.x = config.center_x - 125;
temperatures_table_highlight.y = config.center_y + 35;  // 35, 81, 127, 174

// Temperatures Table Values
var temperatures_cell_11 = new createjs.Text("-   ", "17px Arial", "#ce621b");
var temperatures_cell_12 = new createjs.Text("-   ", "17px Arial", "#ce621b");
var temperatures_cell_13 = new createjs.Text("-   ", "17px Arial", "#ce621b");
var temperatures_cell_21 = new createjs.Text("-   ", "17px Arial", "#ce621b");
var temperatures_cell_22 = new createjs.Text("-   ", "17px Arial", "#ce621b");
var temperatures_cell_23 = new createjs.Text("-   ", "17px Arial", "#ce621b");
var temperatures_cell_31 = new createjs.Text("-   ", "17px Arial", "#ce621b");
var temperatures_cell_32 = new createjs.Text("-   ", "17px Arial", "#ce621b");
var temperatures_cell_33 = new createjs.Text("-   ", "17px Arial", "#ce621b");
var temperatures_cell_41 = new createjs.Text("-   ", "17px Arial", "#ce621b");
var temperatures_cell_42 = new createjs.Text("-   ", "17px Arial", "#ce621b");
var temperatures_cell_43 = new createjs.Text("-   ", "17px Arial", "#ce621b");

temperatures_cell_11.textAlign = temperatures_cell_12.textAlign = temperatures_cell_13.textAlign = "right";
temperatures_cell_21.textAlign = temperatures_cell_22.textAlign = temperatures_cell_23.textAlign = "right";
temperatures_cell_31.textAlign = temperatures_cell_32.textAlign = temperatures_cell_33.textAlign = "right";
temperatures_cell_41.textAlign = temperatures_cell_42.textAlign = temperatures_cell_43.textAlign = "right";

temperatures_cell_11.x = temperatures_cell_21.x = temperatures_cell_31.x = temperatures_cell_41.x = config.center_x + 136;
temperatures_cell_12.x = temperatures_cell_22.x = temperatures_cell_32.x = temperatures_cell_42.x = config.center_x + 280;
temperatures_cell_13.x = temperatures_cell_23.x = temperatures_cell_33.x = temperatures_cell_43.x = config.center_x + 438;
temperatures_cell_11.y = temperatures_cell_12.y = temperatures_cell_13.y = config.center_y + 49;
temperatures_cell_21.y = temperatures_cell_22.y = temperatures_cell_23.y = config.center_y + 94;
temperatures_cell_31.y = temperatures_cell_32.y = temperatures_cell_33.y = config.center_y + 141;
temperatures_cell_41.y = temperatures_cell_42.y = temperatures_cell_43.y = config.center_y + 186;

var temperatures_table_values = new createjs.Container();
temperatures_table_values.addChild(temperatures_table_highlight);
temperatures_table_values.addChild(temperatures_cell_11);
temperatures_table_values.addChild(temperatures_cell_11);
temperatures_table_values.addChild(temperatures_cell_12);
temperatures_table_values.addChild(temperatures_cell_13);
temperatures_table_values.addChild(temperatures_cell_21);
temperatures_table_values.addChild(temperatures_cell_22);
temperatures_table_values.addChild(temperatures_cell_23);
temperatures_table_values.addChild(temperatures_cell_31);
temperatures_table_values.addChild(temperatures_cell_32);
temperatures_table_values.addChild(temperatures_cell_33);
temperatures_table_values.addChild(temperatures_cell_41);
temperatures_table_values.addChild(temperatures_cell_42);
temperatures_table_values.addChild(temperatures_cell_43);


stage.addChild(temperatures_table_values);



// 3rd Tab Area - Power
var power_graph_img = new Image();
power_graph_img.src = 'images/power-graph.png';

var power_graph = new createjs.Bitmap(power_graph_img);
power_graph.scaleX = circuit_add.scaleY = 1;
power_graph.x = config.center_x - 470;
power_graph.y = config.center_y - 60;

power_graph_img.onload = function () {
	stage.addChild(power_graph);
	stage.update();
}

var power_table_img = new Image();
power_table_img.src = 'images/power-table.png';

var power_table = new createjs.Bitmap(power_table_img);
power_table.scaleX = circuit_add.scaleY = 1;
power_table.x = config.center_x - 30;
power_table.y = config.center_y - 20;

power_table_img.onload = function () {
	stage.addChild(power_table);
	stage.update();
}

// Power Table Values
var power_cell_11 = new createjs.Text("-   ", "17px Arial", "#ce621b");
var power_cell_12 = new createjs.Text("-   ", "17px Arial", "#ce621b");
var power_cell_21 = new createjs.Text("-   ", "17px Arial", "#ce621b");
var power_cell_22 = new createjs.Text("-   ", "17px Arial", "#ce621b");
var power_cell_31 = new createjs.Text("-   ", "17px Arial", "#ce621b");
var power_cell_32 = new createjs.Text("-   ", "17px Arial", "#ce621b");
var power_cell_41 = new createjs.Text("-   ", "17px Arial", "#ce621b");
var power_cell_42 = new createjs.Text("-   ", "17px Arial", "#ce621b");

power_cell_11.textAlign = power_cell_12.textAlign = "right";
power_cell_21.textAlign = power_cell_22.textAlign = "right";
power_cell_31.textAlign = power_cell_32.textAlign = "right";
power_cell_41.textAlign = power_cell_42.textAlign = "right";

power_cell_11.x = power_cell_21.x = power_cell_31.x = power_cell_41.x = config.center_x + 245;
power_cell_12.x = power_cell_22.x = power_cell_32.x = power_cell_42.x = config.center_x + 445;
power_cell_11.y = power_cell_12.y = config.center_y + 55;
power_cell_21.y = power_cell_22.y = config.center_y + 105;
power_cell_31.y = power_cell_32.y = config.center_y + 155;
power_cell_41.y = power_cell_42.y = config.center_y + 205;

var power_table_values = new createjs.Container();
power_table_values.addChild(power_cell_11);
power_table_values.addChild(power_cell_12);
power_table_values.addChild(power_cell_21);
power_table_values.addChild(power_cell_22);
power_table_values.addChild(power_cell_31);
power_table_values.addChild(power_cell_32);
power_table_values.addChild(power_cell_41);
power_table_values.addChild(power_cell_42);

stage.addChild(power_table_values);


// Create Clickable Areas

// Theory button
var theory_btn_area = new createjs.Shape();
theory_btn_area.graphics.beginFill(config.click_area_color).drawRoundRect(0, 0, 237, 49, 10);
theory_btn_area.x = config.center_x + 285;
theory_btn_area.y = config.center_y - 330;
theory_btn_area.cursor = "pointer"; // show pointer on mouseover
stage.addChild(theory_btn_area);
stage.setChildIndex(theory_btn_area, 29);

// Application button
var app_btn_area = new createjs.Shape();
app_btn_area.graphics.beginFill(config.click_area_color).drawRoundRect(0, 0, 237, 49, 10);
app_btn_area.x = config.center_x + 285;
app_btn_area.y = config.center_y - 265;
app_btn_area.cursor = "pointer"; // show pointer on mouseover
stage.addChild(app_btn_area);
stage.setChildIndex(app_btn_area, 30);

// Investigation button
var inv_btn_area = new createjs.Shape();
inv_btn_area.graphics.beginFill(config.click_area_color).drawRoundRect(0, 0, 237, 49, 10);
inv_btn_area.x = config.center_x + 285;
inv_btn_area.y = config.center_y - 200;
inv_btn_area.cursor = "pointer"; // show pointer on mouseover
stage.addChild(inv_btn_area);
stage.setChildIndex(inv_btn_area, 31);

// Specs Button
var specs_btn_area = new createjs.Shape();
specs_btn_area.graphics.beginFill(config.click_area_color).drawRoundRect(0, 0, 244, 64, 10);
specs_btn_area.x = config.center_x - 110;
specs_btn_area.y = config.center_y - 220;
specs_btn_area.cursor = "pointer"; // show pointer on mouseover
stage.addChild(specs_btn_area);
stage.setChildIndex(specs_btn_area, 32);


// Pick Q Next
var q_arrow_next = new createjs.Shape();
q_arrow_next.graphics.beginFill(config.click_area_color).drawRoundRect(0, 0, 25, 25, 0);
q_arrow_next.x = config.center_x - 182;
q_arrow_next.y = config.center_y - 170;
q_arrow_next.cursor = "pointer"; // show pointer on mouseover
stage.addChild(q_arrow_next);
stage.setChildIndex(q_arrow_next, 33);

// Pick Q Previous
var q_arrow_prev = new createjs.Shape();
q_arrow_prev.graphics.beginFill(config.click_area_color).drawRoundRect(0, 0, 25, 25, 0);
q_arrow_prev.x = config.center_x - 310;
q_arrow_prev.y = config.center_y - 170;
q_arrow_prev.cursor = "pointer"; // show pointer on mouseover
stage.addChild(q_arrow_prev);
stage.setChildIndex(q_arrow_prev, 34);


// Pick Pi Next
var pi_arrow_next = new createjs.Shape();
pi_arrow_next.graphics.beginFill(config.click_area_color).drawRoundRect(0, 0, 25, 25, 0);
pi_arrow_next.x = config.center_x - 390;
pi_arrow_next.y = config.center_y - 170;
pi_arrow_next.cursor = "pointer"; // show pointer on mouseover
stage.addChild(pi_arrow_next);
stage.setChildIndex(pi_arrow_next, 35);

// Pick Pi Previous
var pi_arrow_prev = new createjs.Shape();
pi_arrow_prev.graphics.beginFill(config.click_area_color).drawRoundRect(0, 0, 25, 25, 0);
pi_arrow_prev.x = config.center_x - 466;
pi_arrow_prev.y = config.center_y - 170;
pi_arrow_prev.cursor = "pointer"; // show pointer on mouseover
stage.addChild(pi_arrow_prev);
stage.setChildIndex(pi_arrow_prev, 36);



// Add device button
var device_add_btn = new createjs.Shape();
device_add_btn.graphics.beginFill(config.click_area_color).drawRoundRect(0, 0, 123, 28, 10);
device_add_btn.x = config.center_x - 290;
device_add_btn.y = config.center_y - 135;
device_add_btn.cursor = "pointer"; // show pointer on mouseover
stage.addChild(device_add_btn);
stage.setChildIndex(device_add_btn, 37);





// Remove 1st Device
var rm_device = new Array();
rm_device[0] = new createjs.Shape();
rm_device[0].graphics.beginFill(config.click_area_color).drawRoundRect(0, 0, 25, 25, 0);
rm_device[0].x = config.center_x - 260;
rm_device[0].y = config.center_y + 130;
rm_device[0].cursor = "pointer"; // show pointer on mouseover
stage.addChild(rm_device[0]);
stage.setChildIndex(rm_device[0], 38);

// Remove 2st Device
rm_device[1] = new createjs.Shape();
rm_device[1].graphics.beginFill(config.click_area_color).drawRoundRect(0, 0, 25, 25, 0);
rm_device[1].x = config.center_x - 50;
rm_device[1].y = config.center_y + 130;
rm_device[1].cursor = "pointer"; // show pointer on mouseover
stage.addChild(rm_device[1]);
stage.setChildIndex(rm_device[1], 39);

// Remove 3st Device
rm_device[2] = new createjs.Shape();
rm_device[2].graphics.beginFill(config.click_area_color).drawRoundRect(0, 0, 25, 25, 0);
rm_device[2].x = config.center_x + 160 ;
rm_device[2].y = config.center_y + 130;
rm_device[2].cursor = "pointer"; // show pointer on mouseover
stage.addChild(rm_device[2]);
stage.setChildIndex(rm_device[2], 40);

// Remove 4st Device
rm_device[3] = new createjs.Shape();
rm_device[3].graphics.beginFill(config.click_area_color).drawRoundRect(0, 0, 25, 25, 0);
rm_device[3].x = config.center_x + 370;
rm_device[3].y = config.center_y + 130;
rm_device[3].cursor = "pointer"; // show pointer on mouseover
stage.addChild(rm_device[3]);
stage.setChildIndex(rm_device[3], 41);


// Temparatures table highlight areas
var temperatures_table_highlight_area1 = new createjs.Shape();
temperatures_table_highlight_area1.graphics.beginFill(config.click_area_color).drawRoundRect(0, 0, 615, 46, 0);
temperatures_table_highlight_area1.x = config.center_x - 125;
temperatures_table_highlight_area1.y = config.center_y + 35;  // 35, 81, 127, 174
temperatures_table_highlight_area1.cursor = "pointer"; // show pointer on mouseover
temperatures_table_values.addChild(temperatures_table_highlight_area1);

var temperatures_table_highlight_area2 = new createjs.Shape();
temperatures_table_highlight_area2.graphics.beginFill(config.click_area_color).drawRoundRect(0, 0, 615, 46, 0);
temperatures_table_highlight_area2.x = config.center_x - 125;
temperatures_table_highlight_area2.y = config.center_y + 81;  // 35, 81, 127, 174
temperatures_table_highlight_area2.cursor = "pointer"; // show pointer on mouseover
temperatures_table_values.addChild(temperatures_table_highlight_area2);

var temperatures_table_highlight_area3 = new createjs.Shape();
temperatures_table_highlight_area3.graphics.beginFill(config.click_area_color).drawRoundRect(0, 0, 615, 46, 0);
temperatures_table_highlight_area3.x = config.center_x - 125;
temperatures_table_highlight_area3.y = config.center_y + 127;  // 35, 81, 127, 174
temperatures_table_highlight_area3.cursor = "pointer"; // show pointer on mouseover
temperatures_table_values.addChild(temperatures_table_highlight_area3);

var temperatures_table_highlight_area4 = new createjs.Shape();
temperatures_table_highlight_area4.graphics.beginFill(config.click_area_color).drawRoundRect(0, 0, 615, 46, 0);
temperatures_table_highlight_area4.x = config.center_x - 125;
temperatures_table_highlight_area4.y = config.center_y + 174;  // 35, 81, 127, 174
temperatures_table_highlight_area4.cursor = "pointer"; // show pointer on mouseover
temperatures_table_values.addChild(temperatures_table_highlight_area4);


// Enable Mouseover on stage
stage.enableMouseOver();





// Stage update
stage.update();

