/*
 Copyright (c) 2012 Humu humu2009@gmail.com
 jsc3d is freely distributable under the terms of the MIT license.

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
*/
var JSC3D=JSC3D||{};
JSC3D.Viewer=function(a,b){this.params=b?{SceneUrl:b.SceneUrl||"",MtlLibUrl:b.MtlLibUrl||"",InitRotationX:b.InitRotationX||0,InitRotationY:b.InitRotationY||0,InitRotationZ:b.InitRotationZ||0,ModelColor:b.ModelColor||"#caa618",BackgroundColor1:b.BackgroundColor1||"#ffffff",BackgroundColor2:b.BackgroundColor2||"#383840",BackgroundImageUrl:b.BackgroundImageUrl||"",RenderMode:b.RenderMode||"flat",Definition:b.Definition||"standard",MipMapping:b.MipMapping||"off",SphereMapUrl:b.SphereMapUrl||""}:{SceneUrl:"",
MtlLibUrl:"",InitRotationX:0,InitRotationY:0,InitRotationZ:0,ModelColor:"#caa618",BackgroundColor1:"#ffffff",BackgroundColor2:"#383840",BackgroundImageUrl:"",RenderMode:"flat",Definition:"standard",MipMapping:"off",SphereMapUrl:""};this.canvas=a;this.selectionBuffer=this.zBuffer=this.colorBuffer=this.bkgColorBuffer=this.canvasData=this.ctx=null;this.frameWidth=a.width;this.frameHeight=a.height;this.sphereMap=this.defaultMaterial=this.scene=null;this.isFailed=this.isLoaded=!1;this.errorMsg="";this.needRepaint=
this.needUpdate=!1;this.initRotZ=this.initRotY=this.initRotX=0;this.zoomFactor=1;this.rotMatrix=new JSC3D.Matrix3x4;this.transformMatrix=new JSC3D.Matrix3x4;this.mtlLibUrl=this.sceneUrl="";this.modelColor=13280792;this.bkgColor1=16777215;this.bkgColor2=3684416;this.bkgImageUrl="";this.bkgImage=null;this.renderMode="flat";this.definition="standard";this.isMipMappingOn=!1;this.sphereMapUrl="";this.buttonStates={};this.keyStates={};this.mouseY=this.mouseX=0;this.afterupdate=this.beforeupdate=this.onmousemove=
this.onmouseup=this.onmousedown=null;this.mouseUsage="default";this.isDefaultInputHandlerEnabled=!0;var c=this;void 0==document.createTouch?(this.canvas.addEventListener("mousedown",function(a){c.mouseDownHandler(a)},!1),this.canvas.addEventListener("mouseup",function(a){c.mouseUpHandler(a)},!1),this.canvas.addEventListener("mousemove",function(a){c.mouseMoveHandler(a)},!1),document.addEventListener("keydown",function(a){c.keyDownHandler(a)},!1),document.addEventListener("keyup",function(a){c.keyUpHandler(a)},
!1)):(this.canvas.addEventListener("touchstart",function(a){c.touchStartHandler(a)},!1),this.canvas.addEventListener("touchend",function(a){c.touchEndHandler(a)},!1),this.canvas.addEventListener("touchmove",function(a){c.touchMoveHandler(a)},!1))};JSC3D.Viewer.prototype.setParameter=function(a,b){this.params[a]=b};
JSC3D.Viewer.prototype.init=function(){this.sceneUrl=this.params.SceneUrl;this.mtlLibUrl=this.params.MtlLibUrl;this.initRotX=parseFloat(this.params.InitRotationX);this.initRotY=parseFloat(this.params.InitRotationY);this.initRotZ=parseFloat(this.params.InitRotationZ);this.modelColor=parseInt("0x"+this.params.ModelColor.substring(1));this.bkgColor1=parseInt("0x"+this.params.BackgroundColor1.substring(1));this.bkgColor2=parseInt("0x"+this.params.BackgroundColor2.substring(1));this.bkgImageUrl=this.params.BackgroundImageUrl;
this.renderMode=this.params.RenderMode.toLowerCase();this.definition=this.params.Definition.toLowerCase();this.isMipMappingOn="on"==this.params.MipMapping.toLowerCase();this.sphereMapUrl=this.params.SphereMapUrl;try{this.ctx=this.canvas.getContext("2d"),this.canvasData=this.ctx.getImageData(0,0,this.canvas.width,this.canvas.height)}catch(a){this.canvasData=this.ctx=null}if(2>=this.canvas.width||2>=this.canvas.height)this.definition="standard";switch(this.definition){case "low":this.frameWidth=~~((this.canvas.width+
1)/2);this.frameHeight=~~((this.canvas.height+1)/2);break;case "high":this.frameWidth=2*this.canvas.width;this.frameHeight=2*this.canvas.height;break;default:this.frameWidth=this.canvas.width,this.frameHeight=this.canvas.height}this.zoomFactor=1;this.rotMatrix.identity();this.transformMatrix.identity();this.isFailed=this.isLoaded=!1;this.errorMsg="";this.needRepaint=this.needUpdate=!1;this.scene=null;this.colorBuffer=Array(this.frameWidth*this.frameHeight);this.zBuffer=Array(this.frameWidth*this.frameHeight);
this.selectionBuffer=Array(this.frameWidth*this.frameHeight);this.bkgColorBuffer=Array(this.frameWidth*this.frameHeight);this.generateBackground();this.defaultMaterial=new JSC3D.Material;this.defaultMaterial.ambientColor=0;this.defaultMaterial.diffuseColor=this.modelColor;this.defaultMaterial.transparency=0;this.defaultMaterial.simulateSpecular=!0;this.drawBackground();var b=this;setInterval(function(){b.doUpdate()},30);this.setBackgroudImageFromUrl(this.bkgImageUrl);this.loadScene();this.setSphereMapFromUrl(this.sphereMapUrl)};
JSC3D.Viewer.prototype.update=function(a){this.isFailed?this.reportError(this.errorMsg):a?this.needRepaint=!0:this.needUpdate=!0};JSC3D.Viewer.prototype.rotate=function(a,b,c){this.rotMatrix.rotateAboutXAxis(a);this.rotMatrix.rotateAboutYAxis(b);this.rotMatrix.rotateAboutZAxis(c)};JSC3D.Viewer.prototype.setRenderMode=function(a){this.renderMode=this.params.RenderMode=a};
JSC3D.Viewer.prototype.setDefinition=function(a){if(2>=this.canvas.width||2>=this.canvas.height)a="standard";if(a!=this.definition){this.definition=this.params.Definition=a;a=this.frameWidth;switch(this.definition){case "low":this.frameWidth=~~((this.canvas.width+1)/2);this.frameHeight=~~((this.canvas.height+1)/2);break;case "high":this.frameWidth=2*this.canvas.width;this.frameHeight=2*this.canvas.height;break;default:this.frameWidth=this.canvas.width,this.frameHeight=this.canvas.height}var b=this.frameWidth*
this.frameHeight;this.colorBuffer.length<b&&(this.colorBuffer=Array(b));this.zBuffer.length<b&&(this.zBuffer=Array(b));this.selectionBuffer.length<b&&(this.selectionBuffer=Array(b));this.bkgColorBuffer.length<b&&(this.bkgColorBuffer=Array(b));this.generateBackground();this.zoomFactor*=this.frameWidth/a}};
JSC3D.Viewer.prototype.setBackgroudImageFromUrl=function(a){this.bkgImageUrl=this.params.BackgroundImageUrl=a;if(""==a)this.bkgImage=null;else{var b=this,c=new Image;c.onload=function(){b.bkgImage=this;b.generateBackground()};c.src=a}};JSC3D.Viewer.prototype.setSphereMapFromUrl=function(a){this.sphereMapUrl=this.params.SphereMapUrl=a;if(""==a)this.sphereMap=null;else{var b=this,c=new JSC3D.Texture;c.onready=function(){b.sphereMap=c;b.update()};c.createFromUrl(this.sphereMapUrl)}};
JSC3D.Viewer.prototype.enableDefaultInputHandler=function(a){this.isDefaultInputHandlerEnabled=a};JSC3D.Viewer.prototype.setMouseUsage=function(a){this.mouseUsage=a};JSC3D.Viewer.prototype.replaceSceneFromUrl=function(a){this.sceneUrl=this.params.SceneUrl=a;this.isFailed=this.isLoaded=!1;this.loadScene()};JSC3D.Viewer.prototype.replaceScene=function(a){this.sceneUrl=this.params.SceneUrl="";this.isFailed=!1;this.isLoaded=!0;this.errorMsg="";this.setupScene(a)};JSC3D.Viewer.prototype.getScene=function(){return this.scene};
JSC3D.Viewer.prototype.pick=function(a,b){var c=new JSC3D.PickInfo,e=this.canvas.getBoundingClientRect(),d=a-e.left,e=b-e.top,f=d,g=e;if(null!=this.selectionBuffer&&0<=d&&d<this.canvas.width&&0<=e&&e<this.canvas.height){switch(this.definition){case "low":f=~~(f/2);g=~~(g/2);break;case "high":f*=2,g*=2}var h=this.selectionBuffer[g*this.frameWidth+f];if(0<h)for(var k=this.scene.getChildren(),l=0;l<k.length;l++)if(k[l].internalId==h){c.mesh=k[l];break}}c.canvasX=d;c.canvasY=e;c.mesh&&(c.depth=this.zBuffer[g*
this.frameWidth+f]);return c};JSC3D.Viewer.prototype.doUpdate=function(){if(this.needUpdate||this.needRepaint)null!=this.beforeupdate&&"function"==typeof this.beforeupdate&&this.beforeupdate(),this.scene?(this.needUpdate&&null!=this.colorBuffer&&(this.beginScene(),this.render(),this.endScene()),this.paint()):this.drawBackground(),this.needUpdate=this.needRepaint=!1,null!=this.afterupdate&&"function"==typeof this.afterupdate&&this.afterupdate()};
JSC3D.Viewer.prototype.paint=function(){this.canvasData&&this.ctx.putImageData(this.canvasData,0,0)};JSC3D.Viewer.prototype.mouseDownHandler=function(a){if(this.onmousedown){var b=this.pick(a.clientX,a.clientY);this.onmousedown(b.canvasX,b.canvasY,a.button,b.depth,b.mesh)}a.preventDefault();this.isDefaultInputHandlerEnabled&&(this.buttonStates[a.button]=!0,this.mouseX=a.clientX,this.mouseY=a.clientY)};
JSC3D.Viewer.prototype.mouseUpHandler=function(a){if(this.onmouseup){var b=this.pick(a.clientX,a.clientY);this.onmouseup(b.canvasX,b.canvasY,a.button,b.depth,b.mesh)}a.preventDefault();this.isDefaultInputHandlerEnabled&&(this.buttonStates[a.button]=!1)};
JSC3D.Viewer.prototype.mouseMoveHandler=function(a){if(this.onmousemove){var b=this.pick(a.clientX,a.clientY);this.onmousemove(b.canvasX,b.canvasY,a.button,b.depth,b.mesh)}a.preventDefault();if(this.isDefaultInputHandlerEnabled&&(b=!0==this.keyStates[16],!0==this.buttonStates[0])){if(b&&"default"==this.mouseUsage||"zoom"==this.mouseUsage)this.zoomFactor*=this.mouseY<=a.clientY?1.11:0.9;else if("default"==this.mouseUsage||"rotate"==this.mouseUsage)b=360*(a.clientX-this.mouseX)/this.canvas.height,this.rotMatrix.rotateAboutXAxis(360*
(a.clientY-this.mouseY)/this.canvas.width),this.rotMatrix.rotateAboutYAxis(b);this.mouseX=a.clientX;this.mouseY=a.clientY;this.update()}};JSC3D.Viewer.prototype.touchStartHandler=function(a){if(0<a.touches.length){var b=a.touches[0].clientX,c=a.touches[0].clientY;if(this.onmousedown){var e=this.pick(b,c);this.onmousedown(e.canvasX,e.canvasY,0,e.depth,e.mesh)}a.preventDefault();this.isDefaultInputHandlerEnabled&&(this.buttonStates[0]=!0,this.mouseX=b,this.mouseY=c)}};
JSC3D.Viewer.prototype.touchEndHandler=function(a){if(this.onmouseup){var b=this.pick(this.mouseX,this.mouseY);this.onmouseup(b.canvasX,b.canvasY,0,b.depth,b.mesh)}a.preventDefault();this.isDefaultInputHandlerEnabled&&(this.buttonStates[0]=!1)};
JSC3D.Viewer.prototype.touchMoveHandler=function(a){if(0<a.touches.length){var b=a.touches[0].clientX,c=a.touches[0].clientY;if(this.onmousemove){var e=this.pick(b,c);this.onmousemove(e.canvasX,e.canvasY,0,e.depth,e.mesh)}a.preventDefault();if(this.isDefaultInputHandlerEnabled){if("zoom"==this.mouseUsage)this.zoomFactor*=this.mouseY<=c?1.11:0.9;else if("default"==this.mouseUsage||"rotate"==this.mouseUsage)a=360*(b-this.mouseX)/this.canvas.height,this.rotMatrix.rotateAboutXAxis(360*(c-this.mouseY)/
this.canvas.width),this.rotMatrix.rotateAboutYAxis(a);this.mouseX=b;this.mouseY=c;this.update()}}};JSC3D.Viewer.prototype.keyDownHandler=function(a){this.isDefaultInputHandlerEnabled&&(this.keyStates[a.keyCode]=!0)};JSC3D.Viewer.prototype.keyUpHandler=function(a){this.isDefaultInputHandlerEnabled&&(this.keyStates[a.keyCode]=!1)};
JSC3D.Viewer.prototype.loadScene=function(){this.scene=null;this.isLoaded=!1;if(""==this.sceneUrl)return!1;var a=this.sceneUrl.lastIndexOf("/");-1==a&&(a=this.sceneUrl.lastIndexOf("\\"));var a=this.sceneUrl.substring(a+1),b=a.lastIndexOf(".");if(-1==b)return!1;a=a.substring(b+1);a=JSC3D.LoaderSelector.getLoader(a);if(!a)return!1;a.setMtlLibUrl(this.mtlLibUrl);var c=this;c.dfd=new $.Deferred;c.loadPromise=c.dfd.promise();a.onload=function(a){c.setupScene(a);c.dfd.resolve()};a.onerror=function(a){c.scene=
null;c.isLoaded=!1;c.isFailed=!0;c.errorMsg=a;c.update();c.dfd.fail()};a.onprogress=function(a,b){c.reportProgress(a,b);c.dfd.progress()};a.onresource=function(a){a instanceof JSC3D.Texture&&(c.isMipMappingOn&&!a.hasMipmap())&&a.generateMipmaps();c.update();c.dfd.resolve()};a.loadFromUrl(this.sceneUrl);return!0};
JSC3D.Viewer.prototype.setupScene=function(a){a.init();if(!a.isEmpty()){var b=a.aabb.lengthOfDiagonal(),c=this.frameWidth,e=this.frameHeight;this.zoomFactor=0==b?1:(c<e?c:e)/b}this.rotMatrix.identity();this.rotMatrix.rotateAboutXAxis(this.initRotX);this.rotMatrix.rotateAboutYAxis(this.initRotY);this.rotMatrix.rotateAboutZAxis(this.initRotZ);this.scene=a;this.isLoaded=!0;this.isFailed=!1;this.errorMsg="";this.needRepaint=this.needUpdate=!1;this.update()};
JSC3D.Viewer.prototype.reportProgress=function(a,b){if(this.ctx){this.drawBackground();this.ctx.save();var c=255-((this.bkgColor1&65280)>>8),e=255-(this.bkgColor1&255),c="#"+(255-((this.bkgColor1&16711680)>>16)).toString(16)+c.toString(16)+e.toString(16);this.ctx.strokeStyle=c;this.ctx.fillStyle=c;c=0.38*this.canvas.height;e=this.canvas.width-80;this.ctx.strokeRect(40,c,e,20);this.ctx.fillRect(42,c+2,(e-4)*b,16);this.ctx.font="12px Courier New";this.ctx.textAlign="left";this.ctx.fillText(a,40,c-4,
e);this.ctx.restore()}};JSC3D.Viewer.prototype.reportError=function(a){if(this.ctx){this.drawBackground();this.ctx.save();var b=0.38*this.canvas.height-4,c=255-((this.bkgColor1&65280)>>8),e=255-(this.bkgColor1&255),c="#"+(255-((this.bkgColor1&16711680)>>16)).toString(16)+c.toString(16)+e.toString(16);this.ctx.fillStyle=c;this.ctx.font="16px Courier New";this.ctx.textAlign="left";this.ctx.fillText(a,40,b);this.ctx.restore()}};
JSC3D.Viewer.prototype.generateBackground=function(){this.bkgImage?this.fillBackgroundWithImage():this.fillGradientBackground()};
JSC3D.Viewer.prototype.fillGradientBackground=function(){for(var a=this.frameWidth,b=this.frameHeight,c=this.bkgColorBuffer,e=(this.bkgColor1&16711680)>>16,d=(this.bkgColor1&65280)>>8,f=this.bkgColor1&255,g=(this.bkgColor2&16711680)>>16,h=(this.bkgColor2&65280)>>8,k=this.bkgColor2&255,l=0,o=0;o<b;o++)for(var i=e+o*(g-e)/b&255,H=d+o*(h-d)/b&255,q=f+o*(k-f)/b&255,I=0;I<a;I++)c[l++]=i<<16|H<<8|q};
JSC3D.Viewer.prototype.fillBackgroundWithImage=function(){var a=this.frameWidth,b=this.frameHeight;if(!(0>=this.bkgImage.width||0>=this.bkgImage.height)){var c=!1,e=JSC3D.Texture.cv;if(!e)try{e=document.createElement("canvas"),JSC3D.Texture.cv=e,c=!0}catch(d){return}if(e.width!=a||e.height!=b)e.width=a,e.height=b,c=!0;var f=null;try{var g=e.getContext("2d");c||g.clearRect(0,0,a,b);g.drawImage(this.bkgImage,0,0,a,b);f=g.getImageData(0,0,a,b).data}catch(h){return}c=this.bkgColorBuffer;a*=b;for(e=b=
0;b<a;b++,e+=4)c[b]=f[e]<<16|f[e+1]<<8|f[e+2]}};JSC3D.Viewer.prototype.drawBackground=function(){this.canvasData&&(this.beginScene(),this.endScene(),this.paint())};JSC3D.Viewer.prototype.beginScene=function(){for(var a=this.colorBuffer,b=this.zBuffer,c=this.selectionBuffer,e=this.bkgColorBuffer,d=this.frameWidth*this.frameHeight,f=-Number.MAX_VALUE,g=0;g<d;g++)a[g]=e[g],b[g]=f,c[g]=0};
JSC3D.Viewer.prototype.endScene=function(){var a=this.canvasData.data,b=this.canvas.width,c=this.canvas.height,e=this.colorBuffer,d=this.frameWidth,f=d*this.frameHeight;switch(this.definition){case "low":for(var g=b>>1,h=d-g,k=0,l=0,f=0;f<c;f++){for(var o=0;o<b;o++)d=e[k],a[l]=(d&16711680)>>16,a[l+1]=(d&65280)>>8,a[l+2]=d&255,a[l+3]=255,k+=o&1,l+=4;k+=f&1?h:-g}break;case "high":for(f=l=k=0;f<c;f++){for(o=0;o<b;o++){var g=e[k],h=e[k+1],i=e[k+d],H=e[k+d+1];a[l]=(g&16711680)+(h&16711680)+(i&16711680)+
(H&16711680)>>18;a[l+1]=(g&65280)+(h&65280)+(i&65280)+(H&65280)>>10;a[l+2]=(g&255)+(h&255)+(i&255)+(H&255)>>2;a[l+3]=255;k+=2;l+=4}k+=d}break;default:for(l=k=0;k<f;k++,l+=4)d=e[k],a[l]=(d&16711680)>>16,a[l+1]=(d&65280)>>8,a[l+2]=d&255,a[l+3]=255}};
JSC3D.Viewer.prototype.render=function(){if(!this.scene.isEmpty()){var a=this.scene.aabb;this.transformMatrix.identity();this.transformMatrix.translate(-(a.minX+a.maxX)/2,-(a.minY+a.maxY)/2,-(a.minZ+a.maxZ)/2);this.transformMatrix.multiply(this.rotMatrix);this.transformMatrix.scale(this.zoomFactor,-this.zoomFactor,this.zoomFactor);this.transformMatrix.translate(this.frameWidth/2,this.frameHeight/2,0);for(var a=this.sortScene(this.transformMatrix),b=0;b<a.length;b++){var c=a[b];if(!c.isTrivial()&&
(JSC3D.Math3D.transformVectors(this.transformMatrix,c.vertexBuffer,c.transformedVertexBuffer),c.visible))switch(this.renderMode){case "point":this.renderPoint(c);break;case "wireframe":this.renderWireframe(c);break;case "flat":this.renderSolidFlat(c);break;case "smooth":this.renderSolidSmooth(c);break;case "texture":c.hasTexture()?this.renderSolidTexture(c):this.renderSolidFlat(c);break;case "textureflat":c.hasTexture()?this.renderTextureFlat(c):this.renderSolidFlat(c);break;case "texturesmooth":c.isEnvironmentCast&&
null!=this.sphereMap&&this.sphereMap.hasData()?this.renderSolidSphereMapped(c):c.hasTexture()?this.renderTextureSmooth(c):this.renderSolidSmooth(c);break;default:this.renderSolidFlat(c)}}}};
JSC3D.Viewer.prototype.sortScene=function(a){for(var b=[],c=this.scene.getChildren(),e=0;e<c.length;e++){var d=c[e];if(!d.isTrivial()){b.push(d);var f=d.aabb.center();JSC3D.Math3D.transformVectors(a,f,f);d.sortKey={depth:f[2],isTransparnt:0<(d.material?d.material:this.defaultMaterial).transparency||(d.hasTexture()?d.texture.hasTransparency:!1)}}}b.sort(function(a,b){return!a.sortKey.isTransparnt&&b.sortKey.isTransparnt?-1:a.sortKey.isTransparnt&&!b.sortKey.isTransparnt?1:a.sortKey.isTransparnt?a.sortKey.depth-
b.sortKey.depth:b.sortKey.depth-a.sortKey.depth});return b};
JSC3D.Viewer.prototype.renderPoint=function(a){var b=this.frameWidth,c=b-1,e=this.frameHeight-1,d=a.transformedVertexBuffer,f=a.transformedVertexNormalZBuffer,g=this.colorBuffer,h=this.zBuffer,k=this.selectionBuffer,l=d.length/3,o=a.internalId,i=a.material?a.material.diffuseColor:this.defaultMaterial.diffuseColor;if(!f||f.length<l)a.transformedVertexNormalZBuffer=Array(l),f=a.transformedVertexNormalZBuffer;JSC3D.Math3D.transformVectorZs(this.rotMatrix,a.vertexNormalBuffer,f);for(var H=0,q=0;H<l;H++,
q+=3){var I=f[H];a.isDoubleSided&&(I=0<I?I:-I);if(0<I){var v=~~(d[q]+0.5),t=~~(d[q+1]+0.5),I=d[q+2];if(0<=v&&(v<c&&0<=t&&t<e)&&(v=t*b+v,I>h[v]&&(h[v]=I,g[v]=i,k[v]=o),v++,I>h[v]&&(h[v]=I,g[v]=i,k[v]=o),v+=c,I>h[v]&&(h[v]=I,g[v]=i,k[v]=o),v++,I>h[v]))h[v]=I,g[v]=i,k[v]=o}}};
JSC3D.Viewer.prototype.renderWireframe=function(a){var b=this.frameWidth,c=b-1,e=this.frameHeight-1,d=a.indexBuffer,f=a.transformedVertexBuffer,g=a.transformedFaceNormalZBuffer,h=this.colorBuffer,k=this.zBuffer,l=this.selectionBuffer,o=a.faceCount,i=a.internalId,H=a.material?a.material.diffuseColor:this.defaultMaterial.diffuseColor;if(!g||g.length<o)a.transformedFaceNormalZBuffer=Array(o),g=a.transformedFaceNormalZBuffer;JSC3D.Math3D.transformVectorZs(this.rotMatrix,a.faceNormalBuffer,g);for(var q=
0,I=0;q<o;){var v=g[q++];a.isDoubleSided&&(v=0<v?v:-v);if(0>v){do;while(-1!=d[I++])}else{var t,B;t=3*d[I++];B=3*d[I++];for(var v=t,C=!1;!C;){var w=~~(f[t]+0.5),z=~~(f[t+1]+0.5),u=f[t+2],D=~~(f[B]+0.5),m=~~(f[B+1]+0.5),p=f[B+2],y=D-w,n=m-z,x=p-u,j,E,G;Math.abs(y)>Math.abs(n)?(j=y,E=0<y?1:-1,G=0!=y?E*n/y:0,y=0!=y?E*x/y:0):(j=n,G=0<n?1:-1,E=0!=n?G*y/n:0,y=0!=n?G*x/n:0);0>j&&(w=D,z=m,u=p,j=-j,E=-E,G=-G,y=-y);for(D=0;D<j;D++)0<=w&&(w<c&&0<=z&&z<e)&&(m=~~z*b+~~w,u>k[m]&&(k[m]=u,h[m]=H,l[m]=i)),w+=E,z+=
G,u+=y;B==v?C=!0:(t=B,B=-1!=d[I]?3*d[I++]:v)}I++}}};
JSC3D.Viewer.prototype.renderSolidFlat=function(a){var b=this.frameWidth,c=this.frameHeight,e=a.indexBuffer,d=a.transformedVertexBuffer,f=a.transformedFaceNormalZBuffer,g=this.colorBuffer,h=this.zBuffer,k=this.selectionBuffer,l=a.faceCount,o=a.internalId,i=a.material?a.material:this.defaultMaterial,H=i.getPalette(),q=0==i.transparency,I=255*i.transparency,v=255-I;if(1!=i.transparency){if(!f||f.length<l)a.transformedFaceNormalZBuffer=Array(l),f=a.transformedFaceNormalZBuffer;JSC3D.Math3D.transformVectorZs(this.rotMatrix,
a.faceNormalBuffer,f);for(var i=Array(3),t=Array(3),B=Array(3),C=0,w=0;C<l;){var z=f[C++];a.isDoubleSided&&(z=0<z?z:-z);if(0>z){do;while(-1!=e[w++])}else{var z=H[~~(255*z)],u,D,m;u=3*e[w++];D=3*e[w++];do{m=3*e[w++];i[0]=~~(d[u]+0.5);t[0]=~~(d[u+1]+0.5);B[0]=d[u+2];i[1]=~~(d[D]+0.5);t[1]=~~(d[D+1]+0.5);B[1]=d[D+2];i[2]=~~(d[m]+0.5);t[2]=~~(d[m+1]+0.5);B[2]=d[m+2];D=t[0]<t[1]?0:1;D=t[D]<t[2]?D:2;var p=t[0]>t[1]?0:1,p=t[p]>t[2]?p:2,y=3-p-D;if(D!=p)for(var n=i[p],x=B[p],j=t[p]-t[D],j=0!=j?j:1,E=(i[p]-
i[D])/j,j=(B[p]-B[D])/j,G=i[p],s=B[p],K=t[p]-t[y],K=0!=K?K:1,A=(i[p]-i[y])/K,K=(B[p]-B[y])/K,J=i[y],O=B[y],r=t[y]-t[D],r=0!=r?r:1,S=(i[y]-i[D])/r,r=(B[y]-B[D])/r,T=t[p]*b,p=t[p];p>t[D];p--){if(0<=p&&p<c){var X=~~n,Y=x,U,aa;p>t[y]?(U=~~G,aa=s):(U=~~J,aa=O);if(X>U){var P;P=X;X=U;U=P;P=Y;Y=aa;aa=P}0>X&&(X=0);U>=b&&(U=b-1);aa=X!=U?(aa-Y)/(U-X):1;P=T+X;if(q)for(;X<=U;X++,Y+=aa)Y>h[P]&&(h[P]=Y,g[P]=z,k[P]=o),P++;else for(;X<U;X++,Y+=aa){if(Y>h[P]){var ea=z,pa=g[P];g[P]=(pa&16711680)*I+(ea&16711680)*v>>
8&16711680|(pa&65280)*I+(ea&65280)*v>>8&65280|(pa&255)*I+(ea&255)*v>>8&255;k[P]=o}P++}}n-=E;x-=j;p>t[y]?(G-=A,s-=K):(J-=S,O-=r);T-=b}D=m}while(-1!=e[w]);w++}}}};
JSC3D.Viewer.prototype.renderSolidSmooth=function(a){var b=this.frameWidth,c=this.frameHeight,e=a.indexBuffer,d=a.transformedVertexBuffer,f=a.transformedVertexNormalZBuffer,g=a.transformedFaceNormalZBuffer,h=this.colorBuffer,k=this.zBuffer,l=this.selectionBuffer,o=a.faceCount,i=d.length/3,H=a.internalId,q=a.material?a.material:this.defaultMaterial,I=q.getPalette(),v=0==q.transparency,t=255*q.transparency,B=255-t;if(1!=q.transparency){if(!f||f.length<i)a.transformedVertexNormalZBuffer=Array(i),f=a.transformedVertexNormalZBuffer;
if(!g||g.length<o)a.transformedFaceNormalZBuffer=Array(o),g=a.transformedFaceNormalZBuffer;JSC3D.Math3D.transformVectorZs(this.rotMatrix,a.vertexNormalBuffer,f);JSC3D.Math3D.transformVectorZs(this.rotMatrix,a.faceNormalBuffer,g);for(var a=a.isDoubleSided,i=Array(3),q=Array(3),C=Array(3),w=Array(3),z=0,u=0;z<o;){var D=g[z++];a&&(D=0<D?D:-D);if(0>D){do;while(-1!=e[u++])}else{var m,p,y,n,x,D=e[u++];y=3*D;m=e[u++];n=3*m;do{p=e[u++];x=3*p;i[0]=~~(d[y]+0.5);q[0]=~~(d[y+1]+0.5);C[0]=d[y+2];i[1]=~~(d[n]+
0.5);q[1]=~~(d[n+1]+0.5);C[1]=d[n+2];i[2]=~~(d[x]+0.5);q[2]=~~(d[x+1]+0.5);C[2]=d[x+2];w[0]=f[D];w[1]=f[m];w[2]=f[p];a&&(0>w[0]&&(w[0]=-w[0]),0>w[1]&&(w[1]=-w[1]),0>w[2]&&(w[2]=-w[2]));m=q[0]<q[1]?0:1;m=q[m]<q[2]?m:2;var j=q[0]>q[1]?0:1,j=q[j]>q[2]?j:2;n=3-j-m;if(m!=j)for(var E=i[j],G=C[j],s=255*w[j],K=q[j]-q[m],K=0!=K?K:1,A=(i[j]-i[m])/K,J=(C[j]-C[m])/K,K=255*(w[j]-w[m])/K,O=i[j],r=C[j],S=255*w[j],T=q[j]-q[n],T=0!=T?T:1,X=(i[j]-i[n])/T,Y=(C[j]-C[n])/T,T=255*(w[j]-w[n])/T,U=i[n],aa=C[n],P=255*w[n],
ea=q[n]-q[m],ea=0!=ea?ea:1,pa=(i[n]-i[m])/ea,na=(C[n]-C[m])/ea,ea=255*(w[n]-w[m])/ea,ua=q[j]*b,j=q[j];j>q[m];j--){if(0<=j&&j<c){var M=~~E,F=G,N=s,fa,la,ia;j>q[n]?(fa=~~O,la=r,ia=S):(fa=~~U,la=aa,ia=P);if(M>fa){var L;L=M;M=fa;fa=L;L=F;F=la;la=L;L=N;N=ia;ia=L}la=M!=fa?(la-F)/(fa-M):1;ia=M!=fa?(ia-N)/(fa-M):1;0>M&&(F-=M*la,N-=M*ia,M=0);fa>=b&&(fa=b-1);L=ua+M;if(v)for(;M<=fa;M++,F+=la,N+=ia)F>k[L]&&(k[L]=F,h[L]=I[0<N?~~N:0],l[L]=H),L++;else for(;M<fa;M++,F+=la,N+=ia){if(F>k[L]){var Ba=I[0<N?~~N:0],qa=
h[L];h[L]=(qa&16711680)*t+(Ba&16711680)*B>>8&16711680|(qa&65280)*t+(Ba&65280)*B>>8&65280|(qa&255)*t+(Ba&255)*B>>8&255;l[L]=H}L++}}E-=A;G-=J;s-=K;j>q[n]?(O-=X,r-=Y,S-=T):(U-=pa,aa-=na,P-=ea);ua-=b}n=x;m=p}while(-1!=e[u]);u++}}}};
JSC3D.Viewer.prototype.renderSolidTexture=function(a){var b=this.frameWidth,c=this.frameHeight,e=a.indexBuffer,d=a.transformedVertexBuffer,f=a.transformedFaceNormalZBuffer,g=this.colorBuffer,h=this.zBuffer,k=this.selectionBuffer,l=a.faceCount,o=a.internalId,i=a.texture,H=!i.hasTransparency,q=a.texCoordBuffer,I=a.texCoordIndexBuffer,v=i.data,t=i.width,B=t-1,C=i.hasMipmap()?i.mipmaps:null,w=C?i.mipentries:null;if(!f||f.length<l)a.transformedFaceNormalZBuffer=Array(l),f=a.transformedFaceNormalZBuffer;
JSC3D.Math3D.transformVectorZs(this.rotMatrix,a.faceNormalBuffer,f);for(var z=Array(3),u=Array(3),D=Array(3),m=Array(3),p=Array(3),y=0,n=0;y<l;){var x=f[y++];a.isDoubleSided&&(x=0<x?x:-x);if(0>x){do;while(-1!=e[n++])}else{var j,E,G,s,K,x=3*e[n];G=2*I[n];n++;j=3*e[n];s=2*I[n];n++;if(C){E=3*e[n];K=2*I[n];t=i.width;z[0]=d[x];u[0]=d[x+1];z[1]=d[j];u[1]=d[j+1];z[2]=d[E];u[2]=d[E+1];m[0]=q[G]*t;p[0]=q[G+1]*t;m[1]=q[s]*t;p[1]=q[s+1]*t;m[2]=q[K]*t;p[2]=q[K+1]*t;v=(z[1]-z[0])*(u[2]-u[0])-(u[1]-u[0])*(z[2]-
z[0]);0>v&&(v=-v);v+=1;B=(m[1]-m[0])*(p[2]-p[0])-(p[1]-p[0])*(m[2]-m[0]);0>B&&(B=-B);v=B/v;B=0;if(v<w[1])B=0;else if(v>=w[w.length-1])B=w.length-1,t=1;else for(;v>=w[B+1];)B++,t/=2;v=C[B];B=t-1}do{E=3*e[n];K=2*I[n];n++;z[0]=~~(d[x]+0.5);u[0]=~~(d[x+1]+0.5);D[0]=d[x+2];z[1]=~~(d[j]+0.5);u[1]=~~(d[j+1]+0.5);D[1]=d[j+2];z[2]=~~(d[E]+0.5);u[2]=~~(d[E+1]+0.5);D[2]=d[E+2];m[0]=q[G]*t;p[0]=q[G+1]*t;m[1]=q[s]*t;p[1]=q[s+1]*t;m[2]=q[K]*t;p[2]=q[K+1]*t;j=u[0]<u[1]?0:1;j=u[j]<u[2]?j:2;var A=u[0]>u[1]?0:1,A=
u[A]>u[2]?A:2;s=3-A-j;if(j!=A)for(var J=z[A],O=D[A],r=m[A],S=p[A],T=u[A]-u[j],T=0!=T?T:1,X=(z[A]-z[j])/T,Y=(D[A]-D[j])/T,U=(m[A]-m[j])/T,T=(p[A]-p[j])/T,aa=z[A],P=D[A],ea=m[A],pa=p[A],na=u[A]-u[s],na=0!=na?na:1,ua=(z[A]-z[s])/na,M=(D[A]-D[s])/na,F=(m[A]-m[s])/na,na=(p[A]-p[s])/na,N=z[s],fa=D[s],la=m[s],ia=p[s],L=u[s]-u[j],L=0!=L?L:1,Ba=(z[s]-z[j])/L,qa=(D[s]-D[j])/L,Ca=(m[s]-m[j])/L,L=(p[s]-p[j])/L,Na=u[A]*b,A=u[A];A>u[j];A--){if(0<=A&&A<c){var ja=~~J,ra=O,oa=r,R=S,V,ba,W,Z;A>u[s]?(V=~~aa,ba=P,W=
ea,Z=pa):(V=~~N,ba=fa,W=la,Z=ia);if(ja>V){var Q;Q=ja;ja=V;V=Q;Q=ra;ra=ba;ba=Q;Q=oa;oa=W;W=Q;Q=R;R=Z;Z=Q}ba=ja!=V?(ba-ra)/(V-ja):1;W=ja!=V?(W-oa)/(V-ja):1;Z=ja!=V?(Z-R)/(V-ja):1;0>ja&&(ra-=ja*ba,oa-=ja*W,R-=ja*Z,ja=0);V>=b&&(V=b-1);Q=Na+ja;if(H)for(;ja<=V;ja++,ra+=ba,oa+=W,R+=Z)ra>h[Q]&&(h[Q]=ra,g[Q]=v[(R&B)*t+(oa&B)],k[Q]=o),Q++;else for(;ja<V;ja++,ra+=ba,oa+=W,R+=Z){if(ra>h[Q]){var sa=v[(R&B)*t+(oa&B)],va=g[Q],ca=sa>>24&255,wa=255-ca;g[Q]=(va&16711680)*wa+(sa&16711680)*ca>>8&16711680|(va&65280)*
wa+(sa&65280)*ca>>8&65280|(va&255)*wa+(sa&255)*ca>>8&255;k[Q]=o}Q++}}J-=X;O-=Y;r-=U;S-=T;A>u[s]?(aa-=ua,P-=M,ea-=F,pa-=na):(N-=Ba,fa-=qa,la-=Ca,ia-=L);Na-=b}j=E;s=K}while(-1!=e[n]);n++}}};
JSC3D.Viewer.prototype.renderTextureFlat=function(a){var b=this.frameWidth,c=this.frameHeight,e=a.indexBuffer,d=a.transformedVertexBuffer,f=a.transformedFaceNormalZBuffer,g=this.colorBuffer,h=this.zBuffer,k=this.selectionBuffer,l=a.faceCount,o=a.internalId,i=a.material?a.material:this.defaultMaterial,H=i.getPalette(),q=a.texture,I=0==i.transparency&&!q.hasTransparency,v=~~(255*(1-i.transparency)),t=a.texCoordBuffer,B=a.texCoordIndexBuffer,C=q.data,w=q.width,z=w-1,u=q.hasMipmap()?q.mipmaps:null,D=
u?q.mipentries:null;if(1!=i.transparency){if(!f||f.length<l)a.transformedFaceNormalZBuffer=Array(l),f=a.transformedFaceNormalZBuffer;JSC3D.Math3D.transformVectorZs(this.rotMatrix,a.faceNormalBuffer,f);for(var i=Array(3),m=Array(3),p=Array(3),y=Array(3),n=Array(3),x=0,j=0;x<l;){var E=f[x++];a.isDoubleSided&&(E=0<E?E:-E);if(0>E){do;while(-1!=e[j++])}else{var E=H[~~(255*E)],G,s,K,A,J,O;G=3*e[j];A=2*B[j];j++;s=3*e[j];J=2*B[j];j++;if(u){K=3*e[j];O=2*B[j];w=q.width;i[0]=d[G];m[0]=d[G+1];i[1]=d[s];m[1]=
d[s+1];i[2]=d[K];m[2]=d[K+1];y[0]=t[A]*w;n[0]=t[A+1]*w;y[1]=t[J]*w;n[1]=t[J+1]*w;y[2]=t[O]*w;n[2]=t[O+1]*w;C=(i[1]-i[0])*(m[2]-m[0])-(m[1]-m[0])*(i[2]-i[0]);0>C&&(C=-C);C+=1;z=(y[1]-y[0])*(n[2]-n[0])-(n[1]-n[0])*(y[2]-y[0]);0>z&&(z=-z);C=z/C;z=0;if(C<D[1])z=0;else if(C>=D[D.length-1])z=D.length-1,w=1;else for(;C>=D[z+1];)z++,w/=2;C=u[z];z=w-1}do{K=3*e[j];O=2*B[j];j++;i[0]=~~(d[G]+0.5);m[0]=~~(d[G+1]+0.5);p[0]=d[G+2];i[1]=~~(d[s]+0.5);m[1]=~~(d[s+1]+0.5);p[1]=d[s+2];i[2]=~~(d[K]+0.5);m[2]=~~(d[K+1]+
0.5);p[2]=d[K+2];y[0]=t[A]*w;n[0]=t[A+1]*w;y[1]=t[J]*w;n[1]=t[J+1]*w;y[2]=t[O]*w;n[2]=t[O+1]*w;s=m[0]<m[1]?0:1;s=m[s]<m[2]?s:2;var r=m[0]>m[1]?0:1,r=m[r]>m[2]?r:2;J=3-r-s;if(s!=r)for(var S=i[r],T=p[r],X=y[r],Y=n[r],U=m[r]-m[s],U=0!=U?U:1,aa=(i[r]-i[s])/U,P=(p[r]-p[s])/U,ea=(y[r]-y[s])/U,U=(n[r]-n[s])/U,pa=i[r],na=p[r],ua=y[r],M=n[r],F=m[r]-m[J],F=0!=F?F:1,N=(i[r]-i[J])/F,fa=(p[r]-p[J])/F,la=(y[r]-y[J])/F,F=(n[r]-n[J])/F,ia=i[J],L=p[J],Ba=y[J],qa=n[J],Ca=m[J]-m[s],Ca=0!=Ca?Ca:1,Na=(i[J]-i[s])/Ca,ja=
(p[J]-p[s])/Ca,ra=(y[J]-y[s])/Ca,Ca=(n[J]-n[s])/Ca,oa=m[r]*b,r=m[r];r>m[s];r--){if(0<=r&&r<c){var R=~~S,V=T,ba=X,W=Y,Z,Q,sa,va;r>m[J]?(Z=~~pa,Q=na,sa=ua,va=M):(Z=~~ia,Q=L,sa=Ba,va=qa);if(R>Z){var ca;ca=R;R=Z;Z=ca;ca=V;V=Q;Q=ca;ca=ba;ba=sa;sa=ca;ca=W;W=va;va=ca}Q=R!=Z?(Q-V)/(Z-R):1;sa=R!=Z?(sa-ba)/(Z-R):1;va=R!=Z?(va-W)/(Z-R):1;0>R&&(V-=R*Q,ba-=R*sa,W-=R*va,R=0);Z>=b&&(Z=b-1);ca=oa+R;if(I)for(;R<=Z;R++,V+=Q,ba+=sa,W+=va){if(V>h[ca]){h[ca]=V;var wa=C[(W&z)*w+(ba&z)],Da=((E&16711680)>>16)*((wa&16711680)>>
8),da=((E&65280)>>8)*((wa&65280)>>8),ma=(E&255)*(wa&255)>>8;g[ca]=Da&16711680|da&65280|ma&255;k[ca]=o}ca++}else for(;R<Z;R++,V+=Q,ba+=sa,W+=va){if(V>h[ca]){var ma=C[(W&z)*w+(ba&z)],wa=g[ca],xa=(ma>>24&255)*(v&255)>>8,Da=((E&16711680)>>16)*((ma&16711680)>>8),da=((E&65280)>>8)*((ma&65280)>>8),ma=(E&255)*(ma&255)>>8;if(250<xa)h[ca]=V;else var ya=255-xa,Da=Da*xa+(wa&16711680)*ya>>8,da=da*xa+(wa&65280)*ya>>8,ma=ma*xa+(wa&255)*ya>>8;g[ca]=Da&16711680|da&65280|ma&255;k[ca]=o}ca++}}S-=aa;T-=P;X-=ea;Y-=U;
r>m[J]?(pa-=N,na-=fa,ua-=la,M-=F):(ia-=Na,L-=ja,Ba-=ra,qa-=Ca);oa-=b}s=K;J=O}while(-1!=e[j]);j++}}}};
JSC3D.Viewer.prototype.renderTextureSmooth=function(a){var b=this.frameWidth,c=this.frameHeight,e=a.indexBuffer,d=a.transformedVertexBuffer,f=a.transformedVertexNormalZBuffer,g=a.transformedFaceNormalZBuffer,h=this.colorBuffer,k=this.zBuffer,l=this.selectionBuffer,o=a.faceCount,i=a.internalId,H=d.length/3,q=a.material?a.material:this.defaultMaterial,I=q.getPalette(),v=a.texture,t=0==q.transparency&&!v.hasTransparency,B=~~(255*(1-q.transparency)),C=a.texCoordBuffer,w=a.texCoordIndexBuffer,z=v.data,
u=v.width,D=u-1,m=v.hasMipmap()?v.mipmaps:null,p=m?v.mipentries:null;if(1!=q.transparency){if(!f||f.length<H)a.transformedVertexNormalZBuffer=Array(H),f=a.transformedVertexNormalZBuffer;if(!g||g.length<o)a.transformedFaceNormalZBuffer=Array(o),g=a.transformedFaceNormalZBuffer;JSC3D.Math3D.transformVectorZs(this.rotMatrix,a.vertexNormalBuffer,f);JSC3D.Math3D.transformVectorZs(this.rotMatrix,a.faceNormalBuffer,g);for(var y=a.isDoubleSided,n=Array(3),x=Array(3),j=Array(3),E=Array(3),G=Array(3),s=Array(3),
K=0,A=0;K<o;){var J=g[K++];y&&(J=0<J?J:-J);if(0>J){do;while(-1!=e[A++])}else{var O,r,S,T,X,Y,U,aa,P;O=e[A];T=3*O;U=2*w[A];A++;r=e[A];X=3*r;aa=2*w[A];A++;if(m){Y=3*e[A];P=2*w[A];u=v.width;n[0]=d[T];x[0]=d[T+1];n[1]=d[X];x[1]=d[X+1];n[2]=d[Y];x[2]=d[Y+1];G[0]=C[U]*u;s[0]=C[U+1]*u;G[1]=C[aa]*u;s[1]=C[aa+1]*u;G[2]=C[P]*u;s[2]=C[P+1]*u;var ea=(n[1]-n[0])*(x[2]-x[0])-(x[1]-x[0])*(n[2]-n[0]);0>ea&&(ea=-ea);var ea=ea+1,pa=(G[1]-G[0])*(s[2]-s[0])-(s[1]-s[0])*(G[2]-G[0]);0>pa&&(pa=-pa);var na=pa/ea,ua=0;if(na<
p[1])ua=0;else if(na>=p[p.length-1])ua=p.length-1,u=1;else for(;na>=p[ua+1];)ua++,u/=2;z=m[ua];D=u-1}do{S=e[A];Y=3*S;P=2*w[A];A++;n[0]=~~(d[T]+0.5);x[0]=~~(d[T+1]+0.5);j[0]=d[T+2];n[1]=~~(d[X]+0.5);x[1]=~~(d[X+1]+0.5);j[1]=d[X+2];n[2]=~~(d[Y]+0.5);x[2]=~~(d[Y+1]+0.5);j[2]=d[Y+2];G[0]=C[U]*u;s[0]=C[U+1]*u;G[1]=C[aa]*u;s[1]=C[aa+1]*u;G[2]=C[P]*u;s[2]=C[P+1]*u;E[0]=f[O];E[1]=f[r];E[2]=f[S];y&&(0>E[0]&&(E[0]=-E[0]),0>E[1]&&(E[1]=-E[1]),0>E[2]&&(E[2]=-E[2]));var M=x[0]<x[1]?0:1,M=x[M]<x[2]?M:2,F=x[0]>
x[1]?0:1,F=x[F]>x[2]?F:2,N=3-F-M;if(M!=F)for(var fa=n[F],la=j[F],ia=G[F],L=s[F],Ba=255*E[F],qa=x[F]-x[M],qa=0!=qa?qa:1,Ca=(n[F]-n[M])/qa,Na=(j[F]-j[M])/qa,ja=(G[F]-G[M])/qa,ra=(s[F]-s[M])/qa,oa=255*(E[F]-E[M])/qa,R=n[F],V=j[F],ba=G[F],W=s[F],Z=255*E[F],Q=x[F]-x[N],Q=0!=Q?Q:1,sa=(n[F]-n[N])/Q,va=(j[F]-j[N])/Q,ca=(G[F]-G[N])/Q,wa=(s[F]-s[N])/Q,Da=255*(E[F]-E[N])/Q,da=n[N],ma=j[N],xa=G[N],ya=s[N],Ia=255*E[N],ha=x[N]-x[M],ha=0!=ha?ha:1,Ta=(n[N]-n[M])/ha,Ua=(j[N]-j[M])/ha,Va=(G[N]-G[M])/ha,Wa=(s[N]-s[M])/
ha,Ja=255*(E[N]-E[M])/ha,Xa=x[F]*b,Ma=x[F];Ma>x[M];Ma--){if(0<=Ma&&Ma<c){var ka=~~fa,Ka=la,ta=ia,Ea=L,za=Ba,ga,Fa,Ga,Ha,Oa;Ma>x[N]?(ga=~~R,Fa=V,Ga=ba,Ha=W,Oa=Z):(ga=~~da,Fa=ma,Ga=xa,Ha=ya,Oa=Ia);if(ka>ga){var Aa;Aa=ka;ka=ga;ga=Aa;Aa=Ka;Ka=Fa;Fa=Aa;Aa=ta;ta=Ga;Ga=Aa;Aa=Ea;Ea=Ha;Ha=Aa;Aa=za;za=Oa;Oa=Aa}var Pa=ka!=ga?(Fa-Ka)/(ga-ka):1,Qa=ka!=ga?(Ga-ta)/(ga-ka):1,Ya=ka!=ga?(Ha-Ea)/(ga-ka):1,Za=ka!=ga?(Oa-za)/(ga-ka):0;0>ka&&(Ka-=ka*Pa,ta-=ka*Qa,Ea-=ka*Ya,za-=ka*Za,ka=0);ga>=b&&(ga=b-1);var La=Xa+ka;if(t)for(var cb=
ka,Ra=Ka,Sa=za,$a=ta,ab=Ea;cb<=ga;cb++,Ra+=Pa,Sa+=Za,$a+=Qa,ab+=Ya){if(Ra>k[La]){k[La]=Ra;var bb=I[0<Sa?~~Sa:0],ib=z[(ab&D)*u+($a&D)],db=((bb&16711680)>>16)*((ib&16711680)>>8),eb=((bb&65280)>>8)*((ib&65280)>>8),fb=(bb&255)*(ib&255)>>8;h[La]=db&16711680|eb&65280|fb&255;l[La]=i}La++}else{cb=ka;Ra=Ka;Sa=za;$a=ta;for(ab=Ea;cb<ga;cb++,Ra+=Pa,Sa+=Za,$a+=Qa,ab+=Ya){if(Ra>k[La]){var bb=I[0<Sa?~~Sa:0],hb=z[(ab&D)*u+($a&D)],jb=h[La],gb=(hb>>24&255)*(B&255)>>8,db=((bb&16711680)>>16)*((hb&16711680)>>8),eb=((bb&
65280)>>8)*((hb&65280)>>8),fb=(bb&255)*(hb&255)>>8;if(250<gb)k[La]=Ra;else var kb=255-gb,db=db*gb+(jb&16711680)*kb>>8,eb=eb*gb+(jb&65280)*kb>>8,fb=fb*gb+(jb&255)*kb>>8;h[La]=db&16711680|eb&65280|fb&255;l[La]=i}La++}}}fa-=Ca;la-=Na;ia-=ja;L-=ra;Ba-=oa;Ma>x[N]?(R-=sa,V-=va,ba-=ca,W-=wa,Z-=Da):(da-=Ta,ma-=Ua,xa-=Va,ya-=Wa,Ia-=Ja);Xa-=b}r=S;X=Y;aa=P}while(-1!=e[A]);A++}}}};
JSC3D.Viewer.prototype.renderSolidSphereMapped=function(a){var b=this.frameWidth,c=this.frameHeight,e=a.indexBuffer,d=a.transformedVertexBuffer,f=a.transformedVertexNormalBuffer,g=a.transformedFaceNormalZBuffer,h=this.colorBuffer,k=this.zBuffer,l=this.selectionBuffer,o=a.faceCount,i=d.length/3,H=a.internalId,q=a.material?a.material:this.defaultMaterial,I=q.getPalette(),v=this.sphereMap,t=v.data,B=v.width,C=B-1,w=0==q.transparency,z=255*q.transparency,u=255-z;if(1!=q.transparency){if(!f||f.length<
3*i)a.transformedVertexNormalBuffer=Array(3*i),f=a.transformedVertexNormalBuffer;if(!g||g.length<o)a.transformedFaceNormalZBuffer=Array(o),g=a.transformedFaceNormalZBuffer;JSC3D.Math3D.transformVectors(this.rotMatrix,a.vertexNormalBuffer,f);JSC3D.Math3D.transformVectorZs(this.rotMatrix,a.faceNormalBuffer,g);for(var D=a.isDoubleSided,m=Array(3),p=Array(3),y=Array(3),n=Array(3),x=Array(3),j=Array(3),E=0,G=0;E<o;){var s=g[E++];D&&(s=0<s?s:-s);if(0>s){do;while(-1!=e[G++])}else{var K,A,J;K=3*e[G++];A=
3*e[G++];do{J=3*e[G++];m[0]=~~(d[K]+0.5);p[0]=~~(d[K+1]+0.5);y[0]=d[K+2];m[1]=~~(d[A]+0.5);p[1]=~~(d[A+1]+0.5);y[1]=d[A+2];m[2]=~~(d[J]+0.5);p[2]=~~(d[J+1]+0.5);y[2]=d[J+2];n[0]=f[K];x[0]=f[K+1];j[0]=f[K+2];n[1]=f[A];x[1]=f[A+1];j[1]=f[A+2];n[2]=f[J];x[2]=f[J+1];j[2]=f[J+2];D&&(0>j[0]&&(j[0]=-j[0]),0>j[1]&&(j[1]=-j[1]),0>j[2]&&(j[2]=-j[2]));var O=p[0]<p[1]?0:1,O=p[O]<p[2]?O:2,r=p[0]>p[1]?0:1,r=p[r]>p[2]?r:2,S=3-r-O;if(O!=r)for(var T=m[r],X=y[r],Y=255*j[r],U=(n[r]/2+0.5)*B&C,aa=(0.5-x[r]/2)*B&C,P=
p[r]-p[O],P=0!=P?P:1,ea=(m[r]-m[O])/P,pa=(y[r]-y[O])/P,na=255*(j[r]-j[O])/P,ua=(n[r]-n[O])/2*B/P,M=(x[O]-x[r])/2*B/P,F=m[r],N=y[r],fa=255*j[r],la=(n[r]/2+0.5)*B&C,ia=(0.5-x[r]/2)*B&C,L=p[r]-p[S],L=0!=L?L:1,Ba=(m[r]-m[S])/L,qa=(y[r]-y[S])/L,Ca=255*(j[r]-j[S])/L,Na=(n[r]-n[S])/2*B/L,ja=(x[S]-x[r])/2*B/L,ra=m[S],oa=y[S],R=255*j[S],V=(n[S]/2+0.5)*B&C,ba=(0.5-x[S]/2)*B&C,W=p[S]-p[O],W=0!=W?W:1,Z=(m[S]-m[O])/W,Q=(y[S]-y[O])/W,sa=255*(j[S]-j[O])/W,va=(n[S]-n[O])/2*B/W,ca=(x[O]-x[S])/2*B/W,wa=p[r]*b,Da=p[r];Da>
p[O];Da--){if(0<=Da&&Da<c){var da=~~T,ma=X,xa=Y,ya=U,Ia=aa,ha,Ta,Ua,Va,Wa;Da>p[S]?(ha=~~F,Ta=N,Ua=fa,Va=la,Wa=ia):(ha=~~ra,Ta=oa,Ua=R,Va=V,Wa=ba);if(da>ha){var Ja;Ja=da;da=ha;ha=Ja;Ja=ma;ma=Ta;Ta=Ja;Ja=xa;xa=Ua;Ua=Ja;Ja=ya;ya=Va;Va=Ja;Ja=Ia;Ia=Wa;Wa=Ja}var Xa=da!=ha?(Ta-ma)/(ha-da):1,Ma=da!=ha?(Ua-xa)/(ha-da):1,ka=da!=ha?(Va-ya)/(ha-da):1,Ka=da!=ha?(Wa-Ia)/(ha-da):1;0>da&&(ma-=da*Xa,xa-=da*Ma,ya-=ya*ka,Ia-=Ia*Ka,da=0);ha>=b&&(ha=b-1);var ta=wa+da;if(w)for(var Ea=da,za=ma,ga=xa,Fa=ya,Ga=Ia;Ea<=ha;Ea++,
za+=Xa,ga+=Ma,Fa+=ka,Ga+=Ka){if(za>k[ta]){k[ta]=za;var Ha=I[0<ga?~~ga:0],Oa=t[(Ga&C)*B+(Fa&C)],Aa=((Ha&16711680)>>16)*((Oa&16711680)>>8),Pa=((Ha&65280)>>8)*((Oa&65280)>>8),Qa=(Ha&255)*(Oa&255)>>8;h[ta]=Aa&16711680|Pa&65280|Qa&255;l[ta]=H}ta++}else{Ea=da;za=ma;ga=xa;Fa=ya;for(Ga=Ia;Ea<ha;Ea++,za+=Xa,ga+=Ma,Fa+=ka,Ga+=Ka){if(za>k[ta]){var Ha=I[0<ga?~~ga:0],Ya=t[(Ga&C)*B+(Fa&C)],Za=h[ta],Aa=((Ha&16711680)>>16)*((Ya&16711680)>>8),Pa=((Ha&65280)>>8)*((Ya&65280)>>8),Qa=(Ha&255)*(Ya&255)>>8,Aa=Aa*u+(Za&
16711680)*z>>8,Pa=Pa*u+(Za&65280)*z>>8,Qa=Qa*u+(Za&255)*z>>8;h[ta]=Aa&16711680|Pa&65280|Qa&255;l[ta]=H}ta++}}}T-=ea;X-=pa;Y-=na;U-=ua;aa-=M;Da>p[S]?(F-=Ba,N-=qa,fa-=Ca,la-=Na,ia-=ja):(ra-=Z,oa-=Q,R-=sa,V-=va,ba-=ca);wa-=b}A=J}while(-1!=e[G]);G++}}}};JSC3D.Viewer.prototype.params=null;JSC3D.Viewer.prototype.canvas=null;JSC3D.Viewer.prototype.ctx=null;JSC3D.Viewer.prototype.canvasData=null;JSC3D.Viewer.prototype.bkgColorBuffer=null;JSC3D.Viewer.prototype.colorBuffer=null;
JSC3D.Viewer.prototype.zBuffer=null;JSC3D.Viewer.prototype.selectionBuffer=null;JSC3D.Viewer.prototype.frameWidth=0;JSC3D.Viewer.prototype.frameHeight=0;JSC3D.Viewer.prototype.scene=null;JSC3D.Viewer.prototype.defaultMaterial=null;JSC3D.Viewer.prototype.sphereMap=null;JSC3D.Viewer.prototype.isLoaded=!1;JSC3D.Viewer.prototype.isFailed=!1;JSC3D.Viewer.prototype.errorMsg="";JSC3D.Viewer.prototype.needUpdate=!1;JSC3D.Viewer.prototype.needRepaint=!1;JSC3D.Viewer.prototype.initRotX=0;
JSC3D.Viewer.prototype.initRotY=0;JSC3D.Viewer.prototype.initRotZ=0;JSC3D.Viewer.prototype.zoomFactor=1;JSC3D.Viewer.prototype.rotMatrix=null;JSC3D.Viewer.prototype.transformMatrix=null;JSC3D.Viewer.prototype.sceneUrl="";JSC3D.Viewer.prototype.mtlLibUrl="";JSC3D.Viewer.prototype.modelColor=13280792;JSC3D.Viewer.prototype.bkgColor1=16777215;JSC3D.Viewer.prototype.bkgColor2=16777088;JSC3D.Viewer.prototype.renderMode="flat";JSC3D.Viewer.prototype.definition="standard";
JSC3D.Viewer.prototype.isMipMappingOn=!1;JSC3D.Viewer.prototype.sphereMapUrl="";JSC3D.Viewer.prototype.buttonStates=null;JSC3D.Viewer.prototype.keyStates=null;JSC3D.Viewer.prototype.mouseX=0;JSC3D.Viewer.prototype.mouseY=0;JSC3D.Viewer.prototype.onmousedown=null;JSC3D.Viewer.prototype.onmouseup=null;JSC3D.Viewer.prototype.onmousemove=null;JSC3D.Viewer.prototype.beforeupdate=null;JSC3D.Viewer.prototype.afterupdate=null;JSC3D.Viewer.prototype.mouseUsage="default";
JSC3D.Viewer.prototype.isDefaultInputHandlerEnabled=!1;JSC3D.PickInfo=function(){this.canvasY=this.canvasX=0;this.depth=-Infinity;this.mesh=null};JSC3D.Scene=function(a){this.name=a||"";this.aabb=null;this.children=[];this.maxChildId=1};JSC3D.Scene.prototype.init=function(){if(!this.isEmpty()){for(var a=0;a<this.children.length;a++)this.children[a].init();this.aabb||(this.aabb=new JSC3D.AABB,this.calcAABB())}};JSC3D.Scene.prototype.isEmpty=function(){return 0==this.children.length};
JSC3D.Scene.prototype.addChild=function(a){a.internalId=this.maxChildId++;this.children.push(a)};JSC3D.Scene.prototype.removeChild=function(a){for(var b=0;b<this.children.length;b++)if(this.children[b]==a){this.children.splice(b,1);break}};JSC3D.Scene.prototype.getChildren=function(){return this.children};
JSC3D.Scene.prototype.calcAABB=function(){this.aabb.minX=this.aabb.minY=this.aabb.minZ=Number.MAX_VALUE;this.aabb.maxX=this.aabb.maxY=this.aabb.maxZ=-Number.MAX_VALUE;for(var a=0;a<this.children.length;a++){var b=this.children[a];if(!b.isTrivial()){var c=b.aabb.minX,e=b.aabb.minY,d=b.aabb.minZ,f=b.aabb.maxX,g=b.aabb.maxY,b=b.aabb.maxZ;this.aabb.minX>c&&(this.aabb.minX=c);this.aabb.minY>e&&(this.aabb.minY=e);this.aabb.minZ>d&&(this.aabb.minZ=d);this.aabb.maxX<f&&(this.aabb.maxX=f);this.aabb.maxY<g&&
(this.aabb.maxY=g);this.aabb.maxZ<b&&(this.aabb.maxZ=b)}}};JSC3D.Scene.prototype.name="";JSC3D.Scene.prototype.aabb=null;JSC3D.Scene.prototype.children=null;JSC3D.Scene.prototype.maxChildId=1;
JSC3D.Mesh=function(a,b,c,e,d,f,g,h,k,l){this.name=a||"";this.metadata="";this.visible=void 0!=b?b:!0;this.aabb=null;this.vertexBuffer=g||null;this.indexBuffer=h||null;this.faceNormalBuffer=this.vertexNormalBuffer=null;this.material=c||null;this.texture=e||null;this.faceCount=0;this.isDoubleSided=d||!1;this.isEnvironmentCast=f||!1;this.internalId=0;this.texCoordBuffer=k||null;this.texCoordIndexBuffer=l||null;this.transformedVertexNormalBuffer=this.transformedFaceNormalZBuffer=this.transformedVertexNormalZBuffer=
this.transformedVertexBuffer=null};JSC3D.Mesh.prototype.init=function(){if(!this.isTrivial()){if(0==this.faceCount&&(this.calcFaceCount(),0==this.faceCount))return;this.aabb||(this.aabb=new JSC3D.AABB,this.calcAABB());this.faceNormalBuffer||(this.faceNormalBuffer=Array(3*this.faceCount),this.calcFaceNormals());this.vertexNormalBuffer||(this.vertexNormalBuffer=Array(this.vertexBuffer.length),this.calcVertexNormals());this.normalizeFaceNormals();this.transformedVertexBuffer=Array(this.vertexBuffer.length)}};
JSC3D.Mesh.prototype.isTrivial=function(){return!this.vertexBuffer||3>this.vertexBuffer.length||!this.indexBuffer||3>this.indexBuffer.length};JSC3D.Mesh.prototype.setMaterial=function(a){this.material=a};JSC3D.Mesh.prototype.setTexture=function(a){this.texture=a};
JSC3D.Mesh.prototype.hasTexture=function(){return null!=this.texCoordBuffer&&2<=this.texCoordBuffer.length&&null!=this.texCoordIndexBuffer&&3<=this.texCoordIndexBuffer.length&&this.texCoordIndexBuffer.length>=this.indexBuffer.length&&null!=this.texture&&this.texture.hasData()};JSC3D.Mesh.prototype.calcFaceCount=function(){this.faceCount=0;var a=this.indexBuffer;-1!=a[a.length-1]&&a.push(-1);for(var b=0;b<a.length;b++)-1==a[b]&&this.faceCount++};
JSC3D.Mesh.prototype.calcAABB=function(){for(var a=minY=minZ=Number.MAX_VALUE,b=maxY=maxZ=-Number.MAX_VALUE,c=this.vertexBuffer,e=0;e<c.length;e+=3){var d=c[e],f=c[e+1],g=c[e+2];d<a&&(a=d);d>b&&(b=d);f<minY&&(minY=f);f>maxY&&(maxY=f);g<minZ&&(minZ=g);g>maxZ&&(maxZ=g)}this.aabb.minX=a;this.aabb.minY=minY;this.aabb.minZ=minZ;this.aabb.maxX=b;this.aabb.maxY=maxY;this.aabb.maxZ=maxZ};
JSC3D.Mesh.prototype.calcFaceNormals=function(){for(var a=this.vertexBuffer,b=this.indexBuffer,c=this.faceNormalBuffer,e=0,d=0;e<b.length;){var f=3*b[e++],g=a[f],h=a[f+1],k=a[f+2],f=3*b[e++],l=a[f],o=a[f+1],i=a[f+2],f=3*b[e++],l=l-g,o=o-h,i=i-k,g=a[f]-g,h=a[f+1]-h,k=a[f+2]-k,f=o*k-i*h,k=i*g-l*k,l=l*h-o*g;c[d++]=f;c[d++]=k;c[d++]=l;do;while(-1!=b[e++])}};
JSC3D.Mesh.prototype.calcVertexNormals=function(){this.faceNormalBuffer||(this.faceNormalBuffer=Array(3*this.faceCount),this.calcFaceNormals());for(var a=this.indexBuffer,b=this.faceNormalBuffer,c=this.vertexNormalBuffer,e=0;e<c.length;e++)c[e]=0;for(var d=e=0,f=0;e<a.length;)f=a[e++],-1==f?d+=3:(f*=3,c[f]+=b[d],c[f+1]+=b[d+1],c[f+2]+=b[d+2]);for(d=e=0;e<c.length;e+=3,d++){var a=c[e],b=c[e+1],f=c[e+2],g=Math.sqrt(a*a+b*b+f*f);0<g&&(a/=g,b/=g,f/=g);c[e]=a;c[e+1]=b;c[e+2]=f}};
JSC3D.Mesh.prototype.normalizeFaceNormals=function(){for(var a=this.faceNormalBuffer,b=0;b<a.length;b+=3){var c=a[b],e=a[b+1],d=a[b+2],f=Math.sqrt(c*c+e*e+d*d);0<f&&(c/=f,e/=f,d/=f);a[b]=c;a[b+1]=e;a[b+2]=d}};JSC3D.Mesh.prototype.checkValid=function(){};JSC3D.Mesh.prototype.name="";JSC3D.Mesh.prototype.metadata="";JSC3D.Mesh.prototype.visible=!1;JSC3D.Mesh.prototype.aabb=null;JSC3D.Mesh.prototype.vertexBuffer=null;JSC3D.Mesh.prototype.indexBuffer=null;JSC3D.Mesh.prototype.vertexNormalBuffer=null;
JSC3D.Mesh.prototype.faceNormalBuffer=null;JSC3D.Mesh.prototype.texCoordBuffer=null;JSC3D.Mesh.prototype.texCoordIndexBuffer=null;JSC3D.Mesh.prototype.material=null;JSC3D.Mesh.prototype.texture=null;JSC3D.Mesh.prototype.faceCount=0;JSC3D.Mesh.prototype.isDoubleSided=!1;JSC3D.Mesh.prototype.isEnvironmentCast=!1;JSC3D.Mesh.prototype.internalId=0;JSC3D.Mesh.prototype.transformedVertexBuffer=null;JSC3D.Mesh.prototype.transformedVertexNormalZBuffer=null;
JSC3D.Mesh.prototype.transformedFaceNormalZBuffer=null;JSC3D.Mesh.prototype.transformedVertexNormalBuffer=null;JSC3D.Material=function(a,b,c,e,d){this.name=a||"";this.ambientColor=b||0;this.diffuseColor=c||8355711;this.transparency=e||0;this.simulateSpecular=d||!1;this.palette=null};JSC3D.Material.prototype.getPalette=function(){this.palette||(this.palette=Array(256),this.generatePalette());return this.palette};
JSC3D.Material.prototype.generatePalette=function(){var a=(this.ambientColor&16711680)>>16,b=(this.ambientColor&65280)>>8,c=this.ambientColor&255,e=(this.diffuseColor&16711680)>>16,d=(this.diffuseColor&65280)>>8,f=this.diffuseColor&255;if(this.simulateSpecular){for(var g=0;204>g;){var h=a+g*e/204,k=b+g*d/204,l=c+g*f/204;255<h&&(h=255);255<k&&(k=255);255<l&&(l=255);this.palette[g++]=h<<16|k<<8|l}for(;256>g;)h=a+e+(g-204)*(255-e)/82,k=b+d+(g-204)*(255-d)/82,l=c+f+(g-204)*(255-f)/82,255<h&&(h=255),255<
k&&(k=255),255<l&&(l=255),this.palette[g++]=h<<16|k<<8|l}else for(g=0;256>g;)h=a+g*e/256,k=b+g*d/256,l=c+g*f/256,255<h&&(h=255),255<k&&(k=255),255<l&&(l=255),this.palette[g++]=h<<16|k<<8|l};JSC3D.Material.prototype.name="";JSC3D.Material.prototype.ambientColor=0;JSC3D.Material.prototype.diffuseColor=8355711;JSC3D.Material.prototype.transparency=0;JSC3D.Material.prototype.simulateSpecular=!1;JSC3D.Material.prototype.palette=null;
JSC3D.Texture=function(a,b){this.name=a||"";this.height=this.width=0;this.mipentries=this.mipmaps=this.data=null;this.hasTransparency=!1;this.srcUrl="";this.onready=b&&"function"==typeof b?b:null};
JSC3D.Texture.prototype.createFromUrl=function(a,b){var c=this,e=new Image;e.onload=function(){c.data=null;c.mipmaps=null;c.mipentries=null;c.width=0;c.height=0;c.hasTransparency=!1;c.srcUrl="";c.createFromImage(this,b);JSC3D.console&&JSC3D.console.logInfo('Finished loading texture image file "'+this.src+'".')};e.onerror=function(){c.data=null;c.mipmaps=null;c.mipentries=null;c.width=0;c.height=0;c.hasTransparency=!1;c.srcUrl="";JSC3D.console&&JSC3D.console.logWarning('Failed to load texture image file "'+
this.src+'". This texture will be discarded.')};e.src=a};
JSC3D.Texture.prototype.createFromImage=function(a,b){if(!(0>=a.width||0>=a.height)){var c=!1,e=JSC3D.Texture.cv;if(!e)try{e=document.createElement("canvas"),JSC3D.Texture.cv=e,c=!0}catch(d){return}var f=a.width>a.height?a.width:a.height,f=32>=f?32:64>=f?64:128>=f?128:256>=f?256:512;if(e.width!=f||e.height!=f)e.width=e.height=f,c=!0;var g;try{var h=e.getContext("2d");c||h.clearRect(0,0,f,f);h.drawImage(a,0,0,f,f);g=h.getImageData(0,0,f,f).data}catch(k){return}c=g.length/4;this.data=Array(c);for(var l=
h=0;h<c;h++,l+=4)e=g[l+3],this.data[h]=e<<24|g[l]<<16|g[l+1]<<8|g[l+2],255>e&&(this.hasTransparency=!0);this.height=this.width=f;this.mipmaps=null;b&&this.generateMipmaps();this.srcUrl=a.src;if(null!=this.onready&&"function"==typeof this.onready)this.onready()}};JSC3D.Texture.prototype.hasData=function(){return null!=this.data};
JSC3D.Texture.prototype.generateMipmaps=function(){if(!(1>=this.width||null==this.data||null!=this.mipmaps)){this.mipmaps=[this.data];this.mipentries=[1];for(var a=1+~~(0.1+Math.log(this.width)*Math.LOG2E),b=this.width>>1,c=1;c<a;c++){for(var e=Array(b*b),d=this.mipmaps[c-1],f=b<<1,g=0,h=0,k=0;k<b;k++){for(var l=0;l<b;l++){var o=d[g],i=d[g+1],H=d[g+f],q=d[g+f+1];e[h]=(((o&4278190080)>>>2)+((i&4278190080)>>>2)+((H&4278190080)>>>2)+((q&4278190080)>>>2)&4278190080)+((o&16711680)+(i&16711680)+(H&16711680)+
(q&16711680)>>2&16711680)+((o&65280)+(i&65280)+(H&65280)+(q&65280)>>2&65280)+((o&255)+(i&255)+(H&255)+(q&255)>>2&255);g+=2;h++}g+=f}this.mipmaps.push(e);this.mipentries.push(Math.pow(4,c));b>>=1}}};JSC3D.Texture.prototype.hasMipmap=function(){return null!=this.mipmaps};JSC3D.Texture.prototype.name="";JSC3D.Texture.prototype.data=null;JSC3D.Texture.prototype.mipmaps=null;JSC3D.Texture.prototype.mipentries=null;JSC3D.Texture.prototype.width=0;JSC3D.Texture.prototype.height=0;
JSC3D.Texture.prototype.hasTransparency=!1;JSC3D.Texture.prototype.srcUrl="";JSC3D.Texture.prototype.onready=null;JSC3D.Texture.cv=null;JSC3D.AABB=function(){this.minZ=this.maxZ=this.minY=this.maxY=this.minX=this.maxX=0};JSC3D.AABB.prototype.center=function(){return[(this.minX+this.maxX)/2,(this.minY+this.maxY)/2,(this.minZ+this.maxZ)/2]};JSC3D.AABB.prototype.lengthOfDiagonal=function(){var a=this.maxX-this.minX,b=this.maxY-this.minY,c=this.maxZ-this.minZ;return Math.sqrt(a*a+b*b+c*c)};
JSC3D.Matrix3x4=function(){this.m00=1;this.m10=this.m03=this.m02=this.m01=0;this.m11=1;this.m21=this.m20=this.m13=this.m12=0;this.m22=1;this.m23=0};JSC3D.Matrix3x4.prototype.identity=function(){this.m00=1;this.m10=this.m03=this.m02=this.m01=0;this.m11=1;this.m21=this.m20=this.m13=this.m12=0;this.m22=1;this.m23=0};
JSC3D.Matrix3x4.prototype.scale=function(a,b,c){this.m00*=a;this.m01*=a;this.m02*=a;this.m03*=a;this.m10*=b;this.m11*=b;this.m12*=b;this.m13*=b;this.m20*=c;this.m21*=c;this.m22*=c;this.m23*=c};JSC3D.Matrix3x4.prototype.translate=function(a,b,c){this.m03+=a;this.m13+=b;this.m23+=c};
JSC3D.Matrix3x4.prototype.rotateAboutXAxis=function(a){if(0!=a){var a=a*(Math.PI/180),b=Math.cos(a),a=Math.sin(a),c=b*this.m11-a*this.m21,e=b*this.m12-a*this.m22,d=b*this.m13-a*this.m23,f=b*this.m20+a*this.m10,g=b*this.m21+a*this.m11,h=b*this.m22+a*this.m12,k=b*this.m23+a*this.m13;this.m10=b*this.m10-a*this.m20;this.m11=c;this.m12=e;this.m13=d;this.m20=f;this.m21=g;this.m22=h;this.m23=k}};
JSC3D.Matrix3x4.prototype.rotateAboutYAxis=function(a){if(0!=a){var a=a*(Math.PI/180),b=Math.cos(a),a=Math.sin(a),c=b*this.m01+a*this.m21,e=b*this.m02+a*this.m22,d=b*this.m03+a*this.m23,f=b*this.m20-a*this.m00,g=b*this.m21-a*this.m01,h=b*this.m22-a*this.m02,k=b*this.m23-a*this.m03;this.m00=b*this.m00+a*this.m20;this.m01=c;this.m02=e;this.m03=d;this.m20=f;this.m21=g;this.m22=h;this.m23=k}};
JSC3D.Matrix3x4.prototype.rotateAboutZAxis=function(a){if(0!=a){var a=a*(Math.PI/180),b=Math.cos(a),a=Math.sin(a),c=b*this.m10+a*this.m00,e=b*this.m11+a*this.m01,d=b*this.m12+a*this.m02,f=b*this.m13+a*this.m03,g=b*this.m01-a*this.m11,h=b*this.m02-a*this.m12,k=b*this.m03-a*this.m13;this.m00=b*this.m00-a*this.m10;this.m01=g;this.m02=h;this.m03=k;this.m10=c;this.m11=e;this.m12=d;this.m13=f}};
JSC3D.Matrix3x4.prototype.multiply=function(a){var b=a.m00*this.m01+a.m01*this.m11+a.m02*this.m21,c=a.m00*this.m02+a.m01*this.m12+a.m02*this.m22,e=a.m00*this.m03+a.m01*this.m13+a.m02*this.m23+a.m03,d=a.m10*this.m00+a.m11*this.m10+a.m12*this.m20,f=a.m10*this.m01+a.m11*this.m11+a.m12*this.m21,g=a.m10*this.m02+a.m11*this.m12+a.m12*this.m22,h=a.m10*this.m03+a.m11*this.m13+a.m12*this.m23+a.m13,k=a.m20*this.m00+a.m21*this.m10+a.m22*this.m20,l=a.m20*this.m01+a.m21*this.m11+a.m22*this.m21,o=a.m20*this.m02+
a.m21*this.m12+a.m22*this.m22,i=a.m20*this.m03+a.m21*this.m13+a.m22*this.m23+a.m23;this.m00=a.m00*this.m00+a.m01*this.m10+a.m02*this.m20;this.m01=b;this.m02=c;this.m03=e;this.m10=d;this.m11=f;this.m12=g;this.m13=h;this.m20=k;this.m21=l;this.m22=o;this.m23=i};
JSC3D.Math3D={transformVectors:function(a,b,c){for(var e=0;e<b.length;e+=3){var d=b[e],f=b[e+1],g=b[e+2];c[e]=a.m00*d+a.m01*f+a.m02*g+a.m03;c[e+1]=a.m10*d+a.m11*f+a.m12*g+a.m13;c[e+2]=a.m20*d+a.m21*f+a.m22*g+a.m23}},transformVectorZs:function(a,b,c){for(var e=b.length/3,d=0,f=0;d<e;)c[d]=a.m20*b[f]+a.m21*b[f+1]+a.m22*b[f+2]+a.m23,d++,f+=3}};JSC3D.BinaryStream=function(a,b){if(b)throw"JSC3D.BinaryStream constructor failed: Big endian is not supported yet!";this.data=a;this.offset=0};
JSC3D.BinaryStream.prototype.size=function(){return this.data.length};JSC3D.BinaryStream.prototype.tell=function(){return this.offset};JSC3D.BinaryStream.prototype.seek=function(a){if(0>a||a>=this.data.length)return!1;this.offset=a;return!0};JSC3D.BinaryStream.prototype.reset=function(){this.offset=0};JSC3D.BinaryStream.prototype.skip=function(a){this.offset=this.offset+a>this.data.length?this.data.length:this.offset+a};JSC3D.BinaryStream.prototype.available=function(){return this.data.length-this.offset};
JSC3D.BinaryStream.prototype.eof=function(){return!(this.offset<this.data.length)};JSC3D.BinaryStream.prototype.readUInt8=function(){return this.decodeInt(1,!1)};JSC3D.BinaryStream.prototype.readInt8=function(){return this.decodeInt(1,!0)};JSC3D.BinaryStream.prototype.readUInt16=function(){return this.decodeInt(2,!1)};JSC3D.BinaryStream.prototype.readInt16=function(){return this.decodeInt(2,!0)};JSC3D.BinaryStream.prototype.readUInt32=function(){return this.decodeInt(4,!1)};
JSC3D.BinaryStream.prototype.readInt32=function(){return this.decodeInt(4,!0)};JSC3D.BinaryStream.prototype.readFloat32=function(){return this.decodeFloat(4,23)};JSC3D.BinaryStream.prototype.readFloat64=function(){return this.decodeFloat(8,52)};JSC3D.BinaryStream.prototype.readBytes=function(a,b){var c=b;this.offset+b>this.data.length&&(c=this.data.length-this.offset);for(var e=0;e<c;e++)a[e]=this.data[this.offset++].charCodeAt(0)&255;return c};
JSC3D.BinaryStream.prototype.decodeInt=function(a,b){if(this.offset+a>this.data.length)return this.offset=this.data.length,NaN;for(var c=0,e=1,d=0;d<a;d++)c+=(this.data[this.offset++].charCodeAt(0)&255)*e,e*=256;b&&c&Math.pow(2,8*a-1)&&(c-=Math.pow(2,8*a));return c};
JSC3D.BinaryStream.prototype.decodeFloat=function(a,b){if(this.offset+a>this.data.length)return this.offset=this.data.length,NaN;for(var c=8*a-b-1,e=(1<<c)-1,d=e>>1,f=a-1,g=this.data[this.offset+f].charCodeAt(0)&255,f=f+-1,h=-7,k=g&(1<<-h)-1,g=g>>-h,h=h+c;0<h;)k=256*k+(this.data[this.offset+f].charCodeAt(0)&255),f+=-1,h-=8;c=k&(1<<-h)-1;k>>=-h;for(h+=b;0<h;)c=256*c+(this.data[this.offset+f].charCodeAt(0)&255),f+=-1,h-=8;this.offset+=a;switch(k){case 0:k=1-d;break;case e:return c?NaN:Infinity*(g?-1:
1);default:c+=Math.pow(2,b),k-=d}return(g?-1:1)*c*Math.pow(2,k-b)};JSC3D.LoaderSelector={registerLoader:function(a,b){"function"==typeof b&&(JSC3D.LoaderSelector.loaderTable[a]=b)},getLoader:function(a){a=JSC3D.LoaderSelector.loaderTable[a.toLowerCase()];if(!a)return null;var b;try{b=new a}catch(c){b=null}return b},loaderTable:{}};
JSC3D.ObjLoader=function(a,b,c,e){this.onload=a&&"function"==typeof a?a:null;this.onerror=b&&"function"==typeof b?b:null;this.onprogress=c&&"function"==typeof c?c:null;this.onresource=e&&"function"==typeof e?e:null;this.requestCount=0;this.mtlLibUrl="";this.setMtlLibUrl=function(a){this.mtlLibUrl=a}};
JSC3D.ObjLoader.prototype.loadFromUrl=function(a){var b="",c=a,e=a.lastIndexOf("/");-1==e&&(e=a.lastIndexOf("\\"));-1!=e&&(b=a.substring(0,e+1),c=a.substring(e+1));this.requestCount=0;this.loadObjFile(b,c)};
JSC3D.ObjLoader.prototype.loadObjFile=function(a,b){var c=a+b,e=this,d=new XMLHttpRequest,c=c.replace(".obj","");d.open("POST",c,!0);d.onreadystatechange=function(){if(4==this.readyState)if(200==this.status||0==this.status){if(e.onload){if(e.onprogress)e.onprogress("Loading obj file ...",1);JSC3D.console&&JSC3D.console.logInfo('Finished loading obj file "'+c+'".');var a=new JSC3D.Scene,b=e.parseObj(a,this.responseText);0<b.length&&e.mtlLibUrl&&e.loadMtlFile(a,e.mtlLibUrl,b[0]);if(0==--e.requestCount)e.onload(a)}}else JSC3D.console&&
JSC3D.console.logError('Failed to load obj file "'+c+'".'),e.onerror&&(e.requestCount--,e.onerror('Failed to load obj file "'+c+'".'))};this.onprogress&&(this.onprogress("Loading obj file ...",0),d.onprogress=function(a){e.onprogress("Loading obj file ...",a.position/a.totalSize)});this.requestCount++;d.send()};
JSC3D.ObjLoader.prototype.loadMtlFile=function(a,b,c){var e=this,d=new XMLHttpRequest;d.open("POST",b,!0);d.onreadystatechange=function(){if(4==this.readyState){if(200==this.status||0==this.status){if(e.onprogress)e.onprogress("Loading mtl file ...",1);JSC3D.console&&JSC3D.console.logInfo('Finished loading mtl file "'+b+'".');for(var d=e.parseMtl(this.responseText),g={},h=a.getChildren(),k=0;k<h.length;k++){var l=h[k];if(null!=l.mtl&&null!=l.mtllib&&l.mtllib==c){var o=d[l.mtl];null!=o&&(null!=o.material&&
l.setMaterial(o.material),""!=o.textureFileName&&(g[o.textureFileName]?g[o.textureFileName].push(l):g[o.textureFileName]=[l]))}}for(var i in g)e.setupTexture(g[i],b+i)}else JSC3D.console&&JSC3D.console.logWarning('Failed to load mtl file "'+b+'". A default material will be applied.');if(0==--e.requestCount)e.onload(a)}};this.onprogress&&(this.onprogress("Loading mtl file ...",0),d.onprogress=function(a){e.onprogress("Loading mtl file ...",a.position/a.totalSize)});this.requestCount++;d.send()};
JSC3D.ObjLoader.prototype.parseObj=function(a,b){var c={},e=[],d=0,f=null,g="",h="",k=[],l=[],o="obj-"+d++,i=new JSC3D.Mesh;i.name=o;i.indexBuffer=[];for(var f=c.nomtl=i,H=b.split("\n"),o=0;o<H.length;o++)if(h=H[o].split(/[ \t]+/),0<h.length)switch(h[0]){case "v":if(3<h.length)for(var q=1;4>q;q++)k.push(parseFloat(h[q]));break;case "vt":2<h.length&&(l.push(parseFloat(h[1])),l.push(1-parseFloat(h[2])));break;case "f":if(3<h.length){for(q=1;q<h.length;q++){var I=h[q].split("/");f.indexBuffer.push(parseInt(I[0])-
1);1<I.length&&""!=I[1]&&(f.texCoordIndexBuffer||(f.texCoordIndexBuffer=[]),f.texCoordIndexBuffer.push(parseInt(I[1])-1))}f.indexBuffer.push(-1);f.texCoordIndexBuffer&&f.texCoordIndexBuffer.push(-1)}break;case "mtllib":1<h.length?(g=h[1],e.push(g)):g="";break;case "usemtl":1<h.length&&""!=h[1]&&""!=g?(h=h[1],q=g+"-"+h,f=c[q],f||(f=new JSC3D.Mesh,f.name="obj-"+d++,f.indexBuffer=[],f.mtllib=g,f.mtl=h,c[q]=f)):f=i}var d=3<=k.length?Array(k.length/3):null,g=2<=l.length?Array(l.length/2):null,v;for(v in c){f=
c[v];if(3<=k.length&&0<f.indexBuffer.length){for(o=0;o<d.length;o++)d[o]=-1;f.vertexBuffer=[];for(o=H=i=0;o<f.indexBuffer.length;o++)i=f.indexBuffer[o],-1!=i&&(-1==d[i]?(h=3*i,f.vertexBuffer.push(k[h]),f.vertexBuffer.push(k[h+1]),f.vertexBuffer.push(k[h+2]),f.indexBuffer[o]=H,d[i]=H,H++):f.indexBuffer[o]=d[i])}if(2<=l.length&&null!=f.texCoordIndexBuffer&&0<f.texCoordIndexBuffer.length){for(o=0;o<g.length;o++)g[o]=-1;f.texCoordBuffer=[];for(o=H=i=0;o<f.texCoordIndexBuffer.length;o++)i=f.texCoordIndexBuffer[o],
-1!=i&&(-1==g[i]?(h=2*i,f.texCoordBuffer.push(l[h]),f.texCoordBuffer.push(l[h+1]),f.texCoordIndexBuffer[o]=H,g[i]=H,H++):f.texCoordIndexBuffer[o]=g[i])}f.isTrivial()||a.addChild(f)}return e};
JSC3D.ObjLoader.prototype.parseMtl=function(a){for(var b={},c="",a=a.split("\n"),e=0;e<a.length;e++){var d=a[e].split(/[ \t]+/);if(0<d.length)switch(d[0]){case "newmtl":c=d[1];d={};d.material=new JSC3D.Material;d.textureFileName="";b[c]=d;break;case "Kd":if(4==d.length&&!isNaN(d[1])){var f=255*parseFloat(d[1])&255,g=255*parseFloat(d[2])&255,h=255*parseFloat(d[3])&255,d=b[c];null!=d&&(d.material.diffuseColor=f<<16|g<<8|h)}break;case "d":2==d.length&&!isNaN(d[1])&&(f=parseFloat(d[1]),d=b[c],null!=d&&
(d.material.transparency=1-f));break;case "map_Kd":2==d.length&&(f=d[1],d=b[c],null!=d&&(d.textureFileName=f))}}return b};JSC3D.ObjLoader.prototype.setupTexture=function(a,b){var c=this,e=new JSC3D.Texture;e.onready=function(){for(var b=0;b<a.length;b++)a[b].setTexture(this);if(c.onresource)c.onresource(this)};e.createFromUrl(b)};JSC3D.ObjLoader.prototype.onload=null;JSC3D.ObjLoader.prototype.onerror=null;JSC3D.ObjLoader.prototype.onprogress=null;JSC3D.ObjLoader.prototype.onresource=null;
JSC3D.ObjLoader.prototype.requestCount=0;JSC3D.LoaderSelector.registerLoader("obj",JSC3D.ObjLoader);JSC3D.StlLoader=function(a,b,c,e){this.onload=a&&"function"==typeof a?a:null;this.onerror=b&&"function"==typeof b?b:null;this.onprogress=c&&"function"==typeof c?c:null;this.onresource=e&&"function"==typeof e?e:null;this.decimalPrecision=3};
JSC3D.StlLoader.prototype.loadFromUrl=function(a){var b=this,c=new XMLHttpRequest;c.open("GET",a,!0);c.overrideMimeType("text/plain; charset=x-user-defined");c.onreadystatechange=function(){if(4==this.readyState)if(200==this.status||0==this.status){if(JSC3D.console&&JSC3D.console.logInfo('Finished loading STL file "'+a+'".'),b.onload){if(b.onprogress)b.onprogress("Loading STL file ...",1);var c=new JSC3D.Scene;b.parseStl(c,this.responseText);b.onload(c)}}else if(JSC3D.console&&JSC3D.console.logError('Failed to load STL file "'+
a+'".'),b.onerror)b.onerror('Failed to load STL file "'+a+'".')};this.onprogress&&(this.onprogress("Loading STL file ...",0),c.onprogress=function(a){b.onprogress("Loading STL file ...",a.position/a.totalSize)});c.send()};JSC3D.StlLoader.prototype.setDecimalPrecision=function(a){this.decimalPrecision=a};
JSC3D.StlLoader.prototype.parseStl=function(a,b){var c=new JSC3D.Mesh;c.vertexBuffer=[];c.indexBuffer=[];c.faceNormalBuffer=[];var e=!1,d=new JSC3D.BinaryStream(b);d.skip(84);for(var f=0;256>f&&!d.eof();f++)if(127<d.readUInt8()){e=!0;break}JSC3D.console&&JSC3D.console.logInfo("This is recognised as "+(e?"a binary":"an ASCII")+" STL file.");if(e){d.reset();d.skip(80);h=d.readUInt32();if(d.size()<84+50*h){JSC3D.console&&JSC3D.console.logError("Failed to parse contents of the file. It seems not complete.");
return}c.faceCount=h;e={};for(f=0;f<h;f++){c.faceNormalBuffer.push(d.readFloat32());c.faceNormalBuffer.push(d.readFloat32());c.faceNormalBuffer.push(d.readFloat32());for(var g=0;3>g;g++)k=d.readFloat32(),l=d.readFloat32(),o=d.readFloat32(),i=k.toFixed(this.decimalPrecision)+"-"+l.toFixed(this.decimalPrecision)+"-"+o.toFixed(this.decimalPrecision),H=e[i],void 0==H&&(H=c.vertexBuffer.length/3,e[i]=H,c.vertexBuffer.push(k),c.vertexBuffer.push(l),c.vertexBuffer.push(o)),c.indexBuffer.push(H);c.indexBuffer.push(-1);
d.skip(2)}}else if(d=RegExp("facet\\s+normal\\s+([-+]?\\b(?:[0-9]*\\.)?[0-9]+(?:[eE][-+]?[0-9]+)?\\b)\\s+([-+]?\\b(?:[0-9]*\\.)?[0-9]+(?:[eE][-+]?[0-9]+)?\\b)\\s+([-+]?\\b(?:[0-9]*\\.)?[0-9]+(?:[eE][-+]?[0-9]+)?\\b)\\s+outer\\s+loop\\s+vertex\\s+([-+]?\\b(?:[0-9]*\\.)?[0-9]+(?:[eE][-+]?[0-9]+)?\\b)\\s+([-+]?\\b(?:[0-9]*\\.)?[0-9]+(?:[eE][-+]?[0-9]+)?\\b)\\s+([-+]?\\b(?:[0-9]*\\.)?[0-9]+(?:[eE][-+]?[0-9]+)?\\b)\\s+vertex\\s+([-+]?\\b(?:[0-9]*\\.)?[0-9]+(?:[eE][-+]?[0-9]+)?\\b)\\s+([-+]?\\b(?:[0-9]*\\.)?[0-9]+(?:[eE][-+]?[0-9]+)?\\b)\\s+([-+]?\\b(?:[0-9]*\\.)?[0-9]+(?:[eE][-+]?[0-9]+)?\\b)\\s+vertex\\s+([-+]?\\b(?:[0-9]*\\.)?[0-9]+(?:[eE][-+]?[0-9]+)?\\b)\\s+([-+]?\\b(?:[0-9]*\\.)?[0-9]+(?:[eE][-+]?[0-9]+)?\\b)\\s+([-+]?\\b(?:[0-9]*\\.)?[0-9]+(?:[eE][-+]?[0-9]+)?\\b)\\s+endloop\\s+endfacet",
"ig"),f=b.match(d)){var h=f.length;c.faceCount=h;e={};d.lastIndex=0;d.global=!1;for(h=d.exec(b);null!=h;h=d.exec(b)){c.faceNormalBuffer.push(parseFloat(h[1]),parseFloat(h[2]),parseFloat(h[3]));for(f=0;3>f;f++){var k=parseFloat(h[4+3*f]),l=parseFloat(h[5+3*f]),o=parseFloat(h[6+3*f]),i=k.toFixed(this.decimalPrecision)+"-"+l.toFixed(this.decimalPrecision)+"-"+o.toFixed(this.decimalPrecision),H=e[i];void 0===H&&(H=c.vertexBuffer.length/3,e[i]=H,c.vertexBuffer.push(k),c.vertexBuffer.push(l),c.vertexBuffer.push(o));
c.indexBuffer.push(H)}c.indexBuffer.push(-1)}}c.isTrivial()||a.addChild(c)};JSC3D.StlLoader.prototype.onload=null;JSC3D.StlLoader.prototype.onerror=null;JSC3D.StlLoader.prototype.onprogress=null;JSC3D.StlLoader.prototype.onresource=null;JSC3D.StlLoader.prototype.decimalPrecision=3;JSC3D.LoaderSelector.registerLoader("stl",JSC3D.StlLoader);
