/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* global THREE */

var epsilon=1E-15;
var ccursor="default";

function changecursor(nc) {
    
     if (nc!==ccursor){
        document.body.style.cursor = nc;
        ccursor=nc;
     }
       
    
}
function getepsilon(){
    return epsilon;
}


 function iszero(n){
            return Math.abs(n)<epsilon;
        }
    
    function toggle(x) {
    
    if (x.style.display === "none") {
        x.style.display = "block";
    } else {
        x.style.display = "none";
    }
}
function showelement(x) {
    
     
        x.style.display = "block";
   
       
    
}
function hideelement(x) {
    
    
        x.style.display = "none";
   
       
    
}

function getelement(st) {
		return document.getElementById(st);
	}
   function scaleelement(el,wi,hi)     {
       
       var st='scale(' + wi+','+hi + ')';
el.style.transform = st;
el.style['-o-transform'] = st;
el.style['-webkit-transform'] = st;
el.style['-moz-transform'] = st;
   }
   
   /// usefull for vector length
    function todecimal(n, digits) {
        return n.toFixed(digits);
    }

    function toround(n) {
        return Math.round(n);
    }

    function sign(x) {
        if (x > 0) return 1;
        if (x < 0) return -1;
        return 0;
    }

    function toint(x) {
        return parseInt(x);
    }

    function tofloat(str) {
        return parseFloat(str);
    }

    function rgb(r, g, b) {
        return ("rgb(" + r.toString() + "," + g.toString() + "," + b.toString() + ")");
    }

    function rgba(r, g, b, a) {
        return ("rgba(" + r.toString() + "," + g.toString() + "," + b.toString() + "," + a.toString() + ")");
    }

    function concat() {
        var st = "";
        for (var i = 0; i < arguments.length; i++) {
            st += " " + arguments[i];
        }
        return st;
    };
    //// dom elements support
    function getattr(el, str) {
        return el.getAttribute(str);
    }

    function setattr(el, str) {
        el.setAttribute(str);
    }
    /// string for id comma sep childs
    function appendchilds() {
        var el = getelement(arguments[0]);
        for (var i = 1; i < arguments.length; i++) {
            el.appendChild(arguments[i]);
        }
    }

    function setbackimage(el, str) {
        el.style.backgroundImage = "url(" + str + ")";
    }

    function setbackcolor(el, str) {
        el.style.backgroundColor = str;
    }

    function setelementpos(d, x_pos, y_pos) {
        d.style.position = "absolute";
        d.style.left = x_pos + 'px';
        d.style.top = y_pos + 'px';
    }
    /////----------------- global functions 
    
    //////  3 d    g e o m e t r y /////////////////////////////////////////////////
    function arrow() {
        //var dir = new THREE.Vector3(0, 0, 1);
        //normalize the direction vector (convert to vector of length 1)
        //dir.normalize();
        var origin = new THREE.Vector3(0, 0, 0);
        var length = 1;
        return new THREE.Arrow(0, 0, 1, origin, length, 0x336633, 0.08, 0.04, 0.01);
    }

    function sphere(radius, s1, s2, mat) {
        var geometry = new THREE.SphereBufferGeometry(radius, s1, s2);
        return new THREE.Mesh(geometry, mat);
    }

    function box(x1, y1, z1, mat) {
        var geometry = new THREE.BoxGeometry(x1, y1, z1);
        return new THREE.Mesh(geometry, mat);
    }

    function cylinder(segments, mat) {
        var geometry = new THREE.CylinderBufferGeometry(1, 1, 1, segments);
        geometry.translate(0, +0.5, 0);
        return new THREE.Mesh(geometry, mat);
    }

    function line(mat) {
        var geometry = new THREE.Geometry();
        geometry.vertices.push(new THREE.Vector3(0, 0, 0));
        geometry.vertices.push(new THREE.Vector3(1, 0, 0));
        return new THREE.Line(geometry, mat);
    }

    function lineupdate(aline) {
        aline.geometry.verticesNeedUpdate = true;
        if (aline.material.isLineDashedMaterial) {
            aline.computeLineDistances();
            aline.geometry.lineDistancesNeedUpdate = true;
        }
    }
 
    function lineset(aline, x1, y1, z1, x2, y2, z2) {
        aline.geometry.vertices[0].set(x1, y1, z1);
        aline.geometry.vertices[1].set(x2, y2, z2);
        lineupdate(aline)
    }

    function linestart(aline, x1, y1, z1) {
        aline.geometry.vertices[0].set(x1, y1, z1);
        lineupdate(aline)
    }

    function lineend(aline, x1, y1, z1) {
        aline.geometry.vertices[1].set(x1, y1, z1);
        lineupdate(aline)
    }

    function ngon(radius, num, mat) {
        var geometry = new THREE.Geometry();
        for (var i = 0; i <= num; i++) {
            var th = i * 2.0 * Math.PI / num;
            var x = radius * Math.cos(th);
            var y = radius * Math.sin(th);
            geometry.vertices.push(new THREE.Vector3(x, y, 0));
        }
        return new THREE.Line(geometry, mat);
    }

    function helix(radius, num, turns, mat) {
        var geometry = new THREE.Geometry();
        for (var i = 0; i <= num * turns; i++) {
            var th = i * 2.0 * Math.PI / num;
            var x = radius * Math.cos(th);
            var y = radius * Math.sin(th);
            geometry.vertices.push(new THREE.Vector3(x, y, 1 * i / turns / num));
        }
        return new THREE.Line(geometry, mat);
    }

    function concat() {
        var st = "";
        for (var i = 0; i < arguments.length; i++) {
            st += " " + arguments[i];
        }
        return st;
    };
    
      ///////////---------drawing functions -------------------------
    function strokestyle(ctx, stst) {
         ctx.strokeStyle = stst;
    }
    function fillstyle(ctx, fst) {
         ctx.fillStyle = fst;
    }
    // if one parameter both stroke and fill same 
    function styles(ctx, stst, fst) {
         ctx.strokeStyle = stst;
         ctx.fillStyle =  stst;
         ctx.fillStyle = fst ||stst;
    }
   
     function linewidth(ctx, lw) {
        ctx.lineWidth=lw;
    }
    function drawroundrect(ctx, x, y, width, height, radius, filled, strokestyle, fillstyle) {
        // filled =0 only line 1 only fill 2 both
        ctx.beginPath();
         
        if (strokestyle) ctx.strokeStyle = strokestyle;
        if (fillstyle) ctx.fillStyle = fillstyle;
        ctx.moveTo(x, y + radius);
        ctx.lineTo(x, y + height - radius);
        ctx.arcTo(x, y + height, x + radius, y + height, radius);
        ctx.lineTo(x + width - radius, y + height);
        ctx.arcTo(x + width, y + height, x + width, y + height - radius, radius);
        ctx.lineTo(x + width, y + radius);
        ctx.arcTo(x + width, y, x + width - radius, y, radius);
        ctx.lineTo(x + radius, y);
        ctx.arcTo(x, y, x, y + radius, radius);
        ctx.closePath();
        if (filled === 0 || filled === 2) ctx.stroke();
        if (filled === 1 || filled === 2) ctx.fill();
    }

    function settransform(ctx, tr) {
        ctx.setTransform(tr.m[0], tr.m[1], tr.m[2], tr.m[3], tr.m[4], tr.m[5]);
    }

    function drawline(ctx, x1, y1, x2, y2, linestyle) {
         if (linestyle) ctx.strokeStyle = linestyle;
        ctx.beginPath();
       
        ctx.moveTo(x1, y1);
        ctx.lineTo(x2, y2);
        ctx.stroke();
    }

    function drawpolar(ctx, x, y, r, thrad, linestyle) {
        ctx.beginPath();
        if (linestyle) ctx.strokeStyle = linestyle;
        ctx.moveTo(x, y);
        ctx.lineTo(x + r * Math.cos(thrad), y + r * Math.sin(thrad));
        ctx.stroke();
    }

    function drawvector(ctx, x1, y1, x2, y2, linestyle) {
        var thrad = Math.atan2(y2 - y1, x2 - x1);
        //var r=Math.hypot(y2-y1,x2-x1);
        var r = Math.sqrt((y2 - y1) * (y2 - y1) + (x2 - x1) * (x2 - x1));
        drawpolar(ctx, x1, y1, r, thrad, linestyle);
        drawpolar(ctx, x2, y2, 16, thrad +  Math.PI * 0.8, linestyle);
        drawpolar(ctx, x2, y2, 44, thrad - Math.PI * 0.8, "yellow");
    }

    function drawvectorpolar(ctx, x, y, r, thrad, linestyle) {
        drawvector(ctx, x, y, x + r * Math.cos(thrad), y + r * Math.sin(thrad), linestyle);
    }

    function drawrect(ctx, x1, y1, w, h, filled) {
        ctx.beginPath();
        //if (linestyle) ctx.strokeStyle = linestyle;
        ctx.rect(x1, y1, w, h);
         if (filled===1 || filled===2) ctx.fill();
       if (filled===0 || filled===2) ctx.stroke();
        //ctx.stroke();
    }

   

    function drawarcfilled(ctx, xo, yo, r, st, en, anticlock, linestyle) {
        ctx.beginPath();
        ctx.moveTo(xo, yo);
        if (linestyle) ctx.fillStyle = linestyle;
        ctx.arc(xo, yo, r, st, en, anticlock);
        ctx.fill();
    }
    ///////////////////////new 
    
    
 function drawarc(ctx, xo, yo, r, st, en, anticlock, closed,filled) {
        ctx.beginPath();
        //if (linestyle) ctx.strokeStyle = linestyle;
        ctx.arc(xo, yo, r, st, en, anticlock);
        //ctx.stroke();
         if (closed) ctx.closePath();
        if (filled===1 || filled===2) ctx.fill();
       if (filled===0 || filled===2) ctx.stroke();
        
    }
    function drawcircle(ctx, xo, yo, r) {
        drawarc(ctx, xo, yo, r, 0, 2*Math.PI, false,false, 0,1);
    }

    function drawcirclefilled(ctx, xo, yo, r, linestyle) {
        drawarcfilled(ctx, xo, yo, r, 0, 2*Math.PI, false, linestyle);
    }
    // fill text centered at x y 
    function drawtext(ctx,text,x,y,size,centerleft){
          ctx.font = size + "px Helvetica";
          ctx.textAlign = "center";
          if (centerleft) ctx.textAlign = "left";
         
        ctx.textBaseline = "middle";
       
        ctx.fillText(text,x,y);   
    }
    // draw polygon p [x,y,x,y]
    //filled =0 stroke 1 filled 2 str & filled
    //percent 
    function drawpolygon(ctx, p,filled,closed,percent) {
         var filled=filled||0;
         var closed=closed||0;
         var percent=percent||1.0;
         
       ctx.beginPath();
        ctx.moveTo(p[0], p[1]);
        var i;
        for (i=1;i<percent*p.length/2;i++){
        ctx.lineTo(p[i*2], p[i*2+1]);
        }
        if (closed) ctx.closePath();
        if (filled===1 || filled===2) ctx.fill();
       if (filled===0 || filled===2) ctx.stroke();
    }
    function drawarrow(ctx, x,y,len,th,arh,d,filled) {
        if (len<0.01) return;
        //var arh=appw/50;
       // var d=arh/3;
        var ars=len-arh;
        var d2=2*d;
        if (ars<0) ars=0;
        tr=new Transform();
        p=[];
       
        tr.translate(x,y);
        tr.rotate(th);
        
        
        p.push(0,0, 0,d, ars,d, ars,d+d2, len,0, ars,-d-d2, ars,-d ,0,-d, 0,0);
        p=tr.transformPolygon(p);
        drawpolygon(ctx,p,filled); 
    }
    // center xo yo , half len
 function drawdistance(ctx, x,y,len,th,arh,d,filled) {
      drawarrow(ctx, x,y,len,th,arh,d,filled);
      drawarrow(ctx, x,y,len,th+Math.PI,arh,d,filled);
    }