
/* global Curve, Chart, Graph, THREE */

// app hlf
// agelis dimitrios 2018 all rights reserved


"use strict";



var evn = 0;///user events

function loadgltf(frm, str) {



    var loader = new THREE.GLTFLoader();

// Optional: Provide a DRACOLoader instance to decode compressed mesh data
//THREE.DRACOLoader.setDecoderPath( '/examples/js/libs/draco' );
//loader.setDRACOLoader( new THREE.DRACOLoader() );

// Load a glTF resource

    loader.load(
            // resource URL'models/gltf/duck/duck.gltf'
            str,
            // called when the resource is loaded
                    function (gltf) {
                        alert(str)
                        ///frm.scene.add(gltf.scene);

                        gltf.animations; // Array<THREE.AnimationClip>
                        var object = gltf.scene; // THREE.Scene
                        gltf.scenes; // Array<THREE.Scene>
                        gltf.cameras; // Array<THREE.Camera>
                        gltf.asset; // Object
                        ////// 
                        var animations = gltf.animations;

                        if (animations && animations.length) {

                            frm.mixer = new THREE.AnimationMixer(object);

                            for (var i = 0; i < animations.length; i++) {

                                var animation = animations[ i ];

                                animation.duration = 233;//sceneInfo.animationTime

                                var action = frm.mixer.clipAction(animation);


                                action.play();

                            }

                        }

                        frm.scene.add(object);





                    },
                    // called while loading is progressing
                            function (xhr) {

                                console.log((xhr.loaded / xhr.total * 100) + '% loaded');

                            },
                            // called when loading has errors
                                    function (error) {
                                        alert("gltfe error")
                                        //console.log( 'An error happened' );

                                    }
                            );

                        }

                function click() {

                    alert("click");


                }
                function clickdown(event) {

                    alert(event.target.id);


                }

                function clickhelp() {

                    hideelement(getelement("help"));


                }
                setbackcolor(getelement("body"), "black");
                var gf = new GF();
                var sm = gf.getmanager();

                var ttcolor = "pink";

                var appw = sm.width;
                var apph = sm.height;
                var logw = appw;
                var logh = apph;
                sm.adddebug();/// here because form


                sm.dwin.drawoutline = true;
                sm.dwin.x = 800;

                sm.setbackcolor(0, 0, 0);
                sm.drawbackground = false;//true; /// dont draw background if have a 2d or 3d app
// resources 

                var scene0 = sm.createscene();      ///  0



                scene0.userevent = function (e, type) {
                    evn++;
                    if (type === "MU") {

                    }
                    //info.title=concat(e.target,evn);
                }




////  app 
                var appname = "    Βαρυτικό Πεδίο της Γής"

                var helptext = "Διάλεξε την απόσταση από τη γή. # Σύρε την πέτρα σε διάφορα σημεία για να δείς το βάρος της και την ένταση του πεδίου της βαρύτητας. # Το πεδίο βαρύτητας κοντά στην επιφάνεια της γης θεωρείται ομογενές # Η κλίμακα απεικόνισης της πέτρας δεν είναι πραγματική"

                var gui = scene0.addform(0, "", 0, 0, appw, apph);

                gui.drawbackground = false;
                gui.pickable = false;


                var form0 = gui.addform("form0", "", 0, 48, appw, apph - 48);
                //var form0 = gui.addform("form0", "", 0, 48, 640, 700);
                //form0.draggable = true;
                //var f3d = form0.addform3d(0, "", 1100, 600, 180, 20);

                ////           loadgltf(f3d,'models/gltftest/testgltf.gltf')
/////////////   arrow x, y, len, th, arh, d, filled

////----------------------------------------------------------------
                var G = 6.67e-11;
                var Re = 6371000;
                var Me = 5.97e24;
                var x0, y0, xr, yr, dist;
                var dist0;
                var state = 0;
                var vec = {min: 64, max: 12, value: 32, dmin: 1, dmax: 11, dvalue: 5}
                var veclen = 64;
                function getg(h) {
                    return G * Me / (Re + h) / (Re + h);
                }

                var field = form0.addshape(0, "", 0, 0, appw, apph);

                field.userdraw = function (ctx) {

                    if (state === 0)
                        drawfl(field);

                }
                var field2 = form0.addshape(0, "", 0, 0, appw, apph);

                field2.userdraw = function (ctx) {

                    if (state === 1)
                        drawfl2(field2);

                }
                var earth = form0.addshape(0, "", form0.width / 2 - 64, form0.height / 2 - 64, 128, 128, sm.createimage("images/earth.png"));
                earth.visible = false;
                var ground = form0.addshape(0, "", 0, form0.height - 32, appw, 32);

                ground.userdraw = function (ctx) {

                    var grd = ground.lineargrad(0, 0, 0, 64);
                    grd.addColorStop(0, "white");
                    grd.addColorStop(1, "green");
                    styles(ctx, grd, grd);

                    ground.drawrect(0, 0, appw, 32, 1);//ground
                    ground.drawimageto(tree1, 8, -40);
                    ground.drawimageto(tree2, appw - 90, -50);

                }
                var ch1d = 220;
                var ch1 = form0.addcheck(0, "", appw - ch1d, 0, ch1d, 300);
                ch1.corner = 4;
                //ch1.draggable=true;

                ch1.addlistitem(0, "κατακόρυφο", 0, 8 + 1 * 32, 120, 32);
                ch1.addlistitem(0, "δυναμικές γραμμές", 0, 8 + 2 * 32, 120, 32);
                ch1.addlistitem(0, "Βάρος ", 0, 8 + 3 * 32, 120, 32);
                ch1.addlistitem(0, "g = w/m", 0, 8 + 4 * 32, 120, 32);
                ch1.addlabel(0, "Εμφάνισε:", 8, 8, ch1d - 16, 32);

                var list = ch1.addlist(0, "", 8, 6 * 32, ch1d - 16, 32);
                ch1.addlabel(0, "διάλεξε ύψος:", 8, 6 * 32, ch1d - 16, 32);
                list.addlistitem(0, "μικρό ύψος", 0, 8 + 1 * 32, ch1d - 16, 32)
                list.addlistitem(0, "μεγάλο ύψος", 0, 8 + 2 * 32, ch1d - 16, 32)
                list.selectitem(0);

                list.onclick = function () {
                    state = list.selindex;
                    ground.visible = (state === 0);
                    earth.visible = (state === 1);
                    if (state === 1) {
                        form0.backcolor = "black";
                    } else {
                        form0.backcolor = "cyan";
                    }
                }
                var tree1 = sm.createimage("images/tree1.png");
                var tree2 = sm.createimage("images/tree2.png");
                var rock = form0.addform(0, "", 300, 300, 48, 48, sm.createimage("images/pebble.png"));

                rock.limit(0, 0, appw - 50, apph - 104);
                rock.draggable = true;
                rock.drawbackground = false;
                function drawfl(frm) {
                    if (!ch1.childs[1].checked)
                        return;
                    var ni = 10;
                    var i;
                    var de = frm.width / (ni - 1) - 16;
                    var xi = 8;
                    styles(frm.ctx, "blue");
                    for (i = 0; i <= ni; i++) {

                        frm.drawvector(xi, 0, xi, frm.height / 2);
                        frm.drawline(xi, frm.height / 2, xi, frm.height);
                        xi += de;
                    }
                }


                function drawfl2(frm) {
                    if (!ch1.childs[1].checked)
                        return;
                    var ni = 12;
                    var i;
                    var de = 2 * Math.PI / (ni);
                    var th = 0;
                    var r1 = 300;
                    var r2 = apph;
                    x0 = earth.x + 64;
                    y0 = earth.y + 64;
                    styles(frm.ctx, "blue");
                    for (i = 0; i < ni; i++) {
                        frm.drawpolar(x0, y0, appw, th)
                        frm.drawpolarvector(x0 + r1 * Math.cos(th), y0 + r1 * Math.sin(th), 4, th + Math.PI)
                        th += de;
                    }
                }




                rock.userdraw = function (ctx) {
                    var rdx = 24;
                    var rdy = 24;
                    if (state === 0) {
                        styles(ctx, "black", "blue");
                        rock.dash([5, 5]);
                        if (ch1.childs[0].checked)
                            form0.drawpolar(rock.x + rdx, apph - 80, apph - 80, -Math.PI / 2);  /// katak
                        rock.dash([]);
                        if (ch1.childs[3].checked)
                            rock.drawarrow(rdx, rdy, 64, Math.PI / 2, 20, 5, 2);// g
                        styles(ctx, "red", "red");
                        if (ch1.childs[2].checked)
                            rock.drawarrow(rdx, rdy, 80, Math.PI / 2, 10, 2.5, 2);//ww
                    }
                    var nr = dist / 64;
                    var h = (nr - 1) * Re;
                    if (state === 0) {
                        h = dist0;
                        nr = (h + Re) / Re;
                    }
                    var ge = getg(h);
                    if (ge > 9.83)
                        ge = 9.83;
                    var rdist = todecimal(nr, 3);
                    var hdec = todecimal(h, 1);
                    vec.dvalue = nr;
                    veclen = getvalue(vec);
                    styles(ctx, "white");
                    if (state === 0)
                        styles(ctx, "blue");
                    //form0.drawtext(rdist, 10, 30, 20, true);
                    form0.drawtext("g=" + todecimal(ge, 2) + "m/s²", 10, 80, 20, true);

                    if (state === 0)
                        form0.drawtext("h=" + hdec + "m", 10, 50, 20, true);
                    if (state === 1) {
                        form0.drawtext("h=" + todecimal(Math.round(h / 100000) * 100, 0) + "Km", 10, 50, 20, true);
                        //form0.drawtext("h="+rdist+" Re", 10, 110, 20, true);
                    }
                    form0.drawtext("w=mg", 10, 110, 20, true);

                    if (state === 1) {
                        styles(ctx, "white")
                        rock.dash([5, 5]);
                        if (ch1.childs[0].checked)
                            form0.drawpolar(x0, y0, apph, Math.atan2(-y0 + yr, -x0 + xr)); //// katak2
                        rock.dash([]);
                        styles(ctx, "black", "blue");
                        //form0.drawarrow(xr, yr, 60 * ge / 9.81, Math.atan2(y0 - yr, x0 - xr), 20, 5, 2);// g2
                        if (veclen > 64)
                            veclen = 64;
                        if (ch1.childs[3].checked)
                            form0.drawarrow(xr, yr, veclen, Math.atan2(y0 - yr, x0 - xr), 20, 5, 2);// g2
                        styles(ctx, "red", "red");
                        if (ch1.childs[2].checked)
                            form0.drawarrow(xr, yr, veclen * 1.2, Math.atan2(y0 - yr, x0 - xr), 10, 2.5, 2);// g2

                    }
                }

                form0.userdraw = function (ctx) {

                    //styles(ctx, "red", "red");
                    //drawfl(form0);
                    ///  
                    var rdx = 24;
                    var rdy = 24;
                    x0 = earth.x + 64;
                    y0 = earth.y + 64;
                    xr = rock.x + rdx;
                    yr = rock.y + rdy;

                    dist0 = (ground.y - yr) / 10;
                    dist = Math.sqrt((x0 - xr) * (x0 - xr) + (y0 - yr) * (y0 - yr));
                    if (dist < 64 && state === 1) {
                        var th = Math.atan2(yr - y0, xr - x0);
                        xr = x0 + 64 * Math.cos(th);
                        yr = y0 + 64 * Math.sin(th);
                        rock.x = xr - rdx;
                        rock.y = yr - rdy;
                        dist = 64;
                    }
                    if (state === 0)
                        dist = dist0 + Re;

                }

                function bodyload() {
                }





                var label2 = gui.addlabel(0, appname, 0, 0, appw, 48);
                label2.backcolor = "orange";

                label2.textcentered = false;//
/////   predefined temps




//-----------------------------------------------------

                var btnabout = label2.addbutton(0, "", appw - 48, 0, 48, 48, sm.getimageres("about"));
                btnabout.drawbackground = false;
                btnabout.drawoutline = false;

                var btnhelp = label2.addbutton(0, "", appw - 100, 0, 48, 48, sm.getimageres("help"));
                btnhelp.drawbackground = false;
                btnhelp.drawoutline = false;
                var sceneabout = sm.adddialog(512, 360, sm.createimage("images/about.png"), 0);/// scene 1

                btnabout.onclick = function () {
                    window.open('index_DS_II.html');
                    //formabout.visible = !false;
                }
                btnhelp.onclick = function () {
                    formhelp.visible = !formhelp.visible;//false;
                    
                }


                //var formhelp = gui.addform(0, "about", 0, 0, 574, 149, sm.createimage("images/help.png"));
                var formhelp = gui.addform(0, "", 0, 0, 660, 200);
                formhelp.backcolor = "lightgreen"
                formhelp.userdraw = function (ctx) {
                    //function wraptext(ctx, text, x, y, maxWidth, lineHeight) {
                    wraptext(formhelp.ctx, helptext, formhelp.xg + 8, formhelp.yg + 28, formhelp.width - 55, 24)
                }
                var formabout = gui.addform(0, "about", 0, 0, logw, logh, sm.createimage("images/about error.png"));
                formhelp.visible = false;
                formhelp.center();
                formabout.visible = false;
                formabout.backcolor = "white";
                var bc1 = formhelp.addbutton(0, "", formhelp.width - 56, 0, 48, 48, sm.getimageres("close"));
                bc1.drawoutline = false;
                var bc2 = formabout.addbutton(0, "", logw - 56, 0, 48, 48, sm.getimageres("close"));
                bc1.drawoutline = false;
                bc1.onclick = function () {
                    formhelp.visible = false;
                }
                bc2.onclick = function () {
                    formabout.visible = false;
                }
                bc1.drawbackground = false;
                bc1.drawoutline = false;
                bc2.drawbackground = false;
                bc2.drawoutline = false;

                var scenehelp = sm.createscene(); ///1 
                var sceneabout = sm.createscene(); ///2
                scenehelp.addchild(formhelp);
                sceneabout.addchild(formabout);
//// end help about 


                gf.start();





